-----------------------------------------------------------------------------
--  This module stores the CMU dictionary information, which describes the
--  word to phoneme definitions.
--  (Factorio restricts loading external files so it's stored in this module
--  instead, there is probably a better method to accomplish this)
-----------------------------------------------------------------------------
local cmuDict = {}

cmuDict.cmuTable = {SHOUMAKER="SH UW M EY K ER",EFFICIENCY="IH F IH SH AH N S IY",VANDALIZE="V AE N D AH L AY Z",PLEBEIANS="P L AH B IY AH N Z",RISSE="R IH S",MOSTAERT="M AH S T EY R T",RAGONE="R AA G OW N IY",JUMBOS="JH AH M B OW Z",OZIER="OW Z IY ER",RAINIEST="R EY N IY AH S T",["LABELING(2)"]="L EY B L IH NG",TUCKEY="T AH K IY",MALDEN="M AO L D AH N",GAWEN="G AO AH N",MUCKEY="M AH K IY",LUCKEY="L AH K IY",FANGUY="F AH NG G W IY",WALDEN="W AO L D AH N",UNDERCLASSMEN="AH N D ER K L AE S M EH N",BUCKEY="B AH K IY",FRIEDA="F R IY D AH",SPLASH="S P L AE SH",["CROSS-POLLINATE"]="K R AO S P AA L AH N EY T",ROSSE="R AA S",SELKIN="S EH L K IH N",POSSE="P AA S IY",STIER="S T AY ER",A="AH",C="S IY",B="B IY",E="IY",D="D IY",G="JH IY",F="EH F",I="AY",H="EY CH",K="K EY",J="JH EY",M="EH M",["SOPRANO(2)"]="S AH P R AE N OW",O="OW",N="EH N",Q="K Y UW",P="P IY",S="EH S",R="AA R",U="Y UW",SUPERVISORS="S UW P ER V AY Z ER Z",W="D AH B AH L Y UW",LEASEBACK="L IY S B AE K",Y="W AY",X="EH K S",LATULIPPE="L AA T UW L IY P IY",WETTEST="W EH T AH S T",LAJEUNE="L AH JH AH N",WOEHLER="W OW L ER",ARGENTINIAN="AA R JH AH N T IH N IY AH N",INVADED="IH N V EY D AH D",TELESCIENCES="T EH L AH S AY AH N S IH Z",PAWNEE="P AO N IY",POEHLER="P OW L ER",CRISTIANO="K R IY S T IY AA N OW",KOEHLER="K OW L ER",LIVELIEST="L AY V L IY AH S T",BOEHLER="B OW L ER",AWACS="EY W AE K S",MISOGYNIST="M IH Z AH JH IH N IH S T",["ANXIOUS(2)"]="AE NG SH AH S",["CHOPPER'S"]="CH AA P ER Z",WEINGARTNER="W AY NG G AA R T N ER",BELKIN="B EH L K IH N",["SCOTTY'S"]="S K AA T IY Z",DANCED="D AE N S T",SLUMPED="S L AH M P T",PLUMPED="P L AH M P T",TROSTEL="T R AA S T AH L",["SUNWORLD'S"]="S AH N W ER L D Z",WELLIVER="W EH L IH V ER",YEMENIDJIAN="Y EH M AH N IH JH IY AH N",SWIER="S W AY ER",["BAKKER(2)"]="B EY K ER",ATTERBERRY="AE T ER B EH R IY",TADROS="T EY D R OW Z",STUFFY="S T AH F IY",["HEINZ'S"]="HH AY N Z IH Z",FATTEST="F AE T AH S T",GAFFNEY="G AE F N IY",SALKIN="S AE L K IH N",TALKIN="T AA K AH N",BACHAILIAN="B AH K EY L IY AH N",SPIER="S P AY ER",NYDEGGER="N AY D IH G ER",MALKIN="M AE L K IH N",MORRALL="M AO R AA L",HORTICULTURE="HH AO R T IH K AH L CH ER",POPOVICH="P AA P AH V IH CH",["KHRUSHCHEV(2)"]="K R UW S CH AO F",SHRAMEK="SH R AE M IH K",DISREGARDING="D IH S R IH G AA R D IH NG",SHIGEKUNI="SH IY G IH K UW N IY",["MISREPRESENTING(2)"]="M IH S R EH P R AH Z EH N IH NG",PRIMACK="P R IH M AH K",CHURCHGOERS="CH ER CH G OW ER Z",["NEVADA(2)"]="N AH V AE D AH",EURASIA="Y UH R EY ZH AH",CHUSE="CH Y UW Z",EVANGELISTIC="IY V AE N JH AH L IH S T IH K",ATROPHIES="AE T R AH F IY Z",["GREITZ(2)"]="G R AY T S",SCHOENFELD="SH OW N F EH L D",SOCIA="S OW CH AH",FIGONE="F IH G AH N",CROSTON="K R AA S T AH N",ELABORATE="IH L AE B R AH T",LOBBYIST="L AA B IY AH S T",PRIER="P R AY ER",TRIER="T R AY ER",LABORATORIES="L AE B R AH T AO R IY Z",SLATTON="S L AE T AH N",BLAIZE="B L EY Z",HOBBYIST="HH AA B IY IH S T",KINBURN="K IH N B ER N",["PALME(2)"]="P AA L M",BABYSITTER="B EY B IY S IH T ER",ROACHE="R OW CH",MERCIES="M ER S IY Z",HILDEN="HH AY L D AH N",WINBURN="W IH N B ER N",OBSERVABLES="AH B Z ER V AH B AH L Z",COLORADAN="K AA L ER AA D AH N",TILDEN="T IH L D AH N",WILDEN="W AY L D AH N",MIERZEJEWSKI="M IH R Z EY EH F S K IY",STAMAND="S T AE M AH N D",CHEESES="CH IY Z IH Z",GOFFNEY="G AA F N IY",POLYCAST="P AA L IY K AE S T",MUEHLER="M Y UW L ER",BARSKY="B AA R S K IY",DIETZLER="D IY T S L ER",BENGALI="B EH NG G AA L IY",RADIOLOGISTS="R EY D IY AA L AH JH IH S T S",PLIER="P L AY ER",DEFAMATION="D EH F AH M EY SH AH N",BUEHLER="B Y UW L ER",TOENAIL="T OW N EY L",KUEHLER="K UH L ER",DEDUCTIBLES="D IH D AH K T AH B AH L Z",LEVELLED="L EH V AH L D",SCHOEPF="SH OW P",RAMIREZ="R AH M IH R EH Z",CRIER="K R AY ER",DRIER="D R AY ER",BEVELLED="B EH V AH L D",FRIER="F R AY ER",GRIER="G R AY ER",ABREGO="AA B R EH G OW",SWIRSKY="S W ER S K IY",BOSNIAN="B AA Z N IY AH N",APLOMB="AH P L AA M",PARSKY="P AA R S K IY",UNQUESTIONABLY="AH N K W EH S CH AH N AH B L IY",TOYOBO="T OW Y OW B OW",BALASH="B AE L AH SH",RESENDEZ="R EY S EY N D EH Z",HERBICIDES="ER B AH S AY D Z",FERRALL="F EH R AH L",UNCOUPLE="AH N K AH P AH L",STEPMOTHER="S T EH P M AH DH ER",LEMUR="L IY M ER",DUNCANSON="D AH NG K AH N S AH N",HAMPSTEAD="HH AE M P S T EH D",PISTOLS="P IH S T AH L Z",METEOR="M IY T IY ER",OKWU="AO K W UW",BOSSE="B AA S",["VASBINDER(2)"]="V AE S B AY N D ER",GOSSE="G AA S",FOSSE="F AA S",HUEBNER="HH Y UW B N ER",VUKOVICH="V Y UW K AH V IH CH",["RESCINDS(2)"]="R IY S IH N D Z",["MISSPEND(2)"]="M IH S P EH N D",KLIER="K L AY ER",SELDEN="S EH L D AH N",CEPHAS="S EH F AH Z",WESOLEK="W EH S AH L IH K",FLIER="F L AY ER",MICROCODE="M AY K R OW K OW D",PALASH="P AH L AE SH",WELDEN="W EH L D AH N",FATHERLESS="F AA DH ER L AH S",QUADREX="K W AA D R EH K S",MOUNTAINEER="M AW N T IH N IH R",GREBNER="G R EH B N ER",THIER="TH IY ER",SHIER="SH AY ER",MCCLELLAND="M AH K L EH L AH N D",KWASNIEWSKI="K W AH Z N EH F S K IY",SCHUERMAN="SH UW ER M AH N",DILEONARDO="D IH L IY AH N AA R D OW",BOECKMAN="B OW K M AH N",EXECUTOR="IH G Z EH K Y AH T ER",HARASSING="HH ER AE S IH NG",LEAKEY="L IY K IY",["MODELS'"]="M AA D AH L Z",GOLOMB="G AA L AH M",DEMUR="D IH M ER",LIABILITIES="L AY AH B IH L AH T IY Z",FEMUR="F IY M ER",SCHAFF="SH AE F",STAPLES="S T EY P AH L Z",MYRLIE="M IH R L IY",RAYCHEM="R EY K EH M",MATHIASON="M AH TH AY AH S AH N",CAPILLARY="K AE P AH L EH R IY",VAGRANTS="V EY G R AH N T S",DISLIKE="D IH S L AY K",JOBLESSNESS="JH AA B L AH S N AH S",ALSTHOM="AE L S TH AH M",JUNGLES="JH AH NG G AH L Z",UNDERPANTS="AH N D ER P AE N T S",["EARMARKS(2)"]="IY R M AA R K S",["BLOOMINGDALE'S"]="B L UW M IH NG D EY L Z",STEBNER="S T EH B N ER",INDECISIVENESS="IH N D EH S IH S IH V N AH S",ROZEN="R AA Z AH N",CONSOLIDATING="K AH N S AA L AH D EY T IH NG",LEJEUNE="L EH Y OY N",SUDDENLY="S AH D AH N L IY",TIMUR="T IH M ER",HONCHO="HH AO N CH OW",ELEKTRON="IH L EH K T R AA N",PONCHO="P AA N CH OW",SOPHISTICATED="S AH F IH S T AH K EY T IH D",JAFFA="JH AE F AH",DISMISSIVE="D IH S M IH S IH V",CONISTON="K AA N AH S T AH N",YEAKEY="Y IY K IY",BAFFA="B AE F AH",STRENIO="S T R IY N IY OW",["MCCONATHY(2)"]="M AE K AH N AE TH IY",MCALOON="M AE K AH L UW N",KERCHNER="K ER K N ER",AEROJET="EH R OW JH EH T",EXCOMMUNICATED="EH K S K AH M Y UW N AH K EY T AH D",SURF="S ER F",TURF="T ER F",SPECTATOR="S P EH K T EY T ER",FEDERICO="F EH D ER IY K OW",RAFFA="R AE F AH",KARYDAKIS="K EH R IY D AE K IH S",BULLIES="B UH L IY Z",ANNISTON="AE N IH S T IH N",["CYNICALLY(2)"]="S IH N IH K L IY",GLEESON="G L IY Z AH N",["JUDGES'"]="JH AH JH IH Z",ARTIFICIAL="AA R T AH F IH SH AH L",PRIVATIZING="P R AY V AH T AY Z IH NG",NARCOTIC="N AA R K AA T IH K",GIRSKY="G ER S K IY",ZINNIAS="Z IH N IY AH Z",PENISTON="P EH N IH S T AA N",["GREAT-CIRCLE"]="G R EY T S ER K AH L",RELISHES="R EH L IH SH AH Z",NEVALA="N EY V AA L AH",RAILCAR="R EY L K AA R",ADULATION="AE JH AH L EY SH AH N",HOAGY="HH OW G IY",COPPINGER="K AA P IH NG ER",VANILLI="V AH N IH L IY",DENISTON="D EH N IH S T AA N",MARKAIR="M AA R K EH R",BRIGHTBILL="B R AY T B IH L",RHETORIC="R EH T ER IH K",FOREBODING="F AO R B OW D IH NG",WINBUSH="W IH N B UH SH",RAMMING="R AE M IH NG",["MAZDA(2)"]="M AE Z D AH",STARKEL="S T AA R K AH L",MCDONNELL="M AH K D AA N AH L",TARBELL="T AA R B EH L",DAMMING="D AE M IH NG",OVULATION="OW V Y AH L EY SH AH N",ADSTEAM="AE D S T IY M",["DEEPENING(2)"]="D IY P N IH NG",["INTRODUCTORY(2)"]="IH N T R OW D AH K T ER IY",TIFFANY="T IH F AH N IY",ALBERICO="AA L B ER IY K OW",ELEVENTH="IH L EH V AH N TH",COMEDIC="K AH M IY D IH K",SCHEPIS="SH EH P IH S",DAGESTAN="D AE G EH S T AE N",["LANTING'S"]="L AE N T IH NG Z",KIRCHNER="K ER K N ER",BELLAMY="B EH L AH M IY",TANGO="T AE NG G OW",CIRCUMVENTED="S ER K AH M V EH N T IH D",["POSNER(2)"]="P AO Z N ER",MYLOD="M AY L AA D",MCNEIL="M AH K N IY L",RITTERBUSCH="R IH T ER B UH SH",PERSKY="P ER S K IY",BARBELL="B AA R B EH L",MAJER="M EY JH ER",PINGPONG="P IH NG P AO NG",STANWAY="S T AE N W EY",INTERFERON="IH N T ER F EH R AA N",REAPPRAISAL="R IY AH P R EY Z AH L",WINFREY="W IH N F R IY",UNEXPLODED="AH N IH K S P L OW D IH D",JANIERO="JH AH N EH R OW",CORREA="K AO R IY AH",BOWLBY="B OW L B IY",BYGONE="B AY G AO N",SEIXAS="S IY K S AH S",GREESON="G R IY S AH N",BESECKER="B EH S IH K ER",SKULLS="S K AH L Z",CASSOCK="K AE S AH K",CAUSE="K AA Z",CLEANSED="K L EH N Z D",SUBLEASING="S AH B L IY S IH NG",CALKIN="K AE L K IH N",["ALITALIA(2)"]="AE L IH T AE L IY AH",CONCANNON="K AH N K AE N AH N",CRIVELLO="K R IH V EH L OW",IMPLIES="IH M P L AY Z",["MINORITY(2)"]="M AH N AO R AH T IY",CHOPRA="CH AA P R AH",ALLYS="AE L AY Z",YAROSH="Y AE R AH SH",KERRIDGE="K EH R IH JH",COLORISTIC="K AH L ER IH S T IH K",HEASLIP="HH IY S L IH P",ATTARDO="AA T AA R D OW",UTILIZATION="Y UW T AH L AH Z EY SH AH N",MANGO="M AE NG G OW",["INTERVENTIONISM(2)"]="IH N ER V EH N CH AH N IH Z AH M",LANGO="L AA NG G OW",DANGO="D AE NG G OW",BANGO="B AA NG G OW",LASSETER="L AE S IY T ER",RESIDING="R IH Z AY D IH NG",KURYLO="K ER IH L OW",MIZEN="M AY Z AH N",WIZEN="W AY Z AH N",EMULATION="EH M Y AH L EY SH AH N",JERGENS="JH ER G AH N Z",BOROSKI="B ER AW S K IY",POLYGON="P AA L IH G AA N",MEUSE="M Y UW Z",DIAPHRAGM="D AY AH F R AE M",STATIN="S T EY T IH N",RADHA="R AA D AH",PIECHOWSKI="P IY HH AO F S K IY",SWEDEN="S W IY D AH N",SECESSIONIST="S IH S EH SH AH N IH S T",["PANELS'"]="P AE N AH L Z",VUNCANNON="V AH N K AH N AA N",["UNCRITICALLY(2)"]="AH N K R IH T IH K L IY",ECCENTRICITY="EH K S AH N T R IH S AH T IY",DUTIFUL="D UW T IY F AH L",PELICAN="P EH L AH K AH N",MAFIA="M AA F IY AH",MELICAN="M EH L IH K AH N",SNITCHING="S N IH CH IH NG",WOLFMAN="W UH L F M AH N",FAIRLAWN="F EH R L AO N",GORSKY="G AO R S K IY",RECUPERATE="R IH K UW P ER EY T",DOLLIVER="D AA L IH V ER",WINCED="W IH N S T",MINCED="M IH N S T",HAZEN="HH EY Z AH N",["PATHS(2)"]="P AE TH S",["OATHS(2)"]="OW TH S",DEALMAKERS="D IY L M EY K ER Z",POLLYANNA="P AA L IY AE N AH",BANGALOR="B AE NG G AH L AO R",REFORMS="R AH F AO R M Z",ISSAC="IH S AH K",PLEOMORPHIC="P L IY AH M AO F IH K",MADDUX="M AE D AH K S",GOLFMAN="G AA L F M AH N",HEEBNER="HH IY B N ER",["ARENELLA'S"]="AA R AH N EH L AH Z",RAPAPORT="R AE P AH P AO R T",EXTENDED="IH K S T EH N D AH D",THROWAWAY="TH R OW AH W EY",COIFFE="K OY F",FLUFFY="F L AH F IY",TIPSTER="T IH P S T ER",STATISTICIAN="S T AE T AH S T IH SH AH N",HAUSE="HH AW S",GAUSE="G AO Z",VAUSE="V AO S",SAUSE="S AO Z",SOSEBEE="S AA S IH B IY",PAUSE="P AO Z",BUECHEL="B Y UW K AH L",FINCANNON="F IH N K AH N AA N",["RECEIVED(3)"]="R IY S IY V D",HURRIEDLY="HH ER IY D L IY",KINCANNON="K IH N K AE N AH N",ATTACK="AH T AE K",["SEPARATELY(2)"]="S EH P R AH T L IY",PERTSCHUK="P ER CH AH K",CYNTHIE="S IH N TH IY",["SYNERGEN'S"]="S IH N ER JH EH N Z",VILLAGOMEZ="V IY L AA G OW M EH Z",VARIETY="V ER AY AH T IY",LACOVARA="L AA K OW V AA R AH",FLICKINGER="F L IH K IH NG ER",WANNABE="W AA N AH B IY",["SWITCHES(2)"]="S W IH CH IH Z",LITHIUM="L IH TH IY AH M",FENCED="F EH N S T",PRECEEDING="P R IH S IY D IH NG",DEVITA="D IH V IY T AH",VANDERWEELE="V AE N D ER W IY L",MCFARLAND="M AH K F AA R L AH N D",["CIRCUMSTANTIALLY(2)"]="S ER K AH M S T AE N SH AH L IY",INTERESTED="IH N T R AH S T AH D",["KOTSONIS'(2)"]="K OW T S OW N AH S",PIGNATARO="P IY G N AA T AA R OW",PETREA="P EH T R IY AH",["THINK'S"]="TH IH NG K S",TOXIN="T AA K S AH N",DIRECTIONLESS="D ER EH K SH AH N L AH S",SEAGOING="S IY G OW IH NG",["GATEWAY'S"]="G EY T W EY Z",TEMKIN="T EH M K IH N",KINDERGARTEN="K IH N D ER G AA R T AH N",ELASTOMERS="IH L AE S T AH M ER Z",CONSUMES="K AH N S UW M Z",MOLINARO="M OW L IY N AA R OW",HEDGECOCK="HH EH JH K AA K",SATIRISTS="S AE T ER AH S T S",TRUNDLED="T R AH N D AH L D",WAVRA="W AA V R AH",VAVRA="V AE V R AH",FEINERMAN="F AY N ER M AH N",TREIBER="T R AY B ER",PORRIDGE="P AO R AH JH",QUAGLIA="K W AE G L IY AH",["CARTEL'S"]="K AA R T EH L Z",KASPUTYS="K AE S P Y UW T IH S",AOSHIMA="AW SH IY M AH",["POGROMS(2)"]="P OW G R AH M Z",POOHED="P UW D",DOBBIN="D AA B IH N",BOBBIN="B AA B AH N",QUIZZING="K W IH Z IH NG",PROCRASTINATED="P R AH K R AE S T AH N EY T AH D",BOISSEAU="B W AA S OW",HILDEGARDE="HH IH L D IH G AA R D",SYMBOLISTS="S IH M B AH L AH S T S",GOETHALS="G OW TH AH L Z",ROBBIN="R AA B IH N",FURBISHED="F ER B IH SH T",OHASHI="OW HH AA SH IY",["AISLES(2)"]="AY AH L Z",PIECED="P IY S T",RODEBAUGH="R AA D IH B AO",MAGNETI="M AE G N EH T IY",DUOPOLY="D UW OW P AA L IY",WEEDEN="W IY D AH N",HOVATER="HH OW V AH T ER",COCKERELL="K AA K ER EH L",WANGERIN="W AO NG G ER IH N",BUFFA="B AH F AH",DURABLES="D UH R AH B AH L Z",ZAPF="Z AE P F",["MARKS'S"]="M AA R K S IH Z",TAWNEY="T AO N IY",GRASSMAN="G R AE S M AH N",TETLEY="T EH T L IY",CASCIATO="K AA S CH AA T OW",LIBERTE="L IH B ER T EY",LOUGHREY="L AW R IY",["ICE-CREAM"]="AY S K R IY M",ALBATROSS="AE L B AH T R AA S",BLANKENHORN="B L AE NG K IH N HH ER N",DUNLEVY="D UW N L IH V IY",KONICKI="K AH N IH T S K IY",DORFMAN="D AO R F M AH N",BRYEN="B R AY AH N",["FRANKE(2)"]="F R AE NG K IY",APACS="EY P AE K S",WEIDEMAN="W AY D M AH N",CLASSMAN="K L AE S M AH N",RESILIENCE="R IH Z IH L IY AH N S",GRASTY="G R AE S T IY",GROCE="G R OW S",MCILWAIN="M AE K IH L W EY N",SPITTLER="S P IH T L ER",CLEETON="K L IY T AH N",PROSPERED="P R AA S P ER D",TURBOS="T ER B OW Z",HELFMAN="HH EH L F M AH N",HEMMING="HH EH M IH NG",HENRIE="HH EH N ER IY",LEMMING="L EH M IH NG",PREDICATES="P R EH D AH K EY T S",CROCE="K R OW CH IY",BROCE="B R OW S",FORMULATING="F AO R M Y AH L EY T IH NG",ALVITA="AA L V IY T AH",MERCANTILISM="M ER K AE N T AH L IH Z AH M",DECIBELS="D EH S AH B AH L Z",STERILIZERS="S T EH R AH L AY Z ER Z",KEAGY="K IY JH IY",DISABLES="D IH S EY B AH L Z",CLOSURES="K L OW ZH ER Z",VEMPALA="V EH M P AA L AH",MAGNAVOX="M AE G N AH V AA K S",BURRIDGE="B AO R IH JH",MISREPRESENTATIONS="M IH S R EH P R IH Z EH N T EY SH AH N Z",["TRAVELER(2)"]="T R AE V L ER",WIEDEN="W IY D AH N",CAULEY="K AO L IY",["SWEETENER(2)"]="S W IY T N ER",["D'OEUVRES"]="D ER V Z",["VIOLETT(2)"]="V AY L AH T",STARTLE="S T AA R T AH L",SINGLES="S IH NG G AH L Z",UNDERSTAFF="AH N D ER S T AE F",JURGENS="JH ER G AH N Z",RAJIV="R AA JH IY V",DISTANCING="D IH S T AH N S IH NG",["CRUELTY(2)"]="K R UW AH L T IY",VALIANT="V AE L Y AH N T",GINGLES="JH IH NG G AH L Z",ALCANTAR="AE L K AE N T ER",BALCERZAK="B AH L CH ER Z AH K",THORLEY="TH AO R L IY",["LIGHTHOUSES(2)"]="L AY T HH AW Z AH Z",ASTOUNDS="AH S T AW N D Z",PENNIMAN="P EH N IH M AH N",["CHRIBONIKO'S"]="CH R IY B OW N IY K OW Z",PERFETTI="P ER F EH T IY",RESTORATION="R EH S T ER EY SH AH N",STAHLBERG="S T AA L B ER G",HIGBEE="HH IH G B IY",["UHDE(2)"]="UW D AH",INTERFACE="IH N T ER F EY S",SCHULTE="SH AH L T",MATCHLOCKS="M AE CH L AA K S",WHORLEY="HH AO R L IY",FIERSTEIN="F IY R S T IY N",VIGNETTES="V IH N Y EH T S",DIMMING="D IH M IH NG",ANTOSH="AH N T AA SH",KAZAKHS="K AE Z AE K S",BIGBEE="B IH G B IY",FRIEDRICH="F R IY D R IH K",BOGDANSKI="B AH G D AE N S K IY",OVERLOOKS="OW V ER L UH K S",DAMBROSIO="D AE M B R OW S IY OW",PRESSURIZES="P R EH SH ER AY Z IH Z",OCCURRENCES="AH K ER AH N S IH Z",DISCONNECTS="D IH S K AH N EH K T S",GUMPP="G AH M P",LUMPP="L AH M P",BRIDESBURG="B R AY D Z B AH R G",KAMPALA="K AH M P AA L AH",WIPF="W IH P F",ZIPF="Z IH P F",ANACHRONISM="AH N AE K R AH N IH Z AH M",EPIDURAL="EH P AH D ER AH L",SLECHTA="S L EH CH T AH",UNIMPRESSED="AH N IH M P R EH S T",ACHESON="AE CH AH S AH N",BRUXELLES="B R AH K S EH L AH S",FRITZSCHE="F R IH T Z SH",["ROWLAND'S"]="R OW L AH N D Z",PAULEY="P AO L IY",["REFUSE(3)"]="R IH F Y UW Z",SULTANS="S AH L T AH N Z",OVERBEY="OW V ER B IY",RELIANT="R IH L AY AH N T",WELCOMING="W EH L K AH M IH NG",HAMSTER="HH AE M S T ER",SIEMSEN="S IY M S AH N",PICKERELL="P IH K ER AH L",["KAREN'S"]="K EH R AH N Z",TREINEN="T R AY N AH N",JUNOD="JH UW N AH D",CONCEALMENT="K AH N S IY L M AH N T",WESTPORT="W EH S T P AO R T",CLIPPARD="K L IH P ER D",LITWILLER="L IH T W IH L ER",BAYONETS="B EY AH N EH T S",PALPITATED="P AE L P AH T EY T AH D",GERBINO="JH ER B IY N OW",DOWNEY="D AW N IY",FAVALE="F AA V AA L IY",SUCHAN="S AH CH AH N",VERSTRAETE="V ER S T R EH T",FEYEN="F AY N",URBANCZYK="ER B AH N CH IH K",HEYEN="HH AY N",ROWNEY="R OW N IY",SCARIER="S K EH R IY ER",HEILMANN="HH AY L M AH N",LOWNEY="L OW N IY",MICHIGAN="M IH SH IH G AH N",VIRGILIO="V ER JH IH L IY OW",LINCOLNS="L IH NG K AH N Z",LUCHSINGER="L AH K S IH N JH ER",CHIAVETTA="K IY AA V EH T AH",SHREDS="SH R EH D Z",PARABLES="P EH R AH B AH L Z",CARTOON="K AA R T UW N",IDYLL="AY D AH L",["ANGELS'"]="EY N JH AH L Z",TANGLES="T AE NG G AH L Z",BAGDASARIAN="B AE G D AH S EH R IY AH N",DISPARAGE="D IH S P EH R IH JH",CHABOT="SH AH B OW",DIAMAGNETIC="D AY AH M AE G N EH T IH K",DANGLES="D AE NG G AH L Z",SUPERSECRET="S UW P ER S IY K R IH T",LITVAK="L IH T V AH K",CARNEGIES="K AA R N AH G IY Z",CHRISTA="K R IH S T AH",STANLINE="S T AE N L AY N",FUKUI="F UW K UW IY",LYDIA="L IH D IY AH",TERTIARY="T ER SH ER IY",COLBURN="K OW L B ER N",DIVIDING="D IH V AY D IH NG",["DIFFICULTIES(2)"]="D IH F IH K AH L T IY Z",COLLOID="K AA L OY D",GRUBAUGH="G R AH B AO",CRUSADING="K R UW S EY D IH NG",NYDIA="N IH D IY AH",WYNGAARDEN="W IH N G AA R D AH N",BUCHAN="B AH K AH N",SKEPTICISM="S K EH P T IH S IH Z AH M",BRAMHALL="B R AE M HH AH L",OTTLEY="AA T L IY",STONEWALL="S T OW N W AO L",TERRORS="T EH R ER Z",ALMYS="AE L M IY Z",RIGHTNESS="R AY T N AH S",EXCOMMUNICATION="EH K S K AH M Y UW N AH K EY SH AH N",RUSSE="R AH S",NUTLEY="N AH T L IY",BRICCO="B R IH K OW",SZCZEPANIAK="SH IH P AE N IY AE K",BAUBLES="B AO B AH L Z",SUTLEY="S AH T L IY",REDEYE="R EH D AY",RUTLEY="R AH T L IY",OUTLEY="AW T L IY",THERMAL="TH ER M AH L",EMMYS="EH M IY Z",["PREFERENCED(2)"]="P R EH F R AH N S T",PORTANOVA="P AO R T AA N OW V AH",MATRIARCH="M EY T R IY AA R K",PATRIARCH="P EY T R IY AA R K",SCHWOERER="SH W OW ER ER",SCHAACK="SH AA K",["UDVERHYE'S(2)"]="Y UW D V EH R HH IY Z",SARBANE="S AA R B EY N",UNENTHUSIASTIC="AH N IH N TH UW Z IY AE S T IH K",CAFTANS="K AE F T AE N Z",SCHWARTZKOPF="SH W AO R T S K AO P F",OCEANEERING="OW SH AH N IH R IH NG",PERMIAM="P ER M AY AH M",PLAYBOOK="P L EY B UH K",DEBUNKS="D IH B AH NG K S",BONASERA="B OW N AA S EH R AH",KAZIN="K EY Z IH N",NOBUAKI="N OW B UW AA K IY",RADEBAUGH="R AE D IH B AO",BOELKOW="B OW L K AW",BELIVEAU="B EH L IH V OW",STAMPFLI="S T AE M P F L IY",UNDIPLOMATIC="AH N D IH P L AH M AE T IH K",BRITTLER="B R IH T L ER",TEMPESTA="T EH M P EH S T AH",HERBERS="HH ER B ER Z",KRUTICK="K R UW T IH K",BOULEY="B UW L IY",LAMPP="L AE M P",DETACH="D IH T AE CH",["TANTALIZED(2)"]="T AE N AH L AY Z D",BLACKLOCK="B L AE K L AA K",ANYWHERE="EH N IY W EH R",PYRAMIDS="P IH R AH M IH D Z",HILLENBURG="HH IH L AH N B ER G",MOTHERLESS="M AH DH ER L IH S",GENTRIFY="JH EH N T R IH F AY",SCHADLER="SH EY D AH L ER",FLOORBOARD="F L AO R B AO R D",UNCONCERN="AH N K AH N S ER N",SARAWAK="S EH R AH W AA K",SNOWSHOE="S N OW SH UW",STUPOR="S T UW P ER",CHITWOOD="CH IH T W UH D",["HORS-D-OEUVRE"]="AO R D ER V",CALLOUSNESS="K AE L AH S N AH S",WHIZZING="W IH Z IH NG",KOCHAN="K AA K AH N",INSTITUTIONALIZE="IH N S T IH T UW SH AH N AH L AY Z",MURJANI="M ER JH AA N IY",GOSORNSTEM="G AH S AO R N S T EH M",SOMERSAULTS="S AH M ER S AO L T S",["LEGIONNAIRE'S"]="L IY JH AH N EH R Z",KARATSU="K ER AE T S UW",OVERESTIMATE="OW V ER EH S T AH M EY T",HEIMBERGER="HH AY M B ER G ER",EMPTY="EH M P T IY",MUGNIYAH="M AH G N IH Y AH",DACIA="D EY SH IY AH",GONDOLAS="G AA N D AH L AH Z",["FLATTENING(2)"]="F L AE T N IH NG",STROHMEIER="S T R OW M AY ER",["BROKEN-WIND"]="B R OW K AH N W IH N D",FORERO="F AO R OW",["INSULATED(2)"]="IH N S AH L EY T IH D",GOODNER="G UH D N ER",GWIZDALA="G W IH Z D AA L AH",TADPOLES="T AE D P OW L Z",MUSICALS="M Y UW Z IH K AH L Z",UNSETTLING="AH N S EH T AH L IH NG",["GRIDLEY'S"]="G R IH D L IY Z",GARBERS="G AA R B ER Z",DESTINATIONS="D EH S T AH N EY SH AH N Z",BARBERS="B AA R B ER Z",AKBASH="AE K B AE SH",DETLEFSEN="D EH T L IH F S AH N",DETOXIFICATION="D IH T AA K S IH F IH K EY SH AH N",STRIFES="S T R AY F S",["NYCUM(2)"]="N AY K AH M",HAYEN="HH EY AH N",RYEN="R AY AH N",SORCERERS="S AO R S ER ER Z",ALEKSANDER="AE L AH K S AE N D ER",OYEN="OY IH N",MISHAP="M IH S HH AE P",DISORDERLY="D IH S AO R D ER L IY",SHOOTERS="SH UW T ER Z",["WHEREWITHAL(2)"]="HH W EH R W IH DH AO L",INHIBITING="IH N HH IH B AH T IH NG",KLEIBER="K L AY B ER",VANDROSS="V AE N D R AO S",GLOTFELTY="G L AA T F IH L T IY",ANGLERS="AE NG G L ER Z",["HUGHETT(2)"]="Y UW IH T",["SEE-KIONG"]="S IY K Y AO NG",OVERFLOWING="OW V ER F L OW IH NG",OPULENCE="AA P Y AH L AH N S",JOVITA="Y AH V AY T AH",QUESTIONERS="K W EH S CH AH N ER Z",HEIDRICK="HH AY D R IH K",SHEDLOCK="SH EH D L AA K",ARABICA="ER AE B IH K AH",["ABBEY'S"]="AE B IY Z",WESTBROOK="W EH S T B R UH K",KOCHENDORFER="K AA K IH N D AO R F ER",PROFFIT="P R AA F IH T",BOURRET="B UH R EH T",UNSUSTAINABLY="AH N S AH S T EY N AH B L IY",CAMILLI="K AH M IH L IY",["THIEVES'"]="TH IY V Z",MOFFA="M AA F AH",AIRSTRIPS="EH R S T R IH P S",TECHNOLOGIST="T EH K N AA L AH JH IH S T",HOFFA="HH AO F AH",SAPHIRA="S AA F IH R AH",CRITERIA="K R AY T IH R IY AH",BOFFA="B AA F AH",BRINKMANN="B R IH NG K M AH N",["FUSELAGE(2)"]="F Y UW S AH L IH JH",["SABOTEURS(2)"]="S AE B IH T AO R Z",GALSWORTHY="G AE L Z W ER DH IY",WESLEY="W EH S L IY",STAPLER="S T EY P AH L ER",HENGST="HH EH NG G S T",TONALITY="T OW N AE L AH T IY",DOLLOP="D AA L AH P",MIRRORS="M IH R ER Z",MATNEY="M AE T N IY",PORTFOLIOS="P AO R T F OW L IY OW Z",MACKERT="M AE K ER T",BRINN="B R IH N",WAHLERS="W AA L ER Z",["SRIRAM(2)"]="SH R IY R AA M",LESLEY="L EH S L IY",PROWESS="P R AW AH S",MOUNTAIN="M AW N T AH N",ONLOOKER="AO N L UH K ER",MUCKRAKE="M AH K R EY K",JENKIN="JH EH NG K IH N",QUAYLE="K W EY L",PROPIONIC="P R OW P IY AA N IH K",["UGANDA'S"]="Y UW G AE N D AH Z",KUHLMANN="K UW L M AH N",LANDEN="L AE N D AH N",["MAYFIELD(2)"]="M EY F IH L D",["TORRENTIAL(2)"]="T AO R EH N SH AH L",BIOSYS="B AY OW S IH S",LEWELLEN="L UW EH L AH N",TYGER="T AY G ER",ANGUS="AE NG G AH S",KYGER="K AY G ER",BUCHTA="B AH CH T AH",YACHTING="Y AA T IH NG",SZCZEPANSKI="SH IH P AE N S K IY",GYGER="G AY G ER",GARBLES="G AA R B AH L Z",FOUNTAIN="F AW N T AH N",FREDERIKA="F R EY D EH R IY K AH",MARBLES="M AA R B AH L Z",WILKIN="W IH L K IH N",MAMARONECK="M AH M EH R AH N EH K",FUTURE="F Y UW CH ER",WARBLES="W AO R B AH L Z",GILLIGAN="G IH L AH G AH N",MILLIGAN="M IH L IH G AH N",ALSGAARD="AA L Z G AA R D",CONTICOMMODITY="K AA N T IH K AH M AA D IH T IY",PRENUPTIAL="P R IY N AH P SH AH L",["SADEH-KONIECPOL"]="S AA D EH K OW N IY EH K P AO L",SLEUTHS="S L UW TH S",SCHAMP="SH AE M P",SUTURE="S UW CH ER",RECREATED="R EH K R IY EY T IH D",SCHOBEL="SH OW B AH L",WISLEY="W IH Z L IY",DEPREZ="D EY P R EH Z",SISLEY="S IH Z L IY",AUGUSTA="AH G AH S T AH",IMMOBILIZED="IH M OW B AH L AY Z D",BEFRIEND="B IH F R EH N D",["DETACHMENT(2)"]="D IY T AE CH M AH N T",OLYMPUS="OW L IH M P AH S",["RANSOM'S"]="R AE N S AH M Z",["VERTEL'S"]="V ER T EH L Z",PRIVATIZED="P R AY V AH T AY Z D",RISLEY="R IH Z L IY",BOTTOMS="B AA T AH M Z",NISLEY="N IH Z L IY",RANKIN="R AE NG K IH N",MACKEY="M AE K IY",LACKEY="L AE K IY",MANKIN="M AE NG K IH N",MCCRUDDEN="M AH K R AH D AH N",EXERCISES="EH K S ER S AY Z AH Z",COLLATERALIZE="K AH L AE T ER AH L AY Z",HANKIN="HH AE NG K IH N",HEPBURN="HH EH P B ER N",["STOCKS'"]="S T AA K S",CORDONED="K AO R D AH N D",RUGER="R UW G ER",VANDEN="V AE N D AH N",LUGER="L UW G ER",ENDURE="EH N D Y UH R",["DETAILS(2)"]="D IY T EY L Z",BAYTREE="B EY T R IY",NEKOOSA="N IH K UW S AH",COPPERNOLL="K AH P ER N OW L",AUGER="AO G ER",["PORSCHE'S"]="P AO R SH AH Z",FLINN="F L IH N",STAYS="S T EY Z",KRATKY="K R AE T K IY",FINALITY="F AY N AE L AH T IY",SORTERS="S AO R T ER Z",MULLIGAN="M AH L IH G AH N",SECULARISM="S EH K Y AH L ER IH Z AH M",["SHECK'S"]="SH EH K S",LUTEN="L UW T AH N",PARNASSUS="P AA R N AE S AH S",OUTEN="AW T AH N",TUTEN="T Y UW T AH N",HORRORS="HH AO R ER Z",IHLENFELDT="IH L IH N F IH L T",INSPECTION="IH N S P EH K SH AH N",NUMBERS="N AH M B ER Z",["PUSHES(2)"]="P UH SH IH Z",HERMIT="HH ER M AH T",OATLEY="OW T L IY",["VINING'S"]="V AY N IH NG Z",KERMIT="K ER M IH T",RATLEY="R AE T L IY",["CAVACO(2)"]="K AH V AA K OW",COGER="K OW JH ER",BOGER="B OW G ER",["MINING'S"]="M AY N IH NG Z",MOTIVATION="M OW T AH V EY SH AH N",POTPOURRIS="P OW P UH R IY Z",PERMIT="P ER M IH T",WATLEY="W AA T L IY",MULTIVISION="M AH L T IY V IH ZH AH N",RHETORICIAN="R EH T ER IH SH AH N",SANDBLAST="S AE N D B L AE S T",WICKERT="W IH K ER T",ATHALIA="EY TH AE L IY AH",RICKERT="R IH K ER T",OUTPOUCH="AW T P AW CH",PRAETORIAN="P R IY T AO R IY AH N",PICKERT="P IH K ER T",DOTEN="D OW T AH N",SWAGGART="S W AE G ER T",BIRCHMEIER="B ER K M AY ER",BICKERT="B IH K ER T",BATLEY="B AE T L IY",DICKERT="D IH K ER T",POTEN="P OW T AH N",TROPOPAUSE="T R AA P AH P AO Z",UNVERIFIED="AH N V EH R IH F AY D",["CONCORD'S(2)"]="K AA N K ER D Z",ROTEN="R OW T AH N",LINDEN="L IH N D AH N",CANNON="K AE N AH N",SHAYS="SH EY Z",TWITCHED="T W IH CH T",BANNON="B AE N AH N",ESOPHAGUS="IH S AA F AH G AH S",WEEBER="W IY B ER",MONTJOY="M AA N T JH OY",GANNON="G AE N AH N",HANNON="HH AE N AH N",["ACTIVISTS(4)"]="AE K T IH V IH S",MCKAMEY="M AH K AE M IY",DISEQUILIBRIUM="D IH S IY K W AH L IH B R IY AH M",SWITCHED="S W IH CH T",UNDERPINNED="AH N D ER P IH N D",FERTILIZATION="F ER T AH L IH Z EY SH AH N",HOLZAPFEL="HH OW L Z AH P F AH L",REFRESHED="R IY F R EH SH T",HUGUS="HH Y UW G AH S",METABOLIC="M EH T AH B AA L IH K",["BROOKSVILLE'S"]="B R UH K S V IH L Z",THEODORA="TH IY AH D AO R AH",PORTIS="P AO R T IH S",MORTIS="M AO R T IH S",RENDITION="R EH N D IH SH AH N",SEEBER="S IY B ER",RESTAURATEUR="R EH S T ER AH T ER",KRAPF="K R AE P F",LIKHYANI="L IH K Y AA N IY",["CACKLING(2)"]="K AE K L IH NG",LOOMIS="L UW M IH S",ABBREVIATING="AH B R IY V IY EY T IH NG",SUBMINIMUM="S AH B M IH N IH M AH M",WIELGUS="W IY L G AH S",CENTAVOS="S EH N T AA V OW S",NORDIC="N AO R D IH K",SPRENG="S P R EH NG",ORTEN="AO R T AH N",REALTOR="R IY AH L T ER",["OPERANDI(3)"]="AA P ER EH N D AY",FILMING="F IH L M IH NG",CARTHAGINIAN="K AA R TH AH JH IH N IY AH N",GERSTENBERGER="G ER S T AH N B ER G ER",["METHODIST(2)"]="M EH TH AH D IH S T",SPASMODIC="S P AE Z M AO D IH K",UECKERT="UH K ER T",ELGER="EH L G ER",BULLWINKLE="B UH L W IH NG K AH L",ALGER="AE L JH ER",HICKEY="HH IH K IY",["RECKONING(2)"]="R EH K N IH NG",MICKEY="M IH K IY",BECKERT="B EH K ER T",DENDEN="D EH N D AH N",MELCHIORRE="M EH L K IY AO R EY",ULGER="AH L G ER",["TACKLING(2)"]="T AE K AH L IH NG",HECKERT="HH EH K ER T",GIVENCHY="G IH V EH N CH IY",WICKEY="W IH K IY",VICKEY="V IH K IY",STITCHED="S T IH CH T",EPILEPTICS="EH P AH L EH P T IH K S",VALERO="V AH L EH R OW",CONDITIONALITY="K AH N D IH SH AH N AE L IH T IY",["TELESIS'S"]="T EH L AH S IH S IH Z",CALERO="K AH L EH R OW",DICKEY="D IH K IY",OTTEN="AA T AH N",COLLIGAN="K AA L IH G AE N",INGER="IH NG ER",HELMING="HH EH L M IH NG",["SPECIALIZES(2)"]="S P EH SH AH L AY Z IH Z",ENGER="EH NG G ER",ANGER="AE NG G ER",ORDINANCES="AO R D AH N AH N S IH Z",FISCUS="F IH S K AH S",DISCUS="D IH S K AH S",MARSZALEK="M ER SH AA L EH K",YINGST="Y IH NG G S T",PEPPERONI="P EH P ER OW N IY",JOACHIM="Y OW AA K IH M",UNDELIVERED="AH N D IH L IH V ER D",UNGER="AH NG G ER",FUNGAL="F AH NG G AH L",OFTEN="AO F AH N",OUSLEY="AW S L IY",FRITCHMAN="F R IH CH M AH N",ADMINISTRATORS="AE D M IH N IH S T R EY T ER Z",UNEMOTIONAL="AH N IY M OW SH AH N AH L",["PRAYERFUL(2)"]="P R EY ER F AH L",["INTERNATIONALIZATION(2)"]="IH N ER N AE SH AH N AH L IH Z EY SH AH N",RODKEY="R AA D K IY",MESZAROS="M IH SH AA R OW Z",LECKEY="L EH K IY",MEHLHORN="M EH L HH ER N",MIRRORING="M IH R ER IH NG",["SOVRAN'S"]="S AA V R AH N Z",INTERESTING="IH N T R AH S T IH NG",NORTHBROOK="N AO R TH B R UH K",CONFESSES="K AH N F EH S IH Z",AUSLEY="AO S L IY",STAPF="S T AE P F",CORNEAL="K AO R N IY L",["GENERALLY(2)"]="JH EH N R AH L IY",QUAKENBUSH="K W AH K EH N B UH SH",["FROMBUGER'S"]="F R OW M B Y UW G ER Z",MELERO="M EY L EH R OW",WHIRLEY="W ER L IY",CANIPE="K AA N IY P IY",MYHRE="M IH R",PRIZE="P R AY Z",COTNEY="K AA T N IY",DISBURSEMENT="D IH S B ER S M AH N T",KANIPE="K AE N IH P",INHERENTLY="IH N HH IH R AH N T L IY",LUKASH="L UW K AE SH",MAHLMANN="M AA L M AH N",ORIGINATION="ER IH JH AH N EY SH AH N",MANDAMUS="M AE N D EY M AH S",DEVOY="D EH V OY",KATEN="K EY T AH N",ATTENDED="AH T EH N D AH D",LOCKERT="L AA K ER T",["DAVENPORT'S"]="D AE V AH N P AO R T S",FINGERPOINTING="F IH NG G ER P OY N T IH NG",EXTRANEOUS="EH K S T R EY N IY AH S",SHIRLEY="SH ER L IY",GENTRIFICATION="JH EH N T R IH F IH K EY SH AH N",CUISINES="K W IH Z IY N Z",CHIEFFO="K IY F OW",CONFISCATE="K AA N F AH S K EY T",KLEBER="K L IY B ER",TIERNO="T IH R N OW",FEHER="F EH HH ER",CONDITION="K AH N D IH SH AH N",NEHER="N EY ER",FRUEH="F R UW",DELPHIAN="D EH L F Y AH N",SEHER="S EH HH ER",WOODEN="W UH D AH N",CUSTOMS="K AH S T AH M Z",MAGNANO="M AA G N AA N OW",REHER="R EH R",PROLIFERATION="P R OW L IH F ER EY SH AH N",PHILHOWER="F IH L AW ER",HOLTKAMP="HH OW L T K AE M P",GOODEN="G UH D AH N",ARMENIAN="AA R M IY N IY AH N",FURFARO="F UH R F AA R OW",ANDROS="AE N D R AA S",WEBMASTER="W EH B M AE S T ER",MCVOY="M AH K V OY",INTUITIVE="IH N T UW AH T IH V",WHORLS="W ER L Z",DIVITA="D IH V IY T AH",CULLOP="K AH L AH P",HEARIN="HH IH R IH N",CHLORINATING="K L AO R AH N EY T IH NG",PREBLE="P R EH B AH L",TRUJILLO="T R UW HH IY OW",UNOBSTRUCTED="AH N AH B S T R AH K T IH D",WIEBER="W IY B ER",LEONI="L EH OW N IY",["TYPICALLY(2)"]="T IH P IH K AH L IY",SIEBER="S IY B ER",["BOZTEPE(4)"]="B OW Z T EH P IY",FIRSTLY="F ER S T L IY",MUSICH="M Y UW S IH K",NEEDLED="N IY D AH L D",DEROSIER="D EH R AH S IY ER",SEQUENTIALLY="S AH K W EH N CH AH L IY",CHEERLEADER="CH IH R L IY D ER",HILLSIDES="HH IH L S AY D Z",FIEBER="F IY B ER",CHABLIS="SH AH B L IY",RIEBER="R IY B ER",LIEBER="L IY B ER",GARTERS="G AA R T ER Z",MCNITT="M AH K N IH T",PARDONED="P AA R D AH N D",["CREDENTIALED(2)"]="K R AH D EH N SH AH L D",CARTERS="K AA R T ER Z",SPODEN="S P OW D AH N",INTERMISSION="IH N T ER M IH SH AH N",BITNEY="B IH T N IY",SANDEFER="S AE N D IY F ER",AFGHAN="AE F G AE N",JITNEY="JH IH T N IY",DAHER="D AA ER",BADIA="B AA D IY AH",PITNEY="P IH T N IY",MEMBERS="M EH M B ER Z",["BURNSTEIN(2)"]="B ER N S T IY N",MAHER="M AA R",DIVIDER="D IH V AY D ER",ORCHESTRA="AO R K AH S T R AH",AFOUL="AH F AW L",TAHER="T EY ER",THORELL="TH AO R AH L",BIOTIN="B AY AH T AH N",ARTLEY="AA R T L IY",IMAGERY="IH M AH JH R IY",SEIZE="S IY Z",METHODICAL="M AH TH AA D AH K AH L",MIGRATORY="M AY G R AH T AO R IY",MERKICH="M ER K IH CH",PODCAST="P AO D K AE S T",PROFITABLY="P R AA F AH T AH B L IY",SOFTER="S AA F T ER",GYMNASIUMS="JH IH M N EY Z IY AH M Z",GEISERT="G AY S ER T",FAIRLEY="F EH R L IY",["O'BRIANT"]="OW B R AY AH N T",SHINN="SH IH N",GHOUL="G UW L",SCHER="SH ER",MARTIS="M AA R T IH S",["ARTISTS'"]="AA R T IH S T S",HARTIS="HH AA R T IH S",ROCHELLE="R OW SH EH L",AMBIENT="AE M B IY AH N T",ZAHER="Z EY ER",ALONI="AH L OW N IY",["RESTAURANT'S"]="R EH S T ER AA N T S",BOMBERS="B AA M ER Z",HOLTROP="HH OW L T R AH P",HUEBER="HH UH B ER",HALLUCINATES="HH AH L UW S AH N EY T S",HOTTEST="HH AA T AH S T",REISERT="R AY S ER T",ENTRANTS="EH N T R AH N T S",SCHADT="SH AE T",MOTLEY="M AA T L IY",REVELED="R EH V AH L D",GULBRANDSEN="G AH L B R AH N D S AH N",BAIZE="B EY Z",MEGAQUEST="M EH G AH K W EH S T",KETNEY="K EH T N IY",BURACK="B Y UW R AH K",CEREBRAL="S EH R AH B R AH L",TIMBERS="T IH M B ER Z",AUTORAD="AO T OW R AE D",EMOTIONALISM="IH M OW SH AH N AH L IH Z AH M",SEASONALLY="S IY Z AH N AH L IY",MISTRETTA="M IH S T R EH T AH",HEFTER="HH EH F T ER",COLIFORM="K OW L AH F AO R M",GUCKERT="G AH K ER T",["HORNSTEIN(2)"]="HH AO R N S T IY N",NISSHIN="N IH SH IH N",CONCESSIONARY="K AH N S EH SH AH N EH R IY",ANTLEY="AE N T L IY",KUSHNIR="K AH SH N ER",VICORP="V AY K AO R P",STRUMS="S T R AH M Z",MAIZE="M EY Z",RUCKERT="R AH K ER T",["APPLICANTS'"]="AE P L AH K AH N T S",HEADBAND="HH EH D B AE N D",DEMOBILIZED="D IH M OW B AH L AY Z D",VANDERWAL="V AE N D ER W AA L",BURBLES="B ER B AH L Z",SEOUL="S OW L",GREBER="G R IY B ER",ZUPANCIC="Z AH P AE NG K IH K",SOUTHAMPTON="S AW TH HH AE M P T AH N",["BORNSTEIN(2)"]="B AO R N S T IY N",MEGHAN="M EH G AH N",DOUGGINS="D UW G AH N Z",["PHILLIPS'"]="F IH L IH P S",VANRIPER="V AE N R AY P ER",["DIVERGENCE(2)"]="D IH V ER JH AH N S",VERSATILITY="V ER S AH T IH L AH T IY",CONTENT="K AA N T EH N T",SCHUMPERT="SH AH M P ER T",TRAFALGAR="T R AH F AE L G ER",["ENCHANTER'S(3)"]="EH N CH AE N ER Z",MADIA="M AA D IY AH",RAVELED="R AE V AH L D",STEBER="S T IY B ER",NADIA="N AE D Y AH",MONTMINY="M AA N T M IH N IY",BULRUSH="B UH L R AH SH",["CROSBY'S"]="K R AO Z B IY Z",SHIMBUN="SH IH M B AH N",["OSCEOLA(2)"]="AO S IY OW L AH",BALDUR="B AA L D UH R",MEEKLY="M IY K L IY",VEROA="V ER OW AH",JAMILA="JH AH M IH L AH",SPRINGBORN="S P R IH NG G B ER N",CARNEAL="K AA R N AH L",FILIGREES="F IH L AH G R IY Z",PITIFUL="P IH T AH F AH L",MYSLINSKI="M IH S L IH N S K IY",ROEBER="R OW B ER",DAMASK="D AE M AH S K",LEREAH="L EH R EY AH",BELLIES="B EH L IY Z",LOEBER="L OW B ER",MERCHANDISING="M ER CH AH N D AY Z IH NG",COLORIZE="K AH L ER AY Z",["DEMOCRAT'S"]="D EH M AH K R AE T S",JELLIES="JH EH L IY Z",BREZA="B R EH Z AH",["POINTED(2)"]="P OY N AH D",PLATTE="P L AE T",HUSEN="HH UW S AH N",WIEDERHOLT="W IY D ER HH OW L T",SWITCHING="S W IH CH IH NG",TWITCHING="T W IH CH IH NG",NUSEN="N UW S AH N",["TURRET(2)"]="T ER T",LUTSKY="L AH T S K IY",WELLIES="W EH L IY Z",["NEBRASKA'S"]="N AH B R AE S K AH Z",["ARABIC(2)"]="EH R AH B IH K",["RHODE-ISLAND'S"]="R OW D AY L AH N D Z",["WHITMAN(2)"]="HH W IH T M AH N",CUTAIA="K UW T AA Y AH",SUCTION="S AH K SH AH N",["REPUGNANT(2)"]="R IY P AH G N AH N T",WILLPOWER="W IH L P AW ER",["DINGELL'S"]="D IH NG G AH L Z",CREASEY="K R IY S IY",FOLLIES="F AA L IY Z",DIBBLE="D IH B AH L",HOLLIES="HH AA L IY Z",JOLLIES="JH AA L IY Z",["MICRON'S"]="M AY K R AA N Z",NIBBLE="N IH B AH L",DIAMETRICALLY="D AY AH M EH T R IH K AH L IY",KIBBLE="K IH B AH L",COLLIES="K AA L IY Z",["GROCERY(2)"]="G R OW S R IY",GIBBLE="JH IH B AH L",GENTLEMEN="JH EH N T AH L M IH N",STETHOSCOPES="S T EH TH AH S K OW P S",WEEKLY="W IY K L IY",RIBBLE="R IH B AH L",QUARANTA="K W ER AE N T AH",INFECTIOUS="IH N F EH K SH AH S",LALIT="L AH L IY T",["EVOLUTION(3)"]="EH V OW L UW SH AH N",AUCTION="AA K SH AH N",DISMANTLEMENT="D IH S M AE N T AH L M AH N T",CONGEAL="K AH N JH IY L",["MACHIAVELLI'S(2)"]="M AA K Y AH V EH L IY Z",MAHALIA="M AH HH AE L IY AH",ESSAYIST="EH S EY IH S T",ZAMMIT="Z AE M IH T",SUPERHEATED="S UW P ER HH IY T IH D",VIPUL="V IY P UW L",KROPP="K R AA P",WAGONEER="W AE G AH N IH R",DAMMIT="D AE M IH T",PROPP="P R AA P",TROPP="T R AA P",USHER="AH SH ER",LEPTIN="L EH P T IH N",SHOPLIFTERS="SH AA P L IH F T ER Z",["HUNDRED(2)"]="HH AH N D R IH D",DECLARATORY="D IH K L EH R AH T AO R IY",TONIEST="T OW N IY S T",CREDITWORTHINESS="K R EH D IH T W ER DH IY N AH S",ATTENTIVE="AH T EH N T IH V",UNSURE="AH N SH UH R",DISMANTLING="D IH S M AE N T AH L IH NG",HERZLINGER="HH ER Z L IH NG ER",MCWETHY="M AH K W EH TH IY",ZAVALA="Z AA V AA L AH",BERARDO="B ER AA R D OW",RECOLLECTED="R EH K AH L EH K T IH D",CROPP="K R AA P",GROPP="G R AA P",GERARDO="JH ER AA R D OW",SAVALA="S AA V AA L AH",COLOMBIA="K AH L AH M B IY AH",ETHER="IY TH ER",OTHER="AH DH ER",TELIT="T EH L IH T",JETHRO="JH EH TH R OW",BUBBLE="B AH B AH L",DISPROVES="D IH S P R UW V Z",GIRAUD="ZH AY R OW",STEPTOE="S T EH P T OW",ENSURE="EH N SH UH R",RUBBLE="R AH B AH L",ALFONO="AE L F OW N OW",KRAUSSE="K R AO S",ORDINARIES="AO R D AH N EH R IY Z",PICKERING="P IH K ER IH NG",VERRASTRO="V EH R AE S T R OW",PROTEASE="P R OW T IY EY Z",DIOXINS="D AY AA K S IH N Z",REPATRIATED="R IY P EY T R IY EY T IH D",["PRINTED(2)"]="P R IH N T IH D",["CAMPUSES(2)"]="K AE M P AH S IH Z",IPSEN="IH P S AH N",["DAMME(2)"]="D EY M",AMERIBANC="AH M EH R IH B AE NG K",TOMKIN="T AA M K IH N",KNOPP="N AA P",LOSURE="L OW ZH ER",BLAYDES="B L EY D Z",ZACHMANN="Z AA K M AH N",RUECKERT="R UW K ER T",SAOUMA="S AW Y UW M AH",["CONTRAS'"]="K AA N T R AH Z",PLATONIST="P L EY T AH N AH S T",INTERLEAVE="IH N T ER L IY V",STEKLY="S T EH K L IY",SOFIA="S OW F IY AH",OSHER="AA SH ER",CICALESE="CH IY K AA L EY Z IY",SLINEY="S L IH N IY",KARNICKI="K AA R N IH K IY",STITCHING="S T IH CH IH NG",HENTHORN="HH EH N TH AO R N",OREGONIAN="AO R AH G OW N IY AH N",HARDENING="HH AA R D AH N IH NG",GARDENING="G AA R D AH N IH NG",HOOLIGAN="HH UW L IH G AH N",PRELUDES="P R EY L UW D Z",ASHER="AE SH ER",THANKFUL="TH AE NG K F AH L",["PRECINCT(2)"]="P R IY S IH NG K",PEDROS="P EY D R OW Z",["O'"]="OW",ANXIETY="AE NG Z AY AH T IY",POSEN="P OW Z AH N",DESROCHERS="D EY R OW SH ER Z",RECREATION="R EH K R IY EY SH AH N",DICKERING="D IH K ER IH NG",RAMBIN="R AE M B IH N",PRINTEMPS="P R IH N T EH M P S",["Q."]="K Y UW",["R."]="AA R",["S."]="EH S",["T."]="T IY",["M."]="EH M",["N."]="EH N",["O."]="OW",["P."]="P IY",["I."]="AY",MCKELVEY="M AE K AH L V EY",["K."]="K EY",NEWARK="N UW ER K",["E."]="IY",["F."]="EH F",["G."]="JH IY",["TRAVERSE(2)"]="T R AH V ER S",["Y."]="W AY",["Z."]="Z IY",["U."]="Y UW",["V."]="V IY",RHODEN="R OW D AH N",["X."]="EH K S",ALLBEE="AO L B IY",FAVORITISM="F EY V ER IH T IH Z AH M",MARYA="M AA R Y AH",["MANIFOLD(2)"]="M AE N IH F OW L D",["A."]="EY",CONVERGENCE="K AH N V ER JH AH N S",["C."]="S IY",["D."]="D IY",["SCHMUTZLER(2)"]="SH M AH T Z L ER",BACKPACKS="B AE K P AE K S",HIPBONE="HH IH P B OW N",FITTEST="F IH T AH S T",STIGMA="S T IH G M AH",BACHMANN="B AA K M AH N",CAMERO="K AH M EH R OW",STULTZ="S T AH L T S",["CAFE(2)"]="K AE F EY",ROHER="R OW ER",MOHER="M AA HH ER",HAUSKY="HH AO S K IY",["PRINZ'S"]="P R IH N Z AH Z",SIMKIN="S IH M K IH N",["FOREIGNERS'(2)"]="F AA R AH N ER Z",PERSEVERING="P ER S AH V IH R IH NG",MARAUD="M ER AO D",ESSEN="EH S AH N",MARUTI="M ER UW T IY",["MATTEL'S"]="M AH T EH L Z",FICTION="F IH K SH AH N",SWIRLS="S W ER L Z",TWIRLS="T W ER L Z",HATHORNE="HH AE TH ER N",PAWLOSKI="P AA V L AW S K IY",EQUALIZER="IY K W AH L AY Z ER",FREEING="F R IY IH NG",["OOOHS(2)"]="OW Z",INVITED="IH N V AY T AH D",TINIEST="T AY N IY AH S T",DYNASTIES="D AY N AH S T IY Z",["COUNTERSUED(2)"]="K AW N ER S UW D",UNMASK="AH N M AE S K",EXPOUNDS="IH K S P AW N D Z",PROULX="P R AW L K S",C3="S IY TH R IY",BENGAL="B EH NG G AH L",["AMES'S"]="EY M Z IH Z",GROULX="G R AW L K S",DEATHSHOT="D EH TH SH AO T",M2="EH M T UW",INTERIORS="IH N T IH R IY ER Z",NIGHTSTAND="N AY T S T AE N D",HELMBRECHT="HH EH L M B R IH K T",SPECKMAN="S P EH K M AH N",BHANGRA="B AA NG G R AH",FINGERTIPS="F IH NG G ER T IH P S",SKIER="S K AY R",LEIBOVIT="L IY B AH V IH T",["HAIG'S"]="HH EY G Z",MYRTIS="M IH R T IH S",["MARADONA'S"]="M AA R AH D OW N AH Z",HORNPIPE="HH AO R N P AY P",SCARPULLA="S K AA R P UH L AH",BURKINA="B ER K IY N AH",["GAMING'S"]="G EY M IH NG Z",IBSEN="IH B S AH N",POINTINGLY="P OY N T IH NG L IY",ODIER="OW D IY ER",STERKEL="S T ER K AH L",LOANLOSS="L OW N L AO S",KURUMIZOWA="K UH R UW M IY Z OW AH",EYEBROWS="AY B R AW Z",BEIER="B AY ER",WIGHTMAN="W AY T M AH N",NEIER="N AY ER",MEIER="M AY ER",LEIER="L AY ER",GLYCOGEN="G L AY K AH JH IH N",FASTENERS="F AE S AH N ER Z",HEIER="HH AY ER",GEIER="G AY ER",SOFRANKO="S AH F R AE NG K OW",SEIER="S AY ER",CHECHNYAN="CH EH CH N IY AH N",HEINEY="HH AY N IY",DISCRETION="D IH S K R EH SH AH N",WEIER="W EY ER",CLOUDLESS="K L AW D L AH S",HUMPHERY="HH AH M F ER IY",["SREBRENICA'S"]="S R EY B R EH N IY T S AH Z",OSCILLATIONS="AA S AH L EY SH AH N Z",SECTION="S EH K SH AH N",RAOUL="R AA UW L",CROUNSE="K R AW N S",MEGALOPOLIS="M EH G AH L AA P AH L AH S",["ABDUCTING(2)"]="AH B D AH K T IH NG",SCERZUSKY="S ER Z UW S K IY",SPEROS="S P EH R OW Z",["GENERALIZING(2)"]="JH EH N R AH L AY Z IH NG",REGISTRANTS="R EH JH AH S T R AH N T S",OLSEN="OW L S AH N",ANTONIOU="AA N T OW N IY UW",JANICKI="JH AH N IH K IY",MARCUS="M AA R K AH S",MENTIONING="M EH N SH AH N IH NG",ELSEN="EH L S AH N",["MATRIX'S"]="M EY T R IH K S IH Z",NEWMONT="N UW M AA N T",SALLIES="S AE L IY Z",RALLIES="R AE L IY Z",RACHELLE="R AH SH EH L",OGIER="OW G IY ER",SHAREHOLDER="SH EH R HH OW L D ER",["CONFIDED(2)"]="K AH N F AY D IH D",GUERRINI="G ER IY N IY",BENAVIDEZ="B EY N AA V IY D EH Z",RISEN="R IH Z AH N",["FIGHTER'S"]="F AY T ER Z",["INVALID(3)"]="IH N V AE L AH D",ZEEBLE="Z IY B AH L",M1="EH M W AH N",ADULTEROUS="AH D AH L T ER AH S",FLUORIDE="F L UH R AY D",["STREISAND'S"]="S T R AY Z AH N D Z",SASSNET="S AE S N EH T",CULKIN="K AH L K IH N",["RESUMES(2)"]="R IY Z UW M Z",PERMISSIVE="P ER M IH S IH V",PUBLISH="P AH B L IH SH",MEXICANA="M EH K S IH K AE N AH",ZIEMBA="Z IY M B AH",["THICKENING(2)"]="TH IH K N IH NG",JELLYFISH="JH EH L IY F IH SH",C1="S IY W AH N",AERODROMES="EH R AH D R OW M Z",EICHMANN="AY K M AH N",HANTHORN="HH AE N TH ER N",DENATALE="D IH N AA T AA L IY",["MIGLIN'S"]="M IH G L IH N Z",NARRATIVES="N AE R AH T IH V Z",GAIER="G EY ER",["DEGRACE(2)"]="D IH G R EY S",BLACKLEY="B L AE K L IY",WICHMANN="W IH CH M AH N",MAIER="M EY ER",HAINEY="HH EY N IY",BARCUS="B AA R K AH S",VOLDEN="V OW L D AH N",MONJE="M AA N JH",SOUTHGATE="S AW TH G EY T",ERITREA="EH R IH T R IY AH",NOLDEN="N OW L D AH N",MOLDEN="M OW L D AH N",KOLDEN="K OW L D AH N",HOLDEN="HH OW L D AH N",GOLDEN="G OW L D AH N",FOLDEN="F OW L D AH N",FREELANCE="F R IY L AE N S",COLDEN="K OW L D AH N",BOLDEN="B OW L D AH N",M3="EH M TH R IY",["EXPRESS'"]="IH K S P R EH S",BAROMETRIC="B AE R AH M EH T R IH K",BODENHEIMER="B AA D IH N HH AY M ER",SUMMIT="S AH M AH T",MRAZIK="M R AA Z IH K",DEPARDIEU="D IY P AA R D Y AH",SCHLITT="SH L IH T",ROTTERDAM="R AA T ER D AE M",DIECKMAN="D IY K M AH N",KOTILA="K AH T AY L AH",SCHIFANO="S K IY F AA N OW",BATISTA="B AH T IH S T AA",HOBBLE="HH AA B AH L",HERZING="HH ER Z IH NG",BOBBLE="B AO B AH L",COBBLE="K AA B AH L",CHOLERIC="K AA L ER IH K",LISTENERS="L IH S AH N ER Z",["DISPARATE(2)"]="D IH S P EH R IH T",SCHEIDERER="SH AY D ER ER",TEMPORALLY="T EH M P ER AH L IY",["BUENOS-AIRES(3)"]="B W EY N OW S EY R",C5="S IY F AY V",DUARTE="D W AA R T EY",BALLAST="B AE L AH S T",ENSLEY="EH N S L IY",VINJE="V IH N JH",AUGMENTING="AO G M EH N T IH NG",M5="EH M F AY V",INSLEY="IH N S L IY",["ACHOA'S"]="AH CH OW AH Z",["PROSECUTORS'"]="P R AA S AH K Y UW T ER Z",COUSINS="K AH Z AH N Z",["CONTRACTOR'S"]="K AA N T R AE K T ER Z",MOSLEY="M OW Z L IY",SEEDEATERS="S IY D IY T ER Z",C4="S IY F AO R",BOSLEY="B AA Z L IY",M4="EH M F AO R",HOSLEY="HH AA S L IY",UNDERLINE="AH N D ER L AY N",LOOPHOLES="L UW P HH OW L Z",SMOOTHING="S M UW DH IH NG",["BAEDEKER'S"]="B EY D AH K ER Z",BEDDORS="B EH D ER Z",["NATIONALISTS(2)"]="N AE SH N AH L IH S T S",MCINTURFF="M AE K IH N T ER F",TRUMPED="T R AH M P T",MARCHETTA="M AA R K EH T AH",["FISHES(2)"]="F IH SH IH Z",MURGUIA="M UH R G W IY AH",POHLMANN="P OW L M AH N",["WIESBADEN(2)"]="W AY S B AA D AH N",ST_LOUIS="S EY N T L UW AH S",["DISHES(2)"]="D IH SH IH Z",DEWHIRST="D EH W ER S T",HUACHUCA="HH W AA CH UW K AH",SPLIT="S P L IH T",DESIGNATED="D EH Z IH G N EY T IH D",PROFFERED="P R AA F ER D",WINDHAM="W IH N D AH M",["PIES'S"]="P AY Z IH Z",MATSUDA="M AA T S UW D AH",["PRECEDED(3)"]="P R IY S IY D IH D",SUNBURN="S AH N B ER N",SCHOPF="SH AA P F",MICHELLE="M IH SH EH L",STUMPED="S T AH M P T",REMAINED="R IH M EY N D",MONTECALVO="M OW N T EH K AA L V OW",ERNESTO="ER N EH S T OW",MORGANTE="M AO R G AA N T IY",AASEN="AA S AH N",SCHMALZ="SH M AO L Z",KURTIS="K ER T IH S",PRECAST="P R IY K AE S T",ENDEAVOUR="IH N D EH V ER",["HOLVIS'"]="HH OW L V AH S",AMNESIA="AE M N IY ZH AH",SIMULATES="S IH M Y AH L EY T S",SCRATCHING="S K R AE CH IH NG",SUFFICIENTLY="S AH F IH SH AH N T L IY",BANALITY="B AH N AE L IH T IY",MEIOSIS="M AY OW S AH S",DEXTROSE="D EH K S T R OW S",UNCOLLECTED="AH N K AH L EH K T IH D",MADRIL="M AE D R IH L",MEMNON="M EH M N AA N",CONFINED="K AH N F AY N D",BOHLMANN="B OW L M AH N",TRAPANI="T R AA P AA N IY",DELISTED="D IY L IH S T IH D",KOHLMANN="K OW L M AH N",["LAOTIAN(3)"]="L AW SH AH N",SPLENIC="S P L EH N IH K",AC="EY S IY",CC="S IY S IY",DECELERATED="D IH S EH L ER EY T IH D",SUPERIORS="S UW P IH R IY ER Z",MC="M IH K",PUMMELING="P AH M AH L IH NG",["GRANDMOTHER'S(2)"]="G R AE M AH DH ER Z",["RETIREMENT'S(2)"]="R IY T AY R M AH N T S",PC="P IY S IY",FORSELL="F AO R S AH L",ENERGY="EH N ER JH IY",CONTENTEDLY="K AH N T EH N T AH D L IY",["INTIMATE(3)"]="IH N AH M AH T",RENEGOTIATION="R IY N IH G OW SH IY EY SH AH N",SIVERTSON="S IH V ER T S AH N",SCORPIO="S K AO R P IY OW",NEDERLANDSCHE="N EH D ER L AE N D SH IY",["REPEAT(2)"]="R IY P IY T",["YOUNGSTERS'"]="Y AH NG S T ER Z",CA="K AH",FOUNDERED="F AW N D ER D",SMOOTHS="S M UW DH Z",DA="D AA",ELEKTRA="EH L EH K T R AH",JA="Y AA",IA="IY AH",HA="HH AA",DESANTIS="D EY S AA N T IH S",SAEHAN="S EY AH N",LA="L AA",SA="S AA",COPPERMAN="K AA P ER M AH N",PA="P AA",WA="W AA",MARZOLF="M AA R Z OW L F",["RECALLS(2)"]="R IH K AO L Z",TA="T AA",YA="Y AA",SEPTIMUS="S EH P T IH M IH S",KARAJAN="K EH R AH JH AH N",SPRINGSTON="S P R IH NG S T AH N",IMMORTALIZING="IH M AO R T AH L AY Z IH NG",PICHETTE="P AH SH EH T",IF="IH F",QUINOCO="K W IH N OW K OW",WESSELL="W EH S AH L",TOLENTINO="T OW L EH N T IY N OW",ROGELIO="R OW G IY L IY OW",OF="AH V",KLEPTOMANIAC="K L EH P T AH M EY N IY AE K",CHAVALIT="CH AH V AA L IH T",MUSSELWHITE="M AH S AH L W AY T",KESSELL="K EH S AH L",["PERATIS'"]="P ER AA T IH S",FORTINO="F AO R T IY N OW",["LA-QUINTA"]="L AH K W IH N T AH",["WRECKAGE(2)"]="R EH K IH JH",HOUPT="HH UW P T",GUARIN="G W AA R IH N",["HORATIO'S"]="HH AO R EY SH IY OW Z",["REGRET(2)"]="R IH G R EH T",MOERKE="M AO R K",KOCHANOWSKI="K AH HH AH N AO F S K IY",SKANDIA="S K AE N D IY ER",DEFENSIBLE="D IH F EH N S AH B AH L",TRANSNATIONAL="T R AE N S N AE SH AH N AH L",STARIN="S T AE R IH N",FAIRLEIGH="F EH R L AH",["ASPEN'S"]="AE S P AH N Z",SORTINO="S AO R T IY N OW",SUSANN="S UW Z AE N",SAMOA="S AH M OW AH",WICKLIFFE="W IH K L IH F",KINTIGH="K IH N T AY",TEEHAN="T IY AH N",ASCRIBES="AH S K R AY B Z",REMIT="R IY M IH T",AMYLOID="AE M IH L OY D",PHIBBS="F IH B Z",DISANTIS="D IH S AA N T IH S",MUPPETS="M AH P IH T S",MELADOR="M EH L AH D AO R",KEEHAN="K IY AH N",PUPPETS="P AH P AH T S",DEEHAN="D IY HH AE N",["INTERLAKE'S"]="IH N T ER L EY K S",FEEHAN="F IY AH N",["PILLSBURY'S"]="P IH L Z B EH R IY Z",RIVALS="R AY V AH L Z",MARLAR="M AA R L ER",BONAPARTE="B OW N AH P AA R T",AB="AE B",EB="EH B",IB="IH B",LB="P AW N D",SUCCESSFULLY="S AH K S EH S F AH L IY",["THOMASON(2)"]="T AA M AH S AH N",VANWINKLE="V AE N W IH NG K AH L",TB="T IY B IY",SEROTONIN="S ER AH T OW N IH N",PSYCHOPATHS="S AY K OW P AE TH S",AMICUS="AH M IY K AH S",SWISSAIR="S W IH S EH R",SALSBURY="S AE L Z B ER IY",SHAMBO="SH AE M B OW",CARDINAL="K AA R D AH N AH L",FERREN="F EH R AH N",KREMLINOLOGISTS="K R EH M L IH N AA L AH JH IH S T S",DUBROVSKY="D UW B R AO F S K IY",EK="EH K",DK="D IY K EY",WEIKERT="W AY K ER T",BREEDER="B R IY D ER",OK="OW K EY",["SEMICLASSICAL(3)"]="S EH M AY K L AE S IH K AH L",MCCULLAH="M AH K AH L AH",OCHRE="OW K ER",MATRILINEAL="M AE T R IH L IH N IY AH L",["GUESTS'"]="G EH S T S",BAHRE="B AA R",PATRILINEAL="P AE T R IH L IH N IY AH L",MH="EH M EY CH",DAMPNESS="D AE M P N IH S",PLUNDERED="P L AH N D ER D",AH="AA",UNFORGIVEN="AH N F AO R G IH V AH N",["RULING'S"]="R UW L IH NG Z",STOECKER="S T OW K ER",NERREN="N EH R AH N",STITH="S T IH TH",PERREN="P ER R AH N",PH="P IY EY CH",BLUNDERED="B L AH N D ER D",SAFFERSTEIN="S AE F ER S T IY N",TH="T IY EY CH",UH="AH",HI="HH AY",TRANSFORMATIONS="T R AE N S F ER M EY SH AH N Z",MI="M IY",ROSITA="R OW Z IY T AH",["'N"]="AH N",JI="JH IY",AI="AY",ROVEN="R OW V AH N",DI="D IY",BI="B AY",REFRESH="R IH F R EH SH",XI="SH IY",LARRIVEE="L AE R IH V IY",VI="V AY",ELEGY="EH L AH JH IY",["SCRIBNER'S"]="S K R IH B N ER Z",PI="P AY",OI="OY",NI="N IY",TI="T IY",SI="S IY",COURTHOUSES="K AO R T HH AW S IH Z",ASTUTENESS="AH S T UW T N AH S",LN="L EY N",EN="EH N",HOLDERNESS="HH OW L D ER N AH S",COMMACK="K AA M AH K",AN="AE N",PAULUS="P AO L AH S",["AKINS(2)"]="EY K IH N Z",["VIRUS'S"]="V AY R AH S IH Z",EQUIVALENT="IH K W IH V AH L AH N T",["INSECT'S"]="IH N S EH K T S",UN="AH N",RECURRING="R IH K ER IH NG",BROECKER="B R OW K ER",GRAUMAN="G R AO M AH N",ON="AA N",BUCHMILLER="B AH K M AH L ER",JURANEK="JH UH R AH N IH K",AG="AE G",NG="EH NG",GRIFFIN="G R IH F IH N",TRIARC="T R AY AA R K",ERVEN="ER V AH N",WALDRIDGE="W AO L D R IH JH",OG="AA G",UNLOAD="AH N L OW D",FRIESON="F R IY Z AH N",COMMISSIONER="K AH M IH SH AH N ER",ED="EH D",CD="S IY D IY",AD="AE D",SCANDIA="S K AE N D IY AH",JUSTIFICATIONS="JH AH S T IH F IH K EY SH AH N Z",WEIGELT="W AY G IH L T",UNDERSOLD="AH N D ER S OW L D",["SIMONTON(2)"]="S IH M AA N T AH N",HOVEN="HH OW V AH N",KOVEN="K OW V AH N",RATCHETED="R AE CH AH T IH D",JUMBOTRON="JH AH M B OW T R AO N",MARINELAND="M ER IY N L AH N D",BOVEN="B AH V AH N",COVEN="K AH V AH N",OBLIGATION="AA B L AH G EY SH AH N",BALDRIDGE="B AE L D R IH JH",FE="F EY",EE="IY",DE="D IY",BE="B IY",NEWSCASTS="N UW Z K AE S T S",BOTSHABELO="B AA CH AH B EH L OW",NE="N IY",ME="M IY",LE="L AH",MELODRAMATIC="M EH L AH D R AH M AE T IH K",ETSU="EH T S UW",MOZENA="M AH Z IY N AH",HE="HH IY",PHILIPPS="F IH L IH P S",VE="V IY",TE="T IY",SE="S AW TH IY S T",RE="R EY",RUSSIN="R AH S IH N",MCDONELL="M AH K D AA N AH L",BIOTECHNOLOGY="B AY OW T EH K N AA L AH JH IY",ZE="Z IY",YE="Y IY",WE="W IY",["KMART'S"]="K EY M AA R T S",LEAPFROGGING="L IY P F R AO G IH NG",WAYSIDE="W EY S AY D",["RESIGNATION(2)"]="R EH Z IH G N EY SH AH N",HOWITT="HH AW IH T",DEPLETION="D IH P L IY SH AH N",WARRIORS="W AO R IY ER Z",STARSTREAM="S T AA R S T R IY M",KOKOMO="K OW K AH M OW",OJ="OW JH EY",["ALLERGIST'S(2)"]="AE L ER JH AH S",["DESIGNATION(2)"]="D EH Z IH G N EY SH AH N",["SAVION(2)"]="S AE V Y AO N",["OBESITY(2)"]="AH B IY S AH T IY",LS="EH L EH S",OS="AA S",["FLASHER'S"]="F L AE SH ER Z",MAIMING="M EY M IH NG",TS="T IY EH S",MCLURE="M AH K L UW R",VS="V ER S AH Z",PALKAR="P AE L K AA R",LEVEN="L IY V AH N",["ARCANUM'S"]="AA R K AH N AH M Z",AS="AE Z",SEVEN="S EH V AH N",["DECAYING(2)"]="D IH K EY IH NG",DEPENDS="D IH P EH N D Z",ES="EH S",FS="F S",IS="IH Z",ROSENBLOOM="R OW Z AH N B L UW M",AOUZOU="AW Y UW Z UW",OP="AA P",PASSERO="P AA S EH R OW",PURSELL="P ER S AH L",ENDORPHINS="EH N D AO R F IH N Z",ROTATE="R OW T EY T",BAILYN="B EY L IH N",UP="AH P",MOONBEAMS="M UW N B IY M Z",DISREPUTE="D IH S R IH P Y UW T",["CARMEL(2)"]="K AA R M AH L",["EVENTUALLY(2)"]="IH V EH N SH AH L IY",LUCID="L UW S AH D",OCCURRING="AH K ER IH NG",IP="IH P",MYTHOLOGICAL="M IH TH AH L AA JH IH K AH L",INSTANT="IH N S T AH N T",NOWOTNY="N AW OW T N IY",REISSUED="R IY IH SH UW D",["MONTERREY(2)"]="M AA N ER EY",FORAYING="F AO R EY IH NG",GUZZETTA="G UW T S EH T AH",["MCDONALD'S"]="M AH K D AA N AH L D Z",BEVEN="B EH V AH N",["PIANISTS(3)"]="P IY AE N AH S",PELSTER="P EH L S T ER",AFFIRMATIVE="AH F ER M AH T IH V",ANYMORE="EH N IY M AO R",REVIVALS="R IY V AY V AH L Z",KURZWEIL="K ER Z W AY L",MARTINO="M AA R T IY N OW",WILSHIRE="W IH L SH AY R",INTERMARRY="IH N T ER M AE R IY",EV="EH V",BARREN="B AE R AH N",IO="AY OW",LO="L OW",PAULL="P AO L",MAULL="M AO L",NOISIEST="N OY Z IY AH S T",GO="G OW",CLEAVES="K L IY V Z",HARREN="HH AE R AH N",ADAPTATION="AE D AH P T EY SH AH N",FARREN="F EH R AH N",DARREN="D AA R AH N",NIVEN="N AY V AH N",HANF="HH AE N F",YO="Y OW",VO="V OW",WO="W OW",RO="R OW",TO="T UW",SO="S OW",NO="N OW",MO="M OW",PO="P OW",UNISSUED="AH N IH SH UW D",IL="IH L",CHARRING="CH AA R IH NG",MICRONICS="M AY K R AO N IH K S",["'M"]="AH M",DISTANT="D IH S T AH N T",["QUANTITATIVELY(2)"]="K W AA N IH T EY T AH V L IY",DELLAERT="D EH L AA R T",AL="AE L",GENERO="JH AH N ER OW",["ANDREA(2)"]="AA N D R EY AH",SHEEDER="SH IY D ER",SLEIPNER="S L AY P N ER",UNCONVINCED="AH N K AH N V IH N S T",SCRATCHED="S K R AE CH T",RIDDICK="R IH D IH K",RAPTIS="R AH P T IY S",UL="AH L",KARREN="K AE R AH N",DIPHTHERIA="D IH F TH IH R IY AH",ESTATE="IH S T EY T",WARREN="W AO R AH N",PARSELL="P AA R S AH L",HAUPT="HH AO P T",BAMBINO="B AE M B IY N OW",FM="EH F EH M",EM="EH M",ARRAYING="ER EY IH NG",AM="AE M",BRAZZELL="B R AE Z AH L",SUBPOENAS="S AH P IY N AH Z",SHADID="SH AE D IH D",JANSKY="Y AE N S K IY",MINERO="M IH N EH R OW",SOLINGEN="S OW L IH NG G EH N",COUGHENOUR="K AO F EH N ER",UM="AH M",["VENTURE'S"]="V EH N CH ER Z",DANSKY="D AE N S K IY",PM="P IY EH M",REACT="R IY AE K T",LEAVEN="L EH V AH N",MR="M IH S T ER",OR="AO R",SR="S IY N Y ER",SWIDERSKI="S V IH D ER S K IY",LIVEN="L AY V AH N",SYMMONDS="S IH M AH N D Z",RODDICK="R AA D IH K",AR="AA R",RAKICH="R AE K IH CH",MCGAGH="M AH G AO",["CHEMED(2)"]="K EH M D",DIVEN="D AY V AH N",MICROCLIMATE="M AY K R OW K L AY M AH T",BIVEN="B AY V AH N",BLUELAW="B L UW L AA",BARTMESS="B AA R T M IH S",["GREENWALD'S"]="G R IY N W AO L D Z",SHAVEN="SH EY V AH N",SKEHAN="S K EY AH N",BEGINNER="B IH G IH N ER",SALONE="S AH L OW N",BARANEK="B AE R AH N IH K",THRU="TH R UW",VALONE="V AH L OW N",BOLSTER="B OW L S T ER",SPRAYING="S P R EY IH NG",MALONE="M AH L OW N",SHEAVES="SH IY V Z",HOLSTER="HH OW L S T ER",BRIDEN="B R AY D AH N",KNIFFIN="N IH F IH N",MONSKY="M AA N S K IY",POLSTER="P OW L S T ER",HEXAGON="HH EH K S AH G AA N",ANTICIPATING="AE N T IH S AH P EY T IH NG",OX="AA K S",REDDICK="R EH D IH K",JUGGERNAUT="JH AH G ER N AO T",BRANDYWINE="B R AE N D IY W AY N",CURREN="K ER AH N",GRUFFLY="G R AH F L IY",NEDDICK="N EH D IH K",AX="AE K S",UY="UW IY",TY="T AY",SY="S AY",LIMIT="L IH M AH T",VY="V AY",MY="M AY",LY="L AY",["ESTATE'S"]="IH S T EY T S",OY="OY",CY="S AY",BY="B AY",SPARRING="S P AA R IH NG",PROUTY="P R AW T IY",["PAINTED(2)"]="P EY N T IH D",SHEHAN="SH EH HH AH N",FLUORSPAR="F L UH R S P AA R",["RUSSIA'S"]="R AH SH AH Z",SEYMORE="S IY M AO R",["HORACE(2)"]="HH AO R IH S",NONGREEK="N AA N G R IY K",ABIOMED="EY B IY AH M EH D",OW="OW",LINEBACKERS="L AY N B AE K ER Z",BIRREN="B ER AH N",VOMIT="V AA M AH T",SPRUIELL="S P R UW L",SLAVEN="S L EY V AH N",PETTRY="P EH T R IY",RAVEN="R EY V AH N",BERANEK="B EH R AH N IH K",AW="AO",MAVEN="M EY V AH N",EXPENDED="IH K S P EH N D IH D",LAVEN="L EY V AH N",STRAYING="S T R EY IH NG",AMARIN="AE M ER IH N",OT="AO T",GILLIES="G IH L IY Z",FILLIES="F IH L IY Z",MAULDING="M AO L D IH NG",PAULDING="P AO L D IH NG",CELSIUS="S EH L S IY AH S",MASENG="M AE S IH NG",ST="S T R IY T",COMPULSION="K AH M P AH L SH AH N",AT="AE T",BT="B IY T IY",SEAPOWER="S IY P AW ER",GRAVEN="G R EY V AH N",MACHINEGUNS="M AH SH IY N G AH N Z",PERU="P ER UW",MIRREN="M IH R AH N",ET="EH T",CT="K AO R T",EARTHLING="ER TH L IH NG",BERTINO="B ER T IY N OW",QU="K UW",PU="P UW",OU="UW",NU="N UW",LANGENDORF="L EY NG G IH N D AO R F",LU="L UW",KU="K UW",YU="Y UW",XU="Z UW",WU="W UW",VU="V UW",BALLASTS="B AE L AH S T S",SU="S UW",PUTTERER="P AH T ER ER",LOUGHEED="L AW IY D",DISASSOCIATED="D IH S AH S OW SH IY EY T AH D",VERMETTE="V ER M EH T",LINSKY="L IH N S K IY",EMMIT="EH M IH T",GU="G UW",GAULDING="G AO L D IH NG",FAULDING="F AO L D IH NG",DU="D UW",PINSKY="P IH N S K IY",ROMERO="R OW M EH R OW",GAVEN="G EY V AH N",["DIFFERENTIALS(2)"]="D IH F ER EH N CH AH L Z",COVENTRY="K AH V AH N T R IY",AGOURON="AH G UW R AA N",HOLDRIDGE="HH OW L D R IH JH",PHILBECK="F IH L B EH K",PERALA="P ER AA L AH",FAIRCHILD="F EH R CH AY L D",PENNEBAKER="P EH N IH B AH K ER",CULVERHOUSE="K AH L V ER HH AW S",CONSTRAINS="K AH N S T R EY N Z",CORRENE="K AO R IY N",ROCHETTE="R AH SH EH T",SEPARATIST="S EH P ER AH T IH S T",SIGURDSON="S IH G ER D S AH N",BJERKE="B Y ER K",GRATER="G R EY T ER",CRATER="K R EY T ER",["GARRIDO-LUNA"]="G AA R IY D OW L UW N AH",["ANTECEDENT(2)"]="AE N T IH S IY D AH N T",["INDOSUEZ(2)"]="IH N D OW S UW EH Z",DENTIN="D EH N T AH N",HUNDREDWEIGHT="HH AH N D R AH D W EY T",RICHAUD="R IH SH OW D",PRATER="P R EY T ER",CRAMPS="K R AE M P S",WISHED="W IH SH T",GHITIS="G IY T IH Z",["TOUVIER'S"]="T UW V IY EY Z",DEPENDED="D IH P EH N D AH D",WAGNON="W AE G N AH N",DEEDRICK="D IY D R IH K",HOLLENDER="HH AA L EH N D ER",COLLENDER="K AA L AH N D ER",TASSIN="T AE S IH N",NONETHELESS="N AH N DH AH L EH S",NINETEEN="N AY N T IY N",KASSIN="K AE S IH N",CHASTISES="CH AE S T AY Z IH Z",GWINN="G W IH N",CASSIN="K AE S IH N",KOVATCH="K AA V AH CH",HUMIDOR="HH Y UW M IH D AO R",TRAMPS="T R AE M P Z",FUMIDOR="F Y UW M AH D AO R",PROMPT="P R AA M P T",QUIRKS="K W ER K S",STATER="S T EY T ER",SPONSELLER="S P AA N S AH L ER",PHENOTYPIC="F IY N AH T IH P IH K",WHATSOEVER="W AH T S OW EH V ER",MURNAN="M ER N AH N",CLAMPS="K L AE M P S",BALBI="B AE L B IY",["RUINS(2)"]="R UW IH N Z",BORCHERDING="B AO R K ER D IH NG",["GRANDFATHER(2)"]="G R AE N F AA DH ER",ACURAS="AE K Y ER AH Z",KWON="K W AA N",LEUKEMIA="L UW K IY M IY AH",NONCHALANCE="N AA N SH AH L AA N S",TENGELMANN="T EH NG G AH L M AH N",GAGNON="G AE N Y AH N",FOULKES="F AW L K S",MARKEDLY="M AA R K AH D L IY",KRULL="K R AH L",CURFEW="K ER F Y UW",ARGENTINIANS="AA R JH AH N T IH N IY AH N Z",TRULL="T R AH L",POPEIL="P OW P IY L",["PHONE'S"]="F OW N Z",["FUNDRAISER'S"]="F AH N D R EY Z ER Z",VINDICATE="V IH N D AH K EY T",MICHAUD="M IH SH OW",MEXICANO="M EH K S IH K AA N OW",GENTZLER="JH EH N T S L ER",DESANCTIS="D EH S AE NG K T IH S",BACARDI="B AH K AA R D IY",COULL="K AW L",LOPARDO="L OW P AA R D OW",BANKEAST="B AE NG K IY S T",LYON="L AY AH N",AYON="EY AO N",["VIRAZOLE(2)"]="V AY R AH Z OW L",LOGOGRAMS="L AO G AH G R AE M Z",ROYALE="R OY AE L",WOGOMAN="W OW G OW M AH N",SCRIPTURE="S K R IH P CH ER",["ALEXANDROV(2)"]="AE L AH G Z AE N D R AH V",COSMETIC="K AA Z M EH T IH K",RYON="R AY AH N",["COMPRISES(2)"]="K AH M P R AY Z IH Z",ZIERKE="Z IY R K",LATVIAN="L AE T V IY AH N",["PRESIDE(2)"]="P R IY Z AY D",PANORAMIC="P AE N ER AE M IH K",PRIMING="P R AY M IH NG",AVON="EY V AA N",EVON="EH V AH N",INSULATOR="IH N S AH L EY T ER",FLEEMAN="F L IY M AH N",NARITA="N EH R IY T AH",BALLOON="B AH L UW N",ACCARDI="AA K AA R D IY",CHAMPS="CH AE M P S",GALLOON="G AH L UW N",DEFENSES="D IH F EH N S AH Z",CHRETIEN="K R IH T Y EH N",CLONIDINE="K L AA N IH D IY N",SARNI="S AA R N IY",ANSELM="AE N S EH L M",VARNI="V AA R N IY",SMULL="S M AH L",BINN="B IH N",SCARRING="S K AA R IH NG",HYDRAZINE="HH AY D R AH Z IY N",FINN="F IH N",ACCURACY="AE K Y ER AH S IY",HINN="HH IH N",RITTENHOUSE="R IH T AH N HH AW S",HERRLINGER="HH EH R L IH NG ER",MAIDEN="M EY D AH N",PRESTIDIGITATION="P R EH S T IH D IH JH AH T EY SH AH N",CARITA="K AA R IY T AH",SLEEMAN="S L IY M AH N",HAUSCHILDT="HH AW SH IH L T",KLEEMAN="K L IY M AH N",["COMMERCIALE'S"]="K AH M ER S IY AE L Z",BEACHCOMBER="B IY CH K OW M ER",BATHED="B EY DH D",GREAVES="G R IY V Z",SMITHWICK="S M IH TH W IH K",DEMOCRATIZES="D IH M AA K R AH T AY Z IH Z",CARNAUD="K AA R N AO",LUNN="L AH N",MUNN="M AH N",NUNN="N AH N",SKULL="S K AH L",GARAGIOLA="G ER AE JH IY OW L AH",MONOCLONAL="M AA N AH K L OW N AH L",DEMURE="D IH M Y UH R",WALBRIDGE="W AO L B R IH JH",EXECUTES="EH K S AH K Y UW T S",["CHINN'S"]="CH IH N Z",BYPASSING="B AY P AE S IH NG",STARNES="S T AA R N Z",MCCAUTHY="M AH K AW TH IY",["SIERRA'S"]="S IY EH R AH Z",CALMING="K AA M IH NG",LADOW="L AE D OW",SMIRKS="S M ER K S",CONSOLE="K AA N S OW L",WYNDHAM="W IH N D AH M",DELBRIDGE="D EH L B R IH JH",KIPPERMAN="K IH P ER M AH N",BUTTRY="B AH T R IY",CHUGOKU="CH UW G OW K UW",TRIANGULATION="T R AY AE NG G Y UW L EY SH AH N",DOTTERER="D AA T ER ER",HOBNAIL="HH AA B N EY L",MONN="M AA N",VIPPERMAN="V IH P ER M AH N",SONN="S AA N",PHAGOCYTES="F AE G AH S AY T S",TONN="T AA N",SLANDEROUS="S L AE N D ER AH S",JUSTINO="JH AH S T IY N OW",SEAMSTRESSES="S IY M S T R AH S AH Z",CONFETTI="K AH N F EH T IY",BUNN="B AH N",GUINN="G IH N",GRUEN="G R UW N",GUNN="G AH N",HUNN="HH AH N",GOLDTHWAITE="G OW L D TH W EY T",HEIDEN="HH AY D AH N",DUNN="D AH N",["ARONSTEIN(2)"]="EH R AH N S T AY N",FASSNACHT="F AE S N AH K T",QUINN="K W IH N",MATTRESS="M AE T R AH S",ANNOYANCES="AH N OY AH N S IH Z",HOVSEPIAN="HH AH V S IY P IY AH N",ERCROS="ER K R OW Z",IRRECONCILABLE="IH R EH K AH N S AY L AH B AH L",["COUNTEROFFENSIVES(2)"]="K AW N ER AO F EH N S IH V Z",TURNEY="T ER N IY",FASTEST="F AE S T AH S T",LASTEST="L AE S T AH S T",BRUEN="B R UW N",CROTHERS="K R AH DH ER Z",BROTHERS="B R AH DH ER Z",FURNEY="F ER N IY",BONN="B AA N",CONN="K AA N",SHULL="SH AH L",JURNEY="JH ER N IY",THULL="TH AH L",DONN="D AA N",JONN="JH AA N",HONN="HH AA N",["RICHARD'S"]="R IH CH ER D Z",BACKWATER="B AE K W AO T ER",LUCHT="L AH K T",SUPERAMERICA="S UW P ER AH M EH R IH K AH",UNAWARE="AH N AH W EH R",OFFENSES="AH F EH N S IH Z",LETHALITY="L IY TH AE L AH T IY",BURNEY="B ER N IY",EGGER="EH G ER",CRAYS="K R EY Z",LAUNDERED="L AO N D ER D",GRAYS="G R EY Z",TYPEFACE="T AY P F EY S",BJORGE="B Y AO R G",PRAYS="P R EY Z",TRAYS="T R EY Z",DEPRAVATION="D EH P R AH V EY SH AH N",LICHT="L IH K T",VELAYATI="V EH L AY AA T IY",SUSPICIOUSLY="S AH S P IH SH AH S L IY",PICHT="P IH K T",BLUEBONNETS="B L UW B AA N AH T S",["MASCARENA(2)"]="M AE K AH R IY N AH",LAKATOS="L AE K AH T OW Z",CHIARENZA="K IY AA R EH N Z AH",SMITH="S M IH TH",NOVOTNY="N AH V OW T N IY",CANN="K AE N",DANN="D AE N",SCHILDER="SH AY L D ER",MCDOW="M AH K D AW",DEALERSHIPS="D IY L ER SH IH P S",MINIMALLY="M IH N AH M AH L IY",SCHATZEL="SH AE T Z AH L",["LUANDA'S"]="L UW AA N D AH Z",KANN="K AE N",LANN="L AE N",MANN="M AE N",GIGER="G AY G ER",JOHNATHAN="JH AA N AH TH AH N",["NE(4)"]="N EY",HETEROZYGOUS="HH EH T ER AH Z AY G AH S",MONIT="M AA N AH T",LITURGICAL="L AH T ER JH IH K AH L",VIGER="V AY G ER",NORITA="N AH R IY T AH",MORITA="M AO R IY T AH",LORITA="L AO R IY T AH",GUIRE="G AY R",RESIDUAL="R IH Z IH JH UW AH L",NIGER="N AY JH ER",SPELLMEYER="S P EH L M AY ER",CAPECI="K AH P EH CH IY",["JEWELS(2)"]="JH UW L Z",["AFTERTHOUGHTS(2)"]="AE F T ER TH AO T S",SUIRE="S UH R",QUIRE="K W AY R",AUGUSTYNIAK="AW G AH S T IH N IY AE K",SYDOW="S IH D OW",PEWABIC="P Y UW AA B IH K",GULFSTREAM="G AH L F S T R IY M",["RWANDA'S"]="R AH W AA N D AH Z",FLAUNTING="F L AO N T IH NG",HOLEWINSKI="HH AH L UW IH N S K IY",["TCHAIKOVSKY'S(2)"]="CH AY K AA V S K IY Z",EQUATE="IH K W EY T",SCALLY="S K AE L IY",KAEHLER="K EH L ER",["DENMARK'S"]="D EH N M AA R K S",LEIFESTE="L AY F IH S T",["QUINN'S"]="K W IH N Z",INFLATES="IH N F L EY T S",PUNIT="P AH N IH T",KOZICKI="K AH Z IH T S K IY",DWIRE="D W AY R",THUNDERED="TH AH N D ER D",BEHAVIORISTS="B IH HH EY V Y ER IH S T S",EDGER="EH JH ER",ADGER="AE JH ER",MATTHEWSON="M AE TH Y UW S AH N",SWIRE="S W AY R",VANSCYOC="V AE N S IY AA K",GRATEFUL="G R EY T F AH L",MINTEER="M IH N T IH R",["ENTERTAINS(2)"]="EH N ER T EY N Z",KETCHEM="K EH CH IH M",DEGER="D IY G ER",FEGER="F IY G ER",["ROULETTE'S"]="R UW L EH T S",CRYSTER="K R AY S T ER",LEGER="L EH JH ER",WARDRIP="W AO R D R IH P",COUNTERFORCES="K AW N T ER F AO R S IH Z",MEGER="M EH G ER",HEGER="HH IY G ER",RASPBERRIES="R AE Z B EH R IY Z",SEGER="S IY G ER",WATERBEDS="W AO T ER B EH D Z",REGER="R IY G ER",JUNEJO="JH UW N EY HH OW",GOSNEY="G AA S N IY",WEGER="W IY G ER",ZEGER="Z IY G ER",BRANTLEY="B R AE N T L IY",MACHINIMA="M AH SH IY N IH M AH",["CONTESTS(4)"]="K AH N T EH S",PROFESSES="P R AH F EH S IH Z",IMPERIALIST="IH M P IH R IY AH L IH S T",PALERMO="P AH L EH R M OW",["COUSIN'S"]="K AH Z AH N Z",CHIARAMONTE="K IY AA R AA M OW N T IY",BERNI="B EH R N IY",ROYSTER="R OY S T ER",["IMPOSES(2)"]="IH M P OW Z IH Z",GLYCOMED="G L AY K OW M D",["LINEAR'S"]="L IH N IY ER Z",WEITH="W IY TH",CISNEY="S IH Z N IY",SILESIA="S IH L IY Z AH",HULLENDER="HH UW L EH N D ER",MORBIDLY="M AO R B AH D L IY",MATTHAU="M AE T HH AW",WELLBROCK="W EH L B R AH K",RETURNEES="R IH T ER N IY Z",SISNEY="S IH Z N IY",TEPPERMAN="T EH P ER M AH N",CHAGNON="CH AE G N AH N",PEPPERMAN="P EH P ER M AH N",RICHOUX="R IH SH UW",NOTEHOLDERS="N OW T HH OW L D ER Z",AUCTIONING="AO K SH AH N IH NG",["TELEVISION'S"]="T EH L AH V IH ZH AH N Z",["CARLSON'S"]="K AA R L S AH N Z",AWAYS="EY W EY Z",SUSCEPTIBILITY="S AH S EH P T AH B IH L AH T IY",STRADDLE="S T R AE D AH L",MOMENTARILY="M OW M AH N T EH R AH L IY",GILLIKIN="G IH L AH K AH N",MESIROW="M EH S IH R OW",COUSAR="K UW S AA R",["MINNESOTA'S"]="M IH N AH S OW T AH Z",VEITH="V IY TH",MITCHEM="M IH CH IH M",SEITH="S IY TH",REITH="R IY TH",SWAYS="S W EY Z",SENN="S EH N",TENN="T EH N",MANDALITE="M AE N D AH L AY T",VENN="V EH N",EAGER="IY G ER",PENN="P EH N",GAGER="G EY G ER",RENN="R EH N",HYDROGENS="HH AY D R AH JH AH N Z",HAGER="HH EY G ER",JAGER="JH EY G ER",MAGER="M AE G ER",["PARADOXICALLY(2)"]="P EH R AH D AA K S AH K AH L IY",SKATER="S K EY T ER",NAGER="N EY G ER",["VIGELAND'S"]="V AY G L AH N D Z",["ALL-PURPOSE"]="AO L P ER P AH S",SAGER="S EY G ER",RAGER="R EY G ER",TRADITION="T R AH D IH SH AH N",TAGER="T EY G ER",WAGER="W EY JH ER",YAGER="Y EY JH ER",MUKASEY="M Y UW K IH S IY",ZAGER="Z EY G ER",SUMMING="S AH M IH NG",SUBTITLE="S AH B T AY T AH L",CYCLICALS="S IH K L IH K AH L Z",SLATER="S L EY T ER",PLICHTA="P L IH CH T AH",CRISCI="K R IH S IY",FLATER="F L EY T ER",ELATER="EH L AH T ER",SEATER="S IY T ER",TEATER="T IY T ER",FRANZEL="F R AE N Z AH L",SANTIN="S AE N T IH N",YEATER="Y IY T ER",ENDOW="EH N D AW",TONYES="T OW N Y AH Z",["SWENSEN'S"]="S W EH N S AH N Z",LENHARD="L EH N ER D",WECHT="W EH K T",["NOEL'S"]="N OW EH L Z",HEATER="HH IY T ER",RECHT="R EH K T",RAUEN="R AW AH N",PECHT="P EH K T",ATTAINDER="AH T EY N D ER",SHYSTER="SH AY S T ER",STAMPS="S T AE M P S",PUBLICIST="P AH B L IH S IH S T",LONERO="L OW N EH R OW",FAITH="F EY TH",BULWARK="B UH L W ER K",DENN="D EH N",["OPEL'S"]="OW P AH L Z",FENN="F EH N",ALIRE="AA L IH R EY",CANTIN="K AA N T IY N",MARIOTTI="M AA R IY AO T IY",BENN="B EH N",KENN="K EH N",RAITH="R EY TH",MENN="M EH N",IKERD="IH K ER D",MANTEER="M AE N T IY R",JENN="JH EH N",SWAMPS="S W AA M P S",SHIRE="SH AY R",RANN="R AE N",CLAYS="K L EY Z",TANN="T AE N",VANN="V AE N",WANN="W AA N",EDITH="IY D IH TH",PLAYS="P L EY Z",["SARAGE'S"]="S AE R AH JH IH Z",["HONOR'S"]="AA N ER Z",MONASH="M AA N AE SH",RUDOW="R UW D OW",HAFEMAN="HH EY F M AH N",BLANCETT="B L AE N S IH T",PANTHERS="P AE N TH ER Z",HECHT="HH EH K T",PESSIN="P EH S IH N",TIEDEMAN="T IY D M AH N",LESSIN="L EH S IH N",UPTIGHT="AH P T AY T",GERGELY="JH ER JH L IY",["OPTION(2)"]="AO P SH AH N",GRUESOME="G R UW S AH M",KONTROLLBANK="K AA N T R AH L B AE NG K",VALENTINO="V AE L AH N T IY N OW",PHOTOGRAPHERS="F AH T AA G R AH F ER Z",GISU="JH IH S UW",FLUFFIEST="F L AH F IY AH S T",LESLIE="L EH S L IY",["OLSEN'S"]="OW L S AH N Z",WINGFIELD="W IH NG F IY L D",MARKETWIDE="M AA R K AH T W AY D",MINNESOTAN="M IH N AH S OW T AH N",ABSCONDING="AE B S K AA N D IH NG",DICKERED="D IH K ER D",["REITZFELD(2)"]="R AY T S F EH L D",REMOTEST="R IH M OW T AH S T",ALASKAMEN="AH L AE S K AH M AH N",DOUDNA="D AW D N AH",SKILLFULLY="S K IH L F AH L IY",WOLF="W UH L F",NUCORP="N UW K AO R P",THORNER="TH AO R N ER",SHELVED="SH EH L V D",NEWSUM="N UW Z AH M",ADAMCZAK="AA D AH M CH AE K",["MUSGRAVE'S"]="M AH S G R EY V Z",ABEYTA="AA B EY T AH",RIDEOUT="R AY D AW T",MAZANEC="M AH Z AE N IH K",WOODBECK="W UH D B EH K",PROPAGANDA="P R AA P AH G AE N D AH",DECOUPLE="D IY K AH P AH L",DANYLYSZYN="D AE N IH L IY Z IH N",HIDEOUT="HH AY D AW T",IGLESIA="IY G L EY S IY AH",["VIDOR(2)"]="V IH D AO R",LOFTIS="L AA F T IH S",COMPACTNESS="K AH M P AE K T N AH S",SOBCZYK="S AA B CH IH K",ASPEN="AE S P AH N",BELICH="B EH L IH K",PATERNALISM="P AH T ER N AH L IH Z AH M",["THRIFTS(2)"]="TH R IH F S",RUHLAND="R AH L AH N D",RIMPOCHET="R IH P OW CH IH T",LONGFIELD="L AO NG F IY L D",["BOREN'S"]="B AO R AH N Z",ATHANAS="EY TH AE N AH Z",LUYSTER="L AY S T ER",FLUXIONAL="F L AH K SH AH N AH L",["ALSACE(2)"]="AE L S AE S",MERRITT="M EH R IH T",ANDREW="AE N D R UW",SECATEURS="S EY K AH T ER Z",PIPETTER="P AY P EH T ER",["PROCEDURE(2)"]="P R OW S IY JH ER",PERRITT="P ER R IH T",BOTTINO="B OW T IY N OW",DELIBERATELY="D IH L IH B ER AH T L IY",["SMUGGLER'S"]="S M AH G L ER Z",["ACTIVE'S"]="AE K T IH V Z",FRAGONARD="F R AE G AH N ER D",ANDROGYNOUS="AE N D R AO JH AH N AH S",["GOLDSMITH'S"]="G OW L D S M IH TH S",WIENERS="W IY N ER Z",DOUGHTY="D AO T IY",["KILOMETRES(2)"]="K IH L AH M IY T ER Z",BARBOZA="B AA R B OW Z AH",NEPHEW="N EH F Y UW",ANGELICO="AA NG G EH L IY K OW",HEADQUARTERS="HH EH D K W AO R T ER Z",OBEYS="OW B EY Z",["TUDOR(2)"]="T Y UW D ER",STARTLINGLY="S T AA R T L IH NG L IY",BUGEYE="B AH G AY",MCNICHOLS="M AH K N IH K AH L Z",YOCUM="Y OW K AH M",MISINFORMS="M IH S IH N F AO R M Z",MACBETH="M AH K B EH TH",LUNCHROOM="L AH N CH R UW M",MONOCLATE="M AA N AH K L EY T",HESITATES="HH EH Z AH T EY T S",NAMBI="N AE M B IY",HANDSETS="HH AE N D S EH T S",CANISTERS="K AE N AH S T ER Z",OUTFITTER="AW T F IH T ER",HOORAY="HH UH R EY",UHLICH="UW L IH K",MALNUTRITION="M AE L N UW T R IH SH AH N",AHLF="AA L F",BOHLAND="B OW L AH N D",MIDAMERICA="M IH D AH M EH R IH K AH",["DANIELLE(2)"]="D AE N Y EH L",PROPOSALS="P R AH P OW Z AH L Z",["PUERTO_RICANS(2)"]="P AO R T AH R IY K AH N Z",KROWITZ="K R AW IH T S",SELF="S EH L F",RELF="R EH L F",EXTREMIST="EH K S T R IY M IH S T",ISON="IH S AH N",MCLERRAN="M AH K L EH R AH N",SCINTILLA="S IH N T IH L AH",DELAHUNT="D EH L AH HH AH N T",RECTANGLE="R EH K T AE NG G AH L",BLUBAUGH="B L AH B AO",KALMANOVITZ="K AE L M AE N AH V IH T S",TRON="T R AA N",["PARTNER'S"]="P AA R T N ER Z",MAHALA="M AE HH AH L AH",OUTSTANDINGLY="AW T S T AE N D IH NG L IY",PSYCHIC="S AY K IH K",KUEHNE="K UW N",SANSBURY="S AE N S B EH R IY",HRON="HH R AA N",ERON="IH R AA N",CRON="K R AA N",LANSBURY="L AE N Z B ER IY",KRON="K R AA N",["ADVANTAGE(4)"]="AH D V AE N AH JH",DOUBLY="D AH B L IY",SUON="S UW AO N",TROTH="T R OW TH",STYMIES="S T AY M IY Z",ARON="EH R AH N",SYNDROME="S IH N D R OW M",["INTERSECTS(3)"]="IH N T ER S EH K S",["ONE-WAY"]="W AH N W EY",THEONE="TH IY AA N",GROTH="G R AA TH",FROTH="F R AO TH",["MICKEY'LL"]="M IH K IY AH L",VERMILYEA="V ER M IY L Y AH",QUON="K W AA N",ORALLY="AO R AH L IY",BOBLITT="B AH B L IH T",ANALYSTS="AE N AH L AH S T S",GALEANO="G AA L IY N OW",BROTH="B R AO TH",NOBLITT="N AA B L IH T",DALLMANN="D AO L M AH N",TINKERERS="T IH NG K ER ER Z",EVACUEES="IH V AE K Y UW IY Z",BRESNAN="B R EH S N AH N",ETON="IY T AH N",["PLANET'S"]="P L AE N AH T S",STRUCTURED="S T R AH K CH ER D",HALF="HH AE F",TOON="T UW N",YOON="Y UW N",RESISTED="R IH Z IH S T IH D",RALF="R AA L F",ATON="AH T AA N",ASHLAND="AE SH L AH N D",MINISTERS="M IH N AH S T ER Z",GOON="G UW N",GIAMBALVO="JH AA M B AA L V OW",ANCESTRAL="AE N S EH S T R AH L",PERPETUITY="P ER P IH T Y UW IH T IY",JOON="JH UW N",MALDIVES="M AO L D AY V Z",VENTIMIGLIA="V EH N T IH M IH G L IY AH",NOON="N UW N",MOON="M UW N",LOON="L UW N",SOON="S UW N",POON="P UW N",TOOTH="T UW TH",KULHANEK="K AH L HH AH N EH K",OVIEDO="OW V IY EY D OW",COON="K UW N",BOON="B UW N",EXUDES="IH G Z UW D Z",TRIMARCO="T R IH M AA R K OW",CLANDESTINELY="K L AE N D EH S T AH N L IY",STRATOFLEX="S T R AE T OW F L EH K S",XANTIPPE="Z AE N T IH P",SANCTIFY="S AE NG K T AH F AY",BOOTH="B UW TH",["TARANTULAS(2)"]="T AH R AE N CH AH L AH Z",WAREHOUSED="W EH R HH AW Z D",CONSTANTLY="K AA N S T AH N T L IY",CUTTINO="K UW T IY N OW",KETTERER="K EH T ER ER",["SPRING'S"]="S P R IH NG Z",LIQUIDITIES="L IH K W IH D AH T IY Z",["GET-WELL"]="G EH T W EH L",KIRKBY="K ER K B IY",UPON="AH P AA N",ESPEJO="EY S P EY Y OW",MADRUGA="M AE D R UW G AH",ESCANDON="IH S K AE N D AH N",MERITED="M EH R IH T IH D",CHATMON="CH AE T M AH N",["DONALD'S"]="D AA N AH L D Z",MANILA="M AH N IH L AH",MANGRUM="M AE NG G R AH M",["NAZI'S"]="N AA T S IY Z",["BIHAC'S"]="B IY HH AA CH IH Z",TASTELESS="T EY S T L AH S",JIMMIED="JH IH M IY D",WHITLEDGE="W IH T L EH JH",QUOTH="K W OW TH",DIURNALLY="D AY ER N AH L IY",ELDRIDGE="EH L D R IH JH",["YODELING(2)"]="Y OW D L IH NG",PETRALIA="P EH T R AA L IY AH",ALDRIDGE="AO L D R IH JH",INCONVENIENCES="IH N K AH N V IY N Y AH N S IH Z",CORDAY="K AO R D EY",GIETZEN="G IY T Z AH N",RIVERHEAD="R IH V ER HH EH D",WILLMANN="W IH L M AH N",KRAJICEK="K R AY IH CH EH K",BUNTIN="B AH N T IH N",JONESES="JH OW N Z IH Z",BARTNIK="B AA R T N IH K",["ZARROLI'S"]="Z ER OW L IY Z",RADIATES="R EY D IY EY T S",TECHNICAL="T EH K N IH K AH L",["CENTERRE'S"]="S EH N T ER Z",RECOUNTED="R IH K AW N T IH D",BELSKY="B EH L S K IY",HEGLAND="HH EH G L AH N D",BUOYING="B OY IH NG",COSENZA="K OW S EH N Z AH",SCIARRINO="SH ER IY N OW",ETUDES="EY T UW D Z",WOHLFARTH="W OW L F AA R TH",CAPEN="K EY P AH N",BRAID="B R EY D",ROADSIDES="R OW D S AY D Z",WHERLEY="W ER L IY",SUMMONSES="S AH M AH N Z IH Z",BIERLEY="B IH R L IY",DANTZLER="D AE N T S L ER",JITTERBUG="JH IH T ER B AH G",FITTERER="F IH T ER ER",TINDERBOX="T IH N D ER B AA K S",["DOMINION'S"]="D AH M IH N Y AH N Z",SEDUM="S EH D AH M",SYLVANIA="S IH L V EY N IY AH",CALORIE="K AE L ER IY",VANDERCOOK="V AE N D ER K UH K",ALCHEMIST="AE L CH AH M IH S T",HILLMANN="HH IH L M AH N",NATUREDLY="N EY CH ER D L IY",CYCLOSTOME="S AY K L AH S T OW M",NAUGHTY="N AO T IY",["TUBERCULOSIS(3)"]="T UW B ER K Y UW L OW S AH S",HAMSTRA="HH AE M S T R AH",STACKER="S T AE K ER",CARILLON="K EH R AH L AA N",USAID="Y UW EH S EY D",NEGROS="N IY G R OW Z",SHERLEY="SH ER L IY",REWATCHING="R IY W AA CH IH NG",ALAMODOME="AE L AH M OW D OW M",["MODELING(2)"]="M AA D L IH NG",ELIMINATION="IH L IH M AH N EY SH AH N",FRYBERGER="F R AY B ER G ER",KOVACICH="K AH V AA CH IH HH",DEFEATISM="D IH F IY T IH Z AH M",BRANNIGAN="B R AE N IH G AH N",STAID="S T EY D",SCHOOLEY="S K UW L IY",WHITEHILL="W AY T HH IH L",PATRICIAN="P AH T R IH SH AH N",BIRCHARD="B ER K ER D",["SEMIPRECIOUS(2)"]="S EH M IH P R EH SH AH S",VENERABLE="V EH N ER AH B AH L",APPENDED="AH P EH N D IH D",SCHNUR="SH N ER",SILVADIO="S IH L V AA D IY OW",["SAMURAIS(2)"]="S AE M ER IH Z",MOCKINGBIRD="M AA K IH NG B ER D",QUAID="K W EY D",["TAXPAYER'S"]="T AE K S P EY ER Z",["NATURAL(2)"]="N AE CH R AH L",FORECAST="F AO R K AE S T",OUTSELL="AW T S EH L",AMEZQUITA="AA M EH Z K W IY T AH",["JENNIFER'S"]="JH EH N AH F ER Z",HUTSELL="HH AH T S AH L",MORESO="M AO R EH S OW",["SEMICYLINDRICAL(3)"]="S EH M AY S AH L IH N D R IH K AH L",SIMSBURY="S IH M Z B EH R IY",FLANNIGAN="F L AE N IH G AH N",SCOGGIN="S K AA G IH N",BORCHARD="B ER SH AA R D",FROGMOUTH="F R AA G M AW TH",["KARADZIC'S"]="K AA R AA JH IH K S",TREGONING="T R EH G AH N IH NG",RINN="R IH N",SINN="S IH N",["HANDEL'S"]="HH AE N D AH L Z",ACCOUNTED="AH K AW N T AH D",LINN="L IH N",HOSNI="HH OW Z N IY",LIPARI="L IY P AA R IY",BRANNAM="B R AE N AH M",PINN="P IH N",["SELF-DORMANT"]="S EH L F D AO R M AH N T",KNITTEL="N IH T AH L",SOMALIS="S AH M AA L IY Z",TIMMENY="T IH M AH N IY",BAGELAND="B EY G AH L AE N D",BEASTIE="B IY S T IY",KUMQUAT="K AH M K W AA T",SWERGOLD="S W ER G OW L D",CRUDES="K R UW D Z",RHINESTONE="R AY N S T OW N",DINARDO="D IH N AA R D OW",MANIFESTATIONS="M AE N AH F EH S T EY SH AH N Z",HOGELAND="HH AA G IH L AH N D",VALERIANO="V AA L ER IY AA N OW",NESTLINGS="N EH S T L IH NG Z",GULF="G AH L F",["O'REILLY"]="OW R AY L IY",EMSLIE="EH M S AH L IY",["COUNTERPARTS(2)"]="K AW N ER P AA R T S",NOVACK="N AA V AH K",KOVACK="K AA V AH K",MCQUEENEY="M AH K W IY N IY",PHILIPPINE="F IH L AH P IY N",SMOTHERS="S M AH DH ER Z",ROLFS="R OW L F S",WULF="W UH L F",PRANKSTERS="P R AE NG K S T ER Z",VINEYARD="V IH N Y ER D",["BICYCLISTS(2)"]="B AY S IH K L IH S",["MUNFORD'S"]="M AH N F ER D Z",BLOWY="B L OW IY",PROPULSION="P R AH P AH L SH AH N",INTERCEPTIONS="IH N T ER S EH P SH AH N Z",ECON="IY K AA N",THETIS="TH IY T AH S",["VENDOR'S"]="V EH N D ER Z",LEON="L IY AA N",FLEITAS="F L AY T AH S",NEON="N IY AA N",HEON="HH IY AH N",GEON="JH IY AA N",VALIANTLY="V AE L Y AH N T L IY",MENESES="M EY N EY S EH S",STRENG="S T R EH NG",PEON="P IY AH N",["STUFF-IT'S"]="S T AH F IH T S",["BARING'S"]="B EH R IH NG Z",BATTERER="B AE T ER ER",ENGINEERING="EH N JH AH N IH R IH NG",["BIOCHEMICAL(2)"]="B AY OW K EH M IH K AH L",NOTIFICATIONS="N OW T AH F AH K EY SH AH N Z",CLAMPITT="K L AH M P IH T",["PROTESTS(4)"]="P R AH T EH S",HAREBRAINED="HH EH R B R EY N D",["GOTTLIEB'S"]="G AA T L IY B Z",RECOMBINANT="R IH K AA M B IH N AH N T",LODGINGS="L AA JH IH NG Z",AESTHETICS="EH S TH EH T IH K S",["POSTMASTERS(2)"]="P OW S M AE S T ER Z",ANTHROPOMORPHIC="AE N TH R AH P AH M AO R F IH K",OVERALL="OW V ER AO L",DOWNLOAD="D AW N L OW D",DEON="D IY AA N",CENTRIFUGE="S EH N T R AH F Y UW JH",SNOWY="S N OW IY",DISORDER="D IH S AO R D ER",CHALLENGERY="CH AE L AH N JH ER IY",DENARDO="D IH N AA R D OW",LAURENE="L AO R IY N",["ENABLE(2)"]="IH N EY B AH L",GALOSH="G AH L AA SH",CURFMAN="K ER F M AH N",BREWINGTON="B R UW IH NG T AH N",ARMBANDS="AA R M B AE N D Z",NATURALISTS="N AE CH ER AH L IH S T S",PLAID="P L AE D",TRUSCOTT="T R AH S K AH T",NAVRATILOVA="N AE V R AE T IH L OW V AH",OPENERS="OW P AH N ER Z",ADON="AA D AO N",AIRCOA="EH R K OW AH",LICAUSI="L IY K AO S IY",MANLOVE="M AE N L AH V",RAGLAND="R AE G L AH N D",["PREDICTS(4)"]="P R IY D IH K S",UNMATCHED="AH N M AE CH T",KUKJE="K UW K Y IH",PAIUTE="P AY Y UW T",JULIETTE="JH UW L IY EH T",["MCDERMOTT'S"]="M AH K D ER M AH T S",INDEMNIFYING="IH N D EH M N IH F AY IH NG",CADOTTE="K AH D AO T",BEARISHNESS="B EH R IH SH N AH S",FOCHT="F AA K T",["BARNABY'S"]="B AA R N AH B IY Z",CRESPIN="K R EH S P IH N",SPREITZER="S P R AY T Z ER",PRELATES="P R EH L IH T S",INVALUABLE="IH N V AE L Y AH B AH L",DOLF="D OW L F",TAPAS="T AH P AH S",PAPAS="P AA P AH Z",NOLF="N OW L F",BETTINO="B EH T IY N OW",SKATE="S K EY T",ROLF="R OW L F",GOLF="G AA L F",VIGELAND="V AY G L AH N D",HELLMANN="HH EH L M AH N",OVERQUALIFIED="OW V ER K W AA L AH F AY D",["ZAIRIAN'S"]="Z AY IH R IY AH N Z",CARROTHERS="K AE R AH DH ER Z",DRAFFEN="D R AE F AH N",KOLSKY="K OW L S K IY",ACCOMPANIST="AH K AH M P AH N AH S T",ROKICKI="R AH K IH K IY",POLSKY="P OW L S K IY",ENCYCLOPEDIC="IH N S AY K L AH P IY D IH K",["SPOOR'S"]="S P UH R Z",REVELLER="R EH V AH L ER",LEEN="L IY N",ELATE="IH L EY T",REEN="R IY N",SEEN="S IY N",TEEN="T IY N",VEEN="V IY N",PHONEMATE="F OW N M EY T",["DIRE(2)"]="D AY ER",ATTRITION="AH T R IH SH AH N",["POSTMASTER(2)"]="P OW S M AE S T ER",DEEN="D IY N",CERF="S ER F",["MIRE(2)"]="M AY ER",KEEN="K IY N",EARLYWINE="ER L IY W AY N",PROSCIA="P R OW S CH AH",BLOCKADES="B L AA K EY D Z",MARGARETA="M AA R G AA R EH T AH",BERTOLI="B ER T OW L IY",GEORGIANS="JH AO R JH AH N Z",MAUNEY="M AO N IY",WORLDVISION="W ER L D V IH ZH AH N",SLATE="S L EY T",LASALA="L AA S AA L AH",PLATE="P L EY T",CORBELL="K AO R B EH L",ANDREEN="AH N D R IY N",["ZOOT-SUIT"]="Z UW T S UW T",SPERRFRIST="S P EH R F R IH S T",["TRANSACTION'S"]="T R AE N Z AE K SH AH N Z",FUNARI="F UW N AA R IY",DELFS="D EH L F S",CROCKFORD="K R AA K F ER D",STAMBERG="S T AE M B ER G",ANNAUD="AH N OW D",BUNDESPOST="B UH N D IH S P OW S T",PEMBINA="P EH M B IH N AH",MALTER="M AO L T ER",GROEN="G R OW N",VOLUME="V AA L Y UW M",BALTER="B AO L T ER",WALTER="W AO L T ER",RANCHO="R AE N CH OW",PANCHO="P AE N CH OW",SHEN="SH EH N",VEMICH="V EH M IH CH",PHEN="F EH N",WHEN="W EH N",CEREGHINO="CH ER EH G IY N OW",THEN="DH EH N",SALTER="S AO L T ER",SANCHO="S AA N K OW",GANGEMI="G AA NG G EH M IY",CHEN="CH EH N",CANGEMI="K AA NG G EH M IY",ARSENIO="AA R S IY N IY OW",NUTRITION="N UW T R IH SH AH N",MILOSH="M IH L AO SH",SAWICKI="S AO IH T S K IY",["ELVIS'S"]="EH L V IH S IH Z",BURLATSKY="B ER L AE T S K IY",COUNTERFORCE="K AW N T ER F AO R S",CAEN="K AE N",FRUGAL="F R UW G AH L",MAILERS="M EY L ER Z",["NATURALIZING(2)"]="N AE CH R AH L AY Z IH NG",MAIREAD="M EY R EH",JAILERS="JH EY L ER Z",["MUHAMMED'S"]="M UH HH AA M EH D Z",TURBINEN="T ER B IH N AH N",FOWLKES="F AW L K S",PRZYBYSZ="P ER Z IH B IH SH",WHATE="W EY T",CONVERTIBLES="K AH N V ER T AH B AH L Z",AFIRE="AH F AY R",SLONIKER="S L AA N IH K ER",BERNADENE="B ER N AH D IY N",["WHITENACK(2)"]="HH W AY T N AE K",HANGUP="HH AE NG G AH P",UNFURLING="AH N F ER L IH NG",OFFSHORED="AO F SH AO R D",RAILCARS="R EY L K AA R Z",GRATE="G R EY T",FRATE="F R EY T",GOLKAR="G OW L K AA R",TOMANEK="T AA M AH N IH K",CRATE="K R EY T",SICOTTE="S IH K AO T",PICOTTE="P IH K AO T",DUBROVNIK="D UW B R AA V N IH K",WARRANTS="W AO R AH N T S",BLANKENBURG="B L AE NG K AH N B ER G",CAIRE="K EH R",LIEBL="L IY B AH L",LONARDO="L OW N AA R D OW",FAIRE="F EH R",EARLIE="ER L IY",ODEN="OW D AH N",THACKER="TH AE K ER",LILIENTHAL="L IH L IY N TH AH L",WHACKER="W AE K ER",DRACHMAS="D R AA K M AH Z",PRECHTL="P R EH K T AH L",QURESHI="K UH R EY SH IY",CROSSTALK="K R AO S T AO K",SYNONYMOUS="S AH N AA N AH M AH S",COUNTERATTACKED="K AW N T ER AH T AE K T",IMREG="IH M R EH G",REFORMER="R IH F AO R M ER",OVERHEADS="OW V ER HH EH D Z",IDEN="AY D AH N",FORTIFICATIONS="F AO R T AH F AH K EY SH AH N Z",EDEN="IY D AH N",SQUIRTING="S K W ER T IH NG",AMPERAGE="AE M P ER IH JH",SCIRE="S AY R",AMEN="EY M EH N",OTTOSON="AA T AH S AH N",["CARPE-DIEM"]="K AA R P AH D IY AH M",KERCHEVAL="K ER CH IH V AH L",["CLERGYMEN(2)"]="K L ER JH IY M EH N",OMEN="OW M AH N",SUBVERTING="S AH B V ER T IH NG",TRACKER="T R AE K ER",FAWLEY="F AO L IY",RENAUD="R IH N OW",NIAID="N AY EY D",GILKISONS="G IH L K IH S AH N Z",LAWLEY="L AO L IY",STADIA="S T EY D IY AH",KESTENBAUM="K EH S AH N B AW M",HEICHEL="HH AY K AH L",JERELD="JH EH R IH L D",LILLIPUTIAN="L IH L AH P Y UW SH AH N",PINHO="P IH N HH OW",REICHEL="R AY K AH L",BRACKER="B R AE K ER",CRACKER="K R AE K ER",WEICHEL="W AY K AH L",["SUPPLIER'S"]="S AH P L AY ER Z",MCTAVISH="M AH K T EY V IH SH",["BARCLAY(2)"]="B AA R K L IY",SCHARP="SH AA R P",PAWLEY="P AO L IY",RAWLEY="R AO L IY",HOEN="HH OW N",GUMBI="G AH M B IY",GOEN="G OW N",MOEN="M OW N",KOEN="K OW N",SHEDRICK="SH EH D R IH K",SPILOTRO="S P IH L AA T R OW",BOEN="B OW N",SCHONE="SH OW N",HUMILIATION="HH Y UW M IH L IY EY SH AH N",SHRIEKS="SH R IY K S",SURPRISING="S ER P R AY Z IH NG",["MENDEL'S"]="M EH N D AH L Z",["GREENFELD'S"]="G R IY N F EH L D Z",ROEN="R OW N",DIEDRICK="D IY D R IH K",HALLUCINATORY="HH AH L UW S AH N AH T AO R IY",CZECHOWSKI="CH IH HH AO F S K IY",MARSCHALK="M AA R SH AO K",SLACKER="S L AE K ER",BODICES="B AA D IH S IH Z",FIGURE="F IH G Y ER",ORTHOPEDIST="AO R TH AH P IY D AH S T",ONATE="OW N EY T",ISACKSON="IH S AH K S AH N",REMAKE="R IY M EY K",BURKART="B ER K AA R T",OPEN="OW P AH N",PHAROS="F EH R OW Z",QUESINBERRY="K W EH S IH N B EH R IY",KLOIBER="K L OY B ER",GOODISON="G UH D IH S AH N",["ALSBROOK'S"]="AE L Z B R UH K S",SOLICITS="S AH L IH S AH T S",["OURSELVES(2)"]="AA R S EH L V Z",ABIMAELS="AE B IH M EY L Z",VIEN="V IY N",["GERE(2)"]="JH IH R IY",COPAS="K OW P AH Z",TIEN="T Y EH N",MIEN="M IY N",OIEN="AA IY N",KOPAS="K OW P AH Z",["BOJANGLES'"]="B OW JH AE NG G AH L Z",COATE="K OW EY T",SHOWY="SH OW IY",DORSALLY="D AO R S AH L IY",["REDUCTION(2)"]="R IY D AH K SH AH N",SHINRIKYO="SH IH N R IY K Y OW",["WALESA'S(2)"]="V AH L EH S AH Z",MCHONE="M AH K OW N",SPATE="S P EY T",CADORETTE="K AE D ER EH T",MOURNERS="M AO R N ER Z",["OLOFSON'S"]="AA L AH F S AH N Z",HYPNOTIC="HH IH P N AA T IH K",DOUBLETREE="D AH B AH L T R IY",FRUCHTMAN="F R AH K T M AH N",PORRITT="P AO R IH T",AKEN="EY K AH N",PFLEIDERER="F L AY D ER ER",DORF="D AO R F",AURELIO="AW R EY L IY OW",LEBENTHAL="L EH B AH N TH AO L",SHORTER="SH AO R T ER",PUTNEY="P AH T N IY",BAEZA="B IY Z AH",OKEN="OW K EY AH N",NISHIZAWA="N IY SH IH Z AA W AH",CLOISTERS="K L OY S T ER Z",INFORMER="IH N F AO R M ER",GLEN="G L EH N",ACHIEVES="AH CH IY V Z",NEURONS="N UH R AA N Z",KORF="K AO R F",STOCKFORD="S T AA K F ER D",OLEN="AA L AH N",SVORAY="S V AO R EY",["KIGALI'S"]="K IY G AA L IY Z",GERVASI="JH ER V AA S IY",COSSIN="K AA S IH N",STRAIGHTENS="S T R EY T AH N Z",REINTERPRETED="R IY IH N T ER P R AH T IH D",OKON="OW K OW N",SUEN="S UW N",ROSSIN="R AA S IH N",DENOMINATIONAL="D IH N AO M AH N EY SH AH N AH L",IKON="AY K AA N",PLEISTOCENE="P L AY S T AH S IY N",YUEN="Y W EH N",IPHONE="AY F OW N",PROGRESSIVELY="P R AA G R EH S IH V L IY",CREHAN="K R EH HH AH N",PACCAR="P AH K AA R",COMBEE="K AA M B IY",SPEEDSKATE="S P IY D S K EY T",IVEN="AY V AH N",["MORNING'S"]="M AO R N IH NG Z",OVEN="AH V AH N",IRRITATES="IH R IH T EY T S",LOWNDES="L OW N D IY Z",PURPORTEDLY="P ER P AO R T IH D L IY",EXCHANGES="IH K S CH EY N JH AH Z",["CORNING'S"]="K AO R N IH NG Z",HANDSHAKES="HH AE N D SH EY K S",GRUPPO="G R UW P OW",GWEN="G W EH N",EWEN="Y UW AH N",IWEN="IH W AH N",OWEN="OW AH N",CERTIFICATIONS="S ER T AH F AH K EY SH AH N Z",FILIPA="F IY L IY P AH",EASTHAM="IY S T AH M",VANDERHOOF="V AE N D ER HH UH F",CORNERSTONES="K AO R N ER S T OW N Z",AMON="AA M AO N",["MCLARTY'S"]="M AH K L AA R T IY Z",LOCKEY="L AA K IY",PHILOMELA="F IH L AH M IY L AH",BRACKET="B R AE K IH T",ROCKEY="R AA K IY",STAWICKI="S T AA V IH T S K IY",OXEN="AA K S AH N",LONGANECKER="L AA NG G AH N EH K ER",MONTROUIS="M AA N T R UW IY",MULLIKIN="M AH L IH K IH N",CONOLLY="K AA N OW L IY",PARISHIONERS="P ER IH SH AH N ER Z",BRUNEY="B R UW N IY",COCKEY="K AA K IY",UNADULTERATED="AH N AH D AH L T ER EY T IH D",TELEVISON="T EH L IH V IH ZH AH N",ALON="AH L AA N",KULICH="K Y UW L IH K",BOILERS="B OY L ER Z",DISSECTIONS="D AY S EH K SH AH N Z",MUMPHREY="M AH M F R IY",PUMPHREY="P AH M F R IY",AERITALIA="EH R IH T AE L Y AH",MICRONESIA="M AY K R OW N IY ZH AH",HUMPHREY="HH AH M F R IY",INDICES="IH N D IH S IY Z",BURRITT="B ER IH T",BOYACK="B OY AH K",EGON="IY G AH N",SAFARIK="S AE F ER IH K",AMORTIZE="AE M ER T AY Z",IGON="AY G AH N",OVERSTROM="OW V ER S T R AA M",TUESDAYS="T UW Z D EY Z",PUSSYCAT="P UH S IY K AE T",HOMEOSTASIS="HH OW M IY OW S T EY S AH S",NAPHTHALENE="N AE F TH AH L IY N",AREN="AA R AH N",MENDOSA="M EH N D OW S AH",KREN="K R EH N",SORLIE="S AO R L IY",GREN="G R EH N",NIGHSWONGER="N AY S W AO NG ER",SEVERTSON="S EH V ER T S AH N",["MERCEDES'S"]="M ER S EY D IY Z",UREN="ER EH N",["SPECIALIST(2)"]="S P EH SH AH L IH S T",ANACKER="AE N AH K ER",QUINON="K W IH N AH N",DUPLICITOUS="D UW P L IH S IH T AH S",ZION="Z AY AH N",VELOCIRAPTOR="V AH L AO S AH R AE P T ER",PERUGINA="P EH R UW JH IY N AH",RION="R AY AH N",POTENZA="P OW T EH N Z AH",WION="W AY AH N",DEFORREST="D EY F AO R IH S T",KNOTH="N AA TH",ATTEBURY="AE T B EH R IY",MION="M AY AH N",LION="L AY AH N",ABATE="AH B EY T",ORLICH="AO R L IH K",PILFERING="P IH L F ER IH NG",DION="D AY AH N",ERLICH="ER L IH K",ULTIMATUM="AH L T AH M EY T AH M",ATEN="EY T AH N",SHON="SH AA N",THON="TH AA N",KENMARE="K EH N M EH R",MAHAYANA="M AA HH AH Y AA N AH",BOUCHARD="B UW SH AA R D",CELESTINO="CH EH L EH S T IY N OW",STEN="S T EH N",["FUNARO'S"]="F UW N AA R OW Z",CHON="CH AA N",["CORPUS-CHRISTI"]="K AO R P AH S K R IH S T IY",TEATE="T IY EY T",SLOTH="S L OW TH",["VIRTUALLY(2)"]="V ER CH UW L IY",TOLERABLE="T AA L ER AH B AH L",BURCHARD="B ER SH AA R D",MEDCALF="M EH D K AE L F",KLOTH="K L AA TH",DELOSH="D EH L AH SH",LEHENBAUER="L EY AH N B AW ER",OUTLOOKS="AW T L UH K S",EVERIDGE="EH V ER IH JH",["VOWELS(2)"]="V AW L Z",LETOURNEAU="L EH T UH R N OW",RYSKAMP="R AY S K AE M P",["TOWELS(2)"]="T AW L Z",ISENSEE="AY Z AH N S IY",DEFRAYS="D IH F R EY Z",BECHLER="B EH K L ER",AGORA="AE G ER AH",ROMANOSKI="R AH M AH N AW S K IY",HECHLER="HH EH K L ER",["BOWELS(2)"]="B AW L Z",MECHLER="M EH K L ER",NORTHAMPTON="N AO R TH AE M P T AH N",SOLUTION="S AH L UW SH AH N",SECHLER="S EH K L ER",REGALIA="R IH G EY L Y AH",MISGUIDE="M IH S G AY D",["FINANCIAL'S(2)"]="F IH N AE N SH AH L Z",NISSIN="N IH S IH N",CARGAL="K AA R G AE L",TIPPETS="T IH P IH T S",LEGITIMIZE="L AH JH IH T AH M AY Z",["CONTENDS(2)"]="K AH N T EH N Z",QUIXOTE="K IY HH OW T IY",SHAPIRO="SH AH P IH R OW",RHYMED="R AY M D",["BLUESY(2)"]="B L UW AH S IY",THORA="TH AO R AH",PATHOLOGICAL="P AE TH AH L AA JH IH K AH L",LEORA="L EH R AH",PUUSEPP="P UW Z AH P",IRONIZE="AY ER N AY Z",["PROPORTIONALLY(2)"]="P R AH P AO R SH N AH L IY",STACEY="S T EY S IY",OLAUGHLIN="OW L AO K L IH N",RUBICAM="R UW B IH K AH M",SINKHORN="S IH NG K HH ER N",BRACEY="B R EY S IY",ANORA="AA N AO R AH",ZEMANEK="Z EH M AH N IH K",CONSERVING="K AH N S ER V IH NG",FRONTRUNNERS="F R AH N T R AH N ER Z",ROSEBORO="R OW Z B ER OW",LUGUARDA="L UW G AA R D AH",OCALLAGHAN="OW K AE L AH G AH N",HOPELESSNESS="HH OW P L AH S N AH S",["POSTMARKED(2)"]="P OW S M AA R K T",REVITALIZE="R IY V AY T AH L AY Z",WARF="W AO R F",KOLICH="K AA L IH HH",FLORINI="F L AO R IY N IY",EDOARDO="EH D W AA R D OW",POLICH="P AA L IH K",BICHLER="B IH K AH L ER",SKORA="S K AO R AH",BOIPATONG="B OY P AH T AO NG",OBERLANDER="OW B ER L AH N D ER",SNEERINGER="S N IH R IH N JH ER",BARTOLI="B AA R T OW L IY",METAGOGUE="M EH T AH G AO G",HOLLMANN="HH AA L M AH N",SELFS="S EH L F S",BOLICH="B AA L IH K",PICHLER="P IH CH L ER",TRACEY="T R EY S IY",SIGHTING="S AY T IH NG",DVORSKY="D V AO R S K IY",MURIHURO="M UH R IY HH UH R OW",RESIDENT="R EH Z IH D AH N T",LIGHTING="L AY T IH NG",RESTROOMS="R EH S T R UW M Z",LONERGAN="L AA N ER G AH N",PRONOUNS="P R OW N AW N Z",KONECNY="K AH N EH K N IY",SWEETENING="S W IY T AH N IH NG",["CONSORTIUMS(2)"]="K AH N S AO R SH Y AH M Z",MINDSETS="M AY N D S EH T S",DWORSKY="D W ER S K IY",["BEREGOVOY(2)"]="B EH R AH G OW V OY",AIRLIE="EH R L IY",MILICH="M IH L IH K",CHALMETTE="SH AE L M EH T",SPACEY="S P EY S IY",["DONOVAN'S"]="D AA N AH V AH N Z",DILLION="D IH L Y AH N",["WHINERY(2)"]="HH W AY N ER IY",BILLION="B IH L Y AH N",GALLACHER="G AE L AH K ER",MINARIK="M IH N ER IH K",SEQUESTERS="S IH K W EH S T ER Z",FREDERICKS="F R EH D R IH K S",ELKIND="IH L K AY N D",RESPECTFUL="R IH S P EH K T F AH L",BUTTERY="B AH T ER IY",["MAGICALLY(2)"]="M AE JH IH K L IY",PARTICIPATE="P AA R T IH S AH P EY T",GRENADA="G R IH N EY D AH",CONSTANCY="K AA N S T AH N S IY",SLINKY="S L IH NG K IY",MURMUR="M ER M ER",PEACEABLE="P IY S AH B AH L",ORCHARD="AO R CH ER D",ECCENTRICITIES="EH K S EH N T R IH S IH T IY Z",GLOOMIER="G L UW M IY ER",ZILLION="Z IH L Y AH N",KRENZER="K R EH N Z ER",REDID="R IY D IH D",MOONEYHAN="M UW N IY HH AH N",LUSTGARTEN="L AH S T G AA R D AH N",HASHEMITE="HH AE SH AH M AY T",PUGMIRE="P AH G M AY R",MILLION="M IH L Y AH N",JILLION="JH IH L Y AH N",KILLION="K IH L Y AH N",WADSWORTH="W AA D Z W ER TH",FUNDORA="F UW N D AO R AH",CARMACK="K AA R M AH K",MUSEUM="M Y UW Z IY AH M",SURVEYOR="S ER V EY ER",BRASCADE="B R AH S K EY D",PURVEYOR="P ER V EY ER",GRADUATING="G R AE JH AH W EY T IH NG",["CORPORATE(2)"]="K AO R P R AH T",HOMICIDE="HH AA M AH S AY D",CRUZADO="K R UW Z AA D OW",["PUZZLING(2)"]="P AH Z L IH NG",["JUSTIN(2)"]="JH AH S T IH N",OUTDID="AW T D IH D",SODERGREN="S AA D ER G R EH N",MAYTAG="M EY T AE G",["BOCCE(2)"]="B OW K AH",REUTER="R OY T ER",PINCHING="P IH N CH IH NG",SCHEDULERS="S K EH JH UH L ER Z",NEUTER="N UW T ER",["SNOUT'S"]="S N AW T S",WEIGHTLIFTING="W EY T L IH F T IH NG",WARMACK="W AO R M AE K",BLUNCK="B L AH NG K",WILLADSEN="W IH L AE D S AH N",MARROU="M AH R UW",AUTORADS="AO T OW R AE D Z",GRIEBEL="G R IY B AH L",KRIEBEL="K R IY B AH L",ATTABOY="AE T AH B OY",BRIDGMAN="B R IH JH M AH N",ABACHA="AE B AH K AH",CURTAILS="K ER T EY L Z",AIDID="AY D IY D",ASCHOFF="AE S K HH AO F",EVENED="IY V AH N D",SWACKHAMER="S W AO K AE M ER",["ERUPTS(2)"]="IH R AH P T S",HEADRICK="HH EH D R IH K",CHERNIN="CH ER N IH N",UNKIND="AH N K AY N D",ALKENE="AE L K IY N",DORAZIO="D AO R AA Z IY OW",CRIPPLING="K R IH P AH L IH NG",SHADRICK="SH AE D R IH K",MAJESTIC="M AH JH EH S T IH K",ALFAVILLI="AE L F AH V IH L IY",KNITWEAR="N IH T W EH R",SHANNAHAN="SH AE N AH HH AE N",BUNCHING="B AH N CH IH NG",QUASAR="K W EY Z AA R",MUNCHING="M AH N CH IH NG",LUNCHING="L AH N CH IH NG",MIKULAK="M IH K UW L AH K",["ABOUT'S"]="AH B AW T S",HOAGIE="HH OW G IY",TAMBURO="T AA M B UH R OW",CERTIFICATES="S ER T IH F IH K AH T S",LAUTER="L AW T ER",RECONSIDERED="R IY K AH N S IH D ER D",FINGERTIP="F IH NG G ER T IH P",BELTH="B EH L TH",["GRANDSON'S"]="G R AE N D S AH N Z",CHERNOBYL="CH ER N OW B AH L",STOCKSLAGER="S T AA K S L EY G ER",MULNIX="M AH L N IH K S",ABSENCES="AE B S AH N S IH Z",CHAIRMANSHIPS="CH EH R M AH N SH IH P S",WINCHEL="W IH N K AH L",["PETERSEN'S"]="P IY T ER S AH N Z",JUSTIS="Y UW S T IH S",CHIPCOM="CH IH P K AA M",["RIGID(2)"]="R IH JH IH D",LACLEDE="L AA K L IY D",EUSTIS="Y UW S T AH S",CUSTIS="K AH S T IH S",STINKY="S T IH NG K IY",IVANYENKO="AY V AH N Y EH N K OW",["COSATU'S"]="K AH S AA T UW Z",CAUTHORN="K AO TH ER N",BIENNIAL="B AY EH N IY AH L",BAECKER="B EH K ER",INVOICES="IH N V OY S IH Z",ALFIERO="AE L F IY EH R OW",["JAROMIR(2)"]="Y AA R AH M IH R",["WITH(2)"]="W IH TH",MCDOWELL="M AH K D AW AH L",WRECKAGE="R EH K AH JH",BARNY="B AA R N IY",INGMIRE="IH NG M AY R",KAYLIE="K EY L IY",CHIRPY="CH ER P IY",GRACES="G R EY S IH Z",["STALIN'S"]="S T AA L IH N Z",TRACES="T R EY S AH Z",["DOROTHY'S"]="D AO R AH TH IY Z",SMARTED="S M AA R T AH D",["RESORTED(2)"]="R IY Z AO R T IH D",ALLBRITTEN="AE L B R IH T AH N",CENCALL="S EH N S EH L",LOUANNE="L UW AE N",["COMCAST'S"]="K AA M K AE S T S",ANGELICALLY="AE N JH EH L IH K L IY",UNCERTAINTIES="AH N S ER T AH N T IY Z",CREPEAU="K R IH P OW",ACCIDENTS="AE K S AH D AH N T S",ROTHFUSS="R AO TH F AH S",STRAVINSKY="S T R AH V IH N S K IY",["GRUNDFEST(2)"]="G R UH N D F EH S T",BRACES="B R EY S AH Z",SEROKA="S EH R OW K AH",SHARBONO="SH AA R B OW N OW",JITTERY="JH IH T ER IY",FERROFLUIDICS="F EH R OW F L UW IH D IH K S",KNESSET="N EH S AH T",NEWSMAKERS="N UW Z M EY K ER Z",["COLLECTOR'S(2)"]="K L EH K T ER Z",ESCHBACH="EH SH B AA K",["PRIAM(2)"]="P R AY AH M",["DIFFUSE(2)"]="D IH F Y UW Z",CRAFTSMANSHIP="K R AE F T S M AH N SH IH P",DRAFTSMANSHIP="D R AE F T S M AH N SH IH P",VINSANT="V IY N S AH N T",INTERMISSIONS="IH N T ER M IH SH AH N Z",HADID="HH AA D IY D",["BUGAI'S"]="B Y UW G AY Z",["SHORTAGE(2)"]="SH AO R T IH JH",STENHOUSE="S T EH N HH AW S",STIPULATIONS="S T IH P Y AH L EY SH AH N Z",ACCESSION="AH K S EH SH AH N",LEDLOW="L EH D L OW",LOTTERY="L AA T ER IY",LANDLOCK="L AE N D L AA K",["MIHAI'S"]="M IY HH AY Z",CRISTOBEL="K R IH S T AH B EH L",DOMINIQUE="D AO M IH N IY K",DICKENSIAN="D IH K EH N Z IY AH N",["FELDMAN'S"]="F EH L D M AH N Z",ELEVATORS="EH L AH V EY T ER Z",SOLTIS="S OW L T IH S",COVERAGE="K AH V ER AH JH",POTTERY="P AA T ER IY",HERRIAGE="HH EH R IY IH JH",FORSYTHE="F AO R S AY DH",VANGILDER="V AE NG G IH L D ER",INNOCULATE="IH N AO K Y AH L EY T",CADETS="K AH D EH T S",COMDEN="K AA M D IH N",MINICH="M IH N IH CH",["OFTENER(2)"]="AO F T AH N ER",MORTGAGES="M AO R G AH JH AH Z",["PRECEDENTS(2)"]="P R EH S AH D EH N T S",PROBED="P R OW B D",TILTH="T IH L TH",NEMESIS="N EH M AH S IH S",["HUGHS(2)"]="HH Y UW Z",AMUSEMENTS="AH M Y UW Z M AH N T S",DELRAY="D EH L R EY",STACKPOLE="S T AE K P OW L",DODSWORTH="D AA D S W ER TH",CARACCI="K AA R AA CH IY",["DISPATCHER'S"]="D IH S P AE CH ER Z",["FRACTIONALLY(2)"]="F R AE K SH N AH L IY",SHORTSIGHTED="SH AO R T S AY T IH D",REILAND="R AY L AH N D",NIENABER="N IY N AH B ER",KLIEMAN="K L AY M AH N",LECOMPTE="L EH K AH M P T",HEILAND="HH AY L AH N D",BULLFROG="B UH L F R AO G",BUSHBY="B UH SH B IY",UNVEIL="AH N V EY L",VILHAUER="V IH L HH AW ER",TRAMONTE="T R AA M OW N T IY",PACIFICA="P AH S IH F IH K AH",SENSITIZED="S EH N S AH T AY Z D",EXTENDS="IH K S T EH N D Z",MESENBRINK="M EH S IH N B R IH NG K",CHEWY="CH UW IY",FILTH="F IH L TH",JARVINEN="JH AA R V IH N AH N",SCHOENBERG="SH OW N B ER G",["PREVENTED(2)"]="P R IY V EH N T IH D",STOMATA="S T OW M AH T AH",PACKAGER="P AE K IH JH ER",SCAT="S K AE T",EJECT="IH JH EH K T",SANRIO="S AE N R IY OW",SILBAUGH="S IH L B AO",ELONGATE="IH L AO NG G EY T",BUSHWHACKING="B UH SH W AE K IH NG",ASSAULTING="AH S AO L T IH NG",COSMOS="K AA Z M OW S",SCHWALLER="SH W AO L ER",WEISFELD="W AY S F EH L D",KILLEAGH="K IH L IY G",["MARASH'S"]="M AA R AH SH IH S",ORIGINALITY="ER IH JH AH N AE L IH T IY",MONOCARPIC="M AA N AH K AA R P IH K",HAILAND="HH EY L AH N D",NOTIFIED="N OW T AH F AY D",SUPERSAVER="S UW P ER S EY V ER",NEAT="N IY T",MEAT="M IY T",SEAT="S IY T",PEAT="P IY T",ANNOUNCMENT="AH N AW N S M AH N T",TEAT="T IY T",REMPAC="R EH M P AE K",REVOCABLE="R EH V AH K AH B AH L",FEAT="F IY T",PRODIGIES="P R AA D AH JH IY Z",STYLUS="S T AY L AH S",SUBSCRIBING="S AH B S K R AY B IH NG",["TROUT'S"]="T R AW T S",PETITT="P EH T IH T",["ANTIDEPRESSANTS(2)"]="AE N T IY D IH P R EH S AH N T S",MACCAQUANO="M AE K AH K W AA N OW",BECHARD="B EH K ER D",HOOVLER="HH UW V L ER",BOTSWANA="B AA T S W AA N AH",LEVCHENKO="L EH V CH EH NG K OW",MINEWORKERS="M AY N W ER K ER Z",PATRIOTS="P EY T R IY AH T S",INTERCELLULAR="IH N T ER S EH L Y AH L ER",ORLENE="AO R L IY N",RICHARD="R IH CH ER D",WALTH="W AO L TH",GOUGHNOUR="G AW N ER",OSTENTATIOUSLY="AA S T AH N T EY SH AH S L IY",MARRIAGE="M EH R IH JH",HAGGSTROM="HH AE G S T R AH M",BRIMELOW="B R IH M AH L OW",BIMIODAL="B AY M OW D AH L",COMPASSION="K AH M P AE SH AH N",CARRIAGE="K AE R IH JH",TRAMONTANO="T R AA M OW N T AA N OW",MENTION="M EH N SH AH N",ALLBAUGH="AH L B AO",DIMINISHING="D IH M IH N IH SH IH NG",ENSLAVE="EH N S L EY V",JEFFRY="JH EH F R IY",MARCMANN="M AA R K M AH N",MINORITE="M IH N ER AY T",ELECT="IH L EH K T",ARCHAIC="AA R K EY IH K",CONFESSIONS="K AH N F EH SH AH N Z",COPPERSMITH="K AA P ER S M IH TH",UNIVERSALLY="Y UW N AH V ER S AH L IY",BURLINGAME="B ER L IH NG G EY M",VACUTAINER="V AE K Y UW T EY N ER",GORNY="G AO R N IY",HORNY="HH AO R N IY",CORNY="K AO R N IY",RARER="R EH R ER",HARER="HH EH R ER",UNRELEASED="AH N R IH L IY S T",AVELAR="AA V EY L AA R",MELCHING="M EH L CH IH NG",CHANNELED="CH AE N AH L D",INSTITUTIONALIZED="IH N S T IH T UW SH AH N AH L AY Z D",WANNABES="W AA N AH B IY Z",BIBBEE="B IH B IY",CARICATURES="K ER IH K AH CH ER Z",BROCKMEYER="B R AA K M AY ER",ARLENE="AA R L IY N",SULEWSKI="S Y UW L EH F S K IY",CONSPICUOUS="K AH N S P IH K Y UW AH S",ERLENE="ER L IY N",ONOMATOPEIA="AA N AH M AE T AH P IY AH",EMBRACEABLE="IH M B R EY S AH B AH L",["PLAYIN'"]="P L EY IH N",DICOSTANZO="D IH K OW S T AA N Z OW",DECIMATION="D EH S AH M EY SH AH N",RAYONIER="R EY OW N IH R",REDDITT="R EH D IH T",PREADOLESCENT="P R IY AE D AH L EH S IH N T",OENOPHILE="IY N AH F AY L",HALFWAY="HH AE F W EY",["RHODE-ISLANDER"]="R OW D AY L AH N D ER",SWORDPLAYS="S AO R D P L EY Z",FOREWOMAN="F AO R W UW M AH N",THUNDERBIRDS="TH AH N D ER B ER D Z",SUNBIRD="S AH N B ER D",SWATCHING="S W AA CH IH NG",MIDWESTERNER="M IH D W EH S T ER N ER",TRACINDA="T R AH S IH N D AH",MELLEMA="M EH L EH M AH",THROTTLE="TH R AA T AH L",OLYMPIA="OW L IH M P IY AH",["CLEAVAGE(2)"]="K L IY V IH JH",["SECRET(2)"]="S IY K R IH T",POSTERIZE="P OW S T ER AY Z",BAUERLE="B AW ER AH L",["WESTMARK'S"]="W EH S T M AA R K S",["APPAREL(2)"]="AH P EH R AH L",HUKSTRA="HH AH K S T R AH",IMPENETRABLE="IH M P EH N AH T R AH B AH L",RELATIVELY="R EH L AH T IH V L IY",["MAJESTY'S"]="M AE JH AH S T IY Z",OPENED="OW P AH N D",FLANNELED="F L AE N AH L D",INCITED="IH N S AY T IH D",UNREAD="AH N R EH D",SUGGESTIBLE="S AH G JH EH S T AH B AH L",["NEGATED(2)"]="N IH G EY T AH D",["SUMMIT(2)"]="S AH M IH T",AERODYNAMICIST="EH R OW D AY N AE M IH S IH S T",BELVIDERE="B EH L V IH D IH R",ZUPANJA="Z AH P AE N JH AH",RIPPLING="R IH P AH L IH NG",["REFINING(2)"]="R IH F AY N IH NG",KNAPPENBERGER="N AE P AH N B ER G ER",TELESPHERE="T EH L AH S F IH R",ALREAD="AA L R IY D",DEPOPULATE="D IY P AA P Y AH L EY T",HEFEI="HH AH F EY",LEONTINE="L EH N T IY N IY",["COPETAS(2)"]="K AH P IY T AH S",["MISTRUSTFUL(2)"]="M IH S T R AH S F AH L",MITTELSTAEDT="M IH T IH L S T EH T",NIGHTFALL="N AY T F AO L",EYEDROPS="AY D R AA P S",SWINDELL="S W IH N D AH L",INSENSIBLE="IH N S EH N S AH B AH L",NEWBURN="N UW B ER N",SPECIALS="S P EH SH AH L Z",RELAXATION="R IY L AE K S EY SH AH N",LARYNGOSCOPY="L AA R IH N G AO S K OW P IY",["AUGUSTUS(2)"]="AH G AH S T AH S",BROICH="B R OY CH",SLAPDASH="S L AE P D AE SH",STARTED="S T AA R T AH D",PULASKI="P Y UW L AE S K IY",["CHATTERTON'S"]="CH AE T ER T AH N Z",["FRIENDS(2)"]="F R EH N Z",BANYU="B AA N Y UW",CYNTH="S IH N TH",MCCLINTICK="M AH K L IH N T IH K",CHOCOLATE="CH AO K L AH T",ZHIVKOV="ZH IH V K AA V",PALPITATIONS="P AE L P IH T EY SH AH N Z",WINKLES="W IH NG K AH L Z",IZETBEGOVIC="IH Z EH T B EH G OW V IH CH",CRUCIFIED="K R UW S AH F AY D",["SHELTON'S"]="SH EH L T AH N Z",COURINGTON="K AO R IH NG T AH N",BYRER="B AY R ER",VOLKERT="V OW L K ER T",ADENOSINE="AH D EH N AH S IY N",REVENUES="R EH V AH N UW Z",TOMORROWS="T AH M AA R OW Z",SMYLIE="S M IH L IY",KUZNIAR="K AH Z N Y ER",GEIGY="G AY G IY",["STEINHARDT'S"]="S T AY N HH AA R T S",SHRINK="SH R IH NG K",TOMATOS="T AH M EY T OW Z",CHONTALES="SH AA N T EY L Z",FABERMAN="F EY B ER M AH N",HABERMAN="HH EY B ER M AH N",GEYSERS="G AY Z ER Z",MOCZYGEMBA="M AH CH IH G EH M B AH",ANDREANO="AE N D R IY N OW",OUGHT="AO T",["BORIS'S"]="B AO R IH S IH Z",DUTIES="D UW T IY Z",GIELOW="JH IY L OW",["TELE(2)"]="T EH L AH",SOROKA="S AO R OW K AH",["DAVIS'S(2)"]="D EY V IH S IH Z",CARRUBBA="K AA R UW B AH",CAMDEN="K AE M D AH N",CUSTODIAN="K AH S T OW D IY AH N",["UNUSUALLY(2)"]="AH N Y UW ZH W AH L IY",MEIYUH="M EY Y UW",MONSTER="M AA N S T ER",RATIFIED="R AE T AH F AY D",AGATHA="AE G AH TH AH",LOOSENED="L UW S AH N D",PROFESSIONS="P R AH F EH SH AH N Z",KIMBELL="K IH M B EH L",LEVERAGE="L EH V ER IH JH",["INTRODUCING(2)"]="IH N T R OW D UW S IH NG",CEDERGREN="S IY D ER G R EH N",CRANNEY="K R AE N IY",ENCOMPASSED="EH N K AH M P AH S T",YOUTSEY="Y AW T S IY",PHILBRICK="F IH L B R IH K",["FOGG'S"]="F AA G Z",LEKACHMAN="L EH K AA K M AH N",CREDULOUS="K R EH JH AH L AH S",WADLOW="W AA D L OW",NONUTILITY="N AA N Y UW T IH L IH T IY",["ISLAM(2)"]="IH Z L AH M",MONTH="M AH N TH",RORER="R AO R ER",POSITIVISM="P AA Z AH T IH V IH Z AH M",LEVANDOWSKI="L IH V AH N D AO F S K IY",PROVIDENCE="P R AA V AH D AH N S",SCHOW="SH AW",SUNDERMEYER="S AH N D ER M AY ER",DORER="D AO R ER",BORER="B AO R ER",BEVERAGE="B EH V ER IH JH",SHRINER="SH R AY N ER",EVERSOLE="EH V ER S OW L",MARTYRE="M AA R T AY R",WATERFALLS="W AO T ER F AO L Z",LUDEMAN="L UW D M AH N",FRESCOES="F R EH S K OW Z",RATHGEBER="R AE TH G IH B ER",PRIVATE="P R AY V AH T",LIGHTENED="L AY T AH N D",MATERIALIST="M AH T IH R IY AH L IH S T",CORROBORATION="K ER AO B ER EY SH AH N",["ARNELLE'S"]="AA R N EH L Z",GRIEPENTROG="G R IY P IH N T R AH G",STASKO="S T AA S K OW",TIGHTENED="T AY T AH N D",DEREGT="D ER EH K T",PRATTLED="P R AE T AH L D",JANICEK="Y AE N IH CH EH K",["IONS(2)"]="AY AA N Z",RADISHES="R AE D IH SH IH Z",CRIMI="K R IY M IY",MEHETABEL="M IH HH EH T AH B IH L",SELENE="S AH L IY N",REGULATES="R EH G Y AH L EY T S",MAGID="M AE JH IH D",TAWFIQ="T AA F IH K",HELENE="HH AH L IY N",SHOWGIRL="SH OW G ER L",CELENE="CH EH L IY N",GRIDLOCKED="G R IH D L AA K T",REHIRED="R IY HH AY ER D",ACQUIESCED="AE K W IY EH S T",LIBERMAN="L IH B ER M AH N",["DROP-OFFS"]="D R AA P AO F S",MINSTER="M IH N S T ER",JEALOUS="JH EH L AH S",FERRINI="F ER IY N IY",THANATOLOGY="TH AE N AH T AO L AH JH IY",INCUBATION="IH NG K Y UW B EY SH AH N",STEPP="S T EH P",["ROCHESTER'S"]="R AA CH EH S T ER Z",CANVASSING="K AE N V AH S IH NG",CONTRITE="K AH N T R AY T",CLARIFICATION="K L EH R AH F AH K EY SH AH N",PERCOLATE="P ER K AH L EY T",FERRINGTON="F EH R IH NG T AH N",DERRINGTON="D EH R IH NG T AH N",INAEZ="IH N AE Z",HONOREE="AA N ER IY",["RASHID(2)"]="R AA SH IY D",DIVISIBLE="D IH V IH Z AH B AH L",TERRINGTON="T EH R IH NG T AH N",DECAFFEINATION="D IY K AE F AH N EY SH AH N",SILVERWARE="S IH L V ER W EH R",SHOWCASE="SH OW K EY S",CAMBELL="K AE M B AH L",FACETS="F AE S AH T S",EASTWARD="IY S T W ER D",MEXICAN="M EH K S AH K AH N",SIPPICAN="S IH P IH K AH N",FLIMSY="F L IH M Z IY",CHARLAND="CH AA R L AH N D",["ENCYCLOPEDIST(2)"]="IH N S AY K L OW P IY D AH S T",["HAGINS(2)"]="HH AE JH IH N Z",CESSNA="S EH S N AH",["FARRAKHAN'S"]="F AA R AH K AA N Z",SECESSION="S IH S EH SH AH N",RECESSION="R IH S EH SH AH N",BECALM="B IH K AA M",ELLESMERE="EH L Z M IH R",SHEPP="SH EH P",PLESCIA="P L EY SH Y AH",AMALYA="AH M AA L Y AH",BALDASSARRE="B AO L D AH S AA R IY",LECLERC="L AH K L ER K",DISCOVER="D IH S K AH V ER",MARINER="M EH R AH N ER",DEPENDENCY="D IH P EH N D AH N S IY",["BRANDENSTEIN(2)"]="B R AE N D EH N S T IY N",KORMOS="K AO R M OW Z",CEASAR="S AH S AA R",BALAZS="B AO L AH SH",["MELOR(2)"]="M AH L AO R",HEARTED="HH AA R T AH D",BUZZARDS="B AH Z ER D Z",VOLCKER="V OW L K ER",["SURAT'S"]="S ER AA T S",BRIDGEHEAD="B R IH JH HH EH D",RECOGNIZABLY="R EH K AH G N AY Z AH B L IY",FOTHERGILL="F AH DH ER G IH L",CAPTIONING="K AE P SH AH N IH NG",CHACHI="CH AA CH IY",BLASKO="B L AA S K OW",["INTERVAL(2)"]="IH N ER V AH L",MANUSCRIPT="M AE N Y AH S K R IH P T",BAJOREK="B AE JH ER EH K",["DISOBEDIENT(2)"]="D IH S OW B IY D IY AH N T",DELASKI="D AH L AE S K IY",OSSIFIED="AA S AH F AY D",PLEXIGLAS="P L EH K S IH G L AE S",REPLACED="R IY P L EY S T",LEFAVE="L IH F EY V",AUFIERO="OW F IH R OW",SMOKEJUMPER="S M OW K JH AH M P ER",FIREBUG="F AY ER B AH G",BRIMHALL="B R IH M HH AO L",CISSNA="S IH S N AH",MASSONI="M AA S OW N IY",SEISMOLOGY="S AY Z M AA L AH JH IY",POUTER="P AW T ER",SOUTER="S UW T ER",ROUTER="R UW T ER",UPSIZE="AH P S AY Z",UNDYING="AH N D AY IH NG",SQUALOR="S K W AA L ER",CASSONI="K AH S OW N IY",FIGHT="F AY T",MATHENA="M AE TH IH N AH",HIGHT="HH AY T",BIGHT="B AY T",POIRIER="P OY R IY ER",RAHMING="R AA M IH NG",MISAPPROPRIATED="M IH S AH P R OW P R IY EY T IH D",KIMONO="K AH M OW N AH",FELICITATE="F AH L IH S IH T EY T",HAMMACK="HH AE M AH K",KLUTTZ="K L AH T S",MINTHA="M IH N TH AH",POLJE="P OW L JH IY",CONTRACTIONARY="K AH N T R AE K SH AH N EH R IY",TELESIS="T EH L AH S IH S",STADIUM="S T EY D IY AH M",IMPOVERISH="IH M P AA V R IH SH",PREYS="P R EY Z",SHORIN="SH AO R IH N",KREITNER="K R AY T N ER",COMPUTER="K AH M P Y UW T ER",BALKANIZED="B AO L K AH N AY Z D",STALWARTS="S T AO L W ER T S",BURKEMPER="B ER K IH M P ER",TAVOULAREAS="T AA V UW L EH R IY AH S",COTTONWOOD="K AA T AH N W UH D",SURER="SH UH R ER",HYSLOP="HH AY S L AH P",PURER="P Y UH R ER",FURER="F Y UH R ER",DURER="D UH R ER",DEBUTING="D EY B Y UW IH NG",ROWSEY="R OW S IY",CONDEMNS="K AH N D EH M Z",ROTHENBERGER="R AO TH AH N B ER G ER",NOWACK="N AW AH K",BLAKENEY="B L EY K N IY",["TERRITORY'S"]="T EH R IH T AO R IY Z",["POSTPONED(2)"]="P OW S P OW N D",LEIBROCK="L AY B R AH K",FOREWARNED="F AO R W AO R N D",PLACENTIA="P L AH S EH N SH AH",INCIDENTS="IH N S AH D AH N T S",NUCLEONICS="N UW K L IY AA N IH K S",KNIEF="N IY F",["BOOMERS'"]="B UW M ER Z",QUIRKE="K W ER K",RASHID="R AH SH IY D",POLASKI="P AH L AA S K IY",INTERFERE="IH N T ER F IH R",SUCCESSION="S AH K S EH SH AH N",CAYCE="K EY S",CRITICIZE="K R IH T IH S AY Z",MARHEFKA="M ER HH EH F K AH",CATCHMENT="K AE CH M AH N T",CZERWONKA="CH ER V AA NG K AH",COOPERSMITH="K UW P ER S M IH TH",VOLKSFUERSORGE="V OW L K S F Y UW R S AO R JH",["CAROL'S(2)"]="K AE R AH L Z",WIGHT="W AY T",RIGHT="R AY T",["QUITO'S(2)"]="K IY T OW Z",TIGHT="T AY T",SIGHT="S AY T",NIGHT="N AY T",KOEPP="K OW P",LIGHT="L AY T",KIGHT="K AY T",CONFORTI="K AA N F AO R T IY",LINDBECK="L AY N D B EH K",MUNICH="M Y UW N IH K",MCPEAKE="M AH K P IY K",TOPPLING="T AA P AH L IH NG",["WHARF(2)"]="HH W AO R F",YUNICH="Y UW N IH CH",TELSTRA="T EH L S T R AH",MOUSEHOLE="M AW S HH OW L",KNEPP="N EH P",["WHITBECK(2)"]="HH W IH T B EH K",WOODLAND="W UH D L AE N D",WESTWARD="W EH S T W ER D",["COMMISION(2)"]="K AH M IH SH AH N",LOEWY="L OW IY",SONNENFELD="S AA N IH N F EH L D",PRUDHOMME="P R AH D HH AH M",MECUM="M EH K AH M",OBSCENITIES="AA B S EH N IH T IY Z",FREEBERG="F R IY B ER G",["BOFORS'S"]="B OW F ER Z IH Z",RANKLES="R AE NG K AH L Z",MOUTHPARTS="M AW TH P AA R T S",IMPRESSIONISM="IH M P R EH SH AH N IH Z AH M",MEASURED="M EH ZH ER D",MCKERCHER="M AH K ER CH ER",CEPEDA="S EY P EY D AH",["INDIVIDUALS'"]="IH N D IH V IH JH AH W AH L Z",["LEASEWAY'S"]="L IY S W EY Z",LAPINSKY="L AH P IH N S K IY",UNAVOIDABLE="AH N AH V OY D AH B AH L",FAHRNER="F AA R N ER",SEPEDA="S EY P EY D AH",LANCETS="L AE N S AH T S",["BOTTOM'S"]="B AA T AH M Z",ZEPEDA="Z EY P EY D AH",COLLAZO="K OW L AA Z OW",["SOCO'S(2)"]="S AA K OW Z",EBERSOLE="EH B ER S OW L",NADJEN="N AA JH AH N",PATRICIANS="P AH T R IH SH AH N Z",ZYLSTRA="Z IH L S T R AH",SHERRI="SH EH R IY",["CHA-CHAS"]="CH AA CH AA Z",BALKCOM="B AE L K AH M",ADACHI="AA D AA K IY",BRIEF="B R IY F",RADIANT="R EY D IY AH N T",PRINTOUTS="P R IH N T AW T S",STIEF="S T IY F",HEDONISTIC="HH IY D AH N IH S T IH K",ANARCHIST="AE N ER K AH S T",VANROEKEL="V AE N R OW K AH L",["APARTHEID'S(2)"]="AH P AA R T AY D Z",["SHIPS'"]="SH IH P S",CONTENTIONED="K AH N T EH N SH AH N D",UNDERGRADUATES="AH N D ER G R AE JH AH W AH T S",DIORIO="D IY AO R IY OW",TREMENDOUSLY="T R AH M EH N D AH S L IY",REASONOVER="R IY Z AH N OW V ER",OVERLOADS="OW V ER L OW D Z",ORCHESTRALLY="AO R K EH S T R AH L IY",ARRANGE="ER EY N JH",AVASSO="AH V AA S OW",STODGY="S T AA JH IY",["PLEXIGLAS(2)"]="P L EH K S IY G L AE S",SERGEY="S EH R JH IY",MATALA="M AH T AA L AH",NATALA="N AA T AA L AH",NONCASH="N AA N K AE SH",GOUPIL="G UW P AH L",OTTAVIANO="OW T AA V IY AA N OW",HATALA="HH AE T AH L AH",MELLOTT="M EH L AH T",JAYROE="JH EY R OW",ALIBI="AE L AH B AY",KEROUAC="K EH R UW AE K",PRUITT="P R UW IH T",TRUITT="T R UW T",["ELEPHANTS'"]="EH L AH F AH N T S",APPEARED="AH P IH R D",RHAPSODY="R AE P S AH D IY",["MONUMENTALLY(3)"]="M AA N Y AH M EH N AH L IY",SALVATIERRA="S AA L V AA T IH R AH",RECAST="R IY K AE S T",BERGEY="B ER JH IY",HEARTBEATS="HH AA R T B IY T S",FOGGY="F AA G IY",ACCEPTABLY="AE K S EH P T AH B L IY",["RATION(2)"]="R EY SH AH N",TINNON="T IH N AH N",ABSORBS="AH B Z AO R B Z",PRIMATE="P R AY M EY T",SOGGY="S AA G IY",LORINCZ="L AO R IH N CH",SHERBET="SH ER B AH T",SCHMIESING="SH M IY S IH NG",["BASILICA(2)"]="B AH Z IH L AH K AH",WESPAC="W EH S P AE K",BRASSO="B R AE S OW",EPPICH="EH P IH CH",["SAREJEVO'S"]="S AA R AH Y EY V OW Z",["EARNINGS'"]="ER N IH NG Z",GRASSO="G R AE S OW",JACLYN="JH AE K L IH N",INSTIGATORS="IH N S T AH G EY T ER Z",SHACKELFORD="SH AE K IH L F ER D",GUERRE="G EH R",AQUILA="AE K W AH L AH",TORRAY="T AO R EY",DELLUMS="D EH L AH M Z",WIEBUSCH="W IY B AH SH",CHOUINARD="SH W IY N AA R D",BRAINWASH="B R EY N W AA SH",["UTICA(2)"]="Y UW T IY K AH",["DRIVERS'"]="D R AY V ER Z",BURGO="B ER G OW",["REESJONES'"]="R IY S JH OW N Z",BARTLEBAUGH="B AA R T AH L B AO",PRIMESTAR="P R AY M S T AA R",BANCOKLAHOMA="B AE NG K AA K L AH HH OW M AH",HELLUMS="HH EH L AH M Z",TAKEI="T AA K EY",["INTEGRELIN(2)"]="IH N T EH G R AH L IH N",ANIMATE="AE N AH M AH T",PRACTICAL="P R AE K T AH K AH L",SPASSO="S P AE S OW",PERIPHERY="P ER IH F ER IY",STRANGE="S T R EY N JH",REPELLED="R AH P EH L D",DUMPLING="D AH M P L IH NG",KREIS="K R IY Z",["KENYAN(2)"]="K IY N Y AH N",PREIS="P R IY Z",KENNON="K EH N AH N",LENNON="L EH N AH N",STYMIED="S T AY M IY D",FREIS="F R IY Z",UNIMATE="Y UW N IH M EY T",["FAVORABLY(2)"]="F EY V R AH B L IY",HENNON="HH EH N AH N",GOODLING="G UH D L IH NG",CONCEPTS="K AA N S EH P T S",CLIMATE="K L AY M AH T",ALLURE="AH L UH R",PAVILIONS="P AH V IH L Y AH N Z",["CHARBONNET(2)"]="SH AA R B AH N EY",RUDNICKY="R AH D N IH K IY",INTRIGUINGLY="IH N T R IY G IH NG L IY",MORENCY="M AO R EH N S IY",["MONTAGU'S"]="M AA N T AH G Y UW Z",LEUMI="L UW M IY",DRUCKENMILLER="D R AH K IH N M IH L ER",KINGSOLVER="K IH NG S AA L V ER",MULCT="M AH L K T",ROCKHOLD="R AA K HH OW L D",SAMOJLIK="S AH M OY L IH K",BESSE="B EH S",URSCHEL="ER SH AH L",JESSE="JH EH S IY",TURNBO="T UH R N B OW",["INTERCEPTED(3)"]="IH N ER S EH P T AH D",SANDRIDGE="S AE N D R IH JH",BIERBARROR="B IH R B AA R ER",INSCORE="IH N S K AO R IY",BASHED="B AE SH T",CASHED="K AE SH T",LEWANDOWSKI="L UW AH N D AO F S K IY",MUNCE="M AH N S",REINDEER="R EY N D IH R",KUNCE="K AH N S",HASHED="HH AE SH T",BALLPOINTS="B AO L P OY N T S",LASHED="L AE SH T",MASHED="M AE SH T",BUNCE="B AH N S",["ASSOCIATION(2)"]="AH S OW SH IY EY SH AH N",RECTIFIERS="R EH K T AH F AY ER Z",TATEM="T AE T IH M",PLEASER="P L IY Z ER",KUSCHEL="K AH SH AH L",OUNCE="AW N S",ZANIEWSKI="Z AE N IY EH F S K IY",MALUKEN="M AE L UW K IH N",AMIABLY="EY M IY AH B L IY",AMCAST="AE M K AE S T",HATEM="HH AE T IH M",COLLUMS="K AA L AH M Z",AEROJETS="EH R OW JH EH T S",GROER="G R OW ER",BROER="B R OW ER",KASHMIRI="K AE SH M IY R IY",SQUALID="S K W AA L AH D",ATROCITY="AH T R AA S AH T IY",GRUMBLING="G R AH M B AH L IH NG",["CHEMICAL'S"]="K EH M IH K AH L Z",TROUBLESHOOTER="T R AH B AH L SH UW T ER",GONCE="G AA N S",THATCHERISM="TH AE CH ER IH Z AH M",RABID="R AE B IH D",TEAKAMP="T IY K AE M P",CRUMBLING="K R AH M B AH L IH NG",YONCE="Y AA N S",SCHROFF="SH R AO F",OPTOMETRIC="AA P T OW M EH T R IH K",["PARIS'S"]="P EH R IH S IH Z",SCHMALL="SH M AO L",["COCHRAN'S"]="K AA K R AH N Z",["RECRUITS(2)"]="R IH K R UW T S",ROSENLUND="R OW Z AH N L AH N D",PONCE="P OW N S EY",FORGEY="F AO R JH IY",FLASHBACKS="F L AE SH B AE K S",BURKEEN="B ER K IY N",NEUMAYER="N UW M EY ER",BANDWAGON="B AE N D W AE G AH N",EGYPTOLOGY="IY JH AH P T AA L AH JH IY",SHAMBAUGH="SH AE M B AO",ZYWICKI="Z IH W IH K IY",ASSEMBLYMEN="AH S EH M B L IY M IH N",["OTTERBEIN'S"]="AA T ER B AY N Z",KODACOLOR="K OW D AH K AH L ER",MALCONTENTS="M AE L K AH N T EH N T S",MESHED="M EH SH T",HETERODYNE="HH EH T ER AH D AY N",HARDEY="HH AA R D IY",FREYMILLER="F R EY M IH L ER",MAJURE="M AA Y UH R EY",ALLOPHONES="AE L AH F OW N Z",["UNEQUIVOCALLY(2)"]="AH N IY K W IH V AH K L IY",["ALMS(2)"]="AA M Z",NAGATA="N AA G AA T AH",ELECTRICALLY="IH L EH K T R IH K AH L IY",BATTERIES="B AE T ER IY Z",MORRA="M AO R AH",PANELED="P AE N AH L D",SPREADSHEETS="S P R EH D SH IY T S",DELBOSQUE="D IH L B OW S K",DAGATA="D AA G AA T AH",["TUZLA'S"]="T UW Z L AH Z",FABRICATOR="F AE B R IH K EY T ER",SOCIETE="S OW S IY EH T EY",ALCOHOLISM="AE L K AH HH AO L IH Z AH M",SEIBU="S AY B UW",DEBELLIS="D EH B IH L IH S",OCCASION="AH K EY ZH AH N",ALETHA="AH L IY TH AH",PIPER="P AY P ER",VIPER="V AY P ER",WIPER="W AY P ER",AFANASYEV="AE F AH N EY S IY EH V",OROARK="OW R AO R K",WORLDERS="W ER L D ER Z",AFFINED="AH F AY N D",SIGNED="S AY N D",["UNBECOMING(2)"]="AH N B IY K AH M IH NG",SKELTON="S K EH L T AH N",CLOUTHIER="K L AW TH IY ER",ENUMERATES="IH N UW M ER EY T S",SAVITCH="S AE V IH CH",RAVITCH="R AE V IH CH",PUDGY="P AH JH IY",LATECOMERS="L EY T K AH M ER Z",YAOHAN="Y AW HH AA N",["CHRONICALLY(2)"]="K R AA N IH K L IY",GODBEE="G AA D B IY",PETRUCELLI="P EH T R UW CH EH L IY",DEFINED="D IH F AY N D",ROHLFS="R OW L F S",REAGEN="R IY G AH N",FUDGY="F AH JH IY",CONFRONTATIONAL="K AA N F R AH N T EY SH AH N AH L",MOSKOVITZ="M AA S K AH V IH T S",FRISINA="F R IY S IY N AH",GLEAVE="G L IY V",HEARTTHROBS="HH AA R T TH R AA B Z",OUTFOXES="AW T F AA K S IH Z",GEYELIN="JH EY IH L IH N",WEAKEST="W IY K AH S T",PENNIX="P EH N IH K S",HORNS="HH AO R N Z",LITEM="L AY T EH M",["MARASH'"]="M AA R AH SH",KORNS="K AO N Z",["HURDLING(2)"]="HH ER D L IH NG",KRISHNA="K R IH SH N AH",DELICIA="D EH L IY CH AH",GARFINKEL="G AA R F IH NG K AH L",FELICIA="F AH L IY SH AH",REFINED="R AH F AY N D",RURITANIA="R UH R AH T EY N IY AH",["GRADUATES(4)"]="G R AE JH UW EY T S",MEMORANDA="M EH M ER AE N D AH",DISASSEMBLED="D IH S AH S EH M B AH L D",FEROCITY="F ER AA S AH T IY",CITISTEEL="S IH T IY S T IY L",ANDERMAN="AE N D ER M AH N",HYSSOP="HH IH S AH P",DEBUG="D IY B AH G",["SIMULATE(2)"]="S IH M Y AH L EY T",PARASITES="P EH R AH S AY T S",SOURCE="S AO R S",ENTRANCED="IH N T R AE N S T",SODERMAN="S OW D ER M AH N",["REASONABLENESS(2)"]="R IY Z N AH B AH L N AH S",BORNS="B AO R N Z",CORNS="K AO R N Z",ALLUSIVE="AH L UW S IH V",KIEHNE="K IY N",EGELTON="EH G AH L T AH N",BERRA="B EH R AH",FRAZE="F R EY Z",CURBSIDE="K ER B S AY D",DISAPPEARS="D IH S AH P IH R Z",PERRA="P ER R AH",UNDERMAN="AH N D ER M AE N",MASSE="M AE S",SCRAMBLED="S K R AE M B AH L D",SERRA="S EH R AH",SHIONOGI="SH IY AH N OW G IY",APOLOGETICALLY="AH P AA L AH JH EH T IH K L IY",MURPHREY="M ER F R IY",MAHAFFY="M AE HH AH F IY",PASSE="P AE S EY",SPIETH="S P AY AH TH",DETENTE="D EY T AA N T",MINNIX="M IH N IH K S",PINNIX="P IH N IH K S",MICHAELLA="M AY K EH L AH",MINCE="M IH N S",LINCE="L IH N S",ALDERMAN="AO L D ER M AH N",CONSTRUCCIONES="K AH N S T R UW CH IY OW N EY Z",GOETTEL="G OW T AH L",VINCE="V IH N S",SINCE="S IH N S",ASSUAGE="AH S W EY JH",MOONDREAMERS="M UW N D R IY M ER Z",MERIDOR="M EH R IH D AO R",NIMBLY="N IH M B L IY",RESTORATIONS="R EH S T ER EY SH AH N Z",WINCE="W IH N S",["OPERANDI(2)"]="AA P ER AE N D AY",SANDBAR="S AE N D B AA R",SHOHAT="SH OW HH AE T",WHELTON="W EH L T AH N",SANCTION="S AE NG K SH AH N",SHELTON="SH EH L T AH N",["BROOKS'S(2)"]="B R UH K S",BECERRA="B EH CH EH R AH",LAFAVE="L AH F EY V",INVIRASE="IH N V AY R EY Z",["HEARST'S"]="HH ER S T S",CAPER="K EY P ER",DABHOL="D AE B OW L",PAPER="P EY P ER",ALLCORN="AH L K AO R N",PURPLISH="P ER P L IH SH",WEINAND="W AY N AH N D",TAPER="T EY P ER",INSTINCTIVELY="IH N S T IH NG K T IH V L IY",SEACOAST="S IY K OW S T",TENSIONS="T EH N CH AH N Z",HARDLINER="HH AA R D L AY N ER",PENSIONS="P EH N SH AH N Z",TURNS="T ER N Z",WILLOUGHBY="W IH L AH B IY",FAUSTINA="F AO S T IY N AH",SHIPWRIGHT="SH IH P R AY T",["HORACE'S"]="HH AO R AH S AH Z",CONNON="K AA N AH N",BIOCHEM="B AY AH CH AH M",POCATELLO="P OW K AH T EH L OW",PRIVACIES="P R AY V AH S IY Z",["SINGH'S"]="S IH NG Z",MISLAID="M IH S L EY D",CREWEL="K R UW AH L",PESCHEL="P EH SH AH L",["FOXWORTHY'S"]="F AA K S W ER DH IY Z",YQUEM="IY K W AH M",MELRIDGE="M EH L R IH JH",MUTILATE="M Y UW T AH L EY T",BURNS="B ER N Z",GENTEEL="JH EH N T IY L",["KROEGER'S"]="K R OW G ER Z",PLANERS="P L EY N ER Z",RANCHING="R AE N CH IH NG",LEANERS="L IY N ER Z",EARNSHAW="ER N SH AO",["ACADEMY'S"]="AH K AE D AH M IY Z",ACCURACIES="AE K Y ER AH S IY Z",CHURCHGOING="CH ER CH G OW IH NG",["FASHION'S"]="F AE SH AH N Z",["BAUMHOLDER(2)"]="B AW M HH AO L D ER",["MANAGEMENT(2)"]="M AE N IH JH M AH N T",SCRIPTWRITING="S K R IH P T R AY T IH NG",["HANS(2)"]="HH AE N Z",["SLAVONIA(2)"]="S L AH V OW N Y AH",DROHAN="D R OW AH N",DUECKER="D UW K ER",VOGHT="V AA T",NIEHAUS="N IY HH AW S",LIBERATO="L IY B ER AA T OW",KUECKER="K UH K ER",HERMITAGE="HH ER M AH T AH JH",["BOTANICALLY(2)"]="B AH T AE N AH K L IY",FRACTIONAL="F R AE K SH AH N AH L",BRUECKNER="B R UH K N ER",REBELLIOUSNESS="R AH B EH L IY AH S N AH S",DISTINCTIVELY="D IH S T IH NG K T IH V L IY",["VIOLENT(2)"]="V AY L AH N T",POLHAMUS="P OW L HH AH M IH S",EASTBURN="IY S T B ER N",RINGLEADERS="R IH NG L IY D ER Z",STECKER="S T EH K ER",GRAHEK="G R AE HH IH K",PUSHED="P UH SH T",FURSE="F ER S",RUSHED="R AH SH T",["DRESDNER'S"]="D R EH Z D N ER Z",["SURREALISM(2)"]="S ER IY AH L IH Z AH M",NURSE="N ER S",PURSE="P ER S",STRONGMAN="S T R AO NG M AE N",IMPELLED="IH M P EH L D",SWECKER="S W EH K ER",["LONG-WINDED"]="L AO NG W IH N D IH D",RUDERMAN="R UW D ER M AH N",SUDERMAN="S UW D ER M AH N",WARDAIR="W AO R D EH R",PRETTI="P R EH T IY",["NORDLING(2)"]="N AO R D L IH NG",BURSE="B ER S",CURSE="K ER S",BOEHNE="B OW N",REZAC="R EH Z AH K",KOEHNE="K OW N",INVALID="IH N V AH L AH D",["REBUKE(2)"]="R IH B Y UW K",PROSPECTS="P R AA S P EH K T S",FRANCISCO="F R AE N S IH S K OW",BROGNA="B R OW G N AH",SIGNORELLI="S IY G N AO R EH L IY",GALICIA="G AH L IH SH IY AH",FORMAT="F AO R M AE T",UMBRIA="AH M B R IY AH",SCHAFFERT="SH AE F ER T",["WHITWELL(2)"]="HH W IH T W EH L",KIECKER="K IY K ER",HYPER="HH AY P ER",["MEMPHIS(3)"]="M EH M P F AH S",PYPER="P AY P ER",SILENCING="S AY L AH N S IH NG",REITERA="R IY IH T ER AH",FILENE="F IH L IY N",LOIBL="L OY B AH L",WHAT="W AH T",THAT="DH AE T",REGGY="R EH G IY",PEGGY="P EH G IY",NARRAMORE="N AA R AA M AO R",LEGGY="L EH G IY",KHAT="K AA T",MIYAKE="M IY Y AA K EY",WENDLING="W EH N D L IH NG",PARRAMORE="P AA R AA M AO R",ORPHAN="AO R F AH N",CHAT="CH AE T",SCHLOSSER="SH L AO S ER",CHECKER="CH EH K ER",["O'BRIAN"]="OW B R AY AH N",ELLENPORE="EH L IH N P AO R",HANDLING="HH AE N D L IH NG",RUMBERGER="R AH M B ER G ER",["RALPH'S"]="R AE L F S",ZWIEBEL="Z W IY B AH L",MONGSTAD="M AO NG S T AE D",NICHOL="N IH K AO L",ABIDJAN="AE B IH JH AA N",DOOMSAYERS="D UW M S EY ER Z",HYPERBOLA="HH AY P ER B AH L AH",FIAT="F AY AE T",BOROSAGE="B AO R AH S IH JH",["TURBOT(2)"]="T ER B AH T",CARVALHO="K AA R V AA L HH OW",FRAUDULENTLY="F R AO D UW L AH N T L IY",["FEINSTEIN(2)"]="F AY N S T IY N",PEARLSTEIN="P ER L S T AY N",SUBTITLED="S AH B T AY T AH L D",["YENE(2)"]="Y EH N",TRANSMITS="T R AE N Z M IH T S",HERBERGER="HH ER B ER G ER",["WEINSTEIN(2)"]="W AY N S T IY N",GALEF="G AE L AH F",CUCCHI="K UW K IY",DENYING="D IH N AY IH NG",CALEF="K AE L IH F",["NAMIBIA'S"]="N AH M IH B IY AH Z",RETRACED="R IY T R EY S T",STAYNER="S T EY N ER",ROMBERGER="R AA M B ER G ER",SCHIAVONE="S K IY AA V OW N IY",RINGSTAD="R IH NG S T AH D",DISTURBED="D IH S T ER B D",SCHOOLMASTER="S K UW L M AE S T ER",TUPELO="T Y UW P AH L OW",SUCHARD="S UW SH AA R D",["PLEBISCITE(2)"]="P L IY B IH S AY T",["MANNING'S"]="M AE N IH NG Z",LEPER="L EH P ER",STAT="S T AE T",ALETTI="AH L EH T IY",UNELECTED="AH N IH L EH K T IH D",["YASSER'S(2)"]="Y AA S ER Z",NONACADEMIC="N AA N AE K AH D EH M IH K",ASSASSIN="AH S AE S AH N",KLECKER="K L EH K ER",ASAT="AE Z AE T",PIGGY="P IH G IY",["PETUNIA(2)"]="P AH T UW N Y AH",CREDENZA="K R AH D EH N Z AH",BLECKER="B L EH K ER",ROCKETDYNE="R AA K IH T D AY N",YEOSOCK="Y OW S AO K",ALLENE="AE L IY N",DOWNLOADING="D AW N L OW D IH NG",["SELF-ENRICHMENT"]="S EH L F AH N R IH CH M AH N T",TELETYPE="T EH L AH T AY P",ANTITHETICAL="AE N T AH TH EH T IH K AH L",ROECKER="R OW K ER",MORREN="M AO R AH N",YABLONSKY="Y AH B L AA N S K IY",QUENZER="K W EH N Z ER",INTERRUPTION="IH N T ER AH P SH AH N",ROWLIE="R OW L IY",NOECKER="N OW K ER",EXPRESSLY="EH K S P R EH S L IY",BOECKER="B OW K ER",BEETHOVEN="B EY T OW V AH N",COLUMNIST="K AA L AH M N AH S T",CLAVETTE="K L AH V EH T",JABLONSKY="Y AH B L AA N S K IY",MARKOVITZ="M AA R K AH V IH T S",UNPARALLELED="AH N P EH R AH L EH L D",MALTREATED="M AE L T R IY T IH D",JOLENE="JH OW L IY N",CILICIA="S IH L IH SH AH",TWEEZER="T W IY Z ER",VIETTI="V IY EH T IY",SOMETHINGS="S AH M TH IH NG Z",THALMANN="TH AO L M AH N",FANUCCHI="F AA N UW K IY",RAYBURN="R EY B ER N",CONNECTORS="K AH N EH K T ER Z",PUAT="P Y UW AE T",EDPER="EH D P ER",PIERRE="P IY EH R",NEUENFELDT="N UW AH N F EH L T",SWORDFISH="S AO R D F IH SH",MAYHAN="M EY AH N",OLEJNICZAK="AH L EY N IH CH AE K",GREAVE="G R IY V",GALLOPED="G AE L AH P T",SNATCHING="S N AE CH IH NG",CARIDAD="K AE R AH D AE D",INDOCHINESE="IH N D OW CH AY N IY Z",KLOEPPEL="K L OW P AH L",REFILE="R IY F AY L",CONGLOMERATE="K AH N G L AA M ER AH T",TERNS="T ER N Z",RESPONSIVE="R IH S P AA N S IH V",OCCUPANT="AA K Y AH P AH N T",KERNS="K ER N Z",QUOTABLE="K W OW T AH B AH L",ROPER="R OW P ER",SOPER="S OW P ER",BERNS="B ER N Z",SCHERMAN="SH ER M AH N",FERNS="F ER N Z",DEEMPHASIZING="D IY EH M F AH S AY Z IH NG",KURANARI="K UH R AH N AA R IY",ESPER="EH S P ER",DERANGE="D IH R EY N JH",KOZLOSKI="K AH Z L AW S K IY",FOODSTUFF="F UW D S T AH F",PINDLING="P IH N D L IH NG",UPPER="AH P ER",FORGO="F AO R G OW",BERKOVITZ="B ER K AH V IH T S",FINDLING="F IH N D AH L IH NG",CHAPELLE="SH AH P EH L",["CREUTZFELDT(2)"]="K R UH T S F EH L T",GLAZE="G L EY Z",BLAZE="B L EY Z",MOULDING="M OW L D IH NG",OPPER="AA P ER",REINSURERS="R IY IH N SH UH R ER Z",MARSE="M AA R S",AUTOBIOGRAPHICAL="AO T AH B AY AH G R AE F IH K AH L",OUTMANEUVER="AW T M AH N UW V ER",GOULDING="G UW L D IH NG",PARSE="P AA R S",BLACKBERRIES="B L AE K B EH R IY Z",UNIVERSAL="Y UW N AH V ER S AH L",REPELLENT="R IH P EH L AH N T",OBEID="OW B AY D",LEUKOCYTE="L UW K AH S AY T",["REUTERS'S"]="R OY T ER Z IH Z",VANORDER="V AE N AO R D ER",ALGEBRA="AE L JH AH B R AH",TELESCO="T EH L EH S K OW",PECKENPAUGH="P IH K EH N P AO",PROCEEDING="P R AH S IY D IH NG",FONDLING="F AA N D AH L IH NG",TOKYU="T OW K Y UW",GRAVETTE="G R AH V EH T",SLAT="S L AE T",SIMPLISTIC="S IH M P L IH S T IH K",WARNS="W AO R N Z",["VAAPENFABRIKK(2)"]="V AA P AH N F AA B R IH K",EXTRAORDINARILY="EH K S T R AO R D AH N EH R AH L IY",LANGILL="L AE NG G AH L",ELECTIVE="IH L EH K T IH V",ELAT="EH L AE T",EARNS="ER N Z",FLAT="F L AE T",CARNS="K AA R N Z",DAVOX="D AE V AA K S",KARNS="K AA R N Z",KOPER="K OW P ER",LOPER="L OW P ER",DIETITIANS="D AY AH T IH SH AH N Z",BARNS="B AA R N Z",CLYBURN="K L IH B ER N",PLOCAR="P L OW K AA R",MANNARINO="M AE N ER IY N OW",GRAVITATING="G R AE V IH T EY T IH NG",FREEZER="F R IY Z ER",HOILAND="HH OY L AE N D",MERCHANDISERS="M ER CH AH N D AY Z ER Z",LEBOWE="L IH B OW",["THURSDAY'S"]="TH ER Z D IY Z",OVERWRITING="OW V ER R AY T IH NG",STAHLEY="S T AE L IY",PERSE="P ER S",SQUANDERS="S K W AA N D ER Z",TERSE="T ER S",LABARGE="L AE B AA R JH",VERSE="V ER S",GREGARIOUS="G R AH G EH R IY AH S",BEARUP="B EH R AH P",["VILLAGE'S"]="V IH L IH JH IH Z",BELZBERGS="B EH L T S B ER G Z",["ABSOLUT'S"]="AE B S AH L UW T S",["BILOXI'S"]="B AH L AH K S IY Z",ELTZROTH="EH L T S R AO TH",PROGNOSTICATING="P R AA G N AA S T AH K EY T IH NG",MENDELSOHN="M EH N D AH L S AH N",VIRGO="V ER G OW",FORKLIFT="F AO R K L IH F T",HUGGY="HH AH G IY",PROFS="P R AA F S",MCDANNEL="M AH K D AE N AH L",LUZHKOV="L UW ZH K AO V",BUGGY="B AH G IY",BARAFF="B AA R AA F",HORNBURG="HH AO R N B ER G",SWAT="S W AA T",["ACKNOWLEDGES(2)"]="IH K N AA L IH JH IH Z",FUNCTION="F AH NG K SH AH N",AUTHORITY="AH TH AO R AH T IY",MUGGY="M AH G IY",BLOWFISH="B L OW F IH SH",CATSKILLS="K AE T S K IH L Z",STONEROCK="S T OW N R AA K",WOHLWEND="W OW L W EH N D",SUBTERRANEAN="S AH B T ER EY N IY AH N",["IRVING'S"]="ER V IH NG Z",RESPLENDENT="R IY S P L EH N D AH N T",SYLVAIN="S IH L V EY N",DAENZER="D EH N Z ER",STOCKBROKER="S T AA K B R OW K ER",LUSITANIA="L UW S AH T EY N IY AH",HELOTRY="HH EH L AH T R IY",DISSEMINATING="D IH S EH M AH N EY T IH NG",STANDARDS="S T AE N D ER D Z",SEPICH="S EH P IH CH",MANIGO="M AA N IY G OW",["COLLEGE'S"]="K AA L IH JH IH Z",JACINTH="JH AE S IH N TH",DEMSKY="D EH M S K IY",NARANJA="N AA R AA N Y AH",OVERRULES="OW V ER R UW L Z",SCRIVER="S K R AY V ER",["PORSCHE(2)"]="P AO R SH",RECHECK="R IY CH EH K",MORITZ="M AO R IH T S",KUPER="K Y UW P ER",LUPER="L UW P ER",CANNELTON="K AE N AH L T AH N",HATTERY="HH AE T ER IY",DUPER="D UW P ER",["WHISENAND(2)"]="HH W IH S IH N AE N D",FRESENIUS="F R AH S IY N IY AH S",FASCINATING="F AE S AH N EY T IH NG",AGGREGATED="AE G R AH G EY T AH D",CHAPAS="CH AA P AH S",RECYCLERS="R IY S AY K L ER Z",PORPOISES="P AO R P AH S AH Z",KANIEWSKI="K AA N IY EH F S K IY",UNICORN="Y UW N IH K AO R N",GRIFFIS="G R IH F IH S",BERNY="B ER N IY",TRACEABLE="T R EY S AH B AH L",["WHEELER(2)"]="HH W IY L ER",BLAZEJEWSKI="B L AH Z EY EH F S K IY",["GOODMAN'S"]="G UH D M AE N Z",JANUSZ="Y AA N UH SH",KOOISTRA="K UW IH Z T R AH",BUNDLING="B AH N D AH L IH NG",["WESTALL'S"]="W EH S T AH L Z",["CHARGES(2)"]="CH AA R JH IH Z",MISCONSTRUE="M IH S K AH N S T R UW",WAYLAY="W EY L EY",BLOODSUCKERS="B L AH D S AH K ER Z",FORSYTH="F AO R S AY TH",HOTDOGS="HH AA T D AO G Z",REDLAND="R EH D L AH N D",["TOMATOS(2)"]="T AH M AA T OW Z",KOSKELA="K AH S K IY L AH",RESCHEDULING="R IY S K EH JH UW L IH NG",SUPER="S UW P ER",ACQUIRER="AH K W AY ER ER",RENTABLE="R EH N T AH B AH L",EVOLVED="IH V AA L V D",DURCHHOLZ="D ER CH OW L T S",FINALIZED="F AY N AH L AY Z D",SOKOLOV="S AA K AH L AA V",INDEPENDENTLY="IH N D IH P EH N D AH N T L IY",RAILBIKERS="R EY L B IH K ER Z",IMPULSE="IH M P AH L S",SPAT="S P AE T",DELPOZO="D EH L P OW Z OW",ARGUED="AA R G Y UW D",MCCLISH="M AH K L IH SH",BLASTFURNACE="B L AE S T F ER N AH S",SPECKER="S P EH K ER",COAT="K OW T",FRACTIOUS="F R AE K SH AH S",["TIMOR'S"]="T IY M AO R Z",PETTIS="P EH T IH S",BOAT="B OW T",CRICHLOW="K R IH K L OW",MOAT="M OW T",BETTIS="B EH T IH S",GOAT="G OW T",ELIZA="IH L AY Z AH",SOBIBOR="S OW B IY B AO R",BEGLEITER="B EH G L AY T ER",TOTEM="T OW T AH M",FOREBRAIN="F AO R B R EY N",ROAT="R OW T",SUFFERINGS="S AH F ER IH NG Z",SAKSIDA="S AA K S IY D AH",SUNDBY="S AH N D B IY",["CARNEGIES(2)"]="K AA R N EY G IY Z",BRANSFORD="B R AE N S F ER D",BRAT="B R AE T",GASPARA="G AH S P AA R AH",GOURLEY="G AO R L IY",AKIHITO="AA K IY HH IY T OW",KRAT="K R AE T",SCAMPERED="S K AE M P ER D",WRECKER="R EH K ER",TRECKER="T R EH K ER",MARYANN="M EH R IY AE N",REYBURN="R EY B ER N",STICKLEY="S T IH K L IY",HISTORICALLY="HH IH S T AO R IH K AH L IY",MICATIN="M AY K AH T IH N",HYDROLYZE="HH AY D R AH L AY Z",INTERROGATIONS="IH N T EH R AH G EY SH AH N Z",PINEDA="P IY N EH D AH",PYROTECHNICS="P AY R OW T EH K N IH K S",BECHTLE="B EH CH T AH L",WESRAY="W EH S R EY",KAKTOVIK="K AE K T OW V IH K",["DAZZLING(2)"]="D AE Z L IH NG",JEANINE="JH AH N IY N",WESOLOWSKI="V IH S AH L AO F S K IY",SAMANIEGO="S AA M AA N IY G OW",["WHITEHURST(2)"]="HH W AY T HH ER S T",ARTIFACT="AA R T AH F AE K T",["COLUMBUS'S"]="K AH L AH M B AH S IH Z",RYZHKOV="R AY Z K AA V",["LOOSESTRIFE(2)"]="L UW S T R AY F",SCOUNDRELS="S K AW N D R AH L Z",PATTIS="P AE T IH S",MANSIONS="M AE N CH AH N Z",LOTTERIES="L AA T ER IY Z",MATTIS="M AE T IH S",BRUMITT="B R UW M IH T",MCABEE="M AH K AE B IY",HIROYUKI="HH IH R OW Y UW K IY",GATTIS="G AE T IH S",BAGGY="B AE G IY",["COUNTY(2)"]="K AW N IY",BATTIS="B AE T IH S",MCCOSH="M AH K AA SH",HESLOP="HH EH S L AH P",DAGGY="D AE G IY",HOOFS="HH UH F S",NORDICA="N AO R D IH K AH",AGUILA="AA G W IY L AH",SCHRUMPF="SH R AH M P F",SEABEE="S IY B IY",UNDID="AH N D IH D",FUNNIEST="F AH N IY AH S T",TRAPEZE="T R AH P IY Z",CHAIREZ="CH AA IH R EH Z",BOARDINGPASS="B AO R D IH N G P AE S",ANGRIER="AE NG G R IY ER",FLUITT="F L UW AH T",TWINJET="T W IH N JH EH T",BASRA="B AA S R AA",SCHREMP="SH R EH M P",PHILANTHA="F IH L AE N TH AH",COMPARES="K AH M P EH R Z",BLUITT="B L UW T",CLOSE="K L OW S",BLOSE="B L OW Z",SHEER="SH IH R",ANDRZEJ="AA N D R EY",CRITICISMS="K R IH T IH S IH Z AH M Z",ENFORCED="EH N F AO R S T",MASOCHISM="M AE S AH K IH Z AH M",NUHN="N AH N",HUHN="HH AH N",REPUDIATED="R IY P Y UW D IY EY T AH D",KUHN="K UW N",LUHN="L AH N",FOOSE="F UW S",["CONABLE'S"]="K OW N AH B AH L Z",["HERTZENLEBEN'S"]="HH ER T AH N L EY B AH N Z",BOOSE="B UW S",["CENTRUST'S"]="S EH N T R AH S T S",DRUTHERS="D R AH DH ER Z",YORICH="Y AO R IH CH",NEWINGHAM="N UW IH NG HH AE M",PLACEWAY="P L EY S W EY",BAYTOWN="B EY T AW N",QUEER="K W IH R",SUMMAGRAPHICS="S AH M AH G R AE F IH K S",THANH="TH AE N",RUMMAGED="R AH M IH JH D",KOBZA="K AA B Z AH",["BOWATER(2)"]="B OW AO T ER",UNDESIRABLE="AH N D IH Z AY R AH B AH L",BANAMEX="B AE N AH M EH K S",CLUNKER="K L AH NG K ER",["HUGHEY(2)"]="HH Y UW IY",CRETIN="K R IY T AH N",SEWERAGE="S UW ER IH JH",WONDROUS="W AH N D R AH S",MONOLINGUAL="M AA N AH L IH NG G W AH L",DELIAL="D IH L AY EH L",NEUBERGER="N UW B ER G ER",RAJALA="R AA Y AA L AH",ESCAPE="IH S K EY P",CHEER="CH IH R",STILLWATER="S T IH L W AO T ER",MASAYOSHI="M AA S AA Y OW SH IY",HEUBERGER="HH OY B ER G ER",NARJES="N AA R Y AH S",UNDEREMPLOYMENT="AH N D ER IH M P L OY M AH N T",["SIZZLING(2)"]="S IH Z L IH NG",["HELMS'S"]="HH EH L M Z IH Z",STEER="S T IH R",["FIZZLING(2)"]="F IH Z L IH NG",BRETTHAUER="B R EH TH AW ER",["DELOSREYES(3)"]="D EH L OW S R EY AH Z",EXTRA="EH K S T R AH",YOHN="Y AA N",ENABLES="EH N EY B AH L Z",GREER="G R IH R",CREER="K R IH R",FREER="F R IY ER",FRIEDLEY="F R IY D L IY",HYDERABAD="HH AY D EH R AH B AE D",COWBELL="K AW B EH L",WORKSHEETS="W ER K SH IY T S",DUNNINGTON="D AH N IH NG T AH N",CHAIRMANSHIP="CH EH R M AH N SH IH P",KLOPPENBURG="K L AA P AH N B ER G",OVERTAKE="OW V ER T EY K",MASSENET="M AE S AH N EH T",HILLEGASS="HH IH L IH G AH S",["PLACID(2)"]="P L AE S IH D",CUDDEBACK="K AH D B AE K",["EINSTEIN'S"]="AY N S T AY N Z",ZEELAND="Z IY L AH N D",STEALEY="S T IY L IY",BUTCHERING="B UH CH ER IH NG",DAIEI="D AY EY",PROBLEMATIC="P R AA B L AH M AE T IH K",HOCHENHEIM="HH AO K AH N HH AY M",GEURTS="ZH ER T S",FRILEY="F R IH L IY",COARTICULATES="K OW AA R T IH K Y UW L EY T S",ARTRA="AA R T R AH",BRILEY="B R IH L IY",GERICH="G EH R IH K",INVESTIGATORS="IH N V EH S T AH G EY T ER Z",DEBONO="D IH B OW N OW",REMATCH="R IY M AE CH",PERICH="P ER IH K",NOURISHED="N ER IH SH T",["BARRICADES(2)"]="B EH R AH K EY D Z",ORILEY="OW R AY L IY",BRUNKER="B R AH NG K ER",SKIN="S K IH N",["DOCTORS'"]="D AA K T ER Z",OKIN="OW K IH N",["PARTRIDGE(2)"]="P AA R T R IH JH",SHAQUILLE="SH AH K IY L",NANOGRAMS="N AE N OW G R AE M Z",EUGENE="Y UW JH IY N",ALTRA="AA L T R AH",SPEER="S P IH R",VANDENBURG="V AE N D AH N B ER G",["CHURCHILL(2)"]="CH ER CH HH IH L",SCHIFFER="SH IH F ER",ABHORRED="AH B HH AO R D",LAFRENIERE="L AE F R IH N IY EH R",FARMWORKERS="F AA R M W ER K ER Z",MUSUMECI="M UW S UW M EH CH IY",POPULARLY="P AA P Y AH L ER L IY",REBROADCAST="R IY B R AO D K AE S T",POOLSIDE="P UW L S AY D",ICELAND="AY S L AH N D",APPEARANCE="AH P IH R AH N S",["GUERRILLAS'"]="G ER IH L AH Z",SUNSWEET="S AH N S W IY T",PANKAU="P AE NG K AW",MORIOKA="M AO R IY OW K AH",OVERDRAFTING="OW V ER D R AE F T IH NG",ROEBUCK="R OW B AH K",POTENCY="P OW T AH N S IY",VANVOORST="V AE N V UH R S T",BOHN="B OW N",COHN="K OW N",["RECEIVE(2)"]="R IH S IY V",KINGSHIP="K IH NG SH IH P",GOHN="G AA N",DOHN="D AA N",JOHN="JH AA N",KOHN="K AA N",ORGANIZING="AO R G AH N AY Z IH NG",BUTTOCKS="B AH T AH K S",BUSSIERE="B AH S IY EH R",MOHN="M AA N",ROHN="R AA N",SOHN="S AA N",MASSUCCI="M AA S UW CH IY",BINETTI="B IH N EH T IY",SHUNS="SH AH N Z",["PREDOMINATE(2)"]="P R IH D AA M AH N AH T",PHILPOT="F IH L P AH T",["FACET'S"]="F AE S AH T S",["ICE-NINE"]="AY S N AY N",PIQUED="P IY K T",THOMPSON="T AA M P S AH N",ATHEIST="EY TH IY AH S T",BRICKMAN="B R IH K M AH N",BOUGAINVILLE="B UW G IH N V IH L",IMPAIRMENT="IH M P EH R M AH N T",SCOFFS="S K AO F S",["FEATHERY(2)"]="F EH DH R IY",["CARTRIDGE(2)"]="K AA R T R IH JH",DOGMATISM="D AA G M AH T IH Z AH M",["VIOLIST'S"]="V IY OW L AH S T S",RACINESS="R EY S IY N AH S",OSSETIAN="AA S EH SH Y IH N",GUANINE="G W AA N IY N",ULRICH="AH L R IH CH",BILICKI="B IH L IH T S K IY",BREAST="B R EH S T",["FREIDY'S(2)"]="F R AY D IY Z",SECURE="S IH K Y UH R",ELRICH="EH L R IH CH",AGIN="AA JH IY N",RHIN="R IH N",SHIN="SH IH N",THIN="TH IH N",HAYTER="HH EY T ER",["DISTILLATE(2)"]="D IH S T AH L AH T",BLURTS="B L ER T S",SCULPTURED="S K AH L P CH ER D",DURFLINGER="D ER F AH L IH NG ER",HULCE="HH AH L S",SOLSTICES="S AO L S T IH S IH S",CHIN="CH IH N",THIAMIN="TH AY AH M AH N",WORSENED="W ER S AH N D",UNWORRIED="AH N W ER IY D",HADRIA="HH AE D R IY AH",["LIQUID(2)"]="L IH K W IH D",["RAISA(2)"]="R AA IY S AH",BLOODSHED="B L AH D SH EH D",BEFALTO="B AH F AA L T OW",ROOSE="R UW Z",MOOSE="M UW S",NOOSE="N UW S",FALSEHOODS="F AE L S HH UH D Z",RHUBARB="R UW B AA R B",KNIEVEL="K AH N IY V AH L",LOOSE="L UW S",["GRUMMOND'S"]="G R AH M AH N D Z",TERRIBLE="T EH R AH B AH L",BARTHOLOMEW="B AA R TH AA L AH M Y UW",OBEYING="OW B EY IH NG",ULTRA="AH L T R AH",KIROUAC="K AY R AW AE K",STATOIL="S T AH T OY L",SULLENGER="S UW L IH N JH ER",EMRICH="EH M R IH K",LILLIANA="L IH L IY AE N AH",["O'KICKI"]="OW K IH K IY",GANGBUSTER="G AE NG B AH S T ER",WHIMSY="W IH M S IY",["RECEPTIONIST(2)"]="R IY S EH P SH AH N IH S T",CAIRNES="K EH R N Z",KEHN="K EH N",PETRA="P EH T R AH",HOWERTER="HH AW ER T ER",IVORIANS="AY V AO R IY AH N Z",TETRA="T EH T R AH",CRAYON="K R EY AA N",BEHN="B EH N",DEHN="D EH N",SCHUH="SH UW",FEHN="F EH N",MULTIFAMILY="M AH L T AY F AE M AH L IY",METRA="M EH T R AH",FIERCER="F IH R S ER",["LANOLIN(2)"]="L AE N AH L IH N",DEFER="D IH F ER",INTRA="IH N T R AH",TROENDLE="T R OW N D AH L",CELEBRE="S EH L AH B R AH",SHOCKER="SH AA K ER",STEEDLEY="S T IY D L IY",GARIBALDI="G AE R AH B AO L D IY",SCHOENROCK="SH OW N R AH K",ABASCAL="AE B AH S K AH L",BARRIO="B AA R IY OW",CYPRIOTS="S IH P R IY AH T S",["GOLDMAN'S"]="G OW L D M AH N Z",TERRIO="T EH R IY OW",["CARRIES(2)"]="K EH R IY Z",SCHAEFFLER="SH AE F L ER",EVISCERATE="AH V IH S ER EY T",["ENLISTED(2)"]="IH N L IH S T AH D",CROCKER="K R AA K ER",BROCKER="B R AA K ER",LUCIANNE="L UW S IY AE N",ITALIANO="IH T AA L IY AA N OW",ALDIS="AA L D IH S",DEMAGOGY="D EH M AH G AA JH IY",URQUIZA="ER K W IY Z AH",INSIGHTS="IH N S AY T S",CHODOROW="CH OW D ER OW",PUZZLEMASTER="P AH Z AH L M AE S T ER",["GEARHART(2)"]="G IY R HH AA R T",["STOUFFER(2)"]="S T OW F ER",DULCEA="D AH L S IY AH",SOFTWOOD="S AO F T W UH D",REHN="R EH N",THURNHER="TH ER N ER",["LAWNER(2)"]="L AW N ER",HAHN="HH AA N",SIDESTEPPED="S AY D S T EH P T",CAHN="K AE N",DAHN="D AE N",RAHN="R AE N",KAHN="K AA N",LAHN="L AE N",MAHN="M AE N",YAMAZAKI="Y AA M AA Z AA K IY",REVVED="R EH V D",VAGUINE="V AH G W IY N",BAHN="B AE N",KOCIS="K OW S IH S",UNALLOYED="AH N AE L OY D",STOCKER="S T AA K ER",GRIFFITTS="G R IH F IH T S",BUTULESI="B UW T AH L EY Z IY",CHECKERED="CH EH K ER D",USEFULNESS="Y UW S F AH L N AH S",["NEXT'S"]="N EH K S T S",WHISPERED="W IH S P ER D",BOTANICALLY="B AH T AE N AH K AH L IY",["ABTS(3)"]="EY B IY T IY EH S",NEMITZ="N EH M IH T S",["CELO(3)"]="S IY IY EH L OW",DILEMMAS="D AH L EH M AH Z",DELOATCH="D EH L OW CH",GRIMME="G R IH M",STRATEGICAL="S T R AH T IY JH IH K AH L",UNCENSORED="AH N S EH N S ER D",["ORSBURN(2)"]="AO R Z B ER N",ARAUJO="AA R AW Y OW",ODONOVAN="OW D AA N AH V AH N",REFER="R AH F ER",SUBMISSIONS="S AH B M IH SH AH N Z",DOLCE="D OW L CH EY",STABLES="S T EY B AH L Z",["VONSTEIN(2)"]="V AA N S T IY N",BENETTI="B EH N EH T IY",KASPEREK="K AE S P ER IH K",VIRILE="V IH R AH L",SPENDABLE="S P EH N D AH B AH L",ETHENE="EH TH IY N",SHOAFF="SH OW F",MARGO="M AA R G OW",CROSSWALK="K R AA S W AA K",BOERNER="B AO R N ER",DOERNER="D AO R N ER",CARGO="K AA R G OW",THOUSANDS="TH AW Z AH N D Z",INFER="IH N F ER",FARGO="F AA R G OW",OLMEDA="OW L M EY D AH",GOERNER="G AO R N ER",HOERNER="HH AO R N ER",KOERNER="K AO R N ER",ARREDONDO="AA R EH D OW N D OW",BLILEY="B L AY L IY",GONORRHEA="G AA N ER IY AH",TAILORED="T EY L ER D",BLECHA="B L EH CH AH",INSPIRES="IH N S P AY R Z",PHYSICALS="F IH Z IH K AH L Z",TRANQUILITY="T R AE NG K W IH L IH T IY",HELMINIAK="HH EH L M IH N IY AE K",ANDRIA="AE N D R IY AH",BEGEMAN="B IY G M AH N",ENFOLD="IH N F OW L D",FRACTURED="F R AE K CH ER D",SMUGGLER="S M AH G L ER",RAMSAY="R AE M Z IY",EDICT="IY D IH K T",TUNGSTEN="T AH NG S T AH N",INSUBSTANTIAL="IH N S AH B S T AE N CH AH L",MADIS="M AE D AH S",BLUMBERG="B L AH M B ER G",ADDIS="AA D IH S",NOVAKOVICH="N AH V AA K AH V IH CH",DRABENSTOTT="D R AH B EH N S T AH T",GATTUSO="G AA T UW S OW",LAFER="L EY F ER",KAFER="K EY F ER",PENCE="P EH N S",WOERNER="W AO R N ER",SAFER="S EY F ER",BENCE="B EH N S",HENCE="HH EH N S",FENCE="F EH N S",NELLIANA="N EH L IY AE N AH",PREVENTATIVE="P R IY V EH N T AH T IH V",WAFER="W EY F ER",JUXTAPOSITION="JH AH K S T AH P AH Z IH SH AH N",MERRIWEATHER="M EH R IH W EH DH ER",FAUCETS="F AO S AH T S",DAMITZ="D AE M IH T S",WARGO="W AO R G OW",PRATTE="P R AE T",PERMUTATIONS="P ER M Y UW T EY SH AH N Z",POLICYHOLDER="P AA L AH S IY HH OW L D ER",GAMETE="G AE M IY T",TATRA="T AE T R AH",MARICH="M AE R IH K",PREMONITION="P R EH M AH N IH SH AH N",REELECTED="R IY IH L EH K T AH D",BARICH="B AE R IH K",ALUMNI="AH L AH M N AY",ADELMANN="AE D AH L M AH N",DEITRICK="D AY T R IH K",["MIRANDA'S"]="M ER AE N D AH Z",EDELMANN="EH D AH L M AH N",PROLACTIN="P R OW L AE K T AH N",DERFLINGER="D ER F AH L IH NG ER",RUDIMENTARY="R UW D AH M EH N T ER IY",MATRA="M AE T R AH",INTERACCIONES="IH N T ER AE K S IY OW N Z",APRILE="AA P R AH L",CALIFANO="K AA L IY F AA N OW",TABLATURE="T AE B L AH CH ER",MUTINIED="M Y UW T AH N IY D",GRAVESTONE="G R EY V S T OW N",BATRA="B AE T R AH",LOFLAND="L AA F L AH N D",HIGHSPEED="HH AY S P IY D",HOFLAND="HH AA F L AH N D",CLARENDON="K L EH R AH N D AH N",SURFACENESS="S ER F AH S N AH S",BROCKLIN="B R AA K L IH N",SHILEY="SH IH L IY",HUNTOON="HH AH N T UW N",STACHOWSKI="S T AH CH AO F S K IY",ANTRIM="AE N T R IH M",["ESCOBAR'S(2)"]="EH S K AH B AA R Z",GREYING="G R EY IH NG",TAMIAMI="T AE M IY AE M IY",TAPEIE="T EY P IY EY",VEDIS="V EY D IH S",SMILEY="S M AY L IY",PERMUTE="P ER M Y UW T",VANCE="V AE N S",["SUCCESSES(2)"]="S AH K S EH S IH Z",SPECIALE="S P EH CH AH L IY",["ENACTMENTS(3)"]="EH N AE K M AH N S",RANCE="R AE N S",MANCE="M AE N S",JAKUBIAK="Y AH K AH B IY AE K",["INVITED(2)"]="IH N V AY T IH D",LANCE="L AE N S",HANCE="HH AE N S",DANCE="D AE N S",COLORCRAFT="K AH L ER K R AE F T",RIBEIRO="R IY B EH R OW",GALVANIZED="G AE L V AH N AY Z D",PREYING="P R EY IH NG",ARTERY="AA R T ER IY",MORSE="M AO R S",DWIVEDI="D W IH V EH D IY",NORSE="N AO R S",BORSE="B AO R S",CORSE="K AO R S",HORSE="HH AO R S",FORSE="F AO R S",["WESAT(2)"]="W IY S AE T",GUMMI="G AH M IY",SARRA="S AA R AH",["RECANTATION(2)"]="R IY K AE N T EY SH AH N",MEEUWSEN="M IY UW S AH N",["SWIVELING(2)"]="S W IH V L IH NG",ONSITE="AA N S AY T",FARRA="F AA R AH",CARRA="K AA R AH",REIMBURSING="R IY IH M B ER S IH NG",PARRA="P AA R AH",MARRA="M AA R AH",NUMMI="N UW M IY",BISCHEL="B IH SH AH L",GRIGNON="G R IH G N AH N",FISCHEL="F IH SH AH L",MATHUR="M AE TH ER",NONFICTION="N AA N F IH K SH AH N",RAMALA="R AH M AA L AH",MISCHEL="M IH SH AH L",PERCUTANEOUS="P ER K Y UW T EY N IY AH S",PIASECKI="P IY AH S EH T S K IY",["ORTHODONTIST'S"]="AO R TH AH D AA N T AH S T S",RUTILE="R UW T IY L",MIXUPS="M IH K S AH P S",INTERPRETING="IH N T ER P R EH T IH NG",GRIDLOCK="G R IH D L AA K",INTESTINAL="IH N T EH S T AH N AH L",COOPERMAN="K UW P ER M AE N",["GINGOLD(2)"]="G IH N G OW L D",["SEIDMAN'S"]="S AY D M AH N Z",KIRKUM="K IH R K AH M",HOOPERMAN="HH UW P ER M AH N",HILLSIDE="HH IH L S AY D",SOSSAMON="S OW S AA M AO N",PIFER="P AY F ER",BEBBER="B EH B ER",HURRAY="HH AH R EY",PASSAGE="P AE S AH JH",LIFER="L AY F ER",KIFER="K AY F ER",MECHEM="M EH K IH M",MURRAY="M ER IY",MASSAGE="M AH S AA ZH",SODOMY="S AA D AH M IY",LICHTEN="L IH K T AH N",ARMENIANS="AA R M IY N IY AH N Z",["CURRENT'S"]="K ER AH N T S",ACHIEVERS="AH CH IY V ER Z",BARTKOWSKI="B ER T K AO F S K IY",WEBBER="W EH B ER",KNEELAND="N IY L AH N D",WORSE="W ER S",COACHING="K OW CH IH NG",URFER="ER F ER",CAUTERIZE="K AO T ER AY Z",HOLIDAYSBURG="HH AA L AH D EY Z B ER G",BICEPS="B AY S EH P S",["TRANSLATION(2)"]="T R AE N S L EY SH AH N",CONSTANTS="K AA N S T AH N T S",POACHING="P OW CH IH NG",ASHLEY="AE SH L IY",PROPRIETOR="P R AH P R AY AH T ER",MANMADE="M AE N M EY D",["KIRYAT(2)"]="K IH R Y AA T",["VENEZUELA'S"]="V EH N IH Z W EY L AH Z",["TECHNOLOGIES'"]="T EH K N AA L AH JH IY Z",["SOLACE(2)"]="S OW L IH S",["CONFEDERACY'S"]="K AH N F EH D ER AH S IY Z",["NEWSLINK'S"]="N UW Z L IH NG K S",DERUYTER="D IH R AY T ER",SONOGRAMS="S AO N AH G R AE M Z",FRALICK="F R AE L IH K",BROOKSHIRE="B R UW K SH AY R",PISCHEL="P IH SH AH L",COMBATANTS="K AH M B AE T AH N T S",FORSWORN="F AO R S W AO R N",RESTRICT="R IY S T R IH K T",STENERSON="S T EH N ER S AH N",["WHITMILL(2)"]="HH W IH T M IH L",ALEUTIAN="AH L UW SH AH N",STONEHENGE="S T OW N HH EH N JH",GALVANIZING="G AE L V AH N AY Z IH NG",DOWNTURN="D AW N T ER N",["NORANDA'S"]="N AO R AE N D AH Z",ALEWIVES="EY L W AY V Z",MISKELL="M IH S K AH L",BUFFONE="B UW F OW N IY",AMENDABLE="AH M EH N D AH B AH L",MARSHAL="M AA R SH AH L",ANTIOXIDANTS="AE N T IY AA K S AH D AH N T S",FREELAND="F R IY L AH N D",BREELAND="B R IY L AH N D",["PROJECTS(2)"]="P R AH JH EH K T S",TRIVEDI="T R IY V EH D IY",DEHARBE="D AH HH AA R B IY",SENSATIONALIZES="S EH N S EY SH AH N AH L AY Z IH Z",NUFER="N UW F ER",PLOSIVE="P L OW S IH V",SHIFFLETT="SH IH F L IH T",["RABID(2)"]="R EY B IH D",MISCONCEIVE="M IH S K AH N S IY V",CORKUM="K AO R K AH M",FACILITATING="F AH S IH L AH T EY T IH NG",VELASQUEZ="V EH L AE S K EH Z",WHEELAND="W IY L AH N D",SPITEFUL="S P AY T F AH L",NORWITZ="N AO R W IH T S",SHITILA="SH AH T IH L AH",EURICH="OY R IH K",IMMIGRATION="IH M AH G R EY SH AH N",SPRUNGER="S P R AH NG ER",AURICH="AW R IH K",BURICH="B EH R IH K",HOWELLS="HH AW AH L Z",SOFER="S OW F ER",HOFER="HH OW F ER",COFER="K OW F ER",EROSIVE="IH R OW S IH V",BERGSTEN="B ER G S AH N",ALLEGRA="AA L EH G R AH",VALESKA="V AA L EY S K AH",["HIGH-PROFILE"]="HH AY P R OW F AY L",ERIKSSON="EH R IH K S AH N",RUBBIA="R AH B IY AH",SPILLAGE="S P IH L IH JH",PSYCHIATRY="S AY K AY AH T R IY",REOFFERED="R IY AO F ER D",BEGETS="B IH G EH T S",["FUNDAMENTALLY(2)"]="F AH N D AH M EH N AH L IY",WILLIAMS="W IH L Y AH M Z",SEETIN="S IY T IH N",LUSIGNAN="L AH S IH G N AH N",BHATTI="B AA T IY",HIGNITE="HH IH G N AY T",OPFER="AA P F ER",LIGNITE="L IH G N AY T",ENUMERATION="IH N UW M ER EY SH AH N",["CONSTITUENTS'"]="K AH N S T IH CH UW AH N T S",HAMSTRING="HH AE M S T R IH NG",HORWITZ="HH AO R W IH T S",ISOLATING="AY S AH L EY T IH NG",SALMERON="S AA L M EH R AO N",MARSHY="M AA R SH IY",BECERRIL="B EY S EH R IY L",BARTOLUCCI="B AA R T OW L UW CH IY",MIHN="M IH N",KIHN="K IH N",ARDIS="AA R D IH S",BIHN="B IH N",ACTIVATES="AE K T AH V EY T S",IBERIA="AY B IH R IY AH",BLOCKER="B L AA K ER",CLOCKER="K L AA K ER",EYRICH="EH R IH CH",ENQUIRER="IH N K W AY R ER",BLANKINSHIP="B L AE NG K IH N SH IH P",MORPHINE="M AO R F IY N",AUTERY="OW T ER IY",JOCHEM="JH AA K IH M",UNCHALLENGED="AH N CH AE L IH N JH D",MISUNDERSTOOD="M IH S AH N D ER S T UH D",CITGO="S IH T G OW",RUBBO="R UW B OW",SLOVENIA="S L OW V IY N IY AH",POLITZ="P AA L IH T S",HEITKAMP="HH AY T K AE M P",ARNESEN="AA R N IY Z AH N",["MENSTRUAL(2)"]="M EH N S T R AH L",TELEVISION="T EH L AH V IH ZH AH N",["REPORTED(2)"]="R IH P AO R T AH D",NORGAARD="N AO R G AA R D",METICULOUSLY="M AH T IH K Y AH L AH S L IY",LOFTIN="L AA F T IH N",MCCULLER="M AH K AH L ER",["PONTIFF'S"]="P AA N T AH F S",KNUEPPEL="K N UW P AH L",TOVAZ="T OW V AA Z",HASKELL="HH AE S K AH L",PORCHIA="P AO R K IY AH",JAWBONING="JH AO B OW N IH NG",GASKELL="G AE S K AH L",TORCHIA="T AO R K IY AH",["RESORTS(3)"]="R IY S AO R T S",GOUVEIA="G UW V EH Y AH",RUDIS="R UW D IY Z",BLOCKAGE="B L AA K IH JH",UPSHUR="AH P SH ER",LEVINER="L EH V IH N ER",AUDIS="AO D IH S",PROMISCUOUS="P R OW M IH S K W AH S",["MILSTEIN(2)"]="M IH L S T IY N",LOBBYING="L AA B IY IH NG",SAVOY="S AH V OY",HULTGREN="HH AH L T G R EH N",["FEDERALISTS(2)"]="F EH D ER AH L IH S",MUSTACHIOED="M AH S T AE SH IY OW D",RIHN="R IH N",LAVOY="L AH V OY",TOPETE="T AA P IY T",FANDANGO="F AE N D AE NG G OW",STAMFORD="S T AE M F ER D",UNREDEEMED="AH N R IY D IY M D",["GERTLER(2)"]="G ER T L ER",AUNGST="AW NG G S T",SPURTS="S P ER T S",HAAGENSON="HH AA G IH N S AH N",DEBAUN="D EH B AW N",VENZKE="V EH N Z K",LAFONTANT="L AA F AA N T AH N T",ROBBER="R AA B ER",DISILLUSIONMENT="D IH S IH L UW ZH AH N M AH N T",SOYARS="S OY ER Z",["RIPPLING(2)"]="R IH P L IH NG",THEIS="DH AY Z",INJUNCTIONS="IH N JH AH NG K SH AH N Z",BOBBER="B AA B ER",ANZALONE="AE N Z AH L OW N",LANZET="L AE N Z AH T",JOBBER="JH AA B ER",AFFABLY="AE F AH B L IY",MEANDERING="M IY AE N D ER IH NG",PLUNKETT="P L AH NG K IH T",["ESTERLINE'S"]="EH S T ER L AY N Z",OFFERMAN="AO F ER M AH N",PODHORETZ="P AA D HH ER EH T S",KASICH="K AA S IH CH",STUCKEY="S T AH K IY",["MACHINATION(2)"]="M AE SH AH N EY SH AH N",PRENSA="P R EH N S AH",MUNDEN="M AH N D AH N",LUNDEN="L AH N D AH N",["KREIDLER(2)"]="K R AY D L ER",LINSAY="L IH N S EY",MCCONKEY="M AH K AA NG K IY",RUBBER="R AH B ER",LUBBER="L AH B ER",["DIALING(2)"]="D AY L IH NG",BOBBO="B AA B OW",FIDATA="F IH D AA T AH",SCAVENGING="S K AE V AH N JH IH NG",UNINCORPORATED="AH N IH N K AO R P ER EY T IH D",STRITE="S T R AY T",["SHANDWICK'S"]="SH AE N D W IH K S",MOBILIZATIONS="M OW B AH L AH Z EY SH AH N Z",["ADMINISTRATORS'"]="AE D M IH N AH S T R EY T ER Z",REALTY="R IY AH L T IY",ANALYST="AE N AH L AH S T",COONROD="K UW N R AA D",MALTOSE="M AO L T OW S",KLARICH="K L AE R IH K",["REBELS(2)"]="R IH B EH L Z",WEISENBURGER="W AY S AH N B ER G ER",MALICKI="M AH L IH K IY",SHINRI="SH IH N R IY",KAMRA="K AE M R AH",PONTIFICATE="P AA N T IH F AH K EY T",WALICKI="W AH L IH K IY",AFFILIATIONS="AH F IH L IY EY SH AH N Z",UNDERCAPITALIZE="AH N D ER K AE P AH T AH L AY Z",ZAJICEK="Z AY IH CH EH K",["RESO(3)"]="R IH S OW",SAMRA="S AE M R AH",REATTA="R IY AA T AH",DOMAGALA="D OW M AA G AA L AH",["GRANDMAISON(2)"]="G R AE N D M EY S AH N",GOSSAGE="G AO S IH JH",ENORMOUS="IH N AO R M AH S",KRUMHOLZ="K R AH M HH OW L Z",SHEALEY="SH IY L IY",SUBMACHINE="S AH B M AH SH IY N",NEWSOM="N UW Z AH M",MINISTERSHIP="M IH N IH S T ER SH IH P",VIOLATING="V AY AH L EY T IH NG",PRETTY="P R IH T IY",MARCELLINA="M AA R CH EH L IY N AH",["RABBANI(2)"]="R AH B AA N IY",MAILEY="M EY L IY",RAILEY="R EY L IY",PYRITE="P AY R AY T",ATMOSPHERE="AE T M AH S F IH R",BRAYFIELD="B R EY F IY L D",["WRANGLING(2)"]="R AE NG G L IH NG",["HERRLINGER(2)"]="HH EH R L IH NG G ER",THOMSON="T AA M S AH N",["SUNTRUST'S"]="S AH N T R AH S T S",JURICH="JH UH R IH K",OPOSSUM="OW P AA S AH M",["TOPPLING(2)"]="T AA P L IH NG",MOUSERS="M AW Z ER Z",["ONE-UP-MANSHIP"]="W AH N AH P M AE N SH IH P",GAYLORD="G EY L AO R D",BERTOLUCCI="B ER T OW L UW CH IY",SUBCULTURES="S AH B K AH L CH ER Z",FEALTY="F IY AH L T IY",SHAMROCK="SH AE M R AA K",DRIEHAUS="D R IY HH AW S",ANDIS="AE N D IH S",MESSAGE="M EH S AH JH",REGAINED="R IY G EY N D",UHRICH="UH R IH K",["BARROWS(2)"]="B EH R OW Z",["IBERIA'S"]="AY B IH R IY AH Z",EHRICH="EH R IH K",VROOMAN="V R UW M AH N",OVERALLS="OW V ER AO L Z",DOANH="D OW N",HEINZEL="HH AY N Z AH L",BAILEY="B EY L IY",["NEWT'S"]="N UW T S",["LIBRETTO(2)"]="L IH B R EH T OW",GAILEY="G EY L IY",DAILEY="D EY L IY",FONTAINE="F AO N T EY N",MAGNETITE="M AE G N AH T AY T",HAILEY="HH EY L IY",ELECTRIQUE="EH L EH K T R IY K",PIECHOTA="P IY HH OW T AH",LAWHORNE="L AE W ER N",NECKWEAR="N EH K W EH R",REPACKAGE="R IY P AE K IH JH",OUTGO="AW T G OW",AROSE="ER OW Z",CROSE="K R OW Z",BROSE="B R OW Z",BOYTER="B OY T ER",GROSE="G R OW Z",CREOSOTE="K R IY AH S OW T",MONDRAGON="M OW N D R AA G AO N",MARIANNE="M EH R IY AE N",SORRELLS="S AO R AH L Z",["KAVNER(2)"]="K AO V N ER",PICKAR="P IH K AA R",LEONETTI="L EH N EH T IY",BALLENGER="B AE L IH N JH ER",SILVESTRO="S IY L V EY S T R OW",TWERSKY="T W ER S K IY",["ULTRANATIONALIST'S"]="AH L T R AH N AE SH AH N AH L AH S T S",PANGBORN="P AE NG B AO R N",VITRIOL="V IH T R IY AH L",SLANDERING="S L AE N D ER IH NG",EIRICH="AY R IH K",ALERIA="AH L IY R IY AH",["COUNTERCHARGES(2)"]="K AW N ER CH AA R JH IH Z",PROSE="P R OW Z",MARITZ="M EH R IH T S",CHARBONNET="SH AA R B AH N IH T",REMEDYING="R EH M AH D IY IH NG",FEREBEE="F EH R IH B IY",SALMI="S AA L M IY",IRRITANTS="IH R AH T AH N T S",MORTGAGEPOWER="M AO R G IH JH P AW R",BLISSFUL="B L IH S F AH L",CLOER="K L OW ER",INTERGROUP="IH N T ER G R UW P",KLEIS="K L AY Z",SUPERMAC="S UW P ER M AE K",MATTOCKS="M AE T AH K S",KIRKEBY="K ER K IH B IY",PETERPAUL="P IY T ER P AO L",CULPABILITY="K AH L P AH B IH L IH T IY",DEBILITATING="D AH B IH L AH T EY T IH NG",LINGENFELTER="L IH NG G IH N F IH L T ER",["JACOBIN(2)"]="JH AE K AH B IH N",BOATYARD="B OW T Y AA R D",SESTANOVICH="S EH S T AE N AH V IH CH",ERIDANIA="EH R IH D AE N IY AH",TAXIDERMIST="T AE K S AH D ER M AH S T",LAPSE="L AE P S",LYNDEN="L IH N D AH N",SPRITE="S P R AY T",SOVEREIGNTY="S AA V R AH N T IY",NICKOLAS="N IH K AH L AH Z",ILLUSTRATIVE="IH L AH S T R AH T IH V",FLEXIBILITY="F L EH K S AH B IH L AH T IY",HALMI="HH AO L M IY",SMOOTHEN="S M UW DH IH N",["REHKOPF(2)"]="R EH K AO F",LONGCOR="L OW NG G K AO R",HICFA="HH IH K F AH",ANTIBIOTIC="AE N T IY B IY AA T IH K",SABUNUMA="S AE B UW N AH M AH",TORRENTIAL="T AO R EH N CH AH L",INITIALIZE="IH N IH SH AH L AY Z",BEMBRY="B EH M B R IY",FELDKAMP="F EH L D K AE M P",BUMBAUGH="B AH M B AO",BUMBLY="B AH M B L IY",["HIMALAYA(2)"]="HH IH M AH L EY AH",PERFUNCTORY="P ER F AH NG K T ER IY",HUGLEY="HH AH G L IY",HUMBLY="HH AH M B L IY",EDUARDO="EH D W AA R D OW",LIQUIDATIONS="L IH K W IH D EY SH AH N Z",RUMBAUGH="R AH M B AO",COMPETITION="K AA M P AH T IH SH AH N",BETRAYING="B IH T R EY IH NG",TICER="T AY S ER",DEGUIRE="D EY G W IH R EY",BREAKOUTS="B R EY K AW T S",NICER="N AY S ER",MANTIS="M AE N T IH S",LANTIS="L AA N T IH S",CHRISTENDOM="K R IH S AH N D AH M",MINAR="M AY N ER",NEWBAUER="N UW B AW ER",SINAR="S AY N ER",QUINNEY="K W IH N IY",["ACERO(2)"]="AH S Y EH R OW",["FEBRUARY'S"]="F EH B Y AH W EH R IY Z",ISSUED="IH SH UW D",CONNELY="K AA N L IY",UNFORESEEABLE="AH N F AO R S IY AH B AH L",GENIERE="JH EH N Y EH R",TRAUMATIZE="T R AO M AH T AY Z",MAITRE="M EY T R AH",GRABBE="G R AE B",KRABBE="K R AE B",UNMERCIFUL="AH N M ER S IH F AH L",CRABBE="K R AE B",KREUTER="K R OY T ER",PICINICH="P IH S IH N IH CH",DRAINED="D R EY N D",METEORS="M IY T IY ER Z",BRAINED="B R EY N D",MARSUPIAL="M AA R S UW P IY AH L",METALLURGICAL="M EH T AH L ER JH IH K AH L",DINAR="D IH N AA R",THIEF="TH IY F",CITRIN="S IH T R IH N",ELECTROSPACE="IH L EH K T R OW S P EY S",TRAINED="T R EY N D",WOODSHEDS="W UH D SH EH D Z",SCOREBOARD="S K AO R B AO R D",ABBOTTSTOWN="AE B AH T S T AW N",["COMICALLY(2)"]="K AA M IH K L IY",GARRABRANT="G AA R AA B R AH N T",CENVILL="S EH N V IH L",KETCHLEDGE="K EH CH L EH JH",FINLANDIZATION="F IH N L AE N D IH Z EY SH AH N",VEVILA="V EY V IY L AH",PLAIT="P L EY T",INVOLVING="IH N V AA L V IH NG",HIGLEY="HH IH G L IY",SIGLEY="S IH G L IY",MAGUIRE="M AH G W AY R",ENSHROUDED="IH N SH R AW D AH D",CHIEF="CH IY F",WIGLEY="W IH G L IY",ESTRIN="EH S T R IH N",["REQUIRING(2)"]="R IY K W AY R IH NG",DEMOCRATS="D EH M AH K R AE T S",VACCINA="V AE K S IY N AH",PHENOTYPE="F IY N AH T AY P",SOCIOLOGISTS="S OW S IY AA L AH JH IH S T S",MELBURN="M EH L B ER N",PETITE="P AH T IY T",DUFFETT="D AH F IH T",HURRICANE="HH ER AH K EY N",MAXIMAL="M AE K S AH M AH L",BRESCIA="B R EH S CH AH",BIGLEY="B IH G L IY",BLOWHARD="B L OW HH AA R D",MILBOURNE="M IH L B UH R N",KILBOURNE="K IH L B ER N",LOBBIA="L AA B IY AH",MCGUIRE="M AH G W AY R",PEAUDOUCE="P OW D UW S",BRACCO="B R AE K OW",ACHATZ="AE K AH T S",["MONEYWEEK'S"]="M AH N IY W IY K S",LEHRKE="L EH R K",WILBOURNE="W IH L B ER N",GREASER="G R IY S ER",LIONETTI="L IY AH N EH T IY",GEHRKE="JH EH R K",["GRANDMAS(3)"]="G R AE M AA Z",["RING'S"]="R IH NG Z",MUNGO="M AH NG G OW",RESPONSIBILITIES="R IY S P AA N S AH B IH L AH T IY Z",["SANCTIONS'(2)"]="S AE NG SH AH N Z",["O'GLOVE"]="OW G L AH V",DEVONSHIRE="D IH V AA N SH AY R",ATTEMPTS="AH T EH M P T S",CHAIT="CH EY T",JOHNDROW="JH AA N D R OW",SWINNEY="S W IH N IY",LOVELACE="L AH V L EY S",EACHAN="IY CH AH N",["SING'S"]="S IH NG Z",SCHATZ="SH AE T S",SMIRNOFF="S M ER N AO F",WOODROME="W UH D R AH M",TENTH="T EH N TH",PENIX="P EH N IH K S",["O'HALLORON"]="OW HH AE L ER AH N",STRIDER="S T R AY D ER",["MARTIN(2)"]="M AA R T IH N",LIFTIN="L IH F T IH N",["LEVERAGING(2)"]="L EH V ER IH JH IH NG",["BLAUSTEIN(2)"]="B L AW S T IY N",SCRIPTWRITERS="S K R IH P T R AY T ER Z",["LUNTZ'"]="L AH N T S",DEVEAUX="D IH V OW",TOPPINGS="T AA P IH NG Z",RECITED="R AH S AY T AH D",LEITHA="L IY DH AH",STAINED="S T EY N D",CAWTHORN="K AO TH ER N",HILBURN="HH IH L B ER N",KILBURN="K IH L B ER N",ENSUED="IH N S UW D",FRAGMENTING="F R AE G M AH N T IH NG",STREAKED="S T R IY K T",ELECTIONEERING="IH L EH K SH AH N IH R IH NG",SKYDOME="S K AY D OW M",WILBURN="W IH L B ER N",MELBOURNE="M EH L B ER N",HOUSEKEEPERS="HH AW S K IY P ER Z",MULCHING="M AH L CH IH NG",BRUSE="B R UW Z",POLLINATE="P AA L AH N EY T",UPROOTING="AH P R UW T IH NG",CUBIT="K Y UW B IH T",ANGLEY="AE NG G L IY",CONSERVATORS="K AH N S ER V AH T ER Z",SCHOOLBOOKS="S K UW L B UH K S",DRUSE="D R UW Z",ORBIT="AO R B AH T",["DENG'S"]="D EH NG Z",BULLFROGS="B UH L F R AO G Z",["TABLING(2)"]="T EY B L IH NG",REAFFILIATION="R IY AH F IH L IY EY SH AH N",VALEDA="V AA L EY D AH",SHERBURNE="SH ER B ER N",DOCENT="D OW S AH N T",VIVRA="V IY V R AH",CONSISTENCY="K AH N S IH S T AH N S IY",SHREDDER="SH R EH D ER",ASCENSION="AH S EH N SH AH N",CHAINED="CH EY N D",GOODFELLOW="G UH D F EH L OW",["INFORMATICS(2)"]="IH N F AO R M AE T IH K S",CZAJKA="CH AY K AH",LIPSHUTZ="L IH P SH AH T S",SEDIMENTARY="S EH D AH M EH N T ER IY",ROUSE="R AW S",FIACCO="F IY AA K OW",["PROTECTED(3)"]="P ER T EH K T IH D",MOUSE="M AW S",LOUSE="L AW S",MAROTTO="M AA R OW T OW",BEABER="B IY B ER",COUSE="K AW S",BOUSE="B AW S",DOUSE="D AW S",FOUSE="F AW S",KATARINA="K AA T ER IY N AH",CAUTERIZED="K AO T ER AY Z D",LAUF="L AO F",CONSPIRACY="K AH N S P IH R AH S IY",SCHALOW="SH AE L OW",DARNEL="D AA R N AH L",DECRESCENZO="D IH K R EH S CH EH N Z OW",MOFFETT="M AA F IH T",RECEIVER="R AH S IY V ER",EDITHA="EH D IH DH AH",NIGHTLINES="N AY T L AY N Z",MCGUANE="M AH G W EY N",["ELATERS(2)"]="IH L EY T ER Z",["FREEMEN'S"]="F R IY M EH N Z",NIEHOFF="N IY HH AO F",["GANG'S"]="G AE NG Z",COXEN="K AA K S AH N",CATERPILLAR="K AE T AH P IH L ER",OUTWITTING="AW T W IH T IH NG",SLYTER="S L AY T ER",["WANG'S"]="W AE NG Z",MISERABLE="M IH Z ER AH B AH L",["SPIRITUALISM(2)"]="S P IH R IH CH W AH L IH Z M",ASCENT="AH S EH N T",AMUSE="AH M Y UW Z",ARTHUR="AA R TH ER",CORSAGE="K AO R S AA ZH",GRIMACES="G R IH M AH S IH Z",FALYNN="F AE L IH N",UNSANITARY="AH N S AE N AH T EH R IY",LAUGHREY="L AE F R IY",NIMITZ="N IH M IH T S",["MINNEAPOLIS'S"]="M IH N IY AE P AH L IH S IH Z",ULIASKI="Y UW L Y AE S K IY",YUZONG="Y UW Z AO NG",["SURGICALLY(2)"]="S ER JH IH K L IY",POSAVINA="P OW S AH V IY N AH",PASCUZZI="P AA S K UW T S IY",HORVAC="HH AO R V AE K",["POSTSCRIPTS(2)"]="P OW S T S K R IH P T S",CARTOONIST="K AA R T UW N AH S T",RATCHETING="R AE CH AH T IH NG",ARCHAMBAULT="AA R SH AH M B OW",["POOR-SPIRITED"]="P UW R S P IH R IH T IH D",SMALLRIDGE="S M AO L R IH JH",["GENTLEWOMAN'S(2)"]="JH EH N AH L W UH M AH N Z",KELBAUGH="K EH L B AO",VANDERLINDEN="V AE N D ER L IH N D AH N",LICATA="L IY K AA T AH",["GILLETTE'S"]="JH IH L EH T S",CAPRIO="K AE P R IY OW",WESTERNS="W EH S T ER N Z",STRINGHAM="S T R IH NG HH AE M",CONSCRIPTION="K AH N S K R IH P SH AH N",LUCENT="L UW S IH N T",SALEMI="S AA L EH M IY",STROBE="S T R OW B",["LEACHMAN'S"]="L IY CH M AH N Z",["DEBTORS'"]="D EH T ER Z",CISTERNS="S IH S T ER N Z",EVICTION="IH V IH K SH AH N",PURDHAM="P ER D AH M",CANDID="K AE N D AH D",["INVESTMENTS'"]="IH N V EH S T M AH N T S",MAINTAINING="M EY N T EY N IH NG",DICECCO="D IH S EH K OW",SAPPHIRES="S AE F AY ER Z",["TECHNICIAN'S"]="T EH K N IH SH AH N Z",CLARKIN="K L AA R K IH N",SEMIAUTOMATIC="S EH M IY AO T AH M AE T IH K",FLICKER="F L IH K ER",["ALDUS'S"]="AA L D IH S IH Z",ADDER="AE D ER",JENNEWEIN="JH EH N UW AY N",ELICKER="EH L IH K ER",INTERWEAVING="IH N T ER W IY V IH NG",ENGEMAN="EH N JH M AH N",ODDER="AA D ER",NEBRASKA="N AH B R AE S K AH",PROLONGED="P R AH L AO NG D",NINTH="N AY N TH",SLICKER="S L IH K ER",EUGENICS="Y UW JH EH N IH K S",ULBRICH="AH L B R IH K",CEDER="S IY D ER",["WHIRLING(2)"]="HH W ER L IH NG",["RECIPIENT'S"]="R IH S IH P IY AH N T S",FEDER="F EH D ER",OLBRICH="OW L B R IH K",OFLYNN="OW F L IH N",PHILHARMONIA="F IH L HH AA R M OW N IY AH",PIECEWORK="P IY S W ER K",PENNWALT="P EH N W AO L T",["LENO'S(2)"]="L IY N OW Z",SEDER="S EY D ER",REDER="R EH D ER",["RUMBLING'S(2)"]="R AH M B L IH NG Z",AFTERMARKET="AE F T ER M AA R K IH T",["LEAGUES'"]="L IY G Z",HERWITZ="HH ER W IH T S",SHRIDER="SH R AY D ER",KNICKER="N IH K ER",INVESTIGATOR="IH N V EH S T AH G EY T ER",CHATTEL="CH AE T AH L",SNICKER="S N IH K ER",FRIIS="F R IY Z",["PORT'S"]="P AO R T S",REEBOKS="R IY B AA K S",CRELLIN="K R EH L IH N",TAWNY="T AA N IY",STRANAHAN="S T R AE N AH HH AE N",["WHINY(2)"]="HH W AY N IY",DECECCO="D IH CH EH K OW",NONINFLATIONARY="N AA N IH N F L EY SH AH N EH R IY",NATIVE="N EY T IH V",KAHLEY="K AA L IY",MCCLELLEN="M AH K L EH L AH N",MAGERMAN="M AE G ER M AH N",HAGERMAN="HH EY G ER M AH N",CYCLOSPORINE="S IH K L AO S P ER IY N",EVERYTHING="EH V R IY TH IH NG",KLIMOWICZ="K L IH M AH V IH CH",MARINARO="M AA R IH N AA R OW",["AMBLING(2)"]="AE M B L IH NG",AMBIDEXTROUS="AE M B AH D EH K S T R AH S",PANTUSO="P AA N T UW S OW",["DIRT'S"]="D ER T S",THRUSHES="TH R AH SH AH Z",AMOEBA="AH M IY B AH",PROVISIONAL="P R AH V IH ZH AH N AH L",["INTERNATIONALIZE(3)"]="IH N ER N AE SH N AH L AY Z",EADER="IY D ER",BADER="B AE D ER",COROLLARY="K AO R AH L EH R IY",NADER="N EY D ER",MADER="M EY D ER",LADER="L EY D ER",MANGEMENT="M EY N JH M AH N T",HADER="HH EY D ER",RECTIFYING="R EH K T AH F AY IH NG",VADER="V EY D ER",SADER="S EY D ER",["COLOR(2)"]="K AO L ER",BRICKER="B R IH K ER",["BALLY'S(2)"]="B EY L IY Z",BREADTH="B R EH D TH",FRICKER="F R IH K ER",LAVENDER="L AE V AH N D ER",BIBBO="B IY B OW",FOXHOLES="F AA K S HH OW L Z",OVERPROTECTIVE="OW V ER P R AH T EH K T AH V",VIXEN="V IH K S IH N",["OURS(3)"]="AW R Z",CAVENDER="K AH V EH N D ER",PEPLINSKI="P IH P L IH N S K IY",MOTIVATES="M OW T AH V EY T S",SCRAPBOOK="S K R AE P B UH K",WASEDA="W AH S IY D AH",CAPTION="K AE P SH AH N",LABORIOUS="L AH B AO R IY AH S",LIKELIEST="L AY K L IY AH S T",SERRAO="S EH R AW",DECALS="D IY K AE L Z",VERSIONS="V ER ZH AH N Z",["INTEGRATES(2)"]="IH N AH G R EY T S",CHEVETTE="SH AH V EH T",NEUFELD="N UW F EH L D",THIEMAN="TH IY M AH N",PETIPA="P EH T IY P AH",ABADI="AH B AE D IY",BRIBED="B R AY B D",ACTIVE="AE K T IH V",GESTURING="JH EH S CH ER IH NG",ALDER="AO L D ER",["TERRE-HAUTE(2)"]="T EH R AH HH AH T",BECKOM="B EH K AA M",OLDER="OW L D ER",HALLANDALE="HH AE L AH N D EY L",AZURA="AH Z UH R AH",MEADORS="M IY D ER Z",LOCALS="L OW K AH L Z",["EMIRATES'"]="EH M ER AH T S",EICHORN="AY K AO R N",MALVAL="M AA L V AA L",PETRIN="P EH T R IH N",STIMPSON="S T IH M P S AH N",DISINFLATION="D IH S IH N F L EY SH AH N",ANDER="AE N D ER",RESEDA="R EH S EY D AH",RICKLEFS="R IH K L IH F S",ENDER="EH N D ER",["DISHEARTENING(2)"]="D IH S HH AA R T N IH NG",EMPTION="EH M P SH AH N",KUYKENDALL="K AY K EH N D AA L",SQUIGGLES="S K W IH G AH L Z",PENDULOUS="P EH N JH AH L AH S",PURCHASES="P ER CH AH S AH Z",POSTURING="P AA S CH ER IH NG",CORNEL="K AO R N AH L",ONDER="AA N D ER",["CAROLCO'S(2)"]="K ER EH L K OW Z",UNDER="AH N D ER",BERMUDES="B ER M Y UW D Z",SWOOPE="S W UW P",PASSIONS="P AE SH AH N Z",AGERATUMS="AH JH EH R AH T AH M Z",HABIT="HH AE B AH T",BROADHURST="B R AO D HH ER S T",["DISTRIBUTORS'"]="D IH S T R IH B Y AH T ER Z",EXCITED="IH K S AY T AH D",PLOWRIGHT="P L AW R AY T",["DYNAMICS'S"]="D AY N AE M IH K S IH Z",MENGHINI="M EH N G IY N IY",["CONTENT(2)"]="K AH N T EH N T",ARTICULATING="AA R T IH K Y AH L EY T IH NG",MARKETS="M AA R K AH T S",ANTIGUA="AE N T IY G W AH",SPIRALLING="S P AY R AH L IH NG",SHORB="SH AO R B",SALCE="S EY L S",VOCALS="V OW K AH L Z",["MARGRET'S"]="M AA R G R EH T S",["SCHILLING'S"]="SH IH L IH NG Z",CONVERGED="K AH N V ER JH D",TRABER="T R EY B ER",CIDER="S AY D ER",UNACCOUNTABLE="AH N AH K AW N T AH B AH L",["REALTOR'S"]="R IY AH L T ER Z",KILOBYTES="K IH L OW B AY T S",AFFIRMATIONS="AE F ER M EY SH AH N Z",POGORZELSKI="P AH G ER Z EH L S K IY",SIDER="S AY D ER",RIDER="R AY D ER",DEFIANT="D IH F AY AH N T",EDUCATE="EH JH AH K EY T",KIRIBATI="K IH R IH B AA T IY",WEYMOUTH="W EY M AH TH",ENACT="IH N AE K T",LARISCY="L ER IH S K IY",["TRUST'S"]="T R AH S T S",EMOTION="IH M OW SH AH N",NONSPECIFIC="N AA N S P AH S IH F IH K",CAMBURN="K AE M B ER N",STECKLEY="S T EH K L IY",HAKALA="HH AH K AA L AH",["GEDDES(2)"]="G EH D AH Z",SUCCEEDING="S AH K S IY D IH NG",TROUBH="T R UW B",["DIRECTIVE(3)"]="D AY R EH K T IH V",PEKALA="P IH K AA L AH",COLORATION="K AH L ER EY SH AH N",EMBASSY="EH M B AH S IY",MANIFESTING="M AE N AH F EH S T IH NG",KEYHOLES="K IY HH OW L Z",LANETE="L AH N IY T",LAPLAND="L AE P L AE N D",ACCELERANT="AE K S EH L ER AH N T",TROPICANA="T R AA P IH K AE N AH",MARILYNN="M EH R AH L AH N",["DESIGNERS'"]="D IH Z AY N ER Z",ZWOLINSKI="Z V AH L IH N S K IY",TOMASINA="T AO M AH S IY N AH",HEARTS="HH AA R T S",PREVETTE="P R IH V EH T",["PYTHON'S"]="P AY TH AA N Z",AFFIANT="AE F IY AH N T",KURIANSKY="K UH R IY AE N S K IY",VANNATTA="V AA N AA T AH",CRIMPED="K R IH M P T",["BOGEYMAN(2)"]="B UH G IY M AE N",PHRASING="F R EY Z IH NG",ZHIVAGO="ZH IH V AA G OW",VERNACULAR="V ER N AE K Y AH L ER",NONDURABLES="N AA N D UH R AH B AH L Z",KUDER="K Y UW D ER",RESTITUTION="R EH S T IH T UW SH AH N",RUDER="R UW D ER",PUDER="P Y UW D ER",LABRADOR="L AE B R AH D AO R",BLATANTLY="B L EY T AH N T L IY",["ANYTIME'LL"]="EH N IY T AY M AH L",TRAIT="T R EY T",BUDER="B Y UW D ER",GRISLY="G R IH Z L IY",CONTEMPTUOUS="K AH N T EH M P CH UW AH S",RECISIONS="R IH S IH ZH AH N Z",PEABODY="P IY B AA D IY",["MEHRABIAN(2)"]="M ER EY B IY AH N",HANDSAW="HH AE N D S AO",CORROBORATES="K ER AO B ER EY T S",STANKEY="S T AE NG K IY",DECISIONS="D IH S IH ZH AH N Z",CLODFELTER="K L AA D F EH L T ER",ARRIVE="ER AY V",CODER="K OW D ER",TURBOFAN="T ER B OW F AE N",RODER="R OW D ER",CHARTS="CH AA R T S",COUNCILOR="K AW N S AH L ER",["THOMASSON(2)"]="T AA M AH S AH N",MODER="M OW D ER",DOWNSIDES="D AW N S AY D Z",BLONDES="B L AA N D Z",AIRMOTIVE="EH R M OW T IH V",MCINNES="M AH K IH N AH S",TAXABLES="T AE K S AH B AH L Z",GUARDRAILS="G AA R D R EY L Z",SCHLICK="SH L IH K",["RAMAT(2)"]="R AA M AH T",INDENT="IH N D EH N T",MAILBOXES="M EY L B AA K S IH Z",["FRAMERS'"]="F R AE M ER Z",COOPRIDER="K UW P R AY D ER",MERITT="M EH R IH T",LIMITED="L IH M AH T AH D",PONTOON="P AA N T UW N",["SELF-TORMENTS"]="S EH L F T AO R M EH N T S",RODENT="R OW D AH N T",SENTINELS="S EH N T AH N AH L Z",SMARTS="S M AA R T S",FLORIA="F L AO R IY AH",COMPULSORY="K AH M P AH L S ER IY",OBSCURITY="AH B S K Y UH R AH T IY",ROWNY="R OW N IY",["FRIENDSHIP(2)"]="F R EH N SH IH P",KLEMPNER="K L EH M P N ER",["COLOSIO'S"]="K AH L OW S IY OW Z",RELOADED="R IY L OW D IH D",MERITING="M EH R AH T IH NG",FLEEING="F L IY IH NG",MILITANTS="M IH L AH T AH N T S",["ORNSTEIN(2)"]="AO R N S T IY N",["SCANDINAVIA'S"]="S K AE N D IH N EY V IY AH Z",ORDER="AO R D ER",MELGAARD="M EH L G AA R D",["MAINE'S"]="M EY N Z",PROCEDURALLY="P R AH S IY JH ER AH L IY",PRATFALL="P R AE T F AO L",TELEVISIONS="T EH L AH V IH ZH AH N Z",SODER="S OW D ER",SMALLEST="S M AO L AH S T",PATTERNS="P AE T ER N Z",NURTURING="N ER CH ER IH NG",CONCOCTING="K AH N K AA K T IH NG",SWARTS="S W AO R T S",COUNCILWOMAN="K AW N S AH L W UH M AH N",FUJIS="F Y UW JH IH S",REARRANGE="R IY ER EY N JH",SCHUYLKILL="S K Y UW L K IH L",LEGISLATORS="L EH JH AH S L EY T ER Z",PENNINGTON="P EH N IH NG T AH N",["ALCOA'S"]="AE L K OW AH Z",KENNINGTON="K EH N IH NG T AH N",SRIVASTAVA="S R IY V AA S T AA V AH",LARREA="L AE R IY AH",POCAHONTAS="P OW K AH HH AA N T AH S",ENGLISH="IH NG G L IH SH",MARAUDER="M ER AO D ER",DOWNY="D AW N IY",CONTORTED="K AH N T AO R T AH D",ERICSSON="EH R IH K S AH N",["DUBLIN'S"]="D AH B L IH N Z",REACTIONARIES="R IY AE K SH AH N EH R IY Z",["CASSINI'S"]="K AH S IY N IY Z",ALVARDO="AA L V AA R D OW",PISCITELLI="P IY S CH IY T EH L IY",BONGO="B AA NG G OW",CONGO="K AA NG G OW",SCIENTOLOGISTS="S AY AH N T AA L AH JH AH S T S",TECHNOMIC="T EH K N AA M IH K",["MASCARENAS(2)"]="M AE K AH R IY N AH Z",ORTHODOXY="AO R TH AH D AA K S IY",ARDENT="AA R D AH N T",WAMBAUGH="W AO M B AA",EVERGLADES="EH V ER G L EY D Z",["CURT'S"]="K ER T S",BANKERT="B AE NG K ER T",REESOR="R IY S ER",LONGO="L AO NG G OW",["METALLGESELLSCHAFT'S"]="M EH T AH L G EH S AH L SH AE F T S",WINGO="W IY NG G OW",TRACT="T R AE K T",PLYMOUTH="P L IH M AH TH",POLICYHOLDERS="P AA L AH S IY HH OW L D ER Z",ENMESHED="EH N M EH SH T",PISCIOTTA="P IY S CH OW T AH",INTOXICATE="IH N T AA K S AH K EY T",["STOREHOUSE'S"]="S T AO R HH AW S IH Z",["ALICIA'S"]="AH L IH SH AH Z",OVEREXPOSING="OW V ER IH K S P OW Z IH NG",THRIVE="TH R AY V",GEEZE="JH IY Z",["AWESOME(2)"]="AO S AH M",IMPOSSIBLY="IH M P AA S AH B L IY",BRANON="B R AE N AH N",DISBELIEVE="D IH S B AH L IY V",DEVAUGHN="D EH V AO N",PROCESSING="P R AA S EH S IH NG",BOWEN="B OW AH N",COWEN="K AW AH N",DOWEN="D AW AH N",CECCONI="CH EH K OW N IY",PECTIN="P EH K T AH N",["STATIN'S"]="S T EY T IH N Z",MILEWSKI="M IH L EH F S K IY",["REMBRANDT'S"]="R EH M B R AE N T S",MOWEN="M OW AH N",THICKER="TH IH K ER",LOWEN="L OW AH N",GOWEN="G AW AH N",CHOREOGRAPHER="K AO R IY AA G R AH F ER",INCLINED="IH N K L AY N D",HYDER="HH AY D ER",VALOREE="V AE L ER IY",["PROTECTIVELY(2)"]="P ER T EH K T IH V L IY",ASSISTED="AH S IH S T AH D",CLELAND="K L EH L AH N D",BEACHING="B IY CH IH NG",NARAZAKI="N AA R AA Z AA K IY",MCCLOY="M AH K L OY",STAMBAUGH="S T AE M B AO",CORMACK="K AO R M AH K",ABNORMAL="AE B N AO R M AH L",MAFFETT="M AE F IH T",PERROTTA="P ER R OW T AH",TEJEDA="T EY Y EY D AH",MINESTRONE="M IH N AH S T R OW N IY",KOUNS="K AW N Z",SIZEABLE="S AY Z AH B AH L",PARKFIELD="P AA R K F IY L D",DINGO="D IH NG G OW",NOUNS="N AW N Z",MINGO="M IY NG G OW",BIAMONTE="B IY AH M AO N T IY",LINGO="L IH NG G OW",VINGO="V IH NG G OW",LACTER="L AE K T ER",CASTRATING="K AE S T R EY T IH NG",STARTS="S T AA R T S",JAUREQUI="Y AW R EY K W IY",QUIROS="K W IH R OW Z",RESONATE="R EH Z AH N EY T",NIELAND="N IY L AH N D",["LIPSTEIN(2)"]="L IH P S T AY N",ACCUSATIONS="AE K Y AH Z EY SH AH N Z",THREAT="TH R EH T",PANTALONE="P AE N T AH L OW N",RYDER="R AY D ER",SCHLEGELMILCH="SH L EH G IH L M IH L K",FILOMENA="F IH L AH M IY N AH",GIELGUD="G IY L G AH D",IMPRIMATUR="IH M P R IH M AA T ER",ENVISAGED="EH N V IH Z IH JH D",["BUDAPEST(2)"]="B UW D AH P EH SH T",SELWITZ="S EH L W IH T S",GUTWAKS="G AH T W AA K S",MYOJIN="M Y OW JH IH N",HANSHIN="HH AE N SH IH N",ASTHMATICS="EH S TH M EH T IH K S",["BANCROFT'S"]="B AE N K R AO F T S",KNEAFSEY="N IY F S IY",BEDIENT="B IY D Y IH N T",DENNINGTON="D EH N IH NG T AH N",BENNINGTON="B EH N IH NG T AH N",WILHELM="W IH L HH EH L M",MISREMEMBERED="M IH S R IY M EH M B ER D",["CLEMENTES(2)"]="K L AH M EH N T IY Z",CHENXIANG="CH EH N SH Y AA NG",REFFETT="R EH F IH T",MICROWAVING="M AY K R AH W EY V IH NG",LEASABLE="L IY S AH B AH L",SPEAKE="S P IY K",FORDHAM="F AO R D AH M",GOTSHAL="G AA CH AH L",PARROTTA="P AA R OW T AH",OSHATZ="OW SH AE T S",CALISTHENIC="K AE L AH S TH EH N IH K",ERASABLE="IH R EY S AH B AH L",WOOLWINE="W UH L W AY N",["FACTORS'"]="F AE K T ER Z",["SHATZ(2)"]="SH AA T S",GENESIS="JH EH N AH S AH S",TEACHING="T IY CH IH NG",REACHING="R IY CH IH NG",METROPLEXES="M EH T R OW P L EH K S IH Z",REDNOUR="R EH D N UH R",RENGO="R EH NG G OW",LEACHING="L IY CH IH NG",PENGO="P EH NG G OW",OVERCHARGING="OW V ER CH AA R JH IH NG",AWAIT="AH W EY T",BRAINPOWER="B R EY N P AW ER",SMOLINSKI="S M AH L IH N S K IY",UNLOADED="AH N L OW D AH D",GOODRIDGE="G UH D R IH JH",["TRICIA'S"]="T R IH SH AH Z",GRAMMS="G R AE M Z",YAHOO="Y AA HH UW",PAGINATION="P AE JH AH N EY SH AH N",PATRIOTISM="P EY T R IY AH T IH Z AH M",DIALOG="D AY AH L AO G",STREITMATTER="S T R AY T M AH T ER",BUMPINGS="B AH M P IH NG Z",THALASSA="TH AA L AA S AH",UNALTERABLE="AH N AO L T ER AH B AH L",LATENCY="L EY T AH N S IY",OMNIBOOK="AA M N IH B UH K",QUAVERED="K W EY V ER D",["WINAMAC'S"]="W IH N AH M AE K S",LEVENE="L EH V IY N",HOHENSTEIN="HH OW AH N S T AY N",STOMACH="S T AH M AH K",ACROBAT="AE K R AH B AE T",["ROBLING(2)"]="R OW B L IH NG",LUDDITES="L AH D AY T S",HASHMARK="HH AE SH M AA R K",DECTER="D EH K T ER",INTOLERANCE="IH N T AA L ER AH N S",MADYUN="M AE D IY AH N",KARELIAN="K ER IY L IY AH N",SCRUTINY="S K R UW T AH N IY",REINHEIMER="R AY N HH AY M ER",ELFRIDA="EH L F R IY D AH",["SEBASTIANI(2)"]="S AH B AE S T Y AA N IY",WEINHEIMER="W AY N HH AY M ER",["WEAPON'S"]="W EH P AH N Z",KNEER="N IH R",PRICEY="P R AY S IY",ZWICKER="Z W IH K ER",ARCATA="AA R K AA T AH",IRELAND="AY ER L AH N D",TAKESHI="T AH K EH SH IY",SLOSHING="S L AA SH IH NG",BRELAND="B R EH L AH N D",MOLLOHAN="M AA L AH HH AE N",LAURIN="L AO R IH N",MAURIN="M AO R IH N",GIACOMELLI="JH AH K OW M EH L IY",["IMAX'"]="AY M AE K S",["TUNG'S"]="T AH NG Z",["SUNG'S"]="S AH NG Z",["YUNG'S"]="Y AH NG Z",SMOSHING="S M UH SH IH NG",["JUNG'S"]="Y UH NG Z",["WHICKER(2)"]="HH W IH K ER",TAKEOUT="T EY K AW T",RELINQUISHING="R IY L IH NG K W IH SH IH NG",GRANDSONS="G R AE N D S AH N Z",["FUNG'S"]="F AH NG Z",BENKERT="B EH NG K ER T",STOBAUGH="S T AA B AO",LOOSESTRIFES="L UW S S T R AY F S",RECEIVABLES="R IH S IY V AH B AH L Z",PINCUS="P IH NG K AH S",DAMELIO="D AH M IY L IY OW",ROELAND="R OW L AH N D",["WONG'S"]="W AO NG Z",BRUNS="B R AH N Z",["SONG'S"]="S AO NG Z",OSMOSIS="AO Z M OW S IH S",["LONG'S"]="L AO NG Z",["TEAMSTERS'"]="T IY M S T ER Z",PATTERNED="P AE T ER N D",INSTITUTION="IH N S T IH T UW SH AH N",GLICKMAN="G L IH K M AH N",INTENDS="IH N T EH N D Z",DAUGHENBAUGH="D AO EH N B AO",TROBAUGH="T R AA B AO",QUICKER="K W IH K ER",GUANGDONG="G W AE NG D AO NG",SNEER="S N IH R",SHUMAKE="SH UW M EY K",SMOLENSK="S M OW L EH N S K",MARKUM="M AA R K AH M",CASTEEL="K EY S T IY L",APPORTION="AH P AO R SH AH N",RENDEZVOUS="R AA N D IH V UW",GASKETS="G AE S K AH T S",CATHOLIC="K AE TH L IH K",BASKETS="B AE S K AH T S",CASKETS="K AE S K AH T S",KUJALA="K AH Y AA L AH",["ENTERPRISES'(2)"]="EH N ER P R AY Z IH Z",ATTENDS="AH T EH N D Z",KLEER="K L IH R",ROBESON="R OW B IH S AH N",["RICOH'S"]="R IY K OW Z",["STEVENS'"]="S T IY V AH N Z",STUNS="S T AH N Z",FEICKERT="F AY K ER T",NETHUVA="N EH TH UW V AH",SHEARSON="SH IH R S AH N",SWILL="S W IH L",CANASTA="K AH N AE S T AH",SEIBERLING="S AY B ER L IH NG",WESTERNMOST="W EH S T ER N M OW S T",TWILL="T W IH L",TRILATERAL="T R AY L AE T ER AH L",ANTITAX="AE N T AY T AE K S",EXPONENTIALLY="EH K S P OW N EH N SH AH L IY",BANACH="B AE N AH K",RUGERONI="R UW JH EH R OW N IY",SCHEERER="SH IH R ER",HEUN="HH Y UW N",KEESLER="K IY Z L ER",PIGMIED="P IH G M IY D",LITZENBERGER="L IH T Z AH N B ER G ER",["WOUK(2)"]="W OW K",RESTRICTIVENESS="R AH S T R IH K T IH V N AH S",PRIVITERA="P R IY V IY T EH R AH",STRITTMATTER="S T R IH T M AH T ER",LEGO="L EH G OW",APPRAISES="AH P R EY Z IH Z",FOREHAND="F AO R HH AE N D",CANELO="K AH N EH L OW",STAUB="S T AO B",CORROBORATING="K ER AA B ER EY T IH NG",HOSTETTLER="HH AA S T IH T AH L ER",SEGO="S IY G OW",TROUBLEMAKERS="T R AH B AH L M EY K ER Z",CHUN="CH AH N",INNOCENCE="IH N AH S AH N S",["BOXING'S"]="B AA K S IH NG Z",["O'DOHERTY"]="OW D AA ER T IY",STRNAD="S T ER N AE D",["MANZI'S"]="M AE N Z IY Z",SYMBOLIC="S IH M B AA L IH K",["SINGLETON'S"]="S IH NG G AH L T AH N Z",PRITTS="P R IH T S",INTERMINGLED="IH N T ER M IH NG G AH L D",PRENTNIEKS="P R EH N T N IY EH K S",STEFFENSEN="S T EH F IH N S AH N",BRITTS="B R IH T S",SWINDLING="S W IH N D L IH NG",CRATIA="K R EY SH AH",BROWNLIE="B R AW N L IY",["MULTICANDIDATE(2)"]="M AH L T IY K AE N D AH D AH T",MINEOLA="M IH N IY OW L AH",["DUPONT'S"]="D UW P AA N T S",FUTURIST="F Y UW CH ER IH S T",NONESSENTIAL="N AA N IH S EH N CH AH L",EVANGI="IH V AE N JH IY",BRIERLEY="B R AY ER L IY",BETRAY="B IH T R EY",["REJOINDER(2)"]="R IY JH OY N D ER",FAVIA="F AA V IY AH",ANDRESS="AA N D R EH S",SALVAGGIO="S AA L V AA JH IY OW",ENDRESS="EH N D R IH S",NYGREN="N IH G R EH N",["LUERAS(2)"]="L UW EH R AH Z",["DEMOBILIZATION(2)"]="D IY M OW B AH L AH Z EY SH AH N",UNDRESS="AH N D R EH S",TECHNICOLOR="T EH K N IH K AH L ER",WALKENHORST="W AO K AH N HH AO R S T",PATHOGENS="P AE TH AH JH AH N Z",OBARR="OW B AA R",SPURNING="S P ER N IH NG",CARN="K AA R N",BARN="B AA R N",SILICONES="S IH L AH K OW N Z",ECONOMIZES="IH K AA N AH M AY Z AH Z",EARN="ER N",DARN="D AA R N",KARN="K AA R N",HARN="HH AA R N",THUN="TH AH N",SHUN="SH AH N",KOZMINSKI="K AH Z M IH N S K IY",JAGO="Y AA G OW",IAGO="IY AA G OW",WITKOP="W IH T K AH P",BOURASSA="B UH R AA S AH",LAGO="L AA G OW",SAGO="S EY G OW",PAPAGEORGE="P AE P AH JH AO R JH",["OSBORNE'S"]="AO Z B AO R N Z",UNHURRIED="AH N HH ER IY D",["ECONOMIST'S"]="IH K AA N AH M IH S T S",["WHISTLE(2)"]="HH W IH S AH L",EVITTS="EH V IH T S",["SIGHTSEERS(2)"]="S AY T S IY R Z",["BASES(3)"]="B EY S IY Z",OPIATES="OW P IY AH T S",PODOLSKI="P AH D OW L S K IY",INSTALLMENT="IH N S T AO L M AH N T",TROWEL="T R AW W EH L",DIASTROPHISM="D AY AE S T R AH F IH Z AH M",COMPELS="K AH M P EH L Z",CENTERBANC="S EH N T ER B AE NG K",SAVIR="S EY V ER",CREDITHRIFT="K R EH D IH TH R IH F T",BOUTTE="B UW T",SAYIID="S AY IH D",TRAUB="T R AO B",CABRALL="K AH B R AA L",["MISOGYNISTS(2)"]="M IH Z AH JH IH N IH S",COUNCILORS="K AW N S AH L ER Z",SWEHLA="S W EH L AH",SCRAGGLE="S K R AE G AH L",THERESA="T ER IY S AH",SEBRING="S IY B R IH NG",CONTRAVENTION="K AA N T R AH V EH N CH AH N",GABRALL="G EY B R AH L",HEVIA="HH EY V IY AH",["REPRISALS(2)"]="R IY P R AY Z AH L Z",LONGACRE="L AO NG EY K ER",AUTHORIZING="AO TH ER AY Z IH NG",TRIALS="T R AY AH L Z",MAILHOT="M AY L HH AH T",NEEDLESS="N IY D L AH S",["IRAQIS(2)"]="IY R AE K IY Z",SUBLEASE="S AH B L IY S",["CAREY'S"]="K EH R IY Z",["STATION'S"]="S T EY SH AH N Z",CHIPMAN="CH IH P M AH N",LEFTIST="L EH F T IH S T",["SOMALIAS(2)"]="S AH M AA L Y AH Z",KATZENBERGER="K AE T Z AH N B ER G ER",EDGEWOOD="EH JH W UH D",["GREENWICH'S"]="G R EH N IH CH IH Z",SPRAWLS="S P R AO L Z",OFFSET="AO F S EH T",LAMOTTA="L AA M OW T AH",GLAUB="G L AO B",YOUN="Y AH N",WEILL="W AY L",NEILL="N IY L",VANNOY="V AE N OY",["ANECDOTALLY(2)"]="AE N IH K D OW T AH L IY",MARYRUTH="M AE R IH R UW TH",NONPERFORMING="N AA N P ER F AO R M IH NG",PLATOON="P L AH T UW N",["COWEN(2)"]="K OW AH N",MAYEDA="M AY IY D AH",NOUN="N AW N",METAPHORS="M EH T AH F AO R Z",LUCKIEST="L AH K IY AH S T",MONDRIAN="M AA N D R IY AH N",KREBSBACH="K R EH B Z B AA K",AOUN="AW AH N",FRANKIEWICZ="F R AE N K AH V IH CH",NARCISSIST="N AA R S IH S IH S T",PALOMO="P AA L OW M OW",["FAIRCHILD'S"]="F EH R CH AY L D Z",["SPEAKER'S"]="S P IY K ER Z",ENLARGED="EH N L AA R JH D",WETTER="W EH T ER",VETTER="V EH T ER",["EASY'S"]="IY Z IY Z",SKILL="S K IH L",GUERIN="G EH R IH N",LIVIA="L IH V IY AH",PIDCOCK="P IH D K AH K",PUBLICIZED="P AH B L IH S AY Z D",DETTER="D EH T ER",BETTER="B EH T ER",DIGITALIS="D IH JH AH T AE L AH S",SCHLOCK="SH L AA K",SVEHLA="S V EH L AH",SCHULLER="SH UW L ER",GOODENOUGH="G UH D AH N AW",GIESLER="G IY S AH L ER",PROPORTIONATELY="P R AH P AO R SH AH N AH T L IY",SETTER="S EH T ER",RETTER="R EH T ER",NADOLSKI="N AH D OW L S K IY",STREBECK="S T R IY B EH K",PITTSBURGH="P IH T S B ER G",METTER="M EH T ER",DOMENICK="D AA M IH N IH K",KETTER="K EH T ER",JETTER="JH EH T ER",GETTER="G EH T ER",FETTER="F EH T ER",OLOUGHLIN="OW L AW K L IH N",DEMETRIA="D IH M EH T R IY AH",["JURIST(2)"]="JH UH R IH S T",SHAUB="SH AO B",MENAGERIE="M AH N AE JH ER IY",ALUN="EY L AH N",UNPROFITABLE="AH N P R AA F IH T AH B AH L",BORGELT="B AO R G IH L T",NAILL="N EY L",JANOVSKY="JH AH N AA V S K IY",DISORIENTATION="D IH S AO R IY AH N T EY SH AH N",["GHORBANIFAR(3)"]="G AO R B AE N IH F ER",KRAKOWER="K R AE K OW ER",JOCKEYS="JH AA K IY Z",OKUN="OW K UW N",HOLDAWAY="HH OW L D AH W EY",DECELERATION="D IH S EH L ER EY SH AH N",RUPIAH="R UW P AY AH",BABYAK="B AE B IY AE K",["REPUBLIC'S"]="R IY P AH B L IH K S",DOCIE="D AA K IY",TROTTEN="T R AA T AH N",WITTER="W IH T ER",MULTILAYERED="M AH L T IY L EY ER D",["BOOGIE-WOOGIE"]="B UW G IY W UW G IY",SHOPPES="SH AA P S",METCALF="M EH T K AE F",NONCOMPETITIVE="N AA N K AH M P EH T AH T IH V",REMISSIONS="R IY M IH SH AH N Z",DUESLER="D UW S AH L ER",BITTER="B IH T ER",SNOOKERED="S N UH K ER D",PLATELETS="P L EY T L AH T S",DEBILITY="D AH B IH L AH T IY",["INTEGRATE(2)"]="IH N AH G R EY T",TITTER="T IH T ER",SITTER="S IH T ER",SCHUCKER="SH AH K ER",BURKHARDT="B ER K HH AA R T",GITTER="G IH T ER",COEXISTED="K OW AH G Z IH S T AH D",LITTER="L IH T ER",VANHOOK="V AE N HH UH K",YUGO="Y UW G OW",INCLINATION="IH N K L AH N EY SH AH N",["AUTUMN'S"]="AO T AH M Z",HALMOS="HH AO L M OW S",PITTSFIELD="P IH T S F IY L D",LUKOIL="L UW K OY L",HELGERSON="HH EH L G ER S AH N",["CHAPLIN(2)"]="CH AE P L IH N",HUGO="HH Y UW G OW",DUGO="D UW G OW",POLYTECHNIC="P AA L IH T EH K N IH K",STYLISH="S T AY L IH SH",VOLVOVITZ="V OW L V AH V IH T S",MCGINNISS="M AH G IH N AH S",SNARR="S N AE R",UNREMARKABLE="AH N R IH M AA R K AH B AH L",SORENTO="S ER EH N T OW",CASTILLON="K AE S T IH L AA N",KNARR="N AE R",BELIZE="B EH L IY Z",["GUIDE'S"]="G AY D Z",DIOCESES="D AY AH S IY Z",MERIDETH="M EH R IH D IH TH",MORRISETT="M AO R AH S EH T",HELPRIN="HH EH L P R IH N",SANDIDGE="S AE N D IH JH",COMPROMISED="K AA M P R AH M AY Z D",SMARR="S M AE R",["COURTS'"]="K AO R T S",["JUSTICES(2)"]="JH AH S T IH S IH Z",REVOLUTIONIZE="R EH V AH L UW SH AH N AY Z",BRESLER="B R EH S L ER",HOLMLUND="HH OW L M L AH N D",["HILFIGER(2)"]="HH IH L F IH G ER",BAPTISTE="B AH P T IH S T",["WEISENBACH(2)"]="W AY Z IH N B AA K",OTELLO="OW T EH L OW",["TOPEKA(2)"]="T OW P IY K AH",CAPITALIZES="K AE P AH T AH L AY Z IH Z",STELLO="S T EH L OW",GURIT="G Y UH R IH T",PLODDING="P L AA D IH NG",TRAUM="T R AO M",["HILEMON'S"]="HH AY L M AH N Z",OBLITERATED="AH B L IH T ER EY T IH D",WOOTTEN="W UW T AH N",OSTIA="AA S T IY AH",["LEVY'S"]="L EH V IY Z",["SHUTTLING(2)"]="SH AH T L IH NG",URGO="ER G OW",CUELLO="K UW EH L OW",["TAIWAN'S"]="T AY W AA N Z",FARCICAL="F AA R S AH K AH L",DINOSAUR="D AY N AH S AO R",BIOLOGISTS="B AY AA L AH JH IH S T S",LAMERE="L AA M EH R EY",CIESLA="CH EH S L AH",THILL="TH IH L",PLAGENS="P L AE G AH N Z",ERGO="ER G OW",LLOYD="L OY D",BLAYNEY="B L EY N IY",CICILY="CH IH CH AH L IY",["INTENDED(2)"]="IH N T EH N D IH D",MARABLE="M EH R AH B AH L",MENACHEM="M AH N AA HH AH M",OUTTAKE="AW T T EY K",DATAGRAPHIX="D EY T AH G R AE F IH K S",GALLIA="G AE L Y AH",SICILY="S IH S AH L IY",["WHINNEY(2)"]="HH W IH N IY",PARABLE="P EH R AH B AH L",QUINTINA="K W IY N T IY N AH",POSTHUMOUSLY="P AA S CH UH M AH S L IY",POLARIMETER="P OW L ER IH M AH T ER",FUSELIER="F Y UW S L IY ER",["PROVIDED(2)"]="P R AH V AY D IH D",PROPOSITION="P R AA P AH Z IH SH AH N",FRAUM="F R AW M",CONTORTIONS="K AH N T AO R SH AH N Z",DEWAARD="D UW AA R D",CRUDUP="K R AH D AH P",STRATUS="S T R AE T AH S",HELIX="HH IY L IH K S",["D'AGOSTINO'S"]="D AA G AH S T IY N OW Z",PFEFFERKORN="F EH F ER K AO R N",SITUATIONAL="S IH CH UW EY SH AH N AH L",SATTERFIELD="S AE T ER F IY L D",POWERCISE="P AW R S AY Z",TOGO="T OW G OW",INCREDIBLY="IH N K R EH D AH B L IY",NEGLECTS="N IH G L EH K T S",["SCUTTLING(2)"]="S K AH T L IH NG",SEVERE="S AH V IH R",ARCTURUS="AA R K T UH R AH S",HOUGLAND="HH AW G L AH N D",SELVAGGIO="S EH L V AA JH IY OW",["KONZI'S"]="K AA N Z IY Z",GOGO="G OW G OW",["BARBARA(2)"]="B AA R B R AH",HOLGERSON="HH OW L G ER S AH N",LOGO="L OW G OW",POGO="P OW G OW",SOGO="S OW G OW",UNGO="AH N G OW",["COJUANGCO(2)"]="K OW JH W AE NG K OW",BARKDULL="B AA R K D AH L",SHEALY="SH IY L IY",RECLINED="R IH K L AY N D",PHARR="F AA R",["HEALY'S"]="HH IY L IY Z",ROGERNOMICS="R OW G ER N AA M IH K S",FLAUM="F L AO M",INGO="IH NG G OW",NEWSIES="N UW Z IY Z",BLAUM="B L AO M",JOLLIFF="JH AA L IH F",CORNHUSKS="K AO R N HH AH S K S",WARN="W AO R N",VARN="V AA R N",ZOTTER="Z AA T ER",STRANDING="S T R AE N D IH NG",ABSTRACTION="AE B S T R AE K SH AH N",SALOOJEE="S AH L UW JH IY",MEANINGFULLY="M IY N IH NG F AH L IY",ADDRESS="AE D R EH S",REDRESS="R IH D R EH S",KOSTELECKY="K AH S T EH L EH T S K IY",ONCOGENE="AA NG K OW JH IY N",NOBILITY="N OW B IH L AH T IY",STRONGEST="S T R AO NG G AH S T",MOBILITY="M OW B IH L AH T IY",HOLOCAUST="HH AA L AH K AO S T",ASTRONOMY="AH S T R AA N AH M IY",PFARR="F AA R",BATUIGAS="B AE CH UW IY G AH S",DISKLESS="D IH S K L AH S",LOTTER="L AA T ER",KOTTER="K AA T ER",NOTTER="N AA T ER",MOTTER="M AA T ER",["BROWNS'"]="B R AW N Z",TEMBLOR="T EH M B L ER",MONOLOGUES="M AA N AH L AO G Z",TOTTER="T AA T ER",MOURNING="M AO R N IH NG",HOLDOVER="HH OW L D OW V ER",POTTER="P AA T ER",ROTTER="R AA T ER",RISKLESS="R IH S K L AH S",BOWLERS="B OW L ER Z",PULSIPHER="P UH L S IH F ER",COUCHING="K AW CH IH NG",DEFREES="D IH F R IY Z",POITIER="P OY T Y ER",JOCELYN="JH AO S L IH N",ADELIZZI="AE D AH L IY Z IY",MICHAEL="M AY K AH L",UNILATERAL="Y UW N AH L AE T ER AH L",REPLAYED="R IY P L EY D",ASHLOCK="AE SH L AA K",COOPERATIVE="K OW AA P ER EY T IH V",SHAWCROSS="SH AO K R AO S",["PERPETRATOR'S"]="P ER P AH T R EY T ER Z",SATANIST="S EY T AH N IH S T",LUDITES="L UW D AY T S",["SANS-CULOTTES"]="S AA N K UW L AO T",DELAVAL="D EH L AH V AE L",MCCANTS="M AH K AE N T S",["ENTERING(2)"]="EH N ER IH NG",HOLLISTER="HH AA L IH S T ER",INOPERATIVE="IH N AA P ER AH T IH V",PERFORMA="P ER F AO R M AH",TOLLBOOTH="T OW L B UW TH",BOGENSCHUTZ="B AA G IH N SH AH T S",ABOMINABLE="AH B AA M AH N AH B AH L",PLAYWRIGHTS="P L EY R AY T S",LOBBED="L AA B D",MOBBED="M AA B D",STEEPENED="S T IY P AH N D",WINDHOLZ="W IH N D HH OW L Z",ROBBED="R AA B D",ANELLO="AH N EH L OW",["TRENDIER(2)"]="T R EH N D IY ER",CHURNING="CH ER N IH NG",CALCIFIED="K AE L S AH F AY D",["HARNISCHFEGER'S"]="HH AA R N IH SH F EH G ER Z",EXUDED="IH G Z UW D IH D",TAVENNER="T AE V IH N ER",STRICTLY="S T R IH K T L IY",MATYAS="M AE T Y AH S",TOUCHING="T AH CH IH NG",VISCLOSKY="V IH S K L AO S K IY",POLYGYNOUS="P AH L IH JH AH N AH S",GARRIDO="G AA R IY D OW",REGRESSION="R AH G R EH SH AH N",OVERPLAYING="OW V ER P L EY IH NG",IMPRESSIONISTIC="IH M P R EH SH AH N IH S T IH K",ETHERIDGE="EH TH ER IH JH",RASCOE="R AE S K OW",REVIEWS="R IY V Y UW Z",NEGRIN="N EH G R IH N",PASCOE="P AE S K OW",JERDEN="JH ER D AH N",BLOOMER="B L UW M ER",GABEIRA="G AH B EY R AH",["LYUBIMOV'S"]="L Y UW B AH M AA V Z",MIDDAY="M IH D D EY",INEQUITY="IH N EH K W AH T IY",["WITNESS'S"]="W IH T N AH S IH Z",ALLOTMENTS="AH L AA T M AH N T S",ASSASSINATING="AH S AE S AH N EY T IH NG",FOURTEEN="F AO R T IY N",LIGHTEN="L AY T AH N",ANTEBELLUM="AE N T IH B EH L AH M",TIGHTEN="T AY T AH N",ALBIE="AO L B IY",KIENTZ="K IY N T S",SLEDDING="S L EH D IH NG",SCRUB="S K R AH B",BURGOON="B ER G UW N",["START-UP"]="S T AA R T AH P",BOUGHMAN="B AW M AH N",OBSOLESCENT="AA B S AH L EH S AH N T",DISREPUTABLE="D IH S R EH P Y AH T AH B AH L",["ETERNAL(2)"]="IY T ER N AH L",COLCHICINE="K AO L CH AH S IY N",LOUGHMAN="L AW M AH N",RASIA="R AA S IY AH",UNORTHODOX="AH N AO R TH AH D AA K S",NISWONGER="N IH S W AO NG ER",CLEANER="K L IY N ER",ASTONISHINGLY="AH S T AA N IH SH IH NG L IY",STATESMAN="S T EY T S M AH N",DRAFTEES="D R AE F T IY Z",MCKOY="M AH K OY",ERLANGER="EH R L AE NG ER",CATERERS="K EY T ER ER Z",NONFAT="N AA N F AE T",JOYONI="JH OY OW N IY",TABONE="T AA B OW N",DENTINO="D IH N T IY N OW",MERIT="M EH R AH T",["KIMBERLY'S"]="K IH M B ER L IY Z",["RECEIVER(3)"]="R IY S IY V ER",MCGREW="M AH G R UW",MANTIONE="M AA N T IY OW N IY",SHAKIEST="SH EY K IY IH S T",WATCHDOG="W AA CH D AO G",PARDEN="P AA R D AH N",SUMMARIZING="S AH M ER AY Z IH NG",RESPONDING="R IH S P AA N D IH NG",REIMPOSED="R IY IH M P OW Z D",WARDEN="W AO R D AH N",OUTLANDISH="AW T L AE N D IH SH",VARDEN="V AA R D AH N",DIGRESSION="D AY G R EH SH AH N",CONROE="K AA N R OW",FRUITLESSLY="F R UW T L AH S L IY",BAUN="B AO N",["INDIANAPOLIS'S"]="IH N D IY AH N AE P AH L IH S IH Z",DAUN="D AO N",CURTIN="K ER T IH N",HAUN="HH AO N",MONROE="M AH N R OW",["NANOGRAM(2)"]="N AE N OW G R AE M",LIBYA="L IH B IY AH",["STANDARD-BEARERS"]="S T AE N D ER D B EH R ER Z",STARR="S T AA R",PICKETERS="P IH K AH T ER Z",STUPIDITY="S T UW P IH D IH T IY",MCSHAN="M AH K SH AE N",REBATES="R IY B EY T S",TAMARINS="T AE M ER AH N Z",ARTHRITIS="AA R TH R AY T AH S",DISLIKING="D IH S L AY K IH NG",DEBATES="D AH B EY T S",CALLISTER="K AO L IH S T ER",KOSUB="K OW S AH B",SOMMERSBY="S AH M ER R Z B IY",PROBING="P R OW B IH NG",NOAMI="N OW M IY",MOAMI="M OW M IY",BROADCASTS="B R AO D K AE S T S",PROVOSTS="P R OW V OW S T S",OHIOAN="OW HH AY OW AH N",LEIBFRIED="L AY B F ER IY D",GARDEN="G AA R D AH N",CLASSIFIED="K L AE S AH F AY D",["MOISHE(2)"]="M OY SH IH",["CHICKENS'"]="CH IH K AH N Z",CARDEN="K AA R D AH N",DARDEN="D AA R D AH N",THEORETICALLY="TH IY ER EH T IH K AH L IY",GLOBALIZED="G L OW B AH L AY Z D",SECULARIZED="S EH K Y AH L ER AY Z D",CANNIBALIZING="K AE N AH B AH L AY Z IH NG",["SAUDIA(2)"]="S AW D IY AH",OVERDUE="OW V ER D UW",DRIVEN="D R IH V AH N",CRIVEN="K R IH V AH N",SHEHANE="SH EH HH AH N",ASHDOWN="AE SH D AW N",MCDANEL="M AH K D AE N AH L",MCENANY="M AE K AH N EY N IY",UNIVISION="Y UW N IH V IH ZH AH N",SANTINO="S AA N T IY N OW",RUSTIER="R AH S T IY ER",DIFFERENT="D IH F ER AH N T",DISMUKE="D IH S M Y UW K",OLDENKAMP="OW L D IH N K AE M P",SISCOE="S IH S K OW",["RIUNITE(2)"]="R IY UW N AY T IY",["ITALY'S"]="IH T AH L IY Z",BUSTIER="B AH S T Y ER",["PAGENKOPF(2)"]="P AE G AH N K AO F",FRAGO="F R EY G OW",DRAGO="D R AA G OW",CRAGO="K R AA G OW",KRENTZ="K R EH N T S",["CASEY'S"]="K EY S IY Z",ECHELONS="EH SH AH L AA N Z",CAIRNS="K EH R N Z",DIMITRI="D IH M IY T R IY",FRENTZ="F R EH N T S",SCRAPE="S K R EY P",["BRAVES'"]="B R EY V Z",ONTOLOGY="AA N T AA L AH JH IY",EXULTANT="IH G Z AH L T AH N T",MYSTERIES="M IH S T ER IY Z",["NATIONALE(2)"]="N AE SH AH N AH L",["TEMPLE'S"]="T EH M P AH L Z",SAPPENFIELD="S AH P EH N F IY L D",NEWSWORTHY="N UW Z W ER DH IY",GUTIERREZ="G UW T Y EH R EH Z",REFLEXIVELY="R IY F L EH K S IH V L IY",HAYMON="HH EY M AH N",HOAXES="HH OW K S IH Z",LAYMON="L EY M AH N",WATCHING="W AA CH IH NG",INTUIT="IH N T UW AH T",ARENTZ="AE R IH N T S",STATISTICIANS="S T AE T IH S T IH SH AH N Z",CRANKSHAFT="K R AE NG K SH AE F T",BLUMENTHAL="B L UW M AH N TH AO L",INSEPARABLY="IH N S EH P ER AH B L IY",ROESLER="R OW S AH L ER",["REMINDED(2)"]="R IY M AY N D IH D",CATCHING="K AE CH IH NG",LOUDEN="L AW D AH N",["NYGREN(2)"]="N AY G R EH N",SNOWFLAKES="S N OW F L EY K S",STUDIOUSLY="S T UW D IY AH S L IY",MATHIS="M AE TH IH S",MOKOENA="M AH K OW N AH",PACTEL="P AE K T EH L",NAPOLES="N AE P AH L Z",PATCHING="P AE CH IH NG",MATCHING="M AE CH IH NG",LATCHING="L AE CH IH NG",["DEBATE'S"]="D AH B EY T S",HATCHING="HH AE CH IH NG",LORENZO="L ER EH N Z OW",MAXIMA="M AE K S AH M AH",EHRENHALT="EH R AH N HH AO L T",COOKSEY="K UH K S IY",ANDREN="AE N D ER AH N",VIRDEN="V ER D AH N",CONSTITUTE="K AA N S T AH T UW T",PAINKILLER="P EY N K IH L ER",ARENDS="ER EH N D Z",AMENDS="AH M EH N D Z",["ATTESTS(2)"]="AH T EH S",MONOTONE="M AA N AH T OW N",KEIRNS="K AY R N Z",SHIPMENT="SH IH P M AH N T",BARTOLOMEO="B AA R T AO L AH M EY OW",GABRIELSON="G AE B R IY L S AH N",HUNDERTMARK="HH AH N D ER T M AA R K",BUTTONHOLES="B AH T AH N HH OW L Z",CRISTINA="K R IH S T IY N AH",METZENBAUM="M EH T S AH N B AW M",SHEDDING="SH EH D IH NG",["CROISSANTS(2)"]="K R AH S AA N T S",["COVEN(2)"]="K OW V AH N",["JAPONICA(2)"]="JH AH P AA N IH K AH",RIGO="R IY G OW",JOSIAH="JH OW S AY AH",SPENDS="S P EH N D Z",STELLENBOSCH="S T EH L AH N B AO SH",VIGO="V IY G OW",["IJAZ(2)"]="IY JH AA Z",ANTHIS="AE N TH IH S",SPAGO="S P EY G OW",LARCENOUS="L AA R S AH N AH S",ROSCOE="R AA S K OW",["EDELMAN(2)"]="EY D AH L M AH N",["ADELMAN(2)"]="EH D AH L M AH N",DOBIE="D AA B IY",DOCUMENTARIES="D AA K Y AH M EH N T ER IY Z",SLENTZ="S L EH N T S",BIRDEN="B ER D AH N",LEMCKE="L EH M K IY",SWAMI="S W AA M IY",PEDOPHILIC="P EH D OW F IH L IH K",MUNROE="M AH N R OW",ROBIE="R OW B IY",MADORE="M AH D AO R EY",CARRASCO="K AA R AA S K OW",GARTSIDE="G AA R T S AY D",ABRIDGED="AH B R IH JH D",KRISTINA="K R IH S T IY N AH",NORTHWARD="N AO R TH W ER D",HORSETAILS="HH AO R S T EY L Z",GOBIE="G OW B IY",BASEMENTS="B EY S M AH N T S",FINNEGAN="F IH N AH G AH N",MARTIN="M AA R T AH N",HARTIN="HH AA R T IH N",GARTIN="G AA R T IH N",DISAPPROVAL="D IH S AH P R UW V AH L",SARTIN="S AA R T IH N",MATCHMAKERS="M AE CH M EY K ER Z",PARTIN="P AA R T IH N",CATEGORIZED="K AE T AH G ER AY Z D",DOORWAYS="D AO R W EY Z",HIGGENBOTHAM="HH IH G IH N B AH TH AH M",PECORE="P EH K AO R IY",KANTER="K AE N T ER",LANTER="L AE N T ER",GANTER="G AE N T ER",HEGELIAN="HH IY JH IY L IY AH N",BANTER="B AE N T ER",CANTER="K AE N T ER",["ORCHESTRA'S"]="AO R K AH S T R AH Z",TELEMARKET="T EH L AH M AA R K IH T",INACTIVITY="IH N AE K T IH V IH T IY",["BARYSHNIKOV'S"]="B ER IH SH N IH K AA V Z",LUEBBERT="L UH B ER T",SANTER="S AE N T ER",FIENDS="F IY N D Z",MANTER="M AE N T ER",CUTOUT="K AH T AW T",HACKNEY="HH AE K N IY",JULIANNE="JH UW L IY EH N",DURBIN="D ER B IH N",AUTOGRAPH="AO T AH G R AE F",PITCHING="P IH CH IH NG",BLENDS="B L EH N D Z",KITCHING="K IH CH IH NG",UNDOCUMENTED="AH N D AA K Y AH M EH N T IH D",WITCHING="W IH CH IH NG",ZAVODNIK="Z AH V AA D N IH K",HITCHING="HH IH CH IH NG",MINOAN="M AH N OW AH N",DITCHING="D IH CH IH NG",TRACED="T R EY S T",ANTIBACTERIAL="AE N T IY B AE K T IH R IY AH L",STARDEL="S T AA R D EH L",GRACED="G R EY S T",["MCGOWAN'S"]="M AH G AW AH N Z",CAREFULLY="K EH R F AH L IY",BRACED="B R EY S T",["THINKIN'"]="TH IH NG K IH N",["SHOREHAM(2)"]="SH AO R HH AE M",STRUB="S T R AH B",ALGODONES="AA G AH D OW N AH Z",BRYARS="B R AY ER Z",ACCOMPLICE="AH K AA M P L AH S",FUNDERBURK="F AH N D ER B ER K",DEBACLE="D AH B AA K AH L",CLEARED="K L IH R D",["EFFECTS(4)"]="IY F EH K S",OINTMENT="OY N T M AH N T",DECOMMISSIONED="D IY K AH M IH SH AH N D",BRUN="B R AH N",EMBARKS="IH M B AA R K S",CYANURIC="S AY AE N ER IH K",DUBIE="D AH B IY",CHALLENGES="CH AE L AH N JH IH Z",RUBIE="R UW B IY",LABORATORY="L AE B R AH T AO R IY",DELUCCA="D EH L UW K AH",GADFLIES="G AE D F L AY Z",UTTECH="AH T EH K",BERTIN="B ER T IH N",SERVICED="S ER V IH S T",ADMISSIONS="AE D M IH SH AH N Z",["NIGHTS'"]="N AY T S",PEMBRIDGE="P EH M B R IH JH",STUN="S T AH N",["RELISHES(2)"]="R EH L IH SH IH Z",SINOPEC="S AY N OW P EH K",LEACOCK="L IY K AA K",PARACHUTED="P EH R AH SH UW T IH D",["RIGHTS'"]="R AY T S",STENTZ="S T EH N T S",HAUGLAND="HH AO G L AH N D",["LAPAROSCOPIC(2)"]="L AE P R AH S K AA P IH K",BUSCHE="B AH SH",SALAFIA="S AH L EY F IY AH",TRBOVICH="T ER B AA V IH CH",PEACOCK="P IY K AA K",SMEARED="S M IH R D",BIEV="B IY V",PREBIOTIC="P R IY B AY AO T IH K",KIEV="K IY EH V",OUTLAWED="AW T L AO D",UNIONIZATION="Y UW N Y AH N AH Z EY SH AH N",["WHOOSH(2)"]="HH W UW SH",HOVERFLIES="HH AH V ER F L AY Z",FACER="F EY S ER",KUBY="K Y UW B IY",ENJOY="EH N JH OY",LUBY="L UW B IY",WATSONVILLE="W AA T S AH N V IH L",KACER="K EY S ER",LACER="L EY S ER",DUBY="D UW B IY",RACER="R EY S ER",PACER="P EY S ER",RUBY="R UW B IY",OCTAGON="AA K T AH G AA N",EIGHMY="EY G M IY",["BIGELOW'S"]="B IH G AH L OW Z",STILL="S T IH L",OBTRUSIVE="AH B T R UW S IH V",KIENINGER="K IY N IH NG ER",KANITZ="K AE N IH T S",ALBUM="AE L B AH M",STRUBBE="S T R AH B",PICKNEY="P IH K N IY",DEVOLUTION="D EH V AH L UW SH AH N",BERNEICE="B ER N AY S",DERENZO="D IH R EH N Z OW",SABBATH="S AE B AH TH",ASBY="AE S B IY",LEMERE="L EH M ER",["MONTANA'S"]="M AA N T AE N AH Z",CONTINO="K AA N T IY N OW",REVOLUTION="R EH V AH L UW SH AH N",FORYS="F AO R IY Z",GUILL="G IH L",ACKERLEY="AE K ER L IY",BORYS="B AO R IY Z",FLAWLESS="F L AO L AH S",OSBY="AA S B IY",DUHAIME="D UW AY M",IRBY="ER B IY",["SMREKAR(2)"]="S M ER IH K ER",ERBY="ER B IY",TRILL="T R IH L",TALMADGE="T AE L M AE JH",ARBY="AA R B IY",ALEXANDERS="AE L IH G Z AE N D ER Z",MULTIPLEX="M AH L T IY P L EH K S",MORPHED="M AO R F T",GRILL="G R IH L",BUCHBERGER="B AH K B ER G ER",FRILL="F R IH L",CRILL="K R IH L",DRILL="D R IH L",TULLIA="T AH L IY AH",BRILL="B R IH L",EXPLICITE="IH K S P L IH S AH T",SHEARED="SH IH R D",PERFORMANCES="P ER F AO R M AH N S AH Z",METHOT="M EH TH AH T",ULCER="AH L S ER",BIBY="B AY B IY",CAJUN="K EY JH AH N",DAJUN="D EY JH AH N",WYNN="W IH N",BRODERICK="B R AA D ER IH K",MCKENNY="M AH K EH N IY",SODOMIZES="S AO D AH M AY Z AH Z",RECADI="R IH K AE D IY",BRICKLAYER="B R IH K L EY ER",["GRANVILLE'S"]="G R AE N V IH L Z",EXCELLENTLY="EH K S AH L AH N T L IY",CHEESY="CH IY Z IY",TOILETRIES="T OY L AH T R IY Z",VANDERKOLK="V AE N D ER K OW K",SPILL="S P IH L",NONCOLOR="N AA N K AH L ER",RELIEVES="R IY L IY V Z",MEZUZAH="M AH Z UH Z AH",TURBIN="T ER B IH N",FACIE="F EY S IY",BELIEVES="B IH L IY V Z",["FORMALDEHYDE(2)"]="F ER M AE L D AH HH AY D",COSTLIER="K AO S T L IY ER",LYNN="L IH N",CORNSTARCH="K AO R N S T AA R CH",["NEGOTIATIONS(2)"]="N IH G OW SH IY EY SH AH N Z",MARUYU="M EH R UW Y UW",NEWBERGER="N UW B ER G ER",["HARRISBURG'S"]="HH AE R IH S B ER G Z",BUNDYS="B AH N D IY Z",CARTRIDGE="K AA R T R AH JH",PARIAH="P ER AY AH",AHRANAT="AH R AA N AH T",BASTARACHE="B AA S T AA R EY K",ALMELUND="AA L M AH L AH N D",SHRUB="SH R AH B",PARTRIDGE="P AA R T R AH JH",BAUGUESS="B AW G IH S",CASCADING="K AE S K EY D IH NG",MOSSBACHER="M AA S B AA K ER",KNILL="N IH L",GUADALCANAL="G W AA D AH L K AH N AE L",LARVAL="L AA R V AH L",COLOSIO="K AH L OW S IY OW",SIRHAN="S IH R HH AA N",UNINTERRUPTIBLE="AH N IH N T ER AH P T AH B AH L",GAMECOCKS="G EY M K AO K S",ASHAJI="AH SH AA JH IY",SALABLES="S EY L AH B AH L Z",MILLIONTH="M IH L Y AH N TH",["TRACOR(4)"]="T R AE K AO R",SCHENCK="SH EH NG K",ADDYSTON="AE D IY S T AH N",["INTERVIEWEE(2)"]="IH N ER V Y UW IY",WORKSTATIONS="W ER K S T EY SH AH N Z",BILLIONTH="B IH L Y AH N TH",["HOME-MADE"]="HH OW M M EY D",SHIMMERS="SH IH M ER Z",TIMPSON="T IH M P S AH N",SIMPSON="S IH M P S AH N",KLEVEN="K L IY V AH N",PALOMITA="P AA L OW M IY T AH",SLEVEN="S L IY V AH N",PIROZZI="P IH R AA Z IY",ALDERIDGE="AA L D ER IH JH",DISCIPLINARY="D IH S AH P L AH N EH R IY",SCZEPANSKI="S IH P AE N S K IY",["ARCHIVIST(2)"]="AA R K AY V IH S T",ACROLEIN="AE K R OW L IY N",ANNUNZIATA="AA N UW N Z IY AA T AH",GRANDSTAND="G R AE N D S T AE N D",FORNWALT="F AO R N W AH L T",CLEVEN="K L IY V AH N",ELEVEN="IH L EH V AH N",["LYANNE(2)"]="L AY AE N",RASCHE="R AE SH",POUTRE="P AW T ER",NEGATES="N IH G EY T S",["BABANGIDA(2)"]="B AH B AE NG G IH D AH",LEGATES="L EH G AH T S",OSBORN="AO Z B AO R N",QUEALY="K W IY L IY",INTERPROVINCIAL="IH N T ER P R OW V IH N SH AH L",TOROK="T AO R AH K",MUCKRAKER="M AH K R EY K ER",SKIMMERS="S K IH M ER Z",ASTORINO="AA S T AO R IY N OW",DETAILING="D IH T EY L IH NG",CHUCKED="CH AH K T",TOURIST="T UH R AH S T",RETAILING="R IY T EY L IH NG",BOXCAR="B AA K S K AA R",BLATCHLEY="B L AE CH L IY",["COMPUTERS'"]="K AH M P Y UW T ER Z",APARTHEID="AH P AA R T AY T",["EVACUATIONS(2)"]="IY V AE K Y AH W EY SH AH N Z",INSIGNIA="IH N S IH G N IY AH",MEMENTO="M IH M EH N T OW",HEMODYNAMIC="HH EH M OW D AY N AE M IH K",KEMPSON="K EH M P S AH N",MORELAND="M AO R L AH N D",TROPWORLD="T R AA P W ER L D",DESIGNATING="D EH Z IH G N EY T IH NG",BIGHORN="B IH G HH AO R N",ORCHESTRATION="AO R K AH S T R EY SH AH N",MASTRIANO="M AA S T R IY AA N OW",INBORN="IH N B AO R N",["MOROVCIC'S"]="M AO R AA V CH IH K S",HANDERS="HH AE N D ER Z",WHIMSICALLY="W IH M Z IH K L IY",FENSTERSTOCK="F EH N S T ER S T AA K",UNBORN="AH N B AO R N",PETRODOLLARS="P EH T R OW D AA L ER Z",BRIDGHAM="B R IH JH HH AH M",KATIA="K AA T IY AH",INTERRUPT="IH N T ER AH P T",WESCHE="W EH SH",["COUNTERPROPOSAL(2)"]="K AW N ER P R AH P OW Z AH L",TOBOLSKI="T AH B OW L S K IY",["ZEIBEL'S"]="Z AY B AH L Z",ZANDERS="Z AE N D ER Z",WANDERS="W AA N D ER Z",SANDERS="S AE N D ER Z",["QUARTERBACK(2)"]="K AO R T ER B AE K",MANDERS="M AE N D ER Z",EUROCRATS="Y UW R AH K R AE T S",["INTERVENTION(2)"]="IH N ER V EH N CH AH N",DIRECTIONS="D ER EH K SH AH N Z",LANDERS="L AE N D ER Z",BEATIE="B IY T IY",HOEDOWN="HH OW D AW N",URBANSKI="ER B AE N S K IY",NONMEMBER="N AA N M EH M B ER",DEVANY="D EH V AH N IY",HICCOUGH="HH IH K AH P",["SEPHLON'S"]="S EH F L AO N Z",STOPGAP="S T AA P G AE P",DEPICTING="D IH P IH K T IH NG",VAMPIRIC="V AE M P IH R IH K",SKILLFUL="S K IH L F AH L",BARRENTINE="B AE R AH N T AY N",SAMPSON="S AE M P S AH N",CUSTOMIZING="K AH S T AH M AY Z IH NG",ALBRITTON="AE L B R IH T AA N",HAMPSON="HH AE M P S AH N",CONSUMERISTS="K AH N S UW M ER IH S T S",INVITEES="IH N V AY T IY Z",LAWTER="L AO T ER",["ARTIST(2)"]="AA R T IH S T",GLOBALIZE="G L OW B AH L AY Z",LAMPSON="L AE M P S AH N",OSTERMEIER="AA S T ER M AY ER",STROUP="S T R UW P",TRIMMERS="T R IH M ER Z",LEGITIMATE="L AH JH IH T AH M AH T",["CECIL'S"]="S IY S AH L Z",BOOTSTRAP="B UW T S T R AE P",AMBORN="AH M B AO R N",FRANKINCENSE="F R AE NG K AH N S EH N S",RICHARDT="R IH K AA R T",PANCOAST="P AE N K OW S T",STIGLITZ="S T IH G L IH T S",PRUNING="P R UW N IH NG",STOECKLEIN="S T OW K L AY N",["MCCORMICK'S"]="M AH K AO R M IH K S",DEOLIVEIRA="D IY AA L IH V EY R AH",LETTISH="L EH T IH SH",OCELOT="AA S AH L AA T",SCARCELY="S K EH R S L IY",["DIRECTLY(3)"]="D AY R EH K L IY",MULVANEY="M AH L V EY N IY",VALUEPOINT="V AE L Y UW P OY N T",ZHIRINOVSKY="ZH IH R AH N AA V S K IY",BUCKEYE="B AH K AY",DESCRIBES="D IH S K R AY B Z",SHIMEK="SH IH M IH K",BEGUN="B IH G AH N",PEMBROKE="P EH M B R OW K",GLIMMERS="G L IH M ER Z",COMPENSATED="K AA M P AH N S EY T AH D",BALLANTYNE="B AH L AE N T AY N",DALRYMPLE="D AE L R IH M P AH L",COSSIGA="K AO S IY G AH",BOMBARDMENTS="B AA M B AA R D M AH N T S",["INSPECTOR'S"]="IH N S P EH K T ER Z",["ONENESS(2)"]="W AH N AH S",SCAVENGER="S K AE V AH N JH ER",MATAKSAS="M AH T AE K S AH S",STAVOLA="S T AA V OW L AH",PEWTER="P Y UW T ER",["MARTINEZ'S"]="M AA R T IY N EH Z IH Z",LEWTER="L UW T ER",TRYOUT="T R AY AW T",CARBONATES="K AA R B AH N EY T S",DELINQUENCY="D IH L IH NG K W AH N S IY",MANIPULATION="M AH N IH P Y AH L EY SH AH N",PAAVOLA="P AA V OW L AH",TERRENCE="T EH R AH N S",PARTAKE="P AA R T EY K",APRIORI="AH P R IY AO R IY",LUCICH="L AH CH IH HH",["PICTURE'S"]="P IH K CH ER Z",BAUMGARDT="B AW M G AA R T",AUDIOVISUAL="AO D IY OW V IH ZH UW AH L",DOLLOFF="D AA L AO F",["JEANBERTRAND(2)"]="ZH AA N B EH R T R AA N D",OGBORN="AA G B ER N",LAFOY="L AH F OY",MARCHIONESS="M AA R SH AH N IH S",AUDWIN="AO D W IH N",GOVONI="G OW V OW N IY",FUNCTIONARIES="F AH NG K SH AH N EH R IY Z",LUDWIN="L AH D W IH N",WITHSTAND="W IH TH S T AE N D",VITIA="V IY SH AH",CANALS="K AH N AE L Z",CUAUHTEMOC="K Y UW AW T AH M AA K",LAMMI="L AE M IY",["HOFFMAN'S"]="HH AO F M AH N Z",ST_MARY="S EY N T M EH R IY",KLIMEK="K L IH M IH K",EOSINOPHILIA="IY AH S IH N AH F IH L Y AH",COSTABILE="K AO S T AH B AY L",AFFLICTIONS="AH F L IH K SH AH N Z",["MINERAL(2)"]="M IH N R AH L",["OSWALD'S"]="AO Z W AO L D Z",INJUDICIOUS="IH N JH AH D IH SH AH S",WONDERS="W AH N D ER Z",RELIGIONS="R IY L IH JH AH N Z",STIG="S T IH G",PONDERS="P AA N D ER Z",PFLUG="F L UW G",SHANEYFELT="SH AE N IY F EH L T",["COLLOSIO'S"]="K AH L OW S IY OW Z",RUZICKA="R UW Z IH K AH",["GOFFMAN'S"]="G AA F M AH N Z",PLUMMET="P L AH M AH T",LORENZETTI="L AO R EH N Z EH T IY",SCARSDALE="S K AA R Z D EY L",PANELIZATION="P AE N AH L AH Z EY SH AH N",["L'ENFANT(2)"]="L AA N F AA N T",STRAWBRIDGE="S T R AO B R IH JH",["DICKSTEIN(2)"]="D IH K S T IY N",BELANOFF="B EH L AH N AO F",TOPOLOGY="T AH P AO L AH JH IY",BARBERO="B AA R B EH R OW",COWGIRL="K AW G ER L",CARGOES="K AA R G OW Z",BEDORE="B EH D AO R",TRUCKED="T R AH K T",NORODOM="N AO R OW D AH M",CATAPULTS="K AE T AH P AH L T S",VOCALTEC="V OW K AH L T EH K",SEDORE="S EH D AO R IY",DECEITFUL="D AH S IY T F AH L",["CITY'S"]="S IH T IY Z",["ENTOURAGE(2)"]="AA N T ER AA ZH",DROPOUTS="D R AA P AW T S",HARALSON="HH AE R AH L S AH N",SUCCUMBED="S AH K AH M D",MUNDAY="M AH N D EY",LUNDAY="L AH N D EY",CULTIVATES="K AH L T IH V EY T S",["TRANSMISSION(2)"]="T R AE N Z M IH SH AH N",PRONGER="P R AO N G ER",NASTIER="N AE S T IY ER",MACIAS="M AA S IY AH S",PRINTOUT="P R IH N T AW T",TASTIER="T EY S T IY ER",COZAD="K OW Z AH D",BRANDENBERGER="B R AE N D AH N B ER G ER",WALDHOLZ="W AO L D HH OW L T S",LOZAD="L OW Z AE D",WESTDEUTSCHE="W EH S T D OY CH",ACQUIT="AH K W IH T",PROGNOSTICATIVE="P R AA G N AA S T AH K EY T IH V",KNECHTEL="N EH K T AH L",CLARKSBURG="K L AA R K S B ER G",KIRKSEY="K ER K S IY",KLEINER="K L AY N ER",ANTIQUATED="AE N T AH K W EY T AH D",["T-BONE"]="T IY B OW N",PONTIFICATES="P AA N T IH F AH K EY T S",PAPERBOYS="P EY P ER B AO Y Z",["DISINTEGRATION(2)"]="D IH S IH N AH G R EY SH AH N",JANECZKO="Y AH N EH CH K OW",SWIMMERS="S W IH M ER Z",SUFFICED="S AH F AY S T",SORDID="S AO R D AH D",SUNDAY="S AH N D EY",OVERAMBITIOUS="OW V ER AE M B IH SH AH S",STANISLAV="S T AE N IH S L AA V",ENFORCEABILITY="EH N F AO R S AH B IH L IH T IY",LETICIA="L AH T IH SH AH",ERCEG="ER S IH G",MCANANY="M AH K AE N AH N IY",STEWARDSHIP="S T UW ER D SH IH P",SOLITARINESS="S AA L AH T EH R IY N IH S",AERONAUTIC="EH R OW N AA T AH K",GORGUZE="G AO R G Y UW Z",EXCORIATING="EH K S K AO R IY EY T IH NG",REDEMPTIVE="R IH D EH M P T IH V",TRUSTCO="T R AH S T K OW",CILENTO="S IH L EH N T OW",["HERRE(2)"]="HH AH R IY",HOURLY="AW R L IY",["FERRUZZI'S"]="F ER UW Z IY Z",COTTIER="K AA T IY ER",KITTELSON="K IH T IH L S AH N",MASTECTOMIES="M AE S T EH K T AH M IY Z",STILLWAGON="S T IH L W AE G AH N",GABIE="G AE B IY",MABIE="M AE B IY",["UH-HUH"]="AH HH AH",SQUABBLING="S K W AA B AH L IH NG",UNDERDAHL="AH N D ER D AA L",["GERASIMOV(2)"]="G ER AE S IH M AA V",SCHWANKE="SH W AO NG K",PAYCHEX="P EY CH EH K S",SCHANK="SH AE NG K",["D'ANDREA"]="D AE N D R IY AH",SHOOTINGS="SH UW T IH NG Z",REAUTHORIZE="R IY AO TH ER AY Z",["COUNTERATTACKING(2)"]="K AW N ER AH T AE K IH NG",BENDERS="B EH N D ER Z",["POSTMAN(2)"]="P OW S M AH N",GENDERS="JH EH N D ER Z",LENDERS="L EH N D ER Z",NAVIGATES="N AE V AH G EY T S",PENDERS="P EH N D ER Z",BOOKSELLER="B UH K S EH L ER",RENDERS="R EH N D ER Z",SENDERS="S EH N D ER Z",TENDERS="T EH N D ER Z",WENDERS="W EH N D ER Z",TECHNIQUE="T EH K N IY K",["RAISINS(2)"]="R EY Z IH N Z",COOPMAN="K UW P M AH N",VISNIC="V IH S N IH CH",CHANGEABLE="CH EY N JH AH B AH L",["ACCEPT(2)"]="AH K S EH P T",MODESTINE="M OW D EH S T IY N IY",["WHISKY(2)"]="HH W IH S K IY",HOMOSAPIENS="HH OW M OW S EY P IY AH N Z",OBTRUDES="AH B T R UW D Z",EXCRETION="IH K S K R IY SH AH N",["GENERAL(2)"]="JH EH N R AH L",VANDEGRIFT="V AE N D AH G R IH F T",["SECTION'S"]="S EH K SH AH N Z",DELGIORNO="D EH L JH AO R N OW",MOLUCCA="M AH L UW K AH",MCBRIDGE="M AH K B R IH JH",PENSIVE="P EH N S IH V",REAGOR="R IY G ER",BEMOAN="B IH M OW N",DUENOW="D UW N OW",DIEHARD="D AY HH AA R D",SALTLIKE="S AO L T L AY K",["DAMIEN'S"]="D EY M IY AH N Z",ITAMI="IH T AA M IY",["AMOUNTED(2)"]="AH M AW N IH D",PREOCCUPIES="P R IY AA K Y AH P AY Z",REVIGLIO="R AH V IH G L IY OW",OUSEBA="UW S AH B AH",YOUNKIN="Y AH NG K IH N",REFINER="R IH F AY N ER",NETWORTH="N EH T W ER TH",["ADEQUATE(2)"]="AE D AH K W EY T",KRAUSKOPF="K R AW S K AO F",SQUIRRELS="S K W ER AH L Z",SAMOAN="S AH M OW AH N",PARLAYED="P AA R L EY D",ARROWROOT="EH R OW R UW T",BINDERS="B AY N D ER Z",MANGIARACINA="M AA N JH ER AA CH IY N AH",MULTIPLY="M AH L T AH P L AY",CONSENT="K AH N S EH N T",MULTIPLIER="M AH L T AH P L AY ER",ALTOONA="AE L T UW N AH",REGGAE="R EH G EY",CRAYFISH="K R EY F IH SH",WINDERS="W IH N D ER Z",MEDWIN="M EH D W IH N",BINGHAMTON="B IH NG AH M T AH N",VONBARGEN="V AA N B AA R G AH N",KLITZKE="K L IH T S K IY",DEVOURED="D IH V AW ER D",VERLEGER="V ER L AH G ER",["PROTROPIN(2)"]="P R OW T R OW P IH N",["MOTOROLA'S"]="M OW T ER OW L AH Z",CHAPTERS="CH AE P T ER Z",GIENOW="G IY N AW",["SANDWICH(2)"]="S AE N W IH CH",WIGGINTON="W IH G IH N T AH N",NEDLLOYD="N EH D AH L OY D",PEDONE="P EY D OW N EY",COLORWATCH="K AH L ER W AA CH",GRUDGING="G R AH JH IH NG",REDONE="R IY D AH N",["ECHLIN'S"]="EH K L IH N Z",SNEDDON="S N EH D AH N",ANDIE="AE N D IY",DEGREES="D IH G R IY Z",LANDAY="L AE N D EY",LAYOUT="L EY AW T",NIENOW="N IY N OW",MAROTTA="M ER AA T AH",HERN="HH ER N",QUERIDA="K W EH R IY D AH",KANGAROO="K AE NG G ER UW",BURGHARDT="B ER G AA R T",DERN="D ER N",SHANAFELT="SH AE N AH F EH L T",BERN="B ER N",DECENT="D IY S AH N T",KLOCEK="K L OW S IH K",VERDEROSA="V ER D ER OW S AH",PLOCEK="P L OW CH EH K",SHERRGOLD="SH EH R G OW L D",ADAMEC="AH D AA M IH K",STOKLOSA="S T AH K L OW S AH",TRUDGING="T R AH JH IH NG",FANCIEST="F AE N S IY AH S T",["AYER'S(2)"]="EY R Z",BUTTERFLIES="B AH T ER F L AY Z",ALSHELHAH="AA L SH EH L HH AH",CONSISTS="K AH N S IH S T S",VASCULAR="V AE S K Y AH L ER",["OFTEN(2)"]="AO F T AH N",KIRN="K ER N",RAISOR="R EY Z ER",PRESLAR="P R IH S L AA R",["UNEQUIVOCAL(2)"]="AH N IY K W IH V AH K AH L",STEREOTYPE="S T EH R IY AH T AY P",HERBIN="HH ER B IH N",BARBASH="B AA R B AE SH",HOYLAKE="HH OY L EY K",OCTAVIA="AA K T EY V IY AH",SERBIN="S ER B IH N",PERFUMED="P ER F Y UW M D",BUTTERFIELD="B AH T ER F IY L D",ACCENT="AH K S EH N T",NONCONTRACT="N AA N K AA N T R AE K T",EXPECTED="IH K S P EH K T AH D",MICROCOM="M AY K R OW K AA M",LIMONITE="L AY M AH N AY T",APPOINTEES="AH P OY N T IY Z",RACHAEL="R EY CH AH L",GEBHARDT="G EH B HH AA R T",MISMANAGES="M IH S M AE N IH JH AH Z",OLDIE="OW L D IY",ACCRETION="AH K R IY SH AH N",PROPHETS="P R AA F AH T S",SCOTTON="S K AA T AH N",GIROLAMO="JH IH R OW L AA M OW",BOSCHWITZ="B AO SH W IH T S",MISAPPLICATION="M IH S AE P L AH K EY SH AH N",["ORGANIZATION'S"]="AO R G AH N IH Z EY SH AH N Z",ALLENTOWN="AE L AH N T AW N",EUPHORY="Y UW F AO R IY",HILFIGER="HH IH L F AY G ER",VERN="V ER N",PREWITT="P R UW IH T",KERN="K ER N",THERAPY="TH EH R AH P IY",RETROFITTING="R EH T R OW F IH T IH NG",INDIE="IH N D IY",UNALTERED="AH N AO L T ER D",SECRETION="S AH K R IY SH AH N",OMISSIONS="OW M IH SH AH N Z",LOUISVILLE="L UW IY V IH L",LAFAVOR="L AE F AH V ER",WHOOPIE="W UW P IY",THIELEN="TH IY L AH N",["GLASSES(2)"]="G L AE S IH Z",["SUPERINTENDANT(2)"]="S UW P ER IH N T EH N D AH N T",RIOTOUS="R AY AH T AH S",BROTHERSON="B R AH DH ER S AH N",PORN="P AO R N",GHAZNAVI="G AH Z N AA V IY",KORN="K AO R N",JUDIE="JH AH D IY",MORN="M AO R N",["EXECUTIVES'"]="EH G Z EH K Y AH T IH V Z",WORN="W AO R N",ACORNS="EY K AO R N Z",TORN="T AO R N",RUDIE="R UW D IY",GEOMAGNETIC="JH IY OW M AE G N EH T IH K",["TINKLING(2)"]="T IH NG K L IH NG",SHORTSTOP="SH AO R T S T AA P",["NAVY'S"]="N EY V IY Z",EUCHARIST="Y UW K ER AH S T",DAIRYMEN="D EY R IY M AH N",AIELLO="AY EH L OW",ASBURY="AE Z B EH R IY",ANNUIT="AH N UW IH T",CONVICTION="K AH N V IH K SH AH N",["CLASSES(2)"]="K L AE S IH Z",DEVAUL="D IH V OW L",ADORNS="AH D AO R N Z",BAXTER="B AE K S T ER",STERNBERGER="S T ER N B ER G ER",RONAYNE="R AA N EY N",AUTHORSHIP="AO TH ER SH IH P",KUNSELMAN="K AH N S AH L M AH N",LAFATA="L AA F AA T AH",["UNIVERSAL'S"]="Y UW N AH V ER S AH L Z",BORN="B AO R N",DEOXYRIBONUCLEIC="D IY AA K S IY R AY B OW N UW K L EY IH K",["DEBLUM(2)"]="D AH B L AH M",ASSAILANTS="AH S EY L AH N T S",HORN="HH AO R N",SINIBALDI="S IH N IH B AA L D IY",DORN="D AO R N",["LARYNGOSCOPICAL(2)"]="L AA R IH N JH AH S K AA P IH K AH L",MULTIBANK="M AH L T IY B AE NG K",EMBURY="EH M B EH R IY",RAXTER="R AE K S T ER",OTHERNESS="AH DH ER N AH S",WELLCOME="W EH L K AH M",["PINOCHET(2)"]="P IY N AO CH EH T",HAGEMAN="HH EY JH M AH N",HAINAN="HH EY N AH N",VACLAVIK="V AE K L AH V IH K",AIRPORTER="EH R P AO R T ER",STROHMAIER="S T R OW M AY ER",STINCHFIELD="S T IH N CH F IY L D",CLORINDA="K L AO R IY N D AH",RABOBANK="R AA B OW B AE NG K",WAGEMAN="W EY JH M AH N",["PRIVILEGES(4)"]="P R IH V IH L IH JH IH Z",FLORINDA="F L AO R IY N D AH",ENDOCRINE="EH N D OW K R AY N",UNAFFORDABLE="AH N AH F AO R D AH B AH L",HIRN="HH ER N",REASSIGNING="R IY AH S AY N IH NG",ODORLESS="OW D ER L AH S",TUSCALOOSA="T AH S K AH L UW S AH",BANCSHARES="B AE NG K SH EH R Z",GUTIERRES="G UW T Y EH R EH Z",EXONERATION="IH G Z AA N ER EY SH AH N",APPLICABILITY="AE P L AH K AH B IH L AH T IY",BERKOWITZ="B ER K AH W IH T S",FLEEGER="F L IY G ER",MCGEEAN="M AH G IY AH N",EAGERNESS="IY G ER N AH S",PASOK="P AA Z AA K",PENDERGRASS="P EH N D ER G R AH S",DEXTER="D EH K S T ER",["CARMAKERS'"]="K AA R M EY K ER Z",UBIQUITY="Y UW B IH K W IH T IY",FLEMISTER="F L EH M IH S T ER",INGLESE="IH NG G L IY Z",CARBIN="K AA R B IH N",["CONTRASTS(3)"]="K AA N T R AE S",BARBIN="B AA R B IH N",SCORNS="S K AO R N Z",KREEGER="K R IY G ER",OUTFITTED="AW T F IH T IH D",HUGHBANKS="HH AH B AH NG K S",HARBIN="HH AA R B IH N",NEWBILL="N UW B IH L",SURVIVALISTS="S ER V AY V AH L IH S T S",PERENNIALS="P ER EH N IY AH L Z",SOFTENS="S AO F AH N Z",["LEADBETTER(2)"]="L EH D B IH T ER",FARSIGHTEDNESS="F AA R S AY T IH D N AH S",TEXTER="T EH K S T ER",POCHILUK="P AH CH IY L UW K",CREATIVENESS="K R IY EY T IH V N AH S",["CYCLIST(2)"]="S AY K L IH S T",["TARZAN'S"]="T AA R Z AE N Z",CYBERPORN="S AY B ER P AO R N",PRUSSAK="P R AH S AH K",ALBURY="AE L B EH R IY",VENTRESS="V EH N T R IH S",["CYRANO(2)"]="S IH R AH N OW",COORDINATOR="K OW AO R D AH N EY T ER",FOSIA="F OW ZH AH",DOSIA="D OW S IY AH",ELEPHANTIASIS="EH L IH F AH N T AY AH S IH S",FENTRESS="F EH N T R IH S",["MAGLAJ'S"]="M AA G L AY Z",GERLOFF="G ER L AO F",TOKARCZYK="T AA K ER CH IH K",SHOWERING="SH AW ER IH NG",STRIKES="S T R AY K S",MERCILESSLY="M ER S AH L AH S L IY",SNIFFY="S N IH F IY",SEAGRAVES="S IY G R EY V Z",SKENANDORE="S K IH N AE N D ER",WASIELEWSKI="V AH S IY L EH F S K IY",SCRIPPS="S K R IH P S",JODIE="JH OW D IY",MCKARRICK="M AH K AE R IH K",DISMUKES="D IH S M Y UW K S",DIFFRACT="D IH F R AE K T",RADBORNE="R AH D B AO R N",BODIE="B OW D IY",["REDUCES(2)"]="R IH D UW S IH Z",IMPLIED="IH M P L AY D",BEECHWOOD="B IY CH W UH D",STEENKAMP="S T IY N K AE M P",AFFIXES="AE F IH K S IH Z",SPIFFY="S P IH F IY",HRABAK="HH R AA B AH K",FINANCIERS="F IH N AH N S IH R Z",ROBICHAUD="R AA B IH SH OW",PATCHY="P AE CH IY",SUPPOSITION="S AH P AH Z IH SH AH N",["RESIGNED(3)"]="R IY S AY N D",KARANICKI="K EH R AH N IH K IY",PASSANISI="P AA S AA N IY S IY",FACILITIES="F AH S IH L AH T IY Z",BELLIZZI="B EH L IY T S IY",MURDERS="M ER D ER Z",FLOWERING="F L AW ER IH NG",LYDIE="L IH D IY",EYDIE="EY D IY",CURATIVE="K Y UH R AH T IH V",LEITZKE="L AY T S K IY",NEITZKE="N AY T S K IY",KOMINEFT="K AA M IH N EH F T",HARLOFF="HH AA R L AO F",["CARNEGIE-MELLON(2)"]="K AA R N EY G IY M EH L AH N",SCHANER="SH EY N ER",GRIFFY="G R IH F IY",IONIZE="AY AH N AY Z",BIELEFELD="B IY L IH F EH L D",MEATBALL="M IY T B AO L",APPLIED="AH P L AY D",CUTSFORTH="K AH T S F AO R TH",SYMPSON="S IH M P S AH N",CAMPFIELD="K AE M P F IY L D",GENITALIA="JH EH N AH T AA L Y AH",ACHING="EY K IH NG",SHOBANA="SH OW B AA N AH",CLARIDGE="K L EH R IH JH",FLIPPO="F L IH P OW",SURGEONS="S ER JH AH N Z",CONTRIVANCES="K AH N T R AY V AH N S IH Z",KARAOKE="K EH R IY OW K IY",ARCHIVAL="AA R K AY V AH L",CHRYSLERS="K R AY S L ER Z",YASUHIKO="Y AA S UW HH IY K OW",BAGDAD="B AE G D AE D",COLLODION="K AH L OW D IY AH N",JAQUITH="JH AE K W IH TH",UNDERTOOK="AH N D ER T UH K",CHITLIN="CH IH T L IH N",BLOWUP="B L OW AH P",ENGRAVING="IH N G R EY V IH NG",REPUBLICA="R IH P AH B L IH K AH",DEVEREUX="D EH V ER UW",["ROUGH'S"]="R AH F S",BLEWITT="B L UW IH T",COGENT="K OW JH AH N T",EXCEEDS="IH K S IY D Z",MESSERLI="M EH S ER L IY",PROMOTER="P R AH M OW T ER",["SMUGGLERS(2)"]="S M AH G AH L ER Z",REPLIED="R IH P L AY D",PURULENT="P Y UH R UW L AH N T",MOONBEAM="M UW N B IY M",["AUJOURD'HUI"]="OW ZH AO R D W IY",KALGOORLIE="K AE L G UW R L IY",VANETTEN="V AE N EH T AH N",CROOKLYN="K R UH K L IH N",STRAGGLE="S T R AE G AH L",BROOKLYN="B R UH K L AH N",UNRUH="AH N R UW",TANTRUMS="T AE N T R AH M Z",GUNBOAT="G AH N B OW T",AUSCHWITZ="AO SH W IH T S",PRIORITIES="P R AY AO R AH T IY Z",CLOTHIERS="K L OW DH Y ER Z",LIPOVSKY="L IH P AA V S K IY",RUTHLESSLY="R UW TH L AH S L IY",CONASUPO="K AA N AH S UW P OW",EVERYBODY="EH V R IY B AA D IY",HATCHETS="HH AE CH AH T S",BOTANISTS="B AA T AH N IH S T S",ARGENT="AA R JH IH N T",DECORUM="D IH K AO R AH M",SAUVAGEAU="S OW V AH ZH OW",BURKHARD="B ER K HH ER D",BJORK="B Y AO R K",URGENT="ER JH AH N T",UNDONE="AH N D AH N",PETRODOLLAR="P EH T R OW D AA L ER",["ARTY'S"]="AA R T IY Z",UNVEILED="AH N V EY L D",MATCHBOX="M AE CH B AA K S",GRUPO="G R UW P OW",ZELLERBACH="Z EH L ER B AA K",EXCITES="IH K S AY T S",["REBEL(2)"]="R IH B EH L",["THOROUGH(2)"]="TH AO R OW",DENATURE="D IH N EY CH ER",SUPERINTENDENTS="S UW P ER AH N T EH N D AH N T S",WESTERFIELD="W EH S T ER F IY L D",ESTIMATING="EH S T AH M EY T IH NG",ADAPTERS="AH D AE P T ER Z",LOUSINESS="L AW Z IY N AH S",GRIPPO="G R IH P OW",["LANDVIEW'S"]="L AE N D V Y UW Z",["EXBROKER'S"]="EH K S B R OW K ER Z",FORGOES="F AO R G OW Z",["WHIPPOORWILLS(2)"]="HH W IH P ER W IH L Z",DEFLECTS="D IH F L EH K T S",STANKIEWICZ="S T AE N K AH V IH CH",TOXICOLOGICAL="T AA K S AH K AH L AA JH IH K AH L",STORK="S T AO R K",REFLECTS="R IH F L EH K T S",LAVERE="L AA V EH R EY",BREIDENSTEIN="B R AY D AH N S T AY N",RESCUING="R EH S K Y UW IH NG",TRANSLOGIC="T R AE N Z L AA JH IH K",DELICATESSENS="D EH L IH K AH T EH S AH N Z",MARKOWITZ="M AA R K AH W IH T S",["FRENZEL(2)"]="F R EH N Z EH L",BISCEGLIA="B IH S CH EH G L IY AH",PLURALIZE="P L UH R AH L AY Z",KITAMURA="K IY T AA M UH R AH",["LANDSLIDE(2)"]="L AE N S L AY D",MITAMURA="M IY T AH M UH R AH",PANTSUITS="P AE N T S UW T S",INVALIDATED="IH N V AE L AH D EY T AH D",SUGARED="SH UH G ER D",WEGLARZ="W EH G L AA R Z",["SURPRISED(2)"]="S AH P R AY Z D",REDCOATS="R EH D K OW T S",POSTERIORS="P AO S T IH R Y ER Z",SCHUMER="SH UW M ER",DIATHERMY="D AY AH TH ER M IY",GAROUTTE="G ER UW T",RENEWS="R IH N UW Z",SHRIEKED="SH R IY K T",QUELL="K W EH L",MILITIAMEN="M AH L IH SH AH M IH N",REASONABLY="R IY Z AH N AH B L IY",ACCEPTABLE="AE K S EH P T AH B AH L",["ORMSBY'S"]="AO R M Z B IY Z",TUELL="T UW L",BUELL="B Y UW AH L",["MAZDA'S(2)"]="M AE Z D AH Z",POLYESTER="P AA L IY EH S T ER",DUELL="JH UW L",BLACHLY="B L AA CH L IY",CHISUM="CH IH Z AH M",ACQUIRE="AH K W AY ER",INFLATED="IH N F L EY T AH D",KOREATOWN="K ER IY AH T AW N",PUSSIES="P UH S IY Z",REBUILDER="R IY B IH L D ER",SPRANGER="S P R AE NG ER",KOSLOSKI="K AH S L AW S K IY",SQUASH="S K W AA SH",ANESTHESIOLOGY="AE N AH S TH IY Z IY AA L AH JH IY",ADMINISTER="AH D M IH N AH S T ER",HEIKKILA="HH AY K IH L AH",REINTERPRETING="R IY IH N T ER P R AH T IH NG",GREENBAUM="G R IY N B AW M",TINNY="T IH N IY",WINNY="W IH N IY",PANKRATZ="P AE NG K R AH T S",PAROCHIAL="P ER OW K IY AH L",CROIX="K R OY",GARTZKE="G AA R T S K",GLORIANE="G L AO R IY AE N",MULROY="M AH L R OY",ROOSTER="R UW S T ER",WOOSTER="W UW S T ER",ETHYLENE="EH TH AH L IY N",HEREFORD="HH EH R AH F ER D",GINNY="JH IH N IY",GSELL="G AH S EH L",MALACCA="M AH L AE K AH",MINNY="M IH N IY",PROSTITUTE="P R AA S T AH T UW T",NINNY="N IH N IY",BRANAN="B R EY N AH N",STELL="S T EH L",REPLICATED="R EH P L IH K EY T IH D",EXTRASENSORY="EH K S T R AH S EH N S ER IY",BELIEVABILITY="B AH L IY V AH B IH L IH T IY",RENEAU="R IH N OW",["ABDOMEN(2)"]="AE B D AH M AH N",OBOYLE="OW B OY L",SMOOTHEST="S M UW DH AH S T",WASHROOM="W AA SH R UW M",WAZIR="W AA Z IH R",DENEAU="D IH N OW",SHEHORN="SH EH HH ER N",BOOSTER="B UW S T ER",SUNBELT="S AH N B EH L T",STOLPE="S T OW L P",["EXCUSE(2)"]="IH K S K Y UW Z",GOODPASTER="G UH D P AE S T ER",BATTISTE="B AA T IY S T IY",DIVINITAS="D IH V IH N IY T AH S",GASPARRO="G AA S P AA R OW",["CHARLES(2)"]="CH AA R AH L Z",MUSKIE="M AH S K IY",PANSOPHIC="P AE N S AH F IH K",["BLITZER'S"]="B L IH T S ER Z",SEIYU="S IY Y UW",ALAMOUD="AE L AH M UW D",KRELL="K R EH L",PERPENDICULAR="P ER P AH N D IH K Y AH L ER",SLOKUM="S L OW K AH M",AUTHORIZED="AO TH ER AY Z D",STALEMATE="S T EY L M EY T",["REFINANCINGS(2)"]="R IY F AY N AE N S IH NG Z",IRELL="AY R EH L",GRELL="G R EH L",RENNY="R EH N IY",VOELL="V OW L",TENNY="T EH N IY",ROELL="R OW L",PENNY="P EH N IY",MONGEAU="M AH NG G OW",JENNY="JH EH N IY",NOELL="N OW L",LENNY="L EH N IY",KENNY="K EH N IY",AMAZONIA="AE M AH Z OW N IY AH",TRAILWAYS="T R EY L W EY Z",MCQUIRE="M AH K W AY R",FOELL="F IY L",HOELL="HH OW L",VERTEBRATE="V ER T AH B R EY T",["BEST-WESTERN"]="B EH S T W EH S T ER N",GEMBERLING="G EH M B ER L IH NG",AMFESCO="AE M F EH S K OW",ANTAGONIZE="AE N T AE G AH N AY Z",DIPALMA="D IH P AA L M AH",PINEAU="P IH N OW",HAAG="HH AA G",["COMMITTEE'S"]="K AH M IH T IY Z",MINEAU="M IH N OW",HELLISH="HH EH L IH SH",EXAMINE="IH G Z AE M IH N",MELLISH="M EH L IH SH",TRUEMAN="T R UH M AH N",BENNY="B EH N IY",DENNY="D EH N IY",OBERMEYER="OW B ER M AY ER",MUTABLE="M Y UW T AH B AH L",BICHSEL="B IH K S AH L",NAIVETE="N AA IY V AH T EY",["STUDEMAN(2)"]="S T UW D AH M AH N",TRASHES="T R AE SH IH Z",ROBILLARD="R AA B IH L ER D",SMELL="S M EH L",PHILIPPOUSSIS="F IH L AH P UW S AH S",MIYASAKI="M IY Y AA S AA K IY",["EMORY'S"]="EH M ER IY Z",NEFARIOUS="N AH F EH R IY AH S",REQUIRE="R IY K W AY ER",CRASHES="K R AE SH IH Z",HORMUZ="HH AO R M UW Z",LEQUIRE="L EY K W IH R EY",STEFANICH="S T EH F AH N IH CH",LOCHHEAD="L AA K HH EH D",["BRACAMONTE'S"]="B R AE K AH M AA N T IY Z",AMORTIZATION="AE M ER T IH Z EY SH AH N",REASSURANCE="R IY AH SH UH R AH N S",SNELL="S N EH L",LAPAROSCOPY="L AE P ER AA S K AH P IY",KNELL="N EH L",NAYDEN="N EY D IH N",MAYDEN="M EY D AH N",LAYDEN="L EY D AH N",HAYDEN="HH EY D AH N",GAYDEN="G EY D AH N",POSTCARD="P OW S T K AA R D",SLASHES="S L AE SH IH Z",KORTHALS="K AO R TH AH L Z",SUPERFUND="S UW P ER F AH N D",["BARTLETT'S"]="B AA R T L AH T S",CLASHES="K L AE SH IH Z",DEPALMA="D IH P AA L M AH",STEALS="S T IY L Z",NEUROTH="N UH R AO TH",SMASHES="S M AE SH IH Z",POULOS="P UW L AH S",HOESCHEN="HH OW SH AH N",PEDIGO="P EH D IY G OW",SNARSKI="S N AA R S K IY",BRAMLAGE="B R AE M L IH JH",CLARAMAE="K L AA R AA M AY",SCHELLINGER="SH EH L IH NG ER",SCISSORS="S IH Z ER Z",ENQUIRE="IH N K W AY ER",MINIONS="M IH N Y AH N Z",CANCELLING="K AE N S AH L IH NG",SONNY="S AH N IY",HERCULEAN="HH ER K Y UW L IY AH N",MCGLOTHLIN="M AH G L AA TH L AH N",["KINETIC(2)"]="K IH N EH T IH K",DONNY="D AA N IY",CONNY="K AA N IY",RONNY="R AA N IY",MALAVE="M AA L AA V IY",["SCHUTZ'S"]="SH AH T S IH Z",["COUNTERCHARGE(2)"]="K AW N ER CH AA R JH",LONNY="L AO N IY",BAROVSKY="B ER AA V S K IY",BONNY="B AA N IY",BIHAC="B IY HH AA CH",RESERVIST="R IH Z ER V IH S T",DAWSEY="D AO S IY",INQUIRE="IH N K W AY R",MILROY="M IH L R OY",NYBORG="N AY B AO R G",KRIGSTEN="K R IH G S T IH N",DELASHMUTT="D EH L AH SH M AH T",KILROY="K IH L R OY",GILROY="G IH L R OY",WASSUM="W AA S AH M",["BEDOUIN(2)"]="B EH D UW IH N",OVERKILL="OW V ER K IH L",["ANYONE'S"]="EH N IY W AH N Z",KLOSTER="K L AO S T ER",PRETENSIONS="P R AH T EH N SH AH N Z",OVERUSE="OW V ER Y UW Z",VIDIGO="V IH D IY G OW",TELLABS="T EH L AE B Z",FALANGA="F AA L AA NG G AH",["RECRUITMENT(3)"]="R IY K R UW T M AH N T",["STORY'S"]="S T AO R IY Z",PRUDENTE="P R AH D IH N T",LATELIES="L EY T L IY Z",CHALOUPKA="CH AH L UW P K AH",DUBORD="D AH B AO R D",CRAMPONS="K R AE M P AO N Z",OFFERDAHL="AA F ER D AA L",CLAFFEY="K L AE F IY",GOODBAR="G UH D B AA R",CHEYNEY="CH EY N IY",NIEZGODA="N IY Z G OW D AH",GRADUALIST="G R AE JH AH W AH L IH S T",FOURTH="F AO R TH",ESQUIRE="EH S K W AY R",COUNTERFEITED="K AW N T ER F IH T IH D",SIMPLIFY="S IH M P L AH F AY",AFTEREFFECT="AE F T ER AH F EH K T",ELLROY="EH L R OY",JESUIT="JH EH ZH UW IH T",POTABLE="P OW T AH B AH L",NOTABLE="N OW T AH B AH L",POPEYES="P AO P AY Z",SUBCOMMITTEE="S AH B K AH M IH T IY",MIXTER="M IH K S T ER",COCHRANTON="K AA K R AH N T AH N",["ALSBROOKS'"]="AE L Z B R UH K S",CROYLE="K R OY L",NEWSWEEKLY="N UW Z W IY K L IY",LEYENDECKER="L AY N D IH K ER",TRILLO="T R IH L OW",ATHEISTIC="EY TH IY IH S T IH K",SKOUSEN="S K UW S AH N",["LUBINOV(2)"]="L UW B AH N AA F",GRILLO="G R IH L OW",UNDEMOCRATIC="AH N D EH M AH K R AE T IH K",["FILL-A-BUSTER"]="F IH L AH B AH S T ER",LEASHES="L IY SH IH Z",["CRAWFORD'S"]="K R AO F ER D Z",RHODESIAN="R OW D IY ZH AH N",LAMENDOLA="L AA M EH N D OW L AH",KATSANOS="K AE T S AA N OW S",KRAMLICH="K R AE M L IH K",FRANCHISERS="F R AE N CH AY Z ER Z",PANAGOPOULOS="P AE N AH G AA P AH L IH S",STOUTNESS="S T AW T N AH S",PRODUCTS="P R AA D AH K T S",["GONZALEZ'S"]="G AA N Z AA L AH Z AH Z",["SANTA(2)"]="S AE N AH",BOARDINGHOUSE="B AO R D IH NG HH AW S",["SUPPLEMENTARY(2)"]="S AH P L AH M EH N ER IY",BIDCOS="B IH D K OW S",TEQUILIU="T AH K IY L Y UW",PYTHAGORUS="P IH TH AE G AH R AH S",STRANDLINES="S T R AE N D L AY N Z",AKAMINE="AE K AH M AY N",CAVEMAN="K EY V M AE N",HAVEMAN="HH EY V M AH N",PAPACY="P EY P AH S IY",["TWENTYSOMETHINGS(2)"]="T W EH N IY S AH M TH IH NG Z",EGGING="EH G IH NG",RUNNY="R AH N IY",TUNNY="T AH N IY",SUNNY="S AH N IY",UNCOILED="AH N K OY L D",LUNNY="L AH N IY",FUNNY="F AH N IY",EXPEDITING="EH K S P AH D AY T IH NG",BRADEMAS="B R AH D EY M AH S",["PACTEL'S"]="P AE K T EH L Z",PENOBSCOT="P AH N AA B S K AA T",WITTROCK="W IH T R AH K",CHEEKBONES="CH IY K B OW N Z",ARCHIBALD="AA R CH AH B AO L D",EDGING="EH JH IH NG",TOPIX="T OW P IH K S",STEFANELLI="S T EH F AA N EH L IY",EXPERIMENTING="EH K S P EH R AH M EH N T IH NG",["STEUBEN(2)"]="S T UW B IH N",STASIK="S T AA S IH K",SHAWMUT="SH AO M AH T",PAGING="P EY JH IH NG",SECORD="S IY K AO R D",COPPOLA="K OW P OW L AH",DEPRESSINGLY="D IH P R EH S IH NG L IY",["DOUGLAS'"]="D AH G L AH S",["WASN'T(2)"]="W AH Z AH N T",["TOTTENHAM(2)"]="T AA T AH N HH AE M",ADDERLEY="AH D ER L IY",STANDSTILL="S T AE N D S T IH L",KAIRAMO="K EH R AA M OW",PREDESTINED="P R IY D EH S T AH N D",MIGENT="M IH JH AH N T",SECURITIZATION="S IH K Y UH R AH T AH Z EY SH AH N",HOGSTON="HH AA G S T AH N",MUNSTER="M AH N S T ER",LAKEWOOD="L EY K W UH D",LOGSTON="L AA G S T AH N",ALLENDE="AA Y EH N D EY",DUNSTER="D AH N S T ER",PERULAC="P EH R UW L AE K",TYPESET="T AY P S EH T",PEPTIDE="P EH P T AY D",OBJECTIVELY="AA B JH EH K T IH V L IY",["MALAYSIA'S"]="M AH L EY ZH AH Z",["JULY'S(2)"]="JH AH L AY Z",["FARRELL'S"]="F EH R IH L Z",BOYFRIEND="B OY F R EH N D",["HARRELL'S"]="HH AE R AH L Z",THROATY="TH R OW T IY",CONGESTION="K AH N JH EH S CH AH N",DOWNPAYMENT="D AW N P EY M AH N T",OXYTOCIN="AA K S AH T OW S AH N",SYSTEMATICALLY="S IH S T AH M AE T IH K L IY",BANKRUPTED="B AE NG K R AH P T IH D",PEDALS="P EH D AH L Z",MEDALS="M EH D AH L Z",ANTTILA="AA N T IY L AH",SPORADICALLY="S P ER AE D IH K L IY",WAGING="W EY JH IH NG",HOXSEY="HH AA K S IY",MCGINNESS="M AH G IH N AH S",SAVVIEST="S AE V IY IH S T",ECUADOREAN="EH K W AH D AO R IY AH N",MELANGE="M EH L AE NG",MARQUAI="M AA R K W EY",OILSEEDS="OY L S IY D Z",VAPORIZE="V EY P ER AY Z",FRANKHOUSER="F R AE NG K HH AW S ER",BOURKE="B ER K",REGISTRIES="R EH JH IH S T R IY Z",ARRANGER="ER EY N JH ER",STERNPOSTS="S T ER N P OW S T S",KEARSE="K ER S",["HERCEGOVINA'S(2)"]="HH ER R T S AH G OW V IY N AH Z",DOUBTFIRES="D AW T F AY ER Z",STRANGER="S T R EY N JH ER",PEARSE="P ER S",BRITOIL="B R IH T OY L",METALWORKERS="M EH T AH L W ER K ER Z",TORBECK="T AO R B EH K",SPAUR="S P AO R",RESHOT="R IY SH AO T",NORBECK="N AO R B EH K",RECEPTIONISTS="R IH S EH P SH AH N IH S T S",GALLERIES="G AE L ER IY Z",LORANGER="L AO R EY N JH ER",TOPLIFF="T AA P L IH F",GROMEK="G R OW M IH K",NATALIA="N AH T AA L Y AH",TURRENTINE="T UH R EH N T IY N IY",["HUSSEIN'S"]="HH UW S EY N Z",BEARSE="B ER S",["AFFAIR'S"]="AH F EH R Z",HAULERS="HH AO L ER Z",["KRIKALEV'S"]="K R IH K AH L EH V Z",PLAGIARISM="P L EY JH ER IH Z AH M",VAUDEVILLIAN="V AA D V IH L Y AH N",AMBIGUITIES="AE M B AH G Y UW AH T IY Z",TWELVE="T W EH L V",["MCALEESE'S"]="M AH K AH L IY S IY Z",GRABBERS="G R AE B ER Z",HOMESTEADERS="HH OW M S T EH D ER Z",PESETAS="P AH S EY T AH Z",DELANGE="D EH L EY N JH",OVERCAME="OW V ER K EY M",KROBOTH="K R AA B AH TH",INTRUDES="IH N T R UW D Z",MATTIKALLI="M AE T IH K AA L IY",["REMODELING(2)"]="R IH M AA D L IH NG",SANTOSUOSSO="S AA N T OW S W OW S OW",EASTERNER="IY S T ER N ER",REFRACTORY="R AH F R AE K T ER IY",GUATEMALAN="G W AA T AH M AA L AH N",BECOMES="B IH K AH M Z",WRINKLES="R IH NG K AH L Z",CASSELBERRY="K AE S AH L B EH R IY",["MANUFACTURER'S"]="M AE N Y AH F AE K CH ER ER Z",BECHTHOLD="B EH K TH OW L D",COMEAU="K AH M OW",STAG="S T AE G",COMPANIONWAY="K AH M P AE N Y AH N W EY",AMPHORAE="AE M F ER IY",["CHOREOGRAPHING(2)"]="K AO R IY AH G R AE F IH NG",KLIPP="K L IH P",WORKWEEK="W ER K W IY K",SQUITIERI="S K W IY T IH R IY",LUSARDI="L UW S AA R D IY",["JURY'S"]="JH UH R IY Z",DIETITIAN="D AY AH T IH SH AH N",ELLITHORPE="EH L IH TH ER P",PLACED="P L EY S T",CAMPOFRIO="K AE M P AO F R IY OW",["BURY'S"]="B EH R IY Z",QUERIED="K W IH R IY D",LERCHE="L ER CH",BRINKERHOFF="B R IH NG K ER HH AO F",DECORATION="D EH K ER EY SH AH N",["UNRAVELING(2)"]="AH N R AE V L IH NG",COMMENDING="K AH M EH N D IH NG",RAIDERS="R EY D ER Z",RAYMARK="R EY M AA R K",["READINGS(2)"]="R IY D IH NG Z",SHREWSBERRY="SH R UW Z B EH R IY",SLEETH="S L IY TH",["JAEGERS(2)"]="Y AE G ER Z",BATHROOM="B AE TH R UW M",CRIMINALIZED="K R IH M AH N AH L AY Z D",ACHMED="AA HH M EH D",ROSELAND="R OW Z L AH N D",ABSOLUTENESS="AE B S AH L UW T N AH S",PEDOPHILIAC="P EH D AH F IH L Y AE K",COMPILE="K AH M P AY L",PULSAR="P UH L S ER",BRANDL="B R AE N D AH L",WILLENBRING="W IH L AH N B R IH NG",AEROQUIP="EH R AH K W IH P",ERNSTER="ER N S T ER",EMERSED="IH M ER S T",TUSCANY="T AH S K AH N IY",["ROCKWELL'S"]="R AA K W EH L Z",SHEPARD="SH EH P ER D",ALFREDO="AE L F R EY D OW",DISUNION="D IH S Y UW N Y AH N",PLANELOAD="P L EY N L OW D",GODWIN="G AA D W IH N",AUTOPART="AO T OW P AA R T",["EVELYN(2)"]="EH V AH L IH N",STEVESON="S T EH V IH S AH N",STARKER="S T AA R K ER",ACTAVAS="AE K T AA V AH Z",TEMPERAMENTS="T EH M P R AH M AH N T S",MCCOMB="M AH K OW M",LARCHE="L AA R CH IY",SPACED="S P EY S T",GIRIJA="G IH R IY JH AH",MARCHE="M AA R SH",["IRANIANS'"]="AY R EY N IY AH N Z",MISCHARGING="M IH S CH AA R JH IH NG",["POLLARD'S"]="P AA L ER D Z",SKIPP="S K IH P",IMMACULATELY="IH M AE K Y AH L AH T L IY",ALDICARB="AO L D IH K AA R B",PAPERNICK="P EY P ER N IH K",TRUESDELL="T R UW Z D EH L",WALMSLEY="W AO L M S L IY",APOLLO="AH P AA L OW",["RENAISSANCE'S"]="R EH N AH S AA N S IH Z",["MISERABLES(3)"]="M IH Z ER AA B",KIRYAS="K IH R Y AH S",CORNET="K AO R N EH T",BRAG="B R AE G",DRAG="D R AE G",["BOLTZMANN'S"]="B OW L T S M AH N Z",["MISSPELLING(2)"]="M IH S P EH L IH NG",DISCHARGING="D IH S CH AA R JH IH NG",HUMIDIFIERS="HH Y UW M IH D AH F AY ER Z",KNIPP="N IH P",MARSALIS="M AA R S AH L IH S",SARKISIAN="S AA R K IH ZH IH N",WENZHOU="W EH N Z UW",ELDWIN="IH L D W IH N",FLAG="F L AE G",ALDWIN="AO L D W IH N",LACEFIELD="L EY S F IY L D",LANDOVER="L AE N D OW V ER",TUFTLIKE="T AH F T L AY K",["STRANGLING(2)"]="S T R AE NG G L IH NG",OVERTHROW="OW V ER TH R OW",HANDOVER="HH AE N D OW V ER",MARTER="M AA R T ER",LAMBETH="L AE M B IH TH",FLUENCY="F L UW AH N S IY",BARFUSS="B AA R F AH S",TARTER="T AA R T ER",ROBICHEAUX="R AA B IH SH OW",PARABOLIC="P EH R AH B AA L IH K",CONTRACTION="K AH N T R AE K SH AH N",SWEATSHOPS="S W EH T SH AA P S",CARTER="K AA R T ER",BARTER="B AA R T ER",DARTER="D AA R T ER",BRYDEN="B R AY D AH N",FIBROIDS="F AY B R OY D Z",PONZETTI="P AA N Z EH T IY",KARTER="K AA R T ER",RESCHEDULINGS="R IY SH K EH JH UW L IH NG Z",KARBASSIOUN="K AA R B AE S IY UW N",CONTINENTALS="K AA N T AH N EH N T AH L Z",FREQUENCY="F R IY K W AH N S IY",SICKEST="S IH K AH S T",["CAUGHT(2)"]="K AO T",DISTASTEFUL="D IH S T EY S T F AH L",LOCALIZED="L OW K AH L AY Z D",LIACOS="L AY AA K OW S",RUSTYS="R AH S T IY Z",SNAG="S N AE G",["STRUCTURE'S"]="S T R AH K CH ER Z",CLELL="K L EH L",DERIVATION="D EH R AH V EY SH AH N",MCMANAMON="M AH K M AE N AH M AH N",ODEGAARD="AA D IH G AA R D",CUTWORM="K AH T W ER M",LUDLUM="L AH D L AH M",SUFFOCATE="S AH F AH K EY T",FLORIDA="F L AO R AH D AH",BACKTRACKED="B AE K T R AE K T",GRAZING="G R EY Z IH NG",MCMANNIS="M AH K M AE N AH S",["ARCHIVISTS(2)"]="AA R K AY V IH S T S",BEUYS="B Y UW IY Z",GLAZING="G L EY Z IH NG",PLEASANTRIES="P L EH Z AH N T R IY Z",SEIPP="S IY P",HUSSEIN="HH UW S EY N",AMAZING="AH M EY Z IH NG",STUYVESANT="S T AY V AH S AH N T",REISSUING="R IY IH SH UW IH NG",FEATURES="F IY CH ER Z",KJELL="K Y EH L",WERNET="W ER N IH T",GENERATED="JH EH N ER EY T AH D",SHIPP="SH IH P",CLEMENTS="K L EH M AH N T S",ELEMENTS="EH L AH M AH N T S",RECIPE="R EH S AH P IY",BOLLIG="B AA L IH G",HILLHAVEN="HH IH L HH EY V AH N",VENERATED="V EH N ER EY T IH D",GRIGGY="G R IH G IY",TWINKLES="T W IH NG K AH L Z",KARLSEN="K AA R L S AH N",ZIMNY="Z IH M N IY",BUONOCORE="B W OW N OW K AO R IY",CHELL="CH EH L",DEGIROLAMO="D IH JH IH R OW L AA M OW",STANDPOINT="S T AE N D P OY N T",SELLOFF="S EH L AO F",["WHETSTINE(2)"]="HH W EH T S T IY N",SHELL="SH EH L",OUTLAY="AW T L EY",ROADBLOCK="R OW D B L AA K",ANNULLED="AE N AH L D",CARLSEN="K AA R L S AH N",CHEMISTRY="K EH M AH S T R IY",DELOREY="D EH L ER IY",["CANAL'S"]="K AH N AE L Z",EXOTICS="EH G Z AA T IH K S",["BENIHANA(2)"]="B EH N IY HH AA N AH",BAROMETER="B ER AA M IH T ER",GLIDERS="G L AY D ER Z",CHAIKIN="CH EY K IH N",HADWIN="HH AE D W IH N",JADWIN="JH AE D W IH N",VINCENNES="V IH N S EH N AH S",POMROY="P AA M R OY",["RESCIND(2)"]="R IY S IH N D",WESTERBERG="W EH S T ER B ER G",STANKO="S T AE NG K OW",UNBURDEN="AH N B ER D AH N",MISTREATED="M IH S T R IY T IH D",["WHATNOT(2)"]="HH W AH T N AA T",["GIGANTIC(2)"]="JH AY G AE N IH K",["JACOBSON'S"]="JH EY K AH B S AH N Z",PAPAW="P AO P AO",STRETCHERS="S T R EH CH ER Z",INDIGO="IH N D AH G OW",LAFORTUNE="L AE F ER T UW N",CAROSELLI="K AA R OW S EH L IY",["CONFERENCE(2)"]="K AA N F R AH N S",COCKRAN="K AA K R AH N",["ENCYCLOPEDIA(2)"]="IH N S AY K L OW P IY D IY AH",LAMPMAN="L AE M P M AH N",LESUEUR="L EH S UW ER",SHOPLIFT="SH AA P L IH F T",TRULOVE="T R UW L OW V IY",ADELL="AH D EH L",["EVEREST'S"]="EH V ER AH S T S",SKALSKI="S K AA L S K IY",IVANKO="IY V AA N K OW",KAWAGUCHI="K AA W AA G UW CH IY",ODELL="OW D EH L",SUBURBANITES="S AH B ER B AH N AY T S",SARKAR="S AA R K AA R",SALVATORE="S AE L V AH T AO R IY",["FARMERS'"]="F AA R M ER Z",SAFING="S EY F IH NG",SPIDERS="S P AY D ER Z",JANESVILLE="JH EY N Z V IH L",["CEDRAS(2)"]="S EY D R AH S",ARBITERS="AA R B AH T ER Z",EDGREN="EH D G R EH N",BOYDEN="B OY D AH N",CARMELITA="K AA R M AH L IY T AH",FASCINATES="F AE S AH N EY T S",EUROPEANS="Y UH R AH P IY AH N Z",MINSKOFF="M IH N S K AO F",BUYOUT="B AY AW T",["NIELSEN'S"]="N IY L S AH N Z",DEININGER="D AY N IH NG ER",ABELL="EY B AH L",HEININGER="HH AY N IH NG ER",OFFING="AO F IH NG",["PARKINSON'S"]="P AA R K IH N S AH N Z",MEININGER="M AY N IH NG ER",LEININGER="L AY N IH NG ER",["RETIRING(3)"]="R IY T AY R IH NG",["BALLARD'S"]="B AE L ER D Z",PRESERVATION="P R EH Z ER V EY SH AH N",REININGER="R AY N IH NG ER",HOAG="HH OW G",INTERSCHOLASTIC="IH N T ER S K AH L AE S T IH K",WEININGER="W AY N IH NG ER",HUNCHINE="HH AH CH IY N",PANDORA="P AE N D AO R AH",CALNY="K AE L N IY",ALLSET="AO L S EH T",["SEPTEMBER'S"]="S EH P T EH M B ER Z",ABSECON="AE B S AH K AO N",MUMAW="M UW M AO",REALESTATE="R IY L IH S T EY T",POLYMERIZE="P AA L IH M ER AY Z",OVERWHELMINGLY="OW V ER W EH L M IH NG L IY",SEIDERS="S AY D ER Z",["REPRESENTATIVES'"]="R EH P R AH S EH N T AH T IH V Z",REIDERS="R IY D ER Z",SIGNALLED="S IH G N AH L D",AMTECH="AE M T EH K",ZEIDERS="Z AY D ER Z",VULGAMORE="V AH L G AH M AO R",BRANKO="B R AE NG K OW",JUNKETS="JH AH NG K IH T S",FRANKO="F R AE NG K OW",["TOOTHED(2)"]="T UW DH D",KIRKENDALL="K ER K EH N D AH L",ORAHOOD="AO R AH HH UH D",["MARKAIR'S"]="M AA R K EH R Z",STENZEL="S T EH N Z AH L",PRESUMING="P R IH Z UW M IH NG",POLSTON="P OW L S T AH N",ROLSTON="R OW L S T AH N",GOLSTON="G OW L S T AH N",SENTENCING="S EH N T AH N S IH NG",SEPARATELY="S EH P ER AH T L IY",BAUDENDISTEL="B AW D IH N D IH S T AH L",POLYMERIZED="P AA L IH M ER AY Z D",["RACING'S"]="R EY S IH NG Z",SPEEDSKATING="S P IY D S K EY T IH NG",NATHALIA="N AH TH AE L IY AH",MOJAVE="M OW HH AA V IY",KUENZEL="K UH N Z AH L",ATTACKERS="AH T AE K ER Z",STIPP="S T IH P",["REMEDIATE(2)"]="R IY M IY D IY EY T",MEALTIME="M IY L T AY M",TRANSMITTAL="T R AE N S M IH T AH L",["MONDRIAN(2)"]="M AA N D R IY AE N",DEFLATED="D IH F L EY T IH D",HELMSLEY="HH EH L M Z L IY",ORTIZ="AO R T IY Z",ROYDEN="R OY D AH N",GIRLISH="G ER L IH SH",MOGAYON="M OW G AA Y AH N",TWIGGY="T W IH G IY",DIBARTOLOMEO="D IH B AA R T OW L OW M IY OW",KONGSBERG="K AO NG Z B ER G",FALLOFF="F AO L AO F",MYSTERIOUSLY="M IH S T IH R IY AH S L IY",ESTOK="IH S T AA K",TRIPP="T R IH P",BRAWLING="B R AO L IH NG",CRAWLING="K R AO L IH NG",BENSENYORE="B EH N S IY N Y AO R",["MOORE(2)"]="M AO R",["ATLANTA(3)"]="AE T L AE N AH",REPAIRMEN="R IH P EH R M EH N",FLUORESCE="F L UH R EH S",["MITTERAND'S(2)"]="M IY T ER AE N D Z",SHAG="SH AE G",SUPPRESSANT="S AH P R EH S AH N T",["JIMMY'S"]="JH IH M IY Z",EASTERN="IY S T ER N",["BRODERICK(2)"]="B R AA D R IH K",QUIPP="K W IH P",CENSORING="S EH N S ER IH NG",EXAMINER="IH G Z AE M AH N ER",NATCHITOCHES="N AE K AH T AO SH",BURNET="B ER N IH T",SLIVOVITZ="S L IH V AH V IH T S",["SUPPLEMENTAL(2)"]="S AH P L AH M EH N AH L",EXUBERANT="IH G Z UW B ER AH N T",STATESMANSHIP="S T EY T S M AH N SH IH P",CACOPHONY="K AE K AA F AH N IY",["JORDAN'S"]="JH AO R D AH N Z",HEYDEN="HH EY D AH N",["DILLARD'S"]="D IH L ER D Z",BLOWDRIED="B L OW D R AY D",MISENHEIMER="M IH S IH N HH AY M ER",LEYDEN="L AY D AH N",["HILLARD'S"]="HH IH L ER D Z",HOTELIER="HH OW T EH L Y ER",["REASSURINGLY(2)"]="R IY AH SH UH R IH NG L IY",CONFORM="K AH N F AO R M",["PHANTOMS(2)"]="F AE N AH M Z",SWELL="S W EH L",CRAMBLIT="K R AE M B L IH T",VIAG="V AY AE G",AFFLERBACH="AE F L ER B AA K",PENETRATES="P EH N AH T R EY T S",WESTFALL="W EH S T F AO L",FRENZEL="F R EH N Z AH L",DWELL="D W EH L",EWELL="Y UW AH L",["NEURAL(2)"]="N Y UH R AH L",AMPHETAMINES="AE M F EH T AH M IY N Z",SARAJEVAN="S AA R AH Y EY V AH N",FRISCIA="F R IY S CH AH",MACARENA="M AE K AH R IY N AH",["HENRY'S"]="HH EH N R IY Z",BURNABLE="B ER N AH B AH L",LIBERTARIAN="L IH B ER T EH R IY AH N",["DEMJANJUK(2)"]="D EH M Y AE N Y UW K",SCOTTEN="S K AA T AH N",KEENEST="K IY N AH S T",PINKERTON="P IH NG K ER T AH N",LIBERALIZES="L IH B ER AH L AY Z IH Z",KLUGT="K L AH T",ARANSAS="ER AE N S AH S",ANAREN="AE N ER AH N",UNDERCOOK="AH N D ER K UH K",SCHORR="SH AO R",AMFAC="AE M F AE K",PRIBULA="P R IY B UW L AH",["SABERBEIN'S"]="S EY B ER B AY N Z",ELKHORN="EH L K HH AO R N",JULEPS="JH UW L AH P S",["SCHNEIDERS'"]="SH N AY D ER Z",["MANAGERS(2)"]="M AE N IH JH ER Z",DIFFERENTIALS="D IH F ER EH N SH AH L Z",SHIEH="SH IY",LEGIT="L EH JH IH T",IRIANESE="AY R IY AH N IY S",SELOWSKY="S EH L AW S K IY",CONVENTIONAL="K AH N V EH N SH AH N AH L",GORRIAK="G AO R IY AE K",PERVADES="P ER V EY D Z",LIGHTWEIGHT="L AY T W EY T",KRAMM="K R AE M",["OLLIE'S(2)"]="OW L IY Z",DRASTICALLY="D R AE S T IH K L IY",CRITELLI="K R IH T EH L IY",RESONATING="R EH Z AH N EY T IH NG",ALTUCHER="AE L T AH K ER",["SKETCHES(2)"]="S K EH CH IH Z",MICROGRAPHICS="M AY K R OW G R AE F IH K S",MARCOE="M AA R K OW",CLAREN="K L AE R AH N",DURABLE="D UH R AH B AH L",DEJOY="D AH JH OY",CHIMED="CH AY M D",ETERNALLY="IH T ER N AH L IY",GRISSOM="G R IH S AH M",WESELOH="W EY S EY L OW",["INSUBSTANTIATE(2)"]="IH N S AH B S T AE N SH IY EY T",WHITESELL="W AY T S EH L",TRIPLE="T R IH P AH L",NONSTANDARD="N AA N S T AE N D ER D",FAGNANT="F AE G N AH N T",COUNSELLORS="K AW N S AH L ER Z",MAGNANT="M AE G N AH N T",CURABLE="K Y UH R AH B AH L",UMSTEAD="AH M S T EH D",WOMANIZING="W UH M AH N AY Z IH NG",TRUTHFULLY="T R UW TH F AH L IY",DIGIT="D IH JH AH T",SENSENEY="S EH N S IH N IY",["SHIPPER'S"]="SH IH P ER Z",BESAW="B IY S AO",ENVISIONED="EH N V IH ZH AH N D",IDEALIZED="AY D IY AH L AY Z D",HOLDERBAUM="HH OW L D ER B AW M",["CATERPILLAR'S"]="K AE T ER P IH L ER Z",DOILIES="D OY L IY Z",PROMILACIDIC="P R OW M IH L AH S IY D IH K",EGLANTINE="EH G L AH N T AY N",CULTURALISM="K AH L CH ER AH L IH Z AH M",["PARISHES(2)"]="P EH R IH SH IH Z",GORBACHEVS="G AO R B AH CH EH V Z",[")PAREN"]="P ER EH N",["(PAREN"]="P ER EH N",["MUSSOLINI'S"]="M UW S OW L IY N IY Z",["LOUIS'S"]="L UW IH S IH Z",HECKLING="HH EH K L IH NG",INFLATING="IH N F L EY T IH NG",PALLIATIVE="P AE L IY AH T IH V",WASDEN="W AO S D AH N",WESTERN="W EH S T ER N",TOWBIN="T OW B IH N",HEADLIGHTS="HH EH D L AY T S",MWANZA="M W AA N Z AH",KWANZA="K W AA N Z AH",BIOMETRIC="B AY AH M EH T R AH K",ARBITRAGING="AA R B AH T R AA JH IH NG",SPACESUIT="S P EY S UW T",MASDEN="M AE S D AH N",["SKIPPER'S"]="S K IH P ER Z",["GLASNOST(2)"]="G L AO S T N OW S T",STAMM="S T AE M",BASDEN="B AE S D AH N",LIVELIER="L AY V L IY ER",VALENT="V AE L AH N T",STANZA="S T AE N Z AH",SAMEDAN="S AE M AH D AH N",ENLIGHTENED="EH N L AY T AH N D",WRINKLED="R IH NG K AH L D",ELEFANTE="EH L EH F AA N T IY",BERGDORF="B ER G D AO R F",MAIMED="M EY M D",LIQUEUR="L IH K ER",HATTABAUGH="HH AE T AH B AO",GIONET="JH IY OW N EY T",DELIGHTING="D IH L AY T IH NG",FASCHING="F AE SH IH NG",["PLACK'S"]="P L AE K S",LEAVY="L IY V IY",SPLINTERED="S P L IH N T ER D",HEAVY="HH EH V IY",KREUL="K R UW L",HAFIF="HH AA F IY F",BIBLIOGRAPHIES="B IH B L IY AA G R AH F IY Z",PEAVY="P IY V IY",["EMERGES(2)"]="IY M ER JH IH Z",ALKALINE="AE L K AH L AY N",["MARION'S"]="M EH R IY AH N Z",SEIDELMAN="S AY D AH L M AH N",["ALYESKA'S"]="AE L Y EH S K AH Z",TWINKLED="T W IH NG K AH L D",PREDICTIONS="P R IY D IH K SH AH N Z",DETAINEE="D IY T EY N IY",["CARBOHYDRATE(2)"]="K AA R B OW HH AY D R AH T",UNDERMINES="AH N D ER M AY N Z",BUENROSTRO="B W EH N R OW S T R OW",CAUTIONARY="K AO SH AH N EH R IY",SCIMED="S AY M EH D",DELEGATES="D EH L AH G EY T S",["TRACK'S"]="T R AE K S",REHABILITATORS="R IY HH AH B IH L AH T EY T ER Z",["MONROE'S"]="M AH N R OW Z",["TSONGAS'S"]="T S AO NG G AH S AH Z",VOLUNTARILY="V AA L AH N T EH R AH L IY",MUMIA="M AH M IY Y AH",MACCHI="M AE K IY",BACKWARDNESS="B AE K W ER D N AH S",FECUNDITY="F AH K AH N D IH T IY",OVERSPENDING="OW V ER S P EH N D IH NG",["ENRICHMENT(2)"]="IH N R IH CH M AH N T",BACCHI="B AE K IY",PROSTHESES="P R AA S TH IY S IY Z",MISSTATING="M IH S S T EY T IH NG",ANTLERS="AE N T L ER Z",KNOCHEL="N AA K AH L",BULENT="B Y UW L AH N T",ADAMI="AA D AA M IY",["INTELLECTUAL(2)"]="IH N AH L EH K CH UW AH L",["HOSTUTLER(2)"]="HH AA S T UW T L ER",CHILIES="CH IH L IY Z",SYNCHRONIC="S IH NG K R AA N IH K",COLARUSSO="K OW L AA R UW S OW",VACATIONS="V EY K EY SH AH N Z",RUSSIANS="R AH SH AH N Z",CONVEYOR="K AH N V EY ER",CHOJNACKI="CH AH Y N AA T S K IY",COGLIANESE="K OW G L IY AH N EY Z IY",BORDEN="B AO R D AH N",BERLUSCONI="B ER L AH S K OW N IY",COOPERSTOWN="K UW P ER Z T AW N",GORDEN="G AO R D AH N",CHILCOAT="CH IH L K OW T",PUREBREDS="P Y UH R B R EH D Z",LORDEN="L AO R D AH N",MORDEN="M AO R D AH N",NORDEN="N AO R D AH N",SORDONI="S AO R D OW N IY",MANSOUR="M AE N S ER",BONILLA="B AH N IH L AH",KANKAKEE="K AE NG K IH K IY",SYPHILIS="S IH F AH L IH S",FLAGELLUM="F L AH JH EH L AH M",["PREVAILS(2)"]="P R IY V EY L Z",WHITEY="W AY T IY",RISDEN="R IH S D AH N",SHINGLETON="SH IH NG G AH L T AH N",BILLIG="B IH L IH G",NELLCOR="N EH L K AO R",GILLIG="G IH L IH G",SIELSKI="S IY L S K IY",["INEQUALITY(3)"]="IH N IY K W AA L AH T IY",BRAZIL="B R AH Z IH L",BIELSKI="B IY L S K IY",["ENCRYPTED(2)"]="IH N K R IH P T IH D",WILLIG="W IH L IH G",SILENT="S AY L AH N T",HSIEH="SH IY EH",DOERFLER="D AO R F AH L ER",CHOSE="CH OW Z",SEEING="S IY IH NG",TEEING="T IY IH NG",SILVERSHOE="S IH L V ER SH UW",INTEROPERATES="IH N T ER AO P ER AH T S",GHOSE="G OW Z",HAZZARD="HH AE Z ER D",THOSE="DH OW Z",POLYCARPIC="P AA L IY K AA R P IH K",["OPHTHALMOLOGISTS(3)"]="AA F TH AH M AA L AH JH IH S T S",["MOMMY'S"]="M AA M IY Z",BOONDOGGLE="B UW N D AA G AH L",METHODOLOGIES="M EH TH OW D AA L AH JH IY Z",LEVASSEUR="L EH V AH S ER",["KOREAN(3)"]="K ER R IY AH N",BEWITCHED="B IH W IH CH T",GARNET="G AA R N AH T",KUZMINSKI="K AH Z M IH N S K IY",BARNET="B AA R N IH T",PUGILIST="P Y UW JH AH L IH S T",VANUAAKU="V AE N W AH AA K UW",GRAMMAR="G R AE M ER",["PLENTIFUL(2)"]="P L EH N T IH F AH L",FICKLING="F IH K L IH NG",SCHEMMEL="SH EH M AH L",HICKLING="HH IH K L IH NG",BATTLEFRONT="B AE T AH L F R AH N T",COPPERHEAD="K AA P ER HH EH D",CUMULATIVELY="K Y UW M Y AH L AH T IH V L IY",RUNKLES="R AH NG K AH L Z",PASLAY="P AE S L EY",MOAMMAR="M OW AH M AA R",["CRANSTON'S"]="K R AE N S T AH N Z",THICKEST="TH IH K IH S T",MAYBIN="M EY B IH N",SCHAUMBERG="SH OW M B ER G",STORAGE="S T AO R AH JH",CONVERSE="K AA N V ER S",MELROY="M EH L R OY",REASSEMBLY="R IY AH S EH M B L IY",MURDEN="M ER D AH N",INCIDENCES="IH N S AH D AH N S IH Z",MANGOES="M AE NG G OW Z",GONCHAROV="G AA N CH ER AA V",PICKLING="P IH K L IH NG",REPUBLIC="R IY P AH B L AH K",PLOYS="P L OY Z",SOUTHWARD="S AW TH W ER D",CONTRACTING="K AA N T R AE K T IH NG",["ELEVENTH(2)"]="IY L EH V AH N TH",HIROMASA="HH IH R OW M AA S AH",INDICTING="IH N D AY T IH NG",MORGENTHALER="M AO R G IH N TH AH L ER",NEWLYN="N UW L IH N",TERRITORIALISM="T EH R AH T AO R IY AH L IH Z AH M",["RECOLLECTED(2)"]="R IY K AH L EH K T IH D",POTEAT="P OW T IY T",FOOLISH="F UW L IH SH",CODERRE="K AH D EH R",DEPRESSURIZE="D IH P R EH SH ER AY Z",LANDLESS="L AE N D L AH S",MUCOSAL="M Y UW K OW S AH L",APPRENTICESHIPS="AH P R EH N T AH S SH IH P S",DISENFRANCHISE="D IH S IH N F R AE N CH AY Z",MEZVINSKY="M EH Z V IH N S K IY",PRIMED="P R AY M D",DUPLICATED="D UW P L IH K EY T IH D",LEANZA="L IY AE N Z AH",["HOTTELET'S"]="HH AA T L EH T S",REVITALIZATION="R IY V AY T AH L AH Z EY SH AH N",SCHWAIGER="SH W AY G ER",SEIPLE="S IY P AH L",["SUBCOMMITTEE'S"]="S AH B K AH M IH T IY Z",PIZZERIAS="P IY T S ER IY AH Z",SUCKLING="S AH K L IH NG",EMERAUDE="EH M ER AW D",PALONIUS="P AH L OW N IY AH S",NAUGLES="N AO G AH L Z",EXHIBITIONISTS="EH K S AH B IH SH AH N IH S T S",QUARTO="K W AO R T OW",SAUNDERSON="S AO N D ER S AH N",SCHWEGEL="SH W EH G AH L",CHAIRED="CH EH R D",DAILIES="D EY L IY Z",MODARRESSI="M OW D AA R EH S IY",IMBEDS="IH M B EH D Z",HOOGLAND="HH UW G L AH N D",ANSTEAD="AE N S T EH D",BUCKLING="B AH K L IH NG",ROSELLEN="R OW Z AH L AH N",INSTEAD="IH N S T EH D",["GARSTEN'S"]="G AA R S T EH N Z",MIAMI="M AY AE M IY",POPCORN="P AA P K AO R N",CAUGHMAN="K AO M AH N",WINEBRENNER="W IH N IH B R IH N ER",CHRYSLER="K R AY S L ER",LAUGHMAN="L AE F M AH N",DELCASTILLO="D EH L K AA S T IH L OW",GIZZARD="G IH Z ER D",MUAMMAR="M UW AE M ER",BLAMPIED="B L AE M P IY D",BACKDOORS="B AE K D AO R Z",BAUGHMAN="B AO M AH N",SPURGE="S P ER JH",EBONY="EH B AH N IY",CONSCRIPT="K AA N S K R IH P T",["HOME-SCHOOL"]="HH OW M S K UW L",["LABOUR(2)"]="L EY B ER",GETTYS="G EH T IY Z",QUILTY="K W IH L T IY",LOVELAND="L AH V L AH N D",BURPO="B UH R P OW",GUILTY="G IH L T IY",DOMESTIC="D AH M EH S T IH K",ADORNO="AA D AO R N OW",REACTIVITY="R IY AE K T IH V AH T IY",KARWOSKI="K ER V AW S K IY",SPECKLED="S P EH K AH L D",BACIGALUPO="B AA CH IY G AA L UW P OW",WITHDRAW="W IH DH D R AO",ISOELECTRONIC="AY S OW IH L EH K T R AA N IH K",CACKLING="K AE K AH L IH NG",["SACHS(2)"]="S AA K S",ROBUSTLY="R OW B AH S T L IY",["BANDICOOTS(2)"]="B AE N D IY K UW T S",BUOYS="B UW IY Z",POMRENZE="P AA M R AH N Z",BABCOCK="B AE B K AO K",INTEGRA="IH N T EH G R AH",INTERNATIONALIZATION="IH N T ER N AE SH AH N AH L IH Z EY SH AH N",["PEMBROKE(2)"]="P EH M B R UH K",ALDAPE="AA L D AA P EY",PORTABILITY="P AO R T AH B IH L IH T IY",VANILLA="V AH N IH L AH",["DISINTERESTED(2)"]="D IH S IH N R IH S T IH D",TACKLING="T AE K L IH NG",HYUN="HH AY AH N",IMPLICATED="IH M P L IH K EY T IH D",["CHAMPION'S"]="CH AE M P IY AH N Z",REGGAETON="R EH G EY T OW N",BYUN="B Y AH N",DRONET="D R OW N IH T",WEISGERBER="W AY S G ER B ER",COMMERCIALISM="K AH M ER SH AH L IH Z AH M",PHAROAHS="F EY R OW Z",MCMURRY="M AH K M ER IY",HUSTEAD="HH AH S T EH D",FEMIA="F IY M IY AH",["CLAYTON'S"]="K L EY T AH N Z",TROCHMANN="T R AA CH M AE N",MCCANN="M AH K AE N",["ASSOCIATED(2)"]="AH S OW SH IY EY T AH D",MACDONOUGH="M AH K D AA N AH F",SEABED="S IY B EH D",["MONTGOMERY'S"]="M AA N T G AH M R IY Z",SEASTRAND="S IY S T R AE N D",DULCINEA="D AH L S IH N IY AH",COLANTONIO="K OW L AA N T OW N IY OW",FLAMBOYANTLY="F L AE M B OY AH N T L IY",GIBRALTAR="JH IH B R AO L T ER",IDENTIFYING="AY D EH N T AH F AY IH NG",EVEREX="EH V ER AH K S",["RECOUNTED(2)"]="R IY K AW N T IH D",CLIFFS="K L IH F S",["PREVAIL(2)"]="P R IY V EY L",CROWSON="K R AW S AH N",REASSEMBLED="R IY AH S EH M B AH L D",MULTIETHNIC="M AH L T IY EH TH N IH K",TIMBERLINE="T IH M B ER L AY N",LAMIA="L EY M IY AH",CONSONANTAL="K AA N S AH N AA N T AH L",SKIFFS="S K IH F S",PECULIARITY="P IH K Y UW L IY EH R AH T IY",HILLESHEIM="HH IH L IH S HH AY M",MAAHS="M AA Z",DULLEST="D AH L AH S T",REINCORPORATING="R IY IH N K AO R P ER EY T IH NG",["JELINEK(2)"]="JH EH L IH N EH K",SIMPLIFYING="S IH M P L AH F AY IH NG",VOCATIONS="V OW K EY SH AH N Z",FREIHEIT="F R AY HH AY T",METALLGESELLSCHAFT="M EH T AH L G EH S AH L SH AE F T",["MIOTKE(2)"]="M Y AA T K IY",FULLEST="F UH L AH S T",LOCATIONS="L OW K EY SH AH N Z",BOGGESS="B AA G IH S",SNIFFS="S N IH F S",BENELUX="B EH N AH L AH K S",WEATHERS="W EH DH ER Z",GRONEWOLD="G R AA N UW OW L D",["LAFALCE(2)"]="L AH F AA L S",CACIOPPO="K AA CH OW P OW",GATHRIGHT="G AE TH R AY T",HEATHERS="HH EH DH ER Z",FOERTSCH="F AO R CH",MARZAN="M AA R Z AH N",OUTMODED="AW T M OW D AH D",MUNDLOW="M AH N D L OW",LEATHERS="L EH DH ER Z",TARZAN="T AA R Z AE N",MONTEFORTE="M OW N T EH F AO R T IY",FIZZLING="F IH Z AH L IH NG",BUTZBERGER="B AH T S B ER G ER",SHELTERED="SH EH L T ER D",BAGENT="B EY JH AH N T",KARANITSKI="K EH R AH N IH T S K IY",KSIAZEK="K S Y AA Z EH K",SOUTAR="S UW T AA R",DELISLE="D IH L AY L",RECTANGULAR="R EH K T AE NG G Y AH L ER",ALLMENDINGER="AE L M EH N D IH NG ER",BLUEGRASS="B L UW G R AE S",SIZZLING="S IH Z AH L IH NG",LADBROKE="L AE D B R OW K",BENNINK="B EH N IH NG K",HIROSHIMA="HH IH R OW SH IY M AH",["DISASSOCIATED(2)"]="D IH S AH S OW S IY EY T AH D",["PREFERENTIALLY(2)"]="P R EH F ER EH N SH AH L IY",DETONATING="D EH T AH N EY T IH NG",GERMANE="JH ER M EY N",BELISLE="B EH L AY AH L",PROSERV="P R OW S ER V",TRICARICO="T R IY K AA R IY K OW",TOLERATED="T AA L ER EY T AH D",MARGINALIZE="M AA R JH AH N AH L AY Z",PROMOS="P R OW M OW Z",["VLADIVOSTOK(2)"]="V L AE D IH V OW S T AA K",PENSYL="P EH N S IH L",DISTRACTION="D IH S T R AE K SH AH N",INGRAO="IY NG G R AW",HINDERLITER="HH IH N D ER L IY T ER",CREEDS="K R IY D Z",BREEDS="B R IY D Z",RESISTORS="R IH Z IH S T ER Z",PROGRAMMING="P R OW G R AE M IH NG",PHONY="F OW N IY",["ACCOUNTED(2)"]="AH K AW N AH D",REFRACTORS="R AH F R AE K T ER Z",CARRYFORWARD="K EH R IY F AO R W ER D",BUZZARD="B AH Z ER D",ANCHOVY="AE N CH OW V IY",["M-CODES"]="EH M K OW D Z",["SOFIA'S"]="S OW F IY AH Z",DARJEELING="D AA R JH IY L IH NG",EYEING="AY IH NG",["VILLAGES(2)"]="V IH L IH JH IH Z",WHIDDON="W IH D AH N",QUICKEST="K W IH K IH S T",["REPLANTED(2)"]="R IY P L AE N IH D",POLITBURO="P AA L AH T B Y UH R OW",LABORE="L AH B AO R",BORGERDING="B AO R G ER D IH NG",ISLAMABAD="IH S L AE M AH B AE D",["C-CODES"]="S IY K OW D Z",BRIBING="B R AY B IH NG",IMPERCEPTIBLE="IH M P ER S EH P T IH B AH L",REACTIVE="R IY AE K T IH V",WOLFREY="W UH L F R IY",PEONY="P IY AH N IY",LAJEUNESSE="L AH JH AH N EH S",["JESSICA'S"]="JH EH S IH K AH Z",BIOVEST="B AY OW V AH S T",INTERDICTED="IH N T ER D IH K T IH D",LAUDED="L AO D IH D",["GARY'S"]="G EH R IY Z",HASSENFELD="HH AE S AH N F EH L D",ESCAPEE="IH S K EY P IY",ABOLISH="AH B AA L IH SH",["MARY'S"]="M EH R IY Z",MCCROSKEY="M AH K R AA S K IY",["HUALLAGA(2)"]="W AA L AA G AH",CONSPIRATORIAL="K AH N S P IH R AH T AO R IY AH L",KOHLBECK="K OW L B EH K",AGONY="AE G AH N IY",ACCORD="AH K AO R D",["ROCHEFORT(2)"]="R AA SH F ER T",CENTRALITY="S EH N T AE L IH T IY",CRONY="K R OW N IY",ELLIJAY="IY L AY JH EY",JABBED="JH AE B D",BRIDGING="B R IH JH IH NG",DREISBACH="D R AY S B AA K",REFRESHINGLY="R IY F R EH SH IH NG L IY",RYNDERS="R IH N D ER Z",BOULAY="B UW L EY",SMATHERS="S M AE DH ER Z",PERFECTA="P ER F EH K T AH",INTERNATONAL="IH N T ER N AE SH AH N AH L",HOTELIERS="HH OW T EH L Y ER Z",CABANAS="K AH B AE N AH Z",TERRORIZES="T EH R ER AY Z IH Z",MCELWAINE="M AE K AH L W EY N",DAZZLING="D AE Z AH L IH NG",ELITIST="EY L IY T IH S T",SAVIOR="S EY V Y ER",BURRAGE="B ER IH JH",NASCAR="N AE S K AA R",WEINBERG="W AY N B ER G",JUMPSTART="JH AH M P S T AA R T",["CHRIBONIKO'S(2)"]="CH R IH B AH N IY K OW Z",RELEASES="R IH L IY S IH Z",BAOGUANG="B AA AO G W AE NG",DOCILITY="D AA S IH L AH T IY",THROWING="TH R OW IH NG",COCOANUTS="K OW K OW N AH T S",FEINBERG="F AY N B ER G",DISARRAY="D IH S ER EY",ALIRIO="AH L IH R IY OW",IONOSPHERE="AY AA N AO S F IY R",["COMBINABILITY(2)"]="K AH M B IH N AH B IH L AH T IY",ADVANTAGEOUS="AE D V AH N T EY JH AH S",JUNIA="Y UW N IY AH",BOEING="B OW IH NG",DISENFRANCHISED="D IH S IH N F R AE N CH AY Z D",HOEING="HH OW IH NG",MISTAKE="M IH S T EY K",TOEING="T OW IH NG",["ABBE(2)"]="AE B EY",["DRAYTON'S"]="D R EY T AH N Z",AMSDEN="AE M Z D AH N",SUNIA="S UW N IY AH",FLUOROCARBONS="F L UH R OW K AA R B AH N Z",GIRVEN="G ER V AH N",KIRVEN="K ER V AH N",["ADVANTEST(2)"]="AH D V AE N T AH S T",TELETHON="T EH L AH TH AA N",FEUDED="F Y UW D IH D",BERGLAND="B ER G L AE N D",DUBBED="D AH B D",FUNDERS="F AH N D ER Z",ABIGAIL="AE B AH G EY L",GEOFFROY="JH IY AH F R OY",DEREGULATE="D IY R EH G Y AH L EY T",ALOYS="AH L OY Z",["EDUCATION(2)"]="EH JH Y UW K EY SH AH N",HEITMEYER="HH AY T M AY ER",SUBBED="S AH B D",GRINALD="G R IH N AA L D",GONIA="G OW N IY AH",RUBBED="R AH B D",MISREAD="M IH S R IY D",LOONY="L UW N IY",ANSWERING="AE N S ER IH NG",REREGULATE="R IY R EH G Y AH L EY T",MINDLESS="M AY N D L AH S",STENSRUD="S T EH N S R AH D",DONIA="D OW N IY AH",NEGENT="N EH G AH N T",LEGENT="L EH JH AH N T",DENSE="D EH N S",CHARTISTS="CH AA R T IH S T S",HENSE="HH EH N S",TONIA="T OW N IY AH",EXPANDING="IH K S P AE N D IH NG",VIOLINIST="V AY AH L IH N AH S T",SENSE="S EH N S",PENSE="P EH N S",HOWITZERS="HH AW AH T S ER Z",TENSE="T EH N S",POLYPHONIC="P AA L IH F AA N IH K",["SCRAMBLING(2)"]="S K R AE M B L IH NG",SHREDDED="SH R EH D AH D",ARCHITRAVE="AA R K AH T R EY V",MORVEN="M AO R V AH N",["TRADE'S"]="T R EY D Z",DEMELO="D IH M EH L OW",LISBETH="L IH S B IH TH",ARBITRAGE="AA R B IH T R AA ZH",SHELVE="SH EH L V",SLICKEST="S L IH K AH S T",CARPENITO="K AA R P EH N IY T OW",NUPENG="N Y UW P EH NG",BLASSIE="B L AE S IY",CONSTANTINOPLE="K AA N S T AE N T AH N OW P AH L",HIGGERSON="HH IH G ER S AH N",WIKOWSKY="W IH K AW S K IY",INSTITUTIONAL="IH N S T IH T UW SH AH N AH L",BRIEGER="B R IY G ER",KLOCKE="K L AA K",GRIEGER="G R IY G ER",["O'CANAS"]="OW K AE N AH Z",COUNTERPARTY="K AW N T ER P AA R T IY",KRIEGER="K R IY G ER",UNDERSHIRT="AH N D ER SH ER T",LIBBED="L IH B D",LAKEBERG="L EY K B ER G",FADING="F EY D IH NG",WECHSEL="W EH K S AH L",DAHLGREN="D AE L G R IH N",LOCSIN="L AA K S IH N",MEJIA="M EY Y IY AH",DUGOUTS="D AH G AW T S",PALFREY="P AE L F R IY",SHELDAHL="SH EH L D AA L",SCHAVE="SH EY V",WAHLGREN="W AA L G R AH N",DEMANDING="D IH M AE N D IH NG",EPITHELIAL="EH P IH TH EH L Y AH L",PEARCE="P IH R S",TEMPTRESS="T EH M P T R IH S",DINSE="D IH N S",FEODORA="F IY AH D AO R AH",LINSE="L IH N S",WADING="W EY D IH NG",SNOWBERGER="S N OW B ER G ER",VICISSITUDE="V IH S IH S IH T UW D",RINSE="R IH N S",PARAGON="P EH R AH G AA N",["INCORPORATED(2)"]="IH N K AO R P ER EY T IH D",NADING="N EY D IH NG",KADING="K EY D IH NG",LADING="L EY D IH NG",EQUABLE="EH K W AH B AH L",OLIVERAS="OW L IY V EH R AA Z",INAUGURATION="IH N AO G Y ER EY SH AH N",STRAGGLERS="S T R AE G L ER Z",STUBBINS="S T AH B IH N Z",SCARCE="S K EH R S",["APHID(2)"]="EY F AH D",POLITTE="P AH L IH T",MOTIVATIONS="M OW T AH V EY SH AH N Z",NIHEI="N IH HH EY",DEODORANTS="D IY OW D ER AH N T S",SCHENLEY="SH EH N L IY",HEEREN="HH IH R AH N",PATSIES="P AE T S IY Z",ISUZU="IH S UW Z UW",BEARCE="B ER S",["DETROIT'S(2)"]="D IH T R OY T S",JUNEAU="JH UW N OW",BEHAVE="B IH HH EY V",ENCORE="AA N K AO R",PICCHI="P IH K IY",EDITORIALIST="EH D AH T AO R IY AH L IH S T",LAROSIERE="L AA R OW S Y EH R",DELFAVERO="D EH L F AA V EH R OW",FIGAROA="F IH G ER OW AH",ADJUDGED="AH JH AH JH D",["BURNHAM(2)"]="B ER N HH AE M",["DIRECTORY(2)"]="D AY R EH K T ER IY",MANCUSO="M AE NG K Y UW S OW",DECORATIONS="D EH K ER EY SH AH N Z",SHACKLEFORD="SH AE K AH L F ER D",["TUBE(2)"]="T Y UW B",BLEEDS="B L IY D Z",OUTGUESS="AW T G EH S",COATTAIL="K OW T T EY L",SOLLISH="S AA L IH SH",OTTUM="AA T AH M",CENTRE="S EH N T ER",["RHODE-ISLAND"]="R OW D AY L AH N D",["ENVIRONMENTALISTS(2)"]="EH N V AY R AH N M EH N AH L IH S T S",DISABLE="D IH S EY B AH L",["MICROSYSTEMS'"]="M AY K R OW S IH S T AH M Z",["CHARITY'S"]="CH EH R AH T IY Z",INSTABILITY="IH N S T AH B IH L IH T IY",["RESUMING(2)"]="R IY Z UW M IH NG",FLAMINIAN="F L AH M IH N IY AH N",CONFLAGRATION="K AA N F L AH G R EY SH AH N",HUMANIZING="HH Y UW M AH N AY Z IH NG",OSHIELDS="OW SH IY L D Z",SCALPED="S K AE L P T",WILDCATTERS="W AY L D K AE T ER Z",SALEMME="S AE L IH M",WHISKERS="W IH S K ER Z",KORNBLUM="K AO R N B L AH M",BEGETTING="B IH G EH T IH NG",INACCURATE="IH N AE K Y ER AH T",STONY="S T OW N IY",STATUTE="S T AE CH UW T",RADLIFF="R AE D L IH F",BULLISH="B UH L IH SH",HUGHES="HH Y UW Z",BARNABAS="B AA R N AH B AH S",SALEH="S AA L EH HH",BLUMENSCHEIN="B L AH M IH N SH AY N",VOLUMES="V AA L Y UW M Z",SOHO="S OW HH OW",OUGHTA="AO T AH",HOBDAY="HH AA B D EY",HISAW="HH AY S AO",ROADMASTER="R OW D M AE S T ER",COCCHI="K OW K IY",NICKOLSON="N IH K OW L S AH N",AMCORE="AE M K AO R",ECLIPSING="IH K L IH P S IH NG",PAULOS="P AW L OW Z",OBSTETRICAL="AH B S T EH T R IH K AH L",ONECOMM="W AH N K AA M",DOMENICONI="D OW M EH N IH K OW N IY",TATUM="T EY T AH M",ROCCHI="R OW K IY",["ASTRONAUT'S"]="AE S T R AH N AA T S",SPEEDS="S P IY D Z",DEBORD="D IH B AO R D",NANNY="N AE N IY",PANNY="P AE N IY",GASIOR="G AE S IY ER",FANNY="F AE N IY",HANNY="HH AE N IY",METROMAIL="M EH T R OW M EY L",MANNY="M AE N IY",LANNY="L AE N IY",DISTILLERY="D IH S T IH L ER IY",HILDEGARDES="HH IH L D AH G AA R D Z",WILDCAT="W AY L D K AE T",KRUMWIEDE="K R AH M W IY D",["LIEBERMAN'S"]="L IY B ER M AH N Z",NORTHEASTERNERS="N AO R TH IY S T ER N ER Z",GEOMETRIC="JH IY AH M EH T R IH K",ISOXICAM="IH S AA K S IH K AH M",COHO="K OW HH OW",MISSIMER="M IH S IH M ER",POLLUTES="P AH L UW T S",HOHO="HH OW HH OW",FALLISH="F AA L IH SH",FORENSIC="F ER EH N S IH K",CANNY="K AE N IY",METHODISMS="M EH TH AH D IH Z AH M Z",RELENT="R IH L EH N T",CATASTROPHE="K AH T AE S T R AH F IY",IANNIELLO="IY AA N IY EH L OW",["FINANCING(2)"]="F IH N AE N S IH NG",BATTIATO="B AA T IY AA T OW",["CONTRASTS(2)"]="K AH N T R AE S T S",PELFREY="P EH L F R IY",WYCLIFF="W IH K L IH F",["PRESIDENTIAL(2)"]="P R EH Z AH D EH N SH AH L",COMPROMISES="K AA M P R AH M AY Z IH Z",INACTIVE="IH N AE K T IH V",SCAIFE="S K EY F",REDING="R IY D IH NG",STEEDS="S T IY D Z",GREIF="G R IY F",DATUM="D AE T AH M",LUNACY="L UW N AH S IY",GRINBERG="G R IH N B ER G",CLEMENSEN="K L EH M AH N S AH N",["SUSPECTS'"]="S AH S P EH K T S",UNHINGE="AH N HH IH N JH",["STRAUSS'S"]="S T R AW S IH Z",CHIANESE="K IY AA N EY Z IY",GUARANTEEING="G EH R AH N T IY IH NG",INVESTIMENTO="IH N V EH S T IH M EH N T OW",SHADOWENS="SH AE D OW AH N Z",BENHAMOU="B EH N HH AH M UW",MESSIMER="M EH S IH M ER",PICTORIAL="P IH K T AO R IY AH L",ADDING="AE D IH NG",TRIATHLON="T R AY AE TH L AH N",CHARGE="CH AA R JH",WEBBED="W EH B D",STEFFY="S T EH F IY",HINCHCLIFF="HH IH N CH K L IH F",REUNIFY="R IY UW N AH F AY",RECLUSE="R IH K L UW S",HOIUM="HH AA IY AH M",KARPEN="K AA R P AH N",CONSIDERED="K AH N S IH D ER D",NORIMATSU="N AO R IY M AA T S UW",CACCAMISE="K AA K AA M IH S",OUTRIGGERS="AW T R IH G ER Z",SEELIG="S IY L IH G",["DELANO(2)"]="D EH L AH N OW",SILVERPLATE="S IH L V ER P L EY T",DEPOTS="D IY P OW Z",DISMEMBERED="D IH S M EH M B ER D",STIDHAM="S T IH D HH AH M",HOLSEY="HH OW L S IY",HEDDEN="HH EH D AH N",LEDDEN="L EH D AH N",NOKIA="N OW K IY AH",REDDEN="R EH D AH N",["MELISSA'S"]="M AH L IH S AH Z",COPRA="K OW P R AH",MUNDIS="M AH N D IH S",CROSSFIELD="K R AO S F IY L D",HARTWOOD="HH AA R T W UH D",REINDUSTRIALIZE="R IY IH N D AH S T R IY AH L AY Z",SNUFFING="S N AH F IH NG",["BOXES(2)"]="B AA K S IH Z",UNREGULATED="AH N R EH G Y AH L EY T IH D",PILKERTON="P IH L K ER T AH N",["CONCORD(2)"]="K AA N K ER D",MISHEAR="M IH S HH IY R",KNOBEL="N OW B AH L",PFLEGER="F L IY G ER",PANDYA="P AA N D Y AH",VESPERA="V EY S P EH R AH",GASSERT="G AE S ER T",BALBINA="B AA L B IY N AH",HESPERA="HH EY S P EH R AH",HOEVELER="HH OW V L ER",EMPTS="EH M P T S",HELLENIZES="HH EH L AH N AY Z IH Z",DRUMMERS="D R AH M ER Z",["MIXES(2)"]="M IH K S IH Z",HOMELESSNESS="HH OW M L AH S N AH S",TEBELSKIS="T AH B EH L S K IY S",COEUR="K UW R",CADDEN="K AE D AH N",PERFORM="P ER F AO R M",MADDEN="M AE D AH N",MATULIS="M AE T AH L IH S",BOMBSHELLS="B AA M SH EH L Z",DIBIASIO="D IH B IY AA S IY OW",SADDEN="S AE D AH N",PADDEN="P AE D AH N",PIROUETTE="P IH R UW EH",BLUFFING="B L AH F IH NG",ISPRA="IH S P R AH",LIGHTSHIP="L AY T SH IH P",CRYSTALLINE="K R IH S T AH L AY N",LAURIE="L AO R IY",MAURIE="M AO R IY",KASTL="K AE S T AH L",DEDUCTED="D IH D AH K T IH D",["MARKETPLACE'S"]="M AA R K AH T P L EY S IH Z",OPIUM="OW P IY AH M",COUNTERREVOLUTIONARY="K AW N T ER R EH V AH L UW SH AH N EH R IY",KAMPELMAN="K AE M P AH L M AH N",RIGHTEOUSNESS="R AY CH AH S N AH S",CORZINE="K ER Z IY N IY",HULSEY="HH AH L S IY",MAKINEN="M AE K IH N AH N",SUPRA="S UW P R AH",RECONQUERED="R IY K AO NG K ER D",KOLASINSKI="K AH L AH S IH N S K IY",["CONGRESS'(2)"]="K AA NG G R AH S",DEPAUL="D IH P AO L",ELLINGSON="EH L IH NG S AH N",RAMESES="R AE M AH S IY Z",LILYBELL="L IH L IY B EH L",MATRONS="M EY T R AH N Z",DELIBERATED="D IH L IH B ER EY T IH D",GREGERSON="G R EH G ER S AH N",PATRONS="P EY T R AH N Z",["MIZEL(2)"]="M AY Z EH L",["CHARRON(2)"]="K EH R AH N",["PICKENS'S"]="P IH K AH N Z IH Z",CONTROLLER="K AH N T R OW L ER",PINKIE="P IH NG K IY",WAVELENGTHS="W EY V L EH NG TH S",MAGNETIC="M AE G N EH T IH K",RELIGIONIST="R IY L IH JH AH N IH S T",ANTROSCOPE="AE N T R AH S K OW P",MAZYCK="M AE Z IH K",OVERFEED="OW V ER F IY D",SQUIGGLE="S K W IH G AH L",ABOU="AH B UW",["THEORY(2)"]="TH IY ER IY",QUARTERMASTER="K W AO R T ER M AE S T ER",INFINITUM="IH N F IH N IH T AH M",["REFUNDS(2)"]="R IY F AH N D Z",TOBAGO="T AH B EY G OW",SCUFFLES="S K AH F AH L Z",ADDENDUM="AH D EH D AH M",ABDUCTED="AE B D AH K T IH D",["COUGHING(2)"]="K AO F IH NG",POSTDOCTORAL="P OW S T D AA K T ER AH L",GRACIE="G R EY S IY",BERTHELOT="B ER TH AH L AA T",FERDLOW="F EH R D L OW",CONDORS="K AA N D ER Z",ANDREAE="AA N D R EY AA",TRACIE="T R EY S IY",MASTERSTROKE="M AE S T ER S T R OW K",CHATWAL="CH AE T W AO L",GILARDI="JH IY L AA R D IY",SCREWS="S K R UW Z",ALFONSO="AE L F AA N S OW",PABLUM="P AE B L AH M",["PECTIN(2)"]="P EH K T IH N",["DICKENS'S"]="D IH K AH N Z IH Z",GENERALISSIMO="JH EH N EH R AH L IH S IH M OW",GERANIUM="JH ER EY N IY AH M",ARNOLDY="AA R N OW L D IY",FORTRESS="F AO R T R AH S",ANTICLIMACTIC="AE N T IY K L AY M AE K T IH K",AMVESTORS="AE M V EH S T ER Z",SIWEK="S IH W IH K",MICROPHONES="M AY K R OW F OW N Z",MIDSIZE="M IH D S AY Z",WHITBREAD="W IH T B R EH D",MARKETPLACES="M AA R K AH T P L EY S IH Z",PROCASSINI="P R AA K AH S IY N IY",["RETALIATE(2)"]="R IY T AE L IY EY T",HOLIDAYS="HH AA L AH D EY Z",INVESTORS="IH N V EH S T ER Z",DETERGENT="D IH T ER JH AH N T",RAGTOP="R AE G T AO P",["BANGKOK'S"]="B AE NG K AA K S",BIDDEN="B IH D IH N",PEEVED="P IY V D",OBLIGE="AH B L AY JH",DEVENNY="D EH V IH N IY",PROBASCO="P R OW B AA S K OW",UNSKILLED="AH N S K IH L D",SIDDEN="S IH D AH N",RIDDEN="R IH D AH N",JOKINEN="JH AH K IH N AH N",PARTICIPLES="P AA R T IH S IH P AH L Z",ROUTZAHN="R AW T Z AH N",PROBITY="P R OW B AH T IY",FINLAY="F IH N L IY",LAMBDIN="L AE M D IH N",COZYING="K OW Z IY IH NG",RISENHOOVER="R IH S IH N HH UW V ER",TRACTOR="T R AE K T ER",SPIWAK="S P IH V AH K",BRIZZOLARA="B R IY T S OW L AA R AH",LOBBYISTS="L AA B IY IH S T S",WROBEL="R OW B AH L",ORCHESTRAS="AO R K AH S T R AH Z",NATIVISM="N EY T IH V IH Z AH M",ASSUME="AH S UW M",MULLIGANS="M AH L IH G AH N Z",LUCCHESE="L UW K EY Z IY",KLEINHANS="K L AY N HH AH N Z",HOBBYISTS="HH AA B IY IH S T S",EHRENKRANTZ="EH R AH N K R AE N T S",MATHILDA="M AH T IH L D AH",SHITTY="SH IH T IY",REITZFELD="R IY T S F EH L D",WHITTY="W IH T IY",BLACKARD="B L AE K ER D",ACTIVISM="AE K T IH V IH Z AH M",CHITTY="CH IH T IY",GELARDI="JH EH L AA R D IY",VENTILATED="V EH N T AH L EY T IH D",HEVERLY="HH EH V ER L IY",BEVERLY="B EH V ER L IY",["MICHENER'S"]="M IH CH N ER Z",TESTIFIED="T EH S T AH F AY D",SILVERTHORNE="S IH L V ER TH AO R N",RAFFAELLI="R AA F AA EH L IY",GYPSUM="JH IH P S AH M",SHEPLEY="SH EH P L IY",RUTGERS="R AH T G ER Z",MULHEARN="M AH L HH ER N",LOOSER="L UW S ER",["WHEEL(2)"]="HH W IY L",HERMON="HH ER M AH N",GRAVEST="G R AE V AH S T",MASTERBATING="M AE S T ER B EY T IH NG",FORTRESSES="F AO R T R AH S IH Z",AMBULATORY="AE M B Y AH L AH T AO R IY",LAVERGNE="L AH V ER N Y",POMPONS="P AA M P AA N Z",["RUSHDIE'S"]="R AH SH D IY Z",HOOSER="HH UW Z ER",KOOSER="K UW Z ER",["ATLANTIC(2)"]="AH T L AE N IH K",WEDDINGTON="W EH D IH NG T AH N",NOURSE="N AO R S",REDDINGTON="R EH D IH NG T AH N",["MCDADE'S"]="M AH K D EY D Z",SURRENCY="S AO R AH N S IY",MILITARIZE="M IH L AH T ER AY Z",["SWALLOW(2)"]="S W AO L OW",SERMON="S ER M AH N",SEQUESTERED="S IH K W EH S T ER D",["WHITON(2)"]="HH W IH T AH N",CACACE="K AE K AH S",NORTHWOOD="N AO R TH W UH D",NORTHAM="N AO R TH AH M",LEAPHART="L IY P HH AA R T",["CURRY'S"]="K AH R IY Z",JUNKHOLDER="JH AH NG K HH OW L D ER",GRIFFO="G R IH F OW",WORTHAM="W ER TH AH M",PAPALIA="P AA P AA L IY AH",AMARILLO="AE M ER IH L OW",BOURSE="B AO R S",COURSE="K AO R S",MINDFUL="M AY N D F AH L",ADULTERER="AH D AH L T ER ER",FLABBERGAST="F L AE B ER G AE S T",SHOEMATE="SH UW M EY T",KASHUBA="K AH SH UW B AH",WESTBROOKS="W EH S T B R UH K S",SPOGLI="S P AA G L IY",LARIJANI="L EH R IH JH AA N IY",CLOSER="K L OW S ER",AQUARIUS="AH K W EH R IY AH S",ZUMBRUN="Z AH M B R AH N",KIRCHOFF="K ER K HH AO F",MOTORIZE="M OW T ER AY Z",TRADEOFFS="T R EY D AO F S",WARDLOW="W AO R D L OW",BARCELO="B AA R CH EH L OW",MARCELO="M AA R CH EH L OW",BOCCHINO="B OW K IY N OW",NEKIA="N AH K IY AH",FINGERHUT="F IH NG G ER HH AH T",SILMON="S IY L M AO N",SHAQ="SH AE K",CHAUNCEY="CH AO N S IY",KELSEY="K EH L S IY",WADDINGTON="W AA D IH NG T AH N",STAPLING="S T EY P AH L IH NG",ABANDONING="AH B AE N D AH N IH NG",PADDINGTON="P AE D IH NG T AH N",SHATKIN="SH AE T K IH N",VELARDI="V EH L AA R D IY",MAKOWSKY="M AH K AW S K IY",BOSNIAS="B AA Z N IY AH Z",RUPAUL="R UW P AA L",FIXATE="F IH K S EY T",["ARMY'S"]="AA R M IY Z",FACILITY="F AH S IH L IH T IY",TROPICAL="T R AA P IH K AH L",MENU="M EH N Y UW",CIVILIZATIONS="S IH V AH L IH Z EY SH AH N Z",DROSER="D R OW Z ER",GODKIN="G AA D K IH N",STADELMAN="S T AE D AH L M AH N",AIRBOAT="EH R B OW T",MISTRESSES="M IH S T R AH S AH Z",ROARING="R AO R IH NG",TESTIFYING="T EH S T AH F AY IH NG",BORDES="B AO R D Z",CORDES="K AO R D Z",MIGHTIEST="M AY T IY AH S T",IRAQ="IH R AA K",BODKIN="B AA D K IH N",["FAMILIES'"]="F AE M AH L IY Z",PHARAONIC="F EH R AH AA N IH K",KEOGH="K IY OW",["JACK'S"]="JH AE K S",PASSIONATE="P AE SH AH N AH T",STOLAR="S T OW L ER",["HANY'S"]="HH EY N IY Z",DEALY="D IY L IY",KEALY="K IY L IY",MCDOUGALD="M AH K D UW G AH L D",["BANDAGES(2)"]="B AE N D IH JH IH Z",MOCCASIN="M AA K AH S IH N",["PUERTO-RICO(3)"]="P AO R T ER R IY K OW",BOSSERT="B AA S ER T",BALUJA="B AH L UW JH AH",["ALL-OUT"]="AO L AW T",MANHOOD="M AE N HH UH D",NIEDZIELSKI="N IY JH IY L S K IY",KENWORTH="K EH N W ER TH",["MCGEEAN'S"]="M AH G IY AH N Z",EVILSIZER="IY V AH L S AY Z ER",RASORITE="R AE S ER AY T",["OLAH(2)"]="OW L AH",WESTHAMPTON="W EH S T HH AE M P T AH N",HARBAUGH="HH AA R B AO",CARBAUGH="K AA R B AO",MCNEESE="M AH K N IY S",SLATKIN="S L AE T K IH N",SHORKEY="SH AO R K IY",MORNINGSTAR="M AO R N IH NG S T AA R",ENTRUSTING="EH N T R AH S T IH NG",MORRISEY="M AO R IH S IY",HALLANAN="HH AE L AH N AH N",SIGNPOSTS="S AY N P OW S T S",MAHAMUD="M AH HH AA M UH D",DISTRESSES="D IH S T R EH S IH Z",NONCRIMINAL="N AA N K R IH M IH N AH L",WANDIS="W AA N D IH S",["SELF-DECEIVING"]="S EH L F D IY S IY V IH NG",BUGG="B AH G",DISCREET="D IH S K R IY T",["MONTPELIER'S"]="M AA N T P IY L IY ER Z",HUGG="HH AH G",LANDLORD="L AE N D L AO R D",HANDFUL="HH AE N D F UH L",["COUPLE'S"]="K AH P AH L Z",SCRATCH="S K R AE CH",HISTOLOGY="HH IH S T AA L AH JH IY",CLARIMOND="K L AE R IH M AH N D",LANDIS="L AE N D IH S",BIALY="B IY AA L IY",CLINKSCALES="K L IH NG K S K EY L Z",BENEFIELD="B EH N AH F IY L D",GERDES="ZH ER D Z",VERDES="V ER D IY",VIRTUE="V ER CH UW",["COMPUSA'S"]="K AA M P Y UW EH S EY Z",RUGG="R AH G",FINCKE="F IH NG K",DILDAY="D IH L D EY",LUMINOSO="L UW M IH N OW S OW",SUGG="S AH G",GILDAY="G IH L D EY",BERTELSON="B ER T IH L S AH N",CARMON="K AA R M AH N",DARMON="D AA R M AH N",CORALS="K AO R AH L Z",ASHOK="AE SH AA K",GARMON="G AA R M AH N",HARMON="HH AA R M AH N",MORALS="M AO R AH L Z",PLAYHOUSES="P L EY HH AW S IH Z",NEALY="N IY L IY",MEALY="M IY L IY",SEALY="S IY L IY",COALESCED="K OW AH L EH S T",THERIOT="TH IH R IY AA T",BREHMER="B R EH M ER",["ARTIST'S(2)"]="AA R T IH S T S",OVERTOOK="OW V ER T UH K",ALLDAY="AO L D EY",MINSTREL="M IH N S T R AH L",SPARING="S P EH R IH NG",BESSERT="B EH S ER T",DEREGULATED="D IY R EH G Y AH L EY T IH D",DESSERT="D IH Z ER T",GESSERT="G EH S ER T",JARMON="Y AA R M AO N",JUNKIE="JH AH NG K IY",MARMON="M AA R M AH N",MCCLIMANS="M AH K L AY M AH N Z",SATYA="S AA T Y AH",["WHARFF(2)"]="HH W AA R F",UPHOLDING="AH P HH OW L D IH NG",KATYA="K AA T Y AH",UNPLUGGED="AH N P L AH G D",ARRIVALS="ER AY V AH L Z",FORMIDABLE="F AO R M AH D AH B AH L",TRIGO="T R IY G OW",AUDIBLY="AA D AH B L IY",RADBURN="R AE D B ER N",SUCCINCT="S AH K S IH NG K T",STAKED="S T EY K T",FRIGO="F R IY G OW",CHINNICI="K IY N IY CH IY",MATRIMONIAL="M AE T R AH M OW N IY AH L",PATRIMONIAL="P AE T R AH M OW N Y AH L",KUDOS="K UW D OW S",["HARRISBURGH(2)"]="HH EH R IH S B ER G",DEPRIVES="D IH P R AY V Z",FERRENCY="F EH R EH N S IY",ALLEVIATED="AH L IY V IY EY T AH D",CAVEAT="K EY V IY AE T",AMIGO="AH M IY G OW",SODERBLOM="S OW D ER B L AA M",LEARJET="L IH R JH EH T",LUTTWAK="L AH T W AA K",POTASH="P AA T AE SH",ARRIGONI="AA R IY G OW N IY",["OTTAWA'S"]="AA T AH W AH Z",REALIZATION="R IY L AH Z EY SH AH N",["GADHAFI(2)"]="G AH D HH AA F IY",BRUTALIZED="B R UW T AH L AY Z D",PUDWILL="P AH D W IH L",BLACKFORD="B L AE K F ER D",MANGOPE="M AE NG G OW P EY",BIVOUAC="B IH V W AE K",["BARREN(2)"]="B EH R AH N",SOUDERS="S AW D ER Z",PHEASANT="F EH Z AH N T",MCNIFF="M AH K N IH F",KREITZBERG="K R AY T S B ER G",GAISER="G EY Z ER",DIPIERO="D IH P IH R OW",KAISER="K AY Z ER",FIRPO="F IH R P OW",SANGUINE="S AE NG G W IH N",REDBURN="R EH D B ER N",FLAGGED="F L AE G D",["TERRY'S"]="T EH R IY Z",SOMATOGEN="S OW M AE T AH JH EH N",["LOBBYISTS'"]="L AA B IY IH S T S",["PERRY'S"]="P EH R IY Z",GARABEDIAN="G AE R AH B IY D IY AH N",["KERRY'S"]="K EH R IY Z",["JERRY'S"]="JH EH R IY Z",OMNICOM="AA M N IH K AA M",["GERRY'S"]="JH EH R IY Z",STIFFS="S T IH F S",KIKKOMAN="K IY K OW M AA N",["BERRY'S"]="B EH R IY Z",["O'DELI"]="OW D EH L IY",ISABELL="IH S AA B EH L",SHUFFLES="SH AH F AH L Z",VASOTEC="V EY Z OW T EH K",["DEAK'S"]="D IY K S",VEZINA="V EH Z IY N AH",BAIDOA="B AY D OW AH",["TONY'S"]="T OW N IY Z",["ROCK'S"]="R AA K S",ABSURDITY="AH B S ER D AH T IY",WASSINK="W AO S IH NG K",["TEMPERAMENTALLY(2)"]="T EH M P ER M EH N T AH L IY",COMPUTERS="K AH M P Y UW T ER Z",DRAGONS="D R AE G AH N Z",MICELI="M IY CH EH L IY",SNAGGED="S N AE G D",REISSMAN="R AY S M AH N",RUDKIN="R AH D K IH N",PHOTOGRAPHIC="F OW T AH G R AE F IH K",GLASSCOCK="G L AE S K AA K",ZAISER="Z AY S ER",JULIA="JH UW L Y AH",["SHARPENING(2)"]="SH AA R P N IH NG",TWITTY="T W IH T IY",EVENTFUL="IH V EH N T F AH L",MATARAZZO="M AA T AA R AA Z OW",HORDES="HH AO R D Z",COAUTHORED="K OW AA TH ER D",RALESES="R AH L IY S IH Z",JOLIET="JH OW L IY EH T",MIDAFTERNOON="M IH D AE F T ER N UW N",CULLINANE="K AH L IH N EY N",["LINDSEY'S"]="L IH N D Z IY Z",DISCONTENTED="D IH S K AH N T EH N T IH D",BRAINER="B R EY N ER",["SHEPARD'S"]="SH EH P ER D Z",["SHUCHMAN'S"]="SH AH K M AH N Z",ELYRIA="IH L IH R IY AH",["COPELAND'S"]="K OW P L AH N D Z",COGBURN="K AA G B ER N",["VASLOV'S"]="V AE S L AA V Z",HAWKINESS="HH AO K N AH S",ITALY="IH T AH L IY",MARINATED="M EH R AH N EY T IH D",TRAINER="T R EY N ER",["LARRY'S"]="L EH R IY Z",MICROBIOLOGISTS="M AY K R OW B IY AA L AH JH IH S T S",GRIPED="G R AY P T",["LAUGHLIN(2)"]="L AA F L IH N",ABROGATING="AE B R AH G EY T IH NG",AGUILAR="AE G AH L AA R",UNBUILT="AH N B IH L T",JUSTIFYING="JH AH S T AH F AY IH NG",SHIRR="SH ER",["RUTSKOI'S"]="R UW T S K OY Z",CAISSE="K EY S",AGGLUTINATE="AH G L UW T IH N EY T",["WHIZ(2)"]="HH W IH Z",["VETERANS'"]="V EH T ER AH N Z",GEOMETRICALLY="JH IY AH M EH T R IH K L IY",HAIRSTYLE="HH EH R S T AY L",["SENTIMENTALITY(2)"]="S EH N AH M EH N T AE L IH T IY",WAVERLY="W EY V ER L IY",["MUMMY'S"]="M AH M IY Z",YASUNORI="Y AA S UW N AO R IY",["DOCK'S"]="D AA K S",ROEBKE="R OW B K",SNIPED="S N AY P T",["TUSKEGEE(2)"]="T AH S K IY G IY",SECTIONING="S EH K SH AH N IH NG",["ECOLOGISTS(3)"]="IH K AA L AH JH IH S",LULU="L UW L UW",SNOWFLAKE="S N OW F L EY K",VANAUSDALL="V AE N AW S D AH L",FONTANEZ="F OW N T AA N EH Z",ROMAGNOLO="R OW M AA N Y OW L OW",KEOHANE="K IY AH HH EY N",MONTANEZ="M OW N T AA N EH Z",STAVINOHA="S T AE V IH N OW HH AH",PREDICTABLY="P R IH D IH K T AH B L IY",XYLIA="Z AY L IY AH",PALPITATING="P AE L P AH T EY T IH NG",GRITTY="G R IH T IY",ZIEG="Z IY G",PROPRIETARY="P R AH P R AY AH T EH R IY",HARPO="HH AA R P OW",BUBINGA="B AH B IH NG G AH",["LORAL'S"]="L AO R AH L Z",DISSOLVING="D IH Z AO L V IH NG",MEINHOLD="M AY N HH OW L D",GUILLIAMS="G W IY L IY AA M Z",REINHOLD="R AY N HH OW L T",WEISEMAN="W AY S AH M AH N",WEINHOLD="W AY N HH OW L D",SECURITIES="S IH K Y UH R AH T IY Z",STIEHL="S T IY L",["ENABLER(2)"]="EH N EY B L ER",SHREDDERS="SH R EH D ER Z",ESPARZA="EH S P AA R Z AH",MARONITE="M EH R AH N AY T",SMITTY="S M IH T IY",INTERCOLLEGIATE="IH N T ER K AH L IY JH AH T",CIVILIZE="S IH V AH L AY Z",CAVERLY="K EY V ER L IY",MYSTIFYING="M IH S T AH F AY IH NG",NONSTOP="N AA N S T AA P",RIEG="R IY G",SIEG="S IY G",HAVERLY="HH EY V ER L IY",NICOLAUS="N IH K AH L AW Z",["GAZES(2)"]="G EY Z IH Z",ACKNOWLEDGEABLE="AE K N AA L IH JH AH B AH L",KNUTZEN="N AH T Z AH N",SUPERHUMAN="S UW P ER HH Y UW M AH N",TEVYE="T EH V IY",PLAINER="P L EY N ER",GENETICISTS="JH AH N EH T AH S IH S T S",CHAPPELEAR="SH AE P IH L ER",APPROPRIATIONS="AH P R OW P R IY EY SH AH N Z",NEDVED="N EH D V AH D",MEDVED="M EH D V AH D",PREARRANGES="P R IY ER EY N JH AH Z",REWRITTEN="R IY R IH T AH N",BOYCOTTING="B OY K AA T IH NG",NORSWORTHY="N AO R S W ER DH IY",["COMEDY'S"]="K AA M AH D IY Z",NEGATED="N IY G EY T IH D",PEGBOARDS="P EH G B AO R D Z",["EASTLAND(3)"]="IY S L AH N D",ELNOZAHY="EH L N OW Z AA HH IY",["DWINDLING(2)"]="D W IH N D L IH NG",SEISER="S AY S ER",REISER="R AY S ER",PEISER="P AY S ER",MEISER="M AY S ER",LEISER="L AY S ER",KEISER="K AY S ER",SNORTER="S N AO R T ER",HEISER="HH AY S ER",GEISER="G AY S ER",PEAKED="P IY K T",NOBLY="N AA B L IY",PONTIOUS="P OW N SH IH S",DEEG="D IY G",TRIESTE="T R IY S T",ADVO="AE D V OW",HEEG="HH IY G",REEG="R IY G",ZHOU="ZH UW",SHRINKING="SH R IH NG K IH NG",HOUSHOLDER="HH AW SH OW L D ER",SYSTEMICALLY="S AH S T EH M IH K L IY",THOU="DH AW",MISALLOCATION="M IH S AE L AH K EY SH AH N",PEACENIK="P IY S N IH K",SOAKED="S OW K T",PARSONAGE="P AA R S AH N IH JH",EUSTACE="Y UW S T AH S",PLUMMETED="P L AH M AH T IH D",ZEISER="Z AY S ER",["INDIVIDUALLY(2)"]="IH N D IH V IH JH AH L IY",WEISER="W AY S ER",DEGRAFF="D EH G R AH F",PELKEY="P EH L K IY",WRETCHED="R EH CH IH D",LIOU="L IY UW",HOEG="HH OW G",["DUCK'S"]="D AH K S",["CHAVEZ(2)"]="CH AE V EH Z",MURALS="M Y UH R AH L Z",REDWOOD="R EH D W UH D",["PAVAROTTI'S"]="P AE V ER AA T IY Z",TEXFI="T EH K S F IY",STENGLEIN="S T IH NG L AY N",SKETCHED="S K EH CH T",BOROCCE="B AH R OW CH IY",["SLOVAKIA'S(2)"]="S L OW V AE K IY AH Z",["BUCK'S"]="B AH K S",["OPERATORS'"]="AO P ER EY T ER Z",TRAUGHBER="T R AO B ER",["FLAVORISTS(3)"]="F L EY V ER IH S",["STEPHENS'S"]="S T IY V IH N Z IH Z",RADICH="R AE D IH K",CICERO="S IH S ER OW",IGOU="IH G UW",["BANYAS(2)"]="B AE N Y AH Z",["ADMITTING(2)"]="AH D M IH T IH NG",HERGOTT="HH ER G AH T",OKLAHOMA="OW K L AH HH OW M AH",GAVIRIA="G AH V IH R IY AH",BALKANIZATION="B AO L K AH N IH Z EY SH AH N",PRINDL="P R IH N D AH L",EXPROPRIATIONS="EH K S P R OW P R IY EY SH AH N Z",COMMISSIONS="K AH M IH SH AH N Z",PAULINO="P AO L IY N OW",ROANOKE="R OW AH N OW K",PUGLISI="P UW G L IY S IY",KROGH="K R OW",DEVALUED="D IH V AE L Y UW D",AESOP="IY S AA P",POLICEWOMAN="P AH L IY S W UH M AH N",ORINOCO="AO R AH N OW K OW",BERGSTROM="B ER G S T R AA M",REVALUED="R IY V AE L Y UW D",RADOS="R AA D OW Z",["O'GRADY'S"]="OW G R EY D IY Z",PERENNIAL="P ER EH N IY AH L",DODOS="D OW D OW Z",["INTEGRATOR(2)"]="IH N AH G R EY T ER",SAUDIA="S AO D IY AH",["ROMANIA'S"]="R OW M EY N IY AH Z",FOREIGNER="F AO R AH N ER",RODALE="R OW D EY L",CARDOZO="K AA R D OW Z OW",STICKEL="S T IH K AH L",EXCEPTIONAL="IH K S EH P SH AH N AH L",MEDTRONIC="M EH D T R AA N IH K",TRAGICOMIC="T R AE JH IH K AA M IH K",COMMENSURATE="K AH M EH N S ER AH T",CACHING="K AE SH IH NG",["CUNNINGHAM'S"]="K AH N IH NG HH AE M Z",CAUSALITY="K AO Z AA L IH T IY",["HOUGHTON'S(2)"]="HH AW T AH N Z",GILBERTINA="JH IY L B ER T IY N AH",BOTTOMED="B AA T AH M D",CERTIFYING="S ER T AH F AY IH NG",SULLIVANT="S AH L IH V AH N T",SCULPTURAL="S K AH L P CH ER AH L",BADMINTONS="B AE D M IH N T AH N Z",EICHENBERGER="AY K AH N B ER G ER",HEADMASTER="HH EH D M AE S T ER",ASSETS="AE S EH T S",HOSTETLER="HH AA S T IH T AH L ER",DEGNAN="D EH G N AH N",MASTERWORKS="M AE S T ER W ER K S",["DIRECTIONLESS(3)"]="D AY R EH K SH IH N L AH S",["CREDIT(2)"]="K R EH D IH T",DICTATORIAL="D IH K T AH T AO R IY AH L",DUFUR="D AH F ER",MISGIVINGS="M IH S G IH V IH NG Z",["HILLARY'S"]="HH IH L ER IY Z",RABAGO="R AA B AA G OW",HAMMERSTROM="HH AE M ER S T R AH M",PROHIBITED="P R OW HH IH B AH T AH D",NUMEROLOGY="N UW M ER AA L AH JH IY",MONTOYA="M AA N T OY AH",["BUKAVU'S"]="B UW K AA V UW Z",ORIENT="AO R IY EH N T",CHADICK="CH AE D IH K",NEWSSTAND="N UW Z S T AE N D",FLAGOFFICER="F L AE G AO F AH S ER",["SCHADLER(2)"]="SH EY D L ER",CADILLAC="K AE D AH L AE K",STUFFING="S T AH F IH NG",WIEBKE="W IY B K IY",BURKARD="B ER K ER D",["REPORT'S(2)"]="R IH P AO R T S",WHISENANT="W IH S IH N AH N T",SAVO="S AA V OW",["NATIONALISTIC(2)"]="N AE SH N AH L IH S T IH K",PAVO="P AA V OW",PFAHLER="F AA L ER",OFFICES="AO F AH S AH Z",PROTECTORATE="P R AH T EH K T ER AH T",BEHOLDING="B IH HH OW L D IH NG",PANSIES="P AE N Z IY Z",LOCATES="L OW K EY T S",OUTDATED="AW T D EY T IH D",TRICKEL="T R IH K AH L",ODWALLA="AA D W AA L AH",CONTINUOUSLY="K AH N T IH N Y UW AH S L IY",GILKEY="G IH L K IY",UNDULATES="AH N JH AH L EY T S",DIGNAN="D IH G N AH N",["WHITEBREAD(2)"]="HH W AY T B R EH D",SERAGUT="S EH R AH G AH T",INTERCESSION="IH N T ER S EH SH AH N",AQUILAR="AA K W IY L AA R",BRAKED="B R EY K T",UNSEAT="AH N S IY T",SECONDARIES="S EH K AH N D EH R IY Z",MOSQUITOS="M AH S K IY T OW Z",POLYSACCHARIDE="P AA L IY S AE K ER AY D",THORVALD="TH AO R V AA L D",BRICKEL="B R IH K AH L",SILKEY="S IH L K IY",BAHIA="B AA HH IY AH",VULGARIZATION="V AH L G ER IH Z EY SH AH N",WILKEY="W IH L K IY",MCGAVIN="M AH G AE V AH N",LENNARTZ="L EH N AA R T S",TAPPEN="T AE P AH N",LEANEST="L IY N AH S T",MEANEST="M IY N AH S T",EXPLICITLY="IH K S P L IH S AH T L IY",["FOLKS'"]="F OW K S",WAGG="W AE G",UNDERSIDE="AH N D ER S AY D",AZCUENAGA="AE Z K W EY N AA G AH",BAGG="B AE G",PIZZAZZ="P IH Z AE Z",DAGG="D AE G",FAGG="F AE G",HAGG="HH AE G",REDPOLL="R EH D P OW L",["PRIVILEGED(4)"]="P R IH V IH L IH JH D",VALIQUETTE="V AE L IH K EH T",["PREVENT(2)"]="P R IY V EH N T",SIMMONDS="S IH M AH N D Z",PREEMPTIVE="P R IY EH M P T IH V",GOODLOW="G UH D L OW",MULKEY="M AH L K IY",BERGENDAHL="B ER G EH N D AA L",EGBERTINA="EH G B ER T IY N AH",SHUBIN="SH UW B IH N",AMBASSADRESS="AE M B AE S AH D R AH S",WIMBISH="W IH M B IH SH",GRAVITATION="G R AE V IH T EY SH AH N",OARLOCK="AO R L AA K",NARLOCK="N AA R L AH K",DAUBED="D AO B D",NIEDZWIECKI="N IY JH V IY T S K IY",SOMALIAS="S AH M AA L IY AH Z",SQUELCHED="S K W EH L CH T",WALKIE="W AO K IY",ETHNICITY="EH TH N IH S IH T IY",TALKIE="T AO K IY",LUPONE="L UW P OW N",["GRAMM'S"]="G R AE M Z",MARSHLANDS="M AA R SH L AE N D Z",ASTORGA="AA S T AO R G AH",EAPPEN="IY P AH N",PARALLEL="P EH R AH L EH L",HAPPEN="HH AE P AH N",["QUAYE(2)"]="K W EY",ASYMPTOTE="AE S AH M T OW T",LAPPEN="L AE P AH N",CHELETTE="SH IH L EH T",RIBONUCLEIC="R AY B OW N UW K L EY IH K",DISBANDED="D IH S B AE N D IH D",MCCRUM="M AH K R AH M",DELMONTE="D EH L M AA N T IY",WAINOCO="W EY N OW K OW",APARICIO="AE P ER IH S IY OW",THERMOPATCH="TH ER M OW P AE CH",["MOUNT-EVEREST"]="M AW N T EH V ER EH S T",INCUR="IH N K ER",PIEROTTI="P IH R OW T IY",TAROTS="T AE R OW Z",["INGENUE(4)"]="IH N JH AH N UW",VOYAGERS="V OY IH JH ER Z",ADAPTER="AH D AE P T ER",KRAUTER="K R AW T ER",BIERCE="B IH R S",FURNITURE="F ER N IH CH ER",CORNELIO="K ER N EH L IY OW",METROMEDIA="M EH T R OW M IY D IY AH",MCKINNIE="M AH K IH N IY",HONGWEI="HH AO NG W EY",FIERCE="F IH R S",NEWBRIDGE="N UW B R IH JH",SIBYLL="S IH B IH L",["FIREARMS(2)"]="F AY R AA R M Z",["ANYTHING'S"]="EH N IY TH IH NG Z",DISPARITIES="D IH S P EH R AH T IY Z",HYSTERIA="HH IH S T EH R IY AH",WRUBEL="R UW B AH L",["BUD-TEST"]="B AH D T EH S T",DEIDRE="D IY D R AH",DIRECTORY="D ER EH K T ER IY",MICALE="M IY K AA L IY",UNGODLY="AH N G AO D L IY",["LOOSESTRIFES(2)"]="L UW S T R AY F S",GOLDWASSER="G OW L D W AO S ER",CONJUNCTIONS="K AH N JH AH NG K SH AH N Z",TRIBBEY="T R IH B IY",FUSILLADE="F Y UW S IH L EY D",KARSTENS="K AA R S T AH N Z",OROGRAPHIC="AO R AH G R AE F IH K",SHEEPISH="SH IY P IH SH",CARSTENS="K AA R S T AH N Z",CHAUDHRY="CH AO D R IY",GRIESSER="G R IY S ER",DEPPEN="D EH P AH N",BATEMAN="B EY T M AH N",GOODYEAR="G UH D Y IH R",THROTTLING="TH R AA T AH L IH NG",SERVICING="S ER V IH S IH NG",BRONC="B R AA NG K",GENEROUSLY="JH EH N ER AH S L IY",STEPSON="S T EH P S AH N",OVERDRAFTS="OW V ER D R AE F T S",UPDATED="AH P D EY T AH D",STRAUGHN="S T R AO N",["MISREAD(2)"]="M IH S R EH D",["DATELINE'S"]="D EY T L AY N Z",CENTIMETRES="S EH N T AH M IY T ER Z",SHESHUNOFF="SH EH SH UW N AO F",SPIRITS="S P IH R IH T S",MULTIMARKET="M AH L T IY M AA R K IH T",CHADRON="CH AE D R AH N",["REVOLTED(2)"]="R IY V OW L T AH D",GERLOCK="G ER L AH K",WACHSMAN="W AO K S M AH N",HIGHBERGER="HH AY B ER G ER",PEROTS="P ER OW Z",PAVEMENTS="P EY V M AH N T S",REPENT="R IH P EH N T",MOVIEMAKER="M UW V IY M EY K ER",NACHTIGAL="N AE CH T IH G AH L",MCCUR="M AH K ER",OCCUR="AH K ER",CLAUDIE="K L AO D IY",SEIVERT="S AY V ER T",CAPTURING="K AE P CH ER IH NG",ROSLYN="R AA Z L IH N",GRECCO="G R EH K OW",PSEUDOSCIENTIFIC="S UW D OW S AY AH N T IH F IH K",RELATIONSHIPS="R IY L EY SH AH N SH IH P S",["RESIDING(2)"]="R IY Z AY D IH NG",MARGOLIS="M AA R G OW L IH S",["KRAJINA'S(2)"]="K R AY IY N AH Z",KETCHIKAN="K EH CH IH K AH N",LONGVIEW="L AO NG V Y UW",WEISSE="W AY S",REJECTIONS="R IH JH EH K SH AH N Z",EVANGELISTS="IH V AE N JH AH L IH S T S",BOOKLET="B UH K L IH T",MAHLUM="M AA L AH M",AMENITIES="AH M EH N AH T IY Z",ZACCAGNINI="Z AA K AH G N IY N IY",ENGENDER="EH N JH EH N D ER",["MOBILIZATION(2)"]="M OW B AH L IH Z EY SH AH N",TITANIUM="T AY T EY N IY AH M",RECUR="R IH K ER",THRUWAY="TH R UW W EY",["SURREALISM'S(2)"]="S ER IY AH L IH Z AH M Z",["ORIENTAL(2)"]="AO R IY EH N AH L",["LIVES(2)"]="L AY V Z",["GROUNDS(2)"]="G R AW N Z",BUREAUCRACY="B Y UH R AA K R AH S IY",ONCALE="OW N K AA L IY",["DOLES'S"]="D OW L Z IH Z",STEFFEN="S T EH F AH N",THUMM="TH AH M",COAUTHOR="K OW AA TH ER",MARTOCCI="M AA R T OW CH IY",UNAPPROVED="AH N AH P R UW V D",BOSTONIAN="B AO S T OW N IY AH N",["WINSLET'S"]="W IH N S L IH T S",MADERO="M AA D EH R OW",KALOK="K AE L AA K",NAHUM="N AE HH AH M",FONTANELLA="F AA N T AH N EH L AH",CONSEQUENTLY="K AA N S AH K W AH N T L IY",MISTAKENLY="M IH S T EY K AH N L IY",BOLSHEVIKS="B OW L SH AH V IH K S",HAMMONDS="HH AE M AH N D Z",BUCHLER="B AH K AH L ER",RELEVANCY="R EH L AH V AH N S IY",BIDWILL="B IH D W IH L",BILDERBACK="B AY L D ER B AE K",KUCHLER="K AH K AH L ER",AVALANCHES="AE V AH L AE N CH IH Z",["RITUALISTICALLY(2)"]="R IH CH UW AH L IH S T IH K L IY",SEDATED="S IH D EY T IH D",CELESTINE="CH EH L EH S T IY N IY",COERCE="K OW ER S",GUALDONI="G AA L D OW N IY",["SERRANO(2)"]="S ER AE N OW",LUSTROUS="L AH S T R AH S",["SEXES(2)"]="S EH K S IH Z",SIEBERS="S IY B ER Z",SUCRALOSE="S UW K R AH L OW S",TENETS="T EH N AH T S",SACRAMENTO="S AE K R AH M EH N T OW",["INMATE'S"]="IH N M EY T S",WEYFORTH="W EY F AO R TH",LAUREL="L AO R AH L",CATWOMAN="K AE T W UH M AH N",MOLDABLE="M OW L D AH B AH L",WARHOL="W AO R HH AO L",GREENSPON="G R IY N S P AA N",NEWVECTOR="N UW V EH K T ER",CLOBBERED="K L AA B ER D",KIMPO="K IH M P OW",ANCRUM="AH N K R AH M",BERENDS="B EH R EH N D Z",PLAIA="P L AA Y AH",LANGSFORD="L AE NG Z F ER D",CIRCULARLY="S ER K Y AH L ER L IY",DEADLOCK="D EH D L AA K",COLVERT="K AA L V ER T",SYSTEMONE="S IH S T AH M OW N",HUSEMAN="HH UW S M AH N",PURYEAR="P ER Y IH R",MONROY="M AA N R OY",LUDWIGSHAFEN="L AH D W IH G SH AH F AH N",STANBURY="S T AE N B EH R IY",BRUTALIZATION="B R UW T AH L AH Z EY SH AH N",MCCAMEY="M AH K AE M IY",DOBKIN="D AA B K IH N",NEUENDORF="N UW AH N D AO R F",CONROY="K AO N R OY",BUSBIN="B AH S B IH N",STEFANICK="S T EH F AH N IH K",INDICATION="IH N D AH K EY SH AH N",LENGTHWAYS="L EH NG TH W EY Z",BURNINGHAM="B ER N IH NG HH AE M",IMMU="IH M Y UW",SHIZUKA="SH IH Z UW K AH",["GOHLKE(2)"]="G OW K",DIGITALLY="D IH JH AH T AH L IY",MORLOCK="M AO R L AH K",DINUNZIO="D IH N AH N Z IY OW",ELLINGWOOD="EH L IH NG W UH D",["SACHS'S"]="S AE K S IH Z",DEVITT="D IH V IH T",MINNIFIELD="M IH N AH F IY L D",KATHALENE="K AE TH AH L IY N",HIGHLIGHTED="HH AY L AY T IH D",RAFTERY="R AE F T ER IY",TUNAFISH="T UW N AH F IH SH",SIPHONING="S AY F AH N IH NG",CHROMATOGRAMS="K R OW M AE T AH G R AE M Z",GREENPEACE="G R IY N P IY S",AUDIT="AO D IH T",GRANDILOQUENT="G R AE N D IH L AH K W AH N T",["EVOLVE(2)"]="IY V AA L V",MODESTLY="M AA D AH S T L IY",["PARKS'"]="P AA R K S",JERGENSON="JH ER G IH N S AH N",MOTTL="M AA T AH L",MONARCHIES="M AA N AA R K IY Z",["PAOLI(2)"]="P EY OW L IY",NEVITT="N EH V IH T",BOGDEN="B AA G D AH N",IMPLICITLY="IH M P L IH S AH T L IY",SIRMON="S ER M AH N",TEARFUL="T IH R F AH L",["INTERVENING(2)"]="IH N ER V IY N IH NG",["CHANDRIKA(2)"]="SH AA N D R IY K AH",CAMEJO="K AA M EY Y OW",THOMPSEN="T AA M P S AH N",CONCLUDES="K AH N K L UW D Z",SCHMIEDER="SH M AY D ER",CANCEROUS="K AE N S ER AH S",BULLOCKS="B UH L AH K S",["REEVES'"]="R IY V Z",["RITENOUR'S"]="R IH T AH N AW R Z",OMNICARE="AA M N IH K EH R",UNDEREMPLOYED="AH N D ER IH M P L OY D",["OPENNESS(2)"]="OW P AH N AH S",CONTROLLERS="K AH N T R OW L ER Z",UNSURPASSED="AH N S ER P AE S T",HARKLESS="HH AA R K L AH S",SCHLOTTER="SH L AA T ER",AMALGAMATING="AH M AE L G AH M EY T IH NG",["INTERNATIONALLY(4)"]="IH N ER N AE SH N AH L IY",VARIANT="V EH R IY AH N T",JORGENSON="JH AO R G IH N S AH N",["JAMAL'S"]="JH AH M AA L Z",DWARFING="D W AO R F IH NG",["FRENCH-POLYNESIA"]="F R EH N CH P AA L IH N IY ZH AH",MICROS="M AY K R OW Z",CAVITT="K AE V IH T",DAVITT="D AH V IH T",GAVITT="G AE V IH T",CAMPO="K AE M P OW",MIXOLOGY="M IH K S AO L AH G IY",ABDICATION="AE B D IH K EY SH AH N",DIVERSIFIED="D AY V ER S AH F AY D",RADIOACTIVE="R EY D IY OW AE K T IH V",CAROLINAS="K EH R AH L AY N AH Z",CHAPTER="CH AE P T ER",["ANTILOCK(2)"]="AE N T AY L AA K",JOHNSONS="JH AA N S AH N Z",SHIRIN="SH IH R AH N",KERATIN="K EH R AH T AH N",STUMM="S T AH M",SAVITT="S AH V IH T",HURLOCK="HH ER L AH K",["OUTLASTS(2)"]="AW T L AE S",METABOLIZE="M AH T AE B AH L AY Z",SNUFFS="S N AH F S",SELECTIVELY="S AH L EH K T IH V L IY",LAMPO="L AE M P OW",FRENETIC="F R AH N EH T IH K",HOUGHAM="HH AW AH M",KINGSFORD="K IH NG S F ER D",BRAGGED="B R AE G D",SUISSE="S W IH S",DRAGGED="D R AE G D",LYNXES="L IH NG K S IH Z",DEDICATION="D EH D AH K EY SH AH N",ACKNOWLEDGED="AE K N AA L IH JH D",STAUTER="S T AW T ER",["NAISBITT(2)"]="N EY Z B IH T",["AVENTURA(2)"]="AE V AH N CH UH R AH",MEDICATION="M EH D AH K EY SH AH N",["KAPLAIN'S"]="K AE P L AH N Z",FARMYARD="F AA R M Y AA R D",["PREDICTING(2)"]="P R IY D IH K T IH NG",YUPPIFIED="Y AH P IH F AY D",CULVERT="K AH L V ER T",BOSEMAN="B OW S M AH N",BENDECTIN="B EH N D EH K T IH N",SCOTTY="S K AA T IY",PROCESSES="P R AA S EH S AH Z",CRISSMAN="K R IH S M AH N",CZEKAJEWSKI="CH EH K AH Y EH W S K IY",["REFORMS(2)"]="R IH F AO R M Z",ROSEMAN="R OW Z M AH N",FALGOUT="F AE L G AW T",MOSEMAN="M OW S M AH N",ACCIDENTLY="AE K S AH D AH N T L IY",CLAYBORNE="K L EY B ER N",CARLOCK="K AA R L AA K",GARLOCK="G AA R L AH K",["SYSTEMHOUSE'S"]="S IH S T AH M HH AW S IH Z",["PRAVDA'S"]="P R AE V D AH Z",SPOTTY="S P AA T IY",SOWATA="S OW AA T AH",["MARSISA'S"]="M AA R S IH S AH Z",["NOVICK(2)"]="N AA V IH K",WALWORTH="W AO L W ER TH",["CONTROLS'"]="K AA N T R AA L Z",CAUSEY="K AO Z IY",FAUSEY="F AO S IY",["VOGELSTEIN(2)"]="V OW G AH L S T AY N",TRICKLED="T R IH K AH L D",ALSOP="AE L S AA P",OBRIANT="OW B R AY AH N T",ESKIMOS="EH S K AH M OW Z",STRAUSS="S T R AW S",DALLARA="D AE L AA R AH",ASHBURN="AE SH B ER N",LACASSE="L AA K AA S IY",OVEREXTEND="OW V ER IH K S T EH N D",["RALES'S"]="R EY L Z IH Z",KERBEL="K ER B AH L",PERSONIFYING="P ER S AA N AH F AY IH NG",GURRIA="G ER IY AH",GYPSIES="JH IH P S IY Z",PESCATORE="P EH S K AA T AO R IY",SLOVAK="S L OW V AE K",GROUNDLESS="G R AW N D L AH S",VANDERPOOL="V AE N D ER P UW L",["SUSPECT'S"]="S AH S P EH K T S",REPLACEABLE="R IY P L EY S AH B AH L",FURBISH="F ER B IH SH",SCHORN="SH AO R N",GRANLUND="G R AE N L AH N D",MANIGAULT="M AE N IH G AO L T",OSTENDORF="AA S T AH N D AO R F",SHRUG="SH R AH G",HUMANISTS="HH Y UW M AH N IH S T S",COMPORT="K AH M P AO R T",["DICK'S"]="D IH K S",ROSSELL="R AA S AH L",CHEVALIER="SH EH V AH L IH R",VOISEY="V W AA S EY",PITYING="P IH T IY IH NG",["NICK'S"]="N IH K S",["WHITENEIR(2)"]="HH W AY T N IH R",["SOPHISTICATED(2)"]="S AH F IH S T IH K EY T AH D",["PELEKUNU'S"]="P EH L AH K UW N UW Z",PLEASANT="P L EH Z AH N T",ORGANIST="AO R G AH N AH S T",["RICK'S"]="R IH K S",PANCONTINENTAL="P AE N K AA N T AH N EH N T AH L",BANDOW="B AE N D AW",RUPTURING="R AH P CH ER IH NG",FURUTA="F ER UW T AH",TENNANT="T EH N AH N T",["KORRY'S"]="K AO R IY Z",PENNANT="P EH N AH N T",GONOCOCCAL="G AA N AH K AA K AH L",LUCENTE="L UW CH EH N T IY",["D'AGOSTINO"]="D AA G AH S T IY N OW",NOTABLES="N OW T AH B AH L Z",ARORA="AA R AO R AH",ETIOLOGIES="IY T IY AA L AH JH IY Z",INVESTMENT="IH N V EH S T M AH N T",CAMPANELLI="K AA M P AA N EH L IY",ABRIDGES="AH B R IH JH AH Z",FLINCHUM="F L IH N K AH M",NORTHCUTT="N AO R TH K AH T",MINICUCCI="M IY N IY K UW CH IY",SORREL="S AO R AH L",SYNOPSIS="S IH N AA P S IH S",GELASIA="JH EH L AA S IY AH",SOLIDIFIES="S AH L IH D AH F AY Z",KNOTTY="N AA T IY",["DEPOSIT(2)"]="D IH P AA Z AH T",HOHUM="HH OW HH AH M",UNINDICTED="AH N IH N D AY T IH D",LANGLAND="L AE NG L AH N D",ROEDERER="R OW D ER ER",STORA="S T AO R AH",["STEMPLER'S"]="S T EH M P L ER Z",["ECLIPSE(3)"]="IY K L IH P S",KARSHNER="K AA R SH N ER",JEPPSON="JH EH P S AH N",["BECK'S"]="B EH K S",ANTHROPOCENTRIC="AE N TH R AH P AH S EH N T R IH K",KRUMMEL="K R AH M AH L",STEEG="S T IY G",KOHTARO="K OW T AA R OW",BRUMMEL="B R AH M AH L",MCFERRIN="M AH K F EH R AH N",SHOLAR="SH OW L ER",["PECK'S"]="P EH K S",["TECK'S"]="T EH K S",MOHRING="M AO R IH NG",KOHRING="K AO R IH NG",THEOCRATIC="TH IY AH K R AE T IH K",PLACIDLY="P L AE S IH D L IY",CHISENHALL="CH IH S EH N HH AH L",["ASSOCIATES(2)"]="AH S OW S IY EY T S",RIEDERER="R IY D ER ER",LIEUTENANT="L UW T EH N AH N T",REOPEN="R IY OW P AH N",FIREWORK="F AY R W ER K",KOBREN="K AA B R AH N",NIEDERER="N IY D ER ER",BATHSHEBA="B AE TH SH IY B AH",CONDUCTS="K AH N D AH K T S",REINFORCE="R IY IH N F AO R S",MACANDREWS="M AH K AE N D R UW Z",PEDIGREES="P EH D AH G R IY Z",MITHRIDATE="M IH TH R IH D EY T",SCRUBBER="S K R AH B ER",HOSPICE="HH AA S P AH S",UNUSABLE="AH N Y UW Z AH B AH L",TREZISE="T R EH Z AY Z",GEOPHYSICAL="JH IY OW F IH Z AH K AH L",RECUPERATES="R IH K UW P ER EY T S",NEEDLEMAN="N IY D AH L M AH N",NIGG="N IH G",CALVERT="K AE L V ER T",PIGG="P IH G",RIGG="R IH G",SIGG="S IH G",ROGGENBUCK="R AA G IH N B AH K",PSYCHOSIS="S AY K OW S AH S",TUGBOAT="T AH G B OW T",DECEIVE="D IH S IY V",LUNDBLAD="L AH N D B L AH D",["ANESTHESIOLOGISTS(2)"]="AE N AH S TH IY Z IY AA L AH JH AH S",CORTINES="K AO R T IY N Z",IMMOBILITY="IH M OW B IH L IH T IY",BERGSTRESSER="B ER G S T R EH S ER",FAUCHEUX="F OW SH OW",DEPOSIT="D AH P AA Z IH T",LOVITT="L AA V IH T",FIGG="F IH G",JERICHO="JH EH R IH K OW",MISPRICES="M IH S P R AY S IH Z",["SEMIANNUALLY(2)"]="S EH M AY AE N UW AH L IY",PARASYMPATHETIC="P EH R AH S IH M P AH TH EH T IH K",MEGAFOODS="M EH G AH F UW D Z",BODILY="B AA D AH L IY",DUNWORTH="D AH N W ER TH",FEHRING="F EH R IH NG",GEHRING="G EH R IH NG",BEHRING="B EH R IH NG",["MILAN(3)"]="M AY L AE N",["DISMANTLING(2)"]="D IH S M AE N AH L IH NG",ZEHRING="Z EH R IH NG",RUBIA="R UW B IY AH",SUBIA="S UW B IY AH",EGOTISTICAL="IY G AH T IH S T IH K AH L",ILLUSTRATORS="IH L AH S T R EY T ER Z",ZUBIA="Z UW B IY AH",MEHRING="M EH R IH NG",NEHRING="N EH R IH NG",["TRANSCHANNEL'S"]="T R AH N S CH AE N AH L Z",["TEMPERAMENTAL(2)"]="T EH M P ER M EH N T AH L",COTTONWOODS="K AA T AH N W UH D Z",REPURCHASING="R IY P ER CH AH S IH NG",REUSABLE="R IY UW Z AH B AH L",BIOENGINEER="B AY OW EH N JH AH N IH R",["TAXES(2)"]="T AE K S IH Z",LEGG="L EH G",BODDINGTON="B AA D IH NG T AH N",GEGG="JH EH G",HEGG="HH EH G",GERCHAS="G ER CH AH Z",EXEMPTING="IH G Z EH M P T IH NG",BISSONNETTE="B IH S AH N EH T",STRATTON="S T R AE T AH N",PEGG="P EH G",KIRSHNER="K ER SH N ER",COBIA="K OW B IY AH",PERMANENTE="P ER M AH N EH N T EY",NEWSNIGHT="N UW Z N AY T",["ALLY'S"]="AH L AY Z",TOBIA="T OW B IY AH",ROBIA="R OW B IY AH",CONTRAPTION="K AH N T R AE P SH AH N",["IVORY-COAST"]="AY V ER IY K OW S T",TRACZYK="T R AA CH IH K",["LILY'S"]="L IH L IY Z",GILLIHAN="G IH L AH HH AE N",TEMPO="T EH M P OW",BEGG="B EH G",YANDOW="Y AE N D OW",APPROXIMATE="AH P R AA K S AH M AH T",TACIT="T AE S IH T",["SITENSKI'S"]="S IH T EH N S K IY Z",SANDOW="S AE N D OW",HALLGREN="HH AE L G R EH N",["FAMILY'S(2)"]="F AE M L IY Z",ATONEMENT="AH T OW N M AH N T",QUICKSILVER="K W IH K S IH L V ER",TENNECO="T EH N AH K OW",COMPO="K AA M P OW",UNREVISED="AH N R IY V AY Z D",BOOSTERISM="B UW S T ER IH Z AH M",["LEFT-WINGER"]="L EH F T W IH NG ER",["FOCUSSED(2)"]="F OW K IH S T",IMPASSIVELY="IH M P AE S IH V L IY",VANDEVOORT="V AE N D AH V UH R T",CROTTY="K R AA T IY",BUSSERT="B AH S ER T",SURBAUGH="S ER B AO",SUGDEN="S AH G D AH N",KUBISIAK="K AH B IH S IY AE K",["POLY'S"]="P AA L IY Z",DENUDE="D IH N UW D",RUSSERT="R AH S ER T",PAVEK="P AE V IH K",KANIA="K AA N IY AH",MANIA="M EY N IY AH",MITHCELL="M IH TH S AH L",SERBAINE="S ER B EY N",FORTUNATE="F AO R CH AH N AH T",BANIA="B AA N IY AH",PROVEN="P R UW V AH N",BLESSINGTON="B L EH S IH NG T AH N",["WINDMERE'S"]="W IH N D M IH R Z",BARREL="B AE R AH L",CARREL="K AE R AH L",DARREL="D EH R AH L",FARREL="F EH R AH L",SCHUM="SH AH M",FININVEST="F IH N IH N V EH S T",HOOVEN="HH UW V AH N",LUDDEN="L AH D AH N",SUDDEN="S AH D AH N",RUDDEN="R AH D AH N",CHEATED="CH IY T AH D",PROSEK="P R OW S EH K",GIANNINI="JH AH N IY N IY",WROBLEWSKI="R AH B L UW F S K IY",WICKLANDER="W IH K L AE N D ER",GENIUSES="JH IY N Y AH S IH Z",KORBEL="K AO R B AH L",["JULY'S"]="JH UW L AY Z",CORBEL="K AO R B AH L",CHRISTMASTIME="K R IH S T M AH S T AY M",NEARING="N IH R IH NG",TAKASHIMA="T AA K AA SH IY M AH",HEEKIN="HH IY K IH N",PLEIADES="P L IY AH D IY Z",SEARING="S IH R IH NG",TEARING="T EH R IH NG",INJECTIONS="IH N JH EH K SH AH N Z",KORNHAUSER="K AO R N HH AW Z ER",REARING="R IH R IH NG",SNOWBALLING="S N OW B AO L IH NG",FLEUR="F L ER",WEARING="W EH R IH NG",["YEVLINSKY'S"]="Y EH V L IH N S K IY Z",FUSSELL="F AH S AH L",BLAKNEY="B L AE K N IY",BEFORE="B IH F AO R",BUSSELL="B AH S AH L",MATAMOROS="M AA T AA M AO R OW S",NAKASHIMA="N AA K AA SH IY M AH",LISTERIA="L IH S T IH R IY AH",RODDEN="R AA D AH N",TORU="T AO R UW",["MURPHY'S"]="M ER F IY Z",RUSSELL="R AH S AH L",SODDEN="S AA D AH N",MUSSELL="M AH S AH L",BODDEN="B AA D AH N",["WHITEHEAD'S(2)"]="HH W AY T HH EH D Z",GODDEN="G AA D AH N",TANIA="T AA N Y AH",MILONE="M IH L OW N",VANIA="V AA N IY AH",BEARING="B EH R IH NG",MENIA="M IY N Y AH",OBADIAH="OW B AH D AY AH",PEWITT="P Y UW IH T",JEWITT="JH UW IH T",SCARING="S K EH R IH NG",CARPENTIER="K AA R P AH N T IY ER",HEWITT="HH Y UW IH T",LANGHORN="L AE NG HH AO R N",DEWITT="D AH W IH T",FERREL="F EH R EH L",SCHLEYER="SH L EY ER",TIMESHARE="T AY M SH EH R",DOVERSPIKE="D AH V ER S P IH K",LINDBLAD="L IH N D B L AH D",BUNGLERS="B AH NG G L ER Z",COMPUTATIONS="K AA M P Y UW T EY SH AH N Z",SAFEGUARD="S EY F G AA R D",STEPHANIE="S T EH F AH N IY",["MAGLAJ(2)"]="M AE G L AY",DISSOLVERS="D IH Z AA L V ER Z",AUSPICE="AO S P IH S",MITCHELSON="M IH CH AH L S AH N",REINSURER="R IY IH N SH UH R ER",SUNAMERICA="S AH N AH M EH R AH K AH",DINOSAURS="D AY N AH S AO R Z",["QUINTILE(2)"]="K W IH N T AY L",HELLENISTIC="HH EH L AH N IH S T IH K",BELVEDERE="B EH L V AH D IH R",MACROVISION="M AE K R OW V IH ZH AH N",DACRUZ="D AA K R UW Z",CLIBURN="K L AY B ER N",CASSELL="K AE S AH L",HOGG="HH AA G",FOGG="F AA G",GASPERINI="G AA S P ER IY N IY",MOGG="M AA G",HASSELL="HH AE S AH L",PROGNOSIS="P R AA G N OW S AH S",CONSTERNATION="K AA N S T ER N EY SH AH N",PIRACY="P AY R AH S IY",ZOGG="Z AA G",RECEIVE="R AH S IY V",SHARING="SH EH R IH NG",CHEAPO="CH IY P OW",HAIRR="HH EH R",ANIMUS="AE N IH M AH S",RESPECTED="R IH S P EH K T IH D",FUNCTIONAL="F AH NG K SH AH N AH L",NICOSIA="N IH K AH S IY AH",["NOSAIR'S"]="N OW Z EY R Z",WASSELL="W AO S AH L",XENIA="Z IY N IY AH",MELONE="M EH L OW N IY",GONYA="G OW N Y AH",["UNABOMB'S"]="Y UW N AH B AO M Z",["EYETECH'S"]="AY T EH K S",NONSTARTERS="N AA N S T AA R T ER Z",TERRIBLY="T EH R AH B L IY",CHILEANS="CH IH L IY AH N Z",PIPPEN="P IH P AH N",TIPPEN="T IH P AH N",MEGAWATT="M EH G AH W AA T",["BABBAGE'S"]="B AE B IH JH IH Z",PAOLINO="P AA OW L IY N OW",STANDRIDGE="S T AE N D R IH JH",AMSBAUGH="AE M Z B AO",["DIRECTORIES(4)"]="D IH R EH K T ER IY Z",["EVANDRO(2)"]="IY V AE D R OW",["COMPARABLE(2)"]="K AH M P EH R AH B AH L",THETFORD="TH EH T F ER D",JAQUEZ="Y AA K W EH Z",MONEYLESS="M AH N IY L IH S",GRADUALISM="G R AE JH AH W AH L IH Z AH M",["ACKNOWLEDGED(2)"]="IH K N AA L IH JH D",PERSONIFIED="P ER S AA N AH F AY D",TANGENTIAL="T AE N JH EH N CH AH L",MANCINI="M AA N CH IY N IY",MONOPOLIZATION="M AH N AA P AH L IH Z EY SH AH N",PRIMUS="P R AY M AH S",["REICHLING(2)"]="R AY K L IH NG",MENIFEE="M EH N IH F IY",AIRSPACES="EH R S P EY S IH Z",SWIPED="S W AY P T",POLYSACCHARIDES="P AA L IY S AE K ER AY D Z",BALAKUMAR="B AA L AH K UW M AA R",TIERCE="T IY R S",MAIONE="M AY OW N IY",DECESARIS="D IH S EH S ER IH S",OPPENHEIM="AA P IH N HH AY M",UNDERDOGS="AH N D ER D AO G Z",HIPPEN="HH IH P AH N",BLACKMORE="B L AE K M AO R",PIZZOLATO="P IY T S OW L AA T OW",HAMDUN="HH AE M D AH N",BALLANTRAE="B AE L AH N T R EY",BLOXHAM="B L AA K S AH M",["UNOCAL'S(2)"]="Y UW N AH K AO L Z",RECLUSIVE="R IH K L UW S IH V",LUHRING="L UH R IH NG",LAMOTHE="L AE M AH DH",["STINEL'S(2)"]="S T IH N EH L Z",MEYERBEER="M AY ER B IH R",["INTERVENTIONISTS(4)"]="IH N ER V EH N CH AH N IH S",CONNEELY="K AH N IY L IY",LIONIZE="L AY AH N AY Z",BALLCLUB="B AO L K L AH B",ENCHANTER="EH N CH AE N T ER",BLARING="B L EH R IH NG",RINGLAND="R IH NG G L AH N D",COWEDA="K AH W IY D AH",GLARING="G L EH R IH NG",FLARING="F L EH R IH NG",INDUCTED="IH N D AH K T AH D",VERBALIZING="V ER B AH L AY Z IH NG",MUSCOCHO="M AH S K AA CH OW",["ENDEAVOUR'S"]="IH N D EH V ER Z",LIFEGUARD="L AY F G AA R D",SCOTCHED="S K AA CH T",["INTEGRATED(2)"]="IH N T AH G R EY T IH D",GILLOGLY="G IH L AH G L IY",KOPPEN="K AA P AH N",OUTLIERS="AW T L AY ER Z",INCOHERENCE="IH N K OW HH IH R AH N S",MAJOROS="M AA Y AO R OW Z",HORMONAL="HH AO R M OW N AH L",["DIRECTIONS(4)"]="D IH R EH K SH IH N Z",BISSELL="B IH S AH L",CISSELL="S IH S AH L",GLADIS="G L AE D IH S",FISSELL="F IH S AH L",FIREBOMB="F AY ER B AA M",STATUTES="S T AE CH UW T S",ARRAIGNMENTS="ER EY N M AH N T S",SEHORN="S EH HH ER N",INCLUSIVE="IH N K L UW S IH V",SPITBALL="S P IH T B AO L",SEIGNIORAGE="S IY G N IY ER IH JH",["DIRECTIONLESS(2)"]="D IY R EH K SH IH N L AH S",DEBLUM="D AH B L UW M",STREHL="S T R EH L",PREFACED="P R EH F AH S T",BLESSINGS="B L EH S IH NG Z",COLLURA="K AA L UH R AH",OBJECTIONS="AH B JH EH K SH AH N Z",REANALYZES="R IY AE N AH L AY Z AH Z",ROTHMEIER="R AO TH M AY R",KISSELL="K IH S AH L",GLYN="G L IH N",ALTSCHULER="AE L CH Y UW L ER",PLAYFULNESS="P L EY F AH L N AH S",MCCONE="M AH K OW N",STEINBRENNER="S T AY N B R EH N ER",ELYN="EH L IH N",HUNTRESS="HH AH N T R IH S",["MINISERIES(2)"]="M IH N IY S EH R IY Z",CHARIOT="CH EH R IY AH T",BAJEMA="B AA Y EY M AH",INVISIBLE="IH N V IH Z AH B AH L",EMBERS="EH M B ER Z",CLAPP="K L AE P",AMBERS="AE M B ER Z",GUAJARDO="G W AA Y AA R D OW",DOERING="D UW ER IH NG",GOERING="G OW ER IH NG",DIETEL="D IY T AH L",MILLENNIA="M AH L EH N IY AH",["COMMAND'S"]="K AH M AE N D Z",TELACTION="T EH L AE K SH AH N",SOLARZ="S OW L AA R Z",TRAVELER="T R AE V AH L ER",BREIT="B R IY T",FORGIVING="F ER G IH V IH NG",HEATWOLE="HH IY T W OW L",LASEK="L AA S EH K",MASEK="M AA S EH K",MATUSZAK="M AH T AH SH AH K",HASEK="HH AA S EH K",JASEK="Y AA S EH K",PESEK="P EH S EH K",MATTRESSES="M AE T R AH S AH Z",GONIOMETER="G OW N IY AA M AH T ER",NONRESIDENTS="N AA N R EH Z AH D AH N T S",BEGRUDGE="B IH G R AH JH",KRASNOFF="K R AE S N AO F",REMNANT="R EH M N AH N T",["OPTIONS(2)"]="AO P SH AH N Z",["DATSUN'S"]="D AE T S AH N Z",MICHAUX="M IH SH OW",MALVEAUX="M AE L V OW",NUMEIRI="N UW M EY R IY",ILLUMINED="IH L UW M AH N D",["WORKS'"]="W ER K S",LAGROCERIA="L AA G R OW S ER IY AH",["BEATRICE(2)"]="B IY AH T R IH S",INDEMNIFICATION="IH N D EH M N AH F IH K EY SH AH N",ALABAMA="AE L AH B AE M AH",KATHLINE="K AE TH L AY N",SERENDIPITY="S EH R AH N D IH P IH T IY",SHRUBLIKE="SH R AH B L AY K",STRAUBE="S T R AW B",JUSTIFIED="JH AH S T AH F AY D",POPULATED="P AA P Y AH L EY T AH D",SYNTAX="S IH N T AE K S",FIBERS="F AY B ER Z",INTEGRITY="IH N T EH G R AH T IY",STONEHOUSE="S T OW N HH AW S",AVERIL="EY V ER IH L",PLUTONIAN="P L UW T OW N IY AH N",LUSTRE="L AH S T ER",SPEICH="S P AY K",BROCKNER="B R AA K N ER",WASHBURNE="W AO SH B ER N",HEADLESS="HH EH D L AH S",UNSWORTH="AH N S W ER TH",["BAREFIELD(2)"]="B AE R F IY L D",KIMCHE="K IH M CH IY",FEDERICI="F EH D ER IY CH IY",BOSWORTH="B AO Z W ER TH",["SUCCEEDED(2)"]="S AH K S IY D IH D",PARTICIPATIVE="P AA R T IH S AH P AH T IH V",MOBILE="M OW B AH L",REULAND="R OY L AH N D",SNAPP="S N AE P",NOBILE="N AA B AH L",CINTHIE="S IH N TH IY",APPROPRIATES="AH P R OW P R IY EY T S",MOHAMAD="M AH HH AA M AH D",BUTTACAVOLI="B UW T AA K AA V OW L IY",SUSPECTED="S AH S P EH K T AH D",KNAPP="N AE P",FILIPOVIC="F IH L IH P OW V IH K",SOBERS="S OW B ER Z",SENSATIONS="S EH N S EY SH AH N Z",ROBERS="R OW B ER Z",PRIMITIVE="P R IH M AH T IH V",MORAWSKI="M ER AA F S K IY",HOMEWORK="HH OW M W ER K",TRANSCRIBING="T R AE N S K R AY B IH NG",["SOCIALISTS(2)"]="S OW SH AH L IH S T S",PREDISPOSED="P R IY D IH S P OW Z D",ALEJANDRE="AA L EY Y AA N D R EY",CULHANE="K AH L HH EY N",ELSWORTH="EH L Z W ER TH",BRYANT="B R AY AH N T",["METZGER'S"]="M EH T S G ER Z",RENDLEMAN="R EH N D AH L M AH N",BLEICH="B L AY K",MYSTIFIED="M IH S T AH F AY D",GLEICH="G L AY K",STRONGER="S T R AO NG ER",["VIACOM'S"]="V AY AH K AA M Z",ENERGIZER="EH N ER JH AY Z ER",["TIMES'S"]="T AY M Z IH Z",SALAMEH="S AA L AA M EH",MASTECTOMY="M AE S T EH K T AH M IY",BORAWSKI="B ER AA F S K IY",SEVEROVIC="S EH V ER OW V IH K",SPECIFICS="S P IH S IH F IH K S",JUNKIEST="JH AH NG K IY AH S T",WEBERS="W EH B ER Z",ARBITRATES="AA R B IH T R EY T S",PEACHTREE="P IY CH T R IY",["INNOVATOR(2)"]="IH N OW V EY T ER",BLOTCHED="B L AA T CH T",NEWSLETTERS="N UW Z L EH T ER Z",BISEK="B IH S IH K",CISEK="CH IH S EH K",MCCLURKIN="M AH K L ER K AH N",["BOYLSTON'S"]="B OY L S T AH N Z",REVERBERATING="R IH V ER B ER EY T IH NG",FINEMAN="F AY N M AH N",SOMMERFELDT="S AA M ER F IH L T",HINEMAN="HH AY N M AH N",PEERING="P IY R IH NG",MCCARTER="M AH K AA R T ER",["COVERAGES(2)"]="K AH V ER IH JH IH Z",OSTANKINO="AA S T AH N K IH N OW",JEERING="JH IY R IH NG",BRUNDIDGE="B R AH N D IH JH",AUGUSTUS="AA G AH S T AH S",PHARMACIES="F AA R M AH S IY Z",SWEETHEARTS="S W IY T HH AA R T S",THOMASINE="TH OW M AA S IY N IY",REINWALD="R AY N W AO L D",GLOCKNER="G L AA K N ER",PINGREE="P IH NG G R IY",VEERING="V IH R IH NG",JULIET="JH UW L IY EH T",LUCRECIA="L UW K R IY SH AH",KOWTOW="K AW T AW",IMPOSED="IH M P OW Z D",RESTAURATEURS="R EH S T ER AH T ER Z",OCCASIONAL="AH K EY ZH AH N AH L",IMMUNIZES="IH M Y AH N AY Z IH Z",SERPICO="S ER P IY K OW",CRUNCHY="K R AH N CH IY",WINEMAN="W AY N M AH N",WETMORE="W EH T M AO R",MEYN="M EY N",ALBERS="AO L B ER Z",["THOUSAND(2)"]="TH AW Z AH N",FRIDAY="F R AY D IY",FROGMEN="F R AA G M IH N",LINEMAN="L AY N M AH N",BULLITT="B UW L IH T",KAZUNORI="K AE Z AH N OW R IY",SPONSORSHIPS="S P AA N S ER SH IH P S",LEGISLATURE="L EH JH AH S L EY CH ER",["RESERVES(2)"]="R IY Z ER V Z",HOVLAND="HH AA V L AH N D",EVETTS="EH V IH T S",COPERNICAN="K AH P ER N AH K AH N",["MARGARET(3)"]="M AA R G R IH T",ALEJOS="AA L EY Y OW Z",["MCILVAIN(2)"]="M AH K IH L V EY N",MONSIGNORS="M AA N S IY N Y ER Z",["FLUORESCENTLY(2)"]="F L AO R EH S AH N T L IY",HALLOCK="HH AE L AH K",FISHBURNE="F IH SH B ER N",SASEK="S AE S IH K",MARIJUANA="M EH R AH W AA N AH",VASEK="V AA S EH K",HANSELMAN="HH AE N S AH L M AH N",PASEK="P AA S EH K",UNDERPLAYED="AH N D ER P L EY D",NIKKEL="N IH K AH L",HAERING="HH AA ER IH NG",FRIENDS="F R EH N D Z",["CRUDE'S"]="K R UW D Z",["NIKKEI(2)"]="N IY K EY",["GARRETT'S(2)"]="G EH R IH T Z",COLLECTED="K AH L EH K T AH D",WICKWIRE="V IH S K V AY R",OVERESTIMATING="OW V ER EH S T AH M EY T IH NG",COMFORTED="K AH M F ER T IH D",["ROMANY(2)"]="R OW M AH N IY",ESTEEMED="IH S T IY M D",DOMINATED="D AA M AH N EY T AH D",CONDITT="K AA N D IH T",PROJECTORS="P R AH JH EH K T ER Z",NOMINATED="N AA M AH N EY T AH D",ANTIPODAL="AE N T IH P AH D AH L",BOUTIN="B UW T AE N",SUPPLEE="S AH P L IY",HAYN="HH EY N",KINDEST="K AY N D AH S T",KRUMME="K R AH M",LIPPINCOTT="L IH P IH N K AH T",SCHOOLTIME="S K UW L T AY M",OUELETTE="AA UW L EH T",TORREGROSSA="T AO R EH G R OW S AH",KERSHNER="K ER SH N ER",BOORISHNESS="B UH R IH SH N AH S",HERSHNER="HH ER SH N ER",DETECTION="D IH T EH K SH AH N",LEAPLEY="L IY P L IY",MIDFLIGHT="M IH D F L AY T",KOMPANEK="K AA M P AA N EH K",CARLINO="K AA R L IY N OW",["INTERNATIONAL'S(2)"]="IH N ER N AE SH AH N AH L Z",LOGISTICS="L AH JH IH S T IH K S",FAIRHAVEN="F EH R HH EY V AH N",PHYSIOLOGICAL="F IH Z IY AH L AA JH IH K AH L",["SOUTHERNNET'S"]="S AH DH ER N EH T S",["FREEMAN'S"]="F R IY M AH N Z",PSYCHOTHERAPY="S AY K OW TH EH R AH P IY",CONTROVERSY="K AA N T R AH V ER S IY",MELLGREN="M EH L G R EH N",FRIEDLI="F R IY D L IY",OUTLASTING="AW T L AE S T IH NG",STIRRING="S T ER IH NG",BOTHWELL="B AA TH W EH L",BAIDOAN="B AY D OW AH N",["INTERVIEW(2)"]="IH N ER V Y UW",HEMOGLOBIN="HH IY M AH G L OW B AH N",HADDAD="HH AE D AH D",["EUROTUNNEL'S"]="Y UH R OW T AH N AH L Z",ROTHWELL="R AO TH W EH L",DEADLIER="D EH D L IY ER",POLLOCK="P AA L AH K",COMANCHE="K AH M AE N CH IY",MESTRE="M EH S T ER",QUIRIN="K W IH R IH N",GAUTIER="G AW T IY ER",SHOOTS="SH UW T S",WEYANT="W EY AH N T",["SCALIA'S(2)"]="S K AA L Y AH Z",LUXURIANT="L AH G ZH ER IY AH N T",BAILIFF="B EY L AH F",ACTIVATION="AE K T AH V EY SH AH N",MILITANCY="M IH L AH T AH N S IY",FENCL="F EH NG K AH L",HILLOCK="HH IH L AH K",KENYA="K EH N Y AH",DUSEK="D UW S EH K",CARDIGES="K AA R D IH JH IH Z",CALLIHAN="K AE L IH HH AE N",MATTHES="M AE TH IH Z",CORSIGLIA="K ER S IY G L IY AH",EYELASH="AY L AE SH",PREPAYING="P R IY P EY IH NG",WILLOCK="W IH L AH K",["DELVALLE'S"]="D EH L V AE L IY Z",["BOUGHT(2)"]="B AO T",OXBRIDGE="AA K S B R IH JH",KLIEG="K L IY G",SESKAR="S EH S K AA R",SHANKLES="SH AE NG K AH L Z",FINALS="F AY N AH L Z",["YOUSEF'S"]="Y UW S EH F S",CONSECRATE="K AA N S AH K R EY T",BIOFLAVONOIDS="B AY OW F L EY V AH N OY D Z",MISEK="M IH S EH K",RESUME="R IH Z UW M",FRIZZELL="F R IH Z AH L",GRIZZELL="G R IH Z AH L",FACILE="F AE S AH L",SAMMIS="S AE M IH S",DAURIA="D AO R IY AH",OVERRULE="OW V ER R UW L",["IRETON(2)"]="AY ER T AH N",MILLSTEIN="M IH L S T AY N",EXCEEDED="IH K S IY D AH D",OMARSKA="OW M AA R S K AH",["INADMISSIBLY(2)"]="IH N AE D M IH S AH B L IY",CHERISHED="CH EH R IH SH T",["AUGSPURGER(2)"]="AO G S P ER G ER",ABSENTEEISM="AE B S AH N T IY IH Z AH M",PATMORE="P AE T M AO R",KNOWLEDGE="N AA L AH JH",["TATEHO'S"]="T AH T EY HH OW Z",HIGHNESS="HH AY N AH S",["CORNIEL'S"]="K AO R N IY L Z",JANUSZEWSKI="Y AH N AH SH EH F S K IY",["MEDIA'S"]="M IY D IY AH Z",["KASINGA'S"]="K AH S IH NG G AH Z",AGROCHEMICAL="AE G R OW K EH M AH K AH L",["BIRDFEEDER'S"]="B ER D F IY D ER Z",CORNMEAL="K AO R N M IY L",BUNCHE="B AH N CH",ALISLAMIYYA="AE L AH S L AH M IY AH",HIAASEN="HH AY AA S IH N",BAYSINGER="B EY S IH N JH ER",BULLOCK="B UH L AH K",IMPEACH="IH M P IY CH",FIGMENTS="F IH G M IH N T S",FAINTHEARTED="F EY N T HH AA R T IH D",KLESKEN="K L EH S K AH N",BLUEEYED="B L UW AY D",HEARTWOOD="HH AA R T W UH D",HOUSEWARES="HH AW S W EH R Z",OVERDRESS="OW V ER D R EH S",["HANGIN'"]="HH AE NG G IH N",LINDOW="L IH N D OW",LECTURES="L EH K CH ER Z",INSTITUTO="IH N S T IH T UW T OW",BRIGHTNESS="B R AY T N AH S",["HYNES'S"]="HH AY N Z IH Z",SHAMPOO="SH AE M P UW",CALLIGAN="K AE L IH G AH N",PAUNCHY="P AO N CH IY",GALLIGAN="G AE L IH G AH N",LAMINATED="L AE M AH N EY T AH D",HALLIGAN="HH AE L IH G AH N",["FIERSTEIN(2)"]="F IY R S T AY N",SUNDERLAND="S AH N D ER L AH N D",ACADEMICALLY="AE K AH D EH M IH K L IY",REFORMISTS="R IH F AO R M IH S T S",NUTRIA="N UW T R IY AH",JEFFRIES="JH EH F R IY Z",QUESENBERRY="K W IY Z AH N B EH R IY",MOZLEY="M AA Z L IY",MICROLITER="M AY K R OW L IY T ER",HOOLIGANS="HH UW L IH G AH N Z",BRANDEBERRY="B R AE N D B EH R IY",["GETTINGER(2)"]="G EH T IH N JH ER",NOSEK="N OW S EH K",KOSEK="K OW S EH K",["OETTINGER(2)"]="OW T IH NG ER",["RETTINGER(2)"]="R EH T IH NG ER",PULCINI="P UW L CH IY N IY",MORIBUND="M AO R AH B AH N D",MURAWSKI="M ER AA F S K IY",KILDOW="K IH L D OW",VANDYCK="V AE N D IH K",WACHTELL="W AA K T EH L",PREEMPTS="P R IY EH M P T S",DISEASES="D IH Z IY Z AH Z",EARTHMOVING="ER TH M UW V IH NG",CUMBIAS="K AH M B IY AH Z",NEOCLASSICAL="N IY OW K L AE S IH K AH L",CACCAVALE="K AA K AH V AA L IY",PLANET="P L AE N AH T",CATHERWOOD="K AE DH ER W UH D",NELLIGAN="N EH L IH G AH N",KAZMIERCZAK="K AA Z M IH R CH AE K",HARDPRESSED="HH AA R D P R EH S T",["BARRELED(2)"]="B EH R AH L D",PICONE="P IH K OW N",ARCHAEOLOGISTS="AA R K IY AA L AH JH IH S T S",PAYSINGER="P EY S IH NG G ER",SERONO="S EH R AA N OW",OUTRUNNING="AW T R AH N IH NG",["SAN-ANDREAS"]="S AE N AA N D R EY AH S",POREMBA="P AO R EH M B AH",["INDIA'S"]="IH N D IY AH Z",WONKSAHACHEE="W AA N K S AH HH AE CH IY",["HA'ETZNI"]="HH AH EH T S N IY",["LEGISLATION'S"]="L EH JH AH S L EY SH AH N Z",PREPARERS="P R IY P EH R ER Z",HOSEK="HH OW S EH K",REYNAGA="R IY N AA G AH",ALLENDER="AA L Y EH N D EY ER",FONDEST="F AA N D AH S T",ALLPORT="AO L P AO R T",LOANED="L OW N D",GALLAGHER="G AE L AH G ER",WEDNESDAYS="W EH N Z D EY Z",INTERSECTS="IH N T ER S EH K T S",["DEVAL'S"]="D IH V AA L Z",FRIEDE="F R IY D",CAUTIOUS="K AO SH AH S",BARBONE="B AA R B OW N",CARBONE="K AA R B OW N",FRANCISCAN="F R AE N S IH S K AH N",COAGULATION="K OW AE G Y AH L EY SH AH N",REESER="R IY S ER",BLIMPS="B L IH M P S",MOANED="M OW N D",TREGO="T R EH G OW",["POUGHKEEPSIE'S"]="P AH K IH P S IY Z",["SHEK'S"]="SH EH K S",PREGO="P R EY G OW",WRITEDOWN="R AY T D AW N",GREGO="G R EH G OW",CREGO="K R EH G OW",CASHWELL="K AE SH W EH L",["KENDALL'S"]="K EH N D AH L Z",PEASANTRY="P EH Z AH N T R IY",MOXLEY="M AA K S L IY",["INTERCO'S"]="IH N T ER K OW Z",ROUGEAU="R UW ZH OW",MACKIN="M AE K IH N",CHAMPNEY="CH AE M P N IY",["SINGLE-HANDED"]="S IH NG G AH L HH AE N D IH D",CHURNS="CH ER N Z",CRUMM="K R AH M",BREADBASKET="B R EH D B AE S K AH T",KLONDIKE="K L AA N D AY K",TOKARZ="T OW K AA R Z",DIFAZIO="D IH F EY Z IY OW",CARRAHER="K AE R AH HH ER",DRUMM="D R AH M",KRUMM="K R AH M",STAPLEY="S T AE P L IY",["LILLEHAMER'S"]="L IH L IY HH AE M ER Z",["IDENTICS(2)"]="AY D EH N IH K S",["FALCONBRIDGE'S"]="F AE L K AH N B R IH JH IH Z",CRESSMAN="K R EH S M AH N",KATHERINE="K AE TH ER IH N",BRESSMAN="B R EH S M AH N",DEPOSITOR="D AH P AA Z IH T ER",SKIDDING="S K IH D IH NG",CATHERINE="K AE TH ER AH N",BROMBERG="B R AA M B ER G",PRESSMAN="P R EH S M AH N",MOTTERN="M AA T ER N",GRESSMAN="G R EH S M AH N",DOCILE="D AA S AH L",PASSABLE="P AE S AH B AH L",ETHNIC="EH TH N IH K",["LEFT-BRACE"]="L EH F T B R EY S",CERBONE="CH ER B OW N",REFIT="R IY F IH T",ANGIOPLASTY="AE N JH IY AH P L AE S T IY",MONOGAMY="M AH N AA G AH M IY",GOUNOD="G UW N AH D",["FREMD'S"]="F R EH M D Z",PROFESSING="P R AH F EH S IH NG",CHIMPS="CH IH M P S",BEFIT="B IH F IH T",AGRICOLE="AE G R IH K OW L",["KANSAS'"]="K AE N Z AH S",MERGERS="M ER JH ER Z",ENROLLEES="EH N R OW L IY Z",["TOMAKO'S"]="T OW M AA K OW Z",["DAMAGED(2)"]="D AE M IH JH D",OCEANOGRAPHER="OW SH AH N AA G R AH F ER",DEROUSSE="D ER UW S",HEAVNER="HH IY V N ER",STABILIZATION="S T EY B AH L AH Z EY SH AH N",["ACCLAIM'S"]="AH K L EY M Z",PLANED="P L EY N D",AMBIVALENT="AE M B IH V AH L AH N T",JURGENSON="JH ER G IH N S AH N",JERRIE="JH EH R IY",["LISTENERS(2)"]="L IH S N ER Z",FERRIE="F EH R IY",BERRIE="B EH R IY",EUPHEMISTIC="Y UW F AH M IH S T IH K",SULYA="S UW L Y AH",PENDRIL="P EH N D R IH L",["FLUORIDATION(2)"]="F L AO R AH D EY SH AH N",TERRIE="T EH R IY",DEFAZIO="D IH F AA Z IY OW",PUSKAR="P AH S K ER",MERRIE="M EH R IY",["CHURCHILL'S(2)"]="CH ER CH HH IH L Z",PRINTZ="P R IH N T S",STUFFS="S T AH F S",ALLUDE="AH L UW D",BOHREN="B AO R AH N",SEABORNE="S IY B AO R N",UNKNOWING="AH N N OW IH NG",MOCKBY="M AA K B IY",DISPOSALS="D IH S P OW Z AH L Z",LORETO="L AO R EH T OW",ENTRANT="EH N T R AH N T",PRICED="P R AY S T",DELUDE="D IH L UW D",BREINER="B R AY N ER",OTREMBA="OW T R EH M B AH",AHLSTRAND="AA L S T R AH N D",KREINER="K R AY N ER",ITCHING="IH CH IH NG",["WESTPHALIA(2)"]="W EH S T F EY L Y AH",GREINER="G R AY N ER",SYRINGES="S ER IH N JH AH Z",BLOODIEST="B L AH D IY AH S T",MEDICI="M EH D IY S IY",NEGLECTED="N AH G L EH K T AH D",LAWRANCE="L AO R AH N S",INDICT="IH N D AY T",["NAJIB'S"]="N AH JH IY B Z",DECAFFEINATING="D IY K AE F AH N EY T IH NG",ULCERS="AH L S ER Z",KABUKI="K AH B UW K IY",RAPHAEL="R AA F AY EH L",BARRIE="B AE R IY",CARRIE="K EH R IY",STEGOSAURUS="S T EH G AH S AO R AH S",VONSEGGERN="V AA N S IH G ER N",SPICED="S P AY S T",PEREGRINES="P EH R AH G R IY N Z",HUXLEY="HH AH K S L IY",["INACOMP(2)"]="IH N AH K AA M P",MONTEBELLO="M AA N T IH B EH L OW",ARCHING="AA R CH IH NG",SPACIOUS="S P EY SH AH S",["EDUCATION'S(2)"]="EH JH Y UW K EY SH AH N Z",TUMINELLO="T UW M IY N EH L OW",VOICED="V OY S T",VACATED="V EY K EY T AH D",ZELIA="Z EH L IY AH",KINGMA="K IH NG M AH",MADALENA="M AE D AH L EY N AH",SELIA="S EH L IY AH",NELIA="N EH L IY AH",MELIA="M EH L IY AH",LELIA="L IY L Y AH",OLEJNIK="AH L EY N IH K",FAIRFAX="F EH R F AE K S",LEVYING="L EH V IY IH NG",DELIA="D IY L Y AH",CELIA="S IY L Y AH",HUMANITARIANS="HH Y UW M AE N AH T EH R IY AH N Z",PACIFIER="P AE S AH F AY ER",EGGUM="EH G AH M",["CONFLICTS(3)"]="K AH N F L IH K S",TRANQUILIZE="T R AE NG K W AH L AY Z",["DOESN'T"]="D AH Z AH N T",HEINTZ="HH AY N T S",FIESER="F IY S ER",STAIRCASES="S T EH R K EY S IH Z",KAWAMURA="K AW AA M UH R AH",KIESER="K IY S ER",LIESER="L IY S ER",GIESER="G IY S ER",["CHIRON'S"]="CH AY R AH N Z",["RIVAL'S"]="R AY V AH L Z",POLYMORPHISM="P AA L IY M AO R F IH Z M",RIESER="R IY S ER",SCHOECK="SH OW K",["MOSHE'S(2)"]="M OW SH AH Z",["DEWEY'S"]="D UW IY Z",ASBRIDGE="AH S B R IH JH",MCFUN="M AH K F AH N",RICHERSON="R IH CH ER S AH N",MATTERN="M AE T ER N",ARBENZ="AA R B EH N Z",MYHREN="M IH R AH N",CLIENT="K L AY AH N T",ZAREMBA="Z AA R EH M B AH",KORNBLUTH="K AO R N B L UW TH",LEANED="L IY N D",["FASTENERS(2)"]="F AE S N ER Z",BULLPEN="B UH L P EH N",WEANED="W IY N D",["WEISEL(3)"]="W IY Z EH L",PATEK="P AA T EH K",SHAPLEY="SH AE P L IY",INCHING="IH N CH IH NG",FORGERS="F AO R JH ER Z",STEINER="S T AY N ER",CRYOGENIC="K R AY AH JH EH N IH K",HEINDL="HH AY N D AH L",PERCEPTIVE="P ER S EH P T IH V",KUNDUN="K UH N D AH N",MEINDL="M AY N D AH L",WIESER="W IY S ER",STEPHANIA="S T IH F AE N IY AH",FORTIFIED="F AO R T AH F AY D",HINDQUARTERS="HH AY N D K W AO R T ER Z",MELICHAR="M EH L IH K ER",["ENRAGED(2)"]="IH N R EY JH D",MORTIFIED="M AO R T AH F AY D",DISMORE="D IH S M AO R",DATEK="D AE T EH K",FLUFFS="F L AH F S",ADDICT="AH D IH K T",EXHAUSTS="IH G Z AO S T S",BLUFFS="B L AH F S",REINDL="R AY N D AH L",PILLARED="P IH L ER D",PORTCULIS="P AO R T K AH L IH S",DONAHOE="D AA N AH HH OW",SWAVELY="S W EY V L IY",ABBITT="AE B IH T",PHILANTHROPIST="F AH L AE N TH R AH P AH S T",COWLICKS="K AW L IH K S",KIDNAPPED="K IH D N AE P T",RITUALISTICALLY="R IH CH UW AH L IH S T IH K AH L IY",["PORT-VICTORIA"]="P AO R T V IH K T AO R IY AH",CERTITUDE="S ER T AH T UW D",DONILON="D AA N AH L AA N",BAYLEY="B EY L IY",SEYFARTH="S EY F AA R TH",["AJAX'S(2)"]="EY JH AE K S IH Z",HAYLEY="HH EY L IY",EPIGRAPHIC="EH P AH G R AE F IH K",STUMPAGE="S T AH M P IH JH",["DONNELLEY'S"]="D AA N AH L IY Z",SYMPATHIES="S IH M P AH TH IY Z",HOCKIN="HH AA K IH N",PALESTINE="P AE L AH S T AY N",CLIMATOLOGISTS="K L IH M AH T AA L AH JH IH S T S",["BLACKENING(2)"]="B L AE K N IH NG",ALIENATES="EY L IY AH N EY T S",OUTLAWING="AW T L AO IH NG",["REID-MILLER"]="R IY D M IH L ER",PUERTO="P W EH R T OW",FUGITIVE="F Y UW JH AH T IH V",BRAVELY="B R EY V L IY",GRAVELY="G R EY V L IY",CANCELED="K AE N S AH L D",DARKENED="D AA R K AH N D",STREPS="S T R EH P S",ROSENKRANTZ="R OW Z AH N K R AE N T S",TRIXIE="T R IH K S IY",CHEESEBURGERS="CH IY Z B ER G ER Z",TELEPATH="T EH L AH P AE TH",KLOSTERMAN="K L AA S T ER M AH N",BRUTALIZE="B R UW T AH L AY Z",ELLIOT="EH L IY AH T",STAVELY="S T EY V L IY",CERTIFIED="S ER T AH F AY D",GWYN="G W IH N",GROUPERS="G R UW P ER Z",SIGHING="S AY IH NG",IMAGINATION="IH M AE JH AH N EY SH AH N",BUCKSHOT="B AH K SH AA T",RUMINATED="R UW M IH N EY T IH D",FORMIDABLY="F AO R M AH D AH B L IY",MOURNS="M AO R N Z",EMBARRASSED="IH M B EH R AH S T",SUBDIVISION="S AH B D IH V IH ZH AH N",SITEK="S IH T EH K",MITEK="M AY T EH K",MCCONAUGHEY="M AH K AA N AH G EY",HOLIDAY="HH AA L AH D EY",MARINVEST="M ER IH N V AH S T",SLICED="S L AY S T",BEIJER="B AY R",PRATTLING="P R AE T L IH NG",SOLIDAY="S OW L IY D EY",ENLISTED="EH N L IH S T IH D",ZITEK="Z IH T IH K",VITEK="V IH T EH K",WITEK="V IH T EH K",MOVEMENTS="M UW V M AH N T S",MISPRINT="M IH S P R IH N T",UNLISTED="AH N L IH S T IH D",["RENAULT'S(2)"]="R AH N OW Z",INTERACTED="IH N T ER AE K T AH D",VALIA="V AE L Y AH",MALIA="M AA L IY AH",FAUBEL="F AW B AH L",SHOALS="SH OW L Z",TELEVISED="T EH L AH V AY Z D",DALIA="D AA L Y AH",CALIA="K AA L IY AH",["MOREFIELD(2)"]="M AO R F IY L D",["SONDHEIM'S"]="S AA N D HH AY M Z",STAPP="S T AE P",REBUILDS="R IY B IH L D Z",HOLDOUT="HH OW L D AW T",["BALLASTS(2)"]="B AE L AH S",LAKEFIELD="L EY K F IY L D",MAKEFIELD="M EY K F IY L D",["COMMENSURATE(2)"]="K AH M EH N S ER IH T",HARMONIE="HH AA R M AH N IY",["PUSH-UP"]="P UH SH AH P",COMDATA="K AA M D AE D AH",BENEDIX="B EH N AH D IH K S",SNACKWELLS="S N AE K W EH L Z",BLOMBERG="B L AA M B ER G",DOMENECH="D AA M IH N IH K",ALBERTINA="AA L B ER T IY N AH",BARREDA="B AA R EY D AH",COUNTERCULTURAL="K AW N T ER K AH L CH ER AH L",TRAPP="T R AE P",SOUNDNESS="S AW N D N AH S",POZNAN="P AA Z N AH N",KRAPP="K R AE P",OVERPROTECTED="OW V ER P R AH T EH K T AH D",GALLEON="G AE L IY AH N",DWEEB="D W IY B",JABRIL="JH AH B R IY L",SPURNS="S P ER N Z",FERRARI="F ER AA R IY",BOMBASTIC="B AA M B AE S T IH K",CUPBOARDS="K AH B ER D Z",MISGIVING="M IH S G IH V IH NG",NOVELTY="N AA V AH L T IY",OZMENT="AA Z M AH N T",PARTYING="P AA R T IY IH NG",LUCILE="L UW S IY L",PURPLES="P ER P AH L Z",BARBECUED="B AA R B IH K Y UW D",MCCAUGHEY="M AH K AO IY",OSMENT="AA S M AH N T",["JOYCELYN'S"]="JH OY S L IH N Z",SHAPP="SH AE P",FRANKLY="F R AE NG K L IY",EISENHOUR="AY Z AH N AW R",ASTUTE="AH S T UW T",KOTEK="K OW T EH K",CLAUDINE="K L AO D IY N",["CERRUTI(2)"]="S ER UW T IY",OVERSHOT="OW V ER SH AA T",MCBURNETT="M AH K B ER N AH T",SOUVENIR="S UW V AH N IH R",["LAUDER(2)"]="L AW D ER",WELCOMED="W EH L K AH M D",OPTEK="AA P T EH K",RATICAN="R AE T IH K AH N",VATICAN="V AE T IH K AH N",GURSKY="G ER S K IY",DOXOLOGY="D AA K S AA L AH JH IY",AUMENT="AW M AH N T",BRYN="B R IH N",WILLABELLE="W IH L AH B EH L",["PREROGATIVE(2)"]="P ER AA G AH T IH V",COMPUTERIZATION="K AH M P Y UW T ER IH Z EY SH AH N",UNFIT="AH N F IH T",EULOGIZE="Y UW L AH JH AY Z",BLAKEY="B L EY K IY",MANUFACTURING="M AE N Y AH F AE K CH ER IH NG",RICHENTHAL="R IH K AH N TH AO L",["CANFOR'S"]="K AE N F ER Z",CARTILAGE="K AA R T AH L AH JH",HIPPOCRATES="HH IH P AH K R EY T S",LILIA="L IY L IY AH",STREICHER="S T R AY K ER",BORDERS="B AO R D ER Z",["L'ESPALIER"]="L EH S P AE L IY EY",INHALERS="IH N HH EY L ER Z",SOWN="S OW N",GRANA="G R AE N AH",FRANA="F R AE N AH",ARANA="AA R AE N AH",OLEOYLS="OW L IY OY L Z",JAWBONE="JH AO B OW N",LYRICISTS="L IH R IH S IH S T S",DOWN="D AW N",SELLERS="S EH L ER Z",TELLERS="T EH L ER Z",LOWN="L AW N",KEWLEY="K Y UW L IY",NEWLEY="N UW L IY",DECRANE="D AH K R EY N",BARBEQUED="B AA R B IH K Y UW D",DUANA="D UW AE N AH",BEWLEY="B Y UW L IY",FLAMBOYANT="F L AE M B OY AH N T",ROSSETTO="R OW S EH T OW",LENARZ="L EY N AA R Z",PALMISTRY="P AA M IH S T R IY",VRANA="V R AE N AH",VERLAG="V ER L AE G",SADOWSKY="S AH D AW S K IY",CAVANAUGH="K AE V AH N AO",KATHAN="K AE TH AH N",SALSER="S EY L S ER",NATHAN="N EY TH AH N",MATHAN="M EY TH AH N",LATHAN="L AE TH AH N",WABASH="W AO B AE SH",BIGHORNS="B IH G HH AO R N Z",PATHAN="P AE TH AH N",["SHAREHOLDERS'"]="SH EH R HH OW L D ER Z",STATIONING="S T EY SH AH N IH NG",ALTERCATION="AA L T ER K EY SH AH N",NONFOOD="N AA N F UW D",ALLEYWAYS="AE L IY W EY Z",TOOBIN="T UW B AH N",SECURITIZED="S IH K Y UH R AH T AY Z D",["PAPAGEORGE(2)"]="P AA P AH JH AO R JH",LEUGERS="L OY G ER Z",HOCKNEY="HH AA K N IY",SHAMBERGER="SH AE M B ER G ER",LOCKNEY="L AA K N EY",PARALLELING="P EH R AH L EH L IH NG",["PENNYPACKER(2)"]="P EH N IY P AE K ER",LECATES="L IH K EY T S",COCKNEY="K AA K N IY",YUHASZ="Y AH HH AH SH",FONDUES="F AA N D UW Z",WALLBOARD="W AO L B AO R D",MUNSTERMAN="M AH N S T ER M AH N",MILLERS="M IH L ER Z",LOUDEST="L AW D AH S T",DIVERGES="D AY V ER JH IH Z",["AMBASSADOR'S"]="AE M B AE S AH D ER Z",VILLERS="V IH L ER Z",WILLERS="W IH L ER Z",SALEMA="S AH L IY M AH",TIMPONE="T IY M P OW N IY",PEIRCE="P IH R S",EVERITT="EH V ER IH T",FILLERS="F IH L ER Z",GILLERS="G IH L ER Z",KILLERS="K IH L ER Z",DERMAGRAPH="D ER M AH G R AE F",LEUTWILER="L UW T W AY L ER",HAUGEN="HH AW G AH N",AUGUR="AO G ER",AVERITT="AE V ER IH T",BALSER="B EY L S ER",PAROLEE="P ER OW L IY",ACCIDENTAL="AE K S AH D EH N T AH L",GOLDBLATT="G OW L D B L AH T",SEWN="S OW N",ALANA="AA L AE N AH",MACOMB="M EY K AH M",LACOMB="L AE K AH M",ILANA="IH L AA N AH",HEWN="HH Y UW N",["PLAYGROUND(2)"]="P L EY G R AW N",FIXTURES="F IH K S CH ER Z",BLANKLY="B L AE NG K L IY",ODANIEL="AA D AH N IY L",["GURIT(2)"]="G UH R IH T",MIXTURES="M IH K S CH ER Z",MUSSELMAN="M AH S AH L M AH N",UMANA="UW M AA N AH",ENDOSPERM="EH N D AH S P ER M",MUSTIN="M AH S T IH N",RUSTIN="R AH S T IH N",ENLIVENS="EH N L AY V AH N Z",TUSTIN="T AH S T IH N",BOOKCELLARS="B UH K S EH L ER Z",LLANA="L AE N AH",MCGARRIGLE="M AH G AE R AH G AH L",GUSTIN="G AH S T IH N",DUSTIN="D AH S T IH N",["SIZES(2)"]="S AY Z IH Z",TAMBRANDS="T AE M B R AE N D Z",GUATEMALANS="G W AA T AH M AA L AH N Z",HARLEM="HH AA R L AH M",MONTVALE="M AA N T V EY L",FRASCO="F R AA S K OW",VANDERGRIFF="V AE N D ER G R IH F",["HAMMERSTEIN'S(2)"]="HH AE M ER S T AY N Z",RADAKOVICH="R AH D AE K AH V IH CH",["PLENTY(2)"]="P L EH N IY",["MASTRICH'S"]="M AE S T R IH CH IH Z",WINSTANLEY="W IH N S T AH N L IY",SIGUR="S IH G ER",["WHATSOEVER(2)"]="HH W AH T S OW EH V ER",EBENEZER="EH B IH N IY Z ER",MASONITE="M AE S AH N AY T",MILLICOM="M IH L IH K AA M",SHIRKEY="SH ER K IY",YPSILANTI="IH P S AH L AE N T IY",MCCLAINE="M AH K L EY N",HELSER="HH EH L S ER",BELSER="B EH L S ER",ALOOFNESS="AH L UW F N AH S",["GLEASON'S"]="G L IY S AH N Z",HEISEY="HH AY S IY",PAWN="P AO N",HERDERS="HH ER D ER Z",ANNIHILATION="AH N AY AH L EY SH AH N",CHISWICK="CH IH Z W IH K",SPANIEL="S P AE N Y AH L",TEXTURES="T EH K S CH ER Z",HAWN="HH AO N",FAWN="F AO N",LEISEY="L IY S IY",LAWN="L AO N",YAWN="Y AO N",SHOPKORN="SH AA P K AO R N",PEEKED="P IY K T",TERRORISM="T EH R ER IH Z AH M",TASTER="T EY S T ER",DANSFORTH="D AE N S F AO R TH",DEFLECTED="D IH F L EH K T IH D",["STEWART'S"]="S T UW ER T S",FILENET="F AY L N EH T",FASTER="F AE S T ER",GASTER="G AE S T ER",DEFOLLETS="D AH F AO L AH T S",JASTER="JH AE S T ER",KASTER="K AE S T ER",DUFRANE="D AH F R EY N",VOLUNTEERING="V AO L AH N T IH R IH NG",GUMAER="G AH M AW ER",LASTER="L AE S T ER",MASTER="M AE S T ER",RASTER="R AE S T ER",DAYCARES="D EY K EH R Z",ILLEGALITIES="IH L IY G AE L IH T IY Z",ROBARTS="R AA B AA R T S",LAWRIE="L AO R IY",INFLECTED="IH N F L EH K T AH D",SHREWDEST="SH R UW D AH S T",PRECEDENTS="P R EH S AH D AH N T S",LARIVEE="L AE R IH V IY",SZAFRANSKI="SH AH F R AE N S K IY",PERROTTI="P ER R OW T IY",HORSESHOE="HH AO R S SH UW",["TREASURY'S"]="T R EH ZH ER IY Z",GREGOR="G R EH G ER",BUTTRESSES="B AH T R AH S AH Z",["RETURNED(2)"]="R IY T ER N D",CLEMATIS="K L EH M AH T IH S",MELANOMA="M EH L AH N OW M AH",["GOBBLER(2)"]="G AA B L ER",MARLBOROS="M AA R L B ER R OW Z",COLVARD="K AA L V ER D",BREWBAKER="B R UW B EY K ER",CASEWORK="K EY S W ER K",MARSIGLIA="M AA R S IH G L IY AH",REAFFIRMS="R IY AH F ER M Z",HOLLENBAUGH="HH AH L EH N B AO",STRANGULATION="S T R AE NG G Y AH L EY SH AH N",WINNICKI="V IH N IH T S K IY",LEGHORNS="L EH G HH AO R N Z",DEFECTIONS="D IH F EH K SH AH N Z",THIEDE="TH IY D",IVANA="IH V AA N AH",BIRDERS="B ER D ER Z",GIRDERS="G ER D ER Z",PATIENT="P EY SH AH N T",["BUREAUCRACY'S"]="B Y UH R AA K R AH S IY Z",GROSVENOR="G R OW V N ER",DAISEY="D EY S IY",SPAGNOLO="S P AA G N OW L OW",MCMURTRY="M AH K M ER T R IY",BASYE="B AE S AY",HISTRIONIC="HH IH S T R IY AA N IH K",DEORBIT="D IY AO R B IH T",JUANA="W AA N AH",LUANA="L UW AE N AH",CHEEKY="CH IY K IY",["GRADUATED(2)"]="G R AE JH AH W EY T IH D",DWANA="D W AA N AH",ALTSCHUL="AE L CH AH L",WHITISH="W AY T IH SH",CRIMEAN="K R IH M IY N",["TEMPERAMENTS(2)"]="T EH M P ER M AH N T S",STOESSEL="S T OW S AH L",SAVEDRA="S AH V EH D R AH",["RECOVERY'S"]="R IH K AH V ER IY Z",MINILAB="M IH N IY L AE B",BAXLEY="B AE K S L IY",CURCIO="K UH R CH IY OW",EUROPEENNE="Y UW R OW P IY N",CECOS="S IY K OW S",INCIDENTAL="IH N S IH D EH N T AH L",ISOGENIC="AY S OW JH EH N AH K",HERTER="HH ER T ER",REVALUATION="R IY V AE L Y UW EY SH AH N",FORTNIGHT="F AO R T N AY T",CULLERS="K AH L ER Z",LAMENT="L AH M EH N T",CONFECTIONARY="K AH N F EH K SH AH N EH R IY",MELARAGNO="M EH L AA R AA G N OW",ORADOUR="AO R AH D AO R",OPTOMETRY="AA P T AA M AH T R IY",HUCKSTER="HH AH K S T ER",["JOBS'S"]="JH AA B Z IH Z",IMASCO="IH M AE S OW",VIOLETTE="V IY OW L EH T",HEADLINED="HH EH D L AY N D",MITCHNER="M IH CH N ER",SUMRALL="S AH M R AH L",BARTHES="B AA R TH S",ADUSDUR="AE D AH S D ER",HITCHNER="HH IH CH N ER",["MURRAY'S"]="M ER IY Z",BERETS="B EH R AH T S",ALLOWANCES="AH L AW AH N S IH Z",EASTIN="IY Z T IH N",MACMASTER="M AH K M AE S T ER",ADVECTION="AE D V EH K SH AH N",BASTIN="B AE S T IH N",LARAIA="L AA R AA Y AH",MASTIN="M AE S T IH N",IGNORAMUS="IH G N ER EY M AH S",EBBERS="EH B ER Z",COUNTERED="K AW N T ER D",TECOS="T IY K OW S",DEVALUATION="D IH V AE L Y UW EY SH AH N",MILLINER="M IH L IH N ER",NOVOA="N OW V OW AH",OROGENIC="AO R AH JH EH N IH K",CORRUPTION="K ER AH P SH AH N",CUPIT="K Y UW P IH T",BURGERS="B ER G ER Z",COUNTESS="K AW N T AH S",KRUPMAN="K R AH P M AH N",HUMPBACK="HH AH M P B AE K",BELANGER="B EH L AH NG ER",MAINLINE="M EY N L AY N",SEGUR="S EY G UH R",ASHRAWI="AE SH R AA W IY",GARNICA="G AA R N IY K AH",MCBREEN="M AH K B R IY N",FIASCO="F IY AE S K OW",["ANYONE'LL"]="EH N IY W AH N AH L",NORDMANN="N AO R D M AH N",HAINLINE="HH EY N L AY N",STAPLE="S T EY P AH L",HAUSNER="HH AW S N ER",MORTER="M AO R T ER",MICHEAL="M AY K AH L",HORTER="HH AO R T ER",GORTER="G AO R T ER",COURTESIES="K ER T AH S IY Z",COUNTERSUIT="K AW N T ER S UW T",LARMORE="L AA R M AO R",["HUERTA(2)"]="W EH R T AH",BLASCO="B L AA S K OW",EATMON="IY T M AH N",GLASCO="G L AA S K OW",OAKWOOD="OW K W UH D",BARMORE="B AA R M AO R",HARDERS="HH AA R D ER Z",ANSHAN="AE N SH AH N",OWENSBORO="OW AH N Z B ER OW",DESTIN="D EH S T IH N",IMPINGES="IH M P IH N JH IH Z",["SCHWEITZER'S"]="SH W AY T S ER Z",DISPOSITION="D IH S P AH Z IH SH AH N",WESTIN="W EH S T IH N",YACOS="Y AA K OW S",PIXLEY="P IH K S L IY",SMITTEN="S M IH T AH N",LINOLEUM="L AH N OW L IY AH M",OBJECTIONABLE="AH B JH EH K SH AH N AH B AH L",ADAMANTLY="AE D AH M AH N T L IY",TIPHOOK="T IH P HH UH K",["ELEANOR(2)"]="EH L AH N ER",QUICKEL="K W IH K AH L",RABINER="R AH B IY N ER",WISTFULLY="W IH S T F AH L IY",WRITTEN="R IH T AH N",REINBOLT="R AY N B OW L T",ZEHREN="Z EH R AH N",PENTAX="P EH N T AE K S",POLYPHASE="P AA L IY F EY Z",EBASCO="EH B AE S K OW",GOURMETS="G UH R M EY Z",LOCATED="L OW K EY T AH D",HOUSTON="HH Y UW S T AH N",LAGRANGE="L AE G R EY N JH",["SEIGEL(2)"]="S IY G AH L",OLSHAN="OW L SH AH N",LOURIE="L AW R IY",INVIDIOUS="IH N V IH D IY AH S",MCGREEVEY="M AH G R IY V IY",LEASCO="L IY S K OW",BRITTEN="B R IH T AH N",STEELMAKER="S T IY L M EY K ER",SCAMMON="S K AE M AH N",ROLLERS="R OW L ER Z",BEXLEY="B EH K S L IY",MERAZ="M EH R AA Z",OCCIDENTAL="AA K S AH D EH N T AH L",["BUTARE'S"]="B UW T AA R IY Z",KRAEMER="K R EH M ER",MULLANY="M AH L AH N IY",RECAREY="R IY K EH R IY",HOLLERS="HH AA L ER Z",ZELAPUTON="Z EH L AH P Y UW T AH N",["RESORT(3)"]="R IY S AO R T",MARBRY="M AA R B R IY",ELLEFSON="EH L IH F S AH N",["REPLACE(2)"]="ER P L EY S",SIEDSCHLAG="S IY D SH L AH G",GUANDJO="G W AA N JH OW",MURDOCKS="M ER D AA K S",SQUADRON="S K W AA D R AH N",CLAPBOARDS="K L AE P B AO R D Z",UPBEAT="AH P B IY T",DOMAINE="D OW M EY N",["WACKSMAN'S"]="W AE K S M AH N Z",BRITISH="B R IH T IH SH",["COVERING(2)"]="K AH V R IH NG",NEONAZI="N IY OW N AA T S IY",["EXCESSES(2)"]="IH K S EH S IH Z",COUDERSPORT="K AW D ER Z P AO R T",RAINBOLT="R EY N B OW L T",INTERTIDAL="IH N T ER T AY D AH L",["EVOLVES(2)"]="IY V AA L V Z",["SIMMONS'"]="S IH M AH N Z",SWIMSUITS="S W IH M S UW T S",OFFENDER="AH F EH N D ER",RECUPERATION="R IH K UW P ER EY SH AH N",LINGUINE="L IH NG G W IY N IY",SELIGSON="S EH L IH G S AH N",MARJE="M AA R JH",DEFENDER="D IH F EH N D ER",VOINOVICH="V OY N AH V IH CH",MANNERING="M AE N ER IH NG",HEPWORTH="HH EH P W ER TH",["MINISTRY'S"]="M IH N AH S T R IY Z",["PUROLATOR'S"]="P Y UH R AH L EY T ER Z",["BIOTECHNOLOGY'S"]="B AY OW T EH K N AA L AH JH IY Z",VENDETTAS="V EH N D EH T AH Z",["BURRELL'S"]="B ER EH L Z",MUTILATIONS="M Y UW T AH L EY SH AH N Z",COCOS="K OW K OW Z",DEGRANGE="D EH G R EY N JH",CRIMPS="K R IH M P S",SENSUOUS="S EH N SH AH W AH S",OLYMPIAN="OW L IH M P IY AH N",OUSTER="AW S T ER",MUSTER="M AH S T ER",HABERKORN="HH AE B ER K ER N",KUSTER="K AH S T ER",LUSTER="L AH S T ER",JUSTER="JH AH S T ER",MERIEUX="M EH R IY UW",OSTEOARTHRITIS="AA S T IY OW AA R TH R AY T AH S",ALLAIS="AH L EY",UPDATES="AH P D EY T S",INCONSISTENCIES="IH NG K AA N S IH S T EH N S IY Z",SUCCESSES="S AH K S EH S AH Z",SCHREIER="SH R AY ER",PAKISTANIS="P AE K IH S T AE N IY Z",BETTERMENT="B EH T ER M AH N T",SLEUTHING="S L UW TH IH NG",PAMACHO="P AH M AA CH OW",CAMACHO="K AH M AA CH OW",LAROQUE="L ER OW K",SNOOK="S N UH K",DOGBANE="D AO G B EY N",METHVIN="M EH TH V IH N",GUSTER="G AH S T ER",SHERIN="SH EH R IH N",STANKOWSKI="S T AH NG K AO F S K IY",CUSTER="K AH S T ER",DUSTER="D AH S T ER",AUSTER="AO S T ER",BUSTER="B AH S T ER",LESESNE="L EH S IH N",CLINIC="K L IH N IH K",NAPOLEON="N AH P OW L IY AH N",BATHOLITHS="B AE TH AH L IH TH S",["INAUGURATED(2)"]="IH N AO G Y ER EY T IH D",CASSTEVENS="K AE S T IY V AH N Z",KRAPELS="K R AE P AH L Z",MEIERFELD="M AY R F EH L D",KOPIT="K AA P IH T",REPLIES="R IH P L AY Z",AGGRAVATION="AE G R AH V EY SH AH N",BURSTON="B ER S T AH N",["POSTPONING(2)"]="P OW S P OW N IH NG",GLOEDE="G L OW D",BARTELSON="B AA R T IH L S AH N",HURSTON="HH ER S T AH N",["TOTAL'S"]="T OW T AH L Z",TRANBERG="T R AE N B ER G",LEMASTERS="L AH M AE S T ER Z",MACLAINE="M AH K L EY N",ENTERTAINERS="EH N T ER T EY N ER Z",NEJAMATIN="N EH JH AH M AE T IH N",AHERIN="AA ER IH N",[")RIGHT-PAREN"]="R AY T P ER EH N",GRUSSING="G R AH S IH NG",LYSTER="L IH S T ER",CHESTNUTT="CH EH S T N AH T",EXCLUSIVE="IH K S K L UW S IH V",SEGMENTS="S EH G M AH N T S",OYSTER="OY S T ER",BAROQUE="B ER OW K",SCOOTS="S K UW T S",FLOOK="F L UH K",EXACERBATING="IH G Z AE S ER B EY T IH NG",AERODYNAMIC="EH R OW D AY N AE M IH K",FRESHENERS="F R EH SH AH N ER Z",DEMASTERS="D IY M AE S T ER Z",EARPHONE="IH R F OW N",RUDICH="R AH D IH K",ALLEGHENIES="AE L AH G EY N IY Z",MOULDY="M OW L D IY",COMMANDING="K AH M AE N D IH NG",["BUILDING'S"]="B IH L D IH NG Z",VOLUNTEERISM="V AO L AH N T IH R IH Z AH M",WELDWOOD="W EH L D W UH D",MCDERMOTT="M AH K D ER M AH T",EMBOSSED="IH M B AO S T",DISTRESS="D IH S T R EH S",SYLVEST="S IH L V EH S T",ISTHMUS="IH S M AH S",MISTRESS="M IH S T R AH S",PORTRAYING="P AO R T R EY IH NG",NORDLING="N AO R D AH L IH NG",["SOBIL'S"]="S OW B AH L Z",BASEMAN="B EY S M AH N",["MOBIL'S"]="M OW B AH L Z",HASEMAN="HH EY S M AH N",ASHUR="AE SH ER",HYSTER="HH IH S T ER",CASALS="K AA S AA L Z",DISPERSION="D IH S P ER ZH AH N",CALIFF="K AE L IH F",PICTURES="P IH K CH ER Z",MILLENNIUM="M AH L EH N IY AH M",APPLIES="AH P L AY Z",SEDATES="S IH D EY T S",CHERNENKO="CH ER N EH NG K OW",POSITED="P AA Z AH T AH D",GOODKIN="G UH D K IH N",["KUENSTLER(2)"]="K UH N S L ER",RUMSEY="R AH M Z IY",SOWDERS="S OW D ER Z",APPELLATE="AH P EH L IH T",OVERVALUATION="OW V ER V AE L Y UW EY SH AH N",POWDERS="P AW D ER Z",TRANQUILIZERS="T R AE NG K W AH L AY Z ER Z",["SELF-HELP"]="S EH L F HH EH L P",PARAKEET="P EH R AH K IY T",HILGENDORF="HH IH L G IH N D AO R F",PRIVY="P R IH V IY",EMPANEL="IH M P AE N AH L",SCORTESE="S K AO R T IY Z",IMPANEL="IH M P AE N AH L",OFFENSIVES="AH F EH N S IH V Z",MICHAELA="M AY K EH L AH",VANYA="V AA N Y AH",["SMUGGLERS'"]="S M AH G L ER Z",COMMODE="K AH M OW D",MIXUP="M IH K S AH P",ZELIFF="Z EH L IH F",EGOMANIAC="IY G OW M EY N IY AE K",SMOOTS="S M UW T S",AESTHETIC="EH S TH EH T IH K",BRENDEL="B R EH N D AH L",POLAROID="P OW L ER OY D",COLBERN="K OW L B ER N",BOLLETTIERI="B AH L EH T IY EH R IY",WERMIEL="W ER M IY AH L",PETRONI="P EH T R OW N IY",HOLLSTEIN="HH AA L S T AY N",BANYA="B AA N Y AH",DECEDENTS="D EH S IY D AH N T S",WESSELMAN="W EH S AH L M AH N",GEOLOGISTS="JH IY AA L AH JH IH S T S",MIDSUMMER="M IH D S AH M ER",BATTER="B AE T ER",BRODKIN="B R AA D K IH N",HASSELMAN="HH AE S AH L M AH N",FATTER="F AE T ER",CASSELMAN="K AE S AH L M AH N",HATTER="HH AE T ER",FRANKOWSKI="F R AH NG K AO F S K IY",ELLIFF="EH L IH F",OLLIFF="AA L IH F",WILSEY="W IH L S IY",HUFSTETLER="HH AH F S T IH T AH L ER",HOGWASH="HH AA G W AA SH",PALMERINO="P AO L M EH R IY N OW",MALTESE="M AO L T IY Z",KRIEG="K R IY G",CARBONARA="K AA R B OW N AA R AH",CHEERFUL="CH IH R F AH L",MATTER="M AE T ER",ECOLOGISTS="IH K AA L AH JH IH S T S",SATTER="S AE T ER",PATTER="P AE T ER",VATTER="V AE T ER",ZANU="Z AA N UW",TATTER="T AE T ER",TANU="T AA N UW",ZOOLOGISTS="Z OW AA L AH JH AH S T S",HYPOCRITE="HH IH P AH K R IH T",["GEARAN'S"]="G IH R AH N Z",DISARMED="D IH S AA R M D",AMERITECH="AH M EH R IH T EH K",GUMPORT="G AH M P AO R T",GEOGRAPHIC="JH IY AH G R AE F IH K",GENOTYPES="JH EH N AH T AY P S",INEQUITABLE="IH N EH K W AH T AH B AH L",NABERS="N EY B ER Z",SABERS="S EY B ER Z",STIEG="S T IY G",WESTWOOD="W EH S T W UH D",REEMERGED="R IY IH M ER JH D",HALSEY="HH AE L S IY",CARMICKLE="K AA R M IH K AH L",ROSAMUND="R OW Z AH M UH N D",UROLOGISTS="Y ER AA L AH JH AH S T S",BABERS="B EY B ER Z",LATTIN="L AE T IH N",BACKLIGHTS="B AE K L AY T S",["SORRELL'S"]="S AO R AH L Z",VISITED="V IH Z AH T AH D",LINHARDT="L IH N HH AA R T",["HOLLINGS(2)"]="HH AA L IH NG G Z",PATTIN="P AE T IH N",PROPENSITY="P R AH P EH N S IH T IY",WESTER="W EH S T ER",VESTER="V EH S T ER",EMERGENCY="IH M ER JH AH N S IY",TESTER="T EH S T ER",RESTER="R EH S T ER",PESTER="P EH S T ER",MESTER="M EH S T ER",NESTER="N EH S T ER",["IACOCCA'S"]="AY AH K OW K AH Z",HESITANTLY="HH EH Z IH T AH N T L IY",APOLOGISTS="AH P AA L AH JH AH S T S",ORACLES="AO R AH K AH L Z",GRIGAS="G R AY G AH Z",VITAE="V AY T AH",ARMINIE="AA R M IH N IY",WHIRRING="W ER IH NG",SWARTWOOD="S W AO R T W UH D",BEIDLEMAN="B AY D AH L M AH N",["SUBS'S"]="S AH B Z IH Z",TATTOOS="T AE T UW Z",ZWIEG="Z W IY G",PROGESTIN="P R OW JH EH S T IH N",YOUNGSTROM="Y AH NG S T R AH M",ANAPLASIA="AE N AH P L EY ZH Y AH",HOMEOWNERSHIP="HH OW M OW N ER SH IH P",MULTIVALVE="M AH L T IY V AE L V",OCANA="OW K AE N AH",EXONERATED="IH G Z AA N ER EY T IH D",["BROADENING(2)"]="B R AO D N IH NG",["RELAPSES(2)"]="R IH L AE P S IH Z",DEMERITT="D EH M ER IH T",OUTSTRIPS="AW T S T R IH P S",DIRECTED="D ER EH K T AH D",FOSSILIZE="F AA S AH L AY Z",OVERPOWERED="OW V ER P AW ER D",BETTIN="B EH T IH N",PILASTERS="P AH L AE S T ER Z",KLINGON="K L IH NG G AH N",STOOTS="S T UW T S",LEANA="L IY N AH",HESTER="HH EH S T ER",FESTER="F EH S T ER",CROSSED="K R AO S T",PRIMEAUX="P R IH M OW",BESTER="B EH S T ER",SAMPSEL="S AE M P S AH L",PARISEAU="P AE R IH S OW",["INADEQUATE(2)"]="IH N AE D AH K W EY T",STATIST="S T EY T IH S T",PROMOTIONAL="P R AH M OW SH AH N AH L",INCAPACITATION="IH N K AH P AE S IH T EY SH AH N",RISTER="R IH S T ER",SISTER="S IH S T ER",PACERS="P EY S ER Z",RACERS="R EY S ER Z",DELAUDER="D EH L AW D ER",["CARRIAN'S"]="K AE R IY AH N Z",FENECH="F EH N IH K",HOSKYNS="HH AO S K IH N Z",TANABE="T AA N AA B EY",ALEXANDER="AE L AH G Z AE N D ER",SUFFRAGE="S AH F R IH JH",KILOMETER="K AH L AA M AH T ER",IRREPARABLY="IH R EH P ER AH B L IY",FOUGERE="F AW G ER",ARGENTO="AA R JH EH N T OW",MAINTAIN="M EY N T EY N",KEMPTHORNE="K EH M P TH AO R N",TIBIA="T IH B IY AH",PORTWOOD="P AO R T W UH D",PALAIS="P AH L EY",HEMMINGER="HH EH M IH NG ER",["BAEHR(2)"]="B EH R",SNIDOW="S N IH D OW",HABICH="HH AE B IH K",BABICH="B AE B IH CH",INFECTIONS="IH N F EH K SH AH N Z",CALAIS="K AH L EY",STACIE="S T EY S IY",MABILE="M AA B AH L",LATCHKEY="L AE CH K IY",FURLOUGHED="F ER L OW D",KEMMERLING="K EH M ER L IH NG",INTONATIONS="IH N T AH N EY SH AH N Z",HULBURD="HH AH L B ER D",HEMMERLING="HH EH M ER L IH NG",INDUSTRIALLY="IH N D AH S T R IY AH L IY",ULSTER="AH L S T ER",PUGWASH="P AH G W AA SH",TVEIT="T V IY T",FISTER="F IH S T ER",LISTER="L IH S T ER",MISTER="M IH S T ER",GREENHOUSES="G R IY N HH AW S IH Z",PSORIASIS="S ER AY AH S AH S",["RESEARCH'S"]="R IY S ER CH IH Z",HEENAN="HH IY N AH N",REFRIGERATED="R IH F R IH JH ER EY T IH D",["BRIDE'S"]="B R AY D Z",MEENAN="M IY N AH N",NEENAN="N IY N AH N",BORUFF="B AO R AH F",HURDLING="HH ER D AH L IH NG",RISKIEST="R IH S K IY AH S T",OPPOSED="AH P OW Z D",DOMINICANA="D OW M IH N IH K AA N AH",INEXCUSABLY="IH N IH K S K Y UW Z AH B L IY",MURRIE="M ER IY",CURRIE="K ER IY",MATALON="M AA T AA L AO N",["FROGMOUTHS(2)"]="F R AA G M AW DH Z",PLANETS="P L AE N AH T S",HUBERS="HH UW B ER Z",POSTER="P OW S T ER",DETONATIONS="D EH T AH N EY SH AH N Z",INITIATING="IH N IH SH IY EY T IH NG",ATTRIBUTE="AE T R AH B Y UW T",LOBOS="L OW B OW S",ZOSTER="Z AA S T ER",DOBOS="D OW B OW Z",COBOS="K OW B OW Z",LENHARDT="L EH N HH AA R T",MARCIANTE="M AA R CH AH N T IY",PRIEUR="P R IY ER",TELEMARKETERS="T EH L AH M AA R K IH T ER Z",AMANA="AH M AE N AH",FOTOPOULOS="F AH T AA P AH L IH S",LORRIE="L AO R IY",MORRIE="M AO R IY",NORRIE="N AO R IY",CREATIONISM="K R IY EY SH AH N IH Z AH M",FERNALD="F ER N AA L D",DOTHAN="D AA TH AH N",AMSTER="AE M S T ER",["INSURANCE'S"]="IH N SH UH R AH N S IH Z",CORRIE="K AO R IY",VANVALKENBURG="V AE N V AO K AH N B ER G",["SEMIFINALISTS(4)"]="S EH M AY F AY N AH L IH S",CHANA="CH AE N AH",GRATIS="G R AE T AH S",GHANA="G AE N AH",ROWLEY="R OW L IY",LIANA="L IY AA N AH",PRICIEST="P R AY S IY IH S T",JOWLEY="JH OW L IY",PIANA="P IY AE N AH",POWLEY="P AW L IY",HELPED="HH EH L P T",COWLEY="K AW L IY",CREATES="K R IY EY T S",MICKELBERRY="M IH K AH L B EH R IY",HOWLEY="HH AW L IY",AKANA="AA K AA N AH",MESAROS="M EY S AA R OW Z",COSTER="K AO S T ER",DOSTER="D AA S T ER",FOSTER="F AA S T ER",SABIA="S AA B IY AH",SHANA="SH AE N AH",AMARAL="AA M AA R AE L",KOSTER="K AA S T ER",["INTRODUCES(2)"]="IH N T R OW D UW S IH Z",ENSNARLED="IH N S N AA R L D",HOSTER="HH OW S T ER",WISEMAN="W AY Z M AH N",SMITHERS="S M IH DH ER Z",SUBMERGED="S AH B M ER JH D",DEAKIN="D IY K IH N",GUGLIELMI="G UW G L IY EH L M IY",HOMSEY="HH AA M Z IY",ALLEYOOP="AE L IY UW P",ADDITIVE="AE D AH T IH V",ICELANDAIR="AY S L AE N D EH R",GREIWE="G R IY W",BRITANNIA="B R IH T AE N IY AH",SUTTER="S AH T ER",RUTTER="R AH T ER",PUTTER="P AH T ER",NUTTER="N AH T ER",MUTTER="M AH T ER",LUTTER="L AH T ER",KUTTER="K AH T ER",BIANA="B IY AA N AH",CARPENTIERI="K AA R P EH N T IH R IY",GUTTER="G AH T ER",TINKERER="T IH NG K ER ER",DUTTER="D AH T ER",CUTTER="K AH T ER",FEODOR="F IY AH D ER",HARDWOOD="HH AA R D W UH D",FISCALLY="F IH S K AH L IY",MERLINO="M ER L IY N OW",MEAKIN="M IY K IH N",["WATERSHEDS(2)"]="W AA T ER SH EH D Z",BROOK="B R UH K",MARSTON="M AA R S T AH N",GLOSSED="G L AO S T",HARSTON="HH AA R S T AH N",GARSTON="G AA R S T AH N",["TOWERING(2)"]="T AW R IH NG",PRISONERS="P R IH Z AH N ER Z",ACCOMMODATES="AH K AA M AH D EY T S",SPOOK="S P UW K",EXPOSED="IH K S P OW Z D",LIKELIER="L AY K L IY ER",SHREFFLER="SH R EH F L ER",CAPOZZOLI="K AA P OW T S OW L IY",ALVEOLAR="AE L V IY AH L ER",DANCANET="D AE NG K AH N EH T",["RAMESSES(2)"]="R AE M S IY Z",ASAMERA="AE S AH M EH R AH",["KNICKS'"]="N IH K S",SWANBERG="S W AA N B ER G",["FAJITAS(2)"]="F AH HH IY T AH Z",GOSSIPER="G AA S AH P ER",REGULATORY="R EH G Y AH L AH T AO R IY",COSENTINO="K OW S EH N T IY N OW",AGANA="AH G AA N AH",["HOW-ABOUT"]="HH AW AH B AW T",["IRAQI(3)"]="AY R AE K IY",ZAGEL="Z EY G AH L",["MADISON(2)"]="M AE D IH S AH N",SWARTZENTRUBER="S W AO R T S AH N T R UW B ER",RAGEL="R EY G AH L",CLOWNS="K L AW N Z",MCSWAIN="M AH K S W EY N",NAGEL="N EY G AH L",PAGEL="P AE G AH L",ESTROGEN="EH S T R AH JH AH N",KAGEL="K EY G AH L",GAGEL="G AE G AH L",HAGEL="HH AE G AH L",BAGEL="B EY G AH L",POLYSYLLABIC="P AA L IY S IH L AE B IH K",BRUNSVOLD="B R AH N Z V OW L D",["PYRENEES'"]="P IH R AH IY Z",OATHOUT="OW TH AW T",UGLIER="AH G L IY ER",CLARCOR="K L AA R K AO R",RUSSETS="R AH S IH T S",MARKETEER="M AA R K AH T IH R",GYPPED="JH IH P T",AZURE="AE ZH ER",TALKIES="T AO K IY Z",BRISSETTE="B R IH S EH T",OLASKY="OW L AE S K IY",SOUTHWEST="S AW TH W EH S T",PERMUT="P ER M AH T",MISQUOTING="M IH S K W OW T IH NG",CLEVITE="K L AH V AY T",BORROWERS="B AA R OW ER Z",HYPNOTIZES="HH IH P N AH T AY Z AH Z",SLAMMER="S L AE M ER",WALFRED="W AO L F R EH D",IMMUNOMEDICS="IH M Y UW N OW M EH D IH K S",INCORVAIA="IH N K AO R V AA Y AH",KLAMMER="K L AE M ER",["MODERNIZATION(2)"]="M AA D ER N AY Z EY SH AH",AURIEMMA="AO R IY M AH",REPERTORY="R EH P ER T AO R IY",VENEZIANO="V EH N EH Z IY AA N OW",FLAMMER="F L AE M ER",IMPRUDENTLY="IH M P R UW D AH N T L IY",SIDEKICK="S AY D K IH K",BRADBURN="B R AE D B ER N",KNOWNS="N OW N Z",["SITTIN'"]="S IH T AH N",PRESSWOOD="P R EH S W UH D",["COMMINGLE(2)"]="K OW M IH NG G AH L",SMILINGLY="S M AY L IH NG L IY",PRATFALLS="P R AE T F AO L Z",CONTENTIOUS="K AH N T EH N SH AH S",WAAH="W AA",MATTERS="M AE T ER Z",["RELATING(2)"]="R IY L EY T IH NG",COBAINE="K OW B EY N",["ONASSIS'S"]="OW N AE S IH S IH S",BATTERS="B AE T ER Z",["PACA(2)"]="P AE K AH",TRELA="T R EH L AH",ORELA="AO R EH L AH",EBERHART="EH B ER HH AA R T",TATTERS="T AE T ER Z",COMPATRIOT="K AH M P EY T R IY AH T",HLAVACEK="HH L AA V AH CH EH K",SINISTER="S IH N IH S T ER",CIGARETTE="S IH G ER EH T",AGREEABLE="AH G R IY AH B AH L",RECAPITALIZATION="R IY K AE P IH T AH L IH Z EY SH AH N",["ALCHEMIST(2)"]="AA L K AH M IH S T",["COMMISSIONER'S"]="K AH M IH SH AH N ER Z",CLOSEDOWNS="K L OW Z D AW N Z",RESUBMITTING="R IY S AH B M IH T IH NG",MCNICHOLAS="M AH K N IH K L AH S",OFFICE="AO F AH S",USINOR="Y UW S AH N ER",["CRANDALL'S"]="K R AE N D AH L Z",GUDINO="G UW D IY N OW",["MIDDLING(2)"]="M IH D L IH NG",["PIDDLING(2)"]="P IH D L IH NG",["MICHIELS(2)"]="M IH CH IY L Z",["FARMERS'S"]="F AA R M ER Z IH Z",["BARBED-WIRE"]="B AA R B D W AY R",["GETTIN'"]="G IH T AH N",REPOSSESS="R IY P AH Z EH S",COTILLA="K AH T IH L AH",HARJU="HH AA R Y UW",["TAVERNA'S"]="T AA V EH R N AH Z",KIYOHIDA="K IY OW HH IY D AH",DEPAOLI="D IH P AW L IY",["HORSE'S"]="HH AO R S AH Z",BORROWINGS="B AA R OW IH NG Z",PHILBIN="F IH L B IH N",KEESEE="K IY S IY",LOZEAU="L AH Z OW",MAHWAH="M AA W AH",ISAKSON="IH S AH K S AH N",DATUK="D AA T UW K",CRISTIANI="K R IH S T IY AA N IY",LETTERS="L EH T ER Z",BERMEL="B ER M AH L",KRAATZ="K R AA T S",["EMOTIONALLY(2)"]="IY M OW SH N AH L IY",MAYDE="M EY D",MCCARVILLE="M AH K AA R V AH L",PARADOXES="P EH R AH D AA K S IH Z",["DAVIO'S"]="D AE V IY OW Z",BETTERS="B EH T ER Z",CHRISTIANIZE="K R IH S CH AH N AY Z",BRAATZ="B R AA T S",["PETERSON'S"]="P IY T ER S AH N Z",UMLASI="UW M L AA S IY",LACAYO="L AA K EY OW",ALLERS="AO L ER Z",SETTERS="S EH T ER Z",WALDRON="W AO L D R AH N",NARVESON="N AA R V IH S AH N",REFUTING="R IH F Y UW T IH NG",MCCULLERS="M AH K AH L ER Z",CIULLO="CH UW L OW",GROINS="G R OY N Z",WIMPEE="W IH M P IY",GARDENS="G AA R D AH N Z",SEQUENCE="S IY K W AH N S",HARDENS="HH AA R D AH N Z",ARONOWITZ="ER AA N AH W IH T S",WITHOUT="W IH TH AW T",["SPECIALTY(2)"]="S P EY SH AH L T IY",MILLN="M IH L N",VANDERHOFF="V AE N D ER HH AO F",PETITES="P EH T IY T S",SOUTHARD="S AW TH ER D",["SINGAPORE'S"]="S IH NG AH P AO R Z",["HOW'RE"]="HH AW ER",["MEDDLING(2)"]="M EH D L IH NG",["MENORAH'S"]="M AH N AO R AH Z",SURVIVE="S ER V AY V",BOLEYN="B OW L IH N",LEXIS="L EH K S IH S",["PEDDLING(2)"]="P EH D L IH NG",SKOKIE="S K OW K IY",ENGROSSING="IH N G R OW S IH NG",RAZOR="R EY Z ER",PATHWAY="P AE TH W EY",["MENZIONE(2)"]="M EH N Z Y OW N IY",OUTRUNS="AW T R AH N Z",MAZOR="M AA Z AO R",LAZOR="L AA Z AO R",["ALEXANDER'S(2)"]="AE L IH G Z AE N D ER Z",PEARLSTINE="P ER L S T AY N",["MATTER'S"]="M AE T ER Z",BELIER="B EH L Y ER",ZUIDEMA="Z UW IH D EH M AH",RUMERY="R AH M ER IY",ALBERTY="AH L B ER T IY",LITTERS="L IH T ER Z",LITHOGRAPH="L IH TH AH G R AE F",FOREFATHER="F AO R F AA DH ER",SITTERS="S IH T ER Z",WITTERS="W IH T ER Z",MARESCO="M AA R EH S K OW",MINICHIELLO="M IY N IY K IY EH L OW",DESMOPLASTIC="D EH Z M OW P L AE S T IH K",["KIMBALL'S"]="K IH M B AH L Z",BITTERS="B IH T ER Z",TORTUROUS="T AO R CH UW AH S",CAMPOPIANO="K AA M P OW P IY AA N OW",JITTERS="JH IH T ER Z",HITTERS="HH IH T ER Z",COSENS="K OW S AH N Z",MADRIDS="M AH D R IH D Z",ROSALYN="R AA Z AH L IH N",CORNWALL="K AO R N W AO L",WORCESTERSHIRE="W UH S T AH SH ER",CRIVELLI="K R IH V EH L IY",BOOMHOWER="B UW M HH OW ER",HABITABLE="HH AE B AH T AH B AH L",LANGUISHING="L AE NG G W IH SH IH NG",COMPLIMENTARY="K AA M P L AH M EH N T ER IY",OUTSPENT="AW T S P EH N T",["RUSSIAN'S"]="R AH SH AH N Z",SUBCOMMANDERS="S AH B K AH M AE N D ER Z",SATRE="S EY T ER",GAUSTAD="G AW S T AH D",POTTERS="P AA T ER Z",HIALEAH="HH AY AH L IY AH",MCELYEA="M AE K AH L Y EY",ELECTROMAGNETIC="IH L EH K T R OW M AE G N EH T IH K",BROWNS="B R AW N Z",CROWNS="K R AW N Z",DROWNS="D R AW N Z",SURRENDERED="S ER EH N D ER D",["JUROR'S"]="JH UH R ER Z",CRITCHFIELD="K R IH CH F IY L D",POLLUX="P AA L AH K S",LIBERTY="L IH B ER T IY",BOTTOMING="B AA T AH M IH NG",WARDENS="W AO R D AH N Z",["BARRON(2)"]="B EH R AH N",THREADS="TH R EH D Z",ANDINO="AA N D IY N OW",HYRAXES="HH AY R AE K S AH Z",ROBINIA="R OW B IY N IY AH",SHAPELESS="SH EY P L AH S",BIELA="B IY L AH",PIELA="P IY L AH",GUILLORY="G IH L ER IY",RUMPF="R AH M P F",ADOPTERS="AH D AA P T ER Z",["IDENTIFIABLE(2)"]="AY D EH N AH F AY AH B AH L",EMMERY="EH M ER IY",MIKESH="M IH K IH SH",KUMPF="K AH M P F",GAINOR="G EY N ER",["D'ALESSI(2)"]="D AH L EY S IY",MAINOR="M EY N ER",WOLFARTH="W UH L F AA R TH",IRRIGATION="IH R AH G EY SH AH N",THRESHER="TH R EH SH ER",BURYING="B EH R IY IH NG",RODINO="R OW D IY N OW",UNCONTROVERSIAL="AH N K AA N T R AH V ER SH AH L",BOOKIE="B UH K IY",COOKIE="K UH K IY",AMUNDSON="AE M AH N D S AH N",ARMENTROUT="AA R M AH N T R AW T",REDEPLOYMENT="R IY D IH P L OY M AH N T",RUNNELLS="R AH N AH L Z",BARSTOW="B AA R S T OW",WHICH="W IH CH",SPROULE="S P R UW L",LEWKE="L UW K IY",PRECLUDES="P R IH K L UW D Z",FINEGOLD="F AY N G OW L D",DEFACING="D IH F EY S IH NG",["SULLIVAN(2)"]="S AH L IH V AH N",SCION="S AY AH N",AVEROF="AE V ER AA F",LUCARELLI="L UW K AA R EH L IY",BASHFORD="B AE SH F ER D",INATTENTIVE="IH N AH T EH N T IH V",PELAGIC="P AH L AE JH IH K",SIZABLE="S AY Z AH B AH L",SCHNEBLY="SH N EH B L IY",OREFFICE="AO R EH F IH S",["WITTER'S"]="W IH T ER Z",["OSTROW(2)"]="AA S T R OW",DISCERNIBLE="D IH S ER N AH B AH L",EFFACING="IH F EY S IH NG",DENUCLEARIZATION="D IY N UW K L IY ER AH Z EY SH AH N",VICINO="V IY CH IY N OW",MANERS="M EY N ER Z",ALLEBACH="AE L IH B AA K",SLEEPLESS="S L IY P L AH S",BECHTOLD="B EH K T OW L D",EQUIANGULAR="IY K W AH AE NG G Y AH L ER",RIZOR="R AY Z ER",THOMANN="DH OW M AH N",KOCIAN="K OW SH AH N",PLACATE="P L EY K EY T",ANTIPHON="AE N T AH F AA N",CONVERT="K AA N V ER T",KULIS="K UW L IH S",SHURE="SH UH R",ISOTOPES="AY S AH T OW P S",RECHARGEABLE="R IY CH AA R JH AH B AH L",REFLEXIVE="R AH F L EH K S IH V",KEGEL="K EH JH AH L",["DURKHEIM'S"]="D ER K HH AY M Z",COMPEAU="K AH M P OW",MATUSCHKA="M AH T AH SH K AH",REGEL="R EH G AH L",SEGEL="S IY G AH L",PROCESSIONAL="P R AH S EH SH AH N AH L",ORGANOGENESIS="AO R G AH N OW JH EH N AH S IH S",TRETTIN="T R EH T IH N",SUFFRAGETTE="S AH F R AH JH EH T",TRUNKLINE="T R AH NG K L AY N",EXCITABLE="IH K S AY T AH B AH L",BEGEL="B EY G AH L",["NONWHITE(2)"]="N AA N HH W AY T",UNOBTAINABLE="AH N AH B T EY N AH B AH L",NOVELLY="N OW V AH L IY",REGIME="R AH ZH IY M",["PLANES'"]="P L EY N Z",KOKESH="K AA K IH SH",GOMERY="G OW M ER IY",WERNERT="W ER N ER T",ROGEL="R OW G AH L",SIMPLICITY="S IH M P L IH S AH T IY",MOGEL="M OW G AH L",SWANK="S W AE NG K",KREMPLERS="K R EH M P L ER Z",GOGEL="G OW G AH L",FOGEL="F OW G AH L",VANNORMAN="V AE N AO R M AH N",GERNERT="G ER N ER T",ANGEL="EY N JH AH L",CAMSHAFT="K AE M SH AE F T",BRITTINGHAM="B R IH T IH NG HH AE M",WINDECKER="W IH N D EH K ER",POISONINGS="P OY Z AH N IH NG Z",VOGEL="V OW G AH L",MAMIS="M AE M IH S",NAMIS="N AE M IH S",LAMBORGHINIS="L AE M B ER G IY N IY Z",SPILLMAN="S P IH L M AH N",["DUPLICATED(2)"]="D Y UW P L AH K EY T IH D",MOZINGO="M OW Z IY NG G OW",IRANGATE="IH R AA N G EY T",LOHMEIER="L OW M AY ER",TRAVELDAYS="T R AE V AH L D EY Z",POLLINO="P OW L IY N OW",NICKLAS="N IH K L AH Z",GOLLIHER="G AA L IH HH ER",UNIBANCORP="Y UW N IH B AE N K AO R P",RESPECTABILITY="R IY S P EH K T AH B IH L IH T IY",TURNBRIDGE="T ER N B R IH JH",HONEYMAN="HH AA N IY M AH N",SIGEL="S IH G AH L",KURMEL="K ER M AH L",CENSORS="S EH N S ER Z",PUTTERS="P AH T ER Z",PRIMARILY="P R AY M EH R AH L IY",GUTTERS="G AH T ER Z",POLLITT="P AA L IH T",CUTTERS="K AH T ER Z",ACCOMPANYING="AH K AH M P AH N IY IH NG",BUTTERS="B AH T ER Z",SENSORS="S EH N S ER Z",RIOTING="R AY AH T IH NG",MONETARIST="M AA N AH T ER IH S T",RIGEL="R AY JH AH L",NIGEL="N AY JH AH L",NEBULIZER="N EH B Y AH L AY Z ER",SCHAUL="SH OW L",RECHECKED="R IY CH EH K T",["CYPRESS(2)"]="S AY P R IH S",STRUGGLING="S T R AH G AH L IH NG",STANK="S T AE NG K",["SOFTER(2)"]="S AO F T ER",CRUCIALLY="K R UW SH AH L IY",HARMONIZING="HH AA R M AH N AY Z IH NG",KELLIHER="K EH L IH HH ER",INFRARED="IH N F R ER EH D",SPILKER="S P IH L K ER",GALLUCCI="G AA L UW CH IY",IMPARTIAL="IH M P AA R SH AH L",["LYONS'S"]="L AY AH N Z IH Z",WONDERLY="W AH N D ER L IY",HAMBLET="HH AE M B L IH T",NICOLLS="N IH K AH L Z",DINERS="D AY N ER Z",UNDISPUTED="AH N D IH S P Y UW T IH D",SUITABLE="S UW T AH B AH L",NINERS="N AY N ER Z",MINERS="M AY N ER Z",LINERS="L AY N ER Z",["CALMART(2)"]="K AE L M AA R T",HEITZENRATER="HH AY T Z IH N R EY T ER",AUDIOVOX="AO D IY OW V AA K S",JUDGESHIP="JH AH JH SH IH P",WOOLFORK="W UH L F AO R K",["ENVIRONMENTALISM(2)"]="EH N V AY R AH N M EH N AH L IH Z AH M",["O'MELVENY"]="OW M EH L V AH N IY",PACINO="P AH S IY N OW",BACINO="B AA CH IY N OW",CHANCELLORS="CH AE N S AH L ER Z",WEAKLING="W IY K L IH NG",WILFRED="W IH L F R IH D",TURMEL="T ER M AH L",FEDERALISTS="F EH D ER AH L IH S T S",EDITORIALIZED="EH D AH T AO R IY AH L AY Z D",TENDERLY="T EH N D ER L IY",STEGENGA="S T EH JH EH NG G AH",WHITTINGHAM="W IH T IH NG HH AE M",BURROWERS="B ER OW ER Z",HAMITER="HH AE M AY T ER",GLOATED="G L OW T IH D",SKILLMAN="S K IH L M AH N",FLOATED="F L OW T AH D",PONTIFICAL="P AA N T IH F AH K AH L",CHAMPLAIN="SH AE M P L EY N",ESHLEMAN="EH SH AH L M AH N",ELINOR="EH L IH N ER",LEAPFROGGED="L IY P F R AO G D",YITZHAK="Y IH T S AA K",INCONVENIENCE="IH N K AH N V IY N Y AH N S",STUFFLEBEAN="S T AH F AH L B IY N",CHAMBLISS="CH AE M B L IH S",OXIDIZING="AA K S AH D AY Z IH NG",GALLIHER="G AE L IH HH ER",INURE="IH N Y UH R",BELLUCCI="B EH L UW CH IY",BLOATED="B L OW T IH D",DEION="D IY Y AA N",CANISTER="K AE N AH S T ER",STRAYER="S T R EY ER",CELLUCCI="CH EH L UW CH IY",PROFESSORS="P R AH F EH S ER Z",SCINTILORE="S IH N T AH L AO R IY",PREDICATE="P R EH D AH K EY T",ANGUIANO="AA NG G IY AA N OW",OXBOW="AA K S B OW",ROOKIE="R UH K IY",CLAGETT="K L AE JH IH T",SITUATE="S IH CH UW EY T",PRORATED="P R OW R EY T IH D",PROGRESSED="P R AH G R EH S T",DESECRATIONS="D EH S AH K R EY SH AH N Z",["ALZHEIMER(2)"]="AA L T S HH AY M ER",SAUTERNES="S OW T ER N Z",["RESPONDING(2)"]="R IY S P AA N D IH NG",COSMETICALLY="K AO Z M EH T IH K L IY",DRUMBEAT="D R AH M B IY T",UTAH="Y UW T AO",BLEILER="B L AY L ER",NONLITURGICAL="N AA N L AH T ER JH IH K AH L",MUJAHEDEEN="M UW JH AH HH EH D IY N",["STAKE'S"]="S T EY K S",DEMERS="D IY M ER Z",["AM(2)"]="EY EH M",BREITKREUTZ="B R AY T K R OY T S",CHONGQING="CH AO NG K IH NG",JOSTENS="JH AO S T AH N Z",SPRAYER="S P R EY ER",ACADIA="AH K EY D IY AH",MOUTHWASH="M AW TH W AA SH",HEAVYHANDED="HH EH V IY HH AE N D IH D",PLANK="P L AE NG K",BLANK="B L AE NG K",REPEATERS="R IH P IY T ER Z",FLANK="F L AE NG K",BIRCHFIELD="B ER CH F IY L D",COUNTERVAILING="K AW N T ER V EY L IH NG",EGLISE="EH G L IY S",CORIER="K AO R IY ER",GRATIFYING="G R AE T AH F AY IH NG",["EK(2)"]="IY K EY",LORUSSO="L AO R UW S OW",KRAH="K R AA",FOMENT="F OW M EH N T",WOHLFORD="W OW L F ER D",PINCHERS="P IH N CH ER Z",HAGENS="HH EY G AH N Z",["FI(2)"]="F IY",ALLYING="AE L AY IH NG",BEMIS="B IY M AH S",SUBSTANTIATES="S AH B S T AE N CH IY EY T S",SEMIS="S EH M AY Z",["VI(2)"]="V IY",REMIS="R EY M IY Z",BRAMBLETT="B R AE M B L IH T",["THACKERY'S"]="TH AE K ER IY Z",DELISE="D EH L AY Z",COOLIDGE="K UW L IH JH",["MCHARGUE(2)"]="M AH K AA R G Y UW",["CALVINIST(2)"]="K AE L V IH N IH S T",CHARRETTE="SH AH R EH T",MUSKE="M AH S K",["OP(2)"]="AO P",["MONUMENTALLY(4)"]="M AA N Y UW M EH N AH L IY",ROSSLYN="R AA S L IH N",FLEXES="F L EH K S IH Z",["TO(2)"]="T IH",NURRE="N ER",SHANK="SH AE NG K",THANK="TH AE NG K",["POTTER'S"]="P AA T ER Z",SLEDGEHAMMER="S L EH JH HH AE M ER",MOOERS="M UW ER Z",KINDERGARTNERS="K IH N D ER G AA R T N ER Z",SKIDMORE="S K IH D M AO R",ATALANTA="AE T AH L AE N T AH",SUMMAGRAPHIC="S AH M AH G R AE F IH K",["WO(2)"]="HH W OW",["VO(2)"]="V IY OW",WOZNY="W AA Z N IY",CHOOK="CH UH K",["ON(2)"]="AO N",["BURNHAM'S(2)"]="B ER N HH AE M Z",QUICKENS="K W IH K AH N Z",JIRGA="JH ER G AH",TORRENZANO="T AO R EH N Z AA N OW",["SNAKE'S"]="S N EY K S",AIRSTRIKES="EH R S T R AY K S",DOBRATZ="D AA B R AH T S",SHOOK="SH UH K",DISSIPATE="D IH S AH P EY T",MATERIALITY="M AH T IH R IY AE L IH T IY",ROOTING="R UW T IH NG",BUSKE="B AH S K",LOOTING="L UW T IH NG",FIXATION="F IH K S EY SH AH N",JACKHAMMER="JH AE K HH AE M ER",FOOTING="F UH T IH NG",BOOTING="B UW T IH NG",OBSTRUCTIONIST="AH B S T R AH K SH AH N AH S T",MCMICHEN="M AH K M IH CH AH N",FASTBALLS="F AE S T B AO L Z",REFRACTORIES="R IH F R AE K T ER IY Z",MCCAMPBELL="M AH K AE M P B AH L",RUSHFORD="R AH SH F ER D",BEGNAUD="B IH G N OW",MAGNIFIER="M AE G N AH F AY ER",["ST(2)"]="S EY N T",COLLECTING="K AH L EH K T IH NG",PHOBIAS="F OW B IY AH Z",CONATSER="K AA N AH T S ER",ZEALAND="Z IY L AH N D",EXPATRIATION="EH K S P EY T R IY EY SH AH N",["GUEVARA'S(2)"]="G AH V AA R AH Z",["MEDCHEM'S"]="M EH D K EH M Z",["OT(2)"]="OW T IY",["DETAIL(2)"]="D IY T EY L",STEEL="S T IY L",BLAH="B L AA",STRADDLING="S T R AE D L IH NG",["WS(2)"]="D AH B Y AH EH S",["VS(2)"]="V IY EH S",["DE-EXCITE"]="D IY IH K S AY T",STRICKER="S T R IH K ER",STORYTELLING="S T AO R IY T EH L IH NG",["PAY'N"]="P EY AH N",PELLEGRINO="P EH L EH G R IY N OW",DAWKINS="D AO K IH N Z",SCHWAKE="SH W EY K",JAEGAR="JH AE G ER",REZNICK="R EH Z N IH K",MUFFOLETTO="M UW F OW L EH T OW",["HIGHTOWER'S"]="HH AY T AW ER Z",["FS(2)"]="EH F EH S",SEALAND="S IY L AE N D",HAWKINS="HH AO K IH N Z",INTERTECH="IH N T ER T EH K",ROLLERBLADE="R OW L ER B L EY D",LAURE="L AO R",APPROXIMATED="AH P R AA K S AH M EY T AH D",["ELDERS'"]="EH L D ER Z",STRANGLED="S T R AE NG G AH L D",LAMARCA="L AA M AA R K AH",JASPAL="JH AE S P AA L",LUBRICANT="L UW B R AH K AH N T",ANGIOGRAM="AE N JH IY OW G R AE M",CATHERINES="K AE TH R IH N Z",["DR(2)"]="D AA K T ER",ASSEMBLIES="AH S EH M B L IY Z",STYGIAN="S T IH JH IY AH N",GYRATES="JH AY R EY T S",["OR(2)"]="ER",SAVANT="S AH V AA N T",PARENTHOOD="P EH R AH N T HH UH D",["SR(2)"]="S IH S T ER",MENSWEAR="M EH N Z W EY R",["THIRTY'S"]="TH ER D IY Z",MEDICATING="M EH D IH K EY T IH NG",["TODAY'LL(2)"]="T UW D EY L",NEWSROOMS="N UW Z R UW M Z",MCCLINTIC="M AH K L IH N T IH K",EMMIS="EH M IH S",REPEATEDLY="R IH P IY T IH D L IY",HAUKE="HH AO K",BIRKHOLZ="B ER K HH OW L Z",["AY(2)"]="AY",STUDNICKA="S T AH D N IH S K AH",COURAGE="K ER AH JH",WETSTEIN="W EH T S T IY N",NEGRI="N EH G R IY",DEMENT="D AH M EH N T",CEMENT="S AH M EH N T",TELMEX="T EH L M EH K S",MALAYSIA="M AH L EY ZH AH",WAECHTER="W EH K T ER",MUSARRA="M UW S AA R AH",BELLINO="B EH L IY N OW",BEMENT="B IY M AH N T",EXPRESSIVITY="EH K S P R AH S IH V IH T IY",["WHITTLE'S"]="W IH T AH L Z",["OW(2)"]="AW",["TONGS(2)"]="T AO NG Z",MARGA="M AA R G AH",PARGA="P AA R G AH",["TV(2)"]="T EH L AH V IH ZH AH N",CREEL="K R IY L",WARGA="W AO R G AH",FREEBORN="F R IY B ER N",FREEL="F R IY L",CONCEPTIONS="K AH N S EH P SH AH N Z",BARGA="B AA R G AH",DARGA="D AA R G AH",["WU(2)"]="D AH B AH L Y UW Y UW",PROCIDA="P R OW CH IY D AH",["SU(2)"]="EH S Y UW",["VU(2)"]="V IY Y UW",["PRELIMINARY(2)"]="P R IY L IH M AH N EH R IY",MAMMOGRAPHY="M AH M AA G R AH F IY",NASTIEST="N AE S T IY AH S T",ECEVIT="EH S AH V IH T",["DU(2)"]="D AH",YUKON="Y UW K AA N",["RU(2)"]="AA R Y UW",EXTENSIONS="IH K S T EH N SH AH N Z",ENCINO="EH N S IY N OW",TAXATION="T AE K S EY SH AH N",GLOTTIS="G L AA T AH S",NAVARRA="N AA V AA R AH",["ALDERMAN(2)"]="AE L D ER M AH N",GERVASIO="JH ER V AA S IY OW",GORGONE="G AO R G AH N",SCHULENBERG="SH UW L AH N B ER G",["CODDLING(2)"]="K AA D L IH NG",CINERGY="S IH N ER JH IY",SCHOONERS="S K UW N ER Z",MAGRI="M AE G R IY",FEASIBLE="F IY Z AH B AH L",MECKSTROTH="M EH K S T R AO TH",SCARFF="S K AA R F",CELNIK="S EH L N IH K",KONRATH="K AA N R AH TH",GUNSLINGERS="G AH N S L IH NG ER Z",SOLEIL="S OW L EY L",CONRATH="K AA N R AH TH",TARALLO="T ER AE L OW",SEDENTARY="S EH D AH N T EH R IY",["STRIKES'"]="S T R AY K S",STEGAR="S T IY G ER",HARMONICA="HH AA R M AA N IH K AH",AMERICO="AH M ER AH K OW",MOILANEN="M OY L AH N AH N",WHITELOCK="W AY T L AA K",ELLMANN="EH L M AH N",LEWISBURG="L UW IH S B ER G",ABDICATING="AE B D IH K EY T IH NG",["HUSBANDS'"]="HH AH S B AH N D Z",TORRE="T AO R",CROCODILE="K R AA K AH D AY L",ULLMANN="AH L M AH N",["LUBRICANTS(2)"]="L UW B R IH K AH N T S",CELEBATE="S EH L AH B AH T",RULERS="R UW L ER Z",["RELAXED(2)"]="R IY L AE K S T",PERRINS="P EH R IH N Z",ASTRONAUTICS="AE S T R AH N AA T IH K S",BETKE="B EH T K IY",INSTALLATION="IH N S T AH L EY SH AH N",CHICANOS="CH IH K AA N OW Z",PIPELINE="P AY P L AY N",["MATERIALS'"]="M AH T IH R IY AH L Z",HITTITE="HH IH T AY T",PROPONENTS="P R AH P OW N AH N T S",GADGETRY="G AE JH AH T R IY",PESTANA="P EH S T AE N AH",["BOARD'S"]="B AO R D Z",MAITI="M EY T IY",EFFICIENTLY="IH F IH SH AH N T L IY",["ATLANTA'S(2)"]="AE T L AE N AH Z",["INTERESTS(2)"]="IH N T R IH S T S",["CA(2)"]="S IY EY",LAMERS="L EY M ER Z",LISTENS="L IH S AH N Z",["GA(2)"]="JH IY EY",FIECHTER="F IH K T ER",SYNCHRONIZES="S IH NG K R AH N AY Z IH Z",TERRE="T EH R AH",NOVELLI="N OW V EH L IY",["CARVILLE'S"]="K AA R V IH L Z",WOZNICKI="V AH Z N IH T S K IY",PROCTER="P R AA K T ER",DISARMAMENT="D IH S AA R M AH M AH N T",PASTEURIZATION="P AE S CH ER AH Z EY SH AH N",FERRE="F EH R",HERRE="HH EH R",NEHRU="N EY R UW",APFEL="AE P F AH L",SPREADS="S P R EH D Z",HEDGLIN="HH EH JH L IH N",SHIFFER="SH IH F ER",RELAUNCH="R IY L AO N CH",CLARDY="K L AA R D IY",WESTCOTT="W EH S T K AA T",PROOFED="P R UW F T",MICROFOSSILS="M AY K R OW F AA S AH L Z",LAMOTTE="L AH M AO T",CHAMBLIN="CH AE M B L IH N",WOLVERINE="W UH L V ER IY N",MANHASSET="M AE N HH AE S EH T",TANIS="T AE N IH S",RELOCATED="R IY L OW K EY T IH D",YANIS="Y AE N AH S",KANIS="K AE N IH S",JANIS="JH AE N IH S",MANIS="M AE N IH S",UHLMANN="UW L M AH N",SCHOOL="S K UW L",PERCENTILES="P ER S EH N T AY L Z",NOAH="N OW AH",DANIS="D AA N IY Z",LITKE="L IH T K IY",AMUSINGLY="AH M Y UW Z IH NG L IY",PEIFFER="P AY F ER",["OLD-TIMER"]="OW L D T AY M ER",["ID(2)"]="AY D IY",["WHEREBY(2)"]="HH W EH R B AY",POSTPONING="P OW S T P OW N IH NG",MISSPENT="M IH S S P EH N T",BELYING="B IH L AY IH NG",SPOOFED="S P UW F T",RECEIVABLE="R IH S IY V AH B AH L",LEGALIZED="L IY G AH L AY Z D",["DE(2)"]="D EY",["WAITER'S"]="W EY T ER Z",REVOLTING="R IY V OW L T IH NG",STRAWDERMAN="S T R AO D ER M AH N",CREGAR="K R IY G ER",RELYING="R IY L AY IH NG",["MC(2)"]="EH M S IY",STRAWS="S T R AO Z",PHLEBITIS="F L AH B AY T IH S",SURMOUNTED="S ER M AW N T IH D",WEITZNER="W AY T S N ER",HALLUCINATION="HH AH L UW S AH N EY SH AH N",FLORSHEIM="F L AO R SH AY M",TEEGARDIN="T IY G AA R D IH N",EVERHART="EH V ER HH AA R T",REDIRECT="R IY D ER EH K T",["NAVRATILOVA'S"]="N AE V R AE T IH L OW V AH Z",PERLSTEIN="P ER L S T AY N",HIGNIGHT="HH IH G N AY T",DYNAMISM="D AY N AH M IH Z AH M",["GUARD'S"]="G AA R D Z",["IB(2)"]="AY B IY",RESURFACING="R IY S ER F AH S IH NG",SUPERCILIOUS="S UW P ER S IH L IY AH S",KUZNICKI="K AH Z N IH T S K IY",BALSAMO="B AA L S AA M OW",TRANSLATORS="T R AE N S L EY T ER Z",PIRATES="P AY R AH T S",MARKETED="M AA R K AH T AH D",TELEVANGELIST="T EH L AH V AE N JH AH L AH S T",REINERTSON="R AY N ER T S AH N",["HA(2)"]="EY CH EY",PELLETIER="P EH L AH T IH R",DISLODGE="D IH S L AA JH",VANDIVIER="V AE N D AY V IY ER",["APEX'S"]="EY P EH K S IH Z",NITROGEN="N AY T R AH JH AH N",CRUELLY="K R UW L IY",STAMMER="S T AE M ER",PRANK="P R AE NG K",BOOKSTOP="B UH K S T AA P",["WHITECOTTON(2)"]="HH W AY T K AA T AH N",DIRUSSO="D IH R UW S OW",["AB(2)"]="EY B IY",CRANK="K R AE NG K",DRANK="D R AE NG K",CAPPARELLI="K AA P AA R EH L IY",PRIDMORE="P R IH D M AO R",WITHROW="W IH TH R OW",PARENTHESES="P ER EH N TH AH S IY Z",ANAGNOS="AA N AA G N OW Z",["ONEX'S"]="W AH N EH K S IH Z",IRREGULARITY="IH R EH G Y AH L EH R AH T IY",["PROFESSION'S"]="P R AH F EH SH AH N Z",PAPESH="P AE P IH SH",PREVITE="P R EH V AY T",NEWORLD="N EH W ER L D",["AD-HOC"]="AE D HH AA K",["DI(2)"]="D AY",TIMERS="T AY M ER Z",SABINO="S AA B IY N OW",["NG(2)"]="IH NG",GRAMMER="G R AE M ER",KOSTMAYER="K AO S T M EY ER",DUHAMEL="D UW HH AE M AH L",KRAMMER="K R AE M ER",CURTAILING="K ER T EY L IH NG",PLAUGHER="P L AO ER",PAPPAS="P AE P AH S",BABINO="B AA B IY N OW",OYSTERS="OY S T ER Z",SPANK="S P AE NG K",ARGUMENT="AA R G Y AH M AH N T",IBMERS="IH B M ER Z",["AMEX'S"]="AE M EH K S IH Z",MONAGENE="M AA N AH JH IY N",NICETIES="N AY S IH T IY Z",PSYCHEDELIC="S AY K AH D EH L IH K",DIJON="D IY ZH AA N",BRAMMER="B R AE M ER",CRAMMER="K R AE M ER",DOMINELLI="D OW M IH N EH L IY",["SADDLING(2)"]="S AE D L IH NG",EDUCATOR="EH JH AH K EY T ER",PETROFINA="P EH T R AH F IY N AH",BANDITS="B AE N D AH T S",SHAREHOLDINGS="SH EH R HH OW L D IH NG Z",SCIPIO="S IH P IY OW",["PADDLING(2)"]="P AE D L IH NG",NONEXCLUSIVE="N AA N IH K S K L UW S IH V",MELNIK="M EH L N IH K",HORMEL="HH AO R M EH L",DEMISCH="D AH M IH SH",ROSKE="R OW S K",GRANZOW="G R AE N Z OW",FACILITATED="F AH S IH L AH T EY T IH D",["AG(2)"]="EY G IY",["DIRECTOR'S(2)"]="D ER EH K T ER Z",["NE(2)"]="N AO R TH IY S T",["JE(2)"]="JH EY IY",["ADDISON(2)"]="AE D IH S AH N",["SE(2)"]="S EY",["VE(2)"]="V IY IY",TAFEL="T AE F AH L",["RE(2)"]="R IY",LARSSON="L AA R S AH N",INFATUATION="IH N F AE CH UW EY SH AH N",MIGUEZ="M IY G EH Z",LONGHURST="L AA NG HH ER S T",["ARRESTED(2)"]="ER EH S T IH D",["YE(2)"]="Y EH",ARMISTICE="AA R M AH S T AH S",CHERICO="K ER IY K OW",JUNKIES="JH AH NG K IY Z",SEMIEN="S EH M IY N",RAPOPORT="R AH P AA P AO R T",NATIONAIR="N EY SH AH N EH R",["MARIA'S"]="M ER IY AH Z",ROSIER="R OW Z IY ER",COMPARATIVELY="K AH M P EH R AH T IH V L IY",BECHTEL="B EH K T EH L",MIDPRICE="M IH D P R AY S",JORSTAD="JH AO R S T AH D",["WHETSTONE(2)"]="HH W EH T S T OW N",HYDROPONIC="HH AY D R AH P AA N IH K",EDMONTON="EH D M AH N T AH N",SCHLACK="SH L AE K",WAYNICK="W EY N IH K",HEARTY="HH AA R T IY",["CUCKOO'S"]="K UW K UW Z",BAGUETTE="B AE G EH T",HICKORY="HH IH K ER IY",TENDERING="T EH N D ER IH NG",LIBRARIES="L AY B R EH R IY Z",WORKHORSES="W ER K HH AO R S IH Z",TURBOCHARGE="T ER B OW CH AA R JH",COGBILL="K AA G B IH L",WOEHRLE="W AO R AH L",MALICE="M AE L AH S",BRUNSON="B R AH N S AH N",CARLUCCI="K AA R L UW CH IY",["HEADQUARTERED(2)"]="HH EH D K W AO R T ER D",DOSIER="D OW S IY ER",SALMONELLA="S AE L M AH N EH L AH",KOSIER="K OW S IY ER",CICHOCKI="S IH CH AA K IY",BELLINGHAM="B EH L IH NG HH AE M",STOCKHAUSEN="S T AA K HH AW Z AH N",CHIARELLI="K IY AA R EH L IY",CASEWORKER="K EY S W ER K ER",["MARTIN'S"]="M AA R T AH N Z",KOSCHECK="K AO S CH EH K",["LUMBERMAN'S"]="L AH M B ER M AE N Z",ASHEVILLE="AE SH V IH L",WASSERMAN="W AA S ER M AH N",SIMONTON="S AY M AH N T AH N",SALVESON="S AA L V EY S AH N",ETHEL="EH TH AH L",FICHTEL="F IH CH T EH L",LEONORE="L IY AH N AO R",BARBIES="B AA R B IY Z",["SANTA-FE"]="S AE N T AH F EY",DUMMITT="D AH M IH T",CADAVER="K AH D AE V ER",OVERDOING="OW V ER D UW IH NG",BRAILSFORD="B R EY L S F ER D",ALAMILLO="AE L AH M IH L OW",NYERI="N AY ER IY",BUEHRLE="B Y UW R AH L",PANDERING="P AE N D ER IH NG",WANDERING="W AA N D ER IH NG",LOUDERMILK="L AW D ER M IH L K",EQUIVALENCY="IH K W IH V AH L AH N S IY",GORILLA="G ER IH L AH",["RESISTING(2)"]="R IY Z IH S T IH NG",BELATED="B IH L EY T IH D",HELICE="HH EH L IH S",FELICE="F AH L IY S",SUCHOCKI="S AH K AA K IY",["GUILLOTINE(2)"]="G IY Y AH T IY N",["PUNCTURES(2)"]="P AH NG K SH ER Z",JEANNIOT="JH IY N IY AH T",STENCILING="S T EH N S IH L IH NG",["SHERIFF'S(2)"]="SH EH R IH F S",RELATED="R IH L EY T IH D",["ATLANTANS(2)"]="AE T L AE N AH N Z",["ADVIL'S"]="AE D V IH L Z",CRUELTY="K R UW L T IY",SILICONE="S IH L AH K OW N",WHEELUS="W IY L AH S",DISPOSE="D IH S P OW Z",SPIRITO="S P IH R IY T OW",PFIESTERIA="F AY S T EH R IY AH",WHIPPOORWILLS="W IH P ER W IH L Z",BERKELMAN="B ER K AH L M AH N",REGESTER="R EH JH IH S T ER",["PENH'S"]="P EH N Z",OUTGROWN="AW T G R OW N",BEAUCAGE="B OW K EY JH",FARAHKAN="F AE R AH K AE N",NARAYAN="N AA R AA Y AA N",REPLENISHING="R IY P L EH N IH SH IH NG",SCHAPP="SH AE P",["OVERWHELMS(2)"]="OW V ER HH W EH L M Z",EXAGGERATES="IH G Z AE JH ER EY T S",KHALIFA="K AH L IY F AH",QUARTERBACK="K W AO R T ER B AE K",ZARRE="Z AA R",TRAITOROUS="T R EY T ER AH S",IMPALA="IH M P AA L AH",PERPETUALLY="P ER P EH CH UW AH L IY",SALPETRIERE="S AE L P EH T R IY EH R",COLLECTIVE="K AH L EH K T IH V",INTERIM="IH N T ER AH M",MIKLOS="M IY K L OW S",["RITTENHOUSE'S"]="R IH T AH N HH AW S IH Z",BARRE="B EH R IY",STURGEONS="S T ER JH AH N Z",CARRE="K AA R",BATTLESHIPS="B AE T AH L SH IH P S",LEAFY="L IY F IY",["CATERPILLER'S"]="K AE T AH P IH L ER Z",CADRONE="K AH D R OW N",TRIBUNE="T R IH B Y UW N",["CANADIANS'"]="K AH N EY D IY AH N Z",LAGOW="L AE G OW",SUMMITT="S AH M IH T",DAMPED="D AE M P T",CAMPED="K AE M P T",CAMPEAU="K AE M P OW",PLURALISTIC="P L UH R AH L IH S T IH K",TRINTEX="T R IH N T EH K S",INTREX="IH N T R AH K S",MIHALKO="M IH HH AE L K OW",ASYMPTOTES="AE S AH M T OW T S",SCHELLING="S K EH L IH NG",TELECOMMUTERS="T EH L AH K AH M Y UW T ER Z",MARKOWICZ="M AA R K AH V IH CH",BURKLOW="B ER K L AW",EMINASE="EH M IH N AA S IY",OSHEL="AA SH AH L",DOUTHETT="D AW TH IH T",["BUNGLING(2)"]="B AH NG G L IH NG",DUHON="D UW HH AH N",ATATURK="AE T AH T ER K",["REPEATS(2)"]="R IY P IY T S",PARCELLS="P AA R S AH L Z",EISCHEID="AY SH AY D",PERSALL="P ER S AH L",["PERIA'S"]="P EH R IY AH Z",OWNERS="OW N ER Z",APPIAN="AE P IY AH N",DEPAUW="D AH P AW",WEISKOPF="W AY S K AO F",BARITES="B EH R AY T S",BRUNETTE="B R UW N EH T",LINKENHOKER="L IH NG K IH N HH AH K ER",["ISALY(2)"]="AY S L IY",KIRACOFE="K IH R AH K OW F",["!EXCLAMATION-POINT"]="EH K S K L AH M EY SH AH N P OY N T",INTERGENERATIONAL="IH N T ER JH EH N ER EY SH AH N AH L",MARGERUM="M AA R G ER AH M",CONSUMER="K AH N S UW M ER",FLATULENT="F L AE CH AH L AH N T",DAMIEN="D EY M IY AH N",NEWBERN="N UW B ER N",CEDRONE="S EY D R OW N EY",STALK="S T AO K",["LEVERAGED(2)"]="L EH V ER IH JH D",["THAXTON'S"]="TH AE K S T AH N Z",SOFTIMAGE="S AO F T IH M IH JH",CULTURE="K AH L CH ER",COMPLICITY="K AH M P L IH S AH T IY",["SCHUBERT'S"]="SH UW B ER T S",INACTIVATION="IH N AE K T IH V EY SH AH N",BIOSPHERE="B AY OW S F IH R",VANDUSEN="V AE N D UW S AH N",["MCTIERNAN(2)"]="M AH K T IH R N AH N",NEWTONIAN="N UW T OW N IY AH N",POCONO="P OW K AH N OW",DASPIT="D AE S P IH T",NOVOTEL="N OW V OW T EH L",BILLINGHAM="B IH L IH NG HH AE M",FIXATES="F IH K S EY T S",CANTATA="K AE N T AA T AH",GILLINGHAM="G IH L IH NG HH AE M",["EXPLOITING(2)"]="IH K S P L OY T IH NG",DILLINGHAM="D IH L IH NG HH AE M",FILLINGHAM="F IH L IH NG HH AE M",["CRUZAN(2)"]="K R UW Z AE N",KIDNEYS="K IH D N IY Z",DIPPED="D IH P T",RIPPED="R IH P T",NIPPED="N IH P T",LIPPED="L IH P T",CHECKUPS="CH EH K AH P S",["DONNELLY(2)"]="D AA N EH L IY",RODIME="R OW D IY M",SLIWA="S L AY V AH",REISCHAUER="R AY SH AW R",PROSCAR="P R AO S K AA R",FRONTIERS="F R AH N T IH R Z",HINDERING="HH IH N D ER IH NG",RIKLIS="R IH K L IH S",HODGKINSON="HH AA JH K IH N S AH N",["CENTER'S"]="S EH N T ER Z",EPICENTER="EH P AH S EH N T ER",["VEHICLE'S"]="V IY HH IH K AH L Z",["SANTA-CROCE(2)"]="S AE N AH K R OW CH IY",GUCCIARDO="G UW CH AA R D OW",KIEVIT="K IY V IH T",GODBOLT="G AA D B OW L T",REDISTRIBUTING="R IY D IH S T R IH B Y UW T IH NG",LACORTE="L AA K AO R T IY",BOOKIES="B UH K IY Z",INDIRECT="IH N D ER EH K T",SHIMON="SH IY M OW N",["WHITWAM(2)"]="HH W IH T W AA M",MAZURKIEWICZ="M AH Z ER K AH V IH CH",FEDORKO="F IH D AO R K OW",CIRCUMSCRIBE="S ER K AH M S K R AY B",LOCHRIDGE="L AA K R IH JH",ROOKIES="R UH K IY Z",TEPOZTLAN="T IH P AO S T L AH N",["BESCHLOSS'S"]="B EH SH L AO S IH S",["UY(2)"]="Y UW W AY",INDONESIA="IH N D OW N IY ZH AH",["WY(2)"]="D AH B AH L Y UW W AY",TANGREDI="T AA NG G R EH D IY",MENASION="M EH N AE S IY AH N",SIPPED="S IH P T",TIPPED="T IH P T",TREESH="T R IY SH",PROPORTIONAL="P R AH P AO R SH AH N AH L",["MARDI-GRAS"]="M AA R D IY G R AA",SIMIEN="S IH M IY N",ANANDEEP="AA N AA N D IY P",["N'DOUR"]="N D AW R",SPIEL="S P IY L",["AMERICANS'"]="AH M EH R IH K AH N Z",DELBUONO="D EH L B W OW N OW",MEDIOCRITY="M IY D IY AA K R AH T IY",SMOKEJUMPERS="S M OW K JH AH M P ER Z",OVERPAYMENTS="OW V ER P EY M AH N T S",HERBAL="ER B AH L",BELSHE="B EH L SH",DEDICATING="D EH D IH K EY T IH NG",["COAST'S"]="K OW S T S",ANAESTHESIA="AE N AH S TH IY ZH AH",QUANTUM="K W AA N T AH M",["KANTER'S"]="K AE N T ER Z",ORIELDA="AO R IY L D AH",ENCYCLOPEDIAS="IH N S AY K L AH P IY D IY AH Z",GOLLUST="G OW L AH S T",ANOREXICS="AE N ER EH K S IH K S",LEAGUERS="L IY G ER Z",HAYWIRE="HH EY W AY R",ENTHUSIASTS="EH N TH UW Z IY AE S T S",MODGLIN="M AA JH L IH N",HOJNACKI="HH AH Y N AA T S K IY",OBERSTAR="OW B ER S T AA R",["ADISQ(2)"]="EY D IH S K",NEATNESS="N IY T N AH S",METHOD="M EH TH AH D",ADOPTED="AH D AA P T AH D",["AEROSPATIALE'S"]="EH R OW S P AA S IY AA L Z",SCHRECKENGOST="SH R EH K IH NG G AH S T",ENVIROTEST="IH N V AY R OW T EH S T",["ROSEWOOD'S"]="R OW Z W UH D Z",LINDH="L IH N D",EDICTS="IY D IH K T S",REASSIGNMENTS="R IY AH S AY N M AH N T S",BEHAVIORALLY="B IY HH EY V Y ER AH L IY",ELLIOS="EH L Y OW S",PENDYALA="P EH D Y AA L AH",ERICKA="EH R IH K AH",LAMMEY="L AE M IY",VERBAL="V ER B AH L",TENEYCK="T EH N IY K",WERTHEIM="W ER T HH AY M",MANASION="M AE N AH SH AH N",SHAPES="SH EY P S",MACKOWIAK="M AH S K AW IY AE K",KEYWORD="K IY W ER D",["INTERVIEWEES(2)"]="IH N ER V Y UW IY Z",JANISCH="JH AE N IH SH",ADVERTORIAL="AE D V ER T AO R IY AH L",BALTICA="B AE L T IH K AH",PAIVA="P EY V AH",SUKRU="S UH K R UW",MCKEON="M AH K IY AH N",HANISCH="HH AE N IH SH",DAMACLEAN="D AE M AH K L IY N",GRAPES="G R EY P S",PONDERING="P AA N D ER IH NG",SCRUPULOUS="S K R UW P Y AH L AH S",RAPTUROUS="R AE P CH ER AH S",ACCIDENTALLY="AE K S AH D EH N T AH L IY",SPARLING="S P AA R L IH NG",PORTEOUS="P AO R T IY IH S",SCHNORR="SH N AO R",BUSIER="B IH Z IY ER",WHITTINGHILL="W IH T IH NG HH IH L",RAMERIZ="R AA M EH R IY Z",HEIWA="HH AY W AH",DOUGHTIE="D AO T IY",RABALAIS="R AE B AH L EY",LYMPHOMAS="L IH M F OW M AH Z",KOPKE="K OW P K",INTERACT="IH N T ER AE K T",HOPKE="HH OW P K",STACCATO="S T AH K AA T OW",BURPEE="B ER P IY",TOPPED="T AA P T",QUATTLEBAUM="K W AO T AH L B AW M",KALLIS="K AE L IH S",MALLIS="M AE L IH S",DIABASIC="D AY AH B EY S IH K",MOHON="M OW HH AH N",CALLIS="K AE L IH S",["LABORATORIES'"]="L AE B R AH T AO R IY Z",["CHINOOKS(2)"]="SH IH N UH K S",WALLIS="W AO L IH S",VALLIS="V AE L IH S",GNARLING="N AA R L IH NG",SIDEBARS="S AY D B AA R Z",THICKENS="TH IH K AH N Z",MCFAUL="M AH K F AO L",SALLIS="S AE L IH S",RALLIS="R AE L IH S",SNARLING="S N AA R L IH NG",STEINHORST="S T AY N HH AO R S T",CONTINUATION="K AH N T IH N Y UW EY SH AH N",CIANCIO="CH AO N CH IY OW",["WHALE(2)"]="HH W EY L",CHICKENS="CH IH K AH N Z",MCCONNAUGHEY="M AH K AA N AH G EY",TULLOS="T AH L OW Z",RESELLER="R IY S EH L ER",SAVINGS="S EY V IH NG Z",["ARMTEK'S"]="AA R M T EH K S",["CHARLOTTE'S"]="SH AA R L AH T S",MUMMEY="M AH M IY",STARLING="S T AA R L IH NG",PREEXISTING="P R IY IH G Z IH S T IH NG",BLINDSIDE="B L AY N D S AY D",ANTEATER="AE N T IY T ER",WACHTEL="W AO CH AH L",OLAYAN="OW L AY AH N",["DILLARD'S(2)"]="D IH L AA R D Z",GRATUITOUSLY="G R AH T UW AH T AH S L IY",BALANCHINE="B AE L AH N CH IY N",PIZZINO="P IY T S IY N OW",DEJARNETT="D IH JH AA R N IH T",BAROMETERS="B ER AA M IH T ER Z",HACHTEL="HH AE K T AH L",["AKER(2)"]="EY K ER",BACHTEL="B AE K T AH L",YACONO="Y AE K AH N OW",CHOON="CH UW N",BIDDABLE="B IH D AH B AH L",NEGOTIATING="N IH G OW SH IY EY T IH NG",MISCALCULATED="M IH S K AE L K Y AH L EY T IH D",FULOP="F UW L AH P",["METALLICA'S"]="M AH T AE L IH K AH Z",THEILER="TH AY L ER",["MACPHERSON'S"]="M AH K F ER S AH N Z",IODIDES="AY AH D AY D Z",["WESTWOOD'S"]="W EH S T W UH D Z",STATESMEN="S T EY T S M IH N",SCHULTHEISS="SH AH L TH AY S",TELEPHONICS="T EH L AH F AA N IH K S",MILLENNIUMS="M AH L EH N IY AH M Z",MOPPED="M AA P T",STUDDS="S T AH D Z",RADATZ="R AE D AH T S",MCWHIRT="M AH K W ER T",LOPPED="L AA P T",PLEXUS="P L EH K S AH S",HOPPED="HH AA P T",COPPED="K AA P T",THREATT="TH R IY T",BELABOR="B IH L EY B ER",MARAUDERS="M ER AO D ER Z",BALKANIZE="B AO L K AH N AY Z",YEKATERINBURG="Y EH K AE T ER IY N B AH R G",ENTHRALLED="EH N TH R AO L D",PACIFICARE="P AH S IH F IH K EH R",PERPETUATION="P ER P EH CH AH W EY SH AH N",REDBIRD="R EH D B ER D",HAMMITT="HH AE M IH T",THIEL="TH IY L",SHIEL="SH IY L",WEINTRAUB="W AY N T R AW B",SPIRAL="S P AY R AH L",DEXTROUS="D EH K S T R AH S",DISMANTLED="D IH S M AE N T AH L D",["SHAVELSON(2)"]="SH AE V AH L S IH N",RECORDKEEPING="R EH K ER D K IY P IH NG",ESCH="EH SH",LIVINGS="L IH V IH NG Z",CORRELATION="K AO R AH L EY SH AH N",ISCH="IH SH",["UKRAINE'S"]="Y UW K R EY N Z",["EXPANSIONARY(2)"]="IH K S P AE N CH AH N EH R IY",WASHOUT="W AA SH AW T",DOWIS="D AW IH S",INHERITING="IH N HH EH R AH T IH NG",TARBOX="T AA R B AA K S",ASCH="AE SH",ETCH="EH CH",ITCH="IH CH",["SHIP'S"]="SH IH P S",SELVIDGE="S EH L V IH JH",CHANDLEY="CH AE N D L IY",TUCH="T AH CH",BEGGAR="B EH G ER",SHIVA="SH IY V AH",BUEHRER="B Y UW HH ER",["CHIP'S"]="CH IH P S",SIZZLED="S IH Z AH L D",["EDITION(2)"]="IH D IH SH AH N",URINATE="Y ER AH N EY T",QUILLMAN="K W IY L M AE N",SYNERGY="S IH N ER JH IY",SAMMUT="S AE M AH T",UNDERBELLY="AH N D ER B EH L IY",FARQUAR="F AA R K W AA R",CHEWED="CH UW D",["SHANGHAI'S"]="SH AE NG HH AY Z",STECKELBERG="S T EH K AH L B ER G",COPIER="K AA P IY ER",STILLMAN="S T IH L M AH N",MONTAGNE="M AH N T EY N Y",RICHINS="R IH K IH N Z",RIESLING="R IY Z L IH NG",DEMOCRACIES="D IH M AA K R AH S IY Z",ABERCROMBIE="AE B ER K R AA M B IY",SMARTENED="S M AA R T AH N D",ECONOMY="IH K AA N AH M IY",EMPATHETIC="EH M P AH TH EH T IH K",DIVERSICARE="D IH V ER S IH K EH R",DROUIN="D R W IY N",UNDERGONE="AH N D ER G AO N",KIESLING="K IY Z L IH NG",HUGEL="HH UW G AH L",KUGEL="K UW G AH L",IRIMAJIRI="AY R IY M AH JH IH R IY",["STAFFORDSHIRE'S"]="S T AE F ER D SH ER Z",WINEBERG="W AY N B ER G",DARKIE="D AA R K IY",["LIFETIME'S"]="L AY F T AY M Z",ARTISTICALLY="AA R T IH S T IH K L IY",["BEARS'"]="B EH R Z",EDIVA="EH D IY V AH",["LAOS(3)"]="L EY OW S",RAPTORIAL="R AE P T AO R IY AH L",FINEBERG="F AY N B ER G",["SEARS'"]="S IH R Z",GLADSON="G L AE D S AH N",IMITABLE="IH M AH T AH B AH L",REUNITE="R IY UW N AY T",DICOMED="D IH K AH M EH D",["GOODRICH'S"]="G UH D R IH CH IH Z",["YEARS'"]="Y IH R Z",COMPARTMENTALIZED="K AA M P AA R T M EH N T AH L AY Z D",PLAGIARIZED="P L EY JH ER AY Z D",CLABORN="K L AE B ER N",BARKLOW="B AA R K L OW",SCHNEPF="SH N EH P F",HAGGAR="HH AE G ER",RELATIVE="R EH L AH T IH V",RESPONDS="R IH S P AA N D Z",GUGEL="G UW G AH L",DUCH="D AH CH",RECREATIONAL="R EH K R IY EY SH AH N AH L",HUCH="HH AH CH",KUCH="K AH CH",MUCH="M AH CH",["HUSSEINI(2)"]="HH UW S EY N IY",OUCH="AW CH",RUCH="R AH CH",SUCH="S AH CH",ASTERISK="AE S T ER IH S K",BIWEEKLY="B AY W IY K L IY",["GUZMAN(2)"]="G UW Z M AA N",["HUTCHISON'S"]="HH AH CH IH S AH N Z",AUCH="AO CH",BUCH="B AH CH",HANJIN="HH AE N JH IH N",ORION="OW R AY AH N",SNIPPET="S N IH P AH T",GALLOS="G AE L OW Z",GARRAHAN="G AE R AH HH AE N",POWIS="P AW IH S",["STEINBERG'S"]="S T AY N B ER G Z",LEIVA="L IY V AH",SCHILZ="SH IH L Z",BRION="B R AY AH N",ERION="EH R IY AO N",VALERY="V AE L ER IY",MIRILLA="M IH R IH L AH",PUNCTURED="P AH NG K CH ER D",LINCICOME="L IH N S IH K OW M",["ACCOUNTABLE(2)"]="AH K AW N AH B AH L",ROYSTON="R OY S T AH N",STROLLO="S T R AA L OW",LISANTI="L IH S AE N T IY",SAPPED="S AE P T",TAPPED="T AE P T",RAPPED="R AE P T",MAPPED="M AE P T",NAPPED="N AE P T",REWRITING="R IY R AY T IH NG",LAPPED="L AE P T",ULCH="AH L CH",EMBOLISMS="EH M B OW L IH Z AH M Z",LEYBA="L EY B AH",SODITIC="S OW D IH T IH K",HEFFRON="HH EH F R AH N",REWIS="R UW IH S",DUCOMMUN="D UW K AA M AH N",MODULATION="M AA JH AH L EY SH AH N",LEWIS="L UW IH S",IXION="IH K S AY AH N",ABELN="AE B IH L N",SPIVA="S P IY V AH",PIRAEUS="P AH R EY AH S",DISANTI="D IH S AE N T IY",RIUNITE="R IY UW N AY T",SCHONBERG="SH AA N B ER G",["OKSANA'S"]="AA K S AE N AH Z",LIZOTTE="L IH Z AO T",TRAFFICKERS="T R AE F IH K ER Z",PLIERS="P L AY ER Z",ABYSS="AH B IH S",READINGER="R EH D IH NG ER",PREDATES="P R IY D EY T S",TRANSAMERICAN="T R AE N Z AH M EH R IH K AH N",MARKIE="M AA R K IY",REDUCED="R AH D UW S T",SEDUCED="S IH D UW S T",ZAPPED="Z AE P T",WOODSTOCK="W UH D S T AA K",NIECE="N IY S",BETAMAX="B EY T AH M AE K S",PIECE="P IY S",DEDUCED="D IH D UW S T",POLLUTED="P AH L UW T AH D",EXAMINED="IH G Z AE M AH N D",SKIERS="S K IY ER Z",CONFINES="K AA N F AY N Z",DEBRUYN="D EH B R AY N",CLOTHIER="K L OW DH Y ER",SCHNARR="SH N AE R",["FORSEEABLE(2)"]="F ER S IY AH B AH L",BRONWYN="B R AA N W IH N",SCHUETTE="S K UW T",EMBRYO="EH M B R IY OW",["SHACKLETON'S"]="SH AE K AH L T AH N Z",COPYREADER="K AA P IY R IY D ER",CATTANACH="K AE T AH N AE CH",COPYWRITERS="K AA P IY R AY T ER Z",SNIFFLING="S N IH F L IH NG",REINSTALL="R IY IH N S T AA L",REDISTRIBUTIVE="R IY D IH S T R IH B Y UW T IH V",KIWIS="K IY W IY Z",DAFFRON="D AE F R AH N",FLIERS="F L AY ER Z",SCHAEFERS="SH EY F ER Z",CHRISTMANN="K R IH S T M AH N",HAWKE="HH AO K",["STERNNESS(2)"]="S T ER N AH S",PUZZLED="P AH Z AH L D",BLOUIN="B L W IY N",DUPUIS="D AH P W IY",BIGGAR="B IH G ER",MUZZLED="M AH Z AH L D",SLIVA="S L IY V AH",BARSTAD="B AA R S T AH D",LEZOTTE="L IH Z AO T",FASHIONABLE="F AE SH AH N AH B AH L",["DETRIMENTAL(2)"]="D EH T R AH M EH N AH L",HARSTAD="HH AA R S T AH D",FLICEK="F L IH CH EH K",EMCH="EH M CH",DEPOSITORS="D AH P AA Z IH T ER Z",ECOSYSTEMS="IY K OW S IH S T AH M Z",SPIERS="S P AY ER Z",GUION="G W IY AO N",BACKPEDAL="B AE K P EH D AH L",FREITAG="F R AY T AH G",YOUNGS="Y AH NG Z",KEESLING="K IY Z L IH NG",["RESIGNING(3)"]="R IY S AY N IH NG",WIDENING="W AY D AH N IH NG",["KWOK-SHING"]="K W AO K SH IH NG",["SUNBEAM'S"]="S AH N B IY M Z",WHITTET="W IH T IH T",UNIVA="Y UW N IH V AH",SMETHERS="S M EH DH ER Z",CARILLA="K AA R IH L AH",PROVIDES="P R AH V AY D Z",["LIBERALS(2)"]="L IH B R AH L Z",YEAH="Y AE",AMERI="AH M EH R IY",MARILLA="M AA R IH L AH",REVOIR="R IH V W AA R",ADAH="AE D AA",KONOP="K OW N AH P",LASZLO="L AE Z L OW",WHITENACK="W AY T N AE K",["JOHNS'S"]="JH AA N Z IH Z",INCIDENTALLY="IH N S IH D EH N T AH L IY",MININGER="M AY N IH NG ER",CORDOBAS="K AO R D OW B AH Z",LININGER="L AY N IH NG ER",MARCHESANO="M AA R K EH S AA N OW",MAHON="M EY AH N",DUGGAR="D AH G ER",REFLAG="R IY F L AE G",ELMSFORD="EH L M Z F ER D",ENTITLEMENTS="EH N T AY T AH L M AH N T S",SHAMUS="SH EY M AH S",KIMMITT="K IH M IH T",WININGER="W AY N IH NG ER",PHILIBOSIAN="F IH L IH B OW Z IY AH N",EQUITEC="EH K W AH T EH K",NONTRANSFERABLE="N AA N T R AE N S F ER AH B AH L",SPIGOTS="S P IH G AH T S",LEALA="L IY L AH",KETCHERSIDE="K EH CH ER S AY D",MARIER="M EH R IY ER",["OLMSTEAD'S"]="OW L M S T EH D Z",REINERT="R AY N ER T",["INFORMATION'S(2)"]="IH N F AO R M EY SH AH N Z",BRUTALLY="B R UW T AH L IY",WEINERT="W AY N ER T",["FLUOR'S"]="F L UW ER Z",MEINERT="M AY N ER T",JANCZAK="Y AE N CH AE K",TOCQUEVILLE="T OW K V IH L",RUSTIEST="R AH S T IY AH S T",SEAMUS="SH EY M AH S",HOSPICES="HH AA S P AH S IH Z",["FININVEST'S"]="F IH N IH N V EH S T S",NICKLESS="N IH K L AH S",ISENBERG="AY Z AH N B ER G",PASTRANA="P AA S T R AE N AH",JOINT="JH OY N T",POINT="P OY N T",LAPIDARY="L AE P AH D EH R IY",["ALTHORP(2)"]="AA L TH AO R P",["TEXAS'S"]="T EH K S AH S AH Z",BRANNUM="B R AE N AH M",OVERTAX="OW V ER T AE K S",MAGGOTS="M AE G AH T S",NILSSON="N IH L S AH N",STOTTLEMYER="S T AA T AH L M AY ER",RAFTING="R AE F T IH NG",POCH="P AA K",MOCH="M AA K",STENBERG="S T EH N B ER G",LOCH="L AA K",WIRELINE="W AY R L AY N",NIVENS="N AY V AH N Z",BIERI="B IH R IY",MOHEL="M OW AH L",TENPAS="T EH N P AH Z",GIVENS="G IH V AH N Z",FAZZINO="F AA T S IY N OW",LEFTIES="L EH F T IY Z",BIVENS="B AY V AH N Z",INTERPLAY="IH N T ER P L EY",DIVENS="D AY V AH N Z",DELGUIDICE="D EH L G AY D IH S",PATUXETS="P AH T AH K S AH T S",WILKENING="W IH L K AH N IH NG",SCHMEISER="SH M AY S ER",["DECLERQUE'S"]="D AH K L ER K S",["REFINANCES(2)"]="R IY F AY N AE N S IH Z",BAUMEL="B AW M AH L",MAYFIELD="M EY F IY L D",MATRANGA="M AA T R AA NG G AH",HAYFIELD="HH EY F IY L D",GAUNTT="G AO N T",RAYFIELD="R EY F IY L D",[")END-THE-PAREN"]="EH N D DH AH P ER EH N",SALVADORE="S AA L V AA D AO R EY",HOAGLIN="HH OW G L IH N",KROLCZYK="K R OW L CH IH K",KLINT="K L IH N T",GLINT="G L IH N T",NONOPERATING="N AA N AO P ER EY T IH NG",FLINT="F L IH N T",CORNETTE="K ER N EH T",CONERY="K OW N ER IY",CORTESI="K ER T EH S IY",["CHILDREN'S"]="CH IH L D R AH N Z",ORNERY="AO R N ER IY",INCH="IH N CH",["IDAHO'S"]="AY D AH HH OW Z",CAROLLO="K ER AA L OW",["NUMERICAL(2)"]="N UW M EH R IH K AH L",SCHON="SH AA N",MAXIS="M AE K S IY Z",AMERICANAS="AH M EH R AH K AE N AH Z",ZOCH="Z AA K",ROCH="R AA K",LEVENS="L IY V AH N Z",GROSZ="G R OW S",LINNIK="L IH N IH K",SEVENS="S EH V AH N Z",SCHIAVI="S K IY AA V IY",OROSZ="AO R AH SH",GARNETTE="G AA R N EH T",LOOPED="L UW P T",METALLO="M EH T AA L OW",YIPPEE="Y IH P IY",LADINO="L AH D IY N OW",["KEYPAD'S"]="K IY P AE D Z",UNDERREPORTING="AH N D ER R IH P AO R T IH NG",BEVENS="B IY V AH N Z",COOPED="K UW P T",DEVENS="D IY V AH N Z",RIPPEE="R IH P IY",BROSZ="B R AA SH",HELIOS="HH IY L IY AA S",KEMERY="K EH M ER IY",LEMERY="L EH M ER IY",QUINT="K W IH N T",PAWLOWICZ="P AA V L AH V IH CH",EXECUTORS="IH G Z EH K Y AH T ER Z",MISSISSIPPIANS="M IH S IH S IH P IY AH N Z",GROPED="G R OW P T",GOODWIN="G UH D W IH N",ETHELDA="IH TH EH L D AH",["EMPLOYER(2)"]="IH M P L OY ER",BARNETTE="B AA R N EH T",ATTLEBORO="AE T AH L B ER OW",DELELLIS="D EH L IH L IH S",NIHON="N IH HH AA N",KITZMILLER="K IH T S M IH L ER",FORRESTAL="F AO R AH S T AH L",SHERI="SH EH R IY",PUBERTY="P Y UW B ER T IY",THEATRICS="TH IY T R IH K S",OCCIDENTALE="AA K S IH D EH N T AH L",["KEYSTONE'S"]="K IY S T OW N Z",FILIPIAK="F IH L IH P IY AE K",TABULATION="T AE B Y AH L EY SH AH N",MATHISON="M AE TH IH S AH N",MONINGER="M OW N IH NG ER",["GROUNDWATER(2)"]="G R AW N D W AO T ER",OBERHAUS="OW B ER HH AW S",UNION="Y UW N Y AH N",CARWILE="K AA R W AY L",SKETCHES="S K EH CH AH Z",BRUNELLI="B R UW N EH L IY",TOPOGRAPHIC="T AA P AH G R AE F IH K",NEUZIL="N UW Z AH L",PIERI="P IY R IY",CADENHEAD="K EY D AH N HH EH D",LIFTING="L IH F T IH NG",PRINT="P R IH N T",SWEZEY="S W EH Z IY",RAVENS="R EY V AH N Z",MAVENS="M EY V AH N Z",SIFTING="S IH F T IH NG",SHORR="SH AO R",WALTHAM="W AO L TH AH M",LUIKART="L UW K AA R T",HAVENS="HH EY V AH N Z",FRANCINES="F R AE N S IY N Z",GIFTING="G IH F T IH NG",WERNETTE="W ER N EH T",KURILLA="K ER IH L AH",ZACCAGNINO="Z AA K AH G N IY N OW",SHAH="SH AA",KIMERY="K IH M ER IY",LACHNEY="L AE K N IY",HUBERTY="HH AH B ER T IY",GOOSTREE="G UW S T R IY",GLASGOW="G L AE S K OW",ASUNCION="AH S AH N SH AH N",KNORR="N AO R",OUTBOARD="AW T B AO R D",DROMEDARY="D R AA M AH D EH R IY",STINT="S T IH N T",REFINISHING="R IY F IH N IH SH IH NG",MUNICIPALITY="M Y UW N IH S AH P AE L AH T IY",OTERI="OW T EH R IY",MORESCO="M AO R EH S K OW",["WHORLEY(3)"]="HH W AO R L IY",["BUTHELEZI'S"]="B UW T AH L EY Z IY Z",RECONSTITUTE="R IY K AA N S T AH T UW T",PURGED="P ER JH D",FECKLESS="F EH K L IH S",SHANKAR="SH AE NG K AA R",POLYANDROUS="P AA L IY AE N D R AH S",ORLEANS="AO R L IY AH N Z",RECKLESS="R EH K L AH S",HAITIANS="HH EY SH AH N Z",OCALA="OW K AE L AH",STAIRWELL="S T EH R W EH L",BLONDEST="B L AA N D AH S T",["SUBSTANTIATED(2)"]="S AH B S T AE N CH IY EY T IH D",JESSYE="JH EH S IY",MACRAME="M AE K R AH M EY",["BERKSHIRES(2)"]="B ER K SH AY R Z",SERRATO="S ER AA T OW",SCHWIND="SH W IH N D",ALVARO="AH L V AA R OW",MERISEL="M EH R IH S EH L",QUOTIENT="K W OW SH AH N T",MATLOCK="M AE T L AA K",CERRATO="CH ER AA T OW",INDISPENSIBLE="IH N D IH S P EH N S IH B AH L",BAZAARS="B AH Z AA R Z",TATLOCK="T AE T L AA K",MACMULLEN="M AH K M AH L AH N",COARSER="K AO R S ER",UMBEL="AH M B AH L",LYKINS="L IH K AH N Z",OTHERS="AH DH ER Z",ENMITIES="EH N M AH T IY Z",ETHERS="IY TH ER Z",REFSNES="R EH F S N IY Z",OCCUPIERS="AA K Y AH P AY ER Z",NORDLUND="N AO R D L AH N D",SWOPES="S W OW P S",USHERS="AH SH ER Z",LOWDERMILK="L OW D ER M IH L K",LAMBORGHINI="L AE M B ER G IY N IY",DOCUMENTED="D AA K Y AH M EH N T AH D",SCHIER="SH AY ER",GOBEL="G OW B AH L",FOBEL="F OW B AH L",SCHALLOCK="SH AE L AH K",NOBEL="N OW B EH L",LOBEL="L OW B AH L",SOBEL="S OW B AH L",ROBEL="R OW B AH L",["PIANOS(2)"]="P IY AE N AH Z",NUALA="N UW AA L AH",KUALA="K W AA L AH",LONON="L OW N AH N",FOSAMAX="F AA S AH M AE K S",PINKELMAN="P IH NG K AH L M AH N",TORMEY="T AO R M IY",UTERUS="Y UW T ER AH S",WINKELMAN="W IH NG K AH L M AH N",FORBUS="F AO R B IH S",UTTERING="AH T ER IH NG",["JULIA'S"]="JH UW L Y AH Z",STRONGHOLDS="S T R AO NG HH OW L D Z",JABBAR="JH AH B AA R",DAMNS="D AE M Z",BLOOMBERG="B L UW M B ER G",BAYBANKS="B EY B AE NG K S",PROSPECTUSES="P R AH S P EH K T AH S IH Z",["HANNA'S"]="HH AE N AH Z",COCCIA="K OW CH AH",BOCCIA="B OW CH AH",LUCIDITY="L UW S IH D IH T IY",STATTIN="S T AE T IH N",MONOPOLIES="M AH N AA P AH L IY Z",CRUCIAL="K R UW SH AH L",["ROISTER'S"]="R OY S T ER Z",MILTIE="M IH T IY",EDITORIAL="EH D AH T AO R IY AH L",CHEERIOS="CH IH R IY OW S",CHAMBERS="CH EY M B ER Z",SORBUS="S AO R B AH S",MOCCIA="M OW CH AH",["PROBLEM'S"]="P R AA B L AH M Z",LUKINS="L UW K IH N Z",["CATALOGS(2)"]="K AE T AH L AO G Z",RATTERMAN="R AE T ER M AH N",ASKINS="AH S K IH N Z",ARBEL="AA R B AH L",STONEBERG="S T OW N B ER G",DIMARIA="D IH M AA R IY AH",REEXPORT="R IY EH K S P AO R T",DOMECQ="D OW M EH K",LAMATTINA="L AA M AA T IY N AH",TOUSSAINT="T UW S AE N",RASPED="R AE S P T",SCHAUBLE="SH OW B AH L",COLTIE="K OW L T IY",REAFFIRMING="R IY AH F ER M IH NG",DEPRENYL="D EH P R AH N IH L",SUPPOSE="S AH P OW Z",MASLYUKOV="M AE S L Y UW K AA V",GOOSEFISH="G UW S F IH SH",BATTERMAN="B AE T ER M AH N",PHOSPHATES="F AA S F EY T S",FINKELMAN="F IH NG K AH L M AH N",HINKELMAN="HH IH NG K AH L M AH N",HARTENSTEIN="HH AA R T AH N S T AY N",["SOLIMAN'S"]="S AA L IH M AH N Z",AYALA="AH Y AA L AH",STOGA="S T OW G AH",["ENDOCRINOLOGIST'S"]="EH N D OW K R AH N AA L AH JH AH S T S",GISMONDI="JH IY S M OW N D IY",["INTEREST(3)"]="IH N T ER AH S T",KNOGO="N OW G OW",AGRICULTURALLY="AE G R IH K AH L CH ER AH L IY",MESQUITE="M EH S K IY T",STALLONE="S T AH L OW N",PILLAGERS="P IH L IH JH ER Z",AVALLONE="AE V AH L OW N",ACCESSORY="AE K S EH S ER IY",STATUETTES="S T AE CH UW EH T S",BAKKE="B AE K",POTENTATES="P OW T AH N T EY T S",IMPRISONS="IH M P R IH Z AH N Z",BUNTING="B AH N T IH NG",KOALA="K OW AA L AH",GROUNDSKEEPERS="G R AW N D S K IY P ER Z",SCULPT="S K AH L P T",PEOPLE="P IY P AH L",EYNON="EY N AH N",SNOOKER="S N UH K ER",["FRANCE'S"]="F R AE N S IH Z",RICHESIN="R IH K IH S IH N",CORONARY="K AO R AH N EH R IY",["ESTABLISHMENT'S(2)"]="IY S T AE B L IH SH M AH N T S",["AZERBAIJANI(2)"]="AE Z ER B AY JH AA N IY",BELLEVILLE="B AH L V IH L",TROISE="T R OY Z",LIGHTLY="L AY T L IY",HERMAPHRODITE="HH ER M AE F R AH D AY T",GIACOBBE="JH AA K OW B IY",PONZI="P AA N Z IY",SPUNKY="S P AH NG K IY",KONZI="K AA N Z IY",["JEWELERS(2)"]="JH UW L ER Z",BOSHEARS="B AA SH IH R Z",NIGHTLY="N AY T L IY",["PLOTTED(2)"]="P L AA T IH D",RIGHTLY="R AY T L IY",TIGHTLY="T AY T L IY",["EVAPORATES(2)"]="IY V AE P ER EY T S",HANSSON="HH AE N S AH N",JANSSON="JH AE N S AH N",REDDINGER="R EH D IH NG ER",INTERMARKET="IH N T ER M AA R K IH T",FULFILL="F UH L F IH L",PREMIUMS="P R IY M IY AH M Z",["FANTASYLAND(2)"]="F AE N AH S IY L AE N D",CUTRELL="K AH T R AH L",HERTENSTEIN="HH ER T AH N S T AY N",FUTRELL="F Y UW T R EH L",HEADLINERS="HH EH D L AY N ER Z",GABRYS="G AE B ER IY Z",["REALLY(2)"]="R IY L IY",COOKMAN="K UH K M AH N",BOOKMAN="B UH K M AH N",PIZZAS="P IY T S AH Z",SPALLONE="S P AE L OW N",["POSTCARD(2)"]="P OW S K AA R D",TRIMESTER="T R AY M EH S T ER",MCCORVEY="M AH K AO R V IY",["LANGUAGE(2)"]="L AE NG G W IH JH",MILICI="M IY L IY CH IY",MENZE="M EH N Z",EXPANSIONARY="IH K S P AE N SH AH N EH R IY",HENZE="HH EH N Z",["TOWERS'"]="T AW ER Z",["POWERS'"]="P AW ER Z",COMPLIMENTED="K AA M P L AH M EH N T IH D",CLUNKY="K L AH NG K IY",IMPLEMENTATION="IH M P L AH M EH N T EY SH AH N",OLEKSY="AH L EH K S IY",SKOWRONEK="S K AW R OW N EH K",MANOOGIAN="M AH N UW JH IY AH N",NATURALIZED="N AE CH ER AH L AY Z D",TETRAHEDRON="T EH T R AH HH IY D R AH N",ASCLAD="AE S K L AE D",DISTURBINGLY="D IH S T ER B IH NG L IY",BIDDINGER="B IH D IH NG ER",ENTERING="EH N T ER IH NG",DISSOCIATE="D IH S OW S IY EY T",["CURATOR(2)"]="K Y UH R AH T ER",TORMENTA="T AO R M EH N T AH",MORASS="M ER AE S",COLLOQUY="K AA L AH K W IY",KALTENBACHER="K AA L T AH N B AA K ER",MURRIN="M AO R IH N",TYPEWRITTEN="T AY P R IH T AH N",RAISBECK="R EY Z B EH K",CREATIVE="K R IY EY T IH V",CHAPPELL="CH AE P AH L",ZWICKY="Z W IH K IY",MCELREATH="M AE K AH L R AE TH",ROARTY="R AO R T IY",OFFERINGS="AO F ER IH NG Z",["ALFIN'S"]="AE L F IH N Z",TEMPTED="T EH M P T AH D",SHAPPELL="SH AE P AH L",SHORTLY="SH AO R T L IY",INFRINGEMENT="IH N F R IH N JH M AH N T",BATTALION="B AH T AE L Y AH N",HARASS="HH ER AE S",["LOCKE-OBER"]="L AA K OW B ER",MITERING="M AY T ER IH NG",["SPECTER'S"]="S P EH K T ER Z",OXALIS="AA K S AH L AH S",TRAPASSO="T R AA P AA S OW",CHORD="K AO R D",SYMBOLICALLY="S IH M B AA L IH K AH L IY",KUMARATUNGA="K UW M AA R AH T AH N G AH",["NIKKEI'S"]="N IY K EY Z",VENTURE="V EH N CH ER",POTAPOV="P AA T AH P AA V",["TOPEKA'S"]="T AH P IY K AH Z",["SCHOOLS'"]="S K UW L Z",["SEGMENT'S"]="S EH G M AH N T S",RECONSIDERING="R IY K AH N S IH D ER IH NG",REDENIUS="R EH D IY N IY IH S",DEADLOCKED="D EH D L AA K T",PURVIEW="P ER V Y UW",["ARTHUR'S"]="AA R TH ER Z",HARROP="HH EH R AH P",SABATINO="S AA B AA T IY N OW",RENNERT="R EH N ER T",CUCCIA="K UW CH AH",BILLUPS="B IH L AH P S",DAVERSA="D AA V EH R S AH",EPIDEMIOLOGIST="EH P AH D IY M IY AA L AH JH IH S T",ETHELYN="EH TH IH L IH N",SIMON="S AY M AH N",PAONESSA="P AA OW N EH S AH",["O'HANLON"]="OW HH AE N L AH N",UNLIKELY="AH N L AY K L IY",FREMIN="F R EH M IH N",FARGNOLI="F AA R G N OW L IY",LIMON="L IH M AH N",OVERFLIGHTS="OW V ER F L AY T S",SNEERS="S N IH R Z",HOCHBRUECKNER="HH AA K B R AH K N ER",["DAX'"]="D AE K S",TRICKY="T R IH K IY",METERING="M IY T ER IH NG",CWIKLINSKI="K W IH K L IH N S K IY",CHAMLEE="CH AE M L IY",["MEMORIES'"]="M EH M ER IY Z",MCKEEMAN="M AH K IY M AH N",GAYNESS="G EY N AH S",PETERING="P IY T ER IH NG",REVERBERATES="R IH V ER B ER EY T S",LALITESH="L AA L IH T EH SH",REECE="R IY S",LEECE="L IY S",MEECE="M IY S",NEECE="N IY S",EKBLAD="EH K B L AE D",CAPPELLA="K AA P EH L AH",SHAPIROS="SH AH P IH R OW Z",DIMAMBRO="D IH M AE M B R OW",INFARCTION="IH N F AA R K SH AH N",PIETIES="P AY AH T IY Z",STEFANIC="S T IH F AE N IH K",["WHALEY(2)"]="HH W EY L IY",["GREENSPAN'S"]="G R IY N S P AE N Z",["WHIMSICAL(2)"]="HH W IH M Z IH K AH L",GANGBANGER="G AE NG B AE NG G ER",REBATED="R IY B EY T IH D",SHOEPRINTS="SH UW P R IH N T S",INCARCERATION="IH N K AA R S ER EY SH AH N",AHRENDT="AA R IH N T",AMABILE="AA M AA B AH L",RUFOW="R UW F OW",LEXICONS="L EH K S IH K AA N Z",ELLIS="EH L IH S",FYFFES="F IH F S",IMPERTINENT="IH M P ER T AH N AH N T",ALLIS="AE L IH S",["PROBE'S"]="P R OW B Z",ARIADNE="EH R IY AE D N IY",SKARDA="S K AA R D AH",MCKINSEY="M AH K IH N Z IY",BOYKINS="B OY K IH N Z",SEMON="S EH M AH N",LANNOM="L AE N AH M",SLOPES="S L OW P S",EROSION="IH R OW ZH AH N",NARCISSISTIC="N AA R S IH S IH S T IH K",RATEPAYERS="R EY T P EY ER Z",LEMON="L EH M AH N",GOETTL="G OW T AH L",RESENTFUL="R IH Z EH N T F AH L",["LAMBASTE(2)"]="L AE M B EY S T",COLIS="K OW L IH S",["MUDDLING(2)"]="M AH D L IH NG",PROFITED="P R AA F AH T AH D",LUNSFORD="L AH N S F ER D",OVERSTATEMENT="OW V ER S T EY T M AH N T",GOLIATH="G AH L AY AH TH",HOGARTH="HH OW G AA R TH",INMATES="IH N M EY T S",POLIS="P OW L AH S",SOLIS="S OW L IH S",PRESTAGE="P R EH S T IH JH",SIMILARITY="S IH M AH L EH R AH T IY",DEFENSE="D IH F EH N S",PROCEEDS="P R AH S IY D Z",DEMON="D IY M AH N",ELOPES="IH L OW P S",FACELESS="F EY S L AH S",["SURPRISE(2)"]="S AH P R AY Z",WATERING="W AO T ER IH NG",JOHNSON="JH AA N S AH N",UCCEL="UW CH AH L",RESEACHERS="R IY S ER CH ER Z",DEMARIA="D IH M AA R IY AH",["KOMODO(2)"]="K OW M OW D OW",HANELINE="HH AE N IH L AY N",FELIS="F EH L IH S",AMERICANA="AH M EH R AH K AE N AH",CECCARELLI="CH EH K ER EH L IY",CATERING="K EY T ER IH NG",WEBLEY="W EH B L IY",OFFENSE="AH F EH N S",PEBLEY="P EH B L IY",SCAFFIDI="S K AA F IY D IY",KRZYZANOWSKI="K R IH Z AH N AO F S K IY",["MISUSE(2)"]="M IH S Y UW S",HOOPES="HH UW P S",ACCEL="AH K S EH L",UNREPRESENTED="AH N R EH P R IH Z EH N T IH D",BANDLEADERS="B AE N D L IY D ER Z",["MOLPUS'"]="M AO L P AH S",AUGUSTINIAN="AA G AH S T IH N IY AH N",BLUEBELL="B L UW B EH L",OFFICIATING="AH F IH SH IY EY T IH NG",SWORD="S AO R D",UNEXPIRED="AH N IH K S P AY ER D",PERFECTIONIST="P ER F EH K SH AH N AH S T",TREATED="T R IY T AH D",SYNCOPATE="S IH NG K AH P EY T",EGREGIOUS="IH G R IY JH AH S",AGREGIOUS="AH G R IY JH IY AH S",HYMNS="HH IH M Z",RESTROOM="R EH S T R UW M",LAMBASTED="L AE M B AE S T IH D",RAPANELLI="R AE P AH N EH L IY",BROOKER="B R UH K ER",CROOKER="K R UH K ER",KIRCHHOFF="K ER K HH AO F",DENISE="D IH N IY S",SAPORITO="S AA P AO R IY T OW",BUDREAU="B AH D R OW",BESHEARS="B EH SH IY R Z",["REPRESENTS(2)"]="R EH P R IH Z EH N T S",["WHIGS(2)"]="HH W IH G Z",ESCHEWS="EH S CH UW Z",QUECHEE="K W EH CH IY",BRYDIE="B R IH D IY",DENTURE="D EH N CH ER",LANGSETH="L AE NG S EH TH",RELAXING="R IH L AE K S IH NG",CICCARELLI="CH IY K ER EH L IY",MORASSES="M ER AE S IH Z",["AUSTIN'S"]="AO S T AH N Z",SWEATED="S W EH T IH D",["RESURGENCY(2)"]="R IY S ER JH AH N S IY",SUNOBE="S UW N OW B IY",["ROCK-AND-ROLL"]="R AA K AE N D R OW L",["JUSTIN'S"]="JH AH S T AH N Z",MABLEY="M AE B L IY",MALARIA="M AH L EH R IY AH",SICKLY="S IH K L IY",EXTRAVAGANZAS="EH K S T R AE V AH G AE N Z AH Z",CALLOUS="K AE L AH S",STAUNTON="S T AO N T AH N",ORDAINING="AO R D EY N IH NG",FERMENTS="F ER M EH N T S",BULKHEADS="B AH L K HH EH D Z",KANZI="K AA N Z IY",LANZI="L AE N Z IY",MANZI="M AE N Z IY",NORRELL="N AO R AH L",RUTSTEIN="R AH T S T AY N",SORRELL="S AO R AH L",GORRELL="G AO R EY L",HORRELL="HH AO R AH L",MORANT="M AO R AH N T",["DEVIL'S"]="D EH V AH L Z",MORRELL="M AO R EH L",LIFEBLOOD="L AY F B L AH D",HURLBERT="HH ER L B ER T",COLLEVILLE="K OW L V IH L",WORRELL="W ER R AH L",EDDLEMAN="EH D AH L M AH N",SUPPES="S AH P S",ADDLEMAN="AE D AH L M AH N",TORREON="T AO R IY AH N",APPLEANS="AH P L IY N Z",ORNELLAS="AO R N EH L AH Z",PURIFOY="P Y UW R IH F OY",GIOVINAZZO="JH OW V IY N AA Z OW",PRINCIPALITIES="P R IH N S IH P AE L IH T IY Z",ASKERS="AE S K ER Z",LAPENTA="L AA P EH N T AH",BELGO="B EH L G OW",ARDENTLY="AA R D AH N T L IY",BOLOGNA="B AH L OW N IY",["DASSAULT'S"]="D AE S AO L T S",MERRELL="M EH R AH L",JERRELL="Y EH R EY L",RASMUSON="R AE Z M AH S AH N",HERRELL="HH EH R AH L",["QUINTESSENTIAL(2)"]="K W IH N T IH S EH N CH AH L",YAMASHITA="Y AA M AA SH IY T AH",TERRELL="T EH R AH L",EARTHWORM="ER TH W ER M",PERRELL="P ER R EY L",ONAWA="OW N AA W AH",CHUNKY="CH AH NG K IY",SPOON="S P UW N",SMALLCAP="S M AO L K AE P",DARRIN="D AE R IH N",RATHJEN="R AE TH JH AH N",["YOURSELVES(2)"]="Y AO R S EH L V Z",ODDITIES="AA D AH T IY Z",HYPOTHETICALS="HH AY P AH TH EH T AH K AH L Z",METHOUGHT="M EH TH AO T",KROON="K R UW N",YEARLING="Y ER L IH NG",MERCATOR="M ER K EY T ER",SEEPED="S IY P T",PEARLING="P ER L IH NG",["LUBAVITCHER'S"]="L UW B AH V IH CH ER Z",SHULTIS="SH AH L T IH S",FERRELL="F EH R IH L",LESTRANGE="L EH S T R EY N JH",["PERIPHERALS(2)"]="P ER IH F R AH L Z",RETHOUGHT="R IY TH AO T",KILGO="K IH L G OW",MCGAW="M AH G AO",["COLTRANE(2)"]="K OW L T R EY N",BUGLIOSI="B UW G L IY OW S IY",["MISSTEPS(2)"]="M IH S T EH P S",MALFUNCTIONING="M AE L F AH NG K SH AH N IH NG",POCIASK="P AH CH IY AH S K",PROBUS="P R OW B IH S",MAIERS="M EY ER Z",BELLFLOWERS="B EH L F L AW ER Z",BOEPPLE="B OW P AH L",SILENCED="S AY L AH N S T",BLANDISHMENT="B L AE N D IH SH M AH N T",EXPLOIT="EH K S P L OY T",AUYEUNG="AW Y UW NG",CHEETAN="CH IY T AH N",WORKMAN="W ER K M AH N",EXTERMINATORS="IH K S T ER M AH N EY T ER Z",MARLEENE="M AA R L IY N",["COLECO'S"]="K OW L EH K OW Z",HOUSEHOLDS="HH AW S HH OW L D Z",SYNERGISTIC="S IH N ER JH IH S T IH K",BERNTSON="B ER N T S AH N",SHELLITO="SH EY L IY T OW",EMPATHIZE="EH M P AH TH AY Z",["INTERVENORS(2)"]="IH N ER V IY N ER Z",BENEFICIARIES="B EH N AH F IH SH IY EH R IY Z",WHALEY="W EY L IY",RELAX="R IH L AE K S",SMARTY="S M AA R T IY",IMMINENT="IH M AH N AH N T",PROPES="P R OW P S",["WATERSTONE'S"]="W AO T ER S T OW N Z",["SURREBUTTAL(2)"]="S ER IY B AH T AH L",HOLMQUEST="HH OW L M K W EH S T",MANNERIST="M AE N ER AH S T",FLAVORINGS="F L EY V ER IH NG Z",HOERR="HH AO R",GLADSTEIN="G L AE D S T AY N",["FELICITE(2)"]="F EH L IH S AH T IY",IMPEDE="IH M P IY D",SARIS="S AA R IY Z",JUMBOTRONS="JH AH M B OW T R AO N Z",PARIS="P EH R IH S",MARIS="M EH R IH S",KARIS="K EH R IY Z",CELEBRANT="S EH L AH B R AH N T",COLLEGIAN="K AH L IY JH AH N",HARIS="HH AA R IY S",CONSTRAIN="K AH N S T R EY N",FARIS="F EH R IH S",CARIS="K AE R IH S",BARIS="B AA R IY Z",["BUDAPEST'S(2)"]="B UW D AH P EH SH T S",CROMPTON="K R AA M P T AH N",UNRESTRAINED="AH N R IY S T R EY N D",KUNESH="K AH N IH SH",["PRINTINGS(2)"]="P R IH N IH NG Z",DIVERSITY="D IH V ER S AH T IY",THALIA="TH EY L Y AH",["RIMPOCHETS(2)"]="R IH M P OW CH IH T S",ETHIOPIA="IY TH IY OW P IY AH",PENNISI="P EH N IY S IY",KATYDID="K EY T IY D IH D",MUTILATING="M Y UW T AH L EY T IH NG",OQUINN="OW K W IY N",DILWORTH="D IH L W ER TH",REBEL="R EH B AH L",UEBEL="UH B AH L",["ADVISER'S"]="AH D V AY Z ER Z",MONTEREY="M AA N T ER EY",["GLOBE'S"]="G L OW B Z",LAUINGER="L AW IH NG ER",NEBEL="N EH B AH L",STALEY="S T EY L IY",GEBEL="G EH B AH L",HEBEL="HH EH B AH L",PLAUSIBLE="P L AO Z AH B AH L",CAESAREAN="K EY S ER IY N",QUOTING="K W OW T IH NG",MCHATTON="M AH K AE T AH N",MULTIPLAYER="M AH L T IY P L EY ER",MINEFIELDS="M AY N F IY L D Z",GEOPOLITIC="JH IY OW P AA L IH T IH K",WATERFRONT="W AO T ER F R AH N T",SCHMUNK="SH M AH NG K",MARCELA="M AA R CH EH L AH",IMMOTILE="IH M OW T AH L",YEARWOOD="Y IH R W UH D",CORNHUSKING="K AO R N HH AH S K IH NG",SIMMON="S IH M AH N",WILCZAK="V IH L CH AE K",HAMON="HH AE M AH N",PORTRAYAL="P AO R T R EY AH L",["FISHER'S"]="F IH SH ER Z",COMMUNISTS="K AA M Y AH N AH S T S",["MASCOT(2)"]="M AE S K AA T",RAMON="R AH M OW N",CHAUCER="CH AO S ER",["GUNFIRE(2)"]="G AH N F AY R",ENLISTEES="IH N L IH S T IY Z",SHOEHORNED="SH UW HH AO R N D",VITRIOLIC="V IH T R IY AA L IH K",AMALIA="AH M AA L Y AH",FORGIONE="F AO R JH OW N IY",["ONASSIS'S(2)"]="OW N AA S IH S IH S",JOLETTA="JH OW L EH T AH",["DEXTERITY(2)"]="D EH K S T EH R IH T IY",POPOLARE="P AA P OW L AA R IY",FUMIGATION="F Y UW M IH G EY SH AH N",ALTERING="AO L T ER IH NG",DAMON="D EY M AH N",COAXED="K OW K S T",SHENK="SH EH NG K",["MISSILE'S"]="M IH S AH L Z",BREATHTAKING="B R EH TH T EY K IH NG",GOLGO="G OW L G OW",QUALEY="K W EY L IY",SUMMONED="S AH M AH N D",COLETTA="K OW L EH T AH",ATENCIO="AH T EH N S IY OW",SPRIGGED="S P R IH G D",MACRI="M AE K R IY",BABYISH="B EY B IY IH SH",BRALEY="B R AE L IY",STABILE="S T EY B IH L",STICKY="S T IH K IY",RAVISHANKAR="R AA V IY SH AA NG K AA R",SCHREGER="SH R EH G ER",ASENCIO="AH S EH N S IY OW",GRALEY="G R AE L IY",FRALEY="F R EY L IY",LAGRONE="L AA G R OW N IY",MIDDLEMISS="M IH D AH L M IH S",INDULGED="IH N D AH L JH D",POLICE="P AH L IY S",["PREDICTED(3)"]="P R IY D IH K T IH D",FINEGAN="F IH N IH G AE N",MORRIN="M AO R IH N",PACELLI="P AH S EH L IY",SCHWENT="SH W EH N T",CONSCIENCES="K AA N CH IH N S IH Z",CORRIN="K AO R IH N",LOWRIMORE="L AO R IY M AO R",OMAHONEY="OW M AH HH OW N IY",LENZI="L EH N Z IY",BARKMAN="B AA R K M AH N",["EMBEZZLING(2)"]="EH M B EH Z L IH NG",KOREANS="K AO R IY AH N Z",["GUITARRO'S"]="G IH T AA R OW Z",HARV="HH AA R V",GUILBEAU="G IH L B OW",SHOWDOWN="SH OW D AW N",SURFACED="S ER F IH S T",SOFTSPOKEN="S AO F T S P OW K AH N",SUPERVISED="S UW P ER V AY Z D",TAMOXIFEN="T AE M AA K S AH F AH N",OCTAVIUS="AA K T EY V IY AH S",TELLINGLY="T EH L IH NG L IY",MAYOTTE="M EY AO T",ARCHULETA="AA R K UW L EH T AH",HALLFORD="HH AE L F ER D",["D'AMERICA"]="D AH M EH R IH K AH",KNUTSEN="N AH T S AH N",BOOZIER="B UW Z IY ER",KLIXSHAVICH="K L IH K S AE V IH CH",IMPECCABLE="IH M P EH K AH B AH L",KILNS="K IH L N Z",AMPLIFIERS="AE M P L AH F AY ER Z",["THAXTER'S"]="TH AE K S T ER Z",ATTENUATED="AH T EH N Y UW EY T IH D",HENRICKSON="HH EH N R IH K S AH N",CLAEYS="K L EY Z",SPLICE="S P L AY S",KERKMAN="K ER K M AH N",PHANEUF="F AE N UW F",BRANCHLET="B R AE N CH L AH T",LICH="L IH CH",MICH="M IH CH",QINGMING="K IH NG M IH NG",CANON="K AE N AH N",PROFESSORSHIP="P R AH F EH S ER SH IH P",TRANSGRESSES="T R AE N Z G R EH S IH S",SCHULENBURG="SH UW L AH N B ER G",RICH="R IH CH",KANON="K EY N AH N",DONEGAN="D AA N IH G AE N",SALMON="S AE M AH N",WICH="W IH CH",JANOWICZ="Y AE N AH V IH CH",MANON="M AA N AO N",CARREON="K AA R EY AO N",["HASHER'S"]="HH AE SH ER Z",DINESH="D IH N EH SH",["SALINAS'(2)"]="S AH L IY N AH Z",BOOZE="B UW Z",SAMPLE="S AE M P AH L",ITALIA="IY T AE L IY AH",BADOUR="B AH D UH R",SELSOR="S EH L S ER",["BYZANTINE(2)"]="B IH Z AH N T IY N",["COMPLEX(2)"]="K AH M P L EH K S",BONIER="B AA N Y ER",OJALA="OW Y AA L AH",STARKWEATHER="S T AA R K W EH DH ER",SCONC="S K AA N S",SAMUELLE="S AE M Y UW EH L",GUGINO="G UW JH IY N OW",MURDOCK="M ER D AA K",RABEL="R AE B AH L",LABEL="L EY B AH L",KABEL="K AE B AH L",MABEL="M EY B AH L",ENSNARE="IH N S N EH R",REGARDLESS="R AH G AA R D L AH S",SABEL="S AA B EH L",WILLFORD="W IH L F ER D",ATALIA="AA T AA L IY AH",BABEL="B AE B AH L",["WESLIA(2)"]="HH W EH S L IY AH",HABEL="HH AE B AH L",GABEL="G AH B EH L",SKALA="S K AA L AH",PEDOWITZ="P EH D OW IH T S",ORALIA="AO R AA L IY AH",PULICE="P UW L IH S",NICKNAME="N IH K N EY M",NORFOLK="N AO R F AH K",WARRELL="W AO R EH L",JACKSONVILLE="JH AE K S AH N V IH L",JARRELL="Y AA R EY L",["AJAX'S"]="EY JH AE K S AH Z",MARV="M AA R V",BARRELL="B AA R EY L",CARRELL="K AA R EY L",HARRELL="HH EH R AH L",FARRELL="F EH R IH L",GARRELL="G AA R EY L",["KUCHMA'S"]="K UW CH M AH Z",MARKMAN="M AA R K M AH N",DECH="D EH K",SENSITIVITY="S EH N S IH T IH V IH T IY",JECH="JH EH K",FIALA="F IY AA L AH",MECH="M EH K",SCOPES="S K OW P S",PECH="P EH K",RECH="R EH K",TECH="T EH K",NOTEWORTHY="N OW T W ER DH IY",PAULHUS="P AW L HH IH S",SELMON="S EH L M AH N",EBONIC="IY B AO N IH K",ZECH="Z EH K",COMPAORE="K AA M P AH AO R IY",MOBILIZED="M OW B AH L AY Z D",MERILLAT="M EH R IH L AE T",TIPPIT="T IH P IH T",INHABITATION="IH N HH AE B AH T EY SH AH N",LANFEAR="L AE N F ER",DISCOLORATION="D IH S K AH L ER EY SH AH N",DUERR="D UH R",KRAUSHAAR="K R AW SH AA R",NINON="N IH N AH N",["ACHESON'S"]="AE CH AH S AH N Z",FERNSTROM="F ER N S T R AH M",PARODI="P AA R OW D IY",PLATITUDES="P L AE T IH T UW D Z",WEANT="W IY N T",MEANT="M EH N T",LEANT="L IY AH N T",NATURAL="N AE CH ER AH L",PERCEPTIONS="P ER S EH P SH AH N Z",ULTRAIR="AH L T R EH R",["SADDAM'S(2)"]="S AH D AA M Z",["SYNERGY'S"]="S IH N ER JH IY Z",ATCHINSON="AE CH IH N S AH N",IMPROPER="IH M P R AA P ER",AUBEL="AW B AH L",PHONIC="F AA N IH K",BUBEL="B UW B AH L",PINKERMAN="P IH NG K ER M AH N",GRADSTEIN="G R AE D S T IY N",ENGESSER="EH NG G IH S ER",KLENK="K L EH NG K",STERR="S T EH R",JONSSON="JH AA N S AH N",RUBEL="R UW B AH L",ENTSMINGER="EH N T S AH M IH NG ER",OPERETTAS="AA P ER EH T AH Z",SEDALIA="S AH D EY L Y AH",KENNETH="K EH N IH TH",FILICE="F IY L IH S",INTERCORPORATION="IH N T ER K AO R P ER EY SH AH N",SCANT="S K AE N T",FAIRYTALES="F EH R IY T EY L Z",COHABITATION="K OW HH AE B AH T EY SH AH N",["C'MON"]="K AH M AA N",DISASTERS="D IH Z AE S T ER Z",KACH="K AE CH",LACH="L AE CH",EACH="IY CH",GACH="G AE CH",HACH="HH AE CH",BACH="B AA K",FORSAKEN="F AO R S EY K AH N",JEALOUSY="JH EH L AH S IY",ANTIGONES="AE N T IH G AH N IY Z",HOKURIKU="HH AA K ER IY K UW",["SMILGIS(2)"]="S M IH L JH IH Z",WACH="W AO CH",["NATIONALIST(4)"]="N AE SH N AH L IH S T",RACH="R AE CH",EINON="AY N AO N",STRATUM="S T R AE T AH M",GREENSTREET="G R IY N S T R IY T",EMPTING="EH M P T IH NG",REENACT="R IY IH N AE K T",XENON="Z IY N AA N",SHROYER="SH R OY ER",["GOIN'"]="G OW AH N",ULICNY="AH L IH K N IY",MENON="M EY N AO N",ENDERBY="EH N D ER B IY",HEIDECKER="HH AY D IH K ER",SHEFFER="SH EH F ER",["SAVINGS'S"]="S EY V IH NG Z",["INTERRUPTION(2)"]="IH N ER AH P SH AH N",["STRUGGLE'S"]="S T R AH G AH L Z",PAOLUCCI="P AA OW L UW CH IY",PIETRUSZKA="P IY T R AH SH K AH",MUNIER="M Y UW N IY ER",KIEFFER="K IY F ER",DUNKLEBERGER="D AH NG K AH L B ER G ER",["SNAIL'S"]="S N EY L Z",["PINOCHET'S(2)"]="P IY N AO CH EH T S",FREIJE="F R IY JH",["FIGGIE'S"]="F IH G IY Z",SHERR="SH EH R",MCINTYRE="M AE K IH N T AY R",["OCCIDENTAL'S(2)"]="AA K S AH D EH N AH L Z",REBBE="R IY B AH",PERRIN="P EH R IH N",DIFFERENTIATION="D IH F ER EH N SH IY EY SH AH N",["STRUGGLING(2)"]="S T R AH G L IH NG",MCWATERS="M AH K W AO T ER Z",MERRIN="M EH R IH N",PARLIAMENTS="P AA R L AH M AH N T S",GLOBUS="G L OW B AH S",PFEFFER="F EH F ER",HERRIN="HH EH R IH N",LOGGINS="L AA G IH N Z",FERRIN="F EH R IH N",["AMATEUR(2)"]="AE M AH CH ER",ELLICE="EH L IH S",CARTUSCIELLO="K AA R T UW S IY EH L OW",SAKHAROV="S AA K ER AA V",SUPPLYING="S AH P L AY IH NG",OBERHELMAN="OW B ER HH AH L M AH N",ISSUABLE="IH SH UW AH B AH L",PREARRANGED="P R IY ER EY N JH D",KIRKMAN="K ER K M AH N",ETTINGER="EH T IH NG ER",SAMARIA="S EY M ER IY AH",INTERREGNUM="IH N T ER R EH G N AH M",LENON="L EH N AH N",DAIGRE="D EY G ER",HEAPHY="HH IY F IY",PROPOSE="P R AH P OW Z",NOFFSINGER="N AA F S IH N JH ER",TAKASAGO="T AA K AA S AA G OW",POLIZZI="P OW L IY T S IY",SOLON="S OW L AH N",ROLON="R OW L AH N",LOGOGRAPHIC="L AO G AH G R AE F IH K",CALISE="K AA L AY Z",["PRODUCE(2)"]="P R OW D UW S",DESCEND="D IH S EH N D",FALISE="F AH L IY S",["WHISENHUNT(2)"]="HH W AY Z AH N HH AH N T",SIXTEEN="S IH K S T IY N",COLON="K OW L AH N",BOLON="B OW L AH N",RAEBURN="R EY B ER N",ADLERS="AE D L ER Z",COGGINS="K AA G IH N Z",RUPTURE="R AH P CH ER",UNTRUTHS="AH N T R UW TH S",JUDICIOUSLY="JH UW D IH SH IH S L IY",RICCIARDELLI="R IY CH ER D EH L IY",HENKELMAN="HH EH NG K AH L M AH N",GALANTI="G AH L AE N T IY",VOLKOGONOV="V OW L K AO G AH N AO V",ROSSLER="R AA S AH L ER",MCELDERRY="M AE K AH L D IH R IY",["SUBSIDIARY'S"]="S AH B S IH D IY EH R IY Z",HOSSLER="HH AA S AH L ER",["SEGMENT(2)"]="S EH G M EH N T",PRESENTATION="P R EH Z AH N T EY SH AH N",["WITHDRAW(2)"]="W IH TH D R AO",MONTEGO="M AO N T IY G OW",MALATHION="M AH L AE TH IY AO N",OVONIC="OW V AA N IH K",DENIS="D EH N IH S",COLONNADE="K AA L AH N EY D",BLINDS="B L AY N D Z",TRANSMITTER="T R AE N S M IH T ER",OSTWALD="AA S T W AH L D",HAYEK="HH EY IH K",BRACHFELD="B R AA K F EH L D",LUFFMAN="L AH F M AH N",GENIS="G EH N IH S",SCHEIDEL="SH AY D AH L",BOSSLER="B AA S AH L ER",["DOCUMENTING(2)"]="D AA K Y AH M AH N IH NG",["WARKENTIN(2)"]="W AO R K AH N T IH N",PENIS="P IY N IH S",["BUYERS'"]="B AY ER Z",MEHLENBACHER="M EH L IH N B AA K ER",COCKINESS="K AA K IY N AH S",VENTERS="V EH N T ER Z",["CHANDON(2)"]="SH AE N D AA N",RISSLER="R IH S L ER",MISSLER="M IH S L ER",SENTERS="S EH N T ER Z",RENTERS="R EH N T ER Z",BELLEFEUILLE="B EH L AH F IY UW L",INCOMPETENTLY="IH N K AA M P AH T AH N T L IY",SENSORMATIC="S EH N S ER M AE T IH K",PROSTATIC="P R OW S T AE T IH K",MONZON="M OW N Z AO N",DEFRANK="D EH F R AH NG K",RAYMO="R EY M OW",DISPLACING="D IH S P L EY S IH NG",["NARROW(2)"]="N AE R OW",MURANAGA="M ER R AH N AA G AH",["POSTPONEMENTS(2)"]="P OW S P OW N M AH N T S",WALDOCK="W AO L D AA K",["GODFATHER'S"]="G AA D F AA DH ER Z",DEFINO="D IH F IY N OW",WOLLACK="W AA L AH K",ATAVISTIC="AE T AH V IH S T IH K",EISSLER="AY S AH L ER",HERSCU="HH ER S K UW",ANTONIU="AE N T OW N IY UW",BALDOCK="B AE L D AH K",JAGIELSKI="Y AH G IY L S K IY",["DUODENAL(2)"]="D UW AA D AH N AH L",["AMIR'S(2)"]="AA M IH R Z",SIMCHA="S IH M HH AH",LABBE="L AE B",RELATES="R IH L EY T S",DISAVOW="D IH S AH V AW",NYLON="N AY L AA N",PYLON="P AY L AA N",LIBERALIZE="L IH B ER AH L AY Z",SPEKTR="S P EH K T ER",IRONIC="AY R AA N IH K",UNCOOL="AH N K UW L",KREHBIEL="K R EH B IY L",["LUBRICANTS(3)"]="L UW B R AH K AH N S",["NITROGLYCERIN(2)"]="N AY T R AH G L IH S ER AH N",PACIFIERS="P AE S AH F AY ER Z",REICHART="R IY IH K HH AA R T",SALUTING="S AH L UW T IH NG",CYMBAL="S IH M B AH L",BARONESS="B EH R AH N IH S",DISQUALIFIES="D IH S K W AA L AH F AY Z",CROWBOROUGH="K R OW B ER OW",CARLONI="K AA R L OW N IY",PROFIT="P R AA F AH T",FABRICANT="F AE B R IH K AH N T",ELLZEY="EH L Z IY",STACIA="S T AA CH AH",["WHITFORD(2)"]="HH W IH T F ER D",MCGLADE="M AH G L EY D",STARDOM="S T AA R D AH M",FRIDAYS="F R AY D IY Z",BERNARDO="B ER N AA R D OW",["EUCALYPTI(2)"]="Y UW K AH L IH P T IY",LIGGETT="L IH G IH T",VANIER="V AE N IY ER",RUSSLER="R AH S L ER",LANIER="L AH N IH R",["NIETO'S(2)"]="N IY AH T OW Z",["ARGONAUT'S"]="AA R G AH N AO T S",LYSAGHT="L AY S AA T",SATIRIST="S AE T ER AH S T",SMARTEN="S M AA R T AH N",PEACEABLY="P IY S AH B L IY",["CLARA(2)"]="K L EH R AH",DONIS="D OW N IH S",SELLMEYER="S EH L M AY ER",LAGERFELD="L AA G ER F EH L D",HODEL="HH OW D AH L",IMBEDDED="IH M B EH D IH D",RADOSEVICH="R AH D AA S IH V IH CH",AXLON="AE K S L AA N",MODEL="M AA D AH L",TRIMAC="T R IH M AE K",VENDOME="V EH N D OW M",MANSION="M AE N SH AH N",DILAPIDATE="D AH L AE P AH D EY T",MONTIE="M AA N T IY",INNIS="IH N IH S",POLONSKY="P AH L AA N S K IY",ENFEEBLE="EH N F IY B AH L",MULTITASKING="M AH L T IY T AE S K IH NG",ENNIS="EH N IH S",["HOSEA(2)"]="HH OW Z EY AH",KULON="K UW L AO N",ANNIS="AE N IY Z",HULON="HH Y UW L AH N",["DEKLERK'S"]="D AH K L ER K S",MCGLINN="M AH G L IH N",MCCULLAGH="M AH K AH L AH G",CARRERO="K AA R EH R OW",SEBASTIAN="S AH B AE S CH AH N",MARRERO="M AA R EH R OW",INTOXICATION="IH N T AA K S AH K EY SH AH N",["WRITER'S"]="R AY T ER Z",HUGGINS="HH AH G IH N Z",DUGGINS="D AH G IH N Z",POACH="P OW CH",DONOFRIO="D OW N OW F R IY OW",COUNTERPROPOSALS="K AW N T ER P R AH P OW Z AH L Z",["BEIN'"]="B IY IH N",SHOREHAM="SH AO R AH M",COACH="K OW CH",LYRIS="L IH R IH S",RUDEL="R UW D AH L",MEDEMA="M EH D EH M AH",RICHTS="R IH K T S",PHILISTINE="F IH L AH S T IY N",["OLEA(2)"]="OW L IY",FELLEISEN="F EH L AY S AH N",["COLD-BLOODED"]="K OW L D B L AH D AH D",KADRMAS="K AE D ER M AA Z",SPARKLY="S P AA R K L IY",RENIER="R IY N IY ER",BERKMAN="B ER K M AH N",["MI-VAMI"]="M IY V AE M IY",["GENTLENESS(2)"]="JH EH N AH L N AH S",MEDIAMARK="M IY D IY AH M AA R K",SCAMMER="S K AE M ER",BILLMEYER="B IH L M AY ER",CATHARTIC="K AH TH AA R T IH K",["FRESHENER(2)"]="F R EH SH N ER",RULON="R UW L AH N",PENSION="P EH N SH AH N",DISTRIBUTE="D IH S T R IH B Y UW T",DRACH="D R AE CH",MARABELLA="M AE R AH B EH L AH",KIBBE="K IH B",KRACH="K R AE CH",NIBBE="N IH B",DENARIUS="D IH N AE R IY AH S",METHADONE="M EH TH AH D OW N",DOGGETT="D AA G IH T",FERRERO="F EH R EH R OW",BIRDCAGE="B ER D K EY JH",BESANT="B EH Z AH N T",IMPETUOUS="IH M P EH CH W AH S",KIMONOS="K AH M OW N AH Z",["ESQUIRE'S"]="EH S K W AY R Z",SCHAMEL="SH AE M AH L",RETROACTIVE="R EH T R OW AE K T IH V",DUPLESSIS="D UW P L IH S IH S",MACDOUGALL="M AH K D UW G AH L",ELEONORE="EH L IY AH N AO R IY",DURIS="D Y UW R IH S",["LICHTENSTEIN(2)"]="L IH K T AH N S T AY N",JURIS="JH UH R IH S",STIMAC="S T IH M AH K",TYRRELL="T AY R EH L",TWARDY="T W AO R D IY",PURIS="P Y UH R IH S",FOWBLE="F AW B AH L",VLOK="V L AA K",MAYWEATHER="M EY W EH DH ER",KREDIETBANK="K R EH D IY T B AE NG K",AMERICAS="AH M EH R AH K AH Z",["HOSOKA'S"]="HH OW S AA K AH Z",["FRAGONARD(2)"]="F R AE G AH N AA R D",PLEWA="P L UW AH",MESON="M EY Z AA N",["GREAT'S"]="G R EY T S",MOSHOOD="M AA S HH UH D",WINTERS="W IH N T ER Z",INDUSTRIVAERDEN="IH N D AH S T R IY V EH R D AH N",INATTENTION="IH N AH T EH N CH AH N",CAMMON="K AE M AH N",RELAXES="R IH L AE K S IH Z",HONEYMOONERS="HH AH N IY M UW N ER Z",CHROMIUM="K R OW M IY AH M",BLOK="B L AA K",["MODULATE(2)"]="M AO JH UW L EY T",["YAZOV(2)"]="Y AA Z AO V",LAMMON="L AE M AH N",TEMPERATURE="T EH M P R AH CH ER",GAMMON="G AE M AH N",HAMMON="HH AE M AH N",SAMMON="S AE M AH N",BELDOCK="B EH L D AA K",["SOUP'S"]="S UW P S",MEHRABIAN="M EH R EY B IY AH N",TIMELINE="T AY M L AY N",BURRELL="B ER EH L",SCHWALIER="SH W AA L Y ER",FENJVES="F EH N HH EH V EH Z",DAWNS="D AO N Z",["JASMINE(2)"]="JH AE Z M IH N",DURRELL="D UH R AH L",MANCINO="M AA N CH IY N OW",ENCAPSULATE="EH N K AE P S AH L EY T",BROERS="B R OW ER Z",SAFETIES="S EY F T IY Z",BALLOONED="B AH L UW N D",PERUVIANS="P ER UW V IY AH N Z",LUTTERMAN="L AH T ER M AH N",PUTTERMAN="P AH T ER M AH N",PLOTTER="P L AA T ER",RIFLEMAN="R AY F AH L M AH N",["INVESTMENTS(2)"]="IH N V EH S M AH N T S",LOCKERMAN="L AA K ER M AH N",LAWNS="L AO N Z",SKEEL="S K IY L",PAWNS="P AO N Z",WILLEFORD="W IH L IH F ER D",HOTTENSTEIN="HH AA T AH N S T AY N",DAMBROSIA="D AA M B R OW S IY AH",["REWARD(2)"]="R IY W AO R D",YAWNS="Y AO N Z",SURRELL="S AO R AH L",TURRELL="T AO R AH L",NAFZIGER="N AE F Z IH G ER",CONCEIVING="K AH N S IY V IH NG",["PATRICK'S"]="P AE T R IH K S",CROUCHER="K R AW CH ER",ARMANTROUT="AA R M AH N T R AW T",EISON="AY Z AH N",REPATRIATION="R IY P EY T R IY EY SH AH N",BISON="B AY S AH N",MUNGUIA="M UW N G W IY AH",UNFLINCHING="AH N F L IH N CH IH NG",LEGGETT="L EH G IH T",OLIVETTI="AA L IH V EH T IY",DOUBT="D AW T",KITTENS="K IH T AH N Z",SCHMUCKLER="SH M AH K L ER",LONDONO="L OW N D OW N OW",GITTENS="G IH T AH N Z",TISON="T IH S AH N",SISON="S IH S AH N",RISON="R IH S AH N",POLLUTANT="P AH L UW T AH N T",REAPER="R IY P ER",DEMMON="D EH M AH N",ARIANESPACE="EH R IY AE N S P EY S",CHOK="CH AA K",PARIZEAU="P EH R IH Z OW",LEMMON="L EH M AH N",LEFTRIDGE="L EH F T R IH JH",UTTERANCE="AH T ER AH N S",KANESHIRO="K AA N EY SH IH R OW",BLINCOE="B L IH N K OW",MIRABELLA="M IH R AA B EH L AH",UMBRAGE="AH M B R IH JH",NUTRIENT="N UW T R IY AH N T",HENERY="HH EH N ER IY",KAPPES="K AE P S",MOORADIAN="M UH R EY D IY AH N",["SELIES'"]="S EH L IY Z",SHURTLIFF="SH ER T L IH F",RITTENOUR="R IH T AH N AW R",["DIRECTV(3)"]="D IY R EH K T IY V IY",SANAA="S AH N AA",CHEMYR="K EH M IH R",MONTIETH="M AA N T IY IH TH",HUNTERS="HH AH N T ER Z",DANTUONO="D AA N T W OW N OW",TRANSITING="T R AE N Z IH T IH NG",STAGGERING="S T AE G ER IH NG",NORANDA="N AO R AE N D AH",LUPIEN="L AH P IY N",KORANDA="K ER AE N D AH",SILVERIA="S IY L V EH R IY AH",HAGGINS="HH AE G IH N Z",VLACH="V L AE CH",CHORDATES="K AO R D EY T S",OUTGUESSES="AW T G EH S IH Z",COMPOSITIONS="K AA M P AH Z IH SH AH N Z",["MORROW(2)"]="M AO R OW",["CHARLESTON(2)"]="CH AA R AH L S T AH N",NESSLER="N EH S L ER",MESSLER="M EH S L ER",INCUMBENCY="IH N K AH M B AH N S IY",HESSLER="HH EH S L ER",GESSLER="G EH S AH L ER",ROTHBERG="R AO TH B ER G",TESSLER="T EH S L ER",SESSLER="S EH S L ER",RESSLER="R EH S L ER",SCHERZ="SH ER Z",MAHDI="M AA D IY",WESSLER="W EH S L ER",["HADRIAN(2)"]="HH EY D R IY AH N",MARINUCCI="M AA R IY N UW CH IY",SKYWRITING="S K AY R AY T IH NG",["DEFECT(2)"]="D IH F EH K T",PIVOTS="P IH V AH T S",BRIQUEMONT="B R IH K M AO N T",ACACIA="AH K EY SH AH",QUANTITATIVELY="K W AA N T IH T EY T AH V L IY",GUTEKUNST="G AH T IH K AH N S T",SERENADING="S EH R AH N EY D IH NG",["PAINTINGS(2)"]="P EY N IH NG Z",REDISCOVER="R IY D IH S K AH V ER",FESSLER="F EH S L ER",BESSLER="B EH S L ER",BLOODSWORTH="B L AH D Z W ER TH",["EVADER(2)"]="IY V EY D ER",MOLINELLI="M OW L IY N EH L IY",SODOMIZER="S AO D AH M AY Z ER",["PALO-ALTO"]="P AE L OW AE L T OW",FINERY="F AY N ER IY",GISSENDANNER="G IH S IH N D AH N ER",["DIDN'T(2)"]="D IH D N T",SIEGMUND="S IY G M AH N D",["GHORBANIFAR(4)"]="G AO R B AA N IH F ER",PILKENTON="P IH L K EH N T AH N",BELTRAN="B EH L T R AH N",WINERY="W AY N ER IY",REHIRING="R IY HH AY R IH NG",CONFLATES="K AH N F L EY T S",BASSISTS="B EY S IH S T S",DRAMATIZE="D R AA M AH T AY Z",MISPLACING="M IH S P L EY S IH NG",JIFENG="JH IY F EH NG",RATIONALIZED="R AE SH AH N AH L AY Z D",SCUDERI="S K UW D EH R IY",WEAKLY="W IY K L IY",SLAVERY="S L EY V ER IY",FRANJO="F R AE N JH OW",CRIMINALIZE="K R IH M AH N AH L AY Z",["URUGUAY'S"]="Y ER AH G W EY Z",KASSLER="K AE S L ER",CASON="K AE S AH N",RIGGINS="R IH G IH N Z",HASSLER="HH AE S L ER",JHEEL="JH IY L",KHEEL="K IY L",WIGGINS="W IH G IH N Z",["BOUNTIFUL(2)"]="B AW N IH F AH L",PURSUANT="P ER S UW AH N T",WATERBORNE="W AO T ER B AO R N",BLOTTER="B L AA T ER",MEHDI="M EH D IY",HANDWRITING="HH AE N D R AY T IH NG",MASON="M EY S AH N",JASON="JH EY S AH N",IASON="IY AH S AH N",PUSANT="P Y UW S AA N T",QUACH="K W AA CH",CASSADY="K AE S AH D IY",EASON="IY Z AH N",GENICOM="JH EH N IH K AA M",EHLERS="EH L ER Z",AHLERS="AA L ER Z",GIZMO="G IH Z M OW",DICKERMAN="D IH K ER M AH N",IDLEWILD="AY D AH L W AY L D",STUDIOUS="S T UW D IY AH S",MCCOOL="M AH K UW L",VICKERMAN="V IH K ER M AH N",MANGANIELLO="M AA NG G AA N IY EH L OW",ARMPIT="AA R M P IH T",BASSLER="B AE S L ER",INFESTS="IH N F EH S T S",FASSLER="F AE S L ER",SLEEKEST="S L IY K AH S T",SCHICKER="SH IH K ER",FOOTBALL="F UH T B AO L",EILERS="AY L ER Z",PIOTTER="P IY AA T ER",STEPANEK="S T EH P AH N IH K",MOSKOW="M AA S K OW",MORTALLY="M AO R T AH L IY",PAMPAS="P AE M P AH Z",BREASTING="B R EH S T IH NG",CHEMISTS="K EH M AH S T S",ACTODINE="AE K T OW D AY N",SPOTTER="S P AA T ER",CARJACKERS="K AA R JH AE K ER Z",MINIS="M IH N IY Z",WASON="W AA S AH N",DOWNTIME="D AW N T AY M",BIGGINS="B IH G IH N Z",DIGGINS="D IH G IH N Z",FIGGINS="F IH G IH N Z",HIGGINS="HH IH G IH N Z",ASHMEAD="AE SH M IY D",KIGGINS="K IH G IH N Z",LIGGINS="L IH G IH N Z",MIGGINS="M IH G IH N Z",WETHERILL="W EH TH ER AH L",["IMMOBILE(3)"]="IH M OW B IY L",BRICE="B R AY S",HUDGINS="HH AH JH IH N Z",GRICE="G R AY S",ORZECH="AO R Z IH HH",["DILUTED(2)"]="D IH L UW T AH D",["NATIONALIST(3)"]="N AE SH N AH L AH S T",FOMON="F OW M AH N",AFFOLTER="AE F OW L T ER",PRICE="P R AY S",EXCEL="IH K S EH L",TRICE="T R AY S",BURMESTER="B ER M IH S T ER",PARTIALLY="P AA R SH AH L IY",ZHENYU="ZH EH N Y UW",PERJURER="P ER JH ER ER",ANKLEBONE="AE NG K AH L B OW N",DISNEYLAND="D IH Z N IY L AE N D",CREVICE="K R EH V AH S",KEMPF="K EH M P F",SCALIA="S K AA L IY AH",GRATITUDE="G R AE T AH T UW D",PROGRESSIVE="P R AH G R EH S IH V",FETTERMAN="F EH T ER M AH N",["HADN'T(2)"]="HH AE D AH N",KETTERMAN="K EH T ER M AH N",LOVALLO="L OW V AA L OW",STEERS="S T IH R Z",MOUSSORGSKY="M UW S AO R G S K IY",DREYFUSS="D R EY F AH S",PLACEBOS="P L AH S IY B OW Z",PRAIRIES="P R EY R IY Z",BREAKMATE="B R EY K M EY T",PARKINSONISM="P AA R K IH N S AH N IH Z IH M",MARANDO="M ER AE N D OW",SCHMIT="SH M IH T",["SCHIAVO'S"]="S K IY AA V OW Z",IDALIA="IH D AA L Y AH",CREDULITY="K R IH D UW L AH T IY",FLOUTING="F L AW T IH NG",LETTERMAN="L EH T ER M AH N",ADALIA="AA D AA L IY AH",["TEW(3)"]="T IY IY D AH B AH L Y UW",POWERPC="P AW ER P IY S IY",["COOPERSTEIN(2)"]="K UW P ER S T IY N",PAULSEN="P AW L S AH N",INMON="IH N M AH N",DEMBSKI="D EH M S K IY",HUGGETT="HH AH G IH T",MITNICK="M IH T N IH K",RECEPTACLES="R IH S EH P T IH K AH L Z",CASTERS="K AE S T ER Z",LYNK="L IH NG K",["BITUMEN(2)"]="B AY T UW M AH N",ILALIS="IH L AE L AH S",["OFARRELL(2)"]="OW F AE R AH L",TASTERS="T EY S T ER Z",BAKERS="B EY K ER Z",COGEMA="K OW G M AA",MASTERS="M AE S T ER Z",FAKERS="F EY K ER Z",PONTIFICATING="P AA N T IH F AH K EY T IH NG",CODELCO="K OW D EH L K OW",PAYCHECK="P EY CH EH K",AMIDI="AA M IY D IY",BUROKER="B Y UW R AH K ER",ROTUNDA="R OW T AH N D AH",REPARATION="R EH P ER EY SH AH N",SANDBAGGING="S AE N D B AE G IH NG",SCOUTING="S K AW T IH NG",SEPARATION="S EH P ER EY SH AH N",["DRIFTED(2)"]="D R IH F T IH D",["ZUGANOV'S"]="Z UW G AH N AO V S",ALMON="AA L M AH N",EBARB="EH B AA R B",LANGUISHED="L AE NG G W IH SH T",REFINANCE="R IY F AH N AE N S",NECROLOGIST="N AH K R AO L AH JH IH S T",DALIS="D AE L IH S",BALIS="B AA L IY Z",ANASTASIA="AE N AH S T EY ZH AH",DRYNESS="D R AY N AH S",HODGINS="HH AA JH IH N Z",MERGED="M ER JH D",["RANIERI(2)"]="R AH N IY EH R IY",LEGIONNAIRES="L IY JH AH N EH R Z",INSIDIOUS="IH N S IH D IY AH S",STICE="S T AY S",["DESCENDANTS(2)"]="D IH S EH N IH N T S",ZACCARIA="Z AA K AA R IY AH",LIGHTSTONE="L AY T S T OW N",["AUTHORITY'S"]="AH TH AO R IH T IY Z",RAYMUNDO="R EY M AH N D OW",WASTERS="W EY S T ER Z",CHAMBERLAYNE="CH EY M B ER L EY N",BEZEK="B EH Z EH K",SUPERSTITION="S UW P ER S T IH SH AH N",SALIS="S AA L IH S",["LUXEMBOURG(2)"]="L AH K S AH M B ER G",MALIS="M AA L IY Z",KALIS="K AE L IH S",REZEK="R EH Z EH K",STARKLY="S T AA R K L IY",RUNK="R AH NG K",PUNK="P AH NG K",ANABAPTIST="AE N AH B AE P T AH S T",MUNK="M AH NG K",SLYNESS="S L AY N AH S",KLECKNER="K L EH K N ER",JUNK="JH AH NG K",HUNK="HH AH NG K",GIDWITZ="G IH D W IH T S",TESTERS="T EH S T ER Z",PESTERS="P EH S T ER Z",NESTERS="N EH S T ER Z",JESTERS="JH EH S T ER Z",DEGROAT="D EH G R OW T",MANUCHER="M AE N UW K ER",SINISE="S IH N IY Z",BUFFET="B AH F AH T",HAUSS="HH AW S",GAUSS="G AW S",HOVNANIAN="HH AA V N EY N IY AH N",SAARI="S AA R IY",["LEVELERS(2)"]="L EH V L ER Z",DUNK="D AH NG K",CLECKNER="K L EH K N ER",BUNK="B AH NG K",FLEXING="F L EH K S IH NG",GREENBACK="G R IY N B AE K",NAUSS="N AO S",MAUSS="M AO S",SCHULHAUF="SH UW L HH AA F",REJUVENATING="R IY JH UW V AH N EY T IH NG",ARCHIVIST="AA R K AH V IH S T",BARGED="B AA R JH D",DELGADILLO="D EH L G AA D IH L OW",HUEGLIN="HH Y UW G L IH N",IRWINDALE="ER W IH N D EY L",MOULINEX="M UW L IH N EH K S",SALIENT="S EY L IY AH N T",HIROHITO="HH IH R OW HH IY T OW",REISZ="R AY SH",COEBURN="K OW B ER N",WEISZ="V AY SH",CIZEK="CH IH Z EH K",FISHKILL="F IH SH K IH L",SNAGGERS="S N AE G ER Z",SEMIFINAL="S EH M IY F AY N AH L",["ARKANSAS'"]="AA R K AH N S AA Z",["MOSQUE(2)"]="M AO S K",NOFZIGER="N AO F Z IH G ER",WOLFRUM="W UH L F R AH M",LEACH="L IY CH",KEACH="K IY CH",SHYNESS="SH AY N AH S",["FATTENING(2)"]="F AE T N IH NG",OSMON="AA S M AH N",MISTERS="M IH S T ER Z",["PHARAOHS(2)"]="F EY R OW Z",SISTERS="S IH S T ER Z",ENDEARED="EH N D IY R D",LEALIA="L IY L IY AH",MODELO="M OW D EH L OW",INTERCHANGEABLY="IH N T ER CH EY N JH AH B L IY",STARBOARDS="S T AA R B ER R D Z",VEACH="V IY CH",REACH="R IY CH",TEACH="T IY CH",PEACH="P IY CH",CORNEJO="K ER N EY Y OW",["BACKPEDALING(2)"]="B AE K P EH D L IH NG",DISCONNECT="D IH S K AH N EH K T",KEASLING="K IY Z L IH NG",SHIRKED="SH ER K T",HONORARIUM="AA N ER EH R IY AH M",BOICE="B OY S",FLASHBULBS="F L AE SH B AH L B Z",JOICE="JH OY S",LAMPF="L AE M P F",KAMPF="K AE M P F",GUCWA="G AH K W AH",QUEERS="K W IH R Z",["EJUP'S"]="IY JH AH P S",BEEFY="B IY F IY",ALICE="AE L AH S",RONK="R AA NG K",FOSTERS="F AA S T ER Z",BRAGGERS="B R AE G ER Z",POSTERS="P OW S T ER Z",GILPATRICK="G IH L P AH T R IH K",ROSTERS="R AA S T ER Z",HONK="HH AA NG K",["CHANCELLOR'S"]="CH AE N S AH L ER Z",DEMODULATE="D IY M AA JH AH L EY T",MONK="M AH NG K",MAZZETTI="M AA T S EH T IY",SLICE="S L AY S",RAIMONDI="R AH M OW N D IY",WONK="W AA N K",["PHYSICIANS(2)"]="F IH Z IH SH AH N Z",["BABOON'S"]="B AE B UW N Z",SCHEMER="S K IY M ER",SCHMEAD="SH M IY D",GUFFEY="G AH F IY",DUFFEY="D AH F IY",CONTIBEL="K AA N T IH B AH L",STEAMING="S T IY M IH NG",["ALLIES'"]="AE L AY Z",INEXTRICABLY="IH N EH K S T R IH K AH B L IY",["SHIFTED(2)"]="SH IH F T IH D",CONK="K AA NG K",BONK="B AA NG K",["T_A_C(2)"]="T AE K",AUDIOTAPE="AO D IY OW T EY P",DENICOLA="D IH N IY K OW L AH",SANTORUM="S AE N T AO R AH M",LEMAITRE="L IH M EY T ER",SALVAGE="S AE L V AH JH",LEIPZIG="L AY P S IH G",["CULLERTON'S"]="K AH L ER T AH N Z",SUTNICK="S AH T N IH K",SPONSORS="S P AA N S ER Z",MULTILAYER="M AH L T IY L EY ER",NEUENSCHWANDER="N UW AH N SH W AO N D ER",PRESCRIBERS="P R IY S K R AY B ER Z",HUTNICK="HH AH T N IH K",HAGGETT="HH AE G IH T",MOCHIZUKI="M OW CH IY Z UW K IY",RESEARCHED="R IY S ER CH T",["PRINGLE'S"]="P R IH NG G AH L Z",BOZEK="B OW Z EH K",BAGGETT="B AE G IH T",["GERMANS'"]="JH ER M AH N Z",HEINBAUGH="HH AY N B AW",ROZEK="R OW Z EH K",BOARDING="B AO R D IH NG",HINELINE="HH IH N IH L AY N",HACKBERRY="HH AE K B EH R IY",["MUBARAK(2)"]="M Y UW B AA R IH K",HOARDING="HH AO R D IH NG",PRITZL="P R IH T Z AH L",INVITES="IH N V AY T S",ENGEBRETSEN="EH NG G IH B R IH T S AH N",GAMBILL="G AH M B IH L",LITTLEBOY="L IH T AH L B OY",ZOGHBY="Z OW B IY",["TROTTED(2)"]="T R AA T IH D",["REBUKED(2)"]="R IY B Y UW K T",PIKERS="P AY K ER Z",MASSARO="M AH S AA R OW",OFFSTAGE="AO F S T EY JH",SETLIFF="S EH T L IH F",MARKETER="M AA R K AH T ER",RIKERS="R AY K ER Z",HIKERS="HH AY K ER Z",LEASEWAY="L IY S W EY",KIDWA="K IH D W AH",GIDEL="G AY D EH L",["WHENEVER(2)"]="HH W EH N EH V ER",OVERBUILDING="OW V ER B IH L D IH NG",JULIEN="JH UW L IY AH N",KERZNER="K ER Z N ER",MOPBOARD="M AA P B AO R D",BINK="B IH NG K",CABOODLE="K AH B UW D AH L",FINK="F IH NG K",FEVERFEWS="F IY V ER F Y UW Z",BIRTHRIGHT="B ER TH R AY T",HINK="HH IH NG K",["JOURNALIST(2)"]="JH ER N AH L IH S T",SPOUTING="S P AW T IH NG",INTERURBAN="IH N T ER ER B AH N",ROYBAL="R OY B AH L",GIOVANNONI="JH OW V AA N OW N IY",ANDEL="AE N D AH L",["SPOTTED(2)"]="S P AA T IH D",SPOKESPERSON="S P OW K S P ER S AH N",FORISTER="F AO R IH S T ER",FAVARO="F AA V AA R OW",GROUTING="G R AW T IH NG",BUSINESSLAND="B IH Z N IH S L AE N D",NINCOMPOOP="N IH NG K AH M P UW P",CHOSUN="CH OW Z AH N",["ORMISTON'S"]="AO R M IH S T AA N Z",ALLOWS="AH L AW Z",APHASIA="AH F EY ZH AH",SUBSTANTIATION="S AH B S T AE N CH IY EY SH AH N",["ESPY'S"]="EH S P IY Z",MINK="M IH NG K",LINK="L IH NG K",SINK="S IH NG K",RINK="R IH NG K",PINK="P IH NG K",WINK="W IH NG K",VINK="V IH NG K",["RAMPAGING(2)"]="R AE M P AH JH IH NG",SHADDIX="SH AE D IH K S",YODEL="Y OW D AH L",BLOODIER="B L AH D IY ER",CONSULTANCY="K AH N S AH L T AH N S IY",AGGRANDIZE="AH G R AE N D AY Z",["BRAZIL'S"]="B R AH Z IH L Z",GLEAMING="G L IY M IH NG",["RUTGER'S"]="R AH T G ER Z",["WHITENING(4)"]="HH W AY T N IH NG",["INTERCEPTING(2)"]="IH N ER S EH P T IH NG",SALVETTI="S AA L V EH T IY",["INHOFE'S"]="IH N HH OW F S",REPRISALS="R IH P R AY Z AH L Z",["ASEA(2)"]="EY EH S IY EY",PLAYCOUNT="P L EY K AW N T",COLLAPSING="K AH L AE P S IH NG",["SMELTER'S"]="S M EH L T ER Z",BUDYONNOVSK="B UW D Y AH N AA V S K",LILIEN="L IH L IY AH N",RUZEK="R UW Z EH K",PISTOLE="P IH S T OW L",NEICE="N IY S",["GRANDPARENT(2)"]="G R AE N P EH R AH N T",PILON="P IY L AO N",HENK="HH EH NG K",GENK="JH EH NG K",MUSTERS="M AH S T ER Z",DENK="D EH NG K",KOIKE="K OY K",COLIER="K OW L IY ER",CRUMITIE="K R UW M IH T IY",BOIKE="B OY K",UNHEARD="AH N HH ER D",GEDEON="G EH D IY AH N",PANORAMA="P AE N ER AE M AH",["SELF-DETERMINATION"]="S EH L F D IH T ER M AH N EY SH AH N",RADEL="R AE D AH L",OSMOTIC="AA Z M AA T AH K",MADEL="M AE D AH L",NADEL="N AA D EH L",KADEL="K AE D AH L",REHABILITATIVE="R IY HH AH B IH L AH T EY T IH V",WADEL="W EY D AH L",DILUTING="D AY L UW T IH NG",HARDSHIPS="HH AA R D SH IH P S",STANEK="S T AE N IH K",MARGARITAS="M AA R G EH R IY T AH S",HYPERSENSITIVITY="HH AY P ER S EH N S IH T IH V IH T IY",POLIDORI="P OW L IY D AO R IY",INDIFFERENCE="IH N D IH F ER AH N S",WENK="W EH NG K",FOGLEMAN="F OW G AH L M AH N",SENK="S EH NG K",BEREFT="B ER EH F T",MENK="M EH NG K",LENK="L EH NG K",AWARDING="AH W AO R D IH NG",MINICOMPUTER="M IH N IY K AH M P Y UW T ER",PALATES="P AE L AH T S",NUANCED="N UW AA N S T",KNOCKOUT="N AA K AW T",COLUMN="K AA L AH M",UTZINGER="AH T Z IH NG ER",RAWHIDE="R AO HH AY D",BULOVA="B Y UW L OW V AH",PHONOGRAPH="F OW N AH G R AE F",RUYBAL="R AY B AH L",SEALEY="S IY L IY",MEALEY="M IY L IY",NEALEY="N IY L IY",MCMILLAN="M AH K M IH L AH N",KEALEY="K IY L IY",AUNTIE="AE N T IY",CHARTIST="CH AA R T IH S T",FELON="F EH L AH N",MAKERS="M EY K ER Z",LAKERS="L EY K ER Z",["MISSILDINE(2)"]="M IH S IH L D AY N",RAKERS="R EY K ER Z",FADEL="F AE D AH L",TAKERS="T EY K ER Z",GUARDING="G AA R D IH NG",["GRANINGEVERKEN'S"]="G R AE N IH NG G EH V ER K AH N Z",COLUNGA="K OW L UW NG G AH",THISSEN="TH IH S AH N",NELON="N EH L AH N",MELON="M EH L AH N",SPIKE="S P AY K",DANK="D AE NG K",BANK="B AE NG K",HANK="HH AE NG K",ADLON="AE D L AA N",["HELMSLEY'S"]="HH EH L M Z L IY Z",["ROUTERS(2)"]="R AW T ER Z",NEDEL="N IY D AH L",MARTINIS="M AA R T IY N IY Z",MEDEL="M EH D AH L",REDEL="R EH D AH L",BUCHSBAUM="B AH K S B AW M",KENNAMER="K EH N AH M ER",HEIDI="HH AY D IY",DETOXICATION="D IH T AA K S AH K EY SH AH N",INDIAN="IH N D IY AH N",REDISTRICTING="R IY D IH S T R IH K T IH NG",EXTREMES="EH K S T R IY M Z",MENDENHALL="M EH N D AH N HH AO L",UNJUSTIFIABLE="AH N JH AH S T IH F AY AH B AH L",HEALEY="HH IY L IY",["PO-JEN"]="P OW JH EH N",DEALEY="D IY L IY",["MCAULIFFE'S"]="M AH K AO L AH F S",SUPERX="S UW P ER EH K S",ZANK="Z AE NG K",TRANSGRESSION="T R AE N Z G R EH SH AH N",INTERLINK="IH N T ER L IH NG K",IMARI="IY M AA R IY",COMBATIVENESS="K AH M B AE T IH V N AH S",SANK="S AE NG K",RANK="R AE NG K",YANK="Y AE NG K",WANK="W AA NG K",MANK="M AE NG K",LANK="L AE NG K",["HEALTHCARE'S"]="HH EH L TH K EH R Z",HOLIEN="HH OW L IY AH N",["GUILLERMO(3)"]="G W IY EH R M OW",["NEW-MEXICO"]="N UW M EH K S AH K OW",CIARLO="CH ER L OW",MANKINDS="M AE N K AY N D Z",CLAYWELL="K L EY W EH L",CUPBOARD="K AH B ER D",AMARI="AA M AA R IY",POLEWARD="P OW L W ER D",KRAWITZ="K R AA W IH T S",TREJO="T R EY Y OW",SILVERDOME="S IH L V ER D OW M",RATLIFF="R AE T L IH F",BEDEL="B IH D EH L",["INTERRUPTS(2)"]="IH N ER AH P T S",DEMISE="D IH M AY Z",CHLORIDE="K L AO R AY D",BLACKBERRY="B L AE K B EH R IY",EMBITTER="EH M B IH T ER",ARMON="AA R M AH N",PROFESSORSHIPS="P R AH F EH S ER SH IH P S",["LENGTHS(2)"]="L EH NG TH S",COLINO="K OW L IY N OW",HOSPITALIZATIONS="HH AA S P IH T AH L AH Z EY SH AH N Z",FOLINO="F OW L IY N OW",ACCOMMODATIVE="AH K AA M AH D EY T IH V",MOLINO="M OW L IY N OW",STEINGUT="S T AY N G AH T",LECITHIN="L EH S AH TH AH N",HOMEBUYERS="HH OW M B AY ER Z",SPIRALING="S P AY R AH L IH NG",CHALKER="CH AO K ER",DEBRUHL="D EH B R AH L",PANCAKE="P AE N K EY K",POLINO="P OW L IY N OW",INTROVERTED="IH N T R OW V ER T IH D",COPELAND="K OW P L AH N D",LEONELLE="L EH N EH L",["REBUFF(2)"]="R IY B AH F",AUGUSTE="AO G AH S T",["DATUM(2)"]="D EY T AH M",BOCHRAM="B AA K R AH M",SEPTEMBER="S EH P T EH M B ER",MEDGAR="M EH D G ER",["CARNAHAN'S"]="K AA R N AH HH AE N Z",["WARNER'S"]="W AO R N ER Z",["FASTENING(2)"]="F AE S N IH NG",["HASTENING(2)"]="HH EY S N IH NG",TONELLI="T OW N EH L IY",LEATHAM="L IY TH AH M",SNOWSTORM="S N OW S T AO R M",MONETARY="M AA N AH T EH R IY",SCHUNEMAN="SH UW N M AH N",PRECIOUS="P R EH SH AH S",MERIWEATHER="M EH R IH W EH DH ER",GENENCOR="JH EH N AH N K AO R",CAMILLA="K AH M IH L AH",POSTMARK="P OW S T M AA R K",["OPTIMISTICALLY(2)"]="AA P T IH M IH S T IH K L IY",FUTURISTIC="F Y UW CH ER IH S T IH K",PUFFY="P AH F IY",LAYBORNE="L EY B AO R N",BOBBINGER="B AA B IH NG ER",SALATA="S AA L AA T AH",MUFFY="M AH F IY",EMPOWERED="IH M P AW ER D",GORDINIER="G AO R D IH N IY ER",CHORALE="K ER AE L",ROSZELL="R AA SH AH L",COUGHLIN="K AO G L IH N",SCHMIDLIN="SH M IH D L IH N",KALATA="K AH L AA T AH",SEMRAU="S EH M R AW",LANDESBANK="L AE N D IY Z B AE NG K",FUJISAWA="F UW JH IH S AA W AH",BALATA="B AE L AH T AH",LOUGHLIN="L AO F L IH N",MONTGOMERY="M AA N T G AH M R IY",UNDERSCORED="AH N D ER S K AO R D",BLACKOUT="B L AE K AW T",LIMOUSINES="L IH M AH Z IY N Z",SUBJECTS="S AH B JH IH K T S",DEVALUE="D IH V AE L Y UW",["INFOMERCIAL'S"]="IH N F OW M ER SH AH L Z",GREGOIRE="G R IH G W AA R",ARCEMENT="AA R S EY M AH N T",POSITIONS="P AH Z IH SH AH N Z",BLOEMER="B L OW M ER",REVALUE="R IY V AE L Y UW",ATARI="AH T AA R IY",DIGITECH="D IH JH AH T EH K",BUFFY="B AH F IY",GUFFY="G AH F IY",HUFFY="HH AH F IY",["WERNER'S"]="W ER N ER Z",DUFFY="D AH F IY",ALDYS="AA L D IY Z",CITIZENS="S IH T AH Z AH N Z",SLAYBACK="S L EY B AE K",PLAYBACK="P L EY B AE K",MOSCOW="M AA S K OW",BRUMIT="B R UW M IH T",["REDUCING(3)"]="R IY D UW S IH NG",MARPLE="M AA R P AH L",MOLDAVIA="M OW L D EY V IY AH",SHREDDING="SH R EH D IH NG",SHAKINESS="SH EY K IY N AH S",["WHIZZING(2)"]="HH W IH Z IH NG",WORKFARE="W ER K F EH R",RAMPANT="R AE M P AH N T",["MISSY'S"]="M IH S IY Z",["MONSANTO'S"]="M AA N S AE N T OW Z",ROSALIA="R OW Z AH L IY AH",TATTOOING="T AE T UW IH NG",KEAVENY="K IY V IH N IY",STROMBERG="S T R AA M B ER G",SEVCIK="S EH V S IH K",BARBOSA="B AA R B OW S AH",FORSHAN="F AO R SH AH N",VACILLATES="V AE S AH L EY T S",GRUBBS="G R AH B Z",ANTIBIOTICOS="AE N T IY B IY AA T IH K OW S",LICHTENFELS="L IH K T IH N F AH L Z",GIFFY="G IH F IY",UPDYKE="AH P D AY K",ZAVODNY="Z AH V AA D N IY",NISHIDA="N IY SH IY D AH",OPDYKE="AA P D AY K",CAMCORDER="K AE M K AO R D ER",KARADZIC="K AA R AA JH IH K",RUFORD="R UW F ER D",ROCHESTER="R AA CH EH S T ER",MILAZZO="M IY L AA Z OW",["TRAJAN'S"]="T R EY JH AH N Z",THROWERS="TH R OW ER Z",CUTICLE="K Y UW T AH K AH L",DUFORD="D AH F ER D",ALTERNATION="AO L T ER N EY SH AH N",READABLE="R IY D AH B AH L",PIDGEON="P IH D JH IH N",SMELSER="S M EH L S ER",TOXICOLOGIST="T AA K S IH K AA L AH JH IH S T",["LEIBRAND'S(2)"]="L IY B R AE N D Z",PRINTMAKER="P R IH N T M EY K ER",SANCTUARIES="S AE NG K CH UW EH R IY Z",VACUUMING="V AE K Y UW M IH NG",PRAGUE="P R AA G",EXTROVERTED="EH K S T R AH V ER T IH D",["LERNER'S"]="L ER N ER Z",NAKANISHI="N AA K AA N IY SH IY",ANGIOTENSIN="AE N JH IY OW T EH N S IH N",ROLEMODEL="R OW L M AA D AH L",["SCOTIA'S"]="S K OW SH AH Z",AXFORD="AE K S F AO R D",WHISTLERS="W IH S L ER Z",ACIDOSIS="AE S AH D OW S AH S",BASEBALLS="B EY S B AO L Z",KREITER="K R AY T ER",KATAYAN="K AA T AH Y AA N",["THIRTY'S(2)"]="TH ER T IY Z",RATIER="R EY T Y ER",CARPAL="K AA R P AH L",SEMESTER="S AH M EH S T ER",CONTROLS="K AH N T R OW L Z",ENCHANT="EH N CH AE N T",SUTLIFF="S AH T L IH F",SELBE="S EH L B",MIYAKO="M IY AH K OW",RANSFORD="R AE N S F ER D",["JOSEPHS(2)"]="JH OW Z IH F S",LANSFORD="L AE N S F ER D",["MARSHES(2)"]="M AA R SH IH Z",ARTICLE="AA R T AH K AH L",["RUDOLPH(2)"]="R UW D AO F",COARTICULATING="K OW AA R T IH K Y UW L EY T IH NG",["SANWA'S"]="S AE N W AH Z",["CAUSTIC(2)"]="K AO S T IH K",PROGLACIAL="P R OW G L EY SH AH L",["MARKETPLACE(2)"]="M AA R K IH T P L EY S",LYFORD="L IH F ER D",HOSPITALIZED="HH AA S P IH T AH L AY Z D",MASAMI="M AA S AA M IY",BYFORD="B IH F ER D",MISCONDUCT="M IH S K AA N D AH K T",POMPEO="P OW M P IY OW",["HANWA'S"]="HH AE N W AH Z",GULINO="G UW L IY N OW",CONVEYING="K AH N V EY IH NG",HUSTLERS="HH AH S AH L ER Z",GEOMETRICAL="JH IY AH M EH T R IH K AH L",["VENTURA(2)"]="V EH N T UH R AH",ELFORD="EH L F ER D",MOULTON="M OW L T AH N",PALACE="P AE L AH S",POULTON="P AW L T AH N",OVERREGULATED="OW V ER R EH G Y AH L EY T IH D",["STEREOTYPICAL(2)"]="S T EH R IY AH T IH P IH K AH L",BALON="B AA L AO N",MAFIKENG="M AA F AH K EH NG",["MCKINNEY'S"]="M AH K IH N IY Z",HALON="HH EY L AA N",HANSFORD="HH AE N S F ER D",MALON="M AE L AH N",SALON="S AH L AA N",TALON="T AE L AH N",CLOSET="K L AA Z AH T",["GARP'S"]="G AA R P S",LUTZKE="L AH T S K IY",["HARA-KIRI"]="HH AA R IH K IH R IY",VITAMIN="V AY T AH M AH N",CONSTRICTING="K AH N S T R IH K T IH NG",CASTRONOVA="K AE S T R OW N OW V AH",LICENSER="L AY S AH N S ER",DECAFFEINATED="D IY K AE F AH N EY T IH D",SEANOR="S IY N ER",MEYEROWITZ="M AY ER AH W IH T S",PORGES="P AO R JH IH Z",["GLADSTEIN(2)"]="G L AE D S T IY N",FORGES="F AO R JH IH Z",GORGES="G AO R JH AH Z",BORGES="B AO R G EY S",INTERCONNECTIONS="IH N T ER K AH N EH K SH AH N Z",OVERHEAT="OW V ER HH IY T",LAUGHLIN="L AA K L IH N",RAGUSA="R AA G UW S AH",HANDBOOKS="HH AE N D B UH K S",["URBANIZATION(2)"]="ER B AH N IH Z EY SH AH N",DUNLAVEY="D AH N L AH V EY",["VISION'S"]="V IH ZH AH N Z",MACYS="M EY S IY Z",KNAPSACK="N AE P S AE K",ANTIBODIES="AE N T IH B AA D IY Z",MISCALCULATES="M IH S K AE L K Y AH L EY T S",DEMONSTRABLY="D IH M AA N S T R AH B L IY",["HANDKERCHIEFS(2)"]="HH AE NG K ER CH IY F S",CEPHALOSPORIN="S EH F AH L AO S P AO R IH N",RECOMPENSE="R EH K AH M P EH N S",SURGES="S ER JH AH Z",GRADUATED="G R AE JH UW EY T IH D",LAVATORY="L AE V AH T AO R IY",PURGES="P ER JH IH Z",DEMAURO="D IH M AO R OW",BURGES="B ER G Z",LUNGFISH="L AH NG F IH SH",DISGORGED="D IH S G AO R JH D",ROUSSELLE="R UW S EH L",COMAIR="K AA M EH R",GOODNIGHTS="G UH D N AY T S",["KIRCHBERG(2)"]="K ER CH B ER G",YAMATAKE="Y AA M AA T AA K EY",PICOP="P IH K AA P",APHRODITE="AE F R AH D AY T IY",RHEOLOGY="R IY AO L AH JH IY",THEOLOGY="TH IY AA L AH JH IY",FETTUCCINE="F EH T AH CH IY N IY",AFRIKANERDOM="AE F R AH K AA N ER D AH M",SCHEIBE="SH AY B",LEAFLIKE="L IY F L AY K",PENICILLINS="P EH N AH S IH L AH N Z",SILVERY="S IH L V ER IY",["MARSH'S"]="M AA R SH IH Z",TRUDIE="T R UW D IY",BENEFICIALLY="B EH N AH F IH SH AH L IY",ORFORD="AO R F ER D",["ASKERS'"]="AE S K ER Z",BLOKE="B L OW K",CLOKE="K L OW K",LAREAU="L ER OW",LEAGUES="L IY G Z",COLLAPSE="K AH L AE P S",CERTIFICATE="S ER T IH F IH K AH T",PINBALL="P IH N B AO L",GREENBELT="G R IY N B EH L T",FITHIAN="F IH TH IY AH N",SOURBY="S AW R B IY",MEDICINES="M EH D AH S AH N Z",GAREAU="G ER OW",GOUDIE="G AW D IY",PROGRAMME="P R OW G R AE M",["VISITORS'(2)"]="V IH S IH T ER Z",CLAIBORNE="K L EY B ER N",MASQUERADING="M AE S K ER EY D IH NG",NAVICKAS="N AA V IY K AA Z",BURKS="B ER K S",["OREGON'S"]="AO R AH G AH N Z",MINEWORKER="M AY N W ER K ER",SAVICKAS="S AE V IH K AH Z",["MULTILINGUAL(2)"]="M AH L T AY L IH NG W AH L",GREENWICH="G R EH N IH CH",PARAFFIN="P EH R AH F AH N",["ADELPHIA'S"]="AH D EH L F IY AH Z",CAREERCOM="K ER IH R K AA M",SUNSET="S AH N S EH T",["INTERSECTS(2)"]="IH N ER S EH K T S",BELKACEM="B EH L K AH S AH M",REMARKS="R IH M AA R K S",["BEECHAM'S"]="B IY CH AH M Z",AFFILIATES="AH F IH L IY AH T S",UNWINNABLE="AH N W IH N AH B AH L",["ZUCKER'S(2)"]="Z UW K ER Z",DOMINOES="D AA M AH N OW Z",PRACTICE="P R AE K T AH S",MYRIAD="M IH R IY AH D",SQUIER="S K W AY ER",["WHEELAN(2)"]="HH W IY L AH N",ELOQUENT="EH L AH K W AH N T",OUTSTRIPPING="AW T S T R IH P IH NG",MERETZ="M EH R EH T S",PERETZ="P ER IH T S",CREEGAN="K R IY G AH N",VESICLE="V EH Z IH K AH L",SIMEON="S IH M IY AH N",HEDSTROM="HH EH D S T R AH M",IDIOTIC="IH D IY AA T IH K",CALCUTT="K AE L K AH T",LESSOR="L EH S ER",BUREAU="B Y UH R OW",GAUDREAU="G OW D R OW",["AVIATION'S"]="EY V IY EY SH AH N Z",HEADSHIP="HH EH D SH IH P",["INTERFERENCE(2)"]="IH N ER F IH R AH N S",GALERIAS="G AE L ER IY AH Z",CONFIDENTIALLY="K AA N F AH D EH N SH AH L IY",SIERRACIN="S IY EH R AH S IH N",["STONECYPHER(2)"]="S T OW N S AY F ER",RAKIYA="R AH K IY AH",KYRGYZSTAN="K IH R G IH S T AE N",DIVULGED="D IH V AH L JH D",GAWTHROP="G AO TH R AH P",RAVELO="R AA V EH L OW",AHEARN="AH HH ER N",NATZKE="N AE T S K IY",WOLAVER="W AA L AH V ER",OUTRIDERS="AW T R AY D ER Z",YONKE="Y AA NG K",GATZKE="G AE T S K",MATZKE="M AE T S K IY",MAXFIELD="M AE K S F IY L D",OHEARN="OW HH ER N",DAOUD="D AW D",SHEARN="SH IH R N",["DEVELOPMENTALLY(2)"]="D IH V EH L AH P M EH N T AH L IY",["RIO-DE-JANEIRO"]="R IY OW D IY JH AH N EH R OW",FINIAN="F IH N IY AH N",["FAULKNER'S"]="F AO K N ER Z",KOOKS="K UW K S",LOOKS="L UH K S",NOOKS="N UH K S",DISCRIMINATES="D IH S K R IH M AH N EY T S",COOKS="K UH K S",MIDDENDORF="M IH D AH N D AO R F",["BRADLEY'S"]="B R AE D L IY Z",FOOKS="F UH K S",DESSAUER="D IH S AW R",HOOKS="HH UH K S",SCHMIDGALL="SH M IH JH AH L",RELAPSES="R IY L AE P S IH Z",ESPELAND="EH S P IH L AH N D",["UNPROFOR'S"]="AH P R OW F AO R Z",NITHUEKAN="N IH TH W AH K AA N",ACCOUNTS="AH K AW N T S",WEHRLY="W EH R L IY",WENZL="W EH N Z AH L",BILLERICA="B IH L ER IY K AH",ALVEREZ="AA L V EH R EH Z",BRYK="B R IH K",REHBEIN="R EH B AY N",QUIRION="K W IH R IY AH N",["WHISKERS(2)"]="HH W IH S K ER Z",BABUSHKA="B AH B UH SH K AH",THREATENED="TH R EH T AH N D",RECOUNTS="R IY K AW N T S",LAUNIUS="L AW N IY IH S",GARGES="G AA R JH IH Z",RAREFIED="R EH R AH F AY D",INTERDEALER="IH N T ER D IY L ER",DIMAURO="D IH M AO R OW",RATINGS="R EY T IH NG Z",MINIVANS="M IH N IY V AE N Z",HOMOGENEITY="HH AA M AH JH AH N IY AH T IY",IBACH="IH B AA K",INCORRIGIBLE="IH N K AA R AH JH AH B AH L",COMFORTERS="K AH M F ER T ER Z",RAJEWSKI="R AY EH F S K IY",BARGES="B AA R JH AH Z",UNDERGOING="AH N D ER G OW IH NG",BARTHELME="B AA R TH AH L M",GAJEWSKI="G AY EH F S K IY",ROOKS="R UH K S",COLOSSUS="K AH L AA S AH S",HANDYMAN="HH AE N D IY M AE N",CANDYMAN="K AE N D IY M AE N",MACAW="M AH K AO",UNREALITY="AH N R IY AE L AH T IY",GREGORIAN="G R AH G AO R IY AH N",ASTIGMATISM="AH S T IH G M AH T IH Z AH M",["INTERCEPTED(2)"]="IH N T ER S EH P T IH D",INGLIS="IH NG G L IH S",GOLCONDA="G AA L K AA N D AH",AMELIA="AH M IY L Y AH",LEFCOURT="L EH F K AO R T",TIBERON="T IH B ER AH N",KEEGALI="K IY G AA L IY",SPONGY="S P AH N JH IY",HEINOLD="HH AY N OW L D",RESPIRONIC="R EH S P ER AA N IH K",CUONG="K W AO NG",["RESISTS(2)"]="R IY Z IH S T S",["MCCOMBIE(2)"]="M AH K OW M IY",COMETARY="K AA M AH T EH R IY",DECLASSIFY="D IH K L AE S AH F AY",READABILITY="R IY D AH B IH L IH T IY",MADELYN="M AE D IH L IH N",BURPING="B ER P IH NG",VUONG="V UW AO NG",SONNET="S AA N IH T",NOTIFY="N OW T AH F AY",LUCKILY="L AH K AH L IY",CHECCHI="CH EH K IY",SOUTHWICK="S AW TH W IH K",CANCHOLA="K AA N K OW L AH",PRECRASH="P R IY K R AE SH",HOPPLE="HH AA P AH L",SCARPONE="S K AA R P OW N IY",MERGES="M ER JH IH Z",["MADEWELL(2)"]="M EY D W EH L",COPPLE="K AA P AH L",PRADESH="P R AH D EH SH",OMBUDSMAN="AA M B AH D Z M AH N",IMPECCABLY="IH M P EH K AH B L IY",AIRSPACE="EH R S P EY S",HARDIMON="HH AA R D IH M AA N",INFOMERCIALS="IH N F OW M ER SH AH L Z",THECLA="TH EH K L AH",LINNET="L IH N IH T",FORESHADOWING="F AO R SH AE D OW IH NG",SLURRING="S L ER IH NG",SARISI="S AH R IY S IY",THREADBARE="TH R EH D B EH R",FOONG="F UW NG",SPECULATIVE="S P EH K Y AH L AH T IH V",UNDERPERFORMER="AH N D ER P ER F AO R M ER",NOZZLES="N AA Z AH L Z",FARADAY="F AE R AH D EY",LOONG="L UH NG",POPPLE="P AA P AH L",JOONG="JH UH NG",SOONG="S UW NG",SHOPLIFTING="SH AA P L IH F T IH NG",KOPPENHAVER="K AA P IH N HH AH V ER",TOPPLE="T AA P AH L",STUDIOS="S T UW D IY OW Z",BRUTISH="B R UW T IH SH",HUESMAN="HH UH S M AH N",ERECTS="IH R EH K T S",["HODGKIN'S"]="HH AA JH K IH N Z",FOOBAR="F UW B AA R",CUELLAR="K Y UW L ER",PAGLIA="P AE G L IY AH",PRONG="P R AO NG",FORWARDED="F AO R W ER D IH D",DEWEISS="D IH W AY S",DUBININ="D UW B IH N IH N",BALMY="B AA M IY",KAZOO="K AH Z UW",MONTAZERI="M AA N T AH Z EH R IY",["SELLERS'"]="S EH L ER Z",REVERES="R IH V IH R Z",["TELECOMMUNICATIONS'"]="T EH L AH K AH M Y UW N AH K EY SH AH N Z",RAGED="R EY JH D",MCCAW="M AH K AO",PAGED="P EY JH D",RECLASSIFY="R IY K L AE S IH F AY",MCINTOSH="M AE K AH N T AO SH",JUROR="JH UH R ER",WAGED="W EY JH D",CARLOS="K AA R L OW S",ANABOLIC="AE N AH B AA L IH K",FUROR="F Y UH R AO R",FOOTPRINTS="F UH T P R IH N T S",KIZZIAH="K IH Z IY AH",CAGED="K EY JH D",LEBOEUF="L AH B AH F",SARLOS="S AA R L OW S",SENNET="S EH N AH T",RENNET="R EH N AH T",["INTERACT(2)"]="IH N ER AE K T",LINEBERGER="L AY N B ER G ER",CANARIES="K AH N EH R IY Z",KINSLER="K IH N S AH L ER",ARBOTHNOTT="AA R B AO TH N AO T",BENNET="B EH N IH T",VERBRUGGE="V ER B R AH G",["PAJAMAS(2)"]="P AH JH AE M AH Z",APOCRYPHAL="AH P AA K R AH F AH L",LIJEWSKI="L IH Y EH F S K IY",AIRBUS="EH R B AH S",SCOTTIE="S K AA T IY",DIPPLE="D IH P AH L",GIPPLE="JH IH P AH L",INCISE="IH N S AY Z",HIPPLE="HH IH P AH L",EXCAVATION="EH K S K AH V EY SH AH N",ALTEON="AA L T IY AO N",AGNELLI="AE G N EH L IY",ORGASMS="AO R G AE Z AH M Z",GRUETZMACHER="G R UH T S M AA K ER",["MARIAN'S"]="M EH R IY AH N Z",DUMMY="D AH M IY",NEGLIA="N EH G L IY AH",STOCKERT="S T AA K ER T",RASOR="R EY Z ER",OSOWSKI="AH S AO F S K IY",STELLAR="S T EH L ER",NIPPLE="N IH P AH L",PREROGATIVES="P R IH R AA G AH T IH V Z",ORIFICES="AO R AH F AH S AH Z",RIPPLE="R IH P AH L",TIPPLE="T IH P AH L",PERSUASIONS="P ER S W EY ZH AH N Z",ADVOCATING="AE D V AH K EY T IH NG",ACCESSORIZE="AE K S EH S ER AY Z",WAINMAN="W EY N M AH N",SPORCK="S P AO R K",BECKMANN="B EH K M AH N",GUZZETTI="G Y UW Z EH T IY",TIRADES="T AY R EY D Z",["BABAR'S"]="B AA B AA R Z",["PANTERA'S"]="P AA N T EH R AH Z",["FICARRA(2)"]="F IH K AA R AH",CINELLI="S IH N EH L IY",RESULTS="R IH Z AH L T S",SCHARENBERG="SH EH R AH N B ER G",PORTERFIELD="P AO R T ER F IY L D",MINELLI="M IH N EH L IY",["CLAIBORNE'S"]="K L EY B AO R N Z",RAINMAN="R EY N M AH N",PINELLI="P IH N EH L IY",HUNGERING="HH AH NG G ER IH NG",KLAMON="K L EY M AH N",["MACDILL'S"]="M AH K D IH L Z",["CLEMENTINE(2)"]="K L EH M AH N T IY N",MCCARTHA="M AH K AA R TH AH",["ZABAR'S"]="Z AE B AA R Z",DARKENING="D AA R K AH N IH NG",ISLAMIST="IH S L AH M IH S T",BLANCO="B L AE NG K OW",LUZIER="L UW Z IY ER",KWONG="K W AO NG",EWONG="Y UW AO NG",PAGURIAN="P AH G Y UH R IY AH N",["JABAR'S"]="JH AH B AA R Z",SUPERVOTING="S UW P ER V OW T IH NG",["MILLSTEIN(2)"]="M IH L S T IY N",KILBANE="K IH L B AH N",RETRIEVES="R IH T R IY V Z",HOUSEGUESTS="HH AW S G EH S T S",TANTAMOUNT="T AE N T AH M AW N T",CALVERY="K AE L V ER IY",KAORI="K AO R IY",KEPPLE="K EH P AH L",MAORI="M AW R IY",WALKE="W AO K",["BLISS'"]="B L IH S",POLITES="P AH L AY T S",INTERROGATION="IH N T EH R AH G EY SH AH N",MACEDONIA="M AE S AH D OW N IY AH",["NANOS(2)"]="N AE N OW Z",EMMELINE="EH M AH L AY N",BOEHNKE="B OW NG K",MERITLESS="M EH R IH T L AH S",SIGMOIDAL="S IH G M OY D AH L",KARPF="K AA R P F",GRAPHICS="G R AE F IH K S",TAKEDA="T AA K EY D AH",PEPPLE="P EH P AH L",DENOYER="D EH N OY ER",KENOYER="K EH N OY ER",KYONG="K Y AO NG",PLAUDIT="P L AO D IH T",FIZZLES="F IH Z AH L Z",PENOYER="P EH N OY ER",CORDASCO="K ER D AA S K OW",DICKMANN="D IH K M AH N",PLAGUES="P L EY G Z",MCNAIR="M AH K N EH R",CORROBORATIVE="K ER AA B ER AH T IH V",DELLAVECCHIA="D EH L AH V EH K IY AH",STORCK="S T AO R K",GASPING="G AE S P IH NG",FLAMM="F L AE M",RINGNECK="R IH NG N EH K",MAGLIS="M AE G L IY Z",["WASP'S"]="W AA S P S",["MATURES(2)"]="M AH T Y UH R Z",GREENE="G R IY N",IREENE="AY R IY N",KLAMM="K L AE M",SYNAPSES="S IH AE P S IH Z",TARASOFF="T EH R IH S AO F",BALKE="B EY L K",MUMMY="M AH M IY",DALKE="D EY L K",FALKE="F AO K",MENTALLY="M EH N T AH L IY",GUMMY="G AH M IY",LOZENGES="L AO Z AH N JH AH Z",TUMMY="T AH M IY",SUMMY="S AH M IY",RUMMY="R AH M IY",PREEXISTED="P R IY IH G Z IH S T IH D",ETHOLOGY="IH TH AA L AH JH IY",ZUCCARELLI="Z UW K ER EH L IY",JOHNSTOWN="JH AA N Z T AW N",KAUMOGRAPHY="K OW M AA G R AH F IY",["SCHWEGLER(2)"]="SH W EH G L ER",BUCHS="B AH K S",LEONG="L EH NG",ARRANT="AE R AH N T",OMORI="OW M AO R IY",RATIFY="R AE T AH F AY",SWINSON="S W IH N S AH N",NOTHINGS="N AH TH IH NG Z",OELKE="OW L K",BIANCO="B IY AA NG K OW",["HAGGLING(2)"]="HH AE G L IH NG",OGUINN="OW G W IH N",MCMANIS="M AH K M AE N AH S",JEONG="JH EH NG",FINANCIALS="F AY N AE N SH AH L Z",KISOR="K AY Z ER",["ANTIBIOTICS(2)"]="AE N T AY B AY AA T IH K S",SPEARHEADING="S P IH R HH EH D IH NG",STINSON="S T IH N S AH N",BARAJAS="B AA R AA Y AA Z",ROZIER="R OW Z IY ER",DIBBERN="D IH B ER N",["EMPHASIS(2)"]="EH M F AH S IH S",["VOGOSCA(2)"]="V AH G OW S K AH",LOZIER="L OW Z IY ER",MACHINERIES="M AH SH IY N ER IY Z",HUBBELL="HH AH B AH L",PRENTISS="P R EH N T IH S",VISOR="V AY Z ER",WISOR="W AY Z ER",MEANINGS="M IY N IH NG Z",LEANINGS="L IY N IH NG Z",FORCIBLY="F AO R S AH B L IY",WHIPPLE="W IH P AH L",ARENDT="EH R IH N T",CARPINELLI="K AA R P IY N EH L IY",PARADES="P ER EY D Z",RUZICH="R AH Z IH HH",MADRIGAL="M AE D R AH G AH L",["TRICENTROL'S"]="T R AY S EH N T R AA L Z",ARROWHEAD="AE R OW HH EH D",INSULTS="IH N S AH L T S",FANELLI="F AH N EH L IY",MNEMONICS="N IH M AA N IH K S",KUEHNLE="K UH N AH L",["SPLENIC(2)"]="S P L IY N IH K",BELKE="B EH L K",["RIGHT-WINGER"]="R AY T W IH NG ER",HELKE="HH EH L K",DISCRETIONARY="D IH S K R EH SH AH N EH R IY",HAGGADAH="HH AH G AH D AH",CHOCOLATOLOGY="CH AA K L AH T AA L AH JH IY",CELESTIAL="S AH L EH S CH AH L",BREUNINGER="B R UW N IH NG ER",["SUBORDINATES(2)"]="S AH B AO R D AH N AH T S",ENSOR="EH N S ER",FLAGSTAFFS="F L AE G S T AE F S",["ZAIREAN'S"]="Z AY IH R AH N Z",PUZZLING="P AH Z AH L IH NG",COINCIDENTALLY="K OW IH N S IH D EH N T AH L IY",GUZZLING="G AH Z AH L IH NG",BAHNSEN="B AA N S AH N",MILKE="M IH L K",SHADBUSH="SH AE D B UH SH",IGNACE="IH G N AH S",WILKE="W IH L K",MERICLE="M EH R IH K AH L",URGED="ER JH D",ARRENDONDO="AA R EH N D OW N D OW",LUGWORM="L AH G W ER M",SURMOUNTING="S ER M AW N T IH NG",PADDACK="P AE D AH K",["NATURALISTS(4)"]="N AE CH R AH L IH S",PRECOURT="P R IH K AO R T",CALAMITIES="K AH L AE M AH T IY Z",ATTENDEE="AH T EH N D IY",EXCISE="EH K S AY S",PRERECORD="P R IY R IY K AO R D",MATHIESON="M AH TH IY Z AH N",MENACE="M EH N AH S",HACKMANN="HH AE K M AH N",["INTERFERES(2)"]="IH N ER F IH R Z",SACKMANN="S AE K M AH N",["FORENSIC(2)"]="F AO R EH N S IH K",GOUDREAU="G UW D R OW",DONATED="D OW N EY T AH D",HILKE="HH IH L K AH",BOUDREAU="B UW D R OW",GLORI="G L AO R IY",["RATCHET(2)"]="R AE T CH AH T",PUPPETEERS="P AH P AH T IY R Z",["CHRISTIAN(2)"]="K R IH S CH IH N",ALONG="AH L AO NG",FOXBORO="F AA K S B ER OW",HOPPES="HH AA P S",KOPPES="K AA P S",MOPPES="M AA P S",ROBNETT="R AA B N IH T",TYRANT="T AY R AH N T",FORETELLING="F AO R T EH L IH NG",NEUROPATHY="N UH R OW P AE TH IY",HMONG="M AO NG",SCHIMEK="SH IH M IH K",MARICLE="M AE R IH K AH L",WESTMARK="W EH S T M AA R K",AMONG="AH M AH NG",BRINKMEIER="B R IH NG K M AY ER",INCURRED="IH N K ER D",ROZEMA="R AH Z IY M AH",GUZZLES="G AH Z AH L Z",["ANNEXED(2)"]="AH N EH K S T",["LISTENING(2)"]="L IH S N IH NG",["SANDOS(2)"]="S AE N D OW S",KEYSTONES="K IY S T OW N Z",PUZZLES="P AH Z AH L Z",FRANCO="F R AE NG K OW",["VENICE'S"]="V EH N IH S IH Z",BRANCO="B R AE NG K OW",CREATURE="K R IY CH ER",NEWSCASTER="N UW Z K AE S T ER",["SABINE'S"]="S AH B IY N Z",CROUSER="K R AW S ER",MASQUERADE="M AE S K ER EY D",MISCHIEVOUS="M IH S CH AH V AH S",RUKAVINA="R AH K AH V AY N AH",KREISMAN="K R AY S M AH N",ALMADANI="AA L M AH D AA N IY",KAZUHIKO="K AA Z UW HH IY K OW",SIGHED="S AY D",STILETTOS="S T AH L EH T OW Z",MCELHONE="M AE K AH L HH OW N",SELECTIONS="S AH L EH K SH AH N Z",MADONNA="M AH D AA N AH",["REJECTION(2)"]="R IY JH EH K SH AH N",["SITUATION'S"]="S IH CH UW EY SH AH N Z",BLADDER="B L AE D ER",["TURNER'S"]="T ER N ER Z",["FINLAND(2)"]="F IH N L AH N D",ARMADILLOS="AA R M AH D IH L OW Z",["OSCAR'S"]="AO S K ER Z",MACABRE="M AH K AA B R AH",ILLITERACY="IH L IH T ER AH S IY",CHILCOTT="CH IH L K AH T",DISSEMINATES="D IH S EH M AH N EY T S",GENSLER="G EH N S AH L ER",HORNBOSTEL="HH AO R N B AH S T AH L",EXEMPLIFY="IH G Z EH M P L AH F AY",KENSLER="K EH N S AH L ER",["HOLLSTEIN(2)"]="HH AA L S T IY N",IRETTA="IH R EH T AH",XIONG="ZH AO NG",["ANEURISM(2)"]="AE N Y UH R IH Z M",RESTATES="R IY S T EY T S",BRINSON="B R IH N S AH N",SHELIA="SH IH L Y AH",SPECIOUS="S P IY SH AH S",BLURRING="B L ER IH NG",["HOLIDAY'S"]="HH AA L AH D EY Z",AUTOFACT="AO T OW F AE K T",DURANT="D UH R AH N T",["DEFENDANTS'"]="D IH F EH N D AH N T S",POORBAUGH="P UW R B AO",KELSALL="K EH L S AH L",REVERENT="R EH V ER AH N T",["TEHERAN'S"]="T EH HH ER AA N Z",GOFFMAN="G AA F M AH N",HOFFMAN="HH AO F M AH N",KOFFMAN="K AO F M AH N",ARETTA="AA R EH T AH",["MINERVA(2)"]="M IH N ER V AH",TOMASELLI="T OW M AA S EH L IY",ROFFMAN="R AO F M AH N",OPTIMISM="AA P T AH M IH Z AH M",DEFEAT="D IH F IY T",KIPPES="K IH P S",TROUSER="T R AW Z ER",DILAURO="D IH L AO R OW",COFFMAN="K AO F M AH N",THRONEBERRY="TH R OW N B EH R IY",ANGSTADT="AE NG SH T AE T",STONG="S T AO NG",WHORL="W ER L",OSCILLATES="AA S AH L EY T S",OMELIA="OW M EH L IY AH",CONCERNS="K AH N S ER N Z",["SASSY'S"]="S AE S IY Z",FINGERING="F IH NG G ER IH NG",RINDERKNECHT="R IH N D ER K N IH K T",FANSLER="F AE N S AH L ER",["HARKIN'S"]="HH AA R K IH N Z",CANSLER="K AE N S AH L ER",LINGERING="L IH NG G ER IH NG",CLOUSER="K L AW S ER",PRINSEN="P R IH N S AH N",SCHLAG="SH L AE G",SIRRI="S IH R IY",LEXINGTON="L EH K S IH NG T AH N",["COMMUNICATION'S"]="K AH M Y UW N IH K EY SH AH N Z",HANDSOME="HH AE N S AH M",EQUATED="IH K W EY T IH D",BENNARDO="B AH N AA R D OW",ROBLEY="R AA B L IY",LONGBOW="L AO NG B OW",PACHTER="P AE K T ER",ERUPTIONS="IY R AH P SH AH N Z",["BEGLEITER'S"]="B EH G L AY T ER Z",["SWATCHES(2)"]="S W AA CH IH Z",REPRESENTATIVES="R EH P R AH Z EH N T AH T IH V Z",KEVORKIAN="K AH V AO R K IY AH N",["DIRECTORATE(3)"]="D IY R EH K T ER AH T",BERGERSON="B ER G ER S AH N",STAUSS="S T AO S",FERGERSON="F ER G ER S AH N",PURPOSE="P ER P AH S",HALOGEN="HH AE L AH JH AH N",DUMKE="D AH M K IY",EBBED="EH B AH D",STANDINGS="S T AE N D IH NG Z",ANITOLE="AE N IH T OW L",ABURTO="AH B UH R T OW",HORACE="HH AO R AH S",MORACE="M AO R AA CH IY",TROESTER="T R OW S T ER",["QUEBECKERS(2)"]="K W AH B EH K ER Z",["PECAN(2)"]="P IY K AA N",["COMMANDED(2)"]="K AH M AE N D IH D",SUBSTITUTIONS="S AH B S T IH T Y UW SH AH N Z",STROMAIN="S T R AA M AY N",RENATA="R AH N AA T AH",["DEVALUED(2)"]="D IY V AE L Y UW D",["PHILANDERING(2)"]="F AH L AE N D ER IH NG",CIAMPA="CH AO M P AH",MOLLICA="M AA L IH K AH",PLENTIFUL="P L EH N T AH F AH L",KOOK="K UW K",LOOK="L UH K",MOOK="M UH K",BOOK="B UH K",GIAMPA="JH AA M P AH",INFLAMMATORY="IH N F L AE M AH T AO R IY",KLECK="K L EH K",GELLIS="G EH L IH S",MCCARTHY="M AH K AA R TH IY",DELLIS="D EH L IH S",MEMOIR="M EH M W AA R",BLECK="B L EH K",["RAPIST'S"]="R EY P IH S T S",KNAUSS="N AO S",ROOK="R UH K",KELLIS="K EH L IH S",NELLIS="N EH L IH S",MELLIS="M EH L IH S",SUMGAIT="S AH M G EY T",HOECK="HH OW K",GOTTESMAN="G AA T S M AH N",KLINGENSMITH="K L IH NG G IH N S M IH TH",WRECK="R EH K",SAWIN="S AO IY N",SEGREGATE="S EH G R AH G EY T",BOECK="B OW K",SLABAUGH="S L AE B AO",SALATINO="S AA L AA T IY N OW",SEXIST="S EH K S IH S T",FRECK="F R EH K",CAMMY="K AE M IY",MARGRAVE="M AA R G R EY V",SOMALIA="S AH M AA L IY AH",HARGRAVE="HH AA R G R EY V",LOLLIS="L AH L IY S",SAKURAI="S AA K UH R AA IY",COLLIS="K AA L IH S",HOLLIS="HH AA L IH S",FOLLIS="F AA L IH S",REVISITED="R IY V IH Z AH T IH D",EXHIBITED="IH G Z IH B AH T AH D",INEFFICIENTLY="IH N IH F IH SH AH N T L IY",STIPES="S T AY P S",["OPERATION'S"]="AA P ER EY SH AH N Z",SIBLEY="S IH B L IY",DAMIAN="D EY M IY AH N",["PREDICTED(2)"]="P R IY D IH K T AH D",PONTILLO="P OW N T IH L OW",REDHEADED="R EH D HH EH D IH D",SPECK="S P EH K",YELLOWEST="Y EH L OW IH S T",AMELIORATE="AH M IY L Y ER EY T",SHORTTERM="SH AO R T T ER M",WOJAHN="W OW HH AA N",NORDICTRACK="N AO R D IH K T R AE K",HANGAR="HH AE NG ER",KRAUSS="K R AW S",DOOMSDAY="D UW M Z D EY",SEMPLE="S EH M P AH L",DICHTER="D IH K T ER",MARKUPS="M AA R K AH P S",BROK="B R AA K",["MCKESSON'S"]="M AH K EH S AH N Z",INSUBORDINATE="IH N S AH B AO R D AH N EY T",NEEDELMAN="N IY D AH L M AH N",CHAMPA="K AA M P AH",RICHTER="R IH K T ER",LEWIN="L UW IH N",NICHTER="N IH K T ER",LICHTER="L IH K T ER",BERTOLD="B ER T OW L D",FICHTER="F IH K T ER",FINAZZO="F IY N AA Z OW",["DRAINAGE(2)"]="D R EY N IH JH",SETARO="S EH T AA R OW",QUESTION="K W EH S CH AH N",STEMM="S T EH M",REPORTAGE="R IH P AO R T IH JH",MISCREANT="M IH S K R IY AH N T",GTECH="JH IY T EH K",HUBLEY="HH AH B L IY",["ASEAN(2)"]="EY EH S IY EY EH N",RUNCIE="R AH N S IY",EDWIN="EH D W AH N",MUNCIE="M AH N S IY",STECH="S T EH K",CORRIDORS="K AO R IH D ER Z",["COLLEGES'"]="K AA L IH JH IH Z",["EXCLAMATION-POINT"]="EH K S K L AH M EY SH AH N P OY N T",FARRUGIA="F AA R UW JH AH",PLAMONDON="P L AA M OW N D AO N",RUBLEY="R AH B L IY",STECK="S T EH K",LEGACY="L EH G AH S IY",SLAUGHTER="S L AO T ER",["RECORDS'"]="R EH K ER D Z",MCGRANE="M AH G R EY N",HAUNTINGLY="HH AO N T IH NG L IY",GOLDSCHMIDT="G OW L D SH M IH T",["TRIANGLE'S"]="T R AY AE NG G AH L Z",KEWAUNEE="K Y UW AO N IY",GRECH="G R EH K",FRECH="F R EH K",SONATA="S AH N AA T AH",TERRI="T EH R IY",VERRI="V EH R IY",DWECK="D W EH K",TONDREAU="T AH N D R OW",DIMPLE="D IH M P AH L",KIMPLE="K IH M P AH L",FECHTER="F EH K T ER",IMPONDERABLE="IH M P AA N D ER AH B AH L",COMPLYING="K AH M P L AY IH NG",DEIKE="D IY K",PIMPLE="P IH M P AH L",ELECTRONICALLY="IH L EH K T R AA N IH K AH L IY",KLENSCH="K L EH N SH",WILLCOX="W IH L K AA K S",["HOPBURG'S"]="HH AA P B ER G Z",LITARO="L IH T AA R OW",UTECH="Y UW T EH K",NADEIN="N AH D AY N",DONATA="D AH N AA T AH",VIRNIG="V ER N IH G",["PROTECTIONISTS(2)"]="P ER T EH K SH AH N IH S T S",KUECK="K UW K",LUECK="L UW IH K",NAIFY="N EY F AY",["IONICS'S"]="AY AA N IH K S IH Z",FEINMAN="F AY N M AH N",PETKUS="P EH T K IH S",DELCARLO="D EH L K AA R L OW",KEYBOARD="K IY B AO R D",JANOW="Y AE N OW",["HOPKIN'S"]="HH AA P K IH N Z",DIMASI="D IH M AA S IY",CUBED="K Y UW B D",SUPERFREIGHTERS="S UW P ER F R EY T ER Z",CONFIRM="K AH N F ER M",THOUGHTFULLY="TH AO T F AH L IY",MONASTERY="M AA N AH S T EH R IY",WECHTER="W EH K T ER",VERDUIN="V EH R D UW IH N",MARILYN="M EH R AH L AH N",BERRI="B EH R IY",MOTOHASHI="M OW T OW HH AA SH IY",["OPPENHEIMER'S"]="AA P AH N HH AY M ER Z",GERRI="JH EH R IY",FERRI="F EH R IY",KERRI="K EH R IY",JERRI="JH EH R IY",LOITERING="L OY T ER IH NG",["PERTUIT(2)"]="P ER T UW AH T",["ALESSANDRO(2)"]="AA L AH S AE N D R OW",GATEAU="G AA T OW",MANGIONE="M AA N JH OW N IY",ROOTSTEIN="R UW T S T AY N",["ERUPT(2)"]="IY R AH P T",["PRACTICAL(2)"]="P R AE K T IH K AH L",["DEALERS'"]="D IY L ER Z",MARKSMANSHIP="M AA R K S M AH N SH IH P",TOMMY="T AA M IY",MOMMY="M AA M IY",["CONSOL'S"]="K AA N S AA L Z",FIXABLE="F IH K S AH B AH L",MONGERING="M AH NG G ER IH NG",["PONCE(3)"]="P AA N S EY",PEEVY="P IY V IY",SEMIPRECIOUS="S EH M IY P R EH SH AH S",["ST_LAURENT(2)"]="S AA N L AO R AO N T",OKAMOTO="OW K AH M OW T OW",INFINITESIMAL="IH N F IH N IH T EH S IH M AH L",REKINDLING="R IY K IH N D L IH NG",["ROCHELLE'S(2)"]="R AH SH EH L Z",LOBED="L OW B D",RAYSOR="R EY S ER",MCCROCKLIN="M AH K R AA K L AH N",OUTSET="AW T S EH T",SURREPTITIOUSLY="S ER AH P T IH SH AH S L IY",NORBERTO="N AO R B ER T OW",DEIFY="D IY AH F AY",MULTISTORY="M AH L T IY S T AO R IY",NOSEDIVED="N OW Z D AY V D",TYMNET="T AY M N EH T",PETITIONERS="P AH T IH SH AH N ER Z",ARBED="AA R B IH D",MCCULLOH="M AH K AH L AH",GASIFY="G AE S AH F AY",INSTRUCTORS="IH N S T R AH K T ER Z",HEIDORN="HH AY D ER N",TIMMY="T IH M IY",ACTOR="AE K T ER",RICHNESS="R IH CH N AH S",CHEVY="CH EH V IY",ECTOR="EH K T ER",KOBAYASHI="K OW B AA Y AA SH IY",FIASCOS="F IY AE S K OW Z",BRIDGETON="B R IH JH T AH N",LEAMON="L IY M AH N",RIZZUTO="R IY T S UW T OW",["KILOMETER(2)"]="K IH L AH M IY T ER",PIZZUTO="P IY T S UW T OW",BEAMON="B IY M AH N",NEGOTIATIONS="N AH G OW SH IY EY SH AH N Z",GRISMORE="G R IY S M AO R",HOLMBERG="HH OW L M B ER G",BASSFORD="B AE S F ER D",SHIPES="SH AY P S",SEAMON="S IY M AH N",DIMINO="D IH M IY N OW",JAZMIN="JH AE Z M IH N",CIMINO="CH IY M IY N OW",MUSKEGON="M AH S K IY G IH N",BERNAT="B ER N AH T",ALIKE="AH L AY K",["PADDY'S"]="P AE D IY Z",PAULETTE="P AO L EH T",IMMEDIATE="IH M IY D IY AH T",PLASTICIZER="P L AE S T AH S AY Z ER",SWAYING="S W EY IH NG",PINELLAS="P IH N EH L AH S",["TUTSI'S"]="T UW T S IY Z",CHEERY="CH IH R IY",LUMINARIES="L UW M AH N EH R IY Z",SMOOTHED="S M UW DH D",["FIGHTERS'"]="F AY T ER Z",REXROTH="R EH K S R AA TH",ENCOURAGES="EH N K ER IH JH IH Z",DECRIED="D IH K R AY D",["NOBODY'S"]="N OW B AA D IY Z",["REPORTING(2)"]="R IH P AO R T IH NG",GROWLS="G R AW L Z",INCONCLUSIVE="IH N K AH N K L UW S IH V",VIEGAS="V IY G AH Z",DELAMAR="D EY L AA M AA R",OHBAYASHI="OW B AA Y AA SH IY",JOKERS="JH OW K ER Z",["BOUNDARY(2)"]="B AW N D R IY",ARRIS="AE R AH S",DISAGREEING="D IH S AH G R IY IH NG",PRESUMES="P R AH Z UW M Z",WALTERMIRE="W AO L T ER M AY R",BLOSSOM="B L AA S AH M",SCRAMBLING="S K R AE M B AH L IH NG",RECENTLY="R IY S AH N T L IY",NARCOLEPSY="N AA R K AH L EH P S IY",MATUSIK="M AH T UW S IH K",BARDULPH="B AA R D AH L F",MCCLEARY="M AH K L IH R IY",CONFESSED="K AH N F EH S T",NICOLIN="N IH K AH L IH N",REDEFINE="R IY D IH F AY N",["RESORTING(3)"]="R IY S AO R T IH NG",IMBED="IH M B EH D",NOSEWORTHY="N OW Z W ER DH IY",BRAZEE="B R AE Z IY",CHRIS="K R IH S",MARYLIN="M AE R IH L IH N",["FIFTY'S"]="F IH F T IY Z",["LATINO(2)"]="L AH T IY N OW",["PUGH'S"]="P Y UW Z",["TEDDY'S"]="T EH D IY Z",RUMPLE="R AH M P AH L",["CHUANG(2)"]="CH W AA NG",EGGED="EH G D",["HYGIENISTS(2)"]="HH AY G IY N IH S",["MISREPRESENTED(2)"]="M IH S R EH P R IH Z EH N IH D",HOFFARTH="HH AO F AA R TH",IMMERSED="IH M ER S T",GORIS="G AO R AH S",SPORTSMEN="S P AO R T S M IH N",LORIS="L AO R IH S",MORIS="M AO R IH S",BORIS="B AO R IH S",DORIS="D AO R AH S",ROSSELOT="R AA S IH L AH T",VORIS="V AO R IH S",HOOPLA="HH UW P L AA",UNIFY="Y UW N AH F AY",["MA'AM"]="M AE M",SCURDELL="S K ER D EH L",["SPRINGFIELD'S"]="S P R IH NG F IY L D Z",TORMENTS="T AO R M EH N T S",GEORGIADES="JH AO R JH IY AA D AH S",PREFAB="P R IY F AE B",CHITTERCHATTER="CH IH T ER CH AE T ER",MCKITRICK="M AH K IH T R IH K",ECSTASY="EH K S T AH S IY",SAMMY="S AE M IY",PAMMY="P AE M IY",RADICE="R AE D IH S",TAMMY="T AE M IY",BERNBACH="B ER N B AA K",POSPISIL="P OW S P IY S IY L",THOUSANDTHS="TH AW Z AH N D TH S",["ARISTEDE'S"]="AA R IH S T IY D Z",CONVERY="K AA N V ER IY",CINRAM="S IH N R AE M",KWOK="K W AA K",["ANIMAL'S"]="AE N AH M AH L Z",CRIPPLE="K R IH P AH L",EDGED="EH JH D",AGROKOMERC="AE G R AH K OW M ER K",CONNAUGHT="K AA N AO T",["EXCEPTIONALLY(2)"]="IH K S EH P SH N AH L IY",ZUELKE="Z UW L K",BOARDGAMES="B AO R D G EY M Z",CAMINO="K AH M IY N OW",REMEDIATE="R IY M IY D IY AH T",GAMINO="G AA M IY N OW",STORYTELLER="S T AO R IY T EH L ER",LEANN="L IY AE N",ARCHAEOLOGICAL="AA R K IY AH L AA JH IH K AH L",ELFSTROM="EH L F S T R AH M",BUTEAU="B Y UW T OW",DUNEGAN="D AH N IH G AE N",FORTHRIGHT="F AO R TH R AY T",BOECKMANN="B OW K M AH N",MOTOR="M OW T ER",SOPHOMORES="S AA F M AO R Z",PSYCHOPATHIC="S AY K AH P AE TH IH K",MAGRANE="M AE G R EY N",INDULGENCES="IH N D AH L JH AH N S AH Z",ROTOR="R OW T ER",INHIBITED="IH N HH IH B AH T IH D",["AMBIDEXTROUS(2)"]="AE M B IH D EH K S T R AH S",ORGERON="AO R G ER AH N",WUENSCH="W UH N SH",SURACE="S UH R AA S EY",GRIPES="G R AY P S",IDEOLOGY="AY D IY AA L AH JH IY",MALMBERG="M AA L M B ER G",["NINERS'"]="N AY N ER Z",UNDERSERVE="AH N D ER S ER V",["LINERS'"]="L AY N ER Z",["MINERS'"]="M AY N ER Z",WESTBORO="W EH S T B ER OW",BORRERO="B AO R EH R OW",KOWALEWSKI="K AW AH L EH F S K IY",FATUOUS="F AE CH AH W AH S",REMMY="R EH M IY",MICROFOSSIL="M AY K R OW F AA S AH L",PIERACCINI="P IH R AH CH IY N IY",GROBE="G R OW B",WEAKNESSES="W IY K N AH S AH Z",MACHINISTS="M AH SH IY N IH S T S",PROBE="P R OW B",KNIPPLE="N IH P AH L",SHELVES="SH EH L V Z",POTTEIGER="P AA T AY G ER",HYPERION="HH AY P IH R IY AH N",SIRIS="S AY R IH S",["HSIUNG'S"]="SH Y AH NG Z",PURIFY="P Y UH R AH F AY",ALUMINIUM="AH L UW M IH N AH M",BRAISE="B R EY Z",FOREPERSON="F AO R P ER S AH N",RENOIR="R EH N W AA R",ONDERDONK="AA N D ER D AH NG K",PRAISE="P R EY Z",REFUNDS="R IH F AH N D Z",PROLONGING="P R OW L AO NG IH NG",FAIRLY="F EH R L IY",["COORDINATES(2)"]="K OW AO R D AH N EY T S",UNDERPINNING="AH N D ER P IH N IH NG",INTERCONNECTED="IH N T ER K AH N EH K T IH D",PORTLOCK="P AO R T L AA K",COMMODORE="K AA M AH D AO R",SNIPES="S N AY P S",REGULATING="R EH G Y AH L EY T IH NG",["LAMAGNA(2)"]="L AH M AA N Y AH",INFERNAL="IH N F ER N AH L",DIGIDYNE="D IH JH IH D AY N",["COSTELLO'S"]="K AO S T EH L OW Z",ROGAINE="R OW G EY N",BUNKE="B AH NG K",GUARANTOR="G EH R AH N T AO R",TINKLING="T IH NG K AH L IH NG",DROMON="D R OW M AH N",LOMASNEY="L AA M AH S N IY",HUNKE="HH AH NG K",UNRAVELS="AH N R AE V AH L Z",LANGILLE="L AA NG G IY L IY",SECRETIVE="S IY K R AH T IH V",["CONN.(2)"]="K AH N EH T AH K AH T",ANCESTRY="AE N S EH S T R IY",HELMICH="HH EH L M IH K",SZOSTEK="SH AA S T EH K",WITZKE="W IH T S K IY",ASTOR="AE S T ER",OPRYLAND="AA P R IY L AH N D",BROCADES="B R OW K EY D Z",DIEKMANN="D IY K M AH N",FORESTER="F AO R AH S T ER",["COUNTERMEASURES(2)"]="K AW N ER M EH ZH ER Z",["WHITEHEAD(2)"]="HH W AY T HH EH D",ZAHRADNIK="Z ER AE D N IH K",LEONARDO="L IY AH N AA R D OW",["CREEK'S"]="K R IY K S",EVAPORATES="IH V AE P ER EY T S",LAPIS="L AE P AH S",MAERSK="M EH R S K",BARRYMORE="B AE R IY M AO R",ENLIGHTENING="EH N L AY T AH N IH NG",OUTFIELD="AW T F IY L D",FUGITT="F Y UW JH IH T",INGRAHAM="IH NG G R AH HH AE M",STRIDENTLY="S T R AY D AH N T L IY",["NEGLIGENT(2)"]="N EH G L IH JH AH N T",BRUEGGEMANN="B R UW G M AH N",ALSACE="AE L S AA S",["BEACH'S"]="B IY CH AH Z",["INTERCEPTORS(2)"]="IH N ER S EH P T ER Z",GIDDENS="G IH D AH N Z",SHOBE="SH OW B",AMANN="AE M AH N",BOLLENBACHER="B AA L IH N B AA K ER",SIDDENS="S IH D AH N Z",GYNECOLOGISTS="G AY N AH K AA L AH JH AH S T S",SEDATIVE="S EH D AH T IH V",["BEAUTIFULLEST(2)"]="B Y UW T AH F L AH S T",FLUORINE="F L UH R IY N",LAHIFF="L AE HH IH F",VELVETY="V EH L V AH T IY",KEYSOR="K IY S ER",ABSTINENCE="AE B S T AH N AH N S",HOSPITALITY="HH AA S P AH T AE L AH T IY",BLAISE="B L EY Z",KLANN="K L AE N",FLANN="F L AE N",LEFFEW="L EH F Y UW",PIGSTY="P IH G S T AY",ALANN="AE L AE N",STUNG="S T AH NG",PROFUSE="P R AH F Y UW S",TUTOR="T UW T ER",SUTOR="S UW T ER",MATURITIES="M AH CH UH R IH T IY Z",ACORD="AH K AO R D",OVERPRICING="OW V ER P R AY S IH NG",SKURKA="S K ER K AH",ACCESSED="AE K S EH S T",YONTEF="Y AO N T EH F",SWUNG="S W AH NG",MOREAU="M ER OW",HOGENSON="HH AA JH IH N S AH N",SAPIEN="S AE P IY N",COSGRIFF="K AA S G R IH F",MUTATED="M Y UW T EY T IH D",MCCURRY="M AH K ER IY",BRANN="B R AE N",["PLETHORA(2)"]="P L AH TH AO R AH",BRAILEY="B R EY L IY",HENBANE="HH EH N B EY N",AMBASSADORIAL="AE M B AE S AH D AO R IY AH L",STUTESMAN="S T UW T S M AH N",AUXIER="AO K S IY ER",ANTIBODY="AE N T IH B AA D IY",MILILITER="M IH L IH L IY T ER",["EARSHOT(2)"]="IY R SH AA T",["ASHAJI'S"]="AH SH AA JH IY Z",["DOCUMENTS(2)"]="D AA K Y UW M AH N T S",MYUNG="M Y AH NG",KYUNG="K Y AH NG",["ELAINE'S"]="AH L EY N Z",DEFACED="D IH F EY S T",RECESSED="R IH S EH S T",ADOBE="AH D OW B IY",RICEVILLE="R AY S V IH L",["POUND'S(2)"]="P AW N Z",BOATHOUSE="B OW T HH AW S",MINOW="M IH N OW",PRAYING="P R EY IH NG",SKYLAWN="S K AY L AO N",["POSNER'S"]="P OW Z N ER Z",MESMERIZING="M EH Z M ER AY Z IH NG",COMINO="K AH M IY N OW",DOMINO="D AA M AH N OW",CHAISE="SH EY Z",GRAYING="G R EY IH NG",FRAYING="F R EY IH NG",TINKLER="T IH NG K AH L ER",SINKLER="S IH NG K L ER",CORNUCOPIA="K AO R N AH K OW P IY AH",GOULETTE="G UW L EH T",OVERHOLSER="OW V ER HH OW L S ER",BOULETTE="B UW L EH T",GERASIMOV="JH ER AE S IH M AA V",["MEESE'S"]="M IY S IH Z",["REDUCING(2)"]="R IH D UW S IH NG",WASILEWSKI="V AH S IH L EH F S K IY",ROULETTE="R UW L EH T",["EISNER'S"]="AY S N ER Z",PROJECTIVE="P R AH JH EH K T IH V",RESIDUALS="R IH Z IH JH UW AH L Z",ORTHOGRAPHY="AO R TH AA G R AH F IY",["PHILIPS'"]="F IH L IH P S",["GRANDPARENTS'"]="G R AE N D P EH R AH N T S",["REESE'S"]="R IY S IH Z",GAUTREAU="G OW T R OW",GNANN="N AE N",DISSOLVED="D IH Z AA L V D",TYRRHENIAN="T ER IY N IY AH N",SHOULI="SH UW L IY",BULLIS="B UH L IH S",ALPHABETIZE="AE L F AH B AH T AY Z",EVENHANDED="IY V AH N HH AE N D IH D",ARTESIAN="AA R T IY ZH AH N",BOWDEN="B OW D AH N",COWDEN="K AW D AH N",DOWDEN="D AW D AH N",FINKLER="F IH NG K L ER",BENTZEN="B EH N T Z AH N",MINKLER="M IH NG K L ER",LOWDEN="L OW D AH N",["OWNERS'"]="OW N ER Z",OLGUIN="OW L G IH N",SOWDEN="S OW D AH N",POLLINATION="P AA L AH N EY SH AH N",CONCHEMCO="K AA N CH EH M K OW",BRAINWASHES="B R EY N W AA SH AH Z",STEARN="S T ER N",DUPRE="D AH P R EY",RESPONDENTS="R IH S P AA N D AH N T S",CHLORINATE="K L AO R AH N EY T",["RODIN(2)"]="R OW D AE N",ACCOMPLICES="AH K AA M P L AH S AH Z",MACDOWELL="M AH K D AW AH L",STANN="S T AE N",BERWANGER="B ER W AO NG ER",MISCONSTRUED="M IH S K AH N S T R UW D",["SKIBO(2)"]="S K IY B OW",BOLERJACK="B AA L ER JH AH K",["O'FLAHERTY"]="OW F L EY HH ER T IY",GOODREAU="G UH D R OW",TANKE="T AE NG K",JUDICE="JH UW D IH S",RANKE="R AE NG K",NARVAEZ="N AA R V AA EH Z",YANKE="Y AE NG K",WANKE="W AA NG K",MANKE="M AE NG K",JANKE="JH AE NG K",FRAILEY="F R EY L IY",BIOSCIENCES="B AY AO S IY EH N S IH Z",BANKE="B AE NG K",ARMILLA="AA R M IH L AH",HANKE="HH AE NG K",FJORD="F Y AO R D",FIREBALLS="F AY ER B AO L Z",SUPERFAST="S UW P ER F AE S T",["BESNER'S"]="B EH S N ER Z",["STEIN'S"]="S T AY N Z",CHANGED="CH EY N JH D",TROIS="T W AA",["HA'ARETZ"]="HH AA R EH T S",HOWARTH="HH AW AA R TH",GARDINIER="G AA R D IH N IY ER",SUPERCUTS="S UW P ER K AH T S",MAUNG="M AO NG",RESTRICTING="R IY S T R IH K T IH NG",MALINO="M AH L IY N OW",STREETMAN="S T R IY T M AH N",NEILSEN="N AY L S AH N",MARYLAND="M EH R AH L AH N D",REEDUCATION="R IY EH D Y AH K EY SH AH N",GUDGEON="G AH JH AH N",GOLDAMMER="G OW L D AH M ER",PREPPIE="P R EH P IY",DUDGEON="D AH JH AH N",JANTZEN="JH AE N T Z AH N",BUERGE="B Y UW R JH",BRONFMANS="B R AA N F M AH N Z",MONTROSS="M OW N T R OW S",SCHOPP="SH AA P",SABATISTA="S AA B AH T IY S T AH",MISLABELS="M IH S L EY B AH L Z",VANBLARCOM="V AE N B L AA R K AH M",SCOURGE="S K ER JH",ARTILLERY="AA R T IH L ER IY",COUNCILWOMEN="K AW N S AH L W IH M AH N",PREDOMINATE="P R IH D AA M AH N EY T",NONVIOLENT="N AA N V AY AH L AH N T",OLAGUE="OW L AA G",PLAGUE="P L EY G",LEFTWING="L EH F T W IH NG",THEREIN="DH EH R IH N",GIECK="JH IY K",MULLIS="M AH L IH S",BATDORF="B AE T D AO R F",LENKE="L EH NG K",AMBERY="AE M B ER IY",["SUMMERS'S"]="S AH M ER Z IH Z",WENKE="W EH NG K",DECHANT="D EY CH AH N T",DIECK="D IY K",BENKE="B EH NG K",HENKE="HH EH NG K",RIECK="R IY K",SIECK="S IY K",SOLAZZO="S OW L AA Z OW",GAMETOPHYTE="G AH M IY T AH F AY T",CAGGIANO="K AA JH IY AA N OW",RANTING="R AE N T IH NG",PANTING="P AE N T IH NG",DOMKE="D AA M K",WANTING="W AA N T IH NG",["DIRECTORS'(3)"]="D IY R EH K T ER Z",SANTILLO="S AE N T IH L OW",AIRLIA="EH R L IY AH",LENGTHEN="L EH NG TH AH N",SUBSIDIES="S AH B S AH D IY Z",LEUNG="L UW NG",["GREENBACK'S"]="G R IY N B AE K S",YEUNG="Y UW NG",MYREON="M AY R IY AH N",ICONOCLASTIC="AY K AH N AH K L AE S T IH K",SCARCELLA="S K AA R S EH L AH",QUILALI="K W IH L AA L IY",DEEMED="D IY M D",LONCAR="L AA N K AA R",LUPATKIN="L UW P AA T K IH N",UNFILTERED="AH N F IH L T ER D",SEEMED="S IY M D",KAMINS="K AE M IH N Z",SHELLSHOCK="SH EH L SH AA K",MEENAGHAN="M IY N AH HH AE N",REPEAT="R IH P IY T",CHEMED="K EH M EH D",LAMINER="L AE M AH N ER",KAMINER="K AE M IH N ER",PIQUANT="P IY K AH N T",DANVY="D AE N V IY",INCIRLIK="IH N S ER L IH K",REACTOR="R IY AE K T ER",KOZNOVSKY="K AA Z N AA F S K IY",THEMED="TH IY M D",SUFFICES="S AH F AY S IH Z",REOFFER="R IY AO F ER",NOVINGER="N OW V IH NG ER",LINKE="L IH NG K",LOVINGER="L AH V IH NG ER",RINKE="R IH NG K",IRANAMOK="AY R AH N AA M AA K",["MOLDAVIA(2)"]="M OW L D AA V IY AH",ZINKE="Z IH NG K",SHAKEDOWNS="SH EY K D AW N Z",["KLEIN'S"]="K L AY N Z",["O'GUIN"]="OW G UW IY N",KIMBRIEL="K IH M B R IY AH L",FINKE="F IH NG K",["SUBSTANTIATION(2)"]="S AH B S T AE N SH IY EY SH AH N",APPREHENSIONS="AE P R IH HH EH N SH AH N Z",["LIGGETT'S"]="L IH G EH T S",DEALBA="D IY AE L B AH",LEBOWITZ="L EH B AH W IH T S",RENTING="R EH N T IH NG",FACULTATIVE="F AE K AH L T EY T IH V",ENGEBRETSON="EH NG G IH B R IH T S AH N",ALLERGY="AE L ER JH IY",ACQUIESCING="AE K W IY EH S IH NG",CROWBAR="K R OW B AA R",PAREKH="P AA R IH K",GRASSEL="G R AE S AH L",MELODRAMAS="M EH L AH D R AA M AH Z",HARVESTABLE="HH AA R V AH S T AH B AH L",LITCHFIELD="L IH CH F IY L D",GRABSKI="G R AE B S K IY",DUBOISE="D UW B OY S",EVERDING="EH V ER D IH NG",PETRONIO="P EH T R OW N IY OW",DENTING="D EH N T IH NG",NONEMERGENCY="N AA N IH M ER JH AH N S IY",["CORP'S"]="K AO R P S",["BODZIAK'S"]="B AO D Z IY AE K S",OFFORD="AA F ER D",ODONOHUE="OW D AA N AH HH Y UW",CRAMTON="K R AE M T AH N",FLUOR="F L UW ER",["AVANA'S"]="AH V AE N AH Z",LAZIER="L EY Z IY ER",RESOURCEFULNESS="R IY S AO R S F AH L N AH S",HAZIER="HH EY Z IY ER",CORBUSIER="K AO R B Y UW S Y ER",GUADALUPE="G W AA D AH L UW P",CHUNG="CH AH NG",CYTOPLASMIC="S AY T AH P L AE Z M IH K",CARMY="K AA R M IY",SHUTOUT="SH AH T AW T",AGGREGATE="AE G R AH G AH T",SHARAR="SH ER AA R",PAYABLE="P EY AH B AH L",BORDELON="B AO R D IH L AA N",RANKLING="R AE NG K L IH NG",PURPLE="P ER P AH L",ISHIMURA="IY SH IH M UW R AH",COMPOST="K AA M P OW S T",SWANN="S W AA N",STEAGLE="S T IY G AH L",BROCIOUS="B R AH SH IY S",["ENSURES(2)"]="IH N SH UH R Z",INVENTORY="IH N V AH N T AO R IY",CRESPI="K R EH S P IY",MCFERRON="M AH K F EH R AH N",GULYAS="G UW L Y AH S",SOLACE="S AA L AH S",WILLIAMSBURGH="W IH L Y AH M Z B ER G",JEREMIAH="JH EH R AH M AY AH",DEFORD="D EH F ER D",SCHIFF="SH IH F",BAWDEN="B AO D AH N",CHOLERA="K AA L ER AH",SYBASE="S AY B EY S",DONATIONS="D OW N EY SH AH N Z",MINTING="M IH N T IH NG",BELLIS="B EH L IH S",IMAGINED="IH M AE JH AH N D",KOTLOWITZ="K AA T L AH W IH T S",["MERCHANTS'"]="M ER CH AH N T S",BECHTELSVILLE="B EH K T EH L Z V IH L",HINTING="HH IH N T IH NG",GINTING="JH IH N T IH NG",WOLFGANG="W UH L F G AE NG",WAYNESBORO="W EY N Z B ER OW",ARNOW="AA R N OW",PELINO="P EH L IY N OW",NANDAIME="N AE N D EY M",SCHRAEDER="SH R EH D ER",SUDANESE="S UW D AH N IY Z",CHARBONEAU="SH AA R B AH N OW",TEAGUE="T IY G",GRILLOT="G R IH L AH T",ENSERCH="EH N S ER CH",ROTATED="R OW T EY T IH D",CONCESSIONAL="K AH N S EH SH AH N AH L",SERRATED="S EH R EY T IH D",LEAGUE="L IY G",["UNOSOM(2)"]="Y UW N OW S AH M",RIDGECREST="R IH JH K R EH S T",REICHELDERFER="R AY K IH L D ER F ER",FLUNG="F L AH NG",CLUNG="K L AH NG",EPIDERMIS="EH P AH D ER M AH S",WORLDWIDE="W ER L D W AY D",HILARIA="HH IY L AA R IY AH",YOUNG="Y AH NG",CHECK="CH EH K",JANATA="JH AH N AA T AH",STROSNIDER="S T R AA S N AY D ER",UNMENTIONABLE="AH N M EH N SH AH N AH B AH L",LAZARO="L AH Z AA R OW",SHECK="SH EH K",LAMINNE="L AH M IH N",TILLIS="T IH L IH S",WILLIS="W IH L IH S",LEBED="L EH B EH D",BEECK="B IY K",SPINOSA="S P IY N OW S AH",LEPPLA="L EH P L AH",DISTRICTING="D IH S T R IH K T IH N G",GILLIS="G IH L IH S",ALOIS="AA L OY S",REDISCOVERY="R IY D IH S K AH V R IY",HILLIS="HH IH L IH S",LIFORD="L IH F ER D",IMMEASURABLY="IH M EH ZH ER AE B L IY",MILLIS="M IH L IH S",REECK="R IY K",AILMENTS="EY L M AH N T S",CHAISSON="CH EY S AH N",CANVASES="K AE N V AH S IH Z",DISRESPECTS="D IH S R IH S P EH K T S",PARAMUS="P ER AE M AH S",MINERALS="M IH N ER AH L Z",["ICKES'(2)"]="IH K IY Z",["CHAMORRO'S"]="CH AH M AO R OW Z",BECHTOL="B EH K T AH L",SHOOP="SH UW P",LIUZZI="L IY UW T S IY",ELGIE="EH L JH IY",GUINAN="G W IY N AA N",JEFFERIS="JH EH F ER IH S",ELVIN="EH L V IH N",ALVIN="AE L V IH N",TEUFEL="T OY F AH L",WILMA="W IH L M AH",TRENDLINE="T R EH N D L AY N",ZBIG="Z B IH G",LAPRE="L EY P ER",PRIVILEGE="P R IH V L AH JH",BLOSSOMED="B L AA S AH M D",EPPERS="EH P ER Z",BAMAKO="B AE M AH K OW",BALOW="B AE L OW",ROPERS="R OW P ER Z",EQUATES="IH K W EY T S",["QUAKE'S"]="K W EY K S",DEBONIS="D EH B AH N IH S",BARRAGE="B ER AA ZH",FREEWHEELING="F R IY W IY L IH NG",FUJIYA="F UW JH IY Y AH",MAGIE="M EY JH IY",["HAGIN(2)"]="HH AE G IH N",PHEROMONE="F EH R AH M OW N",CHAPPIE="CH AE P IY",NUREYEV="N ER AY AH V",ESPINO="EY S P IY N OW",GENERALS="JH EH N ER AH L Z",DERAMUS="D EH R AH M IH S",DEPARTED="D IH P AA R T AH D",DISSOCIATION="D IH S OW S IY EY SH AH N",HYDROX="HH AY D R AO K S",LEUZZI="L UW Z IY",SHORTENING="SH AO R T AH N IH NG",["ANGELINO'S"]="AE N JH AH L IY N OW Z",SPACER="S P EY S ER",LUKYANOV="L UW K Y AH N AA V",SFUZZI="S F UW T Z IY",PALLADIUM="P AH L EY D IY AH M",SELMA="S EH L M AH",VELMA="V EH L M AH",FABIAN="F EY B IY AH N",UPPERS="AH P ER Z",BEVINGTON="B EH V IH NG T AH N",BERSHAD="B ER SH AA D",SINGAPOREAN="S IH NG G AH P AO R IY AH N",SAXOPHONES="S AE K S AH F OW N Z",["EMPEROR'S"]="EH M P ER ER Z",KOPLOVITZ="K AA P L AH V IH T S",PALMA="P AA L M AH",CALMA="K AA L M AH",OSTROM="AA S T R AH M",DALMA="D AA L M AH",SALLADE="S AE L EY D",UNFAIRLY="AH N F EH R L IY",SUSPENSEFUL="S AH S P EH N S F AH L",["SHUFFLER(2)"]="SH AH F L ER",ANGIE="AE N JH IY",DEFLECTING="D IH F L EH K T IH NG",BUNGALOWS="B AH NG G AH L OW Z",PEDOPHILES="P EH D OW F AY L Z",MOYNAHAN="M OY N AH HH AE N",["REDIFER(2)"]="R IY D AH F ER",HAIG="HH EY G",FATHERED="F AA DH ER D",IRRITATED="IH R AH T EY T AH D",["AVRAHAM(2)"]="AA V R AH HH AA M",CAPTIVATING="K AE P T IH V EY T IH NG",BRITTIN="B R IH T IH N",["SEMIDRY(3)"]="S EH M AY D R AY",CITTADINO="CH IY T AA D IY N OW",HALFDAN="HH AE L F D AH N",REAPPOINTMENT="R IY AH P OY N T M AH N T",OGILVIE="AA JH IH L V IY",CHOMBIONO="CH AA M B IY OW N OW",["ESTABLISH(2)"]="IY S T AE B L IH SH",["TENNESSEE'S"]="T EH N AH S IY Z",SNAPPY="S N AE P IY",["GRADSTEIN(2)"]="G R AE D S T AY N",SHELDEN="SH EH L D AH N",PINSHAN="P IH N SH AH N",CHAUNCE="CH AO N S",TALLAHASSEANS="T AE L AH HH AE S IY AH N Z",DISSATISFY="D IH S AE T AH S F AY",STRASSBURGER="S T R AE S B ER G ER",INSISTENCE="IH N S IH S T AH N S",BEHRNS="B EH R N Z",ARREOLA="AA R IY AA L AH",WIPERS="W AY P ER Z",VIPERS="V AY P ER Z",POLARIZING="P OW L ER AY Z IH NG",ELVINGTON="EH L V IH NG T AH N",["DONAHUE(2)"]="D AA N AH Y UW",PIPERS="P AY P ER Z",CIRCLE="S ER K AH L",MUSCULAR="M AH S K Y AH L ER",TRANSPLANTED="T R AE N S P L AE N T IH D",IRRELEVANCE="IH R EH L AH V AH N S",ALVARADO="AE L V ER AA D OW",WALRUS="W AO L R AH S",SAWTELL="S AO T EH L",BERTOLOTTI="B ER T OW L OW T IY",RECLAIMING="R IY K L EY M IH NG",NEIGHMOND="N EY M AH N D",["BUDDY'S"]="B AH D IY Z",DORSET="D AO R S IH T",SHISLER="SH IH S AH L ER",CRAPPIE="K R AE P IY",MOSLEMS="M AA Z L AH M Z",WHISLER="W IH S L ER",STATURE="S T AE CH ER",MOURADIAN="M AO R EY D IY AH N",SACHS="S AE K S",ARPINO="AA R P IY N OW",IMPARTED="IH M P AA R T IH D",WACHS="W AO K S",CATASTROPHIC="K AE T AH S T R AA F IH K",["FINANCINGS(2)"]="F IH N AE N S IH NG Z",TRACER="T R EY S ER",NEVEAU="N IH V OW",["DIGITI(2)"]="D IH JH AH T IY",DEVEAU="D IH V OW",OEDIPAL="EH D AH P AH L",CLUNY="K L UW N IY",BRACER="B R EY S ER",RECOLLECTION="R EH K AH L EH K SH AH N",TRAUTH="T R AO TH",ESHBAUGH="IH SH B AO",KRAUTH="K R AO TH",TEXSCAN="T EH K S K AE N",AFFORDING="AH F AO R D IH NG",["ROCARD(2)"]="R OW K AA R D",["RELIANCE(2)"]="R IY L AY AH N S",ASSERTIVE="AH S ER T IH V",CLASSICS="K L AE S IH K S",["ACCUMULATIVELY(2)"]="AH K Y UW M Y AH L AH T IH V L IY",BOGIE="B UH G IY",["MILLIONAIRE'S"]="M IH L Y AH N EH R Z",APPRECIATES="AH P R IY SH IY EY T S",JEANBAPTISTE="ZH EH N B AH P T IH S T",DEBATERS="D AH B EY T ER Z",PHILIDA="F AH L IY D AH",TOOTHAKER="T UW TH AH K ER",STOOP="S T UW P",LOMAX="L OW M AE K S",["FOLIAGE(2)"]="F OW L IY IH JH",OPHTHALMOSCOPE="AA F TH AE L M AH S K OW P",GUIDERA="G IY D EH R AH",HIGHLANDER="HH AY L AE N D ER",LOPATA="L OW P AA T AH",CALTRANS="K AE L T R AE N Z",DESALINATION="D IY S EY L IH N EY SH AH N",["ALLIES(2)"]="AH L AY Z",BRESETTE="B R IH S EH T",PISTACHIOS="P AH S T AE SH IY OW Z",REFLECTIVE="R IH F L EH K T IH V",["STARS'"]="S T AA R Z",INTERRELATE="IH N T ER R IH L EY T",NAVAJO="N AA V AH HH OW",REPLENISHMENT="R IH P L EH N IH SH M AH N T",PENTECOST="P EH N T AH K AO S T",NIGHTERS="N AY T ER Z",LIGHTERS="L AY T ER Z",SCHIEFFER="SH IY F ER",MCRAINEY="M AH K R AE N IY",COVINGTON="K AH V IH NG T AH N",FIGHTERS="F AY T ER Z",["DRAGON'S"]="D R AE G AH N Z",GRAVEL="G R AE V AH L",MAROGEN="M EH R OW G AH N",FRAVEL="F R AE V AH L",NOBLESSE="N OW B L EH S",POSTDATED="P OW S T D EY T AH D",MANFULLY="M AE N F AH L IY",RABORN="R AE B ER N",PAYROLLS="P EY R OW L Z",CONFUSE="K AH N F Y UW Z",TABORN="T AE B ER N",NACOBRE="N AE K AH B R AH",MALASPINA="M AA L AA S P IY N AH",SLEATOR="S L EY T ER",EDGMON="EH JH M AH N",TETHERED="T EH DH ER D",MASTELLER="M EY S T AH L ER",AEROMEXICO="EH R OW M EH K S IH K OW",PROGNOSTICATES="P R AA G N AA S T AH K EY T S",RIKSDAG="R IH K S D AE G",RUSSET="R AH S IH T",MAYFLOWER="M EY F L AW ER",MONDELLO="M AA N D EH L OW",FLINTLOCK="F L IH N T L AA K",STERNS="S T ER N Z",OPERATING="AA P ER EY T IH NG",STEREOTYPES="S T EH R IY AH T AY P S",WILLFULLY="W IH L F AH L IY",OVERDONE="OW V ER D AH N",["JUPITER(2)"]="JH UW P IH T ER",COWIN="K AW IH N",GOWIN="G AW IH N",SIGMON="S IH G M AH N",BUNTSTROCK="B AH N T S T R AA K",NASHNAMIE="N AE SH N AH M IY",LOGIE="L OW JH IY",NEWTOWNE="N UW T AW N",ROWIN="R OW IH N",TALKABLE="T AO K AH B AH L",["PURIM(2)"]="P UH R IY M",["GRBAVICA(2)"]="G ER B AH V AY K AH",JOANN="JH OW AE N",["PREDICTS(2)"]="P R IY D IH K T S",MUMMA="M AH M AH",DRUCIE="D R AH K IY",BRUCIE="B R AH K IY",SUMMA="S UW M AH",UNWIN="AO N W IH N",REBORN="R IY B AO R N",GENDRISEK="JH EH D R IH S EH K",MOLANDER="M AA L AH N D ER",CORINNE="K ER IY N",FILIBUSTERED="F IH L AH B AH S T ER D",OSTRAND="AA S T R AH N D",KOLANDER="K AA L AH N D ER",["STUMBLING(2)"]="S T AH M B L IH NG",SLOOP="S L UW P",SEGUIN="S AH G IY N",FUNERALS="F Y UW N ER AH L Z",FRUITLESS="F R UW T L AH S",ICEBREAKERS="AY S B R EY K ER Z",STORYBOOK="S T AO R IY B UH K",RESUMPTION="R IH Z AH M P SH AH N",SEDUCER="S IH D UW S ER",["BERNSTEINS(2)"]="B ER N S T IY N Z",["EVAPORATION(2)"]="IY V AE P ER EY SH AH N",OUTRAGE="AW T R EY JH",MODEMS="M OW D AH M Z",["PERIDOT(2)"]="P EH R IH D OW",["ACTION'S"]="AE K SH AH N Z",BOLANDER="B AA L AH N D ER",COLANDER="K AA L AH N D ER",UNDISCOVERED="AH N D IH S K AH V ER D",HOMOZYGOTE="HH OW M OW Z AY G OW T",["CRUMBLING(2)"]="K R AH M B L IH NG",MONTREALERS="M AH N T R IY AO L ER Z",BOSSERMAN="B AO S ER M AH N",SUBVERT="S AH B V ER T",["HORNET'S"]="HH AO R N AH T S",ALLTOP="AO L T AA P",ASWIN="AH S W IH N",ILLG="IH L G",VOLCANOLOGISTS="V AO L K AH N AO L AH JH IH S T S",KNOOP="N UW P",["WHITELOCK(2)"]="HH W AY T L AA K",WILFERT="W IH L F ER T",BISSET="B IH S IH T",MASTIFF="M AE S T AH F",QUERNS="K W ER N Z",OPERATES="AA P ER EY T S",ERWIN="ER W IH N",PIGNATO="P IY G N AA T OW",IRWIN="ER W AH N",CHAFFIN="CH AE F IH N",CONDEMNATION="K AA N D AH M N EY SH AH N",["EVERETTS(2)"]="EH V R AH T S",ASSUMES="AH S UW M Z",HABICHT="HH AE B IH K T",MASTERCARDS="M AE S T ER K AA R D Z",SHALIKASHVILI="SH AE L IY K AA SH V IY L IY",SCIARRA="S IY AA R AH",DISPIRITED="D IH S P IH R AH T IH D",CHICAGOANS="SH AH K AA G OW AH N Z",ANGELOU="AE N JH AH L UW",GONGORA="G OW NG G AO R AH",PONTIFICATION="P AA N T IH F AH K EY SH AH N",LIEUTENANTS="L UW T EH N AH N T S",DANJU="D AE N JH UW",["LOCAL'S"]="L OW K AH L Z",DEVINCENTIS="D EH V IH N S EH N T IH S",TROUTWINE="T R AW T W AY N",SIGNIFICANT="S AH G N IH F IH K AH N T",KRETSCHMAR="K R EH CH M ER",NEISLER="N AY S AH L ER",MEISLER="M AY S AH L ER",["ORDNANCE'S"]="AO R D N AH N S IH Z",HEISLER="HH AY S AH L ER",GEISLER="G AY S L ER",GILLOTT="G IH L AH T",["INTERNATIONALIZED(2)"]="IH N ER N AE SH AH N AH L AY Z D",REUTERS="R OY T ER Z",SCATOLOGY="S K AE T AO L AH JH IY",ELIMINATIONS="IH L IH M IH N EY SH AH N Z",["STAAR'S"]="S T AA R Z",KEECH="K IY CH",LEECH="L IY CH",MEECH="M IY CH",MCCHESNEY="M AH K CH EH Z N IY",MOSTELLER="M AA S T AH L ER",TROOP="T R UW P",VEECH="V IY CH",WEECH="W IY CH",HEARTENED="HH AA R T AH N D",FEATURE="F IY CH ER",CASTELLANO="K AA S T EH L AA N OW",CREATOR="K R IY EY T ER",REWARDED="R IH W AO R D IH D",["THEY'D"]="DH EY D",ECUMENICAL="EH K Y UW M EH N IH K AH L",["CROP'S"]="K R AA P S",FRITZLER="F R IH T S L ER",["RECESSION'S"]="R IY S EH SH AH N Z",BAYLIFF="B EY L IH F",ASSUMPTION="AH S AH M P SH AH N",["RUBBERMAID'S"]="R AH B ER M EY D Z",CROAKER="K R OW K ER",MISCOMMUNICATION="M IH S K AH M Y UW N AH K EY SH AH N",EXCLAIMING="IH K S K L EY M IH NG",CHAMPIONS="CH AE M P IY AH N Z",["PROTECTIONISTS(3)"]="P R AH T EH K SH AH N IH S",PATUXENT="P AH T AH K S AH N T",["HASBRO'S"]="HH AE Z B R OW Z",PURIFIER="P Y UH R AH F AY ER",LANCLOS="L AE N K L OW Z",RISC="R IH S K",GRANDSON="G R AE N D S AH N",SOMMA="S AA M AH",DILG="D IH L G",HOCEVAR="HH OW S EY V AA R",RAISLER="R EY Z L ER",DISC="D IH S K",EADIE="EH D IY",GRANULES="G R AE N Y AH L Z",FISC="F IH S K",HUERTER="HH ER T ER",FILMA="F IH L M AH",DEVERELL="D EY V EH R EY L",HILMA="HH IH L M AH",["KVAMME(2)"]="K V AA M EY",ALUMNUS="AH L AH M N AH S",REICHMANN="R AY K M AH N",BALISTRERI="B AA L IY S T R EH R IY",LIQUIDATOR="L IH K W IH D EY T ER",["LIDDY'S"]="L IH D IY Z",PEVERELL="P EH V ER EH L",SUBURBS="S AH B ER B Z",PIECH="P IY CH",ADDIE="AE D IY",DENOSSE="D IH N OW S",WIECH="W IY CH",EDDIE="EH D IY",HAUPTMAN="HH AW P T M AH N",["KOOP'S"]="K UW P S",KAGAMI="K AE G AH M IY",MOELLERING="M OW L ER IH NG",SCOOP="S K UW P",COMMENTERS="K AA M EH N T ER Z",BAFFLING="B AE F AH L IH NG",["EASTWOOD'S"]="IY S T W UH D Z",VANDENBOSCH="V AE N D AH N B AO SH",COLLEDGE="K AA L IH JH",OUTINGS="AW T IH NG Z",GROUNDLING="G R AW N D L IH NG",MALICIOUSLY="M AH L IH SH IH S L IY",PERSET="P ER S EH T",["MUSKIE'S"]="M AH S K IY Z",STEENSON="S T IY N S AH N",INTEROPERATE="IH N T ER AO P ER AH T",ALWIN="AE L W IH N",SPACERS="S P EY S ER Z",MCCOMAS="M AH K OW M AH S",["RELAXING(2)"]="R IY L AE K S IH NG",["OBSERVATORY'S"]="AH B Z ER V AH T AO R IY Z",MUDGETT="M AH JH IH T",["DANGLING(2)"]="D AE NG G L IH NG",RASHEED="R AH SH IY D",WAFFLING="W AA F L IH NG",["SHOP'S"]="SH AA P S",WOLFERT="W UH L F ER T",ELWIN="EH L W IH N",DISGRUNTLEMENT="D IH S G R AH N T AH L M AH N T",ALFIE="AE L F IY",ZONGOL="Z AO NG G AO L",RHEINISCH="R AY N IH SH",ELFIE="EH L F IY",TAVERNA="T AA V EH R N AH",["PER-SE"]="P ER S EY",RECURRED="R IY K ER D",MONGOL="M AA NG G AH L",OBSTRUCTIONISM="AH B S T R AH K SH AH N IH Z AH M",GEMMA="JH EH M AH",STENDHAL="S T EH N D AA L",DEMMA="D IY M AH",MUNITIONS="M Y UW N IH SH AH N Z",["CAROLINIAN(2)"]="K EH R AH L IH N IY AH N",PREVAIL="P R IH V EY L",APPOINTING="AH P OY N T IH NG",FEIG="F IY G",DISCERNS="D IH S ER N Z",AFTERLIVES="AE F T ER L AY V Z",ACQUISITION="AE K W AH Z IH SH AH N",MOISHE="M OW SH EH",["O'BRADOVICH"]="OW B R AE D AH V IH CH",SIELAFF="S IY L AE F",SODOMIZING="S AO D AH M AY Z IH NG",AGLOW="AH G L OW",CARAKER="K AE R AH K ER",PLANARIAN="P L AH N EH R IY AH N",GREGORICH="G R EH G ER IH K",FREDERICK="F R EH D R IH K",RUTABAGAS="R UW T AH B EY G AH Z",["KRIEGER'S"]="K R IY G ER Z",["REQUESTED(3)"]="R IY K W EH S T IH D",MANPOWER="M AE N P AW ER",OCCURRED="AH K ER D",SHAMEFUL="SH EY M F AH L",PHYSICALLY="F IH Z IH K AH L IY",ALODIE="AH L AA D IY",MISHANDLES="M IH S HH AE N D AH L Z",GAVIN="G AE V IH N",JACKPOT="JH AE K P AA T",BIRDSEED="B ER R D S IY D",NAVIN="N AA V IY N",PROTRACTED="P R OW T R AE K T IH D",LAVIN="L AE V IH N",RAVIN="R AE V IH N",SAVIN="S AE V IH N",["WESTTECH'S"]="W EH S T EH K S",DETERMINE="D AH T ER M AH N",SEMINARIES="S EH M AH N EH R IY Z",DESLAURIERS="D EH S L AO R IY ER Z",CAVIN="K AE V IH N",BELOW="B IH L OW",CONCENTRATING="K AA N S AH N T R EY T IH NG",BEEFSTEAK="B IY F S T EY K",ARIEL="EH R IY AH L",MAMMA="M AA M AH",COMPOTE="K AA M P OW T",["GOVERNMENTAL(2)"]="G AH V ER N M EH N T AH L",FRIEL="F R IY L",GAMMA="G AE M AH",PARODIST="P AE R AH D IH S T",NAKAHARA="N AA K AA HH AA R AH",["CHEZ(2)"]="CH EH Z",UNDERPERFORMANCE="AH N D ER P ER F AO R M AH N S",BERLACK="B ER L AE K",AGUILERA="AA G W IY L EH R AH",["RESPONDS(2)"]="R IY S P AA N D Z",MISERS="M AY Z ER Z",["LAROCHE'S"]="L AA R OW SH IH Z",GRANDT="G R AE N T",["WEREN'T"]="W ER AH N T",MATKINS="M AE T K IH N Z",COLUMNED="K AA L AH M D",MCCLAREN="M AH K L AA R AH N",RESPIRATOR="R EH S P ER EY T ER",CATKINS="K AE T K AH N Z",LEBOUEF="L AH B AH F",CLAUSS="K L AO S",SEVIN="S EH V IH N",["MINGLING(2)"]="M IH NG G L IH NG",OTTENS="AA T AH N Z",["SINGLING(2)"]="S IH NG G L IH NG",["TINGLING(2)"]="T IH NG G L IH NG",BHOPAL="B OW P AA L",NEVIN="N EH V IH N",KEVIN="K EH V IH N",LEVIN="L EH V IH N",BEVIN="B EH V IH N",DISJOINTED="D IH S JH OY N T IH D",YARMULKE="Y AA R M AH L K AH",IFINT="AY F IH N T",HANISEE="HH AE N IH S IY",COLUCCIO="K OW L UW CH IY OW",CLIFTON="K L IH F T AH N",MINUTEMAN="M IH N AH T M AE N",CONSTRUCTION="K AH N S T R AH K SH AH N",REBALANCING="R IY B AE L AH N S IH NG",SNORKELING="S N AO R K AH L IH NG",FEINT="F EY N T",MCCONATHY="M AH K AA N AH TH IY",ANNUM="AE N AH M",SONUM="S AA N AH M",SCHRIEVER="SH R IY V ER",["VELOBIND(2)"]="V EH L OW B AY N D",["UNRELIABLE(2)"]="AH N R IY L AY AH B AH L",GENELABS="JH EH N AH L AE B Z",PERUVIAN="P ER UW V IY AH N",["FRIENDSHIPS(2)"]="F R EH N SH IH P S",["ACCOUNTABILITY(2)"]="AH K AW N AH B IH L IH T IY",PHILBY="F IH L B IY",ECKROTH="EH K R AO TH",REQUISITION="R EH K W AH Z IH SH AH N",["SOYUZ(2)"]="S OY UW Z",SWIG="S W IH G",PACED="P EY S T",AMPUTATED="AE M P Y AH T EY T IH D",RACED="R EY S T",MEITZLER="M AY T S L ER",TWIG="T W IH G",CRISLER="K R IH S AH L ER",COSSET="K AA S AH T",["SALIM(2)"]="S AA L IY M",["ENTERED(2)"]="EH N ER D",SHOWSCAN="SH OW S K AE N",EWIG="Y UW IH G",FACED="F EY S T",TOYOTAS="T OY OW T AH Z",COURTAULDS="K AO R T AO L D Z",IMPOVERISHES="IH M P AA V R IH SH AH Z",JAKARTA="JH AH K AA R T AH",TAINT="T EY N T",SAINT="S EY N T",PAINT="P EY N T",MOLESTER="M AH L EH S T ER",SPECTER="S P EH K T ER",CHECHNYA="CH EH CH N IY AH",["LINCOLN'S"]="L IH NG K AH N Z",RESUMES="R IH Z UW M Z",FRAUDSTER="F R AO D S T ER",MYSLIWIEC="M IH S L IH V IY K",["ENGINE'S"]="EH N JH AH N Z",PRESSTEK="P R EH S T EH K",GOEMON="G OW EY M AH N",["{BRACE"]="B R EY S",CLARIDON="K L EH R AH D AA N",PROVENCIO="P R OW V EH N S IY OW",COMECON="K AA M AH K AA N",SOFIE="S AA F IY",RUTHLESS="R UW TH L AH S",GIANNOLA="JH AA N OW L AH",FAINT="F EY N T",CALILLS="K AH L IH L Z",AZZARO="AA T S AA R OW",["JACOB'S"]="JH EY K AH B Z",GIOVENCO="JH OW V EH N K OW",CONRAIL="K AA N R EY L",["NATION'S"]="N EY SH AH N Z",["DIGITS(2)"]="D IH JH IH T S",["SOUNDTRACK(2)"]="S AW N T R AE K",["MERRY-GO-ROUND"]="M EH R IY G OW R AW N D",TRISLER="T R IH S AH L ER",DETOX="D IY T AA K S",BLOODLETTING="B L AH D L EH T IH NG",UNDERWHELMED="AH N D ER W EH L M D",["RUBINSTEIN(2)"]="R UW B IH N S T AY N",STARRS="S T AA R Z",ZURN="Z ER N",MADDISON="M AE D IH S AH N",MCGEGAN="M AH G EH G AH N",AMILIA="AA M IY L IY AH",KLEMM="K L EH M",GLOBAL="G L OW B AH L",BODICE="B AA D IH S",MUMPOWER="M AH M P OW ER",PROPFAN="P R AA P F AE N",["FINANCIALLY(3)"]="F AY N AE N SH AH L IY",MISPRISION="M IH S P R IH ZH AH N",BURN="B ER N",FURGERSON="F ER G ER S AH N",PAPERMATE="P EY P ER M EY T",UNSUCCESSFUL="AH N S AH K S EH S F AH L",["ANASAZI(2)"]="AE N AH S AA Z IY",LAPIER="L EY P IY ER",SCHAAL="SH AA L",NAPIER="N EY P IY ER",SIMONIS="S IH M AH N IH S",RAPIER="R EY P IY ER",MERC="M ER K",TRILBY="T R IH L B IY",STICKA="S T IH K AH",HURN="HH ER N",["REPUBLICAN(2)"]="R IY P AH B L AH K AH N",["OAKLAND'S"]="OW K L AH N D Z",EPSILON="EH P S AH L AA N",BARDOLPH="B AA R D AA L F",BRANISLOV="B R AE N IH S L AA V",["TEAFORD(2)"]="T IY F ER D",BURDENSOME="B ER D AH N S AH M",FALKENSTEIN="F AO K AH N S T AY N",ROSENOW="R OW Z AH N AW",OBREMSKY="OW B R EH M S K IY",NINAGAWA="N IY N AA G AA W AH",SCHUCHARDT="SH AH K AA R T",["INVADED(2)"]="IH N V EY D IH D",["HERBICIDES(2)"]="HH ER B AH S AY D Z",MCGLOTHEN="M AH G L AA TH AH N",DEDMON="D EH D M AH N",MCCLUSKEY="M AH K L AH S K IY",BONAVIA="B AA N EY V IY AH",DIFFICULTLY="D IH F AH K AH L T L IY",REDMON="R EH D M AH N",["SEARS'S(2)"]="S IH R Z",LIMPED="L IH M P T",POMODORO="P AA M AH D AO R OW",GRANDPARENTS="G R AE N D P EH R AH N T S",CARRION="K EH R IY AH N",OVERCOMES="OW V ER K AH M Z",GERDEMAN="G ER D M AH N",["EXTRACTS(2)"]="IH K S T R AE K T S",KINDERGARTENS="K IH N D ER G AA R T AH N Z",GRAYISH="G R EY IH SH",["ALLEGIS'"]="AE L EY JH IH S",ELEUTHERA="IH L UW TH ER AH",RAINMAKER="R EY N M EY K ER",HARC="HH AA R K",DAHLIA="D AE L Y AH",PERCOLATING="P ER K AH L EY T IH NG",REPAIRMAN="R IH P EH R M AE N",STARVATION="S T AA R V EY SH AH N",CLAMPDOWN="K L AE M P D AW N",STEIDINGER="S T AY D IH NG ER",BREADFRUIT="B R EH D F R UW T",DOIG="D OY G",BYRN="B IH R N",["DICOMED(2)"]="D IY K OW M D",["CONSEQUENTLY(2)"]="K AA N S AH K W EH N T L IY",NARC="N AA R K",MARC="M AA R K",HEARTFELT="HH AA R T F EH L T",PARC="P AA R K",GOTSCHALL="G AA CH AH L",CANINO="K AA N IY N OW",["BOWRON(2)"]="B OW R AA N",ARTICULATORY="AA R T IH K Y AH L AH T AO R IY",["SYNOVUS(2)"]="S AY N OW V AH S",BRIG="B R IH G",HYPNOSIS="HH IH P N OW S AH S",INTELCOM="IH N T EH L K AA M",["FIREPLACES(2)"]="F AY R P L EY S IH Z",UMPTEENTH="AH M P T IY N TH",FORAKER="F AO R AH K ER",["PRESTIGIOUS(2)"]="P ER S T IY JH AH S",BYNUM="B IH N AH M",CIARAVINO="CH ER AA V IY N OW",TRIG="T R IH G",POLITICKING="P AA L AH T IH K IH NG",PRIG="P R IH G",NUMERALS="N UW M ER AH L Z",FISCHL="F IH S K AH L",CHOLESTYRAMINE="CH OW L EH S T IH R AH M AY N",["KIGHTLINGER(2)"]="K AY T L IH NG ER",MARBOD="M AA R B AA D",["SNACKWELL'S"]="S N AE K W EH L Z",SPAGNUOLO="S P AA G N Y UW OW L OW",INGREDIENTS="IH N G R IY D IY AH N T S",EMILIA="AH M IY L IY AH",INQUISITION="IH N K W AH Z IH SH AH N",["IZZY'S"]="IH Z IY Z",GADHAFI="G AH D AA F IY",ALIG="AE L IH G",INCREMENTALLY="IH N K R AH M EH N T AH L IY",BIDDISON="B IH D IH S AH N",SAVIMBI="S AH V IH M B IY",TRIANGULAR="T R AY AE NG G Y AH L ER",DEHUMANIZE="D IH HH Y UW M AH N AY Z",SPYWARE="S P AY W EH R",COBIAN="K OW B IY AH N",["EASTLAND'S(4)"]="IY S L AE N D Z",CARAVEO="K AA R AA V IY OW",METHANEX="M EH TH AH N EH K S",["NOTEBOOM(2)"]="N UW T IH B UW M",["INTERNATIONALIZED(3)"]="IH N ER N AE SH N AH L AY Z D",LUCKENBILL="L AH K IH N B AH L",["COOKBOOK'S"]="K UH K B UH K S",MCLESTER="M AH K L EH S T ER",UNWISELY="AH N W AY Z L IY",TRAGEDIES="T R AE JH AH D IY Z",["BANGALORE'S"]="B AE NG G AH L AO R Z",HENDRON="HH EH N D R AH N",["OTTERSON'S"]="AA T ER S AH N Z",GENRE="ZH AA N R AH",BILOW="B IH L OW",DAZZLED="D AE Z AH L D",MACLAREN="M AH K L EH R AH N",BERENDZEN="B EH R IH N D Z AH N",["MARVEL'S"]="M AA R V AH L Z",FANTASIZING="F AE N T AH S AY Z IH NG",MINNIG="M IH N IH G",COSMODROME="K AO Z M AH D R OW M",VANDORN="V AE N D AO R N",NERVOUS="N ER V AH S",DONATES="D OW N EY T S",EMIG="EH M IH G",FRITZEN="F R IH T Z AH N",OSTERREICHISCHE="AO S T ER R AY K IH SH IY",GOVIER="G OW V IY ER",["FINLAND'S"]="F IH N L AH N D Z",MENSAH="M EH N S AH",HONGKONG="HH AO NG K AO NG",["ORANGINA(2)"]="AO R AE N JH IY N AH",["SCHWARZKOPF'S(2)"]="SH W AO R T S K AO F S",PERVOMAISKAYA="P ER V OW M EY S K AY AH",REGIE="R EH G IY",KEREKES="K EH R IH K S",CAJOLE="K AH JH OW L",PARLAY="P AA R L EY",MUFFLING="M AH F L IH NG",RUFFLING="R AH F AH L IH NG",MIDEASTERN="M IH D IY S T ER N",CHIMNEYS="CH IH M N IY Z",CONCEIT="K AH N S IY T",BASEBOARD="B EY S B AO R D",NEGATIVES="N EH G AH T IH V Z",GOTTSCHALL="G AA CH AH L",MATHEMATICAL="M AE TH AH M AE T IH K AH L",INLOW="IH N L OW",RANUM="R AE N AH M",SEIFERT="S AY F ER T",NEIFERT="N IY F ER T",SUPERS="S UW P ER Z",LANUM="L AE N AH M",PANCAKES="P AE N K EY K S",GANCARZ="G AA N K AA R Z",GENDREAU="ZH IH N D R OW",["HOLMES'S(2)"]="HH OW L M Z IH Z",MISDIAGNOSED="M IH S D AY IH G N OW Z D",MIDGETT="M IH JH IH T",["KOREANS'(2)"]="K R IY AH N Z",DUMPED="D AH M P T",HUMPED="HH AH M P T",BROUGHMAN="B R AW M AH N",["AGAIN(2)"]="AH G EY N",SYNTHETICS="S IH N TH EH T IH K S",POUNDSTONE="P AW N D S T OW N",FORNOFF="F AO R N AO F",ZAPATA="Z AA P AA T AH",BRADFORD="B R AE D F ER D",STEGMAIER="S T EH G M AY ER",["ROHDE(2)"]="R OW D AH",FLOURNOY="F L UH R N OY",SCHEMES="S K IY M Z",ALLOW="AH L AW",["MUSEUM'S"]="M Y UW Z IY AH M Z",BLEPHARISMA="B L EH F ER IH Z M AH",HARDEMAN="HH AA R D M AH N",JUMPED="JH AH M P T",LUMPED="L AH M P T",TORGERSON="T AO R G ER S AH N",PUMPED="P AH M P T",EMICK="EH M IH K",["HOLLAND'S"]="HH AA L AH N D Z",VIVIER="V AY V IY ER",ROGIER="R OW ZH Y ER",MARCIAL="M AA R S IY AA L",DENIZENS="D EH N AH Z AH N Z",TALAMANTES="T AA L AA M AA N T EH S",["SIMMONS'S"]="S IH M AH N Z IH Z",["SELF-AGGRANDIZEMENT"]="S EH L F AE G R AH N D AY Z M AH N T",SATURATING="S AE CH ER EY T IH NG",["ROLLAND'S"]="R OW L AH N D Z",MBANK="EH M B AE NG K",["TOLLAND'S"]="T AA L AH N D Z",FLICK="F L IH K",GLICK="G L IH K",STARPOINTE="S T AA R P OY N T",ELICK="EH L IH K",KLICK="K L IH K",PERAZZO="P ER AA Z OW",OLICK="OW L IH K",PREREQUISITE="P R IY R EH K W AH Z AH T",SLICK="S L IH K",SCHMELZER="SH M EH L Z ER",KUWAHARA="K UW W AA HH AA R AH",DISEASE="D IH Z IY Z",["MISBEHAVED(2)"]="M IH S B IY HH EY V D",TUTELAGE="T Y UW T IH L IH JH",MAZZONI="M AA T S OW N IY",HOLDEMAN="HH OW L D M AH N",BLICK="B L IH K",CLICK="K L IH K",CREOLE="K R IY OW L",["LUHR(2)"]="L UH R",JUVENILES="JH UW V AH N AH L Z",["MINERALS(2)"]="M IH N R AH L Z",WINELAND="W AY N L AH N D",GODFREY="G AA D F R IY",NERVOUSLY="N ER V AH S L IY",GUADAGNO="G AA D AA G N OW",FEASTS="F IY S T S",CROSSON="K R AA S AH N",IMAGINEER="IH M AE JH AH N IH R",NAVIGATIONAL="N AE V AH G EY SH AH N AH L",["GALEB(2)"]="G EY L AH B",THEDFORD="TH EH D F ER D",CHRIBONIKO="CH R IY B OW N IY K OW",KAROW="K AA R OW",BEASTS="B IY S T S",IRICK="IH R IH K",OVERFED="OW V ER F EH D",CRICK="K R IH K",FLERFU="F L ER F UW",ERICK="EH R IH K",FRICK="F R IH K",ORICK="AO R IH K",PRICK="P R IH K",["DEMOCRACY'S"]="D IH M AA K R AH S IY Z",KRICK="K R IH K",FAUNTROY="F AO N T R OY",FINDLAY="F IH N D L IY",SALAWAH="S AE L AH W AA",VINELAND="V AY N L AH N D",BRICK="B R IH K",KLASSEN="K L AE S AH N",SKUFCA="S K AH F K AH",UNIMPEACHABLE="AH N IH M P IY CH AH B AH L",["RITCEY'S"]="R IH T S IY Z",NEOAX="N IY OW AE K S",GENOVESI="JH EH N OW V EH S IY",NANDITA="N AA N D IY T AH",POPPYCOCK="P AA P IY K AO K",BUMPAS="B AH M P AH Z",EPITOMIZE="IH P IH T AH M AY Z",CAVALRY="K AE V AH L R IY",ENDOMETRIOSIS="EH N D OW M EH T R IY OW S IH S",TRAVIATA="T R AA V IY AA T AH",HORNIG="HH AO R N IH G",HOSKINS="HH AA S K IH N Z",["WHITENESS(2)"]="HH W AY T N AH S",MCFARLIN="M AH K F AA R L AH N",GOOGINS="G UW G IH N Z",LEFTOVER="L EH F T OW V ER",CLARKSTON="K L AA R K S T AH N",["PRESENTER(2)"]="P R IY Z EH N T ER",DELIVERABLE="D IH L IH V ER AH B AH L",UNREPENTANT="AH N R IH P EH N T AH N T",BANYAS="B AA N Y AH Z",["BROOKNER'S"]="B R UH K N ER Z",DELICIOUSLY="D IH L IH SH AH SH L IY",["APPALACHIAN(3)"]="AE P AH L AE CH AH N",SPIRO="S P IH R OW",FIREFLIES="F AY ER F L AY Z",["CITRON(2)"]="S IH T R AH N Z",FEATHERED="F EH DH ER D",SHRANK="SH R AE NG K",SCHLOTT="SH L AA T",ARAKELIAN="AE R AH K EH L Y AH N",["WHISPER(2)"]="HH W IH S P ER",HIRATA="HH IH R AA T AH",ENCIRCLING="EH N S ER K AH L IH NG",PROFITTAKING="P R AA F IH T T EY K IH NG",MOTIVATOR="M OW T AH V EY T ER",JASKOLSKI="Y AH S K OW L S K IY",ALOUD="AH L AW D",PREDOMINANT="P R IH D AA M AH N AH N T",ARTERBURN="AA R T ER B ER N",["MAINTENANCE(2)"]="M EY N T N AH N S",["BLECH'S"]="B L EH K S",MICROVAX="M AY K R OW V AE K S",SCHMULTS="SH M AH L T S",FLOODWATER="F L AH D W AO T ER",WEEHAWKEN="W IY HH AO K AH N",DISREGARDED="D IH S R IH G AA R D IH D",PFLUM="F L AH M",STROBEL="S T R OW B AH L",RECLASSIFYING="R IY K L AE S IH F AY IH NG",MANFRED="M AE N F R IH D",SAVIER="S EY V Y ER",QUICK="K W IH K",HADDONFIELD="HH AE D AH N F IY L D",["ADELSTEIN(2)"]="AE D AH L S T IY N",BUICK="B Y UW IH K",XAVIER="Z EY V Y ER",RECONNECTED="R IY K AH N EH K T IH D",OVERTON="OW V ER T AH N",PILGRIMAGE="P IH L G R AH M AH JH",COMFY="K AH M F IY",["JIGGLING(2)"]="JH IH G L IH NG",STICK="S T IH K",CATAPULT="K AE T AH P AH L T",["GIGGLING(2)"]="G IH G L IH NG",["SCHLOESSER(2)"]="SH L AA S ER",BEYTOUT="B EY T AW T",GERASHCHENKO="G EH AH SH EY NG K OW",CLOSSON="K L AA S AH N",CARJACKER="K AA R JH AE K ER",UNSCRAMBLE="AH N S K R AE M B AH L",GLOSSON="G L AA S AH N",BOONDOCKS="B UW N D AA K S",MORIMOTO="M AO R IY M OW T OW",WEATHERED="W EH DH ER D",LUFTTRANSPORT="L AH F T R AE N Z P AO R T",["MARKETS(2)"]="M AA R K IH T S",SWICK="S W IH K",STEWING="S T UW IH NG",MESSICK="M EH S IH K",GLITCHES="G L IH CH IH Z",LOEWENSON="L OW W AH N S AH N",TESSICK="T EH S IH K",TIBETAN="T IH B EH T AH N",REPROGRAPH="R EH P R OW G R AE F",MARLENS="M AA R L AH N Z",HASKINS="HH AE S K IH N Z",GASKINS="G AE S K IH N Z",INTERTECT="IH N T ER T EH K T",TROUPES="T R UW P S",REBECCA="R AH B EH K AH",OZICK="OW Z IH K",PROUD="P R AW D",EVERTON="EH V ER T AH N",KRAGH="K R AE G",GRANATO="G R AA N AA T OW",["WIGGLING(2)"]="W IH G L IH NG",PLOETZ="P L OW T S",BLASTS="B L AE S T S",VELOTTA="V EH L OW T AH",HAVIER="HH AE V Y ER",JAVIER="HH AA V IY EH R",KIMBALL="K IH M B AH L",TRANSLATE="T R AE N Z L EY T",MATLACK="M AE T L AE K",BRIMM="B R IH M",CRIMM="K R IH M",SUPERSEDED="S UW P ER S IY D AH D",SHACKLED="SH AE K AH L D",LUMINANCE="L UW M AH N AH N S",TAMKE="T AE M K IY",SEVIER="S EH V Y ER",REVIER="R IY V IY ER",KAMKE="K AE M K IY",UMPTEEN="AH M P T IY N",COASTS="K OW S T S",LAMKE="L AE M K IY",BOASTS="B OW S T S",BYSTANDERS="B AY S T AE N D ER Z",METICULOUS="M AH T IH K Y AH L AH S",NORMY="N AO R M IY",ARASKOG="ER AE S AA G",TARNOFF="T AA R N AO F",SARNOFF="S AA R N AO F",CAROW="K AE R OW",TOASTS="T OW S T S",ROASTS="R OW S T S",MONETARISM="M AA N AH T ER IH Z AH M",DININO="D IH N IY N OW",KAWAHARA="K AA W AA HH AA R AH",PRIMENEWS="P R AY M N UW Z",BOROWSKY="B ER AW S K IY",["TENNCARE'S"]="T EH N K EH R Z",HARBERTS="HH AA R B ER T S",SCHEIN="SH AY N",PRIMM="P R IH M",["AUTHENTICALLY(2)"]="AO TH EH N IH K L IY",JOKESTER="JH OW K S T ER",MARQUEZ="M AA R K EH Z",MEADOWLARK="M EH D OW L AA R K",SPEWING="S P Y UW IH NG",CORRODED="K ER OW D IH D",VINDICTIVE="V IH N D IH K T IH V",LENNIG="L EH N IH G",YOKUM="Y OW K AH M",HENNIG="HH EH N IH G",MCCROREY="M AH K R AO R IY",["DRIP-DRY"]="D R IH P D R AY",DESKINS="D EH S K IH N Z",["SOVIETS'"]="S OW V IY EH T S",DOMINANCE="D AA M AH N AH N S",HOKUM="HH OW K AH M",SLATHERED="S L AE DH ER D",WILDEMAN="W AY L D M AH N",SEIFFERT="S AY F ER T",BONINO="B OW N IY N OW",MAERTENS="M EH R T AH N Z",BREWING="B R UW IH NG",DEVELOPERS="D IH V EH L AH P ER Z",EHMKE="EH M K IY",["EDELSTEIN(2)"]="EH D AH L S T IY N",DWIGGINS="D W IH G IH N Z",["PHOTOCHEMICAL(2)"]="F OW T OW K EH M IH K AH L",BEVIER="B EH V IY ER",VIBRATES="V AY B R EY T S",["MORTGAGE(2)"]="M AO R G IH JH",ZEMKE="Z EH M K",BREAKUP="B R EY K AH P",SOBCZAK="S AA B CH AE K",MEGAWATTS="M EH G AH W AA T S",SKEWING="S K Y UW IH NG",["EMERGENCIES(2)"]="IY M ER JH AH N S IY Z",BRUMMET="B R AH M IH T",["EGYPT(2)"]="IY JH IH P T",REGULATION="R EH G Y AH L EY SH AH N",BONFANTI="B OW N F AA N T IY",LEMKE="L EH M K IY",BRITCHES="B R IH CH AH Z",SIPHONED="S AY F AH N D",LEEMON="L IY M AH N",SANTISTEVAN="S AA N T IY S T EY V AA N",HOLIAN="HH OW L IY AH N",STRATA="S T R AE T AH",HOEFLING="HH OW F AH L IH NG",ADOPTIVE="AH D AA P T IH V",VENDITTI="V EH N D IY T IY",FRIGHTENED="F R AY T AH N D",REASSESSING="R IY AH S EH S IH NG",SCHEHR="SH EH R",MEFFERT="M EH F ER T",LEFFERT="L EH F ER T",KNOWLES="N OW L Z",MURATA="M UH R AA T AH",["YASSER(2)"]="Y AA S ER",BRUINGTON="B R UW IH NG T AH N",AMBASE="AE M B EY S",RIDENHOUR="R IH D IH N AW R",JENNETTE="ZH IH N EH T",STITCHES="S T IH CH IH Z",CONNECTING="K AH N EH K T IH NG",YULIAN="Y UW L IY AH N",BEAUDREAU="B OW D R OW",SIGMAFORM="S IH G M AH F AO R M",["SANDERS'S"]="S AE N D ER Z IH Z",JULIAN="JH UW L IY AH N",REILLY="R AY L IY",STATIONER="S T EY SH AH N ER",STANWICK="S T AE N W IH K",LOCATOR="L OW K EY T ER",ACTIVATOR="AE K T AH V EY T ER",GODDESSES="G AA D AH S IH Z",PHOTOJOURNALIST="F OW T OW JH ER N AH L AH S T",PHILLY="F IH L IY",ADULTERATION="AH D AH L T ER EY SH AH N",GRANITE="G R AE N AH T",JAFFNA="JH AE F N AH",KULOW="K Y UW L OW",["CARAVAN(2)"]="K EH R AH V AE N",["POSTULATES(2)"]="P AA S CH AH L AH T S",LITTERAL="L IH T ER AH L",COUNIHAN="K AW N IH HH AE N",BOILERPLATE="B OY L ER P L EY T",CHEWING="CH UW IH NG",["BAHR(2)"]="B AA R",BULOW="B Y UW L OW",CONCERTMASTER="K AA N S ER T M AE S T ER",SUPERCOOL="S UW P ER K UW L",COMPAS="K AA M P AH S",SIEMON="S IY M AH N",GHOSTBUSTERS="G OW S T B AH S T ER Z",BOTTECELLI="B AO T AH CH EH L IY",PLUTONIUM="P L UW T OW N IY AH M",BADGETT="B AE JH IH T",BARSNESS="B AA R Z N AH S",TOUAREG="T UW ER AH G",FREEDOM="F R IY D AH M",VIEWING="V Y UW IH NG",SEHNERT="S EH N ER T",GEORGINA="JH AO R JH IY N AH",RICHELIEU="R IH SH AH L UW",["RELIES(2)"]="R IY L AY Z",KILIAN="K IH L IY AH N",LILIAN="L IH L IY AH N",PUCCINI="P UW CH IY N IY",SMUGNESS="S M AH G N AH S",ARGENBRIGHT="AA R G IH N B R AY T",["ACCEPTING(2)"]="AH K S EH P T IH NG",DEHNERT="D EH N ER T",MORISHITA="M AO R IY SH IY T AH",HUTZELL="HH AH T Z AH L",PADGETT="P AE JH IH T",CLARIDA="K L AA R IY D AH",BOUGAINVILLEA="B UW G EY N V IH L IY AH",CHILLY="CH IH L IY",JURGENSMEYER="JH ER G AH N Z M AY R",CORMAC="K AO R M AH K",["AMIR(2)"]="AA M IH R",COMFORT="K AH M F ER T",PERISTYLE="P EH R AH S T AY L",MAHMOUD="M AE M UW D",GODZILLA="G AA D Z IH L AH",NEGOTIATOR="N AH G OW SH IY EY T ER",GROSKOPF="G R AA S K AO P F",LYMPHOCYTES="L IH M F AH S AY T S",MARCIE="M AA R K IY",["BEGAN(2)"]="B IY G AE N",SHOOTOUTS="SH UW T AW T S",REJUVENATION="R IH JH UW V AH N EY SH AH N",EXTRACURRICULAR="EH K S T R AH K ER IH K Y AH L ER",LEVANDOSKI="L IH V AH N D AW S K IY",RENFRED="R EH N F ER D",PICOULT="P IH K OW L T",AGERTON="EY G ER T AH N",["PIECH'S"]="P IY CH IH Z",["BURLINGTON'S"]="B ER L IH NG T AH N Z",EGERTON="EH G ER T AH N",DISBARMENT="D IH S B AA R M AH N T",CASHFLOW="K AE SH F L OW",DARCIE="D AA R K IY",TWITCHES="T W IH CH IH Z",PARASITE="P EH R AH S AY T",VANACORE="V AA N AA K AO R IY",["EDUCATION'S"]="EH JH AH K EY SH AH N Z",SHIELDING="SH IY L D IH NG",PERCENTAGE="P ER S EH N T AH JH",["NANTUCKET'S"]="N AE N T AH K IH T S",["OPTION'S"]="AA P SH AH N Z",SWITCHES="S W IH CH AH Z",GUESTS="G EH S T S",SIEVERT="S IY V ER T",GASIOROWSKI="G AH S IY AO R AO F S K IY",RUPPRECHT="R UW P R EH K T",INCAPACITATING="IH N K AH P AE S IH T EY T IH NG",QUESTS="K W EH S T S",PIGEON="P IH JH AH N",LITIGATION="L IH T AH G EY SH AH N",EFFIE="EH F IY",MCDONALD="M AH K D AA N AH L D",CONNECT="K AH N EH K T",GRECIAN="G R IY SH AH N",OFFBEAT="AO F B IY T",BONNETTE="B AH N EH T",DAEMON="D IY M AH N",AUDACIOUS="AA D EY SH AH S",CENTAURS="S EH N T AO R Z",DAMMANN="D AE M AH N",AVENGED="AH V EH N JH D",EXAMINATION="IH G Z AE M AH N EY SH AH N",STEURER="S T ER ER",BANKSHARES="B AE NG K SH EH R Z",STOPPAGES="S T AA P IH JH IH Z",MAESTAS="M EH S T AH Z",HUSKINS="HH AH S K IH N Z",FEHRENBACH="F EH R IH N B AA K",WRITEOFFS="R AY T AO F S",SUAZO="S W AA Z OW",CIRCADIAN="S ER K EY D IY AH N",MCLELAND="M AH K L EH L AH N D",WINFRED="W IH N F R IH D",IMMORTALIZES="IH M AO R T AH L AY Z IH Z",VOICEWORKS="V OY S W ER K S",BUSHWAY="B UH SH W EY",ENFEEBLED="EH N F IY B AH L D",HYDROXY="HH AY D R AO K S IY",MCCOYS="M AH K OY Z",GOLOB="G OW L AH B",["LOTION'S"]="L OW SH AH N Z",YELVINGTON="Y EH L V IH NG T AH N",KNICK="N IH K",UNDERSTATE="AH N D ER S T EY T",UNRAVELING="AH N R AE V AH L IH NG",["GTECH'S"]="JH IY T EH K S",OUTPACES="AW T P EY S IH Z",OVEREXPOSES="OW V ER IH K S P OW Z IH Z",["MIDGETT'S"]="M IH JH AH T S",CONKLING="K AA NG K L IH NG",["PATIENT'S"]="P EY SH AH N T S",CATALOGER="K AE T AH L AO G ER",["OSTLING(3)"]="AA S L IH NG",["CAUTION(2)"]="K AO SH AH N",ROUTERS="R UW T ER Z",VERNITA="V ER N IY T AH",REDOGLIA="R AH D AA G L IY AH",HRIBAR="HH R IH B AA R",WOUTERS="W AW T ER Z",["O'DONALD"]="OW D AA N AH L D",HOPEFULNESS="HH OW P F AH L N IH S",OUTSOURCE="AW T S AO R S",NAKATA="N AA K AA T AH",CHASTE="CH EY S T",NEWSWIRE="N UW Z W AY R",SAKATA="S AA K AA T AH",ROELKE="R OW L K",RESISTENCE="R IH Z IH S T AH N S",["GUESSES(2)"]="G EH S IH Z",BRAMBLE="B R AE M B AH L",["RESISTANT(2)"]="R IY Z IH S T AH N T",PREPARING="P R IY P EH R IH NG",LICENTIOUS="L AY S EH N CH AH S",BERNITA="B ER N IY T AH",MAASSEN="M AA S AH N",EMPLOYMENTS="EH M P L OY M AH N T S",["ROUND'S"]="R AW N D Z",MEACHUM="M IY CH AH M",NOSAIR="N OW Z EY R",["POUND'S"]="P AW N D Z",["DOSSIERS(2)"]="D AO S IY EY Z",FARRAND="F AE R AH N D",SANTIAGO="S AE N T IY AA G OW",CONTAINERIZED="K AH N T EY N ER AY Z D",BURBRIDGE="B ER B R IH JH",REDISCOVERED="R IY D IH S K AH V ER D",AMOROSO="AA M AO R OW S OW",LASHWAY="L AE SH W EY",["PRESSES(2)"]="P R EH S IH Z",ESTATES="IH S T EY T S",ZIELKE="Z IY L K",JOSCELYN="JH AA S IH L IH N",["O'HARRA"]="OW HH ER AH",MASTIF="M AE S T AH F",ANGLIA="AE NG G L IY AH",DIAZO="D AY AE Z OW",["CRESSES(2)"]="K R EH S IH Z",MIELKE="M IY L K IY",HUMBERTO="HH AH M B ER T OW",STOLLAR="S T AA L ER",BRANDENBURGER="B R AE N D AH N B ER G ER",UNCONDITIONAL="AH N K AH N D IH SH AH N AH L",PAPAYA="P AH P AY AH",AUTUMN="AO T AH M",["HAMMERSTEIN'S"]="HH AE M ER S T IY N Z",["PUMPKINS(2)"]="P AH M K AH N Z",DANZIGER="D AE N Z IH G ER",HENAULT="HH EH N AW L T",HUMPAL="HH AH M P AH L",DENAULT="D IH N OW",["MARKEL(2)"]="M AA R K EH L",["MUGABE'S"]="M UW G AA B EY Z",LODESTONE="L OW D S T OW N",NEGLECTING="N IH G L EH K T IH NG",BENEFITING="B EH N AH F IH T IH NG",UPSURGE="AH P S ER JH",ZIESMER="Z IY S AH M ER",MAGAJI="M AH G AA JH IY",SPARKED="S P AA R K T",GROSECLOSE="G R AA S IH K L OW Z",["THERAPIST(2)"]="TH EH R AH P IH S T",YEIRI="Y EH R IY",CALENDAR="K AE L AH N D ER",JAKOB="JH AE K AH B",RECONVENES="R IY K AH N V IY N Z",["RELAX(2)"]="R IY L AE K S",RUNWAYS="R AH N W EY Z",NUTCRACKERS="N AH T K R AE K ER Z",SHINSEI="SH IH N S EY",GUIFFRE="G IH F ER",PRUDENCE="P R UW D AH N S",FERRAND="F EH R AH N D",STEMPIEN="S T EH M P IY N",BOTTOMFISH="B AA T AH M F IH SH",SPRADLING="S P R AE D L IH NG",THROW="TH R OW",AGNOSIO="AE G N OW S IY OW",ANGSTROM="AE NG S T R AH M",SCHOMBERG="SH AA M B ER G",KORNEGAY="K AO R N IH G EY",ALTAIR="AA L T EH R",["MICKEY'S"]="M IH K IY Z",GEORGAKIS="JH AO R JH AA K AH S",PERVERTS="P ER V ER T S",DOUBLESPEAK="D AH B AH L S P IY K",SEVILLA="S EH V IH L AH",REVILLA="R EH V IH L AH",ALTIER="AO L T IY ER",HYPOCRISY="HH IH P AA K R AH S IY",BRITNELL="B R IH T N AH L",LEILIA="L IY L IY AH",ANTEATERS="AE N T IY T ER Z",JORDIE="JH AO R D IY",OEHMENS="OW M AH N Z",PINAULT="P IH N AO L T",AMATI="AH M AA T IY",MEISHAN="M AY SH AH N",SEARFOSS="S ER F AH S",HATHAWAY="HH AE TH AH W EY",GORDIE="G AO R D IY",HIPPOCRATIC="HH IH P AH K R AE T IH K",SUNROOF="S AH N R UW F",WILTGEN="W IH L T G AH N",HOMELAND="HH OW M L AE N D",["KONGSBERG'S(2)"]="K AO NG G Z B ER G Z",BOHNERT="B OW N ER T",DEBUSSY="D IH B AH S IY",LYTHGOE="L IH TH G OW",JOHNSEN="JH AA N S AH N",PHILENE="F IH L IY N",MAXIME="M AE K S IY M",PATRICOF="P AE T R IH K AO F",MISMANAGE="M IH S M AE N IH JH",GALANIS="G AH L AA N IH S",KEISLING="K AY S AH L IH NG",NEGRO="N IY G R OW",COMERS="K AH M ER Z",EUROPEWIDE="Y UH R AH P W AY D",PURDIE="P ER D IY",HERRIOTT="HH EH R IY AA T",MERRIOTT="M EH R IY AH T",CONSECUTIVE="K AH N S EH K Y AH T IH V",RYLANDER="R IH L AH N D ER",EUROSTAR="Y UH R OW S T AA R",NYLANDER="N IH L AH N D ER",SHEELEN="SH IY L AH N",LEBANESE="L EH B AH N IY Z",KIRGIZ="K IH R G IH Z",KERNELS="K ER N AH L Z",ROUGHED="R AH F T",EASIER="IY Z IY ER",["DOERFLINGER(2)"]="D AO R F L IH NG ER",VERIFY="V EH R AH F AY",COUGHED="K AO F T",KUDLA="K AH D L AH",SHAMBLE="SH AE M B AH L",PREVENTED="P R IH V EH N T IH D",GLENN="G L EH N",ABILENE="AE B IH L IY N",["SESKAR'S"]="S EH S K AA R Z",BADGERED="B AE JH ER D",["GLENWOOD'S"]="G L EH N W UH D Z",HOLUM="HH OW L AH M",BOCHAROV="B AA CH ER AA V",["SEMIFINISH(2)"]="S EH M AY F IH N IH SH",MALCONTENT="M AE L K AH N T EH N T",EUTSLER="Y UW T S L ER",NORDGREN="N AO R D G R EH N",CRILLY="K R IH L IY",EXFOLIATION="EH K S F OW L IY EY SH AH N",CONFORMITY="K AH N F AO R M AH T IY",FRILLY="F R IH L IY",LORENC="L AO R IH NG K",CALECA="K AA L EH K AH",STEADIED="S T EH D IY D",DEVIANCY="D IY V IY EH N S IY",UNDERLIE="AH N D ER L AY",CUPCAKE="K AH P K EY K",PROCTOR="P R AA K T ER",IMBODEN="IH M B OW D AH N",ENTERTAINMENTS="EH N T ER T EY N M AH N T S",BOYHOOD="B OY HH UH D",LOVINGS="L AH V IH NG Z",ECZEMA="EH K S AH M AH",["ORIGINATED(2)"]="AO R IH JH AH N EY T IH D",FREISE="F R IY S",CAPTIVATED="K AE P T IH V EY T IH D",MONSOD="M AA N S AA D",ODILIA="OW D IY L IY AH",HENRI="HH EH N R IY",CARMEL="K AA R M EH L",IGNOMINIOUS="IH G N AH M IH N IY AH S",ROVINGS="R OW V IH NG Z",CONTENTIOUSNESS="K AH N T EH N SH AH S N AH S",["BRADY'S"]="B R EY D IY Z",KRAEGER="K R EH G ER",TOBACCO="T AH B AE K OW",NOMENCLATURAL="N OW M AH N K L EY CH ER AH L",DRAEGER="D R EH G ER",GAMETANGIA="G AE M AH T AE N JH IY AH",SOLUM="S OW L AH M",["EVANGELISTS(4)"]="IY V AE N JH AH L IH S",ADVISORIES="AH D V AY Z ER IY Z",ORLANDO="AO R L AE N D OW",SEARCHERS="S ER CH ER Z",BEACHSIDE="B IY CH S AY D",NEGOTIABLE="N AH G OW SH AH B AH L",["WITNESSES'"]="W IH T N AH S IH Z",BACORN="B AE K ER N",DOULTON="D OW L T AH N",MEHRTENS="M EH R T AH N Z",BOULTON="B AW L T AH N",["COMPAQ'S"]="K AA M P AE K S",HOULTON="HH OW L T AH N",ELLENBECKER="EH L IH N B EH K ER",CASINGS="K EY S IH NG Z",HALFTIME="HH AE F T AY M",["DEMAIO(2)"]="D IH M AA OW",ISOLATES="AY S AH L EY T S",DISPLAYS="D IH S P L EY Z",GARAJDA="G ER AA ZH D AH",NOVOSAD="N AA V AH S AE D",BOSQUEZ="B OW S K W EH Z",GILBOY="G IH L B OY",SHUFFLING="SH AH F L IH NG",CASCADES="K AE S K EY D Z",BOVIN="B OW V IH N",COVIN="K OW V IH N",["DETERMINATION'S"]="D IH T ER M IH N EY SH AH N Z",PITRE="P AY T ER",LOVIN="L OW V IH N",MITRE="M IH T R IY",SERPAS="S ER P AH Z",["UNRELATED(2)"]="AH N R IY L EY T IH D",BACKWASH="B AE K W AA SH",INCINERATE="IH N S IH N ER EY T",CHISELED="CH IH Z AH L D",HAGSTROM="HH AE G S T R AH M",SALZANO="S AA L Z AA N OW",SCHRAGE="SH R EY JH",HYDRATES="HH AY D R EY T S",MINTURN="M IH N T ER N",JEFFY="JH EH F IY",["NEXTEL'S"]="N EH K S T EH L Z",FURTHERANCE="F ER TH ER AH N S",MILOSEVICH="M IH L AA S IH V IH CH",PRIRODA="P R AH R OW D AH",TRAVELSTEAD="T R AE V AH L S T EH D",GRINSTEAD="G R IH N S T EH D",["SPECIALISTS(2)"]="S P EH SH AH L IH S T S",["NEWARK'S"]="N Y UW ER K S",REMOVAL="R IH M UW V AH L",DRAMATICS="D R AH M AE T IH K S",SMISEK="S M IH S EH K",GUNSHOT="G AH N SH AA T",TREACY="T R EY S IY",TOMAKO="T OW M AA K OW",PALLADINO="P AA L AA D IY N OW",["HAMPTON'S"]="HH AE M P T AH N Z",["CLAUDINA(2)"]="K L AO D IY N AH",PERCHLORATE="P ER K L AO R EY T",SIGHTSEERS="S AY T S IY ER Z",METRE="M IY T ER",PETRE="P EH T ER",STATUESQUE="S T AE CH UW EH S K",EXPRESSIONLESS="IH K S P R EH SH AH N L IH S",YORKBASED="Y AO R K B EY S T",KISSICK="K IH S IH K",UNREQUITED="AH N R IY K W AY T IH D",MOGLIA="M AA G L IY AH",CHEAPENS="CH IY P AH N Z",GOGLIA="G AA G L IY AH",LESSORS="L EH S ER Z",FOGLIA="F AA G L IY AH",JIFFY="JH IH F IY",ERVIN="ER V IH N",ABELA="AA B EH L AH",ARVIN="AA R V IH N",REGEHR="R EH G IH R",["COMPLETED(2)"]="K AH M P L IY T IH D",IRVIN="ER V IH N",RECEPTIVITY="R IY S EH P T IH V IH T IY",CACTI="K AE K T AY",MEMBERED="M EH M B ER D",ORVIN="AO R V IH N",["TAJIKISTAN'S"]="T AA JH IY K IH S T AE N Z",DAVILLA="D AH V IH L AH",KUVIN="K UW V IH N",ACCUMULATION="AH K Y UW M Y AH L EY SH AH N",EDICK="EH D IH K",PUGLIA="P AH G L IY AH",CORBRIDGE="K AO R B R IH JH",LAUREEN="L AO R IY N",MAUREEN="M AO R IY N",BURROWES="B ER OW Z",ISGRO="IY S G R OW",ERAZO="EH R AA Z OW",LESSNESS="L EH S N AH S",LITAKER="L IH T EY K ER",HEICK="HH AY K",FEICK="F IY K",LEICK="L IY K",DEWAELE="D UW EH L",FREDDYE="F R EH D IY",CAUFIELD="K OW F IY L D",ADELA="AH D EH L AH",TARTAGLIONE="T AA R T AE G L IY OW N IY",ENDURES="EH N D Y UH R Z",DIOCESE="D AY AH S IY Z",MEROW="M EH R OW",CALIENDO="K AA L IY EH N D OW",["MONESSEN(2)"]="M AH N EH S AH N",WESTOVER="W EH S T OW V ER",REALCAP="R IY L K AE P",["RESULTED(3)"]="R IY Z AH L T IH D",FERDIE="F ER D IY",MILITARISTS="M IH L AH T ER IH S T S",["CHOOK(2)"]="CH UW K",AEROSTAR="EH R OW S T AA R",["WEDTECH'S"]="W EH D T EH K S",["SADAT(2)"]="S AH D AE T",ROLANDO="R OW L AA N D OW",STRADLING="S T R AE D L IH NG",TRANSFERRED="T R AE N S F ER D",CHRISTI="K R IH S T IY",BENITES="B EH N AY T S",WAKELAND="W EY K L AH N D",["COMPTON'S"]="K AA M P T AH N Z",HAYDU="HH EY D UW",LAKELAND="L EY K L AH N D",HORNERE="HH AO R N ER",JANKLOW="JH AE NG K L OW",UNWAVERING="AH N W EY V ER IH NG",["CONDUIT(3)"]="K AA N D W IH T",KALAFUT="K AE L AH F AH T",DELEON="D EH L IY AH N",["O'DOUGHERTY"]="OW D AA HH ER T IY",CHICK="CH IH K",NOTRE="N OW T R AH",BJORNSTAD="B Y AO R N S T AH D",BIVIN="B IH V IH N",["WALESA'S"]="W AH L EH S AH Z",GIGLIA="JH IY G L IY AH",SCUFFLING="S K AH F AH L IH NG",SHICK="SH IH K",ARROW="AE R OW",["MORNINGSTAR'S"]="M AO R N IH NG S T AA R Z",XANAX="Z AE N AE K S",LAUGHED="L AE F T",["MCFADDEN'S"]="M AH K F AE D AH N Z",ALLUM="AE L AH M",REVIVALIST="R IY V AY V AH L IH S T",ARMBRUSTER="AA R M B R AH S T ER",PLIMPTON="P L IH M P T AH N",CHARMION="CH AA R M IY AH N",INBODEN="IH N B OW D AH N",HOUTCHENS="HH AW CH AH N Z",UPBRAID="AH P B R EY D",CHERUB="CH EH R AH B",HARDIE="HH AA R D IY",HARRIOTT="HH AE R IY AH T",GARRIOTT="G AE R IY AH T",SHOLTIS="SH OW L T IH S",CASHIERED="K AE SH IH R D",TRANSPACIFIC="T R AE N S P AH S IH F IH K",COAXING="K OW K S IH NG",["SENTIMENT(2)"]="S EH N AH M AH N T",GRANDMOTHER="G R AE N D M AH DH ER",HEGSTROM="HH EH G S T R AH M",PARRIOTT="P AE R IY AH T",MCCLARTY="M AH K L AA R T IY",NIGRO="N IH G R OW",MARRIOTT="M EH R IY AH T",BISEXUAL="B AY S EH K SH UW AH L",["SUBJECTS'(2)"]="S AH B JH EH K S",ENTRE="AA N T R EY",BALIAN="B EY L IY AH N",DALIAN="D EY L IY AH N",SPROW="S P R AW",LAMBERTO="L AA M B EH R T OW",["BEYOND(2)"]="B IY AO N D",["GRANDFATHERING(2)"]="G R AE N F AA DH ER IH NG",MARSCHALL="M AA R SH AH L",MULTIPLICATION="M AH L T AH P L AH K EY SH AH N",SERIOUSLY="S IH R IY AH S L IY",ESCAPADE="EH S K AH P EY D",BARINCO="B ER IH NG K OW",REGIS="R IY JH IH S",["NEGOTIATED(2)"]="N IH G OW SH IY EY T IH D",TWISTY="T W IH S T IY",SCHNITZER="SH N IH T Z ER",BURGESON="B ER G IH S AH N",VERITABLE="V EH R IH T AH B AH L",LEMBKE="L EH M B K",REMANUFACTURED="R IY M AE N Y UW F AE K CH ER D",JERMYN="JH ER M IH N",LIQUIDATING="L IH K W IH D EY T IH NG",UPHEAVALS="AH P HH IY V AH L Z",CONTENDER="K AH N T EH N D ER",SNOUT="S N AW T",HERITABLE="HH EH R AH T AH B AH L",SRIRAM="S R IY R AA M",DEEMPHASIZE="D IY EH M F AH S AY Z",HOLDORF="HH OW L D AO R F",["SCHWERNER'S"]="SH W ER N ER Z",DESCRIBED="D IH S K R AY B D",["OCONNER'S"]="OW K AA N ER Z",CLARKE="K L AA R K",SHIRRELL="SH ER EH L",REEMPHASIZE="R IY EH M F AH S AY Z",["ASHBAUGH(2)"]="AE SH B AO",COMMERCIALIZING="K AH M ER SH AH L AY Z IH NG",["MARGARET(2)"]="M AA R G R AH T",["WHITISH(2)"]="HH W AY T IH SH",MULTIPLEXERS="M AH L T IY P L EH K S ER Z",HEINY="HH AY N IY",LOPRESTO="L OW P R EH S T OW",GATHERER="G AE DH ER ER",ST_GERMAIN="S EY N T JH ER M EY N",CONFERENCING="K AA N F R AH N S IH NG",ENVELOPS="IH N V EH L AH P S",CONGROVE="K AA NG G R AH V",BEINY="B AY N IY",BUDDIES="B AH D IY Z",HEISKELL="HH AY S K AH L",DYNCORP="D IH N K AO R P",PECAN="P AH K AA N",CUOZZO="K W OW Z OW",ROARKE="R AO R K",WHOMEVER="HH UW M EH V ER",OVEROPTIMISM="OW V ER AA P T IH M IH Z AH M",EMPHASIZING="EH M F AH S AY Z IH NG",ATTENTIONS="AH T EH N SH AH N Z",MARGARETHE="M AA R G AA R EH DH IY",SLUGGERS="S L AH G ER Z",ALTOMARE="AA L T OW M AA R IY",TIBETANS="T AH B EH T AH N Z",KARLE="K AA R AH L",INTERCOM="IH N T ER K AA M",EARLE="ER L",CARLE="K AA R AH L",HARLE="HH AA R AH L",HURWITZ="HH ER W IH T S",VARIOUSLY="V EH R IY AH S L IY",MICROAIRE="M AY K R OW EH R",PETHTEL="P EH TH AH L",CASEWORKERS="K EY S W ER K ER Z",["SMITHSONIAN'S"]="S M IH TH S OW N IY AH N Z",AROUSED="ER AW Z D",SUCHOMEL="S AH K OW M EH L",SZABO="SH AA B OW",KACZOROWSKI="K AH CH ER AO F S K IY",SONGY="S AA N JH IY",QUIRAM="K W IY R AH M",DEVICE="D IH V AY S",TARMACS="T AA R M AE K S",BRETTSCHNEIDER="B R EH CH N AY D ER",PALEOCENE="P EY L IY AH S IY N",ADMINISTRATING="AH D M IH N AH S T R EY T IH NG",LINDEMAN="L IH N D M AH N",HIJACKED="HH AY JH AE K T",SCHUNDLER="SH AH N D L ER",["LOSERS'"]="L OW Z ER Z",SCHLEICH="SH L AY K",["ROUTES(2)"]="R AW T S",SCUTTLE="S K AH T AH L",BASHIR="B AH SH IH R",DISMAY="D IH S M EY",ADVICE="AE D V AY S",BIERNAT="B IH R N AE T",POPULARIZED="P AA P Y AH L ER AY Z D",MOLOTOV="M AO L AH T AA F",HAWKINSON="HH AO K IH N S AH N",KIDDIES="K IH D IY Z",["CAISSON(2)"]="K EH S AH N",["NEWBURY'S"]="N UW B EH R IY Z",GRINDROD="G R AY N D R AA D",REPLANTING="R IY P L AE N T IH NG",AROUSAL="ER AW Z AH L",["DIAMETRICALLY(2)"]="D AY AH M EH T R IH K L IY",DEVOLVE="D IH V AA L V",PROUDFIT="P R AW D F IH T",ERMINIA="ER M IY N IY AH",BRIGADE="B R AH G EY D",WESTERFELD="W EH S T ER F EH L D",STOTLER="S T AA T L ER",["WARBURG'S"]="W AO R B ER G Z",NEGROID="N IY G R OY D",FURGESON="F ER G IH S AH N",REVOLVE="R IY V AA L V",CULLISON="K AH L IH S AH N",WHINY="W AY N IY",LANDSTON="L AE N D S T AH N",SHINY="SH AY N IY",KOFRON="K AA F R AH N",KINGSVILLE="K IH NG Z V IH L",PENILE="P IY N AY L",LANDGREN="L AE N D G R EH N",["ROBB'S"]="R AA B Z",BREAKFIELD="B R EY K F IY L D",ROQUEMORE="R OW K M AO R",["HARVARD'S"]="HH AA R V ER D Z",SANDGREN="S AE N D G R EH N",LENIENT="L IY N IY AH N T",["JOSKE'S"]="JH AO S K IY Z",["IRAQ'S(3)"]="AY R AA K S",INTRASPECIFIC="IH N T R AH S P AH S IH F AH K",GIGGING="G IH G IH NG",COMPLICIT="K AH M P L IH S AH T",PALATABLE="P AE L AH T AH B AH L",DIGGING="D IH G IH NG",ANNABELLE="AE N AH B AH L",MELKONIAN="M EH L K OW N IY AH N",SEAVERS="S IY V ER Z",WARMUS="W AO R M AH S",WEAVERS="W IY V ER Z",VARMUS="V AA R M AH S",ROSENE="R AA S IY N",SHUTTLE="SH AH T AH L",RIGGING="R IH G IH NG",DEAVERS="D IY V ER Z",BEAVERS="B IY V ER Z",BASKERVILLE="B AE S K ER V IH L",ASAHAN="AE S AH HH AE N",["QUARANTINES(2)"]="K W AO R AH N T AY N Z",CHEATERS="CH IY T ER Z",BUNGALOW="B AH NG G AH L OW",["CONVERT(2)"]="K AH N V ER T",["ROBERTS'"]="R AA B ER T S",["WEBB'S"]="W EH B Z",UNREALISTICALLY="AH N R IY AH L IH S T IH K L IY",STIPULATES="S T IH P Y AH L EY T S",VODAVI="V OW D AA V IY",["MUTI(2)"]="M Y UW T IY",GRADUATION="G R AE JH UW EY SH AH N",["KRUDMAN'S"]="K R AH D M AH N Z",CLEMO="K L EY M OW",SASSEEN="S AE S IY N",HYPOGLYCEMIA="HH AY P OW G L AY S IY M IY AH",FAIRYTALE="F EH R IY T EY L",TRAHAN="T R AE HH AH N",["APPROXIMATES(2)"]="AH P R AA K S AH M EY T S",ALLEYS="AE L IY Z",BERNARDINI="B ER N AA R D IY N IY",COMPROMISING="K AA M P R AH M AY Z IH NG",KRASNER="K R AE S N ER",VARZI="V AA R Z IY",SHAVERS="SH EY V ER Z",CRASNER="K R AE Z N ER",DRASNER="D R AE S N ER",BARRICKLOW="B AE R IH K L AW",DURRANCE="D UH R AH N S",LEGGING="L EH G IH NG",CHAVERS="CH EY V ER Z",WALCK="W AO L K",KENEFICK="K EH N IH F IH K",GREENFIELD="G R IY N F IY L D",FAUNTLEROY="F AO N T L ER OY",BEGGING="B EH G IH NG",["KONG'S(2)"]="K AO NG G Z",["DIRECTING(2)"]="D IY R EH K T IH NG",TIMELINESS="T AY M L IY N AH S",AMIRAM="AE M ER AE M",PEGGING="P EH G IH NG",REZENDES="R EY Z EY N D EH S",KIMWIPES="K IH M W AY P S",ELGERSMA="EH L JH EH R S M AH",DESMARAIS="D EH Z M ER EY",GOWENS="G AW AH N Z",FALCK="F AE L K",SPACE="S P EY S",AMIRI="AA M IH R IY",BOWENS="B OW AH N Z",PLACE="P L EY S",SUMMARIZED="S AH M ER AY Z D",CIFELLI="S IH F EH L IY",["VITALE(2)"]="V AY T AE L",GLACE="G L EY S",DADDIES="D AE D IY Z",CADDIES="K AE D IY Z",FILMLESS="F IH L M L AH S",["FRYMIRE(2)"]="F R IY M AY R",ALLELIC="AH L EH L IH K",EXPERIMENTALIST="IH K S P EH R AH M EH N T AH L IH S T",IMPLANTING="IH M P L AE N T IH NG",BASTEDO="B AA S T EY D OW",RAINY="R EY N IY",PADDIES="P AE D IY Z",PREMO="P R EH M OW",DENKI="D EH NG K IY",PRONOUNCES="P R AH N AW N S IH Z",MELODIES="M EH L AH D IY Z",SYRUPS="S ER AH P S",["PRESERVE(2)"]="P R IH Z ER V",SIEKIERSKI="S IY K IH R S K IY",["KISMAYU(2)"]="K IH Z M AA Y UW",["GIBB'S"]="G IH B Z",["TSUI(2)"]="S UW IY",SKYHOPPING="S K AY HH AO P IH NG",DETENTIONS="D IH T EH N SH AH N Z",["IALLA(2)"]="IY AA L AH",INSECTICIDE="IH N S EH K T AH S AY D",CREATION="K R IY EY SH AH N",LABADIE="L AE B AH D IY",SCHULDT="SH UH L T",PRUDENTRUST="P R UW D AH N T R AH S T",["PRIAM'S(2)"]="P R AY AH M Z",BROSNAN="B R AA S N AH N",FAINTEST="F EY N T AH S T",PROPELLANT="P R AH P EH L AH N T",COOKSON="K UH K S AH N",CHARTER="CH AA R T ER",WINIFRED="W IH N IH F R IH D",WHATNOT="W AH T N AA T",["L'HEUREUX"]="L HH Y UW R UH",DAVIGNON="D AA V IY G N AO N",KLOPF="K L AA P F",GIZMOS="G IH Z M OW Z",ENGELMANN="EH NG G AH L M AH N",SIEWERT="S IY W ER T",STROMBOLI="S T R AA M B OW L IY",SCHACHT="SH AE K T",VALENTIN="V AA L EH N T IY N",TWONSHEIN="T W AA N SH AY N",DOMINGUES="D OW M IY N G EH S",CLEANLY="K L IY N L IY",["HUBBELL'S"]="HH AH B AH L Z",SEINFELD="S AY N F EH L D",FIGURINE="F IH G Y ER IY N",HARSHEST="HH AA R SH AH S T",ENICHEM="EH N IH CH AH M",WEINFELD="W AY N F EH L D",SERATONIN="S ER AA T OW N IH N",PREDOMINANTLY="P R IH D AA M AH N AH N T L IY",COMMISSIONING="K AH M IH SH AH N IH NG",UNSULLIED="AH N S AH L IY D",JOYNT="JH OY N T",VIVIAN="V IH V IY AH N",["GIBLER(2)"]="JH IH B L ER",DUFFEK="D AH F IH K",SPOUT="S P AW T",["BIBLER(2)"]="B AY B L ER",["HYUNDAI(2)"]="HH AH N D EY",KNOPF="N AA P F",KNOXVILLE="N AA K S V IH L",LANCTOT="L AE NG K T AH T",FREDERIKSEN="F R EH D ER IH K S AH N",["MUDDLEHEADED(2)"]="M AH D AH L HH EH D IH D",PETROS="P EH T R OW Z",GENERATES="JH EH N ER EY T S",BRESLAW="B R EH S L AA",QUENNEL="K W EH N AH L",ILLINOIS="IH L AH N OY",SIDELINED="S AY D L AY N D",["GISENYI(2)"]="JH IH S EH N Y IY",KROUT="K R AW T",CHANTILLY="SH AE N T IH L IY",GROUT="G R AW T",CIRRUS="S IH R AH S",VIRZI="V IH R Z IY",ELCOTEL="EH L K OW T EH L",BAVARIAN="B AH V EH R IY AH N",PRUDISH="P R UW D IH SH",PREPARER="P R IY P EH R ER",VOLKMANN="V OW L K M AH N",TROUT="T R AW T",PROUT="P R AW T",REASNER="R IY S N ER",JOVIAN="JH OW V IY AH N",["NITTA(2)"]="N IY T AH",STORYBOOKS="S T AO R IY B UH K S",["RISKE'S"]="R IH S K S",CLABO="K L AA B OW",POINDEXTER="P OY N D EH K S T ER",["ROSELAWN'S"]="R OW Z L AO N Z",KRENN="K R EH N",SUGGESTS="S AH G JH EH S T S",ANDRICH="AE N D R IH K",BARAHONA="B AE R AH HH OW N AH",MALAMUGI="M AE L AH M Y UW JH IY",DOGGING="D AO G IH NG",PRENN="P R EH N",CORLE="K AO R AH L",EGGEMEYER="EH G IH M AY ER",LOGGING="L AO G IH NG",DECADENT="D EH K AH D AH N T",HOGGING="HH AO G IH NG",JOGGING="JH AA G IH NG",MERLE="M ER L",DEPASQUALE="D IH P AA S K W AA L IY",KIRNAN="K ER N AH N",EVACUATED="IH V AE K Y AH W EY T IH D",ELECTROPHORESIS="IH L EH K T R OW F AO R IH S IH S",SERLE="S ER AH L",KROPF="K R AA P F",UNIMPAIRED="AH N IH M P EH R D",STOUT="S T AW T",PERLE="P ER L",COMPUMAT="K AA M P Y UW M AE T",MARCANTEL="M AA R K AA N T EH L",HAMLISCH="HH AE M L IH SH",SHERIDAN="SH EH R IH D AH N",WERLE="W ER L",CALCAGNO="K AA L K AA G N OW",BELYEA="B EH L IY AH",NICHOLES="N IH K OW L Z",["BOLIVIAN(2)"]="B AH L IH V IY AH N",ALDRICH="AO L D R IH CH",BUSBOOM="B AH S B UW M",MERCHANT="M ER CH AH N T",["INTRANSIGENCE(2)"]="IH N T R AE N S IH JH AH N S",BERLE="B ER L",["MUBARAK'S(2)"]="M Y UW B AA R IH K S",["HISTORICALLY(2)"]="HH IH S T AO R IH K L IY",CORTESE="K ER T EY Z IY",NORTHWESTERLY="N AO R TH W EH S T ER L IY",INTENTIONS="IH N T EH N CH AH N Z",PROPELLANTS="P R OW P EH L AH N T S",RACIST="R EY S IH S T",ASTROGEOLOGY="AE S T R AH JH IY AA L AH JH IY",QUAVERS="K W EY V ER Z",BONELESS="B OW N L AH S",STOCKPILED="S T AA K P AY L D",["DINKINS'"]="D IH NG K IH N Z",POULTER="P OW L T ER",MCCARTAN="M AH K AA R T AH N",MENOPAUSAL="M EH N AH P AW Z AH L",["DETROITERS(2)"]="D IY T R OY T ER Z",BOULTER="B OW L T ER",STARTER="S T AA R T ER",BALLIWICK="B AE L AH W IH K",ANTHRACITE="AE N TH R AH S AY T",ZORZI="Z AO R Z IY",JOKHANG="JH AA K HH AE NG",COULTER="K OW L T ER",["REFERRED(2)"]="R IH F ER D",DIPASQUALE="D IH P AA S K W AA L IY",["CABLER(2)"]="K EY B L ER",KERNAN="K ER N AH N",HERNAN="HH ER N AH N",PERRONE="P ER R OW N IY",PEERAGE="P IH R AH JH",PATRIARCHS="P EY T R IY AA R K S",["FETISHIST(2)"]="F EH T IH SH AH S T",["KABLER(2)"]="K EY B L ER",DARRELLE="D ER EH L",["GABLER(2)"]="G EY B L ER",["TABLER(2)"]="T EY B L ER",["PROTUBERANCE(2)"]="P R AH T UW B ER AH N S",KARTASASMITA="K AA R T AE S AH S M IY T AH",FERRONE="F ER OW N IY",["SEINFELD'S"]="S AY N F EH L D Z",DAMAGED="D AE M AH JH D",INSCRIBED="IH N S K R AY B D",SARAFIN="S AE R AH F IH N",SHIMMERING="SH IH M ER IH NG",PACESETTER="P EY S EH T ER",MIMICKED="M IH M IH K T",MICRONS="M AY K R AA N Z",["GATOS(2)"]="G AE T OW S",GLADIATOR="G L AE D IY EY T ER",BIRLE="B ER L",LUNDGREN="L AH N D G R EH N",RHODIA="R OW D IY AH",NOVICE="N AA V AH S",["LEGIT(2)"]="L AH JH IH T",AVERAGE="AE V ER IH JH",ANNABEL="AE N AH B EH L",OUTFLANKS="AW T F L AE NG K S",EVERAGE="EH V ER IH JH",INTROS="IH N T R OW Z",SKIPJACK="S K IH P JH AE K",DENTISTRY="D EH N T IH S T R IY",["OVERWHELMED(2)"]="OW V ER HH W EH L M D",["DANJU'S"]="D AE N JH UW Z",["WHIPLASH(2)"]="HH W IH P L AE SH",PETRINI="P EH T R IY N IY",ROOMY="R UW M IY",IDEATION="AY D IY EY SH AH N",VANGY="V AE N JH IY",["INCREMENTALISM(2)"]="IH N K R AH M EH N AH L IH Z M",CLOUT="K L AW T",JOHNY="JH AA N IY",ADMIRABLY="AE D M ER AH B L IY",ANAEROBES="AE N ER OW B Z",["PANTSUITS(2)"]="P AE N S UW T S",ABSOLVE="AH B Z AA L V",NOBATOSHI="N OW B AH T OW SH IY",["ROCHELLE(2)"]="R AH SH EH L",["GEBLER(2)"]="G EH B L ER",ENGLEHARDT="IH NG AH L HH AA R T",VARRONE="V AA R OW N EY",BARRONE="B ER OW N",RIECHERS="R IY K ER Z",RANGY="R EY N JH IY",MANGY="M EY N JH IY",COMMENSURATELY="K AH M EH N S ER AH T L IY",WAGGING="W AE G IH NG",TAGGING="T AE G IH NG",LUCERNE="L UW S ER N",INFINITIVE="IH N F IH N IH T IH V",["NOVI(2)"]="N OW V AY",GILLILAND="G IH L AH L AH N D",DOLLENS="D AA L AH N Z",NAGGING="N AE G IH NG",ASTROS="AE S T R OW S",POLLENS="P AA L AH N Z",SAGGING="S AE G IH NG",PLAGUED="P L EY G D",["GARTZKE(2)"]="G AA R T S K IY",TRAVAIL="T R AH V EY L",["TERRE-HAUTE"]="T EH R AH HH OW T",EPITHET="EH P AH TH EH T",MIMICS="M IH M IH K S",ANDRIC="AE N D R IH K",MORRONE="M AO R OW N IY",["FERNANDO'S(2)"]="F ER N AA N D OW Z",BAGGING="B AE G IH NG",SCHLEE="SH L IY",NEGRON="N EH G R AH N",DELOITTE="D AH L OY T",ANEMIAS="AH N IY M IY AH Z",INAUDIBLE="IH N AO D AH B AH L",DUESSELDORF="D UW S AH L D AO R F",HARTZLER="HH AA R T S L ER",GELBART="G EH L B AA R T",["LABIANCA'S"]="L AA B IY AA NG K AH Z",ONTIVEROS="OW N T IY V EH R OW Z",APPENDAGE="AH P EH N D IH JH",SERPENT="S ER P AH N T",CURNUTTE="K ER N AH T",ELDRIC="EH L D R IH K",DUCT="D AH K T",CATBIRD="K AE T B ER D",["JOLLA(2)"]="JH OW L AH",BUTROS="B UW T R OW S",BURCK="B ER K",ALDRIC="AE L D R IH K",WEEVILS="W IY V AH L Z",SHENANIGANS="SH AH N AE N IH G AH N Z",FUSELAGE="F Y UW S AH L AA JH",["BHUTTO'S"]="B UW T OW Z",CHEADLE="CH IY D AH L",ALLOWING="AH L AW IH NG",["PECULIAR(2)"]="P IH K Y UW L Y ER",["CO-WIFE"]="K OW W AY F",["SOFTSPOKEN(2)"]="S AO F S P OW K AH N",TESSMER="T EH S M ER",["POCAHONTAS(2)"]="P OW K AH HH AA N AH S",ROSTRUM="R AA S T R AH M",BRAINDEAD="B R EY N D EH D",SECRETARIAT="S EH K R IH T EH R IY AH T",MEDECIN="M EH D IH S IH N",["LITERALLY(2)"]="L IH T R AH L IY",CONSULATE="K AA N S AH L AH T",LUNDBORG="L AH N D B AO R G",BROBST="B R AA B S T",SATIRICAL="S AH T IH R AH K AH L",["MEDICARE'S"]="M EH D AH K EH R Z",NUTRITIONIST="N UW T R IH SH AH N IH S T",MEYERING="M EY ER IH NG",FASBENDER="F AE S B EH N D ER",SUDDRETH="S AH D R IH TH",PROBST="P R AA B S T",["VOTERS'"]="V OW T ER Z",MUSGROVE="M AH S G R AH V",PAVICH="P AE V IH CH",["SUBJECTS(3)"]="S AH B JH EH K S",ANATOLIA="AE N AH T OW L IY AH",ALLGEMEINES="AO L G AH M AY N Z",AXONS="AE K S AA N Z",SANDIA="S AE N D IY AH",INFLEXIBILITY="IH N F L EH K S IH B IH L IH T IY",HERTZLER="HH ER T Z AH L ER",SINEWY="S IH N Y UW IY",HEIRESSES="EH R AH S IH Z",TASKMASTER="T AE S K M AE S T ER",CONGLOMERATES="K AH N G L AA M ER AH T S",DETERMINATION="D IH T ER M AH N EY SH AH N",["METEOROLOGIST'S"]="M IY T IY ER AA L AH JH IH S T S",["ACCIDENTAL(2)"]="AE K S AH D EH N AH L",["HINTED(3)"]="HH IH N IH D",["MOHIT(2)"]="M OW HH IH T",ARBUCKLES="AA R B AH K AH L Z",CONTRACTOR="K AA N T R AE K T ER",PERPETRATORS="P ER P AH T R EY T ER Z",["OCCIDENTAL(2)"]="AA K S AH D EH N AH L",SCHEUFLER="SH OY F AH L ER",["FIDDLERS(2)"]="F IH D L ER Z",["AMERICAN'S"]="AH M EH R IH K AH N Z",PIRRONE="P IH R OW N IY",MASSAGER="M AH S AA ZH ER",WHITTLED="W IH T AH L D",IDENT="AY D EH N T",["CROATIAN'S"]="K R OW EY SH AH N Z",HAGEMEYER="HH AE G IH M AY ER",CARELESSNESS="K EH R L AH S N AH S",NAMEPLATE="N EY M P L EY T",["ALTOS(2)"]="AO L T OW S",SKYLARK="S K AY L AA R K",COSGROVE="K AA S G R AH V",AGENT="EY JH AH N T",GAWKERS="G AA K ER Z",CHAPPLE="CH AE P AH L",HAWKERS="HH AO K ER Z",SCHWAHN="SH W AO N",["CHARLESTON'S(2)"]="CH AA R AH L S T AH N Z",CURLE="K AO R AH L",HADSALL="HH AE D S AH L",FRIEDMAN="F R IY D M AH N",BONGJIN="B AO NG JH IH N",["BRIDGET(2)"]="B R IH JH IH T",SEATRAIN="S IY T R EY N",PLANECON="P L AE N AH K AA N",WILLENS="W IH L AH N Z",["REESJONES'(2)"]="R IY S JH OW N Z AH Z",CEDRIC="S EH D R IH K",["HUNTED(3)"]="HH AH N AH D",["FARGO'S"]="F AA R G OW Z",REINOEHL="R AY N OW L",["SYNAR(2)"]="S AY N AA R",KALMBACH="K AE L M B AA K",LATORRE="L AA T AO R IY",["PITTSBURGH'S"]="P IH T S B ER G Z",["ENTITIES'"]="EH N T IH T IY Z",MCELVAINE="M AE K AH L V EY N",PISANI="P IY S AA N IY",LODGING="L AA JH IH NG",ARTHROPODS="AA R TH R AH P AA D Z",SCENT="S EH N T",["ASSISTED(2)"]="AH S IH S T IH D",BEHEAD="B IH HH EH D",COMPUTERVISION="K AH M P Y UW T ER V IH ZH AH N",ALGORITHM="AE L G ER IH DH AH M",["SIMULCAST(2)"]="S IH M Y AH L K AE S T",["NATIONALIZE(2)"]="N AE SH N AH L AY Z",["COSTNER'S"]="K AA S T N ER Z",["REEB'S"]="R IY B Z",KOLODZIEJ="K AH L AA D Z IY JH",PRECLUDE="P R IH K L UW D",ACQUAINT="AH K W EY N T",LAFOUNTAIN="L AA F AA N T EY N",KOONS="K UW N Z",LOONS="L UW N Z",MOONS="M UW N Z",TRANSITORY="T R AE N Z AH T AO R IY",PHYSIOLOGY="F IH Z IY AA L AH JH IY",ASHIS="AH SH IY Z",COONS="K UW N Z",SABAN="S EY B AH N",BYRLE="B AY R AH L",LABAN="L EY B AH N",VANTRAN="V AE N T R AE N",NOONS="N UW N Z",HISTRIONICS="HH IH S T R IY AA N IH K S",HICKOK="HH IH K AH K",KOSOWSKY="K AH S AW S K IY",DEROO="D EH R UW",HEDGING="HH EH JH IH NG",CABAN="K EY B AH N",VEGETATE="V EH JH AH T EY T",["PRECLUSION(2)"]="P R IY K L UW ZH AH N",CULLERTON="K AH L ER T AH N",DEMPEWOLF="D EH M P Y UW UH L F",UNCANNY="AH N K AE N IY",BASQUEZ="B AA S K W EH Z",["BURKE'S"]="B ER K S",LANDSLIDE="L AE N D S L AY D",APPENDICITIS="AH P EH N D IH S AY T IH Z",NAKAMA="N AA K AA M AH",NICOLAISEN="N IH K AH L AY S AH N",REINTEGRATION="R IY IH N T AH G R EY SH AH N",["INTERCHANGEABLE(2)"]="IH N ER CH EY N JH AH B AH L",SHOVEL="SH AH V AH L",ARROWS="AE R OW Z",GURGANIOUS="G ER G AH N IY IH S",ORLANDA="AO R L AA N D AH",["RESEARCHERS'"]="R IY S ER CH ER Z",OVERBOOKED="OW V ER B UH K T",["RECRUITS(3)"]="R IY K R UW T S",HEDRICH="HH EH D R IH K",THRONGED="TH R AO NG D",FACT="F AE K T",BRONS="B R AA N Z",ARONS="AA R OW N Z",COMICS="K AA M IH K S",REYNOSA="R IY N OW S AH",IRONS="AY ER N Z",THOMPSONS="T AA M P S AH N Z",PERUSED="P ER UW Z D",KRENEK="K R EH N IH K",SULFUR="S AH L F ER",UNPRESERVED="AH N P R AH Z ER V D",BUTTOCK="B AH T AH K",DEBT="D EH T",["NEW-YORK-CITY"]="N UW Y AO R K S IH T IY",DOMINATE="D AA M AH N EY T",HEIMBACH="HH AY M B AA K",INFLUENTIAL="IH N F L UW EH N CH AH L",LEIMBACH="L AY M B AA K",REDNECKS="R EH D N EH K S",OUTSPOKENNESS="AW T S P OW K AH N AH S",SCHNEERSON="SH N IH R S AH N",TRINGALI="T R IH NG G AA L IY",CHARLOTTETOWN="SH AA R L AH T T AW N",CONDENSATE="K AA N D AH N S EY T",CITYPLACE="S IH T IY P L EY S",HENDEE="HH EH N D IY",CRACKLED="K R AE K AH L D",STEVERSON="S T EH V ER S AH N",ACTIGALL="AE K T IH G AO L",DECEPTIVELY="D IH S EH P T IH V L IY",LANDRETH="L AE N D R IH TH",VENDEE="V EH N D IY",["HUSBAND'S"]="HH AH Z B AH N D Z",FRUCHTER="F R AH K T ER",EXPOSURE="IH K S P OW ZH ER",GRAPPLE="G R AE P AH L",PHINNEY="F IH N IY",["BIJAC(2)"]="B IY JH AE K",WHINNEY="W IH N IY",HALFACRE="HH AE F EY K ER",["REGARD(2)"]="R IH G AA R D",DISTINCTLY="D IH S T IH NG K T L IY",["INSIDERS'"]="IH N S AY D ER Z",SCHILTZ="SH IH L T S",CHEAPEN="CH IY P AH N",["CANDICE'S"]="K AE N D IH S IH Z",["MAGNETICALLY(2)"]="M AE G N EH T IH K L IY",GAUCHO="G AW CH OW",GRADOVS="G R EY D AO F S",MICROCIRCUITS="M AY K R OW S ER K AH T S",["DATSUN'S(2)"]="D AA T S AH N Z",["FEATHERING(2)"]="F EH DH R IH NG",HOSPITAL="HH AA S P IH T AH L",SAULTER="S AO L T ER",DODGING="D AA JH IH NG",SIEBENALER="S IY B IH N AH L ER",ALBANESE="AA L B AA N EY Z IY",MINKOW="M IH NG K AW",["GERSTEIN(2)"]="G ER S T IY N",["FANSLER(2)"]="F AE N Z L ER",["NONWHITES(2)"]="N AA N HH W AY T S",SWEATERS="S W EH T ER Z",SCOVEL="S K OW V AH L",BLACKBOARDS="B L AE K B AO R D Z",HEMOPHILIACS="HH IY M AH F IH L IY AE K S",BRAZENNESS="B R EY Z AH N AH S",LORENSEN="L AO R IH N S AH N",["KAMLER(2)"]="K AE M L ER",GANDEE="G AE N D IY",CANDEE="K AE N D IY",THEREUPON="DH EH R AH P AA N",SUMRELL="S UW M R EY L",["INHABITANT(2)"]="IH N HH AE B IH T AH N T",ALABAMAN="AE L AH B AE M AH N",CLOHERTY="K L AA HH ER T IY",FEISTY="F AY S T IY",TUNSTALL="T AH N S T AH L",ALDEBARAN="AE L D EH B ER AH N",MIKVA="M IH K V AH",STENY="S T EH N IY",["KHLEBNIKOV'S"]="K L EH B N IH K AA V Z",["ADVISORS(2)"]="AH D V AY Z ER Z",SNAPPLE="S N AE P AH L",DOWNGRADES="D AW N G R EY D Z",CAVALLARO="K AA V AA L AA R OW",MCCREADY="M AH K R IY D IY",MCPHEE="M AH K F IY",KYTRIL="K IH T R IH L",TARRANCE="T AA R AH N S",AENEID="AH N IY IH D",LAMBERTH="L AE M B ER TH",GEOPOLITICAL="JH IY OW P AH L IH T IH K AH L",CLAUDE="K L AO D",LARRANCE="L AE R AH N S",MCEUEN="M AH K Y UW AH N",CONTRAN="K AA N T R AE N",RIVERFRONT="R IH V ER F R AH N T",COUVILLON="K UW V IY L AO N",FOUNTAINE="F UW N T EY N",THROWS="TH R OW Z",SETTLEMENTS="S EH T AH L M AH N T S",GLAUDE="G L AO D",SORENSEN="S AO R IH N S AH N",PHILLIPPI="F AH L IY P IY",THABO="TH EY B OW",BALDINI="B AA L D IY N IY",BIESECKER="B IY S IH K ER",DISPLEASE="D IH S P L IY Z",RHIZOIDAL="R AY Z OY D AH L",["WHITCHER(2)"]="HH W IH CH ER",HAUPPAUGE="HH AW P AO JH",AUDRIC="AO D R IH K",COLSTRIP="K OW L S T R IH P",BOBIER="B OW B IY ER",CLAIMING="K L EY M IH NG",CYPRUS="S AY P R AH S",CONTRITION="K AH N T R IH SH AH N",HEALTHCARE="HH EH L TH K EH R",NOMINATION="N AA M AH N EY SH AH N",SPINNEY="S P IH N IY",DOMINATION="D AA M AH N EY SH AH N",SCHLECHT="SH L EH K T",PLINY="P L IH N IY",HOSTETTER="HH AA S T IH T ER",["JOACHIM'S(2)"]="W AA K IY M Z",PANGBURN="P AE NG B ER N",BAGPIPE="B AE G P AY P",FERVENTLY="F ER V AH N T L IY",HEIGHTENED="HH AY T AH N D",MICHELETTI="M IH K AH L EH T IY",MEADOR="M IY D ER",SQUAWKING="S K W AO K IH NG",IMMATURE="IH M AH T Y UH R",VANDEMAN="V AE N D AH M AH N",ORCT="AO R K T",PINKEST="P IH NG K IH S T",TERRANCE="T EH R AH N S",BOUNCINESS="B AW N S IY N AH S",REFRIGERANTS="R IH F R IH JH ER AH N T S",TIGGES="T IH G Z",["PANAMA'S"]="P AE N AH M AA Z",PRESERVER="P R IY Z ER V ER",LEABO="L IY B OW",EUROPE="Y UH R AH P",["KINSLER(2)"]="K IH N S L ER",BATTLEMENTS="B AE T AH L M AH N T S",TUGGING="T AH G IH NG",ERUPTIVE="IY R AH P T IH V",CIRCUMCISE="S ER K AH M S AY Z",STALLIBRASS="S T AE L IH B R AE S",MUGGING="M AH G IH NG",SENSATIONALISTIC="S EH N S EY SH AH N AH L IH S T IH K",LUGGING="L AH G IH NG",REMICS="R EH M IH K S",UNADORNED="AH N AH D AO R N D",DUNKERLEY="D AH NG K ER L IY",SULLENS="S AH L AH N Z",BREAKABLE="B R EY K AH B AH L",MULLENS="M AH L AH N Z",DIGGES="D IH G Z",VENTILATE="V EH N T AH L EY T",ALEGRE="AA L EH G R IY",NOMINATE="N AA M AH N AH T",BOCKELMAN="B AA K AH L M AH N",INDUSTRIALS="IH N D AH S T R IY AH L Z",SPINY="S P AY N IY",CULLENS="K AH L AH N Z",REICHMANNS="R AY K M AH N Z",["WHARRY(2)"]="HH W AE R IY",SOUTHDOWN="S AW TH D AW N",AMRAAM="AE M R AA M",CHALKS="CH AO K S",GORALSKI="G ER AA L S K IY",["EUROPE'S"]="Y UH R AH P S",GIRDLER="G ER D AH L ER",["URUGUAY'S(2)"]="Y ER AH G W AY Z",KREISCHER="K R AY SH ER",ALIQUIPPAS="AE L AH K W IH P AH Z",BRUSSELMANS="B R AH S AH L M AH N Z",["ASARCO'S"]="AH S AA R K OW Z",BEUTLER="B OY T AH L ER",INNUENDOES="IH N Y UW EH N D OW Z",["DIRECTIVES(4)"]="D IH R EH K T IH V Z",SNAKEBITE="S N EY K B AY T",QUININE="K W AY N AY N",EFFUSIVE="EH F Y UW S IH V",["CATWALK(2)"]="K AE T W AO K",["HIGHWAY'S"]="HH AY W EY Z",SUSUMU="S UW S UW M UW",PATHETIC="P AH TH EH T IH K",HONEYS="HH AH N IY Z",RADO="R AA D OW",["ORIOLES'"]="AO R IY OW L Z",PALMOLIVE="P AA L M AA L IH V",MONEYS="M AH N IY Z",BLITZEN="B L IH T S AH N",SUPERPREMIUM="S UW P ER P R IY M IY AH M",ATTENDANCE="AH T EH N D AH N S",ERASERS="IH R EY S ER Z",PREUSSER="P R OY S ER",OCCASIONED="AH K EY ZH AH N D",SCALISE="S K AA L AY Z",FRIZELL="F R IH Z AH L",BLUEBLOODS="B L UW B L AH D Z",BAUTZER="B AW T S ER",["FOIA(2)"]="EH F OW AY EY",ENORMITY="IH N AO R M AH T IY",CARTHAGE="K AA R TH AH JH",OVERREACHES="OW V ER R IY CH IH Z",DURENE="D Y UW R IY N",KALININGRAD="K AH L IH N IH NG G R AE D",["EQUITY'S"]="EH K W AH T IY Z",ORNDOFF="AO R N D AO F",["WHICH'S"]="W IH CH IH Z",JUAREZ="W AA R EH Z",HURDLER="HH ER D AH L ER",MANDIE="M AE N D IY",["ALTIMA'S"]="AA L T IH M AH Z",MAGNITOGORSK="M AE G N IH T AH G AO R S K",["CARRIED(2)"]="K EH R IY D",CANDIE="K AE N D IY",DANIELS="D AE N Y AH L Z",["RODRIGUEZ'S"]="R AA D R IY G EH Z IH Z",WANDIE="W AA N D IY",PIGGOTT="P IH G AH T",FEROCIOUSLY="F ER OW SH IH S L IY",DERIVATIVE="D ER IH V AH T IH V",SUAREZ="S W AA R EH Z",["ORTEGA'S"]="AO R T EY G AH Z",ABOUT="AH B AW T",LUNGES="L AH N JH IH Z",SANDIE="S AE N D IY",KINSMAN="K IH N Z M AE N",["GLYCOMED(2)"]="G L AY K OW M EH D",TINSMAN="T IH N S M AH N",["DEALERSHIP'S"]="D IY L ER SH IH P S",["BLUES'"]="B L UW Z",MCSTAY="M AH K S T EY",GLACIATION="G L EY SH IY EY SH AH N",["'BOUT"]="B AW T",PNEUMOCYSTIS="N UW M OW S IH S T IH S",CARAVANS="K AE R AH V AE N Z",IMMORALITY="IH M ER AE L IH T IY",RECYCLE="R IY S AY K AH L",OCCHIPINTI="OW K IY P IY N T IY",WOODIE="W UH D IY",["GENTLEMEN'S(2)"]="JH EH N AH L M EH N Z",PHOTOGRAPHY="F AH T AA G R AH F IY",["DESEGREGATION(2)"]="D IY S EH G R AH G EY SH AH N",MOODIE="M UW D IY",DUPLICATE="D UW P L AH K AH T",SERRITELLA="S EH R IH T EH L AH",GOODIE="G UH D IY",FOODIE="F UW D IY",FOREBEAR="F AO R B EH R",FLEISCHER="F L AY SH ER",WORTHEY="W ER DH IY",GALIENA="G AA L IY N AH",COMMONER="K AA M AH N ER",NORTHEY="N AO R DH IY",OGLALA="OW G L AA L AH",["JUERGENS(2)"]="JH ER G AH N Z",["GUEI-YUAN"]="G W EY Y UW AA N",ABACUS="AE B AH K AH S",MUNDORF="M AH N D AO R F",ASININE="AE S AH N AY N",CHORUS="K AO R AH S",ASCENDS="AH S EH N D Z",SNACKWELL="S N AE K W EH L",INCURRING="IH N K ER IH NG",MATHEWS="M AE TH Y UW Z",WEITZEN="W AY T S AH N",ORPHEE="AO R F IY",GEISZLER="G AY S L ER",CUCO="K UW K OW",["INDUCTED(2)"]="IH N D AH K T IH D",SPYCATCHER="S P AY K AE CH ER",RELAXED="R IH L AE K S T",["HENSLER(2)"]="HH EH N S L ER",["GENSLER(2)"]="G EH N S L ER",MINEBEA="M IH N AH B IY AH",OVULE="OW V Y UW L",BOISSONNEAULT="B W AA S AH N OW",TRUCE="T R UW S",CRUCE="K R UW S",EYESTRAIN="AY S T R EY N",SATISFY="S AE T AH S F AY",AEROPERU="EH R OW P EY R UW",LIFELONG="L AY F L AO NG",RANCK="R AE NG K",["PRESERVER(2)"]="P R IH Z ER V ER",["DEFAZIO(2)"]="D IH F EY Z IY OW",ANDRINGA="AA N D R IY NG G AH",["SWANN'S"]="S W AA N Z",INTEGRATES="IH N T AH G R EY T S",KIWANIS="K IH W AA N IH S",["ECCENTRIC(2)"]="EH K S EH N T R IH K",EXPLICATE="EH K S P L AH K EY T",SHARPIES="SH AA R P IY Z",BENSMAN="B EH N S M AH N",GUTRIDGE="G AH T R IH JH",FRATERNAL="F R AH T ER N AH L",CASASSA="K AA S AA S AH",MCDUFFEE="M AH K D AH F IY",ADVANI="AE D V AA N IY",POISSANT="P OY Z S AO N T",BRABENDER="B R AE B EH N D ER",FEDERALIZE="F EH D ER AH L AY Z",BLACKWELL="B L AE K W EH L",KERATOTOMY="K EH R AH T AO T AH M IY",COVERING="K AH V ER IH NG",HARTLAUB="HH AA R T L AW B",SYRIAN="S IH R IY AH N",CONCERTINA="K AA N S ER T IY N AH",LEPERS="L EH P ER Z",VANTREASE="V AH N T R IY S",CHASERS="CH EY S ER Z",LOVERING="L AH V ER IH NG",HOVERING="HH AH V ER IH NG",SWEETEN="S W IY T AH N",ARONOFF="EH R AH N AO F",HANSMAN="HH AE N S M AH N",DECLINING="D IH K L AY N IH NG",BULLDOG="B UH L D AO G",["YA'LL"]="Y AA L",NIETZSCHE="N IY CH IY",IMPLICATE="IH M P L IH K EY T",DESTEFANIS="D IH S T IH F AA N IH S",BRODIE="B R OW T IY",RECLINING="R IH K L AY N IH NG",["FISHERMAN'S"]="F IH SH ER M AH N Z",WENCK="W EH NG K",SALYER="S AA L IY ER",EBONICS="IY B AO N IH K S",["KUBLER(2)"]="K Y UW B L ER",TRACZ="T R AA CH",["HUBLER(2)"]="HH Y UW B L ER",["GUBLER(2)"]="G Y UW B L ER",RASTETTER="R EY S T IH T ER",RAUBER="R AW B ER",SAUBER="S AO B ER",TAUBER="T AW B ER",["KENSLER(2)"]="K EH N S L ER",DEBENEDICTIS="D EH B IH N AH D IH K T IH S",LAUBER="L AW B ER",["COUNTERREVOLT(2)"]="K AW N ER R IY V OW L T",DAUBER="D AW B ER",FAUBER="F AW B ER",HAUBER="HH AW B ER",VONTOBEL="V AA N T OW B AH L",YELDELL="Y EH L D AH L",EXCO="EH K S K OW",["EXTREMISTS(2)"]="EH K S T R IY M IH S T S",["WHISTLER(2)"]="HH W IH S L ER",["FOURTH'S"]="F AO R TH S",LEYVA="L EY V AH",PERMA="P ER M AH",NIGHTS="N AY T S",DERKSEN="D ER K S AH N",RIGHTS="R AY T S",SIGHTS="S AY T S",POVICH="P OW V IH CH",FIGHTS="F AY T S",["STICKLER(2)"]="S T IH K L ER",LIGHTS="L AY T S",BREEZY="B R IY Z IY",TAPERS="T EY P ER Z",RAPERS="R EY P ER Z",PAPERS="P EY P ER Z",VERMA="V EH R M AH",ERTLE="ER T AH L",STARBUCK="S T AA R B AH K",MACIOCE="M AA CH OW CH IY",["BOMBER'S"]="B AA M ER Z",MAGYARS="M AE G Y AA R Z",DISINCENTIVES="D IH S IH N S EH N T IH V Z",FRAWLEY="F R AO L IY",KULAKOWSKI="K Y UW L AH K AO F S K IY",WEICHT="W AY K T",["POINSETTIA(2)"]="P OY N S EH T AH",WALDORF="W AO L D AO R F",LEICHT="L AY K T",DERMA="D ER M AH",EIGHTS="EY T S",PHONICS="F AA N IH K S",STUTLER="S T AH T L ER",CHRISTINE="K R IH S T IY N",EQUITABLE="EH K W AH T AH B AH L",["POLITICAL(2)"]="P AH L IH T IH K AH L",["ALDRICH'S"]="AO L D R IH CH AH Z",["PLATINUM(2)"]="P L AE T AH N AH M",CHRISTIANS="K R IH S CH AH N Z",VOCATION="V OW K EY SH AH N",LOCATION="L OW K EY SH AH N",ROGALA="R OW G AA L AH",HOUSEFUL="HH AW S F AH L",BRAWLEY="B R AO L IY",DEPICTION="D IH P IH K SH AH N",BAUMERT="B AW M ER T",STEMBERG="S T EH M B ER G",COLYER="K OW L IY ER",CUEVA="K W EH V AH",DISPOSITIONS="D IH S P AH Z IH SH AH N Z",HAVEMANN="HH AE V AH M AH N",SPILLER="S P IH L ER",["D'ALESSANDRO"]="D AA L EY Z AA N D R OW",TURBYFILL="T ER B IH F IH L",DEFOLLET="D AH F AO L AH T",VERENE="V EH R IY N",KOVICH="K AA V IH CH",SERENE="S ER IY N",FINGERBOARD="F IH NG G ER B AO R D",["REPORTEDLY(2)"]="R IY P AO R T AH D L IY",RELIGION="R IH L IH JH AH N",KALEEL="K AE L IY L",ANTLE="AE N T AH L",MYSELF="M AY S EH L F",SURPRISES="S ER P R AY Z IH Z",UNDERSTAND="AH N D ER S T AE N D",TOURTELOT="T UH R T AH L AA T",FIRMA="F ER M AH",["INTERMINABLY(2)"]="IH N T ER M IH N AH B L IY",CURETON="K Y UH R T AH N",HILYER="HH IH L IY ER",COEFFICIENT="K OW AH F IH SH AH N T",TRIO="T R IY OW",["MCCALL'S"]="M AH K AO L Z",OVERTAKEN="OW V ER T EY K AH N",PROCURE="P R OW K Y UH R",MAGALLANES="M AE G AH L EY N Z",SUCCULENTS="S AH K Y AH L AH N T S",LARIZZA="L ER IH Z AH",POACHER="P OW CH ER",CODESA="K OW D EH S AH",DAVIDOFF="D EY V IH D AO F",REPLICATE="R EH P L AH K EY T",["ENGLAND'S"]="IH NG G L AH N D Z",BELLVILLE="B EH L V IH L",EXCELSIOR="IH K S EH L S IY ER",LITLE="L AY T AH L",MENGES="M EH N JH IH Z",ABULADZE="AE B Y UW L AE D Z IY",FABRIC="F AE B R IH K",BRIO="B R AY OW",TITLE="T AY T AH L",DOLLHOUSES="D AA L HH AW S IH Z",PANICKED="P AE N IH K T",PATRIDGE="P AE T R IH JH",SASSAFRAS="S AE S AH F R AE S",CONDIE="K AA N D IY",HIPPODROME="HH IH P AH D R OW M",DARFUR="D AA F UW R",OHIO="OW HH AY OW",BOULDERS="B OW L D ER Z",AMACHER="AE M AH K ER",GHIO="G AY OW",DAGENAIS="D AE ZH IH N EY",MANVEL="M AE N V AH L",BULGARIAN="B AH L G EH R IY AH N",SCHWIEGER="SH W IY G ER",["MOLNAR(2)"]="M OW L N AA R",CALNAN="K AE L N AH N",RETHINKING="R IY TH IH NG K IH NG",["WHEELED(2)"]="HH W IY L D",["MENEM'S"]="M EH N AH M Z",DULCIMER="D AH L S IH M ER",REDOUBTABLE="R AH D AW T AH B AH L",["PATIENTS(2)"]="P EY SH AH N Z",["KITCHENER(2)"]="K IH CH N ER",LAYERING="L EY ER IH NG",NICOLETTE="N IH K AH L EH T",["AMAZON'S"]="AE M AH Z AA N Z",DELWIP="D EH L W IH P",PIONTEK="P IY OW N T EH K",SALVATO="S AA L V AA T OW",DEPRAVE="D IY P R EY V",["DRINA'S"]="D IY N AH Z",METIVIER="M EH T IH V IY ER",FISSIONABLE="F IH SH AH N AH B AH L",WALRATH="W AO L R AH TH",VANUATU="V AE N UW AA T UW",LUCIER="L UW S IY ER",BATCHELOR="B AE CH AH L ER",RELUCTANT="R IH L AH K T AH N T",HUXTABLE="HH AH K S T AH B AH L",INTERCULTURAL="IH N T ER K AH L CH ER AH L",BABYLON="B AE B AH L AA N",KOLAKOWSKI="K AH L AH K AO F S K IY",MONOPOLISTIC="M AH N AA P AH L IH S T IH K",HYDROPOWER="HH AY D R OW P AW R",POLAKOWSKI="P AH L AH K AO F S K IY",["QUINA'S"]="K W IY N AH Z",ELIO="EH L IY OW",["JACQUET(2)"]="JH AE K EY",CLIO="K L IY OW",ITSELF="IH T S EH L F",KAMCHATKA="K AE M CH AE T K AH",["BELGACOM(2)"]="B EH L JH AH K AA M",NEUBER="N UW B ER",["LUCASFILM(2)"]="L UW K AH S F IH L M",SHELVING="SH EH L V IH NG",INJURIOUS="IH N JH UH R IY AH S",["CALMING(2)"]="K AA L M IH NG",SOUZAS="S UW Z AH Z",SCHISMS="S K IH Z AH M Z",KARMA="K AA R M AH",["HALLOWE'EN"]="HH AE L AH W IY N",DANILOFF="D AE N AH L AO F",SCIANDRA="SH AO N D R AH",VARMA="V AA R M AH",PARMA="P AA R M AH",ABDO="AE B D OW",HOSTUTLER="HH AA S T UW T AH L ER",MCSLEEP="M AH K S L IY P",ALLIANCE="AH L AY AH N S",KWIECIEN="K W IY S IY N",CREEDON="K R IY D AH N",["DATACOMP(2)"]="D AE T AH K AA M P",DEMILITARIZING="D IY M IH L AH T ER AY Z IH NG",THACHER="TH AE K ER",SINEAD="S IH N EY AE D",["BAUMLER(2)"]="B AA M AH L ER",NUDGING="N AH JH IH NG",STEIMEL="S T AY M AH L",JUDGING="JH AH JH IH NG",DADO="D EY D OW",PANKOW="P AE NG K OW",FUDGING="F AH JH IH NG",["RELENTED(4)"]="R IY L EH N AH D",CARMA="K AA R M AH",BUDGING="B AH JH IH NG",PETRUZZI="P EH T R UW T S IY",WATERCOLORS="W AO T ER K AH L ER Z",SHIITES="SH IY AY T S",CONFINE="K AH N F AY N",DWORIN="D W AO R IH N",["NATIONSBANC(2)"]="N EY SH AH N Z B AA NG K",PEACHER="P IY CH ER",GRUBER="G R UW B ER",BEACHER="B IY CH ER",ANTIKNOCK="AE N T IY N AA K",["INNOVATES(2)"]="IH N OW V EY T S",["MEMBER'S"]="M EH M B ER Z",HADRON="HH AE D R AO N",MADRON="M AE D R AH N",["ALLEGHENY'S"]="AE L AH G EY N IY Z",COPIAGUE="K OW P IY AE G",MARSHMALLOWS="M AA R SH M EH L OW Z",PADRON="P AE D R AH N",RAPHALIAN="R AH F EY L IY AH N",HAWTHORNE="HH AO TH AO R N",CAWTHORNE="K AO TH ER N",CHERNOFF="K ER N AO F",LINDGREN="L IH N D G R EH N",["APARTHEID(2)"]="AH P AA R T AY D",MELCHOR="M EH L CH ER",["DUQUESNE'S"]="D UW K EY N Z",GASTILUM="G EY S T IH L AH M",SHERNOFF="SH ER N AO F",["DEJA(2)"]="D EY ZH AA",COVERAGES="K AH V ER AH JH IH Z",COLLEGEVILLE="K AA L AH JH V IH L",["ARGENTINA'S"]="AA R JH AH N T IY N AH Z",["CRISLER(2)"]="K R IH S L ER",TROIKA="T R OY K AH",NATIONALISTIC="N AE SH AH N AH L IH S T IH K",PRESERVATIONISTS="P R EH Z ER V EY SH AH N IH S T S",BOURNIAS="B AO R N IY AH S",OSTERTAG="AA S T ER T AH G",STATHIS="S T AE TH IH S",["TRISLER(2)"]="T R IH S L ER",BUNZL="B AH N Z AH L",CAMPANIS="K AE M P AA N IH S",AGGRAVATED="AE G R AH V EY T AH D",PLAZA="P L AA Z AH",UNDERWITHHELD="AH N D ER W IH TH HH EH L D",GETTLER="G EH T AH L ER",HETTLER="HH EH T L ER",["PIANIST'S(2)"]="P IY AH N IH S T S",KETTLER="K EH T AH L ER",REPROGRAPHICS="R EH P R OW G R AE F IH K S",HYDRANTS="HH AY D R AH N T S",FAILINGS="F EY L IH NG Z",FAUBION="F AW B IY AH N",STIERWALT="S T IH R W AH L T",MEASURES="M EH ZH ER Z",MAILINGS="M EY L IH NG Z",MONEYWEEK="M AH N IY W IY K",RAILINGS="R EY L IH NG Z",ACHTENBERG="AE K T EH N B ER G",PHILIBERT="F IH L IH B ER T",GOULASH="G UW L AA SH",BILLBOARDS="B IH L B AO R D Z",["ANTI(2)"]="AE N T AY",URGENTLY="ER JH AH N T L IY",METTLER="M EH T L ER",DEFYING="D IH F AY IH NG",OSCILLOSCOPE="AO S IH L AH S K OW P",EXHAUSTED="IH G Z AO S T AH D",FIRKINS="F ER K IH N Z",BEGALA="B EH G AA L AH",CAESARS="S IY Z ER Z",VANDEVOORDE="V AE N D AH V UH R D",ZETTLER="Z EH T L ER",["HOT-LINE"]="HH AA T L AY N",STICHT="S T IH K T",["OBLAK(2)"]="OW B L AE K",LYTLE="L AY T AH L",NONPROFESSIONALS="N AA N P R AH F EH SH AH N AH L Z",COMINCO="K OW M IH NG K OW",EXULTS="IH G Z AH L T S",CHLOROPLASTS="K L AO R AH P L AE S T S",["BLUSHES(2)"]="B L AH SH IH Z",BUNDLED="B AH N D AH L D",SCHNEID="SH N AY D",PHOTOCOPIED="F OW T OW K AA P IY D",MORRISTOWN="M AO R AH S T AW N",ABIO="AA B IY OW",GLAZA="G L AA Z AH",DEADWOOD="D EH D W UH D",INTERPLANETARY="IH N T ER P L AE N AH T EH R IY",REPLACEMENTS="R IY P L EY S M AH N T S",REPRESENTING="R EH P R IH Z EH N T IH NG",["BAHRAIN'S"]="B AA R EY N Z",PROTHORAX="P R OW TH AO R AE K S",CHAPPUIS="SH AE P UW IH Z",SCHEIDECKER="SH AY D IH K ER",ANTHROBOT="AE N TH R OW B AH T",GITTLER="G IH T L ER",MOLECULES="M AA L AH K Y UW L Z",CORKINS="K AO R K IH N Z",MONOCLE="M AA N AH K AH L",ARRANGEMENT="ER EY N JH M AH N T",AMADOR="AE M AH D AO R",OBSOLESCENCE="AA B S AH L EH S AH N S",SECEDE="S IH S IY D",HETEROSEXUALS="HH EH T ER OW S EH K SH AH W AH L Z",LUCIEN="L UW S IY AH N",RECEDE="R IH S IY D",VERBOTEN="V ER B OW T AH N",PERFIDY="P ER F IH D IY",ARRAIGN="ER EY N",BEVERAGES="B EH V R IH JH IH Z",DINGY="D IH N JH IY",MILLIBAR="M IH L AH B AA R",KITTLER="K IH T AH L ER",LITTLER="L IH T AH L ER",MITTLER="M IH T L ER",["MITI(2)"]="M IY T IY",LECTEC="L EH K T EH K",SITTLER="S IH T L ER",THESPIAN="TH EH S P IY AH N",HALTEMAN="HH EY L T M AH N",TALIBAN="T AE L IH B AE N",["DAMAGES(2)"]="D AE M IH JH IH Z",MULLENDORE="M UW L EH N D AO R",PRESIDES="P R IH Z AY D Z",TRIBUNALS="T R AY B Y UW N AH L Z",ESTRIDGE="IH S T R IH JH",CROWDED="K R AW D AH D",CRONAN="K R OW N AH N",STULTS="S T AH L T S",MANAGING="M AE N AH JH IH NG",DORALYNNE="D AO R AH L AY N",MCGUFFEE="M AH G AH F IY",STRANGELY="S T R EY N JH L IY",PLEASURAMA="P L EH ZH UH R AE M AH",BLAISDELL="B L EY S D AH L",MICHELS="M IH SH EH L Z",HOWINGTON="HH AW IH NG T AH N",GROSSING="G R OW S IH NG",SUPREMES="S UW P R IY M Z",COMPENSATORY="K AH M P EH N S AH T AO R IY",["TWENTIETH(4)"]="T W EH N IY IH TH",ACCEDE="AE K S IY D",MATASSA="M AA T AA S AH",STUCKERT="S T AH K ER T",ASSASSINATIONS="AH S AE S AH N EY SH AH N Z",CONTINUITY="K AA N T AH N UW AH T IY",NAMELESS="N EY M L AH S",["MOHOLY-NAGY"]="M OW HH OW L IY N EY G IY",HOMOGENIZE="HH OW M AA JH AH N AY Z",AUTOMATIX="AO T OW M EY T IH K S",BRADHAM="B R AE D HH AH M",PARKINS="P AA R K IH N Z",LARKINS="L AA R K IH N Z",HEFTIEST="HH EH F T IY AH S T",CROSSING="K R AO S IH NG",BASHOR="B AE SH ER",PROTHERO="P R AA DH ER OW",["GRADCHEV(2)"]="G R AE D CH AO V",WASZKIEWICZ="V AA SH K EH V IH CH",CZESLAW="CH EH S L AO",REDLINING="R EH D L AY N IH NG",MANGROVE="M AE N G R OW V",HINCHLIFFE="HH IH N K L IH F",KOTTLER="K AA T L ER",BRACHER="B R AE K ER",MONOLITHS="M AA N AH L IH TH S",LEAFLETS="L IY F L AH T S",GOODPASTURE="G UH D P AE S CH ER",BOTTLER="B AA T L ER",PASZKIEWICZ="P AA SH K AH V IH CH",BROWSERS="B R AW Z ER Z",THUNDERSTORMS="TH AH N D ER S T AO R M Z",ROHWEDDER="R OW W IH D ER",ROTTLER="R AA T L ER",REAPPORTIONMENT="R IY AH P AO R SH AH N M AH N T",KUJAWA="K UW JH AA W AH",HALIMEDA="HH AA L IY M EY D AH",ADAZA="AH D AA Z AH",EMPLACEMENTS="IH M P L EY S M AH N T S",LOWERING="L OW ER IH NG",["NUMBER'S"]="N AH M B ER Z",COWERING="K AW ER IH NG",TEAMMATES="T IY M M EY T S",MANTHEY="M AE N TH IY",SHRIKANT="SH R IY K AA N T",PETUNIA="P AH T UW N IY AH",HEARTBEAT="HH AA R T B IY T",TOWERING="T AW ER IH NG",POWERING="P AW ER IH NG",EVASIONS="IH V EY ZH AH N Z",VANDEVEER="V AE N D AH V IH R",GRIESA="G R IY EH S AH",["WIVES'"]="W AY V Z",CLAGGETT="K L AE G IH T",FAIRWAYS="F EH R W EY Z",SWALLOW="S W AA L OW",KINDLED="K IH N D AH L D",["MIDST(2)"]="M IH S T",JERKINS="JH ER K IH N Z",["RITCHEY'S"]="R IH CH IY Z",CONNOTATIONS="K AA N AH T EY SH AH N Z",PERKINS="P ER K AH N Z",HARVILL="HH AA R V IH L",ROOFTOP="R UW F T AA P",MOJO="M OW JH OW",ROJO="R OW JH OW",THERMOSTAT="TH ER M AH S T AE T",["HAPHAZARDLY(2)"]="HH AE P HH AE Z ER D L IY",SONGBIRDS="S AO NG B ER D Z",["MECHANICS'"]="M AH K AE N IH K S",VEHEMENT="V IY AH M AH N T",EXTRICATE="EH K S T R AH K EY T",BURKINS="B ER K IH N Z",GRASSED="G R AE S T",["ALLITERATIVE(2)"]="AH L IH T ER EY T IH V",MARYSVILLE="M EH R IY Z V IH L",UNDERLYING="AH N D ER L AY IH NG",["LOUIMA'S"]="L UW IY M AH Z",DACTYL="D AE K T IH L",RACHELS="R EY CH IH L Z",STARKES="S T AA R K S",DISPOSSESS="D IH S P AH Z EH S",TOULOUSE="T UW L UW Z",MISCALCULATE="M IH S K AE L K Y AH L EY T",DESMA="D IY S M AH",GOLDSTON="G OW L D S T AH N",["WETSTEIN(2)"]="W EH T S T AY N",BLAZIER="B L EY Z IY ER",WILLCUTT="W IH L K AH T",ANDRIANO="AA N D R IY AA N OW",SAVVY="S AE V IY",["BRACHII(2)"]="B R EY K IY IY",MUSCLE="M AH S AH L",BUTTLER="B AH T L ER",TIMELESS="T AY M L AH S",ENZYMATIC="EH N Z AY M AE T IH K",JUJO="JH UW JH OW",MARRUJO="M AA R UW Y OW",REMERCHANDISE="R IY M ER CH AH N D AY Z",EPICUREAN="EH P AH K Y UH R IY AH N",FURIOUSLY="F Y UH R IY AH S L IY",CURIOUSLY="K Y UH R IY AH S L IY",COATESVILLE="K OW T S V IH L",RETALIATORY="R IY T AE L Y AH T AO R IY",GOONAN="G UW N AH N",["DOBLER(2)"]="D OW B L ER",COONAN="K UW N AH N",CHADWICK="CH AE D W IH K",["KOBLER(2)"]="K OW B L ER",["SALAMEH'S"]="S AA L AA M EH Z",DOORENBOS="D UH R EH N B OW S",GENETICALLY="JH AH N EH T IH K L IY",WINGROVE="W IH N G R OW V",SHULTS="SH AH L T S",DANDELIONS="D AE N D AH L AY AH N Z",DOMESTICATED="D AH M EH S T AH K EY T AH D",HOLCK="HH OW L K",OBERON="OW B ER AA N",BRAZELTON="B R AH Z EH L T AH N",RACHELVOLT="R AH SH EH L V AO L T",OVERWHELM="OW V ER W EH L M",["COBLER(2)"]="K OW B L ER",["EXERCISES(2)"]="EH K S ER S AY Z IH Z",MOSLE="M OW S AH L",SPARKES="S P AA R K S",MODERATORS="M AA D ER EY T ER Z",GNOCCHI="N OW K IY",LEGISLATE="L EH JH IH S L EY T",HOFFECKER="HH AO F IH K ER",ARJO="AA R JH OW",DIASTASE="D AY AH S T EY S",COMMUNICATIONS="K AH M Y UW N AH K EY SH AH N Z",TAKEUCHI="T AA K EY UW CH IY",ARENELLA="AA R AH N EH L AH",NOONAN="N UW N AH N",HOMELESS="HH OW M L AH S",SMARTISH="S M AA R T IH SH",HYDRON="HH AY D R AH N",LYUBIMOV="L Y UW B AH M AA V",SIMILARITIES="S IH M AH L EH R AH T IY Z",SARENE="S ER IY N",["PREDICATING(2)"]="P R EH D IH K AH T IH NG",SWEEZY="S W IY Z IY",["ADAMS'S"]="AE D AH M Z IH Z",SCHMUTZLER="SH M AH T Z AH L ER",WOLRATH="W OW L R AE TH",DRISKELL="D R IH S K AH L",DEBUSK="D EH B AH S K",CHARLA="CH AA R L AH",SENDAWAL="S EH N D AA W AH L",["TOBLER(2)"]="T OW B L ER",SHADWICK="SH AE D W IH K",LAVEDA="L AA V EY D AH",DECHRISTOPHER="D EH K R IH S T AA F ER",DEMONIZED="D IY M AH N AY Z D",SHARLA="SH AA R L AH",MENOYO="M AH N OY OW",CONFUSES="K AH N F Y UW Z IH Z",BREADWINNER="B R EH D W IH N ER",LARRIMORE="L AA R IY M AO R",ANARCHICAL="AE N AA R K AH K AH L",TEAHAN="T IY AH N",SLAUGHTERS="S L AO T ER Z",PRIOLEAU="P R IY OW L OW",LICHTENBERG="L IH K T AH N B ER G",BEAHAN="B IY HH AH N",ADULTS="AH D AH L T S",PSYCHOANALYTIC="S AY K OW AE N AH L IH T IH K",DEVINEY="D EH V IH N IY",DEGRADED="D IH G R EY D AH D",GINGRICH="G IH NG G R IH CH",DREIBELBIS="D R AY B IH L B IH S",DISPENSE="D IH S P EH N S",MEKEEL="M EH K IY L",SALIZZONI="S AE L IH Z OW N IY",BOHEMIAN="B OW HH IY M IY AH N",REALIZES="R IY AH L AY Z IH Z",BOOKWALTER="B UH K W AH L T ER",WOMETCO="W OW M EH T K OW",KIRKENDOLL="K ER K EH N D OW L",YOSEF="Y OW S AH F",ZACHARIAS="Z AE K ER AY AH S",WALDRIP="W AO L D R AH P",LEVERING="L EH V ER IH NG",JOCYLAN="JH AO S L AH N",RUBRIC="R UW B R IH K",BRITANNICA="B R IH T AE N IH K AH",REVERING="R IH V IH R IH NG",AISLE="AY L",FOOLHARDY="F UW L HH AA R D IY",PAVELKO="P AH V EH L K OW",LISLE="L AY AH L",GROUSED="G R AW S T",SCULLY="S K AH L IY",HISLE="HH AY AH L",JOSEF="JH OW S AH F",REMEMBERED="R IH M EH M B ER D",AUFHAUSER="AO F HH AW Z ER",WISNIESKI="V IH S N IY S K IY",METEORIC="M IY T IY AO R IH K",PAUTLER="P AW T AH L ER",BEEFEATER="B IY F IY T ER",CENTIGRADE="S EH N T AH G R EY D",REDCAY="R EH D K EY",["MADAME(2)"]="M AH D AE M",BEHAVING="B IH HH EY V IH NG",SEDATION="S AH D EY SH AH N",ASIMOV="AE S IH M AA V",LAFAUCI="L AA F AO CH IY",HOTCAKES="HH AA T K EY K S",REACTIVATING="R IY AE K T IH V EY T IH NG",BRAUNE="B R AO N",LIFSHITZ="L IH F SH IH T S",LANDINI="L AA N D IY N IY",PHOTOCALL="F OW T OW K AA L",FRONEK="F R OW N IH K",HRONEK="HH R OW N IH K",TETSUJI="T EH T S UW JH IY",MANWILLER="M AE N W IH L ER",MATHIESEN="M AE TH IY S AH N",CLASSED="K L AE S T",BAIO="B AA IY OW",GLASSED="G L AE S T",KINGBIRDS="K IH NG B ER D Z",MAIO="M EY OW",["MOLIERE'S"]="M OW L Y EH R Z",WAVERING="W EY V ER IH NG",BAGGOTT="B AE G AH T",COMPLAINING="K AH M P L EY N IH NG",ASSIGNMENT="AH S AY N M AH N T",KELLERMANN="K EH L ER M AH N",AMASSED="AH M AE S T",KITAGAWA="K IY T AA G AA W AH",VANDEWATER="V AE N D AH W AO T ER",["INDEMNITY(2)"]="IH N D EH M N IH T IY",HAVINGTON="HH AE V IH NG T AH N",ANASAZI="AE N AH S AE Z IY",["WHITTLESEY(2)"]="HH W IH T AH L S IY",STORIED="S T AO R IY D",TOWNSON="T AW N S AH N",PURVEYING="P ER V EY IH NG",["ADVOCATE(2)"]="AE D V AH K EY T",FLATWORM="F L AE T W ER M",MULTICOLOR="M AH L T IY K AH L ER",EXPENDITURES="IH K S P EH N D AH CH ER Z",CORABELLE="K AO R AH B AH L",RELOCATE="R IY L OW K EY T",SIXTIETH="S IH K S T IY IH TH",SALSMAN="S AO L S M AH N",ACKNOWLEDGEMENTS="AE K N AA L IH JH M AH N T S",FORMULATE="F AO R M Y AH L EY T",STRATOSPHERE="S T R AE T AH S F IH R",TROPEA="T R OW P IY AH",UNMARKED="AH N M AA R K T",KRISTIE="K R IH S T IY",["MONDAY'S"]="M AH N D IY Z",WITCHHUNT="W IH CH HH AH N T",PANDOLFI="P AA N D OW L F IY",["CERSKA(2)"]="S ER S K AH",MCNEEL="M AH K N IY L",LANDOLFI="L AA N D OW L F IY",SHOULTS="SH OW L T S",PHOEBE="F IY B IY",GAMUT="G AE M AH T",STANCILL="S T AE N S IH L",BAMUT="B AE M AH T",SURVEYING="S ER V EY IH NG",BODEGUITA="B OW D EH G IY D AH",AVERELL="AA V EH R EY L",DIMOND="D AY M AH N D",PROPELLED="P R AH P EH L D",NOGAWA="N OW G AA W AH",UNRELENTING="AH N R IY L EH N T IH NG",LECHTENBERG="L EH K T AH N B ER G",LYERLA="L AY ER L AH",INTERCHANGE="IH N T ER CH EY N JH",STOCK="S T AA K",ANGEVINE="EY NG G IH V AY N",ATITHER="AH T IH DH ER",BRAHMS="B R AA M Z",ULTRASONIC="AH L T R AH S AA N IH K",COSCIA="K OW S CH AH",BOSCIA="B OW S CH AH",MAZZARELLA="M AA T S AA R EH L AH",COMPUSA="K AA M P Y UW EH S EY",["NIGHTLINE'S"]="N AY T L AY N Z",ESTHETIC="EH S TH EH T IH K",RUSTLER="R AH S L ER",["CAISSONS(2)"]="K EH S AH N Z",["APPLIANCES(2)"]="AH P L AY AH N S IH Z",HUSTLER="HH AH S AH L ER",["DUCOMMUN(2)"]="D UW K AA M UW N",FROCK="F R AA K",KROCK="K R AA K",["DOUBLE-ENTENDRE"]="D AH B AH L AA N T AA N D R AH",PROCK="P R AA K",SROCK="SH R AA K",INTIMIDATING="IH N T IH M IH D EY T IH NG",BERATED="B IH R EY T IH D",GRASSHOPPER="G R AE S HH AA P ER",CERRETA="CH ER EH T AH",BROCK="B R AA K",CROCK="K R AA K",OESTERREICH="OW S T ER AY K",["DIRECTS(2)"]="D AY R EH K T S",DRIVEL="D R IH V AH L",["FLORENCE'S"]="F L AO R AH N S IH Z",PELLICANE="P EH L IH K EY N",BEWILDER="B IH W IH L D ER",EPICURE="EH P IH K Y UH R",KROEGERS="K R OW G ER Z",["BUCHBINDER(2)"]="B UH K B AY N D ER",["SAMUEL'S"]="S AE M Y UW L Z",FAULTS="F AO L T S",DOUMA="D OW M AH",ALMOND="AA M AH N D",PERIGNON="P ER IH N Y AA N",HINGIS="HH IH NG AH S",ANDRIANA="AA N D R IY AE N AH",BERKSHIRES="B ER K SH IH R Z",HILSMAN="HH IH L Z M AH N",UNESCO="Y UW N EH S K OW",["OFFICER'S"]="AO F IH S ER Z",KATRAGADDA="K AA T R AH G AA D AH",IMPLICATING="IH M P L IH K EY T IH NG",BOUMA="B OW M AH",DREWETT="D R UW IH T",["BOISTEROUS(2)"]="B OY S T R AH S",GRASPED="G R AE S P T",VULVA="V UH L V AH",PRISCILLA="P R IH S IH L AH",FESMIRE="F EH S M AY R",PREWETT="P R UW IH T",KASTLER="K AE S T L ER",["KUEBLER(2)"]="K UH B L ER",PAGANI="P AA G AA N IY",CONCERTI="K AH N CH EH R T IY",LEFAUVE="L AH F AA V",MESENTERIC="M EH S AH N T EH R IH K",["DATAPRODUCTS'"]="D EY T AH P R AO D AH K T S",COINCIDING="K OW AH N S AY D IH NG",PEPSI="P EH P S IY",OBSESSIVELY="AA B S EH S IH V L IY",AUDIBLES="AA D AH B AH L Z",MANSUETO="M AE N S W EY T OW",SHOCKINGLY="SH AA K IH NG L IY",DEFIANTLY="D IH F AY AH N T L IY",ZAGURY="Z AE G Y ER IY",OVERDREW="OW V ER D R UW",MISUSED="M IH S Y UW Z D",FRESCO="F R EH S K OW",SPECULATE="S P EH K Y AH L EY T",GOVERNORS="G AH V ER N ER Z",PEATROSS="P IY T R AH S",KORZENIEWSKI="K ER Z IH N IY EH F S K IY",["HOUSE'S"]="HH AW S IH Z",INTERNEES="IH N T ER N IY Z",["ROUSE'S"]="R AW Z IH Z",OBSTRUCTING="AH B S T R AH K T IH NG",["DOEBLER(2)"]="D OW B L ER",STEAMSHIP="S T IY M SH IH P",GANDOLFI="G AA N D OW L F IY",ABOLISHING="AH B AA L IH SH IH NG",["COUNTERSUE(2)"]="K AW N ER S UW",WARPING="W AO R P IH NG",MCCLATCHEY="M AH K L AE CH IY",STARCROSS="S T AA R K R AO S",MOGADISHU="M OW G AH D IY SH UW",DISCOUNTER="D IH S K AW N T ER",HARPING="HH AA R P IH NG",NATIONHOOD="N EY SH AH N HH UH D",DEMOLISHES="D IH M AA L IH SH AH Z",STIMULATING="S T IH M Y AH L EY T IH NG",DIFONZO="D IH F AA N Z OW",DATTILO="D AA T IY L OW",CARPOOL="K AA R P UW L",ATROCIOUS="AH T R OW SH AH S",PRINCIPALITY="P R IH N S IH P AE L IH T IY",SAUEY="S AO IY",["LITCHFORD'S"]="L IH CH F ER D Z",GOLDBECK="G OW L D B EH K",PFLIEGER="F L IY G ER",UNRATED="AH N R EY T IH D",BULGES="B AH L JH IH Z",FINANZIARIO="F IH N AE N Z IY EH R IY OW",OBVIOUSLY="AA B V IY AH S L IY",DAUENHAUER="D AW AH N HH AW ER",TRIPPIE="T R IH P IY",CRITICIZING="K R IH T IH S AY Z IH NG",PERTUSSIS="P ER T AH S IH S",MISERY="M IH Z ER IY",PUGLIESE="P UW G L IY EY Z IY",GUESSED="G EH S T",["MOSQUES(2)"]="M AO S K S",PATENTLY="P AE T AH N T L IY",HEMOND="HH EH M AH N D",SAREJEVO="S AA R AH Y EY V OW",DEMOND="D AH M AA N D",SPOCK="S P AA K",["GRANTED(2)"]="G R AE N T IH D",["FANECH'S"]="F AE N EH K S",HOSKINSON="HH AA S K IH N S AH N",IPOCK="IH P AH K",EVENTUALLY="IH V EH N CH AH W AH L IY",["NEW-YORK"]="N UW Y AO R K",EDQUIST="EH D K W IH S T",BATTLED="B AE T AH L D",ADVENTISTS="AE D V EH N T IH S T S",KLIPFEL="K L IH P F AH L",KOOLHAAS="K UW L HH AA S",CONDUCTOR="K AH N D AH K T ER",RESTOCKING="R IY S T AA K IH NG",SHUEY="SH UW IY",FUJIAN="F UW JH IY AH N",MOLDENHAUER="M OW L D IH N HH AW ER",HOOCK="HH UW K",BOOCK="B UW K",JFET="JH F EH T",MULTIPLIES="M AH L T AH P L AY Z",["PLANTED(2)"]="P L AE N T IH D",FELTLER="F EH L T L ER",["CHELSEA'S"]="CH EH L S IY Z",["THERE'RE"]="DH EH R ER",LIFETIME="L AY F T AY M",SUBCONTRACTED="S AH B K AA N T R AE K T IH D",OSTENTATIOUS="AA S T AH N T EY SH AH S",["WHICH'RE(2)"]="HH W IH CH ER",KNOCK="N AA K",ENTEROLOGY="EH N T ER AA L AH JH IY",COURCHESNE="K UH R SH EH N",LEBRON="L EH B R AH N",ALFONZO="AE L F AA N Z OW",GLASSBLOWERS="G L AE S B L OW ER Z",GRAMMATICAL="G R AH M AE T AH K AH L",UNLEASHES="AH N L IY SH IH Z",WHET="W EH T",SMOCK="S M AA K",BURMEISTER="B ER M AY S T ER",PEGLOW="P EH G L OW",MELTZER="M EH L T S ER",PELTZER="P EH L T Z ER",MINIDISC="M IH N IY D IH S K",VANDAMME="V AE N D AE M",CHET="CH EH T",PAPERY="P EY P ER IY",RESPECTIVELY="R IH S P EH K T IH V L IY",EISENHART="AY Z AH N HH AA R T",["SECONDLY(2)"]="S EH K AH N L IY",["MISIDENTIFYING(2)"]="M IH S AY D EH N AH F AY IH NG",HOSTLER="HH AA S L ER",CLAYMATION="K L EY M EY SH AH N",BLUEY="B L UW IY",THIBODEAUX="TH IH B AH D OW",BUGLE="B Y UW G AH L",LONGRANGE="L AO NG R EY N JH",JUSTIFIABLY="JH AH S T AH F AY AH B L IY",AYMOND="EY M AH N D",PLACARDS="P L AE K ER D Z",DYMOND="D AY M AH N D",["CLAIMANTS'"]="K L EY M AH N T S",LITHUANIAN="L IH TH AH W EY N IY AH N",CALMAT="K AE L M AE T",THRESHOLDS="TH R EH SH HH OW L D Z",EASTENDER="IY S T EH N D ER",ARELLANO="AA R EH L AA N OW",FEODOROVICH="F IY AH D AO R AH V IH CH",PETRUS="P EH T R AH S",STYLISTICALLY="S T AY L IH S T IH K L IY",["AIRPORT'S"]="EH R P AO R T S",["IRELAND'S"]="AY R L AH N D Z",ENNUI="EH N UW IY",CHOYCE="CH OY S",["CANDIDATE(2)"]="K AE N AH D IH T",["KODAK'S"]="K OW D AE K S",HEACOX="HH IY K AA K S",SEESAWING="S IY S AO IH NG",CONVERTS="K AA N V ER T S",BALTZER="B AE L T Z ER",["AESTHETE'S"]="EH S TH IY T S",WALTZER="W AO L T S ER",SCULPTING="S K AH L P T IH NG",["SANKARA'S"]="S AA N K AA R AH Z",SMITHEY="S M IH TH IY",SKETCHING="S K EH CH IH NG",UNVARNISHED="AH N V AA R N IH SH T",REMARKED="R IH M AA R K T",HYPERBOREAN="HH AY P ER B AO R IY AH N",BLUEBLOOD="B L UW B L AH D",["BORROWERS'"]="B AO R AH ER Z",GROENE="G R AA IY N",CONFORMATIONAL="K AA N F ER M EY SH AH N AH L",["DAUGHTERS'"]="D AO T ER Z",BALLOTING="B AE L AH T IH NG",HOLTZER="HH OW L T Z ER",ALQUIST="AE L K W IH S T",MUSLIM="M AH Z L AH M",ARENT="AA R AH N T",MCCASLIN="M AH K AE Z L AH N",MANDATE="M AE N D EY T",BRENT="B R EH N T",INCUBATING="IH N K Y AH B EY T IH NG",AMALGAMATION="AH M AE L G AH M EY SH AH N",CRIMINALISTS="K R IH M AH N AH L IH S T S",CHAPPAQUIDDICK="CH AE P AH K W IH D IH K",FABRON="F AE B R AH N",NARDOZZI="N AA R D OW T S IY",TRUEBLOOD="T R UW B L AH D",RESTORER="R IH S T AO R ER",BURROS="B ER OW Z",CATALFAMO="K AA T AA L F AA M OW",OLIVINE="AA L AH V IY N",SHROPSHIRE="SH R AA P SH AY R",BANTERING="B AE N T ER IH NG",FIBRIN="F AY B R AH N",BUCKSTEIN="B AH K S T IY N",["FORENSICALLY(2)"]="F ER EH N S IH K AH L IY",PROCREATED="P R OW K R IY EY T AH D",BLACKSTON="B L AE K S T AH N",MELVA="M EH L V AH",CENSUSES="S EH N S AH S IH Z",HUYNH="HH AY N",SLITHER="S L IH DH ER",NETTLED="N EH T AH L D",COUEY="K UW IY",ADAMSKI="AH D AE M S K IY",NILGES="N IH L JH IH Z",GREATNESS="G R EY T N AH S",MIRABELLE="M IH R AH B EH L",AMERITRUST="AH M EH R IH T R AH S T",BELVA="B EY L V AH",SMITHER="S M IH DH ER",GOVERNMENTAL="G AH V ER M EH N T AH L",MCAULAY="M AH K AO L EY",["KHOMEINI'S(2)"]="K OW M EY N IY Z",WESTCAP="W EH S T K AE P",BASELESS="B EY S L AH S",KRUCKENBERG="K R AH K AH N B ER G",CARICATURED="K ER IH K AH CH ER D",SPURR="S P ER",ECKENFELDER="EH K AH N F EH L D ER",DIMENSIONED="D AH M EH N CH AH N D",KLOCK="K L AA K",PLOCK="P L AA K",PHOSPHATE="F AA S F EY T",BLOCK="B L AA K",CLOCK="K L AA K",HANDBALL="HH AE N D B AO L",FLOCK="F L AA K",GLOCK="G L AA K",RECOLLECT="R EH K AH L EH K T",GILEAD="G IH L IY D",ULUNDI="Y UW L AH N D IY",BLEWETT="B L UW IH T",DHAHARAN="D AH R AA N",REAPED="R IY P T",ATTACHE="AE T AH SH EY",["EXPRESSO(2)"]="EH K S P EH S OW",LEAPED="L EH P T",MINATOME="M IH N AH T OW M",FIJIAN="F IY JH IY AH N",CATCHACAN="K AE CH AH K AA N",SALVA="S AA L V AH",MALVA="M AA L V AH",["BIGLER(3)"]="B IH G L ER",UNFAV="AH N F EY V",OSMOND="AA S M AH N D",FERRUZZI="F EH R UW Z IY",ESMOND="EH Z M AH N D",VENETIAN="V AH N IY SH AH N",PERCEVAL="P ER S EY V AE L",KUNKLER="K AH NG K L ER",WHITHER="W IH DH ER",["MCABEE(2)"]="M AE K AH B IY",ETHELBERT="EH TH IH L B ER T",CARJACKINGS="K AA R JH AE K IH NG Z",GLAMORIZED="G L AE M ER AY Z D",["NESTLINGS(2)"]="N EH S L IH NG Z",TATTLED="T AE T AH L D",DATAPOINT="D EY T AH P OY N T",ORMOND="AO R M AH N D",RATTLED="R AE T AH L D",["CACHES(2)"]="K AE SH EY Z",NAZARIAN="N AH Z EH R IY AH N",FYOCK="F Y AA K",ARMOND="AA R M AH N D",["SIGLER(3)"]="S IH G L ER",CRUEY="K R AH IY",CONCEPTUALIZATION="K AH N S EH P CH W AH L IH Z EY SH AH N",MOQUIN="M OW K W IY N",JANOSKO="Y AH N OW S K OW",KAZARIAN="K AH Z EH R IY AH N",ANGELITA="AA NG G EH L IY T AH",POPOVIC="P AA P AH V IH K",BLANCHETTE="B L AH N SH EH T",MCGOEY="M AH G AA IY",["POEHL'S"]="P OW L Z",BUSEY="B Y UW Z IY",["LONGEST(2)"]="L AO NG G IH S T",SCHOTTENSTEIN="SH AA T AH N S T IY N",SHAPED="SH EY P T",PSYCHOSOMATIC="S AY K OW S AH M AE T IH K",ROSABELLE="R AA S AH B AH L",JOSTLED="JH AA S AH L D",SENECA="S EH N AH K AH",PUSEY="P Y UW Z IY",STRASZHEIM="S T R AE S HH AY M",MARCHEWKA="M ER CH Y UW K AH",TOGETHERS="T AH G EH DH ER Z",ILARDI="IH L AA R D IY",MIDNIGHT="M IH D N AY T",MESSAGEPAD="M EH S AH JH P AE D",UTSEY="AH T S IY",MICRON="M AY K R AA N",["SCIENTISTS(3)"]="S AY N T IH S",FUMIDORS="F Y UW M AH D AO R Z",RELIANCE="R IH L AY AH N S",SURMA="S ER M AH",["WELLSTONE'S"]="W EH L S OW N Z",SCHNICK="SH N IH K",BURMA="B ER M AH",["HAWKE'S"]="HH AO K S",KHAMENEI="K AH M EY N IY",BIRKENAU="B ER K AH N AW",CUSTODIANS="K AH S T OW D IY AH N Z",MANGIERI="M AA NG G IH R IY",["LENDERS'"]="L EH N D ER Z",CHARTING="CH AA R T IH NG",["RUTSTEIN(2)"]="R AH T S T IY N",REPLICATING="R EH P L IH K EY T IH NG",SALLEE="S AE L IY",GYRATED="JH AY R EY T IH D",VALLEE="V AE L IY",DUCKLINGS="D AH K L IH NG Z",CASHEWS="K AE SH UW Z",DIRKSEN="D ER K S AH N",BONAFIDE="B AA N AH F AY D",ANNOUNCEMENT="AH N AW N S M AH N T",FIRSTBORN="F ER S T B AO R N",ESTRUS="EH S T R AH S",OUTDATE="AW T D EY T",ERRICKSON="EH R IH K S AH N",CURATOLO="K UH R AA T OW L OW",EPHEDRINE="IH F EH D R IH N",MODESTY="M AA D AH S T IY",PRODUCTIVELY="P R AH D AH K T IH V L IY",PREMODERN="P R IY M AO D ER N",GLOSSY="G L AO S IY",SIETSEMA="S IY T S IY M AH",FEDERBUSH="F EH D ER B UH SH",MAGNESIUM="M AE G N IY Z IY AH M",WOEBEGONE="W OW B IH G AO N",NYQUIST="N AY K W IH S T",MENDLOWITZ="M EH N D L AH W IH T S",["LUGAR'S"]="L UW G ER Z",DIBRELL="D IH B R AH L",["SUGAR'S"]="SH UH G ER Z",BLACKERBY="B L AE K ER B IY",PRECIPITATED="P R IH S IH P IH T EY T IH D",JACKSONIAN="JH AE K S OW N IY AH N",IMMUNIZATIONS="IH M Y UW N AH Z EY SH AH N Z",BUSSI="B AH S IY",BRUNET="B R UW N EH T",CEMETERY="S EH M AH T EH R IY",TRUNCHEONS="T R AH N CH IH N Z",KLINGERMAN="K L IH NG ER M AH N",["TAXES'"]="T AE K S IH Z",RUSSI="R UW S IY",MAULE="M AO L",PAULE="P AO L",LAHAIE="L AE HH IY",["ASPIRANT(2)"]="AH S P AY R AH N T",NORMA="N AO R M AH",TORMA="T AO R M AH",CHOCK="CH AA K",EMERGENT="IH M ER JH AH N T",CLINGERMAN="K L IH NG ER M AH N",FORMA="F AO R M AH",BRADYS="B R EY D IY Z",SHOCK="SH AA K",SWITCHBOARD="S W IH CH B AO R D",ERUDITE="EH R AH D AY T",ORDONEZ="AO R D OW N EH Z",INCHCAPE="IH N CH K EY P",GONZALEZ="G AA N Z AA L AH Z",MERLIS="M ER L IY Z",PERLIS="P ER L IH S",REVIEWER="R IY V Y UW ER",HIROSAKAMOKI="HH IH R AH S AE K AH M OW K IY",DEVILWOOD="D EH V AH L W UH D",["NICOTINE'S"]="N IH K AH T IY N Z",["PATAKI'S"]="P AH T AA K IY Z",BETWIXT="B IY T W IH K S T",DELNERO="D EH L N EH R OW",["LONG-OVERDUE"]="L AO NG OW V ER D UW",CLUTCHES="K L AH CH AH Z",READIES="R EH D IY Z",PILGRIM="P IH L G R AH M",SASSI="S AE S IY",["SHOWROOM(2)"]="SH OW R UW M",COVERINGS="K AH V ER IH NG Z",HUSTLED="HH AH S AH L D",DECANDIA="D IH K AA N D IY AH",OFFSETS="AO F S EH T S",["BUCHMILLER(2)"]="B UH K M AH L ER",CLOHESSY="K L AA HH IH S IY",ALDERETE="AE L D ER IY T",BRESSEAU="B R EH S OW",MASSI="M AE S IY",NORCIA="N AO R CH AH",STAIRCASE="S T EH R K EY S",DIRICKSON="D IH R IH K S AH N",DOMESTICATES="D AH M EH S T AH K EY T S",BASSI="B AE S IY",AGONIZING="AE G AH N AY Z IH NG",ACREY="AE K R IY",PARTICLE="P AA R T AH K AH L",["ROBIN(2)"]="R AA B IH N",THOENE="TH AA IY N",["BLAKELY'S"]="B L EY K L IY Z",GIARDI="JH IY AA R D IY",CELLOPHANE="S EH L AH F EY N",CIARDI="CH ER D IY",SKINNIEST="S K IH N IY AH S T",VERSATILE="V ER S AH T AH L",SKIRMISH="S K ER M IH SH",GAREY="G AE R IY",DORENE="D AO R IY N",AGUAYO="AA G W EY OW",LORENE="L AO R IY N",PAPERMAKING="P AE P ER M EY K IH NG",DIGNITARIES="D IH G N AH T EH R IY Z",BORGESON="B AO R G IH S AH N",MAZZOTTA="M AA T S OW T AH",["RECURRING(2)"]="R IY K ER IH NG",REGISTRATIONS="R EH JH IH S T R EY SH AH N Z",BAREY="B EH R IY",CAREY="K EH R IY",HANDSET="HH AE N D S EH T",DEMORALIZATION="D IH M AO R AH L IH Z EY SH AH N",EXCHANGE="IH K S CH EY N JH",DELZELL="D EH L Z AH L",DICKSTEIN="D IH K S T AY N",PIZZERIA="P IY T S ER IY AH",BAILIWICK="B EY L IH W IH K",YOLANDA="Y OW L AA N D AH",["SECURITIES'"]="S IH K Y UH R AH T IY Z",REISDORF="R AY S D AO R F",DEKALB="D IH K AE L B",NUDIST="N UW D IH S T",NOLANDA="N AH L AE N D AH",MCQUERRY="M AH K W EH R IY",WOOLUMS="W UH L AH M Z",SINISI="S IH N IY S IY",KIRCHNERS="K ER K N ER Z",["VARITY'S"]="V EH R IH T IY Z",["GALOOB'S"]="G AH L UW B Z",INFIRMARY="IH N F ER M ER IY",GUNLICKS="G AH N L IH K S",AFTERBURNER="AE F T ER B ER N ER",VALENSUELA="V AE L AH N Z W EY L AH",CLASPED="K L AE S P T",OVERFUND="OW V ER F AH N D",GENOSSENSCHAFTSBANK="G EH N OW S EH N SH AE F T S B AE NG K",HOULE="HH AW L",JOULE="JH UW L",REMODEL="R IY M AA D AH L",WIDOWERS="W IH D OW ER Z",BOULE="B UW L",KLEINPASTE="K L AY N P EY S T",DOBRIN="D AA B R IH N",KOBRIN="K AA B R IH N",["SEMI-HEIGHTS"]="S EH M IY HH AY T S",["WE'LL"]="W IY L",NAQUIN="N AE K W IH N",PAQUIN="P AE K W IH N",SOULE="S AW L",MARKETMAKERS="M AA R K AH T M EY K ER Z",FRASCELLA="F R AA S CH EH L AH",FAYANNE="F EY IH N",CONDITIONING="K AH N D IH SH AH N IH NG",COBRIN="K AA B R IH N",SPROULS="S P R AW L Z",THUMA="TH UW M AH",CLARO="K L AA R OW",MISTLER="M IH S T L ER",KISTLER="K IH S T L ER",NISTLER="N IH S T L ER",DISTLER="D IH S T L ER",OVERCROWDED="OW V ER K R AW D IH D",RIADYS="R IY AA D IY Z",DISBAR="D IH S B AA R",GRESKO="G R EH S K OW",BEDROOMS="B EH D R UW M Z",UPHOLSTER="AH P OW L S T ER",["VERITY'S"]="V EH R AH T IY Z",["STRIKERS'"]="S T R AY K ER Z",RESERVATIONISTS="R EH Z ER V EY SH AH N IH S T S",["POLITICIANS'"]="P AA L AH T IH SH AH N Z",DESTRUCTING="D IH S T R AH K T IH NG",BUDNICK="B AH D N IH K",GAMBRILL="G AE M B R IH L",AMBROSIANO="AE M B R OW S IY AA N OW",STORYLINES="S T AO R IY L AY N Z",HOSTENCH="HH AO S T AH N CH",CAMARGO="K AA M AA R G OW",KOSYAKOV="K OW S Y AA K AO V",RECOILS="R IY K OY L Z",CONSCIENCE="K AA N SH AH N S",DISABUSED="D IH S AH B Y UW Z D",FOTHERINGHAM="F AH DH ER IH NG HH AE M",DORMOUSE="D AO R M AW S",DISINTEGRATED="D IH S IH N T AH G R EY T IH D",STEENROD="S T IY N R AH D",PONTIFICATER="P AA N T IH F AH K EY T ER",RICHCO="R IH K OW",["BOSSLER(2)"]="B AA S L ER",["HOSSLER(2)"]="HH AA S L ER",VANNATER="V AE N AE T ER",AIREY="EH R IY",["EDGAR'S"]="EH D G ER Z",BRULE="B R UW L",TEODORO="T IY OW D AO R OW",DEUCE="D UW S",ASARO="AA S AA R OW",PLAYFORD="P L EY F ER D",GLADYS="G L AE D IH S",SYBRON="S IH B R AH N",ATHLETICALLY="AE TH L EH T IH K L IY",BERNABE="B ER N AH B",NESTLER="N EH S AH L ER",KESTLER="K EH S T L ER",RECHRISTENED="R IY K R IH S AH N D",["CROAT'S"]="K R OW AA T S",SOREY="S AO R IY",TOREY="T AO R IY",MOREY="M AO R IY",KAMRATH="K AE M R AH TH",VENTURINI="V EH N T UH R IY N IY",KOREY="K AO R IY",LOREY="L AO R IY",AFTERWARD="AE F T ER W ER D",GOREY="G AO R IY",MARGESON="M AA R G IH S AH N",SCREECHES="S K R IY CH IH Z",COREY="K AO R IY",DOREY="D AO R IY",SIDEWINDER="S AY D W AY N D ER",PROCELL="P R OW S EH L",MINDSET="M AY N D S EH T",AMARO="AA M AA R OW",PARMELE="P AA R M EH L IY",CALAMITOUS="K AH L AE M AH T AH S",SENEGAL="S EH N AH G AO L",YEARLINGS="Y ER L IH NG Z",DECADENCE="D EH K AH D AH N S",["KUOMINTANG'S"]="K W OW M IH N T AE NG Z",TALIBANS="T AE L IH B AE N Z",UNEARTHLY="AH N ER TH L IY",EYEWITNESS="AY W IH T N AH S",DACRON="D AE K R AA N",BACHMEIER="B AA K M AY ER",COURTEAU="K ER T OW",DESANTIAGO="D IH S AA N T IY AA G OW",ARGUMENTATION="AA R G Y AH M EH N T EY SH AH N",SUPERGIANT="S UW P ER JH AY AH N T",["LAFAYETTE(2)"]="L AA F EY EH T",MIDSHIPMAN="M IH D SH IH P M AH N",KUNSMAN="K AH N S M AH N",HALLUMS="HH AE L AH M Z",BARRACUDA="B EH R AH K UW D AH",SHOWED="SH OW D",STEFFI="S T EH F IY",ENQUIST="EH N K W IH S T",DALZELL="D AE L Z AH L",ENVIRONMENTALIST="IH N V AY R AH N M EH N T AH L IH S T",SADIST="S EY D AH S T",SCRIPTWRITER="S K R IH P T R AY T ER",MAIORANA="M AY AO R AE N AH",["AIRCRAFTS(2)"]="EH R K R AE F S",["IT'LL"]="IH T AH L",EXECUTED="EH K S AH K Y UW T AH D",DEUKMEJIAN="D UW K M EY JH IY AH N",IRRITABLE="IH R AH T AH B AH L",["DIRECTNESS(4)"]="D IH R EH K N AH S",ZABAWA="Z AA B AA W AH",ASCRIBED="AH S K R AY B D",["SHORT-WINDED"]="SH AO R T W IH N D IH D",BACHRACH="B AA K R AH K",CLEPHANE="K L EH F EY N",ISRAELITES="IH Z R AH L AY T S",KIENZLE="K IY N Z AH L",["MONROEVILLE(2)"]="M AH N R OW V IH L",ULREY="AH L R IY",YOSSI="Y OW S IY",REVERSING="R IH V ER S IH NG",RHULE="R UW L",["ENDEAVOR'S"]="IH N D EH V ER Z",PAGEANTS="P AE JH AH N T S",NEUENDORFFER="N UW N D AO R F ER",HASELHORST="HH AE S IH L HH AO R S T",["ELGAR'S"]="EH L G ER Z",MCCLINTON="M AH K L IH N T AH N",SNIFFIEST="S N IH F IY AH S T",GARROS="G EH R OW S",UNEMPLOYED="AH N EH M P L OY D",TARIQ="T AA R IY K",MONTEFUSCO="M OW N T EH F UW S K OW",STEPHANY="S T EH F AH N IY",["RESIGNING(2)"]="R IY Z AY N IH NG",BOSSI="B OW S IY",["ENCRYPT(2)"]="IH N K R IH P T",CALANDRA="K AH L AE N D R AH",AQUILINO="AA K W IY L IY N OW",FRONTAGE="F R AH N T IH JH",KOFOED="K OW F OW D",STANDLEE="S T AE N D L IY",TRIBULATION="T R IH B Y AH L EY SH AH N",AMBRIANO="AE M B R IY AA N OW",ROSSI="R AO S IY",SWIVEL="S W IH V AH L",CANONICO="K AA N OW N IY K OW",KOWNACKI="K AW N AA K IY",BACHELLER="B AA K AH L ER",HULOND="HH Y UW L AH N D",ELLERY="EH L ER IY",["JEFFE(2)"]="JH EH F IY",MATHIEU="M AE TH Y UW",ENTRANCE="EH N T R AH N S",PRAIRIE="P R EH R IY",BARTHOLOMAY="B AA R TH AH L AA M EY",SCHNAUZER="SH N AW Z ER",SUMERIA="S AH M ER IY AH",DEPRECATING="D EH P R AH K EY T IH NG",CANOGA="K AH N OW G AH",RIPPON="R IH P AH N",BOQUIST="B AA K W IH S T",NIPPON="N IH P AA N",INFRINGES="IH N F R IH N JH IH Z",REINSPECT="R IY IH N S P EH K T",JONSMAN="JH AA N Z M AH N",WAREING="W EH R IH NG",CHIODO="K IY OW D OW",ULLERY="UW L ER IY",WEIRICH="W AY R IH K",ENERGETICALLY="EH N ER JH EH T IH K L IY",GROVEL="G R AA V AH L",LUJAN="L UW Y AA N",BOTSFORD="B AA T S F ER D",["PLANE'S"]="P L EY N Z",DOROTHY="D AO R AH TH IY",VENTECH="V EH N T EH K",["OVERLAND(2)"]="OW V ER L AH N D",MICROSCOPES="M AY K R AH S K OW P S",WAINRIGHT="W EY N R AY T",["CONSTELLATION'S"]="K AA N S T AH L EY SH AH N Z",DESHAZER="D EH SH AH Z ER",MOTTLED="M AA T AH L D",PENTECH="P EH N T EH K",ROLLOVER="R OW L OW V ER",ARISTOCRATIC="ER IH S T AH K R AE T IH K",BOTTLED="B AA T AH L D",KYSOR="K AY S ER",MICROPHONE="M AY K R AH F OW N",["NETWORKS'"]="N EH T W ER K S",GIFFORDS="G IH F ER D Z",DIDONNA="D IH D AA N AH",PRINCIPATO="P R IY N CH IY P AA T OW",IRREVOCABLY="IH R EH V AH K AH B L IY",["GLACIER'S"]="G L EY SH ER Z",CHUKCHI="CH UW K CH IY",BARCELONA="B AA R S IH L OW N AH",ZELEZNIK="Z IH L EH Z N IH K",TRANSFERRING="T R AE N S F ER IH NG",HANIFEN="HH AE N IH F AH N",EXPLETIVES="EH K S P L AH T IH V Z",["AUXILIARY(2)"]="AA G Z IH L IY EH R IY",CAUTIONING="K AO SH AH N IH NG",CRYPTIC="K R IH P T IH K",BACKTRACKING="B AE K T R AE K IH NG",REVISITING="R IY V IH Z IH T IH NG",DIANTONIO="D AY AH N T OW N IY OW",GONZO="G AA N Z OW",OBSCURE="AH B S K Y UH R",GATHINGS="G AE TH IH NG Z",COMPELLED="K AH M P EH L D",TURSI="T UH R S IY",NEYENS="N AY N Z",MONZO="M AA N Z OW",NAHMIAS="N AA M IY AH Z",PONZO="P AA N Z OW",["PATRONIZED(2)"]="P AE T R AH N AY Z D",GUILFOYLE="G IH L F OY L",["PROTESTS(2)"]="P R OW T EH S",SURFACE="S ER F AH S",VANARSDALL="V AH N AA R S D AH L",["FURLETT(2)"]="F ER L AH T",GEMINATE="JH EH M AH N AH T",BIALKIN="B IY AA L K AH N",APOPLEXY="AE P AH P L EH K S IY",["EURO(3)"]="Y UH R AH",["TSETSE(2)"]="T IY T S IY",SCHRIVER="SH R AY V ER",DEGENERACY="D IH JH EH N ER AH S IY",MONTEAGUDO="M OW N T AH G UW D OW",PREUSS="P R UW S",CONSERVATORY="K AH N S ER V AH T AO R IY",BRIDLED="B R AY D AH L D",["ISHMAEL(2)"]="IH SH M EY L",COTHRON="K AA TH R AH N",LESMEISTER="L EH S M AY S T ER",LEADINGHAM="L IY D IH NG HH AE M",POSTPONEMENTS="P OW S T P OW N M AH N T S",JEFFORDS="JH EH F ER D Z",STRODER="S T R OW D ER",WOOLENS="W UH L AH N Z",PROFESSIONALIZE="P R AH F EH SH AH N AH L AY Z",TORKELSON="T AO R K IH L S AH N",["MIDLAND'S"]="M IH D L AE N D Z",MARITAL="M EH R AH T AH L",SYLVA="S IH L V AH",MEHLE="M EH HH AH L",["TSAR(2)"]="T S AA R",DISSIMILARITY="D IH S IH M AH L AE R AH T IY",JEHLE="JH EH HH AH L",GEHLE="JH EH HH AH L",IMMOBILIZE="IH M OW B AH L AY Z",THUGGERY="TH AH G ER IY",SIMPLOT="S IH M P L AA T",["GANNETT'S"]="G AE N AH T S",["ESPOUSE(2)"]="IH S P AW S",LEVENBERG="L IY V AH N B ER G",SHOOPMAN="SH UW P M AH N",FORTIFIERS="F AO R T AH F AY ER Z",PHENOMENAL="F AH N AA M AH N AH L",PARSI="P AA R S IY",JOHNSTONE="JH AA N S T OW N",IMPAIRMENTS="IH M P EH R M AH N T S",ALREADY="AO L R EH D IY",PRYCE="P R AY S",NONENTITY="N AA N EH N T AH T IY",KINGERY="K IH NG G ER IY",HEFFERAN="HH EH F ER AH N",CHARLENE="SH AA R L IY N",HOUDEK="HH AW D IH K",["FONDLING(2)"]="F AA N D L IH NG",METHYLENE="M EH TH IH L IY N",["CHERRY'S"]="CH EH R IY Z",BRYCE="B R AY S",SHARLENE="SH AA R L IY N",["EDITING(2)"]="EH D IH T IH NG",UNTHINKING="AH N TH IH NG K IH NG",SIMONETTE="S IH M AH N EH T",YABLONSKI="Y AH B L AA N S K IY",["ALLIEDSIGNAL'S"]="AE L AY D S IH G N AH L Z",LAVALLEY="L AE V AH L IY",KENZO="K EH N Z OW",LENZO="L EH N Z OW",POSTIPANKKI="P AO S T IH P AE NG K IY",AVOWED="AH V AW D",["CASTILLO(2)"]="K AE S T IH L OW",FORGETTE="F ER ZH EH T",BUSHINGS="B UH SH IH NG Z",BANCORP="B AE NG K AO R P",IONIZER="AY AH N AY Z ER",ALMERIA="AA L M ER IY AH",NIELSEN="N IY L S AH N",ANTIGOVERNMENT="AE N T IY G AH V ER M AH N T",["PIPELINE'S"]="P AY P L AY N Z",FARSI="F AA R S IY",STRANGWAYES="S T R AE NG W EY Z",["OCELOT'S"]="AA S AH L AA T S",ANXIOUSLY="AE NG K SH AH S L IY",["EMERY'S"]="EH M ER IY Z",BUTTRUM="B AH T R AH M",WENZLICK="W EH N Z L IH K",BENEDETTO="B IH N AH D EH T OW",CLASSICISM="K L AE S IH S IH Z AH M",["HASTA(2)"]="AA S T AH",["DIEGO'S"]="D IY EY G OW Z",PURPOSEFULLY="P ER P AH S F AH L IY",SABORTECH="S EY B ER T EH K",MULLENAX="M AH L AH N AE K S",OVERTIME="OW V ER T AY M",MADDAMMA="M AH D AA M AH",INDIGENTS="IH N D IH JH AH N T S",STORE="S T AO R",PSYCHIATRIST="S AH K AY AH T R AH S T",MAREADY="M ER EH D IY",RASEY="R AE S IY",KLECKA="K L EH K AH",ABYSSINIAN="AE B S IH N IY AH N",POHLE="P OW HH AH L",MENTALITY="M EH N T AE L AH T IY",["KJAR(2)"]="K EY JH EY EY AA R",MCCORKINDALE="M AH K AO R K AH N D EY L",["AFULA'S"]="AH F UW L AH Z",BASEY="B EY S IY",KAUFHOF="K AO F HH AO F",BOHLE="B OW HH AH L",KASEY="K AE S IY",DORNFELD="D AO R N F EH L D",CEAUSESCU="CH AW CH EH S K Y UW",PHARO="F AA R OW",LANZO="L AE N Z OW",CONTINUANCES="K AH N T IH N Y UW AH N S IH Z",VILLALON="V IY L AA L AO N",FREIBERGER="F R AY B ER G ER",BROWED="B R AW D",CROWED="K R OW D",INTERNALLY="IH N T ER N AH L IY",APPREHENSION="AE P R IH HH EH N SH AH N",MASAKO="M AH S AA K OW",RELABEL="R IY L EY B AH L",BINCHY="B IH N CH IY",["INHABITANTS(2)"]="IH N HH AE B IH T AH N T S",MIYAGAWA="M IY AA G AA W AH",MANZO="M AE N Z OW",BERNASCONI="B ER N AA S K OW N IY",TELANDER="T IY L AE N D ER",SELANDER="S EH L AH N D ER",["PIONEER'S"]="P AY AH N IH R Z",MELANDER="M EH L AH N D ER",MYSZKA="M IH SH K AH",["HUGHSON(3)"]="Y UW S AH N",HELANDER="HH EH L AH N D ER",SPRAWLED="S P R AO L D",BOZICH="B AA Z IH HH",["NUSSBAUM'S(2)"]="N AH S B AA M Z",STOWED="S T OW D",["WILLIE'S"]="W IH L IY Z",JASINOWSKI="JH AE S IH N AW S K IY",BLOOMED="B L UW M D",["FOCUSED(2)"]="F OW K IH S T",FELLMETH="F EH L M AH TH",["INSISTED(2)"]="IH N S IH S T IH D",KLIETHERMES="K L IY TH ER M Z",["ALWALEED(2)"]="AA L W AA L IY D",LUOMA="L UW OW M AH",DISPENSING="D IH S P EH N S IH NG",MAGNIFIES="M AE G N AH F AY Z",RETICENCE="R EH T IH S AH N S",VESEY="V EH S IY",BEREGOVOY="B ER EH G AH V OY",["'END-INNER-QUOTE"]="EH N D IH N ER K W OW T",CORSI="K AO R S IY",DORSI="D AO R S IY",DEGREED="D IH G R IY D",STOCKHOLDERS="S T AA K HH OW L D ER Z",["ECOLOGICAL(2)"]="EH K AH L AA JH IH K AH L",BUNCHY="B AH N CH IY",SPREAD="S P R EH D",STECKLEIN="S T EH K L AY N",BLECHER="B L EH K ER",PUNCHY="P AH N CH IY",DAXOR="D AE K S ER",IRONIZING="AY ER N AY Z IH NG",REZNIK="R EH Z N IH K",["REPRESENTATIVE'S(2)"]="R EH P R IH Z EH N AH T IH V Z",INCULCATED="IH NG K AH L K EY T AH D",PUSHUPS="P UH SH AH P S",CRISMAN="K R IH S M AH N",ERISMAN="EH R IH S M AH N",GISSI="G IH S IY",CITRUS="S IH T R AH S",["GIANFRANCO(2)"]="JH IY AH N F R AE N K OW",FERGESON="F ER G AH S AH N",BERGESON="B ER G IH S AH N",CAPUT="K AH P UH T",ABSORBED="AH B Z AO R B D",NIEMEIER="N IY M AY ER",EXTERNALLY="IH K S T ER N AH L IY",FLAMMABILITY="F L AE M AH B IH L IH T IY",GLEGHORN="G L EH G HH ER N",IMPERIL="IH M P EH R AH L",CLEGHORN="K L EH G HH ER N",["MINUTE(2)"]="M AY N UW T",BARRUS="B AE R AH S",CLORE="K L AO R",FLORE="F L AO R",GLORE="G L AO R",AKYANAMA="AE K Y AA N AA M AH",SOLEMIN="S OW L EH M IH N",GUILE="G AY L",INTERLUDE="IH N T ER L UW D",CAPRON="K AE P R AH N",ACIDIFIES="AH S IH D AH F AY Z",CHAIRWOMAN="CH EH R W UH M AH N",PROMUS="P R OW M AH S",ZAMBITO="Z AA M B IY T OW",["NINOS(2)"]="N IY N Y OW Z",RUMINATE="R UW M IH N EY T",KENNERSON="K EH N ER S AH N",GROOPMAN="G R UW P M AH N",HENNESSEY="HH EH N AH S IY",FENNESSEY="F EH N IH S IY",HISEY="HH IH S IY",AMORE="AA M AO R",SYNTECH="S IH N T EH K",BESANCON="B IH S AE N K AH N",FRAGMENTARY="F R AE G M AH N T EH R IY",COMPLETES="K AH M P L IY T S",["DUCHAMP'S"]="D UW SH AA M P S",ATTACHMENTS="AH T AE CH M AH N T S",SHURR="SH ER",["METHAMPHETAMINE(2)"]="M EH TH AE M F EH T AH M AY N",FLAUNTED="F L AO N T IH D",ENSEY="EH N Z IY",MUSICLAND="M Y UW Z IH K L AE N D",["EARDLEY(2)"]="ER D L IY",RESENDIZ="R IH S EH N D IH Z",DEDOMINICIS="D EY D OW M IY N IY S IH S",POORE="P UW R",PROVOKE="P R AH V OW K",KAGAWA="K AH G AA W AH",EXPECTANCY="IH K S P EH K T AH N S IY",NESSI="N EH S IY",MOSEY="M OW Z IY",POSEY="P OW Z IY",JOSEY="JH OW Z IY",JEZIERSKI="Y IH Z IH R S K IY",LOSEY="L AA S IY",HOSEY="HH OW Z IY",COSEY="K OW Z IY",MERMELSTEIN="M ER M AH L S T AY N",EXILE="EH G Z AY L",GRIESBACH="G R IY S B AA K",GIBBONS="G IH B IH N Z",FLAPPING="F L AE P IH NG",ARCHDUKE="AA R CH D UW K",ELSEY="EH L S IY",TUMULTUOUS="T UW M AH L CH UW AH S",RIBBONS="R IH B AH N Z",SLAPPING="S L AE P IH NG",DIBLASI="D IH B L AA S IY",["MUSLIM(2)"]="M AH Z L IH M",SWINDLED="S W IH N D AH L D",SIGNIFIES="S IH G N AH F AY Z",UNIMPORTANT="AH N IH M P AO R T AH N T",["RESISTED(2)"]="R IY Z IH S T AH D",CLAPPING="K L AE P IH NG",["HARCLERODE(2)"]="HH AA R K L ER OW D",BUSHWHACK="B UH SH W AE K",TOLERATES="T AO L ER EY T S",GOLDFUS="G OW L D F AH S",AMPARAN="AE M P ER AH N",DEITRICH="D AY T R IH K",LEONELLI="L EH N EH L IY",THREAD="TH R EH D",HODGENS="HH AA JH AH N Z",LINKUPS="L IH NG K AH P S",MCCAA="M AH K AA",MCGAUGHEY="M AH G AO IY",SUBSIDIARIES="S AH B S IH D IY EH R IY Z",OFFSPRING="AO F S P R IH NG",TITIAN="T IH SH AH N",LONGINGLY="L AO NG IH NG L IY",CLEANTHA="K L IY N TH AH",DWINDLED="D W IH N D AH L D",ELLEREY="EH L ER IY",BEECHER="B IY CH ER",SCORE="S K AO R",ADDITIONAL="AH D IH SH AH N AH L",UNRECORDED="AH N R IH K AO R D IH D",["EVADERS(2)"]="IY V EY D ER Z",DAHLE="D AA AH L",WITTENAUER="W IH T IH N AW ER",KAHLE="K AA L",["FUNDACION(2)"]="F AO N D AA SH Y OW N",MAHLE="M EY HH AH L",SAWAYA="S AO W AA Y AH",WAHLE="W AO L",["WASHINGTON(2)"]="W AO SH IH NG T AH N",TROMA="T R OW M AH",COOPERVISION="K UW P ER V IH ZH AH N",GROMA="G R AA M AH",KOKAN="K OW K AH N",PADOVANO="P AA D OW V AA N OW",ADORE="AH D AO R",["KINGSLEY'S"]="K IH NG Z L IY Z",ALFREDSSON="AE L F R IH D S AH N",MARGETTE="M AA R ZH EH T",BRONCHIAL="B R AA N CH IY AH L",["VENTILATOR(2)"]="V EH N AH L EY T ER",MAKEGOODS="M EY K G UH D Z",APSEY="AE P S IY",AROMA="ER OW M AH",BUTTERFAT="B AH T ER F AE T",FLEURY="F L UH R IY",["CONSUMER'S"]="K AH N S UW M ER Z",TREFGARNE="T R EH F G AA R N",OROSCO="AO R OW S K OW",BRUCHHAUSEN="B R UW K HH AW Z AH N",CROFTON="K R AA F T AH N",["PERSISTED(2)"]="P ER S IH S T IH D",SNAPPING="S N AE P IH NG",SPARGER="S P AA R JH ER",PREAMBLE="P R IY AE M B AH L",PENNYPACKER="P EH N IH P AE K ER",NIZNIK="N IH Z N IH K",MAVERICK="M AE V ER IH K",["UNFORTUNATELY(2)"]="AH N F AO R CH UW N AH T L IY",GENCORP="JH EH N K AO R P",["BARRICK'S(2)"]="B EH R IH K S",["MAZZOLA'S"]="M AA T S OW L AH Z",GYMBOREE="JH IH M B AO R IY",["ROTOTILLING(2)"]="R OW T OW T IH L IH NG",CHECKERBOARDING="CH EH K ER B AO R D IH NG",DOMBROWSKI="D AH M B R AO F S K IY",["STEELMAKERS'"]="S T IY L M AH K ER Z",COONRADT="K UW N R AE T",["PESTILLO(2)"]="P EH S T IY OW",["COUNCIL'S"]="K AW N S AH L Z",HIGGINBOTHAM="HH IH G IH N B AA TH AH M",DICKASON="D IH K AH S AH N",CORPSMAN="K AO R M AH N",["M-80"]="EH M EY T IY",WHORE="HH AO R",["SELF-GOVERNMENT"]="S EH L F G AH V ER N M AH N T",SHORE="SH AO R",OVERMYER="OW V ER M IY ER",PEET="P IY T",["PAYLOAD'S"]="P EY L OW D Z",NEET="N IY T",MEET="M IY T",LEET="L IY T",SKILLIN="S K IH L IH N",["RECEPTIONISTS(2)"]="R IY S EH P SH AH N IH S T S",FEET="F IY T",TELSOURCE="T EH L S AO R S",CHORE="CH AO R",NEOMA="N EY OW M AH",BEET="B IY T",LEOMA="L IH OW M AH",["RWANDAN'S(2)"]="R UW AA N D AH N Z",PARDOE="P AA R D OW",FREDRIKSON="F R EH D R IH K S AH N",MOHICANS="M OW HH IY K AH N Z",BANGLADESHIS="B AE NG L AH D EH SH IY Z",SCURRIED="S K ER IY D",["PROPHESIED(2)"]="P R AA F AH S IY D",INUNDATED="IH N AH N D EY T IH D",FIORE="F IY AO R IY",AMENT="AE M IH N T",["JEWELER(2)"]="JH UW L ER",RONSTADT="R AA N S T AE T",TRAPPING="T R AE P IH NG",SOCIAL="S OW SH AH L",CHOMA="CH OW M AH",SHEARING="SH IH R IH NG",MONUMENT="M AA N Y UW M AH N T",["DIRECTIONAL(4)"]="D IH R EH K SH IH N AH L",BASSIR="B AH S IH R",WRAPPING="R AE P IH NG",SHAMBURGER="SH AE M B ER G ER",SIGLE="S AY G AH L",ADRIANCE="AA D R IY AH N S",WIGLE="W AY G AH L",WATERSTON="W AO T ER S T AH N",MCINNIS="M AH K IH N AH S",THOMA="TH OW M AH",JOLLIEST="JH AA L IY AH S T",VANNELLI="V AA N EH L IY",["WHITAKER(2)"]="HH W IH T AH K ER",["MILLICOM'S"]="M IH L IH K AA M Z",ELLWANGER="EH L W AO NG ER",RECONCILING="R EH K AH N S AY L IH NG",STEWARDESSES="S T UW ER D AH S IH Z",CENTRISTS="S EH N T R IH S T S",SEIZURES="S IY ZH ER Z",PENCILS="P EH N S AH L Z",RECEPTECH="R IY S EH P T EH K",BRECHER="B R EH K ER",OUTHOUSES="AW T HH AW S IH Z",["RESPECT(2)"]="R IY S P EH K T",["NICKEL'S"]="N IH K AH L Z",SCHMETTERER="SH M EH T ER ER",EVENT="IH V EH N T",SWAPPING="S W AA P IH NG",IMPANELED="IH M P AE N AH L D",BUBBLY="B AH B L IY",EMPANELED="IH M P AE N AH L D",THORNBERG="TH AO R N B ER G",WEYENBERG="W AY N B ER G",ABET="AH B EH T",["MOTORISTS(2)"]="M OW T ER IH S T S",DEFILIPPO="D IH F IY L IY P OW",["ENCHANTERS(3)"]="EH N CH AE N ER Z",DULCIBELLE="D AH L S IH B AH L",MYSTIQUE="M IH S T IY K",FEELINGS="F IY L IH NG Z",SKEPTICS="S K EH P T IH K S",SABERTECH="S EY B ER T EH K",NIGHTCLUB="N AY T K L AH B",ALLEGEDLY="AH L EH JH AH D L IY",CELENTANO="CH EH L EH N T AA N OW",KELEHER="K EH L IH HH ER",FLORANCE="F L AO R AH N S",["GROPPY'S"]="G R AA P IY Z",["SANDWICHES(3)"]="S AE M W IH CH IH Z",SLOMA="S L OW M AH",CHUDLER="CH AH D L ER",IANNELLI="IY AH N EH L IY",BIGLOW="B IH G L OW",NAVARETTE="N AE V ER EH T",LOWENBERG="L OW AH N B ER G",["NONRESTRICTED(2)"]="N AA N R IY S T R IH K T AH D",SEMINARIO="S EH M IH N EH R IY OW",ZUFELT="Z AH F IH L T",DELISI="D EH L IY S IY",SMET="S M EH T",COMPLAINANT="K AH M P L EY N AH N T",AGRAWAL="AH G R AE W AH L",["ODONOGHUE(2)"]="OW D AA N AH HH UW",GLOMB="G L AA M",COMFORTABLE="K AH M F ER T AH B AH L",["SATURDAYS(2)"]="S AE T ER D EY Z",DEEPAK="D IY P AE K",DISABILITIES="D IH S AH B IH L AH T IY Z",["INCHES(2)"]="IH N CH IH Z",STECHER="S T EH K ER",BATCHELLER="B AE CH AH L ER",ELLAMAY="EH L AH M EY",INTERMINGLING="IH N T ER M IH NG G AH L IH NG",["PERES'"]="P EH R EH Z",LIVELINESS="L AY V L IY N AH S",["JESSE'S"]="JH EH S IY Z",DIFILIPPO="D IH F IY L IY P OW",CHARALAMBOS="CH AA R AH L AA M B OW S",["HESSE'S"]="HH EH S IH Z",TRILLIN="T R IH L IH N",CIAVARELLA="CH AH V AA R EH L AH",ODOHERTY="OW D AA ER T IY",RESOLVE="R IY Z AA L V",SPEARING="S P IH R IH NG",HOTHOUSES="HH AA T HH AW S IH Z",REREAD="R IY R IY D",["PUPPETS(2)"]="P AH P IH T S",LEARNING="L ER N IH NG",QUILLIN="K W IH L IH N",ERGLE="ER G AH L",BOOKKEEPING="B UH K K IY P IH NG",CARDIEL="K AA R D IY L",MICROPOLIS="M AY K R AO P AH L IH S",YEARNING="Y ER N IH NG",PLACIDA="P L AA CH IY D AH",BELFAST="B EH L F AE S T",PROCHAZKA="P R AH HH AA Z K AH",PRINKEY="P R IH NG K IY",CHAIRMAN="CH EH R M AH N",PRETENSES="P R IY T EH N S IH Z",HATTUSAS="HH AH T UW S AH S",OVERLYING="OW V ER L AY IH NG",HOMOSEXUALS="HH OW M OW S EH K SH UW AH L Z",ALLOCATE="AE L AH K EY T",IMPERIA="IH M P IY R IY AH",HARTNELL="HH AA R T N AH L",PIET="P AY IH T",FOUNDLING="F AW N D L IH NG",VIET="V IY EH T",BACKSTAGE="B AE K S T EY JH",["KIMLER(2)"]="K IH M L ER",SHORTENED="SH AO R T AH N D",FACIAL="F EY SH AH L",DOZENS="D AH Z AH N Z",AUTHOR="AO TH ER",DIET="D AY AH T",NAOMA="N AA OW M AH",SPELLBINDING="S P EH L B AY N D IH NG",GIAQUINTO="JH AA K W IY N T OW",SMEARING="S M IH R IH NG",["KANTOR'S(2)"]="K AE N T AO R Z",NOGLE="N OW G AH L",["ARCHES(2)"]="AA R CH IH Z",PREFERABLY="P R EH F ER AH B L IY",["SAFETY'S"]="S EY F T IY Z",MAGNETICS="M AE G N EH T IH K S",["ADMISSIONS(2)"]="AH D M IH SH AH N Z",BOGLE="B OW G AH L",CHISMAN="CH IH S M AH N",TIBERIO="T IH B IY R IY OW",HOGLE="HH OW G AH L",SCALZITTI="S K AA L Z IY T IY",DOGLE="D OW G AH L",FOGLE="F OW G AH L",LAMINATE="L AE M AH N AH T",TURBEVILLE="T ER B V IH L",IDENTIFIER="AY D EH N T AH F AY ER",FEIGHNER="F EY N ER",DOWNINGTOWN="D AW N IH NG T AW N",["INVALIDATED(2)"]="IH N V AE L IH D EY T IH D",SCOMA="S K OW M AH",CLEARING="K L IH R IH NG",["LA-NINA"]="L AH N IY N Y AH",INGLE="IH NG G AH L",DOGEARED="D AA G IY R D",HEISMAN="HH AY S M AH N",TRANSMITTED="T R AE N S M IH T IH D",WHEREWITHAL="W EH R W IH DH AO L",MEATPACKERS="M IY T P AE K ER Z",REISMAN="R AY S M AH N",ZELENAK="Z EH L IH N AH K",WEISMAN="W AY S M AH N",ARGUIJO="AA R G W IY Y OW",CIPRIANI="CH IY P R IY AA N IY",SANDIFER="S AE N D AY F ER",INVOLVE="IH N V AA L V",ANEMIC="AH N IY M IH K",DETECTABLE="D IH T EH K T AH B AH L",GRENOUILLE="G R AH N UW IY",ANTICORRUPTION="AE N T AY K ER AH P SH AH N",RADIAL="R EY D IY AH L",LAAKSO="L AA K S OW",KLAUSNER="K L AW S N ER",DUET="D UW EH T",SPACKMAN="S P AE K M AH N",DUPLICATING="D UW P L IH K EY T IH NG",["GIANNI(3)"]="JH Y AA N IY",SNOWED="S N OW D",MAYOR="M EY ER",["CORESTATES'"]="K AO R AH S T EY T S",UNIONIST="Y UW N Y AH N AH S T",KNOWED="N OW D",FRANCHISED="F R AE N CH AY Z D",SUBTERFUGE="S AH B T ER F Y UW JH",PEREDA="P ER EY D AH",OVERBOOKING="OW V ER B UH K IH NG",GILLIARDI="G IH L Y AA R D IY",ENVIOUSLY="EH N V IY AH S L IY",KOSMETSKY="K AA Z M EH T S K IY",["ROEBUCK'S"]="R OW B AH K S",NEITHER="N IY DH ER",["ASHLAND'S"]="AE SH L AH N D Z",["GUARANTY-FIRST"]="G EH R AH N T IY F ER S T",CIRCUITRY="S ER K AH T R IY",COMPRISES="K AH M P R AY Z AH Z",REITHER="R AY DH ER",WOBBLY="W AA B AH L IY",ICICLE="AY S IH K AH L",["BUCHI'S(2)"]="B UW CH IY Z",ZULMA="Z UH L M AH",["GOLDWATER'S"]="G OW L D W AO T ER Z",OTTESEN="AA T IY Z AH N",RECONNOITER="R IY K AH N OY T ER",BRACKMAN="B R AE K M AH N",SEVERER="S EH V IH R ER",LYMPHOBLAST="L IH M F AH B L AE S T",["YESTERDAYS(2)"]="Y EH S T ER D IY Z",ROYCE="R OY S",["WHITING(2)"]="HH W AY T IH NG",JOYCE="JH OY S",LOYCE="L OY S",NOYCE="N OY S",ADJANI="AE D JH AA N IY",METROPOLITANS="M EH T R AH P AA L AH T AH N Z",BOYCE="B OY S",PACIFICORP="P AH S IH F IH K AO R P",PRET="P R EH T",DORMINEY="D AO R M IH N IY",FRET="F R EH T",AWESOMELY="AA S AH M L IY",TAURUSES="T AO R AH S AH Z",CLINTONITE="K L IH N T AH N AY T",SCHNACKENBERG="SH N AE K AH N B ER G",HOUSEWARMING="HH AW S W AA M IH NG",HULSMAN="HH AH L S M AH N",COMPENDIUM="K AH M P EH N D IY AH M",["BACHELOR'S(2)"]="B AE CH L ER Z",MACKELLAR="M AH K EH L ER",ANGELUCCI="AA NG G EH L UW CH IY",MANWARREN="M AH N W AO R AH N",KUHLE="K UW AH L",CHARGER="CH AA R JH ER",PLASTERBOARD="P L AE S T ER B AO R D",BLESSED="B L EH S T",VANDERMOLEN="V AE N D ER M AA L AH N",STET="S T EH T",TRANSCRIPTS="T R AE N S K R IH P T S",GAITHER="G EY TH ER",MILLISECOND="M IH L IH S EH K AH N D",RADICALIZE="R AE D IH K AH L AY Z",RUHLE="R UW AH L",NEWBURG="N UW B ER G",MORGANTI="M AO R G AA N T IY",ORRERY="AO R ER IY",WYLMA="W AY L M AH",SLOWED="S L OW D",["JOURNALISM'S"]="JH ER N AH L IH Z AH M Z",["LIMOS(2)"]="L IY M OW Z",URBASZEWSKI="ER B AH S UW S K IY",["RICHES(2)"]="R IH CH IH Z",GAUTHREAUX="G OW TH R OW",PLOWED="P L AW D",BLOWED="B L OW D",["PRESUMED(3)"]="P R IY Z UW M D",UNIDENTIFIED="AH N AY D EH N T AH F AY D",FLOWED="F L OW D",GLOWED="G L OW D",KOHUT="K OW AH T",BERNOULLI="B ER N UW L IY",LOOKUPS="L UH K AH P S",["MATHEMATICALLY(2)"]="M AE TH AH M AE T IH K L IY",["YURCHAK(2)"]="Y ER AH K",DRESSED="D R EH S T",["WHISKEYS(2)"]="HH W IH S K IY Z",IMPURITIES="IH M P Y UH R AH T IY Z",["MARKHAM'S"]="M AA R K AH M Z",HOOKUPS="HH UH K AH P S",POPIELUSZKO="P OW P IY EH L AH S K OW",PRESSED="P R EH S T",LUMBERMAN="L AH M B ER M AH N",FLURRIED="F L ER IY D",GIGNOUX="G IH N UW",STREBE="S T R IY B",OTTERLOO="AA T ER L UW",LAMPRON="L AE M P R AH N",OLENICK="AA L IH N IH K",INVARIANT="IH N V EH R IY AH N T",AUTOMATE="AO T AH M EY T",BAYDHABO="B EY D AA B OW",CROOKSTON="K R UH K S T AH N",AXELSEN="AE K S EH L S AH N",HUMILIATES="HH Y UW M IH L IY EY T S",CHECKERBOARDS="CH EH K ER B AO R D Z",BARRACKS="B AE R AH K S",HINCKLEY="HH IH NG K L IY",ECKRICH="EH K R IH K",HARGROVE="HH AA R G R OW V",CAGLE="K EY G AH L",HALFHEARTED="HH AE F HH AA R T IH D",FROWNINGLY="F R AW N IH NG L IY",DAGLE="D EY G AH L",NESTLED="N EH S AH L D",HAGLE="HH EY G AH L",MCCALEB="M AH K EY L AH B",NAGLE="N EY G AH L",LAGLE="L EY G AH L",IMPLAUSIBLE="IH M P L AO Z AH B AH L",POET="P OW AH T",["SUNDAY'S"]="S AH N D EY Z",PARDINI="P AA R D IY N IY",NARDINI="N AA R D IY N IY",SEMINARIANS="S EH M AH N EH R IY AH N Z",INFLOW="IH N F L OW",GARDINI="G AA R D IY N IY",MOET="M OW IH T",["DIVESTITURES(2)"]="D AY V EH S T IH CH ER Z",NONPROLIFERATION="N AA N P R AH L IH F ER EY SH AH N",ESTEY="EH S T IY",COMMUTE="K AH M Y UW T",MICHALS="M IH CH AH L Z",REDIAL="R IY D AY AH L",MEDIAL="M IY D IY AH L",["GAYSHILL(2)"]="G EY SH IH L",MARCIA="M AA R SH AH",UNHERALDED="AH N HH EH R AH L D IH D",GARCIA="G AA R S IY AH",["LEWINSKI(2)"]="L AH W IH N S K IY",OUTFIELDS="AW T F IY L D Z",CATHARSIS="K AH TH AA R S AH S",NYET="N Y EH T",BLACKMAN="B L AE K M AH N",ARROYO="ER OY OW",PILATUS="P IY L EY T AH S",HEIGES="HH AY JH IH Z",TAMBOURINE="T AE M B ER IY N",LUTEY="L UW T IY",ANIBAL="AE N IH B AH L",TWADDELL="T W AA D EH L",BEIGES="B EY ZH AH Z",BARCIA="B AA R CH AH",LISZKA="L IH SH K AH",["PHOENIX'S"]="F IY N IH K S IH Z",PREVENTATIVES="P R IY V EH N T AH T IH V Z",INTANGIBLY="IH N T AE N JH AH B L IY",DEBATOR="D IY B EY T ER",MINNELLI="M IH N EH L IY",["ITZHAK(2)"]="IH T S AE K",["HANDLING(2)"]="HH AE N D AH L IH NG",SHISEIDO="SH IH S EY D OW",SCHIEREN="SH IH R AH N",PRAYER="P R EH R",MCGILTON="M AH G IH L T AH N",CURVY="K ER V IY",WHITTON="W IH T AH N",FAILSAFE="F EY L S EY F",["PRIAM'S"]="P R AY AE M Z",TRAYER="T R EY ER",ENCEPHALOPATHY="EH N S EH F AH L AO P AH TH IY",["INTRODUCTIONS(2)"]="IH N T R OW D AH K SH AH N Z",KOMODO="K AH M OW D OW",ENTHUSIASTIC="IH N TH UW Z IY AE S T IH K",["INVESTIGATOR'S"]="IH N V EH S T AH G EY T ER Z",GRAYER="G R EY ER",DRAYER="D R EY ER",LIFELESS="L AY F L AH S",INTERNATIONALLY="IH N T ER N AE SH AH N AH L IY",BOGOR="B OW G AO R",EUNICE="Y UW N AH S",REFENES="R EH F IH N EH S",ROSABEL="R OW Z AH B EH L",PATRONAGE="P AE T R AH N IH JH",ANTICOMPETITIVE="AE N T IH K AH M P EH T IH T IH V",ROETHER="R OW DH ER",["ANALYST(2)"]="AE N AH L IH S T",KOETHER="K OW DH ER",DUMAS="D UW M AH Z",SHIRELL="SH IH R EH L",PORTABLE="P AO R T AH B AH L",YEOMANS="Y OW M AH N Z",KUDZU="K AH D Z UW",SERVELLO="S ER V EH L OW",MALEVOLENT="M AH L EH V AH L AH N T",ILLEGALITY="IH L IY G AE L IH T IY",LOINCLOTH="L OY N K L AO TH",["RESUME(2)"]="R IY Z UW M",["AIX-LA-CHAPELLE(2)"]="EH K S L AA SH AH P EH L",CIRCUIT="S ER K AH T",RHINEHART="R AY N HH AA R T",MULTNOMAH="M AH L N OW M AH",ROMAS="R OW M AH Z",ORREN="AO R AH N",LOMAS="L OW M AH Z",GERMANO="JH ER M AA N OW",HARDBALL="HH AA R D B AO L",MCCORKLE="M AH K AO R K AH L",PROFILING="P R OW F AY L IH NG",TOMAS="T OW M AA S",DIDIER="D IH D IY ER",MENDOZA="M EH N D OW Z AH",PAVEMENT="P EY V M AH N T",FETSKO="F EH T S K OW",["HUDLER(2)"]="HH UW D L ER",COMAS="K OW M AH Z",DOMAS="D OW M AH S",ADDITIONS="AH D IH SH AH N Z",COGNETICS="K AA G N EH T IH K S",REPAIRABLE="R IH P EH R AH B AH L",OVEREAGER="OW V ER IY G ER",SHOBER="SH OW B ER",DIDINIUM="D IH D IH N IY AH M",MCCROSSEN="M AH K R AO S AH N",["IMMIGRANT'S"]="IH M AH G R AH N T S",AVICE="AA V AY S",BARILLARI="B EH R IH L EH R IY",["MEMPHIS(4)"]="M EH M P F IH S",COMPULSIVELY="K AH M P AH L S IH V L IY",["KILOMETERS(2)"]="K IH L AH M IY T ER Z",TUMERIC="T UW M EH R IH K",TWICE="T W AY S",LIMAS="L AY M AH Z",STREY="S T R EY",NUMERIC="N UW M EH R IH K",ARNESON="AA R N IH S AH N",["REMARKED(2)"]="R IY M AA R K T",MUSAVI="M Y UW S AA V IY",DIMAS="D AY M AH Z",ALEJO="AA L EY Y OW",TOMASETTI="T OW M AA S EH T IY",ANIMOUS="AE N IH M AH S",MULTER="M AH L T ER",SIMAS="S AY M AH Z",RUMMAGE="R AH M IH JH",DUREN="D UH R AH N",AMESVILLE="EY M Z V IH L",EJACULATE="IH JH AE K Y UW L EY T",["PONTIAC(2)"]="P AA N IY AE K",WOLTERS="W OW L T ER Z",VACCINATE="V AE K S AH N EY T",["DATABASES(2)"]="D AE T AH B EY S IH Z",EVREN="EH V R AH N",ECONOCOM="IY K AA N OW K AA M",OLLILA="AA L IH L AH",["AFRICAN(2)"]="AE F R IH K AH N",JUICE="JH UW S",GUICE="G AY S",SKINLESS="S K IH N L AH S",BUICE="B IH S",FUREY="F Y UH R IY",CASSANDRA="K AH S AE N D R AH",CLOSETED="K L AA Z AH T IH D",DOBBIE="D AA B IY",["WITHOUT(2)"]="W IH DH AW T",BOBBIE="B AA B IY",["PRODUCTIONS'"]="P R AH D AH K SH AH N Z",HOBBIE="HH AA B IY",MCCREARY="M AH K R IH R IY",BOOKSTORE="B UH K S T AO R",TRIMMER="T R IH M ER",ROBBIE="R AA B IY",SCHWICHTENBERG="SH W IH K T AH N B ER G",OVEREXCITE="OW V ER EH K S AY T",BOGOTA="B OW G AH T AA",GRIMMER="G R IH M ER",EARNEY="ER N IY",HARNEY="HH AA R N IY",GARNEY="G AA R N IY",BARNEY="B AA R N IY",KILTER="K IH L T ER",CARNEY="K AA R N IY",PRIMMER="P R IH M ER",PEDDLED="P EH D AH L D",IRANIANS="AY R EY N IY AH N Z",DIGNITARY="D IH G N AH T EH R IY",ANSWERS="AE N S ER Z",CONFABULATION="K AH N F AE B Y AH L EY SH AH N",SUBPOENA="S AH P IY N AH",KAKIMOTO="K AA K IH M OW T OW",CAPITALIZATION="K AE P IH T AH L IH Z EY SH AH N",BRIMMER="B R IH M ER",PRESUMPTIVE="P R IY Z AH M P T IH V",BUISSON="B W IY S AA N",OVERREACTING="OW V ER R IY AE K T IH NG",["FENJVES(2)"]="F EH N V EH Z",PLAYER="P L EY ER",DUNAVANT="D UW N AA V AH N T",["QUARTERMASTER(2)"]="K AO R T ER M AE S T ER",SAMMARCO="S AA M AA R K OW",DILLEHAY="D IH L IH HH EY",KURTENBACH="K ER T IH N B AA K",PASSINO="P AA S IY N OW",LEVENDUSKY="L IH V IH N D AH S K IY",CODDLED="K AA D AH L D",["MARKETING'S"]="M AA R K AH T IH NG Z",RUMACK="R UW M AE K",OPTIMIST="AA P T AH M IH S T",LIFESTYLE="L AY F S T AY L",["DIVERSITY(3)"]="D AY V ER S AH T IY",HOLDERFIELD="HH OW L D ER F IY L D",DELILA="D EH L IY L AH",THOEN="TH OW N",SHOEN="SH UW N",GOLDENSON="G OW L D AH N S AH N",DEMANDINGLY="D IH M AE N D IH NG L IY",TOREN="T AO R AH N",PORTRAYS="P AO R T R EY Z",CAPITULATION="K AH P IH CH AH L EY SH AH N",WIDDLED="W IH D AH L D",LICENCES="L AY S AH N S IH Z",["JERSEY'S"]="JH ER Z IY Z",GUDELAY="G UW D AH L EY",STAGGERS="S T AE G ER Z",SUPPORTERS="S AH P AO R T ER Z",GERRITS="JH EH R IH T S",ERYTHROPOIETIN="EH R IH TH R AH P OY T IH N",TREVATHAN="T R EH V AH TH AH N",RIDDLED="R IH D AH L D",BRAZEAU="B R AH Z OW",AMENABLE="AH M EH N AH B AH L",["GESSLER(2)"]="G EH S L ER",FRESHENS="F R EH SH AH N Z",FRISCO="F R IY S K OW",DEROGATORY="D ER AA G AH T AO R IY",BRISCO="B R IY S K OW",CRISCO="K R IY S K OW",BROCKWAY="B R AA K W EY",["FEDERALS(2)"]="F EH D R AH L Z",SPECIFIED="S P EH S AH F AY D",ARMAS="AA R M AH Z",["USES(3)"]="Y UW Z AH Z",SARNEY="S AA R N IY",MARNEY="M AA R N IY",SHOTTS="SH AA T S",REMEDIES="R EH M AH D IY Z",KARNEY="K AA R N IY",CAPONI="K AA P OW N IY",POSNICK="P AO S N IH K",["DIRECTORIAL(3)"]="D IY R EH K T AO R IY AH L",GRETHER="G R EH DH ER",GUESSWORK="G EH S W ER K",["EMUIL'S"]="EH M Y UW IH L Z",LEATHERBACK="L EH DH ER B AE K",COREN="K AO R AH N",CAFFREY="K AE F R IY",DOREN="D AO R AH N",GOREN="G AO R AH N",SWIMMER="S W IH M ER",HOREN="HH AO R AH N",KOREN="K AO R AH N",PRISCO="P R IY S K OW",JAFFREY="JH AE F R IY",LOREN="L AO R AH N",NOREN="N AO R AH N",FLAPJACK="F L AE P JH AE K",EMULEX="EH M Y UW L AH K S",BIELBY="B IY L B IY",FANTASIZED="F AE N T IH S AY Z D",["BERGSTRAUSSER'S"]="B ER G S T R AW S ER Z",INVENTED="IH N V EH N T AH D",REPRESSIVE="R IY P R EH S IH V",LIMPETS="L IH M P AH T S",BRENNEN="B R EH N AH N",DRENNEN="D R EH N AH N",HUARD="HH W AA R D",SHELBY="SH EH L B IY",BARNICK="B AA R N IH K",CASTELLUCCIO="K AA S T EH L UW CH IY OW",INTERSPERSE="IH N T ER S P ER S",POLACK="P OW L AE K",SUARD="S UW AA R D",WARNICK="W AO R N IH K",CHIAPAS="CH IY AA P AH S",HAREN="HH EH R AH N",DAREN="D AE R IH N",["RIMPOCHET(2)"]="R IH M P OW CH AH T",STOBER="S T OW B ER",MILLILITERS="M IH L AH L IY T ER Z",ALISKY="AH L IH S K IY",GENOESE="JH EH N OW S",PARISE="P AA R AY Z",CHRISTISON="K R IH S T IH S AH N",ZENAS="Z IY N AH Z",GROBER="G R OW B ER",ROULAC="R UW L AE K",["HWANG-HO(2)"]="HH W AA NG HH OW",["BARRICK'S"]="B AE R IH K S",INGIMARSON="IH NG AH M AA R S AH N",UNFURLED="AH N F ER L D",AUDITIONS="AO D IH SH AH N Z",SUCCESSFUL="S AH K S EH S F AH L",MISHRA="M IH SH R AH",["NORTHRUP'S"]="N AO R TH R AH P S",MCCLAIN="M AH K L EY N",PRZYBYLSKI="P ER Z AH B IH L S K IY",WOLTER="W OW L T ER",WONDERFULLY="W AH N D ER F AH L IY",MOLTER="M OW L T ER",KOLTER="K OW L T ER",DEPRESSIVE="D IH P R EH S IH V",PATLEX="P AE T L EH K S",MANIACI="M AA N IY AA CH IY",BOLTER="B OW L T ER",HOLTER="HH OW L T ER",HOMONYMS="HH AO M AH N IH M Z",["NOTES'"]="N OW T S",METALLATZ="M EH T AE L AH T S",HURRIED="HH ER IY D",ASCENDANCE="AH S EH N D AH N S",CENTRALISTS="S EH N T R AH L IH S T S",POLYAK="P AA L Y AE K",["BARCLAY'S(2)"]="B AA R K L EY Z",OBSTACLE="AA B S T AH K AH L",NAVAJOS="N AA V AH HH OW Z",ANTAYA="AA N T EY AH",SASSAMAN="S AE S AH M AH N",MERNICK="M ER N IH K",AESTHENOPIA="AE S TH AH N AO P Y AH",BYARD="B Y AA R D",INDUSTRIE="IH N D AH S T R IY",LINHARES="L IH N HH ER Z",KUKUK="K UW K AH K",PLEASINGLY="P L IY Z IH NG L IY",OGREN="AA G R EH N",MINIMALIST="M IH N AH M AH L IH S T",BERNICK="B ER N IH K",HELTER="HH EH L T ER",DEREN="D IH R AH N",ORTIS="AO R T IH S",VERNICK="V ER N IH K",GEREN="G IH R AH N",["SOFTWARE(2)"]="S AO F W EH R",ARTIS="AA R T IH S",KELTER="K EH L T ER",GLISSON="G L IH S AH N",ENTRENCHES="EH N T R EH N CH IH Z",HYMAS="HH AY M AH Z",MATTHEY="M AE T DH IY",BELTER="B EH L T ER",["REJECTING(2)"]="R IY JH EH K T IH NG",ESTIS="EH S T IH S",KUENNEN="K UH N AH N",PRESIDENTIAL="P R EH Z AH D EH N CH AH L",AWARD="AH W AO R D",PESSIMISTIC="P EH S AH M IH S T IH K",KAREN="K EH R AH N",WAREN="W EH R AH N",UNDERSTATEMENT="AH N D ER S T EY T M AH N T",SWARD="S W AO R D",SOVEXPORTFILM="S OW V EH K S P AO R T F IH L M",STANFORTH="S T AE N F ER TH",PADDLED="P AE D AH L D",UPSIZING="AH P S AY Z IH NG",GRISSON="G R IH S AH N",SPECULATORS="S P EH K Y AH L EY T ER Z",SADDLED="S AE D AH L D",THICKLY="TH IH K L IY",EXBROKERS="EH K S B R OW K ER Z",VENICE="V EH N AH S",CANONIZED="K AE N AH N AY Z D",HOUSECLEANING="HH AW S K L IY N IH NG",ANNAS="AE N AH Z",POISSON="P OY Z S AH N",PREMEDITATED="P R IY M EH D AH T EY T IH D",ROXANNE="R AA K S IH N",UNCONCEALED="AH N K AH N S IY L D",SLICKLY="S L IH K L IY",CHAMPEAU="SH AE M P OW",DISPERSIVE="D IH S P ER S IH V",BRISSON="B R IH S AH N",GLOBETROTTER="G L OW B T R AO T ER",GREENAWALT="G R IY N AH W AO L T",SASKATOON="S AE S K AH T UW N",STAINLESS="S T EY N L AH S",CHRISTIANE="K R IH S T IY AA N",OPPRESSIVE="AH P R EH S IH V",["MILITARY'S"]="M IH L IH T EH R IY Z",DYNAMOMETER="D AY N AH M AA M AH T ER",ALUMINIO="AE L UW M IY N IY OW",CARTLEDGE="K AA R T L EH JH",TELECHECK="T EH L AH CH EH K",JOFFREY="JH AO F R IY",SPECIALITIES="S P EH SH AH L T IY Z",UNSAVORY="AH N S EY V ER IY",["ISOMEDIX'S(2)"]="AY S OW M EH D IH K S",["PRESSURE'S"]="P R EH SH ER Z",SUREN="S UH R AH N",CANRON="K AE N R AH N",CRISPIN="K R IH S P IH N",LAUTENBACH="L AW T AH N B AA K",WOODKE="W UH D K IY",["REPEALED(2)"]="R IY P IY L D",TENUTA="T EH N UW T AH",BREIER="B R AY ER",MORTALITY="M AO R T AE L AH T IY",FREIER="F R EY ER",DREIER="D R AY ER",HOMERIC="HH OW M EH R IH K",IMPRESSIVE="IH M P R EH S IH V",DISTRACTED="D IH S T R AE K T AH D",HORNEY="HH AO R N IY",GORNEY="G AO R N IY",FORNEY="F AO R N IY",PICTURETEL="P IH K CH ER T EH L",["CONCILIATOR'S"]="K AH N S IH L IY EY T ER Z",SAILBOATS="S EY L B OW T S",IZARD="IH Z ER D",CORNEY="K AO R N IY",MOLINARI="M AO L AH N AA R IY",VALIDATES="V AE L AH D EY T S",HUBBUB="HH AH B AH B",RUMNEY="R AH M N IY",BRAINLESS="B R EY N L IH S",FILTERS="F IH L T ER Z",["EVEREST'S(2)"]="EH V R AH S T S",ADOLPHUS="AH D AO L F AH S",TEBUTHIURON="T EH B AH TH Y UW R AA N",IMPUTE="IH M P Y UW T",["BORLAND'S"]="B AO R L AH N D Z",MUNYON="M AH N Y AH N",CERISE="S ER IY S",["BROADCASTER'S"]="B R AO D K AE S T ER Z",PROVABLE="P R UW V AH B AH L",STEIER="S T AY ER",RUNYON="R AH N Y AH N",["TRANSATLANTIC(2)"]="T R AE N Z AH T L AE N IH K",CATASTROPHES="K AH T AE S T R AH F IY Z",CARDELLO="K AA R D EH L OW",["NATASHA'S(2)"]="N AH T AE SH AH Z",BREATHS="B R EH TH S",STAHLY="S T AE L IY",ENNOBLING="IH N OW B L IH NG",WRONGDOERS="R AO NG D UW ER Z",GAULTIER="G OW L T Y EY",FLAGELLATE="F L AE JH AH L EY T",CHOICERS="CH OY S ER Z",FRAMED="F R EY M D",["ALVAREZ'S"]="AE L V ER EH Z IH Z",DOWNTURNS="D AW N T ER N Z",PLATFORM="P L AE T F AO R M",PERMEATING="P ER M IY EY T IH NG",CANAS="K AE N AH Z",BANAS="B AE N AH Z",ABALOS="AA B AA L OW Z",MANAS="M AA N AH Z",["ARBITRAGERS'"]="AA R B IH T R AA ZH ER Z",JANAS="JH AE N AH Z",COUSINO="K AW S IY N OW",HANAS="HH AE N AH Z",GANAS="G AE N AH Z",WYKLE="W AY K AH L",DICEON="D IH S IY AH N",PANAS="P AE N AH Z",VANESSEN="V AA N IH S AH N",HAJJAR="HH AA Y AA R",NAJJAR="N AA Y AA R",LEEDHAM="L IY D HH AH M",BEARD="B IH R D",NEEDHAM="N IY D AH M",SKOV="S K AA V",HEARD="HH ER D",MEDNICK="M EH D N IH K",NEPHEWS="N EH F Y UW Z",COILE="K OY L",INFORMALLY="IH N F AO R M AH L IY",MAZELTOV="M AA Z AH L T AA F",DOWNS="D AW N Z",["AUJOURD'HUI'S"]="OW ZH AO R D W IY Z",INSTITUTES="IH N S T AH T UW T S",ERADICATION="IH R AE D AH K EY SH AH N",EXPRESSIVE="IH K S P R EH S IH V",TRAUMAS="T R AO M AH Z",["LORENZO'S(2)"]="L ER EH N Z OW Z",["GATES'"]="G EY T S",SCHUT="SH AH T",["SEVENTIES(2)"]="S EH V AH N IY Z",TOWNS="T AW N Z",["BATES'"]="B EY T S",["HIBERNIA'S"]="HH AY B ER N IY AH Z",LEARD="L ER D",ROBINETT="R AA B IH N EH T",["CONSERVATIVES'"]="K AH N S ER V AH T IH V Z",EMPHASES="EH M F AH S IY Z",ACIDIC="AH S IH D IH K",OVERCROWD="OW V ER K R AW D",EMILE="EY M IY L",CONTRIBUTION="K AA N T R AH B Y UW SH AH N",["SEATTLE'S"]="S IY AE T AH L Z",GOEDDE="G OW D",TUNAS="T UW N AH Z",["SADAT'S"]="S AA D AA T S",DOUBRAVA="D AW B R AH V AH",HARPISTS="HH AA R P IH S T S",JOZEF="JH OW Z AH F",RUETER="R UW T ER",INTIMATELY="IH N T AH M AH T L IY",SUPPLEMENTAL="S AH P L AH M EH N T AH L",VICTIMIZING="V IH K T AH M AY Z IH NG",["DALLAS'"]="D AE L AH S",AMBOY="AE M B OY",KROTZER="K R OW T Z ER",MARSHALLED="M AA R SH AH L D",REPAYING="R IY P EY IH NG",CROTZER="K R OW T Z ER",SMILE="S M AY L",FOODSERVICE="F UW D S ER V IH S",BABYSAT="B EY B IY S AE T",GUNFIGHT="G AH N F AY T",ENFORCES="EH N F AO R S IH Z",["NICE(2)"]="N IY S",GIARD="JH IY AA R D",NOONEY="N UW N IY",MOONEY="M UW N IY",LOONEY="L UW N IY",["CONTROL'S"]="K AH N T R OW L Z",LOWEY="L OW IY",COMEDIES="K AA M AH D IY Z",GORGAS="G AO R G AH Z",["SARANDON(2)"]="S EH R AE N D IH N",HOWEY="HH AW IY",BRATCHER="B R AE CH ER",SERGEANTS="S AA R JH AH N T S",TRAGICALLY="T R AE JH IH K L IY",SUMMERFORD="S AH M ER F ER D",["WESTAMERICA'S"]="W EH S T AH M EH R IH K AH Z",YOCHIM="Y AA CH IH M",LANDLORDS="L AE N D L AO R D Z",CHARD="CH AA R D",AIRDROPS="EH R D R AA P S",INTELLIGENT="IH N T EH L AH JH AH N T",RAFTER="R AE F T ER",JOCHIM="JH AA K IH M",WIARD="W AY AA R D",DEITERS="D AY T ER Z",UNMANAGE="AH N M AE N IH JH",NEWMARKET="N UW M AA R K AH T",AGARD="AE G ER D",ROADCAP="R OW D K AE P",WOODLANDS="W UH D L AE N D Z",DEGRAVE="D IH G R AA V IY",SUMMITRY="S AH M IH T R IY",CREAGH="K R IY G",PERUSAL="P ER UW Z AH L",["MARTINS'S"]="M AA R T IH N Z IH Z",BRISKY="B R IH S K IY",VALLEGRANDE="V AE L IY G R AE N D IY",FRISKY="F R IH S K IY",RINAS="R AY N AH Z",["PENETRATED(2)"]="P EH N AH T R EY T IH D",MINAS="M IY N AH S",CRUMB="K R AH M",GINAS="JH IY N AH Z",ACCOMANDO="AA K OW M AA N D OW",EHREN="EH R AH N",EMARD="EH M ER D",FUTURISM="F Y UW CH ER IH Z AH M",AHREN="AA R AH N",AGILE="AE JH AH L",NEVILE="N EY V AY L",ROADSIDE="R OW D S AY D",MARGOLIN="M AA R G AH L IH N",REVILE="R IY V AY L",["DUPRIEST(2)"]="D UW P R IY S T",SCOTTS="S K AA T S",WHILE="W AY L",VEVEY="V EH V IY",NEPTUNIUM="N EH P T UW N IY AH M",FEATHERSTONE="F EH DH ER S T OW N",GIREN="G IH R AH N",HEVEY="HH IH V EY",BALLOONISTS="B AH L UW N IH S T S",LEVEY="L IH V EY",HACKLER="HH AE K AH L ER",["PROVINCE(2)"]="P R AA V IH N S",GERHARD="G ER HH AA R D",PEVEY="P IH V EY",GOVERNMENTS="G AH V ER M AH N T S",GILDERSLEEVE="G IH L D ER S L IY V",HOLYCROSS="HH OW L IY K R AO S",RISKINESS="R IH S K IY N AH S",DECOY="D AH K OY",FUHRMANS="F UH R M AH N Z",TOLLEFSEN="T AA L IH F S AH N",PLAUSIBILITY="P L AO Z IH B IH L IH T IY",LAVERY="L EY V ER IY",WHISKY="W IH S K IY",BAHRAINI="B ER EY N IY",IKARD="IH K ER D",SAVERY="S EY V ER IY",CLOONAN="K L UW N AH N",ZAVERY="Z EY V ER IY",LIQUIDATES="L IH K W IH D EY T S",["YESTERDAY'S(2)"]="Y EH S T ER D IY Z",RATIONS="R AE SH AH N Z",NATIONS="N EY SH AH N Z",CHILE="CH IH L IY",TANIMOTO="T AA N IY M OW T OW",CROSSPIECES="K R AO S P IY S AH Z",MCVEY="M AH K V EY",["HERBALISTS(3)"]="ER B AH L AH S",HEADCHEESE="HH EH D CH IY Z",["HUMANA'S"]="HH Y UW M AE N AH Z",DAUSTER="D AW S T ER",NEILE="N IY L",DAHLQUIST="D AA L K W IH S T",BLUDGEONED="B L AH JH AH N D",DEAKINS="D IY K IH N Z",["FOSSEY'S"]="F AA S IY Z",["DOCUMENTARY(3)"]="D AA K Y UW M EH N T ER IY",SOYBEAN="S OY B IY N",EHRHARD="EH R HH ER D",PERMANENCE="P ER M AH N AH N S",ANGRILY="AE NG G R AH L IY",MINNAAR="M IH N AA R",RHONEY="R OW N IY",PHONEY="F OW N IY",GALYON="G AE L IY AA N",EXETER="EH K S IH T ER",YATSKO="Y AA T S K OW",BIGBIE="B IH G B IY",LONAS="L OW N AH Z",ACTIONS="AE K SH AH N Z",HIGBIE="HH IH G B IY",CERNEY="S ER N IY",BERNEY="B ER N IY",MERENGUE="M ER EY NG",["WHIZZER(2)"]="HH W IH Z ER",KERNEY="K ER N IY",MATSKO="M AA T S K OW",NERNEY="N ER N IY",PATTILLO="P AA T IH L OW",INFORMIX="IH N F AO R M IH K S",HOARD="HH AO R D",FOARD="F AO R D",IDEALIZE="AY D IY L AY Z",LAWLIS="L AO L IH S",CARLTON="K AA R L T AH N",LINKAGE="L IH NG K AH JH",ACRONYMS="AE K R AH N IH M Z",MACKLER="M AE K L ER",GWENORE="G W EH N ER",TARLTON="T AA R L T AH N",MARLTON="M AA R L T AH N",SACKLER="S AE K L ER",MONGIELLO="M OW N JH EH L OW",THATCHER="TH AE CH ER",ENGRAVE="IH N G R EY V",WEATHERSTONE="W EH DH ER S T OW N",HENTHORNE="HH EH N TH AO R N",SOARD="S AO R D",RYAVA="R AY AA V AH",["LATINA(2)"]="L AH T IY N AH",["PIVOTED(2)"]="P IH V AH T IH D",["WEISENSEL(2)"]="W AY Z IH N S AH L",GOLDFISH="G OW L D F IH SH",THIBADEAU="T IH B AH D OW",["DOCUMENTATION(2)"]="D AA K Y UW M EH N T EY SH AH N",BEATTIE="B IY T IY",OLVEY="OW L V IY",CANNELLA="K AA N EH L AH",EMPTIES="EH M P T IY Z",SABOTEUR="S AE B AH T ER",["WEBER'S(2)"]="W EH B ER Z",ALVEY="AE L V IY",GOTHARD="G AA TH ER D",SWEIGART="S W IY G AA R T",MANNELLA="M AA N EH L AH",ENCAMPMENTS="IH N K AE M P M IH N T S",MEVACOR="M EH V AH K AO R",RASNICK="R AE S N IH K",JEANMICHELE="ZH AA N M AH SH EH L",CUSMANO="K UW S M AA N OW",PREORDAIN="P R IY AO R D EY N",LEGITIMACY="L AH JH IH T AH M AH S IY",IDONEY="IH D OW N IY",SUPERMARKET="S UW P ER M AA R K IH T",ENGELBERT="EH NG G IH L B ER T",TEETER="T IY T ER",GALLBLADDER="G AO L B L AE D ER",REELECTING="R IY IH L EH K T IH NG",SCHAEFFER="SH EH F ER",GEOMORPHOLOGY="JH IY AH M AO R F AA L AH JH IY",KEETER="K IY T ER",JEETER="JH IY T ER",HANDCRAFTS="HH AE N D K R AE F T S",ABRASIVE="AH B R EY S IH V",DEETER="D IY T ER",JANSENISM="JH AE N S IH N IH Z AH M",CONNOISSEUR="K AA N AH S ER",NOUVEL="N UW V AH L",ALBERTINI="AA L B ER T IY N IY",PAGEANTRY="P AE JH AH N T R IY",MONESSEN="M OW N AH S AH N",DEDERICK="D EH D ER IH K",MENJIVAR="M EY N Y IY V AA R",["GALA(2)"]="G EY L AH",RAYNET="R EY N EH T",IRRETRIEVABLY="IH R AH T R IY V AH B L IY",MOVEMENT="M UW V M AH N T",CHAIRING="CH EH R IH NG",OFARRELL="OW F EH R AH L",BOLANCIK="B AH L AE N S AH K",SWINEHART="S W AY N HH AA R T",BROCKHOFF="B R AA K HH AO F",CHLAMYDIA="K L AE M AY D IY AH",ROSALIND="R AA Z AH L IH N D",HYPERMARKET="HH AY P ER M AA R K IH T",PROHIBITING="P R OW HH IH B AH T IH NG",HALTERS="HH AO L T ER Z",TIAACREF="T IY AH K R EH F",AQUEOUS="EY K W IY AH S",CONSIDER="K AH N S IH D ER",AUREOLE="AA R IY OW L",SALTERS="S AO L T ER Z",WALTERS="W AO L T ER Z",["INITIATIVE(2)"]="IH N IH SH Y AH T IH V",DOWDA="D AW D AH",HAVEY="HH EY V IY",BRACHII="B R EY K IY AY",GRUBSTEIN="G R AH B S T IY N",DAVEY="D EY V IY",CAVEY="K EY V IY",RESNICK="R EH Z N IH K",PAVEY="P EY V IY",INUNDATING="IH N AH N D EY T IH NG",LESNICK="L EH S N IH K",REPUTE="R IY P Y UW T",DISCOUNTS="D IH S K AW N T S",DISPELLED="D IH S P EH L D",CHOICE="CH OY S",["FRANCIS'"]="F R AE N S AH S",GEBBIE="JH EH B IY",CARABAJAL="K ER AE B AH JH AH L",BLUSTER="B L AH S T ER",ALLSOPP="AO L S AA P",FREELOADERS="F R IY L OW D ER Z",["GEMCRAFT'S"]="JH EH M K R AE F T S",KASDORF="K AE S D AO R F",MANGIAPANE="M AE N JH IY AH P EY N",BAILE="B EY L",DAILE="D EY L",GAILE="G EY L",["REAGANESQUE(2)"]="R IY G AH N EH S K",HAILE="HH EY L",MAILE="M EY L",MANAGED="M AE N AH JH D",WRITERS="R AY T ER Z",GLIMMER="G L IH M ER",CONSCRIPTS="K AA N S K R IH P T S",RAILE="R EY L",GASTONIA="G AH S T OW N IY AH",VAILE="V EY L",SURBER="S ER B ER",INDEFINITELY="IH N D EH F AH N AH T L IY",PAPANDREA="P AA P AA N D R IY AH",GRUIS="G R UW IH Z",["AGRICULTURALLY(2)"]="AE G R IH K AH L CH R AH L IY",FITZGIBBONS="F IH T S JH IH B AH N Z",FURBER="F ER B ER",ENDUED="EH N D UW D",["DEPRIEST(2)"]="D IH P R IY S T",KREUGER="K R OY G ER",TAKIHYO="T AH K IY Y OW",INTERNATIONALISM="IH N T ER N AE SH AH N AH L IH Z AH M",WHOSOEVER="HH UW S OW EH V ER",RHINOPLASTY="R AY N OW P L AE S T IY",PUBLICIZE="P AH B L IH S AY Z",["EXPERIMENTALLY(2)"]="IH K S P EH R AH M EH N AH L IY",PELUSO="P EH L UW S OW",STEPANIAN="S T IH P EY N IY AH N",RODERICK="R AA D R IH K",CIRCLING="S ER K AH L IH NG",BAIKONUR="B AY K AH N AO R",KUDRNA="K AH D ER N AH",OBLIGED="AH B L AY JH D",BENGALIS="B EH NG G AA L IY Z",CUDDLED="K AH D AH L D",POTIONS="P OW SH AH N Z",MUDDLED="M AH D AH L D",NOTIONS="N OW SH AH N Z",["O'KESON"]="OW K IY S AH",HUDDLED="HH AH D AH L D",PUBLISHING="P AH B L IH SH IH NG",WYFFELS="W IH F AH L Z",LOTIONS="L OW SH AH N Z",MOTIONS="M OW SH AH N Z",SLAUGHTERINGS="S L AO T ER IH NG Z",USREY="AH S R IY",MURASE="M Y ER EY Z",["TECHNOLOGICALLY(2)"]="T EH K N AH L AA JH IH K L IY",OPTIONS="AA P SH AH N Z",LANCZ="L AE N CH",CABBIE="K AE B IY",BUNNEY="B AH N IY",EISENHAUER="AY Z AH N HH AW ER",INTERRUPTING="IH N T ER AH P T IH NG",RELOADABLE="R IY L OW D AH B AH L",["PAYERS'"]="P EY ER Z",DELINQUENCIES="D IH L IH NG K W AH N S IY Z",MALICIOUS="M AH L IH SH AH S",GOELLNER="G OW L N ER",LUNNEY="L AH N IY",["FAVORITE(2)"]="F EY V R AH T",OPPOSITES="AA P AH Z AH T S",SPECTOR="S P EH K T ER",BRUSTER="B R AH S T ER",KASPRZYK="K AA S P ER Z IH K",CRYDERMAN="K R AY D ER M AH N",MANZANO="M AA N Z AA N OW",["PENNZOIL'S"]="P EH N Z OY L Z",TELLEFSEN="T EH L IH F S AH N",HOFSTRA="HH AA F S T R AH",SCOLDING="S K OW L D IH NG",PUERTO_RICANS="P W EH R T OW R IY K AH N Z",MALUSO="M AH L UW S OW",SEIJI="S EY JH IY",MEIJI="M EY JH IY",SECRETLY="S IY K R IH T L IY",KEIJI="K IY JH IY",CONSERVATIONISTS="K AA N S ER V EY SH AH N IH S T S",BUDGETED="B AH JH IH T AH D",FLAWLESSLY="F L AO L AH S L IY",ERECTOR="IH R EH K T ER",HYPERPLASIA="HH AY P ER P L EY ZH AH",ESREY="EH S R IY",PAWNEES="P AO N IY Z",SCREENERS="S K R IY N ER Z",ROSEBROCK="R OW Z B R AH K",FINSIDER="F IH N S AY D ER",SUTHARD="S AH TH ER D",PIETER="P IY T ER",OVERHEATED="OW V ER HH IY T IH D",VANCLEVE="V AE N K L IY V",["GLISTENING(2)"]="G L IH S N IH NG",DIDOMENICO="D IH D OW M EH N IH K OW",PULPIT="P UH L P IH T",FINUNC="F IH N AH NG K",VEHICLE="V IY HH IH K AH L",SCOFFLAWS="S K AA F L AO Z",BUTTONVILLE="B AH T AH N V IH L",FLAMMIA="F L AE M IY AH",PONTIFF="P AA N T AH F",SUPPORTER="S AH P AO R T ER",VOGELPOHL="V AA G IH L P OW L",DRONEY="D R OW N IY",REPARTEE="R EH P ER T IY",UNBEATABLE="AH N B IY T AH B AH L",["TUCCI'S"]="T UW CH IY S",GOTTSCHALKS="G AA CH AH K S",MARTECH="M AA R T EH K",["ASHTEC'S"]="AE SH T EH K S",SCHEIRER="SH AY ER R",DELICIOUS="D IH L IH SH AH S",KICKLIGHTER="K IH K L AY T ER",VIERECK="V IH R IH K",REBIRTH="R IY B ER TH",GIDEON="G IH D IY AH N",BLACKMER="B L AE K M ER",REMARKETED="R IY M AA R K AH T IH D",LAMPHIER="L AE M F IY ER",DEPROGRAMMING="D IY P R OW G R AE M IH NG",MESSEGHERO="M EH S AH G EH R OW",HELDRETH="HH EH L D R IH TH",BRIDENBAUGH="B R IH D IH N B AW",REPROGRAMMING="R IY P R OW G R AE M IH NG",INFUSION="IH N F Y UW ZH AH N",BLATCHFORD="B L AE CH F ER D",GORSUCH="G AO R S AH CH",DULLE="D AH L",["GAMES'"]="G EY M Z",CORRIB="K AO R IH B",["JAMES'"]="JH EY M Z",FITZER="F IH T S ER",JUMANJI="JH UW M AA N JH IY",CUDGEL="K AH JH AH L",MATRIXES="M EY T R IH K S IH Z",GUDGEL="G AH JH AH L",["STORER'S"]="S T AO R ER Z",LADYBUG="L EY D IY B AH G",CLUBHOUSES="K L AH B HH AW S IH Z",SERV="S ER V",["SKINNER'S"]="S K IH N ER Z",ROSAS="R OW Z AH Z",DIPRIMA="D IH P R IY M AH",VOLNEY="V OW L N IY",["SCOTT'S"]="S K AA T S",GUSSIED="G AH S IY D",["VIEWER'S"]="V Y UW ER Z",ELSAS="EH L S AH Z",PATENTED="P AE T AH N T AH D",CRANESBILLS="K R EY N Z B IH L Z",DOLNEY="D OW L N IY",KINGMAKERS="K IH NG M EY K ER Z",BEDFELLOW="B EH D F EH L OW",CHOICES="CH OY S AH Z",ELINORE="EH L IY N AO R IY",["PREVENTABLE(2)"]="P R IY V EH N T AH B AH L",CONTINENT="K AA N T AH N AH N T",BRAZELL="B R AE Z AH L",TRIPOLI="T R IH P AH L IY",NYLEN="N IH L AH N",WALLEYE="W AO L AY",CONSCIENTIOUSLY="K AA N CH IY EH N CH AH S L IY",COFFEY="K AA F IY",DOXEY="D AA K S IY",ARLEN="AA R L AH N",RESPIRATORY="R EH S P ER AH T AO R IY",NIEMI="N IY M IY",["HAUSLER(2)"]="HH AW S L ER",KUNZE="K AH N Z",REANALYZED="R IY AE N AH L AY Z D",LIGHTED="L AY T AH D",CERDA="CH EH R D AH",RIGHTED="R AY T IH D",COUPONITE="K UW P AA N AY T",IMPLOSION="IH M P L OW ZH AH N",HILDRETH="HH IH L D R IH TH",MATTHAUSEN="M AE T HH AW Z AH N",SQUEAKED="S K W IY K T",SERDA="S EH R D AH",["SEVERAL(2)"]="S EH V ER AH L",BUTZER="B AH T S ER",ERIKSON="EH R IH K S AH N",PLYMPTON="P L IH M P T AH N",["SPINNER'S"]="S P IH N ER Z",KNEECAP="N IY K AE P",CATALOGUED="K AE T AH L AO G D",DEBILITATED="D AH B IH L AH T EY T IH D",ETHICS="EH TH IH K S",CHOREOGRAPHERS="K AO R IY AA G R AH F ER Z",["BELADUR'S"]="B EH L AH D UH R Z",HUFNAGEL="HH AH F N EY G AH L",CASELOAD="K EY S L OW D",PASSOVER="P AE S OW V ER",["LA-CARRE"]="L AA K AA R EY",GAUFMAN="G AO F M AH N",RECIPROCAL="R IH S IH P R AH K AH L",COSMOPULOS="K AO Z M AH P Y UW L OW S",TOLLE="T AA L",KAUFMAN="K AO F M AH N",JOSEPHINA="JH AA S IH F AY N AH",DORITOS="D AO R IY T OW Z",PINEDO="P IY N EY D OW",STEIDL="S T IY D AH L",TESSELATE="T EH S AH L EY T",GOLLE="G AA L",PRIOR="P R AY ER",DOLLE="D AA L",KOLLE="K AA L",BRADYCARDIA="B R AE D AH K AA R D IY AH",HOLLE="HH AA L",TELECTRONICS="T EH L AH K T R AA N IH K S",DAULTON="D AO L T AH N",MOLLE="M AA L",IMONDI="IH M OW N D IY",ROLLE="R OW L",["SURROUNDED(2)"]="S ER AW N D IH D",PAINTINGS="P EY N T IH NG Z",["KESLING(2)"]="K EH S L IH NG",["KOREAS(2)"]="K R IY AH Z",COLLE="K OW L",BOLLE="B AA L",IDOLIZE="AY D AH L AY Z",TILNEY="T IH L N IY",["RECIPE'S"]="R EH S AH P IY Z",HINZE="HH IH N Z",WILLMORE="W IH L M AO R",SALAMA="S AA L AA M AH",NARDA="N AA R D AH",WARDA="W AO R D AH",KEASLER="K IY Z L ER",BOUNTIFUL="B AW N T IH F AH L",GANGWER="G AE NG W ER",HALAMA="HH AA L AA M AH",DERELICTS="D EH R AH L IH K T S",FENTER="F EH N T ER",GENTER="JH EH N T ER",NOTICE="N OW T AH S",FILLMORE="F IH L M AO R",PERSPECTIVE="P ER S P EH K T IH V",MENTER="M EH N T ER",CARDA="K AA R D AH",["DENTISTS'(2)"]="D EH N IH S T S",SENTER="S EH N T ER",SCHLEMMER="SH L EH M ER",ELECTRA="IH L EH K T R AH",COLEN="K OW L AH N",DOLEN="D OW L AH N",GOLEN="G AA L AH N",HOLEN="HH OW L AH N",ENTICE="IH N T AY S",MOLEN="M OW L AH N",NOLEN="N AA L AH N",CENTER="S EH N T ER",["ANKARA'S"]="AE NG K ER AH Z",MANIFOLD="M AE N AH F OW L D",ROLEN="R OW L AH N",TOLEN="T OW L AH N",OESTERREICHISCHE="OW S T ER AY K IH SH IY",PICCIRILLO="P IY CH IH R IH L OW",ROTBLAT="R AA T B L AE T",BANUELOS="B AA N W EH L OW Z",HIJACK="HH AY JH AE K",MIRV="M ER V",HODDUR="HH AA D ER",DIFFUSES="D IH F Y UW Z AH Z",KUTZER="K AH T Z ER",["STEREOTYPE(2)"]="S T EH R IY OW T AY P",["BUNDESPOST'S"]="B UH N D IH S P OW S T S",STEFL="S T EH F AH L",SIMCOE="S IH M K OW",["ATTORNEYS'"]="AH T ER N IY Z",DEMAYO="D EY M EY OW",WADKINS="W AO D K IH N Z",["NOAA(2)"]="EH N OW EY EY",["PAINTER'S(2)"]="P EY N ER Z",PEMBER="P EH M B ER",FABRI="F AE B R IY",["AIRCRAFT'S"]="EH R K R AE F T S",SEMBER="S EH M B ER",MEMBER="M EH M B ER",["WELLCOME'S"]="W EH L K AH M Z",ZINTER="Z IH N T ER",["NEGLECTED(2)"]="N IH G L EH K T IH D",RENFROE="R EH N F R OW",CANZONERI="K AA N Z OW N EH R IY",GOGAN="G OW G AH N",MICROSCOPY="M AY K R AH S K AH P IY",DOGAN="D OW G AH N",KOGAN="K OW G AH N",HOGAN="HH OW G AA N",MOGAN="M OW G AH N",LOGAN="L OW G AH N",ROGAN="R OW G AH N",MOTZER="M OW T Z ER",["SOUTHEASTERN'S"]="S AW TH IY S T ER N Z",VILLE="V IH L",MINTER="M IH N T ER",KILLE="K IH L",MILLE="M IH L",LILLE="L IH L",BALDOR="B AO L D ER",PILLE="P IH L",BILLE="B AY L",OUTSPENDS="AW T S P EH N D Z",GILLE="G AY L",PERFUMING="P ER F Y UW M IH NG",HILLE="HH IH L",["FREDDY'S"]="F R EH D IY Z",["MACHISMO(2)"]="M AH K IH Z M OW",TREVIZO="T R EH V IY Z OW",DELILLO="D AH L IH L OW",MERV="M ER V",MELILLO="M EH L IH L OW",DUGAN="D AH G AH N",MELISENT="M EH L IH S AH N T",["BAZILE(2)"]="B AA Z IY L",ANTIBIOTICS="AE N T IY B IY AA T IH K S",NUGAN="N UW G AH N",RITACCO="R IY T AA K OW",REDEEMABLE="R IH D IY M AH B AH L",TREELESS="T R IY L AH S",HANDLED="HH AE N D AH L D",BENEVOLENT="B AH N EH V AH L AH N T",SNAPSHOTS="S N AE P SH AA T S",LEWEY="L UW IY",NEWEY="N UW IY",BAMBER="B AE M B ER",REWEY="R UW IY",UNSHACKLED="AH N SH AE K AH L D",PIGEONHOLE="P IH JH AH N HH OW L",KAMBER="K AE M B ER",DONZE="D AA N Z",WORKWEEKS="W ER K W IY K S",HEWEY="HH Y UW IY",CORPORATES="K AO R P ER AH T S",KAPNICK="K AE P N IH K",["JEFFERSON'S"]="JH EH F ER S AH N Z",WELLE="W EH L",OXALATES="AA K S AH L EY T S",YELLE="Y EH L",COMMONSENSE="K AA M AH N S EH N S",MISSIONARY="M IH SH AH N EH R IY",HUMMEL="HH AH M AH L",["GOODSON'S"]="G UH D S AH N Z",GUZZLERS="G AH Z AH L ER Z",CLEVERLY="K L EH V ER L IY",NONCONTROVERSIAL="N AA N K AA N T R AH V ER SH AH L",["CHALLENGER'S"]="CH AE L AH N JH ER Z",["GALEBS(2)"]="G EY L AH B Z",FORMOSO="F AO R M OW S OW",GERSTER="G ER S T ER",TERRONES="T EH R AH N Z",DELLE="D EH L",LOESCHER="L OW SH ER",BOMBER="B AA M ER",COMBER="K OW M ER",DRUGMAKERS="D R AH G M EY K ER Z",PALMINTERI="P AO L M IH N T EH R IY",BELLE="B EH L",DOBMEIER="D AA B M AY ER",CISTERCIAN="S IH S T ER SH AH N",NELLE="N EH L",MELLE="M EH L",HELLE="HH EH L",MCKELLER="M AH K EH L ER",CEZANNE="S EH Z AE N",STUBBLEFIELD="S T AH B AH L F IY L D",SELLE="S EH L",CABRANES="K AH B R EY N Z",SOMBER="S AA M B ER",PELLE="P EH L",ORGAN="AO R G AH N",VASSAR="V AE S ER",STOPPERS="S T AA P ER Z",BESETTING="B IH S EH T IH NG",BIGAN="B IH G AH N",NASSAR="N AE S ER",MASSAR="M AE S ER",MCCONN="M AH K AA N",KASSAR="K AE S ER",DOESCHER="D OW SH ER",EHLEN="EH L AH N",PIGAN="P IH G AH N",CASSAR="K AE S ER",JAFFEY="JH AE F IY",LAFFEY="L AE F IY",AYLWARD="EY L W ER D",AHLEN="AH L EY N",GEOMETRY="JH IY AA M AH T R IY",ENROUTE="EH N R UW T",EMOTICON="AH M OW T AH K AA N",WILEN="W AY L AH N",KILEN="K IH L AH N",HARMATA="HH AA R M AA T AH",POSHARD="P AA SH ER D",BIONDI="B IY AA N D IY",FEAZELL="F IY Z AH L",["BREWER'S"]="B R UW ER Z",["GRIER'S(2)"]="G R IY R Z",ORVIS="AO R V IH S",HARTSOCK="HH AA R T S AH K",KRETCHMER="K R EH CH M ER",EBLEN="EH B AH L AH N",ADAPTIVE="AH D AE P T IH V",ASHTRAYS="AE SH T R EY Z",CAUDELL="K OW D EH L",CAFFEY="K AE F IY",["ASTOR'S"]="AE S T ER Z",GAFFEY="G AE F IY",HAFFEY="HH AE F IY",DENTZER="D EH N T Z ER",JOERGER="Y ER G ER",CALLE="K EY L",BALLE="B EY L",GALLE="G EY L",VISIONS="V IH ZH AH N Z",FETZER="F EH T S ER",HETZER="HH EH T Z ER",MALLE="M AE L",METZER="M EH T S ER",VENKATESH="V EH N K AA T EH SH",SALLE="S EY L",BETZER="B EH T Z ER",KENTUCKY="K AH N T AH K IY",MENTZER="M EH N T Z ER",MATAS="M AA T AH Z",ADVANTAGES="AE D V AE N T IH JH IH Z",OBSESSED="AH B S EH S T",MONTER="M AA N T ER",THROTTLES="TH R AA T AH L Z",ASCERTAINING="AE S ER T EY N IH NG",["INTERBREW'S"]="IH N T ER B R UW Z",VANDERLINDE="V AE N D ER L IH N D",FORSTER="F AO R S T ER",ALTICE="AA L T IH S",HEFTI="HH EH F T IY",HEMOLYTIC="HH IY M AH L IH T IH K",KIMBER="K IH M B ER",LIMBER="L IH M B ER",SANITIZE="S AE N IH T AY Z",JACHIM="JH AE K IH M",BUSINESSES="B IH Z N AH S AH Z",ATTALLA="AH T AE L AH",FASCIANO="F AA S CH IY AA N OW",CASCIANO="K AA S CH IY AA N OW",DATAS="D EY T AH Z",MCDANIEL="M AH K D AE N Y AH L",BAUSMAN="B AW S M AH N",["PALM-SPRINGS"]="P AA M S P R IH NG Z",EXBROKER="EH K S B R OW K ER",HAUSMAN="HH AW S M AH N",GAUSMAN="G AW S M AH N",BLOUNT="B L AW N T",WAITERS="W EY T ER Z",COMMANDEER="K AA M AH N D IH R",YOUNGERMAN="Y AH NG ER M AH N",["INTERMINGLING(2)"]="IH N T ER M IH NG G L IH NG",ALZENE="AA L Z IY N",STRIPTEASE="S T R IH P T IY Z",GLASSMAKER="G L AE S M EY K ER",CONGRESSWOMAN="K AA NG G R AH S W UH M AH N",GRZESKOWIAK="G ER Z IH S K AW IY AE K",MASAYA="M AA S AA Y AH",WINTZER="W IH N T S ER",GANTENBEIN="G AE N T IH N B AY N",STANGL="S T AE NG G AH L",MEASURABLY="M EH ZH ER AH B L IY",CICCARELLO="CH IY K ER EH L OW",GLOBULINS="G L AA B Y AH L IH N Z",CONTACT="K AA N T AE K T",CAMBRIDGEPORT="K EY M B R IH JH P AO R T",REROUTE="R IY R UW T",KATZER="K AE T S ER",GRANAT="G R AE N AH T",STACHOWIAK="S T AH CH AW IY AE K",BATZER="B EY T Z ER",SAVALAS="S AH V AA L AH S",["MOTOR'S"]="M OW T ER Z",SHOPLIFTER="SH AA P L IH F T ER",CORDA="K AO R D AH",BORDA="B AO R D AH",LUMBER="L AH M B ER",NETZER="N EH T Z ER",KORDA="K AO R D AH",SETZER="S EH T Z ER",RETZER="R EH T Z ER",NUMBER="N AH M B ER",GORDA="G AO R D AH",DUMBER="D AH M ER",RETAKING="R IY T EY K IH NG",CUMBER="K AH M B ER",HUMBER="HH AH M B ER",KEYSTROKES="K IY S T R OW K S",["ARTICULATE(2)"]="AA R T IH K Y AH L AH T",CLARITA="K L AA R IY T AH",PALEN="P AE L AH N",ACRIMONIOUS="AE K R AH M OW N IY AH S",WALEN="W EY L AH N",PARMENTER="P AA R M AH N T ER",ADRDA="EY D ER D AH",LAROWE="L AE R AW",["IRONWOOD'S"]="AY ER N W UH D Z",OLMEDO="OW L M EY D OW",DESCHENE="D EH SH IY N",OCTUPLETS="AA K T AH P L AH T S",HERRIMAN="HH EH R IH M AH N",GALEN="G EY L AH N",DALEN="D AE L AH N",KALEN="K EY L AH N",HALEN="HH EY L EH N",JUDKINS="JH AH D K IH N Z",HUDKINS="HH AH D K IH N Z",["IMMIGRANTS'"]="IH M IH G R AH N T S",KOTAS="K OW T AH Z",BUESCHER="B Y UW SH ER",DRESCHER="D R EH SH ER",ADDRESSES="AE D R EH S IH Z",PULKRABEK="P AH L K R AH B IH K",["PACIFIC'S"]="P AH S IH F IH K S",RIGGINGS="R IH G IH NG Z",KWIECINSKI="K W IY CH IH N S K IY",DUCLOS="D AH K L OW Z",ADAPTING="AH D AE P T IH NG",GUERRETTE="G ER EH T",SOLEMNLY="S AO L AH M L IY",KNOTEK="N OW T IH K",JAQUESS="Y AA K W IH S",HANSCOM="HH AE N S K AH M",MASCIA="M AA S CH AH",BRUNETTA="B R UW N EH T AH",PATZER="P EY T Z ER",TITANATE="T AY T AH N EY T",MCDONALDS="M AH K D AA N AH L D Z",["PRESENTED(3)"]="P R IY Z EH N AH D",HULEN="HH AH L AH N",["PAGLIUCA'S"]="P AE G L IY UW K AH Z",BULEN="B AH L AH N",AZAROW="AE Z ER OW",RATCLIFFE="R AE T K L IH F",STRIKING="S T R AY K IH NG",FERMATA="F EH R M AA T AA",["BEGINNER'S"]="B IH G IH N ER Z",BOUNDLESS="B AW N D L AH S",CATTANEO="K AA T AA N IY OW",GALASIE="G AE L AH S IY",ABSTRACTED="AE B S T R AE K T IH D",OXIDYNE="AA K S IH D AY N",FLANNEL="F L AE N AH L",MOCCIO="M OW CH IY OW",WLODARCZYK="W AH L AA D ER CH IH K",REMINGTONS="R EH M IH NG T AH N Z",SEMMEL="S EH M AH L",LIVERY="L IH V ER IY",SIUDA="S IY UW D AH",ROUBAL="R UW B AE L",CROSSFIRE="K R AO S F AY R",["BABA(2)"]="B AA B AH",EXPLOSION="IH K S P L OW ZH AH N",PICKINS="P IH K IH N Z",CARESSED="K ER EH S T",["KESSLER'S"]="K EH S L ER Z",HUBBART="HH AH B ER T",["CHIRAC'S"]="SH IH R AE K S",SYSTEMAT="S IH S T AH M AE T",QUICKLY="K W IH K L IY",INCENSE="IH N S EH N S",KOSKI="K AW S K IY",UPRISE="AH P R AY Z",GILLIAND="G IH L IY AH N D",BALLISTICS="B AH L IH S T IH K S",GREENLEAF="G R IY N L IY F",MINISTRATIONS="M IH N AH S T R EY SH AH N Z",PANFULS="P AE N F AH L Z",GAMMAGE="G AE M IH JH",JOKERST="JH AA K ER S T",PRICKLY="P R IH K L IY",HANGARTNER="HH AE NG G AA R T N ER",CONSTRUCTIONIST="K AH N S T R AH K SH AH N IH S T",CONTRASTS="K AA N T R AE S T S",GIAMBRA="JH AA M B R AH",LUECKE="L UW K",MUECKE="M UW K",REGIER="R IY G IY ER",ODELIA="OW D EH L IY AH",BUNTROCK="B AH N T R AA K",ILLUMINATOR="IH L UW M AH N EY T ER",MCCARN="M AH K AA R N",SHUDA="SH UW D AH",JANICE="JH AE N AH S",DORISE="D AO R AY Z",POVEROMO="P OW V EH R OW M OW",SHANT="SH AA N T",INDOLENT="IH N D AH L AH N T",HAGEMEISTER="HH AE G IH M AY S T ER",["INDIAN'S"]="IH N D IY AH N Z",CHANNEL="CH AE N AH L",RAMMEL="R AE M AH L",GEOTEK="G IY OW T EH K",HARMONIOUS="HH AA R M OW N IY AH S",FRONTZ="F R AA N T S",GIANT="JH AY AH N T",POWERPCS="P AW ER P IY S IY Z",GAMMEL="G AE M AH L",GRATTAN="G R AE T AH N",FLOREZ="F L AO R EH Z",ROWBOTHAM="R OW B AH TH AE M",OFELIA="OW F EY L IY AH",["DELIBERATES(2)"]="D IH L IH B R EY T S",PIONTKOWSKI="P IY OW N T K AO F S K IY",VARMINT="V AA R M IH N T",INCREDIBLE="IH N K R EH D AH B AH L",RICCIO="R IY CH IY OW",ALKEMA="AE L K IH M AH",MICCIO="M IY CH IY OW",IGLOO="IH G L UW",BOLIVIAN="B OW L IH V IY AH N",EPISCOPAL="IH P IH S K AH P AH L",LANPHIER="L AE N F IH R",PEANUTS="P IY N AH T S",REASOR="R IY S ER",CAISSON="K EY S AH N",LUCKENBACH="L AH K IH N B AA K",ONKEN="AA NG K AH N",SABAUDIA="S AH B AO D IY AH",WIANT="W AY AH N T",["STRETCHER-BEARER"]="S T R EH CH ER B EH R ER",STANT="S T AE N T",RIECKE="R IY K",HAYMARKET="HH EY M AA R K IH T",["ARROWHEADS(2)"]="EH R OW HH EH D Z",DECENCY="D IY S AH N S IY",DISENCHANTMENT="D IH S IH N CH AE N T M AH N T",OUTDISTANCE="AW T D IH S T AH N S",SOUSAPHONE="S UW Z AH F OW N",QUANT="K W AE N T",KATEY="K EY T IY",TRANSFERENCE="T R AE N S F ER AH N S",MATEY="M EY T IY",PATEY="P EY T IY",EXTRADITING="EH K S T R AH D AY T IH NG",KILCULLEN="K IH L K AH L AH N",AVANT="AH V AA N T",GOECKE="G OW K",COMPLICATIONS="K AA M P L AH K EY SH AH N Z",OBELIA="OW B EH L IY AH",["PRINTER'S(2)"]="P R IH N ER Z",BATEY="B EY T IY",LESSENING="L EH S AH N IH NG",LAWYERED="L AO Y ER D",SNAKELIKE="S N EY K L AY K",MCCARVER="M AH K AA R V ER",LANYON="L AE N Y AH N",["PLAISTED(2)"]="P L EY S T IH D",KVANT="K V AA N T",EMLYNNE="IH M L AY N",ROHRBACHER="R AO R B AA K ER",WATERY="W AO T ER IY",HYDSTRA="HH AY D S T R AH",RIOTERS="R AY AH T ER Z",CANYON="K AE N Y AH N",SLAGEL="S L AE G AH L",["LIBERTY'S"]="L IH B ER T IY Z",DIVINING="D AH V AY N IH NG",MANDATES="M AE N D EY T S",HOUSMAN="HH AW S M AH N",MCFADDIN="M AH K F AE D AH N",["MINES'"]="M AY N Z",LYMPHOMA="L IH M F OW M AH",["REHABILITATIONS(2)"]="R IY AH B IH L AH T EY SH AH N Z",RZEPKA="ER Z EH P K AH",["MARGARET'S"]="M AA R G ER IH T S",EATERY="IY T ER IY",CLONTZ="K L AA N T S",LASKI="L AA S K IY",KLEZMATICS="K L EH Z M AE T IH K S",NUCCIO="N UW CH IY OW",MUCCIO="M UW CH IY OW",KOKEN="K OW K AH N",KLONTZ="K L AA N T S",DELEONARDIS="D EH L IY AH N AA R D IH S",LOKEN="L OW K AH N",KOSANKE="K AA S AH NG K",TOKEN="T OW K AH N",PUCCIO="P UW CH IY OW",["BURNETT'S"]="B ER N EH T S",ACCOMMODATION="AH K AA M AH D EY SH AH N",KORYAGIN="K AO R Y AA G IH N",PAULLIN="P AO L IH N",DESHOTELS="D EH SH AH T AH L Z",WESCOAT="W EH S K OW T",CATHERINA="K AA TH ER IY N AH",JETSONS="JH EH T S AH N Z",PETEY="P IY T IY",JACINTHA="JH AH S IH N TH AH",["WHITEHALL'S"]="W AY T HH AO L Z",POLITICIAN="P AA L AH T IH SH AH N",BRANT="B R AE N T",YIELDING="Y IY L D IH NG",REORIENT="R IY AO R IY EH N T",BOGEYED="B OW G IY D",CONTUSION="K AH N T UW ZH AH N",SURPRISINGLY="S ER P R AY Z IH NG L IY",INTERJECTED="IH N T ER JH EH K T IH D",TRANT="T R AE N T",["MICROSOFT'S"]="M AY K R OW S AO F T S",STRENGTHENED="S T R EH NG TH AH N D",FIELDING="F IY L D IH NG",BORDELLO="B AO R D EH L OW",HUIZENGA="HH IH Z EY NG G AH",REGARD="R AH G AA R D",KENYON="K EH N Y AH N",PELAGREENY="P EH L AH G R IY N IY",BOARDROOMS="B AO R D R UW M Z",HUSSAR="HH AH S ER",["ROSEN'S"]="R OW Z AH N Z",CLARIDGES="K L EH R IH JH IH Z",PATRIARCHATE="P EY T R IY AA R K AH T",CORNICK="K AO R N IH K",OPPORTUNITY="AA P ER T UW N AH T IY",GORNICK="G AO R N IH K",LUDLOW="L AH D L OW",HORNICK="HH AO R N IH K",["STOCKMAN'S"]="S T AA K M AE N Z",HUDLOW="HH AH D L OW",NEEDIEST="N IY D IY IH S T",NOBLEMAN="N OW B AH L M AH N",JELEN="JH EH L AH N",HELEN="HH EH L AH N",KRUMREY="K R AH M R IY",BELEN="B EH L AH N",CHRISTNER="K R IH S T N ER",PETERY="P IY T ER IY",HIGHSCHOOLS="HH AY S K UW L Z",["DOOR'S"]="D AO R Z",COONTZ="K UW N T S",PAPPALARDO="P AA P AA L AA R D OW",SWEATPANTS="S W EH T P AE N T S",RIOTER="R AY AH T ER",["POOR'S"]="P UW R Z",KOONTZ="K UW N T S",THEODOROU="TH IY AH D ER UW",["CEDRAS'(2)"]="S EY D R AH S",GERRYMANDER="JH EH R IY M AE N D ER",["YOOR'S"]="Y UW R Z",STRAIGHTFORWARDLY="S T R EY T F AO R W ER D L IY",COLLEGIANS="K AH L IY JH AH N Z",COOTER="K UW T ER",HELDOR="HH EH L D ER",JELLISON="JH EH L IH S AH N",FOOTER="F UH T ER",DEMAS="D IY M AH S",HOOTER="HH UW T ER",["O'DONNELL"]="OW D AA N AH L",KELLISON="K EH L IH S AH N",ROMACK="R AA M AH K",KANGAS="K AE NG G AH Z",DELLAROCCO="D EH L ER OW K OW",HEALTHWORKS="HH EH L TH W ER K S",["GAUBERT'S(2)"]="G AW B EH R T S",CONVENED="K AH N V IY N D",NONPUBLIC="N AA N P AH B L IH K",["CHERNOBYL'S"]="CH ER N OW B AH L Z",BEATRIX="B IY T R IH K S",["ENTERTAINMENT'S"]="EH N T ER T EY N M AH N T S",LETCHWORTH="L EH CH W ER TH",SUTCLIFFE="S AH T K L IH F",DEFENDED="D IH F EH N D AH D",["LAKOTAS'"]="L AH K OW T AH Z",["JANUARY'S"]="JH AE N Y UW EH R IY Z",ROSARIES="R OW Z ER IY Z",BURMANS="B ER M AH N Z",OKUDA="OW K UW D AH",PLOTTS="P L AA T S",OVERVALUE="OW V ER V AE L Y UW",NOBORU="N OW B AO R UW",PAVLIS="P AE V L IH S",TERKHORN="T ER K AO R N",HELGESON="HH EH L G IH S AH N",CHEVERLY="CH EH V ER L IY",CROTTS="K R AA T S",UZMACK="UW Z M AE K",TRUDA="T R UW D AH",["FRAUM(2)"]="F R AA M",ALPACA="AE L P AE K AH",["ELECTRIC'S"]="IH L EH K T R IH K S",WAKEN="W EY K AH N",TAKEN="T EY K AH N",BOMBMAKING="B AA M M EY K IH NG",TILLISON="T IH L IH S AH N",WILLISON="W IH L IH S AH N",MIRRORED="M IH R ER D",MCCLARAN="M AH K L AE R AH N",["BHATIA(2)"]="B AA T Y AH",MINUTE="M IH N AH T",GALVANIZES="G AE L V AH N AY Z AH Z",SWIMSUIT="S W IH M S UW T",GILLISON="G IH L IH S AH N",["SENSITIVE(2)"]="S EH N S IH T IH V",SLUICE="S L UW S",OLDFASHIONED="OW L D F AE SH AH N D",CULTIVATION="K AH L T IH V EY SH AH N",PRINTINGS="P R IH N T IH NG Z",PLAGIOCLASE="P L EY JH IY AH K L EY S",SEEDORF="S IY D AO R F",["MERITS(2)"]="M EH R IH T S",SKIPWORTH="S K IH P W ER TH",GATRELL="G AE T R AH L",SOOTER="S UH T ER",ROOTER="R UW T ER",HEARTACHE="HH AA R T EY K",GUINAROU="G W IH N AA R OW",LOOTER="L UW T ER",BROUSSET="B R UW S EH T",GUILLEMETTE="G IH L AH M EH T",DEKLE="D EH K AH L",GUGGENHEIM="G UW G AH N HH AY M",ACCEPTABILITY="AH K S EH P T AH B IH L AH T IY",SUFFUSES="S AH F Y UW Z IH Z",["DERIVATIVE(2)"]="D ER IH V IH T IH V",SHONTZ="SH AA N T S",["ADVANTAGES(4)"]="AH D V AE N IH JH IH Z",OVERACKER="OW V ER AH K ER",HOLADAY="HH OW L AH D EY",SUSKI="S AH S K IY",HUNTER="HH AH N T ER",DESICCATED="D EH S AH K EY T AH D",MUNTER="M AH N T ER",GATHERINGS="G AE DH ER IH NG Z",GREENHUT="G R IY N HH AH T",PUNTER="P AH N T ER",FLOREN="F L AO R AH N",ALMAS="AE L M AH Z",SUNTER="S AH N T ER",STREIT="S T R AY T",["FORBID(2)"]="F AO B IH D",KEROSENE="K EH R AH S IY N",PETRUZZELLI="P EH T R UW T S EH L IY",NEWSLETTER="N UW Z L EH T ER",KEMRON="K EH M R AH N",WALLPAPERS="W AO L P EY P ER Z",["HUGHIE(2)"]="Y UW IY",BEHALF="B IH HH AE F",LUKEN="L UW K AH N",ZIRCONIUM="Z ER K OW N IY AH M",LEINGANG="L AY NG G AH NG",JEFFEY="JH EH F IY",GREENWALDS="G R IY N W AO L D Z",RIFFEY="R IH F IY",LASITER="L AE S AY T ER",RANCHERS="R AE N CH ER Z",HURLBUT="HH ER L B AH T",BEAUBIEN="B OW B Y EH N",DREAMWORKS="D R IY M W ER K S",HABERDASHERY="HH AE B ER D AE SH ER IY",OVERPASS="OW V ER P AE S",STOTTS="S T AA T S",RIGHTEOUS="R AY CH AH S",REDOLENT="R EH D AH L AH N T",BINOMIAL="B AY N OW M IY AH L",IMPACTING="IH M P AE K T IH NG",["BLANCHARD'S"]="B L AE N CH ER D Z",LICKTEIG="L IH K T AY G",BOGARD="B AA G ER D",LICENSE="L AY S AH N S",["WIENERSCHNITZEL'S(2)"]="V IY N ER SH N IH T S AH L Z",DROPPERS="D R AA P ER Z",KINGSUN="K IH NG S AH N",REGARDED="R AH G AA R D AH D",GAFFES="G AE F S",RAFSANJANI="R AE F S AH N JH AA N IY",KILDEE="K IH L D IY",BELONGED="B IH L AO NG D",MATAYA="M AA T AA Y AH",ROULHAC="R UW L HH AH K",["ROUNDS(2)"]="R AW N Z",["POUNDS(2)"]="P AW N Z",LOOTERS="L UW T ER Z",HOOTERS="HH UW T ER Z",HUCKINS="HH AH K IH N Z",["SOUNDS(2)"]="S AW N Z",["KOTSONIS(2)"]="K OW T S OW N AH S",WALLISON="W AO L IH S AH N",ALCOVE="AE L K OW V",DISHWASHERS="D IH SH W AA SH ER Z",BICYCLE="B AY S IH K AH L",UNRECEPTIVE="AH N R IH S EH P T IH V",KARSTADT="K AA R S T AE T",SHEATHBILLS="SH IY TH B IH L Z",DAMAS="D AA M AH Z",ALIHAN="AE L IH HH AE N",["PIERACCINI(2)"]="P Y EH R AH CH IY N IY",MAMAS="M AA M AH Z",MALLISON="M AE L IH S AH N",LAMAS="L AA M AH Z",DAMRON="D AE M R AH N",HAMAS="HH AA M AA S",DISCONTENTEDNESS="D IH S K AH N T EH N T IH D N AH S",DEJARNETTE="D EH ZH AA R N EH T",PARLIAMENTARIANS="P AA R L AH M EH N T EH R IY AH N Z",HORSEPLAY="HH AO R S P L EY",CAPITAL="K AE P AH T AH L",SUPERSEDES="S UW P ER S IY D Z",CALLISON="K AE L IH S AH N",JAMESON="JH EY M S AH N",["SERVANTS'"]="S ER V AH N T S",DISSONANCE="D IH S AH N AH N S",MANGAS="M AE NG G AH Z",HAIRDRESSER="HH EH R D R EH S ER",RECOUPED="R IH K UW P T",WHOPPERS="W AA P ER Z",CINNAMON="S IH N AH M AH N",UNSURPRISING="AH N S ER P R AY Z IH NG",SHOPPERS="SH AA P ER Z",GONSALES="G OW N S EY L Z",["BUENOS-AIRES(4)"]="B W EY N AH S EH R",RAETHER="R EH DH ER",HARRIMAN="HH EH R IH M AH N",["ZEROES(2)"]="Z IY R OW Z",HARTSOOK="HH AA R T S UH K",["AMERICAS'"]="AH M EH R IH K AH Z",PELICANS="P EH L IH K AH N Z",BRAUNSTEIN="B R AO N S T IY N",["HEROES(2)"]="HH IY R OW Z",THOREN="TH AO R AH N",INSTITUTIONS="IH N S T IH T UW SH AH N Z",["SUPRISINGLY(2)"]="S ER P R AY Z IH NG L IY",ROOTERS="R UW T ER Z",STEPS="S T EH P S",WORDELL="W ER D AH L",["ISOLATIONISTS(2)"]="AY S AH L EY SH AH N IH S",BURKE="B ER K",ADAPTAPLEX="AH D AE P T AH P L EH K S",REPACK="R IY P AE K",REDEVELOPMENT="R IY D IH V EH L AH P M AH N T",MCCANDLESS="M AH K AE N D L AH S",SCHREIBER="SH R AY B ER",CORDELL="K AO R D EH L",["MASTERPIECES(2)"]="M AE S T ER P IY S IH Z",ANDREAS="AA N D R EY AH S",BINNEY="B IH N IY",BLATHER="B L AE DH ER",FINNEY="F IH N IY",HODGES="HH AA JH IH Z",MORPHS="M AO R F S",MOBILER="M OW B IH L ER",["LAFLER(2)"]="L EY F L ER",DUFOUR="D AH F UH R",COUNTEROFFENSIVES="K AW N T ER AO F EH N S IH V Z",ARAFAT="EH R AH F AE T",AGRARIAN="AH G R EH R IY AH N",SHIPMATE="SH IH P M EY T",ARBITRARY="AA R B AH T R EH R IY",FEENY="F IY N IY",DUPLICATIVE="D UW P L IH K AH T IH V",UNWISE="AH N W AY Z",KEENY="K IY N IY",HEFFEL="HH EH F AH L",WEENY="W IY N IY",["HEMIPLEGIA(2)"]="HH EH M AH P L IY JH Y AH",LEGAN="L EH G AH N",MOSQUITOES="M AH S K IY T OW Z",MEGAN="M EY G AH N",LOPPNOW="L AA P N AW",["HUMBLER(2)"]="HH AH M B L ER",TEENY="T IY N IY",GERIATRICIAN="JH EH R IY AH T R IH SH AH N",BONNEY="B AA N IY",MANASSAS="M AH N AA S AH S",MANATEE="M AE N AH T IY",KENNEBUNKPORT="K EH N AH B AH NG K P AO R T",["JAMMU'S"]="JH AH M UW Z",MICROPROSE="M AY K R OW P R OW Z",LEFFEL="L EH F AH L",EXTRAPOLATING="EH K S T R AE P AH L EY T IH NG",REASSERTING="R IY AH S ER T IH NG",ALARIC="AE L ER IH K",CORTENS="K AO R T EH N Z",PROLIFERATED="P R AH L IH F ER EY T IH D",OVERPAID="OW V ER P EY D",MARINATE="M EH R AH N EY T",SCHROECK="SH R OW K",WAITER="W EY T ER",FORMING="F AO R M IH NG",["OPTICAL'S"]="AA P T IH K AH L Z",ENNEN="EH N AH N",NORMING="N AO R M IH NG",FOTIS="F OW T IH S",BERRYLIKE="B EH R IY L AY K",ANNEN="AE N AH N",BUCHENWALD="B Y UW K EH N W AA L D",NOTIS="N OW T IH S",CRABILL="K R AE B AH L",MODROW="M AA D R OW",PETERSEN="P IY T ER S AH N",ONNEN="AA N AH N",KRINGS="K R IH NG Z",PADLOCKED="P AE D L AA K T",PERSECUTOR="P ER S AH K Y UW T ER",AMHERST="AE M ER S T",PRANKSTER="P R AE NG K S T ER",["FORSYTHIAS(2)"]="F AO R S IH DH IY AH Z",SZCZERBA="SH ER B AH",CARONNA="K ER AA N AH",GAITER="G EY T ER",TOYOO="T OY UW",RONEN="R OW N AH N",INADVERTENCE="IH N AH D V ER T AH N S",FLAMED="F L EY M D",KREPS="K R EH P S",FIRMING="F ER M IH NG",PFIESTER="F AY S T ER",SAMPSELL="S AE M P S AH L",GOINGS="G OW IH NG Z",["DISMANTLING(3)"]="D IH S M AE N T L IH NG",["PREDETERMINE(2)"]="P R IY D IY T ER M AH N",NITZE="N IH T S IY",BRINGS="B R IH NG Z",FEATHER="F EH DH ER",FISHBAINE="F IH SH B EY N",HEATHER="HH EH DH ER",RICHARDSONSMITH="R IH CH ER D S AH N S M IH TH",PROTEGES="P R OW T IH ZH EY Z",KIENITZ="K IY N IH T S",TESTICLE="T EH S T IH K AH L",GROUNDED="G R AW N D IH D",WEATHER="W EH DH ER",MCMEANS="M AH K M IY N Z",MISHAWAKA="M IH SH AH W AO K AH",WOHLSTETTER="W OW L S T EH T ER",POSTTRAUMATIC="P OW S T T R AO M AE T IH K",RAFFEL="R AE F AH L",DOINGS="D UW IH NG Z",HANDLOOM="HH AE N D L UW M",BAKERY="B EY K ER IY",ROAMED="R OW M D",BREMMER="B R EH M ER",LEVANGIE="L EH V AH NG IY",BEMUSED="B IH M Y UW Z D",["CATHY'S"]="K AE TH IY Z",FORAGING="F AO R IH JH IH NG",SAELENS="S EH L AH N Z",["KATHY'S"]="K AE TH IY Z",FACSIMILES="F AE K S IH M AH L IY Z",ELXSI="EH L K S IY",HARRIGER="HH AE R IH G ER",REFUGIO="R AH F Y UW JH IY OW",ADVENTIST="AE D V EH N T IH S T",PRATHER="P R AE DH ER",["VIOLA(2)"]="V IY OW L AH",GAINEY="G EY N IY",CHADLI="CH AE D L IY",SCOVILL="S K AA V AH L",COMPENSATING="K AA M P AH N S EY T IH NG",SLOVO="S L OW V OW",BARRIGER="B AE R IH G ER",CARRIGER="K AE R IH JH ER",EUROSID="Y UW R AH S IH D",MAROTTE="M ER AO T",OLOVO="AH L AO V OW",AWOKE="AH W OW K",KONEN="K AA N AH N",HAPKE="HH EY P K IY",NEWHARD="N UW HH AA R D",MESSANA="M EH S AE N AH",HAIDEE="HH EY D IY",DAPONTE="D AA P OW N T EY",REMERCI="R IH M ER S IY",MATADOR="M AE T AH D AO R",EASTERNERS="IY S T ER N ER Z",ECHARD="EH CH ER D",["EMOTIONAL(2)"]="IY M OW SH AH N AH L",HOLLEMAN="HH OW L M AH N",JITTERBUGGING="JH IH T ER B AH G IH NG",LUTZE="L AH T Z",TENNEY="T EH N IY",SHAMED="SH EY M D",PENNEY="P EH N IY",BAPTIZE="B AE P T AY Z",JENNEY="JH EH N IY",ELLERBY="EH L ER B IY",ROLLISON="R AA L IH S AH N",SZOKE="SH OW K",MOLLISON="M AA L IH S AH N",LANTHIER="L AE N TH IY ER",["GRIFFIN'S"]="G R IH F IH N Z",SORICE="S AO R IH S",COLLISON="K AA L IH S AH N",MATIS="M AA T IH S",OATIS="OW T IH S",LONDONER="L AH N D AH N ER",BATHTUBS="B AE TH T AH B Z",ALPHABETICAL="AE L F AH B EH T IH K AH L",["HINDSIGHT(2)"]="HH AY N S AY T",MIYAHARA="M IY Y AA HH AA R AH",SUBVOLCANIC="S AH B V AA L K AE N IH K",DELMONACO="D EH L M OW N AA K OW",SKIDGEL="S K IH JH AH L",SABATKA="S AA B AA T K AH",HOTZE="HH OW T Z",MCGRATH="M AH G R AE TH",BYLAWS="B AY L AO Z",LOTZE="L OW T Z",EMBARGOES="EH M B AA R G OW Z",["BRIDGET'S"]="B R IH JH AH T S",DORICE="D AO R IH S",["CROMWELL'S"]="K R AA M W IH L Z",ASEAN="AH Z IY AH N",WARLORD="W AO R L AO R D",MERTENS="M ER T AH N Z",["SHENG-FEN"]="SH EH NG F EH N",HENNEY="HH EH N IY",THICKET="TH IH K IH T",BENNEY="B EH N IY",HANNAY="HH AE N EY",FLEMMER="F L EH M ER",PROOFREADING="P R UW F R IY D IH NG",INVADES="IH N V EY D Z",BEAMED="B IY M D",CLEMMER="K L EH M ER",DAUGHTERS="D AO T ER Z",AIKEN="EY K IH N",CREAN="K R IY N",FREAN="F R IY N",TEAMED="T IY M D",BREAN="B R IY N",FERTILIZING="F ER T AH L AY Z IH NG",["NEWORLD(2)"]="N UW ER L D",PAPKE="P EY P K",SWINGS="S W IH NG Z",REENACTMENTS="R IY IH N AE K T M AH N T S",EIFFEL="AY F AH L",PFEFFERLE="F EH F ER AH L",CORRUPTIONS="K ER AH P SH AH N Z",EVOKE="IH V OW K",TINNEY="T IH N IY",WINNEY="W IH N IY",METIS="M EH T IH S",EWINGS="Y UW IH NG Z",ADIPOSE="AE D AH P OW S",GEHLHAUSEN="G EH L HH AW Z AH N",LINNEY="L IH N IY",MODERNE="M OW D EH R N",SLATHER="S L AE DH ER",FARMING="F AA R M IH NG",["RITZENTHALER(2)"]="R IH T S IH N TH AA L ER",HARMING="HH AA R M IH NG",ALLEMAND="AE L IH M AH N D",LAZARUS="L AE Z ER AH S",ALEGRETT="AE L AH G R AH T",SCHABACKER="SH AA B AE K ER",["CHIQUITA(3)"]="CH IH K IY T AH",STEALTHIER="S T EH L TH IY ER",ENRAGING="EH N R EY JH IH NG",CHEETAH="CH IY T AH",REXENE="R EH K S IY N",RIFFEL="R IH F AH L",IMMUNETECH="IH M Y UW N T EH K",VASSILIOU="V AE S IH L IY UW",SMATHER="S M AE DH ER",UNSPECTACULAR="AH N S P EH K T AE K Y AH L ER",POACHERS="P OW CH ER Z",["PAPERS'"]="P EY P ER Z",ALLIGATOR="AE L AH G EY T ER",CHILIS="CH IH L IY Z",YESKE="Y EH S K",["LUFTHANSA'S"]="L AH F T AE N Z AH Z",ALTIZER="AE L T AY Z ER",KINNICK="K IH N IH K",FINNICK="F IH N IH K",EMCO="EH M K OW",CORVO="K AO R V OW",LINEN="L IH N AH N",DISNEYWORLD="D IH Z N IY W ER L D",DODDERING="D AA D ER IH NG",["ROTH'S"]="R AA TH S",PRESCHOOLER="P R IY S K UW L ER",VINNICK="V IH N IH K",BESKE="B EH S K",["INTELLECT(2)"]="IH N AH L EH K T",MINNICK="M IH N IH K",PINNICK="P IH N IH K",["KISLING(2)"]="K IH S L IH NG",KINYON="K IH N Y AH N",TESKE="T EH S K",RESKE="R EH S K",LOLLIPOP="L AA L IY P AA P",GURIAN="G Y UH R IY AH N",FLAGSTAFF="F L AE G S T AE F",LESKE="L EH S K",["HAMPSHIRE'S(4)"]="HH AE M SH AY ER Z",JESKE="JH EH S K",KESKE="K EH S K",KUFFEL="K AH F AH L",GONYER="G OW N Y ER",MASSIEU="M AE S IY UW",THRICE="TH R AY S",PROSPECTING="P R AO S P EH K T IH NG",BIMBOS="B IH M B OW S",HARITOS="HH EH R IY T OW S",ATCO="AE T K OW",LANGLEY="L AE NG L IY",COPROCESSORS="K OW P R AA S EH S ER Z",ESCO="EH S K OW",CRUSTY="K R AH S T IY",VALADEZ="V AA L AA D EH Z",OSCO="AA S K OW",PRIESTER="P R IY S T ER",QUICKTIME="K W IH K T AY M",REVERBERATE="R IH V ER B ER AH T",["FEBRUARY(2)"]="F EH B R UW EH R IY",LACOUR="L AH K UH R",IMPROVISATION="IH M P R AA V IH Z EY SH AH N",KOTTWITZ="K AA T W IH T S",OCTAGONAL="AA K T AE G AH N AH L",CARAS="K AA R AH Z",BUDNY="B AH D N IY",KARAS="K AA R AH Z",["BUDVAR(2)"]="B UH D V AA R",DUFFEL="D AH F AH L",["DJAKARTA'S"]="JH AH K AA R T AH Z",BLASTOMA="B L AE S T OW M AH",LAUGHINGSTOCK="L AE F IH NG S T AA K",ZICO="Z IY K OW",["BEDROSIAN(2)"]="B AH D R OW Z IY AH N",RICO="R IY K OW",VIGDOR="V IH G D ER",PIEZOELECTRIC="P AY AH Z OW AH L EH K T R IH K",HUMVEES="HH AH M V IY Z",EXTERMINATION="IH K S T ER M AH N EY SH AH N",LICO="L IY K OW",NICO="N IY K OW",PICO="P IY K OW",BRICKELL="B R IH K AH L",BOSSIDY="B AO S IH D IY",CARLOTTA="K AA R L AO T AH",WENDORF="W EH N D AO R F",HENLE="HH EH N AH L",CONTAGIOUSNESS="K AH N T EY JH AH S N AH S",CILCORP="S IH L K AO R P",GRANDCHILDREN="G R AE N CH IH L D R AH N",CABARETS="K AE B ER EY Z",RISTORANTE="R IH S T ER AA N T EY",IPCO="IH P K OW",RISKE="R IH S K",JACKETS="JH AE K IH T S",LISKE="L IH S K",PACKETS="P AE K IH T S",BREWED="B R UW D",RACKETS="R AE K AH T S",FISKE="F IH S K",RANNEY="R AE N IY",MATURE="M AH CH UH R",TANNEY="T AE N IY",PEBBLE="P EH B AH L",SOCO="S OW K OW",["BAYTREE'S"]="B EY T R IY Z",BENDORF="B EH N D AO R F",DEPRECIATE="D IH P R IY SH IY EY T",RORKE="R AO R K",PREJUDGE="P R IY JH AH JH",BETELGEUSE="B EH T AH L G UH Z",COCO="K OW K OW",POCO="P OW K OW",PHLCORP="P IY EY CH EH L K AO R P",LOCO="L OW K OW",JEEPS="JH IY P S",KEEPS="K IY P S",WATERWAYS="W AO T ER W EY Z",NOUVELLE="N UW V EH L",TORIAN="T AO R IY AH N",BEEPS="B IY P S",["O'BANION"]="OW B AE N Y AH N",DOUBTFUL="D AW T F AH L",MONTANARI="M OW N T AA N AA R IY",CHRYSALIS="K R IH S AH L IH S",AMSTERDAM="AE M S T ER D AE M",SKEWED="S K Y UW D",WEEPS="W IY P S",DORIAN="D AO R IY AH N",LOCKHEED="L AA K HH IY D",["MELKAR'S"]="M EH L K AA R Z",VERAS="V EH R AH Z",PERAS="P EH R AH S",PEEPS="P IY P S",FUNGICIDE="F AH N JH AH S AY D",BANNICK="B AE N IH K",HEINICKE="HH AY N IH K",RAVAGING="R AE V IH JH IH NG",AGRIFUEL="AE G R AH F Y UW L",RECO="R EH K OW",SECO="S EH K OW",EVISCERATED="AH V IH S ER EY T IH D",NECO="N IY K OW",PECO="P EY K OW",MCCULLOUGH="M AH K AH L AH",TANEN="T AE N AH N",BECO="B IY K OW",PETROCHEMICAL="P EH T R OW K EH M IH K AH L",DECO="D EH K OW",["MCCARTNEY'S"]="M AH K AA R T N IY Z",ANGUISHED="AE NG G W IH SH T",DNIESTER="D N IY S T ER",["EIFLER(2)"]="AY F L ER",ANTIS="AE N T AY Z",YORKE="Y AO R K",["FAVORABLE(2)"]="F EY V R AH B AH L",ELCO="EH L K OW",INTIS="IH N T IH S",YANNICK="Y AE N IH K",["RESERVOIR(2)"]="R EH Z ER V W AA R",HANAFIN="HH AE N AH F IH N",TRANSOU="T R AE N Z UW",OUTLASTS="AW T L AE S T S",OLEAN="OW L IY N",INCREMENTS="IH NG K R AH M AH N T S",["MOBUTU'S"]="M OW B UW T UW Z",HERRINGSHAW="HH EH R IH NG SH AO",["KNICK-KNACK"]="N IH K N AE K",GLEAN="G L IY N",GLUCOSIDE="G L UW K AH S AY D",["HAMPSHIRE(3)"]="HH AE M P SH AY ER",MEMBRANES="M EH M B R EY N Z",OVERCASH="OW V ER K AE SH",ERHARD="EH R HH AA R D",OVERTAXED="OW V ER T AE K S T",["IZETBEGOVIC'S"]="IH Z EH T B EH G OW V IH CH IH Z",JUDGES="JH AH JH IH Z",SPEWED="S P Y UW D",NIBLACK="N IH B L AE K",CLEAN="K L IY N",KOSAKOWSKI="K AH S AH K AO F S K IY",NUDGES="N AH JH IH Z",DUCHOSSOIS="D UW CH AO S W AA",GREIFF="G R IY F",SWINEY="S W AY N IY",GODSHALK="G AA D SH AH K",GAGLIARDI="G AA G L IY AA R D IY",DAMINOZIDE="D AE M IH N AH Z AY D",ATHENIANS="AH TH IY N IY AH N Z",["EXPECTS(2)"]="IH K S P EH K S",MARICE="M AA R IH S",APPRECIATE="AH P R IY SH IY EY T",DEVISE="D IH V AY Z",["RESIGN(3)"]="R IY S AY N",COUNTERSUE="K AW N T ER S UW",REVAMP="R IY V AE M P",OUTNUMBERED="AW T N AH M B ER D",BOBCAT="B AA B K AE T",REVISE="R IH V AY Z",METHODOLOGICAL="M EH TH AH D AH L AA JH IH K AH L",["BOEING'S"]="B OW IH NG Z",CYBERTRENDS="S AY B ER T R EH N D Z",MONOPOLIZING="M AH N AA P AH L AY Z IH NG",OVERCOAT="OW V ER K OW T",DARICE="D AA R IH S",["SETH'S"]="S EH TH S",MADAN="M EY D AH N",AGCO="AE G K OW",CHARACTER="K EH R IH K T ER",OVERTURE="OW V ER CH ER",OFFENDED="AH F EH N D AH D",PERVERT="P ER V ER T",STURDINESS="S T ER D IY N AH S",BURDELL="B ER D EH L",EMBASSIES="EH M B AH S IY Z",DELPIZZO="D EH L P IY Z OW",["POLLUTED(2)"]="P AH L UW T IH D",UNDIVERSIFIED="AH N D IH V ER S IH F AY D",RATTLER="R AE T AH L ER",SATTLER="S AE T L ER",TATTLER="T AE T L ER",SHOCKLEY="SH AA K L IY",["DELAWARE'S"]="D EH L AH W EH R Z",GANGES="G AE N JH IY Z",[".FULL-STOP"]="F UH L S T AA P",BEECHY="B IY CH IY",DOGGEDLY="D AO G AH D L IY",MINIATURES="M IH N IY AH CH ER Z",HYMEN="HH AY M AH N",HERMANS="HH ER M AH N Z",GERMANS="JH ER M AH N Z",SUITER="S UW T ER",SERVO="S ER V OW",RUITER="R UW T ER",PHARMACOLOGY="F AA R M AH K AA L AH JH IY",TERVO="T EH R V OW",HENDRIE="HH EH N D ER IY",RINAUDO="R IY N AO D OW",["DOCUMENTED(2)"]="D AA K Y AH M EH N AH D",FIREDAMP="F AY ER D AE M P",DESECRATE="D EH Z AH K R EY T",ORKNEY="AO R K N IY",RESURGENT="R IH S ER JH AH N T",HAPPINESS="HH AE P IY N AH S",ADRIAN="EY D R IY AH N",LEOPOLDINA="L EH P OW L D IY N AH",ANGELFISH="EY N JH AH L F IH SH",JEROD="JH EH R AH D",RANGES="R EY N JH AH Z",YERIAN="Y IY R IY AH N",MANGES="M EY N JH IH Z",HEROD="HH EH R AH D",OBRIAN="OW B R AY AH N",["RAPACIOUS(2)"]="R AH P EY SH IH S",CYGAN="S AY G AH N",["KAZARIAN'S"]="K AH Z EH R IY AH N Z",["SETTLEMENT'S"]="S EH T AH L M AH N T S",MOFFIT="M AA F IH T",ELROD="IH L R AA D",PENCHANT="P EH N CH AH N T",["SWANS(2)"]="S W AO N Z",FARACI="F AA R AA CH IY",["WHEW(3)"]="HH Y UW",TOUCHETTE="T UW SH EH T",POUSSANT="P UW S AH N T",REFUSAL="R AH F Y UW Z AH L",INHALANT="IH N HH EY L AH N T",SHOCKEY="SH AA K IY",["OPERATIONS'"]="AA P ER EY SH AH N Z",COUCHETTE="K UW SH EH T",["BEL'C"]="B EH L K",ESCARCEGA="EH S K AA R CH EH G AH",["APPROXIMATE(2)"]="AH P R AA K S AH M EY T",WESTPAC="W EH S T P AE K",GURTLER="G ER T AH L ER",SIRMANS="S ER M AH N Z",ANTHROPOMORPHISM="AE N TH R AH P AH M AO R F IH Z AH M",BLACKJACK="B L AE K JH AE K",FIRMANS="F ER M AH N Z",OMMEN="AA M AH N",BARBECUEING="B AA R B IH K Y UW IH NG",SARACCO="S AA R AA K OW",LOOTENS="L UW T AH N Z",["RECALL(2)"]="R IH K AO L",["INTUIT'S"]="IH N T UW AH T S",["OUTMAN(2)"]="AW T M AE N",["WHITEY(2)"]="HH W AY T IY",ALLAYING="AH L EY IH NG",MELVINE="M EH L V AY N",["LAWRENCE'S"]="L AO R AH N S IH Z",SARTORIAL="S AA R T AO R IY AH L",MARIAN="M EH R IY AH N",BURGHART="B ER G HH AA R T",TAMMINGA="T AA M IY NG G AH",KLEIER="K L AY ER",["HELICOPTER'S"]="HH EH L AH K AA P T ER Z",BLEIER="B L AY ER",GIROD="ZH ER AA D",BOARDERS="B AO R D ER Z",HOMEN="HH OW M AH N",AGONIZES="AE G AH N AY Z IH Z",CONJECTURE="K AH N JH EH K CH ER",PARISHIONER="P ER IH SH AH N ER",PENKAVA="P EH NG K AA V AH",PUNCTUAL="P AH NG K CH UW AH L",["SNAPPLE'S"]="S N AE P AH L Z",WUELLNER="W UH L N ER",MUELLNER="M Y UW L N ER",JURAS="JH UH R AH Z",MAESTRA="M AY S T R AH",LONGHORNS="L AO NG HH AO R N Z",CLENDENING="K L EH N D AH N IH NG",KURAS="K UH R AH Z",GENERALIZATION="JH EH N ER AH L IH Z EY SH AH N",["LOTHROP(2)"]="L OW TH R AH P",GOODHART="G UH D HH AA R T",BURAS="B Y UW R AH Z",CHEYENNES="SH AY EH N Z",MERCURE="M ER K UH R",SOFFEL="S AO F AH L",BINGES="B IH N JH IH Z",LIPNICK="L IH P N IH K",MISSISSAUGA="M IH S IH S AO G AH",HOWZE="HH AW Z",HENDRIX="HH EH N D R IH K S",MIRABEL="M IH R AA B EH L",EASTPAC="IY S T P AE K",FLETCHER="F L EH CH ER",ALACHLOR="AH L AE K L ER",["EXPLORATION'S"]="EH K S P L ER EY SH AH N Z",DUSENBURY="D UW S AH N B EH R IY",POINTENOIRE="P OY N T AH N OY R",PLETCHER="P L EH CH ER",ORTEGO="AO R T EY G OW",TRAILER="T R EY L ER",ORDINATION="AO R D AH N EY SH AH N",COFFEL="K AA F AH L",DOWDELL="D AW D AH L",MINGES="M IH N JH IH Z",BOETCHER="B OW CH ER",PETROLANE="P EH T R OW L EY N",RIDICULE="R IH D AH K Y UW L",HANNEY="HH AE N IY",["BUGA(2)"]="B IY Y UW JH IY EY",["FREQUENTLY(2)"]="F R IY K W EH N T L IY",MANNEY="M AE N IY",NANNEY="N AE N IY",["KROEBER'S"]="K R OW B ER Z",PLINIUS="P L IH N IY AH S",MILLIET="M IH L IY EH T",OUTPERFORMING="AW T P ER F AO R M IH NG",JEANPIERRE="ZH AO N P IY EH R",DABBLE="D AE B AH L",UNSTRUCTURED="AH N S T R AH K SH ER D",BABBLE="B AE B AH L",ARMEN="AA R M AH N",HOMMEL="HH AA M AH L",["KASHIWAHARA'S"]="K AA SH IY W AH HH AA R AH Z",RESTRUCTURED="R IY S T R AH K CH ER D",MCLANAHAN="M AH K L AE N AH HH AE N",POMMEL="P AA M AH L",ROMMEL="R AA M AH L",BAYUL="B EY AH L",MINERALIZATION="M IH N ER AH L AH Z EY SH AH N",WHITER="W AY T ER",THORUP="TH AO R AH P",ALESHIRE="AA L EY SH IH R EY",JANARDHAN="JH AH N AA R D AH N",EXTENDIBLE="EH K S T EH N D IH B AH L",EGGPLANT="EH G P L AE N T",HAJIME="HH AA JH IY M IY",["DISTRIBUTOR'S"]="D IH S T R IH B Y UW T ER Z",CATTLEMEN="K AE T AH L M AH N",PELADEAU="P EH L AH D OW",["HELLBUSCH(2)"]="HH EH L B UH SH",SUNKIST="S AH N K IH S T",RUNCK="R AH NG K",KIMMEL="K IH M AH L",["OXFAM'S"]="AA K S F AE M Z",HIMMEL="HH IH M AH L",TABLESPOON="T EY B AH L S P UW N",ALMOST="AO L M OW S T",NEANDERTHAL="N IY AE N D ER TH AO L",SLAUGHTERHOUSES="S L AO T ER HH AW S IH Z",RITTEREISER="R IH T ER AY Z ER",ESCAPADES="EH S K AH P EY D Z",DISALLOWANCE="D IH S AH L AW AH N S",EICHELBERGER="AY K AH L B ER G ER",THEIRSELVES="DH EH R S EH L V Z",INHERITS="IH N HH EH R AH T S",MOUNTAINEERING="M AW N T IH N IH R IH NG",IHNEN="IH N AH N",SUBCONTRACTS="S AH B K AA N T R AE K T S",OSHAWA="AO SH AA W AH",SOUCEK="S OW S IH K",["EXPERIMENTING(2)"]="EH K S P EH R AH M EH N IH NG",RUGGEDLY="R AH G AH D L IY",WESTERNERS="W EH S T ER N ER Z",STEWED="S T UW D",DIGANGI="D IH G AE N JH IY",RETRAINING="R IY T R EY N IH NG",IRONIZES="AY ER N AY Z IH Z",OVERSTAFF="OW V ER S T AE F",FUNCK="F AH NG K",MACGYVER="M AH G AY V ER",RIDGWAY="R IH JH W EY",MONTERREY="M AA N T ER EY",BARBER="B AA R B ER",GLASSCO="G L AE S K OW",GARBER="G AA R B ER",HARBER="HH AA R B ER",["FETISHISTS(2)"]="F EH T IH SH IH S T S",SUSQUEHANNA="S UW S K W EH HH AE N AH",CHESHIRE="CH EH SH ER",FARBER="F AA R B ER",REITER="R AY T ER",ANDO="AE N D OW",["FINIAN'S"]="F IH N IY AH N Z",KEITER="K IY T ER",LEITER="L AY T ER",["BRIANA'S"]="B R IY AE N AH Z",INDO="IH N D OW",ENDO="EH N D OW",MOHICAN="M OW HH IY K AH N",BEITER="B AY T ER",KNAPIK="N AE P IH K",["MANVILLE'S"]="M AE N V IH L Z",CONTINGENT="K AH N T IH N JH AH N T",DEITER="D AY T ER",PERCEIVING="P ER S IY V IH NG",LABOVE="L AH B AH V",PUBLICIZING="P AH B L AH S AY Z IH NG",SPOKE="S P OW K",ONDO="AO N D OW",EVENSEN="EH V IH N S AH N",LIPKE="L IH P K",HOOKE="HH UH K",JUNWUXIYAN="JH AH N W UW K S IY AH N",COOKE="K UH K",UNDO="AH N D UW",LYSKI="L AY S K IY",GRAUMANN="G R AO M AH N",HELDENTENOR="HH EH L D EH N T EH N ER",["GUINIER'S"]="G W IH N IH R Z",TRADABLE="T R EY D AH B AH L",LOITER="L OY T ER",["SREBRENICA'S(2)"]="SH R EY B R AH N IY T S AH Z",NEIGHBORHOOD="N EY B ER HH UH D",OBSTETRICIANS="AA B S T AH T R IH SH AH N Z",SARDONIC="S AA R D AA N IH K",PEETERS="P IY T ER Z",GOITER="G OY T ER",DAUGHTERY="D AO T ER IY",DROKE="D R OW K",LAMLE="L AE M L IY",CROKE="K R OW K",["BARENBOIM'S"]="B EH R AH N B OY M Z",DIARIO="D AY EH R IY OW",BRITTON="B R IH T AH N",TRAVISANO="T R AE V IH S AA N OW",GRITTON="G R IH T AH N",LIVINGROOM="L IH V IH NG R UW M",LEAGUER="L IY G ER",VUITTON="V UW T AH N",OPHEIM="AA P HH AY M",NENNINGER="N EH N IH NG ER",TELFOUR="T EH L F ER",PENNINGER="P EH N IH NG ER",OSWEGO="AA S W IY G OW",SMOKE="S M OW K",GLADISH="G L AE D IH SH",HEISBOURG="HH AY S B AO R G",JENNINGER="JH EH N IH NG ER",MENNINGER="M EH N IH NG ER",LASURE="L AA ZH ER",FLYNT="F L IH N T",ACCENTUATED="AE K S EH N CH AH W EY T IH D",COSTANTINO="K OW S T AA N T IY N OW",KODO="K OW D OW",WENNINGER="W EH N IH NG ER",PARNELLA="P AA R N EH L AH",BATHROBES="B AE TH R OW B Z",ACCOMPANIMENTS="AH K AH M P N IH M AH N T S",COCCUS="K AA K AH S",STASZAK="S T AA SH AH K",VIVIEN="V IH V IY AH N",SUPPOSITIONS="S AH P AH Z IH SH AH N Z",OUTPOSTS="AW T P OW S T S",PREENING="P R IY N IH NG",FIDO="F AY D OW",FOODTOWN="F UW D T AW N",["CHATZ'S"]="CH AE T S IH Z",GREENING="G R IY N IH NG",APPELBAUM="AE P AH L B AW M",COMMENDATION="K AA M AH N D EY SH AH N",BENNINGER="B EH N IH NG ER",JUXTAPOSE="JH AH K S T AH P OW Z",DENNINGER="D EH N IH NG ER",PROSECUTED="P R AA S IH K Y UW T IH D",TARIFF="T EH R AH F",["CATERPILLER(2)"]="K AE T ER P IH L ER",PRECONCEIVE="P R IY K AH N S IY V",["HOLDERS'"]="HH OW L D ER Z",DEPONTE="D IH P OW N T IY",HABEGGER="HH AE B IH G ER",["BEATRICE(4)"]="B IY T R IH S",RIPKE="R IH P K",TOOKE="T UH K",CHAIKEN="CH EY K AH N",["LENINGRAD(2)"]="L EH N IH N G R AE D",MUSGRAVE="M AH S G R EY V",SUGGESTION="S AH G JH EH S CH AH N",KLINGAMAN="K L IH NG G AH M AH N",AIDAN="EY D AA N",LASPINA="L AA S P IY N AH",SPARTACUS="S P AA R T AH K AH S",BODO="B OW D OW",YEHIYA="Y AH HH IY AH",KAZIS="K AE Z IH S",NAZIS="N AA T S IY Z",SNOKE="S N OW K",PRATTVILLE="P R AE T V IH L",DODO="D OW D OW",CASAS="K AA S AH Z",PROBATIONERS="P R OW B EY SH AH N ER Z",["DOHERTY(2)"]="D AO R T IY",PARENTHETICALLY="P ER EH N TH EH T IH K AH L IY",SHAIKEN="SH EY K AH N",TAMAYO="T AA M AA Y OW",["FAYED'S"]="F EY D Z",["ENGENDER(2)"]="IH N JH EH N D ER",RESTRAINED="R IY S T R EY N D",ZINCK="Z IH NG K",["AGAINST(2)"]="AH G EY N S T",KATHLENE="K AE TH L IY N",["HUNDREDS(2)"]="HH AH N D ER D Z",RINCK="R IH NG K",SHEELAH="SH IY L AH",LINCK="L IH NG K",OKDO="AO K D OW",["SEGA(2)"]="S EY G AH",["BARINGS'"]="B EH R IH NG Z",ILLEGALS="IH L IY G AH L Z",DEDO="D EY D OW",IHASZ="AY HH AE S",EAGAN="IY G AH N",DAGAN="D EY G AH N",KORBER="K AO R B ER",LORBER="L AO R B ER",HAGAN="HH EY G AH N",KAGAN="K EY G AH N",SORBER="S AO R B ER",LUMONICS="L UW M AA N IH K S",SCHLEPP="SH L EH P",AIRWAYS="EH R W EY Z",MCILVAINE="M AE K IH L V EY N",DIANETICS="D AY AH N EH T IH K S",GENITAL="JH EH N AH T AH L",["FESTIVAL'S"]="F EH S T IH V AH L Z",ZONDERVAN="Z AA N D ER V AE N",ALDO="AA L D OW",CASTPART="K AE S T P AA R T",DICTATES="D IH K T EY T S",["YEAS(3)"]="Y IY S",RAMPAGER="R AE M P EY JH ER",HANUKKAH="HH AA N AH K AH",LIDO="L IY D OW",MUGGINGS="M AH G IH NG Z",SWARTHMORE="S W AO R TH M AO R",EVERLY="EH V ER L IY",FERBER="F ER B ER",GERBER="G ER B ER",HERBER="HH ER B ER",KERBER="K ER B ER",LYERLY="L AY ER L IY",PRIMROSE="P R IH M R OW Z",SCROD="S K R AA D",BERBER="B ER B ER",BARTLETT="B AA R T L IH T",BYERLY="B AY ER L IY",THEKLA="TH EH K L AH",MELANCON="M IH L AE N K AH N",["WATLING(2)"]="W AO T L IH NG",EYERLY="IY ER L IY",IVATANS="AY V AH T AH N Z",RUMEN="R UW M AH N",JACO="Y AA K OW",VISAS="V IY Z AH Z",BELLMORE="B EH L M AO R",BULLDOZES="B UH L D OW Z IH Z",PACO="P EY K OW",["KACZYNSKI'S(2)"]="K AH Z IH N S K IY Z",LUMEN="L UW M AH N",SACO="S EY K OW",TACO="T AA K OW",["ANTICORRUPTION(2)"]="AE N T IY K ER AH P SH AH N",DICHIARA="D IH K IY AA R AH",ABCO="AE B K OW",STEALTHIEST="S T EH L TH IY AH S T",BEGAN="B IH G AE N",SWAHILI="S W AA HH IY L IY",GRABENS="G R AA B AH N Z",TERRAZAS="T EH R AA Z AA Z",["PHILHARMONIC'S"]="F IH L HH AA R M AA N IH K S",RICHCREEK="R IH CH K R IY K",VESTIGIAL="V AH S T IH JH IY AH L",["DEIDRE'S"]="D IY D R AH Z",ALTVATER="AE L T V AH T ER",ABSORB="AH B Z AO R B",BRADISH="B R AE D IH SH",CANEDO="K AA N EY D OW",CLENNEY="K L EH N IY",["PHILIP'S"]="F IH L AH P S",["CHEVY'S(2)"]="SH EH V IY Z",NORTHVALE="N AO R TH V EY L",PEGBOARD="P EH G B AO R D",LAGAN="L AE G AH N",COORDINATED="K OW AO R D AH N EY T IH D",REDO="R IY D UW",PAGAN="P EY G AH N",PIETERS="P IY T ER Z",ROBUSTA="R AO B UH S T AH",DIETERS="D AY AH T ER Z",LEDO="L EY D OW",KEDO="K EH D OW",MCCAUL="M AH K AO L",VIAGRA="V IY AE G R AH",PERMISSIONS="P ER M IH SH AH N Z",OPPELT="AA P IH L T",MCKNIGHT="M AH K N AY T",PATNAUDE="P AA T N AO D IY",BUDROW="B AH D R OW",VICKNAIR="V IH K N ER",POSTEMA="P AA S T EH M AH",CETACEAN="S IH T EY SH AH N",REJOICED="R IH JH OY S T",FASCISM="F AE SH IH Z AH M",TWEEZERMAN="T W IY Z ER M AE N",DUNDEE="D AH N D IY",KEMPKER="K EH M P K ER",WITHHOLDS="W IH TH HH OW L D Z",LICHTENSTEIN="L IH K T AH N S T IY N",QUALIFIERS="K W AA L AH F AY ER Z",["POLYSAR'S"]="P AA L IH S AA R Z",NICHOLAS="N IH K AH L AH S",SPORTING="S P AO R T IH NG",["MONTENEGRO'S"]="M AA N T AH N EY G R OW Z",DOCKETS="D AA K AH T S",["DISASSOCIATE(2)"]="D IH S AH S OW S IY EY T",SEPPALA="S EH P AA L AH",CINEMATIC="S IH N AH M AE T IH K",["HADLER(2)"]="HH EY D L ER",LOCKETS="L AA K IH T S",["NADLER(2)"]="N EY D L ER",SPIRALED="S P AY R AH L D",KNABLE="N EY B AH L",UNIMPEDED="AH N IH M P IY D IH D",MISCONSTRUING="M IH S K AH N S T R UW IH NG",DETHLOFF="D EH TH L AO F",ICARD="IH K AA R D",VISIGOTH="V IH Z AH G AA TH",["JAGUAR'S"]="JH AE G W AA R Z",CREPES="K R EY P S",INSCHO="IH N SH OW",["POSEIDON'S"]="P AH S AY D AH N Z",BEBITCH="B EH B IH CH",DOABLE="D UW AH B AH L",REVIEW="R IY V Y UW",MARVEL="M AA R V AH L",["XOMA(2)"]="IH G Z OW M AH",OVERSTATE="OW V ER S T EY T",NERVOSA="N ER V OW S AH",GREENBACKS="G R IY N B AE K S",LEVIS="L EH V IH S",LIABLE="L AY AH B AH L",LOGISTICALLY="L AH JH IH S T IH K L IY",HAWKSLEY="HH AO K S L IY",VIABLE="V AY AH B AH L",WRESTLER="R EH S AH L ER",BEVIS="B EH V IH S",MCFADDEN="M AH K F AE D AH N",ENABLE="EH N EY B AH L",NEVIS="N EH V IH S",SCHILLO="S K IH L OW",TEVIS="T EH V IH S",ANABLE="EY N AH B AH L",REVIS="R EH V IH S",OCEAN="OW SH AH N",RICCITELLI="R IY CH IY T EH L IY",BIDLACK="B IH D L AE K",ZAPPALA="Z AA P AA L AH",MEDISGROUPS="M EH D IH S G R UW P S",SHAUGHNESSY="SH AO N IH S IY",QUARRE="K W AA R",FAIRGROUNDS="F EH R G R AW N D Z",VITUPERATIVE="V AY T UW P ER AH T IH V",INOFFENSIVE="IH N AH F EH N S IH V",CARVEL="K AA R V EH L",GRZYB="G ER Z IH B",BOBROW="B AA B R OW",HARVEL="HH AA R V AH L",SCHWED="SH W EH D",JALALABAD="JH AH L AE L AH B AE D",["ALLSBROOK(2)"]="AO L T S B R UH K",LOUISE="L UW IY Z",EXCAVATED="EH K S K AH V EY T IH D",LOWERY="L AW ER IY",MOWERY="M AW ER IY",KLIMCZAK="K L IH M CH AE K",COLONIZED="K AA L AH N AY Z D",BOWERY="B AW ER IY",HOWERY="HH AW ER IY",["DEMERIST'S"]="D IH M ER IH S T S",SCONNIX="S K AA N IH K S",["COMMONWEALTH'S"]="K AA M AH N W EH L TH S",MOHNEY="M AA N IY",OBRENOVICH="OW B R EH N AH V IH CH",BRUISE="B R UW Z",GRABLE="G R EY B AH L",THORNHILL="TH AO R N HH IH L",BRUNKOW="B R AH NG K OW",HEMMINGS="HH EH M IH NG Z",MCCLENAGHAN="M AH K L EH N AH G AH N",LEMMINGS="L EH M IH NG Z",ENCYCLICALS="EH N S IH K L IH K AH L Z",WALDEGARD="W AO L D AH G AA R D",LAVIS="L AE V IH S",INFINITELY="IH N F AH N AH T L IY",HAVIS="HH AE V IH S",GOLOVEN="G OW L AH V AH N",DAVIS="D EY V AH S",BAVIS="B EY V IH S",CORESTATES="K AO R S T EY T S",TORREZ="T AO R EH Z",PANTYHOSE="P AE N T IY HH OW Z",TROUNCE="T R AW N S",ARABLE="AE R AH B AH L",KREIFELS="K R AY F AH L Z",CRABLE="K R EY B AH L",DELAUTER="D EH L AW T ER",PAOLILLO="P AA OW L IH L OW",VOLTAREN="V OW L T ER AH N",CERACEOUS="S ER EY SH AH S",NAVIS="N AA V IH S",HIRSUTE="HH ER S UW T",SENTENCE="S EH N T AH N S",DONAHO="D OW N AA HH OW",GORNIK="G AO R N IH K",DEBATABLE="D AH B EY T AH B AH L",HORNIK="HH AO R N IH K",GERMINATION="JH ER M AH N EY SH AH N",CHUNN="CH AH N",SAFIER="S AH F IH R",SHANDWICK="SH AE N D W IH K",CLOTILDA="K L AH T IH L D AH",SILBERGELD="S IH L B ER G EH L D",TERMINATION="T ER M AH N EY SH AH N",JARAMILLO="JH AE R AH M IH L OW",NORTHGATE="N AO R TH G EY T",MUNNS="M AH N Z",HOVIS="HH OW V IH S",BAHAMA="B AH HH AA M AH",PLANTAIN="P L AE N T AH N",CARCASS="K AA R K AH S",BALUKAS="B AH L UW K AH Z",["TURKEY'S"]="T ER K IY Z",SARMIENTO="S AA R M IY N T OW",MISAPPROPRIATING="M IH S AH P R OW P R IY EY T IH NG",LOREDO="L AO R EY D OW",MAINFRAME="M EY N F R EY M",BRANNEN="B R AE N AH N",DALIBERTI="D AE L AH B EH R T IY",DIOCESAN="D AY AA S AH S AH N",EFFACE="IH F EY S",BUSHMEN="B UH SH M EH N",RICAN="R IY K AH N",DOUBTFIRE="D AW T F AY ER",["OLIVETTI'S"]="AA L IH V EH T IY Z",["TANZANIA'S(2)"]="T AE N Z AH N IY AH Z",ALCAN="AE L K AE N",RICHERD="R IH CH ER D",OSTRACIZE="AO S T R AH S AY Z",DEBOY="D IH B OY",KLINKHAMMER="K L IH NG K HH AE M ER",["WHITTLE(2)"]="HH W IH T AH L",CONVERSANT="K AH N V ER S AH N T",DELOSSANTOS="D EY L OW S AA N T OW Z",CONTAGION="K AH N T EY JH AH N",AZACTAM="AH Z AE K T AE M",ADMEN="AE D M AH N",COURTEMANCHE="K AO R T M AE N SH",FADDISH="F AE D IH SH",ELVIS="EH L V IH S",YEMEN="Y EH M AH N",ALVIS="AA L V IH S",["ANGELINE(2)"]="AE N JH AH L IY N",["ELECTED(2)"]="IH L EH K T IH D",["M'BOW"]="M B OW",BIELANSKI="B IY L AE N S K IY",LEMEN="L IY M EH N",HOMOSAPIEN="HH OW M OW S EY P IY AH N",AXELROD="AE K S AH L R AA D",IMPINGE="IH M P IH N JH",WISENBAKER="W AY Z AH N B EY K ER",DARKE="D AA R K",PETERKA="P IH T ER K AH",["HANOVER'S"]="HH AE N OW V ER Z",HUNSICKER="HH AH N S IH K ER",MARKE="M AA R K",LARKE="L AA R K",SUBTRACTED="S AH B T R AE K T IH D",HARKE="HH AA R K",ARCHLY="AA R CH L IY",AIRBASES="EH R B EY S IH S",PARKE="P AA R K",LINGUISTICS="L IH NG G W IH S T IH K S",ROSANNE="R OW Z AE N",EXCLUSIVES="IH K S K L UW S IH V Z",["GRISMER(2)"]="G R IH S M ER",["EXPERTS'"]="EH K S P ER T S",DRAPED="D R EY P T",MEDEARIS="M EH D ER IH S",VOLKSBANK="V OW L K S B AE NG K",["MORRIS(2)"]="M AO R IH S",PANZICA="P AE N Z IH K AH",DYNASCAN="D AY N AH S K AE N",DISRUPTED="D IH S R AH P T IH D",RAFALSKI="R AH F AA L S K IY",DIVIS="D IY V IH S",PHRASE="F R EY Z",HILDEGARD="HH IH L D AH G AA R D",PHILOSOPHERS="F AH L AA S AH F ER Z",POCLAIN="P AA K L IH N",HOWK="HH AW K",CONSOB="K AA N S AA B",["HOEPFNER(2)"]="HH OW P N ER",KRUTTSCHNITT="K R AH CH N IH T",PETKOVSEK="P EH T K AA V S EH K",BEHNEY="B EH N IY",FALCIGNO="F AE L S IH G N OW",["RIEDERS'"]="R IY D ER Z",BELNICK="B EH L N IH K",MANURE="M AH N UH R",QUIROGA="K W IH R OW G AH",ZELNICK="Z EH L N IH K",ELENORE="EH L IH N ER",["EXPATRIATES(2)"]="EH K S P EY T R IY AH T S",CAMUSO="K AA M UW S OW",ESTABLISH="IH S T AE B L IH SH",ROSEMOND="R OW Z M AH N D",["SHRIVELING(2)"]="SH R IH V L IH NG",DICKLER="D IH K L ER",MENNELLA="M EH N EH L AH",BICKLER="B IH K L ER",SKIMMER="S K IH M ER",PENNELLA="P EH N EH L AH",["DECORATED(2)"]="D EH K ER EY T IH D",["WHITMAN'S(2)"]="HH W IH T M AH N Z",MCCANLESS="M AH K AE N L AH S",RAMSEYER="R AE M Z IY ER",PENURIOUS="P EH N Y UW R IY AH S",SECKLER="S EH K L ER",LANTZY="L AE N T Z IY",UNEO="Y UW N IY OW",PHOBOS="F OW B OW S",LUEDECKE="L UH D IH K",SHIMMER="SH IH M ER",["CAMA(2)"]="S IY EY EH M EY",PELVIC="P EH L V IH K",MITZI="M IH T S IY",HOEFLICH="HH OW F L IH K",["PLAINTIFF'S"]="P L EY N T IH F S",SUSPICION="S AH S P IH SH AH N",SEGALAS="S EH G AH L AH S",MARKOW="M AA R K OW",["TONIGHT'S(2)"]="T UW N AY T S",STYRON="S T AY R AO N",LILLICROP="L IH L IH K R AA P",GLUCKSMAN="G L AH K S M AH N",KULIKOWSKI="K Y UW L IH K AO F S K IY",BARKOW="B AA R K OW",LOWRANCE="L AO R AH N S",LIASSON="L AY AH S AH N",CLAPSADDLE="K L AE P S AE D AH L",KLICH="K L IH CH",NUCLEATION="N UW K L IY EY SH AH N",["VETERAN(2)"]="V EH T R AH N",TENURE="T EH N Y ER",NONPOLITICAL="N AA N P AH L IH T IH K AH L",GERTLER="G ER T AH L ER",SCHUELER="SH UW L ER",LOOKIT="L UH K IH T",HEILEMAN="HH AY L M AH N",PEDAGOGY="P EH D AH G OW JH IY",KRISCHER="K R IH SH ER",BATESON="B AE T IH S AH N",["PEPSI'S"]="P EH P S IY Z",DETERDING="D EH T ER D IH NG",["HAMPSHIRE'S(3)"]="HH AE M P SH AY ER Z",["O'HARA'S"]="OW HH EH R AH Z",CLASSON="K L AE S AH N",FUNCTIONALITY="F AH NG K SH AH N AE L IH T IY",APOLLINIAN="AE P AH L IH N IY AH N",FINOCCHIARO="F IY N OW K IY AA R OW",DIVORCEE="D AH V AO R S IY",DEMILITARIZED="D IY M IH L AH T ER AY Z D",VANWAGNER="V AE N W AE G N ER",CHARACTERS="K AE R IH K T ER Z",SICKLER="S IH K L ER",PICKLER="P IH K AH L ER",MICKLER="M IH K L ER",MULTIMILLION="M AH L T AY M IH L Y AH N",METZE="M EH T Z",BURDA="B UH R D AH",KUCAN="K Y UW K AH N",HEARTBREAKS="HH AA R T B R EY K S",SHAKEDOWN="SH EY K D AW N",ZIONS="Z AY AH N Z",AUTOMATES="AO T AH M EY T S",SUBLIMINAL="S AH B L IH M IH N AH L",OREO="AO R IY OW",LABOY="L AH B OY",MINIMALISM="M IH N AH M AH L IH Z AH M",RABOY="R AE B OY",CUMMINGS="K AH M IH NG Z",DEMAGOGUING="D EH M AH G AA G IH NG",STABLE="S T EY B AH L",OLESTRA="OW L EH S T R AH",MATCHUP="M AE CH AH P",ICONS="AY K AA N Z",CATCHUP="K AE CH AH P",LABRECK="L AE B R IH K",MINNOWS="M IH N OW Z",RECHARGING="R IY CH AA R JH IH NG",["WEINTZ'"]="W AY N T S",ISOLDE="IH S OW L D AH",LONGLEG="L AO NG L EH G",THEO="TH IY OW",ADENINE="AE D AH N IY N",DISTRESSING="D IH S T R EH S IH NG",["FIDLER(2)"]="F AY D L ER",URICH="Y ER IH K",KOESTLER="K OW S T L ER",MAZZOCCHI="M AA T S OW K IY",AIRGAS="EH R G AE S",["HAN'S(2)"]="HH AE N Z",["GAMBLING'S"]="G AE M B L IH NG Z",FLAVOR="F L EY V ER",["DOUGALL(2)"]="D UW G AH L",["TSURUMI(2)"]="S UW R UW M IY",LYCAN="L AY K AH N",RESNIK="R EH S N IH K",POLYURETHANE="P AA L IY UH R AH TH EY N",CALCULATE="K AE L K Y AH L EY T",["BARRACKS(2)"]="B EH R AH K S",["ANDREA'S"]="AE N D R IY AH Z",FAZEKAS="F AE Z IH K AH Z",GOEDECKE="G OW D IH K",GRANULE="G R AE N Y AH L",ENSKILDA="EH N S K IH L D AH",NEONS="N IY AA N Z",SHAKESPEARE="SH EY K S P IY R",FOCKLER="F AA K L ER",HEIMLICH="HH AY M L IH K",["INTELLECTUALLY(4)"]="IH N AH L EH K CH UW L IY",PEONS="P IY AH N Z",GLOWACKI="G L AW AA T S K IY",MOCKLER="M AA K L ER",KETCHUP="K EH CH AH P",MCCADDEN="M AH K AE D AH N",["WHITEHORN(2)"]="HH W AY T HH AO R N",PLUMB="P L AH M",RELICS="R EH L IH K S",KLUMB="K L AH M",SHOEHORN="SH UW HH AO R N",ROHYPNOL="R OW HH AY P N AO L",LATINATE="L AE T AH N EY T",PETERSBURG="P IY T ER Z B ER G",MISGUIDES="M IH S G AY D Z",LIFTERS="L IH F T ER Z",COURTRIGHT="K AO R T R AY T",["REAGANITE(2)"]="R IY G AH N AY T",OLEO="OW L IY OW",SOIFFER="S OY F ER",NORVEL="N AO R V AH L",CLEO="K L IY OW",["TINKERING(2)"]="T IH NG K R IH NG",ALLBRITTON="AE L B R IH T AA N",HECKLER="HH EH K L ER",GAWK="G AO K",HAWK="HH AO K",KECKLER="K EH K L ER",RELAYING="R IY L EY IH NG",["LAMPPOST(2)"]="L AE M P OW S T",BECKLER="B EH K L ER",["RADLER(2)"]="R AE D L ER",["HUIE(2)"]="Y UW IY",ERICH="EH R IH K",PIATKOWSKI="P IY AH T K AO F S K IY",PRECINCT="P R IY S IH NG K T",HEREDIA="HH ER EH D IY AH",JESSELSON="JH EH S AH L S AH N",["BUIE(2)"]="B W IY",WOLFENSOHN="W UH L F AH N S AH N",FLEISSNER="F L AY S N ER",DELAPP="D EH L AH P",SEDLACK="S EH D L AH K",GERACI="JH ER AA CH IY",VANAKEN="V AE N AH K AH N",STICH="S T IH CH",CARBURETORS="K AA R B ER EY T ER Z",VIOLISTS="V IY OW L AH S T S",TEACHERS="T IY CH ER Z",SCHERZINGER="SH ER Z IH NG ER",CHYRON="CH AY R AH N",DRIVABLE="D R AY V AH B AH L",DECOMMISSIONING="D IY K AH M IH SH AH N IH NG",GEISELMAN="G AY S AH L M AH N",KERCHIEFS="K ER CH AH F S",ESCROW="EH S K R OW",GLASCOCK="G L AE S K AH K",["PUBLICATIONS'"]="P AH B L IH K EY SH AH N Z",PENFIL="P EH N F IH L",WURSTER="W ER S T ER",["VIKING'S"]="V AY K IH NG Z",WILCOXSON="W IH L K AA K S AH N",GANATIEUGANAUF="G AH N EY SH AH G AE N AH L F",ROCKVILLE="R AA K V IH L",VERDUGO="V ER D UW G OW",["MAYOR'S"]="M EY ER Z",["CIPOLLONE(2)"]="S IH P AH L OW N IY",IMMANENT="IH M AH N AH N T",SEDAN="S AH D AE N",ENFOR="EH N F ER",["PRAIRIE'S"]="P R EH R IY Z",CAREMARK="K EH R M AA R K",["DHAKA(3)"]="D AE K AE",FERRIED="F EH R IY D",ABOODI="AH B UW D IY",WORRIED="W ER IY D",DICIER="D AY S IY ER",IDROCARBURI="IH D R AA K AA R B UH R IY",["D'SOUZA(2)"]="D IY S UW Z AH",MITTELMAN="M IH T AH L M AH N",ENDOWS="EH N D AW Z",EASEMENT="IY Z M AH N T",GITTELMAN="G IH T AH L M AH N",["BENNETT'S"]="B EH N AH T S",GRZYBOWSKI="G ER Z IH B AW S K IY",PAMPLONA="P AE M P L OW N AH",RICHLY="R IH CH L IY",EDUCATED="EH JH AH K EY T AH D",["COURAGE(2)"]="K ER IH JH",INSTRUCTING="IH N S T R AH K T IH NG",SHEATHBILL="SH IY TH B IH L",PANFIL="P AE N F IH L",HARMONIES="HH AA R M AH N IY Z",ARENABALL="ER IY N AH B AO L",SHIMABUKURO="SH IY M AA B UW K UH R OW",BASHORE="B AE SH ER",NETWORKS="N EH T W ER K S",URUGUAY="Y ER AH G W EY",["CHINA'S"]="CH AY N AH Z",["FAMILIES(2)"]="F AE M L IY Z",DECIMA="D IH CH IY M AH",SHERRIN="SH EH R IH N",COROLLARIES="K AO R AH L EH R IY Z",PORTILLO="P AO R T IH L OW",STALINISM="S T AE L IH N IH Z AH M",STOUTE="S T AW T",OTTESON="AA T IH S AH N",ARABIE="AE R AH B IY",GRONINGER="G R OW N IH NG ER",SPAGNOLA="S P AA G N OW L AH",EXTRATERRITORIAL="EH K S T R AH T EH R IH T AO R IY AH L",BOOMING="B UW M IH NG",DOOMING="D UW M IH NG",WIDOWS="W IH D OW Z",LOOMING="L UW M IH NG",GOODFELLAS="G UH D F EH L AH Z",["CHISLER(3)"]="CH IH Z L ER",SHASTEEN="SH AE S T IY N",SAWDUST="S AO D AH S T",ROOMING="R UW M IH NG",RIDGES="R IH JH AH Z",MIDGES="M IH JH AH Z",FRANCESMARY="F R AE N S AH S M EH R IY",EXACERBATED="IH G Z AE S ER B EY T AH D",CHASTEEN="CH AH S T IY N",["NASH'S"]="N AE SH IH Z",DUBOW="D UW B OW",HOUSEWARE="HH AW S W EH R",ROMNEY="R AA M N IY",LUBOW="L UW B OW",BARTENDER="B AA R T EH N D ER",PROPOSITIONS="P R AA P AH Z IH SH AH N Z",WHEREAS="W EH R AE Z",["RUTH'S"]="R UW TH S",["OBSCENE(2)"]="AH B S IY N",SERAFIN="S EH R AH F IH N",ONCOLOGIST="AA NG K AA L AH JH IH S T",IACOBELLIS="IY AA K OW B EH L IH S",THERAPIES="TH EH R AH P IY Z",MUILENBURG="M UW L AH N B ER G",STUCKY="S T AH K IY",MCGUYER="M AH G AY ER",ALBAN="AA L B AH N",["GO-CART"]="G OW K AA R T",HUMPHRIES="HH AH M F ER IY Z",CONSPIRATORIALLY="K AH N S P IH R AH T AO R IY AH L IY",CARTRIDGES="K AA R T R AH JH AH Z",BARBIER="B AA R B IY ER",IMMOLATES="IH M AH L EY T S",NUDO="N UW D OW",BESHORE="B EH SH ER",JUDO="JH UW D OW",LUDO="L UW D OW",CAREERISM="K ER IY R IH Z AH M",FUDO="F Y UW D OW",["DEMERIST(2)"]="D EH M ER IH S T",YEGOR="Y EY G ER",ELECTRONICS="IH L EH K T R AA N IH K S",WHITTAKER="W IH T AH K ER",LISENBY="L IH S IH N B IY",DEACONESS="D IY K AH N AH S",TRAMIEL="T R AE M IY AH L",["CAMP'S"]="K AE M P S",ARMADILLO="AA R M AH D IH L OW",["GENTLEWOMEN(2)"]="JH EH N AH L W IH M AH N",DETJEN="D EH T JH AH N",["KAMP'S"]="K AE M P S",NEDROW="N EH D R OW",COSTANZO="K OW S T AA N Z OW",TEDROW="T EH D R OW",BUCKETS="B AH K AH T S",OASIS="OW EY S IH S",CASHFLOWS="K AE SH F L OW Z",LEDGES="L EH JH IH Z",TISDELL="T IH S D AH L",BUDDHIST="B UW D AH S T",RACIER="R EY S IY ER",KITCHENAID="K IH CH AH N EY D",CRUZE="K R UW Z",DRUZE="D R UW Z",HEDGES="HH EH JH IH Z",MECHANISM="M EH K AH N IH Z AH M",ELBOW="EH L B OW",UNDERSELLING="AH N D ER S EH L IH NG",["HYBRID(2)"]="HH AY B R IH D",SELFLESSNESS="S EH L F L AH S N IH S",EISENHUTH="AY Z AH N HH UW TH",ALSDORF="AO L Z D AO R F",BOLKOW="B OW L K AW",ZASKE="Z EY S K",OBERLY="OW B ER L IY",LOVEJOY="L AH V JH OY",KISHORE="K IY SH AO R",KACHMAR="K AE K M ER",LACHMAR="L AE K M AA R",REICH="R AY K",HENNICK="HH EH N IH K",WEICH="W AY K",INTERCOURSE="IH N T ER K AO R S",UNCLAMPS="AH N K L AE M P S",TEICH="T AY K",["SHEFTEL'S"]="SH EH F T EH L Z",HOUZE="HH AW Z",BENNICK="B EH N IH K",BEHAVIORS="B IH HH EY V Y ER Z",["BACKHANDED(2)"]="B AE K HH AE N D IH D",DENYS="D EH N IH S",KENDZIERSKI="K IH N JH IH R S K IY",["BETSY'S"]="B EH T S IY Z",GLASSER="G L AE S ER",PENNICK="P EH N IH K",RENNICK="R EH N IH K",GLAVINE="G L AE V IH N",MASKE="M EY S K",KASKE="K AE S K IY",LASKE="L EY S K",HASKE="HH EY S K",LANGENDERFER="L EY NG G IH N D ER F ER",SANGUINETTI="S AA NG IY N EH T IY",GUNSALUS="G AH N S AA L AH S",EBERLY="EH B ER L IY",RASKE="R EY S K",PASKE="P EY S K",HARRIED="HH EH R IY D",YARDSTICK="Y AA R D S T IH K",["KEMP'S"]="K EH M P S",CARRIED="K AE R IY D",PARRIED="P EH R IY D",VIGOR="V IH G ER",STINGY="S T IH N JH IY",MARRIED="M EH R IY D",CONNICK="K AA N IH K",BUITRON="B IH T R AH N",["COLLOR'S"]="K AA L ER Z",["MARKEY'S"]="M AA R K IY Z",CONVEYANCE="K AH N V EY AH N S",SOLITRON="S OW L IH T R AA N",["RECOVERY(2)"]="R IH K AH V ER IY",LAGACE="L AA G AA CH IY",BADGES="B AE JH IH Z",GRANATA="G R AA N AA T AH",["WASSERSTEIN(2)"]="W AA S ER S T AY N",["EMERTON(2)"]="EH M ER T AH N",EXTENUATING="IH K S T EH N Y UW EY T IH NG",SLUTTY="S L AH T IY",NERVY="N ER V IY",KUBAN="K Y UW B AH N",ENTRAPPED="IH N T R AE P T",MAROVICH="M AA R AH V IH CH",CRACE="K R EY S",DRACE="D R EY S",ABOUNDED="AH B AW N D IH D",FRACE="F R EY S",GRACE="G R EY S",["PRYOR'S"]="P R AY ER Z",JEWELSBURG="JH UW AH L Z B ER G",PLUCKY="P L AH K IY",REMNICK="R EH M N IH K",SMITHEREEN="S M IH DH ER IY N",TANTALIZING="T AE N T AH L AY Z IH NG",REDDISH="R EH D IH SH",MCKINSTRY="M AH K IH N S T R IY",ILLEGAL="IH L IY G AH L",GERKE="G ER K IY",BARGAS="B AA R G AH Z",OUTPOST="AW T P OW S T",OILFIELDS="OY L F IY L D Z",BERKE="B ER K",YERKE="Y ER K",GUIDELINES="G AY D L AY N Z",FEUCHT="F OY K T",INFO="IH N F OW",NYGARD="N AY G ER D",EXPOSITIONS="EH K S P AH Z IH SH AH N Z",SACKVILLE="S AE K V IH L",["KOFLER(2)"]="K OW F L ER",["DADDY-O"]="D AE D IY OW",TRIPODI="T R IY P OW D IY",MALLOZZI="M AE L AA Z IY",KARDELL="K AA R D AH L",["DISADVANTAGE(2)"]="D IH S AH D V AE N IH JH",LYONNAIS="L IY AH N EY",MCMILLON="M AH K M IH L AH N",BARDELL="B AA R D EH L",CARDELL="K AA R D EY L",MEDUSA="M AH D UW S AH",ESTABLISHING="IH S T AE B L IH SH IH NG",MCMUFFIN="M AH K M AH F AH N",ORDINARILY="AO R D AH N EH R AH L IY",WARDELL="W AO R D EH L",SLINGS="S L IH NG Z",OVERDOSED="OW V ER D OW S T",LONELINESS="L OW N L IY N AH S",RINEHARDT="R AY N HH AA R T",DECLASSIFIED="D IH K L AE S AH F AY D",PROVO="P R OW V OW",RUSSIFICATION="R AH S AH F AH K EY SH AH N",FINESSED="F IH N EH S T",TRACE="T R EY S",SCHOENFELDT="SH OW N F EH L T",BROADRICK="B R AO D R IH K",ORBAN="AO R B AH N",IHRKE="IH R K",RAFTERS="R AE F T ER Z",NEWLYWEDS="N UW L IY W EH D Z",PEROVICH="P ER AH V IH CH",BAMBOO="B AE M B UW",LASHOMB="L AE SH AH M",MCELHENEY="M AE K AH L HH EY N IY",YIDDISH="Y IH D IH SH",CORDTS="K AO R D T S",LELLOUCHE="L EH L UW SH",ARTWORKS="AA R T W ER K S",BRUNCOR="B R AH N K AO R",CONSTIPATES="K AA N S T AH P EY T S",CLINGS="K L IH NG Z",MAXEY="M AE K S IY",FLINGS="F L IH NG Z",["CAPITAL(2)"]="K AE P IH T AH L",["TEMPERAMENTALLY(3)"]="T EH M P R AH M EH N AH L IY",GIROZENTRALE="G IH R OW Z AH N T R AA L",MINNS="M IH N Z",FINANCINGS="F AH N AE N S IH NG Z",BOUDOIR="B UW D OY R",ONSHORE="AA N SH AO R",FINNS="F IH N Z",["HIROSHIMA(2)"]="HH IH R OW SH IH M AH",["LENGTHEN(2)"]="L EH NG K TH AH N",["ENSURE(2)"]="IH N SH UH R",DERMATOLOGIST="D ER M AH T AA L AH JH IH S T",CINQUEMANI="CH IY N K W EH M AA N IY",VISCERALLY="V IH S ER AH L IY",CLIPPINGER="K L IH P IH NG ER",DEGIDIO="D IH JH IY D IY OW",HIRSHHORN="HH ER SH HH AO R N",SHADEGG="SH AE D EH G",EXTRATERRITORIALITY="EH K S T R AH T EH R AH T AO R IY AE L AH T IY",PROTUBERANCES="P R OW T UW B ER AH N S AH Z",REORGANIZING="R IY AO R G AH N AY Z IH NG",SURROUNDS="S ER AW N D Z",STIEFELHAGEN="S T IY F AH L HH EY G AH N",SARGIS="S AA R G IH S",["SHERWOOD'S"]="SH ER W UH D Z",CASTILLO="K AE S T IY OW",["PRESERVING(3)"]="P R IY Z ER V IH NG",LEBOW="L AH B OW",PEACE="P IY S",AFOREMENTIONED="AH F AO R M EH N SH AH N D",HARGIS="HH AA R G IH S",VNESHECONOMBANK="V AH N EH SH AH K AA N AH M B AE NG K",FREDLUND="F R EH D L AH N D",GARGIS="G AA R G IH S",BENTONVILLE="B EH N T AH N V IH L",STAGES="S T EY JH AH Z",SUSANNE="S UW Z AE N",WEGBREIT="W EH G B R AY T",["OSTLING(2)"]="AA S T L IH NG",INVASIVE="IH N V EY S IH V",MILLIRONS="M IH L ER OW N Z",TOSHIYUKI="T OW SH IH Y UW K IY",SPEECHES="S P IY CH AH Z",["BA'ATH"]="B AA TH",AMIDSHIPS="AH M IH D SH IH P S",["MIDDLE-CLASS"]="M IH D AH L K L AE S",BANGALA="B AA N G AA L AH",MCFAYDEN="M AH K F EY D AH N",SHORTING="SH AO R T IH NG",["LIMA(2)"]="L IY M AH",["TRUSLER(2)"]="T R AH S L ER",GORGONIAN="G AO R G OW N IY AH N",["STAMPEDED(2)"]="S T AE M P IY D IH D",["DATAPRODUCTS'(2)"]="D AE T AH P R AO D AH K T S",FREEMON="F R IY M AH N",["WHITER(2)"]="HH W AY T ER",PENNS="P EH N Z",["PANDORA'S"]="P AE N D AO R AH Z",CHILDRENS="CH IH L D R AH N Z",RAISINS="R EY Z AH N Z",PAINTERLY="P EY N T ER L IY",["ZIGLER(2)"]="Z AY G L ER",EISEMANN="AY S M AH N",TILGHMAN="T IH L M AH N",CHACE="CH EY S",["BIGLER(2)"]="B AY G L ER",TIPTOED="T IH P T OW D",OPPOSITIONS="AA P AH Z IH SH AH N Z",ORGANIZERS="AO R G AH N AY Z ER Z",["SIGLER(2)"]="S AY G L ER",["RIGLER(2)"]="R IH G L ER",POORLY="P UW R L IY",KEY_WEST="K IY W EH S T",["FIGLER(2)"]="F IH G L ER",UNANTICIPATED="AH N AE N T IH S AH P EY T IH D",RAFFETY="R AE F T IY",ARAMBULA="AA R AA M B UW L AH",CLEVA="K L IY V AH",EELLIKE="IY L L AY K",COLTSFOOT="K OW L T S F UH T",PICKETS="P IH K AH T S",PENTIMENTO="P EH N T IH M EH N T OW",ROOFTREE="R UW F T R IY",TICKETS="T IH K AH T S",BASEMENT="B EY S M AH N T",URDIALES="ER D IY EY L Z",BLALACK="B L AE L AH K",UNIMEDIA="Y UW N IH M IY D IY AH",SCHELLER="S K EH L ER",BURCHETTE="B ER SH EH T",PARETI="P EH R EH T IY",CONTEXTS="K AA N T EH K S T S",["(PARENTHESES"]="P ER EH N TH AH S IY Z",THERMOSTATS="TH ER M AH S T AE T S",REPUDIATING="R IY P Y UW D IY EY T IH NG",AFORESAID="AH F AO R S EH D",["CYBERSPACE'S"]="S AY B ER S P EY S IH Z",SUNDAYS="S AH N D EY Z",SWAROVSKI="S W AA R AA V S K IY",["UTHE(2)"]="AH TH",["BOISE'S"]="B OY Z IY Z",DUBUISSON="D AH B IH S AH N",BEEKEEPING="B IY K IY P IH NG",CARPETS="K AA R P AH T S",MANNS="M AE N Z",PLEVA="P L EY V AH",TORPOR="T AO R P ER",SOCKETS="S AA K AH T S",HOBAN="HH OW B AH N",ROCKETS="R AA K AH T S",["BAHRAIN'S(2)"]="B AY R EY N Z",POCKETS="P AA K AH T S",LIFO="L IY F OW",SOLVABLE="S AA L V AH B AH L",TELESCOPES="T EH L AH S K OW P S",VIBRANT="V AY B R AH N T",IMAGES="IH M AH JH AH Z",THIERY="TH IH R IY",["ACMAT'S"]="AE K M AE T S",MONDAYS="M AH N D IY Z",["TRIBUTE'S"]="T R IH B Y UW T S",DUBROW="D AH B R OW",WESEMANN="W IY Z M AH N",NOTIFICATION="N OW T AH F AH K EY SH AH N",SEQUINED="S IY K W AH N D",NOONTIME="N UW N T AY M",IMMOLATING="IH M AH L EY T IH NG",KLAGES="K L EY JH IH Z",["TISH'S"]="T IH SH IH Z",GRASSER="G R AE S ER",["GUMP'S"]="G AH M P S",BERNACKI="B ER N AA T S K IY",BONSALL="B OW N S AA L",GRUNDIG="G R AH N D IH G",DASHNAW="D AE SH N AO",["CONTAINERS'"]="K AH N T EY N ER Z",MOONLIGHT="M UW N L AY T",["TABLE'S"]="T EY B AH L Z",CAREUNITS="K EH R Y UW N IH T S",DRESDNER="D R EH Z D N ER",PEGASUS="P EH G AH S AH S",CORONET="K AO R AH N EH T",PERATIS="P ER AA T IH S",SCIASCIA="SH AO S CH AH",["CABLE'S"]="K EY B AH L Z",["NUNS'"]="N AH N Z",["SUFFIELD'S"]="S AH F IY L D Z",MIHALIK="M IH HH AH L IH K",TELECONFERENCING="T EH L AH K AA N F R AH N S IH NG",SEIGAL="S IY G AH L",HIBBEN="HH IH B AH N",STOCKBROKING="S T AA K B R OW K IH NG",MARLATT="M AA R L AH T",["AUDI'S(2)"]="AW D IY Z",DRIVES="D R AY V Z",BEEL="B IY L",FEEL="F IY L",DEEL="D IY L",KEEL="K IY L",HEEL="HH IY L",NEEL="N IY L",["SZE-DI"]="SH EY D IY",REEL="R IY L",BILLIPS="B IH L IH P S",PEEL="P IY L",TEEL="T IY L",TRICKETT="T R IH K IH T",CHARLESTOWN="CH AA R L S T AW N",TEBBEN="T EH B AH N",REDEDICATE="R IY D EH D AH K EY T",SUBCONTRACTORS="S AH B K AA N T R AE K T ER Z",LAMANNA="L AE M IH N AH",DEWALT="D UW AH L T",MCCRAE="M AH K R EY",PRICKETT="P R IH K IH T",KLUGER="K L UW G ER",LEGGETTE="L EH G EH T",TOSHIKI="T OW SH IY K IY",PARS="P AA R Z",SACCHARIN="S AE K ER AH N",MALTS="M AO L T S",VARS="V AA R Z",WARS="W AO R Z",ALLBRIGHT="AO L B R AY T",ARTEMUS="AA R T AH M AH S",HALTS="HH AO L T S",MARCKESANO="M AA R K EH S AA N OW",["DIRECTV(2)"]="D AY R EH K T IY V IY",["AERODYNAMICISTS(2)"]="EH R OW D AY N AE M IH S IH S",HIGHBROWS="HH AY B R AW Z",HABITAT="HH AE B AH T AE T",GOUGER="G AW JH ER",DRESSY="D R EH S IY",NEUTRALIZED="N UW T R AH L AY Z D",WALTS="W AO L T S",PETROLEAR="P EH T R OW L IH R",EDEL="EH D AH L",STEWS="S T UW Z",ADEL="AH D EH L",CRUGER="K R UW JH ER",DZOKHAR="JH OW K AA R",BERLANGA="B ER L AA NG G AH",KRUGER="K R UW G ER",PARRILLA="P AA R IH L AH",MASCARENAS="M AE S K ER IH N AH Z",JABALIYA="JH AA B AH L IY AH",MANDARINE="M AE N D ER IY N",CIARAMITARO="CH ER AA M IY T AA R OW",CARDIOLOGISTS="K AA R D IY AA L AH JH IH S T S",["EMPTY(2)"]="EH M T IY",KAEL="K EY L",["WHITEWATER'S"]="W AY T W AO T ER Z",SIVERTSEN="S IH V ER T S AH N",GAEL="G EY L",MCGIBBON="M AH G IH B AH N",RAEL="R EY L",["SELF-ENERGIZING"]="S EH L F EH N ER JH AY Z IH NG",STAHLE="S T EY HH AH L",EBEL="EH B AH L",["BURMA'S"]="B ER M AH Z",RECOMMEND="R EH K AH M EH N D",ABEL="EY B AH L",KLIMA="K L AY M AH",ORIENTED="AO R IY EH N T AH D",FUNNELED="F AH N AH L D",ULIMA="UW L IY M AH",LOBOSCO="L OW B OW S K OW",ALIMA="AA L IY M AH",BARS="B AA R Z",CARS="K AA R Z",EARS="IH R Z",GARS="G AA R Z",MAITLAND="M EY T L AH N D",JARS="JH AA R Z",["NONRESIDENTIAL(2)"]="N AA N R EH Z AH D EH N CH AH L",LARS="L AA R Z",MARS="M AA R Z",NARS="N AA R Z",OARS="AO R Z",SAVELY="S EY V L IY",PELTS="P EH L T S",PRESPLIT="P R IY S P L IH T",LAMBASTES="L AE M B AE S T S",["NOAH'S"]="N OW AH Z",CONFESSION="K AH N F EH SH AH N",MELTS="M EH L T S",SWEDISH="S W IY D IH SH",YELLOWER="Y EH L OW ER",GLUNT="G L AH N T",["BIBLE'S"]="B AY B AH L Z",ROBBEN="R AA B AH N",INTRIERI="IH N T R IH R IY",["MANAGERS'"]="M AE N AH JH ER Z",BLUNT="B L AH N T",["BRAUN'S"]="B R AO N Z",REMARKETING="R IY M AA R K AH T IH NG",SCLERODERMA="S K L IH R AH D ER M AH",["VIGNETTE(2)"]="V IY N Y EH T",["SYLVIO'S"]="S IH L V IY OW Z",CELTS="S EH L T S",BELTS="B EH L T S",["REQUEST(2)"]="R IY K W EH S T",MACRAE="M AH K R EY",SOMEBODY="S AH M B AA D IY",OPTS="AA P T S",SHOD="SH AA D",CONSUELA="K AH N S W EY L AH",NEANDERTHALS="N IY AE N D ER TH AO L Z",["POINSETTIAS(2)"]="P OY N S EH T AH Z",["NON-CATHOLICS"]="N AA N K AE TH L IH K S",CURVES="K ER V Z",MYELIN="M AY IH L IH N",ASSUMED="AH S UW M D",ARTIODACTYLS="AA R T IY OW D AE K T AH L Z",LASKOWSKI="L AH S K AO F S K IY",PURVES="P ER V Z",FOODARAMA="F UW D ER AE M AH",PIERIE="P IY EH R IY",TOTS="T AA T S",NOTS="N AA T S",ENCOUNTERED="IH N K AW N T ER D",POTS="P AA T S",KHAKI="K AA K IY",SHIMA="SH IY M AH",LOTS="L AA T S",HOTS="HH AA T S",DOTS="D AA T S",COTS="K AA T S",OVERSEER="OW V ER S IY ER",["EVANS'"]="EH V AH N Z",LAVELY="L EY V L IY",["LOANS'"]="L OW N Z",KILTS="K IH L T S",FINALCO="F IH N AE L K OW",GILTS="G IH L T S",SOOTHINGLY="S UW DH IH NG L IY",TILTS="T IH L T S",INSISTING="IH N S IH S T IH NG",WHITTIER="W IH T IY ER",ANGELONE="AA NG G EH L OW N IY",WARBLER="W AO R B L ER",WILTS="W IH L T S",DISCORD="D IH S K AO R D",SHUNT="SH AH N T",PURPOSELY="P ER P AH S L IY",DREILING="D R AY L IH NG",["MAJORITY'S"]="M AH JH AO R AH T IY Z",KREILING="K R AY L IH NG",CHARMER="CH AA R M ER",MCNEISH="M AH K N IY SH",["THOUSANDS(2)"]="TH AW Z AH N Z",COUNTERPUNCH="K AW N T ER P AH N CH",EILTS="AY L T S",DUGUAY="D AH G EY",KOLTS="K OW L T S",JOLTS="JH OW L T S",HOLTS="HH OW L T S",GUAVAS="G W AA V AH Z",DENATIONALIZE="D IH N AE SH AH N AH L AY Z",VOLTS="V OW L T S",LIVING="L IH V IH NG",JIVING="JH AY V IH NG",["GATWICK(2)"]="G EY T W IH K",DOUBTER="D AW T ER",DIVING="D AY V IH NG",THANKSGIVING="TH AE NG K S G IH V IH NG",HEBERLING="HH EH B ER L IH NG",MASCOTS="M AE S K AA T S",LERHMAN="L ER M AH N",["HAS-BEEN"]="HH AE Z B IH N",CAHOOT="K AH HH UW T",BROOKSVILLE="B R UH K S V IH L",COLTS="K OW L T S",BOLTS="B OW L T S",FOLTS="F OW L T S",["LENO'S"]="L EH N OW Z",SCHIAVO="S K IY AA V OW",FOSBACK="F AA S B AE K",REEXPORTS="R IY EH K S P AO R T S",["PENS'"]="P EH N Z",["GRANDMOTHER(2)"]="G R AE N M AH DH ER",ABETTED="AH B EH T IH D",TERRIFIES="T EH R AH F AY Z",WAGONER="W AE G AH N ER",DIAGRAMMED="D AY AH G R AE M D",BROOCH="B R UW CH",OSSWALD="AA S W AH L D",SALMELA="S AA L M EY L AH",JAROSZ="Y AA R AH SH",["RENO'S"]="R IY N OW Z",GUTS="G AH T S",["FOALE'S"]="F OW L Z",HUTS="HH AH T S",RAMPY="R AE M P IY",NUTS="N AH T S",RUTS="R AH T S",PUTS="P UH T S",AXILROD="AE K S IH L R AA D",LEIBOWITZ="L IY B OW IH T S",CAMPY="K AE M P IY",CUTS="K AH T S",CREAMERY="K R IY M ER IY",["PLANS'"]="P L AE N Z",OCTAHEDRAL="AA K T AH HH IY D R AH L",MESSIAH="M AH S AY AH",LINDENBERG="L IH N D AH N B ER G",["DERISIVELY(2)"]="D ER AY S IH V L IY",DANSVILLE="D AE N Z V IH L",["BANGLADESHI'S"]="B AE NG L AH D EH SH IY Z",REVUELTA="R AH V W EH L T AH",DESECRATES="D EH Z AH K R EY T S",BURNSIDE="B ER N S AY D",FULBRIGHT="F UH L B R AY T",ZYSKOWSKI="Z IH S K AO F S K IY",GEVING="JH IY V IH NG",ASSAILANT="AH S EY L AH N T",WRITHING="R AY DH IH NG",DAMOOSE="D AH M UW S",UNISOM="Y UW N AH S AA M",HARTLIEB="HH AA R T L IY B",OCONNOR="OW K AA N ER",PETRILLO="P EH T R IH L OW",CUBICLES="K Y UW B IH K AH L Z",["SOUTER(2)"]="S AW T ER",LONGTIME="L AO NG T AY M",MATURES="M AH CH UH R Z",["PINO'S"]="P IY N OW Z",NATURES="N EY CH ER Z",MISKITOS="M IH S K IY T OW S",ROSWALD="R AA S W AH L D",EWORLD="IY W ER L D",ECKERD="EH K ER D",["KOSMETSKY'S"]="K AA Z M EH T S K IY Z",ARTS="AA R T S",TRACI="T R EY S IY",CENTIPEDE="S EH N T IH P IY D",BOUGHAN="B AW AH N",CONSISTED="K AH N S IH S T AH D",MASSIF="M AE S IY F",GRACI="G R AA CH IY",POLITICIZATION="P AH L IH T AH S AH Z EY SH AH N",MCMAHILL="M AH K M EY HH IH L",["LEISURE(2)"]="L IY ZH ER",["UNLIMITED(2)"]="AH N L IH M IH T IH D",BARONET="B EH R AH N AH T",DASHIKI="D AH SH IY K IY",SAVING="S EY V IH NG",OTTS="AA T S",STEIDTMANN="S T AY T M AH N",HAVING="HH AE V IH NG",["BONO'S"]="B OW N OW Z",CAVING="K EY V IH NG",RAVING="R EY V IH NG",SYVERTSEN="S IH V ER T S AH N",PAVING="P EY V IH NG",["CANDY'S"]="K AE N D IY Z",MOHAMADI="M AH HH AA M AH D IY",CARRITHERS="K AE R IH DH ER Z",REBUFFING="R IY B AH F IH NG",STELLJES="S T EY L Y EH S",MACLIN="M AE K L AH N",DIAMOND="D AY M AH N D",["RANDY'S"]="R AE N D IY Z",["TANDY'S"]="T AE N D IY Z",HEMPHILL="HH EH M P HH IH L",NUTRITIONISTS="N UW T R IH SH AH N IH S T S",HEZBULLAH="HH EH Z B AA L AH",["FANS'"]="F AE N Z",HOWDESHELL="HH AW D IH SH EH L",NUMERICAL="N UW M EH R AH K AH L",["KRAJINA(2)"]="K R AY IY N AH",CHERTOFF="CH ER T AA F",["COMPLEXITY(2)"]="K AH M P L EH K S IH T IY",SAMARIN="S AA M AA R IY N",["COLTRANE'S"]="K OW L T R AH N Z",SCIFRES="S AY F ER Z",MAORIS="M EY ER IH S",IWAKI="AY W AA K IY",NATURALISTIC="N AE CH ER AH L IH S T IH K",SELJUK="S EH L JH AH K",KUENHEIM="K Y UW AH N HH AY M",MCREYNOLDS="M AH K R EY N AH L D Z",ABHORRENCE="AH B HH AO R AH N S",MOLENAAR="M AA L IH N AA R",EVICTED="IH V IH K T IH D",HABBEN="HH AE B AH N",HOLYOKE="HH OW L IY OW K",IDOL="AY D AH L",BROWNOUT="B R AW N AW T",PETRELLA="P EH T R EH L AH",["DURHAM(2)"]="D UH R HH AE M",["EMBEZZLING(3)"]="IH M B EH Z L IH NG",DAUS="D AO Z",SERVES="S ER V Z",BAUS="B AO Z",LARGER="L AA R JH ER",KARGER="K AA R G ER",REARDEN="R IH R D AH N",["SONS'"]="S AA N Z",EXPECTANT="IH K S P EH K T AH N T",ROLLICKING="R AA L IH K IH NG",NERVES="N ER V Z",SAUS="S AO Z",["INNS'"]="IH N Z",BARGER="B AA R JH ER",ROGGENKAMP="R AA G IH N K AE M P",MAUS="M AO Z",NAUS="N AO Z",PERKOWSKI="P ER K AO F S K IY",GARGER="G AA R G ER",FINGERPRINTED="F IH NG G ER P R IH N T IH D",OLIGARCHY="AA L AH G AA R K IY",HAUS="HH AW S",["PAINTER(2)"]="P EY N ER",OURSELVES="AW ER S EH L V Z",DIRHAMS="D ER AH M Z",EARTHSHAKING="ER TH SH EY K IH NG",AIRSPEED="EH R S P IY D",PASCAGOULA="P AE S K AH G UW L AH",["LIKUD(2)"]="L IY K UW D",MUIRFIELD="M Y UH R F IY L D",["NULAND(2)"]="N UW L AH N D",TAIMA="T AY M AH",CHRISTENBERRY="K R IH S AH N B EH R IY",BOYISH="B OY IH SH",REITERATING="R IY IH T ER EY T IH NG",ODDSMAKER="AA D Z M EY K ER",LAUTZENHEISER="L AW T Z AH N HH AY Z ER",GLANZMAN="G L AE N Z M AH N",CONLOW="K AA N L OW",MURVEIT="M ER V IY T",TECTONICS="T EH K T AA N IH K S",ALTIPLANO="AE L T AH P L AA N OW",EGGENBERGER="EH G AH N B ER G ER",OVERPAYING="OW V ER P EY IH NG",CARBURETOR="K AA R B ER EY T ER",PUTZIER="P AH T Z IY ER",["MINERALS'"]="M IH N ER AH L Z",DEARDEN="D IH R D AH N",["CINEPLEX'S"]="S IH N AH P L EH K S IH Z",THUS="DH AH S",["O'DONOGHUE"]="OW D AA N AH HH UW",WEARINESS="W IH R IY N AH S",GRIZZLIES="G R IH Z L IY Z",LAIBOWITZ="L EY B AH W IH T S",MERGER="M ER JH ER",COVALT="K OW V AA L T",CHEESECAKE="CH IY Z K EY K",BONCZEK="B AA N CH EH K",YERGER="Y ER JH ER",["CINDY'S"]="S IH N D IY Z",ICARUS="IH K ER AH S",BERGER="B ER G ER",GERGER="G ER G ER",CALTHA="K AE L DH AH",["SCIENTISTS(2)"]="S AY N T IH S T S",SOMERSET="S AH M ER S EH T",JERGER="JH ER G ER",HOAGLAND="HH OW G L AH N D",["WHAM(2)"]="HH W AE M",BURRIS="B ER IH S",["OCCASIONALLY(3)"]="AH K EY ZH AH N L IY",HOUSDEN="HH AW S D AH N",BLASINGAME="B L AA S IH NG G AA M IY",MIKULICH="M IH K UW L IH CH",PELLERITO="P EH L ER IY T OW",PREYISTA="P R EY IH S T AH",PEARSALL="P EH R S AO L",HORGER="HH AO R G ER",FORGER="F AO R JH ER",PICHON="P IH CH AH N",MEIKLE="M IY K AH L",MICHON="M IH CH AH N",KOZAKIEWICZ="K AH Z AA K AH V IH CH",UNRELIEVED="AH N R IY L IY V D",SYNTHESIZING="S IH N TH AH S AY Z IH NG",["NUNO'S"]="N UW N OW Z",["BORDA'S"]="B AO R D AH Z",BORGER="B AO R G ER",TOLD="T OW L D",HARBORSIDE="HH AA R B ER S AY D",CLELLAND="K L EH L AH N D",MULTIPART="M AH L T IY P AA R T",WOLD="W OW L D",OLYMPIAD="OW L IH M P IY AE D",MOLD="M OW L D",MOUSETRAP="M AW S T R AE P",EFFORTS="EH F ER T S",WESTLAND="W EH S T L AH N D",TRIPPEL="T R IH P AH L",NOLD="N OW L D",["GOODEN'S"]="G UH D AH N Z",HILD="HH IH L D",GILD="G IH L D",BILD="B IH L D",SEEGMILLER="S IY G M IH L ER",["MOTORS'"]="M OW T ER Z",PHONED="F OW N D",DRAGNETS="D R AE G N EH T S",SPACESUITS="S P EY S UW T S",NOTETAKER="N OW T T EY K ER",THURMOND="TH ER M AH N D",SIELOFF="S IY L AO F",TETRADS="T EH T R AE D Z",PASSBOOK="P AE S B UH K",["CYCLISTS(2)"]="S AY K L IH S T S",AFTERTASTES="AE F T ER T EY S T S",["MICROSOFT'S(2)"]="M AY K R OW S AO F S",["CONTESTS(3)"]="K AA N T EH S",CANVASSERS="K AE N V AH S ER Z",SEMIFINISH="S EH M IY F IH N IH SH",SCHLESINGER="SH L EH S IH N JH ER",JEWISH="JH UW IH SH",COLD="K OW L D",BOLD="B OW L D",CODLIN="K AA D L IH N",HIVELY="HH AY V L IY",GOLD="G OW L D",FOLD="F OW L D",EMANCIPATING="IH M AE N S AH P EY T IH NG",DEQUEKER="D IH K W EH K ER",["KOBERSTEIN(2)"]="K OW B ER S T IY N",PRUSINSKI="P R AH S IH N S K IY",KRUSINSKI="K R AH S IH N S K IY",["DOBERSTEIN(2)"]="D OW B ER S T IY N",MODLIN="M AA D L IH N",KIEVAN="K IY V AH N",HASS="HH AE S",KASS="K AE S",JASS="JH AE S",MASS="M AE S",LASS="L AE S",NASS="N AE S",PASS="P AE S",SASS="S AE S",TASS="T AE S",ALBERTO="AE L B ER T OW",EASTLAND="IY S T L AH N D",STOCKEL="S T AA K AH L",["CARA'VERAS"]="K AA R AH V EH R AH Z",DRONED="D R OW N D",ESTRELLA="EH S T R EH L AH",["PRESSER'S"]="P R EH S ER Z",CLUSTERED="K L AH S T ER D",INORDINATELY="IH N AO R D AH N AH T L IY",STANALAND="S T AE N AH L AH N D",FLUSTERED="F L AH S T ER D",STONED="S T OW N D",JAGDISH="JH AE G D IH SH",["PRINTER(2)"]="P R IH N ER",NONJET="N AA N JH EH T",GINDIN="G IH N D IH N",["PLAZA'S(2)"]="P L AE Z AH Z",EXTINGUISHMENT="IH K S T IH NG G W IH SH M AH N T",["CONAGRA'S"]="K AA N AE G R AH Z",CASS="K AE S",BASS="B AE S",DASS="D AE S",GASS="G AE S",FASS="F AE S",TWIDDLING="T W IH D L IH NG",["CHENEY'S"]="CH EY N IY Z",MUTATIONS="M Y UW T EY SH AH N Z",MADL="M AE D AH L",WILD="W AY L D",OROGIL="AO R OW G IH L",HILLARY="HH IH L ER IY",MILD="M AY L D",LASTRAPES="L AA S T R AA P EH S",STREAKER="S T R IY K ER",ROBERTO="R AH B EH R T OW",KLIPPEL="K L IH P AH L",DEFOLIANTS="D IH F OW L IY AH N T S",TRIXY="T R IH K S IY",AVATARS="AE V AH T AA R Z",NARUHITO="N AA R UW HH IY T OW",HUCKEBA="HH AH K IH B AH",CHURCHYARD="CH ER CH Y AA R D",["AGRESOURCE(2)"]="AE G R AH S AO R S",MISCREANTS="M IH S K R IY AH N T S",VACHON="V AE CH AH N",MAQUILADORAS="M AE K IY Y AH D AO R AH S",ACAMPORA="AH K AE M P ER AH",DROUGHT="D R AW T",BROUGHT="B R AO T",["O'SHELL"]="OW SH EH L",PALMERTON="P AA M ER T AH N",INCINERATION="IH N S IH N ER EY SH AH N",ROTATIONS="R OW T EY SH AH N Z",PASCUAL="P AE S K UW AH L",BUSHEL="B UH SH AH L",NOTATIONS="N OW T EY SH AH N Z",KLIGMAN="K L IH G M AH N",HIDEOUSLY="HH IH D IY AH S L IY",MEND="M EH N D",LEND="L EH N D",SEND="S EH N D",EQUALIZING="IY K W AH L AY Z IH NG",SHOTS="SH AA T S",RAGWEED="R AE G W IY D",TEND="T EH N D",TIGERA="T IH JH EH R AH",["LIGHTING'S"]="L AY T IH NG Z",RALEIGH="R AO L IY",["GOODYEAR(2)"]="G UH D Y IY R",["FIGHTING'S"]="F AY T IH NG Z",EMINENCE="EH M AH N AH N S",BLENHEIM="B L EH N HH AY M",["DESECRATES(2)"]="D EH S AH K R EY T S",SORBO="S AO R B OW",MURKOWSKI="M ER K AW S K IY",SHERTZER="SH ER T Z ER",RECRUITS="R AH K R UW T S",RECUPERATING="R IH K UW P ER EY T IH NG",["FERRARO'S"]="F ER AA R OW Z",BEND="B EH N D",ERVING="ER V IH NG",FEND="F EH N D",["LAUNCHES(2)"]="L AO N CH IH Z",ROBL="R AA B AH L",WROUGHT="R AO T",GOLEMBESKI="G AH L IH M B EH S K IY",OSTROSKI="AH S T R AW S K IY",LAURITZEN="L AW R IH T Z AH N",AFTERIMAGES="AE F T ER IH M IH JH AH Z",OUTSTRETCH="AW T S T R EH CH",BURLINGTON="B ER L IH NG T AH N",FALLACIOUSLY="F AH L EY SH AH S L IY",HOVING="HH OW V IH NG",MOVING="M UW V IH NG",LOVING="L AH V IH NG",CANTERBURY="K AE N T ER B EH R IY",ROVING="R OW V IH NG",CLOTS="K L AA T S",BLOTS="B L AA T S",PRIMA="P R IY M AH",["CABBAGE(2)"]="K AE B IH JH",UNREPORTED="AH N R IY P AO R T IH D",["ORMOND'S"]="AO R M AH N D Z",GRIMA="G R IY M AH",ELVING="EH L V IH NG",MAGDA="M AE G D AH",["REALTY(3)"]="R IY L T IY",LAND="L AE N D",PLOTS="P L AA T S",HAND="HH AE N D",SANDIN="S AE N D IH N",MACLACHLAN="M AH K L AE K L AH N",SAND="S AE N D",RAND="R AE N D",IMPEDES="IH M P IY D Z",SONNENBERG="S AA N AH N B ER G",ZAND="Z AE N D",WAND="W AA N D",CORBO="K AO R B OW",SKYBOXES="S K AY B AA K S IH Z",CIRCULATES="S ER K Y AH L EY T S",LANDIN="L AE N D IH N",PREFERABLE="P R EH F ER AH B AH L",BURGER="B ER G ER",MOSHE="M OW SH EH",DEVISING="D IH V AY Z IH NG",["KAZAKHSTANA(2)"]="K AH Z AE K S T AE N AH",BRIDGEFORTH="B R IH JH F AO R TH",TUMAZOS="T UW M AA Z OW S",MARKOWSKI="M ER K AO F S K IY",SAFEKEEPING="S EY F K IY P IH NG",REVISING="R IH V AY Z IH NG",KNOTS="N AA T S",TARKOWSKI="T ER K AO F S K IY",BAND="B AE N D",PURCHASING="P ER CH AH S IH NG",["PROCEEDINGS(2)"]="P R AH S IY D IH NG Z",LEADBELLY="L EH D B EH L IY",DOCENTS="D OW S AH N T S",["JOURNAL'S"]="JH ER N AH L Z",SHANSEV="SH AE N S EH V",AZALEA="AH Z EY L Y AH",HOBOES="HH OW B OW Z",TAMPON="T AE M P AA N",REMARRIED="R IY M EH R IY D",["YOGIISM(2)"]="Y OW G IH S AH M",HELLACIOUSLY="HH EH L EY SH AH S L IY",BOTTGER="B AA T G ER",LEADVILLE="L EH D V IH L",INTERSCOPE="IH N T ER S K OW P",SYNCHRONIZED="S IH NG K R AH N AY Z D",["MEMO'S"]="M EH M OW Z",OVERWORKING="OW V ER W ER K IH NG",LOGISTICAL="L AH JH IH S T IH K AH L",VIRTUOUS="V ER CH UW AH S",["MERGER'S"]="M ER JH ER Z",RANCID="R AE N S IH D",IANOVSKI="Y AH N AA V S K IY",HEROINE="HH EH R OW AH N",SHAKUNAGA="SH AA K UW N AA G AH",MADLIN="M AE D L IH N",["WHIRRING(2)"]="HH W ER IH NG",["BERGER'S"]="B ER G ER Z",MOBILIA="M OW B IY L IY AH",WILKIS="W IH L K IH S",FEVERED="F IY V ER D",CANNAVO="K AA N AA V OW",["GRISHAM'S"]="G R IH SH AH M Z",BACKHOES="B AE K HH OW Z",["PROTESTS(3)"]="P R AH T EH S T S",ANTISUBMARINE="AE N T IH S AH B M ER IY N",["ALLIANZ'S"]="AE L IY AH N Z IH Z",DOUDS="D AW D Z",RAMTHA="R AE M TH AH",LILLEHAMER="L IH L IY HH AE M ER",SPEIGNER="S P AY G N ER",ADOPTING="AH D AA P T IH NG",RICOCHET="R IH K AH SH EY",BRIGMAN="B R IH G M AH N",EARNHEART="ER N HH AA R T",FEDERER="F EH D ER ER",SYMPATHY="S IH M P AH TH IY",FIBRILES="F AY B R IH L Z",HOMOZYGOUS="HH OW M OW Z AY G AH S",LEDERER="L EH D ER ER",["IRAQI'S"]="IH R AE K IY Z",PERFUME="P ER F Y UW M",DREADNOUGHT="D R EH D N AO T",COOKSTON="K UH K S T AH N",["WREATHS(2)"]="R IY DH Z",KRASOWSKI="K R AH S AO F S K IY",DUCHON="D AH CH AH N",KUYPER="K AY P ER",BACKACHE="B AE K EY K",SEWING="S OW IH NG",RISHEL="R IH SH AH L",FISHEL="F IH SH AH L",LEWING="L UW IH NG",EDWARDIAN="EH D W AO R D IY AH N",UNWILLING="AH N W IH L IH NG",AULD="AO L D",["SYDNEY'S"]="S IH D N IY Z",TAUNT="T AO N T",["ACTORS'"]="AE K T ER Z",MEDLIN="M EH D L IH N",FULD="F UH L D",REDLIN="R EH D L IH N",FLORIS="F L AO R IH S",OBSESSES="AH B S EH S IH Z",BOXED="B AA K S T",KURKOWSKI="K ER K AO F S K IY",JAUNT="JH AO N T",GAZAWAY="G AA Z AH W EY",LAWHORN="L AE W ER N",DAUNT="D AO N T",HAUNT="HH AO N T",SQUEEZES="S K W IY Z IH Z",["DIVERSION(2)"]="D IH V ER ZH AH N",TRANSFORMATION="T R AE N S F ER M EY SH AH N",CALDRELLO="K AA L D R EH L OW",NIXED="N IH K S T",SIXED="S IH K S T",SPADACCINI="S P AA D AA CH IY N IY",["INFANTS'"]="IH N F AH N T S",WINGBACK="W IH NG B AE K",FIXED="F IH K S T",MIXED="M IH K S T",STELOFF="S T EH L AO F",DELUCIA="D EH L UW CH AH",POINSETTIAS="P OY N S EH T IY AH Z",VAILLANCOURT="V EY L AH N K AO R T",GENTLES="JH EH N T AH L Z",DEWING="D UW IH NG",TORTUOUS="T AO R CH AH W AH S",HEWING="HH Y UW IH NG",MCGAHEE="M AH G AE HH IY",["MITSUI'S"]="M IY T S UW IY Z",SIBILIA="S IY B IY L IY AH",["MARTHA'S"]="M AA R TH AH Z",SHUFFLER="SH AH F AH L ER",PENNED="P EH N D",["WHISENANT(2)"]="HH W IH S IH N AH N T",HEAVILY="HH EH V AH L IY",STENDIG="S T EH N D IH G",COMMUNE="K AA M Y UW N",["COOPERATE(2)"]="K W AA P ER EY T",FULTS="F UH L T S",OKUBO="OW K UW B OW",HULTS="HH AH L T S",MERS="M ER Z",["QUARTERBACKS(2)"]="K AO R T ER B AE K S",PERS="P ER S",PAWING="P AO IH NG",CENITH="S EH N IH TH",GRABAU="G R AE B AW",LAWING="L AO IH NG",SCHLICHT="SH L IH K T",SAWING="S AO IH NG",CALLEBS="K EY L EH B Z",OBSERVATION="AA B Z ER V EY SH AH N",LUNDIN="L AH N D IH N",CREEKMUR="K R IY K M ER",ZENITH="Z IY N AH TH",OREILLY="AO R AH L IY",DUCTILE="D AH K T AH L",REPRISAL="R IY P R AY Z AH L",ERASMUS="IH R AE Z M AH S",["GARCETTI'S"]="G AA R CH EH T IY Z",SHAMELESS="SH EY M L AH S",RESERVATION="R EH Z ER V EY SH AH N",STAGGER="S T AE G ER",ENFORCING="EH N F AO R S IH NG",HARDINGER="HH AA R D IH NG ER",POWELSON="P AW AH L S AH N",CONTEMPORANEOUSLY="K AH N T EH M P ER EY N IY AH S L IY",NEUTRALLY="N UW T R AH L IY",VEXED="V EH K S T",SEXED="S EH K S T",DISTURBING="D IH S T ER B IH NG",ROCHON="R AA CH AH N",["MICHELIN(2)"]="M IH SH L AH N",GAUZE="G AO Z",LOVELY="L AH V L IY",["PRODUCTIONS(3)"]="P ER D AH K SH AH N Z",MESSERSMITH="M EH S ER S M IH TH",POMPON="P AA M P AA N",NEXRAD="N EH K S R AE D",FORNAL="F AO R N AH L",INCHON="IH N CH AO N",JORNAL="JH AO R N AH L",MANTLES="M AE N T AH L Z",HAWING="HH AO IH NG",GUARANI="G W AA R AH N IY",TANNED="T AE N D",["ALTZHEIMER'S"]="AA L T S HH AY M ER Z",MARCHAL="M AA R CH AH L",MANNED="M AE N D",PANNED="P AE N D",RANCOURT="R AH N K AO R T",MASSAGED="M AH S AA ZH D",["ANTHROPOLOGISTS(2)"]="AE N TH R AH P AA L AH JH IH S T S",HERS="HH ER Z",DUNCOMBE="D AH NG K AH M",FINANCER="F AY N AE N S ER",BANNED="B AE N D",WOODBERRY="W UH D B EH R IY",ONETIME="W AH N T AY M",CANNED="K AE N D",LAREDO="L ER EY D OW",FIGUEROA="F IY G EH R OW AH",DISSEMINATED="D IH S EH M AH N EY T AH D",LILITH="L IH L IH TH",RUBERTO="R UW B EH R T OW",DASHEL="D AE SH AH L",REFORMATORIES="R IH F AO R M AH T AO R IY Z",MCALINDEN="M AH K L IH N D AH N",ANACOSTIA="AE N AH K AA S T IY AH",["FRERE(2)"]="F R IH R",MOTHBALLS="M AO TH B AO L Z",PAREDO="P AH R EY D OW",OLIPHANT="AA L IH F AH N T",HUBERTO="HH UW B EH R T OW",ELOQUENCE="EH L AH K W AH N S",SWAGGER="S W AE G ER",BLAMELESS="B L EY M L AH S",HYBL="HH IH B AH L",MEMORABLY="M EH M ER AH B L IY",EVERLAST="EH V ER L AE S T",TERMINATING="T ER M AH N EY T IH NG",["MONDALE'S"]="M AA N D EY L Z",PASTORS="P AE S T ER Z",REVERED="R IH V IH R D",SEVERED="S EH V ER D",MAXED="M AE K S T",MORZE="M AO R Z",["CORPS'"]="K AO R Z",WAXED="W AE K S T",TAXED="T AE K S T",TOURNEY="T ER N IY",BELTRAM="B EH L T R AE M",INTERCEPTED="IH N T ER S EH P T AH D",JOURNEY="JH ER N IY",CLARIFIED="K L EH R AH F AY D",FUJIO="F UW JH IY OW",["DIOS'"]="D IY OW S",ZINFANDEL="Z IH N F AH N D EH L",WESTERHOFF="W EH S T ER HH AO F",REGISTER="R EH JH IH S T ER",["MOORCO(2)"]="M AO R K OW",PERCUSSION="P ER K AH SH AH N",FIRS="F ER Z",REEVALUATION="R IY IH V AE L Y UW EY SH AH N",AIRS="EH R Z",FAXED="F AE K S T",SAUCONY="S AO K AH N IY",CONVERSES="K AA N V ER S AH Z",BETS="B EH T S",MCPHEETERS="M AH K F IY T ER Z",GETS="G EH T S",HOLLOW="HH AA L OW",JETS="JH EH T S",ORGANUM="AO R G AH N AH M",MORPHIN="M AO R F AH N",["EARRING(2)"]="IY R IH NG",NETS="N EH T S",METS="M EH T S",LETS="L EH T S",CAROSI="K ER OW S IY",LIBERTO="L IY B EH R T OW",MCELDOWNEY="M AE K AH L D AW N IY",PETS="P EH T S",STANBERRY="S T AE N B EH R IY",HAMPE="HH AE M P",HARASSED="HH ER AE S T",WITTINGLY="W IH T IH NG L IY",["HEMDALE'S"]="HH EH M D EY L Z",ORTHOCLASE="AO R TH AH K L EY S",EUROPIUM="Y UH R OW P IY AH M",OLIVETTE="AA L IH V EH T",WILPON="W IH L P AA N",LACIVITA="L AA CH IY V IY T AH",GUNNED="G AH N D",SUBMERSION="S AH B M ER ZH AH N",ICENHOWER="IH S AH N HH AW ER",TINKLE="T IH NG K AH L",HINKLE="HH IH NG K AH L",["UENO(2)"]="UW EY N OW",FINKLE="F IH NG K AH L",RELEVANT="R EH L AH V AH N T",THOUGHT="TH AO T",DUNNED="D AH N D",SINNED="S IH N D",MACTAVISH="M AH K T AE V IH SH",PINNED="P IH N D",BJELLAND="B Y EH L AH N D",PLAYTEX="P L EY T EH K S",MISTRAL="M IH S T R AH L",UNDERLING="AH N D ER L IH NG",FOREWARN="F AO R W AO R N",JOBYNA="Y AH B IY N AH",BERTELSMANN="B ER T AH L Z M AH N",CARABALLO="K AE R AH B AE L OW",ACCOUTERMENTS="AH K UW T ER M AH N T S",ACQUISITIVE="AH K W IH Z AH T IH V",SANTORELLI="S AA N T AO R EH L IY",GIRDS="G ER D Z",["ROYCE'S"]="R OY S IH Z",EGBERTA="EY G B EH R T AH",["SEWARD'S"]="S UW ER D Z",["BASEBALL'S"]="B EY S B AO L Z",["JOYCE'S"]="JH OY S IH Z",JOSTEN="JH AA S AH N",COSTEN="K AO S T AH N",ROSTEN="R AA S AH N",POSTEN="P OW S T AH N",["GORBACHEV'S"]="G AO R B AH CH EH V Z",QUILMES="K W IH L M Z",DIATRIBE="D AY AH T R AY B",["AWFULLY(2)"]="AO F AH L IY",GALOSHES="G AH L AA SH AH Z",LAROUCHE="L AA R UW SH",CALCOTE="K AA L K OW T IY",ABTS="AE B T S",MOUTHPIECE="M AW TH P IY S",MARTORANO="M AA R T AO R AA N OW",SHIRL="SH ER L",MARJIE="M AA R JH IY",["WOODY'S"]="W UH D IY Z",VANDEWALLE="V AE N D UW EY L",PROLONG="P R AH L AO NG",["MOODY'S"]="M UW D IY Z",EMINENTLY="EH M AH N AH N T L IY",["NANO(2)"]="N AE N OW",["GOODY'S"]="G UH D IY Z",TANDEM="T AE N D AH M",HENKLE="HH EH NG K AH L",ACTS="AE K T S",RELENTED="R IH L EH N T IH D",["BUZZARD'S"]="B AH Z ER D Z",SUNLITE="S AH N L AY T",PAULHAMUS="P AO L HH EY M AH S",WEMBLEY="W EH M B L IY",BRIGGSTONE="B R IH G S T OW N",SHELLHORN="SH EH L HH ER N",["HADN'T"]="HH AE D AH N T",["BRODY'S"]="B R OW D IY Z",SPECTACULARLY="S P EH K T AE K Y AH L ER L IY",ESCARPMENTS="EH S K AA R P M AH N T S",NERDS="N ER D Z",SHEPHERD="SH EH P ER D",CORUNDUM="K ER AH N D AH M",BEKKI="B EH K IY",GIANFRANCESCO="JH AA N F R AE N CH EH S K OW",NUCLEOTIDE="N UW K L IY AH T AY D",HERDS="HH ER D Z",HALLINAN="HH AE L IH N AH N",TELAMON="T EH L AH M AH N",CULTIVATED="K AH L T AH V EY T IH D",CARPETING="K AA R P AH T IH NG",MATTINGLY="M AE T IH NG L IY",DOGFIGHT="D AA G F AY T",STOL="S T OW L",COPYRIGHTED="K AA P IY R AY T IH D",HAMMOND="HH AE M AH N D",LAMMOND="L AE M AH N D",MACCHIA="M AE K IY AH",IMPASSIVE="IH M P AE S IH V",["SURVEY'S"]="S ER V EY Z",CALTAGIRONE="K AA L T AA JH IH R OW N IY",DOUBTERS="D AW T ER Z",["HARBOR'S"]="HH AA R B ER Z",["EMBASSY'S"]="EH M B AH S IY Z",MCCALLIE="M AH K AO L IY",RIBERA="R IY B EH R AH",["INSTITUTION'S"]="IH N S T IH T UW SH AH N Z",GILMOUR="ZH IH L M UH R",DOMAINS="D OW M EY N Z",FRECKLES="F R EH K AH L Z",CONTEMPO="K AA N T EH M P OW",BONTEMPO="B AA N T EH M P OW",["DOMENICI'S(2)"]="D OW M IH N IY CH IY Z",GALLARDO="G AA L AA R D OW",PYRENEES="P IH R AH IY Z",CORRESPONDS="K AO R AH S P AA N D Z",INERTIA="IH N ER SH AH",WRESTLERS="R EH S L ER Z",["ECHO'S"]="EH K OW Z",FEDERALIZED="F EH D ER AH L AY Z D",HESITATING="HH EH Z AH T EY T IH NG",TRICKIER="T R IH K IY ER",["HAMELIN(2)"]="HH AE M L IH N",["GAMELIN(2)"]="G AE M L IH N",CHEWS="CH UW Z",COUPER="K UW ER",EXPROPRIATED="EH K S P R OW P R IY EY T IH D",["SHAKESPEARE'S"]="SH EY K S P IY R Z",MERTEN="M ER T AH N",CHAVITZ="CH AE V IH T S",ROBERTA="R AH B ER T AH",BLESSEDNESS="B L EH S AH D N AH S",["POINTED(3)"]="P OY N T IH D",HORSETAIL="HH AO R S T EY L",DISSECTING="D AY S EH K T IH NG",ANDUJAR="AA N D UW Y AA R",FRAZZLED="F R AE Z AH L D",DISCRIMINATIVE="D IH S K R IH M AH N AH T IH V",SEEDLINGS="S IY D L IH NG Z",EMPIRICIST="IH M P IH R AH S AH S T",INDONESIAN="IH N D OW N IY ZH AH N",TECHNO="T EH K N OW",DONNED="D AA N D",RAINBOW="R EY N B OW",INTERPRETATIONS="IH N T ER P R IH T EY SH AH N Z",BHAGWAN="B AA G W AA N",TALTOS="T AA L T OW Z",["JOINTED(3)"]="JH OY N IH D",FABULOUSLY="F AE B Y UW L AH S L IY",SADAKO="S AA D AA K OW",RECCHIA="R EH K IY AH",SECCHIA="S EH K IY AH",WANTONLY="W AO N T AH N L IY",ELBERTA="EH L B EH R T AH",KEMPE="K EH M P",["IRAQGATE(2)"]="IY R AA K G EY T",ALBERTA="AE L B ER T AH",BRUYNES="B R UW IH N Z",WEMPE="W EH M P",PRONOUNCING="P R AH N AW N S IH NG",MCFERRAN="M AH K F EH R AH N",TEMPE="T EH M P IY",REMPE="R EH M P",MASOCHIST="M AE S AH K IH S T",EROL="EH R AH L",KROL="K R AO L",["NINO(2)"]="N IY N Y OW",FRANKINO="F R AE NG K IY N OW",ESPERANTO="EH S P ER AE N T OW",SALVATI="S AA L V AA T IY",["PRINTED(3)"]="P R IH N AH D",SUBSET="S AH B S EH T",LEITMOTIF="L AY T M OW T IY F",CRANBERRY="K R AE N B EH R IY",COMMUNICATING="K AH M Y UW N AH K EY T IH NG",GRIEVANCE="G R IY V AH N S",COOL="K UW L",HEARTIER="HH AA R T IY ER",INTERFAITH="IH N T ER F EY TH",FOOL="F UW L",KOOL="K UW L",IDIOT="IH D IY AH T",["HALCION'S"]="HH AE L S IY AH N Z",POOL="P UW L",LICKETY="L IH K AH T IY",ARBITRATED="AA R B AH T R EY T IH D",TOOL="T UW L",WOOL="W UH L",TRIVETTE="T R IH V EH T",SUNS="S AH N Z",RUNS="R AH N Z",CHILLICOTHE="CH IH L IH K AO TH",LEASEBACKS="L IY S B AE K S",MUNS="M AH N Z",KUNS="K AH N Z",PUNS="P AH N Z",NUNS="N AH N Z",QUESTIONS="K W EH S CH AH N Z",DUNS="D AH N Z",BUNS="B AH N Z",GUNS="G AH N Z",FUNS="F AH N Z",THEBERGE="TH EH B ER JH",["CHITRA'S"]="CH IH T R AH Z",SOOTS="S UH T S",TOOTS="T UW T S",SILENCE="S AY L AH N S",["WALTERS'"]="W AO L T ER Z",COMBUSTION="K AH M B AH S CH AH N",IMPERSONATORS="IH M P ER S AH N EY T ER Z",REMINISCE="R EH M AH N IH S",PENNOCK="P EH N AH K",["ESSENTIAL(3)"]="AH S EH N CH AH L",REDISPLAY="R IY D IH S P L EY",ILLUSORY="IH L UW S ER IY",DEBRIEFING="D IH B R IY F IH NG",POWERED="P AW ER D",GAYDAR="G EY D AA R",HAIDA="HH AY D AH",ZOBRIST="Z AA B R IH S T",TONS="T AH N Z",SPOTS="S P AA T S",VONS="V AA N Z",["MULRONEY'S"]="M AH L R OW N IY Z",ARISTOTLE="EH R AH S T AA T AH L",["CALMED(2)"]="K AA L M D",AMIOT="EY M IY AH T",WHEELWRITER="W IY L R AY T ER",["TELEPHONE'S"]="T EH L AH F OW N Z",EONS="IY AH N Z",DONS="D AA N Z",FONS="F AA N Z",IONS="AY AH N Z",HONS="HH AA N Z",NUHFER="N UW F ER",LONS="L AA N Z",UNICYCLES="Y UW N AH S AY K AH L Z",PONS="P AA N Z",SONS="S AH N Z",LILYAN="L IH L IY AH N",["BIBI'S(2)"]="B IY B IY Z",CONS="K AA N Z",TALENTED="T AE L AH N T AH D",ENNS="EH N Z",INNS="IH N Z",TUNEUP="T UW N AH P",HEALTHDYNE="HH EH L TH D AY N",STULTIFY="S T AH L T AH F AY",INSIDERS="IH N S AY D ER Z",CITATIONS="S AY T EY SH AH N Z",["DIRECTORY(3)"]="D IY R EH K T ER IY",KIMBLEY="K IH M B L IY",["LIPS'"]="L IH P S",MOZARTEAN="M OW Z AA R T IY AH N",MCCLUNE="M AH K L UW N",["WHISTLEBLOWERS(2)"]="HH W IH S AH L B L OW ER Z",HILLSBORO="HH IH L Z B ER OW",BOOTS="B UW T S",COOTS="K UW T S",NIKKI="N IH K IY",HOOTS="HH UW T S",READILY="R EH D AH L IY",MOOTS="M UW T S",APPROPRIATED="AH P R OW P R IY EY T IH D",JUDGMENTAL="JH AH JH M EH N T AH L",WEIDA="V AY D AH",NORECO="N AO R EH K OW",CAPORALE="K AA P AO R AA L IY",JANNOCK="JH AE N AH K",CARDS="K AA R D Z",TRAVELLERS="T R AE V AH L ER Z",RECALLING="R IH K AO L IH NG",BEIRUT="B EY R UW T",VANTILBURG="V AE N T IH L B ER G",["COWARD'S"]="K AW ER D Z",CICCARONE="S IH K ER OW N",CONVERGENT="K AH N V ER JH AH N T",ISSUERS="IH SH UW ER Z",COTTONS="K AA T AH N Z",["HOWARD'S"]="HH AW ER D Z",SOFAMOR="S OW F AH M AO R",["GILCREST(2)"]="G IH L K R EH S T",PROKOFIEV="P R AA K OW F IY V",THRISTING="TH R IH S T IH NG",IGUSHI="IH G UW SH IY",ELIOT="EH L IY AH T",OBERWEIS="OW B ER W AY S",["D'AMATO"]="D AH M AA T OW",MAZZONE="M AA T S OW N IY",["TEMPERATE(2)"]="T EH M P ER AH T",BARTEN="B AA R T AH N",MARTEN="M AA R T AH N",HARTEN="HH AA R T AH N",GARTEN="G AA R T AH N",PARTEN="P AA R T AH N",SEAFOODS="S IY F UW D Z",["DIRECTORSHIP(2)"]="D AY R EH K T ER SH IH P",CUCKOOS="K UW K UW Z",ARNS="AA R N Z",PINKSTON="P IH NG K S T AH N",ADOLPHA="AA D OW L F AH",LASCAUX="L AE S K OW",KLERK="K L ER K",SOCCI="S OW CH IY",["O'SMARTY"]="OW S M AA R T IY",["FELICIANO'S"]="F AH L IY S IY AA N OW Z",KREMLINOLOGIST="K R EH M L IH N AA L AH JH IH S T",CLERK="K L ER K",EXTRICATED="EH K S T R AH K EY T IH D",LEOS="L IY OW Z",ALIDA="AA L IY D AH",PUERTO_RICO="P W EH R T OW R IY K OW",FREEWING="F R IY W IH NG",["SUPPLEMENTARY(4)"]="S AH P L AH M EH N CH R IY",EXPERIENTIAL="EH K S P EH R IY EH N SH AH L",ZEOS="Z IY OW S",["NEGOTIATORS'"]="N AH G OW SH IY EY T ER Z",SPORTIER="S P AO R T IY ER",CHARTIER="CH AA R T IY ER",MCLEISH="M AH K L IY SH",FLAGSHIP="F L AE G SH IH P",ANALGESIC="AE N AH L JH IY S IH K",CIPRIANO="CH IY P R IY AA N OW",LAFUENTE="L AA F W EH N T EY",SUCCESSORS="S AH K S EH S ER Z",VECCI="V EH CH IY",ALYSSA="AH L IH S AH",MALSOM="M AE L S AH M",PECCI="P EH CH IY",VARIETIES="V ER AY AH T IY Z",NECCI="N EH CH IY",["INVESTORS'"]="IH N V EH S T ER Z",NGOS="EH NG G OW Z",ENDEARING="EH N D IY R IH NG",["FARAI(2)"]="F AA R EY",PETRILLA="P EH T R IH L AH",["CARRYING(2)"]="K EH R IY IH NG",["KASLER(2)"]="K AE S L ER",SCANDALIZE="S K AE N D AH L AY Z",MULTIUSER="M AH L T IY Y UW Z ER",TRUMPET="T R AH M P AH T",CAPTORS="K AE P T ER Z",PENITENT="P EH N IH T IH N T",["HASLER(2)"]="HH AE S L ER",CARPETED="K AA R P AH T IH D",HARDS="HH AA R D Z",FORMALITIES="F AO R M AE L AH T IY Z",HAMBLEY="HH AE M B L IY",RAPTORS="R AE P T ER Z",EXCULPATORY="EH K S K AH L P AH T AO R IY",BURGNER="B ER G N ER",DISCONTINUITY="D IH S K AA N T IH N UW IH T IY",WARDS="W AO R D Z",YARDS="Y AA R D Z",THOMASSEN="TH AA M AH S AH N",CLAYBORN="K L EY B ER N",EGOS="IY G OW Z",BUTTONS="B AH T AH N Z",HANBO="HH AE N B OW",MUDSLIDE="M AH D S L AY D",BILZERIAN="B IH L Z EH R IY AH N",WALLOPS="W AA L AH P S",RIENSTRA="R IY N S T R AH",MESSIANIC="M EH S IY AE N IH K",AMBERGER="AE M B ER G ER",["JEFFREY'S"]="JH EH F R IY Z",["DOMINGO(2)"]="D AH M IH NG G OW",THEORIST="TH IY ER IH S T",HOMERUNS="HH OW M R AH N Z",FLAGRANT="F L EY G R AH N T",BIRDS="B ER D Z",MARIELITOS="M EH R IY EH L IY T OW S",["QANTAS(2)"]="K AA N T AH S",MCGREGOR="M AH G R EH G ER",HUNTLEY="HH AH N T L IY",KJOS="K Y AO S",LABORS="L EY B ER Z",MCKANNA="M AH K AE N AH",NABORS="N EY B ER Z",SHEERER="SH IY R ER",DIOS="D IY OW S",BIOS="B AY OW S",RICCI="R IY CH IY",["PECANS(3)"]="P AH K AA N Z",COMEUPPANCE="K AH M AH P AH N S",["REUTERS'S(2)"]="R OY T ER Z",PIECZYNSKI="P IY CH IH N S K IY",["DIDN'T"]="D IH D AH N T",BALSIGER="B AE L S IH G ER",["MESLER(2)"]="M EH S L ER",["NESLER(2)"]="N EH S L ER",["KESLER(2)"]="K EH S L ER",PULSIFER="P AH L S IH F ER",QUEERER="K W IH R ER",["HESLER(2)"]="HH EH S L ER",["FESLER(2)"]="F EH S L ER",AUSTRAL="AO S T R AH L",GIRTEN="G ER T AH N",CLONED="K L OW N D",ABIQUIU="AH B IH K Y UW",ATTACKS="AH T AE K S",WILCZEK="V IH L CH EH K",VEAZIE="V IY Z IY",PROVENTUS="P R OW V EH N T AH S",RECESSING="R IY S EH S IH NG",SCHISM="S K IH Z AH M",REGRETS="R IH G R EH T S",ABRIDGING="AH B R IH JH IH NG",MALINOSKI="M AH L IH N AW S K IY",MACHINERY="M AH SH IY N ER IY",FROHMAN="F R OW M AH N",GROHMAN="G R OW M AH N",DENBO="D IY N B OW",LAMBERTSON="L AE M B ER T S AH N",["STANGELAND(2)"]="S T EY NG G L AH N D",["MACIEJEWSKI(2)"]="M AH CH UW S K IY",["SOFTSOAP(2)"]="S AO F S OW P",JOSCELYNE="JH AA S IH L AY N",JARMIN="JH AA R M AH N",VEENSTRA="V IY N S T R AH",["MAPI'S"]="M AE P IY Z",GERTRUD="G ER T R UW D",HARTFIEL="HH AA R T F IY L",ZEUS="Z UW S",WAITKUS="W EY T K AH S",ENTERTAINS="EH N T ER T EY N Z",SURVIVAL="S ER V AY V AH L",CREEPING="K R IY P IH NG",PATENTING="P AE T AH N T IH NG",ANTAGONIZING="AE N T AE G AH N AY Z IH NG",INTERSPERSED="IH N T ER S P ER S T",INAKI="IH N AA K IY",["SPROGUS'S"]="S P R OW G AH S IH Z",SKYTEL="S K AY T EH L",["CRITIQUE(2)"]="K R IH T IY K",WILTROUT="W IH L T R AW T",EACHUS="IY CH AH S",STOLARSKI="S T AH L AA R S K IY",BACHUS="B AE CH AH S",OMEGA="OW M EH G AH",["LINDNER'S"]="L IH N D N ER Z",SEIDEL="S AY D AH L",NETHERCUTT="N EH TH ER K AH T",PIUS="P AY AH S",["GHADAFI(2)"]="K AH D AA F IY",KEIDEL="K AY D AH L",["TROCHMANN(2)"]="T R AA K M AE N",HEIDEL="HH AY D AH L",KLOSINSKI="K L AH S IH N S K IY",COLEUS="K OW L IY AH S",GEIDEL="G AY D AH L",["MOGADISHU'S"]="M OW G AH D IY SH UW Z",FERRIS="F EH R IH S",CITICORP="S IH T IY K AO R P",DEFERRED="D IH F ER D",BALBONI="B AA L B OW N IY",SHARF="SH AA R F",MCANULTY="M AE K AH N AH L T IY",APPLEGARTH="AE P L AH G AA R TH",WHARF="W AO R F",DERMATOLOGICAL="D ER M AH T AH L AA JH IH K AH L",STEVER="S T IY V ER",TRIDEX="T R IH D EH K S",["TSAI'S(2)"]="S AY Z",FLAVIA="F L AE V IY AH",ROMANIANS="R OW M EY N IY AH N Z",HOUSINGS="HH AW Z IH NG Z",HASSEBROCK="HH AE S IH B R AA K",["SIGNORI(2)"]="S IY N Y AO R IY",SYMPTOMS="S IH M P T AH M Z",PAQUETTE="P AH K EH T",SUBCONTRACTOR="S AH B K AA N T R AE K T ER",HIBMA="HH IH B M AH",HIMMELSBACH="HH IH M IH L S B AA K",ASSISTING="AH S IH S T IH NG",BRAUNSCHWEIG="B R AW N SH W AY G",CHERRIER="CH EH R IY ER",SIND="S IH N D",BIAGIONI="B IY AA JH IY OW N IY",MIND="M AY N D",LIND="L IH N D",KIND="K AY N D",HIND="HH AY N D",MANTEY="M AE N T IY",FIND="F AY N D",BIND="B AY N D",PRECIPITATION="P R IH S IH P IH T EY SH AH N",OZAKI="OW Z AA K IY",WELFARE="W EH L F EH R",PRETTIER="P R IH T IY ER",SCHOENBERGER="SH OW N B ER G ER",TUMACOCERI="T UW M AH K OW CH ER IY",PLANELOADS="P L EY N L OW D Z",SAMSOM="S AE M S AH M",KLINGE="K L IH N JH",["PREVENTED(3)"]="P R IH V EH N IH D",["PRESENTS(2)"]="P R IY Z EH N T S",LETTUCE="L EH T AH S",AMSPACHER="AE M S P AH K ER",UNFATHOMABLE="AH N F AE DH AH M AH B AH L",FUMBLING="F AH M B AH L IH NG",["HAKAN(2)"]="HH AA K AH N",BUMBLING="B AH M B AH L IH NG",MUMBLING="M AH M B AH L IH NG",MANEUVERS="M AH N UW V ER Z",HUMBLING="HH AH M B AH L IH NG",["DOWNEY'S"]="D AW N IY Z",HYDROGEN="HH AY D R AH JH AH N",MAIDEL="M EY D AH L",OUTFOXING="AW T F AA K S IH NG",["WHISKEY(2)"]="HH W IH S K IY",CORRUPTS="K ER AH P T S",BRAZEAL="B R AH Z IY L",BAUGHAN="B AO AH N",REMODELED="R IY M AA D AH L D",KREMPLER="K R EH M P L ER",GAUGHAN="G AO AH N",WIERZBA="V IH R Z B AH",MAUGHAN="M AO G AH N",EXPERIMENTS="IH K S P EH R AH M AH N T S",UNDETERRED="AH N D IH T ER D",STUPA="S T UW P AH",BAYLEE="B EY L IY",VAUGHAN="V AO N",CONQUERORS="K AA NG K ER ER Z",DISPUTABLE="D IH S P Y UW T AH B AH L",["CALLAWAY'S"]="K AO L AH W EY Z",JANOTA="Y AH N OW T AH",DOWNES="D AW N Z",RIEBEN="R IY B AH N",SIEBEN="S IY B AH N",ADMONISH="AE D M AA N IH SH",PECANINS="P EH K AH N IH N Z",CREWMAN="K R UW M AH N",STRIPS="S T R IH P S",TIMEFRAME="T AY M F R EY M",["WALLACE(2)"]="W AO L IH S",DOWNSTAGE="D AW N S T EY JH",WAJDA="V AY D AH",VAJDA="V AY D AH",HERTZOG="HH ER T Z AH G",["CESSNA(2)"]="S EH Z N AH",DARLINGTON="D AA R L IH NG T AH N",DEGAULLE="D AH G AA L",GARLINGTON="G AA R L IH NG T AH N",GAJDA="G AY D AH",ZYGOTE="Z AY G OW T",MISPERCEIVED="M IH S P ER S IY V D",DWARF="D W AO R F",RUSS="R AH S",DURATIONS="D UH R EY SH AH N Z",SUSS="S AH S",NUSS="N AH S",PUSS="P UH S",FASTEN="F AE S AH N",GIUFFRIDA="JH UW F R IY D AH",KUSS="K AH S",KASTEN="K AE S T AH N",MASTEN="M AE S T AH N",GUSS="G AH S",BUSS="B AH S",HASTEN="HH EY S AH N",HAMPERED="HH AE M P ER D",CUSS="K AH S",GRANGER="G R EY N JH ER",GREGA="G R IY G AH",RUTGER="R AH T G ER",GRABEN="G R AE B AH N",SCHECHTMAN="SH EH K T M AH N",TAMPERED="T AE M P ER D",PHYSIO="F IH Z IY OW",PAMPERED="P AE M P ER D",COMMANDANT="K AA M AH N D AA N T",["HEZBOLLAH'S"]="HH EH Z B AA L AH Z",UNADDRESSED="AH N AH D R EH S T",IDEOLOGUES="AY D IY AH L AO G Z",PRUDENTLY="P R UW D AH N T L IY",IMBERA="IH M B ER AH",LIVINGWELL="L IH V IH NG W EH L",BUSHELS="B UH SH AH L Z",PEKRUL="P EH K R AH L",PRIHODA="P R IY HH OW D AH",["ALLAIS(2)"]="EY L IY AH S",PIQUETTE="P IH K EH T",OSAKI="OW S AA K IY",CARAWAN="K AE R AH W AE N",CIRCUITOUS="S ER K Y UW IH T AH S",PHENOM="F EH N AH M",KINNOCK="K IH N AH K",LEMMOND="L EH M AH N D",LITERAL="L IH T ER AH L",INFOTRON="IH N F OW T R AA N",AMORUSO="AE M ER UW S OW",BENTLEY="B EH N T L IY",FRICTIONLESS="F R IH K SH AH N L AH S",ARAKI="AA R AA K IY",["ADMINISTRATIONS'"]="AE D M IH N IH S T R EY SH AH N Z",DISQUIET="D IH S K W AY AH T",STEALTHIES="S T EH L TH IY Z",PISTONS="P IH S T AH N Z",PARAGUAY="P EH R AH G W EY",NITZBERG="N IH T S B ER G",RADIOLOGIST="R EY D IY AA L AH JH IH S T",BRUNNHILDE="B R AH N HH IH L D",JOHANNA="JH AH HH AE N AH",GYRATIONS="JH AY R EY SH AH N Z",DOORKNOB="D UW R N AA B",WESTEN="W EH S T AH N",COHORTS="K OW HH AO R T S",SHIPYARD="SH IH P Y AA R D",STERK="S T ER K",CAPISTRANO="K AE P IH S T R AA N OW",COLOPY="K AH L OW P IY",GODDART="G AA D AA R T",RELAPSE="R IY L AE P S",["DUPLER(2)"]="D UW P L ER",FRAGRANCE="F R EY G R AH N S",GRAYBEARD="G R EY B IY R D",BLEEPING="B L IY P IH NG",NOSS="N AO S",MOSS="M AO S",LOSS="L AO S",SOSS="S AO S",ROSS="R AA S",POSS="P AO S",VOSS="V AO S",TOSS="T AO S",ROTHWELLS="R AO TH W EH L Z",DISCREPANCIES="D IH S K R EH P AH N S IY Z",YOSS="Y AO S",COSS="K AO S",BOSS="B AA S",JALOPY="JH AH L AA P IY",NIEVES="N IY EH V EH S",DOSS="D AO S",KOSS="K AO S",JOSS="JH AO S",POPULAR="P AA P Y AH L ER",HOSS="HH AA S",KRUPA="K R UW P AH",DOMINGUEZ="D AH M IH NG IH Z",ISENHOWER="IH S IH N HH OW ER",DISKETTE="D IH S K EH T",BOYCOTTS="B OY K AA T S",KUCHINSKY="K AH CH IH N S K IY",CHANGER="CH EY N JH ER",["THOMAS'S"]="T AA M AH S IH Z",ISSUANCES="IH SH UW AH N S IH Z",["SCULPTURING(2)"]="S K AH L P CH ER IH NG",UNSPENT="AH N S P EH N T",TWEEDIE="T W IY D IY",ASCENCIO="AA S CH EH N CH IY OW",WHITBECK="W IH T B EH K",DIEMERT="D IY M ER T",LISTEN="L IH S AH N",DILSAVER="D IH L S AH V ER",FOLSOM="F OW L S AH M",GRETTENBERGER="G R EH T AH N B ER G ER",IGNORANT="IH G N ER AH N T",LAWRENCEBURG="L AO R AH N S B ER G",OLSTEN="OW L S T AH N",PEPCID="P EH P S IH D",["BURNHAM'S"]="B ER N AH M Z",["BARNETT'S"]="B AA R N EH T S",SALAMON="S AE L AH M AH N",HEALTHIER="HH EH L TH IY ER",INTERNORTH="IH N T ER N AO R TH",LATS="L AA T S",CHURCHGOER="CH ER CH G OW ER",["REFERENCES(2)"]="R EH F R AH N S IH Z",HATS="HH AE T S",BESTSELLERS="B EH S T S EH L ER Z",FATS="F AE T S",INTERVIEWING="IH N T ER V Y UW IH NG",DATS="D AE T S",CATS="K AE T S",BATS="B AE T S",MAROC="M AA R AO K",MAGRUDER="M AH G R UW D ER",CHEVES="CH IY V Z",["HARRISBURG'S(2)"]="HH EH R IH S B ER G Z",FERRARO="F ER AA R OW",["MINOLTA(2)"]="M IH N OW L T AH",VATS="V AE T S",RATS="R AE T S",PATS="P AE T S",OATS="OW T S",NATS="N AE T S",MATS="M AE T S",LYND="L IH N D",HYND="HH IH N D",["GRAVITT'S"]="G R AE V IH T S",COLBYS="K OW L B IY Z",ASSESSES="AH S EH S IH Z",SWIRL="S W ER L",TWIRL="T W ER L",FELDMEIER="F EH L D M AY ER",COVERED="K AH V ER D",HOVERED="HH AH V ER D",OVERSUBSCRIBE="OW V ER S AH B S K R AY B",BIEVER="B IY V ER",ENDEAVORS="IH N D EH V ER Z",MCGRUDER="M AH G R UW D ER",EQUINOX="IY K W AH N AA K S",SIEVER="S IY V ER",CRUISING="K R UW Z IH NG",UNBRIDLED="AH N B R AY D AH L D",DECONGESTANT="D IH K AH N JH EH S T AH N T",RAINDROPS="R EY N D R AA P S",BARRIS="B AE R IH S",SHAWLER="SH AO L ER",CROTEAU="K R AH T OW",FEDEROFF="F EH D ER AO F",BRUISING="B R UW Z IH NG",HARRIS="HH EH R IH S",["INDUSTRIELLE(2)"]="IH N D AH S T R IY AH L EH",BILLOW="B IH L OW",CARRIS="K AE R IH S",DILLOW="D IH L OW",WILLOW="W IH L OW",["BOY-SCOUT"]="B OY S K AW T",TAPERED="T EY P ER D",PAPERED="P EY P ER D",TRIBBETT="T R IH B IH T",THICKHEAD="TH IH K HH EH D",SMETZER="S M EH T Z ER",PILLOW="P IH L OW",IRRESPECTIVE="IH R AH S P EH K T IH V",["CALM(2)"]="K AA L M",["BALM(2)"]="B AA L M",BEQUETTE="B IH K EH T",LOGHRY="L AA G R IY",FIRMIN="F ER M IH N",["PALM(2)"]="P AA L M",SKILLERN="S K IH L ER N",MCEVER="M AH K EH V ER",KAUNDA="K AO N D AH",MUND="M AH N D",LUND="L AH N D",SUND="S AH N D",CENTRAM="S EH N T R AE M",CONVERGING="K AH N V ER JH IH NG",SETTLEMENT="S EH T AH L M AH N T",BUND="B AH N D",FUND="F AH N D",DARTMOUTH="D AA R T M AH TH",HUND="HH AH N D",GAUGER="G EY JH ER",HAUGER="HH AW G ER",BEEVER="B IY V ER",CONGREGATION="K AA NG G R AH G EY SH AH N",["PHALANGE(2)"]="F AH L EY N JH",BUKOVINA="B UW K AO V IH N AA",MAUGER="M AO G ER",CONSUMING="K AH N S UW M IH NG",CHECKMATE="CH EH K M EY T",REEVER="R IY V ER",SEEVER="S IY V ER",["FERNANDO'S"]="F ER N AE N D OW Z",LEEVER="L IY V ER",CRIBBING="K R IH B IH NG",BLOODSTAINS="B L AH D S T EY N Z",KEEVER="K IY V ER",CHILDBEARING="CH AY L D B EH R IH NG",KELLOW="K EH L OW",FELLOW="F EH L OW",BELLOW="B EH L OW",YELLOW="Y EH L OW",["HIROHITO'S(2)"]="HH IH R AH HH IY T OW Z",CONTOURS="K AA N T UH R Z",MELLOW="M EH L OW",["ATLANTIS(2)"]="AE T L AE N IH S",FITS="F IH T S",DEARDOURFF="D IH R D AO R F",LITS="L IH T S",KITS="K IH T S",FERMIN="F ER M IH N",HITS="HH IH T S",MCKESSON="M AH K EH S AH N",["PROTUBERANCES(2)"]="P R AH T UW B ER AH N S AH Z",PETROSKI="P IH T R AW S K IY",SITS="S IH T S",CONFERENCES="K AA N F ER AH N S AH Z",PITS="P IH T S",["EXPANSION(2)"]="IH K S P AE N CH AH N",PEEVES="P IY V Z",VERMIN="V ER M IH N",DOGEARING="D AA G IY R IH NG",ROEVER="R AA EH V ER",SMARMY="S M AA R M IY",SIVERLING="S IH V ER L IH NG",TUMMOND="T AH M AH N D",ROTHBART="R AO TH B AA R T",TRAWLER="T R AO L ER",KRETZER="K R EH T Z ER",URBANIAK="ER B AE N IY AE K",PRETZER="P R EH T Z ER",["BEDOUIN(3)"]="B EH D AH W AH N",["ALEXANDRA(2)"]="AE L IH G Z AE N D R AH",PERTURBATIONS="P ER T ER B EY SH AH N Z",BULLETPROOF="B UH L AH T P R UW F",GINNED="JH IH N D",CHECKOFF="CH EH K AO F",JOHANNESBURG="JH OW HH AE N IH S B ER G",PETERKIN="P IH T ER K IH N",BAGPIPER="B AE G P AY P ER",SHEPHEARD="SH EH P ER D",["FEDERAL'S"]="F EH D ER AH L Z",JUSTEN="JH AH S T AH N",PROVISIONING="P R AH V IH ZH AH N IH NG",LAPD="EH L EY P IY D IY",["YUGO'S"]="Y UW G OW Z",LIFESPANS="L AY F S P AE N Z",COLLIDING="K AH L AY D IH NG",["HUGO'S"]="HH Y UW G OW Z",AUSTEN="AO S T IH N",SHIBATA="SH IY B AA T AH",STETZER="S T EH T Z ER",WOND="W AO N D",["KURALT'S"]="K Y ER AO L T S",ACEVES="AA S EY V EH S",ANNEALING="AH N IY L IH NG",VICENCIO="V IH S EH N S IY OW",POND="P AA N D",BOND="B AA N D",["ARAMONY(2)"]="EH R AH M OW N IY",GOND="G AA N D",FOND="F AA N D",HURDLES="HH ER D AH L Z",MORAGA="M AO R AA G AH",SWANGER="S W AO NG ER",INQUISITIVE="IH N K W IH Z IH T IH V",DELUXE="D AH L AH K S",NIPPY="N IH P IY",MAUD="M AO D",FOMENTED="F OW M EH N T IH D",LAYING="L EY IH NG",["CHRIBONIKO(2)"]="CH R IH B AH N IY K OW",HACKBARTH="HH AE K B AA R TH",SOUNDEST="S AW N D AH S T",DOMINQUEZ="D OW M IY N K W EH Z",ABSHIER="AE B SH IY ER",BAUD="B AO D",BRAKEMAN="B R EY K M AH N",GOUCHER="G AW K ER",PONTIFICATED="P AA N T IH F AH K EY T IH D",ZIPPY="Z IH P IY",PAYING="P EY IH NG",BOUCHER="B UW SH AH",SAYING="S EY IH NG",STEINMETZ="S T AY N M EH T S",VOUCHER="V AW CH ER",FRAGMENT="F R AE G M AH N T",EMPLOYABLE="EH M P L OY AH B AH L",["DODGERS'"]="D AA JH ER Z",["TARA'S(2)"]="T AA R AH Z",POUCHER="P AW CH ER",["IMPRINTING(2)"]="IH M P R IH N IH NG",DIMPLED="D IH M P AH L D",PRAGMATIST="P R AE G M AH T IH S T",INFOCORP="IH N F OW K AO R P",HANBACK="HH AE N B AE K",DIPPY="D IH P IY",["ARGO'S"]="AA R G OW Z",CHECHNYANS="CH EH CH N IY AH N Z",SUNRISE="S AH N R AY Z",RUMINANT="R UW M AH N AH N T",SPARTANBURG="S P AA R T AH N B ER G",MOYL="M OY L",RETABLOS="R IY T AE B L OW S",[",COMMA"]="K AA M AH",PALACIO="P AH L EY S IY OW",STOLEN="S T OW L AH N",ORELLANA="AO R EH L AE N AH",SEAGROVES="S IY G R OW V Z",DOOLIN="D UW L IH N",["PITIFULLY(2)"]="P IH T IH F L IY",KITCHINGS="K IH CH IH NG Z",MEHLHAFF="M EH L HH AH F",["MAGISTRATE(2)"]="M AE JH IH S T R EY T",PENDERGRAPH="P EH N D ER G R AE F",HITCHINGS="HH IH CH IH NG Z",MOEHLE="M OW HH AH L",HALLWOOD="HH AO L W UH D",SAUD="S AO D",PUPPY="P AH P IY",["POLICY'S"]="P AA L AH S IY Z",DETERIORATED="D IH T IH R IY ER EY T IH D",GUPPY="G AH P IY",BOEHLE="B OW HH AH L",MANGINE="M AA NG G IY N IY",["OCCIDENTAL'S"]="AA K S AH D EH N T AH L Z",SEETHING="S IY TH IH NG",CHALCEDONY="CH AE L S AH D OW N IY",BICKERSTAFF="B IH K ER S T AE F",TEETHING="T IY DH IH NG",["VINCENT(2)"]="V IH N S IH N T",POWERFULLY="P AW ER F L IY",["GEMAYEL'S"]="G AH M EY AH L Z",REALLOCATING="R IY AE L AH K EY T IH NG",UNSUBSCRIBED="AH N S AH B S K R AY B D",KLEMA="K L EH M AH",PREEMINENT="P R IY EH M AH N AH N T",PRETEEN="P R IY T IY N",HARCOURT="HH AA R K AO R T",MCNEILL="M AH K N IY L",FRUCHER="F R UW K ER",RECIPROCITY="R EH S IH P R AA S IH T IY",CONCUSSION="K AH N K AH SH AH N",CUPPY="K AH P IY",PLANTATION="P L AE N T EY SH AH N",SCUD="S K AH D",INOCULATES="IH N AA K Y AH L EY T S",ENGLANDER="IH NG G L AH N D ER",SKYROCKET="S K AY R AA K AH T",MCCULLUM="M AH K AH L AH M",MCCARTHYITE="M AH K AA R TH IY AY T",MANIPULATOR="M AH N IH P Y AH L EY T ER",BROLIN="B R OW L IH N",OVERWRITTEN="OW V ER R IH T AH N",MAGNETOMETERS="M AE G N AH T AA M AH T ER Z",MONTEROSSO="M OW N T ER OW S OW",PAINSTAKING="P EY N S T EY K IH NG",ADVENTURE="AE D V EH N CH ER",ENCHANTERS="EH N CH AE N T ER Z",PRECEDED="P R IH S IY D IH D",PROFESS="P R AH F EH S",COLGATE="K OW L G EY T",FUERTH="F W ER TH",ABSURD="AH B S ER D",DINNERWARE="D IH N ER W EH R",ENEMA="EH N AH M AH",REDUNDANT="R IH D AH N D AH N T",DISGRUNTLED="D IH S G R AH N T AH L D",COCKLE="K AA K AH L",MUFFLER="M AH F L ER",SUBSISTENCE="S AH B S IH S T AH N S",HECKLE="HH EH K AH L",MANFREDI="M AA N F R EH D IY",INKJET="IH NG K JH EH T",VOTED="V OW T AH D",MALABRE="M AE L AH B R AH",TOTED="T OW T IH D",PALOMA="P AA L OW M AH",["PRODUCT'S"]="P R AA D AH K T S",SALOMA="S AA L OW M AH",LINCOLNSHIRE="L IH NG K AH N SH IH R",TETRAVALENT="T EH T R AH V EY L AH N T",HIGHFALUTIN="HH AY F AH L UW T IH N",["ARMACOST'S"]="AA R M AH K AO S T S",["CHEVROLET'S(2)"]="SH EH V R OW L EY Z",OVERSHADOWED="OW V ER SH AE D OW D",GIEGERICH="G IY G ER IH K",NOTED="N OW T AH D",OBVIATED="AA B V IY EY T AH D",WORKPLACE="W ER K P L EY S",["WHISPERING(2)"]="HH W IH S P ER IH NG",RODMOND="R AA D M AH N D",RIEHLE="R IY HH AH L",BEEFERMAN="B IY F ER M AH N",KARNAL="K AA R N AH L",HEBDA="HH EH B D AH",RIGHTISTS="R AY T IH S T S",CARNAL="K AA R N AH L",BIEHLE="B IY HH AH L",TRANSFORMERS="T R AE N S F AO R M ER Z",EXCULPATE="EH K S K AH L P EY T",MATTEREASE="M AE T ER IY Z",PRETENSE="P R IY T EH N S",ANDRUS="AE N D R AH S",STRATOCASTER="S T R AE T OW K AE S T ER",CELLPHONE="S EH L F OW N",KUTSCHER="K AH CH ER",ELBOWING="EH L B OW IH NG",MCDOUGALL="M AH K D UW G AH L",ARTICULATE="AA R T IH K Y AH L EY T",DECONTAMINATION="D IY K AH N T AE M AH N EY SH AH N",EMELINE="EH M IH L AY N",RANSOM="R AE N S AH M",["O'KELLEY"]="OW K EH L IY",ESCAMEZ="EH S K AA M EH Z",DELETION="D IH L IY SH AH N",["NIAGARA'S"]="N AY AE G R AH Z",RACIOPPI="R AA CH OW P IY",["INTELLECTS(4)"]="IH N AH L EH K S",MILLWOOD="M IH L W UH D",OVERBEARING="OW V ER B EH R IH NG",RHYTHMIC="R IH DH M IH K",LANGUID="L AE NG G W AH D",RAMTEK="R AE M T EH K",ARIANNA="AA R IY AE N AH",BRIANNA="B R IY AE N AH",BITTEN="B IH T AH N",["SALEM'S"]="S EY L AH M Z",["HOLMES(2)"]="HH OW L M Z",STEHLE="S T EH HH AH L",KITTEN="K IH T AH N",WONDERFULNESS="W AH N D ER F AH L N AH S",RETRIEVED="R IY T R IY V D",DOOLEN="JH UW L AH N",LITTEN="L IH T AH N",MITTEN="M IH T AH N",CONJECTURES="K AH N JH EH K CH ER Z",WITTEN="W IH T AH N",GROSSKOPF="G R OW S K AO P F",["DIFFERENT(2)"]="D IH F R AH N T",SHOWCASES="SH OW K EY S IH Z",FLYING="F L AY IH NG",PERHAPS="P ER HH AE P S",LUNDHOLM="L AH N D HH OW L M",DUCOTE="D AH K OW T",CASHIER="K AE SH IH R",PLYING="P L AY IH NG",MADELENE="M AE D AH L IY N",TOFFLER="T AO F L ER",APPETITES="AE P AH T AY T S",RUEHLE="R UW HH AH L",HOFFLER="HH AO F AH L ER",BERNAL="B ER N AH L",SMOLEN="S M AA L AH N",LESSENED="L EH S AH N D",SHELINE="SH EH L AY N",SEEMA="S IY M AA",CHARLATANS="SH AA R L AH T AH N Z",CHANDROSS="CH AE N D R AO S",["KRZYSZTOF(2)"]="K R IY SH T AO F",["LAMBERT'S"]="L AE M B ER T S",PREOCCUPY="P R IY AA K Y AH P AY",CHEMIST="K EH M IH S T",INADEQUACY="IH N AE D IH K W AH S IY",BEDDINGFIELD="B EH D IH NG F IY L D",PITCHER="P IH CH ER",WITCHER="W IH CH ER",["PREDICTABLE(2)"]="P R IY D IH K T AH B AH L",RECOURSE="R IY K AO R S",CALLOW="K AE L OW",BALLOW="B AE L OW",GALLOW="G AE L OW",FALLOW="F AE L OW",HALLOW="HH AE L OW",ACEVEDO="AE S AH V EY D OW",MALLOW="M AE L OW",LYNDS="L IH N D Z",["NATIONSBANC'S(2)"]="N EY SH AH N Z B AA NG K S",HYNDS="HH IH N D Z",LANTOS="L AE N T OW S",TALLOW="T AE L OW",WALLOW="W AA L OW",WOOLEN="W UH L AH N",PASTORALIZE="P AE T ER AH L AY Z",IMPEACHMENTS="IH M P IY CH M AH N T S",OPTED="AA P T IH D",CURD="K ER D",CITIBANK="S IH T IY B AE NG K",BURD="B ER D",SOLDERING="S AA D ER IH NG",ZOFAGART="Z OW F AH G AA R T",INSKIP="IH N S K IH P",KURD="K ER D",["ENLARGED(2)"]="IH N L AA R JH D",["INTERRUPTIBLE(2)"]="IH N ER R AH P T IH B AH L",CATCHER="K AE CH ER",KHAKIS="K AE K IY Z",COLTEC="K OW L T EH K",HATCHER="HH AE CH ER",SCHETTLER="SH EH T AH L ER",QUEVEDO="K W EY V EY D OW",SHERMER="SH ER M ER",REMUNERATIVE="R IY M Y UW N ER AH T IH V",CHARNOCK="CH AA R N AH K",FAGUNDES="F AE G AH N D Z",CAVALCADE="K AE V AH L K EY D",WEINMANN="W AY N M AH N",HARDENERS="HH AA R D AH N ER Z",GARDENERS="G AA R D AH N ER Z",CARDOON="K AA R D UW N",ALCOCER="AH L K OW S ER",TIRING="T AY R IH NG",PSILOCYBIN="S AY L AH S AY B AH N",ADVANCED="AH D V AE N S T",PERFORMANCE="P ER F AO R M AH N S",GOLDSCHMID="G OW L D SH M IH D",VARGHESE="V AA R G IY Z",UNKNOWN="AH N N OW N",FIRING="F AY R IH NG",HIRING="HH AY R IH NG",HATHORN="HH AA TH AO R N",AIRING="EH R IH NG",MINAMIDE="M IH N AH M IY D EY",WIXTED="W IH K S T IH D",RAZORBACKS="R EY Z ER B AE K S",GROBEN="G R AA B AH N",["SEMIFINISH(3)"]="S EH M IH F IH N IH SH",DOGMATICALLY="D AA G M AE T IH K L IY",HATTEN="HH AE T AH N",LAVENTURE="L AA V EH N CH ER",ANIXTER="AE N IH K S T ER",PROVIDE="P R AH V AY D",GILCREST="G IH L K ER IH S T",MAVERICKS="M AE V ER IH K S",["CENTERS'"]="S EH N T ER Z",THOMPKINS="T AA M P K IH N Z",PATTEN="P AE T AH N",INSISTENT="IH N S IH S T AH N T",LIBRARIANS="L AY B R EH R IY AH N Z",EJECTED="IH JH EH K T IH D",BETCHER="B EH CH ER",HARTZOG="HH AA R T Z AH G",VIVACIOUS="V AH V EY SH AH S",TAOISM="D AW IH Z AH M",PODOLAK="P AH D OW L AH K",REJECTIONISTS="R IH JH EH K SH AH N IH S T S",TOURISTS="T UH R AH S T S",PANHANDLING="P AE N HH AE N D L IH NG",SHINED="SH AY N D",["ANOINTED(3)"]="AH N OY N AH D",KOSCIELNIAK="K AH S CH IY L N IY AE K",HANCOX="HH AE N K AA K S",MITSOTAKIS="M IH T S OW T AA K IH S",LANDRIGAN="L AE N D R IH G AH N",EKOFISK="EH K AH F IH S K",AZEVEDO="AA Z EY V EY D OW",["PRODUCTIONS'(3)"]="P ER D AH K SH AH N Z",["FARMING'S"]="F AA R M IH NG Z",GERING="G IH R IH NG",HERING="HH ER IH NG",OBYRNE="OW B ER N",NATCHER="N AE CH ER",DERING="D IH R IH NG",ELECTED="IH L EH K T AH D",MAHARAJA="M AA HH ER AA ZH AH",["MORRISVILLE'S"]="M AO R AH S V IH L Z",["CEMENT(2)"]="S IH M EH N T",FRISKED="F R IH S K T",COPARTNERS="K OW P AA R T N ER Z",LOOSESTRIFE="L UW S S T R AY F",SLIPPAGE="S L IH P IH JH",KELLWOOD="K EH L W UH D",CHECHENS="CH EH CH IH N Z",BELLWOOD="B EH L W UH D",MAGDALA="M AA G D AA L AH",SPRECHER="S P R EH K ER",HILLERMAN="HH IH L ER M AH N",HOMELY="HH OW M L IY",COMELY="K AH M L IY",NGEMA="EH N G EH M AA",BETTEN="B EH T AH N",ALARIE="AH L EH R IY",LAMIRANDE="L AA M IH R AA N D IY",["HUGE(2)"]="Y UW JH",OVEREXCITING="OW V ER EH K S AY T IH NG",LORELEI="L AO R IH L AY",SHINDIG="SH IH N D IH G",RECOMMITED="R IH K AA M IH T IH D",ARMTEK="AA R M T EH K",SILLERMAN="S IH L ER M AH N",FIFTEEN="F IH F T IY N",TRYOUTS="T R AY AW T S",CRAYONS="K R EY AA N Z",DOMINANT="D AA M AH N AH N T",KAOLIN="K AW L IH N",["WHY'S(2)"]="HH W AY Z",MCGREEVY="M AH G R IY V IY",DORRIS="D AO R IH S",BUCKLE="B AH K AH L",CHEMA="CH EH M AA",["SHANNON'S"]="SH AE N AH N Z",MORRIS="M AO R AH S",NORRIS="N AO R IH S",["D'ETATS"]="D EY T AA Z",MELESSA="M EH L EH S AH",JANOSKY="Y AH N OW S K IY",TREBLINKA="T R EH B L IH NG K ER",ZARING="Z EH R IH NG",POPPY="P AA P IY",ATHLETICS="AE TH L EH T IH K S",ARITHMETIC="EH R IH TH M EH T IH K",SOMERSAULTING="S AH M ER S AO L T IH NG",HOPPY="HH AO P IY",DARING="D EH R IH NG",LACOURSE="L AH K UH R S",FARING="F EH R IY NG",GARING="G EH R IH NG",HARING="HH EH R IH NG",["FURINI'S"]="F UH R IY N IY Z",MARING="M EH R IH NG",KURALT="K Y ER AO L T",PARING="P EH R IH NG",LETCHER="L EH CH ER",KETCHER="K EH CH ER",BRAMAH="B R AA M AH",DOWNSIZE="D AW N S AY Z",FORSYTHIA="F AO R S IH TH IY AH",EMPHYSEMA="EH M F AH Z IY M AH",SHENANDOAH="SH EH N AH N D OW AH",BARING="B EH R IH NG",NOTEHOLDER="N OW T HH OW L D ER",DAIGNAULT="D EH G N OW",UGOLIN="Y UW G AH L IH N",DISCOVERIES="D IH S K AH V ER IY Z",TITTSWORTH="T IH T S W ER TH",["BODEGUITA(2)"]="B OW D AH G IY D AH",REINCARNATED="R IY IH N K AA R N EY T IH D",KELLERMAN="K EH L ER M AH N",HELLERMAN="HH EH L ER M AH N",GELLERMAN="G EH L ER M AH N",GINGHAM="G IH NG AH M",HINGHAM="HH IH NG AH M",KINGHAM="K IH NG HH AE M",YARBOUGH="Y AA R B AW",BYRD="B ER D",BINGHAM="B IH NG AH M",DINGHAM="D IH NG AH M",COLOMA="K OW L OW M AH",DEHECQ="D IH HH EH K",DALMATIANS="D AE L M EY SH AH N Z",ERECTED="IH R EH K T AH D",TRANSPORTING="T R AE N S P AO R T IH NG",RUMPLED="R AH M P AH L D",["QUARRELING(2)"]="K W AA R L IH NG",COUNTRYWIDE="K AH N T R IY W AY D",["INFESTED(2)"]="IH N F EH S T IH D",REFINERY="R IH F AY N ER IY",STERMER="S T ER M ER",MENDICINO="M EH N D IY CH IY N OW",DELAURA="D EH L AO R AH",["BATON-ROUGE'S"]="B AE T AH N R UW JH IH Z",ESTRANGEMENT="IH S T R EY N JH M AH N T",CONSENSUS="K AH N S EH N S AH S",["TAKI'S"]="T AE K IY Z",["INADVISABLE(2)"]="IH N AE D V AY Z AH B AH L",RAUSCHER="R AW SH ER",TAUSCHER="T AW SH ER",["HILLIKER(2)"]="HH IH L IH K ER",CLASSACTION="K L AE S AE K SH AH N",SHIMIZU="SH IH M IY Z UW",BACKSLAPPING="B AE K S L AE P IH NG",CORRALES="K ER AA L EH S",PUNGENT="P AH N JH AH N T",DECLINE="D IH K L AY N",MISCHARGES="M IH S CH AA R JH IH Z",["MOMENT'S"]="M OW M AH N T S",COLOMBARI="K AA L AA M B AA R IY",NONBITING="N AA N B AY T IH NG",["YOUNGSTER'S"]="Y AH NG S T ER Z",ADELAAR="AE D AH L AA R",PICKUPS="P IH K AH P S",["JONATHAN'S"]="JH AA N AH TH AH N Z",GUYNES="G AY N Z",GRAFE="G R EY F",OBJECTORS="AH B JH EH K T ER Z",PREJUDICIAL="P R EH JH AH D IH SH AH L",["URANUS(2)"]="Y ER AH N AH S",PINKOWSKI="P IH NG K AO F S K IY",RAHILLY="R AE HH AH L IY",GODINES="G AA D AY N Z",HERBSTER="HH ER B S T ER",SAUNIER="S AO N IY ER",WINKOWSKI="V IH NG K AO F S K IY",NERD="N ER D",SKOWRON="S K AW R AH N",FUELLED="F Y UW AH L D",ROLLEN="R AO L AH N",EMBELLISHED="EH M B EH L IH SH T",TRIBUTE="T R IH B Y UW T",MOLLEN="M AA L IH N",["HANI'S"]="HH AE N IY Z",MISERATION="M IH Z ER EY SH AH N",ESTATEHOOD="IH S T EY T HH UH D",PERMANENTLY="P ER M AH N AH N T L IY",WILHELMSEN="W IH L HH IH L M S AH N",APICELLA="AE P IH S EH L AH",BOLLEN="B AA L AH N",MIGRAINE="M AY G R EY N",HOLLEN="HH AA L AH N",DEWARE="D UW EH R",KOGYO="K OW JH Y OW",QUELLED="K W EH L D",GOODA="G UH D AH",FULLAM="F UH L AH M",AQUIFERS="AE K W AH F ER Z",OUTFLANKING="AW T F L AE NG K IH NG",ARCHER="AA R CH ER",["DICKSTEIN'S"]="D IH K S T AY N Z",FRUSH="F R AH SH",["PUT-ONS"]="P UH T AA N Z",AEROSOL="EH R AH S AA L",BELCASTRO="B EH L K AE S T R OW",BRODA="B R OW D AH",PULLAM="P UH L AH M",BEARISH="B EH R IH SH",INTERPOSE="IH N T ER P OW Z",NAGAO="N AA G AA OW",BEDPANS="B EH D P AE N Z",GERD="G ER D",BINKOWSKI="B IH NG K AO F S K IY",COPLIN="K AA P L IH N",FERD="F ER D",SULLEN="S AH L AH N",MULLEN="M AH L AH N",LONGTIN="L AO NG T IH N",PULLEN="P UH L AH N",BRUSH="B R AH SH",CRUSH="K R AH SH",LOCKLEAR="L AA K L ER",FULLEN="F UH L AH N",OVERNIGHT="OW V ER N AY T",BULLEN="B UH L AH N",CULLEN="K AH L AH N",POPLIN="P AA P L IH N",JOPLIN="JH AA P L IH N",KOPLIN="K AA P L IH N",SWELLED="S W EH L D",ALTERATION="AO L T ER EY SH AH N",INFEASIBLE="IH N F IY Z AH B AH L",OLEXA="AH L IY K S AH",STROMGREN="S T R AA M G R EH N",MIZUNO="M IH Z UW N OW",BOMBARDING="B AA M B AA R D IH NG",HOREHOUND="HH AA R HH AW N D",ZELINKA="Z IH L IH NG K AH",DOCKSIDE="D AA K S AY D",I_R_A="AY AA R EY",YARD="Y AA R D",PLUSH="P L AH SH",WARD="W AO R D",LARD="L AA R D",ALEXA="AH L EH K S AH",FLUSH="F L AH SH",UNFEASIBLE="AH N F IY Z AH B AH L",NARD="N AA R D",MERENDA="M EH R EY N D AH",POMPOSITY="P AA M P AA S IH T IY",USAFE="Y UW S EY F",["NENI'S"]="N EH N IY S",MEMORABILIA="M EH M ER AH B IY L Y AH",LAWARE="L AH W EH R",LOOPY="L UW P IY",REDUNDANCIES="R IH D AH N D AH N S IY Z",MIFSUD="M IH F S AH D",ACTED="AE K T AH D",DISINTEGRATING="D IH S IH N T AH G R EY T IH NG",TURING="T UH R IH NG",DROVES="D R OW V Z",["GILBERT'S"]="G IH L B ER T S",ACCLAMATION="AE K L AH M EY SH AH N",LURING="L UH R IH NG",MALLEABLE="M AE L IY AH B AH L",TISHMAN="T IH SH M AH N",PROVES="P R UW V Z",["AUSTRIA'S"]="AO S T R IY AH Z",PRESENTS="P R EH Z AH N T S",GROVES="G R OW V Z",FISHMAN="F IH SH M AE N",["PRESERVED(3)"]="P R IY Z ER V D",ACCOKEEK="AE K OW K IY K",HADLINE="HH AE D L AY N",ESPLIN="EH S P L IH N",BARD="B AA R D",CARD="K AA R D",MACERA="M AH S EH R AH",GARD="G AA R D",["GEORGESON(2)"]="JH AO R JH S AH N",["EHRENREICH(2)"]="EH R AH N R IH CH",SPATTERS="S P AE T ER Z",HOUSH="HH AW SH",MOISI="M OY S IY",DURING="D UH R IH NG",BOISI="B OY S IY",ROUSH="R AW SH",MISINFORMING="M IH S IH N F AO R M IH NG",FETED="F EY T IH D",KARCZEWSKI="K ER CH EH F S K IY",LUBINOV="L UW B AH N AA V",["PROBABLY(2)"]="P R AA B L IY",["PLAINTIVE(2)"]="P L EY N IH V",SUMMARY="S AH M ER IY",LORING="L AO R IH NG",MORING="M AO R IH NG",GEVAERT="G AH V EH R T",PORING="P AO R IH NG",NEGOTIATORS="N IH G OW SH IY EY T ER Z",IMPLAUSIBLY="IH M P L AO Z AH B L IY",MANKOWSKI="M AH NG K AO F S K IY",JOHANSEN="JH OW HH AE N S AH N",APPLIN="AE P L IH N",JANKOWSKI="Y AH NG K AO F S K IY",CHROMOSOMES="K R OW M AH Z OW M Z",["SYMBOLICALLY(2)"]="S IH M B AA L IH K L IY",OUTBACK="AW T B AE K",CENTRIFUGAL="S EH N T R IH F Y UW G AH L",THEATRES="TH IY AH T ER Z",["GADHAFI'S(2)"]="G AH D HH AA F IY Z",FRANZONI="F R AA N Z OW N IY",LUISI="L UW S IY",["BARRIERS(2)"]="B EH R IY ER Z",GAMBONE="G AA M B OW N",BORING="B AO R IH NG",UNAVAILING="AH N AH V EY L IH NG",GORING="G AO R IH NG",GLOBEX="G L OW B AH K S",AGRICULTURALIST="AE G R AH K AH L CH ER AH L AH S T",TOKIO="T OW K IY OW",KLIEBERT="K L IY B ER T",GIGAFLOP="G IH G AH F L AA P",QUIESCENT="K W AY EH S AH N T",REINSCH="R AY N SH",MENAPACE="M EH N AA P AA CH IY",["BELAIR(2)"]="B EH L EH R",DESHAIES="D IH SH EY Z",STIKELEATHER="S T IH K IH L EH DH ER",ERRING="EH R IH NG",INTERLEAVES="IH N T ER L IY V Z",PLATTERS="P L AE T ER Z",CONFESS="K AH N F EH S",BANKOWSKI="B AH NG K AO F S K IY",CATCHINGS="K AE CH IH NG Z",SMARTCARD="S M AA R T K AA R D",DELICATELY="D EH L AH K AH T L IY",LOCHER="L AA K ER",KOCHER="K AO CH ER",["MINISTER(2)"]="M IH N IH S T ER",ROCHER="R OW CH ER",DADAMO="D AA D AA M OW",SUZHOU="S UW ZH UW",SCHEMED="S K IY M D",RESURRECTING="R EH Z ER EH K T IH NG",MEUNIER="M OY N IY ER",ALLENHURST="AE L AH N HH ER S T",SKYDIVING="S K AY D AY V IH NG",WEISENTHAL="W AY S IH N TH AA L",FELLOWSHIP="F EH L OW SH IH P",DIMPERIO="D IH M P EH R IY OW",CHAMBERLIN="CH EY M B ER L IH N",COMPETED="K AH M P IY T IH D",["CRICKET'S"]="K R IH K AH T S",SEIDENBERG="S AY D AH N B ER G",UNRING="AH N R IH NG",BEINGS="B IY IH NG Z",OBLIGATED="AA B L AH G EY T IH D",ISODA="IY S OW D AH",BROOKOVER="B R UH K OW V ER",HASHMAN="HH AE SH M AH N",CASHMAN="K AE SH M AH N",VOORHEIS="V UH R HH AY Z",SHATTERS="SH AE T ER Z",MCCLUNEY="M AH K L UW N IY",VIVYAN="V IY V Y AA N",BUNDESTAG="B AH N D AH S T AE G",UNBEKNOWNST="AH N B IY N OW N S T",SCHERER="SH IH R ER",SPRING="S P R IH NG",ASCHER="AE SH ER",ESCHER="EH SH ER",CALMLY="K AA M L IY",MULLIKEN="M AH L IH K AH N",EGOISM="IY G OW IH Z AH M",ANTIHISTAMINE="AE N T IY HH IH S T AH M AH N",CHRISTMASES="K R IH S M AH S IH Z",TRICKSTERS="T R IH K S T ER Z",["ASSASSIN'S"]="AH S AE S AH N Z",GRAPEFRUITS="G R EY P F R UW T S",["CHANNEL'S"]="CH AE N AH L Z",GEMIGNANI="JH EH M IY G N AA N IY",["ATTENDANT'S"]="AH T EH N D AH N T S",PRUNIER="P R UW N IY ER",WATROUS="W AA T R AH S",KASSEBAUM="K AE S AH B AW M",BRUNGARD="B R AH NG G ER D",["JOEY'S"]="JH OW IY Z",ZABIELSKI="Z AH B IY L S K IY",["ABSTAINED(2)"]="AE B S T EY N D",["MOBSTER'S"]="M AA B S T ER Z",["LOBSTER'S"]="L AA B S T ER Z",CEREMONY="S EH R AH M OW N IY",["GRESHAM'S"]="G R EH SH AH M Z",SITED="S AY T IH D",RESUMED="R IH Z UW M D",DRUGGED="D R AH G D",SOMOZA="S AH M OW Z AH",KELLAM="K EH L AH M",EYEDROPPER="AY D R AA P ER",MOSHIER="M AA SH IY ER",MONFILS="M AA N F IH L Z",MILLIKEN="M IH L IH K AH N",DENUCLEARIZED="D IH N UW K L IY ER AY Z D",RAYMUND="R EY M AH N D",TRAFICANTS="T R AE F IH K AH N T S",DOSHIER="D AA SH IY ER",HOOVES="HH UH V Z",HOWITZER="HH AW AH T S ER",KUCERA="K AH CH IH R AH",PEPPY="P EH P IY",AULDS="AO L D Z",MUTINEERS="M Y UW T IH N IH R Z",["CONTRACTS(2)"]="K AH N T R AE K T S",CITED="S AY T AH D",["OAKS'"]="OW K S",TALBOTS="T AE L B AH T S",HOUSEHOLDER="HH AW S HH OW L D ER",["MSSRS."]="M EH S ER Z",EVELINE="EH V AH L IH N",KLINGEL="K L IH NG G AH L",SPELLED="S P EH L D",ARLANA="AA R L AE N AH",WOLLAM="W AA L AH M",SENESCENCE="S AH N EH S AH N S",["AVERAGE'S"]="AE V R IH JH IH Z",PLASTERING="P L AE S T ER IH NG",DISCOURSES="D IH S K AO R S IH Z",FASCIST="F AE SH IH S T",EPHRAIM="IY F R AH M",HOLBEN="HH OW L B AH N",DARKEST="D AA R K AH S T",DECLARED="D IH K L EH R D",EXIGENCY="EH K S IH JH AH N S IY",LIFEBOATS="L AY F B OW T S",WEIGHTINGS="W EY T IH NG Z",LICHTBLAU="L IH CH T B L AW",UNCOVERS="AH N K AH V ER Z",ARRIETA="AA R IY T AH",SCHUTZMAN="SH AH T Z M AH N",NOLANA="N OW L AE N AH",AUDITORY="AO D IH T AO R IY",KROTKOV="K R AO T K AO V",MARUCA="M ER UW K AH",ZILLIONS="Z IH L Y AH N Z",["ANCESTOR'S"]="AE N S EH S T ER Z",MOLDS="M OW L D Z",EMILIO="AH M IY L IY OW",SCATTER="S K AE T ER",DOWNGRADING="D AW N G R EY D IH NG",FAIRCLOUGH="F EH R K L AW",OUTED="AW T AH D",["FREY'S"]="F R EY Z",["GREY'S"]="G R EY Z",JILLIONS="JH IH L Y AH N Z",MILLIONS="M IH L Y AH N Z",COMPAQ="K AA M P AE K",BILLIONS="B IH L Y AH N Z",["THOMAS'(2)"]="T AA M AH S",COUNTERBIDS="K AW N T ER B IH D Z",CANOES="K AH N UW Z",MALOUF="M AE L OW F",PRIVATIZE="P R IH V AH T AY Z",ETCHINGS="EH CH IH NG Z",THOLEN="TH AA L AH N",["LEAPT(2)"]="L IY P T",["STUART'S(2)"]="S T Y UW ER T S",POULTICE="P OW L T AH S",["ZUCHOWSKI(2)"]="Z UW K AO F S K IY",RESERVISTS="R IH Z ER V IH S T S",ELLICOTT="EH L IH K AA T",YAHOOS="Y AA HH UW Z",ALONGS="AH L AO NG Z",ELLYSON="EH L IH S AH N",APRODIVA="AE P R AO D IY V AH",ALLYSON="AE L IH S AH N",HIERARCHY="HH AY ER AA R K IY",PANPHILA="P AE N F IH L AH",CHUGGED="CH AH G D",CASING="K EY S IH NG",BASING="B EY S IH NG",REFINES="R IH F AY N Z",FOLDS="F OW L D Z",CAPLIN="K AE P L IH N",EASING="IY Z IH NG",HOLDS="HH OW L D Z",KAPLIN="K AE P L IH N",MALLEABILITY="M AE L IY AH B IH L AH T IY",DEFINES="D IH F AY N Z",SATIRIZES="S AE T ER AY Z IH Z",["MEDINA(2)"]="M AH D IY N AH",MISPRINTED="M IH S P R IH N T AH D",NITROUS="N IH T R AH S",MATED="M EY T IH D",GATED="G EY T IH D",HATED="HH EY T AH D",["THEORIES(2)"]="TH IY ER IY Z",SATED="S EY T IH D",JOYNES="JH OY N Z",PRASEK="P R AA S EH K",MUSING="M Y UW Z IH NG",TEMPERAMENT="T EH M P R AH M AH N T",PRONGS="P R AO NG Z",FITZSIMMONS="F IH T S IH M AH N Z",["DEATHERAGE(2)"]="D EH TH R IH JH",["ELITISM(2)"]="EY L IY T IH Z AH M",["SOBIBOR(2)"]="S OW B IH B AO R",FROMM="F R AA M",BROMM="B R AA M",MOUNT="M AW N T",MARSDEN="M AA R S D AH N",POWERBALL="P AW ER B AO L",BOTTOMLEY="B AA T AH M L IY",COUNT="K AW N T",VENTURESOME="V EH N CH ER S AH M",HOWCROFT="HH AW K R AH F T",YOUNT="Y AW N T",SAMARANCH="S AE M ER AE N CH",["MANIFESTO(2)"]="M AE N IH F EH S T OW",DATED="D EY T IH D",FATED="F EY T IH D",BATED="B EY T IH D",INCOMPETENT="IH N K AA M P AH T AH N T",SIGNATURE="S IH G N AH CH ER",GLOVES="G L AH V Z",TRAVELING="T R AE V AH L IH NG",["CHALK(2)"]="CH AO K",LOZENGE="L AO Z AH N JH",DISORGANIZATION="D IH S AO R G AH N AH Z EY SH AH N",SLOVES="S L OW V Z",RECOVERS="R IH K AH V ER Z",WHISKED="W IH S K T",TRANSFERS="T R AE N S F ER Z",CLOVES="K L OW V Z",RECLAMATION="R EH K L AH M EY SH AH N",["CAMERA'S"]="K AE M R AH Z",UNTED="AH N T EH D",CADENCE="K EY D AH N S",FEMORAL="F EH M ER AH L",["WHEN(4)"]="HH W IH N",["METHODICALLY(2)"]="M AH TH AA D IH K L IY",VANGUNDY="V AH NG G AH N D IY",BONKOWSKI="B AH NG K AO F S K IY",UZBEK="UW Z B EH K",WILLAM="W IH L AH M",JOZWIAK="Y AA Z V IY AE K",ROSECRANS="R OW Z K R AE N Z",KILLAM="K IH L AH M",GILLAM="G IH L AH M",ANTED="AE N T IH D",ROBINHOOD="R AA B IH N HH UH D",PASING="P EY S IH NG",MOTTOLA="M OW T OW L AH",["HAPOALIM(2)"]="HH AH P OW AH L IY M",["OHIO'S"]="OW HH AY OW Z",MARTELLO="M AA R T EH L OW",ESTROUS="EH S T R AH S",["ROLLINS'S"]="R AA L IH N Z IH Z",MACCARONE="M AE K ER OW N",ASTRINGENTS="AH S T R IH N JH AH N T S",MARIETTA="M EH R IY EH T AH",["COLLINS'S"]="K AA L IH N Z IH Z",SCHICK="SH IH K",["RESENTED(2)"]="R IY Z EH N AH D",PARFAITS="P AA R F EY Z",BOTULISM="B AA CH UW L IH Z AH M",RELIVED="R IY L IH V D",BENDS="B EH N D Z",ABRAXA="AH B R AE K S AH",AJAR="AH JH AA R",EMBATTLED="EH M B AE T AH L D",BURNT="B ER N T",IGNACIO="IH G N AA S IY OW",VENTS="V EH N T S",TOIBIN="T OY B IH N",NOWAKOWSKI="N AW AH K AO F S K IY",DISSATISFIED="D IH S AE T AH S F AY D",["ERASE(2)"]="IY R EY S",AMAR="AH M AA R",MONDADORI="M AA N D AH D AO R IY",VIRULENTLY="V IH R AH L AH N T L IY",["DRACO(2)"]="D R AE K OW",DISGUISES="D IH S G AY Z IH Z",AIRLIFTS="EH R L IH F T S",["HMONG(2)"]="HH M AO NG",["ENDOTRONICS'"]="EH N D AH T R AA N IH K S",PANTS="P AE N T S",REHEARING="R IY HH IY R IH NG",["BEURY'S"]="B ER IY Z",CHAR="CH AA R",BENEDICK="B EH N AH D IH K",HOOSIER="HH UW ZH ER",COHOSTS="K OW HH OW S T S",VIBRATIONS="V AY B R EY SH AH N Z",LANDS="L AE N D Z",KRONENBERG="K R AA N AH N B ER G",HANDS="HH AE N D Z",SANDS="S AE N D Z",PHAR="F AA R",RANDS="R AE N D Z",LESSARD="L EH S ER D",CORPSE="K AO R P S",FRITOS="F R IY T OW Z",WANDS="W AA N D Z",ROUNTREE="R AW N T R IY",["UENOHARA(2)"]="UW EY N OW HH AA R AH",["KATO'S"]="K EY T OW Z",["NATO'S"]="N EY T OW Z",IPOD="AY P AO D",HUGELY="HH Y UW JH L IY",LASTLY="L AE S T L IY",FORMALIZED="F AO R M AH L AY Z D",DOSCHER="D AO SH ER",["JEWELSBURG(2)"]="JH UW L Z B ER G",DONAVAN="D AA N AH V AE N",NORMALIZED="N AO R M AH L AY Z D",MCCLESKEY="M AH K L EH S K IY",AFAR="AH F AA R",WHALERS="W EY L ER Z",ELOCUTIONS="EH L AH K Y UW SH AH N Z",AUDIO="AA D IY OW",REVITALIZING="R IY V AY T AH L AY Z IH NG",BANDS="B AE N D Z",ROSCHER="R AO SH ER",["MCNAMARA'S"]="M AE K N AH M EH R AH Z",["HARTSTEIN(2)"]="HH AA R T S T IY N",DEALERS="D IY L ER Z",COUNTERBALANCED="K AW N T ER B AE L AH N S T",HEALERS="HH IY L ER Z",WANTS="W AA N T S",NIBBLING="N IH B AH L IH NG",COASTAL="K OW S T AH L",JIAR="JH IY AA R",BRICCETTI="B R IH CH EH T IY",LIAR="L AY ER",KURKJIAN="K ER K JH IY AH N",GOOSEBERRY="G UW S B EH R IY",FULLWOOD="F UH L W UH D",["DNASE(2)"]="D IY EH N EY Z",DOREMUS="D AO R IH M IH S",SEAR="S IH R",TEAR="T EH R",PETRICIOLI="P EH T R IH S IY OW L IY",LUSCHER="L AH SH ER",PEAR="P EH R",REAR="R IH R",LAYERED="L EY ER D",WEAR="W EH R",YEAR="Y IH R",RONDINELLI="R OW N D IY N EH L IY",MISIMPRESSION="M IH S IH M P R EH SH AH N",AMBRIZ="AE M B R IH Z",GIMLIN="G IH M L IH N",ADAR="AH D AA R",WOBBLING="W AA B AH L IH NG",SECRETS="S IY K R AH T S",INCLINE="IH N K L AY N",TIMLIN="T IH M L IH N",CLINICS="K L IH N IH K S",GOBBLING="G AA B AH L IH NG",HOBBLING="HH AA B AH L IH NG",LICENCE="L AY S AH N S",BOBBLING="B AO B L IH NG",["RIKELD(2)"]="R IH K EH L D",GLOD="G L AA D",BOOKMAKING="B UH K M EY K IH NG",HAYLOFT="HH EY L AO F T",PLOWMAN="P L AW M AH N",EHUD="EH HH AH D",OPEL="OW P AH L",CLASSING="K L AE S IH NG",MOVIETIME="M UW V IY T AY M",["INTRINSICALLY(2)"]="IH N T R IH N S IH K L IY",CRIMINOLOGISTS="K R IH M IH N AA L AH JH IH S T S",SAMPLED="S AE M P AH L D",SUBJUGATE="S AH B JH AH G EY T",BACILLUS="B AH S IH L AH S",ELBRUS="EH L B R AH S",TSAR="Z AA R",BERNSTEINS="B ER N S T AY N Z",PERTURBING="P ER T ER B IH NG",ENDOWING="EH N D AW IH NG",JOEL="JH OW AH L",NOEL="N OW EH L",POEL="P OW AH L",NOCERA="N OW CH EH R AH",RUCCI="R UW CH IY",AMASSING="AH M AE S IH NG",["DENSMORE(2)"]="D EH N S M AO R",HOEL="HH OW L",LUCCI="L UW CH IY",MUCCI="M UW CH IY",OURS="AW ER Z",PUCCI="P UW CH IY",JURS="JH ER Z",AGILITY="AH JH IH L AH T IY",KEFAUVER="K EH F AW V ER",FURS="F ER Z",BUCCI="B UW CH IY",CUCCI="K UW CH IY",TOMLIN="T AA M L IH N",FUCCI="F UW CH IY",GUCCI="G UW CH IY",ROWING="R OW IH NG",SOWING="S OW IH NG",REPENTED="R IH P EH N T IH D",ALUMAX="AE L UW M AE K S",TOWING="T OW IH NG",ABANDONED="AH B AE N D AH N D",ANGLOS="AE NG G L OW Z",RAIMOND="R EY M AH N D",["CAT-O-NINE-TAILS"]="K AE T OW N AY N T EY L Z",MINTS="M IH N T S",ABILITY="AH B IH L AH T IY",["SIXTY'S"]="S IH K S T IY Z",YADDA="Y AA D AH",HINTS="HH IH N T S",BOLSTERED="B OW L S T ER D",CANAVAN="K AE N AH V AE N",PINTS="P AY N T S",KIRCHER="K ER K ER",MARZOTTO="M AA R Z AA T OW",CSAR="Z AA R",MOTIVATIONAL="M OW T AH V EY SH AH N AH L",EMEL="EH M AH L",DISCONCERTING="D IH S K AH N S ER T IH NG",IMEL="IH M AH L",IMCERA="IH M S EH R AH",GRACEFFA="G R AH S EH F AH",SUMLIN="S AH M L IH N",SPAR="S P AA R",IKENBERRY="AY K AH N B EH R IY",NALBONE="N AE L B OW N",BELCOURT="B EH L K AO R T",CASUALNESS="K AE ZH AH W AH L N EH S",RECONDITIONED="R IY K AH N D IH SH AH N D",SHOVES="SH AH V Z",KATAYAMA="K AA T AA Y AA M AH",PLUGGED="P L AH G D",TUINSTRA="T UW IH N S T R AH",FLUD="F L AH D",SOAR="S AO R",DERIDED="D IH R AY D IH D",ROAR="R AO R",["LUSITANIA'S"]="L UW S AH T EY N IY AH Z",["MEETING'S"]="M IY T IH NG Z",FOYT="F OY T",HOYT="HH OY T",PREFERREDS="P R IY F ER AH D Z",AKEL="AH K EH L",BOWING="B OW IH NG",COWING="K AW IH NG",MCLOUTH="M AH K L AW TH",ACTIVASE="AE K T IH V EY Z",HUMORAL="HH Y UW M ER AH L",LOWING="L OW IH NG",MOWING="M AW IH NG",ERRORFUL="EH R ER F AH L",KERCHER="K ER K ER",DESTEC="D EH S T EH K",CENTS="S EH N T S",OMAR="OW M AA R",VERCHER="V ER K ER",CURBOW="K ER B OW",TAPESTRY="T AE P AH S T R IY",KLAR="K L AA R",NIOBIUM="N AY OW B IY AH M",TENTS="T EH N T S",PROFLIGACY="P R AO F L IH G AE S IY",ALAR="EY L AA R",NEDDA="N EH D AH",CLAR="K L AA R",LENTS="L EH N T S",APPRECIATION="AH P R IY SH IY EY SH AH N",CRYTZER="K R AY T Z ER",PIEL="P IY L",NIEL="N IY L",KIEL="K IY L",GIEL="JH IY L",["REPEATED(2)"]="R IY P IY T AH D",FIEL="F IY L",CIEL="S IY L",DIEL="D IY L",COUPONING="K UW P AA N IH NG",BIEL="B IY L",HAPPY="HH AE P IY",GRENNAN="G R EH N AH N",GOAR="G AO R",HOAR="HH AO R",["PIERCE'S"]="P IH R S IH Z",DRENNAN="D R EH N AH N",COAR="K AO R",DOAR="D AO R",BOAR="B AO R",SLUGGED="S L AH G D",EXEL="EH K S AH L",CZAR="Z AA R",BADAVATZ="B AE D AH V AE T S",MENZIONE="M EH N Z IY OW N IY",SOBEK="S OW B IH K",BRENNAN="B R EH N AH N",AZAR="AA Z AA R",VOLUMINOUS="V AH L UW M AH N AH S",GABORIAULT="G AE B ER IY OW",GIGLIO="JH IH G L IY OW",BERNT="B ER N T",PUTRID="P Y UW T R IH D",BOBEK="B OW B IH K",OVERTLY="OW V ER T L IY",DOBEK="D OW B IH K",CLINTONOMICS="K L IH N T AH N AA M IH K S",CARETAKER="K EH R T EY K ER",AXEL="AE K S AH L",["ABDUCTIONS(2)"]="AH B D AH K SH AH N Z",THAWS="TH AO Z",["WHEATEN(2)"]="HH W IY T AH N",["UNCLE'S"]="AH NG K AH L Z",ENCOUNTERING="EH N K AW N T ER IH NG",ARBORETUM="AA R B ER IY T AH M",PACIFIST="P AE S IH F IH S T",PEREMPTORY="P ER EH M P T ER IY",CONNOISSEURS="K AA N AH S ER Z",DEMOV="D EH M AA V",OJEDA="OW Y EY D AH",EVEL="EH V AH L",LANDVIEW="L AE N D V Y UW",ASTRID="AE S T R IH D",GREEKS="G R IY K S",MOSTLY="M OW S T L IY",SUGARCANE="SH UH G ER K EY N",CREEKS="K R IY K S",PARCHER="P AA R CH ER",COSTLY="K AA S T L IY",IKEDA="IH K EY D AH",STOCKYARDS="S T AA K Y AA R D Z",BACKSIDE="B AE K S AY D",VENOUS="V IY N AH S",SULZBACH="S AH L Z B AA K",FUEL="F Y UW AH L",MIXING="M IH K S IH NG",CAPITOLS="K AE P IH T AH L Z",THEDA="TH IY D AH",["HUCKELBY'S"]="HH AH K AH L B IY Z",FIXING="F IH K S IH NG",["PARFUMS(2)"]="P AA R F Y UW M Z",RUEL="R UW L",PRESAGED="P R EH S IH JH D",QUEL="K W EH L",FORS="F ER Z",ALESI="AA L EH S IY",MAZZOLI="M AH Z OW L IY",HORS="HH AO R Z",LANTERNS="L AE N T ER N Z",["DIVORCEE(2)"]="D AH V AO R S EY",BUEL="B Y UW L",AUEL="AW AH L",WASHINGTONIAN="W AA SH IH NG T OW N IY AH N",BUMPERSTICKER="B AH M P ER S T IH K ER",ITEL="AY T EH L",PAMOUR="P AE M AO R",["CEDRIC(2)"]="S IY D R IH K",IVAR="IH V ER",["FERNANDEZ(2)"]="F EH R N AE N D EH Z",BORS="B AO R Z",MTEL="EH M T EH L",ERRS="EH R Z",MAEDA="M EY IY D AH",STIPE="S T AY P",GLUED="G L UW D",BLUED="B L UW D",ANDORRA="AE N D AO R AH",CLUED="K L UW D",SMIRK="S M ER K",["RETURNS'(2)"]="R IY T ER N Z",DYAR="D AY ER",["OFFENDED(2)"]="AH F EH N D IH D",["PROGRAM'S"]="P R OW G R AE M Z",IZOD="AY Z AA D",PRODUCER="P R AH D UW S ER",["DEFENDED(2)"]="D IH F EH N D IH D",AUCTIONEERS="AO K SH AH N IH R Z",ENTERITIDIS="EH N T ER IH T IH D IH S",IMMORAL="IH M AO R AH L",PARTITION="P AA R T IH SH AH N",AUTOLATINA="AO T OW L AH T IY N AH",PRODS="P R AA D Z",TROTS="T R AA T S",CHARTREUSE="SH AA R T R UW Z",WAYT="W EY T",FREL="F R EH L",TRAPELO="T R AH P EH L OW",MCCUBBIN="M AH K AH B AH N",OREL="AO R AH L",TRIPE="T R AY P",PLAVSIC="P L AE V S IH K",ALPHAMETRICS="AE L F AH M EH T R IH K S",AREL="AA R EH L",["CAESAR'S"]="S IY Z ER Z",VEXING="V EH K S IH NG",["EMERSON'S"]="EH M ER S AH N Z",BORDERING="B AO R D ER IH NG",CUISINART="K W IY S IH N ER T",BUCKSKINS="B AH K S K IH N Z",["PERIODICALLY(2)"]="P IY R IY AA D IH K L IY",WALESON="W EY L S AH N",["FATIMA(2)"]="F AE T IH M AH",DAMOUR="D AH M UH R",GLEDA="G L EY D AH",TRELLEBORG="T R EH L AH B AO R G",["ALLEGHENIES(2)"]="AE L AH G EH N IY Z",MICHALAK="M IH CH AH L AE K",["LADY'S"]="L EY D IY Z",COMPLICATED="K AA M P L AH K EY T AH D",PANAGOS="P AA N AA G OW Z",NESS="N EH S",CHEEKS="CH IY K S",["ARMBRISTER(2)"]="AA R M B R IH S T ER",FREEMASON="F R IY M EY S AH N",LESS="L EH S",KESS="K EH S",FESS="F EH S",HESS="HH EH S",JUSTLY="JH AH S T L IY",MAGLIO="M AE G L IY OW",ADSS="AE D S",FOODS="F UW D Z",HOODS="HH UH D Z",["RED-EYES"]="R EH D AY Z",MOODS="M UW D Z",BAGLIO="B AE G L IY OW",["COUNTERCHALLENGES(2)"]="K AW N ER CH AE L AH N JH AH Z",GAGLIO="G AE G L IY OW",WESS="W EH S",CRIPE="K R AY P",["C-SPAN"]="S IY S P AE N",GRIPE="G R AY P",SHANKEN="SH AE NG K AH N",BESS="B EH S",PRIMLY="P R IH M L IY",ANTICIPATIONS="AE N T IH S AH P EY SH AH N Z",QUARTERBACKING="K W AO R T ER B AE K IH NG",VORTEC="V AO R T EH K",BACKLIST="B AE K L IH S T",EPIDERMAL="EH P AH D ER M AH L",["HULBERT'S"]="HH AH L B ER T S",PORTEC="P AO R T EH K",WAXING="W AE K S IH NG",BUSHMAN="B UH SH M AH N",CUSHMAN="K UH SH M AH N",TAXING="T AE K S IH NG",KNIPE="N AY P",CLOSURE="K L OW ZH ER",ENGROSSED="IH N G R OW S T",SNIPE="S N AY P",RINDS="R AY N D Z",MINDS="M AY N D Z",KINDS="K AY N D Z",RATHBUN="R AE TH B AH N",RIZZOLI="R IH Z OW L IY",["TIETZE(2)"]="T IY T Z IY",HINDS="HH AY N D Z",FINDS="F AY N D Z",SHEEKS="SH IY K S",["ANDY'S"]="AE N D IY Z",WINDS="W IH N D Z",GROUNDWATER="G R AW N D W AA T ER",LULLABY="L AH L AH B AY",PISS="P IH S",BERWALD="B ER W AO L D",RISS="R IH S",ROOD="R UW D",FISS="F IH S",HISS="HH IH S",KISS="K IH S",WOOD="W UH D",MISS="M IH S",LISS="L IH S",UTILITY="Y UW T IH L AH T IY",CRINGE="K R IH N JH",MOOD="M UW D",LINEUP="L AY N AH P",YUKIO="Y UW K IY OW",FRINGE="F R IH N JH",WISS="W IH S",PERLITE="P ER L AY T",FOOD="F UW D",["GUARDIAN'S"]="G AA R D IY AH N Z",HOOD="HH UH D",PECKINPAUGH="P IH K IH N P AO",SCREENED="S K R IY N D",PASSIONATELY="P AE SH AH N AH T L IY",TROD="T R AA D",YOURSELFERS="Y AO R S EH L F ER Z",BIEDA="B IY D AH",KANAREK="K AE N ER IH K",AVOIDED="AH V OY D AH D",["OTTO'S"]="AA T OW Z",BABBLING="B AE B AH L IH NG",BISS="B IH S",DISS="D IH S",GARBO="G AA R B OW",NEWSSTANDS="N UW Z S T AE N D Z",BARBO="B AA R B OW",CARBO="K AA R B OW",PICKINGS="P IH K IH NG Z",GRADUAL="G R AE JH UW AH L",ZURCHER="Z ER K ER",BROD="B R AA D",SAMELSON="S AE M IH L S AH N",SPRAWLING="S P R AO L IH NG",SADEGHI="S AA D EH G IY",WILCOX="W IH L K AA K S",PORNOGRAPHIC="P AO R N AH G R AE F IH K",KANNENBERG="K AE N AH N B ER G",UNOSOM="Y UW N OW S AO M",DISGUSTING="D IH S G AH S T IH NG",["WEBSTER'S"]="W EH B S T ER Z",ENTANGLED="EH N T AE NG G AH L D",DANNENBERG="D AE N AH N B ER G",HAMLIN="HH AE M L IH N",["AUTO'S"]="AO T OW Z",MARANTETTE="M EH R AH N T EH T",TENDS="T EH N D Z",METACARPALS="M EH T AH K AA R P AH L Z",STRACKE="S T R AE K",SENDS="S EH N D Z",SHIRK="SH ER K",FENDS="F EH N D Z",LENDS="L EH N D Z",CHILDHOOD="CH AY L D HH UH D",BUZZELLI="B UW T S EH L IY",BURCHER="B ER CH ER",JOHANNESSEN="JH OW HH AE N IH S AH N",SCHAFER="SH EY F ER",CAREENED="K ER IY N D",CIACCIA="CH IY AH CH IY AH",WENDS="W EH N D Z",BANGKOK="B AE NG K AA K",HEYDON="HH EY D AH N",["HEIDLER(2)"]="HH AY D L ER",NIEBLING="N IY B AH L IH NG",LIEBLING="L IY B AH L IH NG",THIRDLY="TH ER D L IY",["PASO'S"]="P AE S OW Z",DRIVER="D R AY V ER",["BEIDLER(2)"]="B AY D L ER",SCHOOLMATES="S K UW L M EY T S",CORPORA="K AO R P ER AH",FRIDA="F R IY D AH",KLAHR="K L AE R",AFRIKANERS="AE F R IH K AA N ER Z",DIPLOMATIC="D IH P L AH M AE T IH K",PROCURED="P R OW K Y UH R D",ARIDA="AH R IY D AH",DAYLONG="D EY L AO NG",SKOLNIK="S K OW L N IH K",["PAINTED(3)"]="P EY N AH D",VOODOO="V UW D UW",SUPPLIED="S AH P L AY D",["VOYAGES(2)"]="V OY IH JH IH Z",["CATERPILLAR(2)"]="K AE T ER P IH L ER",PARFITT="P AA R F IH T",["INSOUCIANCE(2)"]="IH N S UW S Y AH N S",GOLDENBERG="G OW L D AH N B ER G",["FASO'S"]="F AA S OW Z",["PRESERVED(2)"]="P R IH Z ER V D",DIEGANS="D IY G AH N Z",TOTTEN="T AA T AH N",LIGHTHEADED="L AY T HH EH D AH D",HOFFART="HH AO F AA R T",DISPATCHED="D IH S P AE CH T",PROFFITT="P R AA F IH T",BOTTEN="B AA T AH N",DETERMINIST="D IH T ER M AH N AH S T",GOTTEN="G AA T AH N",REHABILITATION="R IY HH AH B IH L AH T EY SH AH N",["FELDBLUM(2)"]="F EH L D B L AH M",RIEDEL="R IY D AH L",CANTERRA="K AA N T EH R AH",STRIPER="S T R AY P ER",CHINATOWN="CH AY N AH T AW N",GERWIG="G ER W IH G",LIEDEL="L IY D AH L",RELORAL="R IY L AO R AH L",CAVED="K EY V D",["COASTAMERICA'S"]="K OW S T AH M EH R IH K AH Z",["ZEIDLER(2)"]="Z AY D L ER",["WEIDLER(2)"]="W AY D L ER",GUADALAJARA="G W AA D AH L AH HH AA R AH",PAVED="P EY V D",SAVED="S EY V D",LABYRINTHINE="L AE B ER IH N TH IY N",WAVED="W EY V D",RHAPSODIC="R AE P S AA D IH K",HAYDON="HH EY D AH N",KAYDON="K EY D AH N",BIRKHIMER="B ER K HH IH M ER",CASSELLS="K AE S AH L Z",PAREDES="P AA R EY D EH S",["AFRICANS(2)"]="AE F R IH K AH N Z",BETTORS="B EH T ER Z",CEREBRALLY="S ER IY B R AH L IY",MANGHAM="M AE NG G AH M",LANGHAM="L AE NG HH AE M",TRANSFIXED="T R AE N S F IH K S T",LAUDS="L AO D Z",CHARRIER="CH AE R IY ER",MCMENAMIN="M AH K M EH N AH M AH N",INDUCTOR="IH N D AH K T ER",DISBURSING="D IH S B ER S IH NG",ROEDEL="R OW D AH L",AUTHENTICATION="AO TH EH N T AH K EY SH AH N",CANDIDLY="K AE N D IH D L IY",COOVICK="K UW V IH K",["REJECTS(3)"]="R IH JH EH K S",SHANHOLTZER="SH AE N HH OW L T Z ER",PINHEIRO="P IY N HH EH R OW",["OLLINGER'S"]="AA L IH NG ER Z",["PERMITTED(2)"]="P ER M IH T IH D",WHISTLEBLOWER="W IH S AH L B L OW ER",["SPRINKLING(2)"]="S P R IH NG K AH L IH NG",["PATENTED(2)"]="P AE T AH N T IH D",MONTMORENCY="M AA N M AO R EH N S IY",MONTFORD="M AH N T F AO R D",RUDISILL="R AH D IH S IH L",GUIDA="G IY D AH",["POLAROID'S"]="P OW L ER OY D Z",POLYTROPIC="P AA L IY T R AO P IH K",SUBJECTED="S AH B JH EH K T IH D",["SEAWOLF'S"]="S IY W UH L F S",ASPARAGUS="AH S P EH R AH G AH S",MISALLOCATED="M IH S AE L AH K EY T IH D",EXCHANGERS="IH K S CH EY N JH ER Z",PRAYERS="P R EH R Z",TEANECK="T IY N EH K",BIDDIX="B IH D IH K S",BALSBAUGH="B AO L Z B AO",DEPLOY="D IH P L OY",BLAKEMORE="B L EY K M AO R",KETOU="K AH T UW",REBUTTING="R IH B AH T IH NG",HEFFERMAN="HH EH F ER M AH N",BERGSCHNEIDER="B ER G SH N AY D ER",OUTTEN="AW T AH N",CHIPETAS="CH IH P IY T AH Z",DECOMMISSION="D IY K AH M IH SH AH N",TROUSDALE="T ER AH S D EY L",CAUGHEY="K AO IY",["RAFFI'S"]="R AE F IY Z",["DRIVE'S"]="D R AY V Z",PERSISTENTLY="P ER S IH S T AH N T L IY",METROSEXUAL="M EH T R AH S EH K SH UW AH L",LORDS="L AO R D Z",["MICHELANGELO(2)"]="M IH K AH L AE N JH AH L OW",ZAWISTOWSKI="Z AA V IH S T AO F S K IY",WORDS="W ER D Z",BOXING="B AA K S IH NG",PLAYERS="P L EY ER Z",BELLSOUTH="B EH L S AW TH",BULIMIA="B Y UW L IH M IY AH",CORDS="K AO R D Z",THEMATICALLY="TH AH M AE T IH K L IY",GREENWALD="G R IY N W AO L D",PERONISTS="P EH R AH N IH S T S",["TAKESHITA'S"]="T AA K AH SH IY T AH Z",HANSARD="HH AE N S ER D",["GOODSPEED'S"]="G UH D S P IY D Z",HEADPHONES="HH EH D F OW N Z",["ESTABLISHMENT'S"]="EH S T AE B L IH SH M AH N T S",BORUCKI="B ER AH T S K IY",MAQUILADORA="M AE K W IH L AE D ER AH",BLISTERED="B L IH S T ER D",NAMELY="N EY M L IY",CHARLIER="CH AA R L IY ER",MURAYAMA="M ER AY AA M AH",GAMELY="G EY M L IY",SARRAZIN="S AA R AH Z IH N",LAMELY="L EY M L IY",["TOPSY-TURVY"]="T AA P S IY T ER V IY",FOLLOWER="F AA L OW ER",["NEVADA'S(2)"]="N AH V AA D AH Z",SCIENTOLOGY="S AY AH N T AA L AH JH IY",["COUNTERFEITING(2)"]="K AW N ER F IH T IH NG",["WHIPS(2)"]="HH W IH P S",["DUFFY'S"]="D AH F IY Z",SCOUR="S K AW ER",["HISTORIES(2)"]="HH IH S T R IY Z",["AGGRANDIZEMENT(2)"]="AH G R AE N D AY Z M AH N T",FISHBEIN="F IH SH B AY N",DIALTONE="D AY AH L T OW N",QUIRK="K W ER K",["RUDY'S"]="R UW D IY Z",WITKOWSKI="V IH T K AO F S K IY",FLOUR="F L AW ER",["DOROTEA(2)"]="D AO R AH T EY AH",BIRD="B ER D",HIGHFILL="HH AY F IH L",AIRD="EH R D",["RESO'S"]="R IY S OW Z",GIRD="G ER D",["PESO'S"]="P EY S OW Z",["ROSARIA'S"]="R OW Z AA R IY AH Z",MIDLINE="M IH D L AY N",GRANESE="G R AE N IY Z",["ANTIPHONS(2)"]="AE N T IH F AA N Z",MILITARISTIC="M IH L IH T ER IH S T IH K",LANGUAGES="L AE NG G W AH JH AH Z",CHRISTIANNE="K R IH S T IY AA N",CANNADAY="K AE N AH D EY",GAMBLER="G AE M B L ER",GRIMSHAW="G R IH M SH AO",["INTERFERE(2)"]="IH N ER F IH R",RAMESSES="R AE M AH S IH Z",["SALINGER'S"]="S EY L IH NG ER Z",THAYERS="TH EY ER Z",QUIVER="K W IH V ER",["PROSECUTION'S"]="P R AA S AH K Y UW SH AH N Z",CONCERTED="K AH N S ER T AH D",RAMBLER="R AE M B L ER",AMOUNTS="AH M AW N T S",STARCHER="S T AA R CH ER",PRUNEDALE="P R UW N D EY L",PITIESALPETRIERE="P IY T Y EY S AA L P EH T R IY EH R",SITCOMS="S IH T K AA M Z",MARCHESANI="M AA R K EH S AA N IY",LATOURETTE="L AE T UH R EH T",CORD="K AO R D",EXCLAMATION="EH K S K L AH M EY SH AH N",FORD="F AO R D",BURBACK="B ER B AE K",REAGANOMICS="R EY G AH N AA M IH K S",LORD="L AO R D",MORD="M AO R D",NORD="N AO R D",["BODY'S"]="B AA D IY Z",PARSIFAL="P AA R S IH F AH L",POTPOURRI="P OW P UH R IY",CRESCI="K R EH S IY",["ALDRIC(2)"]="AO L D R IH K",["DILIGENCE(2)"]="D IH L IH JH AH N S",EMPLOY="EH M P L OY",ASLESON="AE S L IH S AH N",SIGRIST="S IH G R IH S T",MUSKETEER="M AH S K AH T IY R",SCHWEINSBERG="SH W AY N S B ER G",GAZELLE="G AH Z EH L",CONLIN="K AA N L IH N",OUTSELLS="AW T S EH L Z",OFFERER="AO F ER ER",LURVEY="L ER V EY",PURVEY="P ER V EY",["YASSIR'S(2)"]="Y AA S IH R Z",HURVEY="HH ER V IY",["FIREBOMB(2)"]="F AY R B AA M",["ALLISTER(2)"]="AE L IH S T ER",["COLLECTORS'"]="K AH L EH K T ER Z",SOPHOMORE="S AA F M AO R",["TRIPLING(2)"]="T R IH P L IH NG",SPEWS="S P Y UW Z",SPYING="S P AY IH NG",["COUNTRIES'"]="K AH N T R IY Z",INDOMITABLE="IH N D AA M AH T AH B AH L",SKROCH="S K R AA K",DEVORE="D EH V ER",MERIDIONALE="M ER IH D IY AH N AA L IY",MOVED="M UW V D",LOVED="L AH V D",ABDUCTOR="AE B D AH K T ER",LOEWS="L OW Z",TOYING="T OY IH NG",CRUD="K R AH D",STIMSON="S T IH M S AH N",JOYING="JH OY IH NG",GUERRIER="G EH R IY ER",HOYING="HH OY IH NG",MCIVER="M AH K IH V ER",CARNATHAN="K AA R N AH TH AE N",DISSIDENTS="D IH S AH D AH N T S",MACKAY="M AH K EY",COLONISTS="K AA L AH N IH S T S",LUBBEN="L AH B AH N",HINDSIGHT="HH AY N D S AY T",PELLSTON="P EH L S T AH N",BACKBITE="B AE K B AY T",DECORATORS="D EH K ER EY T ER Z",["NOBLE'S"]="N OW B AH L Z",HANDWRITTEN="HH AE N D R IH T AH N",WEIRDLY="W IH R D L IY",MACHAMER="M AE K AH M ER",["ABRAM'S"]="EY B R AH M Z",["LEGENT'S"]="L EH JH AH N T S",SURVEY="S ER V EY",ADAPTORS="AH D AE P T ER Z",PONGRATZ="P AA NG G R AH T S",SCHERMER="SH ER M ER",DEMONSTRATES="D EH M AH N S T R EY T S",SEARCHER="S ER CH ER",FONTS="F AA N T S",BUYING="B AY IH NG",MIZELLE="M IH Z EH L",COSTA_RICA="K AO S T AH R IY K AH",DISMAYED="D IH S M EY D",PONTS="P AA N T S",STUD="S T AH D",CALCULATES="K AE L K Y AH L EY T S",MISDIRECTED="M IH S D IH R EH K T IH D",MAMMARY="M AE M ER IY",SCHLICHER="SH L IH K ER",KURODA="K ER OW D AH",["CHEMICAL(2)"]="K EH M IH K AH L",DEVIATED="D IY V IY EY T IH D",COHICK="K AA HH IH K",["BELVEDERE(2)"]="B EH L V IH D IH R",ELECTROSHOCK="IH L EH K T R OW SH AA K",["RUBLE'S"]="R UW B AH L Z",RUUD="R UW D",["CHENG-CHUNG"]="CH EH NG CH UH NG",DALGETY="D AE L G EH T IY",["O'RILEY"]="OW R AY L IY",BEETLES="B IY T AH L Z",BANDOLIERS="B AE N D AH L IH R Z",["PREPARING(2)"]="P ER P EH R IH NG",ECKROTE="EH K R AH T",NONCOMMUNISTS="N AA N K AA M Y UW N IH S T S",PREDESTINE="P R IY D EH S T AH N",DOEPKER="D OW P K ER",TRYING="T R AY IH NG",PELCZAR="P EH L CH ER",["GUARANTEE'S"]="G EH R AH N T IY Z",LOUD="L AW D",HEFFLER="HH EH F L ER",GESERUM="G AH S EH R AH M",BERNICE="B ER N IY S",LEFFLER="L EH F L ER",PRYING="P R AY IH NG",HAUGHEY="HH AO K IY",DRYING="D R AY IH NG",LANSDOWNE="L AE N S D AW N",SCUDS="S K AH D Z",CRYING="K R AY IH NG",FRYING="F R AY IH NG",CREWS="K R UW Z",PERNICE="P ER N IH S",NOBREGA="N AA B R IH G AH",KONARSKI="K AH N AA R S K IY",SCAR="S K AA R",["LAISSEZ(2)"]="L EH Z EY",GUTKOWSKI="G AH T K AO F S K IY",CARNATION="K AA R N EY SH AH N",ORIGINAL="ER IH JH AH N AH L",NETBACK="N EH T B AE K",SETBACK="S EH T B AE K",HANDCUFFING="HH AE N D K AH F IH NG",STRATEGIES="S T R AE T AH JH IY Z",RUTKOWSKI="R AH T K AO F S K IY",OBAR="AH B AA R",["COCKBURN'S"]="K OW B ER N Z",LABRIE="L AE B ER IY",CATERED="K EY T ER D",["VAUGHN'S"]="V AO N Z",FEUDS="F Y UW D Z",DOCUMENTING="D AA K Y AH M AH N T IH NG",["WRESTLING(2)"]="R EH S AH L IH NG",PARAGLIDE="P EH R AH G L AY D",BESPEAK="B IH S P IY K",DEAR="D IH R",OUTVOTED="AW T V OW T AH D",FEAR="F IH R",BEAR="B EH R",KEAR="K IH R",LEAR="L IH R",MEAR="M IH R",NEAR="N IH R",GEAR="G IH R",HEAR="HH IY R",WATERED="W AO T ER D",RESPEAK="R IY S P IY K",PAAR="P AA R",SAAR="S AA R",MACQUEEN="M AH K W IY N",COURTNEY="K AO R T N IY",SQUIRM="S K W ER M",POLYMER="P AA L AH M ER",ICONOCLASM="AY K AA N AH K L AE Z AH M",["GALI'S"]="G AA L IY Z",SKIVER="S K AY V ER",COMPANIONS="K AH M P AE N Y AH N Z",EMIGRANT="EH M AH G R AH N T",APPROACHED="AH P R OW CH T",PAPERBOARD="P EY P ER B AO R D",DIVED="D AY V D",CLIVER="K L AY V ER",EROTICA="IH R AA T IH K AH",CROSSTOWN="K R AO S T AW N",AMALEA="AE M AH L IY AH",SLIVER="S L IH V ER",KRISTOFFE="K R IH S T AO F",LAFOLLETTE="L AE F AH L EH T",OLIVER="AA L AH V ER",LIVED="L AY V D",ALUMINUM="AH L UW M AH N AH M",LAFAYETTE="L AA F IY EH T",VALCOURT="V AH L K AO R T",ANWYLL="AE N W IH L",CHIDESTER="CH IH D IH S T ER",["NEST-EGG"]="N EH S T EY G",["ROMANOV(2)"]="R OW M AH N AO F",["CUSO'S"]="K Y UW S OW Z",["BA'ATH(2)"]="B AH AA TH",CONVOLUTION="K AA N V AH L UW SH AH N",NEWFOUND="N UW F AW N D",PROHIBITIVE="P R OW HH IH B AH T IH V",PEKAREK="P EH K ER IH K",JETLINERS="JH EH T L AY N ER Z",ARMENDAREZ="AA R M EY N D AA R EH Z",TWENTIES="T W EH N T IY Z",["LONRHO'S"]="L AA N R OW Z",SCHEDULES="S K EH JH UH L Z",METERED="M IY T ER D",PETERED="P IY T ER D",WOODSTREAM="W UH D S T R IY M",ABSORBER="AH B Z AO R B ER",HAAR="HH AA R",FRISBEE="F R IH S B IY",MCNELIS="M AH K N EH L AH S",CLEWS="K L UW Z",COUNTERING="K AW N T ER IH NG",SIMCOX="S IH M K AA K S",["KITZHABER(2)"]="K IH T S HH AA B ER",FORFEITING="F AO R F AH T IH NG",SKEWS="S K Y UW Z",SLEEPILY="S L IY P AH L IY",COMMUNIQUE="K AH M Y UW N AH K EY",ROZELLE="R AH Z EH L",["MACY'S"]="M EY S IY Z",MOZELLE="M AH Z EH L",["GACY'S"]="G EY S IY Z",["ARDEN'S"]="AA R D AH N Z",ALMENDAREZ="AA L M EY N D AA R EH Z",["UNINTENTIONALLY(2)"]="AH N IH N T EH N SH N AH L IY",PUNTS="P AH N T S",JUMPY="JH AH M P IY",ENFORCEMENTS="EH N F AO R S M AH N T S",LUMPY="L AH M P IY",HUNTS="HH AH N T S",SHIVER="SH IH V ER",BUMPY="B AH M P IY",DUMPY="D AH M P IY",AUNTS="AE N T S",["PORT-ARTHUR"]="P AO R T AA R TH ER",AYATOLLAH="AY AH T OW L AH",ORCAS="AO R K AH S",MONOXIDE="M AH N AA K S AY D",FORBEARANCE="F AO R B EH R AH N S",UNDERCOOKED="AH N D ER K UH K T",ESTIMATED="EH S T AH M EY T AH D",DEVINNEY="D EH V IH N IY",EARLS="ER L Z",ANTARCTIC="AE N T AA R K T IH K",BEATEN="B IY T AH N",UNDERPOWERED="AH N D ER P AW ER D",NOODLE="N UW D AH L",POODLE="P UW D AH L",["BARONET(2)"]="B EH R AH N EH T",FLORESHEIM="F L AO R SH AY M",BASSETTI="B AA S EH T IY",MISDIRECT="M IH S D IH R EH K T",DUNNETT="D AH N IH T",WOODLE="W UH D AH L",BABUSHKAS="B AH B UH SH K AH Z",GARNIER="G AA R N IY ER",HEYDAY="HH EY D EY",["TESLA(2)"]="T EH Z L AH",WINDSHIELD="W IH N D SH IY L D",WOODLIEF="W UH D L IY F",LEONA="L IY OW N AH",KNODLE="N OW D AH L",BOODLE="B UW D AH L",DOODLE="D UW D AH L",PURPA="P ER P AH",["SANTA-CRUZ"]="S AE N T AH K R UW Z",BALLIETT="B AE L IY T",RICHARDSON="R IH CH ER D S AH N",THAWING="TH AO IH NG",HEDGEPETH="HH EH JH IH P EH TH",CITYFED="S IH T IY F EH D",SIMENTAL="S IH M EH N T AH L",PIMENTAL="P IH M EH N T AH L",CONSPIRATORS="K AH N S P IH R AH T ER Z",ADELPHA="AH D EH L F AH",STORMY="S T AO R M IY",BANKBOOK="B AE NG K B UH K",SACKRIDER="S AE K R AY D ER",AGONIES="AE G AH N IY Z",GROOVES="G R UW V Z",ESPOUSES="IH S P AW Z IH Z",PERISH="P EH R IH SH",["TWINS'"]="T W IH N Z",BACKSPIN="B AE K S P IH N",JACKRABBIT="JH AE K R AE B AH T",KINGDOM="K IH NG D AH M",DUBAS="D UW B AH Z",MIASMA="M IY AE Z M AH",KUBAS="K UW B AH Z",LUBAS="L UW B AH Z",["HOUSEMAN'S"]="HH AW S M AH N Z",HOLWEGER="HH OW L W IH G ER",MENATEP="M EH N AH T EH P",NOSTALGIA="N AO S T AE L JH AH",PEONIES="P IY AH N IY Z",MESOPOTAMIANS="M EH S AH P AH T EY M IY AH N Z",BUTTERFLY="B AH T ER F L AY",NAMESAKE="N EY M S EY K",SUTPHIN="S AH T F IH N",HELDS="HH EH L D Z",["MCENTEE(2)"]="M AH K EH N T IY",MONEYLINE="M AH N IY L AY N",BAEDEKER="B EY D AH K ER",MINORU="M IH N AO R UW",HOTTEL="HH AA T AH L",BOTTEL="B AA T AH L",VEGESNA="V EH G EH S N AH",EXPORTS="EH K S P AO R T S",["SAVINGS'"]="S EY V IH NG Z",DEMIRAG="D EY M IH R AA JH",["BOBBINGER'S"]="B AA B IH NG ER Z",DIONA="D IY OW N AH",FIONA="F IY OW N AH",["KINKO'S"]="K IH NG K OW Z",ASAHARA="AE S AH HH AE R AH",DIFELICE="D IH F EH L IH S",NONTAXABLE="N AA N T AE K S AH B AH L",REDIKER="R EH D IH K ER",BANPAIS="B AE N P EY",UNCONDITIONALLY="AH N K AH N D IH SH AH N AH L IY",SHONA="SH OW N AH",["KUSLER(2)"]="K AH S L ER",["RAIDERS'"]="R EY D ER Z",["GUSLER(2)"]="G AH S L ER",["DELICACY(2)"]="D EH L IH K AH S IY",BERISH="B ER IH SH",SCHERING="SH ER IH NG",MCCUTCHEN="M AH K AH CH AH N",NEIGHBOR="N EY B ER",["BYARD(2)"]="B AY ER D",JUGULAR="JH UW G Y AH L ER",PARISH="P AE R IH SH",LARZELERE="L ER Z EH L ER",JANEIRO="JH AH N EH R OW",DESPISING="D IH S P AY Z IH NG",["BUSLER(2)"]="B AH S L ER",PROPAGATING="P R AA P AH G EY T IH NG",DYBAS="D AY B AH Z",NOTEWARE="N OW T W EH R",CHIVAS="CH IY V AH S",MCPHERSON="M AH K F ER S AH N",VOLTAIRE="V OW L T EH R",QUADRUPLED="K W AA D R UW P AH L D",PLURALIZING="P L UH R AH L AY Z IH NG",MANIFESTS="M AE N AH F EH S T S",KOMAREK="K OW M AA R EH K",RENUZIT="R IY N UW Z IH T",MCNAY="M AH K N EY",ANGULAR="AE NG G Y AH L ER",MURDERING="M ER D ER IH NG",FLOIRENDA="F L OY R EH N D AH",LAMENTING="L AH M EH N T IH NG",GNAWING="N AO IH NG",ADVANCER="AH D V AE N S ER",ANECDOTAL="AE N AH K D OW T AH L",QUARTERDECK="K W AO R T ER D EH K",SMALLMAN="S M AO L M AH N",STRAY="S T R EY",GRUWELL="G R AH W EH L",PITILESS="P IH T IY L AH S",LENINISM="L EH N IH N IH Z AH M",["CYRIX'S"]="S AY R IH K S IH Z",PERLS="P ER L Z",["CENTER(2)"]="S EH N ER",IRKUTSK="ER K UH T S K",ELLIPTICAL="IH L IH P T IH K AH L",WEIRDNESS="W IH R D N AH S",FARISH="F EH R IH SH",["FOUNDATION'S"]="F AW N D EY SH AH N Z",ORATORY="AO R AH T AO R IY",JACQUEZ="Y AA K W EH Z",INCORPORATED="IH N K AO R P ER EY T AH D",THAKKAR="TH AE K ER",SUPPORTING="S AH P AO R T IH NG",["BAIRD'S"]="B EH R D Z",BRATWURST="B R AE T W ER S T",GARISH="G EH R IH SH",LATITUDES="L AE T AH T UW D Z",INTRIGUED="IH N T R IY G D",MARVELED="M AA R V EH L D",INAUGURATIONS="IH N AO G Y ER EY SH AH N Z",DANNA="D AE N AH",JANNA="JH AE N AH",["GOTTEN(2)"]="G AO T AH N",BERLS="B ER L Z",LANNA="L AE N AH",MANNA="M AE N AH",SANNA="S AE N AH",SCHUHMANN="SH UW M AH N",STIMULATES="S T IH M Y AH L EY T S",SKILLINGS="S K IH L IH NG Z",MONISM="M AA N IH Z AH M",PARATROOPERS="P EH R AH T R UW P ER Z",QUEENSWAY="K W IY N Z W EY",CORMICAN="K AO R M IH K AH N",RUNABOUT="R AH N AH B AW T",GOODFELLOWS="G UH D F EH L OW Z",LAENDERBANK="L AE N D ER B AE NG K",TABACHNECK="T AH B AA CH N EH K",["LIBERALIZE(2)"]="L IH B R AH L AY Z",["SUARD(2)"]="S W AA R D",CONSTRUCTORS="K AH N S T R AH K T ER Z",MAYDAY="M EY D EY",GOSLEE="G AA S L IY",MACKALL="M AE K AH L",BERTELSEN="B ER T IH L S AH N",PAYDAY="P EY D EY",MOSQUERA="M OW S K W EH R AH",MONNETT="M AA N IH T",MARSHALED="M AA R SH AH L D",MARTINI="M AA R T IY N IY",DUNBAR="D AH N B AA R",MONGELLI="M OW NG G EH L IY",KERESTES="K EH R IH S T S",ASTRINGENT="AH S T R IH N JH AH N T",PEEDIN="P IY D IH N",DURAY="D UH R EY",OSHAUGHNESSY="OW SH AA N IH S IY",SCHWINN="SH W IH N",JANEL="JH AE N AH L",HANEL="HH AE N AH L",AUTHORIZATION="AO TH ER AH Z EY SH AH N",SANWA="S AE N W AH",BONNETT="B AA N IH T",CONNETT="K AA N IH T",PANEL="P AE N AH L",DEVOTING="D IH V OW T IH NG",CLAWING="K L AO IH NG",PASTRIES="P EY S T R IY Z",DEMAREE="D EH M ER IY",ALPHA="AE L F AH",INTRACRANIAL="IH N T R AH K R EY N IY AH L",["KONG(2)"]="K AO NG G",["SKINS'"]="S K IH N Z",MERABANK="M EH R AH B AE NG K",INFIELDER="IH N F IY L D ER",["MOSLER(2)"]="M AA S L ER",CARDON="K AA R D AO N",["CADILLAC'S"]="K AE D AH L AE K S",["HOSLER(2)"]="HH AA S L ER",["INTERESTED(2)"]="IH N T R IH S T IH D",["VOSLER(2)"]="V AA S L ER",SCHOENECKER="SH OW N EH K ER",GOETTSCH="G OW T CH",ANITEC="AE N IH T EH K",["DONG(2)"]="D AO NG G",NOBODIES="N OW B AA D IY Z",LEMZO="L EH M Z OW",["PROCEED(2)"]="P R OW S IY D",INSTILLS="IH N S T IH L Z",["FILMMAKER'S"]="F IH L M EY K ER Z",RESULTED="R IH Z AH L T IH D",UBIQUITOUS="Y UW B IH K W IH T AH S",INEXPLICABLY="IH N IH K S P L IH K AH B L IY",MERSHON="M ER SH AH N",GERSHON="G ER SH AH N",GONYO="G OW N Y OW",YERDON="Y ER D AH N",NADERITES="N EY D ER AY T S",["FOSLER(2)"]="F AA S L ER",VERDON="V EH R D AO N",SHARUM="SH AA R AH M",["BOSLER(2)"]="B AA Z L ER",GAUGES="G EY JH AH Z",["KISLER(2)"]="K IH S L ER",TOGGLED="T AA G AH L D",["BERLINER'S(2)"]="B ER L AY N ER Z",RUSTPROOFING="R AH S T P R UW F IH NG",OVERLEVERAGED="OW V ER L EH V R IH JH D",["SISLER(2)"]="S IH S L ER",["ZHAO(2)"]="JH AW",MOUNTAINSIDES="M AW N T AH N S AY D Z",FREDIN="F R EH D IH N",TRIPLED="T R IH P AH L D",DITTOHEAD="D IH T OW HH EH D",BOGGLED="B AA G AH L D",ORGANIZATIONAL="AO R G AH N AH Z EY SH AH N AH L",MANUAL="M AE N Y UW AH L",ASCHENBACH="AE SH IH N B AA K",ESCHENBACH="EH SH IH N B AA K",HANDLE="HH AE N D AH L",SCHULL="SH UH L",CANDLE="K AE N D AH L",["CAPRI(2)"]="K AH P R IY",ARRAY="ER EY",BURGUNDIAN="B ER G AH N D IY AH N",ZYUGANOV="Z Y UW G AA N AA V",DETECTORS="D IH T EH K T ER Z",SHENICE="SH AH N IY S",INTELOGIC="IH N T AH L AA JH IH K",["INNOVATING(2)"]="IH N OW V EY T IH NG",["LISTENER(2)"]="L IH S N ER",["CISLER(2)"]="S IH S L ER",REEKING="R IY K IH NG",["FISLER(2)"]="F IH S L ER",["GISLER(2)"]="G IH S L ER",EXHORTING="IH G Z AO R T IH NG",FLAGMAN="F L AE G M AE N",LYNNA="L AY N AH",DOMINGO="D OW M IH NG G OW",MORAY="M ER EY",GRIVAS="G R IY V AA Z",FERDON="F EH R D AO N",YANDLE="Y AE N D AH L",["YOCHUM(2)"]="Y AA K AH M",OVERFLOW="OW V ER F L OW",LINKAGES="L IH NG K IH JH IH Z",DILLAHUNTY="D IH L AH HH AH N T IY",RANDLE="R AE N D AH L",LAZULITE="L AE Z AH L AY T",MANDLE="M AE N D AH L",HOOPOE="HH UW P UW",DABCHICK="D AE B CH IH K",HARTFORD="HH AA R T F ER D",EMBODIES="EH M B AA D IY Z",ANGLOPHILE="AE N G L AH F AY L",DECUIR="D EH K IH R",RAINFALL="R EY N F AO L",ANNIVERSARIES="AE N AH V ER S ER IY Z",["COUNSELLOR(2)"]="K AW N S L ER",THEORIES="TH IH R IY Z",SPRAY="S P R EY",["ANTI-INFECTIVE"]="AE N T IY IH N F EH K T IH V",AWAKENING="AH W EY K AH N IH NG",HANDYMEN="HH AE N D IY M EH N",["ASSOCIATES'(2)"]="AH S OW S IY AH T S",["TEACHERS'"]="T IY CH ER Z",DISTILLS="D IH S T IH L Z",WARCHOL="W AO R K AO L",ENLISTING="EH N L IH S T IH NG",GIRLS="G ER L Z",GALAMBOS="G AA L AA M B OW Z",WADAS="W AA D AH Z",VADAS="V AA D AA Z",["CORPS(2)"]="K AO R Z",STRENUOUSLY="S T R EH N Y UW AH S L IY",ROSSETTI="R OW S EH T IY",WEISSENBORN="W AY S IH N B ER N",LADAS="L AA D AH Z",HOELTERHOFF="HH OW L T ER HH AO F",RICHMOND="R IH CH M AH N D",TRAFFIC="T R AE F IH K",WILDS="W AY L D Z",REGULAR="R EH G Y AH L ER",CHOCOLATES="CH AO K L AH T S",COVERDELL="K AH V ER D EH L",HEINTZMAN="HH AY N T S M AH N",GREENSBORO="G R IY N Z B ER R OW",["HEADQUARTERS(2)"]="HH EH D K AO R T ER Z",SWAMPING="S W AA M P IH NG",CANCELLATIONS="K AE N S AH L EY SH AH N Z",AGASP="AH G AE S P",PERNICIARO="P ER N IY CH ER OW",["LEGITIMACY(2)"]="L IH JH IH T AH M AH S IY",BELLEMARE="B EH L AH M EH R",SEAGATE="S IY G EY T",BAKOS="B AA K OW Z",KAKOS="K EY K OW Z",MAVARACH="M AH V AA R AH CH",["DEFUSED(2)"]="D IY F Y UW Z D",ROYALLY="R OY AH L IY",REPENTANCE="R IH P EH N T AH N S",ANONA="AA N OW N AH",HAZLETON="HH EY Z AH L T AH N",ADVANTEST="AE D V AE N T AH S T",EMERYVILLE="EH M ER IY V IH L",SADOFF="S AE D AO F",FRANCHISES="F R AE N CH AY Z IH Z",MANNION="M AE N Y AH N",["AVERAGE(2)"]="AE V R AH JH",GOODINE="G UH D AY N",WACHOWIAK="V AH HH AW IY AE K",SPHINX="S F IH NG K S",BEDEVIL="B IH D EH V AH L",LOUDON="L AW D AH N",DEFELICE="D IH F EH L IH S",FLASHLIGHT="F L AE SH L AY T",SINSABAUGH="S IH N S AH B AO",["QUEBECKER(2)"]="K W EH B EH K ER",BLACKMAILING="B L AE K M EY L IH NG",INDUSTRIER="IH N D AH S T R IY ER",OLIVAS="OW L IY V AA Z",SENTIMENT="S EH N T AH M AH N T",UNCONSTITUTIONAL="AH N K AA N S T AH T UW SH AH N AH L",["GERGEN'S"]="G ER G AH N Z",MODESTIA="M OW D EH S T Y AH",LOATHING="L OW TH IH NG",DELISTING="D IY L IH S T IH NG",LIMEHOUSE="L AY M HH AW S",BRACCI="B R AA CH IY",HEADLUND="HH EH D L AH N D",PREVAILING="P R IH V EY L IH NG",["HOELTERHOFF'S"]="HH OW L T ER HH AO F S",TRAVOLTAS="T R AH V OW L T AH Z",CRIMSON="K R IH M Z AH N",DIMICELI="D IH M IY CH EH L IY",ANIMATIONS="AE N AH M EY SH AH N Z",ORONA="AO R OW N AH",SCHOOLCHILDREN="S K UW L CH IH L D R AH N",ACKLIN="AE K L IH N",DISBURSE="D IH S B ER S",WRONA="R OW N AH",MEDOFF="M EH D AO F",["MAHFOUZ'S"]="M AA F UW Z IH Z",SURELY="SH UH R L IY",SETTLEMIRE="S EH T AH L M AY R",PURELY="P Y UH R L IY",TLATELOCO="T L AE T IH L OW K OW",UNDERCLASS="AH N D ER K L AE S",EXABYTE="EH K S AH B AY T",KRONA="K R OW N AH",["NOVO'S"]="N OW V OW Z",RADCLIFFE="R AE D K L IH F",LEMPKE="L EH M P K",KEMPKE="K EH M P K",BERNIER="B ER N IY ER",ROHLOFF="R OW L AO F",STEINWAY="S T AY N W EY",BENNION="B EH N Y AH N",REINCARNATION="R IY IH N K AA R N EY SH AH N",MCQUISTON="M AH K W IH S T AH N",STALZER="S T EY L Z ER",SOLIMON="S OW L IH M AH N",["LEVITT'S"]="L EH V IH T S",["FASTENER(2)"]="F AE S N ER",DELBIANCO="D EH L B IY AA N K OW",DARPA="D AA R P AH",KIRCHGESSNER="K ER K G IH S N ER",MCWHINNEY="M AH K W IH N IY",RESEARCHERS="R IY S ER CH ER Z",BLESSEDLY="B L EH S AH D L IY",ESCAPES="IH S K EY P S",["CAUTIONED(2)"]="K AO SH AH N D",["KANG(2)"]="K AA NG",YAKLIN="Y AE K L IH N",WOODWORKING="W UH D W ER K IH NG",PENNA="P EH N AH",MENNA="M EH N AH",KENNA="K EH N AH",JENNA="JH EH N AH",ANONYMOUSLY="AH N AA N AH M AH S L IY",HENNA="HH EH N AH",ZENINA="Z EH N IY N AH",IRAQGATE="IH R AA K G EY T",CONLEE="K AA N L IY",CARMELA="K AA R M EH L AH",DISLOCATIONS="D IH S L OW K EY SH AH N Z",DONELSON="D AA N IH L S AH N",GARETT="G AE R IH T",DISPUTE="D IH S P Y UW T",MINKOFF="M IH NG K AO F",DILLIN="D IH L IH N",GABALDON="G AA B AA L D AO N",["DOGS'"]="D AO G Z",IPHEGENIA="IH F AH JH AH N AY AH",TURNOVERS="T ER N OW V ER Z",GRANVILLE="G R AE N V IH L",DEHAVEN="D EH HH AH V AH N",MILLIN="M IH L AH N",CHEETAL="CH IY T AH L",KILLIN="K IH L IH N",HILLIN="HH IH L IH N",GILLIN="G IH L IH N",BRILLIANCE="B R IH L Y AH N S",["DATARAM(2)"]="D AE T ER AE M",REFERING="R IH F ER IH NG",FONDLE="F AO N D AH L",RECONFIRM="R IY K AH N F ER M",COMMANDMENT="K AH M AE N D M AH N T",FULLBACKS="F UH L B AE K S",LARAWAY="L AE R AH W EY",PULLBACKS="P UH L B AE K S",["PRODUCER'S"]="P R AH D UW S ER Z",BLASTING="B L AE S T IH NG",EXCORIATION="EH K S K AO R IY EY SH AH N",KERSTEIN="K ER S T AY N",APPEALABLE="AH P IY L AH B AH L",SHOWA="SH OW AH",ZARETT="Z EH R AH T",RUBBERY="R AH B ER IY",MARTINDALE="M AA R T IH N D EY L",PURDON="P ER D AH N",["ACCENT(2)"]="AE K S EH N T",CHAUMET="CH AO M IH T",ZENNA="Z EH N AH",MCKISSACK="M AH K IH S AH K",GLANVILLE="G L AE N V IH L",MINNA="M IH N AH",["MISIDENTIFIES(2)"]="M IH S AY D EH N IH F AY Z",ALACRITY="AH L AE K R AH T IY",ANNUAL="AE N Y UW AH L",KINNETT="K IH N IH T",TAKAO="T AA K AA OW",STROLE="S T R OW L",["SACCO'S"]="S AE K OW Z",BERSTEIN="B ER S T IY N",WALDROOP="W AO L D R UW P",SCADDEN="S K AE D AH N",BURDON="B ER D AH N",NAKAO="N AA K AA OW",GERSTEIN="G ER S T AY N",LOUSED="L AW Z D",HOUSED="HH AW Z D",HARAWAY="HH AA R AH W EY",WILDCATTING="W AY L D K AE T IH NG",CARAWAY="K AE R AH W EY",ROUSED="R AW Z D",PRETERM="P R IY T ER M",ADOPTEES="AH D AA P T IY Z",CLOISTER="K L OY S T ER",WINNETT="W IH N IH T",DIAPER="D AY P ER",["MAHMOOD(2)"]="M AA M UW D",CANILLES="K AH N IH L IY Z",SUNDEWS="S AH N D UW Z",DURIO="D UH R IY OW",PLOWDEN="P L AW D AH N",HEROIZE="HH IY R OW AY Z",["BLITSTEIN(2)"]="B L IH T S T AY N",SEBEK="S EH B IH K",YOUNES="Y AH N Z",CATALOG="K AE T AH L AO G",DOUSED="D AW S T",VIZCAYA="V IH Z K AY AH",ZAJKOWSKI="Z AY K AO F S K IY",COCKING="K AA K IH NG",DOCKING="D AA K IH NG",CHECKUP="CH EH K AH P",HERETIC="HH EH R AH T IH K",CONTENDS="K AH N T EH N D Z",LOCKING="L AA K IH NG",MOCKING="M AA K IH NG",CHAMONIX="CH AE M AH N IH K S",ROCKING="R AA K IH NG",SOCKING="S AA K IH NG",COPLEN="K AA P AH L AH N",COLGLAZIER="K OW L G L AH Z IY ER",RADMILLA="R AE D M IH L AH",SNOWDEN="S N OW D AH N",SYLLABLE="S IH L AH B AH L",HOONAH="HH UW N AH",EXPEDITIONS="EH K S P AH D IH SH AH N Z",OSTROGOTH="AA S T R AH G AA TH",MEDIATED="M IY D IY EY T IH D",INTERSTELLAR="IH N T ER S T EH L ER",["ADELE'S"]="AH D EH L Z",PESOS="P EY S OW Z",NETIQUETTE="N EH T AH K AH T",LICKING="L IH K IH NG",BIRDSEYE="B ER D Z AY",CHALIFOUX="SH AE L IH F UW",KICKING="K IH K IH NG",AMUSED="AH M Y UW Z D",MCORP="EH M K AO R P",CHERISH="CH EH R IH SH",RECURRENT="R IH K ER AH N T",PICKING="P IH K IH NG",GLADDEN="G L AE D AH N",["CANUCKS(2)"]="K AH N AH K S",POTUCEK="P AA T AH CH EH K",CORRECTS="K ER EH K T S",CASTELLANOS="K AA S T EY L AA N OW Z",FRONTLINE="F R AH N T L AY N",LUPPINO="L UW P IY N OW",EICHENLAUB="AY K IH N L AW B",THORP="TH AO R P",BEISSEL="B AY S AH L",PAUSED="P AO Z D",CENTURION="S EH N T UH R IY AH N",SEEDPOD="S IY D P AA D",MAWHINNEY="M AE W IH N IY",ZELOTES="Z EH L AH T S",MAYHER="M EY ER",PARISIANS="P ER IH S IY AH N Z",NEORX="N IY OW R EH K S",FOLLIN="F AA L IH N",["TOILET'S"]="T OY L AH T S",["PAS-DE-DEUX"]="P AA D AH D UW",COLLIN="K AA L IH N",DAVISSON="D AE V IH S AH N",LUDMILLA="L AH D M IH L AH",NEPTUNE="N EH P T UW N",CHAPPEL="CH AE P AH L",BEETLEJUICE="B IY T AH L JH UW S",BOLLIN="B AA L IH N",GRADATE="G R EY D EY T",WALESA="W AH L EH S AH",ARZT="AA R Z T",SKADDEN="S K AE D IH N",MAXINE="M AE K S IY N",CALLOWAY="K AE L OW W EY",TRIGGER="T R IH G ER",GALLOWAY="G AE L OW W EY",EVINCED="IH V IH N S T",BLONDS="B L AA N D Z",DORNIER="D AO R N IH R",BINDLE="B IH N D AH L",["EXTRACT(2)"]="IH K S T R AE K T",ROLLBACKS="R OW L B AE K S",KINDLE="K IH N D AH L",HAKUHODO="HH AA K UW HH OW D OW",HINDLE="HH IH N D AH L",["CREDITOR(2)"]="K R EH D IH T ER",FUCKING="F AH K IH NG",DOOMSAYER="D UW M S EY ER",KNISPEL="N IH S P AH L",CHAPUT="CH AE P AH T",MUCKING="M AH K IH NG",LUCKING="L AH K IH NG",GRAVELLE="G R AH V EH L",PULLIN="P UH L IH N",WINDLE="W IH N D AH L",BOXWELL="B AA K S W EH L",FUNTIME="F AH N T AY M",MACGRAW="M AH G R AA",TUCKING="T AH K IH NG",PRIMETIME="P R AY M T AY M",CRIGGER="K R IH G ER",MCQUEEN="M AH K W IY N",CULLIN="K AH L IH N",["SOFTNESS(2)"]="S AO F N AH S",["WHITCHURCH(2)"]="HH W IH T CH ER CH",["DECONGESTANTS(2)"]="D IY K AH N JH EH S T AH N T S",FUDDRUCKERS="F AH D R AH K ER Z",RARDON="R AA R D AH N",["EVENTUALLY(3)"]="IY V EH N CH AH W AH L IY",RUSSOM="R AH S AH M",HAWKED="HH AO K T",MARDON="M AA R D AH N",SEIDL="S AY D AH L",GARCIAS="G AA R S IY AH Z",PARDON="P AA R D AH N",KIRSTEIN="K ER S T AY N",WINDMILL="W IH N D M IH L",COUTEE="K UW T IY",MONCURE="M OW N K UH R IY",OFFERING="AO F ER IH NG",BLUEPRINTS="B L UW P R IH N T S",DONSBACH="D AA N Z B AA K",AIRWORTHY="EH R W ER DH IY",JANINA="JH AH N IY N AH",ASSEMBLAGE="AH S EH M B L AH JH",VLASAK="V L AA S AH K",MICRONIC="M AY K R AO N IH K",SEAHOLM="S IY HH OW M",CALAHAN="K AE L AH HH AE N",GENNETT="JH EH N IH T",KINGSLEY="K IH NG Z L IY",PARAGRAPH="P AE R AH G R AE F",TEMPORIZE="T EH M P ER AY Z",DENNETT="D EH N IH T",BENNETT="B EH N AH T",["SCHORR'S"]="SH AO R Z",["DEPALMA'S"]="D IH P AA L M AH Z",YEREVAN="Y EH R AH V AH N",ANANIA="AA N AA N IY AH",["SARAJEVAN'S"]="S AA R AH Y EY V AH N Z",OUTSHINE="AW CH AY N",STOHLER="S T OW L ER",POLLINI="P AH L IY N IY",["CLEMENTE'S(2)"]="K L AH M EH N T IY Z",DUDASH="D AH D AH SH",TUBULAR="T UW B Y AH L ER",SUBURBIA="S AH B ER B IY AH",["QUARANTINING(2)"]="K W AO R AH N T AY N IH NG",SPIERING="S P AY ER IH NG",DEMYAN="D EH M Y AH N",KWIATKOWSKI="K W IY AH T K AO F S K IY",MERYLL="M EH R AH L",JOSEPHS="JH OW S IH F S",QUEENSBERRY="K W IY N Z B EH R IY",WRAPPED="R AE P T",KENNETT="K EH N AH T",["OVIATT'S"]="OW V IY AA T S",PAROLE="P ER OW L",LINDENMUTH="L IH N D IH N M UW TH",["IRAQIS(3)"]="AY R AE K IY Z",["INTERIM(2)"]="IH N T R AH M",["COCKED(2)"]="K AO K T",DILIGENTLY="D IH L AH JH AH N T L IY",FLAGDAY="F L AE G D EY",BUDDHA="B UW D AH",["HOT-SHOT"]="HH AA SH AA T",BUGABOO="B AH G AH B UW",DENWA="D EH N W AA",VALUELESS="V AE L Y UW L AH S",READIER="R EH D IY ER",UNSOLICITED="AH N S AH L IH S IH T IH D",CAROLE="K AE R AH L",SCHOCH="SH AA K",CULMINATION="K AH L M AH N EY SH AH N",ABUSED="AH B Y UW Z D",MANICURIST="M AE N IH K Y ER IH S T",TRANSACT="T R AE N Z AE K T",["ISOMEDIX'S"]="AY S OW M EH D IH K S IH Z",SYMBOLS="S IH M B AH L Z",SCHRECENGOST="SH R EH S IH NG G AH S T",NATIONALISTS="N AE SH AH N AH L IH S T S",MASTERBATES="M AE S T ER B EY T S",PARTICIPANT="P AA R T IH S AH P AH N T",["PATRIMONIAL(2)"]="P AE T R AH M OW N IY AH L",ASHTEC="AE SH T EH K",SAUCEDA="S AW S EY D AH",GOMORRAH="G AH M AO R AH",["CARBERRY'S"]="K AA R B EH R IY Z",MILGRAM="M IH L G R AE M",AERONAUTICAS="EH R OW N AO T IH K AH S",UNWELCOMED="AH N W EH L K AH M D",PILGRAM="P IH L G R AH M",CAUSED="K AA Z D",SNEDEKER="S N EH D IH K ER",SNAPPED="S N AE P T",HISCOX="HH IH S K AA K S",PEJORATIVE="P AH JH AO R AH T IH V",PINPOINTS="P IH N P OY N T S",BREATHING="B R IY DH IH NG",CARLSBAD="K AA R L S B AE D",["ABSOLVED(2)"]="AE B Z AA L V D",["ROCCO'S"]="R AA K OW Z",PRECISE="P R IH S AY S",REUSED="R IY UW Z D",EXTRUDING="IH K S T R UW D IH NG",["CONDUIT(2)"]="K AA N JH UW IH T",RISDON="R IH S D AH N",STAVROS="S T AH V R OW Z",["CAMBRIAN'S"]="K AE M B R IY AH N Z",CONVINCING="K AH N V IH N S IH NG",COMPETITORS="K AH M P EH T AH T ER Z",["FLUHR(2)"]="F L UH R",CRUTHIRDS="K R AH TH ER D Z",["HATLER(2)"]="HH EY T L ER",["CLIENT'S"]="K L AY AH N T S",GORTARI="G AO R T AA R IY",IRONIES="AY R AH N IY Z",["WIENERSCHNITZEL(2)"]="V IY N ER SH N IH T S AH L",WALLIN="W AO L IH N",CRONIES="K R OW N IY Z",DISCOUNTERS="D IH S K AW N T ER Z",CORROSION="K ER OW ZH AH N",CYCLADES="S AY K L EY D IY Z",SYNERGETIC="S IH N ER JH EH T IH K",HERSOM="HH ER S AH M",HEIMSOTH="HH AY M S AH TH",CURRICULUMS="K ER IH K Y AH L AH M Z",["HEWITT'S"]="HH Y UW IH T S",["TOMATOE(2)"]="T AH M AA T OW",DISQUALIFY="D IH S K W AA L AH F AY",OLIVARES="OW L IY V AA R EH S",PLATEN="P L AE T AH N",BALLIN="B AE L IH N",DIFFERENCES="D IH F ER AH N S IH Z",ELSDON="EH L S D AH N",["SAN-JUAN"]="S AE N W AA N",MALLIN="M AE L IH N",HALLIN="HH AE L IH N",PROFESSIONALISM="P R AH F EH SH AH N AH L IH Z AH M",VINCELETTE="V IH N S IH L EH T",WANAMAKER="W AA N AH M EY K ER",COASTING="K OW S T IH NG",BOASTING="B OW S T IH NG",PRIVATIZATIONS="P R AY V AH T AH Z EY SH AH N Z",GEODESY="JH IY AA D AH S IY",STARACE="S T AA R AA CH IY",ROKOSZ="R AA K AH SH",TROYKA="T R OY K AH",FLATEN="F L AE T AH N",MCCOWIN="M AH K AW IH N",MARIUSA="M AA R IY Y UW S AH",MOONIES="M UW N IY Z",REDOING="R IY D UW IH NG",SYMPHONIES="S IH M F AH N IY Z",INCONTROVERTIBLE="IH NG K AA N T R OW V ER T IH B AH L",["WORSECK(2)"]="W AO R S EH K",TOKYO="T OW K IY OW",NOKYO="N OW K Y OW",["GRINDLAY(2)"]="G R IH N D L IY",MERCHANTMEN="M ER CH AH N T M IH N",ACCENTED="AE K S EH N T IH D",MASSERY="M AE S ER IY",COLICCHIO="K OW L IH K IY OW",OLDFATHER="OW L D F AA DH ER",DOCUMENTATION="D AA K Y AH M EH N T EY SH AH N",YELLIN="Y EH L IH N",CHICAGOAN="CH IH K AH G OW N",MIDTERM="M IH D T ER M",LEAVENWORTH="L EH V AH N W ER TH",GANNETT="G AE N IH T",INTIMATED="IH N T AH M EY T IH D",SWATH="S W AA TH",["RELINQUISHED(2)"]="R IY L IH NG K W IH SH T",GREASEWOOD="G R IY S W UH D",KYOWA="K Y OW AH",OUTPACING="AW T P EY S IH NG",DOWD="D AW D",["ANIMATED(2)"]="AE N AH M EY T IH D",UNDERPAYING="AH N D ER P EY IH NG",BROADSWORD="B R AO D S AO R D",DVORACEK="D V AO R AH CH EH K",["WIRELESS'S"]="W AY ER L AH S IH Z",JORDON="JH AO R D AH N",FEMINA="F EH M IH N AH",BELLIN="B EH L IH N",GORDON="G AO R D AH N",FELLIN="F EH L IH N",GRISWOLD="G R IH S W OW L D",CROWDEN="K R AW D AH N",DUNAVAN="D AH N AH V AE N",KERBOW="K ER B OW",SELLIN="S EH L IH N",["MESSIAEN'S"]="M EH S IY EY N Z",GONNA="G AA N AH",DONNA="D AA N AH",KUROSAWA="K UH R OW S AA W AH",PRESIDENCY="P R EH Z AH D AH N S IY",RONNA="R AA N AH",DISCLAND="D IH S K L AE N D",CORDON="K AO R D AH N",ARZOLA="AA R Z OW L AH",SOLLOWAY="S AA L OW W EY",HOLLOWAY="HH AA L OW W EY",CENTIME="S EH N T AY M",FELLINI="F AH L IY N IY",KLEIST="K L AY S T",BELLINI="B EH L IY N IY",SMOKESTACKS="S M OW K S T AE K S",CRUMBY="K R AH M B IY",JUSTIFIABLE="JH AH S T AH F AY AH B AH L",SINAY="S IH N EY",YUTAKA="Y UW T AA K AH",SALVAS="S AA L V AA Z",PIONEERING="P AY AH N IH R IH NG",CURSED="K ER S T",NONRESIDENTIAL="N AA N R EH Z AH D EH N SH AH L",RHINESTONES="R AY N S T OW N Z",FETISH="F EH T IH SH",ATTEMPTED="AH T EH M P T AH D",PERPLEX="P ER P L EH K S",DOCKYARD="D AA K Y AA R D",NURSED="N ER S T",SEIZES="S IY Z IH Z",PURSED="P ER S T",INFIDELITIES="IH N F IH D EH L IH T IY Z",SHIROMA="SH IH R OW M AH",["ADVISEDLY(2)"]="AH D V AY Z AH D L IY",GASAWAY="G AE S AH W EY",BASURTO="B AA S UH R T OW",BOYD="B OY D",STERBENZ="S T ER B IH N S",WEYLIN="W EY L IH N",["JACOBS'"]="JH EY K AH B Z",["YIRNG-AN"]="Y IH R NG AA N",LOYD="L OY D",BACKUS="B AE K AH S",NOYD="N OY D",DINOTOPIA="D AY N AH T OW P IY AH",RADIOS="R EY D IY OW Z",DISTRESSINGLY="D IH S T R EH S IH NG L IY",HOSPITALIZATION="HH AA S P IH T AH L AH Z EY SH AH N",KROSSEL="K R AO S AH L",FURROW="F ER OW",KOLENDA="K AH L EH N D AH",BURROW="B ER OW",CONVERSIONS="K AH N V ER ZH AH N Z",["FEDERALIZE(2)"]="F EH D R AH L AY Z",UNDISCLOSED="AH N D IH S K L OW Z D",["COMBATIVE(2)"]="K AA M B AE T IH V",["TRY-ONS"]="T R AY AA N Z",MOLENDA="M OW L EH N D AH",DOSHER="D AA SH ER",KOSHER="K OW SH ER",PAPAY="P AE P EY",["INTERESTING(3)"]="IH N T ER AH S T IH NG",MOSHER="M OW ZH ER",["'TIL"]="T IH L",["MCCOMBER(2)"]="M AH K OW M ER",THEORETICIAN="TH IY ER AH T IH SH AH N",KOPEL="K OW P AH L",WINTERTIME="W IH N T ER T AY M",["INTEGRATED(3)"]="IH N AH G R EY T AH D",HANDWERK="HH AE N D W ER K",MURROW="M AH R OW",EDELINE="EH D IH L AY N",BOSHER="B AA SH ER",HEINLEN="HH AY N AH L AH N",CLIMAX="K L AY M AE K S",CRITIQUE="K R AH T IY K",LEGENDS="L EH JH AH N D Z",SKETCHBOOK="S K EH CH B UH K",FRIL="F R IH L",EPPEL="EH P AH L",WIDICK="W IH D IH K",DEROOS="D IH R UW Z",EMISSARIES="EH M AH S EH R IY Z",TREBILCOCK="T R IH B IH L K AH K",COMPRESSED="K AH M P R EH S T",DORNHENS="D AO R N HH EH N Z",MARMADUKE="M AA R M AH D UW K",CAYLIN="K EY L IH N",PROMISED="P R AA M AH S T",EMIL="EH M IY L",ECONOMICO="IY K AA N AH M IY K OW",TELLTALE="T EH L T EY L",BABBITT="B AE B IH T",OPPEL="AA P AH L",ZBIKOWSKI="Z B IH K AW S K IY",TRIBAL="T R AY B AH L",PERMISSIVENESS="P ER M IH S IH V N AH S",MAJNOON="M AE JH N UW N",POSEIDON="P AH S AY D AH N",ACOUSTICS="AH K UW S T IH K S",["ACTIVATED(2)"]="AE K T IH V EY T IH D",ENSMINGER="EH N S AH M IH NG ER",HELMUT="HH EH L M AH T",["THUOT(2)"]="TH UW T",GIGNAC="G IH G N AH K",["GRANTED(3)"]="G R AE N AH D",HAMLETT="HH AE M L IH T",["PORT-LONDON"]="P AO R T L AH N D AH N",TETRAMEROUS="T EH T R AE M ER AH S",LULLABIES="L AH L AH B AY Z",DEFINITION="D EH F AH N IH SH AH N",LAWYERS="L AO Y ER Z",ARABICHON="AH R AE B IH SH AO N",STOSSEL="S T AA S AH L",ZARUBA="Z ER UW B AH",MCGLINCHEY="M AH G L IH N CH IY",["CORRUGATED(2)"]="K AO R AH G EY T IH D",BORROW="B AA R OW",["INTERVENTIONISTS(2)"]="IH N ER V EH N CH AH N IH S T S",PONZIO="P AA N Z IY OW",PERSUADABLE="P ER S W EY D AH B AH L",FESCUE="F EH S K Y UW",RESCUE="R EH S K Y UW",CORROW="K AO R OW",NEGATRON="N EH G AH T R AA N",MENHADEN="M EH N HH EY D AH N",BOUGHTEN="B AO T AH N",DOUGHTEN="D AO T AH N",["HAZELWOOD'S"]="HH EY Z AH L W UH D Z",WOODCOCK="W UH D K AA K",["AYLWIN(2)"]="AY L W IH N",BROZOWSKI="B R AH Z AO F S K IY",LESHER="L EH SH ER",BANCROFT="B AE NG K R AO F T",PORCARO="P AO R K AA R OW",ROBERGE="R AA B ER JH",ROMANIELLO="R OW M AA N IY EH L OW",VANBEBBER="V AE N B EH B ER",LAMINA="L AE M AH N AH",RICHARSON="R IH CH AA R S AH N",MCTAGGART="M AH K T AE G ER T",HYPNOTISTS="HH IH P N AH T IH S T S",THIRTY="TH ER D IY",LEXINE="L EH K S AY N",MORROW="M AA R OW",["ELLINGTON'S"]="EH L IH NG T AH N Z",STEINES="S T AY N Z",["PUPPET(2)"]="P AH P IH T",RAGTIME="R AE G T AY M",BIELEN="B IY L AH N",CHESSHIR="SH IH SH ER",KAMERER="K AE M ER ER",["JUREK(2)"]="Y UH R EH K",["SECOND'S"]="S EH K AH N D Z",["BATUS(2)"]="B AO T AH S",["DIABLO(2)"]="D IY AE B L OW",CAMERER="K AE M ER ER",["EVACUATION(2)"]="IY V AE K Y AH W EY SH AH N",ABSHER="AE B SH ER",COMPARTMENT="K AH M P AA R T M AH N T",DRESSING="D R EH S IH NG",TOIL="T OY L",GLOSSES="G L AO S IH Z",MARCELLA="M AA R S EH L AH",PRESSING="P R EH S IH NG",CHARITABLY="CH EH R IH T AH B L IY",["SWINBURNE'S"]="S W IH N B ER N Z",PASQUARELLO="P AA S K W AA R EH L OW",CARDIAC="K AA R D IY AE K",THADA="TH AA D AH",GHADA="G AA D AH",COLLETTA="K OW L EH T AH",IRRATIONALITY="IH R AE SH AH N AE L AH T IY",JARRYD="JH AE R IH D",SOIL="S OY L",ROIL="R OY L",CENTRALIZATION="S EH N T R AH L IH Z EY SH AH N",MICKI="M IH K IY",INCARNATE="IH N K AA R N AH T",ORANGUTANS="AO R AE NG AH T AE N Z",HUMDINGER="HH AH M D IH NG ER",BACCHANAL="B AH K EY N AH L",BOIL="B OY L",["KOREANS'"]="K AO R IY AH N Z",DUDAS="D UW D AH Z",PREMEDITATION="P R IY M EH D AH T EY SH AH N",STALINISTIC="S T AA L IH N IH S T IH K",ALERTLY="AH L ER T L IY",SUKHAREV="S AH K ER AH V",OLSHER="OW L SH ER",WISHER="W IH SH ER",TISHER="T IH SH ER",IDIOPATHIC="IH D IY OW P AE TH AH K",KOHLMEYER="K OW L M AY ER",WOJICK="W OY CH IH K",AUDAS="OW D AA Z",["WITNESSES(2)"]="W IH T N AH S IH Z",BARCELLA="B AA R S EH L AH",CASAMENTO="K AE S AH M EH N T OW",DISHER="D IH SH ER",EDELWEISS="EY D AH L V AY S",FISHER="F IH SH ER",RISHER="R IH SH ER",HJELM="HH Y EH L M",FOREWOMEN="F AO R W IH M EH N",VANDUNK="V AE N D AH NG K",AMUNDSEN="EY M AH N D S AH N",RUMINA="R UW M IH N AH",AMBASSADOR="AE M B AE S AH D ER",ZARRELLA="Z AA R EH L AH",LUMINA="L UW M IH N AH",BISHER="B IH SH ER",GUMINA="G UW M IY N AH",SCHINKE="S K IH NG K",KOVALYOV="K OW V AA L Y AH V",REPEL="R IH P EH L",APPRISE="AH P R AY Z",MCGUINNESS="M AH G IH N AH S",ALGORITHMS="AE L G ER IH DH AH M Z",["ZUGANOV(2)"]="Z UW G AH N AO F",TENRECS="T EH N R EH K S",JULIETA="Y UW L IY T AH",SEARCHING="S ER CH IH NG",PIHL="P IH L",RECRIMINATIONS="R IH K R IH M IH N EY SH AH N Z",CHERRAPUNJI="CH EH R AH P AH N JH IY",NETSCAPE="N EH T S K EY P",REPAY="R IY P EY",CAPSIZED="K AE P S AY Z D",DILLEN="D IH L AH N",["HOCHSTEIN(2)"]="HH AA K S T IY N",GILLEN="G IH L AH N",HILLEN="HH IH L AH N",KILLEN="K IH L AH N",MILLEN="M IH L AH N",["KUOMINTANG(2)"]="G W OW M IH N T AE NG",RELENTING="R IH L EH N T IH NG",EUSTACIA="Y UW S T AA CH AH",OFFSHOOTS="AO F SH UW T S",TULIPS="T UW L AH P S",PENETRATION="P EH N AH T R EY SH AH N",["LARCOM(2)"]="L AA R K AH M",["MAGINNIS(2)"]="M AH G IH N IH S",["BOZELL'S"]="B OW Z EH L Z",TREMEL="T R EH M AH L",DEXFENFLURAMINE="D EH K S AH N F L AO R AH M IY N",JACKING="JH AE K IH NG",HACKING="HH AE K IH NG",LACKING="L AE K IH NG",LAGOS="L EY G AO S",SACKING="S AE K IH NG",PACKING="P AE K IH NG",NITROCELLULOSE="N AY T R OW S EH L Y AH L OW S",PRESTECH="P R EH S T EH K",CROSSES="K R AO S IH Z",GRIJALVA="G R IY Y AA L V AH",GROSSES="G R OW S IH Z",BACKING="B AE K IH NG",ORLOSKY="AO R L OW S K IY",DELVES="D EH L V Z",["BELGRADE(2)"]="B EH L G R AA D",BIGTIME="B IH G T AY M",CHEMEL="K EH M EH L",TRELLIS="T R EH L AH S",SPARINGLY="S P EH R IH NG L IY",MONUMENTAL="M AA N Y AH M EH N T AH L",TUNKELANG="T AH NG K L AE NG",AUTOPSIED="AO T AA P S IY D",MRUK="M R AH K",KRUK="K R AH K",VANESSA="V AH N EH S AH",WHIGS="W IH G Z",PARRELLA="P AA R EH L AH",ORNSTEIN="AO R N S T AY N",IANTHA="IY AA N TH AH",ORIORDAN="OW R IH R D AH N",FREQUENCIES="F R IY K W AH N S IY Z",TOPEKAN="T AH P IY K AH N",["GERMISTON'S"]="JH ER M AH S T AA N Z",SICKENED="S IH K AH N D",["CONFIDENTIAL(2)"]="K AA N F AH D EH N CH AH L",CORPULANT="K AO R P Y AH L AH N T",SLIPPERY="S L IH P ER IY",HENNES="HH EH N Z",KELLEN="K EH L AH N",BRAINSTORMED="B R EY N S T AO R M D",HELLEN="HH EH L AH N",["STANFORD'S"]="S T AE N F ER D Z",KAYSERSBERG="K AY Z ER Z B ER G",TOURISM="T UH R IH Z AH M",MORATORIUMS="M AO R AH T AO R IY AH M Z",YELLEN="Y EH L AH N",BOBBITT="B AA B IH T",TACKING="T AE K IH NG",EXAGGERATIONS="IH G Z AE JH ER EY SH AH N Z",BOCKUS="B AA K AH S",["ARLINGTON'S"]="AA R L IH NG T AH N Z",MEANTIME="M IY N T AY M",SELLEN="S EH L AH N",JACKI="JH AE K IY",DISBELIEVING="D IH S B AH L IY V IH NG",TUXHORN="T AH K S HH ER N",INVITEE="IH N V AY T IY",MCAULIFFE="M AH K AO L AH F",TENURES="T EH N Y ER Z",NIGHTINGALE="N AY T IH NG G EY L",PAINLESSLY="P EY N L AH S L IY",OGLESBEE="OW G AH L Z B IY",["FINANCIAL(3)"]="F AY N AE N SH AH L",DOWNSIZINGS="D AW N S AY Z IH NG Z",SKEOCH="S K IY AA CH",WASHER="W AA SH ER",["KAHRE(2)"]="K AA R",SWEAZY="S W IY Z IY",RUCKUS="R AH K AH S",VONSTEIN="V AA N S T AY N",LASHER="L AE SH ER",TOXICOLOGY="T AA K S IH K AA L AH JH IY",CHRYST="K R IH S T",GUERARD="G ER AA R D",DASHER="D AE SH ER",CASHER="K AE SH ER",EMANCIPATED="IH M AE N S AH P EY T IH D",FOMENTING="F OW M EH N T IH NG",BRIGHAM="B R IH G AH M",MANNHEIM="M AE N HH AY M",CARIBBEAN="K ER IH B IY AH N",REALPOLITIK="R IY L P AO L IH T IH K",WAKELY="W EY K L IY",SISSOM="S IH S AH M",CRANNIES="K R AE N IY Z",["PARENT'S"]="P EH R AH N T S",GETULIO="G AH CH UW L IY OW",DIVESTITURE="D IH V EH S T IH CH ER",RAYOS="R EY OW Z",KERSCHER="K ER SH ER",GERMANYS="JH ER M AH N IY Z",FLARINGLY="F L EH R IH NG L IY",["GLYCOL(2)"]="G L AY K OW L",GRANNIES="G R AE N IY Z",["HUNGARY'S"]="HH AH NG G ER IY Z",IPTAY="IH P T EY",FALLEN="F AA L AH N",GALLEN="G AO L AH N",HALLEN="HH AO L AH N",KALLEN="K AO L AH N",STREAMING="S T R IY M IH NG",MALLEN="M AO L AH N",DROOPY="D R UW P IY",["SAN-FRAN"]="S AE N F R AE N",CALLEN="K AE L AH N",POPULISM="P AA P Y AH L IH Z AH M",DEFUNDING="D IY F AH N D IH NG",WALLEN="W AO L AH N",NONCONFORMITY="N AA N K AH N F AO R M AH T IY",DONMOYER="D AA N M OY ER",DICTAPHONE="D IH K T AH F OW N",OVERSEE="OW V ER S IY",INTRUDING="IH N T R UW D IH NG",SCHOENDORF="SH OW N D AO R F",["ARABICHON'S"]="AH R AE B IH SH AO N Z",BIELICKI="B IH L IH T S K IY",ARTUR="AA R T UH R",EVERARD="EH V ER ER D",MATCHMAKING="M AE CH M EY K IH NG",ZEINAB="Z AY N AE B",BONNES="B AO N Z",AMYLIN="AE M IH L IH N",COGNAC="K OW N Y AE K",SOLVES="S AA L V Z",WOLVES="W UH L V Z",UNCONSCIOUSNESS="AH N K AA N SH AH S N IH S",NONWOVENS="N AA N W OW V AH N Z",SCAVENGE="S K AE V AH N JH",VANHOY="V AE N HH OY",LACOUTURE="L AE K UW CH ER",RAMBOW="R AE M B OW",SHAMELLE="SH AH M EH L",UNINVITING="AH N IH N V AY T IH NG",["FRACTURE(2)"]="F R AE K SH ER",NORDIO="N AO R D IY OW",BUCKLEW="B AH K L UW",DILORETO="D IH L AO R EH T OW",GREENWALT="G R IY N W AH L T",OPINION="AH P IH N Y AH N",GLORIOUSLY="G L AO R IY AH S L IY",["WHITENING(3)"]="HH W AY T IH N IH NG",CONTRIBUTOR="K AH N T R IH B Y AH T ER",EDUCATING="EH JH AH K EY T IH NG",OSCILLATOR="AA S AH L EY T ER",MONGOLS="M AA NG G AH L Z",MASCARO="M AA S K AA R OW",SNOOPY="S N UW P IY",WIDEBODY="W AY D B AA D IY",NOVITSKI="N AH V IH T S K IY",["ODYSSEY'S"]="AA D AH S IY Z",["GROVELING(2)"]="G R AO V L IH NG",MOSAICKED="M OW Z EY IH K T",["TOURTELOT(2)"]="T UH R T AH L OW",DOKELY="D OW K L IY",["WICHITA'S"]="W IH CH AH T AO Z",INJECTS="IH N JH EH K T S",VIVEROS="V IY V EH R OW Z",EXPEL="IH K S P EH L",INJECTORS="IH N JH EH K T ER Z",ADELINE="AE D AH L AY N",DECKING="D EH K IH NG",RADICK="R AE D IH K",PECKING="P EH K IH NG",["ENGLER(2)"]="EH NG G L ER",REHEARSALS="R IH HH ER S AH L Z",SASNETT="S AE S N IH T",DRAMATICALLY="D R AH M AE T IH K L IY",LUMINESCENT="L UW M AH N EH S AH N T",ZELINA="Z EH L IY N AH",RETARDANT="R IY T AA R D AH N T",BUIL="B Y UW AH L",STARBUCKS="S T AA R B AH K S",LEBRETON="L EH B R IH T AA N",["HOLMES'S"]="HH OW M Z IH Z",EXHORTED="IH G Z AO R T IH D",LIKELY="L AY K L IY",STIL="S T IH L",WILMUT="W IH L M AH T",GUARDADO="G AA R D AA D OW",PENETRATE="P EH N AH T R EY T",PEREGOY="P ER IH G OY",STEVENSON="S T IY V AH N S AH N",ARMINA="AA R M IY N AH",OVERREACTION="OW V ER R IY AE K SH AH N",BILLINGSLY="B IH L IH NG Z L IY",ERMINA="ER M IY N AH",REGALADO="R EY G AA L AA D OW",MEASLY="M IY Z L IY",HOUSEWORTH="HH AW S W ER TH",DEFREESE="D EH F R IY S",FEELERS="F IY L ER Z",["FOGLER(2)"]="F OW G L ER",MCRAE="M AH K R EY",RUCKI="R AH K IY",["KOGLER(2)"]="K OW G L ER",DOMINA="D OW M IY N AH",GLOOMILY="G L UW M AH L IY",PEELERS="P IY L ER Z",MONZONITE="M AA N Z AH N AY T",RENOWNED="R IH N AW N D",VELOZ="V EY L OW Z",ROMINA="R AH M IY N AH",["REVIEWER'S"]="R IY V Y UW ER Z",GLASSBERG="G L AE S B ER G",OCTOPUS="AA K T AH P UH S",LINDSETH="L IH N D S IH TH",ZIGGURAT="Z IH G ER AE T",["SCIENTISTS'"]="S AY AH N T IH S T S",CUSSED="K AH S T",BUSSED="B AH S T",AMIRAULT="AE M AY R AW L T",FUSSED="F AH S T",RESURRECTION="R EH Z ER EH K SH AH N",OVERPRODUCE="OW V ER P R AH D UW S",CHADEL="CH AE D AH L",DEPRESSURIZED="D IH P R EH SH ER AY Z D",PULMOZYME="P UH L M OW Z AY M",REJECTS="R IH JH EH K T S",["DECAROLIS(2)"]="D IH K ER AH L IH S",SPRUILL="S P R UW L",BURKLE="B ER K AH L",TRAMPING="T R AE M P IH NG",KOPEKS="K OW P AH K S",PREFERENCES="P R EH F ER AH N S IH Z",LEEPER="L IY P ER",KEEPER="K IY P ER",CONSTANTINIDES="K AA N S T AH N T AH N IY D AH S",EXEMPLIFIES="IH G Z EH M P L AH F AY Z",BEEPER="B IY P ER",FABBRI="F AE B R IY",["JARVIS(2)"]="JH AA R V IH S",SHERARD="SH EH R ER D",CRAMPING="K R AE M P IH NG",ADJUSTER="AH JH AH S T ER",BRISCOE="B R IH S K OW",STONES="S T OW N Z",APPROXIMATES="AH P R AA K S AH M AH T S",AZINGER="EY Z IH NG ER",HOUNDS="HH AW N D Z",RESURRECTED="R EH Z ER EH K T IH D",POSLUSZNY="P AH S L AH SH N IY",FLANGE="F L AE N JH",DIVERGENCES="D AY V ER JH AH N S IH Z",BOUNDS="B AW N D Z",ORGASM="AO R G AE Z AH M",STERILIZING="S T EH R AH L AY Z IH NG",WOUNDS="W UW N D Z",ZOUNDS="Z AW N D Z",HANKLA="HH AE NG K L AH",HYPERSONIC="HH AY P ER S AA N IH K",POUNDS="P AW N D Z",SOUNDS="S AW N D Z",ROUNDS="R AW N D Z",WAGERING="W EY JH ER IH NG",TELECABLE="T EH L AH K EY B AH L",UNICORP="Y UW N IH K AO R P",SELINA="S AH L IY N AH",BROOKSIDE="B R UH K S AY D",["RESUMPTION(2)"]="R IY Z AH M P SH AH N",BLVD="B UH L AH V AA R D",IDONA="IH D OW N AH",MELINA="M EH L IY N AH",NELINA="N EH L IY N AH",PROBATIONER="P R OW B EY SH AH N ER",CONSISTENTLY="K AH N S IH S T AH N T L IY",HOYVALD="HH OY V AH L D",BIOLOGICALLY="B AY AH L AA JH IH K L IY",CLARKSVILLE="K L AA R K S V IH L",YOYOS="Y OW Y OW Z",GIBLEN="G IH B L AH N",DEFENDS="D IH F EH N D Z",OLIVIA="OW L IH V IY AH",ATHENEUM="AE TH AH N UW M",AYSCUE="EY S K Y UW",["D'ORSAY"]="D AO R S EY",BAHRAINIAN="B ER EY N IY AH N",EVANGELICALS="IY V AE N JH EH L IH K AH L Z",ESTRANGE="EH S T R EY N JH",BUTCHER="B UH CH ER",BRUGES="B R UW JH IH Z",CUTCHER="K AH CH ER",LYCOS="L AY K OW S",NONRESTRICTED="N AA N R IH S T R IH K T AH D",SCHLUMBERGER="SH L AH M B ER ZH EY",SCREAMING="S K R IY M IH NG",["DATAQUEST'S"]="D EY T AH K W EH S T S",SCHOLASTIC="S K AH L AE S T IH K",["STRUNK'S"]="S T R AH NG K S",LEINONEN="L AY N AH N AH N",["ORLOFF'S"]="AO R L AO F S",["TROOPERS'"]="T R UW P ER Z",HEINONEN="HH AY N AH N AH N",LAMONT="L AH M AA N T",["BLASIER'S"]="B L EY Z IY ER Z",OFFENDS="AH F EH N D Z",GOTCHER="G AA CH ER",["BAR-MITZVAH"]="B AA R M IH T S V AH",VIRTUES="V ER CH UW Z",FILIBUSTER="F IH L AH B AH S T ER",MCGLOCKLIN="M AH G L AA K L AH N",PAJAMAS="P AH JH AA M AH Z",PERPICH="P ER P IH K",NUTT="N AH T",TUTT="T AH T",RUTT="R AH T",HOMOGENOUS="HH AH M AA JH AH N AH S",HUTT="HH AH T",GUTT="G AH T",GRADEL="G R AE D AH L",ADMITTANCE="AH D M IH T AH N S",["EARHART(2)"]="EH R HH AA R T",SCHOEPE="SH OW P",CHAGRIN="SH AH G R IH N",TOSSED="T AO S T",CRUSTAL="K R AH S T AH L",REMITTANCE="R IY M IH T AH N S",ACOCELLA="AA K OW CH EH L AH",["KAZAKHSTAN'S"]="K AA Z AA K S T AA N Z",REALISTS="R IY AH L IH S T S",STRUGGLED="S T R AH G AH L D",MASUR="M AE S ER",EPEDA="EH P EY D AH",ORGANISATIONS="AO R G AH N IH Z EY SH AH N Z",FERREIRO="F EH R EH R OW",DUTT="D AH T",BOJARSKI="B AH Y AA R S K IY",BUTT="B AH T",EQUIPMENT="IH K W IH P M AH N T",TISCHER="T IH SH ER",["WHEN'LL(2)"]="HH W EH N AH L",BIGOS="B IY G OW Z",BRIDGEPORT="B R IH JH P AO R T",BUJUMBURA="B UW JH AH M B UH R AH",DISCHER="D IH SH ER",FISCHER="F IH SH ER",SCHABER="SH EY B ER",MISCHER="M IH SH ER",JUDGEMENTS="JH AH JH M AH N T S",LEMONT="L AH M AA N T",VALENCIENNE="V AH L EH N S IY EH N",PREDETERMINED="P R IY D IY T ER M IH N D",RECALCULATE="R IY K AE L K Y AH L EY T",GUESSING="G EH S IH NG",["WHITTIER(2)"]="HH W IH T IY ER",BIZZARO="B IH Z AA R OW",IGLESIAS="IH G L EY S IY IH S",SCORERS="S K AO R ER Z",SPOILAGE="S P OY L AH JH",GOBBLEDYGOOK="G AA B AH L D IY G UH K",SLAVA="S L AA V AH",BRAILLES="B R EY L Z",INANIMATE="IH N AE N AH M AH T",DISTENDED="D IH S T EH N D IH D",CHELLIS="CH EH L IH S",CANCILLA="K AA N CH IH L AH",SNORKEL="S N AO R K AH L",WNUK="W N AH K",CHATTED="CH AE T AH D",DIVORCE="D IH V AO R S",GAROFALO="G AA R OW F AA L OW",FRINGER="F R IH N JH ER",INVESTIGATORY="IH N V EH S T AH G AH T AO R IY",["WITHDRAWAL(2)"]="W IH TH D R AO AH L",VALVES="V AE L V Z",SALVES="S AA V Z",DEMONT="D EH M AH N T",WRINGER="R IH NG ER",YORUBA="Y AH R UW B AH",DENTITION="D EH N T IH SH AH N",GOTTLIEB="G AA T L IY B",KUTCHER="K AH CH ER",STEFANI="S T EH F AH N IY",DEMENTED="D IH M EH N T IH D",CEMENTED="S AH M EH N T AH D",PHASEOUT="F EY Z AW T",MEGALOMANIA="M EH G AH L OW M EY N IY AH",CARREIRO="K AA R EH R OW",MANCILLA="M AE N S IH L AH",CLAMPING="K L AE M P IH NG",YOTT="Y AA T",GOTT="G AA T",HOTT="HH AA T",LOUK="L AW K",KAPPELER="K AE P AH L ER",COTT="K AA T",["G'VANNI'S"]="JH IY OW V AA N IY Z",HOUK="HH AW K",JARISLOWSKY="JH EH R IH S L AW S K IY",POTT="P AA T",MIDWESTERNERS="M IH D W EH S T ER N ER Z",ROTT="R AA T",KOTT="K AA T",LOTT="L AA T",MOTT="M AA T",NOTT="N AA T",HALVES="HH AE V Z",INTRUDE="IH N T R UW D",["PREISLER(2)"]="P R AY S L ER",MISSED="M IH S T",PISSED="P IH S T",BOTT="B AA T",KISSED="K IH S T",HISSED="HH IH S T",OBSCURED="AH B S K Y UH R D",EASTEP="IY Z T IH P",SHELLSHOCKED="SH EH L SH AA K T",["SECTOR'S"]="S EH K T ER Z",ENGHOLM="EH NG HH OW L M",PROVIDING="P R AH V AY D IH NG",EDGECOMBE="EH JH K OW M",GAONA="G AA OW N AH",NEOPLATONIST="N IY OW P L EY T AH N AH S T",PARTIALITY="P AA R SH IY AE L AH T IY",EVINGER="IY V IH NG ER",MCCAMANT="M AH K AE M AH N T",AVINGER="EY V IH NG ER",OBJECTS="AA B JH EH K T S",SELVES="S EH L V Z",LUMBAR="L AH M B AA R",OVERLOOKED="OW V ER L UH K T",["MATHILDE(2)"]="M AH T IH L D",HAUSWIRTH="HH AW S W ER TH",MALINA="M AA L IY N AH",ADINOLFI="AA D IY N OW L F IY",STREPTOKINASE="S T R EH P T AH K AY N EY S",FARFETCHED="F AA R F EH CH T",ARCOS="AA R K OW Z",BEAUDETTE="B OW D EH T",CHAUVINIST="SH OW V AH N AH S T",["LIBERALISM'S(2)"]="L IH B R AH L IH Z AH M Z",JANUARY="JH AE N Y UW EH R IY",KALINA="K AH L AY N AH",TASHIRO="T AA SH IH R OW",NAZZARO="N AA T S AA R OW",SCOWDEN="S K AW D AH N",["GAUFMAN'S"]="G AO F M AH N Z",["PRACTITIONER(2)"]="P R AE K T IH SH N ER",["KAUFMAN'S"]="K AO F M AH N Z",BACHELDER="B AA K IH L D ER",LAZZARO="L AA T S AA R OW",WASCHER="W AO SH ER",REPRISE="R IH P R AY Z",PINEIRO="P IY N EH R OW",INMONT="IH N M AA N T",CLAUDETTE="K L OW D EH T",AGRESOURCE="AA G R EH S AO R S",MESSED="M EH S T",GOLFARB="G AO L F AA R B",DAVOS="D AA V OW S",ENSECO="EH N S EH K OW",OBTRUDE="AH B T R UW D",FLYTRAP="F L AY T R AE P",EHINGER="EH HH IH N JH ER",MALPASS="M AE L P AH S",DRYCLEAN="D R AY K L IY N",MACEDO="M AH S EY D OW",["VICTOR'S"]="V IH K T ER Z",FESSED="F EH S T",INTERESTINGLY="IH N T ER EH S T IH NG L IY",NUNZIO="N AH N Z IY OW",HERSHISER="HH ER SH AY Z ER",WYCOFF="W IH K AO F",DERROW="D EH R OW",UPSTAGED="AH P S T EY JH D",SCHMITZER="SH M IH T S ER",JULINA="Y UW L IY N AH",["DOCTOR'S"]="D AA K T ER Z",["GRAMMY'S"]="G R AE M IY Z",["BADEN'S"]="B AA D AH N Z",MERROW="M EH R OW",PERROW="P ER R OW",CHORTLES="CH AO R T AH L Z",BUNDS="B AH N D Z",YOKOHAMA="Y OW K AH HH AA M AH",FUNDS="F AH N D Z",STARLIGHT="S T AA R L AY T",GNAWS="N AO Z",PORTEND="P AO R T EH N D",STALLMAN="S T AO L M AH N",FOGLIO="F AA G L IY OW",STABBING="S T AE B IH NG",MISCUE="M IH S K Y UW",BRAKKE="B R AE K",DESCARPENTRIES="D EY K AA R P AH N T R IY Z",MESCHER="M EH SH ER",["NIKKO'S"]="N IY K OW Z",SIGRID="S IH G R IH D",["ICENHOWER(2)"]="AY S AH N HH AW ER",RATIONALIZATIONS="R AE SH AH N AH L IH Z EY SH AH N Z",STADEL="S T AE D AH L",["BURKINA'S"]="B ER K IY N AH Z",IBUPROFEN="AY B Y UW P R OW F AH N",NATIONALIZATIONS="N AE SH AH N AH L AH Z EY SH AH N Z",HARDIEST="HH AA R D IY AH S T",BROCADE="B R OW K EY D",UNDERSTAFFED="AH N D ER S T AE F T",MASSED="M AE S T",OLINGER="AA L IH NG ER",CORSETTI="K ER S EH T IY",CAPEL="K EY P AH L",STEEDMAN="S T IY D M AH N",MAMMALS="M AE M AH L Z",EMULSIFIER="IH M AH L S AH F AY ER",CLINGER="K L IH NG ER",MISTAKING="M IH S T EY K IH NG",FLAWS="F L AO Z",MOSUR="M OW S UH R",MAPEL="M AE P AH L",LAPEL="L AH P EH L",BISHOPS="B IH SH AH P S",INAPPROPRIATELY="IH N AH P R AA P R IY AH T L IY",LEONES="L IY OW N Z",SHERRIT="SH EH R IH T",YETT="Y EH T",GATOIL="G AH T OY L",GUEDRY="G EH D R IY",LETT="L EH T",JETT="JH EH T",MARIETTE="M EH R IY EH T",PETT="P EH T",NETT="N EH T",BACKYARD="B AE K Y AA R D",REVERENTIAL="R EH V ER EH N CH AH L",BETT="B EH T",AMERONGEN="AE M ER AO N JH AH N",FRIEDL="F R IY D AH L",BOCHENEK="B AA K IH N IH K",FETT="F EH T",FREEDMAN="F R IY D M AH N",CANNES="K AE N Z",INSTANCE="IH N S T AH N S",STAGGERED="S T AE G ER D",LAMENTED="L AH M EH N T IH D",GOMBAR="G AH M B AA R",ANGERING="AE NG G ER IH NG",IMPRACTICABLE="IH M P R AE K T IH K AH B AH L",XYLINA="Z AY L IH N AH",SANNES="S AE N Z",CARDIO="K AA R D IY OW",MANNES="M AE N Z",GRUMBLINGS="G R AH M B AH L IH NG Z",HANNES="HH AE N Z",NIGERIAN="N AY JH IH R IY AH N",["ORANGE(2)"]="AO R IH N JH",RAINGER="R AA IH NG ER",LAPRAIRIE="L AH P R EH R IY",COONES="K UW N Z",GREULICH="G R OY L IH K",THWARTED="TH W AO R T AH D",COHENTANNOUDJI="K OW AH N T AH N UW JH IY",["SCALI(2)"]="S K EY L IY",HIGHWAYS="HH AY W EY Z",BESTIALITY="B EH S CH AE L IH T IY",MIKULIC="M IH K UW L IH K",INSURRECTION="IH N S ER EH K SH AH N",PALMATEER="P AE L M AH T IH R",MONDS="M AA N D Z",GOPHERS="G OW F ER Z",IRONICALLY="AY R AA N IH K L IY",BREDA="B R EY D AH",STRAUS="S T R AW S",MICKUS="M IH K AH S",PICKUS="P IH K AH S",MAXWELL="M AE K S W EH L",PLATONA="P L AA T OW N AH",BRAINSTORMING="B R EY N S T AO R M IH NG",DUMONT="D UW M AA N T",["GRIDLOCK'S"]="G R IH D L AA K S",["HONECKER'S"]="HH OW N EH K ER Z",SHUTTLES="SH AH T AH L Z",BUDDIER="B AH D IY ER",DISTANCE="D IH S T AH N S",ANASQUAN="AE N AH S K W AA N",LINERBOARD="L AY N ER B AO R D",WITT="W IH T",DISFIGURED="D IH S F IH G Y ER D",DISEASED="D IH Z IY Z D",BUDICK="B AH D IH K",OVERRATES="OW V ER R EY T S",STUMPH="S T AH M F",PITT="P IH T",MITT="M IH T",KITT="K IH T",LITT="L IH T",TRUMPETER="T R AH M P AH T ER",EXTREMITY="EH K S T R EH M AH T IY",HITT="HH IH T",FRIKKIE="F R IH K IY",FITT="F IH T",RUJITH="R UW JH IY TH",CREMATORIA="K R IY M AH T AO R IY AH",TRACHT="T R AE K T",PRACHT="P R AE K T",EMPRISE="EH M P R AY Z",INGRID="IH NG G R IH D",FRANCHISEES="F R AE N CH AY Z IY Z",["KILLMAN'S"]="K IH L M AH N Z",BRAINSTORM="B R EY N S T AO R M",EBINGER="EH B IH NG ER",GUNSHIPS="G AH N SH IH P S",SHARPENED="SH AA R P AH N D",CAMPBELLS="K AE M B AH L Z",PAWELSKY="P AA V EH L S K IY",EXTORTIONISTS="EH K S T AO R SH AH N IH S T S",COOMBES="K UW M B Z",WEINGER="W AY N G ER",LEATHEM="L EH TH IH M",HOLLERING="HH AA L ER IH NG",["GERSON(2)"]="G ER S AH N",MOLLERING="M AA L ER IH NG",SOLESBEE="S OW L Z B IY",SCHNEEBERGER="SH N IY B ER G ER",HEADCOUNT="HH EH D K AW N T",DEDIOS="D EY D IY OW Z",MILITARIES="M IH L AH T EH R IY Z",PORCELLA="P AO R CH EH L AH",COLINA="K OW L IY N AH",PHONES="F OW N Z",AILUROPHILE="EY L UH R AH F AY L",MOLINA="M AH L IY N AH",IMPORTS="IH M P AO R T S",["DIVULGE(2)"]="D AY V AH L JH",CAMBRIA="K AE M B R IY AH",SUBFAMILIES="S AH B F AE M AH L IY Z",["STRANGER'S"]="S T R EY N JH ER Z",HIMONT="HH IH M AH N T",EDINGER="EH D IH NG ER",LEPKOWSKI="L IH P K AO F S K IY",DOBOJ="D OW B AO JH",ECHOS="EH K OW Z",["BUSINESSMAN(2)"]="B IH Z N IH S M AE N",GARROW="G EH R OW",HARROW="HH AE R OW",REDDIN="R EH D IH N",["KELLEY(2)"]="OW K EH L IY",LARROW="L AE R OW",["LITTLE-ROCK"]="L IH T AH L R AO K",BARROW="B AE R OW",CARROW="K AE R OW",DARROW="D EH R OW",AMMONITES="AE M AH N AY T S",YARROW="Y AA R OW",WOODCOX="W UH D K AA K S",NARROW="N EH R OW",PARROW="P AE R OW",LAPRISE="L AA P R AY Z",PERMISSION="P ER M IH SH AH N",TRANSSEXUALS="T R AE N S EH K SH Y UW AH L Z",CUEVAS="K W EH V AA Z",["DESPERATE(2)"]="D EH S P ER IH T",REFERENCING="R EH F ER AH N S IH NG",TOOTHLESS="T UW TH L AH S",AFFLICTS="AH F L IH K T S",DESCRIBE="D IH S K R AY B",PANNIER="P AE N IY ER",MAGNETRON="M AE G N AH T R AA N",GALACTOSE="G AH L AE K T OW S",FONDIARIA="F AA N D IY EH R IY AH",RAMSTEIN="R AE M S T AY N",YASUHIRO="Y AA S UW HH IY R OW",REVOLVERS="R IH V AA L V ER Z",ETYMOLOGICAL="EH T AH M AH L AA JH AH K AH L",["EVA'S(2)"]="IY V AH Z",CZARIST="Z AA R IH S T",PATIO="P AE T IY OW",["QUINTUPLE(2)"]="K W IH N T AH P AH L",RATIO="R EY SH IY OW",PACKAGERS="P AE K IH JH ER Z",NEWSPAPERS="N UW Z P EY P ER Z",["BARR'S"]="B AA R Z",["CARR'S"]="K AA R Z",VIOLETT="V AY AH L AH T",ASYMPTOMATIC="EY S IH M P T AH M AE T IH K",["HALLEY(2)"]="HH EY L IY",HELMKE="HH EH L M K",CALLEGARI="K AA L EH G AA R IY",SYNCOPE="S IH N K AH P IY",VANKAMPEN="V AE N K AE M P AH N",SINUSOID="S AY N AH S OY D",CHALLENGERS="CH AE L AH N JH ER Z",["WHEN(3)"]="W IH N",FORSTMANN="F AO R S T M AH N",STOCKPILING="S T AA K P AY L IH NG",KIVI="K IH V IY",SWEEPING="S W IY P IH NG",["BASIM'S"]="B AA S IY M Z",BERTRAN="B ER T R AH N",BELGACOM="B EH L G AH K AA M",HORSTMANN="HH AO R S T M AH N",HARTNESS="HH AA R T N AH S",RARELY="R EH R L IY",HEADHUNTER="HH EH D HH AH N T ER",CALLUS="K AE L AH S",GALLUS="G AE L AH S",MARITIMES="M EH R AH T AY M Z",AFTERTASTE="AE F T ER T EY S T",["NICARAGUA'S"]="N IH K ER AA G W AH Z",KALLUS="K AE L AH S",DISRUPTS="D IH S R AH P T S",TRABERT="T R AE B ER T",CHLOROFLUOROCARBON="K L AO R OW F L AO R OW K AA R B AA N",FAVORING="F EY V ER IH NG",["TECHNOPHOBE'S"]="T EH K N OW F OW B Z",KRAHENBUHL="K R AA IH N B AH L",["ERA'S(2)"]="IH R AH Z",NORTEK="N AO R T EH K",STELZER="S T EH L Z ER",RETORTS="R IH T AO R T S",CONSIGLIO="K AA N S IY G L IY OW",TARTNESS="T AA R T N AH S",PELLEGRIN="P EH L IH G R IH N",MCCLORY="M AH K L AO R IY",GOLDFARB="G OW L D F AA R B",["RAMSEY'S"]="R AE M Z IY Z",["DIVESTMENT(3)"]="D IH V EH S M AH N T",MENAHEM="M AH N AA HH AH M",MAKRIS="M AE K R IH S",FRETTED="F R EH T IH D",HAVRILLA="HH AE V R IH L AH",ARLEDGE="AA R L IH JH",RIPPERGER="R IH P ER G ER",["ROOSEVELTS(2)"]="R UW Z AH V EH L T S",KINCADE="K IH N K EY D",EQUIVOCAL="IH K W IH V AH K AH L",CARLINI="K AA R L IY N IY",GRABERT="G R AE B ER T",["GRANDDAUGHTER'S"]="G R AE N D AO T ER Z",BLIZARD="B L IH Z ER D",CHAPERONE="SH AE P ER OW N",AUTOWORKERS="AO T OW W ER K ER Z",BARELY="B EH R L IY",["WEITZMAN'S"]="W AY T S M AH N Z",DUTROW="D AH T R OW",BACTERIUM="B AE K T IH R IY AH M",STEPPEL="S T EH P AH L",AIRTRAN="EH R T R AE N",ANDROMEDA="AE N D R AA M AH D AH",FAVORABILITY="F AE V ER AH B IH L IH T IY",RAVI="R AA V IY",["INQUIRIES(2)"]="IH N K W ER IY Z",["COUNTY'S(2)"]="K AW N IY Z",DESICCATION="D EH S AH K EY SH AH N",ELLEDGE="EH L IH JH",CONSOLIDATE="K AH N S AA L IH D EY T",INFLICTS="IH N F L IH K T S",ANTISEPTIC="AE N T AH S EH P T IH K",CHRONOWITZ="K R AA N AH W IH T S",DUCKSWORTH="D AH K S W ER TH",SCHILT="SH IH L T",PHYLIS="F AY L AH S",["OPPOSITE(2)"]="AA P Z AH T",SHELLMAN="SH EH L M AH N",PREDICAMENTS="P R IH D IH K AH M AH N T S",OSTROW="AA S T R AW",LAVISH="L AE V IH SH",GENITALS="JH EH N AH T AH L Z",BEGOT="B IY G AO T",SKEWES="S K Y UW Z",BOROUGHS="B ER OW Z",MANAGEABLE="M AE N IH JH AH B AH L",BALLERINA="B AE L ER IY N AH",["RADICAL(2)"]="R AE D IH K AH L",SEGUROS="S EY G Y ER OW Z",STANLEYTOWN="S T AE N L IY T AW N",["CONJECTURE(2)"]="K AH N JH EH K SH ER",POLIO="P OW L IY OW",BOLIO="B OW L IY OW",MCGUFFEY="M AH G AH F IY",BODYGUARDS="B AA D IY G AA R D Z",MISPRONOUNCING="M IH S P R AH N AW N S IH NG",HERPES="HH ER P IY Z",MILLISECONDS="M IH L IH S EH K AH N D Z",["BACHE'S(2)"]="B EY CH IH Z",INSULATE="IH N S AH L EY T",ENDAKA="EH N D AA K AH",WINDFALL="W IH N D F AO L",RODICK="R AA D IH K",DAVI="D AA V IY",STEGMAN="S T EH G M AH N",NURSERY="N ER S ER IY",LAVI="L EY V IY",CLAYBURN="K L EY B ER N",["ELECTORATE(2)"]="IH L EH K T R IH T",KULESA="K Y UW L IY S AH",CLIMBERS="K L AY M ER Z",SAKINA="S AH K IY N AH",TEAMWORK="T IY M W ER K",CLEARCUTS="K L IH R K AH T S",DEMONSTRATE="D EH M AH N S T R EY T",DEPACE="D IH P AA CH IY",DYMALLY="D IH M AH L IY",EXPLORATION="EH K S P L ER EY SH AH N",NUNAMAKER="N UW N AA M EY K ER",ECOLOGICALLY="IY K AH L AA JH IH K L IY",GRIEVOUSLY="G R IY V AH S L IY",SCHMECHEL="SH M EH K AH L",FUNNIER="F AH N IY ER",COLORIZED="K AH L ER AY Z D",["PRODUCTION(2)"]="P R OW D AH K SH AH N",BREGMAN="B R EH G M AH N",INVENTS="IH N V EH N T S",PREJUDICE="P R EH JH AH D IH S",EFFERVESCENT="EH F ER V EH S AH N T",["THORTON'S"]="TH AO R T AH N Z",MCGARITY="M AH G AE R AH T IY",CONNAN="K AA N AH N",THROUGHS="TH R UW Z",GRABBED="G R AE B D",JAPANIMATION="JH AH P AE N IH M EY SH AH N",["MISCIBLE(2)"]="M IH S IH B AH L",CRABBED="K R AE B D",MISCAVIGE="M IH S K AE V IH JH",STELLMAN="S T EH L M AH N",SCHNITKER="SH N IH T K ER",MAKEUP="M EY K AH P",NEWLIN="N UW L IH N",GYTHA="JH AY DH AH",REWRITES="R IY R AY T S",AVINA="AA V IY N AH",["EJUP(2)"]="IY JH UW P",CONDEMN="K AH N D EH M",MCCANE="M AH K EY N",BUDDIN="B AH D IH N",SECESSIONISTS="S IH S EH SH AH N IH S T S",SURREBUTTAL="S ER IH B AH T AH L",ARREARAGE="ER IY R IH JH",["ENCYCLOPAEDIA(2)"]="IH N S AY K L OW P IY D IY AH",LIPOSOME="L IH P AH S OW M",DOCKSON="D AA K S AH N",LAUGHLER="L AE F L ER",["MEXICO'S"]="M EH K S AH K OW Z",["DEAFENING(2)"]="D EH F N IH NG",SACHSE="S AE CH S",COLLABORATION="K AH L AE B ER EY SH AH N",GUZZARDO="G UW T S AA R D OW",IMBIBE="IH M B AY B",MAGISTRO="M AA JH IY S T R OW",STEARNS="S T ER N Z",["CARSON(2)"]="K AA R Z AH N",UPHOLSTERED="AH P OW L S T ER D",OVERSIMPLIFICATION="OW V ER S IH M P L IH F IH K EY SH AH N",SEABEES="S IY B IY Z",ATTRACT="AH T R AE K T",BURTNESS="B ER T N IH S",["BLONDE'S"]="B L AA N D Z",BOHLANDER="B OW L AH N D ER",CARRASQUILLO="K EH R AH S K IH L OW",BELOTE="B EH L OW T IY",CELIO="S IY L IY OW",["REVENUE(2)"]="R EH V AH N Y UW",MISPRONOUNCE="M IH S P R AH N AW N S",["COMPOSITES(2)"]="K AA M P AA Z AH T S",DAUPHIN="D AW F IH N",SQUEEZING="S K W IY Z IH NG",CLIMB="K L AY M",SCHOFF="SH AO F",MABEN="M AE B AH N",SPROWLS="S P R AW L Z",DATEXT="D AE T EH K S T",EMAILING="IY M EY L IH NG",PRIZES="P R AY Z AH Z",MOSQUITO="M AH S K IY T OW",LANDFALL="L AE N D F AO L",ARRANGEMENTS="ER EY N JH M AH N T S",SYMBOLIZED="S IH M B AH L AY Z D",LAMARCHE="L AA M AA R K IY",INTERGOVERNMENTAL="IH N T ER G AH V ER N M EH N T AH L",PEROXIDE="P ER AA K S AY D",ORBITER="AO R B AH T ER",DEHOFF="D EH HH AO F",DESMOND="D EH Z M AH N D",BEHOFF="B IY HH AA F",SOROVSKI="S AO R AO V S K IY",NEUPOGEN="N UW P OW JH EH N",ARBITER="AA R B IH T ER",KINEPOLIS="K IH N EH P AH L IH S",OUTPERFORMERS="AW T P ER F AO R M ER Z",REALLOCATED="R IY AE L AH K EY T IH D",ANDRIST="AE N D R IH S T",PIECHOCKI="P IY HH OW T S K IY",SCHLEICHER="SH L AY K ER",ERTHA="ER DH AH",TRANSFORMER="T R AE N S F AO R M ER",STIMULATE="S T IH M Y AH L EY T",CUBICLE="K Y UW B IH K AH L",SCONES="S K OW N Z",LAMONICA="L AA M OW N IY K AH",DECESARE="D IH CH EH S AA R IY",MILDEWS="M IH L D UW Z",INFILTRATOR="IH N F IH L T R EY T ER",CONTEMPORARIES="K AH N T EH M P ER EH R IY Z",GISI="JH IY S IY",ARMAGEDDON="AA R M AH G EH D AH N",CANTORS="K AE N T ER Z",MORUHIRO="M AO R UW HH IH R OW",BETOOK="B EH T UH K",HOLSTEIN="HH OW L S T IY N",STIRRUP="S T ER AH P",DELIBERATE="D IH L IH B ER AH T",MBEKI="M B EH K IY",FLAMMANG="F L AE M AH NG",WIENERSCHNITZEL="W IY N ER SH N IH T S AH L",RETOOK="R IY T UH K",WARDLE="W AO R D AH L",SCHELLHASE="SH EH L HH AH S",["INHOFE'S(2)"]="IH N HH AA F S",BIGOT="B IH G AH T",MAGLIANO="M AA G L IY AA N OW",APPROBATION="AE P R AH B EY SH AH N",LEBEN="L EH B AH N",MCMEEKIN="M AH K M IY K AH N",SCHMITZ="SH M IH T S",SJOLANDER="SH OW L AE N D ER",SADAKA="S AH D AA K AH",TRAILING="T R EY L IH NG",GAGLIANO="G AA G L IY AA N OW",MCINROY="M AE K IH N R OY",ANDROGYNY="AE N D R AO JH AH N IY",KINNAN="K IH N AH N",INGOT="IH NG G AH T",["JACQUES'(2)"]="JH AE K S",SLAVENS="S L EY V AH N Z",DUNAY="D AH N EY",FINNAN="F IH N AH N",ACIDIFIED="AH S IH D AH F AY D",HOSPITALIZE="HH AO S P IH T AH L AY Z",KICHLINE="K IH K L AY N",CELEBRANTS="S EH L AH B R AH N T S",EXTRUDE="IH K S T R UW D",COUPLED="K AH P AH L D",HOELZER="HH OW L Z ER",GOELZER="G OW L Z ER",LAUNCHINGS="L AO N CH IH NG Z",SMOLENSKI="S M AH L EH N S K IY",WINWORD="W IH N W ER D",EDMUNDS="EH D M AH N D Z",MULHERN="M AH L HH ER N",KOELZER="K OW L Z ER",["WHITMARSH(2)"]="HH W IH T M AA R SH",WARMUP="W AO R M AH P",KUPFERMAN="K AH P F ER M AH N",BAYOU="B AY UW",["DOUGLAS'S"]="D AH G L AH S IH Z",ALTAI="AE L T AY",DICKSON="D IH K S AH N",CENTRALIZED="S EH N T R AH L AY Z D",JOVI="JH OW V IY",MENTORS="M EH N T ER Z",PRECONCEIVED="P R IY K AH N S IY V D",FLAGSTONE="F L AE G S T OW N",ACCEDING="AE K S IY D IH NG",KATSAROS="K AE T S ER OW Z",RICKSON="R IH K S AH N",SNELLINGS="S N EH L IH NG Z",CASIO="K AE S IY OW",SCORPION="S K AO R P IY AH N",VASTNESS="V AE S T N AH S",WHEATLY="W IY T L IY",HICKSON="HH IH K S AH N",["LANAI-CITY"]="L AH N AY S IH T IY",DUCHAMP="D UW SH AA M P",["FOURTHQUARTER(2)"]="F AO R TH K AO R T ER",["MOZART'S"]="M OW Z AA R T S",MYKLEBUST="M IH K AH L B AH S T",WATLINGTON="W AO T AH L IH NG T AH N",CHAOS="K EY AA S",SOBIESKI="S OW B IY EH S K IY",BOTHA="B AA TH AH",["ARAFAT'S(2)"]="EH R AH F AE T S",IMHOFF="IH M HH AO F",LENZINI="L EH N Z IY N IY",COLLAMORE="K OW L AA M AO R",["PRELIMINARIES(2)"]="P R IY L IH M AH N EH R IY Z",SECEDING="S IH S IY D IH NG",MCCUBBINS="M AH K AH B AH N Z",FINANCED="F IH N AE N S T",ALTIERI="AA L T IH R IY",BAFOKENG="B AE F OW K EH NG",ENSNARES="IH N S N EH R Z",TELETTRA="T EH L EH T R AH",BROBDINGNAGIAN="B R AO B D IH G N AE G IY AH N",BRILLSTEIN="B R IH L S T IY N",["FOOTE'S"]="F UH T S",LAYAWAY="L EY AH W EY",BOESKY="B OW S K IY",BANKSTON="B AE NG K S T AH N",BLUISH="B L UW IH SH",ALFREDSON="AE L F R IH D S AH N",ERGOT="ER G AH T",ARGOT="AA R G AH T",FLAILING="F L EY L IH NG",GITHA="JH IH DH AH",STRUCTURALLY="S T R AH K CH ER AH L IY",WEAKENED="W IY K AH N D",["MEDICAL(2)"]="M EH D IH K AH L",["CALFED(2)"]="K AE L F EH D",WIEGMAN="W IY G M AH N",SIEGMAN="S IY G M AH N",MCLEMORE="M AH K L EH M ER",LETHA="L EH TH AH",NOVI="N OW V IY",GARMOND="G AA R M AH N D",OBEDIENT="OW B IY D IY AH N T",PERSHINGS="P ER SH IH NG Z",HANNAN="HH AE N AH N",KANNAN="K AA N AH N",KNEISLEY="N IY S L IY",LANNAN="L AE N AH N",["GRIER(2)"]="G R IY R",MADERA="M AA D EH R AH",ALMAY="AA L M EY",SPELLINGS="S P EH L IH NG Z",MICHELOTTI="M IH K AH L OW T IY",HIPPENSTEEL="HH IH P IH N S T IY L",CANNAN="K AE N AH N",BANNAN="B AE N AH N",SESHADRI="S EH SH AA D R IY",CIRCUMVENTION="S ER K AH M V EH N CH AH N",["LIONETTI(2)"]="L AY AH N EH T IY",["GENTLEMEN(2)"]="JH EH N AH L M IH N",PARENTING="P EH R AH N T IH NG",["BRONFMAN'S"]="B R AA N F M AH N Z",OLESKY="AH L EH S K IY",ANXIETIES="AE NG Z AY AH T IY Z",JACKET="JH AE K AH T",SECULAR="S EH K Y AH L ER",["UNANIMITY(2)"]="Y UW N AH N IH M IH T IY",SCRIMMAGE="S K R IH M IH JH",JOAQUIN="W AA K IY N",GREATLY="G R EY T L IY",GLAVAN="G L EY V AH N",PACKET="P AE K AH T",VESELY="V IY Z L IY",ANTILOCK="AE N T IY L AA K",HAGGLED="HH AE G AH L D",INITIALIZED="IH N IH SH AH L AY Z D",WESELY="W IY Z L IY",LANKFORD="L AE NG K F ER D",SOBOTA="S AH B OW T AH",PARIMUTUEL="P EH R IH M Y UW CH UW AH L",CHUI="K UW IH",SCHMELZ="SH M EH L Z",WOODBURY="W UH D B EH R IY",GASTRONOMY="G AE S T R AA N AH M IY",JEWELCOR="JH UW AH L K AO R",["AFGHANISTAN'S"]="AE F G AE N AH S T AE N Z",MAKTOUM="M AE K T UW M",LOFTHUS="L AA F TH IH S",SHUI="SH UW IY",PRAGMATIC="P R AE G M AE T IH K",["JUERGEN(2)"]="JH ER G AH N",["ISHI'S"]="IH SH IY Z",CORDLE="K AO R D AH L",AIRCONDITIONS="EH R K AH N D IH SH AH N Z",PRATTLE="P R AE T AH L",DICESARE="D IH CH EH S AA R IY",["FUTURE'S"]="F Y UW CH ER Z",["NEGENT(2)"]="N EH JH AH N T",EXTIRPATES="EH K S T ER P EY T S",DIRECTORS="D ER EH K T ER Z",INSPECTORS="IH N S P EH K T ER Z",["PARIS'(2)"]="P AE R IH S",BORTEN="B AO R T AH N",MIKEL="M IH K AH L",ASPNES="AE S P N EH Z",INTERMIXING="IH N T ER M IH K S IH NG",HORTEN="HH AO R T AH N",CROWDING="K R AW D IH NG",FEMINISM="F EH M IH N IH Z AH M",COLONIST="K AA L AH N IH S T",CORTEN="K AO R T EH N",COPPOCK="K AA P AH K",DEPRIVING="D IH P R AY V IH NG",["HARRISBURGH'S(2)"]="HH EH R IH S B ER G Z",RIDOLFI="R IY D OW L F IY",WIKEL="W IH K AH L",AMBROSIO="AE M B R OW S IY OW",DISGRACE="D IH S G R EY S",[")UN-PARENTHESES"]="AH N P ER EH N TH AH S IY Z",PROCTORSILEX="P R AO K T ER S AY L EH K S",VILLEGAS="V IH L IH G AH Z",MACNAB="M AH K N AE B",MALFITANO="M AE L F IH T AA N OW",CHURILLA="CH ER IH L AH",MORTEN="M AO R T AH N",KORTEN="K AO R T AH N",RESORTS="R IH Z AO R T S",FARHA="F AA R HH AH",SCHUSTER="SH UW S T ER",REMAINS="R IH M EY N Z",SUBCULTURE="S AH B K AH L CH ER",LEFTWINGER="L EH F T W IH NG ER",TELEPICTURE="T EH L AH P IH K CH ER",STAAS="S T AA Z",SCHLACHTER="SH L AE K T ER",SANYO="S AA N Y OW",DWELLINGS="D W EH L IH NG Z",TSUI="T S UW IY",CONSTRAINED="K AH N S T R EY N D",WORTHLESS="W ER TH L AH S",BUZZED="B AH Z D",["CATALYSTS(2)"]="K AE T AH L IH S T S",ARKWRIGHT="AA R K R AY T",COMMUNES="K AA M Y UW N Z",DIIORIO="D IH Y AO R IY OW",DESCARTES="D EY K AA R T",BOTTINI="B OW T IY N IY",TRANSITED="T R AE N Z IH T IH D",["HAMPSHIRE'S"]="HH AE M P SH ER Z",PROGRAMMER="P R OW G R AE M ER",["COULDN'T(2)"]="K UH D AH N",["SCHERING(2)"]="SH EH R IH NG",KIEPER="K IY P ER",ASTOUNDINGLY="AH S T AW N D IH NG L IY",OUTFIELDER="AW T F IY L D ER",["NERO'S"]="N IH R OW Z",ASSOCIATED="AH S OW S IY EY T AH D",PIEPER="P IY P ER",["HERO'S"]="HH IH R OW Z",CREDIBLY="K R EH D AH B L IY",FLOTATION="F L OW T EY SH AH N",MERELY="M IH R L IY",MILSTEIN="M IH L S T AY N",TREPPEL="T R EH P AH L",["SAVAGES(2)"]="S AE V IH JH IH Z",BETTINI="B EH T IY N IY",PERIDOT="P EH R IH D AO T",BRITTAIN="B R IH T AH N",GIGGLED="G IH G AH L D",ENTERPRISING="EH N T ER P R AY Z IH NG",DEGENHARDT="D EH G IH N HH AA R T",BOLIVARS="B AA L AH V ER Z",EFFICIENCIES="IH F IH SH AH N S IY Z",GREELIEVILLE="G R IY L IY V IH L",MONACO="M AA N AH K OW",JUSTINIANO="JH UW S T IY N IY AA N OW",KOEPPEL="K OW P AH L",POLYGONAL="P AH L IH G AH N AH L",["UKRAINIAN'S"]="Y UW K R EY N IY AH N Z",DRAPKIN="D R AE P K IH N",OVERPOPULATED="OW V ER P AA P Y AH L EY T IH D",FRAGRANT="F R EY G R AH N T",["PUGET-1"]="P Y UW JH IH T W AH N",KUBOTA="K UW B OW T AH",MARTENEY="M AA R T IH N IY",DEFICIENCIES="D IH F IH SH AH N S IY Z",ANTOLINI="AE N T OW L IY N IY",RACQUET="R AE K IH T",SLEEKLY="S L IY K L IY",UNDERSCORE="AH N D ER S K AO R",JACQUET="JH AE K EH T",FICTIONALIZE="F IH K SH AH N AH L AY Z",["COUNTERSUING(2)"]="K AW N ER S UW IH NG",DECATHLON="D IY K AE TH L AO N",JAKUBOWICZ="Y AH K AH B AH V IH CH",BEAVAN="B EH V AH N",CONTINGENCY="K AH N T IH N JH AH N S IY",BUCKET="B AH K AH T",JAKEL="JH AE K AH L",["MIRO'S"]="M IH R OW Z",["REGISTER'S"]="R EH JH IH S T ER Z",HILLIAN="HH IH L Y AH N",GILLIAN="JH IH L IY AH N",ARNWINE="AA R N W AY N",LILLIAN="L IH L IY AH N",KILLIAN="K IH L Y AH N",JILLIAN="JH IH L IY AH N",SCHMOYER="SH M OY ER",INTERMET="IH N T ER M EH T",["PICKENS'"]="P IH K AH N Z",KAUAI="K AW AY",["SUSPENDED(2)"]="S AH S P EH N D IH D",CARESSING="K ER EH S IH NG",SEMIGLOSS="S EH M IY G L AA S",["DICKENS'"]="D IH K AH N Z",FODERA="F OW D EH R AH",FERVOR="F ER V ER",BOGGS="B AO G Z",ORIGINATE="ER IH JH AH N EY T",HAULS="HH AO L Z",GAULS="G AO L Z",SPATARO="S P AA T AA R OW",SAULS="S AO L Z",RAULS="R AA UW L Z",["INTERMEDIATES(2)"]="IH N T ER M IY D IY EY T S",QUIZARD="K W IH Z ER D",TONAWANDA="T AA N AH W AA N D AH",AMPLIFY="AE M P L AH F AY",ARCANE="AA R K EY N",SCHMUHL="SH M AH L",["FURR'S"]="F ER Z",["NUTRI(2)"]="N UW T R IH",["NATURE'S"]="N EY CH ER Z",STABBED="S T AE B D",SHIREMANSTOWN="SH AY R M AH N Z T AW N",EXPLORERS="IH K S P L AO R ER Z",ECKEL="EH K AH L",PITTENCRIEFF="P IH T IH N K R IY F",CANDELABRA="K AE N D AH L AA B R AH",HELMKAMP="HH EH L M K AE M P",EUCLEA="Y UW K L IY AH",FRENZIED="F R EH N Z IY D",YOSHIRO="Y OW SH IH R OW",["STUHR(2)"]="S T UH R",SCHNEITER="SH N AY T ER",DEACTIVATED="D IY AE K T IH V EY T IH D",PYHRRIC="P IH R IH K",TOPEKANS="T AH P IY K AH N Z",TUNGSROM="T AH NG Z R AH M",CERAMIC="S ER AE M IH K",VALENCE="V EY L AH N S",TURBOTAX="T ER B OW T AE K S",NYINA="N AY IY N AH",BOOKSHOP="B UH K SH AA P",KHUMALO="K Y UW M AA L OW",SHAULL="SH AO L",["CABLEC(3)"]="K EY B L EH K",SONNIER="S AH N IY ER",MONNIER="M AA N IY ER",SCABBARD="S K AE B ER D",BLACKIE="B L AE K IY",HAMBRIGHT="HH AE M B R AY T",LAMBRIGHT="L AE M B R AY T",PIGSKINS="P IH G S K IH N Z",UPPERCLASS="AH P ER K L AE S",LEWKOWICZ="L UW K AH V IH CH",DEMOTE="D IH M OW T",["GARRETT(2)"]="G EH R IH T",["GOLDBERG'S"]="G OW L D B ER G Z",["MARLBORO'S"]="M AA R L B ER R OW Z",RODRIQUEZ="R AA D R IY K EH Z",POWERLESS="P AW ER L AH S",REMOTE="R IH M OW T",SOCIOLOGIST="S OW S IY AA L AH JH IH S T",["BARCLAYS(2)"]="B AA R K L EY Z",STRESSING="S T R EH S IH NG",HUDWON="HH AH D W AH N",SUGGS="S AH G Z",ASSORTED="AH S AO R T IH D",["FOUR'S"]="F AO R Z",["HOUR'S"]="AW ER Z",VAGINAL="V AH JH AY N AH L",VANVLIET="V AE N V L IY T",["INGENUE(2)"]="AA N JH AH N UW",GALLAMORE="G AA L AA M AO R",LUSCOMBE="L UW S K OW M B IY",["KEYES'"]="K IY Z",["COUNTERTOPS(2)"]="K AW N ER T AA P S",IRONWOOD="AY ER N W UH D",GLUTEN="G L UW T AH N",["DREPUNG(2)"]="D R EY P AO NG",["TOUR'S"]="T UH R Z",DENBOW="D EH N B OW",["HUMID(3)"]="Y UW M AH D",PROBABILITIES="P R AA B AH B IH L AH T IY Z",BRANIGAN="B R AE N IH G AH N",GLACIATE="G L EY SH IY EY T",STREHLOW="S T R EH L OW",EXHUMED="EH K S HH Y UW M D",CHIPMAKER="CH IH P M EY K ER",JOCULAR="JH AA K Y AH L ER",OUTSMARTED="AW T S M AA R T AH D",HALOS="HH EY L OW Z",KEMERER="K EH M ER ER",CREWES="K R UW Z",DISPROPORTIONATE="D IH S P R AH P AO R SH AH N IH T",CAUDLE="K AO D AH L",BENBOW="B EH N B OW",PALOS="P AA L OW Z",DREWES="D R UW Z",KINNAMAN="K IH N AH M AH N",DAYDREAMED="D EY D R IY M D",MEMORIZED="M EH M ER AY Z D",UNTOUCHABLES="AH N T AH CH AH B AH L Z",EMACIATE="IH M EY SH IY EY T",COMPETITIVE="K AH M P EH T AH T IH V",MROCZEK="M R AA CH EH K",PIRANHA="P IH R AE N HH AH",FETROW="F EH T R OW",["HARVEY'S"]="HH AA R V IY Z",["RECEIVING(3)"]="R IY S IY V IH NG",BLISTERING="B L IH S T ER IH NG",GLITTERS="G L IH T ER Z",["SEMIANNUAL(2)"]="S EH M AY AE N Y AH W AH L",BUGGS="B AH G Z",COMPUNCTION="K AH M P AH NG K SH AH N",LEVI="L IY V AY",["SALVI'S"]="S AA L V IY Z",HARBOUR="HH AA R B ER",BARBOUR="B AA R B ER",["AMOCO'S"]="AE M AH K OW Z",[")END-PARENS"]="EH N D P ER EH N Z",["RETRIEVAL(2)"]="R IY T R IY V AH L",EXPLOITATIVE="EH K S P L OY T AH T IH V",FORMALDEHYDE="F AO R M AE L D AH HH AY D",NUNGESSER="N AH NG G IH S ER",CONSIDERABLY="K AH N S IH D ER AH B L IY",VINTNERS="V IH N T N ER Z",["JACKSONVILLE'S"]="JH AE K S AH N V IH L Z",MICROCOSM="M AY K R AH K AA Z AH M",SUPERDRUG="S UW P ER D R AH G",["RECEPTION(2)"]="R IY S EH P SH AH N",["KAPLER(2)"]="K EY P L ER",EMPHASIZE="EH M F AH S AY Z",SATURDAY="S AE T ER D IY",["SPELLING'S"]="S P EH L IH NG Z",WESTMIN="W EH S T M IH N",["ESPERANTO'S"]="EH S P ER AE N T OW Z",DEWARR="D UW ER",HERCEGOVINA="HH EH R T S AH G OW V IY N AH",["FORBIDS(2)"]="F AO B IH D Z",SOVIETOLOGIST="S OW V IY AH T AA L AH JH IH S T",DOCKET="D AA K AH T",PEOPLED="P IY P AH L D",GIBAS="JH AY B AH Z",ATTEMPT="AH T EH M P T",LYNCHINGS="L IH N CH IH NG Z",HIBERNATION="HH AY B ER N EY SH AH N",RIBAS="R AY B AH Z",VERTIBRAK="V ER T AH B R AE K",PREDATE="P R IY D EY T",POSSESSES="P AH Z EH S AH Z",NOWLIN="N AW L IH N",DYESTUFFS="D AY S T AH F S",OUTDOES="AW T D AH Z",BOWLIN="B OW L IH N",SOCKET="S AA K AH T",["MONTE'S"]="M AA N T IY Z",POCKET="P AA K AH T",STELLHORN="S T EH L HH ER N",REIMBURSE="R IY IH M B ER S",SCHNITZLER="SH N IH T S L ER",ZUMSTEIN="Z AH M S T IY N",BEHEADING="B IH HH EH D IH NG",MCMAINS="M AH K M EY N Z",DEARMOND="D ER M AH N D",CHRISTY="K R IH S T IY",MERIAM="M IH R IY IH M",CHILDENER="CH IH L D N ER",TOGETHER="T AH G EH DH ER",SHALLOWNESS="SH AE L OW N AH S",PRAVDA="P R AE V D AH",INDUSTRIALIZATION="IH N D AH S T R IY AH L IH Z EY SH AH N",["MAUCHER(2)"]="M AA K ER",SHIFLET="SH IH F L IH T",["BARGAINS(2)"]="B AA R G IH N Z",MASCOT="M AE S K AH T",CRONKRIGHT="K R AA NG K R AY T",["CREDITORS'"]="K R EH D IH T ER Z",["LAURI(2)"]="L AA R IY",GUNDLE="G AH N D AH L",FAIELLA="F AY EH L AH",OMISSION="OW M IH SH AH N",CROSSCURRENT="K R AO S K ER AH N T",["NON-CATHOLIC"]="N AA N K AE TH L IH K",NOSTRIL="N AA S T R IH L",RUNDLE="R AH N D AH L",BOREALIS="B AO R IY AE L AH S",ASYMMETRY="EY S IH M AH T R IY",BUNDLE="B AH N D AH L",HANNAMAN="HH AE N AH M AH N",["PETRI(2)"]="P IY T R IY",NEPL="N EH P AH L",CUTHRELL="K AH TH R AH L",["PANGLOSS(2)"]="P AE NG G L AA S",CURLS="K ER L Z",EMISSION="IH M IH SH AH N",LABERGE="L AA B ER G",OCTAVES="AA K T IH V Z",FABERGE="F AE B ER JH",MILOS="M IY L OW Z",KILOS="K IY L OW Z",PONTIKES="P AA N T IY K EH Z",GOODIN="G UH D AH N",NEWGATE="N UW G EY T",["ENEMY'S"]="EH N AH M IY Z",GASSAWAY="G AE S AH W EY",DILORIO="D IH L AO R IY OW",PREEMPTING="P R IY EH M P T IH NG",MENINGITIS="M EH N AH N JH AY T AH S",COGLIANO="K OW G L IY AA N OW",APPROACHES="AH P R OW CH AH Z",ELECTROBIOLOGY="IH L EH K T R OW B AY AA L AH JH IY",KISSANE="K IH S AH N",GRASP="G R AE S P",["SANCTION'S(2)"]="S AE NG SH AH N Z",REPRINT="R IY P R IH N T",["WHORL(2)"]="W AO R L",GASEOUS="G AE S IY AH S",KINKADE="K IH NG K AH D",RICKWARD="R IH K W ER D",["CROIX'S"]="K R OY Z",REGRET="R AH G R EH T",TARDIF="T AA R D IH F",MICROCHIP="M AY K R OW CH IH P",KEEFFE="K IY F",SAFRANEK="S AE F R AH N IH K",TOKARSKI="T AH K AA R S K IY",ZALAY="Z AH L EY",MARGOLICK="M AA R G OW L IH K",SHEWCHUK="SH EH CH AH K",SHACKLES="SH AE K AH L Z",SALAY="S AE L EY",OVERPOWERING="OW V ER P AW R IH NG",MALAY="M EY L EY",IMPROPRIETIES="IH M P R AH P R AY AH T IY Z",LORRAINE="L ER EY N",PALAY="P EY L EY",FINNERAN="F IH N ER AE N",BIRDFEATHER="B ER D F EH DH ER",INHERITANCE="IH N HH EH R AH T AH N S",ZELOS="Z IY L OW Z",ANNOUNCER="AH N AW N S ER",TELOS="T EH L OW S",SHIPHOLDING="SH IH P HH OW L D IH NG",TAUBES="T AW B Z",SJODIN="SH OW D IH N",PREPACKAGE="P R IY P AE K AH JH",CHINOY="CH IH N OY",CONROW="K AA N R OW",DEAFNESS="D EH F N AH S",IDITAROD="IH D IH T AH R AO D",["DUDAYEV'S"]="D UW D AY EH V Z",BOLSHEVISM="B OW L SH AH V IH Z AH M",SERVICEMEN="S ER V AH S M EH N",EXHIBITS="IH G Z IH B AH T S",CLOWES="K L AW Z",MAGMA="M AE G M AH",STETHOSCOPE="S T EH TH AH S K OW P",MCLAY="M AH K L EY",COMPUTALOG="K AA M P Y UW T AE L AO G",FLODIN="F L OW D IH N",KALIVODA="K AH L IH V OW D AH",PREPLANNING="P R IY P L AE N IH NG",SANITATION="S AE N AH T EY SH AH N",["EMPLOYEES'"]="EH M P L OY IY Z",DEPRAVITY="D IH P R AE V AH T IY",QUIMBY="K W IH M B IY",MAHARAJAHS="M AA HH ER AA JH AH Z",UTGOFF="AH T G AO F",DOVISH="D OW V IH SH",FRAAS="F R AA Z",CUL_DE_SAC="K AH L D IH S AE K",["PUBLICATION'S"]="P AH B L IH K EY SH AH N Z",GATELY="G EY T L IY",REINFORCING="R IY IH N F AO R S IH NG",RAINDROP="R EY N D R AA P",FITZMORRIS="F IH T S M AO R IH S",LATELY="L EY T L IY",DAMNATION="D AE M N EY SH AH N",STEEPLY="S T IY P L IY",NANNINGA="N AA N IY NG G AH",SQUEAKER="S K W IY K ER",CRACKLES="K R AE K AH L Z",BARCROFT="B AA R K R AO F T",WUXI="W AH K S IY",MENDOLIA="M EH N D OW L IY AH",COWHER="K AA W ER",EXPENDABLE="IH K S P EH N D AH B AH L",RUNNION="R AH N Y AH N",MOAWIYA="M OW AA W IY AH",DECAMILLO="D EH K AH M IH L OW",["MCFLY'S"]="M AH K F L AY Z",EXCLAIMS="IH K S K L EY M Z",DIGIOVANNI="D IH JH OW V AA N IY",UNFAILING="AH N F EY L IH NG",JORIO="JH AO R IY OW",DECERTIFY="D IY S ER T AH F AY",LORIO="L AO R IY OW",CORIO="K AO R IY OW",ELECTRODYNAMIC="IH L EH K T R OW D AY N AE M IH K",DORIO="D AO R IY OW",HAVERLAND="HH AE V ER L AH N D",IORIO="IY AO R IY OW",HIMMELSTEIN="HH IH M AH L S T AY N",["CORP."]="K AO R P",BEARINGS="B EH R IH NG Z",WHIPKEY="W IH P K IY",HEARINGS="HH IY R IH NG Z",["MOOREFIELD(2)"]="M UH R F IY L D",BACKWARD="B AE K W ER D",["VILLE'S"]="V IH L Z",MEISELS="M AY S AH L Z",IMPRINT="IH M P R IH N T",THREEFOLD="TH R IY F OW L D",COHESIVELY="K OW HH IY S IH V L IY",SERIO="S IY R IY OW",SOLOS="S OW L OW Z",["CABO(2)"]="S IY EY B IY OW",THULIN="TH UW L IH N",["CABLEC(2)"]="K EY B AH L S IY",CHISELS="CH IH Z AH L Z",PERNICIOUS="P ER N IH SH AH S",UNDERCURRENTS="AH N D ER K ER AH N T S",MESTEK="M EH S T EH K",GAULIN="G OW L AE N",LEWD="L UW D",CLAPPED="K L AE P T",["BUFFETT'S"]="B AH F AH T S",AUTISM="AO T IH Z AH M",EMASCULATED="AH M AE S K Y UW L EY T IH D",SLAPPED="S L AE P T",MAXI="M AE K S IY",["HUMANKIND'S"]="HH Y UW M AH N K AY N D Z",DICAMILLO="D IH K AA M IH L OW",TAXI="T AE K S IY",["ANTHONY'S"]="AE N TH AH N IY Z",["SHEEHAN(2)"]="SH IY HH AH N",SCHIESS="SH IY S",MONEYPENNY="M AH N IY P EH N IY",MACNEIL="M AH K N IY L",REINTERPRETATION="R IY IH N T ER P R AH T EY SH AH N",SUSPICIONS="S AH S P IH SH AH N Z",OVERSUBSCRIBED="OW V ER S AH B S K R AY B D",["ANNEX(2)"]="AH N EH K S",BEUTEL="B Y UW T EH L",NEVERLAND="N EH V ER L AE N D",LAWRENCEVILLE="L AO R AH N S V IH L",["DANTE'S"]="D AE N T IY Z",["ERSHAD(2)"]="ER SH AA D",["KARDASHIAN'S"]="K AA D AH SH EY N Z",LEGISLATIVE="L EH JH AH S L EY T IH V",QUITTERS="K W IH T ER Z",BARTOSH="B AA R T AH SH",INFOTECHNOLOGY="IH N F OW T EH K N AA L AH JH IY",SCHUESSLER="SH UW S L ER",["DEBORAH(2)"]="D EH B R AH",PARTINGTON="P AA R T IH NG T AH N",PORZIO="P AO R Z IY OW",COPENHAVER="K AH P EH N HH AH V ER",PERFECTED="P ER F EH K T AH D",["LIEBLING(2)"]="L IY B L IH NG",["NIEBLING(2)"]="N IY B L IH NG",UNEMPLOY="AH N IH M P L OY",BLAIKIE="B L EY K IY",TACTILE="T AE K T IH L",LEONARDI="L EH N AA R D IY",["PALMDALE'S"]="P AA M D EY L Z",BAWD="B AO D",PYLOS="P AY L OW S",SOFTECH="S AO F T EH K",ELECTIONEER="IH L EH K SH AH N IH R",FELBATOL="F EH L B AH T AA L",["INTEGRATED'S"]="IH N T AH G R EY T IH D Z",["HOOFED(2)"]="HH UW F T",BAYLIS="B EY L IH S",JEKEL="JH EH K AH L",CHIGGERS="CH IH G ER Z",["STORES'"]="S T AO R Z",ATTITUDES="AE T AH T UW D Z",FOLIAGE="F OW L IH JH",RECOGNITION="R EH K AH G N IH SH AH N",LAVECCHIA="L AA V EH K IY AH",ZAPATISTAS="Z AA P AH T IY S T AH Z",FACTORY="F AE K T ER IY",MISPERCEIVES="M IH S P ER S IY V Z",FOULS="F AW L Z",MARTORELLI="M AA R T AO R EH L IY",GRAPER="G R EY P ER",BREGUET="B R IY G AH T",SOULS="S OW L Z",FASCINATION="F AE S AH N EY SH AH N",PSALM="S AA L M",COERCING="K OW ER S IH NG",ZEPPENFELD="Z EH P AH F EH L D",BARRINEAU="B AE R IH N OW",["SRI-LANKA"]="S R IY L AE NG K AH",INHIBITS="IH N HH IH B AH T S",["REVOKING(2)"]="R IY V OW K IH NG",SABAS="S AA B AH Z",CHERNICK="CH ER N IH K",CLIGGOTT="K L IH G AH T",PIERCING="P IH R S IH NG",SNOWDON="S N OW D AH N",ETRUSCANS="IH T R AH S K AH N Z",["APPALACHIANS(2)"]="AE P AH L EY SH AH N Z",DRAPER="D R EY P ER",PERSPECTIVES="P ER S P EH K T IH V Z",CYPRIS="S AY P R IH S",PALMSTIERNA="P AO L M S T IY EH R N AH",["BOUCHER(2)"]="B AW CH ER",["LOWNDES(2)"]="L OW N D Z",PROFILED="P R OW F AY L D",["HEMOPHILIAC(4)"]="HH IY M OW F IH L Y AE K",DRAFTER="D R AE F T ER",VANHOUTEN="V AE N HH AA UW T AH N",CHIRP="CH ER P",MACAU="M AH K AW",HAGENBUCH="HH AE G IH N B AH K",DAMROW="D AE M R OW",DERISION="D ER IH ZH AH N",DIVERTICULUM="D AY V ER T IH K Y AH L AH M",DOGMA="D AA G M AH",["PULSAR'S"]="P UH L S ER Z",PRETEND="P R IY T EH N D",FARLEE="F AA R L IY",["D'ELECTRICITE"]="D AH L EH K T R IH S AH T EY",KEYNES="K EY N Z",STEPCHILD="S T EH P CH AY L D",LAFRAMBOISE="L AH F R AE M B W AA",KOLOWICH="K AA L AH W IH CH",CATALOGED="K AE T AH L AO G D",["MULVIHILL(2)"]="M AH L V IH HH IH L",PRIORITIZE="P R AY AO R AH T AY Z",EQUESTRIAN="IH K W EH S T R IY AH N",["GRINDLAYS(2)"]="G R IH N D L IY Z",CONNIVE="K AH N AY V",ARMAGOST="AA R M AA G OW S T",["ENOUGH'S"]="IH N AH F S",["O'GORMAN"]="OW G AO R M AH N",SAMOS="S EY M AA S",RAMOS="R AA M OW S",EXHAUSTIVE="IH G Z AO S T IH V",CERIO="CH EH R IY OW",MODULAR="M AA JH AH L ER",NODULAR="N AA JH AH L ER",NERIO="N EH R IY OW",BANDAR="B AE N D AA R",["N-TUPLE"]="EH N T UW P AH L",TRANSFERABILITY="T R AE N S F ER AH B IH L IH T IY",PARSED="P AA R S T",["ALFRE(2)"]="AE L F R IY",TURNBOW="T ER N B OW",SEMROW="S EH M R OW",CHUSTZ="CH AH S T S",HOUDESHELL="HH UW D IH SH AH L",SKALICKY="S K AH L IH K IY",DEDUCTIBILITY="D IH D AH K T AH B IH L AH T IY",SHALLENBERGER="SH AO L AH N B ER G ER",["MAVERICKS(2)"]="M AE V R IH K S",["RICH'S"]="R IH CH IH Z",["PATRIARCH'S"]="P EY T R IY AA R K S",URIEGAS="Y ER IY G AH Z",INJURES="IH N JH ER Z",APPROPRIATENESS="AH P R OW P R IY AH T N AH S",BAKEWARE="B EY K W EH R",WILLETTS="W IH L IH T S",MECIAR="M EH S IY AA R",BILLABLE="B IH L AH B AH L",["D'ETAT"]="D EH T AE T",COEXISTING="K OW IH G Z IH S T IH NG",ALEXANDRINE="AE L AH G Z AE N D R IY N",GRANGE="G R EY N JH",CURLEE="K ER L IY",["PLAVSIC'S"]="P L AE V S IH K S",PICKET="P IH K IH T",INSOLENT="IH N S AH L AH N T",TICKET="T IH K AH T",WICKET="W IH K AH T",["(IN-PARENTHESES"]="IH N P ER EH N TH AH S IY Z",PRANGE="P R EY N JH",ORANGE="AO R AH N JH",INFECTS="IH N F EH K T S",LAMOS="L AA M OW S",VISCARDI="V IY S K AA R D IY",CALUMNY="K AE L AH M N IY",MONTANANS="M AA N T AE N AH N Z",ANKLAM="AE NG K L AH M",["INSURERS'"]="IH N SH UH R ER Z",["THREATENINGLY(2)"]="TH R EH T N IH NG L IY",AMPLIFIER="AE M P L AH F AY ER",MATTHIES="M AE TH IY Z",["KOMARIK'S"]="K OW M AA R IH K S",READMIT="R IY AH D M IH T",BRODIN="B R OW D IH N",STERLE="S T ER AH L",STANGE="S T AE N JH",GRODIN="G R OW D IH N",TORTORELLI="T AO R T AO R EH L IY",RECTORY="R EH K T ER IY",NIKOU="N IY K UW",GAMBREL="G AE M B R AH L",DUPAY="D UW P EY",ETHIOPIANS="IY TH IY OW P IY AH N Z",BENYO="B EY N Y OW",SUFFRAGISTS="S AH F R AH JH IH S T S",THRUSTERS="TH R AH S T ER Z",STARZYK="S T AA R Z IH K",APTITUDES="AE P T AH T UW D Z",IVANOV="IH V AH N AA V",EVANOV="EH V AH N AO V",SIGMA="S IH G M AH",BECKET="B EH K AH T",CHRISTLIEB="K R IH S T L IY B",["DIRECTS(3)"]="D IY R EH K T S",BUCKBEE="B AH K B IY",EXPORTABLE="EH K S P AO R T AH B AH L",["SCOUR(2)"]="S K AW R",FARMWORKER="F AA R M W ER K ER",MAXXIM="M AE K S IH M",["EFFECTIVENESS(2)"]="IY F EH K T IH V N AH S",EIGHTFOLD="EY T F OW L D",["VIETNAM'S"]="V IY EH T N AA M Z",BISCARDI="B IH S K AA R D IY",ASSESSING="AH S EH S IH NG",["OUTSIDERS'"]="AW T S AY D ER Z",SISTEK="S IH S T IH K",ECLIPSES="IH K L IH P S IH Z",NUJOMA="N UW JH OW M AH",VIROLOGIST="V IH R AA L AH JH IH S T",ALCATRAZ="AE L K AH T R AE Z",ABSOLUTES="AE B S AH L UW T S",SUSTAINABLE="S AH S T EY N AH B AH L",CATERWAUL="K AE T ER W AA L",["CORDIANT'S"]="K AO R D IY AH N T S",SPERLE="S P ER L",CLASP="K L AE S P",SCHAAP="SH AA P",["REPORTS'"]="R IH P AO R T S",PROFESSED="P R AH F EH S T",BRUGGEMAN="B R AH G M AH N",["ACCEPTABLE(2)"]="AH K S EH P T AH B AH L",KLAAS="K L AA S",JULIO="JH UW L IY OW",PARTLY="P AA R T L IY",TARTLY="T AA R T L IY",["WHAT'D(2)"]="HH W AH T IH D",BITTEL="B IH T AH L",SILVERMAN="S IH L V ER M AE N",WILKOWSKI="V IH L K AO F S K IY",AFFECTS="AH F EH K T S",KITTEL="K IH T AH L",COUDERT="K UW D ER T",EFFECTS="IH F EH K T S",ATMEL="AE T M AH L",MILKOWSKI="M IH L K AO F S K IY",AGLITTER="AH G L IH T ER",JACKSON="JH AE K S AH N",ATTLEE="AE T L IY",TITTEL="T IH T AH L",ZITTEL="Z IH T AH L",CLEMENTE="K L AH M EH N T EY",EARLIEST="ER L IY AH S T",AMBROGIO="AE M B R OW JH IY OW",TWIGS="T W IH G Z",RIMEL="R IH M AH L",LUSAKA="L UW S AA K AH",REPENTING="R IH P EH N T IH NG",KIMEL="K IH M AH L",HIMEL="HH IH M AH L",CONCEIVABLY="K AH N S IY V AH B L IY",GYMNASTS="JH IH M N AE S T S",CUSTODIO="K UW S T OW D IY OW",LIMOS="L IH M OW Z",ESPOUSING="IH S P AW Z IH NG",LAMAY="L AE M EY",ANALOGY="AH N AE L AH JH IY",DEVOTES="D IH V OW T S",["CONVERSION'S"]="K AH N V ER ZH AH N Z",REMOVER="R IH M UW V ER",DEMENTIA="D IH M EH N SH IY AH",HOUSEKEEPING="HH AW S K IY P IH NG",CALLICOAT="K AE L IH K OW T",UNOCAL="Y UW N AH K AE L",SHIMMIN="SH IH M IH N",MIRACID="M IH R AE S AH D",KIMBREL="K IH M B R AH L",CHAPPELLE="SH AH P EH L",DEPENDABLE="D IH P EH N D AH B AH L",MALLICOAT="M AE L IH K OW T",MCDYESS="M AH K D AY AH S",CAPITALISM="K AE P IH T AH L IH Z AH M",SAUERTEIG="S AW ER T EY G",COMPUTERIZE="K AH M P Y UW T ER AY Z",MORANDO="M AO R AA N D OW",DEZIEL="D EH Z IY L",AVENGER="AH V EH N JH ER",DARESAY="D EH R S EY",MOSTEK="M AA S T IH K",FEDECCREDITO="F EH D EH K R EH D IY T OW",KOSTEK="K AA S T EH K",KOEKI="K OW K IY",IMPORTANCE="IH M P AO R T AH N S",HATAWAY="HH AE T AH W EY",VEGETAL="V EH JH AH T AH L",EMMEL="EH M AH L",STALEMATED="S T EY L M EY T IH D",["WHEELWRITER(2)"]="HH W IY L R AY T ER",PRESENTABLE="P R AH Z EH N T AH B AH L",["EL-AL"]="EH L AE L",UMMEL="AH M AH L",["KERATIN(2)"]="K EH R AH T IH N",IMMEL="IH M AH L",ARRIVAL="ER AY V AH L",["DISABILITY(2)"]="D IH S AH B IH L IH T IY Z",ACCORDING="AH K AO R D IH NG",GUGLIELMETTI="G UW G L IY EH L M EH T IY",LEMOS="L IY M OW Z",MCGILVERY="M AH G IH L V ER IY",OBERLE="OW B ER AH L",EARMARKS="IH R M AA R K S",SUMPTER="S AH M P T ER",NEMOS="N IY M OW Z",DEMOS="D EH M OW Z",CORRESPONDENTS="K AO R AH S P AA N D AH N T S",LEMAY="L EH M EY",CIRCUMSCRIBED="S ER K AH M S K R AY B D",PALAZZI="P AA L AA T S IY",ZENTEC="Z EH N T EH K",DEMAY="D EH M EY",DUBOSE="D UW B OW Z",EBERLE="EH B ER AH L",["DOCUMENTARIES(2)"]="D AA K Y AH M EH N ER IY Z",DIETL="D AY AH T L",REALM="R EH L M",BUENGER="B Y UW N JH ER",GORDJI="G AO R JH IY",INCITEMENTS="IH N S AY T M AH N T S",JUENGER="Y UW NG G ER",SCALFARO="S K AE L F AA R OW",SCARPINO="S K AA R P IY N OW",INTERSECT="IH N T ER S EH K T",LAUBHAN="L AW B HH AH N",DRYWALL="D R AY W AA L",CONCERTO="K AH N CH EH R T OW",CIRCUITED="S ER K AH T IH D",["FRANCISCO'S"]="F R AE N S IH S K OW Z",["DONIZETTI'S"]="D AA N IH Z EH T IY Z",GLYCEMIC="G L AY S EH M IH K",RECITALS="R IH S AY T AH L Z",["DALAI(2)"]="D AO L AY",LUCAS="L UW K AH S",MATTEL="M AH T EH L",GETAWAY="G EH T AH W EY",RUCKSACK="R AH K S AE K",STAGNATION="S T AE G N EY SH AH N",SHIPPINGPORT="SH IH P IH NG P AO R T",RAYNES="R EY N Z",["TUMS'"]="T AH M Z",LANDSCAPING="L AE N D S K EY P IH NG",TAVLIN="T AE V L IH N",OLMOS="OW L M OW Z",MAYNES="M EY N Z",HAVLIN="HH AE V L IH N",JAYNES="JH EY N Z",LOOSED="L UW S T",HAYNES="HH EY N Z",KAMEL="K AA M AH L",["INTERCHANGEABLY(2)"]="IH N ER CH EY N JH AH B L IY",HAMEL="HH AE M AH L",GAMEL="G AA M AH L",RECORDED="R AH K AO R D AH D",TOWNSHIP="T AW N SH IH P",RAMEL="R AE M AH L",DIGITIZE="D IH JH AH T AY Z",ALMOS="AA L M OW S",COSIO="K OW S IY OW",MONTHLONG="M AH N TH L AO NG",["EXTINCTIONS(2)"]="IH K S T IH NG SH AH N Z",["OUTLER(2)"]="AW T L ER",PANMURE="P AE N M UH R",DAVLIN="D AE V L IH N",CRESTMONT="K R EH S T M AA N T",ROSEATE="R OW Z IY AH T",HARBORING="HH AA R B ER IH NG",BEDTIME="B EH D T AY M",WORTHIES="W ER DH IY Z",ARMSTRONG="AA R M S T R AA NG",SPINAL="S P AY N AH L",ACCORDED="AH K AO R D IH D",["JEFFERIES'"]="JH EH F ER IY Z",STANDBYS="S T AE N D B AY Z",STROMBECK="S T R AA M B EH K",["KOTLER(2)"]="K AA T L ER",DEFECTS="D IY F EH K T S",["COTLER(2)"]="K AA T L ER",PLOCHER="P L AA K ER",DETERRING="D IH T ER IH NG",SEBACEOUS="S AH B EY SH AH S",THEATRICAL="TH IY AE T R IH K AH L",BLOCHER="B L AA K ER",GULLATT="G AH L AH T",SULKOWSKI="S AH L K AO F S K IY",EXTRACT="EH K S T R AE K T",CONCURRENT="K AH N K ER AH N T",CARTWHEEL="K AA R T W IY L",HETTEL="HH EH T AH L",GETTEL="G EH T AH L",SECOND="S EH K AH N D",["DANIELS'S(2)"]="D AE N Y EH L Z IH Z",["CARTHAGE(2)"]="K AA R TH IH JH",PEDROLI="P EH D R OW L IY",ZETTEL="Z EH T AH L",PILEUP="P AY L AH P",INNOCENT="IH N AH S AH N T",ARREARAGES="ER IH R IH JH IH Z",HEMEL="HH EH M AH L",MEMEL="M EH M AH L",SEMEL="S EH M AH L",["COMMUNISTS'"]="K AA M Y UW N IH S T S",FINANCIER="F IH N AH N S IH R",UPHOFF="AH P HH AO F",["SITLER(2)"]="S AY T L ER",VANOVER="V AE N OW V ER",KOZIEL="K AA Z IY L",TENEBROUS="T EH N AH B R AH S",["PUIPOE(2)"]="P W IY P OW",HAGERSTOWN="HH EY G ER Z T AW N",CRIMINALLY="K R IH M AH N AH L IY",REDEEMING="R IH D IY M IH NG",KAYVON="K EY V AA N",PROGRESSION="P R AH G R EH SH AH N",CHAIRMEN="CH EH R M IH N",COMPTEK="K AA M P T EH K",NECESSITATES="N AH S EH S AH T EY T S",LAXALT="L AE K S AA L T",LEEDOM="L IY D AH M",BERNARDI="B ER N AA R D IY",["ANTIDUMPING(2)"]="AE N T AY D AH M P IH NG",REMBRANDT="R EH M B R AE N T",["BARROWMAN(2)"]="B EH R OW M AH N",ULYSSES="Y UW L IH S IY Z",MCDORMAN="M AH K D AO R M AH N",["EAGLE'S"]="IY G AH L Z",LOMONACO="L OW M OW N AA K OW",["NEW-HAMPSHIRE'S"]="N UW HH AE M P SH ER Z",REVIEWED="R IY V Y UW D",FIRSTHAND="F ER S T HH AE N D",MYRIAM="M IH R IY AH M",["ADOLF'S"]="EY D AA L F S",UTOPIANS="Y UW T OW P IY AH N Z",COMPENSATE="K AA M P AH N S EY T",NEOTENY="N IY AA T AH N IY",SPOTTERS="S P AA T ER Z",["DEANDREA(2)"]="D IY AE D R EY AH",PENDOLA="P EH N D OW L AH",FORGIVENESS="F ER G IH V N AH S",MENDOLA="M EH N D OW L AH",PERVADING="P ER V EY D IH NG",GREINKE="G R EY NG K",SIDEWAYS="S AY D W EY Z",ANTIREFORMERS="AE N T IY R IH F AO R M ER Z",["GRAPHICS'"]="G R AE F IH K S",ALEKSANDR="AE L AH K S AE N D ER",GERMOND="G ER M AH N D",["CATACOSINOS'S"]="K AH T AE K AH S IY N AH S IH Z",PRADA="P R AA D AH",HYMEL="HH AY M AH L",RIVLIN="R IH V L IH N",MCGOFF="M AH G AO F",["BITLER(2)"]="B AY T L ER",POLARITY="P OW L EH R AH T IY",["THEORY'S"]="TH IH R IY Z",BREAZEALE="B R IY Z IY L",SPELLMAN="S P EH L M AH N",["CONTINENT'S"]="K AA N T AH N AH N T S",BARTHOLOW="B AA R TH AH L OW",NORSK="N AO R S K",CHAZANOFF="CH AE Z AH N AO F",MOTORING="M OW T ER IH NG",TEXT="T EH K S T",ELECTROCOM="IH L EH K T R OW K AA M",BERTINI="B ER T IY N IY",SAENGER="S EH N JH ER",STETHEM="S T EH TH AH M",["ABRAMS'S"]="EY B R AH M Z IH Z",HOMEPORTING="HH OW M P AO R T IH NG",NEXT="N EH K S T",MUHLBAUER="M UW L B AW ER",LEIMERT="L IY M ER T",REFCORP="R EH F K AO R P",["DIRECTING(3)"]="D AY R EH K T IH NG",DRUPES="D R UW P S",RIVERSO="R IH V ER S OW",JACQUIN="JH AE K W IH N",["HUGO(2)"]="Y UW G OW",FLAVORS="F L EY V ER Z",TETZLOFF="T EH T Z L AO F",CURZIO="K ER Z IY OW",CURRENTS="K ER AH N T S",HANTAVIRUS="HH AE N T AH V AY R AH S",FRANCAIS="F R AA N S EY",PLOTTERS="P L AA T ER Z",BOLOTIN="B AA L AH T IH N",DESIO="D IY S IY OW",LAREINA="L AA R EY IY N AH",JOSEPH="JH OW S AH F",["AMERITECH'S"]="AH M EH R IH T EH K S",COUPES="K UW P S",KEVLIN="K EH V L IH N",TEVLIN="T EH V L IH N",NEVARACH="N AH V AA R AH CH",MEVARACH="M EH V AA R AH CH",RESTRAINING="R IY S T R EY N IH NG",VILLAREAL="V IH L ER IY AA L",AMPHENOL="AE M F AH N AO L",EXTORTS="EH K S T AO R T S",REFORMATORY="R IH F AO R M AH T AO R IY",DEVLIN="D EH V L IH N",GRAZIER="G R EY Z IY ER",FRAZIER="F R EY ZH ER",FIMBRES="F IH M B ER Z",CRAZIER="K R EY Z IY ER",BRAZIER="B R EY Z IY ER",MAGNIFIERS="M AE G N AH F AY ER Z",["BUCHAREST(2)"]="B UW K ER EH S T",AEROBICALLY="EH R OW B IH K L IY",SCHROETER="SH R OW T ER",SPADA="S P AA D AH",SITUATIONS="S IH CH UW EY SH AH N Z",["BROKERAGES(2)"]="B R OW K R IH JH IH Z",VICTORY="V IH K T ER IY",GRUENEWALD="G R UH N IH W AO L D",CLOCKWORK="K L AA K W ER K",["DISCOURAGING(2)"]="D IH S K ER IH JH IH NG",ALOHA="AH L OW HH AA",CHICKASAW="CH IH K AH S AO",CRYSTAL="K R IH S T AH L",MALKOWSKI="M AH L K AO F S K IY",["BENJAMIN'S"]="B EH N JH AH M AH N Z",BRUZZESE="B R UW T S EY Z IY",WALKOWSKI="W AO K AO F S K IY",OWADA="OW AA D AH",CONOVER="K AA N AH V ER",FIORENZA="F IY AO R EH N Z AH",CUTAWAY="K AH T AH W EY",SEPARATENESS="S EH P ER AH T N AH S",LOPRESTI="L OW P R EH S T IY",SANDROCK="S AE N D R AA K",HAVOC="HH AE V AH K",FOREHEADS="F AO R HH EH D Z",UNSYMPATHETIC="AH N S IH M P AH TH EH T IH K",FALKOWSKI="F AH L K AO F S K IY",ELEVATOR="EH L AH V EY T ER",KEIPER="K IY P ER",LEIPER="L IY P ER",ATTAWAY="AE T AH W EY",BOTTARI="B OW T AA R IY",GOTSCHAL="G AA CH AH L",MARIO="M AA R IY OW",HOURGLASSES="AW ER G L AE S IH Z",["MULTINATIONALS(2)"]="M AH L T IY N AE SH AH N AH L Z",FIFTIETH="F IH F T IY IH TH",OTTAWAY="AA T AH W EY",["OKINAWA(2)"]="OW K IY N AA W AH",KRYSTAL="K R IH S T AH L",OVERWEIGHTED="OW V ER W EY T IH D",LITTLEJOHN="L IH T AH L JH AA N",FREEHOFF="F R IY HH AO F",KLENGE="K L EH N JH",CWIKLA="K W IH K L AH",GIENGER="G IY N JH ER",HYDROGENATE="HH AY D R AH JH AH N EY T",OVERBECK="OW V ER B EH K",SOLORIO="S OW L AO R IY OW",["WHIG(2)"]="HH W IH G",REPREHENSIBLE="R EH P R IH HH EH N S AH B AH L",STENGER="S T EH N JH ER",MEHITABELLE="M EH HH IH T AH B AH L",VANDYK="V AE N D IH K",MINNESOTA="M IH N IH S OW T AH",STORDAHL="S T AO R D AA L",FIGURES="F IH G Y ER Z",PLAINCLOTHES="P L EY N K L OW Z",INACTIVATED="IH N AE K T IH V EY T IH D",["ADAPTED(2)"]="AH D AE P T IH D",["SEARS'S"]="S IH R Z IH Z",DURANDO="D UH R AA N D OW",GRASSHOPPERS="G R AE S HH AA P ER Z",KREHER="K R EH R",STANSBURY="S T AE N S B EH R IY",FIRESTORM="F AY R S T AO R M",CIRCUMSTANCE="S ER K AH M S T AE N S",SWALLOWING="S W AA L OW IH NG",EMBROIDERIES="IH M B R OY D ER IY Z",ZUMEL="Z UW M EH L",TUTORING="T UW T ER IH NG",MORAVIAN="M ER EY V IY AH N",ALLAY="AH L EY",EUTHANIZE="Y UW TH AH N AY Z",PSYCHOLOGY="S AY K AA L AH JH IY",TRACHTENBERG="T R AE K T AH N B ER G",AVERBECK="EY V ER B EH K",MARGINALIZING="M AA R JH AH N AH L AY Z IH NG",RODAS="R OW D AH Z",SODAS="S OW D AH Z",ISLANDIA="AY L AE N D IY AH",LABOV="L AH B AH V",["GRANDPARENTS(2)"]="G R AE N P EH R AH N T S",["EXACTLY'S"]="IH G Z AE K T L IY Z",DREHER="D R EH R",["PI-MESON"]="P AY M EY Z AA N",TRIGGERS="T R IH G ER Z",INSTALLATIONS="IH N S T AH L EY SH AH N Z",OBERBECK="OW B ER B EH K",MIRANDO="M IH R AE N D OW",CONFRONTING="K AH N F R AH N T IH NG",CASCADE="K AE S K EY D",MIDAS="M AY D AH S",BAXT="B AE K S T",["CONGRESSMAN'S"]="K AA NG G R AH S M AH N Z",MENDYK="M EH N D IH K",DELAY="D IH L EY",MIRIAM="M IH R IY AH M",FIENDISH="F IY N D IH SH",AMRHEIN="AE M ER HH AY N",ROMEL="R OW M AH L",RELAY="R IY L EY",HILARITY="HH IH L EH R AH T IY",SCHNITZ="SH N IH T S",DRIGGERS="D R IH G ER Z",CYCLOPS="S AY K L AO P S",GLORIFIED="G L AO R AH F AY D",HARDESTY="HH AA R D AH S T IY",IMPEACHED="IH M P IY CH T",SPLICING="S P L AY S IH NG",SODEN="S OW D AH N",RODEN="R OW D AH N",IRREGULARLY="IH R EH G Y AH L ER L IY",["OVITZ'S"]="OW V IH T S IH Z",JANIKOWSKI="Y AH N IH K AO F S K IY",LAZZARA="L AA T S AA R AH",VALENTIA="V AA L EH N SH AH",["MITSUBISHI'S"]="M IH T S UW B IY SH IY Z",CONCISE="K AH N S AY S",DITTMANN="D IH T M AH N",CHUL="CH AH L",["COBAIN'S"]="K OW B EY N Z",["BIPARTISAN(2)"]="B AY P AA R T IH S AH N",NVRYAN="EH N V R AY AH N",THUL="TH AH L",REPRODUCTIVE="R IY P R AH D AH K T IH V",BIDEN="B AY D AH N",CLAMPETT="K L AE M P AH T",["DUKAKIS'"]="D UW K AA K IH S",DOSTOEVSKI="D AO S T OW V S K IY",LACOSTE="L AA K AO S T",CAUCASIANS="K AO K EY ZH AH N Z",["CELT(2)"]="K EH L T",["FRANCHISE'S"]="F R AE N CH AY Z IH Z",FIEGER="F IY G ER",GIEGER="G IY G ER",["JIANG'S"]="JH IY AA NG Z",ELLENBOGEN="EH L IH N B AH G AH N",LIBERALISM="L IH B ER AH L IH Z AH M",OESTERLING="OW S T ER L IH NG",WRESTLED="R EH S AH L D",RIEGER="R IY G ER",RACHAL="R AE K AH L",DRESBACH="D R EH S B AA K",REUL="R UW L",["PRESBYTERIANS(2)"]="P R EH Z B IH T IH R IY AH N Z",DISPROVED="D IH S P R UW V D",TURNIP="T ER N AH P",MIDPRICED="M IH D P R AY S T",BRODEUR="B R AA D ER",INTERPOLATE="IH T ER P AH L EY T",DIOXIN="D AY AA K S IH N",BODEN="B OW D AH N",EDWINA="EH D W IY N AH",HANNULA="HH AE N UW L AH",MODEN="M OW D AH N",BASHAM="B AE SH AH M",LODEN="L OW D AH N",PREVENTABLE="P R IH V EH N T AH B AH L",DISSIDENT="D IH S AH D IH N T",PRECEDENCE="P R EH S AH D AH N S",BOHLKE="B AA K",["DOUGANS(2)"]="D UW G AH N",PREVIOUS="P R IY V IY AH S",PRECONDITION="P R IY K AH N D IH SH AH N",BOOKMAKERS="B UH K M EY K ER Z",GOHLKE="G AA K",STEGNER="S T EH G N ER",BELOFF="B EH L AO F",DUMPING="D AH M P IH NG",ESTEFAN="EH S T IH F AA N",BUMPING="B AH M P IH NG",LUMPING="L AH M P IH NG",["TRADERS'"]="T R EY D ER Z",JUMPING="JH AH M P IH NG",GRUNEWALD="G R AH N IH W AO L D",PUMPING="P AH M P IH NG",WAELTERMANN="W AA L T ER M AH N",BARLAGE="B AA R L IH JH",["BAUMLER(3)"]="B AA M L ER",ST_PIERRE="S EY N T P Y EH R",ANTIFUNGAL="AE N T AY F AH NG G AH L",ZARROLI="Z ER OW L IY",CATHCART="K AE TH K AA R T",ARDEN="AA R D AH N",["DESECRATIONS(2)"]="D EH Z AH K R EY SH AH N Z",BEYOND="B IH AA N D",PURITANISM="P Y UH R AH T AH N IH Z AH M",CHROMATOGRAPHY="K R OW M AH T AA G R AH F IY",["PENTAGON'S"]="P EH N T IH G AA N Z",STROOCK="S T R UH K",GAVEL="G AE V AH L",HAVEL="HH AE V AH L",NAVEL="N EY V AH L",DECOSTE="D IH K OW S T IY",PAVEL="P AE V AH L",RAVEL="R AE V AH L",SAVEL="S AA V EH L",TAVEL="T AA V EH L",["TREBLINKA(2)"]="T R EH B L IH NG K AH",JARGON="JH AA R G AH N",FOUL="F AW L",ARTEAGA="AA R T IY G AH",GOOFY="G UW F IY",MOUL="M AW L",OGDEN="AA G D AH N",EMPLOYMENT="EH M P L OY M AH N T",SOUL="S OW L",POUL="P UW L",BYASSEE="B IY AA S IY",BONDING="B AA N D IH NG",ASTROLOGERS="AH S T R AA L AH JH ER Z",AMBUSHED="AE M B UH SH T",INTERCEDE="IH N T ER S IY D",["MARIENBONN'S"]="M EH R IY N B AO N Z",JUNKIER="JH AH NG K IY ER",ROWDIES="R AW D IY Z",CREATURES="K R IY CH ER Z",MOLYBDENUM="M AH L IH B D IH N AH M",MALERBA="M AA L EH R B AH",DRECHSEL="D R EH K S AH L",ETHICAL="EH TH IH K AH L",ZIRCONIUMS="Z ER K OW N IY AH M Z",PLANAS="P L AE N AH Z",PECOT="P EH K AH T",LLANAS="L AE N AH Z",["COPPOLA'S"]="K OW P OW L AH Z",GASTROVASCULAR="G AE S T R OW V AE S K Y AH L ER",ARGUABLY="AA R G Y UW AH B L IY",PEDEN="P EH D AH N",SERVER="S ER V ER",["SAFEWAY'S"]="S EY F W EY Z",DEPENDENTS="D IH P EH N D AH N T S",MALNOURISHED="M AE L N ER IH SH T",OPERATIONALLY="AA P ER EY SH AH N AH L IY",HEDGEPATH="HH EH JH P AE TH",MEASURE="M EH ZH ER",LEASURE="L EH ZH ER",["REPRESENTATIVE'S"]="R EH P R IH Z EH N T AH T IH V Z",STRIPLING="S T R IH P L IH NG",HANNESSON="HH AE N AH S AH N",SERGENT="S ER JH AH N T",ARAU="AH R AW",BRAU="B R AW",PERSONICS="P ER S AA N IH K S",ESTABROOKS="EH S T AH B R UH K S",HOMING="HH OW M IH NG",COMING="K AH M IH NG",COGHLAN="K AA G L AH N",BLANCHARDS="B L AE N CH ER D Z",ALDEN="AA L D AH N",OVERSIZE="OW V ER S AY Z",["ANTIFRAUD(2)"]="AE N T AY F R AA D",ELDEN="EH L D AH N",FRAU="F R AW",GRAU="G R AW",BERARDINO="B ER AA R D IY N OW",POLICING="P AH L IY S IH NG",ESAU="IY S AO",ERUPTS="IY R AH P T S",OLDEN="OW L D AH N",["MARCOS'S"]="M AA R K AH S IH Z",UNMENTIONED="AH N M EH N CH AH N D",MONTESSORI="M AA N T AH S AO R IY",SOTHEBY="S AA TH AH B IY",HIGHWAY="HH AY W EY",BIGWIG="B IH G W IH G",["BIOSPHERE'S"]="B AY OW S F IH R Z",LEMING="L IY M IH NG",COUSTEAU="K UW S T OW",CARVER="K AA R V ER",EASTERLING="IY S T ER L IH NG",MCCREA="M AH K R EY",GARVER="G AA R V ER",FARVER="F AA R V ER",MARVER="M AA R V ER",INTERMEC="IH N T ER M AH K",SARVER="S AA R V ER",OSCILLATED="AA S AH L EY T AH D",UNPRODUCTIVE="AH N P R AH D AH K T IH V",BUGAY="B Y UW G EY",MCDERMOT="M AH K D ER M AH T",LITTMANN="L IH T M AH N",HEMING="HH EH M IH NG",["BURKINA-FASO"]="B ER K IY N AH F AA S OW",BALTHROP="B AE L TH R AH P",FONDUE="F AA N D Y UW",EGLOFF="EH G L AO F",ARRIVED="ER AY V D",KRALICEK="K R AA L IH CH EH K",["OBSTRUCTIONISTS(2)"]="AH B S T R AH K SH AH N IH S T S",SPINACH="S P IH N AH CH",["ANTICIPATED(2)"]="AE N T IH S AH P EY T IH D",INFATUATING="IH N F AE CH UW EY T IH NG",ROEGNER="R OW G N ER",KITHCART="K IH TH K AA R T",IMAGINE="IH M AE JH AH N",ORASURE="AO R AH SH UH R",KOVALIK="K AH V AA L IH K",["LINGERING(2)"]="L IH NG G R IH NG",ALBANO="AA L B AA N OW",["ANTISMOKING(2)"]="AE N T AY S M OW K IH NG",FRASURE="F R AA ZH ER",EXECUTIONS="EH K S AH K Y UW SH AH N Z",THAXTON="TH AE K S T AH N",BYGONES="B AY G AO N Z",ARVEL="AA R V EH L",WHITEN="W AY T AH N",["DOWNTOWN'S"]="D AW N T AW N Z",HALPER="HH AE L P ER",ASSELIN="AE S IH L IH N",["PROJECTS'"]="P R AO JH EH K T S",FUNCTIONARY="F AH NG K SH AH N EH R IY",OAKBROOK="OW K B R UH K",CASAVANT="K AE S AH V AH N T",INFALLIBILITY="IH N F AE L IH B IH L IH T IY",TERMINATOR="T ER M AH N EY T ER",DEPLOYMENT="D IH P L OY M AH N T",PESOLA="P EH S OW L AH",REINIG="R AY N IH G",STRUTS="S T R AH T S",["CHAVIS'"]="CH AE V IH S",JUUL="JH UW AH L",["PROPERTY'S"]="P R AA P ER T IY Z",PIERCEALL="P IH R S IY L",ERWINA="ER V AY N AH",HEINIG="HH AY N IH G",PALMITER="P AE L M AY T ER",UNOBTRUSIVE="AH N AH B T R UW S IH V",MERCANTILE="M ER K AH N T AY L",["READERS'"]="R IY D ER Z",["LEADERS'"]="L IY D ER Z",MANHEIM="M AE N HH AY M",LINDSTRAND="L IH N D S T R AH N D",ROTTMANN="R AA T M AH N",BUCHTER="B AH K T ER",CONVECTIVE="K AH N V EH K T IH V",HAFEN="HH AE F AH N",FELDSPAR="F EH L D S P AA R",DEVALUATIONS="D IY V AE L Y UW EY SH AH N Z",ELIHU="EH L IH HH UW",FREEZERS="F R IY Z ER Z",COHABITING="K OW HH AE B IH T IH NG",CLENCHED="K L EH N CH T",ASSERTIVENESS="AH S ER T IH V N AH S",OFFSHORABLE="AO F SH AO R AH B AH L",["ANNUNZIO(2)"]="AH N UW N Z IY OW",WEIRDEST="W IH R D AH S T",BREUNIG="B R UW N IH G",YAEGER="Y IY JH ER",REGULATINGLY="R EH G Y AH L EY T IH NG L IY",REVALUATIONS="R IY IH V AE L Y UW EY SH AH N Z",JANOUSEK="Y AH N UW S EH K",ATTRIBUTION="AE T R IH B Y UW SH AH N",HYACINTHA="HH AY AH S IH N TH AH",RUPERTA="R UW P EH R T AH",TOPHAM="T AA F AH M",PROPOUNDED="P R AH P AW N D AH D",DENYSE="D EH N AY S",UNDERSTANDINGS="AH N D ER S T AE N D IH NG Z",["ST_LUCIA(2)"]="S EY N T L UW S IY AH",MATHERN="M AE DH ER N",["EINON'S"]="AY N AO N Z",HICCUPS="HH IH K AH P S",["INTERRUPTING(2)"]="IH N ER AH P T IH NG",STANMORE="S T AE N M AO R",AWBREY="AO B R IY",MCGUCKIN="M AH G AH K AH N",NUTRASWEET="N UW T R AH S W IY T",CROVITZ="K R OW V IH T S",["MODULATED(2)"]="M AO JH UW L EY T IH D",NEWSPRINT="N UW Z P R IH N T",FITSWATER="F IH T S W AO T ER",GOGHS="G OW Z",CENICEROS="S EY N IY S EH R OW Z",BENNIGAN="B EH N IH G AH N",CONFIRMATIONS="K AA N F ER M EY SH AH N Z",PHONETICS="F AH N EH T IH K S",MESSERLY="M EH S ER L IY",CAUCUS="K AO K AH S",BAUCUS="B AA K AH S",MEMORIES="M EH M ER IY Z",PESCI="P EH S K IY",NESCI="N EH S IY",INHABITING="IH N HH AE B AH T IH NG",JUNKYARD="JH AH NG K Y AA R D",["ONASSIS'(2)"]="OW N AA S IH S",BIONETICS="B AY OW N EH T IH K S",BRINEGAR="B R IH N IH G ER",RESETAR="R EH S IH T ER",DEFRANCISCO="D IH F R AA N CH IY S K OW",COGITATION="K AA JH IH T EY SH AH N",REASSERTION="R IY AH S ER SH AH N",BORNMAN="B AO R N M AH N",CORNMAN="K AO R N M AH N",TERMITE="T ER M AY T",SAEGER="S EH G ER",HAEGER="HH EH G ER",DEPENDENCE="D IH P EH N D AH N S",ERLICHMAN="ER L IH K M AH N",JAEGER="JH EH G ER",BEHEMOTHS="B IH HH IY M AH TH S",["RESUSCITATE(2)"]="R IY S AH S IH T EY T",POYNOR="P OY N ER",GUNCOTTON="G AH N K AA T AH N",LINDHOLM="L IH N D HH OW L M",["DOMINO(2)"]="D AA M IH N OW",IMPERSONAL="IH M P ER S AH N AH L",["EMERALDS(2)"]="EH M ER R AH L D Z",JAMESWAY="JH EY M Z W EY",MCSORLEY="M AH K S AO R L IY",CASOLA="K AA S OW L AH",OPTIMIZATION="AA P T AH M AH Z EY SH AH N",SHORTY="SH AO R T IY",FINNIGAN="F IH N IH G AH N",CRANMORE="K R AA N M AO R",ENHANCED="EH N HH AE N S T",["DIRECTORATE(4)"]="D IH R EH K T ER AH T",OVERLAPPED="OW V ER L AE P T",["WOMEN'S"]="W IH M AH N Z",MAYBE="M EY B IY",ZIEGER="Z IY G ER",["RESISTANCE(2)"]="R IY Z IH S T AH N S",BISAILLON="B AY S AH L AA N",FEDERATION="F EH D ER EY SH AH N",NOVEL="N AA V AH L",WRENCHED="R EH N CH T",CLAXTON="K L AE K S T AH N",HOVEL="HH AH V AH L",MAGALLON="M AE G AH L AA N",DOVEL="D OW V EH L",GUTTMANN="G AH T M AH N",["PENA'S(2)"]="P EY N Y AH Z",STARWALT="S T AA R W AH L T",NEWEST="N UW AH S T",SYMBOLICS="S IH M B AA L IH K S",FUMING="F Y UW M IH NG",BIANCHINI="B IY AA N CH IY N IY",NECKLACE="N EH K L AH S",PUMING="P UW M IH NG",LIZARRAGA="L IY Z AA R AA G AH",JACOT="JH AE K AH T",NAISMITH="N EY Z M IH TH",RUBANO="R UW B AA N OW",["CANON'S"]="K AE N AH N Z",DEPORTED="D IH P AO R T AH D",MARCADE="M AA R K EY D",DRENCHED="D R EH N CH T",["KUWAIT'S"]="K UW W EY T S",INDIVIDUALISM="IH N D IH V IH D UW AH L IH Z AH M",REPORTED="R IY P AO R T AH D",["MACINTOSH'S"]="M AE K AH N T AA SH IH Z",CASSERLY="K AE S ER L IY",BACOT="B AE K AH T",GOTTFRIED="G AO T F R IY D",PERIODICALS="P IH R IY AA D IH K AH L Z",ACHIEVER="AH CH IY V ER",LIPHAM="L IH F AH M",BRENDSEL="B R EH N D S AH L",CUSHITIC="K AH SH IH T IH K",BEAU="B OW",["WHALES(2)"]="HH W EY L Z",GAWEL="G AO AH L",BESHARA="B IH SH AA R AH",CARTMILL="K AA R T M IH L",WHOLLY="HH OW L IY",LAVINA="L AA V IY N AH",SHOLLY="SH AA L IY",CONVECTION="K AH N V EH K SH AH N",["EMBEZZLER(2)"]="EH M B EH Z L ER",PFAU="F AW",BOARDER="B AO R D ER",AGILDO="AH G IH L D OW",DISPLAYWRITE="D IH S P L EY R AY T",OHIOANS="OW HH AY OW AH N Z",SNIPER="S N AY P ER",HOLBROOK="HH OW L B R UH K",ALBACH="AE L B AA K",IGNORES="IH G N AO R Z",["KAZAKHSTAN'S(2)"]="K AH Z AE K S T AE N Z",GOSPLAN="G AO S P L AE N",BUSHAW="B UH SH AO",SHERBORNE="SH ER B ER N",STREETWISE="S T R IY T W AY Z",INFERRING="IH N F ER IH NG",["CLAIBORNE'S(2)"]="K L EY B ER N Z",FROELICH="F R OW L IH K",STALLED="S T AO L D",CORBIT="K AO R B IH T",MANDIGO="M AA N D IY G OW",MAZURKAS="M AH Z ER K AH Z",TERLECKI="T ER L EH T S K IY",DISCOMBOBULATE="D IH S K AH M B AO B Y UW L EY T",MOLLIFIED="M AA L AH F AY D",BOUGHS="B AW Z",ARDUOUS="AA R JH UW AH S",SCHNELLE="SH N EH L",["WHIT(2)"]="HH W IH T",BERNSON="B ER N S AH N",HOUGHS="HH AW Z",PALEST="P EY L AH S T",NIGHTSTANDS="N AY T S T AE N D Z",CUSTOMERS="K AH S T AH M ER Z",ACKNOWLEDGE="AE K N AA L IH JH",BALLPARKS="B AO L P AA R K S",TOUGHS="T AH F S",["EUROCOM(2)"]="Y UW R OW K AA M",HARRELSON="HH EH R IH L S AH N",MOYNA="M OY N AH",VICTORIAN="V IH K T AO R IY AH N",KUIPER="K UW P ER",JEWEL="JH UW AH L",GOODING="G UH D IH NG",STEPHANI="S T EH F AH N IY",AGUDELO="AA G UW D EY L OW",LEVINA="L EH V IY N AH",["ALARMISTS(2)"]="AH L AA R M IH S",["ERASABLE(2)"]="IY R EY S AH B AH L",STARNER="S T AA R N ER",PULITZER="P UH L AH T S ER",PROTEST="P R OW T EH S T",THERESE="TH EH R IY S",VOLKSWAGENS="V OW L K S W AE G AH N Z",["ENCOR'S"]="EH N K AO R Z",MASCI="M AE S IY",SERAPHINE="S ER AA F IY N IY",["BEIT(2)"]="B AY T",TURNBOUGH="T ER N B AW",PEMBLETON="P EH M B AH L T AA N",KARCZ="K AA R CH",WOLFSBURG="W UH L F S B ER G",POLYP="P AA L IH P",BABE="B EY B",CABE="K EY B",GILLIARD="G IH L IY ER D",HILLIARD="HH IH L Y AA R D",TOKOS="T OW K OW S",AIRBASE="EH R B EY S",BILLIARD="B IH L Y ER D",BADOLATO="B AA D OW L AA T OW",BROLLY="B R AA L IY",WILLIARD="W IH L Y AA R D",MABE="M EY B",FRANCHINI="F R AA N K IY N IY",ROKOS="R OW K OW Z",LABE="L EY B",["SARI'S"]="S AA R IY Z",["FRANC'S"]="F R AE NG K S",PROMENADES="P R AA M AH N EY D Z",GABE="G EY B",CIRCUMVENTING="S ER K AH M V EH N T IH NG",["KAPOSI'S"]="K AH P OW S IY Z",MODERATION="M AA D ER EY SH AH N",INTRO="IH N T R OW",TIRPAK="T ER P AH K",HURVITZ="HH ER V IH T S",SUMROW="S AH M R OW",PERISHED="P EH R IH SH T",SCHRICK="SH R IH K",NGUEPPE="EH NG G EH P IY",["OVERWHELMING(2)"]="OW V ER HH W EH L M IH NG",MCCLAFLIN="M AH K L AE F L AH N",MIKOS="M AY K OW Z",HIGHLIGHTS="HH AY L AY T S",FINANCEMENT="F IH N AE N S M AH N T",MILDRID="M IH L D ER IH D",FAWVER="F AO V ER",HYANNISPORT="HH AY AE N IH S P AO R T",HOMESTEADER="HH OW M S T EH D ER",ABBE="AE B IY",["BAIDOAN'S"]="B AY D OW AH N Z",READJUSTED="R IY AH JH AH S T IH D",ENGULFED="IH N G AH L F T",LAURO="L AO R OW",MAURO="M AO R OW",QUARTERS="K W AO R T ER Z",SAURO="S AO R OW",BEDRAGGLED="B IH D R AE G AH L D",HAMBLETON="HH AE M B AH L T AA N",COOLLY="K UW L IY",JAQUAY="ZH AH K EY",ESCOE="IH S K OW",APPALLING="AH P AO L IH NG",ANGIO="AE N JH IY OW",["D'IVOIRE"]="D IY V W AA R",["EVERYTHING'S"]="EH V R IY TH IH NG Z",REFERRING="R IH F ER IH NG",GIANNETTI="JH AH N EH T IY",PALESTINIANS="P AE L IH S T IH N IY AH N Z",ERODING="IH R OW D IH NG",KILDUFF="K IH L D AH F",ROTHSCHILDS="R AO TH CH AY L D Z",["FLEMING'S"]="F L EH M IH NG Z",SWARNER="S W AO R N ER",OCCUPIES="AA K Y AH P AY Z",KIDSTOCK="K IH D S T AA K",["EDUCATORS(2)"]="EH JH Y UW K EY T ER Z",["SHEEHAN'S(2)"]="SH IY HH AH N Z",DREADFUL="D R EH D F AH L",DEFERRING="D IH F ER IH NG",TRANSGRESSED="T R AE N Z G R EH S T",FOLLIARD="F AA L Y ER D",OBERHOLTZER="OW B ER HH OW L T Z ER",HALVED="HH AE V D",STRACENER="S T R AE S IY N ER",ZAPATISTA="Z AA P AH T IY S T AH",VILLAINOUS="V IH L AH N AH S",CIESLAK="CH EH S L AH K",["EARPLUGS(2)"]="IY R P L AH G Z",INHALER="IH N HH EY L ER",REITEN="R AY T AH N",["CONSECO'S"]="K AA N S EY K OW Z",URANIUM="Y ER EY N IY AH M",UNSUBTLE="AH N S AH T AH L",BANDUCCI="B AA N D UW CH IY",NEURO="N UH R OW",NICEN="N AY S AH N",["FINANCES(2)"]="F AY N AE N S IH Z",DIALOGUE="D AY AH L AO G",CRANIUM="K R EY N IY AH M",WINGLIKE="W IH NG L AY K",MOTHERCARE="M AH DH ER K EH R",SUCKROW="S AH K R OW",RATIONING="R AE SH AH N IH NG",BIERBAUM="B IH R B AW M",PRESIDENTIALIST="P R EH Z AH D EH N CH AH L IH S T",HEINBACH="HH AY N B AA K",AMPHITHEATERS="AE M F AH TH IY EY T ER Z",LEINBACH="L AY N B AA K",CALIPER="K AE L AH P ER",FORTUNE="F AO R CH AH N",["MORALES(2)"]="M AO R AE L EH S",["EASTLAND'S(3)"]="IY S L AH N D Z",AVOIDANCE="AH V OY D AH N S",SHRIKELIKE="SH R AY K L AY K",HAWVER="HH AO V ER",LAWVER="L AA V ER",WINTERIZE="W IH N T ER AY Z",STIPULATION="S T IH P Y AH L EY SH AH N",HAZELTINE="HH EY Z AH L T AY N",DOOMSAYING="D UW M S EY IH NG",["BRYAN'S"]="B R AY AH N Z",AUTONOMOUS="AO T AA N AH M AH S",DERIVED="D ER AY V D",ARNULFO="AA R N AH L F OW",OPCOM="AA P K AA M",MCDIARMID="M AH K D EH R M AH D",CALORIES="K AE L ER IY Z",HOMOLKA="HH AH M AA L K AH",MCQUAY="M AH K W EY",["KAMAKAU'S"]="K AA M AH K AA UW Z",["NIDAL'S"]="N IH D AA L Z",MYSTIFY="M IH S T AH F AY",BROCKMAN="B R AA K M AH N",UNEXPECTED="AH N IH K S P EH K T IH D",["STUART(2)"]="S T Y UW ER T",MICROGRAM="M AY K R OW G R AE M",DECEIVED="D IH S IY V D",["DRILLING'S"]="D R IH L IH NG Z",NULLIFIED="N AH L AH F AY D",MARPLAN="M AA R P L AE N",CUSHIONS="K UH SH AH N Z",STEREOS="S T EH R IY OW Z",EATHERTON="EH TH ER T AH N",INJURED="IH N JH ER D",BOVINA="B OW V IY N AH",COVINA="K OW V IY N AH",["PASOK(2)"]="P AE S AO K",HURDLE="HH ER D AH L",SCHUENEMAN="SH UW N AH M AH N",PROFANATION="P R AO F AH N EY SH AH N",LITERATI="L IH T ER AA T IY",URBACH="ER B AA K",BALTIMORE="B AO L T AH M AO R",FUNDING="F AH N D IH NG",ZEROES="Z IH R OW Z",VENTOLA="V EH N T OW L AH",CRIHFIELD="K R IH F IY L D",ABLEST="EY B AH L S T",NIPSCO="N IH P S K OW",THRIVED="TH R AY V D",ORBACH="AO R B AA K",VICKSBURG="V IH K S B ER G",FOGELSON="F OW G AH L S AH N",ESPANA="EH S P AE N Y AH",ANTUNA="AA N T UW N AH",OSUNA="OW S UW N AH",["TELMEX'S"]="T EH L M EH K S IH Z",MCWHORTER="M AH K W AO R T ER",MOHTASHEMI="M OW T AH SH EY M IY",CERANKOSKY="S EH R AH NG K AO S K IY",EXCESS="EH K S EH S",NICOLAY="N IH K AH L EY",["SUBSTANTIAL(2)"]="S AH B S T AE N SH AH L",ENGELSON="EH NG G IH L S AH N",INCOM="IH NG K AA M",TRAUMATIZED="T R AO M AH T AY Z D",["DOLOMITE'S"]="D OW L AH M AY T S",RUNOFF="R AH N AO F",BECOMING="B IH K AH M IH NG",["WHELAN(4)"]="W IY L AH N",VANDERVELDE="V AE N D ER V EH L D",FILYAW="F IH L IY AA V",SCHAIBLE="S K EY B AH L",UNIONDALE="Y UW N Y AH N D EY L",TOWNHOUSE="T AW N HH AW S",COCOM="K OW K AA M",ORDINANCE="AO R D AH N AH N S",OCANAS="OW K AE N AH Z",["LINDEN'S"]="L IH N D AH N Z",AGENCIES="EY JH AH N S IY Z",BLANKENSHIP="B L AE NG K AH N SH IH P",NETHERTON="N EH DH ER T AH N",MOUNTAINTOPS="M AW N T AH N T AA P S",CESSATION="S EH S EY SH AH N",RETRENCHED="R IY T R EH N CH T",DISHAW="D IH SH AO",TOWEL="T AW AH L",OZUNA="OW Z UW N AH",VOWEL="V AW AH L",RECERTIFYING="R IY S ER T AH F AY IH NG",EARTHSHINE="ER TH SH AY N",RECEIVED="R AH S IY V D",DOWEL="D AW AH L",HARTMARX="HH AA R T M AA R K S",["CENTENNIAL'S"]="S EH N T EH N IY AH L Z",GAYSHILL="G EY Z HH IH L",PROPERTY="P R AA P ER T IY",GILBERTI="JH IY L B EH R T IY",STAYOVER="S T EY OW V ER",KRUL="K R AH L",CHRISTIANITY="K R IH S CH IY AE N IH T IY",DIVORCING="D IH V AO R S IH NG",HARDWORKING="HH AA R D W ER K IH NG",QUILICI="K W IY L IY CH IY",["QUANTIFYING(2)"]="K W AA N IH F AY IH NG",HOSHAW="HH AA SH AO",NEATEST="N IY T AH S T",GUYOT="G AY AH T",RABINOVICH="R AH B IH N AH V IH CH",["ADENAUER(2)"]="AE D AH N AW R",BOUTILIER="B AW T AH L IY ER",ACCARDO="AA K AA R D OW",MICOM="M AY K AA M",SASSOUNGUESSO="S AE S UW NG G EH S OW",MINICARS="M IH N IY K AA R Z",SAHLEN="S AA L AH N",MUCKENFUSS="M AH K AH N F AH S",WAHLEN="W AA L AH N",BONAWITZ="B AA N AH W IH T S",PREJUDICING="P R EH JH AH D IH S IH NG",MELNOR="M EH L N ER",FARBEN="F AA R B AH N",DIMUZIO="D IH M UW Z IY OW",AUGUST="AA G AH S T",PELLICANO="P EH L IY K AA N OW",DAHLEN="D AA L AH N",COMPUTERCRAFT="K AH M P Y UW T ER K R AE F T",CONDENSATION="K AA N D AH N S EY SH AH N",CHARLTON="CH AA R L T AH N",HISHAM="HH IH SH AH M",["ALZADO(2)"]="AA L Z AA D OW",STOLTZMAN="S T OW L T S M AH N",UPSHAW="AH P SH AO",LEARNER="L ER N ER",ELVINA="EH L V IY N AH",ALVINA="AE L V AY N AH",WISHAM="W IH SH AH M",LOCALLY="L OW K AH L IY",PERINEURAL="P ER IY N UH R AH L",MALVINAS="M AO L V IY N AH S",BEVEL="B EH V AH L",BEHNKEN="B EH NG K AH N",LEVEL="L EH V AH L",HUNDREDS="HH AH N D R AH D Z",NEVEL="N EY V EH L",POTATOE="P AH T EY T OW",DEBNAM="D EH B N AH M",["GENTLEMAN(2)"]="JH EH N AH L M AH N",HARLEYSVILLE="HH AA R L IY Z V IH L",REVEL="R EH V AH L",NORGREN="N AO R G R AH N",["NIRVANA'S"]="N IH R V AA N AH Z",BARBAGALLO="B AA R B AH G AE L OW",AUSTRIAN="AO S T R IY AH N",DUTRO="D AH T R OW",SHAPELY="SH EY P L IY",SYNAGOGUES="S IH N AH G AO G Z",MOLEST="M AH L EH S T",SECOM="S EH K AA M",RUSSIA="R AH SH AH",["MINOT(2)"]="M IH N AA T",OBRYAN="OW B R AY AH N",TATYANA="T AA T Y AA N AH",REVIVES="R IY V AY V Z",["NON-NONSENSE"]="N AA N N AA N S EH N S",HORNAK="HH AO R N AH K",CHEAPENING="CH IY P AH N IH NG",DORNAK="D AO R N AH K",["WHEELDON(2)"]="HH W IY L D AH N",FAHNESTOCK="F AA N S T AA K",PAWNSHOP="P AO N SH AA P",BENEFICIARY="B EH N AH F IH SH IY EH R IY",["MENACES(2)"]="M EH N IH S IH Z",INTENSE="IH N T EH N S",HEROES="HH IH R OW Z",["GENEGO(2)"]="JH EH N AH G OW",ANNUNCIATA="AA N UW N CH AA T AH",["STAC'S"]="S T AE K S",ANTICRIME="AE N T IY K R AY M",HOCHHALTER="HH AA K HH AH L T ER",["COLLECTOR(2)"]="K L EH K T ER",NDAU="EH N D AW",THROES="TH R OW Z",UMBACH="AH M B AA K",GREENFELL="G R IY N F EH L",DECOM="D EH K AA M",GAARDER="G AA R D ER",ARCANUM="AA R K AH N AH M",["HUNDRED'S"]="HH AH N D R IH D Z",CHILLINGLY="CH IH L IH NG L IY",SUTRO="S UW T R OW",CHARTERS="CH AA R T ER Z",WEATHERHOLTZ="W EH DH ER HH OW L T S",HUITT="HH UW T",BRUNKHORST="B R AH NG K HH AO R S T",AMPUTATIONS="AE M P Y UW T EY SH AH N Z",PRITT="P R IH T",ORBEN="AO R B AH N",SMELTZ="S M EH L T S",TRITT="T R IH T",EXERTS="IH G Z ER T S",PUDDINGS="P UH D IH NG Z",MCELHANNON="M AE K AH L HH AE N AH N",AFTERGLOWS="AE F T ER G L OW Z",KLINGBERG="K L IH NG B ER G",CITRO="S IH T R OW",LAPLANT="L AH P L AO N T",VITRO="V IH T R OW",AMBLED="AE M B AH L D",MILLIMETERS="M IH L AH M IY T ER Z",TIDBITS="T IH D B IH T S",["HULON'S"]="HH Y UW L AH N Z",NITRO="N IH T R OW",MITRO="M IH T R OW",NARDONE="N AA R D OW N IY",TRANSFUSED="T R AE N S F Y UW Z D",CARDONE="K AA R D OW N IY",SUBTEXT="S AH B T EH K S T",PHONOLOGICAL="F OW N AH L AA JH IH K AH L",BARDSLEY="B AA R D S L IY",["IRAQI'S(3)"]="AY R AE K IY Z",ANGELLO="AE N JH EH L OW",HEISTAND="HH AY S T AH N D",CRUZADOS="K R UW Z AA D OW S",ARCHITECTURE="AA R K AH T EH K CH ER",GYRATION="JH AY R EY SH AH N",BRITT="B R IH T",MEFFORD="M EH F ER D",BIFOCALS="B AY F OW K AH L Z",BROTZMAN="B R AA T S M AH N",DRUGMAKER="D R AH G M EY K ER",HELMSMAN="HH EH L M Z M AE N",ASPIRATED="AE S P ER EY T IH D",GHASTLINESS="G AE S T L IY N AH S",["BENETTON'S(2)"]="B EH N AH T AO N Z",FIREBUSH="F AY ER B UH SH",["COYOTE(2)"]="K AY OW T",ROCHBERG="R OW CH B ER G",SAAM="S AA M",RACKMIL="R AE K M IH L",MARCI="M AA R S IY",ITCHY="IH CH IY",FRANCOIS="F R AA N S W AA",["CANNOT(2)"]="K AH N AA T",["THIRTIETH(2)"]="TH ER T IY IH TH",GODSPELL="G AA D S P EH L",OVITT="OW V IH T",ALERTS="AH L ER T S",PREHEIM="P R EH HH AY M",SHRIBER="SH R AY B ER",FREEDOMS="F R IY D AH M Z",HEARNE="HH ER N",CREDEUR="K R IH D ER",ADJUNCT="AE JH AH NG K T",EXPOUNDING="IH K S P AW N D IH NG",SWICKARD="S W IH K ER D",MAZEIKA="M AH Z AY K AH",["TRAVOLTA'S"]="T R AH V OW L T AH Z",AUBREY="AO B R IY",REPOS="R IY P OW Z",EICHBERG="AY K B ER G",CAUSATIVE="K AA Z AH T IH V",VOLLEYBALL="V AA L IY B AO L",SPECIMENS="S P EH S AH M AH N Z",NATUNA="N AH T UW N AH",AETNA="EH T N AH",AGENCY="EY JH AH N S IY",HARTMANN="HH AA R T M AH N",LACE="L EY S",FACE="F EY S",STICHTER="S T IH K T ER",DACE="D EY S",CUTRONE="K UW T R OW N IY",INSECURITY="IH N S IH K Y UH R IH T IY",BODYGUARD="B AA D IY G AA R D",["TSAO(2)"]="S AW",RACE="R EY S",OVERWHELMS="OW V ER W EH L M Z",IMPORTED="IH M P AO R T IH D",NACE="N EY S",ORNATELY="AO R N EY T L IY",PACE="P EY S",AIRPORTERS="EH R P AO R T ER Z",ARMANDO="AA R M AA N D OW",FUQUAY="F UW K EY",PAFFORD="P AE F ER D",OVERBILLING="OW V ER B IH L IH NG",GENERALE="JH EH N ER AE L",WAFFORD="W AA F ER D",EVITT="EH V IH T",ACCESS="AE K S EH S",ASKING="AE S K IH NG",SHEENS="SH IY N Z",MAAM="M AH M",HOCHBERG="HH AA K B ER G",GAFFORD="G AE F ER D",HAFFORD="HH AE F ER D",DIMERCURIO="D IH M ER K UH R IY OW",THICKNESS="TH IH K N AH S",THERAT="DH EH R AE T",NATURALIZATION="N AE CH ER AH L AH Z EY SH AH N",["INTERACTIONS(2)"]="IH N ER AE K SH AH N Z",REINARD="R AY N ER D",MONSANTO="M AA N S AE N T OW",AVENGE="AH V EH N JH",MACAULAY="M AH K AO L IY",SCHIFFNER="SH IH F N ER",RARITIES="R EH R IH T IY Z",["FERRETED(2)"]="F EH R AH T IH D",PARITIES="P EH R AH T IY Z",["LABOR'S"]="L EY B ER Z",GAUNA="G AO N AH",FAUNA="F AO N AH",DELVED="D EH L V D",KOONIG="K UW N IH G",PROFICIENT="P R AA F IH SH AH N T",TATRO="T AE T R OW",LIKING="L AY K IH NG",HIKING="HH AY K IH NG",MCINTIRE="M AE K IH N T AY R",BIKING="B AY K IH NG",STOCKMAN="S T AA K M AH N",PRZYBYLA="P ER Z AH B IH L AH",RECESS="R IH S EH S",IMPOUNDING="IH M P AW N D IH NG",POLLAK="P AA L AH K",EBERTS="EH B ER T S",TURNPIKE="T ER N P AY K",GUDGER="G AH JH ER",HECKAMAN="HH EH K AH M AH N",INITIO="IH N IH T IY OW",CHAIDEZ="CH AA IY D EH Z",INNATELY="IH N EY T L IY",ABSTINENT="AE B S T AH N AH N T",JEFFERSONIANS="JH EH F ER S OW N IY AH N Z",BONESTEEL="B OW N S T IY L",REFLEX="R IY F L EH K S",REASSIGNED="R IY AH S AY N D",LATERRIERE="L AA T EH R Y EH R",SAMUELA="S AE M Y UW EH L AH",EIBEN="AY B AH N",TECHY="T EH CH IY",AGRICOLA="AE G R IH K OW L AH",VASCONCELLOS="V AE S K AH N S EH L OW Z",BEBE="B IY B IY",NICOLO="N IH K AH L OW",RESIDENTIAL="R EH Z IH D EH N CH AH L",ELECTIONS="IH L EH K SH AH N Z",COKING="K OW K IH NG",SKIED="S K IY D",PECHINEY="P EH CH IH N IY",OVERGENEROUS="OW V ER JH EH N ER AH S",BIOLOGY="B AY AA L AH JH IY",["ROESSLER(2)"]="R OW S L ER",ALBUMS="AE L B AH M Z",MARTORANA="M AA R T AO R AE N AH",COTRONE="K OW T R OW N IY",DITTEMORE="D IH T EH M AO R",VERITIES="V EH R AH T IY Z",MAGNIFYING="M AE G N AH F AY IH NG",DETERIORATING="D IH T IH R IY ER EY T IH NG",KLUVER="K L UW V ER",METRO="M EH T R OW",VLACHOS="V L EY K OW S",EMBREY="EH M B R IY",ALLERGIST="AE L ER JH AH S T",HOBEN="HH AA B AH N",GOBEN="G AA B AH N",DETRO="D IY T R OW",SNEDAKER="S N EH D AH K ER",SEVENTEENS="S EH V AH N T IY N Z",HORNBACK="HH AO R N B AE K",PETRO="P EH T R OW",RETRO="R EH T R OW",TETRO="T EH T R OW",CHEANE="CH IY N",MASHAW="M AE SH AO",ALBEN="AO L B AH N",SENSED="S EH N S T",PRONOUN="P R OW N AW N",AUGELLO="AO JH EH L OW",BASHAW="B AH SH AO",ADJUST="AH JH AH S T",SAUNA="S AO N AH",GUINTHER="G IH N DH ER",FLIED="F L AY D",EVERTS="EH V ER T S",GLENFED="G L EH N F EH D",MAUNA="M AO N AH",AVERTS="AH V ER T S",LEMUELA="L EH M UW L AH",ALOYSE="AH L OY S",SIFFORD="S IH F ER D",PLIED="P L AY D",SCHUCHART="SH AH K HH AA R T",MOTOLA="M OW T OW L AH",FERMENTING="F ER M EH N T IH NG",MAHNKEN="M AA NG K AH N",VIBE="V AY B",PRINCIPE="P R IY N CH IY P IY",CONSTRUED="K AH N S T R UW D",GIFFORD="G IH F ER D",CLINARD="K L IH N ER D",JIBE="JH AY B",MICROPROCESSORS="M AY K R OW P R AA S EH S ER Z",CHEATER="CH IY T ER",LAIBROOK="L EY B R UH K",GETAWAYS="G EH T AH W EY Z",CHERTS="CH ER T S",TAPPET="T AE P AH T",CASELLI="K AH S EH L IY",MASELLI="M AH S EH L IY",BIRDLIKE="B ER D L AY K",CLAPPER="K L AE P ER",KEITT="K IY T",["INNOVATORS(2)"]="IH N OW V EY T ER Z",["PURCHASERS'"]="P ER CH AH S ER Z",PROVINE="P R OW V IY N IY",ERECTIONS="IH R EH K SH AH N Z",CANOEING="K AH N UW IH NG",["PERNOD'S"]="P ER N AA D Z",GEERTS="G IH R T S",["CHOLESTEROL(2)"]="K AH L EH S T ER AH L",["LLOYD'S"]="L OY D Z",GEDDINGS="JH EH D IH NG Z",DELROSSO="D EH L R OW S OW",COMISKEY="K OW M IH S K IY",KUNDERT="K AH N D ER T",CARRENO="K AA R EH N OW",WEDDINGS="W EH D IH NG Z",["WHEELERS(2)"]="HH W IY L ER Z",ROEPER="R OW P ER",FAUNAL="F AA N AH L",EBLING="EH B AH L IH NG",DUFFORD="D AH F ER D",LOEPER="L OW P ER",HOEPER="HH OW P ER",MALUEG="M AE L UH G",ELBE="EH L B",SALING="S EY L IH NG",HUFFORD="HH AH F ER D",LATRONE="L AH T R OW N",RUFFORD="R AH F ER D",PATRONE="P AA T R OW N IY",SHIED="SH AY D",EALING="IY L IH NG",["ANSCHLUSS(2)"]="AA N SH L UW S",ENABLING="EH N EY B AH L IH NG",HAFNIUM="HH AE F N IY AH M",["ACCOR'S"]="AE K ER Z",INNOVATIONS="IH N AH V EY SH AH N Z",ALTAMONT="AA L T AH M AO N T",MOSELY="M OW Z L IY",UNEARTHED="AH N ER TH T",IDLING="AY D AH L IH NG",CHICOINE="CH IH K OY N",MAINARD="M EY N ER D",HORNBLENDE="HH AO R N B L EH N D",HELPING="HH EH L P IH NG",GEAREY="G IH R IY",COAUTHORING="K OW AA TH ER IH NG",EMBEZZLERS="IH M B EH Z AH L ER Z",INLAY="IH N L EY",STUVER="S T UW V ER",ODDEN="AA D AH N",CURSORY="K ER S ER IY",MESELSOHN="M EH Z AH L S AH N",CONFIDENTIAL="K AA N F AH D EH N SH AH L",TOBE="T OW B",SNAPPER="S N AE P ER",GIDDINGS="G IH D IH NG Z",MOBE="M OW B",LOBE="L OW B",KOBE="K OW B EY",JOBE="JH OW B",BLUEBELLS="B L UW B EH L Z",NANCARROW="N AE NG K AE R OW",["CLIMBERS'"]="K L AY M ER Z",BOBE="B OW B",GOLAY="G AA L EY",ENGELBERTA="EH NG G EH L B EH R T AH",HELOTISM="HH EH L AH T IH Z AH M",YELPING="Y EH L P IH NG",["BUCHANAN'S"]="B Y UW K AE N AH N Z",["FERNANDA(2)"]="F ER N AA N D AH",GRAICHEN="G R AY K AH N",ARROGANT="EH R AH G AH N T",NIEDBALA="N IY D B AA L AH",ENCAMPMENT="IH N K AE M P M IH N T",VIABILITY="V AY AH B IH L AH T IY",SCHWARTZBERG="SH W AO R T S B ER G",BURPEES="B ER P IY Z",NONSENSE="N AA N S EH N S",VADEN="V EY D AH N",MOTIONING="M OW SH AH N IH NG",LAGGARDS="L AE G ER D Z",PETRONE="P EH T R OW N IY",LIABILITY="L AY AH B IH L IH T IY",FLAPPER="F L AE P ER",CHAPELL="SH AH P EH L",KLAPPER="K L AE P ER",IMLAY="IH M L EY",NICKOL="N IH K AH L",FADEN="F EY D AH N",HADEN="HH EY D AH N",["CHIAPAS'"]="CH IY AA P AH Z",KADEN="K EY D AH N",LADEN="L EY D AH N",MADEN="M EY D AH N",PADEN="P EY D AH N",RADEN="R EY D AH N",ONCOMING="AO N K AH M IH NG",CRUICKSHANK="K R UH K SH AE NG K",TEGETHOFF="T EH G IH T AO F",PERONIST="P EH R AH N IH S T",ERBE="ER B",["SHEPPARD'S"]="SH EH P ER D Z",GIMMICKRY="G IH M IH K R IY",INCOMING="IH N K AH M IH NG",HAGGERTY="HH AE G ER T IY",BRUNA="B R UW N AH",CLAUSTROPHOBIC="K L AO S T R AH F OW B IH K",["AKAO(2)"]="AH K AA W",TOOTHPASTES="T UW TH P EY S T S",CAREGIVER="K EH R G IH V ER",SHRUGGED="SH R AH G D",TRAPPER="T R AE P ER",WRAPPER="R AE P ER",ALDERFER="AE L D ER F ER",HALFWIT="HH AE F W IH T",GLIDDEN="G L IH D AH N",CIOTTI="CH OW T IY",HYDROTHERMAL="HH AY D R OW TH ER M AH L",PATRICELLI="P AA T R IY CH EH L IY",DORMANCY="D AO R M AH N S IY",ROELOFS="R OW L AH F S",OPTIONING="AA P SH AH N IH NG",["JONASSAINT'S"]="JH OW N AH S EY N T S",SENSITIVELY="S EH N S IH T IH V L IY",KOFU="K OW F UW",MCMANAMA="M AH K M AE N AH M AH",AMBASSADORS="AE M B AE S AH D ER Z",WYKOFF="W IH K AO F",REDACTED="R IH D AE K T IH D",BALANCED="B AE L AH N S T",FORMERLY="F AO R M ER L IY",RYKOFF="R AY K AO F",GRUVER="G R UW V ER",DUCHY="D AH CH IY",["ANTIBIOTIC(2)"]="AE N T AY B AY AA T IH K",LYCOMING="L AY K AH M IH NG",NURTURERS="N ER CH ER ER Z",SUCHY="S AH CH IY",ROSENCRANS="R OW Z AH N K R AE N Z",AIRSTRIKE="EH R S T R AY K",BEACONS="B IY K AH N Z",LAFOUNTAINE="L AA F AA N T EY N",DEACONS="D IY K AH N Z",CORRELATES="K AO R AH L AH T S",SANDSTORM="S AE N D S T AO R M",SHOVLIN="SH AA V L IH N",INCULCATE="IH NG K AH L K EY T",SHIMMY="SH IH M IY",PARROTT="P EH R AH T",KUWAITI="K UW W EY T IY",GARROTT="G AE R AH T",APFELBAUM="AE P F AH L B AW M",PERCENTAGES="P ER S EH N T IH JH IH Z",ACKERMANN="AE K ER M AH N",WHIDDEN="W IH D AH N",EMERICK="EH M ER IH K",REPLANT="R IY P L AE N T",STAKEHOLDERS="S T EY K HH OW L D ER Z",BOOTLEG="B UW T L EH G",DUKING="D UW K IH NG",AEROVIAS="EH R OW V IY AH Z",ECOLOGY="IH K AA L AH JH IY",EQUIPPED="IH K W IH P T",["AUNT(2)"]="AO N T",ROSELLI="R OW S EH L IY",BROCKETT="B R AA K IH T",CROCKETT="K R AA K IH T",MCKECHNIE="M AH K EH K N IY",WEERTS="W IH R T S",ACHESONS="AE CH AH S AH N Z",ROXANNA="R AA K S AE N AH",TOOTHPASTE="T UW TH P EY S T",STELTZ="S T EH L T S",UNIFORMLY="Y UW N AH F AO R M L IY",COUPLAND="K UW P L AH N D",CALLARI="K AA L AA R IY",DULAY="D Y UW L EY",ENITT="EH N IH T",COWGER="K AW JH ER",GEOLOGY="JH IY AA L AH JH IY",MELITTA="M EH L IY T AH",STOCKETT="S T AA K IH T",VALDOVINOS="V AA L D OW V IY N OW Z",STEPHANS="S T EH F AH N Z",PRIEN="P R IY N",QUAM="K W AA M",CONTRADICTORY="K AA N T R AH D IH K T ER IY",RUAM="R UW AH M",DETOUR="D IH T UH R",GUAM="G W AA M",ENDPOINTS="EH N D P OY N T S",DELACERDA="D EH L AA CH EH R D AH",GIRDING="G ER D IH NG",BRAM="B R AE M",DRAM="D R AE M",SANCTIONING="S AE NG K SH AH N IH NG",JOEDICKE="JH OW D IH K",ORAM="AO R AH M",NEWSPERSONS="N UW Z P ER S AH N Z",KETTERLING="K EH T ER L IH NG",["PRACTICED(2)"]="P R AE K T IH S T",["FORGOT(2)"]="F AO R G AA T",TRAM="T R AE M",ARGUABLE="AA R G Y UW AH B AH L",AEROSTARS="EH R OW S T AA R Z",VANHOOSE="V AE N HH UW S",KRAM="K R AE M",ROSENBLATTS="R OW Z AH N B L AE T S",LAUNCELOT="L AO N S IH L AA T",HENRIQUEZ="HH EH N R IY K EH Z",["DEFENSES(2)"]="D IH F EH N S IH Z",GERALDI="JH EH R AE L D IY",["WAYANS(2)"]="HH W EY AH N Z",ERLING="ER L IH NG",HILSCHER="HH IH L SH ER",["KOREAN'S(2)"]="K ER IY AH N Z",ALCANTARA="AA L K AA N T AA R AH",["IDEAL'S"]="AY D IY L Z",PARADEE="P EH R AH D IY",SWAM="S W AE M",DELSANTO="D EH L S AA N T OW",DOWNPLAYED="D AW N P L EY D",ABOUNDING="AH B AW N D IH NG",OEHLKE="OW L K",SAPLING="S AE P L IH NG",CHITRAO="CH IH T R AW",KATHA="K AE TH AH",SMELCER="S M EH L S ER",RETRIBUTION="R EH T R AH B Y UW SH AH N",BEHLKE="B EH L K",TREKKING="T R EH K IH NG",["GALEN'S"]="G EY L AH N Z",STAM="S T AE M",ZEEBRUGGE="Z IY B R UW G IY",ESTIMATIONS="EH S T AH M EY SH AH N Z",RAKOFF="R AE K AO F",REUBEN="R UW B AH N",CORNFLOWERS="K AO R N F L AW ER Z",GULPING="G AH L P IH NG",INFILTRATORS="IH N F IH L T R EY T ER Z",WOOED="W UW D",ETLING="EH T L IH NG",HOEGER="HH OW G ER",PULPING="P AH L P IH NG",BOEGER="B OW G ER",PHOTOVOLTAICS="F OW T OW V OW L T EY IH K S",["BOYS'"]="B OY Z",BOOED="B UW D",CAREERIST="K ER IH R IH S T",BLUEPENCILLED="B L UW P EH N S AH L D",HABERL="HH AE B ER L",COCOA="K OW K OW",APOSTLE="AH P AA S AH L",HINOJOS="HH IY N OW Y OW Z",HERDING="HH ER D IH NG",KREGER="K R IY G ER",GERDING="G EH R T IH NG",DEMILITARIZES="D IY M IH L AH T ER AY Z IH Z",["TUBERCULOSIS(2)"]="T UW B ER K Y AH L OW S AH S",DREGER="D R EH G ER",ANDREA="AE N D R IY AH",BREGER="B R IY G ER",GREGER="G R EH G ER",GELDERMANN="G EH L D ER M AH N",REIFSCHNEIDER="R AY F SH N AY D ER",INTERVENTION="IH N T ER V EH N CH AH N",MERVINE="M ER V AY N",HEARSAY="HH IY R S EY",MOMENTOUS="M OW M EH N T AH S",HIGHS="HH AY Z",BRISKEY="B R IH S K IY",TRANSCRIBES="T R AE N S K R AY B Z",CHEANEY="CH IY N IY",DEVOTION="D IH V OW SH AH N",["POTENTIALS(2)"]="P AH T EH N SH AH L Z",BYINGTON="B AY IH NG T AH N",BEGGARS="B EH G ER Z",ESAREY="EH S ER IY",STATUARY="S T AE CH UW EH R IY",["TRIPOLI'S"]="T R IH P AH L IY Z",PATINA="P AH T IY N AH",POLLINIA="P AA L IH N IY AH",LATINA="L AA T IY N AH",["GLENAYRE(2)"]="G L EH N AY R",CELAYA="S EY L EY AH",UNBELIEVING="AH N B AH L IY V IH NG",BROTHERTON="B R AH DH ER T AH N",CARAMEL="K EH R AH M AH L",LAPHAM="L AE F AH M",DEMAGOGUES="D EH M AH G AA G Z",EPLING="EH P L IH NG",LARUSO="L AA R UW S OW",HANDSAWS="HH AE N D S AO Z",IMAM="AY M AE M",BURFEIND="B ER F AY N D",GAYNOR="G EY N ER",FREDERKING="F R EH D ER K IH NG",BADEN="B EY D AH N",["GRANDSTAFF(2)"]="G R AE N S T AE F",TRUSTCORP="T R AH S T K AO R P",TORTURERS="T AO R CH ER ER Z",CURCI="K UH R CH IY",HENKELS="HH EH NG K AH L Z",PEYOT="P EY AO T",DOLING="D OW L IH NG",BOLING="B OW L IH NG",LAUDICINA="L AO D IY CH IY N AH",["ELYSIA(2)"]="IH L IY ZH AH",SHINAULT="SH IH N AW L T",["ORION'S"]="OW R AY AH N Z",POLING="P OW L IH NG",RAYNOR="R EY N ER",["DAWN'S"]="D AO N Z",MAYNOR="M EY N ER",ROLING="R OW L IH NG",["DISCOUNTING(2)"]="D IH S K AW N IH NG",HOLING="HH OW L IH NG",CARUSO="K ER UW S OW",BOLTZMANNS="B OW L T S M AH N Z",KNOCKOUTS="N AA K AW T S",PHOTOCOPY="F OW T OW K AA P IY",FOAM="F OW M",["REGULATED(2)"]="R EH G Y AH L EY T IH D",ROAM="R OW M",LOAM="L OW M",RENOVATIONS="R EH N AH V EY SH AH N Z",NOAM="N OW M",SLUGFEST="S L AH G F EH S T",ULAM="Y UW L AE M",TROSTLE="T R AA S AH L",CHALSTY="CH AE L S T IY",GONDWANA="G AA N D W AA N AA",NARCOTICS="N AA R K AA T IH K S",["ALICE(2)"]="AE L IH S",AILING="EY L IH NG",FLAM="F L AE M",ELAM="EH L AH M",CARSTENSEN="K AA R S T EH N S AH N",RAGU="R AE G UW",FILLINGAME="F IY L IH NG G AA M IY",SLAM="S L AE M",LATOUR="L AH T UH R",PLAM="P L AE M",ALIEN="EY L IY AH N",FRAUGHT="F R AO T",OILING="OY L IH NG",PILING="P AY L IH NG",BRINGTON="B R IH NG T AH N",ARINGTON="AA R IH NG T AH N",RETRIEVER="R IY T R IY V ER",CLAM="K L AE M",FILING="F AY L IH NG",ALAM="AH L AE M",DISDAIN="D IH S D EY N",ALLING="AO L IH NG",HOLSCHER="HH OW L SH ER",ANSPAUGH="AH N S P AO",DIMINISH="D IH M IH N IH SH",RELEARN="R IY L EH R N",MODESTO="M OW D EH S T OW",["CREVELING(2)"]="K R EH V L IH NG",LOUGHRY="L AW R IY",BALDUCCI="B AA L D UW CH IY",ELLING="EH L IH NG",["SNOWBALL'S"]="S N OW B AO L Z",RAITT="R EY T",LANDHOLDING="L AE N D HH OW L D IH NG",TAITT="T EY T",WAITT="W EY T",["PETROLEUM'S"]="P AH T R OW L IY AH M Z",["WHIRLEY(2)"]="HH W ER L IY",HANDHOLDING="HH AE N D HH OW L D IH NG",["BUICE(2)"]="B W IY S",HARASSERS="HH ER AE S ER Z",BEMUSEMENT="B EH M Y UW S M AH N T",ACCOMPANIES="AH K AH M P AH N IY Z",KVAM="K V AE M",TELZROW="T EH L Z R OW",EXTRAVAGANCE="EH K S T R AE V AH G AH N S",TROYAN="T R OY AH N",NONRENEWABLE="N AA N R IY N UW AH B AH L",INTIMATIONS="IH N T AH M EY SH AH N Z",MUSHA="M Y UW SH AH",MANDALA="M AA D AH L AH",RUEGER="R UH G ER",AIRWAVE="EH R W EY V",FAUVER="F AW V ER",MANRIQUEZ="M AA N R IY K W EH Z",["MARTZ'S"]="M AA R T S IH Z",HAUVER="HH AW V ER",LAUVER="L AW V ER",HANDIER="HH AE N D IY ER",MCGUIRK="M AH G ER K",["CASHIER'S"]="K AE SH IH R Z",CATALOGUE="K AE T AH L AO G",HUMANISM="HH Y UW M AH N IH Z AH M",HELING="HH IY L IH NG",MELING="M EH L IH NG",["MAWR(2)"]="M AA R",PREDISPOSITIONS="P R IY D IH S P AH Z IH SH AH N Z",COMMITMENTS="K AH M IH T M AH N T S",HYACINTHIE="HH AY AH S IH N TH IY",YAMAHA="Y AA M AA HH AA",BRANDENSTEIN="B R AE N D EH N S T AY N",CHIEN="CH EH N",WADHAMS="W AO D AH M Z",BUSHA="B AH SH AH",IMAGINATIVE="IH M AE JH AH N AH T IH V",KOWALIK="K AW AA L IH K",EXAM="IH G Z AE M",CATELLI="K AH T EH L IY",KLEPPINGER="K L EH P IH NG G ER",DEAM="D IY M",["LORI'S"]="L AO R IY Z",BEAM="B IY M",LIKEWISE="L AY K W AY Z",PRCHAL="P ER SH AE L",["CONDUITS(2)"]="K AA N D W AH T S",HOUSEWORK="HH AW S W ER K",NEBULOUS="N EH B Y AH L AH S",POOLING="P UW L IH NG",["FIEDLER'S"]="F IY D L ER Z",PAMPER="P AE M P ER",DANDREA="D AE N D R IY AH",ERITREANS="EH R IH T R IY N Z",TRANSPLANTING="T R AE N S P L AE N T IH NG",["DONKEY(2)"]="D AO NG K IY",EPILEPSIES="EH P AH L EH P S IY Z",EXPORTED="IH K S P AO R T AH D",LIMPING="L IH M P IH NG",RIZZOLO="R IY T S OW L OW",CAMPER="K AE M P ER",DAMPER="D AE M P ER",GAMPER="G AE M P ER",ATHEISM="AH TH AY S AH M",HAMPER="HH AE M P ER",KAMPER="K AE M P ER",FERDINANDA="F ER D IY N AA N D AH",ORLOFF="AO R L AO F",RECALCITRANCE="R IH K AE L S AH T R AH N S",LIMING="L AY M IH NG",SEABERT="S IY B ER T",["REQUIRE(3)"]="R IH K W AY ER",["FRITZSCHE(3)"]="F R IH CH",ESPINOZA="EY S P IY N OW Z AH",PROSKAUER="P R AO S K AW R",ARENSON="AE R IH N S AH N",DEZARN="D EY Z AA R N",SUTURED="S UW CH ER D",["GARAJDA'S"]="G ER AA ZH D AH Z",["POSTPONE(2)"]="P OW S P OW N",DIMING="D AY M IH NG",ARNETT="AA R N EH T",COOLING="K UW L IH NG",DOOLING="D UW L IH NG",FOOLING="F UW L IH NG",EDAM="IY D AH M",DOYEL="D OY AH L",["COMPETITORS(2)"]="K AH M P EH T IH T ER Z",ERGONOMIC="ER G AH N AA M IH K",MARQUART="M AA R K W AA R T",ADAM="AE D AH M",LAVELLE="L AH V EH L",TEAM="T IY M",REAM="R IY M",SEAM="S IY M",LUAU="L UW AW",MEDIO="M IY D IY OW",NESBIT="N EH S B IH T",REVELLE="R IH V EH L",KAMALI="K AH M AA L IY",["ACCOMPANIMENT(2)"]="AH K AH M P N IY M AH N T",REANALYZE="R IY AE N AH L AY Z",["ORLOSKY'S"]="AO R L OW S K IY Z",["JACQUES(2)"]="JH AE K",REORDER="R IY AO R D ER",["DOWN'S"]="D AW N Z",ELAMIN="EH L AH M IH N",["BRETTSCHNEIDER(2)"]="B R EH T S N AY D ER",AVOLIO="AH V OW L IY OW",COLLIGNON="K AH L IH G N AH N",SWEANEY="S W IY N IY",MAROHN="M AA R AH N",["LOVERS'"]="L AH V ER Z",DESAUTEL="D EH S OW T AH L",EXTENDABLE="EH K S T EH N D AH B AH L",FRANCA="F R AE NG K AH",IMPLANT="IH M P L AE N T",SHELHAMER="SH EH L HH AH M ER",SLUGA="S L UW G AH",ALSPAUGH="AH L S P AO",HERYANA="HH ER Y AE N AH",VONDRACEK="V AA N D R AH S IH K",CHAU="SH OW",BRANCA="B R AE NG K AH",REVISIONIST="R IY V IH ZH AH N IH S T",GENERICS="JH AH N EH R IH K S",IMPROVISES="IH M P R AH V AY Z AH Z",SPAM="S P AE M",CERULLI="CH ER UW L IY",SCHULDENER="SH UW L D AH N ER",THAU="DH AW",CONSUMMATE="K AA N S AH M AH T",ALCOA="AE L K OW AH",BADGER="B AE JH ER",TREATER="T R IY T ER",ROLOFF="R AA L AO F",FABULOUS="F AE B Y AH L AH S",["DAIWA'S"]="D EY W AH Z",PERJURE="P ER JH ER",THRIFT="TH R IH F T",SOLOFF="S AA L AO F",["HELEN'S"]="HH EH L IH N Z",LIAU="L IY AW",GREATER="G R EY T ER",GUERNSEY="G ER N Z IY",NIHAY="N AY HH EY",MANATEES="M AE N AH T IY Z",BALCONIES="B AE L K AH N IY Z",DEVELLE="D AH V EH L",MCCAMISH="M AH K AE M IH SH",CAPRIATI="K AE P R IY AA T IY",FREEMEN="F R IY M EH N",["COMEDIAN'S"]="K AH M IY D IY AH N Z",["DANJUBE'S"]="D AE N JH UW B Z",WHITESTONE="W AY T S T OW N",CANNERIES="K AE N ER IY Z",["KHALID'S"]="K AA L IH D Z",SOUTHWAY="S AW TH W EY",GOPINATH="G OW P IH N AH TH",DYSENTERY="D IH S AH N T EH R IY",FEMININE="F EH M AH N AH N",SIDETRACK="S AY D T R AE K",NONPRODUCTIVE="N AA N P R AH D AH K T IH V",VITELLI="V IH T EH L IY",GREANEY="G R IY N IY",KORVER="K AO R V ER",OUTDONE="AW T D AH N",TAMPING="T AE M P IH NG",HORIZONTALLY="HH AO R IH Z AA N T AH L IY",ADHESIVES="AE D HH IY S IH V Z",HARDING="HH AA R D IH NG",DAMPING="D AE M P IH NG",ELECTRO="IH L EH K T R OW",["MAYS'"]="M EY Z",GENCARELLI="JH EH N K AA R EH L IY",["DAYS'"]="D EY Z",RAMPING="R AE M P IH NG",HARYANA="HH EH R Y AA N AH",SOBOLEWSKI="S AH B AH L EH F S K IY",MENOPAUSE="M EH N AH P AW Z",["ELLEN'S"]="EH L AH N Z",HEALTHVEST="HH EH L TH V EH S T",NAMING="N EY M IH NG",["WHARF'S"]="W AO R F S",["ALLEN'S"]="AE L AH N Z",["ESSENTIAL(4)"]="IY S EH N CH AH L",ENCOURAGE="EH N K ER IH JH",CAMPING="K AE M P IH NG",ALLERGENS="AE L ER JH AH N Z",DEERBORNE="D IH R B AO R N",RUDEN="R UW D AH N",["CONTRAST(2)"]="K AH N T R AE S T",LEDGER="L EH JH ER",MISHA="M IH SH AH",HEDGER="HH EH JH ER",KISHA="K IH SH AH",AUBE="AO B",CUBE="K Y UW B",DUBE="D UW B",RETINA="R EH T AH N AH",HUBE="HH Y UW B",KUBE="K Y UW B",LUBE="L UW B",ADVOCATED="AE D V AH K EY T AH D",HEPARIN="HH EH P ER IH N",["EVAPORATED(4)"]="IY V AE P ER EY T IH D",REENTERED="R IY IH N T ER D",ANALOGUE="AE N AH L AO G",MICHAL="M IH CH AH L",TUBE="T UW B",SERVICE="S ER V AH S",RADIO="R EY D IY OW",ZUBE="Z UW B",FINEST="F AY N AH S T",KIAM="K IY AH M",LIAM="L IY AH M",ERNEST="ER N AH S T",HIAM="HH AY AH M",["UNDETERMINING(2)"]="AH N D IY T ER M AH N IH NG",APARTMENTS="AH P AA R T M AH N T S",NUNSENSE="N AH N S EH N S",CAGLIARI="K AE G L IY AA R IY",MISOGYNISTS="M IH Z AH JH IH N IH S T S",["FAUGHT'S"]="F AO T S",UNABOMBINGS="Y UW N AH B AO M IH NG Z",["VALUES'"]="V AE L Y UW Z",PARAMAGNETIC="P AE R AH M AE G N EH T IH K",AUDEN="AO D AH N",ALIENS="EY L IY AH N Z",DUDEN="D UW D AH N",MAYBURY="M EY B EH R IY",VETOES="V IY T OW Z",NETHERLANDIC="N EH DH ER L AE N D IH K",MUPPET="M AH P AH T",HONEST="AA N AH S T",["CALMEST(2)"]="K AA L M AH S T",PUPPET="P AH P AH T",CRAMPTON="K R AE M P T AH N",PIXEL="P IH K S AH L",ADORNING="AH D AO R N IH NG",NICOLAIDES="N IH K AH L EY D Z",["HOECHST(2)"]="HH OW SH T",BUDDENBROOKS="B AH D AH N B R UH K S",RESTRAINT="R IH S T R EY N T",RYDEN="R AY D AH N",BIELEFELDT="B IY L IH F IH L T",ERLANDSON="ER L AH N D S AH N",DESHA="D EH SH AH",WYDEN="W AY D",FASHIONABLY="F AE SH AH N AH B L IY",WHAM="W AE M",LYDEN="L AY D AH N",THAM="TH AE M",SHAM="SH AE M",BEARDSLEY="B IH R D Z L IY",PHAM="F AE M",FULFILLS="F UH L F IH L Z",DEDEURWAERDER="D AH D ER W AA R D ER",DULING="D Y UW L IH NG",CHAM="CH AE M",LIBERACE="L IH B ER AA CH IY",CAMBODIANS="K AE M B OW D IY AH N Z",SOLVED="S AA L V D",SOLEMNITY="S AH L EH M N AH T IY",BLANCA="B L AA NG K AH",MONETT="M AA N IH T",COULEE="K UW L IY",DOCUMENTA="D AA K Y UW M EH N T AH",["MILOSEVIC'S"]="M IH L OW S AH V IH CH IH Z",KAWAKAMI="K AA W AA K AA M IY",KREIDLER="K R AY D AH L ER",CHMIELEWSKI="CH AH M AH L EH F S K IY",OXFORDS="AA K S F ER D Z",GROWERS="G R OW ER Z",DAUBE="D AO B",["RESPECTED(2)"]="R IY S P EH K T AH D",["COSTLY(2)"]="K AO S T L IY",JOURNAL="JH ER N AH L",MONDEX="M AA N D EH K S",ABATEMENT="AH B EY T M AH N T",OUTWIT="AW T W IH T",["O'QUINN"]="OW K W IH N",["MOSTLY(2)"]="M OW S L IY",GLENHAM="G L EH N HH AH M",OKRAY="AA K R EY",CHEMFIX="CH EH M F IH K S",COTHERN="K AH DH ER N",BORELLI="B AO R EH L IY",WADED="W EY D IH D",CERNA="CH EH R N AH",BERNA="B EH R N AH",HEBERLEIN="HH EH B ER L AY N",FALZONE="F AA L Z OW N IY",FADED="F EY D AH D",IDEALLY="AY D IY L IY",MERNA="M EH R N AH",GABARDINE="G AE B ER D IY N",PACTS="P AE K T S",PERNA="P ER N AH",INCARCERATE="IH N K AA R S ER EY T",DYATRON="D AY AH T R AH N",MAXIMIZATION="M AE K S IH M IH Z EY SH AH N",["CONTE(2)"]="K AO N T EY",["ENRON'S"]="EH N R AA N Z",LIMITLESS="L IH M AH T L AH S",FRISTOE="F R IH S T OW",COREL="K AO R EH L",["HAKIM'S"]="HH AA K IY M Z",NICOLET="N IH K AH L EH T",HARBORS="HH AA R B ER Z",["SYSTEMIX(2)"]="S IH S T EH M IH K S",MORELLI="M AO R EH L IY",SHOSHONE="SH OW SH OW N IY",LORELLI="L AO R EH L IY",BRISTLED="B R IH S AH L D",OSBOURNE="AA S B ER N",MOREL="M ER EH L",TIBBITS="T IH B IH T S",INIMITABLE="IH N IH M AH T AH B AH L",DESMOPLASIA="D EH Z M OW P L EY ZH IY AH",AUTOMATING="AO T AH M EY T IH NG",BRANDEIS="B R AE N D AY S",ZAPRUDER="Z AH P R UW D ER",SACRIFICES="S AE K R AH F AY S IH Z",ARCHANGEL="AA R K EY N JH AH L",AFOOT="AH F UH T",ANDRESEN="AE N D R IY S AH N",SHOOT="SH UW T",SVENSON="S V EH N S AH N",ENVOS="EH N V OW S",KURLAK="K ER L AE K",SCARP="S K AA R P",EVENSON="EH V IH N S AH N",ERASTUS="IH R AE S T AH S",ARDREY="AA R D R IY",BOBICK="B AA B IH K",FEATHERY="F EH DH ER IY",TONGA="T AA N G AH",["LIKUD'S(2)"]="L IY K UW D Z",SIGWALD="S IH G W AH L D",NONBELIEVERS="N AA N B AH L IY V ER Z",CONGA="K AO NG G AH",DUMLAO="D UW M L AW",FERRO="F EH R OW",LERRO="L EH R OW",POINTEDLY="P OY N T IH D L IY",VIRNA="V ER N AH",SIRNA="S ER N AH",CERRO="S EH R OW",INSTANTANEOUS="IH N S T AH N T AE N IY AH S",WIDHALM="W IH D HH AA M",DESEGREGATED="D IH S EH G R IH G EY T IH D",NULLIFICATION="N AH L AH F AH K EY SH AH N",DIURNAL="D AY ER N AH L",STENSON="S T EH N S AH N",GARAY="G AE R EY",PLISETSKAYA="P L IH S AH T S K AY AH",RADFORD="R AE D F ER D",TATEHO="T AH T EY HH OW",MELNYK="M EH L N IH K",DEMOTION="D IH M OW SH AH N",NEATHERY="N EH TH ER IY",TAIYO="T AY Y OW",DIMARINO="D IH M AA R IY N OW",RIPOFF="R IH P AO F",SZALKOWSKI="SH AH L K AO F S K IY",LEATHERY="L EH DH ER IY",ADEQUATE="AE D AH K W AH T",HECKBERT="HH EH K B ER T",NEWBOLD="N UW B OW L D",CASERTA="K AA S EH R T AH",THEORISTS="TH IY ER IH S T S",EDISONS="EH D IH S AH N Z",WOLSFELD="W OW L Z F EH L D",CHERNOW="CH ER N OW",["BYRON'S"]="B AY R AH N Z",SYSTEM="S IH S T AH M",TURTLENECK="T ER T AH L N EH K",STOCKARD="S T AA K ER D",MELCHIOR="M EY L CH IY ER",["GURNEY'S"]="G ER N IY Z",OVSHINSKY="AA V SH IH N S K IY",DRAPING="D R EY P IH NG",OPENNESS="OW P AH N N AH S",ZIMMERLY="Z IH M ER L IY",JEREL="JH EH R AH L",["HUSTLER(2)"]="HH AH S L ER",BRAGDON="B R AE G D AH N",BEDFORD="B EH D F ER D",SHOWERS="SH AW ER Z",PARSONAGES="P AA R S AH N IH JH AH Z",HORNBAKER="HH AO R N B AH K ER",SCOOT="S K UW T",COUNTERCHARGES="K AW N T ER CH AA R JH IH Z",STINKBUG="S T IH NG K B AH G",["INEQUALITY(2)"]="IH N AH K W AA L AH T IY",AYDT="EY T",MELENDEZ="M AH L EH N D EH Z",LINDROTH="L IH N D R AO TH",AMSOUTH="AE M S AW TH",IMAGERIES="IH M IH JH R IY Z",MISCHARACTERIZES="M IH S K AE R AH K T ER AY Z IH Z",GARRO="G AA R OW",SARRO="S AA R OW",KUBICK="K Y UW B IH K",HOHENSEE="HH AA HH IH N S IY",SCONYERS="S K AO N IY ER Z",ZARRO="Z AA R OW",ROMPING="R AA M P IH NG",REDFORD="R EH D F ER D",["SURGEONS'"]="S ER JH IH N Z",MEDFORD="M EH D F ER D",LESSEE="L EH S IY",LEDFORD="L EH D F ER D",["MIDWINTER'S"]="M IH D W IH N T ER Z",WAIVED="W EY V D",["COLLABORATED(2)"]="K AH L AE B ER EY T IH D",TEDFORD="T EH D F ER D",CARSTARPHEN="K AA R S T AA R F AH N",DUSZYNSKI="D AH SH IH N S K IY",MODALITIES="M AH D AE L AH T IY Z",HEUERMANN="HH OY ER M AH N",["CYCLOPS'S"]="S AY K L AO P S IH Z",CONDITIONALLY="K AH N D IH SH AH N AH L IY",SANKEI="S AE NG K IY",["INDUSTRIES'"]="IH N D AH S T R IY Z",ANDERSONS="AE N D ER S AH N Z",["ACKNOWLEDGE(2)"]="IH K N AA L IH JH",MUSZYNSKI="M AH SH IH N S K IY",["NEW-ORLEANS(2)"]="N Y UW AO R L IY N Z",OUTMANEUVERS="AW T M AH N UW V ER Z",DEVOS="D IY V OW Z",KINGSPORT="K IH NG S P AO R T",FACTS="F AE K T S",TREATY="T R IY T IY",["MICHELANGELOS(2)"]="M IH K AH L AE N JH AH L OW Z",FURTADO="F UH R T AA D OW",BIRTHMARKS="B ER TH M AA R K S",TODT="T AA D T",RUBOTTOM="R AH B AH T AA M",GLEANED="G L IY N D",SEDUMS="S EH D AH M Z",EXBOYFRIEND="EH K S B OY F R EH N D",GRAVETT="G R AE V IH T",HURTADO="HH ER T AA D OW",OUTLAWRY="AW T L AO R IY",["TEMPERATURE(2)"]="T EH M P ER AH CH ER",["NORMA-JEAN"]="N AO R M AH JH IY N",CLEANED="K L IY N D",PERSUADING="P ER S W EY D IH NG",DESIGNATION="D EH Z AH G N EY SH AH N",CALTABIANO="K AA L T AA B IY AA N OW",FLOWERS="F L AW ER Z",["NATIONWIDE'S"]="N EY SH AH N W AY D Z",REAGANESQUE="R EY G AH N EH S K",["INDIGEST(2)"]="IH N D AH JH EH S T",PETROLEUM="P AH T R OW L IY AH M",PURDUE="P ER D UW",["WALDHEIM(2)"]="V AO L D HH AY M",ECKMANN="EH K M AH N",PURCHASER="P ER CH AH S ER",LETTERHEAD="L EH T ER HH EH D",ENGLISHWOMAN="IH NG G L IH SH W UH M AH N",GROOT="G R UW T",["BAUMGARTNER(2)"]="B AA M G AA R T N ER",KLAUBER="K L AW B ER",ULSHAFER="AH L SH AH F ER",JUBILEE="JH UW B AH L IY",DEFERENTIAL="D EH F ER EH N CH AH L",BLOWERS="B L OW ER Z",CLOWERS="K L AW ER Z",CONTEMPLATING="K AA N T AH M P L EY T IH NG",CONVOLUTED="K AA N V AH L UW T AH D",LENGER="L EH NG ER",MENGER="M EH N JH ER",MANGA="M AE NG G AH",["RESERVED(2)"]="R IY Z ER V D",DOROUGH="D AO R AW",MODED="M OW D IH D",AGACHES="AE G AE CH AH Z",AMPHIBOLE="AE M F AH B OW L",["AARON'S"]="EH R AH N Z",["BARON'S"]="B AE R AH N Z",FENGER="F EH NG ER",GENGER="JH EH NG G ER",ZAMZOW="Z AE M Z OW",VISITATION="V IH Z AH T EY SH AH N",BARGAINER="B AA R G IH N ER",WRIT="R IH T",LEVITATING="L EH V AH T EY T IH NG",GREENLAW="G R IY N L AO",BLACKBIRD="B L AE K B ER D",CODED="K OW D IH D",SUBSCRIBER="S AH B S K R AY B ER",["CROCKER'S"]="K R AA K ER Z",CONTRADICTION="K AA N T R AH D IH K SH AH N",GENTILES="JH EH N T AY L Z",SWEATY="S W EH T IY",MIDRIB="M IH D R IH B",POLLIO="P AA L IY OW",["RATTLER(2)"]="R AE T L ER",BOVESPA="B OW V S P AA",STEREOTYPED="S T EH R IY AH T AY P T",NONSMOKER="N AA N S M OW K ER",KNIT="N IH T",DISPOSABLE="D IH S P OW Z AH B AH L",AMIT="AA M IY T",GRADO="G R AA D OW",["SEMIANNUALLY(3)"]="S EH M IY AE N UW L IY",DELIGHTED="D IH L AY T AH D",VASHINSKY="V AH SH IH N S K IY",SMIT="S M IH T",OMIT="OW M IH T",COMMENTARY="K AA M AH N T EH R IY",EMIT="IH M IH T",STATEMENT="S T EY T M AH N T",RELIEVER="R IY L IY V ER",MIEDEMA="M IY D EH M AH",NEUGENT="N UW JH AH N T",MINGER="M IH NG ER",LINGER="L IH NG G ER",CHEAPER="CH IY P ER",ZINGER="Z IH NG ER",WINGER="W IH NG ER",["FELICIANO(2)"]="F AH L IY SH IY AA N OW",SINGER="S IH NG ER",VOIT="V OY T",BINGER="B IH NG ER",HAUSAUER="HH AW S AW ER",["CENTERS'(2)"]="S EH N ER Z",GINGER="JH IH N JH ER",HINGER="HH IH N JH ER",HARPIST="HH AA R P IH S T",FINGER="F IH NG G ER",DINGER="D IH NG ER",COIT="K OY T",SCHWEBACH="SH W EH B AA K",STRICTURES="S T R IH K CH ER Z",BORDEAUX="B AO R D OW",ADAMCIK="AA D AH M CH IH K",["FIDDLER'S"]="F IH D AH L ER Z",RIGOROUS="R IH G ER AH S",UNIT="Y UW N AH T",VIGOROUS="V IH G ER AH S",BELIEVER="B AH L IY V ER",["TORUMI'S"]="T AO R UW M IY Z",["DIAL'S(2)"]="D AY L Z",HOIT="HH OY T",MANISCHEWITZ="M AE N IH SH EH V IH T S",LEACHES="L IY CH IH Z",BEACHES="B IY CH AH Z",GENEROSITY="JH EH N ER AA S AH T IY",["MIGHT-HAVE-BEENS"]="M AY T AH V B IH N Z",SCULPTS="S K AH L P T S",LADWIG="L AE D W IH G",ENDED="EH N D AH D",TEACHES="T IY CH AH Z",UNDERNOURISH="AH N D ER N ER IH SH",REACHES="R IY CH AH Z",BOTHAM="B AA TH AH M",["FOCUSES(2)"]="F OW K IH S IH Z",INFERENTIAL="IH N F ER EH N SH AH L",MYRNA="M ER N AH",ARKANSANS="AA R K AE N Z AH N Z",GOTHAM="G AA TH AH M",CARPET="K AA R P AH T",COTHAM="K AA TH AH M",ROHLICEK="R AA L AH CH EH K",["L'ALMA"]="L AA L M AH",ARSONIST="AA R S AH N AH S T",["EMOTION(2)"]="IY M OW SH AH N",DONUTS="D OW N AH T S",PROTECTIONIST="P R AH T EH K SH AH N IH S T",TRADEMARKED="T R EY D M AA R K T",LIEBOWITZ="L IY B AH W IH T S",SCHOOLED="S K UW L D",VANCISE="V AA N CH AY S",FREDRICKS="F R EH D R IH K S",BINGA="B IY NG G AH",CHOPER="CH OW P ER",BEITLER="B AY T AH L ER",BASIX="B EY S IH K S",SHMOOZING="SH M UW Z IH NG",HOLLIER="HH AO L IY ER",PRISSY="P R IH S IY",JOLLIER="JH AA L IY ER",BUTENHOFF="B Y UW T IH N HH AO F",MOSSLIKE="M AO S L AY K",DAYDREAM="D EY D R IY M",BOLLIER="B AA L IY ER",["HARNESSES(2)"]="HH AA R N AH S IH Z",OVERSTATED="OW V ER S T EY T IH D",CONFIRMS="K AH N F ER M Z",["DOGMATIC(2)"]="D AO G M AE T IH K",CONNECTED="K AH N EH K T AH D",BELABORED="B IH L EY B ER D",["DATSUN(2)"]="D AA T S AH N",MAKSYMUK="M AE K S IY M UH K",PANNILL="P AE N IH L",REVENUER="R EH V AH N UW ER",["NESTLER(2)"]="N EH S L ER",BREITBARTH="B R AY T B AA R TH",CASTEEN="K AH S T IY N",LABRAKE="L AE B R AH K",BUREL="B EH R AH L",COMPANYWIDE="K AH M P AH N IY W AY D",AYGEN="AY G AH N",THIRDQUARTER="TH ER D K W AO R T ER",TULLIO="T UW L IY OW",FRANCK="F R AE NG K",ABUZZ="AH B AH Z",["KENTUCKY'S"]="K AH N T AH K IY Z",RECUSAL="R IH K Y UW Z AH L",MARYSE="M AA R IY S",LAFFOON="L AH F UW N",MALOOF="M AH L UW F",FRANCESCONI="F R AA N CH EH S K OW N IY",AMARIS="AE M ER IH S",SYMBION="S IH M B IY AH N",["ENJOYMENT(2)"]="IH N JH OY M AH N T",["LEACH'S"]="L IY CH IH Z",["TEXAS'(2)"]="T EH K S AH S",["CITRON'S(2)"]="S IH T R AA N Z",["JOACHIM(2)"]="W AA K IY M",HILLIER="HH IH L IY ER",ALBERTSEN="AE L B ER T S AH N",CAPPER="K AE P ER",LUCE="L UW S",["ICESKATE(2)"]="AY S K EY T",ZEITLER="Z AY T AH L ER",WEITLER="W AY T L ER",BEARFIELD="B ER F IY L D",RAPPER="R AE P ER",LAMPOONED="L AE M P UW N D",TAPPER="T AE P ER",MAIELLO="M AY EH L OW",NAPPER="N AE P ER",["EXCUSES(2)"]="IH K S K Y UW Z IH Z",REVAMPING="R IY V AE M P IH NG",TORTOISE="T AO R T AH S",KAPPER="K AE P ER",TRURO="T R UW R OW",SIDESHOW="S AY D SH OW",["BARNEY'S"]="B AA R N IY Z",SANGER="S AE NG ER",TANGER="T AE NG ER",RANGER="R EY N JH ER",MANGER="M EY N JH ER",LANGER="L AE NG ER",NUCLEIC="N UW K L EY IH K",GANGER="G AE NG ER",HANGER="HH AE NG ER",["ABRAXA'S"]="AH B R AE K S AH Z",FANGER="F AE NG ER",DANGER="D EY N JH ER",THRILLS="TH R IH L Z",BANGER="B AE NG ER",["O'DAY"]="OW D EY",DUCE="D UW S",MCCULLY="M AH K AH L IY",ETHNOGRAPHIC="EH TH N AH G R AE F IH K",PHARIS="F AE R AH S",RELIVING="R IY L IH V IH NG",CULBERTSON="K AH L B ER T S AH N",DOGHOUSES="D AO G HH AW S IH Z",COHEN="K OW AH N",BOHEN="B OW AH N",CUPERTINO="K UW P ER T IY N OW",HOKENSON="HH AA K IH N S AH N",KOHEN="K OW AH N",["SARNEY'S"]="S AA R N IY Z",BEAUMIER="B OW M IY ER",ENGRAVINGS="IH N G R EY V IH NG Z",ELECTROCARDIOGRAMS="IH L EH K T R OW K AA R D IY AH G R AE M Z",ARTICHOKE="AA R T AH CH OW K",FLASHBACK="F L AE SH B AE K",SADDENS="S AE D AH N Z",HILSABECK="HH IH L S AH B EH K",FERNAU="F ER N AW",BRIZENDINE="B R IY Z EH N D IY N IY",GASSEE="G AE S IY",NAZISM="N AE Z IH Z AH M",ENDEARMENT="IH N D IH R M AH N T",MARVELING="M AA R V AH L IH NG",PANACO="P AE N AH K OW",KYONGSANG="K Y AO NG S AE NG",SOLICITOUS="S AH L IH S AH T AH S",HELLIER="HH EH L Y ER",SELLIER="S EH L Y ER",MARROQUIN="M AA R OW K W IY N",ASSIMILATION="AH S IH M AH L EY SH AH N",BLANCK="B L AE NG K",LAWPLAN="L AO P L AE N",TENGIZ="T EH NG G IH Z",RADAVAN="R AA D AH V AH N",["AMETEK'S"]="AE M AH T EH K S",PLANCK="P L AE NG K",STOUFFS="S T AH F S",BUNGER="B AH NG ER",ESZTERHAS="EH S T ER HH AA S",["MICHEL'S(2)"]="M IH CH AH L Z",MISUSING="M IH S Y UW Z IH NG",GELERNTER="G AH L ER N T ER",CAFE="K AH F EY",JUNGER="JH AH NG ER",APOLOGY="AH P AA L AH JH IY",DEBRIS="D AH B R IY",LUNGER="L AH NG ER",MUNGER="M AH NG ER",INFRACTIONS="IH N F R AE K SH AH N Z",MORTEM="M AO R T AH M",MATTEA="M AE SH AH",SAFE="S EY F",["LENNON'S"]="L EH N AH N Z",CURRICULA="K ER IH K Y AH L AH",ANTOINE="AA N T W AA N",["BANCORP'S(2)"]="B AE N K AO R P S",PASSALACQUA="P AE S AH L AE K W AH",HESLEP="HH EH S L IH P",MONOPOLES="M AA N AH P OW L Z",EASEL="IY Z AH L",DISPOSABLES="D IH S P OW Z AH B AH L Z",BASEL="B AA Z AH L",SARNA="S AA R N AH",ALLENS="AE L AH N Z",FASTIDIOUS="F AE S T IH D IY AH S",["REDSTONE'S"]="R EH D S T OW N Z",SLINGING="S L IH NG IH NG",["SHA'ATH"]="SH AA TH",SMYRNA="S M ER N AH",ANTHRAX="AE N TH R AE K S",ACCENTING="AE K S EH N T IH NG",RUMSFELD="R AH M Z F EH L D",MEBANE="M EH B AH N",LEMOINE="L IH M OY N",FLINGING="F L IH NG IH NG",MCNETT="M AH K N EH T",["DOLLAR'S(3)"]="D AO L ER Z",["X-RAY"]="EH K S R EY",HILLYER="HH IH L IY ER",["CIBA'S(2)"]="S AY B AH Z",["ASPIRIN'S"]="AE S P R AH N Z",REALAMERICA="R IY L AH M EH R IH K AH",MADOC="M AE D AH K",["INSTRUMENTALISTS(2)"]="IH N S T R AH M EH N AH L IH S T S",GODOT="G AH D OW",MCGAHA="M AH G AA HH AH",GARRISONED="G AE R AH S AH N D",ZADOC="Z AA D AH K",KLOOS="K L UW Z",["DATAPOINT(2)"]="D AE T AH P OY N T",ARBELLA="AA R B EH L AH",WRINGING="R IH NG IH NG",WINDSTORM="W IH N D S T AO R M",VESEL="V EH S AH L",COBWEBS="K AA B W EH B Z",FABRIS="F AE B R IH S",CRINGING="K R IH N JH IH NG",BRINGING="B R IH NG IH NG",["HERON'S"]="HH EH R AH N Z",["GRAUER(2)"]="G R UW ER",TRADITIONAL="T R AH D IH SH AH N AH L",EDSEL="EH D S AH L",LITURGY="L IH T ER JH IY",ACCELERATOR="AE K S EH L ER EY T ER",MCNABB="M AH K N AE B",HODGDON="HH AA JH D AH N",["GENCORP'S(2)"]="JH EH N K AO R S",SEASICK="S IY S IH K",JAVELIN="JH AE V AH L AH N",SPINELLI="S P IH N EH L IY",COMPLICITIES="K AH M P L IH S IH T IY Z",RUGEN="R AH G AH N",["ADVANTAGE(3)"]="AE D V AE N IH JH",TEAFORD="T IY F AO R D",CREUTZFELDT="K R UH T S F EH L D",["ONASSIS'"]="OW N AE S IH S",FUNCTIONS="F AH NG K SH AH N Z",HELLYER="HH EH L IY ER",SEAFORD="S IY F ER D",IDUNA="IH D UW N AH",CREDENTIAL="K R IH D EH N CH AH L",DEWOLFE="D UW UH L F",KOCHEVAR="K AH HH EH V ER",ASHBROOK="AE SH B R UH K",EGGEN="EH G AH N",CLINICALLY="K L IH N IH K AH L IY",INCREASING="IH N K R IY S IH NG",EQUITIES="EH K W AH T IY Z",SNEDDEN="S N EH D AH N",REVERSER="R IH V ER S ER",ACUNA="AA K UW N AH",SIMENSON="S IH M IH N S AH N",KUNDINGER="K AH N D IH NG ER",PILOTTE="P IH L AO T",MUNDINGER="M AH N D IH NG ER",ALTERNATIVES="AO L T ER N AH T IH V Z",["LOMA-PRIEDA"]="L OW M AH P R IY EY D AH",VIGEN="V IH G AH N",WIGEN="W IH G AH N",MICHIELS="M AY K AH L Z",KERSEE="K ER S IY",CAKED="K EY K T",BAKED="B EY K T",STULTIFYING="S T AH L T AH F AY IH NG",UNCORKED="AH N K AO R K T",ANATOMY="AH N AE T AH M IY",NAKED="N EY K AH D",BETAKE="B IY T EY K",RAKED="R EY K T",FARINA="F ER IY N AH",ESSELTE="EH S EH L T IY",["OMONIA(2)"]="OW M OW N Y AH",NEEDIER="N IY D IY ER",EIGEN="AY G AH N",CANNAVINO="K AE N AH V IY N OW",INADEQUATELY="IH N AE D AH K W AH T L IY",RETAKE="R IY T EY K",FINUCANE="F IH N AH K EY N",["MOZART(2)"]="M OW T S AA R T",DEMARINO="D IH M AA R IY N OW",DECREASING="D IH K R IY S IH NG",AMPLIFIED="AE M P L AH F AY D",NONFATAL="N AA N F EY T AH L",HOARSENESS="HH AO R S N AH S",LONGER="L AO NG G ER",FONGER="F AO NG ER",DISSECT="D AY S EH K T",CONGER="K AO NG ER",["WORKMEN'S"]="W ER K M AH N Z",["HENRI(2)"]="AO R IY",["BABA'S(2)"]="B AA B AH Z",LAURENTIAN="L AO R EH N SH AH N",CHALFANT="CH AE F AH N T",ANCHONDO="AA N K OW N D OW",MUJAHADEEN="M Y UW JH AE HH AH D IY N",ZUBOFF="Z UW B AO F",SONGER="S AO NG ER",MONGER="M AH NG G ER",BOUNCED="B AW N S T",TELECTRONIC="T EH L AH K T R AA N IH K",NEWSROOM="N UW Z R UW M",COMPORTMENT="K AH M P AO R T M AH N T",KROLAK="K R OW L AH K",["HUNDRED(3)"]="HH AH N ER D",POUNCED="P AW N S T",HAWAII="HH AH W AY IY",PENDERGRAFT="P EH N D ER G R AH F T",ASSAY="AE S IY",LATHROP="L AE TH R AH P",ESSAY="EH S EY",SNEDEGAR="S N EH D IH G ER",ADJUSTMENT="AH JH AH S T M AH N T",MCHAFFIE="M AH K AE F IY",PETERMANN="P IY T ER M AH N",REDWALD="R EH D W AH L D",COLLYER="K AA L IY ER",["PERIGNON(2)"]="P EH R IH G N AA N",CARELLI="K AA R EH L IY",MASERATI="M AE S EH R AA T IY",GIACONDA="JH IY AH K AA N D AH",VANDENBOS="V AE N D AH N B OW Z",["REFUSES(2)"]="R IH F Y UW Z IH Z",["OPEC'S"]="OW P EH K S",MARELLI="M EH R EH L IY",QUICKSAND="K W IH K S AE N D",OTOLOGY="OW T AA L AH JH IY",AMGEN="AE M JH EH N",GROOVER="G R UW V ER",STURTZ="S T ER T S",HESITATION="HH EH Z AH T EY SH AH N",["MINISTER'S"]="M IH N IH S T ER Z",MALTBIE="M AE L T B IY",["APEC'S"]="EY P EH K S",AFFORDS="AH F AO R D Z",["TALESE(2)"]="T AH L IY Z IY",CASSEB="K AE S AH B",HIRSCHBERG="HH ER SH B ER G",DONAWAY="D AA N AH W EY",CONAWAY="K AA N AH W EY",["INVESTED(2)"]="IH N V EH S T IH D",["PUSH-UPS"]="P UH SH AH P S",SHALNEV="SH AA L N EH V",NARDELLI="N AA R D EH L IY",BOLSHEVIST="B OW L SH IH V IH S T",DOEPKE="D OW P K",CELESTORY="S AH L EH S T ER IY",WIEDERAUFBAU="W IY D ER AO F B AW",LOCALITIES="L OW K AE L IH T IY Z",SMOLAK="S M OW L AH K",KOEPKE="K OW P K",FORSEE="F ER S IY",["POINTEDLY(2)"]="P OY N AH D L IY",UROLOGY="Y ER AA L AH JH IY",CONTRARIAN="K AA N T R EH R IY AH N",DEMERITS="D IY M EH R AH T S",LARINA="L AA R IY N AH",BEGUILING="B IH G AY L IH NG",IDENTITIES="AY D EH N T IH T IY Z",NICKNAMED="N IH K N EY M D",LIGHTLE="L AY T AH L",GIACONE="JH IY AH K OW N IY",RAINBOWS="R EY N B OW Z",["DEVINCI'S"]="D IH V IH N CH IY Z",WARONKER="W AO R AA NG K ER",BALMORALS="B AE L M AO R AH L Z",PREPPED="P R EH P T",["NIACIN(2)"]="N AY AH S IH N",["LOS-ANGELES"]="L AO S AE N JH AH L AH S",BIKED="B AY K T",PRECOOK="P R IY K UH K",PITTSLEY="P IH T S L IY",FERRETS="F EH R AH T S",HIKED="HH AY K T",BOTTLENECK="B AA T AH L N EH K",["PERCENTAGE(2)"]="P ER S EH N AH JH",["ROBINS'S"]="R AA B AH N Z IH Z",LIKED="L AY K T",FEEDINGS="F IY D IH NG Z",JULLIARD="JH UW L IY AA R D",["MAGNA'S"]="M AE G N AH Z",BELLHOPS="B EH L HH AA P S",SCHWEBKE="SH W EH B K",WASSILY="V AH S IH L IY",VASSILY="V AH S IH L IY",CHIPSOFT="CH IH P S AO F T",MEROLA="M ER OW L AH",["SRI-LANKA(2)"]="SH R IY L AE NG K AH",["NATIONALISTS(4)"]="N AE SH N AH L IH S",["CAYENNE(2)"]="K EY EH N",HAMMERLE="HH AE M ER AH L",SPITTLE="S P IH T AH L",LACERATION="L AE S ER EY SH AH N",["DIRECTED(2)"]="D ER EH K T IH D",LAMASTUS="L AE M AH S T IH S",STEEPEST="S T IY P AH S T",STEPPED="S T EH P T",RESIGNATION="R EH Z AH G N EY SH AH N",INTAKE="IH N T EY K",["FONTAINEBLEAU(2)"]="F AA N T AH N B L UW",["BERLES'"]="B ER L Z",ATTABOYS="AE T AH B OY Z",SEABOLT="S IY B OW L T",GREGORI="G R EH G AO R IY",OEIEN="OW IY AH N",PURINA="P Y UH R IH N AH",OPTATION="AA P T EY SH AH N",SORCI="S AO R CH IY",["TAYLOR'S"]="T EY L ER Z",QUARANTINED="K W AO R AH N T IY N D",BANASIAK="B AH N AA S IY AE K",ZEIEN="Z AY AH N",JOOSTEN="Y UW S AH N",STATS="S T AE T S",["WANTON(2)"]="W AA N T AH N",LAFRENZ="L AE F R IH N S",["REMAIN(2)"]="R IY M EY N",SHEEDY="SH IY D IY",BRITTLE="B R IH T AH L",PUTDOWNS="P UH T D AW N Z",ADDED="AE D AH D",RUMBLEY="R AH M B L IY",QUIETIST="K W AY AH T AH S T",SUFFICIENT="S AH F IH SH AH N T",MAHANEY="M AH HH EY N IY",GARRETS="G EH R AH T S",VEGETABLES="V EH JH T AH B AH L Z",KNAUER="N AW ER",BEDBUGS="B EH D B AH G Z",UNDERDOG="AH N D ER D AO G",UNLOCKING="AH N L AA K IH NG",DEGRAAF="D EH G R AA F",IGNASIAK="IH G N AA S IY AE K",CIRELLI="S IH R EH L IY",GALERNTER="G AH L ER N T ER",["DARR(2)"]="D AA R",HEMMERLE="HH EH M ER L IY",["INSANITY(2)"]="IH N S AE N IH T IY",STRIKEBREAKERS="S T R AY K B R EY K ER Z",INDIVIDUALITY="IH N D IH V IH JH UW AE L IH T IY",SPASM="S P AE Z AH M",KAREL="K EH R AH L",ORSAY="AO R S EY",PIRELLI="P IH R EH L IY",KALLENBACH="K AE L IH N B AA K",INTELCO="IH N T EH L K OW",DIFRANCESCO="D IH F R AA N CH EH S K OW",INNOPAC="IH N AH P AE K",BUFFOON="B AH F UW N",QUEMOY="K IY M OY",MCHANEY="M AH K AE N IY",["TRIVIALIZES(2)"]="T R IH V Y AH L AY Z IH Z",BLAUER="B L AW R",KLAUER="K L AW ER",KIELBASA="K IY L B AA S AH",CAVITIES="K AE V IH T IY Z",UNMASKED="AH N M AE S K T",PUMILIA="P UW M IY L IY AH",MALMSTROM="M AE L M S T R AH M",OJIBWA="OW JH IH B W AH",IMPRISONED="IH M P R IH Z AH N D",STAEBELL="S T EH B EH L",CHAE="CH AY",STROUTH="S T R AW TH",PAKULSKI="P AH K AH L S K IY",CLOSINGS="K L OW Z IH NG Z",ROTATION="R OW T EY SH AH N",NOTATION="N OW T EY SH AH N",GRAUER="G R AW ER",CORNA="K AO R N AH",BRAUER="B R AW ER",REMOVES="R IY M UW V Z",JASMIN="JH AE Z M IH N",DENDINGER="D IY N D IH NG ER",THIRZA="TH ER Z AH",FIORELLA="F IY AO R EH L AH",NORNA="N AO R N AH",ZIMMERLE="Z IH M ER AH L",["INTERFERED(2)"]="IH N ER F IH R D",["CONCRETE(2)"]="K AA N K R IY T",UNCHARACTERISTIC="AH N K EH R IH K T ER IH S T IH K",LEONORA="L IY AH N AO R AH",LEARNERS="L ER N ER Z",MORNA="M AO R N AH",LORNA="L AO R N AH",POSUVALYUK="P AA S UW V AA L Y UH K",OSTERLOH="OW S T EH R L OW",KIMMERLE="K IH M ER AH L",INFRINGEMENTS="IH N F R IH N JH M AH N T S",LOTHROP="L AA TH R AH P",LEICHTER="L AY K T ER",GROOS="G R UW Z",CITATION="S AY T EY SH AH N",["DARDEN'S"]="D AA R D AH N Z",SHALOM="SH AH L OW M",PREPONDERANCE="P R IY P AA N D R AH N S",SEXIER="S EH K S IY ER",["HARDEN'S"]="HH AA R D AH N Z",AEROLINEAS="EH R OW L IH N IY AH S",BEBBITS="B EH B AH T S",MCRAY="M AH K R EY",KRAUER="K R AW R",DEKUYPER="D IH K AY P ER",["PROTECTIVE(2)"]="P ER T EH K T IH V",SIDED="S AY D AH D",CONVERSED="K AH N V ER S T",OSTERMANN="AA S T ER M AH N",FORESTALLS="F AO R S T AO L Z",["O'STEEN"]="OW S T IY N",UNCORKS="AH N K AO R K S",["DIGITAL'S"]="D IH JH AH T AH L Z",SISTERHOOD="S IH S T ER HH UH D",CONCUBINE="K AA N K Y AH B AY N",["LITTLER(2)"]="L IH T L ER",AIDED="EY D AH D",HANAWAY="HH AE N AH W EY",GANAWAY="G AE N AH W EY",["REGULATOR'S"]="R EH G Y AH L EY T ER Z",SPEEDY="S P IY D IY",KILLJOY="K IH L JH OY",KRISHNAN="K R IH SH N AH N",SPATAFORE="S P AE T AH F AO R",KUZNIA="K AH Z N IY AH",CINNAMINSON="S IH N AH M IH N S AH N",["VOLVO'S"]="V OW L V OW Z",ATTERMANN="AE T ER M AH N",PAVAO="P AA V AW",HODGMAN="HH AA JH M AH N",["WHOLESALER'S"]="HH OW L S EY L ER Z",RABBITS="R AE B AH T S",ELLETT="EH L IH T",SMITTLE="S M IH T AH L",ARACHNID="AH R AE K N AH D",["CHATIHACHI'S"]="CH AE T IH HH AA CH IY Z",DISCUSSIONS="D IH S K AH SH AH N Z",HUEBSCH="HH UH B SH",SLALOM="S L AA L AH M",ADAPTEC="AH D AE P T EH K",BRAE="B R EY",BEDPAN="B EH D P AE N",DAVAO="D AH V OW",INSEL="IH N S AH L",ANSEL="AH N S EH L",OSMIUM="AA Z M IY AH M",ENGEN="EH NG AH N",ALGOM="AE L G AH M",AIRBOATS="EH R B OW T S",MOSEL="M OW S AH L",COMFINANCE="K AA M F IH N AH N S",KOSEL="K OW S AH L",CORDONE="K AO R D AH N",MIKULSKI="M IH K AH L S K IY",LANGFELDT="L AE NG F EH L T",MCCULLEY="M AH K AH L IY",CEDED="S IY D AH D",CHASM="K AE Z AH M",["LANCASTER(2)"]="L AE NG K AH S T ER",BOGEN="B AA G AH N",MEDOC="M EH D AO K",CIESLEWICZ="CH EH S L IH V IH CH",HOGEN="HH AA G AH N",FREIGHTWAY="F R EY T W EY",SORRELS="S AO R AH L Z",MARSEE="M AA R S IY",KNITTLE="N IH T AH L",CORINA="K AO R IY N AH",["GETTLER(2)"]="G EH T L ER",PENNBANCORP="P EH N B AE N K AO R P",["KETTLER(2)"]="K EH T L ER",IRREVOCABLE="IH R EH V AH K AH B AH L",POLTERGEISTS="P OW L T ER G AY S T S",["ILLINOIS(2)"]="IH L AH N OY Z",ROBAINA="R OW B EY N AH",CORKILL="K AO R K IH L",LYRICISM="L IH R IH S IH Z AH M",["BRANDS'S"]="B R AE N D Z IH Z",LINDSLEY="L IH N D S L IY",BROCKHAUS="B R AA K HH AW S",RASTEROP="R AE S T ER AA P",PROVINCES="P R AA V AH N S AH Z",ALLENSBACH="AE L AH N Z B AA K",DELIVERANCE="D IH L IH V ER AH N S",COLVER="K OW L V ER",HAGE="HH EY JH",GAGE="G EY JH",LAGE="L EY JH",KAGE="K EY JH",ANNOUNCES="AH N AW N S IH Z",PLAISTED="P L AA IH S T IH D",ANACONDA="AE N AH K AA N D AH",CAGE="K EY JH",ABRAMS="EY B R AH M Z",ULCERATION="AH L S ER EY SH AH N",WAGE="W EY JH",NEIGHBORING="N EY B ER IH NG",CHIMPANZEE="CH IH M P AE N Z IY",["GUTHRIE'S"]="G AH TH R IY Z",SAGE="S EY JH",RAGE="R EY JH",BIRTLEY="B ER T L IY",CONIFERS="K AA N AH F ER Z",GUTHRIE="G AH TH R IY",["%PERCENT"]="P ER S EH N T",FATWA="F AA T W AA",["MENACHEM(2)"]="M EH N AH HH EH M",PERFECTION="P ER F EH K SH AH N",CREDIBILITY="K R EH D AH B IH L IH T IY",JANOFF="JH AE N AO F",DECODE="D IH K OW D",INCREASE="IH N K R IY S",POSTSCRIPTS="P OW S K R IH P T S",MANOFF="M AE N AO F",BRIDGEMAN="B R IH JH M AH N",["FLUORESCENTS(2)"]="F L AO R EH S AH N T S",PUCCIARELLI="P UW CH ER EH L IY",SHIBLEY="SH IH B L IY",HANDELMAN="HH AE N D AH L M AH N",PERUSING="P ER UW Z IH NG",EVACUATION="IH V AE K Y AH W EY SH AH N",WOODWIND="W UH D W IH N D",["ENORMOUS(2)"]="IH N AO R M IH S",CIACCIO="CH AO CH IY OW",RESERVEESE="R EH Z ER V IY S",CINEPLEX="S IH N AH P L EH K S",["ADVERTISERS'"]="AE D V ER T AY Z ER Z",BUFE="B Y UW F",DIGIOVANNA="D IH JH OW V AA N AH",OFTEL="AA F T EH L",CHERNEY="CH ER N IY",VOCALLY="V OW K AH L IY",HUGHY="HH Y UW IY",["FROM(2)"]="F ER M",FUDOSAN="F Y UW D AH S AA N",RUFE="R UW F",GERIATRICIANS="JH EH R IY AH T R IH SH AH N Z",["ARENA'S"]="ER IY N AH Z",ACTEL="AE K T EH L",CLEVENGER="K L EH V IH N JH ER",GLECKLER="G L EH K L ER",SOKOLIN="S AA K AH L IH N",FORNES="F AO R N Z",CLECKLER="K L EH K L ER",OPERATIVES="AA P ER AH T IH V Z",KUPPER="K AH P ER",IMPISH="IH M P IH SH",ANESTHESIOLOGISTS="AE N AH S TH IY Z IY AA L AH JH AH S T S",BRESNAHAN="B R EH S N AH HH AE N",SUPPER="S AH P ER",FACELIFT="F EY S L IH F T",TUPPER="T AH P ER",HOLLENBECK="HH AA L AH N B EH K",VANWIE="V AE N W IY",TURBULENCE="T ER B Y AH L AH N S",ZORNES="Z AO R N Z",DISPUTATION="D IH S P Y UW T EY SH AH N",WESTGATE="W EH S T G EY T",CARL="K AA R L",["SUBORDINATE(2)"]="S AH B AO R D AH N AH T",EARL="ER L",DELOSREYES="D IH L AA S ER AY Z",GARL="G AA R L",INTERPUBLIC="IH N T ER P AH B L IH K",HARL="HH AA R L",KARL="K AA R L",["WHAT(2)"]="HH W AH T",BREININGER="B R AY N IH NG ER",["AVAILABILITY(2)"]="AH V EY L AH B IH L IH T IY",PROMOTED="P R AH M OW T AH D",TIERNEY="T IH R N IY",MALACANANG="M AH L AE K AH N AE NG",REHYDRATE="R IY HH AY D R EY T",MOISTEN="M OY S AH N",RAUSCHENBERG="R AW SH AH N B ER G",SHARP="SH AA R P",PYTEL="P IH T AH L",JEANIE="JH IY N IY",ELYSEE="EH L IH S IY",LIFE="L AY F",CAROUSING="K ER AW Z IH NG",DENOUNCES="D IH N AW N S IH Z",SEMIOTIC="S EH M IY AA T IH K",MUTUALITY="M Y UW CH UW AE L IH T IY",WIFE="W AY F",MOTYKA="M AA T AY K AH",SUBSIDIZE="S AH B S IH D AY Z",RENOUNCES="R IH N AW N S IH Z",FIFE="F AY F",STARVED="S T AA R V D",ORIENTATED="AO R IY AH N T EY T IH D",BULLISHNESS="B UH L IH SH N AH S",HAYMOND="HH EY M AH N D",BOULALAS="B UW L AH L AH S",CURRICULUM="K ER IH K Y AH L AH M",RAYMOND="R EY M AH N D",["DIVISIONS'"]="D IH V IH ZH AH N Z",GARTLEY="G AA R T L IY",BOHLEN="B OW L AH N",["CANISTERS(2)"]="K AE N IH S T ER Z",DEGRADE="D IH G R EY D",["SCHEDULES(2)"]="S K EH JH UW L Z",BARTLEY="B AA R T L IY",BLAESING="B L EH S IH NG",FELVER="F EH L V ER",NOBLETT="N AA B L IH T",NESMITH="N EH Z M IH TH",FORAMEN="F ER EY M AH N",NITRILES="N AY T R AH L Z",HOPEFULLY="HH OW P F AH L IY",CLAPBOARD="K L AE P B AO R D",["RAJALA(2)"]="R AA JH AA L AH",GAMEST="G EY M AH S T",SURVIVED="S ER V AY V D",SLAVINSKI="S L AH V IH N S K IY",["C.D.S"]="S IY D IY Z",OVERHOLTZER="OW V ER HH OW L T Z ER",ORNOFF="AO R N AA F",ALLEGRO="AH L EH G R OW",DESMITH="D EH S M IH TH",GLISTEN="G L IH S AH N",ARMORIES="AA R M ER IY Z",BICYCLISTS="B AY S IH K L IH S T S",MENENDEZ="M EH N EH N D EH Z",GRONAU="G R OW N AW",SHADINGS="SH EY D IH NG Z",STECKLER="S T EH K L ER",HARASSMENT="HH ER AE S M AH N T",ERUPTING="IY R AH P T IH NG",CREDENTIALS="K R AH D EH N SH AH L Z",IMPACTED="IH M P AE K T IH D",COAXUM="K OW K S AH M",BELLIVEAU="B EH L IH V OW",CAPTIVES="K AE P T IH V Z",SYNDROMES="S IH N D R OW M Z",SOFTEN="S AA F AH N",["ANTICANCER(2)"]="AE N T IY K AE N S ER",FALSTAFF="F AO L S T AE F",SYNDICATION="S IH N D IH K EY SH AH N",MARELDA="M AA R EH L D AH",YOUNGBERG="Y AH NG B ER G",DASTARDLY="D AE S T ER D L IY",["HERBARIUMS(2)"]="ER B EH R IY AH M Z",SOLICITED="S AH L IH S IH T IH D",KERNES="K ER N Z",FEDERSPIEL="F EH D ER S P IY L",AUTOMATICS="AO T AH M AE T IH K S",FINGERPRINTING="F IH NG G ER P R IH N T IH NG",BLITZER="B L IH T S ER",["PALACES(2)"]="P AE L AH S IH Z",ADJOURNS="AH JH ER N Z",BRANDA="B R AE N D AH",BARRELS="B AE R AH L Z",["MANHATTAN'S"]="M AE N HH AE T AH N Z",GARRELS="G AE R AH L Z",VERNES="V ER N Z",GRANDA="G R AE N D AH",OPINIONATE="AH P IH N Y AH N EY T",HOTEL="HH OW T EH L",["COUNTERMEASURE(2)"]="K AW N ER M EH ZH ER",PROTECTEES="P R AH T EH K T IY Z",SHURTZ="SH ER T S",OUTLIVING="AW T L IH V IH NG",BATHTUB="B AE TH T AH B",CASSIA="K AE SH IY AH",MAHEN="M EY HH EH N",AGROINDUSTRIAL="AE G R OW IH D AH S T R IY AH L",REVEREND="R EH V ER AH N D",["BARRON'S(2)"]="B EH R AH N Z",MCGOURTY="M AH G UH R T IY",["INVOLUNTARILY(2)"]="IH N V AA L AH N T ER AH L IY",["ERASED(2)"]="IY R EY S T",INCOMPREHENSIBLY="IH NG K AA M P R AH HH EH N S IH B L IY",["HERMINA(2)"]="HH ER M IY N AH",MUDDIED="M AH D IY D",BEAUFORT="B OW F ER T",ARTICULATION="AA R T IH K Y AH L EY SH AH N",STEALER="S T IY L ER",RWANDA="R AH W AA N D AH",SWANDA="S W AA N D AH",["ARROW(2)"]="EH R OW",CUTESINESS="K Y UW T S IY N IH S",["MINISTERS(2)"]="M IH N IH S T ER Z",PEZESHKAN="P AH Z EH SH K AH N",INTERMOUNTAIN="IH N T ER M AW N T IH N",HUFSTEDLER="HH AH F S T IH D AH L ER",RUNAWAY="R AH N AH W EY",UNSURPRISINGLY="AH N S ER P R AY Z IH NG L IY",HLAVAC="HH L AA V AH K",["BENDEL(2)"]="B EH N D EH L",ENCODE="EH N K OW D",["TATARSTAN(2)"]="T AA T AA R S T AE N",RAPHEL="R AE F AH L",SPITZER="S P IH T Z ER",["INTELLECTUALISM(2)"]="IH N EH L AH K CH UW AH L IH Z AH M",CHRISTIAN="K R IH S CH AH N",INDEMNIFY="IH N D EH M N AH F AY",HADLEIGH="HH AE D L AH",TWANGY="T W AA N JH IY",ESTEL="EH S T AH L",SURPASS="S ER P AE S",ISTEL="IH S T EH L",EQUITATION="EH K W AH T EY SH AH N",DEARMENT="D IH R M AH N T",INFALLIBLE="IH N F AE L AH B AH L",SCOUTER="S K AW T ER",AMANDA="AH M AE N D AH",LUEPKE="L UW P K IY",["SOFTEN(2)"]="S AO F AH N",PERSONIFICATION="P ER S AA N AH F AH K EY SH AH N",["MANILA'S"]="M AH N IH L AH Z",CHEAPSKATE="CH IY P S K EY T",WHALEN="W EY L AH N",HARVESTED="HH AA R V AH S T AH D",PUREBRED="P Y UH R B R EH D",["BURKINA-FASO'S"]="B ER K IY N AH F AA S OW Z",MCCARNEY="M AH K AA R N IY",BURHAM="B ER HH AH M",BLANDA="B L AE N D AH",PFINGSTEN="F IH NG S T AH N",STOPLIGHTS="S T AA P L AY T S",ELAPSE="IH L AE P S",PHALEN="F AE L AH N",PROGRESSING="P R AH G R EH S IH NG",DURHAM="D ER AH M",CAPITALS="K AE P AH T AH L Z",AMERICORPS="AH M EH R IH K AO R",AMOROSI="AA M AO R OW S IY",["MALATHION(2)"]="M AH L AE TH IY AH N",WADLEIGH="W AO D L IY",FACIALS="F EY SH AH L Z",DUNAWAY="D AH N AH W EY",BINSTOCK="B IH N S T AA K",BLECHLEY="B L EH K L IY",MALCOLM="M AE L K AH M",HISEL="HH IH S AH L",STEVENA="S T EH V IH N AH",MCELRAVY="M AE K AH L R EY V IY",UNKEMPT="AH N K EH M P T",WISEL="W AY Z AH L",REFUSENIKS="R IH F Y UW Z N IH K S",CARILOU="K EH R AH L UW",["EARLESS(2)"]="IY R L AH S",SLATS="S L AE T S",COUNSELLOR="K AW N S AH L ER",SCHUPP="SH AH P",SHELDON="SH EH L D AH N",MODJESKI="M AH JH EH S K IY",ANAWALT="AE N AH W AA L T",["PEIRCE(2)"]="P IY R S",["ACKNOWLEDGEMENT(2)"]="IH K N AA L IH JH M AH N T",["KNOLL'S"]="N OW L Z",TELEPHONIQUES="T EH L AH F AA N IY K S",["CONSTANTINIDES(2)"]="K AA N S T AE N T AH N IY D IY Z",BISEL="B IH S AH L",EISEL="AY S AH L",STEININGER="S T AY N IH NG ER",MAGTEN="M AE G T EH N",GNATS="N AE T S",CURIALE="K UH R IY AA L IY",UNDERUTILIZE="AH N D ER Y UW T AH L AY Z",POKED="P OW K T",JOKED="JH OW K T",SZELIGA="SH IH L AY G AH",SCHEUERMANN="SH OY ER M AH N",GOATS="G OW T S",MOATS="M OW T S",["CAVAZOS(2)"]="K AE V AH Z OW S",INDOCTRINATION="IH N D AA K T R AH N EY SH AH N",COATS="K OW T S",BOATS="B OW T S",["CONRAIL'S"]="K AA N R EY L Z",["RECLINING(2)"]="R IY K L AY N IH NG",MORONES="M AO R OW N EH S",BENSTOCK="B EH N S T AA K",SMARTLY="S M AA R T L IY",GASKILL="G AE S K IH L",SCHELLHORN="SH EH L HH ER N",GORHAM="G AO R AH M",BONNEVILLES="B AA N AH V IH L Z",ROKAHR="R OW K AA R",BYRNES="B ER N Z",COUNCILMEN="K AW N S AH L M EH N",DIURETIC="D AY UW R EH T IH K",["TOLSTOY'S"]="T OW L S T OY Z",DUKED="D UW K T",JUNOT="JH UW N AH T",LUTECIA="L UW T IY SH Y AH",["POGROM(2)"]="P OW G R AH M",WORTLEY="W ER T L IY",SHEDDEN="SH EH D AH N",LUANDA="L UW AA N D AH",["ROBERTS'S"]="R AA B ER T S IH Z",SECULARIST="S EH K Y AH L ER IH S T",LIBERATION="L IH B ER EY SH AH N",HAMISH="HH AE M IH SH",["STYLIZE(2)"]="S T AY AH L AY Z",["ZEITLER(2)"]="Z AY T L ER",BLOMSTROM="B L AA M S T R AH M",INTEL="IH N T EH L",["MARQUAI(2)"]="M AA R K EY",STANDA="S T AE N D AH",WIECZOREK="V IY CH AO R EH K",AFFRONTING="AH F R AH N T IH NG",BRATS="B R AE T S",LAROCCA="L AA R OW K AH",REPTILES="R EH P T AY L Z",["BEITLER(2)"]="B AY T L ER",BUFFETING="B AH F EY IH NG",COVATTA="K OW V AA T AH",MISMANAGEMENT="M IH S M AE N IH JH M AH N T",FRANDSEN="F R AE N D S AH N",PRATS="P R AE T S",ASKED="AE S K T",CREMATION="K R IY M EY SH AH N",["BANCA(2)"]="B AA NG K AH",FICIALS="F IH SH AH L Z",["SEMIFINALS(2)"]="S EH M IH F AY N AH L Z",BOOKSTANDS="B UH K S T AE N D Z",TOSTADO="T OW S T AA D OW",SCRUTON="S K R UW T AH N",IRKED="ER K T",KLADSTRUP="K L AE D S T R AH P",FREUNDLICH="F R OY N D L IH K",["GANDHI'S"]="G AA N D IY Z",["HYPERBARIC(2)"]="HH AY P ER B AE R IH K",["GRANDMOTHERS(3)"]="G R AE M AH DH ER Z",FOUSHEE="F AW SH IY",NERL="N ER L",MERL="M ER L",PERL="P ER L",BURNES="B ER N Z",KERL="K ER L",SAEED="S AA IY D",HERL="HH ER L",MEALYNOSE="M IY L IY N OW Z",ORSOLA="AO R S OW L AH",UNIMPRESSIVE="AH N IH M P R EH S IH V",EDIT="EH D AH T",DEMISH="D EH M IH SH",UPGRADE="AH P G R EY D",["WEDNESDAYS(2)"]="W EH N Z D IY Z",DEPINA="D IH P IY N AH",URSOLA="ER S OW L AH",GALLIER="G AE L IY ER",HOLAWAY="HH OW L AH W EY",BRENTANO="B R EH N T AA N OW",ALLENTON="AE L AH N T AH N",HATLESTAD="HH AE T AH L S T AH D",KALUGIN="K AH L UW G AH N",INDEXER="IH N D EH K S ER",VECCHIARELLI="V EH K IY AA R EH L IY",["GREENS'"]="G R IY N Z",UNELECTABLE="AH N IH L EH K T AH B AH L",MCGRIFF="M AH G R IH F",DECAPITATED="D IY K AE P AH T EY T IH D",BAPNA="B AA P N AH",SCHOOLTEACHERS="S K UW L T IY CH ER Z",LENDING="L EH N D IH NG",TRILOGY="T R IH L AH JH IY",FENDING="F EH N D IH NG",ELFRINK="EH L F R IH NG K",CHAPDELAINE="SH AE P D IH L EY N",CONTEND="K AH N T EH N D",COOPER="K UW P ER",SACCONE="S AA K OW N IY",BERKHEIMER="B ER K HH AY M ER",EVENNESS="IY V AH N N AH S",BILELLO="B IH L EH L OW",DILELLO="D IH L EH L OW",["REPLIED(2)"]="R IY P L AY D",GRAHAMS="G R AE M Z",["CENTERS(2)"]="S EH N ER Z",VALORES="V AH L AO R EH Z",["MICROBIOLOGISTS(2)"]="M AY K R OW B IY AA L AH JH IH S",RENDING="R EH N D IH NG",AZIDOTHYMIDINE="AH Z IH D AH TH AY M AH D IY N",SENDING="S EH N D IH NG",LALLIER="L AE L IY ER",MENDING="M EH N D IH NG",PENDING="P EH N D IH NG",COMDEX="K AA M D AH K S",HYPOCRITES="HH IH P AH K R IH T S",PRETENDED="P R IY T EH N D AH D",INGLETT="IH NG G L EH T",CYPHERS="S AY F ER Z",["WYOMING'S"]="W AY OW M IH NG Z",SNOWFALL="S N OW F AA L",["PAPON'S"]="P AE P AO N Z",SHUWA="SH UW W AH",PRESTWOOD="P R EH S T W UH D",["PALMER(2)"]="P AA L M ER",["FOCUS(2)"]="F OW K IH S",LEAPING="L IY P IH NG",INTERMARRIED="IH N T ER M AE R IY D",HEAPING="HH IY P IH NG",NAUSEATED="N AO Z IY EY T AH D",KAMRADT="K AE M R AH T",["INNOVATION(2)"]="IH N OW V EY SH AH N",["RESCINDED(3)"]="R IY S IH N D IH D",LATHAM="L AE TH AH M",FLOTSAM="F L AA T S AH M",SECTS="S EH K T S",SQUIRREL="S K W ER AH L",ENTRAIL="EH N T R AH L",MELUGIN="M EH L AH G IH N",CHEESIER="CH IY Z IY ER",["ELEANOR'S"]="EH L AH N AO R Z",["EX-VOTO"]="EH K S V OW T OW",VELAGRANDE="V EH L AH G R AA N D EY",PROPER="P R AA P ER",SARDINAS="S AA R D IH N AH Z",FAUL="F AO L",ABRUPT="AH B R AH P T",DAUL="D AO L",KAUL="K AO L",HAUL="HH AO L",MAUL="M AO L",AGOSTINI="AA G OW S T IY N IY",SAUL="S AO L",DELORES="D AH L AO R IH S",["SERVICES(2)"]="S ER V IH S IH Z",CONSEQUENCE="K AA N S AH K W AH N S",MADAY="M AA D EY",CONVINCES="K AH N V IH N S IH Z",COMMENTING="K AA M EH N T IH NG",CAUL="K AA L",NIKOVSKI="N IH K AA F S K IY",CRECHES="K R EH SH AH Z",COACHES="K OW CH IH Z",BURNDY="B ER N D IY",DRIFTNET="D R IH F T N EH T",GRAJEDA="G R AY IY D AH",GODFATHERS="G AA D F AA DH ER Z",SCHOLTEN="SH OW L T AH N",KOPPER="K AA P ER",OUTBID="AW T B IH D",HUSSONG="HH AH S AO NG",COPPER="K AA P ER",BOPPER="B AA P ER",["ALLIANCES(2)"]="AH L AY AH N S IH Z",["INTERVIEWING(2)"]="IH N ER V Y UW IH NG",ROACHES="R OW CH IH Z",ABBOT="AE B AH T",BERUMEN="B IH R UW M EH N",RYDZEWSKI="R IH JH EH F S K IY",NIBLETT="N IH B L IH T",HOEPFNER="HH OW P F N ER",GERSTEN="G ER S T AH N",APACHES="AH P AE CH IY Z",ACQUAINTANCES="AH K W EY N T AH N S IH Z",AUTOMAKER="AO T OW M EY K ER",KERSTEN="K ER S T AH N",["BAUMHARDT(2)"]="B AA M HH AA R T",PUOPOLO="P W OW P OW L OW",LIVOR="L IH V AO R",["VICINITY(2)"]="V IH S IH N IH T IY",["DIANA'S"]="D AY AE N AH Z",EXPLOITIVE="IH K S P L OY T IH V",DELAINE="D IH L EY N",OUAGA="W AA G AH",CORL="K AO R L",TWEED="T W IY D",WORTHOG="W AO R T HH AO G",ATLANTANS="AE T L AE N T AH N Z",CICCONE="CH IY K OW N IY",REPTILIAN="R EH P T IH L Y AH N",STRICKLAND="S T R IH K L AH N D",INSUFFICIENTLY="IH N S AH F IH SH AH N T L IY",NARROWER="N EH R OW ER",SNITZER="S N IH T Z ER",HARROWER="HH AE R OW W ER",PICCONE="P IY K OW N IY",COMPUTE="K AH M P Y UW T",NEOCLASSIC="N IY OW K L AE S IH K",INTERLEAF="IH N T ER L IY F",SUIT="S UW T",PINCKARD="P IH NG K ER D",["ECKERT'S"]="EH K ER T S",QUIT="K W IH T",DIVERGING="D AY V ER JH IH NG",PHEROMONES="F EH R AH M OW N Z",HISSONG="HH IH S AO NG",ROBOT="R OW B AA T",JEOPARDIZED="JH EH P ER D AY Z D",EXIT="EH G Z IH T",BORGWARDT="B AO R G W AO R T",PATERNALISTIC="P AH T ER N AH L IH S T IH K",BARTOLOMEI="B AA R T OW L OW M EY IY",GIRL="G ER L",NEBLETT="N EH B L IH T",CAREERISTS="K ER IH R IH S T S",EQUATION="IH K W EY ZH AH N",PREDOMINATING="P R IH D AA M AH N EY T IH NG",DEVOR="D IH V AO R",KIRSTEN="K ER S T AH N",["ILANA'S"]="IH L AA N AH Z",DECOMPOSING="D IY K AH M P OW Z IH NG",["WHERLEY(2)"]="HH W ER L IY",["PLATINUM'S"]="P L AE T AH N AH M Z",AGREEMENT="AH G R IY M AH N T",["LIZARD'S"]="L IH Z ER D Z",SCHMIERER="SH M AY ER ER",SIOBHAN="SH AW B AA N",CONDONED="K AH N D OW N D",SHUNNED="SH AH N D",ARNOTTS="AA R N AA T S",MANUELA="M AE N W EY L AH",BRIT="B R IH T",SOTOMAYOR="S OW T OW M EY AO R",STIMULATED="S T IH M Y AH L EY T AH D",REPRESENTATIVE="R EH P R AH Z EH N T AH T IH V",WESTLEY="W EH S T L IY",FREED="F R IY D",KINGON="K IH NG AO N",CREED="K R IY D",BREED="B R IY D",MOVIEMAKERS="M UW V IY M EY K ER Z",GRIT="G R IH T",IRIT="IH R IH T",LICENSEE="L AY S AH N S IY",CONFUSIONS="K AH N F Y UW ZH AH N Z",GREED="G R IY D",FRAGA="F R AA G AH",OTHELLO="AH TH EH L OW",ADORABELLE="AE D ER AH B AH L",CLEANSING="K L EH N Z IH NG",KRITZER="K R IH T Z ER",VAGABOND="V AE G AH B AA N D",ALDACO="AA L D AA K OW",CONSULT="K AH N S AH L T",BRAGA="B R AA G AH",LOSCHIAVO="L OW S K IY AA V OW",CONVERSATIONALIST="K AA N V ER S EY SH AH N AH L AH S T",VANCUREN="V AE N K Y UW R AH N",CORBET="K AO R B IH T",LOFT="L AO F T",CONRADT="K AA N R AE T",MATTIAS="M AE SH AH Z",LYONDELL="L AY AH N D EH L",HURL="HH ER L",BURL="B ER L",KIOSKS="K IY AO S K S",STEINBECK="S T AY N B EH K",CALAWAY="K AA L AH W EY",SPIRITUALLY="S P IH R IH CH AH W AH L IY",TOFT="T AA F T",SOFT="S AA F T",SPEED="S P IY D",["GHANA'S"]="G AE N AH Z",["DOMTAR'S"]="D AA M T ER Z",["DETECTED(2)"]="D IH T EH K T IH D",MITOCHONDRIA="M AY T AH K AA N D R IY AH",CABOT="K AE B AH T",INSINUATIONS="IH N S IH N Y UW EY SH AH N Z",BENZES="B EH N Z IH Z",SAVOR="S EY V ER",SORBET="S AO R B EY",["ENDOWMENT'S"]="EH N D AW M AH N T S",["BETABIA(2)"]="B AH T AE B IY AH",KETOLA="K EH T AH L AH",GRANDIN="G R AE N D IH N",BIALKOWSKI="B IY AH L K AW S K IY",FIALKOWSKI="F IY AH L K AO F S K IY",FAVOR="F EY V ER",HARRISBURG="HH AE R IH S B ER G",RIPPER="R IH P ER",LUFT="L AH F T",LIPPER="L IH P ER",KIPPER="K IH P ER",NIPPER="N IH P ER",SNEEZING="S N IY Z IH NG",FAGEN="F AE G AH N",GAGEN="G AE G AH N",DAGEN="D AE G AH N",EAGEN="IY G AH N",TIPPER="T IH P ER",CAPELLI="K AH P EH L IY",["GOLDSTEIN(2)"]="G OW L D S T IY N",["LUNTZ'S"]="L AH N T S IH Z",OVERDID="OW V ER D IH D",KNEED="N IY D",GIPPER="G IH P ER",FROGS="F R AA G Z",TUFT="T AH F T",DIPPER="D IH P ER",ARABIANS="AH R EY B IY AH N Z",ARMITAGE="AA R M IH T IH JH",IMPERSONATOR="IH M P ER S AH N EY T ER",MCCABE="M AH K EY B",ORGANICALLY="AO R G AE N IH K L IY",DISOBEDIENCE="D IH S AH B IY D IY AH N S",WEISBACH="W AY S B AA K",["SERENELY(2)"]="S ER IY N L IY",RAGEN="R AE G AH N",RADICALS="R AE D AH K AH L Z",LEDAY="L IY D EY",DURBEN="D ER B AH N",WURL="W ER L",HALLENBECK="HH AO L AH N B EH K",DOMINICAN="D AH M IH N AH K AH N",RADIALS="R EY D IY AH L Z",["FOMON'S"]="F OW M AH N Z",VARNES="V AA R N Z",WARNES="W AO R N Z",["DISNEY'S"]="D IH Z N IY Z",BLEED="B L IY D",BONNOR="B AA N ER",CONNOR="K AA N ER",PROPAGANDISTIC="P R AA P AH G AH N D IH S T IH K",["FELDSTEIN(2)"]="F EH L D S T IY N",["FRANKFURT'S"]="F R AE NG K F ER T S",FARNES="F AA R N Z",GARNES="G AA R N Z",SHAMELESSLY="SH EY M L AH S L IY",KARNES="K AA R N Z",BERNHEIM="B ER N HH AY M",ROHLFING="R OW L F IH NG",PARNES="P AA R N Z",OVERTURNED="OW V ER T ER N D",THOMISON="TH AA M IH S AH N",BARNES="B AA R N Z",CARNES="K AA R N Z",CONQUESTS="K AA N K W EH S T S",LEPPER="L EH P ER",PEPPER="P EH P ER",CHANCELLOR="CH AE N S AH L ER",CRUEL="K R UW AH L",["PRODUCTION(3)"]="P ER D AH K SH AH N",GRUEL="G R UW IH L",DEGEN="D EH G AH N",CUTTHROAT="K AH T TH R OW T",FREEZING="F R IY Z IH NG",FALCONS="F AE L K AH N Z",["STATISTICS'"]="S T AH T IH S T IH K S",PRIDEAUX="P R IH D OW",HEPPER="HH EH P ER",AVRETT="AE V R EH T",BANDING="B AE N D IH NG",KOENIG="K ER N IH G",REGINALD="R EH JH AH N AH L D",HOENIG="HH OW N IH G",HANDING="HH AE N D IH NG",FLAVORISTS="F L EY V ER IH S T S",LANDING="L AE N D IH NG",HUGOTON="HH Y UW G OW T AH N",REGEN="R EH G AH N",SANDING="S AE N D IH NG",MURPHY="M ER F IY",BOENIG="B OW N IH G",BEDDOW="B EH D OW",SKONIECZNY="S K AH N IY CH N IY",SKIT="S K IH T",KINARK="K IH N AA R K",WHEEZING="W IY Z IH NG",CONNOTATION="K AA N AH T EY SH AH N",ASCOT="AE S K AA T",HEARTWISE="HH AA R T W AY Z",FELICITOUS="F IH L IH S AH T AH S",CLOGS="K L AA G Z",DECREASE="D IH K R IY S",["WELCH'S"]="W EH L CH IH Z",HIJACKINGS="HH AY JH AE K IH NG Z",FYFE="F AY F",BERUDI="B AH R UW D IY",PASCUA="P AA S K UW AH",NAVISTAR="N AE V IH S T AA R",FLIT="F L IH T",BERGERMAN="B ER G ER M AH N",SFFED="S F EH D",REIT="R AY T",REAWAKENED="R IY AH W EY K AH N D",SERAPHIM="S ER AA F IY M",["TCHAIKOVSKY(2)"]="CH AY K AA V S K IY",["SCHICKLER(2)"]="SH IH K L ER",KOVACEVICH="K AH V AA CH IH V IH CH",VARIABLY="V EH R IY AH B L IY",BEIT="B EY T",BEARISHLY="B EH R IH SH L IY",RESTREPO="R EH S T R EH P OW",PATHOGENIC="P AE TH AH JH EH N IH K",HEIT="HH AY T",FEIT="F AY T",PROFUSION="P R AH F Y UW ZH AH N",NISBET="N IH Z B AH T",GLOBALLY="G L OW B AH L IY",LUDWIG="L AH D W IH G",CONDOMINIUMS="K AA N D AH M IH N IY AH M Z",SPLAINE="S P L EY N",SCHLOTZHAUER="SH L AA T S HH AW ER",PARADISE="P EH R AH D AY S",HADDOW="HH AE D OW",REALIZE="R IY AH L AY Z",APODACA="AA P OW D AA K AH",EITEL="AY T AH L",BORROWER="B AA R OW ER",MAGNETEK="M AE G N EH T EH K",MAGICAL="M AE JH IH K AH L",["GAGLIARDI(2)"]="G AE G L IY AA R D IY",MITEL="M AY T EH L",["ZIESKE(2)"]="Z IY S K IY",DILLENBECK="D IH L AH N B EH K",AMEXCO="AH M EH K S K OW",SHAPING="SH EY P IH NG",MONARCHISTS="M AA N AA R K IH S T S",STIRRUPS="S T ER AH P S",LAGUARDIA="L AH G W AA R D IY AH",WELCOME="W EH L K AH M",MENSTRUATE="M EH N S T R UW EY T",MISTLETOE="M IH S AH L T OW",CRIMINALIST="K R IH M AH N AH L IH S T",POWDERY="P AW D ER IY",GELETT="JH EH L IH T",ILLIQUIDITY="IH L IH K W IH D IH T IY",["ELECTRICIANS'"]="IH L EH K T R IH SH AH N Z",CLUBHOUSE="K L AH B HH AW S",BLONDELL="B L AA N D AH L",COSTLEY="K AA S T L IY",SKEPTICAL="S K EH P T AH K AH L",FEVERISHLY="F EH V ER IH SH L IY",TELETYPES="T EH L AH T AY P S",MATOLA="M AH T OW L AH",ORESKOVICH="AO R EH S K AH V IH CH",SUBLETT="S UW B L IH T",CHIT="CH IH T",RAIT="R EY T",TAIT="T EY T",["SIMON'S"]="S AY M AH N Z",PRITZKER="P R IH T S K ER",HONORARIA="AA N ER EH R IY AH",LAIT="L EY",BARFKNECHT="B AA R F K N EH K T",PAIT="P EY T",BAIT="B EY T",HARMATTAN="HH AA R M AH T AE N",FAIT="F EY T",GAIT="G EY T",["AIX-EN-PROVENCE(2)"]="EH K S AA N P R AH V AO N S",HORNBY="HH AO R N B IY",BOGUSZ="B AA G AH SH",SILICONIX="S IH L IH K AA N IH K S",COWARDICE="K AW ER D AH S",APRON="EY P R AH N",FINDING="F AY N D IH NG",PRYOR="P R AY ER",BRAUHAU="B R AA HH AA",["REHABILITATING(2)"]="R IY AH B IH L AH T EY T IH NG",MINDING="M AY N D IH NG",COWDERY="K AW D ER IY",CONFIGURING="K AH N F IH G Y ER IH NG",["GALILEO'S(2)"]="G AE L AH L EY OW Z",BINDING="B AY N D IH NG",WINDING="W AY N D IH NG",EPITOMIZES="IH P IH T AH M AY Z IH Z",ACTUALITY="AE K CH UW AE L AH T IY",MAMMOGRAMS="M AE M OW G R AE M Z",["AMTRAK'S"]="AE M T R AE K S",CONVERSATION="K AA N V ER S EY SH AH N",["HINDQUARTER(2)"]="HH AY N D K AO R T ER",TABULATING="T AE B Y AH L EY T IH NG",VALUATIONS="V AE L Y UW EY SH AH N Z",ESTIMATION="EH S T AH M EY SH AH N",ESCUDO="EH S K UW D OW",CARRIAGES="K AE R IH JH IH Z",PROFANITY="P R OW F AE N AH T IY",FERRERA="F EH R EH R AH",HERRERA="HH ER EH R AH",LAZARSKI="L AH Z AA R S K IY",AKZOS="AE K Z OW Z",GRUNDY="G R AH N D IY",MARRIAGES="M EH R IH JH IH Z",MOPED="M OW P T",SCHEDULED="S K EH JH UH L D",DOPED="D OW P T",COPED="K OW P T",HOPED="HH OW P T",DATAQUEST="D EY T AH K W EH S T",["GORAZDE'S"]="G AO R AA ZH D AH Z",BELITTLED="B IH L IH T AH L D",["ECONOMICAL(2)"]="IY K AH N AA M IH K AH L",["INTERCEPTIONS(2)"]="IH N ER S EH P SH AH N Z",PREYISTAS="P R EY IH S T AH Z",OPTOMETRISTS="AA P T AA M AH T R IH S T S",MORON="M AO R AA N",["ACCEPTANCE(2)"]="AH K S EH P T AH N S",EXHAUST="IH G Z AO S T",BENINATI="B EH N IY N AA T IY",PEROUTKA="P ER UW T K AH",BORON="B AO R AA N",DORON="D AO R AH N",BAINBRIDGE="B EY N B R IH JH",INTERVENTIONISTS="IH N T ER V EH N CH AH N IH S T S",OVERWRITES="OW V ER R AY T S",GERMANIC="JH ER M AE N IH K",MATHWIG="M AE TH W IH G",["CRIMEAN(2)"]="K R AY M IY AH N",FORTUNY="F AO R CH UW N IY",RUHNAU="R UW N AW",ELRON="EH L R AH N",PETZOLD="P EH T Z OW L D",SMUGGLERS="S M AH G L ER Z",ASTRONOMICALLY="AE S T R AH N AA M IH K L IY",HERITAGE="HH EH R AH T AH JH",LOHRENZ="L AO R IH N S",ROSEVILLE="R OW Z V IH L",MACISAAC="M AH CH IH S AE K",KOPISCHKE="K AH P IH SH K IY",ROUNDY="R AW N D IY",CULMINATED="K AH L M AH N EY T AH D",BETZOLD="B EH T Z OW L D",EXTRAVESATED="EH K S T R AE V AH S EY T AH D",JOJOLA="Y OW Y OW L AH",FITHE="F IH TH",EXTORTIONIST="EH K S T AO R SH AH N IH S T",LITHE="L AY DH",OMRON="AA M R AH N",STREETCAR="S T R IY T K AA R",SITHE="S AY DH",TITHE="T AY DH",MONTICELLO="M AA N T AH S EH L OW",HEREDITY="HH ER EH D AH T IY",RIGHTFULLY="R AY T F AH L IY",SWOOPING="S W UW P IH NG",GAMELLO="G AH M EH L OW",SEGREGATIONISTS="S EH G R AH G EY SH AH N IH S T S",SPOONER="S P UW N ER",KAMMERER="K AE M ER ER",CONVERSELY="K AA N V ER S L IY",["GLAVINE(2)"]="G L AE V IY N",MARANDA="M ER AE N D AH",HOCHSTATTER="HH AA K S T AH T ER",PULS="P UH L Z",GONIUM="G OW N IY AH M",HEIFETZ="HH AY F IH T S",MCCUISTION="M AH K W IH SH AH N",FARANDA="F ER AE N D AH",IHDE="IH D",HULS="HH AH L Z",DEBIASE="D IH B IY AA S IY",TRANSWESTERN="T R AE N Z W EH S T ER N",["HOURS(2)"]="AW R Z",["INTRODUCTION(2)"]="IH N T R OW D AH K SH AH N",BORCHERS="B AO R K ER Z",DELANEY="D AH L EY N IY",GARFINKLE="G AA R F IH NG K AH L",AIDE="EY D",BIDE="B AY D",AKRON="AE K R AH N",JAWED="JH AO D",CAPIZZI="K AA P IY T S IY",FIDE="F AY D",LINKOUS="L IH NG K AH S",HIDE="HH AY D",NURTURE="N ER CH ER",SAWED="S AO D",PAWED="P AO D",LAZARE="L AA Z AA R EY",["LEONI(2)"]="L IY OW N IY",GRANDMOTHERLY="G R AE N D M AH DH ER L IY",CONFINING="K AH N F AY N IH NG",GAMSAKHURDIA="G AE M S AH K ER D IY AH",EXACTED="IH G Z AE K T IH D",WASTEBASKETS="W EY S T B AE S K AH T S",OWLS="AW L Z",SUPERCHARGE="S UW P ER CH AA R JH",FINELY="F AY N L IY",HINELY="HH AY N L IY",LIDE="L AY D",RIDE="R AY D",SIDE="S AY D",TIDE="T AY D",VIDE="V AY D",DIMMICK="D IH M IH K",MYRON="M AY R AH N",KYRON="K AY R AH N",SOFTEST="S AO F T AH S T",STARTLING="S T AA R T L IH NG",DEMELLO="D IH M EH L OW",MUZYKA="M Y UW Z IH K AH",["PORSCHE'S(2)"]="P AO R SH IH Z",MORAITIS="M AO R AY T IH S",WITHHOLD="W IH TH HH OW L D",MAGISTRATES="M AE JH IH S T R EY T S",MERANDA="M ER AA N D AH",KRAUSZ="K R AW SH",["GLENFED'S"]="G L EH N F EH D Z",VERANDA="V ER AE N D AH",ASSEMBLYWOMAN="AH S EH M B L IY W UH M AH N",KRIMINYOK="K R IH M IH N Y AO K",["ADVANTAGED(3)"]="AE D V AE N IH JH D",SUBTRACT="S AH B T R AE K T",DIGNIFY="D IH G N AH F AY",JOSEPHSON="JH OW S AH F S AH N",BOJANOWSKI="B AH Y AH N AO F S K IY",["CAPOTE'S"]="K AH P OW T S",JESSICA="JH EH S IH K AH",CUDE="K Y UW D",["MISSHAPEN(2)"]="M IH S HH AE P AH N",DRUISILLA="D R IH S IH L AH",ASSELSTINE="AE S AH L S T AY N",["BERNARD'S"]="B ER N AA R D Z",APPLEMAN="AE P AH L M AH N",CHAFES="CH EY F S",GUDE="G Y UW D",JUDE="JH UW D",BLUING="B L UW IH NG",BARTKOWIAK="B ER T K AW IY AE K",INTERCAPITAL="IH N T ER K AE P AH T AH L",RUDE="R UW D",CUDGELS="K AH JH AH L Z",COMMERCIAL="K AH M ER SH AH L",["PARTICLE(2)"]="P AA R T IH K AH L",DURON="D Y UW R AH N",MARIEN="M EH R IY N",LAGROW="L AE G R OW",SANDWICHES="S AE N D W IH CH IH Z",DARIEN="D EH R IY AH N",["RED-HERRINGS"]="R EH D HH EH R IH NG Z",CARRERA="K AA R EH R AH",BARRERA="B AA R EH R AH",RAWL="R AO L",DEPRESSURIZING="D IH P R EH SH ER AY Z IH NG",KAYAPO="K AY AH P OW",POZOS="P OW Z OW S",BOUNDY="B AW N D IY",MINIUM="M IH N IY AH M",MIRANDA="M ER AE N D AH",["ABLEST(2)"]="EY B L AH S T",["PERSHING'S"]="P ER SH IH NG Z",EICKHOLT="AY K HH OW L T",FITZHUGH="F IH T S HH Y UW",QUEENS="K W IY N Z",FORGIVABLE="F AO R G IH V AH B AH L",MINIVAN="M IH N IY V AE N",["AFFINITY(2)"]="AH F IH N IH T IY",ARSENALS="AA R S AH N AH L Z",ATTENTIVENESS="AH T EH N T IH V N AH S",PRESUMABLY="P R AH Z UW M AH B L IY",COMCAST="K AA M K AE S T",ABEE="AH B IY",["BARNARD'S"]="B AA R N AA R D Z",DUPED="D UW P T",WOLSTENHOLME="W OW L S T IH N HH OW L M",OSPINA="OW S P IY N AH",["WHIM(2)"]="HH W IH M",KERIEN="K EH R IY AH N",SKYDIVE="S K AY D AY V",KHASBULATOV="K AA S B AH L AA T AA F",AERIEN="EH R IY AH N",SOKOLOW="S AA K AH L OW",BEREAVE="B ER IY V",COMPRISING="K AH M P R AY Z IH NG",NIEBAUER="N IY B AW ER",["HILLHAVEN'S"]="HH IH L HH EY V AH N Z",BOWED="B AW D",COWED="K AW D",REXHAM="R EH K S AH M",CROSSLIN="K R AA S L IH N",BLINDLY="B L AY N D L IY",TREHARNE="T R EH HH AA R N",EFFERTZ="EH F ER T S",COMMENCEMENT="K AH M EH N S M AH N T",SEMONES="S EY M OW N EH S",DIAMANDIS="D AY AH M AE N D IH S",ALETHEA="AE L AH TH IY AH",GLODOWSKI="G L AH D AO F S K IY",ROWED="R OW D",SOWED="S AW D",TOWED="T OW D",MOWED="M OW D",MCADOW="M AH K AE D OW",CROSTHWAIT="K R AA S TH W AH T",KINCAID="K IH N K EY D",MCNAB="M AH K N AE B",HYDROLYSIS="HH AY D R AA L AH S AH S",SYNDICATOR="S IH N D IH K EY T ER",TORPEDOING="T AO R P IY D OW IH NG",WIMS="W IH M Z",UPFRONT="AH P F R AH N T",["RUBY'S"]="R UW B IY Z",SCHENKEL="SH EH NG K AH L",UNWED="AH N W EH D",PERTINENT="P ER T IH N IH N T",OHMS="OW M Z",MAGNIFY="M AE G N AH F AY",CHATEAUX="SH AH T OW",EMDE="EH M D",ELLS="EH L Z",SICKENING="S IH K AH N IH NG",CARFAGNO="K AA R F AA G N OW",ILLS="IH L Z",VINING="V AY N IH NG",MANISCALCO="M AA N IY S K AA L K OW",ACKNOWLEDGEMENT="AE K N AA L IH JH M AH N T",DINING="D AY N IH NG",FINING="F AY N IH NG",PINING="P AY N IH NG",LINING="L AY N IH NG",ALLS="AO L Z",MINING="M AY N IH NG",ENDE="EH N D",DEERFIELD="D IH R F IY L D",NUNNELLEY="N AH N IH L IY",ABKHAZIANS="AE B K AA Z IY AH N Z",PLANTATIONS="P L AE N T EY SH AH N Z",REFLECTION="R AH F L EH K SH AH N",NIEMELA="N IY M EH L AH",BOUCHIE="B AW CH IY",["ADVENTURESOME(2)"]="AH D V EH N CH ER S AH M",FORTIFICATION="F AO R T AH F AH K EY SH AH N",INCLUDES="IH N K L UW D Z",SARLI="S AA R L IY",["EDUCATES(2)"]="EH JH Y AH K EY T S",HEREIN="HH IH R IH N",DADDONA="D AA D OW N AH",SPECIFICATION="S P EH S IH F IH K EY SH AH N",BIRKELAND="B ER K L AH N D",REIMBURSED="R IY IH M B ER S T",CARLI="K AA R L IY",DEBRUYNE="D EH B R AY N",["MAVS'"]="M AA V Z",["CEASE-FIRE"]="S IY S F AY ER",ENLIGHTENS="EH N L AY T AH N Z",EXPUNGED="IH K S P AH N JH D",PAPERING="P EY P ER IH NG",TAPERING="T EY P ER IH NG",BOTHE="B OW DH",INIKI="IY N IY K IY",["RELINQUISH(2)"]="R IY L IH NG K W IH SH",ERANY="AH R EY N IY",ANYWAYS="EH N IY W EY Z",SPENDING="S P EH N D IH NG",["APPLAUDED(2)"]="AH P L AO D IH D",KOTHE="K OW DH",EQUICOR="EH K W IH K AO R",AIMS="EY M Z",["RANSBURG'S"]="R AE N Z B ER G Z",BRODOWSKI="B R AH D AO F S K IY",DIMS="D IH M Z",PICNICS="P IH K N IH K S",VILARDO="V IY L AA R D OW",MILARDO="M IY L AA R D OW",HYMNAL="HH IH M N AH L",RINGBERG="R IH NG B ER G",["AFFIXES(2)"]="AH F IH K S IH Z",BACKFIRES="B AE K F AY ER Z",ADMIRATIONS="AE D M ER EY SH AH N Z",SIMS="S IH M Z",TIMS="T IH M Z",MIMS="M IH M Z",NIMS="N IH M Z",VALLEJO="V AA L EY Y OW",OLDE="OW L D",KIMS="K IH M Z",IRREPLACEABLE="IH R AH P L EY S AH B AH L",JOLIVETTE="ZH AA L IH V EH T",MEADOW="M EH D OW",BANNINGS="B AE N IH NG Z",MILLSAPS="M IH L S AE P S",MARQUARD="M AA R K W AA R D",DISAVOWED="D IH S AH V AW D",UNREIN="AO N R AY N",AMENDING="AH M EH N D IH NG",BENING="B EH N IH NG",OVERCAST="OW V ER K AE S T",["ACADEMICIANS(2)"]="AH K AE D AH M IH SH AH N Z",UNENDING="AH N EH N D IH NG",MAXHAM="M AE K S AH M",["HAIM(2)"]="HH EY M",DISINVITED="D IH S IH N V AY T IH D",BROCCOLI="B R AA K AH L IY",GOTTERDAMMERUNG="G AA T ER D AE M ER AH NG",DENSITOMETER="D EH N S AH T AA M AH T ER",DEALMAKING="D IY L M EY K IH NG",KEMMERER="K EH M ER ER",DOWNFALL="D AW N F AO L",GLENWOOD="G L EH N W UH D",["SERGEY(2)"]="S EH R G EY",JENNINGS="JH EH N IH NG Z",INDONESIANS="IH N D OW N IY S IY AH N Z",CORNERBACK="K AO R N ER B AE K",CASESA="K AH S EH S AH",["CHIANG'S"]="CH AE NG Z",DOLORES="D AH L AO R IH S",TECUMSEH="T AH K AH M S AH",ASPENS="AE S P AH N Z",NIKOLA="N IH K OW L AH",CONELY="K OW N L IY",DIBIASE="D IY B IY AA S IY",AMENTA="AH M EH N T AH",DEARINGER="D IH R IH NG ER",BARTKUS="B AA R T K IH S",RYKIEL="R IY K Y EH L",BEDE="B IY D",WALENTA="W AH L EH N T AH",VALENTA="V AH L EH N T AH",BRIANA="B R IY AE N AH",ARIANA="AA R IY AE N AH",MEANY="M IY N IY",CEDE="S IY D",DEDE="D IY D",FEDE="F IY D",["THIS'LL"]="DH IH S AH L",SEWED="S OW D",COMPARATIVE="K AH M P EH R AH T IH V",LANING="L EY N IH NG",HANING="HH EY N IH NG",FRIENDLINESS="F R EH N D L IY N IH S",GOVETT="G AH V AH T",HANRAHAN="HH AE N R AH HH AE N",INFLECTION="IH N F L EH K SH AH N",HENNINGS="HH EH N IH NG Z",COMPOSITE="K AH M P AA Z AH T",RINEHIMER="R AY N HH AY M ER",DINICOLA="D IH N IY K OW L AH",SHORTCHANGING="SH AO R T CH EY N JH IH NG",BLADOW="B L AE D OW",MASLOW="M AA S L OW",BODE="B OW D",CODE="K OW D",GNARLS="N AA R L Z",["O'HALLARON"]="OW HH AE L ER AH N",PEDRAZA="P EY D R AA Z AH",SASLOW="S AE S L OW",["INCIDENCE(2)"]="IH N S IH D AH N S",["PORT-CLINTON"]="P AO R T K L IH N T AH N",BEQUEATH="B IH K W IY TH",SNARLS="S N AA R L Z",WINNINGS="W IH N IH NG Z",ZASLOW="Z AA S L OW",CUMBERLAND="K AH M B ER L AH N D",["BABY'S"]="B EY B IY Z",GONZALES="G AA N Z AA L AH S",["RETRIEVES(2)"]="R IY T R IY V Z",FORMYLIN="F AO R M IH L IH N",PIENTA="P IY N T AH",RAUDABAUGH="R AO D AH B AO",SCAFFOLDING="S K AE F AH L D IH NG",MARGINALIZED="M AA R JH AH N AH L AY Z D",ANTHEMS="AE N TH AH M Z",SOUTHWORTH="S AW TH W ER TH",DEVIATIONS="D IY V IY EY SH AH N Z",RODE="R OW D",SABATINE="S AA B AA T IY N IY",AMREIN="AE M R AY N",MODE="M OW D",FORCIER="F AO R K IY ER",NODE="N OW D",OVERPLAY="OW V ER P L EY",EXCLUDES="IH K S K L UW D Z",SAIKI="S EY K IY",NEOPHYTE="N IY AH F AY T",ANGELICAS="AE N JH EH L IH K AH Z",SCIENCE="S AY AH N S",UPSON="AH P S AH N",QUIZZICAL="K W IH Z AH K AH L",LONELY="L OW N L IY",["PROJECT'S"]="P R AA JH EH K T S",CAMOUFLAGING="K AE M AH F L AA ZH IH NG",ISADORE="IH S AA D AO R EY",CHANY="CH EY N IY",MODALISM="M OW D AH L IH Z AH M",DOLS="D AA L Z",ACCOMPLISHMENT="AH K AA M P L IH SH M AH N T",TROOPING="T R UW P IH NG",MCGOLDRICK="M AH G OW L D R AH K",FERRAR="F ER AA R",ZIMMERER="Z IH M ER ER",POLS="P OW L Z",MCCRACKEN="M AH K R AE K AH N",DROOPING="D R UW P IH NG",TRANSAMERICA="T R AE N S AH M EH R IH K AH",BYERLEY="B AY ER L IY",STERILIZES="S T EH R AH L AY Z IH Z",SANTIESTEBAN="S AE N T IY S T IH B AH N",DULCET="D AH L S AH T",UNDERSTOOD="AH N D ER S T UH D",PHILYAW="F IH L Y AA",CHASKA="CH AE S K AH",OWNING="OW N IH NG",BANNISTER="B AE N AH S T ER",CANNISTER="K AE N IH S T ER",["IMPOSSIBLE'S"]="IH M P AA S AH B AH L Z",CONCUSSIONS="K AH N K AH SH AH N Z",SCHOPFER="SH AA P F ER",EPSON="EH P S AH N",BEATS="B IY T S",DEATS="D IY T S",["VANTAGE'S"]="V AE N T IH JH IH Z",FEATS="F IY T S",HEATS="HH IY T S",KEATS="K IY T S",MEATS="M IY T S",COMPOSE="K AH M P OW Z",NKOHSE="EH NG K OW S IY",HIGHER="HH AY ER",BRUECHER="B R UW CH ER",["RITENOUR'S(2)"]="R AY T AH N AW R Z",TEATS="T IY T S",YEATS="Y EY T S",AWNING="AA N IH NG",CYANIDE="S AY AH N AY D",BARHAM="B AA R HH AH M",STOPA="S T OW P AH",["AFFILIATES'"]="AH F IH L IY IH T S",ASCETIC="AH S EH T IH K",SCHOWALTER="SH AW AH L T ER",BOROWICZ="B ER OW V IH CH",MENNENGA="M IH N EH NG G AH",OVERLEY="OW V ER L IY",PARHAM="P AA R HH AH M",CONFIDE="K AH N F AY D",SHERIFF="SH EH R AH F",CORONER="K AO R AH N ER",BEZDEK="B EH Z D IH K",TROUTNER="T R AW T N ER",KRIEGEL="K R IY G AH L",THATCHERITE="TH AE CH ER AY T",KURTZMAN="K ER T S M AH N",["NEWS'"]="N UW Z",NASRULLAH="N AH Z R UW L AH",STARTLES="S T AA R T AH L Z",STURZA="S T ER Z AH",HAIRCUT="HH EH R K AH T",HELMICK="HH EH L M IH K",BRIEGEL="B R IY G AH L",RESONATED="R EH Z AH N EY T IH D",SHATTUCK="SH AE T AH K",CHATS="CH AE T S",GRILLED="G R IH L D",OUTSHONE="AW T SH OW N",ALASKA="AH L AE S K AH",["CONIC(2)"]="K OW N IH K",STODDARD="S T AA D ER D",["CEDRAS'S"]="S EY D R AA S IH S",DRILLED="D R IH L D",["PRESIDED(3)"]="P R IY Z AY D IH D",BERCIER="B ER K IY ER",COURTIERS="K AO R T IY ER Z",WHATS="W AH T S",ELSON="EH L S AH N",DOMED="D OW M D",["HASHISH(2)"]="HH AH SH IY SH",KAMPSCHULTE="K AE M P SH UH L T IY",INTERMITTENTLY="IH N T ER M IH T AH N T L IY",GLUSKIN="G L AH S K IH N",PLUGS="P L AH G Z",EVERLEY="EH V ER L IY",ALTFEST="AA L T F EH S T",YOSHIHASHI="Y OW SH IH HH AA SH IY",BLANKEN="B L AE NG K AH N",["DIRECTIONAL(3)"]="D AY R EH K SH IH N AH L",GRIGSBY="G R IH G Z B IY",["INTERESTED(3)"]="IH N T ER AH S T AH D",CONJOIN="K AA N JH OY N",KALLHOFF="K AE L HH AO F",HERBOLD="HH ER B OW L D",EMPOWERING="IH M P AW ER IH NG",["ATTRIBUTE(2)"]="AH T R IH B Y UW T",["DIVEST(2)"]="D IH V EH S T",DYSON="D AY S AH N",OVERGROWN="OW V ER G R OW N",THEE="DH IY",POBLA="P OW B L AH",PERHAM="P ER HH AH M",AGEE="EY JH IY",STILLED="S T IH L D",AGARWAL="AA G AA R W AA L",BLASIER="B L EY Z IY ER",FAYANJUU="F AY AH N JH UW",RHEE="R IY",GOEBBELS="G OW B AH L Z",DELTEC="D EH L T EH K",REPENTANT="R IH P EH N T AH N T",STORYLINE="S T AO R IY L AY N",SEAWRIGHT="S IY R AY T",SAMSUNG="S AE M S AH NG",MEDENDORP="M EH D EH N D AO R P",["INTERCOURSE(2)"]="IH N ER K AO R S",CHEE="CH IY",EXCERPT="EH K S ER P T",TONING="T OW N IH NG",URINALYSIS="Y ER AH N AE L AH S IH S",BLENDING="B L EH N D IH NG",KONING="K OW N IH NG",HONING="HH OW N IH NG",DEARMAS="D ER M AH Z",KRINGEN="K R IH NG AH N",STEADHAM="S T EH D HH AH M",HYACINTHE="HH AY AH S IH N TH",["LEONARD'S"]="L EH N ER D Z",ZONING="Z OW N IH NG",THUGS="TH AH G Z",["PLAINTIFFS(2)"]="P L EY N IH F S",["OPRAH'S"]="OW P R AH Z",INNING="IH N IH NG",OBEDIENTLY="OW B IY D IY AH N T L IY",FLIEGEL="F L IY G AH L",BONING="B OW N IH NG",LANDGRAVE="L AE N D G R EY V",ADJUDICATE="AH JH UW D IH K EY T",THIEM="TH IY M",VELARDO="V EY L AA R D OW",["FEDERALISTS(3)"]="F EH D R AH L IH S T S",HARBOLD="HH AA R B OW L D",LEVITICAN="L AH V IH T AH K AH N",FUSON="F UW S AH N",KUWAITIS="K UW W EY T IY Z",WIPED="W AY P T",HUSON="HH UW S AH N",GRUNDMAN="G R AH N D M AH N",["PROVIDENCE'S"]="P R AA V AH D AH N S IH Z",UNCONVENTIONAL="AH N K AH N V EH N SH AH N AH L",FEIGENBAUM="F AY G AH N B AW M",EXTRATERRESTRIALS="EH K S T R AH T ER EH S T R IY AH L Z",NAKAYAMA="N AA K AA Y AA M AH",KILBORNE="K IH L B AO R N",HOHEISEL="HH OW AY S AH L",ALVARENGA="AA L V AA R EH NG G AH",["LIVINGSTONE'S"]="L IH V IH NG S T OW N Z",BIOSCIENCE="B AY OW S IY AH N S",OPPENS="AA P AH N Z",["TOBY'S"]="T OW B IY Z",["FARADAY'S"]="F AE R AH D EY Z",WIDENED="W AY D AH N D",NANNIES="N AE N IY Z",SCHRADE="SH R EY D",CULTIVATING="K AH L T IH V EY T IH NG",STREIGHT="S T R EY T",WOLOSZYN="V AH L AA SH IH N",WUERTTEMBERG="W ER T AH M B ER G",["LIBERALIZING(2)"]="L IH B R AH L AY Z IH NG",ESSON="EH S AH N",SLOGANS="S L OW G AH N Z",["DROMOMANIA(2)"]="D R OW M OW M EY N Y AH",BASAYEV="B AE S AA Y EH V",CLOUATRE="K L AW AH T R",FAVRO="F AE V R OW",URSON="ER S AH N",NUMED="N UW M EH D",["CULTURE'S"]="K AH L CH ER Z",GREUBEL="G R OY B AH L",COLBORNE="K OW L B AO R N",MARCHESCHI="M AA R CH EH SH IY",JIANGSU="JH Y AA NG S UW",["REGRESS(2)"]="R IH G R EH S",GREEDY="G R IY D IY",["REDUCE(2)"]="R IH D UW S",FEATURING="F IY CH ER IH NG",ARMED="AA R M D",["ECKARDT(2)"]="EH K HH AA R T",MARON="M AA R AO N",GREFE="G R IY F",CACCAMO="K AA K AA M OW",["INTEGRATED(4)"]="IH N AH G R EY T IH D",PALAZINA="P AE L AH Z IY N AH",GELLATLY="JH EH L AH T L IY",MOTORISTS="M OW T ER AH S T S",ROUGHEST="R AH F AH S T",FUMED="F Y UW M D",["ARBY'S"]="AA R B IY Z",ARSON="AA R S AH N",ZERCOMO="Z ER K OW M OW",TOUGHEST="T AH F AH S T",INTENSIFY="IH N T EH N S AH F AY",WELBORNE="W EH L B ER N",CLINTONITES="K L IH N T AH N AY T S",LUKEWARM="L UW K W AO R M",FRANKEN="F R AE NG K AH N",CRISSCROSSED="K R IH S K R AO S T",["ISOTONER(2)"]="AY S OW T OW N ER",DEFIED="D IH F AY D",DECAPUA="D IH K AA P UW AH",SIMEONE="S IH M IY AH N",SCHATZBERG="SH AE T S B ER G",RAINS="R EY N Z",SAPIENS="S EY P IY AH N Z",BELOV="B EH L AA V",MAINS="M EY N Z",["ATTEMPTS(2)"]="AH T EH M P S",MISHAPS="M IH S HH AE P S",GAINS="G EY N Z",KIAWAH="K AY AH W AH",["MARCOS'(2)"]="M AA R K OW S IH Z",DEVOLDER="D EH V OW L D ER",DAINS="D EY N Z",SNEE="S N IY",BAINS="B EY N Z",SHANANSKY="SH AH N AE N S K IY",TIMBROOK="T IH M B R UH K",KNEE="N IY",CANOLA="K AH N OW L AH",COLORIZATION="K AH L ER AH Z EY SH AH N",["EARMARKING(2)"]="IY R M AA R K IH NG",LABOUR="L EY B AW R",KARON="K EH R AH N",["CUTICLE(2)"]="K Y UW T IH K AH L",SLOPPILY="S L AA P AH L IY",GARON="G AA R AO N",FARON="F EH R AH N",CARON="K AA R AO N",AARON="EH R AH N",BARON="B AE R AH N",["DAIMLER(2)"]="D EH M L ER",TROUNG="T R AW NG",["MAZDA'S"]="M AA Z D AH Z",RAPED="R EY P T",TAPED="T EY P T",WYTHE="W AY DH",SPILLED="S P IH L D",DETRITUS="D IH T R AY T AH S",SOCIALLY="S OW SH AH L IY",RECYCLED="R IY S AY K AH L D",SLEE="S L IY",["PIERRE'S"]="P IY EH R Z",VETOING="V IY T OW IH NG",["POLKA(2)"]="P OW K AA",REFURBISHING="R IY F ER B IH SH IH NG",FLYPAPER="F L AY P EY P ER",KLEE="K L IY",GAULKE="G AO L K",MCMAHEN="M AH K M EY HH AH N",GLEE="G L IY",FLEE="F L IY",MAULDIN="M AW L D AH N",GUITARISTS="G IH T AA R IH S T S",STALKED="S T AO K T",HECLA="HH EH K L AH",CAPED="K EY P T",DINWIDDIE="D IH N W IH D IY",KACZMAREK="K AH CH M AA R EH K",SPROUTS="S P R AW T S",LYONNAISE="L AY AH N EY Z",SMEE="S M IY",THROUGHPUT="TH R UW P UH T",TRICKLES="T R IH K AH L Z",TRAFFICKER="T R AE F IH K ER",PARACHUTE="P EH R AH SH UW T",UNHEALTHFUL="AH N HH EH L TH F AH L",["PORTUGAL'S"]="P AO R CH AH G AH L Z",KINGTON="K IH NG T AH N",TUSKEGEE="T AH S K AH G IY",MCGLASHAN="M AH G L AE SH AH N",["ZEPA(3)"]="Z IY IY P IY EY",ARROWHEADS="AE R OW HH EH D Z",["RESPONDED(3)"]="R IY S P AA N D IH D",ONOFRE="OW N AO F R IY",["LIFTED(2)"]="L IH F T IH D",ISOTONER="IH Z OW T AH N ER",ALYSHEBA="AE L IH SH IY B AH",CZARNECKI="CH ER N EH T S K IY",EYDE="EY D",GRANDEST="G R AE N D AH S T",HYDE="HH AY D",["GIFTED(2)"]="G IH F T IH D",LYDE="L AY D",["PLAY'S"]="P L EY Z",FLAUNTS="F L AO N T S",KENESSET="K EH N EH S EH T",RUBIO="R UW B IY OW",EXECUTIVE="IH G Z EH K Y AH T IH V",PAOLINI="P AA OW L IY N IY",CONCILIATOR="K AH N S IH L IY EY T ER",WHITELAW="W AY T L AO",UNPROFITABILITY="AH N P R AA F IH T AH B IH L IH T IY",WINOLA="V IH N OW L AH",IWANSKI="IH V AE N S K IY",["VAULTED(2)"]="V AO L T IH D",["PASTOR'S"]="P AE S T ER Z",EFRON="EH F R AH N",FISHBOWL="F IH SH B OW L",GALAVIZ="G AE L AH V IH Z",["DIRECTORSHIP(3)"]="D IY R EH K T ER SH IH P",CUNDARI="K UW N D AA R IY",CONTACTED="K AA N T AE K T IH D",GROUPEMENT="G R UW P M AH N T",["(LEFT-PAREN"]="L EH F T P ER EH N",DUETS="D UW EH T S",MIRON="M IH R AO N",COMANDANTE="K OW M AH N D AA N T EY",FRIDRICH="F R IH D R IH K",TITLOW="T IH T L OW",JIRON="JH IH R AO N",GIRON="ZH IH R AH N",TYPED="T AY P T",PERON="P ER AO N",VERON="V EH R AH N",COUNTERTERRORIST="K AW N T ER T EH R ER IH S T",LADIES="L EY D IY Z",HEINTZELMAN="HH AY N T Z AH L M AH N",HYPED="HH AY P T",PENDERGRAST="P EH N D ER G R AH S T",MIAZGA="M IY AA Z G AH",["TWENTIETH(2)"]="T W EH N T IY IH TH",["CAUSING(2)"]="K AO Z IH NG",["CHEKHOV'S"]="CH EH K AA V Z",JAGODZINSKI="Y AH G AH JH IH N S K IY",CASSAVETES="K AE S AH V IY T IY Z",DIWALI="D IH W AA L IY",FETTEROLF="F EH T ER OW L F",GLADD="G L AE D",HAMIEL="HH AE M IY L",ADEE="AH D IY",BRAJDAS="B R AY D AH S",["FOOTBALL'S"]="F UH T B AO L Z",COVENANT="K AH V AH N AH N T",BIANCONI="B IY AA NG K OW N IY",CLAUSTROPHOBIA="K L AO S T R AH F OW B IY AH",WEINS="W IY N Z",ABRON="AH B R AA N",GUINNESS="G IH N AH S",BALLISTIC="B AH L IH S T IH K",DROPLET="D R AA P L AH T",SCHARRER="SH AA R ER",TREE="T R IY",HEINS="HH AY N Z",CAMRO="K AE M R OW",PREE="P R IY",BREE="B R IY",CREE="K R IY",STEINFELDT="S T AY N F EH L T",FREE="F R IY",DONAPRIA="D AH N AE P R IY AH",BERON="B EH R AH N",DAARMSTADT="D AA R M S T AA D",["WHITSELL(2)"]="HH W IH T S AH L",GERON="JH EH R AH N",UGOLINI="UW G OW L IY N IY",["CARRIAGES(2)"]="K EH R AH JH AH Z",HERON="HH EH R AH N",LANGTON="L AE NG T AH N",["AUGSBURGER(2)"]="AO G Z B ER G ER",NEOLIBERAL="N IY OW L IH B ER AH L",SENEGALESE="S EH N AH G AH L IY Z",["SARAH'S"]="S EH R AH Z",ABRAMCZYK="AA B R AH M CH IH K",INVITATIONS="IH N V IH T EY SH AH N Z",["CALFED'S"]="K AE L F EH D Z",BICYCLED="B AY S IH K AH L D",ROUTINELY="R UW T IY N L IY",HOMOLA="HH AH M AA L AH",ALTARPIECE="AO L T ER P IY S",["FYODOR'S"]="F Y OW D ER Z",["MASON'S"]="M EY S AH N Z",APOPA="AH P OW P AH",LINDBERGH="L IH N D B ER G",CAMORRA="K AH M AO R AH",MILBRATH="M IH L B R AH TH",SUFFERER="S AH F ER ER",CALIBER="K AE L AH B ER",CABRALES="K AA B R AA L EH S",["EVACUATE(2)"]="IY V AE K Y AH EY T",BEILKE="B IY L K",BUSINESSMAN="B IH Z N AH S M AE N",DAIGREPONT="D EY G R IH P AA N T",RIGSBEE="R IH G Z B IY",NATALI="N AA T AA L IY",NEFT="N EH F T",CITRUCEL="S IH T R AH S EH L",GUILIN="G IH L IH N",LEFT="L EH F T",HEFT="HH EH F T",NONMANAGEMENT="N AA N M AE N IH JH M AH N T",DEFT="D EH F T",REFLECT="R AH F L EH K T",ODDITY="AA D AH T IY",SVENDSEN="S V EH N D S AH N",KUCHER="K AH K ER",BUCKELS="B AH K AH L Z",BUCHER="B AH K ER",SLUITER="S L UW T ER",KIDNAPS="K IH D N AE P S",GRINS="G R IH N Z",PENTHEA="P EH N TH IY AH",COURTIS="K AO R T IH S",GROUPINGS="G R UW P IH NG Z",SWENDSEN="S W EH N D S AH N",VANDEVER="V AE N D IY V ER",REINVENTED="R IY IH N V EH N T IH D",BURSTING="B ER S T IH NG",DEFLECT="D IH F L EH K T",BIASI="B IY AA S IY",GOINS="G OY N Z",DECISION="D IH S IH ZH AH N",["ADVOCATE'S"]="AE D V AH K AH T S",GRANADOS="G R AA N AA D OW Z",IMMENSE="IH M EH N S",EMIGRANTS="EH M AH G R AH N T S",GALVANIZE="G AE L V AH N AY Z",LAUCK="L AO K",MAUCK="M AO K",["BUENOS(2)"]="B W EY N AH S",RECISION="R IH S IH ZH AH N",MEDALLIONS="M AH D AE L Y AH N Z",ROFFE="R AA F",GRIZZLED="G R IH Z AH L D",SKOLNIKS="S K OW L N IH K S",HARTGROVE="HH AA R T G R OW V",MURAKAMI="M UH R AA K AA M IY",INTENSIVE="IH N T EH N S IH V",HAUCK="HH AO K",FELLOWES="F EH L OW Z",MCNANEY="M AH K N AE N IY",CHOREOGRAPH="K AO R IY AH G R AE F",GRANTREE="G R AE N T R IY",EQUALING="IY K W AH L IH NG",["UNCONDITIONALLY(2)"]="AH N K AH N D IH SH N AH L IY",["GATZKE(2)"]="G AE T S K IY",WILDRICK="W AY L D R IH K",MICROECONOMIC="M AY K R OW EH K AH N AA M IH K",CIRCULATING="S ER K Y AH L EY T IH NG",ZYCHER="Z IH K ER",BUHROW="B UH R OW",BRUMMOND="B R AH M AH N D",["GENEGO(3)"]="JH IY IY EH N IY JH IY OW",MEASUREX="M EH Z ER AH K S",CHARREN="CH EH R AH N",GRUMMOND="G R AH M AH N D",FREGEAU="F R IH ZH OW",DANNEMEYER="D AE N AH M AY R",NEWTONCHIK="N UW T AA N CH IH K",NAYSAYER="N EY S EY ER",HEYL="HH EY L",STUPAK="S T UW P AH K",BEYL="B EY L",["RECEIVE(3)"]="R IY S IY V",POLITELY="P AH L AY T L IY",DOORBELL="D AO R B EH L",MUKHOPADHYAY="M UW K OW P AA D Y AY",FUSING="F Y UW Z IH NG",CONDESCEND="K AA N D IH S EH N D",BUSING="B AH S IH NG",["PROCEEDS(2)"]="P R OW S IY D Z",OLDIES="OW L D IY Z",DITLOW="D IH T L OW",INVASION="IH N V EY ZH AH N",REVENUE="R EH V AH N UW",BANJO="B AE N JH OW",VAPORIZATION="V EY P ER AH Z EY SH AH N",LOBSTERMEN="L AA B S T ER M IH N",CHILBLAIN="CH IH L B L EY N",LEUCK="L UW K",SEISMOLOGICAL="S AY Z M AH L AO JH AH K AH L",KROGER="K R OW G ER",MAROTZ="M AE R AH T S",["FISHERMAN(2)"]="F IH SH ER M AH N",COLLAGE="K AH L AA ZH",BLASI="B L EY Z IY",DISTRUST="D IH S T R AH S T",MISTRUST="M IH S T R AH S T",GIANNATTASIO="JH AA N AA T AA S IY OW",BONWIT="B AA N W IH T",THINS="TH IH N Z",POSING="P OW Z IH NG",ROSING="R OW Z IH NG",OTOMOBIL="OW T OW M OW B AH L",INDIES="IH N D IY Z",VILLAGE="V IH L AH JH",HOTBEDS="HH AA T B EH D Z",HETEROSEXUALITY="HH EH T ER OW S EH K SH AH W AE L IH T IY",["KREMLIN(2)"]="K R EH M L IH N",DEPLOYABLE="D IH P L OY AH B AH L",MUMPER="M AH M P ER",JUMPER="JH AH M P ER",LUMPER="L AH M P ER",DECAY="D AH K EY",PILLAGE="P IH L IH JH",RAYL="R EY L",BUMPER="B AH M P ER",MILLAGE="M IH L IH JH",CIARAMELLA="CH ER AA M EH L AH",GORED="G AO R D",CHOREOGRAPHED="K AO R IY AH G R AE F T",UNCOIL="AH N K OY L",DOVETAILS="D AH V T EY L Z",CODAY="K OW D EY",GUIDROZ="G W IY D R OW Z",STIFFEST="S T IH F AH S T",SUPPA="S UW P AH",NORED="N AO R D",MAGANA="M AA G AE N AH",LAGANA="L AA G AE N AH",TRANSGENIC="T R AE N Z JH EH N IH K",["ISRAEL'S(2)"]="IH Z R IY AH L Z",BORED="B AO R D",BODIES="B AA D IY Z",FAKE="F EY K",CAKE="K EY K",DAKE="D EY K",BAKE="B EY K",FUZZIER="F AH Z IY ER",IDEALISM="AY D IY L IH Z AH M",MAKE="M EY K",CONGRATULATORY="K AH N G R AE CH AH L AH T AO R IY",LAKE="L EY K",SULFIDE="S AH L F AY D",JAKE="JH EY K",HAKE="HH EY K",ELLINWOOD="EH L IH N W UH D",KINSELLA="K IY N S EH L AH",CASTPARTS="K AE S T P AA R T S",CHILLED="CH IH L D",RAKE="R EY K",AGINS="EY G IH N Z",FLUCK="F L AH K",SOPHOCLES="S AA F AH K L IY Z",FIELDCREST="F IY L D K R EH S T",LAYOUTS="L EY AW T S",EIDEM="AY D IH M",HARPENAU="HH AA R P IH N OW",PAYOUTS="P EY AW T S",OGAWA="OW G AA W AH",MCCAY="M AH K EY",COMPARISONS="K AH M P EH R AH S AH N Z",ENVISAGE="EH N V IH Z IH JH",DOSING="D OW S IH NG",METRAHEALTH="M EH T R AH HH EH L TH",VONDRASEK="V AH N D R AA S EH K",HOSING="HH OW Z IH NG",LOSING="L UW Z IH NG",NOSING="N OW Z IH NG",PARCHMENTLIKE="P AA R CH M AH N T L AY K",["QUIST'S"]="K W IH S T S",MAMBAS="M AA M B AH Z",PUSHOVER="P UH SH OW V ER",NAJIBULLAH="N AE JH IH B UH L AH",["WHEEZE(2)"]="HH W IY Z",DEBTS="D EH T S",ENSING="EH N S IH NG",WELSHANS="W EH L SH AH N Z",["CLAUSES(2)"]="K L AO Z IH Z",["MCMAHON(2)"]="M AH K M AE N",CUFFE="K AH F",["GRAY'S"]="G R EY Z",["ARTICLE(2)"]="AA R T IH K AH L",["CRAY'S"]="K R EY Z",HUFNAGLE="HH AH F N EY G AH L",MICOSUKEE="M IH K AH S UW K IY",RUINS="R UW AH N Z",IVINS="IH V IH N Z",AMDURA="AE M D UH R AH",FLOATERS="F L OW T ER Z",FEUDALISTIC="F Y UW D AH L IH S T IH K",EVINS="EH V IH N Z",COMMITTING="K AH M IH T IH NG",["SESNO'S"]="S EH S N OW Z",ATTALI="AH T AA L IY",GOLDRICK="G OW L D R IH K",KONKOL="K AA NG K AO L",["BURNLEY'S"]="B ER N L IY Z",NORTHEASTWARD="N AO R TH IY S T W ER D",MARGARITA="M AA R G ER IY T AH",SPACEK="S P AA CH EH K",["EXAMINER'S"]="EH G Z AE M AH N ER Z",UNDIMINISHED="AH N D AH M IH N IH SH T",HARMISON="HH AA R M IH S AH N",BRAITHWAITE="B R EY TH W EY T",HEARTTHROB="HH AA R T TH R AA B",SMUCK="S M AH K",VANTOL="V AE N T AO L",SEYBOLD="S EY B OW L D",SOHIO="S OW HH AY OW",LOCURTO="L OW K UH R T OW",["DECREASES(2)"]="D IH K R IY S IH Z",HULETT="HH Y UW L IH T",AMUCK="AH M AH K",THERAPIST="TH EH R AH P AH S T",BEILIN="B EH L IH N",ZECHER="Z EH K ER",LEVENSON="L EH V IH N S AH N",MERCHANDISE="M ER CH AH N D AY Z",EXHILARATE="IH G Z IH L ER EY T",["WAGNER'S(2)"]="V AE G N ER Z",WINTERROWD="W IH N T ER AW D",["SUSPECTED(2)"]="S AH S P EH K T IH D",DRAPERY="D R EY P ER IY",NANKERVIS="N AE NG K ER V IH S",KERSTING="K ER S T IH NG",BECHER="B EH K ER",AYLWORTH="EY L W ER TH",CHEETHAM="CH IY TH AH M",["CRUZ'S"]="K R UW Z IH Z",BIERWIRTH="B IH R W ER TH",RECOLLECTS="R EH K AH L EH K T S",APPEALINGLY="AH P IY L IH NG L IY",LECHER="L EH CH ER",BAZOOKA="B AH Z UW K AH",FECHER="F EH K ER",HEIDRICH="HH AY D R IH K",EUROPHILES="Y UH R OW F AY L Z",["COUNTERTERRORISM(2)"]="K AW N ER T EH R ER IH Z AH M",CHRISTIANIZATION="K R IH S CH AH N AH Z EY SH AH N",RAILROADED="R EY L R OW D IH D",REACTED="R IY AE K T AH D",PTACEK="T AA CH EH K",["REPRISE(2)"]="R IH P R IY Z",["THEMSELVES(2)"]="DH AH M S EH L V Z",SITING="S AY T IH NG",GROUCHO="G R UW CH OW",MCCRAW="M AH K R AO",KITING="K AY T IH NG",LICAVOLI="L IY K AA V OW L IY",CARAVA="K AE R AH V AH",BITING="B AY T IH NG",CITING="S AY T IH NG",["INSUBSTANTIAL(2)"]="IH N S AH B S T AE N SH AH L",DIRTIEST="D ER T IY AH S T",HOMEWARD="HH OW M W ER D",["MISREPRESENTS(2)"]="M IH S R EH P R AH Z EH N S",TIFT="T IH F T",MCCRADY="M AH K R EY D IY",GAPPA="G AE P AH",UPTICK="AH P T IH K",CAPPA="K AE P AH",BACKTRACKS="B AE K T R AE K S",KREMPA="K R EH M P AH",REMUNERATION="R IH M Y UW N ER EY SH AH N",GIFT="G IH F T",AHOSKIE="AH HH AO S K IY",LIFT="L IH F T",ARLYNE="AA R L AY N",DISASTROUSLY="D IH Z AE S T R AH S L IY",BOWERMASTER="B OW ER M AE S T ER",["BENEDETTI'S"]="B EH N AH D EH T IY Z",["HERZEGOVINA'S"]="HH EH R T S AH G OW V IY N AH Z",SIFT="S IH F T",GODMOTHER="G AA D M AH DH ER",AICHER="AY K ER",EICHER="AY K ER",SATTERWHITE="S AE T ER W AY T",RETIREMENT="R IY T AY ER M AH N T",ACTING="AE K T IH NG",GRONEMEYER="G R AA N IH M AY ER",EMBELLISHING="EH M B EH L IH SH IH NG",PICHER="P IH CH ER",RAPPA="R AE P AH",HEAVYSET="HH EH V IY S EH T",DEPASS="D IH P AE S",PAPPA="P AE P AH",ONCOGEN="AA NG K OW JH AH N",CANCELING="K AE N S AH L IH NG",KAPPA="K AE P AH",FRETS="F R EH T S",GULBUDDIN="G AH B UW D IH N",SCRIBBLES="S K R IH B AH L Z",STEUER="S T OY ER",GRIESHABER="G R IY SH AH B ER",UNIMATION="Y UW N IH M EY SH AH N",CHUCK="CH AH K",MIKULEC="M IH K UW L IH K",JAHNS="JH AA N Z",UNCOAT="AH N K OW T",TOMBSTONES="T UW M S T OW N Z",CHARLEY="CH AA R L IY",NEWCOMBE="N UW K AH M",ZANGARA="Z AA NG G AA R AH",DITTBERNER="D IH T B ER N ER",MISPERCEPTIONS="M IH S P ER S EH P SH AH N Z",["GENTLEMAN'S(2)"]="JH EH N AH L M AH N Z",["INCREASES(2)"]="IH N K R IY S IH Z",["IRAQ'S"]="IH R AA K S",POPEJOY="P OW P JH OY",PARTICLES="P AA R T AH K AH L Z",TABOOS="T AE B UW Z",VITALI="V IY T AA L IY",GRANDNEPHEWS="G R AE N D N EH F Y UW Z",KEMPER="K EH M P ER",NOURISH="N ER IH SH",NUMBINGLY="N AH M IH NG L IY",UNNECESSARILY="AH N N EH S AH S EH R AH L IY",REEDUCATE="R IY EH JH AH K EY T",INSURED="IH N SH UH R D",VODAFONE="V OW D AH F OW N",INTERNEE="IH N T ER N IY",TIETMEYER="T IY T M AY R",EGREGIOUSLY="IH G R IY JH AH S L IY",["PREFERRED(2)"]="P R IH F ER D",AISLING="EY S L IH NG",GRANNAN="G R AE N AH N",KISLING="K IH S AH L IH NG",["MENTOR'S"]="M EH N T AO R Z",["DJUKANOVIC(2)"]="JH AH K AE N AH V IH CH",["CHAMBERS'"]="CH EY M B ER Z",SADDLEBAG="S AE D AH L B AE G",PERFORMER="P ER F AO R M ER",INTERNET="IH N T ER N EH T",BRANNAN="B R AE N AH N",WITHERINGTON="W IH TH ER IH NG T AH N",PENDERGAST="P EH N D ER G AE S T",TRANSTECHNOLOGY="T R AE N Z T AH K N AA L AH JH IY",FORSWEAR="F AO R S W EH R",ENSURED="EH N SH UH R D",GATING="G EY T IH NG",DATING="D EY T IH NG",EATING="IY T IH NG",SCHAUB="SH AO B",HATING="HH EY T IH NG",GALLERANI="G AA L ER AA N IY",MATING="M EY T IH NG",RATING="R EY T IH NG",INFLEXIBLE="IH N F L EH K S AH B AH L",OVERSTOCKED="OW V ER S T AA K T",ALLELES="AH L EH L IY Z",STRATEGISTS="S T R AE T IH JH IH S T S",TWINS="T W IH N Z",RISTORANTES="R IH S T ER AA N T EY Z",ACCORDINGLY="AH K AO R D IH NG L IY",KRONOR="K R OW N ER",SIMPER="S IH M P ER",GEHRIS="G EH R IH S",RAFT="R AE F T",TAFT="T AE F T",FERRYBOAT="F EH R IY B OW T",DLUGOSZ="D AH L UW G OW S",["PRUDENTIAL(2)"]="P R UW D EH N SH AH L",LOUCK="L AW K",HOUCK="HH AW K",DAFT="D AE F T",KEEFE="K IY F",HAFT="HH AE F T",CAMPAIGNER="K AE M P EY N ER",REAGANITES="R EY G AH N AY T S",DRUCK="D R AH K",["BOWDEN(2)"]="B AW D AH N",["CANTOR'S"]="K AE N T ER Z",PROTECTEE="P R AH T EH K T IY",BRUCK="B R AH K",KRUCK="K R AH K",["KANTOR'S"]="K AE N T ER Z",LIPPA="L IH P AH",MCCANNA="M AH K AE N AH",BEENKEN="B IY NG K AH N",TRUCK="T R AH K",PUBLIX="P AH B L IH K S",COPPA="K OW P AH",WETHERINGTON="W EH DH ER IH NG T AH N",FAJARDO="F AA Y AA R D OW",POMPER="P AA M P ER",HOPPA="HH AA P AH",METAMORPHIC="M EH T AH M AO R F IH K",GALILEAN="G AE L AH L IY AH N",FARAHA="F AA R AH HH AA",["BALLY(2)"]="B EY L IY",STUNNINGLY="S T AH N IH NG L IY",UNEARTH="AH N ER TH",AUTHORITARIANISM="AH TH AO R AH T EH R IY AH N IH Z AH M",COMPETE="K AH M P IY T",["BASS'S(2)"]="B AE S IH Z",POPPA="P AA P AH",HETHERINGTON="HH EH DH ER IH NG T AH N",ASSURED="AH SH UH R D",["ALLEGIANCES(2)"]="AH L IY JH AH N S IH Z",["ETYMOLOGY(2)"]="EH T IH M AA L AH JH IY",KUNAYEV="K Y UW N EY AH V",MAPPLETHORPE="M AE P AH L TH AO R P",ZORRO="Z AO R OW",KOSLOW="K AA S L OW",POMPA="P AA M P AH",["EFFECTS(3)"]="IY F EH K T S",AVERAGING="AE V R IH JH IH NG",CUIDADO="K W IY D AE D OW",SOHNS="S AA N Z",JOHNS="JH AA N Z",DEALERLINE="D IY L ER L AY N",PORRO="P AO R OW",ENTRENCHMENT="EH N T R EH N CH M AH N T",GAGLIONE="G AA G L IY OW N IY",SYLLABIC="S AH L AE B IH K",NEGLECT="N AH G L EH K T",["IGOR(2)"]="IY G AO R",LEFTISM="L EH F T IH Z AH M",RECONFIGURATION="R IY K AH N F IH G Y ER EY SH AH N",SKYSCRAPER="S K AY S K R EY P ER",DISTINGUISHES="D IH S T IH NG G W IH SH IH Z",["MONUMENTALLY(2)"]="M AA N Y UW M EH N T AH L IY",SALTMARSH="S AO L T M AA R SH",DELBARCO="D EH L B AA R K OW",SVERIGE="S V EH R IH JH",["CONVENT(2)"]="K AA N V EH N T",["LUIGI'S"]="L UW IY JH IY Z",HIGHFIELD="HH AY F IY L D",HEMMERT="HH EH M ER T",FEHLING="F EH L IH NG",CONSOLIDATOR="K AH N S AA L IH D EY T ER",BEHLING="B EH L IH NG",RELAPSED="R IY L AE P S T",PERPLEXED="P ER P L EH K S T",FREEPORT="F R IY P AO R T",ELYSIA="IH L IH ZH IY AH",SOUTHERLAND="S AH DH ER L AH N D",UEHLING="UH L IH NG",WEHLING="W EH L IH NG",REHLING="R EH L IH NG",MEHLING="M EH L IH NG",ONSLOW="AA N S L OW",GLASOW="G L EY Z OW",POGGIOLI="P OW JH OW L IY",NASOPHARYNX="N AH S AA F ER IH NG K S",LYMPHOBLASTIC="L IH M F AH B L AE S T AH K",["UNIDEN'S"]="Y UW N IH D EH N Z",DUBEAU="D AH B OW",DIABASE="D AY AH B EY S",BAILIN="B EY L IH N",GREENHALGH="G R IY N HH AH L G",BRUCKMAN="B R AH K M AH N",DARDAR="D AA R D AA R",["ATTILA'S"]="AH T IH L AH Z",OTTING="AA T IH NG",DELUCA="D IH L UW K AH",MCQUINN="M AH K W IH N",NATICK="N EY T IH K",SHUTTLESWORTH="SH AH T AH L Z W ER TH",CARRICO="K AA R IY K OW",["EISENHOWER'S"]="AY Z AH N HH AW ER Z",HEADWIND="HH EH D W IH N D",MCCOMMONS="M AH K AA M AH N Z",ULIBARRI="UW L IY B AA R IY",ANREDER="AE N R EH D ER",OSTING="AA S T IH NG",BLOXOM="B L AA K S AH M",["CLARITY(2)"]="K L EH R IH T IY",BRASOW="B R AE S OW",HANGOVERS="HH AE NG OW V ER Z",BROADUS="B R OW D AH S",GOLDSTAR="G OW L D S T AA R",LAMMERT="L AE M ER T",KUJAWSKI="K AH Y AA F S K IY",CHARLS="CH AA R L Z",ABRAMOWICZ="AH B R AA M AH V IH CH",STANARD="S T AE N ER D",HOMOGENEOUS="HH OW M AH JH IY N IY AH S",NOISILY="N OY Z AH L IY",WINTERSTEIN="W IH N T ER S T AY N",TYCE="T AY S",["HERBALIST(2)"]="HH ER B AH L AH S T",["CHARLIE'S"]="CH AA R L IY Z",TESTICLES="T EH S T IH K AH L Z",OUTING="AW T IH NG",QUATTROCHI="K W AA T R OW K IY",MUTING="M Y UW T IH NG",BIBEAU="B IH B OW",MYCOGEN="M AY K OW G AH N",GIBEAU="ZH IH B OW",CRISSCROSSING="K R IH S K R AO S IH NG",["ELIZABETH(2)"]="IH L IH Z AH B IH TH",DETERMINING="D IH T ER M AH N IH NG",BICE="B AY S",EPTING="EH P T IH NG",CRUTCHLEY="K R AH CH L IY",WINDISH="W IH N D IH SH",["RESULTED(2)"]="R IY Z AH L T AH D",LIBELOUS="L AY B AH L AH S",["FEDERALIZING(2)"]="F EH D R AH L AY Z IH NG",PASTICHE="P AE S T IY SH",GOTTHELF="G AA T HH EH L F",["MBEKI(3)"]="EH M B EH K IY",RATIOS="R EY SH IY OW Z",CELLIO="CH EH L IY OW",TECHNICALLY="T EH K N IH K AH L IY",PLEBISCITE="P L EH B AH S AY T",MUSTARD="M AH S T ER D",PATIOS="P AE T IY OW Z",YAMS="Y AE M Z",DOTING="D OW T IH NG",PEARLS="P ER L Z",EPILOGUE="EH P AH L AO G",NOTING="N OW T IH NG",ZEMAITIS="Z EH M AY T AH S",FRAHER="F R AA ER",FOULKE="F AW L K",STUCKMAN="S T AH K M AH N",VOTING="V OW T IH NG",["BUDAPEST'S"]="B UW D AH P EH S T S",ANGLING="AE NG G L IH NG",ZUERCHER="Z UH R K ER",["CURTIS'"]="K ER T IH S",CEARLEY="S ER L IY",ROCKHOLT="R AA K HH OW L T",SPLURGING="S P L ER JH IH NG",KEARLEY="K ER L IY",FANTASIA="F AE N T EY ZH AH",GRAVEYARDS="G R EY V Y AA R D Z",GEMS="JH EH M Z",HEMS="HH EH M Z",BUSTARD="B AH S T ER D",KIRKPATRICK="K ER K P AE T R IH K",LATHE="L EY DH",NATHE="N EY DH",FOOLISHNESS="F UW L IH SH N AH S",BATHE="B EY DH",["SOMEBODY'S"]="S AH M B AA D IY Z",DRUCKMAN="D R AH K M AH N",IMMUNIZE="IH M Y UW N AY Z",BULLHEADS="B UH L HH EH D Z",SUBSERVIENT="S AH B S ER V IY AH N T",ANTOON="AE N T UW N",GOODRICK="G UH D R IH K",RASPY="R AE S P IY",CASEIN="K EY S IY N",MASAYUKI="M AA S AA Y UW K IY",MICKELS="M IH K AH L Z",NICKELS="N IH K AH L Z",RICKELS="R IH K AH L Z",ELTING="EH L T IH NG",CRISPNESS="K R IH S P N AH S",CECE="S IY S",SUCCESSOR="S AH K S EH S ER",["TUSSAUD'S(2)"]="T AH S OW Z",FRALIX="F R AE L IH K S",KALLIO="K AE L IY OW",SZWED="SH V EH D",DISSEMINATION="D IH S EH M AH N EY SH AH N",BENGALS="B EH NG G AH L Z",ENFORCE="EH N F AO R S",["BEERS'S"]="B IH R Z IH Z",NICKNAMES="N IH K N EY M Z",FOLKWAY="F OW K W EY",CORNELIUS="K AO R N IY L Y AH S",SHTICK="SH T IH K",AERIENS="EH R IY AH N Z",["SCRIPP'S"]="S K R IH P S",["FIJI'S"]="F IY JH IY Z",DAMS="D AE M Z",STRASBURG="S T R AE S B ER G",HAMS="HH AE M Z",IAMS="IY AA M Z",JAMS="JH AE M Z",DRYCLEANING="D R AY K L IY N IH NG",MAGLIONE="M AA G L IY OW N IY",ASELMA="AH S EH L M AH",DILORENZO="D IH L AO R EH N Z OW",BLAKEMAN="B L EY K M AH N",ATTEMPTING="AH T EH M P T IH NG",DISMAYS="D IH S M EY Z",AVENUE="AE V AH N UW",DUPONT="D UW P AA N T",BABYHOOD="B EY B IY HH UH D",SOLANO="S OW L AA N OW",MOLANO="M OW L AA N OW",MUNCEE="M AH N S IY",MISFORTUNE="M IH S F AO R CH AH N",MISALLOCATES="M IH S AE L AH K EY T S",MODEM="M OW D AH M",DILS="D IH L Z",ROSELAWN="R OW Z L AO N",SHRED="SH R EH D",UNDULY="AH N D UW L IY",GRAWE="G R AO",["RESPONDED(2)"]="R IY S P AA N D AH D",INCE="IH N S",MILS="M IH L Z",OILS="OY L Z",SHINKO="SH IH NG K OW",["PROSTHESIS(2)"]="P R AO S TH IY S AH S",INEQUALITY="IH N IH K W AA L AH T IY",MIECZKOWSKI="M IY CH K AO F S K IY",EXTENSIVE="IH K S T EH N S IH V",CAPON="K EY P AA N",HORNADAY="HH AO R N AH D EY",NOCE="N OW S",NECROSIS="N AH K R OW S AH S",CAFFEINE="K AE F IY N",PAPON="P AE P AO N",OLDSMAR="OW L D Z M AA R",DRUBBED="D R AH B D",LEDESMA="L EH D EH S M AH",MUAVENET="M UW AH V EH N IH T",PROVIDER="P R AH V AY D ER",GLORIFIES="G L AO R AH F AY Z",WIRED="W AY ER D",LEDEZMA="L EY D EY Z M AH",JARNIGAN="JH AA R N IH G AE N",CRAFTING="K R AE F T IH NG",ERXLEBEN="ER K S L EH B AH N",RADIALLY="R EY D IY AH L IY",GRAFTING="G R AE F T IH NG",SCHERTZ="SH ER T S",["ARMBRUSTER(2)"]="AA R M B R UW S T ER",["ADDRESS(2)"]="AH D R EH S",AIRED="EH R D",BOATLOADS="B OW T L OW D Z",MISOGYNE="M IH Z AH JH IH N",SCHRANZ="SH R AE N S",["REDRESS(2)"]="R IY D R EH S",MIRED="M AY R D",MACIAG="M AH K EY G",HIRED="HH AY ER D",FIRED="F AY ER D",GELS="JH EH L Z",FELS="F EH L Z",CACKLE="K AE K AH L",HACKLE="HH AE K AH L",CELS="S EH L Z",BELS="B EH L Z",EELS="IY L Z",SEMINARS="S EH M AH N AA R Z",NELS="N EH L Z",PELS="P EH L Z",FINAGLER="F AH N EY G L ER",TELEMATICS="T EH L AH M AE T IH K S",MOBAY="M OW B EY",HOLTHUS="HH OW L TH AH S",HORNOR="HH AO R N ER",ELITISM="EH L IH T IH Z AH M",GREEDILY="G R IY D AH L IY",LUCODENDRUM="L UW K OW D EH N D R AH M",TACKLE="T AE K AH L",QUEENSLAND="K W IY N Z L AE N D",COLELLO="K OW L EH L OW",MISLABELING="M IH S L EY B AH L IH NG",EXCORIATE="EH K S K AO R IY EY T",HASELTINE="HH AE S IH L T IY N",LINGNER="L IH NG N ER",RASCAL="R AE S K AH L",KAMPA="K AE M P AH",MANDALAY="M AE N D AH L EY",SZYMANOWSKI="SH IH M AH N AO F S K IY",CAMPA="K AE M P AH",ARMTEC="AA R M T EH K",PASCAL="P AE S K AE L",AKINS="AH K IH N Z",WRESTLING="R EH S L IH NG",KERNIGAN="K ER N AH G AH N",FAULHABER="F AW L HH AH B ER",EKINS="EH K IH N Z",GUSTAVESON="G UW S T AA V EY S AH N",CURRO="K UH R OW",BURRO="B ER OW",IMPEDIMENTS="IH M P EH D AH M AH N T S",WICE="W AY S",SKINS="S K IH N Z",DALZIEL="D AE L Z IY L",VICE="V AY S",KUBITZ="K Y UW B IH T S",LUBITZ="L UW B IH T S",LURED="L UH R D",HICE="HH AY S",SWINGLE="S W IH NG G AH L",UHLS="UW L Z",DICE="D AY S",STUBBED="S T AH B D",DELARIVA="D EH L AA R IY V AH",["C-CODE"]="S IY K OW D",LICE="L AY S",MICE="M AY S",NICE="N AY S",CONGRATULATING="K AH N G R AE CH AH L EY T IH NG",BRACKNEY="B R AE K N IY",RAGAVAN="R AA G AH V AA N",JERRICO="JH EH R IH K OW",FYFFE="F AY F",LARYNGOSCOPE="L AA R IH N G AH S K OW P",["INAUGURATE(2)"]="IH N AO G Y ER EY T",BURKITT="B ER K IH T",DERRICO="D IH R IY K OW",PLAUSIBLY="P L AO Z AH B L IY",TADDEI="T AE D AY",EVAPORATE="IH V AE P ER EY T",NIPON="N IH P AA N",CHRISTOPHERSEN="K R IH S T AA F ER S AH N",ACADEMIA="AE K AH D IY M IY AH",SALVADOR="S AE L V AH D AO R",WHOOPING="W UW P IH NG",SNUBBED="S N AH B D",BADURA="B AA D UH R AH",["HEMOPHILIAC(2)"]="HH IY M OW F IH L IY AE K",DEVIANTS="D IY V IY AH N T S",KEMPA="K EH M P AH",ZARED="Z EH R D",SLUPIC="S L UW P IH K",["TOURS(2)"]="T AO R Z",["SOURS(2)"]="S AW R Z",ACTIVES="AE K T IH V Z",["MAJORS'"]="M EY JH ER Z",["CAMPS'"]="K AE M P S",["CADRONE(2)"]="K AH D R OW N IY",THIBEAULT="T IY B OW",UNCOUTH="AH N K UW TH",ASHWORTH="AE SH W ER TH",INVALIDATING="IH N V AE L AH D EY T IH NG",EARED="IH R D",FARED="F EH R D",CARED="K EH R D",DARED="D EH R D",HERREID="HH EH R AY D",BARED="B EH R D",["RAZORBACK'S"]="R EY Z ER B AE K S",SONODA="S OW N OW D AH",JARED="JH EH R IH D",GARED="G AE R AH D",BRICKLER="B R IH K L ER",TANAKA="T AA N AA K AH",OARED="AO R D",PARED="P EH R D",ENTWINE="EH N T W AY N",ALRED="AO L R IH D",KALNINS="K AE L N IH N Z",BICKLE="B IH K AH L",ANTWINE="AE N T W AY N",FICKLE="F IH K AH L",CLUBBED="K L AH B D",HICKLE="HH IH K AH L",EAVENSON="IY V IH N S AH N",BAZOOKAS="B AH Z UW K AH Z",SAVOIE="S AA V W AA",ARCE="AA R S",LAVOIE="L AH V W AA",DEGUERIN="D IH G ER IH N",PENTAMIDINE="P EH N T AE M IH D IY N",LEIBOVITZ="L IY B AH V IH T S",PRIORITIZED="P R AY AO R AH T AY Z D",MICKLE="M IH K AH L",SICKLE="S IH K AH L",PICKLE="P IH K AH L",NARROWNESS="N EH R OW N AH S",TICKLE="T IH K AH L",BAVADRA="B AH V AE D R AH",IACOCCA="AY AH K OW K AH",BACHER="B AA K ER",KAERCHER="K EH R K ER",BRINGLE="B R IH NG G AH L",SUDDENNESS="S AH D AH N N AH S",FOWL="F AW L",STARGATES="S T AA R G EY T S",ACCORDS="AH K AO R D Z",BOWL="B OW L",ALSBROOK="AE L Z B R UH K",FISCAL="F IH S K AH L",JOWL="JH AW L",HOWL="HH AW L",MATERIALLY="M AH T IH R IY AH L IY",RECORDS="R AH K AO R D Z",SIMMERT="S IH M ER T",DUCTS="D AH K T S",BASTARD="B AE S T ER D",CLEARANCES="K L IH R AH N S IH Z",MACHER="M AE K ER",LACHER="L AE K ER",SACHER="S AE K ER",DUBAY="D AH B EY",COMPLICATING="K AA M P L AH K EY T IH NG",ZACHER="Z AE K ER",MONORAILS="M AA N ER EY L Z",HUMENIK="HH Y UW M IH N IH K",KIVETT="K IH V IH T",WAIFER="W EY F ER",LEASED="L IY S T",JABBOUR="ZH AH B UH R",TEASED="T IY Z D",WILLMOTT="W IH L M AH T",SPIRITUALISM="S P IH R IH CH AH W AH L IH Z M",PONCET="P AA N S AH T",FRANCAISES="F R AA N S EH Z",["REJECTED(2)"]="R IY JH EH K T AH D",["NATIONALIZING(2)"]="N AE SH N AH L AY Z IH NG",WALLABY="W AA L AH B IY",CARTOONING="K AA R T UW N IH NG",["GRANDCHILDREN(2)"]="G R AE N D CH IH L D R AH N",PLAYMATE="P L EY M EY T",MUIRHEAD="M Y UH R HH EH D",BARNABY="B AA R N AH B IY",["GAZONSKY'S"]="G AH Z AA N S K IY Z",CROITZER="K R OY T S ER",GYNECOLOGIC="G AY N AH K AH L AA JH IH K",RUNYAN="R AH N Y AH N",MUNYAN="M AH N Y AH N",HERETICAL="HH ER EH T IH K AH L",OSSETIANS="AA S EH SH Y IH N Z",["NEIGHBORHOOD'S"]="N EY B ER HH UH D Z",HEGADORN="HH EH G AH D AO R N",PHILATELY="F IH L AE T AH L IY",RULED="R UW L D",BUNYAN="B AH N Y AH N",STEMS="S T EH M Z",["RUN-DOWN"]="R AH N D AW N",CEASED="S IY S T",KLUGMAN="K L AH G M AH N",[".DECIMAL"]="D EH S AH M AH L",FENDRICK="F EH N D R IH K",HENDRICK="HH EH N D R IH K",KENDRICK="K EH N D R IH K",ANTIPATHY="AE N T IH P AH TH IY",KALINOWSKI="K AH L IH N AO F S K IY",MALINOWSKI="M AH L IH N AO F S K IY",RIVETT="R IH V IH T",SHUMATE="SH UW M EY T",INTERNACIONAL="IH N T ER N AE SH AH N AH L",NINOS="N IY N OW Z",WINOS="W IY N OW S",["THREADED(2)"]="TH R EH D IH D",ENTITIES="EH N T IH T IY Z",CATEGORIZES="K AE T AH G ER AY Z IH Z",DAYCARE="D EY K EH R",["JAVELIN(2)"]="JH AE V AH L IH N",HOLED="HH OW L D",DOLED="D OW L D",HAZEL="HH EY Z AH L",MAZEL="M AH Z AH L",BALESTRIERI="B AA L EH S T R IH R IY",["RECORDED(2)"]="R IH K AO R D IH D",FANS="F AE N Z",SCHIFERON="SH IH F ER AO N",CANS="K AE N Z",BANS="B AE N Z",HIBACHI="HH AH B AA CH IY",DEMONSTRATING="D EH M AH N S T R EY T IH NG",MANS="M AE N Z",KEIFER="K IY F ER",LEIFER="L AY F ER",JANS="JH AE N Z",HANS="HH AA N S",HEIFER="HH AY F ER",PREPAYMENT="P R IY P EY M AH N T",CHERBOURG="SH EH R B UW R G",INTERCONNECTION="IH N T ER K AH N EH K SH AH N",QUINTESSENTIALLY="K W IH N T AH S EH N CH AH L IY",MACIVER="M IY K IH V ER",HASCHKE="HH AE SH K",CYTHEREA="S IH TH ER IY AH",MOKHIBER="M AA K HH IH B ER",ASHE="AE SH",MASCHKE="M AE SH K",["INFORMATIC(2)"]="IH N F AO R M AE T IH K",PASCHKE="P AE SH K",FORFEIT="F AO R F IH T",AGNOS="AE G N OW S",["O'CARROLL"]="OW K AE R AH L",["HOOFS(2)"]="HH UW F S",MEDIGAP="M EH D IH G AE P",GAULTNEY="G AO L T N IY",HUMORISTS="HH Y UW M ER IH S T S",MISREPRESENT="M IH S R EH P R AH Z EH N T",MCCALLON="M AH K AE L AH N",GRIPING="G R AY P IH NG",JAVETT="JH AE V AH T",["INJECTED(2)"]="IH N JH EH K T IH D",XENOS="Z IY N OW Z",CONDUCTIVE="K AH N D AH K T IH V",LENOS="L IY N OW Z",AGHAZADEH="AE G AH Z AA D EH",RECOIL="R IY K OY L",ELIGIBILITY="EH L IH JH AH B IH L IH T IY",DEISM="D IY IH Z AH M",UTHE="AH DH",PHYLLIS="F IH L IH S",["CONFIDENTIALITY(2)"]="K AA N F AH D EH N CH IY AE L AH T IY",AVOCET="AE V AH S EH T",["FALKENSTEIN(2)"]="F AO K AH N S T IY N",RUHE="R UW HH",["MASSENET'S"]="M AE S AH N EH T S",HESELTINE="HH EH S AH L T IY N",DIFFRACTION="D IH F R AE K SH AH N",CHARGERS="CH AA R JH ER Z",["TECHNICALLY(2)"]="T EH K N IH K L IY",STAGNER="S T AE G N ER",CIOLEK="CH IY OW L EH K",["ALIQUIPPA'S"]="AE L AH K W IH P AH Z",HILLESTAD="HH IH L IH S T AH D",DOWNTRODDEN="D AW N T R AA D AH N",STIENS="S T IY N Z",["HERBALIST'S"]="ER B AH L AH S T S",["SEOW'S"]="S IY OW Z",KLAPPERICH="K L AE P ER IH K",["HULOND'S"]="HH Y UW L AH N D Z",EXOCET="EH K S OW S EH T",COUNTERTOPS="K AW N T ER T AA P S",BREMS="B R EH M Z",BORRUSO="B AO R UW S OW",DIGIACOMO="D IY JH AH K OW M OW",WATTENBURG="W AA T AH N B ER G",BLINDFOLD="B L AY N D F OW L D",POPULARIZING="P AA P Y AH L ER AY Z IH NG",INTIMIDATED="IH N T IH M IH D EY T IH D",DOWLEN="D AW L AH N",CANCRO="K AA N K R OW",["BETTMAN'S"]="B EH T M AH N Z",MANOS="M EY N OW Z",NANOS="N AA N OW Z",JANOS="JH AE N OW S",LEVERONE="L EH V ER OW N IY",DESILVA="D IH S IY L V AH",LAGATTUTA="L AA G AA T UW T AH",BANOS="B AA N OW Z",SNIPING="S N AY P IH NG",BOWLEN="B OW L AH N",ENVISIONS="EH N V IH ZH AH N Z",MACROECONOMIC="M AE K R OW EH K AH N AA M IH K",CARTESIAN="K AA R T IY ZH AH N",KOLLEK="K AO L EH K",["STADIUM'S"]="S T EY D IY AH M Z",CALCULATING="K AE L K Y AH L EY T IH NG",ITEMS="AY T AH M Z",GARRULOUS="G EH R AH L AH S",LIBERALIZED="L IH B ER AH L AY Z D",DEMARK="D AH M AA R K",DISPROVE="D IH S P R UW V",NEUTRAL="N UW T R AH L",CONJOINED="K AA N JH OY N D",MCCONAHA="M AH K AA N AH HH AA",ATRIUM="EY T R IY AH M",ESTENSON="EH S T IH N S AH N",ROSEMEYER="R OW Z M AY ER",["FALSTAFF'S"]="F AO L S T AE F S",HAGADORN="HH AE G AH D AO R N",["ANDREANA(2)"]="AE N D R IY AA N AH",STEREOTYPING="S T EH R IY AH T AY P IH NG",PUPS="P AH P S",["MARCESSA'S"]="M AA R S EH S AH Z",DEGIACOMO="D IY JH AH K OW M OW",IGUANA="AY G W AA N AH",BUNDLES="B AH N D AH L Z",OSTENSON="AA S T IH N S AH N",CHISM="CH IH Z AH M",KINDRICK="K IH N D R IH K",DEUTSCHER="D OY CH ER",BAIE="B AY IY",["BRANDON'S"]="B R AE N D AH N Z",FURLOW="F ER L OW",STRIVES="S T R AY V Z",EPPS="EH P S",SUNSERI="S AH N S EH R IY",NATIVES="N EY T IH V Z",DISARMINGLY="D IH S AA R M IH NG L IY",BLADDERS="B L AE D ER Z",HIEMS="HH IY M Z",DASILVA="D AH S IH L V AH",MODULATE="M AO JH Y UW L EY T",FREEHLING="F R IY L IH NG",OVERGAARD="OW V ER G AA R D",RETROCESSIONARY="R EH T R OW S EH SH AH N EH R IY",["JUDAISM'S"]="JH UW D EY IH Z AH M Z",APPS="AE P S",RETEMEYER="R EH T AH M AY R",["ROBITUSSIN(2)"]="R OW B AH T AH S IH N",YNJIUN="IH N JH UH N",DORAVILLE="D AO R AH V IH L",PETRU="P EH T R UW",MIGLIN="M IH G L IH N",MOPS="M AA P S",OOPS="UW P S",POPS="P AA P S",LIONHEART="L AY AH N HH AA R T",ROPS="R AA P S",SIEMS="S IY M Z",NEWSCAST="N UW Z K AE S T",BARBERA="B AA R B EH R AH",BIGLIN="B IH G L IH N",HYPOTHALAMIC="HH AY P OW TH AH L AE M IH K",WESTFED="W EH S T F EH D",UNDULATE="AH N JH AH L EY T",["MARS'"]="M AA R Z",GLUCKMAN="G L AH K M AH N",COPS="K AA P S",ERPS="ER P S",ERASED="IH R EY S T",APPLING="AE P AH L IH NG",REMARK="R IH M AA R K",["ILLINOIS'S"]="IH L IH N OY Z",MESCHKE="M EH SH K",OTOLOGIES="OW T AA L AH JH IY Z",TRIPOD="T R AY P AA D",JESCHKE="JH EH SH K",AGUIAR="AA G W IY ER",GESCHKE="G EH SH K",["'COURSE"]="K AO R S",KONISHI="K OW N IY SH IY",MASONER="M EY S AH N ER",KOZEL="K OW Z AH L",["MCCAIN'S"]="M AH K EY N Z",HACKSTAFF="HH AE K S T AE F",["FINKELSTEIN'S(2)"]="F IH NG K AH L S T AY N Z",LIGAMENTS="L IH G AH M AH N T S",HOFFENBERG="HH AO F AH N B ER G",EQUIP="IH K W IH P",MCCLARY="M AH K L EH R IY",BURNETT="B ER N EH T",["IMPRESSIONIST(2)"]="IH M P R EH SH AH N IH S T",EASED="IY Z D",BALLERINAS="B AE L ER IY N AH Z",BASED="B EY S T",PRESSEL="P R EH S AH L",["JOACHIM'S"]="Y OW AA K IH M Z",BROKERAGE="B R OW K ER IH JH",MOISTURIZER="M OY S CH ER AY Z ER",MCSWEENEY="M AH K S W IY N IY",GERSHWIN="G ER SH W IH N",BEAUCHAINE="B OW SH EY N",ALAMITOS="AE L AH M IY T OW S",MESELSON="M EH Z AH L S AH N",HOMEMADE="HH OW M M EY D",SCHWINGER="SH W IH NG ER",["AVERAGED(2)"]="AE V R IH JH D",ALPS="AE L P S",DOUGALL="D AW G AH L",BEDNARSKI="B EH D N AA R S K IY",PEPPERED="P EH P ER D",KEIRSEY="K IH R S IY",CANTEEN="K AE N T IY N",LINDSAY="L IH N D Z IY",MACIEJEWSKI="M AH CH EH F S K IY",HEROICALLY="HH IH R OW IH K L IY",PROSECUTORS="P R AA S IH K Y UW T ER Z",LEWINSOHN="L UW IH N S AH N",BRAXTON="B R AE K S T AH N",AUXILIARY="AA G Z IH L Y ER IY",["GRANDMA'S"]="G R AE N D M AA Z",EXCISION="IH K S IH ZH AH N",FUENTEZ="F W EH N T EY Z",KHALAF="K AE L AH F",DRESSEL="D R EH S AH L",ELEPHANTS="EH L AH F AH N T S",["KHALID(2)"]="HH AA L IH D",STENCILED="S T EH N S IH L D",DELVALLE="D EH L V AE L IY",["CHRISTOFFERSEN(2)"]="K R IH S T AA F ER S AH N",ORZEL="AO R Z AH L",BLACKSBURG="B L AE K S B ER G",ACHE="EY K",["WARS'"]="W AO R Z",ENCEPHALITIS="EH N S EH F AH L AY T AH S",SHORTHAIRED="SH AO R T HH EH R D",HAUSFELD="HH AW S F EH L D",WHITMIRE="W IH T M AY R",WARNINGS="W AO R N IH NG Z",["RAINLEY'S"]="R EY N L IY Z",GUGLIOTTA="G UW G L IY OW T AH",STANWOOD="S T AE N W UH D",COLLARBONE="K AA L ER B OW N",SUFFER="S AH F ER",RUFFER="R AH F ER",TOMCZYK="T AA M CH IH K",PUFFER="P AH F ER",NUFFER="N AH F ER",SCHUELLER="SH UW L ER",POEMS="P OW AH M Z",HUFFER="HH AH F ER",SWIPING="S W AY P IH NG",DEPORTEES="D IY P AO R T IY Z",FLEXED="F L EH K S T",BUFFER="B AH F ER",COLLABORATIONS="K AA L AH B ER EY SH AH N Z",MALLEK="M AE L IH K",MUSED="M Y UW Z D",MUNOS="M UW N OW Z",["PALAU'S"]="P AH L AW UW Z",HELDRING="HH EH L D R IH NG",DISBANDING="D IH S B AE N D IH NG",DELLAPENNA="D EH L AH P EH N AH",REPUTATIONS="R EH P Y AH T EY SH AH N Z",PROCEEDINGS="P R OW S IY D IH NG Z",ETZEL="EH T Z AH L",BUSED="B AH S T",PERRAULT="P EH R AO L T",FUSED="F Y UW Z D",BAETEN="B EH T AH N",APOLOGIES="AH P AA L AH JH IY Z",REVIVED="R IH V AY V D",KUZEL="K UW Z AH L",["SUBJECTS(2)"]="S AH B JH EH K T S",JUNGELS="JH AH NG G AH L Z",CONNELLEY="K AA N IH L IY",WEHE="W IY HH",DONNELLEY="D AA N AH L IY",TEGTMEYER="T EH T M AY ER",LAFORCE="L AH F AO R S",["SERVICE'S"]="S ER V IH S IH Z",YUSTEF="Y UW S T EH F",REVERSALS="R IH V ER S AH L Z",["RESTRAINT(2)"]="R IY S T R EY N T",UNFORGIVING="AH N F ER G IH V IH NG",ANGLIN="AE NG G L IH N",MITYUNOV="M IH T Y UW N AA V",URCHINS="ER CH AH N Z",["CROW'S"]="K R OW Z",RIVALING="R AY V AH L IH NG",ASSED="AE S T",SALOMON="S AE L AH M AH N",KOGLIN="K AA G L IH N",IMPARTIALITY="IH M P AA R SH IY AE L IH T IY",DETERMINISTIC="D IH T ER M AH N IH S T IH K",ROHE="R OW",BARIUM="B EH R IY AH M",MIKRUT="M IH K R AH T",MORTGAGING="M AO R G IH JH IH NG",YOHE="Y OW HH EY",DIFFER="D IH F ER",FILIPINO="F IH L AH P IY N OW",DOWNPLAYS="D AW N P L EY Z",CHASED="CH EY S T",CRUISER="K R UW Z ER",DEEMS="D IY M Z",WISED="W AY Z D",QUARRELSOME="K W AO R AH L S AH M",["THEM(2)"]="DH AH M",UNSENTIMENTAL="AH N S EH N T IH M EH N T AH L",SEEMS="S IY M Z",TEEMS="T IY M Z",PASQUALE="P AA S K W AA L EY",["SADAT'S(2)"]="S AH D AE T S",STABILIZER="S T EY B AH L AY Z ER",CLICHES="K L IY SH EY Z",WEEMS="W IY M Z",LANGDALE="L AE NG D EY L",NATIONALIZE="N AE SH AH N AH L AY Z",PANMUNJOM="P AE N M UW N JH AO M",SPRATLEY="S P R AE T L IY",RATIONALIZE="R AE SH AH N AH L AY Z",HOFFER="HH AA F ER",COFFER="K AO F ER",ANCHORS="AE NG K ER Z",["ROCARD(3)"]="R OW SH AA R D",LEWANDA="L AH W AA N D AH",MISCHKE="M IH SH K",PISCHKE="P IH SH K",NONVOTING="N AA N V OW T IH NG",DISGORGEMENT="D IH S G AO R JH M AH N T",TRIANGLE="T R AY AE NG G AH L",ESMARK="EH S M AA R K",BIASED="B AY AH S T",MUNCHAUSEN="M AH N CH AW Z IH N",DOWNLOADS="D AW N L OW D Z",SAMANO="S AA M AA N OW",SCHWIESOW="SH W IY S OW",CONVIVIAL="K AH N V IH V IY AH L",BUILDUPS="B IH L D AH P S",KHOMEINI="K OW M EY N IY",DETACHABLE="D IH T AE CH AH B AH L",FEEDBACK="F IY D B AE K",CRIED="K R AY D",CAPTURE="K AE P CH ER",FRIED="F R AY D",CANDLES="K AE N D AH L Z",SCHOONMAKER="SH UW N M EY K ER",HANDLES="HH AE N D AH L Z",RAPTURE="R AE P CH ER",AMIE="AE M IY",WOJCICKI="W OY CH IH T S K IY",MONARCHS="M AA N AA R K S",WAWRZYNIAK="W AA R Z IH N IY AE K",JEFFERIES="JH EH F R IY Z",PREROGATIVE="P R IH R AA G AH T IH V",SUITS="S UW T S",INVOICE="IH N V OY S",TRIGGERED="T R IH G ER D",APOSTLES="AH P AA S AH L Z",TRIED="T R AY D",QUITS="K W IH T S",PERRICONE="P ER R IY K OW N IY",RANDLES="R AE N D AH L Z",IVIE="AY V IY",EXTRAVAGANTLY="EH K S T R AE V AH G AH N T L IY",HERETOFORE="HH IH R T 