# Asphalt Roads 1.1.1
---
## Introduction

*Have you ever looked at your factory and thought: "I dunno, but what this planet is seriously missing is a decent four-lane highway network."
Then worry not: This mod was made to help fulfilling your infrastructure dreams.*


**Asphalt Roads**

"Asphalt Roads" adds a new tile set with a smooth, black road surface to your games, including tiles for hazard marking and lane marking. Enjoy the reduced vehicle friction modifier and accelerate up to 200 km/h with your car (using rocket fuel). 

- Mark separate lanes on your roads with single or double lines
- Mark hazard areas in various colours e.g. near railway crossings or gates 
- Set up pedestrian crossings with zebra crossing or "shark teeth" tiles

For a quick live demonstration (though a bit dated, but nevertheless very well explained): [Asphalt Roads mod spotlight by Xterminator](https://www.youtube.com/watch?v=s5w6K9xEaRo)


## Details

### Items

![Imgur](http://i.imgur.com/WYTCwKI.png)

- **Asphalt** is the base tile. 

- **Asphalt with lane marking** consists of two items for white and yellow lane marking in 45, 90, 135 and 180 degree angles and two items for tiles that divert lines by 45 degree to the left or the right. 

- **Asphalt with zebra crossing marking** are two tiles with thick white lines

- **Asphalt with white triangle** are four tiles with "shark teeth"

- **Asphalt with hazard marking** are five separate items for white, yellow, red, blue and green hazard marking. 

![Imgur](http://i.imgur.com/36NTyPO.png)

- **Double line tiles** are another variation of lane marking tiles

### Technology
Basic technology is called **Asphalt** and needs concrete as a prerequisite.

### Mod recommendation and support 

Recommended mods that work well in addition to this one:

- [Pavement Drive Assist](https://mods.factorio.com/mods/Arcitos/PavementDriveAssist): Allows player driven vehicles to detect lane marking and follow your roads
 
- [Concrete Signpost](https://mods.factorio.com/mods/Klonan/Concrete_Lamppost) (by Klonan) adds sign posts that look really nice in addition to asphalt roads

- [Dectorio](https://mods.factorio.com/mods/PantherX/Dectorio) (by PantherX): This mod adds pretty traffic bollards (and a bunch of other neat stuff)

Supported mods

- [Bio Industries](https://mods.factorio.com/mods/TheSAguy/Bio_Industries): If present, crushed stone will be used as an ingredient for asphalt. This can be disabled in mod settings tab.

### Effects on gameplay

This mod is mostly non-game-changing, apart from the reduced vehicle friction of asphalt. But this is compensated by the significant amount of crude and heavy oil needed for the production of asphalt. For more fun, i recommend the heavy use of blueprints!

### Current language support

- EN (English)
- DE (German)

If you like this mod and you've created a translation of your own, please do not hesitate to send me this, so that it can be made accessible to all in the next version. Same, if you spot spelling mistakes. Thanks in advance!

---

### Changelog
1.1.1 (2017-12-20)

- updated for Factorio 0.16.x
- added a setting for reduced research cost (thanks for your code snippet,  bitbased!)
- changed the render layer of asphalt to 58 and 59 (diagonal lane marking tiles) (stone = 60; concrete = 61)

1.1.0 (2017-08-25)

- added white and yellow double line tiles
- added green hazard marking tiles
- added white triangle tiles ("Shark teeth")
- reduced line thickness of marking tiles
- changed yellow colour to a more orange tone
- changed brightness of white colour
- complete overhaul of all icons to better match factorios 0.15 tile icon style (inspired by the look of the new vanilla concrete icon)
- fixed asphalt recipe still using single digit fluid amounts
- cleaned-up prototype definition

1.0.5 (2017-05-12)

- Fixed a multiplayer issue caused by an MP-unsave event handler. 

1.0.4 (2017-04-30)

- updated for Factorio 0.15.x
- added crafting manchine tint for asphalt crafting
- added new config option for layer priority


1.0.3 (2017-04-15)

- balancing: changed default walking speed modificator to 140% to match that of concrete
- added config file for parameter customization
- added recipe substitution: If BioIndustries is present, crushed stone will be used in asphalt recipe instead of stone bricks
- adjusted (darkened) map colours to make roads more visible in areas of low contrast

1.0.2 (2017-02-10)

- added corner tiles for white and yellow lane marking
- increased brightness of all icons
- usability: all marking and hazard tiles are now set to go to quickbar

 
1.0.1 (2016-12-31)

- minor bugfix: added unique localised string identifiers to avoid problems with other mods
- balancing: reduced amount of bricks needed for asphalt by 20%
- improved map colours
- added correct picture for tile overview


 1.0.0 (2016-12-23) 	

- initial release 


